---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local minimapIconLocales = {
    ["Toggle Menu"] = {
        ["ptBR"] = "Mostrar Menu",
        ["ruRU"] = "Открыть меню",
        ["koKR"] = "메뉴 표시",
        ["esMX"] = "Mostrar menú",
        ["zhCN"] = "切换菜单",
        ["enUS"] = true,
        ["zhTW"] = "顯示/隱藏選單",
        ["deDE"] = "Menü zeigen/verstecken",
        ["esES"] = "Mostrar menú",
        ["frFR"] = "Afficher le menu",
    },
    ["Toggle Questie"] = {
        ["ptBR"] = "Mostrar Questie",
        ["ruRU"] = "Показать/скрыть значки",
        ["deDE"] = "Icons aktivieren/deaktivieren",
        ["koKR"] = "Questie 표시",
        ["esMX"] = "Mostrar Questie",
        ["enUS"] = true,
        ["zhCN"] = "切换Questie",
        ["zhTW"] = "顯示/隱藏任務位置提示",
        ["esES"] = "Mostrar Questie",
        ["frFR"] = "Afficher/cacher Questie",
    },
    ["Toggle My Journey"] = {
        ["ptBR"] = "Mostrar minha viagem",
        ["ruRU"] = "Открыть 'Путешествие'",
        ["deDE"] = "Meine Reise zeigen/verstecken",
        ["koKR"] = "나의 여정 창 열기",
        ["esMX"] = "Mostrar mi viaje",
        ["enUS"] = true,
        ["zhCN"] = "打开我的日志",
        ["zhTW"] = "顯示/隱藏我的冒險日記",
        ["esES"] = "Mostrar mi viaje",
        ["frFR"] = "Mon voyage",
    },
    ["Hide Minimap Button"] = {
        ["ptBR"] = "Ocultar botão do minimapa",
        ["ruRU"] = "Скрыть кнопку у миникарты",
        ["deDE"] = "Minimap-Button verstecken",
        ["koKR"] = "미니맵 버튼 가리기",
        ["esMX"] = "Ocultar botón del minimapa",
        ["enUS"] = true,
        ["zhCN"] = "隐藏小地图图标",
        ["zhTW"] = "隱藏小地圖按鈕",
        ["esES"] = "Ocultar botón del minimapa",
        ["frFR"] = "Cacher le bouton de la minicarte",
    },
    ["Reload Questie"] = {
        ["ptBR"] = "Carregar Questie",
        ["ruRU"] = "Перезагрузить аддон",
        ["deDE"] = "Questie neu laden",
        ["koKR"] = "Questie 리로드",
        ["esMX"] = "Recargar Questie",
        ["enUS"] = true,
        ["zhCN"] = "重载Questie",
        ["zhTW"] = "重新載入任務位置提示",
        ["esES"] = "Recargar Questie",
        ["frFR"] = "Recharger Questie",
    },
    ["Available Quest"] = {
        ["ptBR"] = "Missões disponiveis",
        ["ruRU"] = "Доступные задания",
        ["deDE"] = "Verfügbare Quests",
        ["koKR"] = "수행 가능한 퀘스트",
        ["esMX"] = "Misión disponible",
        ["enUS"] = true,
        ["zhCN"] = "可用任务",
        ["zhTW"] = "可接的任務",
        ["esES"] = "Misión disponible",
        ["frFR"] = "Quêtes disponibles",
    },
    ["Trivial Quest"] = {
        ["ptBR"] = "Missões triviais",
        ["ruRU"] = "Простые задания",
        ["deDE"] = "Niedrigstufige Quests",
        ["koKR"] = "기타 퀘스트",
        ["esMX"] = "Misión trivial",
        ["enUS"] = true,
        ["zhCN"] = "其他任务",
        ["zhTW"] = "低等級任務",
        ["esES"] = "Misión trivial",
        ["frFR"] = "Quêtes de bas niveau",
    },
    ["Questie will open after combat ends."] = {
        ["ptBR"] = "Questie será aberta após o término do combate.",
        ["ruRU"] = "Questie откроется по завершении боя.",
        ["deDE"] = "Questie öffnet sich nach dem Kampf.",
        ["koKR"] = "전투 종료 후 퀘스티가 열립니다",
        ["esMX"] = "Questie abrirá cuando estés fuera de combate.",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "Questie 會在戰鬥結束後開啟。",
        ["esES"] = "Questie abrirá cuando estés fuera de combate.",
        ["frFR"] = "La quête s'ouvrira après la fin du combat.",
    },
}

for k, v in pairs(minimapIconLocales) do
    l10n.translations[k] = v
end
