---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local iconOptionsLocales = {
    ["Enable Icons"] = {
        ["ptBR"] = "Ativar os ícones",
        ["ruRU"] = "Значки Questie",
        ["deDE"] = "Icons aktivieren",
        ["koKR"] = "아이콘 활성화",
        ["esMX"] = "Habilitar iconos",
        ["enUS"] = true,
        ["zhCN"] = "启用Questie",
        ["zhTW"] = "啟用圖示",
        ["esES"] = "Habilitar iconos",
        ["frFR"] = "Activer les icônes",
    },
    ["Shows or hides the icons that Questie draws on the world map and minimap."] = {
        ["ptBR"] = "Ativar ou desativar os ícones da Questie",
        ["ruRU"] = "Показать/скрыть значки Questie",
        ["deDE"] = "Aktivieren/Deaktivieren der Questie-Icons",
        ["koKR"] = "Questie 아이콘을 활성화합니다.",
        ["esMX"] = "Habilitar iconos de Questie",
        ["enUS"] = true,
        ["zhCN"] = "启用或禁用Questie图标",
        ["zhTW"] = "啟用或停用任務位置提示的圖示。",
        ["esES"] = "Habilitar iconos de Questie",
        ["frFR"] = "Activer les icônes de Questie",
    },
    ["Config Tracking Icons"] = {
        ["ptBR"] = "Configurar ícones de rastreamento",
        ["ruRU"] = "Отслеживаемые значки",
        ["deDE"] = "Tracking Icons konfigurieren",
        ["koKR"] = "추적 아이콘 설정",
        ["esMX"] = "Configurar iconos de seguimiento",
        ["enUS"] = true,
        ["zhCN"] = "显示追踪图标",
        ["zhTW"] = "設定追蹤圖示",
        ["esES"] = "Configurar iconos de seguimiento",
        ["frFR"] = "Configurer les icônes de suivi",
    },
    ["Allows to select which tracking icons (like Mailbox, Repair-NPCs) to show on the map and minimap."] = {
        ["ptBR"] = "Permite selecionar quais ícones de rastreamento (como Caixa de Correio, NPC de conserto) mostrar no mapa e minimapa.",
        ["ruRU"] = "Позволяет выбрать, какие 'городские' значки (почтовый ящик, ремонт и проч.) отображать на карте и миникарте",
        ["deDE"] = "Ermöglicht das Konfigurieren der Tracking Icons (z.B. Briefkästen, Reparatur-NPCs) auf der Karte und Minimap.",
        ["koKR"] = "지도에 표시할 추적 아이콘(예: 우체통, 수리NPC)을 선택할 수 있습니다.",
        ["esMX"] = "Permite seleccionar qué iconos de seguimiento (como Buzón, PNJ de Reparación) se mostrarán en el mapa y el minimapa.",
        ["enUS"] = true,
        ["zhCN"] = "允许在地图和小地图上显示选择追踪图标（例如“邮箱”，“修理”）。",
        ["zhTW"] = "可以選擇哪些追蹤圖示 (例如郵箱、修理商人) 要顯示在地圖和小地圖上。",
        ["esES"] = "Permite seleccionar qué iconos de seguimiento (como Buzón, PNJ de Reparación) se mostrarán en el mapa y el minimapa.",
        ["frFR"] = "Permet de sélectionner les icônes de suivi (comme la boîte aux lettres, les PNJ de réparation) à afficher sur la carte et la minicarte.",
    },
    ["Allows to select which profession trainers to show on the map and minimap."] = {
        ["ptBR"] = "Permite selecionar quais instrutores de profissões mostrar no mapa e minimapa.",
        ["ruRU"] = "Позволяет выбрать, каких учителей профессий отображать на карте и миникарте",
        ["deDE"] = "Ermöglicht das Konfigurieren der Berufe-Lehrer auf der Karte und Minimap.",
        ["koKR"] = false,
        ["esMX"] = "Permite seleccionar qué instructores de profesión mostrar en el mapa y minimapa.",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "可以選擇哪些專業訓練師要顯示在地圖和小地圖上。",
        ["esES"] = "Permite seleccionar qué instructores de profesión mostrar en el mapa y minimapa.",
        ["frFR"] = "Permet de sélectionner les maîtres de profession à afficher sur la carte et la minicarte.",
    },
    ["Allows to select which vendors to show on the map and minimap."] = {
        ["ptBR"] = "Permite selecionar quais comerciantes mostrar no mapa e minimapa.",
        ["ruRU"] = "Позволяет выбрать, каких продавцов отображать на карте и миникарте",
        ["deDE"] = "Ermöglicht das Konfigurieren der Händler auf der Karte und Minimap.",
        ["koKR"] = false,
        ["esMX"] = "Permite seleccionar qué vendedores mostrar en el mapa y minimapa.",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "可以選擇哪些商人要顯示在地圖和小地圖上。",
        ["esES"] = "Permite seleccionar qué vendedores mostrar en el mapa y minimapa.",
        ["frFR"] = "Permet de sélectionner quels marchands afficher sur la carte et la minicarte.",
    },
    ["Icon Types"] = {
        ["ptBR"] = "Tipos de ícones",
        ["ruRU"] = "Типы значков",
        ["deDE"] = "Icon-Arten",
        ["koKR"] = "아이콘 유형",
        ["esMX"] = "Tipos de icono",
        ["enUS"] = true,
        ["zhCN"] = "图标类别",
        ["zhTW"] = "圖示類型",
        ["esES"] = "Tipos de icono",
        ["frFR"] = "Types d'icônes",
    },
    ["When this is enabled, the quest turn-in locations will be shown on the map/minimap."] = {
        ["ptBR"] = "Quando ativado, os locais de ativação da missão serão exibidos no mapa / mapa mínimo",
        ["ruRU"] = "Показать/скрыть местоположения выполненных заданий на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert die Icons der abgeschlossenen Quests auf der Karte/Minimap.",
        ["koKR"] = "퀘스트 완료 아이콘을 지도와 미니맵에 표시합니다.",
        ["esMX"] = "Cuando está habilitado los iconos de misión completada apareceran en el mapa y minimapa",
        ["enUS"] = true,
        ["zhCN"] = "若启用，在地图上标记提交任务的地点",
        ["zhTW"] = "啟用時，大地圖/小地圖上會顯示回任務的位置。",
        ["esES"] = "Cuando está habilitado los iconos de misión completada apareceran en el mapa y minimapa",
        ["frFR"] = "Active l'affichage des lieux où rendre les quêtes sur la carte/minicarte.",
    },
    ["Enable Map Icons"] = {
        ["ptBR"] = "Ativar ícones do mapa",
        ["ruRU"] = "Значки на карте мира",
        ["deDE"] = "Karten-Icons anzeigen",
        ["koKR"] = "지도 아이콘 활성화",
        ["esMX"] = "Habilitar iconos en el mapa",
        ["enUS"] = true,
        ["zhCN"] = "启用大地图图标",
        ["zhTW"] = "啟用大地圖圖示",
        ["esES"] = "Habilitar iconos en el mapa",
        ["frFR"] = "Activer les icônes sur la carte",
    },
    ["Show/hide all icons from the main map."] = {
        ["ptBR"] = "Mostrar / ocultar todos os ícones na carta principal",
        ["ruRU"] = "Показать/скрыть все значки на карте мира",
        ["deDE"] = "Aktiviert/Deaktiviert alle Icons auf der Karte",
        ["koKR"] = "세계 지도에 퀘스트 아이콘을 표시합니다.",
        ["esMX"] = "Mostrar/Ocultar todos los iconos del mapa principal",
        ["enUS"] = true,
        ["zhCN"] = "启用或停用大地图上的所有图标",
        ["zhTW"] = "顯示/隱藏大地圖上的所有圖示。",
        ["esES"] = "Mostrar/Ocultar todos los iconos del mapa principal",
        ["frFR"] = "Active l'affichage de toutes les icônes sur la carte.",
    },
    ["Enable Minimap Icons"] = {
        ["ptBR"] = "Ativar ícones do Mini-mapa",
        ["ruRU"] = "Значки на миникарте",
        ["deDE"] = "Minimap-Icons anzeigen",
        ["koKR"] = "미니맵 아이콘 활성화",
        ["esMX"] = "Habilitar iconos del minimapa",
        ["enUS"] = true,
        ["zhCN"] = "启用小地图标记",
        ["zhTW"] = "啟用小地圖圖示",
        ["esES"] = "Habilitar iconos del minimapa",
        ["frFR"] = "Activer les icônes sur la minicarte",
    },
    ["Show/hide all icons from the minimap."] = {
        ["ptBR"] = "Mostrar / ocultar todos os ícones no mini-mapa",
        ["ruRU"] = "Показать/скрыть все значки на миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert alle Icons auf der Minimap",
        ["koKR"] = "미니맵에 퀘스트 아이콘을 표시합니다.",
        ["esMX"] = "Mostrar/Ocultar todos los iconos del minimapa",
        ["enUS"] = true,
        ["zhCN"] = "启用或停用小地图上的所有图标",
        ["zhTW"] = "顯示/隱藏小地圖上的所有圖示。",
        ["esES"] = "Mostrar/Ocultar todos los iconos del minimapa",
        ["frFR"] = "Active l'affichage de toutes les icônes sur la minicarte.",
    },
    ["Hide Icons in Unexplored Areas"] = {
        ["ptBR"] = "Ocultar ícones da área inexplorada",
        ["ruRU"] = "Значки неисследованных зон",
        ["deDE"] = "Icons in nicht entdeckten Gebieten verbergen",
        ["koKR"] = "미탐험 지역 아이콘 가리기",
        ["esMX"] = "Ocultar icono de áreas inexploradas.",
        ["enUS"] = true,
        ["zhCN"] = "隐藏未探测区域图标",
        ["zhTW"] = "隱藏未探索區域的圖示",
        ["esES"] = "Ocultar icono de áreas inexploradas.",
        ["frFR"] = "Cacher les icônes des zones inexplorées",
    },
    ["Hide icons in unexplored map regions."] = {
        ["ptBR"] = "Oculta ícones em áreas inexploradas.",
        ["ruRU"] = "Показать/скрыть значки в неисследованных областях карты",
        ["deDE"] = "Verbirgt die Questie Icons in nicht entdeckten Gebieten.",
        ["koKR"] = "미탐험 지역의 아이콘을 가립니다.",
        ["esMX"] = "Ocultar iconos en áreas inexploradas.",
        ["enUS"] = true,
        ["zhCN"] = "隐藏未探测区域中的图标",
        ["zhTW"] = "隱藏在尚未探索的區域內的圖示。",
        ["esES"] = "Ocultar iconos en áreas inexploradas.",
        ["frFR"] = "Désactive l'affichage des icônes dans les zones inexplorées.",
    },
    ["Hide icons of untracked quests"] = {
        ["ptBR"] = "Ocultar ícones de missões não rastreadas",
        ["ruRU"] = "Значки неотслеживаемых заданий",
        ["deDE"] = "Icons nicht getrackter Quests verbergen",
        ["koKR"] = false,
        ["esMX"] = "Ocultar iconos de misiones sin seguimiento",
        ["enUS"] = true,
        ["zhCN"] = "隐藏未追踪的任务图标",
        ["zhTW"] = "隱藏未追蹤任務的圖示",
        ["esES"] = "Ocultar iconos de misiones sin seguimiento",
        ["frFR"] = "Cacher les icônes des quêtes non suivies",
    },
    ["Hide icons for quests that are not tracked."] = {
        ["ptBR"] = "Oculta ícones para missões que não são rastreadas.",
        ["ruRU"] = "Показать/скрыть значки заданий, которые не отслеживаются в трекере",
        ["deDE"] = "Verbirgt die Icons aller Quests die nicht vom Tracker getrackt werden.",
        ["koKR"] = false,
        ["esMX"] = "Oculta los iconos de las misiones que no se rastrean.",
        ["enUS"] = true,
        ["zhCN"] = "隐藏追踪器上未追踪的任务图标",
        ["zhTW"] = "隱藏沒有在任務追蹤清單中的任務的圖示。",
        ["esES"] = "Oculta los iconos de las misiones que no se rastrean.",
        ["frFR"] = "Masquez les icônes pour les quêtes qui ne sont pas suivies.",
    },
    ["Show custom quest frame icons"] = {
        ["ptBR"] = "Mostrar ícones personalizados no quadro de missões",
        ["ruRU"] = "Значки пользователя в диалогах",
        ["deDE"] = "Zeige angepasste Icons in Quest-Fenster",
        ["koKR"] = false,
        ["esMX"] = "Mostrar iconos de marco de misión personalizados",
        ["enUS"] = true,
        ["zhCN"] = "显示自定义任务窗口图标",
        ["zhTW"] = "顯示自訂任務視窗圖示",
        ["esES"] = "Mostrar iconos de marco de misión personalizados",
        ["frFR"] = "Afficher des icônes de cadre de quête personnalisés",
    },
    ["Use custom Questie icons for NPC dialogs, reflecting the status and type of each quest."] = {
        ["ptBR"] = "Utilizar ícones personalizados do Questie para diálogos de NPCs, refletindo o status e o tipo de cada missão.",
        ["ruRU"] = "Показать/скрыть пользовательские значки, отражающие статус и тип каждого задания, во время диалога с NPC",
        ["deDE"] = "Questie zeigt in NPC-Dialogen angepasste Icons, die den Status und Typ jeder Quest widerspiegeln.",
        ["koKR"] = false,
        ["esMX"] = "Utiliza iconos de Questie personalizados para los diálogos de PNJ, que reflejen el estado y el tipo de cada misión.",
        ["enUS"] = true,
        ["zhCN"] = "NPC 对话框显示任务位置提示插件的自定义图标，反应出每个任务的状态和类型。",
        ["zhTW"] = "NPC 對話框顯示任務位置提示插件的自訂圖示，反應出每個任務的狀態和類型。",
        ["esES"] = "Utiliza iconos de Questie personalizados para los diálogos de PNJ, que reflejen el estado y el tipo de cada misión.",
        ["frFR"] = "Utiliser des icônes Questie personnalisées pour les dialogues des PNJ, reflétant le statut et le type de chaque quête.",
    },
    ["Enable Available Quest Icons"] = {
        ["ptBR"] = "Ativar ícones de missões disponíveis",
        ["ruRU"] = "Значки доступных заданий",
        ["deDE"] = "Icons zu verfügbaren Quests anzeigen",
        ["koKR"] = "수행 가능한 퀘스트 아이콘 활성화",
        ["esMX"] = "Habilitar iconos de misión disponible",
        ["enUS"] = true,
        ["zhCN"] = "启用可接任务图标",
        ["zhTW"] = "啟用可接的任務圖示",
        ["esES"] = "Habilitar iconos de misión disponible",
        ["frFR"] = "Icônes des quêtes disponibles",
    },
    ["When this is enabled, the locations of available quests will be shown on the map/minimap."] = {
        ["ptBR"] = "Quando esta opção está ativada, os locais de ativação da missão serão exibidos no mapa / mini mapa",
        ["ruRU"] = "Показать/скрыть местоположения доступных заданий на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert die Icons der verfügbaren Quests auf der Karte/Minimap.",
        ["koKR"] = "수행 가능한 퀘스트 아이콘을 지도와 미니맵에 표시합니다.",
        ["esMX"] = "Cuando está habilitado los iconos de misión disponible apareceran en el mapa y minimapa",
        ["enUS"] = true,
        ["zhCN"] = "若启用，在地图上标记可接任务的地点",
        ["zhTW"] = "啟用時，大地圖/小地圖上會顯示可取得任務的位置。",
        ["esES"] = "Cuando está habilitado los iconos de misión disponible apareceran en el mapa y minimapa",
        ["frFR"] = "Active l'affichage des lieux où prendre les quêtes sur la carte/minicarte.",
    },
    ["Enable Event Quest Icons"] = {
        ["ptBR"] = "Ativar ícones da missão de eventos",
        ["ruRU"] = "Значки заданий игровых событий",
        ["deDE"] = "Event-Quest anzeigen",
        ["koKR"] = "이벤트 퀘스트 아이콘 활성화",
        ["esMX"] = "Habilitar iconos de misiones de eventos",
        ["enUS"] = true,
        ["zhCN"] = "启用事件任务图标",
        ["zhTW"] = "啟用事件任務圖示",
        ["esES"] = "Habilitar iconos de misiones de eventos",
        ["frFR"] = "Icônes des quêtes d'évènement",
    },
    ["When this is enabled, the locations of active event quests will be shown on the map/minimap."] = {
        ["ptBR"] = "Quando isso estiver ativado, a busca de locais de eventos será mostrada no mapa/minimapa.",
        ["ruRU"] = "Показать/скрыть местоположения заданий игровых событий на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert die Icons von Event-Quests auf der Karte/Minimap.",
        ["koKR"] = "아이콘을 활성화시, 이벤트 퀘스트의 위치를 맵/미니맵에 표시합니다.",
        ["esMX"] = "Cuando está habilitado la localización de misiones de eventos mostrará en el mapa y minimapa.",
        ["enUS"] = true,
        ["zhCN"] = "启用此功能后，事件任务的位置将显示在 世界地图/小地图上。",
        ["zhTW"] = "啟用時，大地圖/小地圖上會顯示可取得事件任務的位置。",
        ["esES"] = "Cuando está habilitado la localización de misiones de eventos mostrará en el mapa y minimapa.",
        ["frFR"] = "Active l'affichage des quêtes des évènements mondiaux sur la carte/minicarte.",
    },
    ["Enable Objective Icons"] = {
        ["ptBR"] = "Ativar ícones do objectivo",
        ["ruRU"] = "Значки целей заданий",
        ["deDE"] = "Icons zu Questzielen anzeigen",
        ["koKR"] = "퀘스트 목표 아이콘 활성화",
        ["esMX"] = "Habilitar iconos de objetivo",
        ["enUS"] = true,
        ["zhCN"] = "启用互动目标图标",
        ["zhTW"] = "啟用任務目標圖示",
        ["esES"] = "Habilitar iconos de objetivo",
        ["frFR"] = "Icônes des objectifs",
    },
    ["When this is enabled, quest objective icons will be shown on the map/minimap."] = {
        ["ptBR"] = "Se ativado, os ícones do objectivo da missão serão exibidos no mapa / minimapa",
        ["ruRU"] = "Показать/скрыть значки целей заданий на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert die Icons der Questziele auf der Karte/Minimap.",
        ["koKR"] = "퀘스트 목표 아이콘을 지도와 미니맵에 표시합니다.",
        ["esMX"] = "Cuando está habilitado los iconos de objetivo apareceran en el mapa y minimapa",
        ["enUS"] = true,
        ["zhCN"] = "若启用，在地图上显示任务互动目标",
        ["zhTW"] = "啟用時，大地圖/小地圖上會顯示任務目標圖示。",
        ["esES"] = "Cuando está habilitado los iconos de objetivo apareceran en el mapa y minimapa",
        ["frFR"] = "Active l'affichage des icônes des objectifs de quête sur la carte/minicarte.",
    },
    ["Enable Repeatable Quest Icons"] = {
        ["ptBR"] = "Mostrar missões repetíveis no mapa",
        ["ruRU"] = "Значки повторяемых заданий",
        ["deDE"] = "Wiederholbare Quests anzeigen",
        ["koKR"] = "지도에 반복 퀘스트를 표시",
        ["esMX"] = "Mostrar misiones repetibles",
        ["enUS"] = true,
        ["zhCN"] = "启用重复的任务图标",
        ["zhTW"] = "顯示可重覆接取的任務圖示",
        ["esES"] = "Mostrar misiones repetibles",
        ["frFR"] = "Quêtes répétables sur la carte",
    },
    ["When this is enabled, the locations of repeatable quests will be shown on the map/minimap."] = {
        ["ptBR"] = "Escolha se missões repetíveis devem estar visíveis no mapa e no minimapa.",
        ["ruRU"] = "Показать/скрыть местоположения повторяемых заданий на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert die Icons von wiederholbaren Quests auf der Karte/Minimap.",
        ["koKR"] = "지도나 미니맵에 반복 퀘스트를 표시할지 말지 선택합니다.",
        ["esMX"] = "Muestra las misiones repetibles en el mapa y minimapa.",
        ["enUS"] = true,
        ["zhCN"] = "启用此功能后，重复任务的位置将显示在 世界地图/小地图上。",
        ["zhTW"] = "啟用時，會在大地圖和小地圖上顯示可以重覆接取的任務。",
        ["esES"] = "Muestra las misiones repetibles en el mapa y minimapa.",
        ["frFR"] = "Active l'affichage des quêtes répétables sur la carte et la minicarte.",
    },
    ["Enable Raid Quest Icons"] = {
        ["ptBR"] = "Ativar ícones de missões de raide",
        ["ruRU"] = "Значки рейдовых заданий",
        ["deDE"] = "Raid-Quests anzeigen",
        ["koKR"] = "레이드 퀘스트 아이콘 활성화",
        ["esMX"] = "Habilitar iconos de misiones de bandas",
        ["enUS"] = true,
        ["zhCN"] = "启用团队任务图标",
        ["zhTW"] = "啟用團隊任務圖示",
        ["esES"] = "Habilitar iconos de misiones de bandas",
        ["frFR"] = "Icônes des quêtes de raid",
    },
    ["When this is enabled, the locations of raid quests will be shown on the map/minimap."] = {
        ["ptBR"] = "Quando isso estiver ativado, os locais da missão da raide serão mostrados no mapa/minimapa.",
        ["ruRU"] = "Показать/скрыть местоположения рейдовых заданий на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert die Icons von Raid-Quests auf der Karte/Minimap.",
        ["koKR"] = "아이콘을 활성화시, 레이드 퀘스트의 위치를 맵/미니맵에 표시합니다.",
        ["esMX"] = "Cuando está habilitado la localización de misiones de bandas mostrará en el mapa y minimapa.",
        ["enUS"] = true,
        ["zhCN"] = "启用此功能后，团队任务的位置将显示在 世界地图/小地图上。",
        ["zhTW"] = "啟用時，會在大地圖和小地圖上顯示團隊任務。",
        ["esES"] = "Cuando está habilitado la localización de misiones de bandas mostrará en el mapa y minimapa.",
        ["frFR"] = "Active l'affichage des quêtes de raid sur la carte/minicarte.",
    },
    ["Enable Dungeon Quest Icons"] = {
        ["ptBR"] = "Ativar ícones de missões de masmorra",
        ["ruRU"] = "Значки заданий подземелий",
        ["deDE"] = "Dungeon-Quests anzeigen",
        ["koKR"] = "던전 퀘스트 활성화",
        ["esMX"] = "Habilitar iconos de misiones de calabozos",
        ["enUS"] = true,
        ["zhCN"] = "启用副本任务图标",
        ["zhTW"] = "啟用地城任務圖示",
        ["esES"] = "Habilitar iconos de misiones de mazmorras",
        ["frFR"] = "Icônes des quêtes de donjon",
    },
    ["When this is enabled, the locations of dungeon quests will be shown on the map/minimap."] = {
        ["ptBR"] = "Quando isso estiver ativado, os locais da missão da masmorra serão mostrados no mapa/minimapa.",
        ["ruRU"] = "Показать/скрыть местоположения заданий подземелий на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert die Icons von Dungeon-Quests auf der Karte/Minimap.",
        ["koKR"] = "아이콘을 활성화시, 던전 퀘스트의 위치를 맵/미니맵에 표시합니다.",
        ["esMX"] = "Cuando está habilitado la localización de misiones de calabozos mostrará en el mapa y minimapa.",
        ["enUS"] = true,
        ["zhCN"] = "启用此功能后，副本任务的位置将显示在 世界地图/小地图上。",
        ["zhTW"] = "啟用時，會在大地圖和小地圖上顯示地城任務。",
        ["esES"] = "Cuando está habilitado la localización de misiones de mazmorras mostrará en el mapa y minimapa.",
        ["frFR"] = "Active l'affichage des quêtes de donjon sur la carte/minicarte.",
    },
    ["Enable Completed Quest Icons"] = {
        ["ptBR"] = "Ativar ícones de missões concluídas",
        ["ruRU"] = "Значки выполненных заданий",
        ["deDE"] = "Icons zu abgeschlossenen Quests anzeigen",
        ["koKR"] = "퀘스트 완료 아이콘 활성화",
        ["esMX"] = "Habilitar iconos de misión completada",
        ["enUS"] = true,
        ["zhCN"] = "启用提交任务标记",
        ["zhTW"] = "啟用已完成的任務圖示",
        ["esES"] = "Habilitar iconos de misión completada",
        ["frFR"] = "Icônes des quêtes terminées",
    },
    ["Enable PvP Quest Icons"] = {
        ["ptBR"] = "Ativar ícones de missões de JxJ",
        ["ruRU"] = "Значки PvP-заданий",
        ["deDE"] = "PvP-Quests anzeigen",
        ["koKR"] = "PVP 퀘스트 아이콘 활성화",
        ["esMX"] = "Habilitar iconos de misiones de JcJ",
        ["enUS"] = true,
        ["zhCN"] = "启用PVP任务图标",
        ["zhTW"] = "啟用 PvP 任務圖示",
        ["esES"] = "Habilitar iconos de misiones de JcJ",
        ["frFR"] = "Icônes des quêtes JcJ",
    },
    ["When this is enabled, the locations of PvP quests will be shown on the map/minimap."] = {
        ["ptBR"] = "Quando isso estiver ativado, os locais da missão de JxJ serão mostrados no mapa/minimapa.",
        ["ruRU"] = "Показать/скрыть местоположения PvP-заданий на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert die Icons von PvP-Quests auf der Karte/Minimap.",
        ["koKR"] = "아이콘을 활성화시, PVP 퀘스트의 위치를 맵/미니맵에 표시합니다.",
        ["esMX"] = "Cuando está habilitado la localización de misiones de JcJ mostrará en el mapa y minimapa.",
        ["enUS"] = true,
        ["zhCN"] = "启用此功能后，PVP任务的位置将显示在 世界地图/小地图上。",
        ["zhTW"] = "啟用時，會在大地圖和小地圖上顯示 PvP 任務。",
        ["esES"] = "Cuando está habilitado la localización de misiones de JcJ mostrará en el mapa y minimapa.",
        ["frFR"] = "Active l'affichage des quêtes JcJ sur la carte/minicarte.",
    },
    ["Available AQ War Effort Quests"] = {
        ["ptBR"] = "O Esforço de Guerra de Ahn'Qiraj",
        ["ruRU"] = "Значки военной кампании Ан'Киража",
        ["deDE"] = "AQ Kriegsanstrengungen Quests anzeigen",
        ["koKR"] = "안퀴라즈 반납 퀘스트 아이콘 활성화",
        ["esMX"] = "La campaña de guerra de Ahn'Qiraj",
        ["enUS"] = true,
        ["zhCN"] = "启用安其拉战备任务图标",
        ["zhTW"] = "啟用安其拉之門戰火任務圖示",
        ["esES"] = "El esfuerzo de guerra de Ahn'Qiraj",
        ["frFR"] = "L'effort de guerre d'Ahn'Qiraj",
    },
    ["When this is enabled, the locations of the AQ War Effort quests will be shown on the map/minimap."] = {
        ["ptBR"] = "Quando isso estiver ativado, os locais da missão do Esforço de Guerra de Ahn'Qiraj serão mostrados no mapa/minimapa.",
        ["ruRU"] = "Показать/скрыть местоположения заданий военной кампании Ан'Киража на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert die Icons der AQ Kriegsanstrengungen Quests auf der Karte/Minimap.",
        ["koKR"] = "아이콘을 활성화시, 안퀴라즈 반납 퀘스트의 위치를 맵/미니맵에 표시합니다.",
        ["esMX"] = "Cuando está habilitado las localizaciones de las misiones de la campaña de guerra de Ahn'Qiraj mostrarán en el mapa/minimapa.",
        ["enUS"] = true,
        ["zhCN"] = "启用此功能后，安其拉战备任务的位置将显示在 世界地图/小地图上。",
        ["zhTW"] = "啟用時，會在大地圖和小地圖上顯示安其拉之門戰火任務。",
        ["esES"] = "Cuando está habilitado las localizaciones de las misiones del esfuerzo de guerra de Ahn'Qiraj mostrarán en el mapa/minimapa.",
        ["frFR"] = "Active l'affichage des quêtes de l'effort de guerre d'Ahn'Qiraj sur la carte/minicarte.",
    },
    ["Toggle pfQuest/ClassicCodex icon style"] = {
        ["ptBR"] = "Alternar o estilo de ícone do pfQuest/ClassicCodex",
        ["ruRU"] = "Значки pfQuest/ClassicCodex",
        ["deDE"] = "pfQuest/ClassicCodex Iconstil umschalten",
        ["koKR"] = false,
        ["esMX"] = "Alternar estilo de icono pfQuest/ClassicCodex",
        ["enUS"] = true,
        ["zhCN"] = "切换 pfQuest/ClassicCodex 图标风格",
        ["zhTW"] = "切換 pfQuest/ClassicCodex 圖示風格",
        ["esES"] = "Alternar estilo de icono pfQuest/ClassicCodex",
        ["frFR"] = "Basculer le style d'icône de pfQuest/ClassicCodex",
    },
    ["Toggles between Questie icon style and pfQuest/ClassicCodex icon style.\n\nToggling affects the following settings:\n\n- Objective icons\n- "] = {
        ["ptBR"] = "Alterna entre o estilo de ícone do Questie e o estilo de ícone do pfQuest/ClassicCodex.\n\nAlternar afeta as seguintes configurações:\n\n- Ícones de objetivo\n-",
        ["ruRU"] = "Переключает между стилями значков Questie или pfQuest/ClassicCodex.\n\nЭто влияет на:\n\n- Значки целей заданий\n- ",
        ["deDE"] = "Schaltet zwischen Questie Iconstil und pfQuest/ClassicCodex Iconstil um.\n\nUmschalten beeinflusst die folgenden Einstellungen:\n\n- Zielicons\n- ",
        ["koKR"] = false,
        ["esMX"] = "Alterna entre el estilo de icono Questie y el estilo de icono pfQuest/ClassicCodex.\n\nLa alternancia afecta las siguientes configuraciones:\n\n- Iconos de objetivos\n- ",
        ["enUS"] = true,
        ["zhCN"] = "切换要使用任务提示插件的图标风格，还是 pfQuest/ClassicCodex icon 的图标风格。\n\n切换风格会影响下列设置：\n\n- 任务目标提示图标\n- ",
        ["zhTW"] = "切換要使用任務位置提示插件的圖示風格，還是 pfQuest/ClassicCodex 的圖示風格。\n\n切換風格會影響下列設定:\n\n- 任務目標圖示\n- ",
        ["esES"] = "Alterna entre el estilo de icono Questie y el estilo de icono pfQuest/ClassicCodex.\n\nLa alternancia afecta las siguientes configuraciones:\n\n- Iconos de objetivos\n- ",
        ["frFR"] = "Basculer entre le style d'icône de Questie et le style d'icône de pfQuest/ClassicCodex.\n\nLe basculement affecte les paramètres suivants :\n\n- Icônes d'objectifs\n-",
    },
    ["Icon Overrides (show/hide)"] = {
        ["ptBR"] = "Sobreposições de ícones (mostrar/ocultar)",
        ["ruRU"] = "Переопределение значков",
        ["deDE"] = "Icons überschreiben",
        ["koKR"] = false,
        ["esMX"] = "Anulación de iconos (mostrar/ocultar)",
        ["enUS"] = true,
        ["zhCN"] = "覆盖图标 （显示/隐藏）",
        ["zhTW"] = "顯示/隱藏圖示",
        ["esES"] = "Anulación de iconos (mostrar/ocultar)",
        ["frFR"] = "Remplacements d'icônes (afficher/cacher)",
    },
    ["Slay objectives"] = {
        ["ptBR"] = "Objetivos de matar",
        ["ruRU"] = "Убийство",
        ["deDE"] = "Tötungsziele",
        ["koKR"] = false,
        ["esMX"] = "Objetivos de matar",
        ["enUS"] = true,
        ["zhCN"] = "击杀目标",
        ["zhTW"] = "擊殺目標",
        ["esES"] = "Objetivos de matar",
        ["frFR"] = "Objectifs de tuerie",
    },
    ["The icon that is displayed for quest objectives where you need to kill an NPC"] = {
        ["ptBR"] = "O ícone mostrado para os objetivos da missão onde você precisa matar um NPC",
        ["ruRU"] = "Значок для целей заданий, в которых вам нужно убить NPC",
        ["deDE"] = "Das Icon welches für Questziele wo du jemanden töten musst angezeigt wird",
        ["koKR"] = false,
        ["esMX"] = "El icono que se muestra para los objetivos de misión en los que necesitas matar a un PNJ",
        ["enUS"] = true,
        ["zhCN"] = "任务需要你击杀 NPC 时显示的图标。",
        ["zhTW"] = "任務目標需要你擊殺 NPC 時顯示的圖示。",
        ["esES"] = "El icono que se muestra para los objetivos de misión en los que necesitas matar a un PNJ",
        ["frFR"] = "L'icône affichée pour les objectifs de quête où vous devez tuer un PNJ",
    },
    ["Loot objectives"] = {
        ["ptBR"] = "Objetivos de butim",
        ["ruRU"] = "Добыча",
        ["deDE"] = "Plünderungsziele",
        ["koKR"] = false,
        ["esMX"] = "Objetivos de botín",
        ["enUS"] = true,
        ["zhCN"] = "拾取物品",
        ["zhTW"] = "拾取物品",
        ["esES"] = "Objetivos de botín",
        ["frFR"] = "Objetifs de butin",
    },
    ["The icon that is displayed for quest objectives where you need to loot an item"] = {
        ["ptBR"] = "O ícone mostrado para os objetivos da missão onde você precisa saquear um item",
        ["ruRU"] = "Значок для целей заданий, в которых вам нужно добыть предмет",
        ["deDE"] = "Das Icon welches für Questziele wo du etwas plündern musst angezeigt wird",
        ["koKR"] = false,
        ["esMX"] = "El icono que se muestra para los objetivos de misión en los que necesitas despojar un objeto",
        ["enUS"] = true,
        ["zhCN"] = "任务需要你拾取物品时显示的图标",
        ["zhTW"] = "任務目標需要你拾取物品時顯示的圖示。",
        ["esES"] = "El icono que se muestra para los objetivos de misión en los que necesitas despojar un objeto",
        ["frFR"] = "L'icône affichée pour les objectifs de quête où vous devez fouiller un objet",
    },
    ["Object objectives"] = {
        ["ptBR"] = "Objetivos de objeto",
        ["ruRU"] = "Объект",
        ["deDE"] = "Objektziele",
        ["koKR"] = false,
        ["esMX"] = "Objetivo de objeto",
        ["enUS"] = true,
        ["zhCN"] = "与道具互动",
        ["zhTW"] = "與物件互動",
        ["esES"] = "Objetivo de objeto",
        ["frFR"] = "Objectifs d'objet",
    },
    ["The icon that is displayed for quest objectives where you need to interact with an object"] = {
        ["ptBR"] = "O ícone mostrado para os objetivos da missão onde você precisa interagir com um objeto",
        ["ruRU"] = "Значок для целей заданий, в которых вам нужно провзаимодействовать с объектом",
        ["deDE"] = "Das Icon welches für Questziele wo du mit einem Objekt interagieren musst angezeigt wird",
        ["koKR"] = false,
        ["esMX"] = "El icono que se muestra para los objetivos de misión en los que necesitas interactuar con un objeto",
        ["enUS"] = true,
        ["zhCN"] = "任务需要你和道具互动时显示的图标。",
        ["zhTW"] = "任務目標需要你和物件互動時顯示的圖示。",
        ["esES"] = "El icono que se muestra para los objetivos de misión en los que necesitas interactuar con un objeto",
        ["frFR"] = "L'icône affichée pour les objectifs de quête où vous devez interagir avec un objet",
    },
    ["Event objectives"] = {
        ["ptBR"] = "Objetivos de evento",
        ["ruRU"] = "Событие",
        ["deDE"] = "Ereignisziele",
        ["koKR"] = false,
        ["esMX"] = "Objetivo de evento",
        ["enUS"] = true,
        ["zhCN"] = "做些事情",
        ["zhTW"] = "做些事情",
        ["esES"] = "Objetivo de evento",
        ["frFR"] = "Objectifs d'événement",
    },
    ["The icon that is displayed for quest objectives where you need to do something in a certain area, like exploring it or casting a spell there"] = {
        ["ptBR"] = "O ícone mostrado para os objetivos da missão onde você precisa fazer algo em uma área específica",
        ["ruRU"] = "Значок для целей заданий, в которых вам нужно сделать что-либо в определенной области, например, исследовать ее или произнести там заклинание",
        ["deDE"] = "Das Icon welches für Questziele angezeigt wird wo du in einem bestimmten Gebiet etwas machen musst, wie es zu erkunden oder dort einen Zauberspruch zu benutzen",
        ["koKR"] = false,
        ["esMX"] = "El icono que se muestra para los objetivos de misión en los que necesitas hacer algo en un área determinada, como explorarla o lanzar un hechizo allí",
        ["enUS"] = true,
        ["zhCN"] = "任务需要在指定区域做某些事情时显示的图标，例如：探索区域或者在那里施放技能。",
        ["zhTW"] = "任務目標需要你在指定區域做某些事情時顯示的圖示，例如探索該區域或在那裏施放法術。",
        ["esES"] = "El icono que se muestra para los objetivos de misión en los que necesitas hacer algo en un área determinada, como explorarla o lanzar un hechizo allí",
        ["frFR"] = "L'icône affichée pour les objectifs de quête où vous devez faire quelque chose dans une certaine zone",
    },
    ["Talk objectives"] = {
        ["ptBR"] = "Objetivos de falar",
        ["ruRU"] = "Разговор",
        ["deDE"] = "Gesprächsziele",
        ["koKR"] = false,
        ["esMX"] = "Objetivo de hablar",
        ["enUS"] = true,
        ["zhCN"] = "对话",
        ["zhTW"] = "說話",
        ["esES"] = "Objetivo de hablar",
        ["frFR"] = "Objectifs de parler",
    },
    ["The icon that is displayed for quest objectives where you need to talk to an NPC"] = {
        ["ptBR"] = "O ícone mostrado para os objetivos da missão onde você precisa falar com um NPC",
        ["ruRU"] = "Значок для целей заданий, в которых вам нужно поговорить с NPC",
        ["deDE"] = "Das Icon welches für Questziele wo du mit einem NPC sprechen musst angezeigt wird",
        ["koKR"] = false,
        ["esMX"] = "El icono que se muestra para los objetivos de misión en los que necesitas hablar con un PNJ",
        ["enUS"] = true,
        ["zhCN"] = "任务需要你和 NCP 对话时显示的图标。",
        ["zhTW"] = "任務目標需要你和 NPC 說話時顯示的圖示。",
        ["esES"] = "El icono que se muestra para los objetivos de misión en los que necesitas hablar con un PNJ",
        ["frFR"] = "L'icône affichée pour les objectifs de quête où vous devez parler à un PNJ",
    },
    ["Normal Quests"] = {
        ["ptBR"] = "Missões normais",
        ["ruRU"] = "Обычные задания",
        ["deDE"] = "Normale Quests",
        ["koKR"] = false,
        ["esMX"] = "Misiones normales",
        ["enUS"] = true,
        ["zhCN"] = "一般任务",
        ["zhTW"] = "一般任務",
        ["esES"] = "Misiones normales",
        ["frFR"] = "Quêtes normales",
    },
    ["Available quests"] = {
        ["ptBR"] = "Missões disponíveis",
        ["ruRU"] = "Доступные",
        ["deDE"] = "Verfügbare Quests",
        ["koKR"] = false,
        ["esMX"] = "Misiones disponibles",
        ["enUS"] = true,
        ["zhCN"] = "可接的任务",
        ["zhTW"] = "可接的任務",
        ["esES"] = "Misiones disponibles",
        ["frFR"] = "Quêtes disponibles",
    },
    ["The icon that is displayed for available quests"] = {
        ["ptBR"] = "O ícone exibido para as missões disponíveis",
        ["ruRU"] = "Значок для доступных заданий",
        ["deDE"] = "Das Icon welches für verfügbare Quests angezeigt wird",
        ["koKR"] = false,
        ["esMX"] = "El icono que se muestra para las misiones disponibles",
        ["enUS"] = true,
        ["zhCN"] = "可接取的任务显示的图标",
        ["zhTW"] = "可取得的任務所顯示的圖示。",
        ["esES"] = "El icono que se muestra para las misiones disponibles",
        ["frFR"] = "L'icône affichée pour les quêtes disponibles",
    },
    ["Unavailable and trivial quests"] = {
        ["ptBR"] = "Missões não disponíveis e triviais",
        ["ruRU"] = "Серые",
        ["deDE"] = "Nicht verfügbare und triviale Quests",
        ["koKR"] = false,
        ["esMX"] = "Misiones triviales y no disponibles",
        ["enUS"] = true,
        ["zhCN"] = "无法接取和低等任务",
        ["zhTW"] = "無法取得和低等任務",
        ["esES"] = "Misiones triviales y no disponibles",
        ["frFR"] = "Quêtes non disponibles et triviales",
    },
    ["The icon that is displayed for quests that require additional conditions to be met before they can be accepted, or are so low level they don't reward experience"] = {
        ["ptBR"] = "O ícone mostrado para missões que requerem condições adicionais a serem cumpridas antes de poderem ser aceitas, ou que são de nível tão baixo que não concedem experiência como recompensa",
        ["ruRU"] = "Значок для серых заданий: недоступные (для принятия которых требуются определенные условия) и низкоуровневые (за выполнение которых вы не получите опыт)",
        ["deDE"] = "Das Icon welches für Quests angezeigt wird die zusätzliche Bedingungen haben bevor sie akzeptiert werden können, oder so niedriglevelig sind, dass sie keine Erfahrung gewähren",
        ["koKR"] = false,
        ["esMX"] = "El icono que se muestra para misiones que requieren que se cumplan condiciones adicionales antes de poder ser aceptadas, o que son de un nivel tan bajo que no recompensan la experiencia",
        ["enUS"] = true,
        ["zhCN"] = "需要额外条件才能接取的任务，或者是等级太低没有经验值的任务图标。",
        ["zhTW"] = "需要額外條件才能接取的任務，或是等級太低沒有經驗值的任務圖示。",
        ["esES"] = "El icono que se muestra para misiones que requieren que se cumplan condiciones adicionales antes de poder ser aceptadas, o que son de un nivel tan bajo que no recompensan la experiencia",
        ["frFR"] = "L'icône affichée pour les quêtes qui nécessitent des conditions supplémentaires à remplir avant de pouvoir être acceptées, ou qui sont de si bas niveau qu'elles ne donnent pas d'expérience en récompense",
    },
    ["Complete quests"] = {
        ["ptBR"] = "Missões completadas",
        ["ruRU"] = "Выполненные",
        ["deDE"] = "Abgeschlossene Quests",
        ["koKR"] = false,
        ["esMX"] = "Misiones completadas",
        ["enUS"] = true,
        ["zhCN"] = "完成任务",
        ["zhTW"] = "完成任務",
        ["esES"] = "Misiones completadas",
        ["frFR"] = "Quêtes terminées",
    },
    ["The icon that is displayed for completed quests that can be handed in"] = {
        ["ptBR"] = "O ícone mostrado para missões completadas que podem ser entregues",
        ["ruRU"] = "Значок для выполненных заданий",
        ["deDE"] = "Das Icon welches für abgeschlossene Quests angezeigt wird",
        ["koKR"] = false,
        ["esMX"] = "El icono que se muestra para las misiones completadas que se pueden entregar",
        ["enUS"] = true,
        ["zhCN"] = "已完成，可以交回的任务图标。",
        ["zhTW"] = "已完成，可以交回的任務圖示。",
        ["esES"] = "El icono que se muestra para las misiones completadas que se pueden entregar",
        ["frFR"] = "L'icône affichée pour les quêtes terminées qui peuvent être remises",
    },
    ["Repeatable Quests"] = {
        ["ptBR"] = "Missões repetíveis",
        ["ruRU"] = "Повторяемые задания",
        ["deDE"] = "Wiederholbare Quests",
        ["koKR"] = false,
        ["esMX"] = "Misiones repetibles",
        ["enUS"] = true,
        ["zhCN"] = "重复性任务",
        ["zhTW"] = "重覆性任務",
        ["esES"] = "Misiones repetibles",
        ["frFR"] = "Quêtes répétables",
    },
    ["Available repeatable quests"] = {
        ["ptBR"] = "Missões repetíveis disponíveis",
        ["ruRU"] = "Доступные",
        ["deDE"] = "Verfügbare wiederholbare Quests",
        ["koKR"] = false,
        ["esMX"] = "Misiones repetibles disponibles",
        ["enUS"] = true,
        ["zhCN"] = "可接的重复性任务",
        ["zhTW"] = "可接的重覆性任務",
        ["esES"] = "Misiones repetibles disponibles",
        ["frFR"] = "Quêtes répétables disponibles",
    },
    ["The icon that is displayed for available repeatable quests like dailies"] = {
        ["ptBR"] = "O ícone mostrado para missões repetíveis disponíveis, como as diárias",
        ["ruRU"] = "Значок для повторяемых заданий типа ежедневных",
        ["deDE"] = "Das Icon welches für verfügbare wiederholbare Quests angezeigt wird",
        ["koKR"] = false,
        ["esMX"] = "El icono que se muestra para las misiones repetibles disponibles, como las diarias",
        ["enUS"] = true,
        ["zhCN"] = "可接取的重复性任务图标，例如：每日。",
        ["zhTW"] = "可取得的重覆性任務的圖示，例如每日。",
        ["esES"] = "El icono que se muestra para las misiones repetibles disponibles, como las diarias",
        ["frFR"] = "L'icône affichée pour les quêtes répétables disponibles comme les quotidiennes",
    },
    ["Complete repeatable quests"] = {
        ["ptBR"] = "Missões repetíveis completadas",
        ["ruRU"] = "Выполненные",
        ["deDE"] = "Abgeschlossene wiederholbare Quests",
        ["koKR"] = false,
        ["esMX"] = "Misiones repetibles completadas",
        ["enUS"] = true,
        ["zhCN"] = "完成重复性任务",
        ["zhTW"] = "完成重覆性任務",
        ["esES"] = "Misiones repetibles completadas",
        ["frFR"] = "Quêtes répétables terminées",
    },
    ["The icon that is displayed for repeatable quests that can be handed in"] = {
        ["ptBR"] = "O ícone exibido para missões repetíveis completadas que podem ser entregues",
        ["ruRU"] = "Значок для выполненных повторяемых заданий типа ежедневных",
        ["deDE"] = "Das Icon welches für wiederholbare Quests angezeigt wird, die abgegeben werden können",
        ["koKR"] = false,
        ["esMX"] = "El icono que se muestra para las misiones repetibles que se pueden entregar",
        ["enUS"] = true,
        ["zhCN"] = "可以交回的重复性任务图标。",
        ["zhTW"] = "可以交回的重覆性任務圖示。",
        ["esES"] = "El icono que se muestra para las misiones repetibles que se pueden entregar",
        ["frFR"] = "L'icône affichée pour les quêtes répétables terminées qui peuvent être remises",
    },
    ["Event Quests"] = {
        ["ptBR"] = "Missões de evento",
        ["ruRU"] = "Игровые события",
        ["deDE"] = "Event-Quests",
        ["koKR"] = false,
        ["esMX"] = "Misiones de evento",
        ["enUS"] = true,
        ["zhCN"] = "节日任务",
        ["zhTW"] = "節慶任務",
        ["esES"] = "Misiones de evento",
        ["frFR"] = "Quêtes d'événement",
    },
    ["Available event quests"] = {
        ["ptBR"] = "Missões de evento disponíveis",
        ["ruRU"] = "Доступные",
        ["deDE"] = "Verfügbare Event-Quests",
        ["koKR"] = false,
        ["esMX"] = "Misiones de evento disponibles",
        ["enUS"] = true,
        ["zhCN"] = "可接的节日任务",
        ["zhTW"] = "可接的節慶任務",
        ["esES"] = "Misiones de evento disponibles",
        ["frFR"] = "Quêtes d'événement disponibles",
    },
    ["The icon that is displayed for available event quests during holidays"] = {
        ["ptBR"] = "O ícone mostrado para missões de evento disponíveis durante feriados",
        ["ruRU"] = "Значок для доступных заданий игровых событий во время праздников",
        ["deDE"] = "Das Icon welches für verfügbare Event-Quests angezeigt wird",
        ["koKR"] = false,
        ["esMX"] = "El icono que se muestra para las misiones de eventos disponibles durante los días festivos",
        ["enUS"] = true,
        ["zhCN"] = "节庆期间可以取得的节日任务",
        ["zhTW"] = "節慶期間可以取得的活動任務。",
        ["esES"] = "El icono que se muestra para las misiones de eventos disponibles durante los días festivos",
        ["frFR"] = "L'icône affichée pour les quêtes d'événement disponibles pendant les vacances",
    },
    ["Complete event quests"] = {
        ["ptBR"] = "Missões de evento completadas",
        ["ruRU"] = "Выполненные",
        ["deDE"] = "Abgeschlossene Event-Quests",
        ["koKR"] = false,
        ["esMX"] = "Misiones de eventos completadas",
        ["enUS"] = true,
        ["zhCN"] = "完成节日任务",
        ["zhTW"] = "完成節慶任務",
        ["esES"] = "Misiones de eventos completadas",
        ["frFR"] = "Quêtes d'événement terminées",
    },
    ["The icon that is displayed for event quests that can be handed in"] = {
        ["ptBR"] = "O ícone exibido para missões de evento completadas que podem ser entregues",
        ["ruRU"] = "Значок для выполненных заданий игровых событий во время праздников",
        ["deDE"] = "Das Icon welches für Event-Quests angezeigt wird, die abgegeben werden können",
        ["koKR"] = false,
        ["esMX"] = "El icono que se muestra para las misiones de eventos que se pueden entregar",
        ["enUS"] = true,
        ["zhCN"] = "可以交回的节日任务图标。",
        ["zhTW"] = "可以交回的節慶任務圖示。",
        ["esES"] = "El icono que se muestra para las misiones de eventos que se pueden entregar",
        ["frFR"] = "L'icône affichée pour les quêtes d'événement terminées qui peuvent être remises",
    },
    ["PvP Quests"] = {
        ["ptBR"] = "Missões JxJ",
        ["ruRU"] = "PvP-задания",
        ["deDE"] = "PvP-Quests",
        ["koKR"] = false,
        ["esMX"] = "Misiones de JcJ",
        ["enUS"] = true,
        ["zhCN"] = "PVP 任务",
        ["zhTW"] = "PvP 任務",
        ["esES"] = "Misiones de JcJ",
        ["frFR"] = "Quêtes JcJ",
    },
    ["Available PvP quests"] = {
        ["ptBR"] = "Missões JxJ disponíveis",
        ["ruRU"] = "Доступные",
        ["deDE"] = "Verfügbare PvP-Quests",
        ["koKR"] = false,
        ["esMX"] = "Misiones de JcJ disponibles",
        ["enUS"] = true,
        ["zhCN"] = "可接的 PVP 任务",
        ["zhTW"] = "可接的 PvP 任務",
        ["esES"] = "Misiones de JcJ disponibles",
        ["frFR"] = "Quêtes JcJ disponibles",
    },
    ["The icon that is displayed for available PvP quests"] = {
        ["ptBR"] = "O ícone mostrado para as missões JxJ disponíveis",
        ["ruRU"] = "Значок для доступных PVP-заданий",
        ["deDE"] = "Das Icon welches für verfügbare PvP-Quests angezeigt wird",
        ["koKR"] = false,
        ["esMX"] = "El icono que se muestra para las misiones de JcJ disponibles",
        ["enUS"] = true,
        ["zhCN"] = "可取得的 PVP 任务图标。",
        ["zhTW"] = "可取得的 PvP 任務圖示。",
        ["esES"] = "El icono que se muestra para las misiones de JcJ disponibles",
        ["frFR"] = "L'icône affichée pour les quêtes JcJ disponibles",
    },
    ["Complete PvP quests"] = {
        ["ptBR"] = "Missões JxJ completadas",
        ["ruRU"] = "Выполненные",
        ["deDE"] = "Abgeschlossene PvP-Quests",
        ["koKR"] = false,
        ["esMX"] = "Misiones de JcJ completadas",
        ["enUS"] = true,
        ["zhCN"] = "完成 PVP 任务",
        ["zhTW"] = "完成 PvP 任務",
        ["esES"] = "Misiones de JcJ completadas",
        ["frFR"] = "Quêtes JcJ terminées",
    },
    ["The icon that is displayed for PvP quests that can be handed in"] = {
        ["ptBR"] = "O ícone mostrado para missões JxJ completadas que podem ser entregues",
        ["ruRU"] = "Значок для выполненных PVP-заданий",
        ["deDE"] = "Das Icon welches für PvP-Quests angezeigt wird, die abgegeben werden können",
        ["koKR"] = false,
        ["esMX"] = "El icono que se muestra para las misiones de JcJ que se pueden entregar",
        ["enUS"] = true,
        ["zhCN"] = "可以交回的 PVP 任务图标。",
        ["zhTW"] = "可以交回的 PvP 任務圖示。",
        ["esES"] = "El icono que se muestra para las misiones de JcJ que se pueden entregar",
        ["frFR"] = "L'icône affichée pour les quêtes JcJ terminées qui peuvent être remises",
    },
    ["Icons"] = {
        ["ptBR"] = "Ícones",
        ["ruRU"] = "Значки",
        ["deDE"] = true,
        ["koKR"] = false,
        ["esMX"] = "Iconos",
        ["enUS"] = true,
        ["zhCN"] = "图标",
        ["zhTW"] = "圖示",
        ["esES"] = "Iconos",
        ["frFR"] = "Icônes",
    },
    ["Icon Options"] = {
        ["ptBR"] = "Opções de ícone",
        ["ruRU"] = "Настройки значков",
        ["deDE"] = "Icon-Optionen",
        ["koKR"] = false,
        ["esMX"] = "Opciones de iconos",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "圖示選項",
        ["esES"] = "Opciones de iconos",
        ["frFR"] = "Options d'icône",
    },
    ["Show icons for..."] = {
        ["ptBR"] = "Mostrar ícones para...",
        ["ruRU"] = "Отображать значки для...",
        ["deDE"] = "Zeige Icons für...",
        ["koKR"] = false,
        ["esMX"] = "Mostrar iconos para...",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "顯示圖示...",
        ["esES"] = "Mostrar iconos para...",
        ["frFR"] = "Afficher des icônes pour...",
    },
    ["Available Normal Quests"] = {
        ["ptBR"] = "Missões normais disponíveis",
        ["ruRU"] = "Обычные задания",
        ["deDE"] = "Verfügbare normale Quests",
        ["koKR"] = false,
        ["esMX"] = "Misiones normales disponibles",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "可接的一般任務",
        ["esES"] = "Misiones normales disponibles",
        ["frFR"] = "Quêtes normales disponibles",
    },
    ["Available Event Quests"] = {
        ["ptBR"] = "Missões de evento disponíveis",
        ["ruRU"] = "Игровые события",
        ["deDE"] = "Verfügbare Event-Quests",
        ["koKR"] = false,
        ["esMX"] = "Misiones de eventos disponibles",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "可接的節慶任務",
        ["esES"] = "Misiones de eventos disponibles",
        ["frFR"] = "Quêtes d'événement disponibles",
    },
    ["Available Repeatable Quests"] = {
        ["ptBR"] = "Missões repetíveis disponíveis",
        ["ruRU"] = "Повторяемые задания",
        ["deDE"] = "Verfügbare Wiederholbare-Quests",
        ["koKR"] = false,
        ["esMX"] = "Misiones repetibles disponibles",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "可接的重覆性任務",
        ["esES"] = "Misiones repetibles disponibles",
        ["frFR"] = "Quêtes répétables disponibles",
    },
    ["Available PvP Quests"] = {
        ["ptBR"] = "Missões JxJ disponíveis",
        ["ruRU"] = "PVP-задания",
        ["deDE"] = "Verfügbare PvP-Quests",
        ["koKR"] = false,
        ["esMX"] = "Misiones de JcJ disponibles",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "可接的 PvP 任務",
        ["esES"] = "Misiones de JcJ disponibles",
        ["frFR"] = "Quêtes JcJ disponibles",
    },
    ["Available Dungeon Quests"] = {
        ["ptBR"] = "Missões de masmorra disponíveis",
        ["ruRU"] = "Задания подземелий",
        ["deDE"] = "Verfügbare Dungeon-Quests",
        ["koKR"] = false,
        ["esMX"] = "Misiones de calabozo disponibles",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "可接的地城任務",
        ["esES"] = "Misiones de mazmorra disponibles",
        ["frFR"] = "Quêtes de donjon disponibles",
    },
    ["Available Raid Quests"] = {
        ["ptBR"] = "Missões de raide disponíveis",
        ["ruRU"] = "Рейдовые задания",
        ["deDE"] = "Verfügbare Raid-Quests",
        ["koKR"] = false,
        ["esMX"] = "Misiones de banda disponibles",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "可接的團隊任務",
        ["esES"] = "Misiones de banda disponibles",
        ["frFR"] = "Quêtes de raid disponibles",
    },
    ["Icon Scales"] = {
        ["ptBR"] = "Escala de ícones",
        ["ruRU"] = "Размер значков",
        ["deDE"] = "Icon-Skalierung",
        ["koKR"] = false,
        ["esMX"] = "Escala de iconos",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "圖示大小",
        ["esES"] = "Escala de iconos",
        ["frFR"] = "Échelle d'icônes",
    },
    ["Map Icons"] = {
        ["ptBR"] = "Ícones do mapa",
        ["ruRU"] = "На карте мира",
        ["deDE"] = "Karten-Icons",
        ["koKR"] = false,
        ["esMX"] = "Iconos de mapa",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "大地圖圖示",
        ["esES"] = "Iconos de mapa",
        ["frFR"] = "Icônes de carte",
    },
    ["Minimap Icons"] = {
        ["ptBR"] = "Ícones do minimapa",
        ["ruRU"] = "На миникарте",
        ["deDE"] = "Minimap-Icons",
        ["koKR"] = false,
        ["esMX"] = "Iconos de minimapa",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "小地圖圖示",
        ["esES"] = "Iconos de minimapa",
        ["frFR"] = "Icônes de minicarte",
    },
    ["Quest Icons"] = {
        ["ptBR"] = "Ícones de missão",
        ["ruRU"] = "Задания",
        ["deDE"] = "Quest-Icons",
        ["koKR"] = false,
        ["esMX"] = "Objetivos de objeto",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "任務圖示",
        ["esES"] = "Objetivos de objeto",
        ["frFR"] = "Icônes de quête",
    },
    ["Icon Overrides"] = {
        ["ptBR"] = "Sobreposições de ícones",
        ["ruRU"] = "Переназначение значков",
        ["deDE"] = "Icons überschreiben",
        ["koKR"] = false,
        ["esMX"] = "Anulación de iconos",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "自訂圖示",
        ["esES"] = "Anulación de iconos",
        ["frFR"] = "Remplacements d'icônes",
    },
    ["Hide Icons on Continent Map"] = {
        ["ptBR"] = "Ocultar ícones no mapa do continente",
        ["ruRU"] = "Скрыть на континенте",
        ["deDE"] = "Icons auf Kontinentkarte ausblenden",
        ["koKR"] = false,
        ["esMX"] = "Ocultar iconos en el mapa continental",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "隱藏大陸地圖上的圖示",
        ["esES"] = "Ocultar iconos en el mapa continental",
        ["frFR"] = "Cacher les icônes sur la carte du continent",
    },
    ["Hide icons on the continent map, when not viewing a specific zone."] = {
        ["ptBR"] = "Oculta ícones no mapa do continente quando nenhuma zona específica está sendo visualizada.",
        ["ruRU"] = "Скрывает значки на карте континента",
        ["deDE"] = "Blendet Icons auf der Kontinentkarte aus, wenn keine Zone ausgewählt ist.",
        ["koKR"] = false,
        ["esMX"] = "Oculta iconos en el mapa del continente cuando no estés viendo una zona específica.",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "不是檢視特定區域時，隱藏大陸地圖上的圖示。",
        ["esES"] = "Oculta iconos en el mapa del continente cuando no estés viendo una zona específica.",
        ["frFR"] = "Masque les icônes sur la carte du continent lorsque aucune zone spécifique n'est affichée.",
    },
    ["Objective Icon Theme"] = {
        ["ptBR"] = "Tema dos ícones de objetivo",
        ["ruRU"] = "Стиль значков целей",
        ["deDE"] = "Ziel-Icon-Style",
        ["koKR"] = false,
        ["esMX"] = "Tema de icono de objetivo",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "目標圖示主題",
        ["esES"] = "Tema de icono de objetivo",
        ["frFR"] = "Thème des icônes d'objectif",
    },
    ["Other Icons"] = {
        ["ptBR"] = "Outros ícones",
        ["ruRU"] = "Другие значки",
        ["deDE"] = "Andere Icons",
        ["koKR"] = false,
        ["esMX"] = "Otros iconos",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "其他圖示",
        ["esES"] = "Otros iconos",
        ["frFR"] = "Autres icônes",
    },
    ["Profession Trainers"] = {
        ["ptBR"] = "Instrutores de profissões",
        ["ruRU"] = "Учителя профессий",
        ["deDE"] = "Berufe-Lehrer",
        ["koKR"] = false,
        ["esMX"] = "Instructores de profesión",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "專業訓練師",
        ["esES"] = "Instructores de profesión",
        ["frFR"] = "Maîtres de profession",
    },
    ["Change between themes for objective icons."] = {
        ["ptBR"] = "Altera entre temas para ícones de objetivo.",
        ["ruRU"] = "Выбор стиля значков для целей заданий",
        ["deDE"] = "Wähle den Ziel-Icon-Style.",
        ["koKR"] = false,
        ["esMX"] = "Cambia entre temas para iconos de objetivos",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "目標圖示換成其他圖示主題。",
        ["esES"] = "Cambia entre temas para iconos de objetivos",
        ["frFR"] = "Change entre les thèmes pour les icônes d'objectif.",
    },
    ["Custom"] = {
        ["ptBR"] = "Personalizado",
        ["ruRU"] = "Пользовательский",
        ["deDE"] = "Benutzerdefiniert",
        ["koKR"] = false,
        ["esMX"] = "Personalizado",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "自訂",
        ["esES"] = "Personalizado",
        ["frFR"] = "Personnalisé",
    },
    ["Season of Discovery Runes"] = {
        ["ptBR"] = "Runas da Temporada da Descoberta",
        ["ruRU"] = "Руны Сезона Открытий",
        ["deDE"] = "Runen der Saison der Entdeckung",
        ["koKR"] = false,
        ["esMX"] = "Runas de Temporada de descubrimiento",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "探索賽季符文",
        ["esES"] = "Runas de Temporada de descubrimiento",
        ["frFR"] = "Runes de Saison de Découverte",
    },
    ["Show Runes"] = {
        ["ptBR"] = "Mostrar runas",
        ["ruRU"] = "Показать руны",
        ["deDE"] = "Runen anzeigen",
        ["koKR"] = "룬 표시",
        ["esMX"] = "Mostrar runas",
        ["enUS"] = true,
        ["zhCN"] = "显示符文",
        ["zhTW"] = "顯示符文",
        ["esES"] = "Mostrar runas",
        ["frFR"] = "Afficher les runes",
    },
    ["When this is enabled, the locations of Season of Discovery Runes and Rune quests will be shown on the map/minimap."] = {
        ["ptBR"] = "Quando ativado, as localizações das runas da Temporada de Descoberta e das missões de runas serão mostradas no mapa/minimapa.",
        ["ruRU"] = "Когда включено, местоположения рун Сезона Открытий и рун заданий будут отображаться на карте мира и миникарте",
        ["deDE"] = "Wenn aktiv, werden die Positionen der Runen der Saison der Entdeckung und Runen-Quests auf der Karte/Minikarte angezeigt.",
        ["koKR"] = false,
        ["esMX"] = "Cuando está habilitado las localizaciones de las runas de la Temporada de descubrimiento y las misiones de runas se mostrarán en el mapa/minimapa.",
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = "啟用時，會在大地圖和小地圖上顯示探索賽季符文和符文任務。",
        ["esES"] = "Cuando está habilitado las localizaciones de las runas de la Temporada de descubrimiento y las misiones de runas se mostrarán en el mapa/minimapa.",
        ["frFR"] = "Active l'affichage des emplacements des runes de la Saison de la Découverte et des quêtes de runes sur la carte/minicarte",
    },
    ["Phase 1"] = {
        ["ptBR"] = "Fase 1",
        ["ruRU"] = "Фаза 1",
        ["deDE"] = true,
        ["koKR"] = "1 단계",
        ["esMX"] = "Fase 1",
        ["enUS"] = true,
        ["zhCN"] = "第 1 阶段",
        ["zhTW"] = "階段 1",
        ["esES"] = "Fase 1",
        ["frFR"] = true,
    },
    ["Phase 2"] = {
        ["ptBR"] = "Fase 2",
        ["ruRU"] = "Фаза 2",
        ["deDE"] = true,
        ["koKR"] = "2 단계",
        ["esMX"] = "Fase 2",
        ["enUS"] = true,
        ["zhCN"] = "第 2 阶段",
        ["zhTW"] = "階段 2",
        ["esES"] = "Fase 2",
        ["frFR"] = true,
    },
    ["Phase 3"] = {
        ["ptBR"] = "Fase 3",
        ["ruRU"] = "Фаза 3",
        ["deDE"] = true,
        ["koKR"] = "3 단계",
        ["esMX"] = "Fase 3",
        ["enUS"] = true,
        ["zhCN"] = "第 3 阶段",
        ["zhTW"] = "階段 3",
        ["esES"] = "Fase 3",
        ["frFR"] = true,
    },
    ["Phase 4"] = {
        ["ptBR"] = "Fase 4",
        ["ruRU"] = "Фаза 4",
        ["deDE"] = true,
        ["koKR"] = "4 단계",
        ["esMX"] = "Fase 4",
        ["enUS"] = true,
        ["zhCN"] = "第 4 阶段",
        ["zhTW"] = "階段 4",
        ["esES"] = "Fase 4",
        ["frFR"] = true,
    },
}

for k, v in pairs(iconOptionsLocales) do
    l10n.translations[k] = v
end
