local _, GBB = GroupBulletinBoard_Loader.Main()

-- IMPORTANT, everything must be in low-case and with no space!

local function langSplit( source )
  local ret = {}
  for lang, pat in pairs( source ) do
    if pat ~= "-" then
      ret[ lang ] = GBB.Tool.Split( pat, " " )
    end
  end
  return ret
end

GBB.suffixTagsLoc = langSplit( {
  enGB = "s group run runs",
  deDE = "gruppe",
  ruRU = "группран фарм фарма фармить",
  frFR = "groupe",
  zhTW = "",
} )

GBB.searchTagsLoc = langSplit( {
  enGB =
  "group lfg lf lfm lf1m lf2m lf3m lf4m lf5m lftank lfheal lfhealer lfdps lfdd dd heal healer tank dps druid dudu huntard hunter mage pala pally paladin priest rogue rouge shaman lock warlock warrior elite quest elitequest elitequests",

  deDE =
  "gesucht suche suchen sucht such gruppe grp sfg sfm druide dudu jäger magier priester warri schurke rschami schamane hexer hexenmeister hm krieger heiler xheiler go run",

  ruRU = "лфг ищет ищу нид нужны лфм лф2м ищем пати похилю лф танк хил нужен дд рдд мдд ршам рога вар прист армс пал",
  frFR = "groupe cherche chasseur druide mage paladin pretre voleur chaman quete",

  zhTW = "缺 來 找 徵 坦 補 DD 輸出 戰 聖 薩 獵 德 賊 法 牧 術",
} )

GBB.badTagsLoc = langSplit( {
  enGB = "layer boost",
  deDE = "fc",
  ruRU = "гильдию гильдия слой",
  frFR = "",
  zhTW = "影布 回流",
} )

GBB.heroicTagsLoc = langSplit( {
  enGB = "h hc heroic hero",
  deDE = "h hc heroic hero",
  ruRU = "гер героик",
  frFR = "h hc heroic hm hero",
  zhTW = "h 英雄",
} )



GBB.dungeonTagsLoc = {
  enGB = langSplit( {
    [ "RFC" ]    = "rfc ragefire chasm",
    [ "DM" ]     = "dm deadmines dead mines mine",
    [ "WC" ]     = "wc wailing",
    [ "SFK" ]    = "sfk shadowfang",
    [ "STOCKS" ] = "stk stock stockade stockades",
    [ "BFD" ]    = "bfd blackfathom fathom",
    [ "GNOMER" ] = "gnomer gnomeregan",
    [ "RFK" ]    = "rfk kraul",
    [ "SM2" ]    = "sm scarlet monastery",
    [ "GY" ]     = "gy graveyard",
    [ "LIB" ]    = "lib library",
    [ "ARMS" ]   = "armory armoury arms",
    [ "CATH" ]   = "cath cathedral",
    [ "GMM" ]    = "gmm glittermurk glitter murk",
    [ "RFD" ]    = "rfd downs",
    [ "ULDA" ]   = "uld ulda uldaman",
    [ "ZF" ]     = "zf zul farrak zul'farrak zulfarrak zulfarak",
    [ "MARA" ]   = "mara maraudon",
    [ "ST" ]     = "st sunken atal temple",
    [ "BRD" ]    = "brd",
    [ "BH" ]     = "bh baradinhold baradin hold tolbarad tol barad",
    [ "SP" ]     = "peak",
    [ "SC" ]     = "caverns",
    [ "STRAT" ]  = "stratlive live living stratUD ud baron stratholme strath strat",
    [ "SCHOLO" ] = "scholomance scholo",
    [ "LBRS" ]   = "lower lbrs",
    [ "UBRS" ]   = "upper ubrs",
    [ "ONY" ]    = "onyxia ony onaxxia",
    [ "MC" ]     = "molten core mc",
    [ "ULDUM" ]  = "uldum",
    [ "ZG" ]     = "zg gurub zul'gurub zulgurub",
    [ "AQ10" ]   = "aq10",
    [ "BWL" ]    = "blackwing bwl",
    [ "AQ25" ]   = "aq25",
    [ "NAXX" ]   = "naxxramas naxx",
    [ "WSG" ]    = "wsg",
    [ "AB" ]     = "ab",
    [ "AV" ]     = "av",
    [ "GI" ]   = "gillijim gillijims gillijim's isle",
    [ "ARENA" ]  = "2s 3s 5s 3v3 5v5 2v2 2vs2 3vs3 5vs5",
    [ "BREW" ]   = "brewfest coren direbrew",
    [ "HOLLOW" ] = "headless horseman",
    [ "TRADE" ]  = "buy buying sell selling wts wtb hitem henchant htrade enchanter", --hlink
  } ),
  deDE = langSplit( {
    [ "RFC" ]    = "rfc ragefire chasm",
    [ "DM" ]     = "dm deadmines dead mines mine",
    [ "WC" ]     = "wc wailing",
    [ "SFK" ]    = "sfk shadowfang",
    [ "STOCKS" ] = "stk stock stockade stockades",
    [ "BFD" ]    = "bfd blackfathom fathom",
    [ "GNOMER" ] = "gnomer gnomeregan",
    [ "RFK" ]    = "rfk kraul",
    [ "SM2" ]    = "sm scarlet monastery",
    [ "GY" ]     = "gy graveyard",
    [ "LIB" ]    = "lib library",
    [ "ARMS" ]   = "armory armoury arms",
    [ "CATH" ]   = "cath cathedral",
    [ "GMM" ]    = "gmm glittermurk glitter murk",
    [ "RFD" ]    = "rfd downs",
    [ "ULDA" ]   = "uld ulda uldaman",
    [ "ZF" ]     = "zf zul farrak zul'farrak zulfarrak zulfarak",
    [ "MARA" ]   = "mara maraudon",
    [ "ST" ]     = "st sunken atal temple",
    [ "BRD" ]    = "brd",
    [ "BH" ]     = "bh baradinhold baradin hold tolbarad tol barad",
    [ "SP" ]     = "peak",
    [ "SC" ]     = "caverns",
    [ "STRAT" ]  = "stratlive live living stratUD ud baron stratholme strath strat",
    [ "SCHOLO" ] = "scholomance scholo",
    [ "LBRS" ]   = "lower lbrs",
    [ "UBRS" ]   = "upper ubrs",
    [ "ONY" ]    = "onyxia ony onaxxia",
    [ "MC" ]     = "molten core mc",
    [ "ULDUM" ]  = "uldum",
    [ "ZG" ]     = "zg gurub zul'gurub zulgurub",
    [ "AQ10" ]   = "aq10",
    [ "BWL" ]    = "blackwing bwl",
    [ "AQ25" ]   = "aq25",
    [ "NAXX" ]   = "naxxramas naxx",
    [ "WSG" ]    = "wsg",
    [ "AB" ]     = "ab",
    [ "AV" ]     = "av",
    [ "GI" ]   = "gillijim gillijims gillijim's isle",
    [ "ARENA" ]  = "2s 3s 5s 3v3 5v5 2v2 2vs2 3vs3 5vs5",
    [ "BREW" ]   = "brewfest coren direbrew",
    [ "HOLLOW" ] = "headless horseman",
    [ "TRADE" ]  = "buy buying sell selling wts wtb hitem henchant htrade enchanter",
  } ),
  ruRU = langSplit( {
    [ "RFC" ]    = "rfc ragefire chasm",
    [ "DM" ]     = "dm deadmines dead mines mine",
    [ "WC" ]     = "wc wailing",
    [ "SFK" ]    = "sfk shadowfang",
    [ "STOCKS" ] = "stk stock stockade stockades",
    [ "BFD" ]    = "bfd blackfathom fathom",
    [ "GNOMER" ] = "gnomer gnomeregan",
    [ "RFK" ]    = "rfk kraul",
    [ "SM2" ]    = "sm scarlet monastery",
    [ "GY" ]     = "gy graveyard",
    [ "LIB" ]    = "lib library",
    [ "ARMS" ]   = "armory armoury arms",
    [ "CATH" ]   = "cath cathedral",
    [ "GMM" ]    = "gmm glittermurk glitter murk",
    [ "RFD" ]    = "rfd downs",
    [ "ULDA" ]   = "uld ulda uldaman",
    [ "ZF" ]     = "zf zul farrak zul'farrak zulfarrak zulfarak",
    [ "MARA" ]   = "mara maraudon",
    [ "ST" ]     = "st sunken atal temple",
    [ "BRD" ]    = "brd",
    [ "BH" ]     = "bh baradinhold baradin hold tolbarad tol barad",
    [ "SP" ]     = "peak",
    [ "SC" ]     = "caverns",
    [ "STRAT" ]  = "stratlive live living stratUD ud baron stratholme strath strat",
    [ "SCHOLO" ] = "scholomance scholo",
    [ "LBRS" ]   = "lower lbrs",
    [ "UBRS" ]   = "upper ubrs",
    [ "ONY" ]    = "onyxia ony onaxxia",
    [ "MC" ]     = "molten core mc",
    [ "ULDUM" ]  = "uldum",
    [ "ZG" ]     = "zg gurub zul'gurub zulgurub",
    [ "AQ10" ]   = "aq10",
    [ "BWL" ]    = "blackwing bwl",
    [ "AQ25" ]   = "aq25",
    [ "NAXX" ]   = "naxxramas naxx",
    [ "WSG" ]    = "wsg",
    [ "AB" ]     = "ab",
    [ "AV" ]     = "av",
    [ "GI" ]   = "gillijim gillijims gillijim's isle",
    [ "ARENA" ]  = "2s 3s 5s 3v3 5v5 2v2 2vs2 3vs3 5vs5",
    [ "BREW" ]   = "brewfest coren direbrew",
    [ "HOLLOW" ] = "headless horseman",
    [ "TRADE" ]  = "buy buying sell selling wts wtb hitem henchant htrade enchanter",
  } ),
  frFR = langSplit( {
    [ "RFC" ]    = "rfc ragefire chasm",
    [ "DM" ]     = "dm deadmines dead mines mine",
    [ "WC" ]     = "wc wailing",
    [ "SFK" ]    = "sfk shadowfang",
    [ "STOCKS" ] = "stk stock stockade stockades",
    [ "BFD" ]    = "bfd blackfathom fathom",
    [ "GNOMER" ] = "gnomer gnomeregan",
    [ "RFK" ]    = "rfk kraul",
    [ "SM2" ]    = "sm scarlet monastery",
    [ "GY" ]     = "gy graveyard",
    [ "LIB" ]    = "lib library",
    [ "ARMS" ]   = "armory armoury arms",
    [ "CATH" ]   = "cath cathedral",
    [ "GMM" ]    = "gmm glittermurk glitter murk",
    [ "RFD" ]    = "rfd downs",
    [ "ULDA" ]   = "uld ulda uldaman",
    [ "ZF" ]     = "zf zul farrak zul'farrak zulfarrak zulfarak",
    [ "MARA" ]   = "mara maraudon",
    [ "ST" ]     = "st sunken atal temple",
    [ "BRD" ]    = "brd",
    [ "BH" ]     = "bh baradinhold baradin hold tolbarad tol barad",
    [ "SP" ]     = "peak",
    [ "SC" ]     = "caverns",
    [ "STRAT" ]  = "stratlive live living stratUD ud baron stratholme strath strat",
    [ "SCHOLO" ] = "scholomance scholo",
    [ "LBRS" ]   = "lower lbrs",
    [ "UBRS" ]   = "upper ubrs",
    [ "ONY" ]    = "onyxia ony onaxxia",
    [ "MC" ]     = "molten core mc",
    [ "ULDUM" ]  = "uldum",
    [ "ZG" ]     = "zg gurub zul'gurub zulgurub",
    [ "AQ10" ]   = "aq10",
    [ "BWL" ]    = "blackwing bwl",
    [ "AQ25" ]   = "aq25",
    [ "NAXX" ]   = "naxxramas naxx",
    [ "WSG" ]    = "wsg",
    [ "AB" ]     = "ab",
    [ "AV" ]     = "av",
    [ "GI" ]   = "gillijim gillijims gillijim's isle",
    [ "ARENA" ]  = "2s 3s 5s 3v3 5v5 2v2 2vs2 3vs3 5vs5",
    [ "BREW" ]   = "brewfest coren direbrew",
    [ "HOLLOW" ] = "headless horseman",
    [ "TRADE" ]  = "buy buying sell selling wts wtb hitem henchant htrade enchanter",
  } ),
  zhTW = langSplit( {
    [ "RFC" ]    = "rfc ragefire chasm",
    [ "DM" ]     = "dm deadmines dead mines mine",
    [ "WC" ]     = "wc wailing",
    [ "SFK" ]    = "sfk shadowfang",
    [ "STOCKS" ] = "stk stock stockade stockades",
    [ "BFD" ]    = "bfd blackfathom fathom",
    [ "GNOMER" ] = "gnomer gnomeregan",
    [ "RFK" ]    = "rfk kraul",
    [ "SM2" ]    = "sm scarlet monastery",
    [ "GY" ]     = "gy graveyard",
    [ "LIB" ]    = "lib library",
    [ "ARMS" ]   = "armory armoury arms",
    [ "CATH" ]   = "cath cathedral",
    [ "GMM" ]    = "gmm glittermurk glitter murk",
    [ "RFD" ]    = "rfd downs",
    [ "ULDA" ]   = "uld ulda uldaman",
    [ "ZF" ]     = "zf zul farrak zul'farrak zulfarrak zulfarak",
    [ "MARA" ]   = "mara maraudon",
    [ "ST" ]     = "st sunken atal temple",
    [ "BRD" ]    = "brd",
    [ "BH" ]     = "bh baradinhold baradin hold tolbarad tol barad",
    [ "SP" ]     = "peak",
    [ "SC" ]     = "caverns",
    [ "STRAT" ]  = "stratlive live living stratUD ud baron stratholme strath strat",
    [ "SCHOLO" ] = "scholomance scholo",
    [ "LBRS" ]   = "lower lbrs",
    [ "UBRS" ]   = "upper ubrs",
    [ "ONY" ]    = "onyxia ony onaxxia",
    [ "MC" ]     = "molten core mc",
    [ "ULDUM" ]  = "uldum",
    [ "ZG" ]     = "zg gurub zul'gurub zulgurub",
    [ "AQ10" ]   = "aq10",
    [ "BWL" ]    = "blackwing bwl",
    [ "AQ25" ]   = "aq25",
    [ "NAXX" ]   = "naxxramas naxx",
    [ "WSG" ]    = "wsg",
    [ "AB" ]     = "ab",
    [ "AV" ]     = "av",
    [ "GI" ]   = "gillijim gillijims gillijim's isle",
    [ "ARENA" ]  = "2s 3s 5s 3v3 5v5 2v2 2vs2 3vs3 5vs5",
    [ "BREW" ]   = "brewfest coren direbrew",
    [ "HOLLOW" ] = "headless horseman",
    [ "TRADE" ]  = "buy buying sell selling wts wtb hitem henchant htrade enchanter", --hlink
  } ),
}

GBB.dungeonTagsLoc.enGB[ "DEADMINES" ] = { "dm" }

GBB.dungeonSecondTags = {
  [ "DEADMINES" ] = { "DM", "-DMW", "-DME", "-DMN" },
  [ "SM2" ] = { "GY", "LIB", "ARMS", "CATH" },
}
