--[[
Name: LibBabble-Epoch-3.0
Revision: $Rev: 296 $
Maintainers: ckknight, nevcairiel, Ackis
Website: http://www.wowace.com/projects/libbabble-epoch-3-0/
Dependencies: None
License: MIT
]]

local MAJOR_VERSION = "LibBabble-Epoch-3.0"
local MINOR_VERSION = 90000 + tonumber(("$Rev: 296 $"):match("%d+"))

if not LibStub then error(MAJOR_VERSION .. " requires LibStub.") end
local lib = LibStub("LibBabble-3.0"):New(MAJOR_VERSION, MINOR_VERSION)
if not lib then return end

local GAME_LOCALE = GetLocale()

lib:SetBaseTranslations {
	[").  Depending on changes, there may be the occasional error, so please visit https://github.com/Raynbock/AtlaslootProjectEpoch/tree/main as soon as possible to update."] = ").  Depending on changes, there may be the occasional error, so please visit https://github.com/Raynbock/AtlaslootProjectEpoch/tree/main as soon as possible to update.",
	["Aerie Peak"] = "Aerie Peak",
	["Abominable Claws"] = "Abominable Claws",
	Afflictor = "Afflictor",
	["Aftershock Armor"] = "Aftershock Armor",
	["Animalistic Armor"] = "Animalistic Armor",
	["Arcanist Regalia"] = "Arcanist Regalia",
	["Aspirant Fighter"] = "Aspirant Fighter",
	["Aspirant Healer's Regalia"] = "Aspirant Healer's Regalia",
	["Aspirant Sets"] = "Aspirant Sets",
	["Aspirant Spellcaster's Regalia"] = "Aspirant Spellcaster's Regalia",
	["Aspirant's Agile Regalia"] = "Aspirant's Agile Regalia",
	["Aspirant's Strong Regalia"] = "Aspirant's Strong Regalia",
	["Astilos the Hollow"] = "Astilos the Hollow",
	["Astral Armor"] = "Astral Armor",
	Auberdine = "Auberdine",
	["Bag of Candies"] = "Bag of Candies",
	["Baradin Hold"] = "Baradin Hold",
	["Barking Armor"] = "Barking Armor",
	["Basilisk Scale Armor"] = "Basilisk Scale Armor",
	["Battlegear of Might"] = "Battlegear of Might",
	["Battleground Rewards"] = "Battleground Rewards",
	["Battlemage's Regalia"] = "Battlemage's Regalia",
	Bazzalan = "Bazzalan",
	["Beastmaster Armor"] = "Beastmaster Armor",
	["Big Voodoo"] = "Big Voodoo",
	Calypso = "Calypso",
	["Capacitor Armor"] = "Capacitor Armor",
	["Cenarion Rainment"] = "Cenarion Rainment",
	["Centaur Clans"] = "Centaur Clans",
	["Combatant's Agile Regalia"] = "Combatant's Agile Regalia",
	["Combatant's Strong Regalia"] = "Combatant's Strong Regalia",
	["Combatant Fighter"] = "Combatant Fighter",
	["Combatant Healer's Regalia"] = "Combatant Healer's Regalia",
	["Combatant Sets"] = "Combatant Sets",
	["Combatant Spellcaster's Regalia"] = "Combatant Spellcaster's Regalia",
	["Corrupted Ancient"] = "Corrupted Ancient",
	["Dak´mal"] = "Dak´mal",
	["Dark Iron Plate"] = "Dark Iron Plate",
	["Darkmantle Armor"] = "Darkmantle Armor",
	["Darkmoon Decks"] = "Darkmoon Decks",
	["Deathmist Raiment"] = "Deathmist Raiment",
	["Defias Set"] = "Defias Set",
	["Devilsaur Claws"] = "Devilsaur Claws",
	["Divined Vestments"] = "Divined Vestments",
	["Dungeon/Raid"] = "Dungeon/Raid",
	["Eastern Kingdom Rares"] = "Eastern Kingdom Rares",
	["Epoch PVP"] = "Epoch PVP",
	["Epoch Sets"] = "Epoch Sets",
	["Fang Set"] = "Fang Set",
	["Featherheart Raiment"] = "Featherheart Raiment",
	["Felheart Raiment"] = "Felheart Raiment",
	["Felstone Fortress"] = "Felstone Fortress",
	["Feralheart Raiment"] = "Feralheart Raiment",
	["Foreman Sprocket"] = "Foreman Sprocket",
	["Giantstalker Armor"] = "Giantstalker Armor",
	["Gladiator Set"] = "Gladiator Set",
	Glagut = "Glagut",
	["Glittermurk Mine"] = "Glittermurk Mine",
	Gnash = "Gnash",
	Gonzor = "Gonzor",
	["Grubbis&Chomper"] = "Grubbis&Chomper",
	Hamhock = "Hamhock",
	["Holyforge Armor"] = "Holyforge Armor",
	["Honorable Fighter"] = "Honorable Fighter",
	["Honorable Sets"] = "Honorable Sets",
	["Ironweave Set"] = "Ironweave Set",
	["Kalimdor Rares"] = "Kalimdor Rares",
	["King Gnok"] = "King Gnok",
	["Korut the Mournful"] = "Korut the Mournful",
	Krakken = "Krakken",
	["Lava Leather"] = "Lava Leather",
	["Lawbringer Armor"] = "Lawbringer Armor",
	["Level 55"] = "Level 55",
	["Level 60"] = "Level 60",
	["Millhouse Manastorm"] = "Millhouse Manastorm",
	["Miner Davod"] = "Miner Davod",
	["Misc. Vendor"] = "Misc. Vendor",
	["Misc Dungeon Sets"] = "Misc Dungeon Sets",
	Morrumus = "Morrumus",
	["Mount Drops"] = "Mount Drops",
	Muggugaj = "Muggugaj",
	Murklurk = "Murklurk",
	Nazrasash = "Nazrasash",
	["New Dungeon"] = "New Dungeon",
	["New unsorted Sets"] = "New unsorted Sets",
	["Nightslayer Armor"] = "Nightslayer Armor",
	Nyx = "Nyx",
	["Pirate Lord Blackstone"] = "Pirate Lord Blackstone",
	["Plated Battlegear"] = "Plated Battlegear",
	["Postmaster Set"] = "Postmaster Set",
	["Praise of the Moon"] = "Praise of the Moon",
	Prismscale = "Prismscale",
	["PvP Vendor"] = "PvP Vendor",
	["Questrewards of Interest"] = "Questrewards of Interest",
	["Raventusk Tribe"] = "Raventusk Tribe",
	["Random Loot"] = "Random Loot",
	["Ranger Garb"] = "Ranger Garb",
	Rares = "Rares",
	Razor = "Razor",
	Recipes = "Recipes",
	["Righteous Armor"] = "Righteous Armor",
	Rizzo = "Rizzo",
	["Rookie's Agile Regalia"] = "Rookie's Agile Regalia",
	["Rookie's Strong Regalia"] = "Rookie's Strong Regalia",
	["Rookie Fighter"] = "Rookie Fighter",
	["Rookie Sets"] = "Rookie Sets",
	["Rookie Spellcaster's Regalia"] = "Rookie Spellcaster's Regalia",
	["Rune Warder"] = "Rune Warder",
	["Scarlet Set"] = "Scarlet Set",
	Scinti = "Scinti",
	["Scouting Armor"] = "Scouting Armor",
	["Season 1"] = "Season 1",
	Sepulcher = "Sepulcher",
	["Shadowcaster's Regalia"] = "Shadowcaster's Regalia",
	["Shockchain Armor"] = "Shockchain Armor",
	["Silithid Lurker"] = "Silithid Lurker",
	["Skirmish Sets"] = "Skirmish Sets",
	["Skirmisher's Agile Regalia"] = "Skirmisher's Agile Regalia",
	["Skirmisher's Strong Regalia"] = "Skirmisher's Strong Regalia",
	["Skirmisher Fighter"] = "Skirmisher Fighter",
	["Skirmishing Healer's Regalia"] = "Skirmishing Healer's Regalia",
	["Skirmishing Spellcaster's Regalia"] = "Skirmishing Spellcaster's Regalia",
	["Sorcerer's Regalia"] = "Sorcerer's Regalia",
	["Soulflayer Ghruzokh"] = "Soulflayer Ghruzokh",
	["Soulforge Armor"] = "Soulforge Armor",
	["Starsong Follower"] = "Starsong Follower",
	["Steward Graves"] = "Steward Graves",
	["Stonetalon Caverns"] = "Stonetalon Caverns",
	["Supervisor Grimgash"] = "Supervisor Grimgash",
	["The Earthfury"] = "The Earthfury",
	["The Five Thunders"] = "The Five Thunders",
	["The Great Sea"] = "The Great Sea",
	["Tidal Armor"] = "Tidal Armor",
	["Tier 1 Set"] = "Tier 1 Set",
	["Tier Sets"] = "Tier Sets",
	["Treeheart Raiment"] = "Treeheart Raiment",
	["Truthful Armor"] = "Truthful Armor",
	["Turtle Scale Armor"] = "Turtle Scale Armor",
	Unknown = "Unknown",
	["Uldic Plate"] = "Uldic Plate",
	["Uldic Set"] = "Uldic Set",
	["Valor´s Expedition"] = "Valor´s Expedition",
	["Vanta Vestments"] = "Vanta Vestments",
	Vendor = "Vendor",
	["Vestments of Prophecy"] = "Vestments of Prophecy",
	["Vestments of the Pious"] = "Vestments of the Pious",
	["Vestments of the Virtuous"] = "Vestments of the Virtuous",
	["Vigilforge Armor"] = "Vigilforge Armor",
	Volchan = "Volchan",
	["Warbear Wear"] = "Warbear Wear",
	["Weapon Sets"] = "Weapon Sets",
	["World Bosses"] = "World Bosses",
	["World PVP"] = "World PVP",
}


if GAME_LOCALE == "enUS" then
	lib:SetCurrentTranslations(true)
else
	error(("%s: Locale %q not supported"):format(MAJOR_VERSION, GAME_LOCALE))
end
