DROP TABLE IF EXISTS `WorldMapOverlay_vanilla`;
CREATE TABLE `WorldMapOverlay_vanilla` (
`areaID` smallint(3) unsigned NOT NULL,
`zoneID` smallint(3) unsigned NOT NULL,
`texture` varchar(255),
`textureWidth` smallint(3) unsigned NOT NULL,
`textureHeight` smallint(3) unsigned NOT NULL,
`offsetX` smallint(3) unsigned NOT NULL,
`offsetY` smallint(3) unsigned NOT NULL,
`hitRectTop` smallint(3) unsigned NOT NULL,
`hitRectLeft` smallint(3) unsigned NOT NULL,
`hitRectBottom` smallint(3) unsigned NOT NULL,
`hitRectRight` smallint(3) unsigned NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED COMMENT='WorldMapOverlay';

INSERT INTO `WorldMapOverlay_vanilla` VALUES (9, 30, "NORTHSHIREVALLEY", 256, 256, 381, 147, 190, 425, 375, 600);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (18, 30, "CRYSTALLAKE", 225, 220, 422, 332, 380, 450, 475, 605);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (19, 37, "ZULGURUB", 245, 220, 483, 8, 50, 525, 200, 675);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (20, 39, "MOONBROOK", 220, 200, 317, 331, 370, 390, 505, 495);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (35, 37, "BOOTYBAY", 145, 128, 203, 433, 460, 220, 530, 305);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (37, 37, "LAKENAZFERITI", 128, 125, 331, 59, 100, 375, 150, 435);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (42, 34, "DARKSHIRE", 315, 280, 631, 162, 250, 710, 350, 835);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (43, 37, "WILDSHORE", 165, 190, 229, 422, 505, 300, 555, 350);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (57, 30, "FARGODEEPMINE", 256, 240, 238, 428, 510, 300, 615, 470);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (60, 30, "FORESTSEDGE", 256, 341, 124, 327, 445, 200, 645, 300);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (62, 30, "BRACKWELLPUMPKINPATCH", 256, 249, 577, 419, 495, 615, 565, 735);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (68, 36, "LAKEEVERSTILL", 535, 275, 133, 240, 325, 245, 465, 595);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (69, 36, "LAKESHIRE", 340, 195, 83, 197, 250, 165, 330, 345);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (70, 36, "STONEWATCH", 255, 300, 500, 215, 300, 595, 435, 730);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (71, 36, "STONEWATCHFALLS", 320, 210, 595, 320, 405, 655, 490, 840);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (72, 19, "DARKPORTAL", 265, 220, 453, 259, 325, 520, 430, 650);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (73, 19, "THETAINTEDSCAR", 384, 450, 212, 178, 295, 265, 540, 495);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (74, 38, "POOLOFTEARS", 300, 275, 565, 218, 265, 620, 440, 805);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (75, 38, "STONARD", 360, 315, 279, 237, 300, 370, 435, 585);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (76, 38, "FALLOWSANCTUARY", 365, 305, 492, 0, 60, 540, 240, 765);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (86, 30, "STONECAIRNLAKE", 310, 256, 587, 190, 250, 675, 415, 830);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (87, 30, "GOLDSHIRE", 240, 220, 250, 270, 400, 370, 465, 455);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (88, 30, "EASTVALELOGGINGCAMP", 256, 210, 704, 330, 400, 775, 485, 900);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (91, 30, "TOWEROFAZORA", 255, 250, 551, 292, 400, 610, 490, 745);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (93, 34, "VULGOLOGREMOUND", 255, 285, 243, 348, 435, 285, 545, 440);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (94, 34, "RAVENHILL", 195, 145, 102, 302, 340, 155, 410, 260);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (95, 36, "REDRIDGECANYONS", 365, 245, 121, 72, 125, 175, 250, 400);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (97, 36, "ALTHERSMILL", 235, 270, 399, 129, 220, 475, 345, 595);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (99, 37, "REBELCAMP", 170, 90, 284, 0, 20, 335, 55, 415);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (100, 37, "NESINGWARYSEXPEDITION", 140, 110, 269, 26, 60, 305, 115, 380);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (101, 37, "KURZENSCOMPOUND", 155, 150, 388, 0, 35, 415, 90, 495);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (102, 37, "RUINSOFZULKUNDA", 125, 140, 196, 3, 55, 220, 110, 300);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (103, 37, "RUINSOFZULMAMWE", 170, 125, 394, 212, 250, 435, 315, 500);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (104, 37, "THEVILEREEF", 190, 175, 152, 90, 135, 180, 235, 305);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (105, 37, "MOSHOGGOGREMOUND", 128, 175, 432, 94, 160, 455, 240, 535);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (107, 39, "SALDEANSFARM", 225, 210, 459, 105, 180, 505, 255, 605);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (108, 39, "SENTINELHILL", 195, 240, 442, 241, 280, 515, 385, 605);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (109, 39, "FURLBROWSPUMPKINFARM", 210, 215, 387, 11, 100, 465, 185, 555);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (111, 39, "JANGOLODEMINE", 215, 215, 307, 29, 125, 405, 200, 490);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (113, 39, "GOLDCOASTQUARRY", 225, 256, 220, 102, 230, 255, 325, 375);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (115, 39, "WESTFALLLIGHTHOUSE", 280, 190, 205, 467, 530, 260, 620, 380);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (116, 38, "MISTYVALLEY", 245, 305, 0, 140, 190, 50, 290, 215);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (117, 37, "GROMGOLBASECAMP", 110, 105, 260, 132, 160, 285, 205, 350);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (118, 40, "WHELGARSEXCAVATIONSITE", 195, 185, 247, 205, 295, 310, 360, 410);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (121, 34, "TRANQUILGARDENSCEMETARY", 220, 220, 690, 353, 430, 755, 505, 850);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (122, 37, "ZUULDAIARUINS", 115, 115, 156, 42, 80, 190, 120, 235);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (123, 37, "BALALRUINS", 90, 80, 241, 92, 115, 270, 150, 320);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (125, 37, "KALAIRUINS", 95, 95, 299, 88, 120, 320, 160, 370);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (127, 37, "BALIAMAHRUINS", 110, 140, 371, 129, 185, 390, 230, 445);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (128, 37, "ZIATAJAIRUINS", 128, 125, 364, 231, 235, 385, 315, 430);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (129, 37, "MIZJAHRUINS", 105, 110, 311, 131, 180, 350, 215, 390);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (131, 27, "KHARANOS", 200, 200, 386, 294, 515, 445, 390, 555);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (132, 27, "ANVILMAR", 240, 185, 155, 403, 445, 190, 560, 340);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (133, 27, "GNOMERAGON", 180, 165, 166, 184, 215, 205, 295, 280);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (134, 27, "GOLBOLARQUARRY", 165, 165, 608, 291, 340, 640, 430, 735);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (135, 27, "FROSTMANEHOLD", 125, 125, 217, 287, 315, 260, 375, 305);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (136, 27, "THEGRIZZLEDDEN", 200, 185, 314, 311, 350, 380, 425, 440);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (137, 27, "BREWNALLVILLAGE", 115, 115, 252, 249, 275, 280, 340, 330);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (138, 27, "MISTYPINEREFUGE", 128, 165, 502, 221, 245, 545, 325, 605);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (142, 35, "IRONBANDSEXCAVATIONSITE", 345, 256, 482, 321, 380, 625, 495, 765);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (143, 35, "MOGROSHSTRONGHOLD", 315, 235, 542, 48, 105, 620, 230, 800);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (144, 35, "THELSAMAR", 256, 230, 217, 203, 265, 300, 350, 400);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (146, 35, "STONEWROUGHTDAM", 290, 175, 339, 11, 45, 380, 125, 580);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (147, 35, "THEFARSTRIDERLODGE", 370, 295, 546, 199, 380, 790, 460, 875);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (149, 35, "SILVERSTREAMMINE", 235, 270, 229, 11, 90, 290, 200, 400);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (150, 40, "MENETHILHARBOR", 175, 128, 13, 314, 345, 70, 415, 135);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (152, 20, "BULWARK", 230, 205, 698, 362, 380, 770, 550, 905);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (154, 20, "DEATHKNELL", 245, 205, 227, 328, 366, 279, 488, 411);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (156, 20, "SOLLIDENFARMSTEAD", 256, 156, 239, 250, 290, 284, 371, 437);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (157, 20, "AGAMANDMILLS", 256, 210, 335, 139, 183, 384, 303, 522);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (159, 20, "BRILL", 128, 158, 537, 299, 320, 560, 418, 635);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (160, 20, "MONASTARY", 211, 189, 746, 125, 144, 766, 295, 933);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (162, 20, "BRIGHTWATERLAKE", 201, 288, 587, 139, 165, 633, 398, 735);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (164, 20, "GARRENSHAUNT", 174, 220, 497, 145, 182, 531, 328, 627);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (165, 20, "BALNIRFARMSTEAD", 216, 179, 630, 326, 335, 664, 489, 795);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (166, 20, "COLDHEARTHMANOR", 150, 128, 474, 327, 365, 502, 436, 575);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (167, 20, "CRUSADEROUTPOST", 173, 128, 694, 289, 292, 708, 395, 853);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (172, 21, "FENRISISLE", 250, 215, 593, 74, 125, 625, 260, 815);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (186, 41, "DOLANAAR", 190, 128, 462, 323, 340, 495, 420, 610);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (188, 41, "SHADOWGLEN", 225, 225, 491, 153, 205, 535, 330, 660);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (190, 22, "HEARTHGLEN", 340, 288, 307, 16, 55, 365, 185, 580);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (192, 22, "NORTHRIDGELUMBERCAMP", 220, 180, 382, 164, 195, 425, 290, 525);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (193, 22, "RUINSOFANDORHOL", 285, 230, 260, 355, 420, 380, 505, 495);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (197, 22, "SORROWHILL", 300, 206, 355, 462, 485, 470, 575, 565);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (198, 22, "THEWEEPINGCAVE", 160, 200, 566, 198, 240, 615, 325, 690);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (199, 22, "FELSTONEFIELD", 160, 125, 300, 311, 340, 335, 405, 415);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (200, 22, "DALSONSTEARS", 220, 150, 381, 265, 315, 420, 390, 510);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (201, 22, "GAHRRONSWITHERING", 180, 205, 520, 250, 345, 580, 420, 680);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (202, 22, "THEWRITHINGHAUNT", 170, 190, 451, 323, 405, 500, 470, 570);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (204, 21, "PYREWOODVILLAGE", 140, 125, 391, 446, 465, 410, 520, 490);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (205, 40, "DUNMODR", 205, 180, 401, 21, 80, 445, 145, 545);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (211, 27, "ICEFLOWLAKE", 128, 180, 281, 167, 195, 315, 320, 385);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (212, 27, "HELMSBEDLAKE", 155, 170, 694, 273, 315, 730, 410, 810);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (213, 21, "DEEPELEMMINE", 160, 170, 470, 261, 285, 530, 360, 595);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (219, 39, "ALEXSTONFARMSTEAD", 305, 210, 204, 260, 295, 325, 405, 440);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (220, 9, "REDCLOUDMESA", 470, 243, 270, 425, 480, 340, 625, 560);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (222, 9, "BLOODHOOFVILLAGE", 256, 200, 367, 303, 345, 415, 445, 535);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (224, 9, "RAVAGEDCARAVAN", 128, 120, 473, 260, 285, 505, 345, 585);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (225, 9, "REDROCKS", 205, 230, 502, 16, 75, 555, 195, 670);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (226, 21, "THESKITTERINGDARK", 185, 165, 286, 37, 70, 325, 140, 425);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (228, 21, "THESEPULCHER", 210, 160, 352, 168, 240, 405, 305, 490);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (229, 21, "OLSENSFARTHING", 165, 185, 382, 252, 330, 430, 390, 510);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (230, 21, "THEGREYMANEWALL", 210, 215, 379, 447, 530, 420, 620, 510);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (231, 21, "BERENSPERIL", 240, 180, 491, 417, 450, 550, 515, 630);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (233, 21, "AMBERMILL", 240, 240, 494, 262, 370, 580, 470, 690);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (236, 21, "SHADOWFANGKEEP", 220, 160, 364, 359, 410, 390, 475, 495);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (237, 21, "THEDECREPITFERRY", 180, 185, 457, 144, 205, 510, 280, 600);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (238, 21, "MALDENSORCHARD", 256, 160, 465, 0, 50, 535, 90, 600);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (240, 21, "THEDEADFIELD", 175, 165, 402, 65, 115, 430, 175, 500);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (241, 34, "THEROTTINGORCHARD", 250, 230, 539, 369, 430, 580, 545, 705);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (242, 34, "BRIGHTWOODGROVE", 220, 340, 504, 117, 165, 570, 380, 685);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (245, 34, "THEYORGENFARMSTEAD", 235, 250, 390, 382, 440, 445, 540, 540);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (246, 28, "THECAULDRON", 425, 325, 250, 170, 260, 315, 400, 610);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (247, 28, "GRIMSILTDIGSITE", 305, 220, 494, 300, 345, 560, 440, 740);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (249, 29, "DREADMAULROCK", 220, 225, 707, 168, 205, 745, 350, 885);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (250, 29, "RUINSOFTHAURISSAN", 270, 285, 513, 99, 145, 550, 315, 755);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (252, 29, "BLACKROCKSTRONGHOLD", 245, 265, 334, 114, 160, 370, 310, 505);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (253, 29, "PILLAROFASH", 320, 270, 377, 285, 325, 415, 430, 590);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (254, 29, "BLACKROCKMOUNTAIN", 256, 280, 173, 101, 145, 220, 280, 380);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (255, 29, "ALTAROFSTORMS", 225, 220, 36, 109, 150, 100, 280, 215);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (259, 41, "LAKEALAMETH", 256, 185, 436, 380, 425, 495, 525, 660);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (260, 41, "STARBREEZEVILLAGE", 200, 200, 561, 292, 345, 605, 425, 710);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (261, 41, "GNARLPINEHOLD", 185, 128, 368, 443, 465, 400, 535, 480);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (264, 41, "THEORACLEGLADE", 170, 240, 272, 127, 170, 350, 315, 410);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (266, 41, "WELLSPRINGLAKE", 180, 256, 377, 93, 165, 415, 310, 525);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (271, 24, "SOUTHSHORE", 235, 270, 418, 201, 310, 445, 430, 550);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (272, 24, "TARRENMILL", 220, 310, 509, 0, 100, 545, 245, 680);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (275, 24, "DURNHOLDEKEEP", 384, 365, 605, 75, 220, 705, 325, 835);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (278, 15, "LORDAMEREINTERNMENTCAMP", 330, 265, 44, 403, 525, 160, 610, 250);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (279, 15, "DALARAN", 300, 300, 26, 262, 360, 75, 520, 230);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (280, 15, "STRAHNBRAD", 370, 300, 549, 105, 255, 570, 350, 700);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (281, 15, "RUINSOFALTERAC", 255, 255, 270, 197, 295, 330, 420, 470);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (282, 15, "CRUSHRIDGEHOLD", 280, 240, 334, 162, 215, 435, 345, 535);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (284, 15, "THEUPLANDS", 235, 200, 462, 77, 120, 500, 245, 630);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (285, 24, "SOUTHPOINTTOWER", 288, 225, 2, 192, 245, 75, 370, 235);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (286, 24, "HILLSBRADFIELDS", 305, 275, 198, 155, 200, 250, 400, 450);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (288, 24, "AZURELOADMINE", 165, 200, 175, 275, 345, 215, 420, 310);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (289, 24, "NETHANDERSTEAD", 215, 240, 541, 236, 290, 580, 450, 700);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (290, 24, "DUNGAROK", 240, 275, 637, 294, 405, 675, 550, 770);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (294, 24, "EASTERNSTRAND", 230, 320, 524, 339, 440, 550, 555, 690);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (295, 24, "WESTERNSTRAND", 285, 155, 208, 368, 415, 240, 495, 475);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (297, 37, "JAGUEROISLE", 125, 120, 314, 493, 510, 350, 590, 430);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (300, 38, "MISTYREEDSTRAND", 256, 668, 746, 0, 75, 815, 630, 955);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (307, 26, "THEOVERLOOKCLIFFS", 170, 310, 693, 303, 350, 755, 570, 835);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (309, 40, "IRONBEARDSTOMB", 200, 185, 349, 115, 150, 385, 265, 510);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (310, 37, "CRYSTALVEINMINE", 120, 120, 345, 276, 310, 380, 365, 440);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (311, 37, "RUINSOFABORAZ", 95, 95, 350, 335, 375, 375, 415, 420);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (313, 16, "NORTHFOLDMANOR", 230, 240, 192, 90, 150, 275, 270, 360);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (314, 16, "GOSHEKFARM", 230, 195, 531, 276, 340, 575, 415, 655);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (315, 16, "DABYRIESFARMSTEAD", 180, 210, 472, 165, 230, 505, 300, 600);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (316, 16, "BOULDERFISTHALL", 215, 235, 432, 362, 425, 475, 560, 610);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (317, 16, "WITHERBARKVILLAGE", 215, 210, 559, 333, 410, 595, 485, 740);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (320, 16, "REFUGEPOINT", 175, 225, 370, 186, 260, 420, 370, 500);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (321, 16, "HAMMERFALL", 205, 250, 655, 120, 190, 690, 300, 815);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (324, 16, "STROMGARDEKEEP", 240, 230, 108, 287, 340, 140, 490, 315);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (327, 16, "FALDIRSCOVE", 256, 215, 171, 424, 475, 215, 590, 405);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (333, 16, "CIRCLEOFEASTBINDING", 160, 230, 558, 112, 175, 595, 280, 680);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (334, 16, "CIRCLEOFWESTBINDING", 190, 210, 138, 54, 110, 170, 230, 275);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (335, 16, "CIRCLEOFINNERBINDING", 210, 185, 286, 310, 365, 315, 460, 420);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (336, 16, "CIRCLEOFOUTERBINDING", 170, 155, 419, 293, 320, 485, 385, 570);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (337, 17, "APOCRYPHANSREST", 255, 205, 17, 310, 360, 100, 465, 215);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (338, 17, "ANGORFORTRESS", 195, 200, 325, 148, 170, 360, 275, 500);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (339, 17, "LETHLORRAVINE", 370, 455, 611, 110, 225, 685, 455, 885);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (340, 17, "KARGATH", 240, 255, 0, 148, 265, 10, 370, 165);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (341, 17, "CAMPKOSH", 220, 220, 551, 48, 100, 600, 200, 725);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (342, 17, "CAMPBOFF", 255, 280, 501, 341, 400, 545, 570, 685);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (344, 17, "CAMPCAGG", 255, 220, 12, 428, 475, 40, 615, 225);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (345, 17, "AGMONDSEND", 265, 270, 345, 389, 420, 400, 570, 545);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (346, 17, "HAMMERTOESDIGSITE", 200, 195, 445, 120, 190, 500, 295, 635);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (348, 26, "AERIEPEAK", 255, 205, 13, 245, 285, 85, 390, 210);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (350, 26, "QUELDANILLODGE", 185, 195, 237, 185, 225, 255, 350, 375);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (351, 26, "SKULKROCK", 160, 145, 512, 232, 250, 550, 325, 635);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (353, 26, "SHADRAALOR", 195, 185, 240, 387, 430, 295, 525, 400);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (354, 26, "JINTHAALOR", 235, 285, 505, 333, 360, 550, 570, 700);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (355, 26, "THEALTAROFZUL", 200, 165, 373, 365, 405, 440, 480, 535);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (356, 26, "SERADANE", 275, 275, 509, 19, 90, 560, 250, 725);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (359, 11, "BAELMODAN", 128, 128, 431, 479, 530, 450, 590, 505);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (360, 9, "THEVENTURECOMINE", 225, 235, 532, 238, 280, 585, 390, 650);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (362, 4, "RAZORHILL", 220, 230, 432, 170, 245, 500, 325, 595);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (363, 4, "VALLEYOFTRIALS", 215, 215, 355, 320, 395, 395, 500, 495);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (366, 4, "KOLKARCRAG", 160, 120, 413, 476, 500, 460, 560, 520);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (367, 4, "SENJINVILLAGE", 160, 190, 474, 384, 450, 525, 525, 600);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (368, 4, "ECHOISLES", 200, 240, 549, 427, 470, 600, 660, 710);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (369, 4, "THUNDERRIDGE", 190, 200, 327, 60, 105, 355, 220, 460);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (370, 4, "DRYGULCHRAVINE", 210, 160, 427, 78, 120, 475, 210, 575);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (372, 4, "TIRAGARDEKEEP", 190, 180, 462, 286, 325, 535, 425, 620);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (378, 11, "CAMPTAURAJO", 145, 125, 365, 350, 380, 425, 435, 490);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (379, 11, "FARWATCHPOST", 100, 165, 564, 52, 115, 590, 170, 635);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (380, 11, "THECROSSROADS", 155, 155, 431, 118, 165, 485, 215, 550);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (381, 11, "BOULDERLODEMINE", 120, 110, 555, 0, 10, 595, 80, 645);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (382, 11, "THESLUDGEFEN", 170, 120, 456, 0, 20, 505, 80, 605);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (383, 11, "THEDRYHILLS", 200, 145, 317, 29, 60, 350, 135, 445);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (384, 11, "DREADMISTPEAK", 128, 105, 419, 63, 95, 450, 150, 520);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (385, 11, "NORTHWATCHFOLD", 150, 120, 527, 307, 340, 575, 400, 650);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (386, 11, "THEFORGOTTENPOOLS", 120, 125, 384, 115, 125, 420, 190, 490);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (387, 11, "LUSHWATEROASIS", 175, 185, 365, 177, 225, 435, 295, 500);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (388, 11, "THESTAGNANTOASIS", 155, 128, 481, 211, 255, 530, 315, 585);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (390, 11, "FIELDOFGIANTS", 210, 150, 355, 402, 445, 425, 500, 500);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (391, 11, "THEMERCHANTCOAST", 95, 100, 581, 247, 270, 615, 335, 660);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (392, 11, "RATCHET", 125, 125, 556, 189, 225, 600, 275, 655);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (396, 9, "WINTERHOOFWATERWELL", 170, 128, 458, 369, 410, 505, 470, 580);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (397, 9, "THUNDERHORNWATERWELL", 128, 155, 379, 242, 270, 415, 340, 480);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (398, 9, "WILDMANEWATERWELL", 185, 128, 291, 0, 50, 330, 115, 460);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (404, 9, "BAELDUNDIGSITE", 210, 180, 255, 214, 260, 290, 360, 385);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (413, 43, "MAESTRASPOST", 215, 305, 205, 38, 90, 250, 255, 335);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (414, 43, "THEZORAMSTRAND", 245, 245, 19, 28, 60, 45, 235, 215);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (415, 43, "ASTRANAAR", 205, 185, 272, 251, 295, 310, 395, 435);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (416, 43, "THESHRINEOFAESSINA", 220, 195, 104, 259, 305, 175, 400, 270);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (417, 43, "FIRESCARSHRINE", 165, 175, 189, 324, 390, 235, 460, 300);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (418, 43, "THERUINSOFSTARDUST", 155, 150, 260, 373, 405, 295, 495, 375);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (419, 43, "THEHOWLINGVALE", 210, 185, 463, 141, 200, 500, 295, 625);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (421, 43, "MYSTRALLAKE", 275, 240, 356, 347, 430, 420, 550, 570);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (422, 43, "FALLENSKYLAKE", 235, 205, 547, 426, 505, 635, 590, 750);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (424, 43, "IRISLAKE", 200, 205, 392, 218, 275, 430, 350, 500);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (426, 43, "RAYNEWOODRETREAT", 180, 245, 520, 238, 305, 560, 385, 660);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (428, 43, "NIGHTRUN", 225, 255, 597, 258, 340, 660, 450, 775);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (430, 43, "SATYRNAAR", 285, 185, 694, 225, 290, 750, 355, 890);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (434, 43, "FELFIREHILL", 245, 255, 713, 344, 465, 750, 570, 915);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (437, 43, "WARSONGLUMBERCAMP", 200, 160, 796, 311, 355, 855, 435, 970);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (438, 43, "BOUGHSHADOW", 146, 200, 856, 151, 200, 895, 285, 985);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (439, 61, "THESHIMMERINGFLATS", 320, 365, 610, 300, 325, 660, 650, 910);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (441, 43, "LAKEFALATHIM", 128, 195, 131, 137, 230, 175, 310, 235);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (442, 42, "AUBERDINE", 150, 215, 318, 162, 255, 355, 330, 430);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (443, 42, "RUINSOFMATHYSTRA", 195, 215, 510, 0, 60, 555, 160, 620);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (444, 42, "TOWEROFALTHALAXX", 170, 195, 468, 85, 145, 520, 205, 610);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (446, 42, "BASHALARAN", 180, 195, 365, 181, 215, 415, 270, 485);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (447, 42, "AMETHARAN", 190, 205, 324, 306, 350, 395, 420, 460);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (448, 42, "GROVEOFTHEANCIENTS", 200, 170, 305, 412, 475, 385, 555, 475);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (449, 42, "THEMASTERSGLAIVE", 175, 158, 329, 510, 555, 370, 630, 460);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (450, 42, "REMTRAVELSEXCAVATION", 175, 183, 229, 485, 540, 320, 600, 380);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (456, 42, "CLIFFSPRINGRIVER", 230, 190, 375, 94, 190, 485, 255, 590);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (459, 20, "SCARLETWATCHPOST", 175, 247, 689, 104, 114, 740, 325, 820);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (460, 81, "SUNROCKRETREAT", 150, 150, 389, 320, 345, 410, 435, 520);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (461, 81, "WINDSHEARCRAG", 320, 275, 553, 197, 240, 570, 435, 830);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (464, 81, "MIRKFALLONLAKE", 200, 215, 390, 145, 220, 425, 325, 560);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (465, 81, "THECHARREDVALE", 230, 355, 210, 234, 375, 245, 520, 395);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (467, 81, "STONETALONPEAK", 270, 205, 247, 0, 30, 270, 150, 475);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (477, 37, "RUINSOFJUBUWAL", 110, 110, 306, 301, 325, 335, 365, 380);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (478, 41, "POOLSOFARLITHRIEN", 128, 190, 335, 313, 380, 375, 470, 435);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (480, 61, "CAMPETHOK", 305, 310, 0, 0, 40, 65, 195, 260);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (481, 61, "SPLITHOOFCRAG", 210, 195, 391, 192, 225, 400, 325, 560);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (482, 61, "HIGHPERCH", 190, 190, 31, 155, 150, 70, 305, 200);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (483, 61, "THESCREECHINGCANYON", 250, 240, 179, 200, 235, 225, 400, 390);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (484, 61, "FREEWINDPOST", 210, 190, 357, 264, 300, 400, 405, 525);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (485, 61, "THEGREATLIFT", 210, 180, 205, 70, 115, 275, 185, 370);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (492, 34, "RAVENHILLCEMETARY", 350, 300, 85, 149, 210, 145, 350, 260);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (496, 141, "BRACKENWALLVILLAGE", 280, 270, 230, 0, 70, 305, 235, 435);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (502, 141, "WITCHHILL", 250, 315, 422, 0, 60, 445, 245, 635);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (509, 141, "THEDENOFFLAME", 255, 250, 257, 313, 345, 315, 475, 425);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (511, 141, "THEWYRMBOG", 285, 240, 367, 381, 435, 440, 570, 615);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (513, 141, "THERAMOREISLE", 230, 205, 534, 224, 280, 615, 405, 750);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (536, 34, "ADDLESSTEAD", 275, 250, 55, 342, 415, 160, 510, 275);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (537, 201, "FIREPLUMERIDGE", 295, 270, 367, 178, 250, 415, 415, 595);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (538, 201, "LAKKARITARPITS", 570, 265, 160, 6, 25, 355, 250, 660);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (539, 201, "TERRORRUN", 345, 285, 158, 368, 415, 300, 575, 445);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (540, 201, "THESLITHERINGSCAR", 345, 285, 367, 380, 470, 440, 600, 595);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (543, 201, "GOLAKKAHOTSPRINGS", 315, 345, 121, 151, 235, 215, 435, 390);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (556, 35, "THELOCH", 320, 410, 352, 87, 115, 405, 450, 600);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (596, 101, "KODOGRAVEYARD", 275, 250, 387, 244, 325, 435, 450, 580);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (599, 101, "THUNDERAXEFORTRESS", 190, 220, 447, 102, 150, 490, 225, 600);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (602, 101, "MANNOROCCOVEN", 285, 280, 399, 380, 470, 455, 590, 615);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (603, 101, "SARGERON", 285, 245, 625, 33, 95, 695, 210, 825);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (604, 101, "MAGRAMVILLAGE", 205, 285, 590, 365, 425, 650, 550, 775);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (606, 101, "GELKISVILLAGE", 195, 242, 293, 426, 540, 320, 650, 450);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (607, 101, "VALLEYOFSPEARS", 245, 285, 212, 215, 255, 250, 440, 415);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (608, 101, "NIJELSPOINT", 200, 250, 554, 0, 25, 600, 100, 700);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (609, 101, "KOLKARVILLAGE", 220, 220, 607, 215, 275, 695, 375, 795);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (656, 241, "LAKEELUNEARA", 555, 510, 244, 89, 235, 365, 495, 650);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (657, 38, "THEHARBORAGE", 235, 205, 171, 145, 190, 215, 290, 340);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (702, 41, "RUTTHERANVILLAGE", 128, 100, 494, 548, 600, 550, 615, 565);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (736, 41, "BANETHILHOLLOW", 160, 210, 382, 281, 305, 420, 460, 510);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (797, 30, "JERODSLANDING", 256, 237, 425, 431, 495, 460, 615, 615);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (798, 30, "RIDGEPOINTTOWER", 306, 233, 696, 435, 505, 790, 570, 915);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (799, 34, "THEDARKENEDBANK", 910, 210, 89, 31, 85, 125, 200, 970);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (800, 27, "COLDRIDGEPASS", 150, 128, 295, 385, 420, 320, 490, 380);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (801, 27, "CHILLBREEZEVALLEY", 180, 128, 274, 296, 320, 320, 390, 400);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (802, 27, "SHIMMERRIDGE", 128, 190, 347, 163, 220, 380, 315, 440);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (803, 27, "AMBERSTILLRANCH", 128, 128, 573, 280, 315, 605, 360, 665);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (804, 27, "THETUNDRIDHILLS", 155, 128, 522, 322, 355, 555, 410, 645);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (806, 27, "SOUTHERNGATEOUTPOST", 128, 120, 792, 279, 305, 825, 375, 885);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (808, 27, "NORTHERNGATEOUTPOST", 128, 165, 759, 173, 205, 800, 300, 860);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (809, 27, "IRONFORGE", 315, 200, 397, 163, 205, 440, 295, 550);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (810, 20, "STILLWATERPOND", 186, 128, 395, 277, 307, 429, 378, 532);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (811, 20, "NIGHTMAREVALE", 243, 199, 363, 349, 396, 401, 490, 547);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (812, 20, "VENOMWEBVALE", 237, 214, 757, 205, 240, 777, 408, 970);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (813, 22, "THEBULWARK", 225, 185, 137, 293, 350, 205, 425, 325);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (816, 4, "RAZORMANEGROUNDS", 230, 230, 301, 189, 230, 350, 350, 475);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (817, 4, "SKULLROCK", 128, 110, 464, 33, 55, 500, 105, 575);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (818, 9, "PALEMANEROCK", 128, 205, 303, 307, 355, 330, 475, 400);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (819, 9, "WINDFURYRIDGE", 205, 128, 395, 0, 45, 450, 115, 555);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (820, 9, "THEGOLDENPLAINS", 215, 240, 428, 80, 120, 485, 280, 575);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (821, 9, "THEROLLINGPLAINS", 256, 190, 523, 356, 410, 575, 495, 685);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (838, 35, "NORTHGATEPASS", 230, 300, 125, 12, 45, 160, 160, 290);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (856, 34, "TWILIGHTGROVE", 360, 420, 298, 79, 145, 370, 395, 585);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (880, 16, "THANDOLSPAN", 200, 220, 355, 412, 485, 400, 625, 520);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (896, 24, "PURGATIONISLE", 125, 100, 109, 482, 480, 110, 585, 235);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (916, 39, "THEJANSENSTEAD", 165, 200, 488, 0, 75, 520, 160, 615);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (917, 39, "THEDEADACRE", 200, 240, 524, 252, 370, 575, 450, 675);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (918, 39, "THEMOLSENFARM", 225, 205, 328, 148, 200, 395, 285, 505);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (920, 39, "THEDAGGERHILLS", 256, 175, 339, 418, 490, 380, 565, 560);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (921, 39, "DEMONTSPLACE", 200, 185, 208, 375, 420, 260, 510, 365);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (922, 39, "THEDUSTPLAINS", 288, 235, 523, 377, 450, 560, 520, 710);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (923, 35, "STONESPLINTERVALLEY", 255, 285, 215, 348, 430, 275, 610, 425);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (924, 35, "VALLEYOFKINGS", 195, 250, 109, 370, 400, 150, 585, 260);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (927, 21, "THESHININGSTRAND", 256, 220, 459, 13, 115, 510, 190, 575);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (928, 21, "NORTHTIDESHOLLOW", 180, 128, 323, 128, 160, 365, 220, 445);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (936, 35, "GRIZZLEPAWRIDGE", 295, 358, 309, 310, 395, 395, 525, 510);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (976, 161, "GADGETZAN", 175, 165, 421, 91, 140, 460, 225, 565);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (977, 161, "STEAMWHEEDLEPORT", 155, 150, 592, 75, 110, 630, 175, 710);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (978, 161, "ZULFARRAK", 210, 175, 254, 0, 25, 300, 145, 450);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (979, 161, "SANDSORROWWATCH", 195, 175, 299, 100, 155, 365, 225, 435);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (980, 161, "THISTLESHRUBVALLEY", 185, 250, 203, 286, 360, 245, 475, 370);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (981, 161, "THEGAPINGCHASM", 220, 210, 449, 372, 415, 490, 530, 600);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (982, 161, "THENOXIOUSLAIR", 180, 200, 252, 199, 255, 310, 355, 385);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (983, 161, "DUNEMAULCOMPOUND", 205, 145, 325, 289, 335, 380, 415, 460);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (984, 161, "EASTMOONRUINS", 160, 150, 395, 346, 410, 435, 460, 500);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (985, 161, "WATERSPRINGFIELD", 165, 180, 509, 168, 210, 550, 295, 645);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (986, 161, "ZALASHJISDEN", 110, 140, 611, 147, 190, 640, 255, 700);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (987, 161, "LANDSENDBEACH", 205, 157, 445, 511, 565, 480, 660, 620);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (990, 161, "VALLEYOFTHEWATCHERS", 150, 160, 291, 434, 490, 330, 585, 410);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (992, 161, "SOUTHMOONRUINS", 195, 210, 323, 359, 445, 365, 510, 440);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (996, 36, "RENDERSCAMP", 275, 256, 277, 0, 25, 305, 200, 500);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (997, 36, "RENDERSVALLEY", 465, 255, 484, 361, 470, 535, 570, 930);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1000, 36, "GALARDELLVALLEY", 250, 250, 654, 161, 195, 700, 375, 865);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1001, 36, "LAKERIDGEHIGHWAY", 430, 290, 187, 333, 445, 220, 535, 545);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1002, 36, "THREECORNERS", 365, 350, 0, 284, 375, 95, 550, 275);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1016, 40, "DIREFORGEHILL", 256, 250, 507, 115, 150, 550, 285, 665);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1017, 40, "RAPTORRIDGE", 190, 160, 628, 176, 210, 665, 300, 780);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1018, 40, "BLACKCHANNELMARSH", 240, 175, 77, 245, 285, 125, 370, 275);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1020, 40, "MOSSHIDEFEN", 205, 245, 527, 264, 305, 565, 425, 675);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1021, 40, "THELGANROCK", 230, 190, 470, 371, 405, 505, 515, 625);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1022, 40, "BLUEGILLMARSH", 225, 190, 89, 142, 205, 120, 280, 265);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1023, 40, "SALTSPRAYGLEN", 200, 240, 237, 41, 95, 275, 230, 410);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1024, 40, "SUNDOWNMARSH", 300, 240, 92, 82, 140, 140, 240, 325);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1025, 40, "THEGREENBELT", 185, 240, 456, 125, 170, 485, 320, 590);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1036, 40, "ANGERFANGENCAMPMENT", 225, 185, 347, 218, 270, 400, 375, 550);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1038, 40, "GRIMBATOL", 350, 360, 611, 230, 280, 710, 570, 930);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1056, 24, "DARROWHILL", 205, 155, 414, 154, 190, 435, 260, 585);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1076, 81, "WEBWINDERPATH", 288, 355, 457, 282, 315, 500, 600, 710);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1097, 34, "THEHUSHEDBANK", 160, 330, 19, 132, 191, 56, 403, 145);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1098, 34, "MANORMISTMANTLE", 200, 175, 653, 120, 195, 695, 255, 795);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1099, 121, "CAMPMOJACHE", 155, 160, 689, 233, 250, 715, 315, 795);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1100, 121, "GRIMTOTEMCOMPOUND", 120, 195, 623, 167, 220, 650, 320, 710);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1101, 121, "THEWRITHINGDEEP", 240, 220, 618, 298, 340, 645, 475, 815);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1103, 121, "GORDUNNIOUTPOST", 140, 165, 690, 141, 175, 725, 240, 825);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1105, 121, "FERALSCARVALE", 115, 115, 486, 329, 350, 510, 410, 580);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1106, 121, "FRAYFEATHERHIGHLANDS", 110, 170, 478, 386, 415, 505, 535, 570);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1108, 121, "THEFORGOTTENCOAST", 145, 320, 404, 256, 275, 430, 555, 500);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1111, 121, "DREAMBOUGH", 150, 125, 454, 0, 40, 490, 95, 540);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1113, 121, "ONEIROS", 110, 110, 493, 70, 95, 520, 130, 575);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1114, 121, "RUINSOFRAVENWIND", 190, 155, 305, 0, 45, 360, 100, 435);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1119, 121, "THETWINCOLOSSALS", 285, 245, 319, 75, 100, 395, 240, 550);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1120, 121, "SARDORISLE", 180, 180, 208, 234, 280, 235, 390, 370);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1121, 121, "ISLEOFDREAD", 215, 293, 192, 375, 410, 225, 645, 370);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1137, 121, "LOWERWILDS", 225, 180, 751, 198, 240, 800, 335, 925);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1216, 181, "TIMBERMAWHOLD", 235, 270, 250, 106, 170, 320, 275, 425);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1219, 181, "LEGASHENCAMPMENT", 235, 140, 478, 44, 90, 495, 150, 665);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1220, 181, "THALASSIANBASECAMP", 240, 155, 499, 119, 160, 535, 225, 685);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1221, 181, "RUINSOFELDARATH", 265, 280, 238, 221, 310, 305, 415, 430);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1225, 181, "URSOLAN", 145, 215, 422, 95, 150, 430, 230, 510);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1226, 181, "TEMPLEOFARKKORAN", 190, 200, 681, 153, 225, 715, 325, 820);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1227, 181, "BAYOFSTORMS", 270, 300, 479, 201, 255, 505, 475, 675);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1228, 181, "THESHATTEREDSTRAND", 160, 210, 404, 194, 245, 430, 370, 485);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1229, 181, "TOWEROFELDARA", 120, 155, 818, 107, 160, 850, 245, 920);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1230, 181, "JAGGEDREEF", 570, 170, 366, 0, 35, 400, 115, 880);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1231, 181, "SOUTHRIDGEBEACH", 370, 220, 389, 353, 420, 440, 540, 730);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1232, 181, "RAVENCRESTMONUMENT", 240, 125, 552, 499, 535, 660, 600, 755);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1233, 181, "FORLORNRIDGE", 220, 255, 191, 369, 425, 220, 530, 370);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1234, 181, "LAKEMENNAR", 315, 200, 296, 429, 490, 375, 580, 490);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1235, 181, "SHADOWSONGSHRINE", 225, 180, 35, 422, 455, 125, 545, 225);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1236, 181, "HALDARRENCAMPMENT", 200, 150, 77, 331, 370, 165, 435, 250);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1237, 181, "VALORMOK", 215, 175, 84, 229, 310, 165, 365, 265);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1256, 181, "THERUINEDREACHES", 395, 128, 396, 540, 580, 440, 645, 725);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1316, 11, "RAZORFENDOWNS", 155, 115, 407, 553, 580, 445, 645, 535);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1336, 161, "LOSTRIGGERCOVE", 160, 190, 629, 220, 255, 675, 375, 760);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1357, 15, "GALLOWSCORNER", 200, 200, 406, 279, 355, 460, 430, 545);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1437, 19, "DREADMAULHOLD", 195, 180, 361, 15, 65, 385, 125, 480);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1438, 19, "NETHERGARDEKEEP", 185, 190, 559, 30, 85, 595, 160, 695);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1439, 19, "DREADMAULPOST", 245, 195, 361, 195, 255, 450, 335, 560);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1440, 19, "SERPENTSCOIL", 225, 170, 501, 140, 190, 575, 255, 685);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1441, 19, "ALTAROFSTORMS", 185, 155, 310, 133, 180, 365, 245, 430);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1442, 28, "FIREWATCHRIDGE", 405, 430, 85, 30, 130, 160, 320, 400);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1444, 28, "THESEAOFCINDERS", 360, 280, 247, 388, 460, 330, 665, 570);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1457, 19, "GARRISONARMORY", 170, 200, 472, 9, 65, 520, 120, 600);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1497, 20, "RUINSOFLORDAERON", 315, 235, 463, 361, 406, 547, 551, 693);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1519, 30, "STORMWIND", 485, 405, 0, 0, 120, 115, 355, 370);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1637, 4, "ORGRIMMAR", 445, 160, 244, 0, 10, 355, 60, 585);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1638, 9, "THUNDERBLUFF", 280, 240, 249, 59, 105, 295, 265, 480);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1657, 41, "DARNASSUS", 315, 256, 101, 247, 290, 200, 480, 350);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1677, 15, "GAVINSNAZE", 160, 175, 225, 478, 525, 270, 620, 345);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1678, 15, "SOFERASNAZE", 255, 320, 462, 307, 415, 540, 505, 630);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1679, 15, "CORRAHNSDAGGER", 195, 288, 399, 380, 495, 435, 625, 530);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1680, 15, "THEHEADLAND", 165, 197, 314, 471, 545, 345, 660, 435);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1681, 15, "MISTYSHORE", 220, 280, 196, 131, 190, 220, 315, 345);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1682, 15, "DANDREDSFOLD", 285, 230, 276, 0, 70, 370, 160, 440);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1683, 15, "GROWLESSCAVE", 190, 170, 317, 372, 420, 345, 505, 450);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1684, 15, "CHILLWINDPOINT", 350, 370, 626, 253, 330, 730, 560, 915);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1697, 11, "RAPTORGROUNDS", 115, 110, 507, 294, 320, 530, 365, 590);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1698, 11, "BRAMBLESCAR", 125, 165, 442, 298, 355, 485, 425, 530);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1699, 11, "THORNHILL", 140, 128, 498, 119, 165, 540, 215, 600);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1700, 11, "AGAMAGOR", 200, 185, 340, 234, 275, 390, 370, 475);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1701, 11, "BLACKTHORNRIDGE", 155, 128, 335, 462, 490, 385, 565, 450);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1702, 11, "HONORSSTAND", 128, 128, 306, 130, 155, 335, 225, 415);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1703, 11, "THEMORSHANRAMPART", 128, 100, 412, 0, 15, 440, 75, 520);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1704, 11, "GROLDOMFARM", 125, 115, 492, 63, 105, 530, 150, 585);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1717, 11, "RAZORFENKRAUL", 128, 128, 341, 537, 555, 370, 625, 450);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1737, 37, "MISTVALEVALLEY", 125, 125, 280, 368, 395, 320, 465, 355);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1738, 37, "NEKMANIWELLSPRING", 90, 115, 211, 359, 385, 230, 450, 285);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1739, 37, "BLOODSAILCOMPOUND", 165, 175, 194, 284, 325, 220, 390, 320);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1740, 37, "VENTURECOBASECAMP", 105, 125, 387, 64, 100, 420, 165, 465);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1741, 37, "THEARENA", 200, 185, 235, 189, 255, 250, 335, 340);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1761, 182, "DEADWOODVILLAGE", 175, 135, 408, 533, 580, 450, 640, 535);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1762, 182, "FELPAWVILLAGE", 240, 145, 483, 0, 35, 585, 110, 685);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1763, 182, "JAEDENAR", 245, 128, 271, 331, 375, 300, 425, 430);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1765, 182, "BLOODVENOMFALLS", 235, 145, 292, 263, 295, 360, 355, 490);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1766, 182, "SHATTERSCARVALE", 235, 200, 307, 123, 175, 370, 295, 475);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1767, 182, "IRONTREEWOODS", 215, 215, 420, 54, 120, 455, 195, 550);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1777, 38, "ITHARIUSSCAVE", 240, 245, 0, 262, 350, 100, 490, 200);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1778, 38, "SORROWMURK", 215, 365, 724, 120, 175, 775, 445, 905);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1780, 38, "SPLINTERSPEARJUNCTION", 275, 240, 129, 236, 290, 150, 410, 340);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1797, 38, "STAGALBOG", 345, 250, 552, 378, 455, 615, 600, 795);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1798, 38, "THESHIFTINGMIRE", 315, 235, 286, 110, 160, 320, 305, 560);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1857, 16, "THORADINSWALL", 190, 240, 87, 138, 180, 125, 325, 230);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1858, 16, "BOULDERGOR", 245, 245, 232, 145, 215, 350, 340, 405);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1877, 17, "VALLEYOFFANGS", 230, 230, 349, 256, 320, 400, 440, 530);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1878, 17, "THEDUSTBOWL", 270, 275, 159, 199, 275, 220, 415, 390);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1879, 17, "MIRAGEFLATS", 285, 240, 148, 384, 420, 215, 585, 400);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1882, 26, "PLAGUEMISTRAVINE", 145, 220, 158, 149, 180, 190, 330, 265);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1883, 26, "VALORWINDLAKE", 170, 170, 319, 302, 355, 365, 425, 440);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1884, 26, "AGOLWATHA", 205, 195, 374, 164, 205, 440, 290, 555);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1885, 26, "HIRIWATHA", 225, 200, 171, 306, 365, 230, 460, 335);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1886, 26, "THECREEPINGRUIN", 180, 170, 408, 260, 315, 455, 400, 550);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1897, 17, "THEMAKERSTERRACE", 245, 205, 389, 7, 50, 400, 170, 585);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1898, 17, "DUSTWINDGULCH", 245, 205, 498, 209, 245, 565, 370, 690);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1917, 26, "SHAOLWATHA", 280, 205, 571, 239, 285, 635, 390, 770);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1937, 161, "NOONSHADERUINS", 120, 135, 533, 104, 140, 570, 190, 630);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1938, 161, "BROKENPILLAR", 110, 180, 473, 234, 275, 500, 335, 565);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1939, 161, "ABYSSALSANDS", 215, 180, 363, 194, 240, 410, 330, 505);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1940, 161, "SOUTHBREAKSHORE", 215, 175, 499, 293, 365, 570, 430, 680);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1942, 201, "THEMARSHLANDS", 310, 355, 560, 240, 305, 615, 540, 780);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1943, 201, "IRONSTONEPLATEAU", 285, 285, 582, 67, 145, 625, 320, 825);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1957, 28, "BLACKCHARCAVE", 275, 235, 77, 366, 415, 155, 565, 305);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1958, 28, "TANNERCAMP", 305, 230, 545, 407, 440, 605, 580, 785);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1959, 28, "DUSTFIREVALLEY", 460, 365, 422, 8, 60, 530, 330, 820);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (1998, 182, "TALONBRANCHGLADE", 160, 145, 548, 90, 130, 585, 195, 660);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2079, 141, "ALCAZISLAND", 200, 195, 660, 21, 55, 695, 180, 820);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2097, 61, "DARKCLOUDPINNACLE", 205, 195, 259, 131, 190, 305, 295, 395);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2198, 101, "SHADOWBREAKRAVINE", 205, 195, 690, 444, 485, 760, 575, 850);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2241, 281, "FROSTSABERROCK", 250, 180, 368, 7, 55, 440, 115, 550);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2242, 281, "THEHIDDENGROVE", 175, 185, 555, 27, 80, 600, 150, 695);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2243, 281, "TIMBERMAWPOST", 230, 120, 229, 243, 270, 365, 310, 440);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2244, 281, "WINTERFALLVILLAGE", 145, 125, 617, 158, 220, 650, 270, 720);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2245, 281, "MAZTHORIL", 185, 180, 493, 258, 360, 555, 415, 615);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2246, 281, "FROSTFIREHOTSPRINGS", 240, 140, 222, 172, 220, 275, 270, 395);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2247, 281, "ICETHISTLEHILLS", 125, 165, 611, 242, 265, 650, 345, 715);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2249, 281, "FROSTWHISPERGORGE", 200, 160, 523, 376, 420, 575, 495, 665);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2250, 281, "OWLWINGTHICKET", 165, 140, 593, 340, 380, 620, 445, 690);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2251, 281, "LAKEKELTHERIL", 215, 185, 401, 198, 250, 485, 330, 580);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2253, 281, "STARFALLVILLAGE", 185, 160, 392, 137, 160, 445, 220, 550);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2255, 281, "EVERLOOK", 165, 200, 509, 107, 220, 565, 285, 655);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2256, 281, "DARKWHISPERGORGE", 255, 205, 447, 441, 500, 490, 610, 670);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2258, 23, "THEFUNGALVALE", 210, 210, 271, 261, 300, 355, 395, 455);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2260, 23, "THEMARRISSTEAD", 200, 205, 156, 360, 455, 215, 525, 320);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2261, 23, "THEUNDERCROFT", 185, 150, 172, 477, 520, 245, 610, 325);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2262, 23, "DARROWSHIRE", 210, 179, 309, 489, 560, 340, 640, 460);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2263, 23, "CROWNGUARDTOWER", 205, 165, 291, 401, 465, 345, 545, 430);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2264, 23, "CORINSCROSSING", 165, 160, 537, 367, 430, 550, 510, 645);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2266, 23, "TYRSHAND", 245, 170, 717, 471, 505, 765, 605, 935);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2268, 23, "LIGHTSHOPECHAPEL", 175, 245, 716, 299, 350, 785, 430, 860);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2270, 23, "THENOXIOUSGLADE", 225, 215, 722, 166, 225, 785, 330, 905);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2271, 23, "EASTWALLTOWER", 180, 160, 592, 241, 290, 645, 375, 715);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2272, 23, "NORTHDALE", 190, 205, 620, 128, 170, 665, 255, 750);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2273, 23, "ZULMASHAR", 205, 165, 614, 30, 60, 670, 135, 795);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2275, 23, "NORTHPASSTOWER", 240, 195, 457, 109, 145, 515, 235, 645);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2276, 23, "QUELLITHIENLODGE", 230, 150, 422, 36, 80, 485, 140, 575);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2277, 23, "PLAGUEWOOD", 360, 270, 169, 83, 160, 235, 290, 495);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2279, 23, "STRATHOLME", 240, 200, 194, 9, 35, 245, 170, 380);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2297, 22, "DARROWMERELAKE", 370, 270, 504, 343, 410, 555, 575, 815);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2298, 22, "CAERDARROW", 170, 165, 600, 412, 455, 640, 550, 740);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2300, 161, "CAVERNSOFTIME", 155, 150, 561, 256, 295, 595, 365, 690);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2301, 43, "THISTLEFURVILLAGE", 255, 195, 203, 158, 215, 335, 275, 405);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2302, 141, "BACKBAYWETLANDS", 400, 255, 239, 189, 240, 320, 410, 570);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2303, 61, "WINDBREAKCANYON", 240, 220, 492, 250, 285, 550, 450, 700);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2404, 101, "TETHRISARAN", 205, 145, 431, 0, 50, 495, 115, 595);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2405, 101, "ETHELRETHOR", 205, 250, 311, 61, 135, 345, 275, 475);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2406, 101, "RANAZJARISLE", 100, 100, 241, 6, 25, 255, 85, 325);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2407, 101, "KORMEKSHUT", 170, 160, 555, 181, 230, 590, 310, 700);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2408, 101, "SHADOWPREYVILLAGE", 230, 230, 167, 389, 420, 195, 520, 315);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2417, 29, "BLACKROCKPASS", 270, 310, 589, 279, 385, 680, 530, 825);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2418, 29, "MORGANSVIGIL", 294, 270, 708, 311, 350, 805, 515, 970);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2420, 29, "TERRORWINGPATH", 280, 355, 722, 46, 115, 780, 365, 995);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2421, 29, "DRACODAR", 415, 315, 56, 258, 330, 125, 545, 435);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2478, 182, "MORLOSARAN", 145, 159, 496, 509, 560, 540, 615, 615);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2479, 182, "EMERALDSANCTUARY", 185, 160, 405, 429, 505, 470, 560, 565);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2480, 182, "JADEFIREGLEN", 165, 155, 332, 465, 510, 370, 595, 455);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2481, 182, "RUINSOFCONSTELLAS", 235, 155, 297, 381, 425, 335, 500, 425);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2497, 181, "BITTERREACHES", 245, 185, 644, 40, 80, 685, 180, 850);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2517, 19, "RISEOFTHEDEFILER", 170, 145, 405, 123, 160, 445, 240, 530);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2522, 121, "RUINSOFISILDIEN", 190, 250, 540, 320, 375, 565, 520, 665);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2537, 81, "GRIMTOTEMPOST", 225, 120, 668, 515, 555, 700, 605, 815);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2538, 81, "CAMPAPARAJE", 190, 97, 718, 571, 600, 745, 635, 805);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2539, 81, "MALAKAJIN", 125, 86, 663, 582, 605, 695, 660, 765);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2540, 81, "BOULDERSLIDERAVINE", 145, 107, 572, 561, 580, 600, 660, 700);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2541, 81, "SISHIRCANYON", 125, 125, 475, 433, 465, 500, 535, 590);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2561, 32, "THEVICE", 270, 270, 426, 299, 325, 510, 540, 665);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2562, 32, "KARAZHAN", 300, 245, 269, 337, 380, 335, 540, 520);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2577, 121, "DIREMAUL", 230, 195, 454, 201, 235, 525, 325, 655);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2618, 182, "JADEFIRERUN", 195, 170, 330, 29, 85, 370, 155, 455);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2619, 23, "THONDRORILRIVER", 220, 360, 7, 231, 255, 25, 550, 130);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2620, 22, "THONDRORILRIVER", 205, 340, 590, 86, 120, 625, 395, 730);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2621, 23, "LAKEMERELDAR", 250, 175, 537, 463, 490, 565, 580, 690);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2622, 23, "THEINFECTISSCAR", 195, 275, 620, 291, 355, 695, 480, 790);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2623, 23, "PESTILENTSCAR", 205, 250, 409, 345, 405, 475, 485, 580);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2624, 23, "BLACKWOODLAKE", 230, 235, 442, 199, 290, 475, 375, 565);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2627, 23, "TERRORDALE", 190, 205, 79, 98, 180, 115, 250, 240);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2697, 32, "DEADMANSCROSSING", 380, 365, 249, 76, 125, 315, 355, 590);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2737, 261, "THESCARABWALL", 288, 256, 116, 413, 615, 220, 655, 360);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2738, 261, "SOUTHWINDVILLAGE", 384, 384, 500, 65, 315, 585, 395, 665);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2740, 261, "THECRYSTALVALE", 320, 289, 104, 24, 50, 150, 185, 315);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2742, 261, "HIVEASHI", 512, 320, 265, 12, 100, 385, 225, 515);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2743, 261, "HIVEZORA", 384, 512, 97, 144, 310, 165, 470, 330);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2744, 261, "HIVEREGAL", 512, 384, 245, 285, 425, 490, 650, 655);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2959, 401, "DUNBALDAR", 270, 240, 348, 13, 50, 275, 225, 565);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2977, 401, "ICEBLOODGARRISON", 300, 300, 335, 172, 230, 380, 430, 600);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (2978, 401, "FROSTWOLFKEEP", 235, 290, 399, 375, 425, 435, 620, 605);
INSERT INTO `WorldMapOverlay_vanilla` VALUES (3425, 261, "TWILIGHTBASECAMP", 320, 256, 344, 197, 215, 475, 285, 540);
DROP TABLE IF EXISTS `AreaTrigger_vanilla`;
CREATE TABLE `AreaTrigger_vanilla` (
`ID` smallint(3) unsigned NOT NULL,
`MapID` smallint(3) unsigned NOT NULL,
`X` float NOT NULL DEFAULT 0.0,
`Y` float NOT NULL DEFAULT 0.0,
`Z` float NOT NULL DEFAULT 0.0,
`Size` float NOT NULL DEFAULT 0.0
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED COMMENT='AreaTrigger';

INSERT INTO `AreaTrigger_vanilla` VALUES (45, 0, 2924.37988281, -798.429016113, 161.610992432, 8.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (60, 24, 47.6134986877, -28.9461994171, -8.81758975983, 7.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (71, 0, -10645.9003906, 1179.06005859, 48.1781005859, 27.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (78, 0, -11208.5, 1685.33996582, 25.7611999512, 7.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (81, 28, -259.24697876, 137.751174927, 36.5683059692, 7.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (83, 28, 254.569396973, -4.32205104828, 6.48652076721, 8.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (84, 0, 16449.9003906, 16393.1992188, 69.4443969727, 15.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (87, 0, -9077.33984375, -552.924987793, 60.3475990295, 30.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (88, 0, -9843.54003906, 127.525001526, 5.36980009079, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (95, 30, -409.828125, -802.770812988, -13.2469615936, 9.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (97, 0, -5660.33007812, 755.29901123, 389.605010986, 15.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (98, 0, -11634.7998047, -54.0696983337, 13.4439001083, 30.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (100, 0, 2019.34936523, 1904.359375, 105.144447327, 7.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (101, 0, -8761.84960938, 848.557006836, 87.8051986694, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (107, 0, -8667.55957031, 623.562988281, 85.4054031372, 7.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (109, 35, -0.90042001009, 16.4430007935, -14.236000061, 7.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (119, 36, -14.3627996445, -393.380004883, 64.5605010986, 6.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (121, 36, -110.760002136, -1009.19000244, 34.8044013977, 7.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (145, 0, -229.490005493, 1576.34997559, 78.8908996582, 7.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (168, 0, -5584.20654297, 759.83215332, 384.290161133, 15.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (169, 0, -5586.45996094, 679.297973633, 384.954986572, 8.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (171, 0, -5763.72021484, -3439.58007812, 306.365997314, 50.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (173, 0, 1058.10998535, 1554.68005371, -15.0, 90.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (175, 0, -4086.36010742, -2610.94995117, 46.0143013, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (178, 0, 683.770996094, -912.143981934, 174.5, 5.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (194, 33, -230.95300293, 2105.06005859, 79.7533035278, 5.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (196, 0, -12153.6210938, 894.01373291, 9.53891277313, 80.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (197, 0, -9796.1796875, 157.772994995, 25.3878002167, 9.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (205, 1, -1895.7800293, -1109.04003906, 86.1829986572, 15.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (216, 1, 90.1003036499, -1943.43994141, 79.4727020264, 9.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (217, 1, 10708.7998047, 762.09197998, 1321.36999512, 14.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (218, 1, 9859.08984375, 588.760986328, 1300.60998535, 14.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (219, 1, 9556.24023438, 1654.77001953, 1299.48999023, 14.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (220, 1, 10675.2001953, 1857.44995117, 1324.17004395, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (223, 1, 4508.16992188, 373.37600708, 32.5125007629, 40.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (224, 1, 4605.56982422, 385.157989502, 31.4827003479, 25.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (225, 1, 4558.35986328, 421.446014404, 33.7425003052, 50.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (226, 43, -172.180999756, 138.979995728, -66.647102356, 12.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (228, 1, -753.596008301, -2212.7800293, 21.5403003693, 13.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (230, 1, 6744.97998047, 41.1164016724, 47.6040992737, 13.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (231, 1, 5996.56005859, 365.209991455, 21.8661003113, 40.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (232, 1, 5980.16992188, 330.669006348, 21.765499115, 40.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (233, 1, 4916.99023438, 328.429992676, 36.7677993774, 50.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (234, 1, 4641.18994141, 55.3801002502, 66.6306991577, 60.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (235, 1, 4554.64990234, 146.354003906, 59.5027008057, 70.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (236, 1, 4643.37988281, 145.348999023, 57.9047012329, 50.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (237, 1, 4504.31005859, 32.3296012878, 86.4913024902, 80.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (238, 1, 6876.27978516, -486.028991699, 40.1436004639, 65.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (239, 1, 3469.42993164, 847.619995117, 5.36475992203, 12.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (242, 47, 1936.39001465, 1534.4699707, 86.8768997192, 8.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (244, 1, -4456.70019531, -1655.98999023, 86.1094970703, 8.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (246, 1, -4932.52978516, -1596.05004883, 84.8156967163, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (254, 33, -236.470001221, 2202.41992188, 97.345199585, 5.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (255, 33, -223.399002075, 2101.9699707, 97.3899002075, 5.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (256, 33, -189.005996704, 2145.68994141, 97.3899002075, 7.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (257, 1, 4252.37011719, 756.973999023, -23.0631999969, 12.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (259, 48, -148.632995605, 121.080001831, -33.414100647, 12.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (262, 47, 2019.72998047, 2004.59997559, 61.6874008179, 15.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (283, 48, -527.65802002, 321.109008789, -50.2583999634, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (284, 0, -8681.37011719, 434.406005859, 99.2578964233, 7.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (286, 0, -6053.72998047, -2954.62988281, 213.686004639, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (288, 70, -228.192993164, 34.1601982117, -39.2338981628, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (302, 1, -3463.26000977, -4123.12988281, 17.1042995453, 8.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (303, 1, -4058.75, -2732.54003906, 35.3301010132, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (322, 90, -312.204986572, -4.63255977631, -148.656997681, 14.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (324, 0, -5161.33007812, 939.62298584, 258.287994385, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (342, 0, -9029.17382812, -608.328857422, 56.4678993225, 30.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (362, 0, -10429.4345703, -3828.84082031, -31.6296463013, 150.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (382, 0, -8681.40039062, 434.438995361, 99.2590026855, 7.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (422, 1, -93.1613998413, 1691.15002441, 89.0649032593, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (442, 1, -4666.52001953, -2536.82006836, 86.9671020508, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (444, 129, 2593.93994141, 1124.64001465, 56.1790008545, 11.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (446, 0, -10162.7001953, -3998.64990234, -107.977996826, 11.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (448, 109, -300.0, 99.0, -127.0, 13.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (462, 47, 2107.7199707, 1823.77001953, 79.9695968628, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (463, 47, 2165.75, 1944.75, 61.4635009766, 15.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (482, 0, -8932.78027344, -1986.40002441, 139.904998779, 12.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (503, 34, 39.3740997314, 0.803469002247, -12.7882995605, 8.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (522, 1, -1679.30004883, -4328.95996094, 2.58591008186, 4.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (523, 0, -4858.27001953, 785.030029297, 241.059997559, 12.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (525, 90, -717.867980957, 1.37206995487, -241.292999268, 12.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (527, 1, 9947.48046875, 2630.04003906, 1318.59997559, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (542, 1, 8799.41015625, 969.786987305, 30.2409000397, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (562, 0, -9465.58007812, 16.8472003937, 65.9209976196, 30.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (602, 189, 1687.56994629, 1040.08996582, 20.9829006195, 8.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (604, 189, 853.679016113, 1308.09997559, 19.6714000702, 8.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (606, 189, 1608.65002441, -308.970001221, 20.7824001312, 8.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (608, 189, 253.600997925, -196.804000854, 21.0384998322, 8.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (610, 0, 2925.17993164, -820.54498291, 161.634002686, 8.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (612, 0, 2877.97998047, -839.267028809, 163.048995972, 6.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (614, 0, 2859.72998047, -824.909973145, 162.082992554, 8.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (682, 0, -9219.37011719, -2149.93994141, 70.6060028076, 30.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (702, 0, -9023.25976562, 892.398010254, 33.509601593, 7.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (704, 0, -9020.08984375, 880.50201416, 151.576004028, 7.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (707, 0, -10517.0, -1158.39001465, 39.0541992188, 30.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (708, 0, -854.54699707, -576.314025879, 18.4659004211, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (709, 1, -3615.48999023, -4467.33984375, 24.3141002655, 30.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (710, 0, -5601.45996094, -530.747009277, 395.483001709, 35.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (712, 0, -5390.18017578, -2953.92993164, 322.029998779, 36.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (713, 0, -3823.06005859, -834.526000977, 18.2789001465, 30.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (715, 1, 9809.04980469, 959.187988281, 1315.34997559, 32.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (716, 1, 6410.00976562, 527.034973145, 14.057800293, 32.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (717, 1, 2756.63989258, -423.057006836, 119.387001038, 32.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (719, 0, 2266.67993164, 245.992996216, 44.4145011902, 30.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (720, 0, 511.536010742, 1638.63000488, 75.4172973633, 50.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (721, 0, -4.944439888, -934.909973145, 62.4686012268, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (722, 1, -2366.69995117, -345.983001709, -1.29313004017, 30.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (742, 1, -405.311004639, -2645.29003906, 111.972000122, 30.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (743, 1, -1051.43994141, -3653.81005859, 31.1352005005, 30.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (762, 48, -842.07598877, -472.462005615, -34.0656013489, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (802, 0, -3752.81005859, -851.557983398, 10.1153001785, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (803, 0, -3668.34008789, -823.838989258, 9.89914989471, 12.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (822, 70, -234.444000244, 319.12701416, -47.5885009766, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (843, 1, 341.420013428, -4684.70019531, 30.949300766, 30.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (844, 0, -10487.2998047, -3256.87011719, 39.8964004517, 30.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (862, 0, -14457.0, 496.450012207, 39.1391983032, 28.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (882, 70, -213.720001221, 370.606994629, -35.3886985779, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (902, 0, -6606.47998047, -3762.18994141, 266.910003662, 12.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (922, 209, 1190.34997559, 840.586975098, 13.4342002869, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (924, 1, -6773.49023438, -2889.77001953, 15.106300354, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (942, 1, -4950.64990234, -1625.14001465, -3.01570010185, 25.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (943, 1, -4950.74023438, -1595.14001465, -3.01570010185, 25.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (944, 1, -4950.64990234, -1567.09997559, -3.01570010185, 25.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (962, 209, 1909.27001953, 1015.10998535, 11.5155000687, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (982, 1, -2372.51000977, -1991.64001465, 120.974998474, 35.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1022, 1, 898.481994629, 922.687988281, 126.788002014, 35.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1023, 1, -7162.14013672, -3845.94995117, 8.78192996979, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1024, 1, -4370.83007812, 3289.14990234, 23.7823009491, 35.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1025, 1, -4461.91992188, 242.57800293, 45.2464981079, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1042, 0, 357.220001221, -2106.09008789, 121.838996887, 60.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1064, 249, 29.2427005768, -22.1812000275, 10.5271997452, 30.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1103, 0, -14468.0, 457.513000488, 15.9821996689, 2.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1104, 0, -5096.75976562, 750.20501709, 260.549987793, 2.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1105, 90, -377.055999756, 44.0499992371, -156.483001709, 15.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1125, 0, -8561.54003906, 823.382995605, 106.518997192, 3.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1205, 0, -295.639007568, -3460.67993164, 193.884002686, 14.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1306, 109, -496.854003906, 42.6929016113, -91.1317977905, 25.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1326, 109, -467.520996094, 95.3082962036, -105.0, 7.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1387, 1, 4260.72998047, -6273.64013672, 90.2288970947, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1388, 1, 4277.58007812, -6296.0, 95.5764007568, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1426, 0, -11204.5, -2730.61010742, 14.8971996307, 2.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1427, 0, -11079.7001953, -2855.63989258, 10.6911001205, 2.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1428, 0, -11208.0996094, -2960.47998047, 9.21448993683, 2.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1429, 0, -11337.4003906, -2848.92993164, 9.34403991699, 2.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1446, 0, -11185.0996094, -2834.62988281, 116.473999023, 2.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1447, 209, 1811.05004883, 700.976013184, 15.2939996719, 30.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1466, 0, -7176.62988281, -937.666992188, 170.205993652, 13.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1468, 0, -7518.18994141, -1239.13000488, 287.243011475, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1470, 229, 73.5083007812, -215.044006348, 52.3869018555, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1472, 230, 456.968994141, 48.3680000305, -65.2752990723, 12.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1506, 0, -7921.14013672, -2604.17993164, 223.345993042, 8.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1526, 230, 596.432006836, -188.498001099, -50.0, 8.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1590, 230, 376.105987549, -191.242004395, -70.5448989868, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1606, 0, -6657.35009766, -2157.10009766, 264.132995605, 30.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1626, 269, 3122.19995117, 2324.63989258, -129.320007324, 70.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1628, 229, -78.5819015503, -401.394989014, 38.9427986145, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1629, 269, -2061.12011719, 6635.97021484, -144.595993042, 70.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1631, 1, -8280.79003906, -4025.13989258, -181.059005737, 70.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1632, 1, -8799.19042969, -4115.16015625, -199.99899292, 70.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1646, 0, -907.864990234, -3534.23999023, 83.7878036499, 30.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1667, 1, -3464.70996094, -4120.93017578, 17.0986995697, 9.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1686, 230, 319.973999023, -215.184997559, -77.9542007446, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1726, 1, -7286.00976562, -2125.06005859, -272.114013672, 12.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1727, 1, -7208.41992188, -2027.08996582, -271.739990234, 12.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1728, 1, -7170.02001953, -1852.79003906, -272.988006592, 12.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1729, 1, -7395.18994141, -1735.68005371, -279.763000488, 12.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1730, 1, -7449.89990234, -2111.57006836, -271.765991211, 12.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1731, 1, -7463.35009766, -1957.64001465, -272.532012939, 12.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1732, 1, -7509.58007813, -1946.56005859, -270.536987305, 12.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1733, 1, -7516.87011719, -1829.76000977, -272.647003174, 12.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1734, 1, -7594.12011719, -1771.61999512, -273.611999512, 12.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1735, 1, -7748.89990234, -1721.14001465, -271.908996582, 12.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1736, 1, -7768.60986328, -1957.63000488, -272.12600708, 12.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1737, 1, -7612.56005859, -1930.86999512, -271.82800293, 12.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1738, 1, -7952.20019531, -1792.01000977, -272.893005371, 12.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1739, 1, -7895.29003906, -1623.61999512, -269.707000732, 12.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1740, 1, -7874.18017578, -1806.30004883, -271.459014893, 12.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1746, 230, 411.617004395, -201.645996094, -65.1445999146, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1766, 1, -7308.71337891, -2001.47314453, -272.450500488, 12.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1786, 230, 690.518005371, -280.052001953, -43.1968994141, 7.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1826, 230, 471.141998291, -9.3437795639, -69.7993011475, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1827, 230, 1380.15002441, -554.604003906, -89.6429977417, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1828, 230, 497.398986816, 13.2319002151, -70.1371994019, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1906, 1, 6818.56005859, -391.734985352, 40.1230010986, 50.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1926, 230, 845.911010742, -317.368988037, -50.2868003845, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1946, 229, 70.8610992432, -409.014007568, 64.3477020264, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1966, 1, 4988.97021484, 547.00201416, 5.37929010391, 11.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1986, 229, 91.0854034424, -408.37399292, 64.3477020264, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (1987, 229, 109.608001709, -415.697998047, 64.3477020264, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2026, 229, 153.763000488, -419.833007812, 110.472000122, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2046, 229, 102.430000305, -319.166992188, 65.4635009766, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2066, 229, 75.2621994019, -547.679016113, 110.928001404, 30.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2067, 229, 26.4582996368, -522.471008301, 110.943000793, 15.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2068, 229, 25.9284992218, -299.325012207, 24.109500885, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2146, 0, 16299.2001953, 16277.2998047, 73.9722976685, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2166, 369, 76.0270004272, 10.5043001175, -4.29658985138, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2171, 369, 80.1632995605, 2490.87988281, -1.85693001747, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2173, 0, -8346.45996094, 514.031005859, 96.5988998413, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2175, 0, -4840.25976562, -1330.45996094, 508.17199707, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2187, 329, 3673.60009766, -3633.87011719, 139.942993164, 5.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2206, 1, 5483.89990234, -749.880981445, 334.621002197, 30.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2207, 1, 5552.08984375, -683.812988281, 335.25, 25.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2208, 1, 5587.02001953, -784.025024414, 335.821990967, 23.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2209, 329, 3665.11010742, -3164.95996094, 127.223999023, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2210, 329, 3663.94995117, -3164.27001953, 127.361000061, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2211, 1, 6107.62011719, -4181.60009766, 852.322021484, 2.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2213, 1, 5893.31982422, -4054.83007812, 596.322021484, 2.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2214, 0, 3237.45996094, -4060.60009766, 112.010002136, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2216, 0, 3392.45996094, -3396.77001953, 143.072998047, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2217, 0, 3392.56005859, -3361.7800293, 142.802001953, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2221, 329, 3584.7800293, -3632.05004883, 142.117996216, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2226, 389, 2.58018994331, -0.0135869998485, -13.3668003082, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2230, 1, 1818.40002441, -4427.25976562, -10.4477996826, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2246, 0, 1757.26000977, -1165.93005371, 59.6025009155, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2248, 0, 1855.13000488, -1569.2199707, 59.1824989319, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2250, 0, 1462.13000488, -1864.02001953, 58.7028007507, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2252, 0, 1668.11999512, -2282.56005859, 59.2220993042, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2266, 1, 245.587005615, 1251.98999023, 210.145004272, 40.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2267, 1, -1596.16003418, 3145.26000977, 61.3618011475, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2286, 1, -5477.91015625, -2460.32006836, 89.2836990356, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2287, 1, 6687.99023438, -4670.06982422, 723.890991211, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2327, 1, 5018.91015625, -4563.93994141, 851.75, 50.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2387, 0, -9897.20996094, -3725.09008789, 24.6671009064, 15.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2406, 33, -287.071014404, 2175.63989258, 36.886100769, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2407, 33, -315.990997314, 2179.62988281, 91.7542037964, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2408, 33, -232.371994019, 2077.10009766, 68.1176986694, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2409, 33, -255.272994995, 2035.76000977, 114.43699646, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2410, 33, -167.091995239, 2104.2199707, 73.4496994019, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2411, 33, -179.729003906, 2079.37011719, 42.6944999695, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2412, 0, 97.4319992065, -176.274002075, 127.865997314, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2413, 0, 544.83001709, -1079.94995117, 109.494003296, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2416, 451, 16304.2001953, 16318.0996094, 69.4443969727, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2426, 469, -7474.00976562, -1286.33996582, 431.303985596, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2427, 469, -7375.31982422, -1240.14001465, 494.279998779, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2428, 469, -7568.39990234, -1375.66003418, 468.507995605, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2429, 469, -7412.97021484, -1371.58996582, 413.425994873, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2486, 1, 6207.5, -152.832992554, 79.8184967041, 15.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2527, 1, 1643.35998535, -4233.60009766, 56.1557006836, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2530, 450, 215.194000244, 71.1569976807, 30.1275997162, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2532, 0, -8768.08007812, 409.204986572, 103.92099762, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2534, 449, -0.199572995305, -1.59112000465, -0.255883991718, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2547, 289, 332.865997314, 94.310798645, 92.2220993042, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2548, 289, 322.884002686, 112.137001038, 98.6725997925, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2549, 289, 325.183990479, 75.6181030273, 93.8743972778, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2567, 0, 1282.05004883, -2548.72998047, 85.3993988037, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2568, 289, 182.26499939, 126.449996948, 143.707000732, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2606, 30, -723.593994141, -707.598999023, 52.8847999573, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2608, 30, 946.833007813, -500.092010498, 94.9294967651, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2610, 1, 2343.57006836, -2569.0, 118.827003479, 30.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2626, 0, 1756.79003906, -1200.15002441, 60.7351989746, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2627, 0, 1723.31994629, -1198.38000488, 60.009601593, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2628, 0, 1723.09997559, -1166.70996094, 59.5774993896, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2629, 0, 1879.59851074, -1546.0826416, 59.0301094055, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2630, 0, 1903.0, -1570.26000977, 59.7034988403, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2631, 0, 1878.07995605, -1593.73999023, 59.4738998413, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2632, 0, 1487.0300293, -1840.91003418, 58.6674995422, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2633, 0, 1510.45996094, -1863.23999023, 59.1059989929, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2634, 0, 1485.60998535, -1888.68994141, 59.0901985168, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2635, 0, 1681.11682129, -2250.93188477, 59.0211181641, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2636, 0, 1712.75, -2263.2800293, 64.0888977051, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2637, 0, 1700.25, -2295.36010742, 58.9846000671, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2647, 0, 2841.81005859, -1544.52001953, 190.51600647, 7.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2706, 0, 2964.56005859, -2712.88989258, 98.7445983887, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2707, 0, 2980.10009766, -2720.91992188, 99.9337005615, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2726, 0, 1868.95996094, -3223.38989258, 123.065002441, 35.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2746, 0, -8821.36035156, 633.29699707, 94.0757980347, 15.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2786, 0, -9050.87011719, 445.458007812, 93.0558013916, 1.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2848, 1, -4768.60986328, -3752.11010742, 53.4317016602, 16.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2886, 230, 1097.98999023, -466.493988037, -96.0718994141, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2890, 409, 1115.2199707, -462.959014893, -95.0148010254, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2926, 1, 1999.15002441, -1121.2800293, 97.3536987305, 9.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (2946, 1, 2.00574994087, 402.67300415, 101.012001038, 45.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3066, 0, 18.9447994232, -1448.2199707, 176.149993896, 8.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3106, 0, -30.0533008575, -1576.5, 194.45300293, 5.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3126, 349, 756.877990723, -633.960021973, -32.8190994263, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3131, 349, 1005.02001953, -460.539001465, -43.2507019043, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3133, 1, -1484.06994629, 2617.57006836, 75.7144012451, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3134, 1, -1181.97998047, 2861.94995117, 85.258102417, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3146, 1, -7180.93994141, 441.136993408, 26.5449008942, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3183, 1, -3730.47998047, 933.974975586, 160.973007202, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3184, 1, -3981.58007812, 771.192993164, 160.962005615, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3185, 1, -4028.20996094, 123.966003418, 26.8108997345, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3186, 1, -3837.79003906, 1250.22998047, 160.223007202, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3187, 1, -3741.95996094, 1249.18005371, 160.216995239, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3189, 1, -3520.64990234, 1068.7199707, 161.128005981, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3190, 429, -55.965801239, 159.867004395, -3.46205997467, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3191, 429, 24.5608997345, 159.449996948, -3.4667699337, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3193, 429, 255.24899292, -9.05605983734, -2.58736991882, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3194, 429, 37.4499015808, -154.822006226, -2.71200990677, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3195, 429, -202.664001465, -314.87600708, -2.72353005409, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3196, 429, 4.31119012833, -837.085021973, -33.0405006409, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3197, 429, 194.350997925, -240.820999146, -25.6306991577, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3326, 30, -767.072998047, -358.70300293, 68.6579971313, 5.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3327, 30, -1221.34997559, -352.87701416, 57.7211990356, 5.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3328, 30, -1305.23999023, -268.868011475, 92.0223007202, 5.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3329, 30, 213.92300415, -373.736999512, 56.3890991211, 5.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3330, 30, 326.269866943, -503.7890625, 71.1437683105, 4.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3331, 30, 683.106994629, -129.845993042, 63.5983009338, 5.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3366, 0, 2832.07006836, -1540.47998047, 190.164993286, 7.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3367, 0, 2843.39990234, -1553.26000977, 190.720993042, 7.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3506, 429, 580.75402832, 487.506011963, 29.464099884, 8.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3507, 429, 580.656982422, 475.885009766, 29.464099884, 8.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3508, 429, 592.507019043, 486.309997559, 29.464099884, 8.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3509, 429, 591.91998291, 476.403991699, 29.464099884, 8.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3528, 0, -7510.87011719, -1035.86999512, 182.95199585, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3529, 0, -7512.16015625, -1034.7800293, 177.207992554, 4.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3530, 0, -8536.1796875, 452.165008545, 104.916999817, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3546, 1, 9933.94042969, 2500.97998047, 1317.81994629, 12.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3547, 0, 1642.09997559, 239.843002319, 62.5915985107, 13.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3548, 0, -4754.56005859, -3313.80004883, 313.563995361, 14.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3549, 1, 1253.79003906, -2227.52001953, 92.2480010986, 15.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3550, 1, -959.29901123, -3759.20996094, 4.98618984222, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3551, 1, -998.182983398, -3822.07006836, 5.29540014267, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3552, 0, -11413.5996094, 1954.91003418, 14.2409000397, 22.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3586, 1, 6221.83984375, -1152.75, 383.230987549, 4.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3587, 1, 6221.89013672, -1153.0, 383.272003174, 5.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3606, 0, -7514.81005859, -1033.11999512, 163.805999756, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3626, 469, -7529.10009766, -1007.19000244, 408.565002441, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3646, 489, 1539.89001465, 1481.35998535, 352.658996582, 5.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3647, 489, 918.49597168, 1434.04003906, 346.053985596, 5.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3649, 489, 1532.06665039, 1151.66674805, 373.975006104, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3650, 1, 1422.32995605, -1855.32995605, 135.774993896, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3654, 1, 1034.18994141, -2087.73999023, 123.372001648, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3669, 489, 1009.16668701, 1290.76672363, 346.960998535, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3671, 489, 1456.46765137, 1628.46765137, 360.351989746, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3686, 489, 1449.76672363, 1470.56665039, 342.625, 4.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3687, 489, 1005.26672363, 1447.26672363, 335.893005371, 4.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3688, 489, 1125.22668457, 1541.50073242, 307.392486572, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3690, 0, -622.142028809, -4582.14013672, 22.5760993958, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3706, 489, 1316.9666748, 1550.96765137, 313.234008789, 4.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3707, 489, 1319.76672363, 1378.66674805, 314.752990723, 4.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3708, 489, 1112.64001465, 1351.10998535, 316.618988037, 4.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3709, 489, 1140.06665039, 1560.76672363, 306.824005127, 4.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3726, 229, 178.729003906, -474.411987305, 120.565002441, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3728, 469, -7676.10986328, -1109.70996094, 399.12298584, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3746, 36, -29.5547008514, -374.502990723, 59.3562011719, 6.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3766, 43, -108.56300354, 160.914993286, -79.7910995483, 9.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3847, 0, -7663.39990234, -1218.36999512, 287.787994385, 3.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3866, 529, 1185.44995117, 1184.70996094, -56.3633003235, 4.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3867, 529, 817.939025879, 842.369018555, -56.540599823, 4.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3868, 529, 809.00769043, 1185.27746582, 11.9216051102, 4.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3869, 529, 1147.01000977, 816.854003906, -98.3990020752, 5.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3870, 529, 989.851989746, 1009.15997314, -42.6032981873, 4.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3886, 0, -12432.7998047, 205.169006348, 2.36514997482, 18.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3926, 309, -11594.0996094, -1621.36999512, 47.1445999146, 15.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3928, 0, -11915.7998047, -1236.43005371, 96.1501998901, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3930, 309, -11917.0, -1221.0, 97.5615997314, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3948, 529, 1394.35998535, 1303.64001465, -8.02585983276, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3949, 529, 627.192016602, 699.956970215, -11.992099762, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3953, 0, -1189.27001953, -2532.18994141, 22.7049999237, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3954, 0, -811.424987793, -3505.82006836, 73.1377029419, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3956, 309, -11918.5996094, -1433.94995117, 44.5449981689, 15.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3957, 309, -11916.7998047, -1256.69995117, 92.5434036255, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3958, 309, -11915.0439453, -1312.6763916, 77.501914978, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3959, 309, -11945.6884766, -1597.6072998, 36.7568969727, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3960, 309, -11788.9003906, -1595.06005859, 36.9989013672, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3961, 309, -11614.2001953, -1361.51000977, 76.8399963379, 15.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3962, 309, -11957.5996094, -1819.9699707, 54.3114013672, 15.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3963, 309, -12112.9003906, -1794.63000488, 80.4162979126, 15.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3964, 309, -11791.0, -1562.85998535, 19.7420005798, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3965, 309, -11610.0, -1749.85998535, 38.7341995239, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3966, 309, -12072.2998047, -1479.05004883, 106.495002747, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3985, 1, -6864.97998047, 731.611999512, 50.0, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3986, 1, -8194.25976562, -4676.43994141, 11.3654003143, 30.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (3991, 0, 1733.31994629, 526.473999023, 34.2494010925, 35.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4006, 509, -8419.58007812, 1504.2800293, 31.7355995178, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4008, 1, -8424.94042969, 1508.65002441, 32.0141983032, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4010, 1, -8230.40039062, 2005.32995605, 129.863006592, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4012, 531, -8231.33007812, 2003.59997559, 129.860992432, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4015, 1, 5085.81982422, -5110.64013672, 929.979003906, 6.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4016, 109, -662.106018066, 3.83104991913, -90.8350982666, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4017, 0, -10636.2001953, -391.307006836, 101.877998352, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4020, 529, 1313.93005371, 1310.77001953, -7.704870224, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4021, 529, 683.960998535, 681.229980469, -12.9158000946, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4026, 0, -5049.33984375, -818.453979492, 495.295013428, 2.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4027, 1, 1332.27001953, -4607.66992188, 24.3694992065, 2.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4028, 0, 2051.36010742, 272.571990967, 57.1633987427, 2.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4029, 0, -14294.2998047, 516.088012695, 8.9539899826, 2.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4030, 0, -3755.10498047, -775.704772949, 9.88801002502, 2.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4031, 1, -7166.06005859, -3917.93994141, 9.39558029175, 2.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4032, 0, -8823.48046875, 540.301025391, 96.9036026001, 2.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4033, 531, -8546.23046875, 1987.65002441, -96.5206985474, 5.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4034, 531, -8545.67871094, 1987.70141602, -32.9392280579, 15.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4036, 531, -8578.0, 1986.80004883, 100.220001221, 7.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4047, 531, -8967.95996094, 1312.61999512, -104.695999146, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4052, 531, -8176.83007812, 1673.36999512, -32.2182998657, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4055, 0, 3133.14990234, -3730.29003906, 138.658996582, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4057, 0, 3133.26000977, -3730.84008789, 138.658004761, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4058, 0, 2298.16992188, -5340.97998047, 90.8798980713, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4085, 1, 7763.328125, -4010.72436523, 694.280151367, 95.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4086, 533, 3292.73852539, -3151.59057617, 297.568725586, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4087, 533, 3291.10693359, -3151.29492188, 297.580352783, 100.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4088, 533, 3321.29003906, -3119.87988281, 297.570007324, 90.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4089, 189, 864.62298584, 1321.59997559, 18.0683002472, 5.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4090, 1, 2716.60009766, 1496.81994629, 236.82800293, 30.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4092, 0, -9061.9296875, 349.757995605, 93.0820999146, 6.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4094, 0, -9118.95996094, 327.821990967, 93.1586990356, 6.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4095, 0, -9182.62011719, 414.856994629, 89.5576019287, 6.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4096, 0, -9218.12988281, 318.62701416, 73.8841018677, 6.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4097, 533, 3320.93554688, -3119.12182617, 297.573394775, 100.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4098, 0, -5163.25, -645.92199707, 397.015014648, 6.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4099, 0, -5175.18994141, -588.085021973, 397.988006592, 6.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4100, 0, 1979.98999023, 305.25201416, 41.1865005493, 6.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4101, 1, 1217.9699707, -4339.29980469, 25.912399292, 6.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4102, 1, 1169.55004883, -4320.06005859, 20.8756008148, 6.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4103, 1, -1545.39001465, 51.3005981445, 5.39339017868, 6.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4104, 1, 9914.16992188, 1864.67004395, 1321.26000977, 6.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4105, 1, 9948.00976562, 1932.5300293, 1328.69995117, 6.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4112, 533, 3716.37988281, -5106.77978516, 141.289993286, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4113, 533, 3432.81005859, -3007.20996094, 295.609008789, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4114, 533, 3432.30004883, -3007.2800293, 295.609008789, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4115, 533, 3322.73999023, -3700.37988281, 262.70098877, 20.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4116, 533, 2740.0, -3383.41992188, 267.684997559, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4117, 533, 2917.0300293, -3344.55004883, 298.145996094, 12.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4119, 533, 3214.34008789, -3476.67993164, 287.071990967, 10.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4120, 533, 3493.44995117, -5375.37988281, 138.167999268, 50.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4156, 533, 3006.09008789, -3434.16992188, 306.195007324, 6.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4158, 533, 3754.55004883, -5115.35986328, 142.434997559, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4162, 1, -7142.04003906, 1397.92004395, 4.32688999176, 4.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4163, 533, 3320.72998047, -3115.07006836, 297.609008789, 100.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4166, 533, 3310.22363281, -2990.23803711, 294.660583496, 100.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4167, 533, 3498.15991211, -5349.02978516, 144.968002319, 50.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4168, 1, -7588.47998047, 756.806030273, -16.4248008728, 4.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4177, 533, 2661.04003906, -3467.16992188, 262.141998291, 90.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4180, 533, 3374.04296875, -3059.25439453, 294.66229248, 0.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4184, 533, 2797.83764648, -3670.59716797, 273.669464111, 6.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4189, 0, 1782.19995117, 151.591995239, -62.2902984619, 1.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4261, 189, 1693.77001953, 1053.33996582, 18.7250003815, 5.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4262, 189, 1617.18005371, -323.432006836, 18.6777992249, 5.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4263, 189, 269.061004639, -211.902999878, 19.2010002136, 5.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4294, 0, 2541.94311523, -4785.32226562, 117.451072693, 80.0);
INSERT INTO `AreaTrigger_vanilla` VALUES (4299, 1, -7376.83984375, 447.272003174, 4.5204501152, 60.0);
DROP TABLE IF EXISTS `WorldMapArea_vanilla`;
CREATE TABLE `WorldMapArea_vanilla` (
`zoneID` smallint(3) unsigned NOT NULL,
`mapID` smallint(3) unsigned NOT NULL,
`areatableID` smallint(3) unsigned NOT NULL,
`name` varchar(255) NOT NULL,
`x_min` float NOT NULL DEFAULT 0.0,
`y_min` float NOT NULL DEFAULT 0.0,
`x_max` float NOT NULL DEFAULT 0.0,
`y_max` float NOT NULL DEFAULT 0.0
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED COMMENT='WorldMapArea';

INSERT INTO `WorldMapArea_vanilla` VALUES (13, 1, 0, "Kalimdor", -11733.2998047, -19733.2109375, 12799.9003906, 17066.5996094);
INSERT INTO `WorldMapArea_vanilla` VALUES (14, 0, 0, "Azeroth", -16000.0, -19199.9003906, 7466.60009766, 16000.0);
INSERT INTO `WorldMapArea_vanilla` VALUES (27, 0, 1, "DunMorogh", -7160.41650391, -3122.91650391, -3877.08325195, 1802.08325195);
INSERT INTO `WorldMapArea_vanilla` VALUES (17, 0, 3, "Badlands", -7547.91650391, -4566.66650391, -5889.58300781, -2079.16650391);
INSERT INTO `WorldMapArea_vanilla` VALUES (19, 0, 4, "BlastedLands", -12800.0, -4591.66650391, -10566.6660156, -1241.66662598);
INSERT INTO `WorldMapArea_vanilla` VALUES (38, 0, 8, "SwampOfSorrows", -11150.0, -4516.66650391, -9620.83300781, -2222.91650391);
INSERT INTO `WorldMapArea_vanilla` VALUES (34, 0, 10, "Duskwood", -11516.6660156, -1866.66662598, -9716.66601562, 833.333312988);
INSERT INTO `WorldMapArea_vanilla` VALUES (40, 0, 11, "Wetlands", -4904.16650391, -4525.0, -2147.91650391, -389.583312988);
INSERT INTO `WorldMapArea_vanilla` VALUES (30, 0, 12, "Elwynn", -10254.1660156, -1935.41662598, -7939.58300781, 1535.41662598);
INSERT INTO `WorldMapArea_vanilla` VALUES (4, 1, 14, "Durotar", -1716.66662598, -7249.99951172, 1808.33325195, -1962.49987793);
INSERT INTO `WorldMapArea_vanilla` VALUES (141, 1, 15, "Dustwallow", -5533.33300781, -6225.0, -2033.33325195, -974.999938965);
INSERT INTO `WorldMapArea_vanilla` VALUES (181, 1, 16, "Aszhara", 1960.41662598, -8347.91601562, 5341.66650391, -3277.08325195);
INSERT INTO `WorldMapArea_vanilla` VALUES (11, 1, 17, "Barrens", -5143.75, -7510.41650391, 1612.49987793, 2622.91650391);
INSERT INTO `WorldMapArea_vanilla` VALUES (22, 0, 28, "WesternPlaguelands", 499.999969482, -3883.33325195, 3366.66650391, 416.666656494);
INSERT INTO `WorldMapArea_vanilla` VALUES (37, 0, 33, "Stranglethorn", -15422.9160156, -4160.41650391, -11168.75, 2220.83325195);
INSERT INTO `WorldMapArea_vanilla` VALUES (15, 0, 36, "Alterac", -366.666656494, -2016.66662598, 1500.0, 783.333312988);
INSERT INTO `WorldMapArea_vanilla` VALUES (35, 0, 38, "LochModan", -6327.08300781, -4752.08300781, -4487.5, -1993.74987793);
INSERT INTO `WorldMapArea_vanilla` VALUES (39, 0, 40, "Westfall", -11733.3330078, -483.333312988, -9400.0, 3016.66650391);
INSERT INTO `WorldMapArea_vanilla` VALUES (32, 0, 41, "DeadwindPass", -11533.3330078, -3333.33325195, -9866.66601562, -833.333312988);
INSERT INTO `WorldMapArea_vanilla` VALUES (36, 0, 44, "Redridge", -10022.9160156, -3741.66650391, -8575.0, -1570.83325195);
INSERT INTO `WorldMapArea_vanilla` VALUES (16, 0, 45, "Arathi", -2533.33325195, -4466.66650391, -133.333328247, -866.666625977);
INSERT INTO `WorldMapArea_vanilla` VALUES (29, 0, 46, "BurningSteppes", -8983.33300781, -3195.83325195, -7031.24951172, -266.666656494);
INSERT INTO `WorldMapArea_vanilla` VALUES (26, 0, 47, "Hinterlands", -1100.0, -5425.0, 1466.66662598, -1575.0);
INSERT INTO `WorldMapArea_vanilla` VALUES (28, 0, 51, "SearingGorge", -7587.49951172, -2554.16650391, -6100.0, -322.916656494);
INSERT INTO `WorldMapArea_vanilla` VALUES (20, 0, 85, "Tirisfal", 824.999938965, -1485.41662598, 3837.49975586, 3033.33325195);
INSERT INTO `WorldMapArea_vanilla` VALUES (21, 0, 130, "Silverpine", -1133.33325195, -750.0, 1666.66662598, 3449.99975586);
INSERT INTO `WorldMapArea_vanilla` VALUES (23, 0, 139, "EasternPlaguelands", 1218.75, -6056.25, 3799.99975586, -2185.41650391);
INSERT INTO `WorldMapArea_vanilla` VALUES (41, 1, 141, "Teldrassil", 8437.5, -1277.08325195, 11831.25, 3814.58325195);
INSERT INTO `WorldMapArea_vanilla` VALUES (42, 1, 148, "Darkshore", 3966.66650391, -3608.33325195, 8333.33300781, 2941.66650391);
INSERT INTO `WorldMapArea_vanilla` VALUES (9, 1, 215, "Mulgore", -3697.91650391, -3089.58325195, -272.916656494, 2047.91662598);
INSERT INTO `WorldMapArea_vanilla` VALUES (24, 0, 267, "Hilsbrad", -1733.33325195, -2133.33325195, 400.0, 1066.66662598);
INSERT INTO `WorldMapArea_vanilla` VALUES (43, 1, 331, "Ashenvale", 829.166625977, -4066.66650391, 4672.91650391, 1699.99987793);
INSERT INTO `WorldMapArea_vanilla` VALUES (121, 1, 357, "Feralas", -6999.99951172, -1508.33325195, -2366.66650391, 5441.66650391);
INSERT INTO `WorldMapArea_vanilla` VALUES (182, 1, 361, "Felwood", 3299.99975586, -4108.33300781, 7133.33300781, 1641.66662598);
INSERT INTO `WorldMapArea_vanilla` VALUES (61, 1, 400, "ThousandNeedles", -6899.99951172, -4833.33300781, -3966.66650391, -433.333312988);
INSERT INTO `WorldMapArea_vanilla` VALUES (101, 1, 405, "Desolace", -2545.83325195, -262.5, 452.083312988, 4233.33300781);
INSERT INTO `WorldMapArea_vanilla` VALUES (81, 1, 406, "StonetalonMountains", -339.583312988, -1637.49987793, 2916.66650391, 3245.83325195);
INSERT INTO `WorldMapArea_vanilla` VALUES (161, 1, 440, "Tanaris", -10475.0, -7118.74951172, -5875.0, -218.749984741);
INSERT INTO `WorldMapArea_vanilla` VALUES (201, 1, 490, "UngoroCrater", -8433.33300781, -3166.66650391, -5966.66650391, 533.333312988);
INSERT INTO `WorldMapArea_vanilla` VALUES (241, 1, 493, "Moonglade", 6952.08300781, -3689.58325195, 8491.66601562, -1381.25);
INSERT INTO `WorldMapArea_vanilla` VALUES (281, 1, 618, "Winterspring", 3799.99975586, -7416.66650391, 8533.33300781, -316.666656494);
INSERT INTO `WorldMapArea_vanilla` VALUES (261, 1, 1377, "Silithus", -8281.25, -945.833984375, -5958.33398438, 2537.5);
INSERT INTO `WorldMapArea_vanilla` VALUES (382, 0, 1497, "Undercity", 1237.84118652, -86.1824035645, 1877.9453125, 873.192626953);
INSERT INTO `WorldMapArea_vanilla` VALUES (301, 0, 1519, "Stormwind", -9175.20507812, 36.700630188, -8278.85058594, 1380.97143555);
INSERT INTO `WorldMapArea_vanilla` VALUES (341, 0, 1537, "Ironforge", -5096.84570312, -1504.21643066, -4569.24121094, -713.591369629);
INSERT INTO `WorldMapArea_vanilla` VALUES (321, 1, 1637, "Ogrimmar", 1338.46057129, -5083.20556641, 2273.87719727, -3680.60107422);
INSERT INTO `WorldMapArea_vanilla` VALUES (362, 1, 1638, "ThunderBluff", -1545.83325195, -527.083312988, -849.999938965, 516.666625977);
INSERT INTO `WorldMapArea_vanilla` VALUES (381, 1, 1657, "Darnassis", 9532.58691406, 1880.02954102, 10238.3164062, 2938.36279297);
INSERT INTO `WorldMapArea_vanilla` VALUES (401, 30, 2597, "AlteracValley", -1739.58325195, -2456.25, 1085.41662598, 1781.24987793);
INSERT INTO `WorldMapArea_vanilla` VALUES (443, 489, 3277, "WarsongGulch", 862.499938965, 895.833312988, 1627.08325195, 2041.66662598);
INSERT INTO `WorldMapArea_vanilla` VALUES (461, 529, 3358, "ArathiBasin", 337.5, 102.083328247, 1508.33325195, 1858.33325195);
DROP TABLE IF EXISTS `FactionTemplate_vanilla`;
CREATE TABLE `FactionTemplate_vanilla` (
`factiontemplateID` smallint(3) unsigned NOT NULL,
`factionID` smallint(3) unsigned NOT NULL,
`A` smallint(1) NOT NULL,
`H` smallint(1) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED COMMENT='WorldMapArea';

INSERT INTO `FactionTemplate_vanilla` VALUES (100, 77, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (1014, 629, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (1015, 629, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (101, 77, 0, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (102, 77, -1, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (1034, 66, -1, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (103, 80, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (10, 40, 1, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (104, 81, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1054, 471, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1055, 471, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (105, 81, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (106, 66, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (107, 33, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1074, 76, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1075, 108, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1076, 69, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1077, 108, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1078, 72, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1080, 31, 1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1081, 74, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (108, 70, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (109, 110, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1094, 23, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (1095, 679, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (1096, 108, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1097, 69, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (110, 110, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1, 1, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1114, 689, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (111, 85, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (112, 85, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (113, 40, 1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1134, 68, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (114, 77, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1154, 68, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (115, 8, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (116, 9, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (11, 72, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1174, 76, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (118, 68, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1194, 709, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (119, 87, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (120, 21, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (121, 21, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (1214, 729, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1215, 729, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1216, 730, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1217, 730, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (122, 47, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1234, 750, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1235, 750, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1236, 750, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (123, 72, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (124, 69, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1254, 609, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (125, 76, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (126, 530, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (12, 72, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (127, 35, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1274, 7, 0, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1275, 7, -1, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (128, 88, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1294, 771, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (129, 89, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (130, 90, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1314, 66, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1315, 189, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (131, 91, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (132, 92, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1334, 730, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1335, 729, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (133, 93, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (134, 94, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1354, 809, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (1355, 809, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (1374, 829, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1375, 77, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (1394, 80, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1395, 916, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (14, 14, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1414, 790, 0, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1415, 849, -1, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (1434, 869, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1454, 36, 1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1474, 59, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (1475, 59, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (148, 14, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (149, 108, 1, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (1494, 893, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1495, 893, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1496, 893, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (150, 108, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (151, 108, 0, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1514, 890, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1515, 889, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (152, 109, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (153, 109, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (1534, 730, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (154, 111, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1554, 729, 0, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1555, 909, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (15, 7, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (1574, 270, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (1575, 72, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1576, 269, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1577, 509, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1594, 69, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1595, 76, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1596, 730, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1597, 729, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1598, 510, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1599, 509, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1600, 69, 1, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (1601, 910, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (1605, 531, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1606, 7, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1607, 7, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1608, 609, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (1611, 47, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1612, 76, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1613, 912, 1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (16, 14, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1614, 14, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1615, 169, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (1616, 919, 1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1617, 918, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1618, 47, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1619, 76, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1620, 128, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1621, 921, 0, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1622, 920, 0, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1624, 529, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (1625, 529, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (1626, 20, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1630, 928, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1634, 928, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (1635, 169, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (1641, 889, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1642, 890, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1673, 950, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (1676, 954, 1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (1677, 951, 1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (168, 128, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (17, 15, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (18, 19, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (188, 148, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (189, 7, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (190, 148, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (19, 17, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (20, 16, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (208, 168, 1, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (209, 168, 1, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (210, 189, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (21, 20, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (2, 2, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (22, 22, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (230, 573, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (231, 40, 1, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (232, 40, 0, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (233, 20, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (23, 54, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (24, 24, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (250, 40, 1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (25, 25, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (26, 25, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (270, 229, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (27, 15, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (28, 26, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (290, 40, 1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (29, 76, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (30, 27, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (310, 249, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (311, 249, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (312, 22, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (31, 28, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (32, 29, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (330, 229, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (3, 3, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (33, 40, 0, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (34, 15, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (350, 88, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (35, 31, 1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (36, 32, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (370, 915, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (371, 269, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (37, 33, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (38, 29, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (390, 21, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (39, 18, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (40, 34, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (410, 43, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (411, 310, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (412, 510, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (413, 309, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (41, 35, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (414, 576, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (415, 311, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (416, 311, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (42, 36, 1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (430, 329, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (43, 35, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (4, 4, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (44, 37, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (450, 229, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (45, 38, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (46, 39, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (470, 311, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (471, 349, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (472, 70, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (473, 349, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (47, 41, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (474, 369, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (475, 369, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (48, 42, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (49, 43, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (494, 389, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (495, 40, 1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (50, 44, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (514, 409, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (51, 45, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (52, 769, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (534, 189, 1, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (53, 49, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (54, 48, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (5, 5, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (554, 429, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (55, 47, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (56, 49, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (574, 449, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (57, 47, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (575, 450, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (58, 7, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (59, 32, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (594, 32, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (60, 50, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (614, 36, 1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (61, 51, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (62, 52, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (634, 14, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (63, 53, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (635, 609, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (636, 576, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (637, 470, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (64, 54, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (654, 82, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (655, 90, 0, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (65, 76, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (6, 6, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (66, 55, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (674, 48, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (67, 56, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (68, 68, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (694, 471, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (69, 470, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (695, 749, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (70, 57, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (714, 66, 0, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (71, 68, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (72, 58, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (734, 48, 1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (735, 489, 1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (736, 489, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (73, 669, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (74, 60, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (754, 48, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (76, 61, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (7, 7, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (774, 40, 1, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (775, 40, 0, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (77, 62, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (776, 910, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (777, 912, 1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (778, 511, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (78, 63, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (794, 529, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (795, 572, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (79, 69, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (80, 69, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (814, 529, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (81, 64, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (82, 65, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (834, 74, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (83, 66, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (84, 189, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (854, 577, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (855, 577, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (85, 76, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (86, 770, 1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (874, 589, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (875, 54, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (876, 530, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (87, 70, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (877, 530, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (88, 71, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (894, 108, 1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (89, 56, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (90, 73, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (914, 679, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (91, 74, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (92, 75, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (93, 14, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (934, 575, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (94, 77, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (954, 73, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (95, 78, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (96, 79, 1, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (974, 20, -1, -1);
INSERT INTO `FactionTemplate_vanilla` VALUES (97, 70, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (98, 68, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (99, 36, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (994, 609, 0, 0);
INSERT INTO `FactionTemplate_vanilla` VALUES (995, 81, -1, 1);
INSERT INTO `FactionTemplate_vanilla` VALUES (996, 609, 0, 0);
DROP TABLE IF EXISTS `Lock_vanilla`;
CREATE TABLE `Lock_vanilla` (
`id` smallint(3) unsigned NOT NULL,
`locktype` smallint(3) NOT NULL,
`data` smallint(3) unsigned NOT NULL,
`skill` smallint(3) unsigned NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED COMMENT='Lock';

INSERT INTO `Lock_vanilla` VALUES (2, 2, 1, 25);
INSERT INTO `Lock_vanilla` VALUES (4, 2, 1, 50);
INSERT INTO `Lock_vanilla` VALUES (5, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (8, 2, 2, 25);
INSERT INTO `Lock_vanilla` VALUES (9, 2, 2, 50);
INSERT INTO `Lock_vanilla` VALUES (10, 2, 2, 75);
INSERT INTO `Lock_vanilla` VALUES (11, 2, 2, 100);
INSERT INTO `Lock_vanilla` VALUES (12, 2, 4, 0);
INSERT INTO `Lock_vanilla` VALUES (13, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (14, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (15, 1, 2629, 0);
INSERT INTO `Lock_vanilla` VALUES (17, 2, 1, 75);
INSERT INTO `Lock_vanilla` VALUES (18, 2, 3, 25);
INSERT INTO `Lock_vanilla` VALUES (19, 2, 3, 50);
INSERT INTO `Lock_vanilla` VALUES (20, 2, 3, 75);
INSERT INTO `Lock_vanilla` VALUES (21, 2, 3, 100);
INSERT INTO `Lock_vanilla` VALUES (22, 2, 3, 125);
INSERT INTO `Lock_vanilla` VALUES (23, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (24, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (25, 2, 3, 150);
INSERT INTO `Lock_vanilla` VALUES (26, 2, 2, 125);
INSERT INTO `Lock_vanilla` VALUES (27, 2, 2, 150);
INSERT INTO `Lock_vanilla` VALUES (29, 2, 2, 0);
INSERT INTO `Lock_vanilla` VALUES (30, 2, 2, 15);
INSERT INTO `Lock_vanilla` VALUES (31, 2, 2, 70);
INSERT INTO `Lock_vanilla` VALUES (32, 2, 2, 115);
INSERT INTO `Lock_vanilla` VALUES (33, 2, 2, 120);
INSERT INTO `Lock_vanilla` VALUES (34, 2, 2, 130);
INSERT INTO `Lock_vanilla` VALUES (35, 2, 2, 140);
INSERT INTO `Lock_vanilla` VALUES (36, 1, 3467, 0);
INSERT INTO `Lock_vanilla` VALUES (37, 1, 3499, 0);
INSERT INTO `Lock_vanilla` VALUES (38, 2, 3, 0);
INSERT INTO `Lock_vanilla` VALUES (39, 2, 3, 65);
INSERT INTO `Lock_vanilla` VALUES (40, 2, 3, 75);
INSERT INTO `Lock_vanilla` VALUES (41, 2, 3, 125);
INSERT INTO `Lock_vanilla` VALUES (42, 2, 3, 155);
INSERT INTO `Lock_vanilla` VALUES (43, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (44, 1, 3710, 0);
INSERT INTO `Lock_vanilla` VALUES (45, 2, 2, 125);
INSERT INTO `Lock_vanilla` VALUES (46, 1, 3745, 0);
INSERT INTO `Lock_vanilla` VALUES (47, 2, 2, 160);
INSERT INTO `Lock_vanilla` VALUES (48, 2, 2, 215);
INSERT INTO `Lock_vanilla` VALUES (49, 2, 2, 185);
INSERT INTO `Lock_vanilla` VALUES (50, 2, 2, 205);
INSERT INTO `Lock_vanilla` VALUES (51, 2, 2, 195);
INSERT INTO `Lock_vanilla` VALUES (52, 1, 3745, 0);
INSERT INTO `Lock_vanilla` VALUES (53, 1, 3930, 0);
INSERT INTO `Lock_vanilla` VALUES (54, 1, 4027, 0);
INSERT INTO `Lock_vanilla` VALUES (55, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (56, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (57, 2, 1, 0);
INSERT INTO `Lock_vanilla` VALUES (58, 1, 4529, 0);
INSERT INTO `Lock_vanilla` VALUES (59, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (60, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (61, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (62, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (63, 1, 4639, 0);
INSERT INTO `Lock_vanilla` VALUES (65, 1, 4750, 0);
INSERT INTO `Lock_vanilla` VALUES (67, 1, 4640, 0);
INSERT INTO `Lock_vanilla` VALUES (68, 1, 4882, 0);
INSERT INTO `Lock_vanilla` VALUES (69, 1, 4986, 0);
INSERT INTO `Lock_vanilla` VALUES (70, 1, 5020, 0);
INSERT INTO `Lock_vanilla` VALUES (71, 1, 5021, 0);
INSERT INTO `Lock_vanilla` VALUES (72, 1, 5059, 0);
INSERT INTO `Lock_vanilla` VALUES (73, 1, 5068, 0);
INSERT INTO `Lock_vanilla` VALUES (75, 1, 5165, 0);
INSERT INTO `Lock_vanilla` VALUES (76, 1, 5185, 0);
INSERT INTO `Lock_vanilla` VALUES (77, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (80, 1, 5338, 0);
INSERT INTO `Lock_vanilla` VALUES (81, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (82, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (83, 1, 5397, 0);
INSERT INTO `Lock_vanilla` VALUES (84, 1, 5396, 0);
INSERT INTO `Lock_vanilla` VALUES (85, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (86, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (88, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (89, 1, 5475, 0);
INSERT INTO `Lock_vanilla` VALUES (90, 1, 5521, 0);
INSERT INTO `Lock_vanilla` VALUES (91, 1, 5384, 0);
INSERT INTO `Lock_vanilla` VALUES (92, 1, 6893, 0);
INSERT INTO `Lock_vanilla` VALUES (93, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (94, 1, 5687, 0);
INSERT INTO `Lock_vanilla` VALUES (95, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (97, 1, 5851, 0);
INSERT INTO `Lock_vanilla` VALUES (98, 1, 5868, 0);
INSERT INTO `Lock_vanilla` VALUES (99, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (119, 1, 5916, 0);
INSERT INTO `Lock_vanilla` VALUES (139, 1, 5937, 0);
INSERT INTO `Lock_vanilla` VALUES (159, 1, 6074, 0);
INSERT INTO `Lock_vanilla` VALUES (179, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (199, 1, 6208, 0);
INSERT INTO `Lock_vanilla` VALUES (200, 1, 6210, 0);
INSERT INTO `Lock_vanilla` VALUES (202, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (203, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (239, 1, 6783, 0);
INSERT INTO `Lock_vanilla` VALUES (259, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (279, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (299, 1, 7146, 0);
INSERT INTO `Lock_vanilla` VALUES (319, 1, 7208, 0);
INSERT INTO `Lock_vanilla` VALUES (359, 1, 7733, 0);
INSERT INTO `Lock_vanilla` VALUES (379, 2, 3, 175);
INSERT INTO `Lock_vanilla` VALUES (380, 2, 3, 230);
INSERT INTO `Lock_vanilla` VALUES (399, 2, 3, 310);
INSERT INTO `Lock_vanilla` VALUES (400, 2, 3, 245);
INSERT INTO `Lock_vanilla` VALUES (419, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (420, 1, 8444, 0);
INSERT INTO `Lock_vanilla` VALUES (439, 2, 2, 210);
INSERT INTO `Lock_vanilla` VALUES (440, 2, 2, 220);
INSERT INTO `Lock_vanilla` VALUES (441, 2, 2, 230);
INSERT INTO `Lock_vanilla` VALUES (442, 2, 2, 235);
INSERT INTO `Lock_vanilla` VALUES (443, 2, 2, 245);
INSERT INTO `Lock_vanilla` VALUES (444, 2, 2, 250);
INSERT INTO `Lock_vanilla` VALUES (459, 1, 9240, 0);
INSERT INTO `Lock_vanilla` VALUES (460, 1, 9249, 0);
INSERT INTO `Lock_vanilla` VALUES (479, 1, 9299, 0);
INSERT INTO `Lock_vanilla` VALUES (499, 1, 9472, 0);
INSERT INTO `Lock_vanilla` VALUES (519, 2, 2, 85);
INSERT INTO `Lock_vanilla` VALUES (520, 1, 10460, 0);
INSERT INTO `Lock_vanilla` VALUES (521, 2, 2, 170);
INSERT INTO `Lock_vanilla` VALUES (540, 1, 10445, 0);
INSERT INTO `Lock_vanilla` VALUES (559, 1, 10515, 0);
INSERT INTO `Lock_vanilla` VALUES (579, 1, 10757, 0);
INSERT INTO `Lock_vanilla` VALUES (599, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (600, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (601, 1, 10757, 0);
INSERT INTO `Lock_vanilla` VALUES (639, 1, 11078, 0);
INSERT INTO `Lock_vanilla` VALUES (640, 1, 11079, 0);
INSERT INTO `Lock_vanilla` VALUES (659, 1, 11197, 0);
INSERT INTO `Lock_vanilla` VALUES (679, 1, 11115, 0);
INSERT INTO `Lock_vanilla` VALUES (680, 1, 11000, 0);
INSERT INTO `Lock_vanilla` VALUES (699, 1, 11140, 0);
INSERT INTO `Lock_vanilla` VALUES (719, 2, 3, 230);
INSERT INTO `Lock_vanilla` VALUES (739, 1, 11602, 0);
INSERT INTO `Lock_vanilla` VALUES (740, 2, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (759, 1, 11000, 0);
INSERT INTO `Lock_vanilla` VALUES (779, 1, 11833, 0);
INSERT INTO `Lock_vanilla` VALUES (799, 1, 11885, 0);
INSERT INTO `Lock_vanilla` VALUES (820, 1, 12344, 0);
INSERT INTO `Lock_vanilla` VALUES (821, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (839, 1, 12186, 0);
INSERT INTO `Lock_vanilla` VALUES (859, 1, 12301, 0);
INSERT INTO `Lock_vanilla` VALUES (879, 1, 12382, 0);
INSERT INTO `Lock_vanilla` VALUES (899, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (920, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (939, 2, 3, 275);
INSERT INTO `Lock_vanilla` VALUES (959, 1, 12785, 0);
INSERT INTO `Lock_vanilla` VALUES (960, 1, 12814, 0);
INSERT INTO `Lock_vanilla` VALUES (979, 1, 12891, 0);
INSERT INTO `Lock_vanilla` VALUES (999, 1, 12906, 0);
INSERT INTO `Lock_vanilla` VALUES (1019, 1, 12942, 0);
INSERT INTO `Lock_vanilla` VALUES (1039, 1, 12973, 0);
INSERT INTO `Lock_vanilla` VALUES (1059, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (1079, 1, 13302, 0);
INSERT INTO `Lock_vanilla` VALUES (1080, 1, 13303, 0);
INSERT INTO `Lock_vanilla` VALUES (1081, 1, 13304, 0);
INSERT INTO `Lock_vanilla` VALUES (1082, 1, 13305, 0);
INSERT INTO `Lock_vanilla` VALUES (1083, 1, 13306, 0);
INSERT INTO `Lock_vanilla` VALUES (1084, 1, 13307, 0);
INSERT INTO `Lock_vanilla` VALUES (1085, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (1099, 2, 10, 0);
INSERT INTO `Lock_vanilla` VALUES (1119, 2, 2, 260);
INSERT INTO `Lock_vanilla` VALUES (1120, 2, 2, 270);
INSERT INTO `Lock_vanilla` VALUES (1121, 2, 2, 280);
INSERT INTO `Lock_vanilla` VALUES (1122, 2, 2, 285);
INSERT INTO `Lock_vanilla` VALUES (1123, 2, 2, 290);
INSERT INTO `Lock_vanilla` VALUES (1124, 2, 2, 300);
INSERT INTO `Lock_vanilla` VALUES (1159, 1, 13704, 0);
INSERT INTO `Lock_vanilla` VALUES (1179, 1, 13523, 0);
INSERT INTO `Lock_vanilla` VALUES (1199, 1, 13873, 0);
INSERT INTO `Lock_vanilla` VALUES (1219, 1, 14523, 0);
INSERT INTO `Lock_vanilla` VALUES (1239, 1, 14547, 0);
INSERT INTO `Lock_vanilla` VALUES (1259, 1, 15042, 0);
INSERT INTO `Lock_vanilla` VALUES (1299, 1, 15766, 0);
INSERT INTO `Lock_vanilla` VALUES (1319, 2, 12, 0);
INSERT INTO `Lock_vanilla` VALUES (1340, 1, 16208, 0);
INSERT INTO `Lock_vanilla` VALUES (1359, 1, 16308, 0);
INSERT INTO `Lock_vanilla` VALUES (1379, 1, 16333, 0);
INSERT INTO `Lock_vanilla` VALUES (1399, 1, 16603, 0);
INSERT INTO `Lock_vanilla` VALUES (1419, 1, 17242, 0);
INSERT INTO `Lock_vanilla` VALUES (1439, 1, 17262, 0);
INSERT INTO `Lock_vanilla` VALUES (1459, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (1479, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (1499, 1, 17696, 0);
INSERT INTO `Lock_vanilla` VALUES (1539, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (1559, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (1560, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (1561, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (1562, 1, 18249, 0);
INSERT INTO `Lock_vanilla` VALUES (1563, 1, 18266, 0);
INSERT INTO `Lock_vanilla` VALUES (1564, 1, 18268, 0);
INSERT INTO `Lock_vanilla` VALUES (1580, 1, 18629, 0);
INSERT INTO `Lock_vanilla` VALUES (1599, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (1619, 1, 19931, 0);
INSERT INTO `Lock_vanilla` VALUES (1620, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (1621, 2, 19, 25);
INSERT INTO `Lock_vanilla` VALUES (1622, 1, 21172, 0);
INSERT INTO `Lock_vanilla` VALUES (1623, 1, 21174, 0);
INSERT INTO `Lock_vanilla` VALUES (1624, 2, 19, 50);
INSERT INTO `Lock_vanilla` VALUES (1625, 2, 19, 100);
INSERT INTO `Lock_vanilla` VALUES (1626, 2, 19, 175);
INSERT INTO `Lock_vanilla` VALUES (1627, 2, 19, 250);
INSERT INTO `Lock_vanilla` VALUES (1628, 2, 19, 375);
INSERT INTO `Lock_vanilla` VALUES (1629, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (1630, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (1632, 2, 3, 305);
INSERT INTO `Lock_vanilla` VALUES (1634, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (1635, 0, 0, 0);
INSERT INTO `Lock_vanilla` VALUES (1636, 1, 22486, 0);
INSERT INTO `Lock_vanilla` VALUES (1647, 1, 23055, 0);
DROP TABLE IF EXISTS `SkillLine_vanilla`;
CREATE TABLE `SkillLine_vanilla` (
`id` smallint(3) unsigned NOT NULL,
`name_loc0` varchar(255) NOT NULL,
`name_loc1` varchar(255) NOT NULL,
`name_loc2` varchar(255) NOT NULL,
`name_loc3` varchar(255) NOT NULL,
`name_loc4` varchar(255) NOT NULL,
`name_loc5` varchar(255) NOT NULL,
`name_loc6` varchar(255) NOT NULL,
`name_loc7` varchar(255) NOT NULL,
`name_loc8` varchar(255) NOT NULL,
`name_loc10` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED COMMENT='SkillLine';

INSERT INTO `SkillLine_vanilla` VALUES (6, "Frost", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (8, "Fire", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (26, "Arms", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (38, "Combat", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (39, "Subtlety", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (40, "Poisons", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (43, "Swords", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (44, "Axes", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (45, "Bows", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (46, "Guns", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (50, "Beast Mastery", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (51, "Survival", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (54, "Maces", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (55, "Two-Handed Swords", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (56, "Holy", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (78, "Shadow Magic", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (95, "Defense", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (98, "Language: Common", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (101, "Dwarven Racial", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (109, "Language: Orcish", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (111, "Language: Dwarven", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (113, "Language: Darnassian", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (115, "Language: Taurahe", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (118, "Dual Wield", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (124, "Tauren Racial", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (125, "Orc Racial", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (126, "Night Elf Racial", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (129, "First Aid", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (134, "Feral Combat", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (136, "Staves", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (137, "Language: Thalassian", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (138, "Language: Draconic", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (139, "Language: Demon Tongue", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (140, "Language: Titan", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (141, "Language: Old Tongue", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (142, "Survival", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (148, "Horse Riding", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (149, "Wolf Riding", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (150, "Tiger Riding", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (152, "Ram Riding", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (155, "Swimming", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (160, "Two-Handed Maces", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (162, "Unarmed", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (163, "Marksmanship", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (164, "Blacksmithing", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (165, "Leatherworking", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (171, "Alchemy", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (172, "Two-Handed Axes", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (173, "Daggers", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (176, "Thrown", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (182, "Herbalism", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (183, "GENERIC (DND)", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (184, "Retribution", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (185, "Cooking", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (186, "Mining", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (188, "Pet - Imp", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (189, "Pet - Felhunter", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (197, "Tailoring", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (202, "Engineering", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (203, "Pet - Spider", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (204, "Pet - Voidwalker", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (205, "Pet - Succubus", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (206, "Pet - Infernal", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (207, "Pet - Doomguard", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (208, "Pet - Wolf", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (209, "Pet - Cat", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (210, "Pet - Bear", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (211, "Pet - Boar", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (212, "Pet - Crocilisk", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (213, "Pet - Carrion Bird", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (214, "Pet - Crab", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (215, "Pet - Gorilla", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (217, "Pet - Raptor", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (218, "Pet - Tallstrider", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (220, "Racial - Undead", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (226, "Crossbows", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (228, "Wands", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (229, "Polearms", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (236, "Pet - Scorpid", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (237, "Arcane", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (251, "Pet - Turtle", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (253, "Assassination", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (256, "Fury", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (257, "Protection", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (261, "Beast Training", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (267, "Protection", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (270, "Pet - Generic", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (293, "Plate Mail", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (313, "Language: Gnomish", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (315, "Language: Troll", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (333, "Enchanting", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (354, "Demonology", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (355, "Affliction", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (356, "Fishing", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (373, "Enhancement", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (374, "Restoration", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (375, "Elemental Combat", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (393, "Skinning", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (413, "Mail", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (414, "Leather", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (415, "Cloth", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (433, "Shield", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (473, "Fist Weapons", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (533, "Raptor Riding", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (553, "Mechanostrider Piloting", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (554, "Undead Horsemanship", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (573, "Restoration", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (574, "Balance", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (593, "Destruction", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (594, "Holy", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (613, "Discipline", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (633, "Lockpicking", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (653, "Pet - Bat", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (654, "Pet - Hyena", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (655, "Pet - Owl", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (656, "Pet - Wind Serpent", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (673, "Language: Gutterspeak", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (713, "Kodo Riding", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (733, "Racial - Troll", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (753, "Racial - Gnome", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (754, "Racial - Human", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (758, "Pet - Event - Remote Control", '', '', '', '', '', '', '', '', '');
INSERT INTO `SkillLine_vanilla` VALUES (762, "Riding", '', '', '', '', '', '', '', '', '');
UPDATE `SkillLine_vanilla` SET name_loc1 = "냉기" WHERE id = 6;
UPDATE `SkillLine_vanilla` SET name_loc1 = "화염" WHERE id = 8;
UPDATE `SkillLine_vanilla` SET name_loc1 = "무기" WHERE id = 26;
UPDATE `SkillLine_vanilla` SET name_loc1 = "전투" WHERE id = 38;
UPDATE `SkillLine_vanilla` SET name_loc1 = "잠행" WHERE id = 39;
UPDATE `SkillLine_vanilla` SET name_loc1 = "독" WHERE id = 40;
UPDATE `SkillLine_vanilla` SET name_loc1 = "도검류" WHERE id = 43;
UPDATE `SkillLine_vanilla` SET name_loc1 = "도끼류" WHERE id = 44;
UPDATE `SkillLine_vanilla` SET name_loc1 = "활류" WHERE id = 45;
UPDATE `SkillLine_vanilla` SET name_loc1 = "총기류" WHERE id = 46;
UPDATE `SkillLine_vanilla` SET name_loc1 = "야수" WHERE id = 50;
UPDATE `SkillLine_vanilla` SET name_loc1 = "생존" WHERE id = 51;
UPDATE `SkillLine_vanilla` SET name_loc1 = "둔기류" WHERE id = 54;
UPDATE `SkillLine_vanilla` SET name_loc1 = "양손 도검류" WHERE id = 55;
UPDATE `SkillLine_vanilla` SET name_loc1 = "신성" WHERE id = 56;
UPDATE `SkillLine_vanilla` SET name_loc1 = "암흑" WHERE id = 78;
UPDATE `SkillLine_vanilla` SET name_loc1 = "방어" WHERE id = 95;
UPDATE `SkillLine_vanilla` SET name_loc1 = "언어: 공용어" WHERE id = 98;
UPDATE `SkillLine_vanilla` SET name_loc1 = "드워프 종족 특성" WHERE id = 101;
UPDATE `SkillLine_vanilla` SET name_loc1 = "언어: 오크어" WHERE id = 109;
UPDATE `SkillLine_vanilla` SET name_loc1 = "언어: 드워프어" WHERE id = 111;
UPDATE `SkillLine_vanilla` SET name_loc1 = "언어: 나이트 엘프어" WHERE id = 113;
UPDATE `SkillLine_vanilla` SET name_loc1 = "언어: 타우렌어" WHERE id = 115;
UPDATE `SkillLine_vanilla` SET name_loc1 = "쌍수 무기" WHERE id = 118;
UPDATE `SkillLine_vanilla` SET name_loc1 = "타우렌 종족 특성" WHERE id = 124;
UPDATE `SkillLine_vanilla` SET name_loc1 = "오크 종족 특성" WHERE id = 125;
UPDATE `SkillLine_vanilla` SET name_loc1 = "나이트 엘프 족종 특성" WHERE id = 126;
UPDATE `SkillLine_vanilla` SET name_loc1 = "응급치료" WHERE id = 129;
UPDATE `SkillLine_vanilla` SET name_loc1 = "야성" WHERE id = 134;
UPDATE `SkillLine_vanilla` SET name_loc1 = "지팡이류" WHERE id = 136;
UPDATE `SkillLine_vanilla` SET name_loc1 = "언어: 하이엘프어" WHERE id = 137;
UPDATE `SkillLine_vanilla` SET name_loc1 = "언어: 용언" WHERE id = 138;
UPDATE `SkillLine_vanilla` SET name_loc1 = "언어: 악마어" WHERE id = 139;
UPDATE `SkillLine_vanilla` SET name_loc1 = "언어: 티탄어" WHERE id = 140;
UPDATE `SkillLine_vanilla` SET name_loc1 = "언어: 고대어" WHERE id = 141;
UPDATE `SkillLine_vanilla` SET name_loc1 = "야영" WHERE id = 142;
UPDATE `SkillLine_vanilla` SET name_loc1 = "말 타기" WHERE id = 148;
UPDATE `SkillLine_vanilla` SET name_loc1 = "늑대 타기" WHERE id = 149;
UPDATE `SkillLine_vanilla` SET name_loc1 = "호랑이 타기" WHERE id = 150;
UPDATE `SkillLine_vanilla` SET name_loc1 = "산양 타기" WHERE id = 152;
UPDATE `SkillLine_vanilla` SET name_loc1 = "수영" WHERE id = 155;
UPDATE `SkillLine_vanilla` SET name_loc1 = "양손 둔기류" WHERE id = 160;
UPDATE `SkillLine_vanilla` SET name_loc1 = "맨손 전투" WHERE id = 162;
UPDATE `SkillLine_vanilla` SET name_loc1 = "사격" WHERE id = 163;
UPDATE `SkillLine_vanilla` SET name_loc1 = "대장기술" WHERE id = 164;
UPDATE `SkillLine_vanilla` SET name_loc1 = "가죽 세공" WHERE id = 165;
UPDATE `SkillLine_vanilla` SET name_loc1 = "연금술" WHERE id = 171;
UPDATE `SkillLine_vanilla` SET name_loc1 = "양손 도끼류" WHERE id = 172;
UPDATE `SkillLine_vanilla` SET name_loc1 = "단검류" WHERE id = 173;
UPDATE `SkillLine_vanilla` SET name_loc1 = "투척 무기류" WHERE id = 176;
UPDATE `SkillLine_vanilla` SET name_loc1 = "약초 채집" WHERE id = 182;
UPDATE `SkillLine_vanilla` SET name_loc1 = "일반 (DND)" WHERE id = 183;
UPDATE `SkillLine_vanilla` SET name_loc1 = "징벌" WHERE id = 184;
UPDATE `SkillLine_vanilla` SET name_loc1 = "요리" WHERE id = 185;
UPDATE `SkillLine_vanilla` SET name_loc1 = "채광" WHERE id = 186;
UPDATE `SkillLine_vanilla` SET name_loc1 = "소환수 - 임프" WHERE id = 188;
UPDATE `SkillLine_vanilla` SET name_loc1 = "소환수 - 지옥사냥개" WHERE id = 189;
UPDATE `SkillLine_vanilla` SET name_loc1 = "재봉술" WHERE id = 197;
UPDATE `SkillLine_vanilla` SET name_loc1 = "기계공학" WHERE id = 202;
UPDATE `SkillLine_vanilla` SET name_loc1 = "소환수 - 거미" WHERE id = 203;
UPDATE `SkillLine_vanilla` SET name_loc1 = "소환수 - 보이드워커" WHERE id = 204;
UPDATE `SkillLine_vanilla` SET name_loc1 = "소환수 - 서큐버스" WHERE id = 205;
UPDATE `SkillLine_vanilla` SET name_loc1 = "소환수 - 지옥불정령" WHERE id = 206;
UPDATE `SkillLine_vanilla` SET name_loc1 = "소환수 - 파멸의수호병" WHERE id = 207;
UPDATE `SkillLine_vanilla` SET name_loc1 = "야수 - 늑대" WHERE id = 208;
UPDATE `SkillLine_vanilla` SET name_loc1 = "야수 - 살쾡이" WHERE id = 209;
UPDATE `SkillLine_vanilla` SET name_loc1 = "야수 - 곰" WHERE id = 210;
UPDATE `SkillLine_vanilla` SET name_loc1 = "야수 - 멧돼지" WHERE id = 211;
UPDATE `SkillLine_vanilla` SET name_loc1 = "야수 - 악어" WHERE id = 212;
UPDATE `SkillLine_vanilla` SET name_loc1 = "야수 - 독수리" WHERE id = 213;
UPDATE `SkillLine_vanilla` SET name_loc1 = "야수 - 게" WHERE id = 214;
UPDATE `SkillLine_vanilla` SET name_loc1 = "야수 - 고릴라" WHERE id = 215;
UPDATE `SkillLine_vanilla` SET name_loc1 = "야수 - 랩터" WHERE id = 217;
UPDATE `SkillLine_vanilla` SET name_loc1 = "야수 - 타조" WHERE id = 218;
UPDATE `SkillLine_vanilla` SET name_loc1 = "언데드 종족 특성" WHERE id = 220;
UPDATE `SkillLine_vanilla` SET name_loc1 = "석궁류" WHERE id = 226;
UPDATE `SkillLine_vanilla` SET name_loc1 = "마법봉류" WHERE id = 228;
UPDATE `SkillLine_vanilla` SET name_loc1 = "장창류" WHERE id = 229;
UPDATE `SkillLine_vanilla` SET name_loc1 = "야수 - 전갈" WHERE id = 236;
UPDATE `SkillLine_vanilla` SET name_loc1 = "비전" WHERE id = 237;
UPDATE `SkillLine_vanilla` SET name_loc1 = "야수 - 거북" WHERE id = 251;
UPDATE `SkillLine_vanilla` SET name_loc1 = "암살" WHERE id = 253;
UPDATE `SkillLine_vanilla` SET name_loc1 = "분노" WHERE id = 256;
UPDATE `SkillLine_vanilla` SET name_loc1 = "보호" WHERE id = 257;
UPDATE `SkillLine_vanilla` SET name_loc1 = "동물 훈련" WHERE id = 261;
UPDATE `SkillLine_vanilla` SET name_loc1 = "보호" WHERE id = 267;
UPDATE `SkillLine_vanilla` SET name_loc1 = "야수 - 일반" WHERE id = 270;
UPDATE `SkillLine_vanilla` SET name_loc1 = "판금 갑옷" WHERE id = 293;
UPDATE `SkillLine_vanilla` SET name_loc1 = "언어: 노움어" WHERE id = 313;
UPDATE `SkillLine_vanilla` SET name_loc1 = "언어: 트롤어" WHERE id = 315;
UPDATE `SkillLine_vanilla` SET name_loc1 = "마법부여" WHERE id = 333;
UPDATE `SkillLine_vanilla` SET name_loc1 = "악마" WHERE id = 354;
UPDATE `SkillLine_vanilla` SET name_loc1 = "고통" WHERE id = 355;
UPDATE `SkillLine_vanilla` SET name_loc1 = "낚시" WHERE id = 356;
UPDATE `SkillLine_vanilla` SET name_loc1 = "고양" WHERE id = 373;
UPDATE `SkillLine_vanilla` SET name_loc1 = "복원" WHERE id = 374;
UPDATE `SkillLine_vanilla` SET name_loc1 = "정기" WHERE id = 375;
UPDATE `SkillLine_vanilla` SET name_loc1 = "무두질" WHERE id = 393;
UPDATE `SkillLine_vanilla` SET name_loc1 = "사슬" WHERE id = 413;
UPDATE `SkillLine_vanilla` SET name_loc1 = "가죽" WHERE id = 414;
UPDATE `SkillLine_vanilla` SET name_loc1 = "천" WHERE id = 415;
UPDATE `SkillLine_vanilla` SET name_loc1 = "방패" WHERE id = 433;
UPDATE `SkillLine_vanilla` SET name_loc1 = "장착 무기류" WHERE id = 473;
UPDATE `SkillLine_vanilla` SET name_loc1 = "랩터 타기" WHERE id = 533;
UPDATE `SkillLine_vanilla` SET name_loc1 = "기계타조 조종" WHERE id = 553;
UPDATE `SkillLine_vanilla` SET name_loc1 = "언데드 승마술" WHERE id = 554;
UPDATE `SkillLine_vanilla` SET name_loc1 = "회복" WHERE id = 573;
UPDATE `SkillLine_vanilla` SET name_loc1 = "조화" WHERE id = 574;
UPDATE `SkillLine_vanilla` SET name_loc1 = "파괴" WHERE id = 593;
UPDATE `SkillLine_vanilla` SET name_loc1 = "신성" WHERE id = 594;
UPDATE `SkillLine_vanilla` SET name_loc1 = "수양" WHERE id = 613;
UPDATE `SkillLine_vanilla` SET name_loc1 = "자물쇠 따기" WHERE id = 633;
UPDATE `SkillLine_vanilla` SET name_loc1 = "야수 - 박쥐" WHERE id = 653;
UPDATE `SkillLine_vanilla` SET name_loc1 = "야수 - 하이에나" WHERE id = 654;
UPDATE `SkillLine_vanilla` SET name_loc1 = "야수 - 올빼미" WHERE id = 655;
UPDATE `SkillLine_vanilla` SET name_loc1 = "야수 - 천둥매" WHERE id = 656;
UPDATE `SkillLine_vanilla` SET name_loc1 = "언어: 언데드어" WHERE id = 673;
UPDATE `SkillLine_vanilla` SET name_loc1 = "코도 타기" WHERE id = 713;
UPDATE `SkillLine_vanilla` SET name_loc1 = "트롤 종족 특성" WHERE id = 733;
UPDATE `SkillLine_vanilla` SET name_loc1 = "노움 종족 특성" WHERE id = 753;
UPDATE `SkillLine_vanilla` SET name_loc1 = "인간 종족 특성" WHERE id = 754;
UPDATE `SkillLine_vanilla` SET name_loc1 = "이벤트 - 원격조종" WHERE id = 758;
UPDATE `SkillLine_vanilla` SET name_loc1 = "탈것 타기" WHERE id = 762;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Givre" WHERE id = 6;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Feu" WHERE id = 8;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Armes" WHERE id = 26;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Combat" WHERE id = 38;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Finesse" WHERE id = 39;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Poisons" WHERE id = 40;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Epées" WHERE id = 43;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Haches" WHERE id = 44;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Arcs" WHERE id = 45;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Armes à feu" WHERE id = 46;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Maîtrise des bêtes" WHERE id = 50;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Survie" WHERE id = 51;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Masse" WHERE id = 54;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Epées à deux mains" WHERE id = 55;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Sacré" WHERE id = 56;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Magie de l'ombre" WHERE id = 78;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Défense" WHERE id = 95;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Langue : commun" WHERE id = 98;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Raciale nain" WHERE id = 101;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Langue : orc" WHERE id = 109;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Langue : nain" WHERE id = 111;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Langue : darnassien" WHERE id = 113;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Langue : taurahe" WHERE id = 115;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Ambidextrie" WHERE id = 118;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Raciale tauren" WHERE id = 124;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Raciale orc" WHERE id = 125;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Raciale elfe de la nuit" WHERE id = 126;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Secourisme" WHERE id = 129;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Combat farouche" WHERE id = 134;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Bâtons" WHERE id = 136;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Langue : thalassien" WHERE id = 137;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Langue : draconique" WHERE id = 138;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Langue : démoniaque" WHERE id = 139;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Langue : titan" WHERE id = 140;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Langue : langue ancienne" WHERE id = 141;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Survie" WHERE id = 142;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Equitation" WHERE id = 148;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Monte de loup" WHERE id = 149;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Monte de tigre" WHERE id = 150;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Monte de bélier" WHERE id = 152;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Natation" WHERE id = 155;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Masses à deux mains" WHERE id = 160;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Mains nues" WHERE id = 162;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Précision" WHERE id = 163;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Forge" WHERE id = 164;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Travail du cuir" WHERE id = 165;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Alchimie" WHERE id = 171;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Haches à deux mains" WHERE id = 172;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Dagues" WHERE id = 173;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Armes de jet" WHERE id = 176;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Herboristerie" WHERE id = 182;
UPDATE `SkillLine_vanilla` SET name_loc2 = "GENERIQUE (DND)" WHERE id = 183;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Vindicte" WHERE id = 184;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Cuisine" WHERE id = 185;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Minage" WHERE id = 186;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Familier - diablotin" WHERE id = 188;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Familier – Chasseur corrompu" WHERE id = 189;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Couture" WHERE id = 197;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Ingénierie" WHERE id = 202;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Familier - araignée" WHERE id = 203;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Familier - Marcheur du Vide" WHERE id = 204;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Familier - Succube" WHERE id = 205;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Familier - Infernal" WHERE id = 206;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Familier - garde funeste" WHERE id = 207;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Familier - loup" WHERE id = 208;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Familier - félin" WHERE id = 209;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Familier - ours" WHERE id = 210;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Familier - sanglier" WHERE id = 211;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Familier - crocilisque" WHERE id = 212;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Familier - charognard" WHERE id = 213;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Familier - crabe" WHERE id = 214;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Familier - gorille" WHERE id = 215;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Familier - raptor" WHERE id = 217;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Familier - haut-trotteur" WHERE id = 218;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Racial - morts-vivants" WHERE id = 220;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Arbalètes" WHERE id = 226;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Baguettes" WHERE id = 228;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Armes d'hast" WHERE id = 229;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Familier - scorpide" WHERE id = 236;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Arcane" WHERE id = 237;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Familier - tortue" WHERE id = 251;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Assassinat" WHERE id = 253;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Fureur" WHERE id = 256;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Protection" WHERE id = 257;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Dressage des bêtes" WHERE id = 261;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Protection" WHERE id = 267;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Familier - générique" WHERE id = 270;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Armure en plaques" WHERE id = 293;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Langue : gnome" WHERE id = 313;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Langue : troll" WHERE id = 315;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Enchantement" WHERE id = 333;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Démonologie" WHERE id = 354;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Affliction" WHERE id = 355;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Pêche" WHERE id = 356;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Amélioration" WHERE id = 373;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Restauration" WHERE id = 374;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Combat élémentaire" WHERE id = 375;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Dépeçage" WHERE id = 393;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Mailles" WHERE id = 413;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Cuir" WHERE id = 414;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Tissu" WHERE id = 415;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Bouclier" WHERE id = 433;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Armes de pugilat" WHERE id = 473;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Monte de raptor" WHERE id = 533;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Pilotage de mécanotrotteur" WHERE id = 553;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Monte de cheval squelette" WHERE id = 554;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Restauration" WHERE id = 573;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Equilibre" WHERE id = 574;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Destruction" WHERE id = 593;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Sacré" WHERE id = 594;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Discipline" WHERE id = 613;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Crochetage" WHERE id = 633;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Familier - chauve-souris" WHERE id = 653;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Familier - hyène" WHERE id = 654;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Familier - chouette" WHERE id = 655;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Familier - serpent des vents" WHERE id = 656;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Langue : bas-parler" WHERE id = 673;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Monte de kodo" WHERE id = 713;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Racial - troll" WHERE id = 733;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Racial - gnome" WHERE id = 753;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Racial - humain" WHERE id = 754;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Familier - Evénement - Télécommande" WHERE id = 758;
UPDATE `SkillLine_vanilla` SET name_loc2 = "Monte" WHERE id = 762;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Frost" WHERE id = 6;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Feuer" WHERE id = 8;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Waffen" WHERE id = 26;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Kampf" WHERE id = 38;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Täuschung" WHERE id = 39;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Gifte" WHERE id = 40;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Schwerter" WHERE id = 43;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Äxte" WHERE id = 44;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Bogen" WHERE id = 45;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Schusswaffen" WHERE id = 46;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Tierherrschaft" WHERE id = 50;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Überleben" WHERE id = 51;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Streitkolben" WHERE id = 54;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Zweihandschwerter" WHERE id = 55;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Heilig" WHERE id = 56;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Schattenmagie" WHERE id = 78;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Verteidigung" WHERE id = 95;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Sprache: Gemeinsprache" WHERE id = 98;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Zwergenvolk" WHERE id = 101;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Sprache: Orcisch" WHERE id = 109;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Sprache: Zwergisch" WHERE id = 111;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Sprache: Darnassisch" WHERE id = 113;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Sprache: Taurisch" WHERE id = 115;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Beidhändigkeit" WHERE id = 118;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Taurenvolk" WHERE id = 124;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Orcvolk" WHERE id = 125;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Nachtelfenvolk" WHERE id = 126;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Erste Hilfe" WHERE id = 129;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Wilder Kampf" WHERE id = 134;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Stäbe" WHERE id = 136;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Sprache: Thalassisch" WHERE id = 137;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Sprache: Drachisch" WHERE id = 138;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Sprache: Dämonisch" WHERE id = 139;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Sprache: Titanisch" WHERE id = 140;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Sprache: Alte Sprache" WHERE id = 141;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Überlebenskunst" WHERE id = 142;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Pferdreiten" WHERE id = 148;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Wolfreiten" WHERE id = 149;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Tigerreiten" WHERE id = 150;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Widderreiten" WHERE id = 152;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Schwimmen" WHERE id = 155;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Zweihandstreitkolben" WHERE id = 160;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Unbewaffnet" WHERE id = 162;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Treffsicherheit" WHERE id = 163;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Schmiedekunst" WHERE id = 164;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Lederverarbeitung" WHERE id = 165;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Alchimie" WHERE id = 171;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Zweihandäxte" WHERE id = 172;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Dolche" WHERE id = 173;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Wurfwaffen" WHERE id = 176;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Kräuterkunde" WHERE id = 182;
UPDATE `SkillLine_vanilla` SET name_loc3 = "ALLGEMEIN (DND)" WHERE id = 183;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Vergeltung" WHERE id = 184;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Kochkunst" WHERE id = 185;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Bergbau" WHERE id = 186;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Tier - Wichtel" WHERE id = 188;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Tier - Teufelsjäger" WHERE id = 189;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Schneiderei" WHERE id = 197;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Ingenieurskunst" WHERE id = 202;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Tier - Spinne" WHERE id = 203;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Tier - Leerwandler" WHERE id = 204;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Tier - Sukkubus" WHERE id = 205;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Tier - Höllenbestie" WHERE id = 206;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Tier - Verdammniswache" WHERE id = 207;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Tier - Wolf" WHERE id = 208;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Tier - Katze" WHERE id = 209;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Tier - Bär" WHERE id = 210;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Tier - Eber" WHERE id = 211;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Tier - Krokilisk" WHERE id = 212;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Tier - Aasvogel" WHERE id = 213;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Tier - Krebs" WHERE id = 214;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Tier - Gorilla" WHERE id = 215;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Tier - Raptor" WHERE id = 217;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Tier - Weitschreiter" WHERE id = 218;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Volk - Untote" WHERE id = 220;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Armbrüste" WHERE id = 226;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Zauberstäbe" WHERE id = 228;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Stangenwaffen" WHERE id = 229;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Tier - Skorpid" WHERE id = 236;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Arkan" WHERE id = 237;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Tier - Schildkröte" WHERE id = 251;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Meucheln" WHERE id = 253;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Furor" WHERE id = 256;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Schutz" WHERE id = 257;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Bestienausbildung" WHERE id = 261;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Schutz" WHERE id = 267;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Tier - Allgemein" WHERE id = 270;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Plattenpanzer" WHERE id = 293;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Sprache: Gnomisch" WHERE id = 313;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Sprache: Trollisch" WHERE id = 315;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Verzauberkunst" WHERE id = 333;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Dämonologie" WHERE id = 354;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Gebrechen" WHERE id = 355;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Angeln" WHERE id = 356;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Verstärkung" WHERE id = 373;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Wiederherstellung" WHERE id = 374;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Elementarkampf" WHERE id = 375;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Kürschnerei" WHERE id = 393;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Schwere Rüstung" WHERE id = 413;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Leder" WHERE id = 414;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Stoff" WHERE id = 415;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Schild" WHERE id = 433;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Faustwaffen" WHERE id = 473;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Raptorreiten" WHERE id = 533;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Roboschreiterlenken" WHERE id = 553;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Untoten-Reitkunst" WHERE id = 554;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Wiederherstellung" WHERE id = 573;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Gleichgewicht" WHERE id = 574;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Zerstörung" WHERE id = 593;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Heilig" WHERE id = 594;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Disziplin" WHERE id = 613;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Schlossknacken" WHERE id = 633;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Tier - Fledermaus" WHERE id = 653;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Tier - Hyäne" WHERE id = 654;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Tier - Eule" WHERE id = 655;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Tier - Windnatter" WHERE id = 656;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Sprache: Gossensprache" WHERE id = 673;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Kodoreiten" WHERE id = 713;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Volk - Trolle" WHERE id = 733;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Volk - Gnome" WHERE id = 753;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Volk - Menschen" WHERE id = 754;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Tier - Ereignis Ferngesteuert" WHERE id = 758;
UPDATE `SkillLine_vanilla` SET name_loc3 = "Reiten" WHERE id = 762;
UPDATE `SkillLine_vanilla` SET name_loc4 = "冰霜" WHERE id = 6;
UPDATE `SkillLine_vanilla` SET name_loc4 = "火焰" WHERE id = 8;
UPDATE `SkillLine_vanilla` SET name_loc4 = "武器" WHERE id = 26;
UPDATE `SkillLine_vanilla` SET name_loc4 = "战斗" WHERE id = 38;
UPDATE `SkillLine_vanilla` SET name_loc4 = "敏锐" WHERE id = 39;
UPDATE `SkillLine_vanilla` SET name_loc4 = "毒药" WHERE id = 40;
UPDATE `SkillLine_vanilla` SET name_loc4 = "单手剑" WHERE id = 43;
UPDATE `SkillLine_vanilla` SET name_loc4 = "单手斧" WHERE id = 44;
UPDATE `SkillLine_vanilla` SET name_loc4 = "弓" WHERE id = 45;
UPDATE `SkillLine_vanilla` SET name_loc4 = "枪械" WHERE id = 46;
UPDATE `SkillLine_vanilla` SET name_loc4 = "野兽控制" WHERE id = 50;
UPDATE `SkillLine_vanilla` SET name_loc4 = "生存技能" WHERE id = 51;
UPDATE `SkillLine_vanilla` SET name_loc4 = "单手锤" WHERE id = 54;
UPDATE `SkillLine_vanilla` SET name_loc4 = "双手剑" WHERE id = 55;
UPDATE `SkillLine_vanilla` SET name_loc4 = "神圣" WHERE id = 56;
UPDATE `SkillLine_vanilla` SET name_loc4 = "暗影魔法" WHERE id = 78;
UPDATE `SkillLine_vanilla` SET name_loc4 = "防御" WHERE id = 95;
UPDATE `SkillLine_vanilla` SET name_loc4 = "语言：通用语" WHERE id = 98;
UPDATE `SkillLine_vanilla` SET name_loc4 = "矮人种族特长" WHERE id = 101;
UPDATE `SkillLine_vanilla` SET name_loc4 = "语言：兽人语" WHERE id = 109;
UPDATE `SkillLine_vanilla` SET name_loc4 = "语言：矮人语" WHERE id = 111;
UPDATE `SkillLine_vanilla` SET name_loc4 = "语言：达纳苏斯语" WHERE id = 113;
UPDATE `SkillLine_vanilla` SET name_loc4 = "语言：牛头人语" WHERE id = 115;
UPDATE `SkillLine_vanilla` SET name_loc4 = "双武器" WHERE id = 118;
UPDATE `SkillLine_vanilla` SET name_loc4 = "牛头人种族特长" WHERE id = 124;
UPDATE `SkillLine_vanilla` SET name_loc4 = "兽人种族特长" WHERE id = 125;
UPDATE `SkillLine_vanilla` SET name_loc4 = "暗夜精灵种族特长" WHERE id = 126;
UPDATE `SkillLine_vanilla` SET name_loc4 = "急救" WHERE id = 129;
UPDATE `SkillLine_vanilla` SET name_loc4 = "野性战斗" WHERE id = 134;
UPDATE `SkillLine_vanilla` SET name_loc4 = "法杖" WHERE id = 136;
UPDATE `SkillLine_vanilla` SET name_loc4 = "语言：萨拉斯语" WHERE id = 137;
UPDATE `SkillLine_vanilla` SET name_loc4 = "语言：龙语" WHERE id = 138;
UPDATE `SkillLine_vanilla` SET name_loc4 = "语言：恶魔语" WHERE id = 139;
UPDATE `SkillLine_vanilla` SET name_loc4 = "语言：泰坦语" WHERE id = 140;
UPDATE `SkillLine_vanilla` SET name_loc4 = "语言：古代语" WHERE id = 141;
UPDATE `SkillLine_vanilla` SET name_loc4 = "生存技能" WHERE id = 142;
UPDATE `SkillLine_vanilla` SET name_loc4 = "骑术：马" WHERE id = 148;
UPDATE `SkillLine_vanilla` SET name_loc4 = "骑术：狼" WHERE id = 149;
UPDATE `SkillLine_vanilla` SET name_loc4 = "骑术：豹" WHERE id = 150;
UPDATE `SkillLine_vanilla` SET name_loc4 = "骑术：羊" WHERE id = 152;
UPDATE `SkillLine_vanilla` SET name_loc4 = "游泳" WHERE id = 155;
UPDATE `SkillLine_vanilla` SET name_loc4 = "双手锤" WHERE id = 160;
UPDATE `SkillLine_vanilla` SET name_loc4 = "徒手战斗" WHERE id = 162;
UPDATE `SkillLine_vanilla` SET name_loc4 = "射击" WHERE id = 163;
UPDATE `SkillLine_vanilla` SET name_loc4 = "锻造" WHERE id = 164;
UPDATE `SkillLine_vanilla` SET name_loc4 = "制皮" WHERE id = 165;
UPDATE `SkillLine_vanilla` SET name_loc4 = "炼金术" WHERE id = 171;
UPDATE `SkillLine_vanilla` SET name_loc4 = "双手斧" WHERE id = 172;
UPDATE `SkillLine_vanilla` SET name_loc4 = "匕首" WHERE id = 173;
UPDATE `SkillLine_vanilla` SET name_loc4 = "投掷武器" WHERE id = 176;
UPDATE `SkillLine_vanilla` SET name_loc4 = "草药学" WHERE id = 182;
UPDATE `SkillLine_vanilla` SET name_loc4 = "GENERIC (DND)" WHERE id = 183;
UPDATE `SkillLine_vanilla` SET name_loc4 = "惩戒" WHERE id = 184;
UPDATE `SkillLine_vanilla` SET name_loc4 = "烹饪" WHERE id = 185;
UPDATE `SkillLine_vanilla` SET name_loc4 = "采矿" WHERE id = 186;
UPDATE `SkillLine_vanilla` SET name_loc4 = "宠物 - 小鬼" WHERE id = 188;
UPDATE `SkillLine_vanilla` SET name_loc4 = "宠物 - 地狱猎犬" WHERE id = 189;
UPDATE `SkillLine_vanilla` SET name_loc4 = "裁缝" WHERE id = 197;
UPDATE `SkillLine_vanilla` SET name_loc4 = "工程学" WHERE id = 202;
UPDATE `SkillLine_vanilla` SET name_loc4 = "宠物 - 蜘蛛" WHERE id = 203;
UPDATE `SkillLine_vanilla` SET name_loc4 = "宠物 - 虚空行者" WHERE id = 204;
UPDATE `SkillLine_vanilla` SET name_loc4 = "宠物 - 魅魔" WHERE id = 205;
UPDATE `SkillLine_vanilla` SET name_loc4 = "宠物 - 地狱火" WHERE id = 206;
UPDATE `SkillLine_vanilla` SET name_loc4 = "宠物 - 末日守卫" WHERE id = 207;
UPDATE `SkillLine_vanilla` SET name_loc4 = "宠物 - 狼" WHERE id = 208;
UPDATE `SkillLine_vanilla` SET name_loc4 = "宠物 - 豹" WHERE id = 209;
UPDATE `SkillLine_vanilla` SET name_loc4 = "宠物 - 熊" WHERE id = 210;
UPDATE `SkillLine_vanilla` SET name_loc4 = "宠物 - 野猪" WHERE id = 211;
UPDATE `SkillLine_vanilla` SET name_loc4 = "宠物 - 鳄鱼" WHERE id = 212;
UPDATE `SkillLine_vanilla` SET name_loc4 = "宠物 - 食腐鸟" WHERE id = 213;
UPDATE `SkillLine_vanilla` SET name_loc4 = "宠物 - 螃蟹" WHERE id = 214;
UPDATE `SkillLine_vanilla` SET name_loc4 = "宠物 - 猩猩" WHERE id = 215;
UPDATE `SkillLine_vanilla` SET name_loc4 = "宠物 - 迅猛龙" WHERE id = 217;
UPDATE `SkillLine_vanilla` SET name_loc4 = "宠物 - 陆行鸟" WHERE id = 218;
UPDATE `SkillLine_vanilla` SET name_loc4 = "亡灵种族特长" WHERE id = 220;
UPDATE `SkillLine_vanilla` SET name_loc4 = "弩" WHERE id = 226;
UPDATE `SkillLine_vanilla` SET name_loc4 = "魔杖" WHERE id = 228;
UPDATE `SkillLine_vanilla` SET name_loc4 = "长柄武器" WHERE id = 229;
UPDATE `SkillLine_vanilla` SET name_loc4 = "宠物 - 蝎子" WHERE id = 236;
UPDATE `SkillLine_vanilla` SET name_loc4 = "奥术" WHERE id = 237;
UPDATE `SkillLine_vanilla` SET name_loc4 = "宠物 - 海龟" WHERE id = 251;
UPDATE `SkillLine_vanilla` SET name_loc4 = "刺杀" WHERE id = 253;
UPDATE `SkillLine_vanilla` SET name_loc4 = "狂怒" WHERE id = 256;
UPDATE `SkillLine_vanilla` SET name_loc4 = "防护" WHERE id = 257;
UPDATE `SkillLine_vanilla` SET name_loc4 = "训练野兽" WHERE id = 261;
UPDATE `SkillLine_vanilla` SET name_loc4 = "防护" WHERE id = 267;
UPDATE `SkillLine_vanilla` SET name_loc4 = "宠物 - 天赋" WHERE id = 270;
UPDATE `SkillLine_vanilla` SET name_loc4 = "板甲" WHERE id = 293;
UPDATE `SkillLine_vanilla` SET name_loc4 = "语言：侏儒语" WHERE id = 313;
UPDATE `SkillLine_vanilla` SET name_loc4 = "语言：巨魔语" WHERE id = 315;
UPDATE `SkillLine_vanilla` SET name_loc4 = "附魔" WHERE id = 333;
UPDATE `SkillLine_vanilla` SET name_loc4 = "恶魔学识" WHERE id = 354;
UPDATE `SkillLine_vanilla` SET name_loc4 = "痛苦" WHERE id = 355;
UPDATE `SkillLine_vanilla` SET name_loc4 = "钓鱼" WHERE id = 356;
UPDATE `SkillLine_vanilla` SET name_loc4 = "增强" WHERE id = 373;
UPDATE `SkillLine_vanilla` SET name_loc4 = "恢复" WHERE id = 374;
UPDATE `SkillLine_vanilla` SET name_loc4 = "元素战斗" WHERE id = 375;
UPDATE `SkillLine_vanilla` SET name_loc4 = "剥皮" WHERE id = 393;
UPDATE `SkillLine_vanilla` SET name_loc4 = "锁甲" WHERE id = 413;
UPDATE `SkillLine_vanilla` SET name_loc4 = "皮甲" WHERE id = 414;
UPDATE `SkillLine_vanilla` SET name_loc4 = "布甲" WHERE id = 415;
UPDATE `SkillLine_vanilla` SET name_loc4 = "盾牌" WHERE id = 433;
UPDATE `SkillLine_vanilla` SET name_loc4 = "拳套" WHERE id = 473;
UPDATE `SkillLine_vanilla` SET name_loc4 = "骑术：迅猛龙" WHERE id = 533;
UPDATE `SkillLine_vanilla` SET name_loc4 = "骑术：机械陆行鸟" WHERE id = 553;
UPDATE `SkillLine_vanilla` SET name_loc4 = "骑术：骸骨战马" WHERE id = 554;
UPDATE `SkillLine_vanilla` SET name_loc4 = "恢复" WHERE id = 573;
UPDATE `SkillLine_vanilla` SET name_loc4 = "平衡" WHERE id = 574;
UPDATE `SkillLine_vanilla` SET name_loc4 = "毁灭" WHERE id = 593;
UPDATE `SkillLine_vanilla` SET name_loc4 = "神圣" WHERE id = 594;
UPDATE `SkillLine_vanilla` SET name_loc4 = "戒律" WHERE id = 613;
UPDATE `SkillLine_vanilla` SET name_loc4 = "开锁" WHERE id = 633;
UPDATE `SkillLine_vanilla` SET name_loc4 = "宠物 - 蝙蝠" WHERE id = 653;
UPDATE `SkillLine_vanilla` SET name_loc4 = "宠物 - 土狼" WHERE id = 654;
UPDATE `SkillLine_vanilla` SET name_loc4 = "宠物 - 猫头鹰" WHERE id = 655;
UPDATE `SkillLine_vanilla` SET name_loc4 = "宠物 - 风蛇" WHERE id = 656;
UPDATE `SkillLine_vanilla` SET name_loc4 = "语言：亡灵语" WHERE id = 673;
UPDATE `SkillLine_vanilla` SET name_loc4 = "骑术：科多兽" WHERE id = 713;
UPDATE `SkillLine_vanilla` SET name_loc4 = "种族特长 - 巨魔" WHERE id = 733;
UPDATE `SkillLine_vanilla` SET name_loc4 = "种族特长 - 侏儒" WHERE id = 753;
UPDATE `SkillLine_vanilla` SET name_loc4 = "种族特长 - 人类" WHERE id = 754;
UPDATE `SkillLine_vanilla` SET name_loc4 = "Pet - Event - Remote Control" WHERE id = 758;
UPDATE `SkillLine_vanilla` SET name_loc4 = "骑术" WHERE id = 762;
UPDATE `SkillLine_vanilla` SET name_loc5 = "冰霜" WHERE id = 6;
UPDATE `SkillLine_vanilla` SET name_loc5 = "火焰" WHERE id = 8;
UPDATE `SkillLine_vanilla` SET name_loc5 = "武器" WHERE id = 26;
UPDATE `SkillLine_vanilla` SET name_loc5 = "戰鬥" WHERE id = 38;
UPDATE `SkillLine_vanilla` SET name_loc5 = "敏銳" WHERE id = 39;
UPDATE `SkillLine_vanilla` SET name_loc5 = "毒藥" WHERE id = 40;
UPDATE `SkillLine_vanilla` SET name_loc5 = "劍" WHERE id = 43;
UPDATE `SkillLine_vanilla` SET name_loc5 = "斧" WHERE id = 44;
UPDATE `SkillLine_vanilla` SET name_loc5 = "弓" WHERE id = 45;
UPDATE `SkillLine_vanilla` SET name_loc5 = "槍械" WHERE id = 46;
UPDATE `SkillLine_vanilla` SET name_loc5 = "野獸控制" WHERE id = 50;
UPDATE `SkillLine_vanilla` SET name_loc5 = "生存技能" WHERE id = 51;
UPDATE `SkillLine_vanilla` SET name_loc5 = "錘" WHERE id = 54;
UPDATE `SkillLine_vanilla` SET name_loc5 = "雙手劍" WHERE id = 55;
UPDATE `SkillLine_vanilla` SET name_loc5 = "神聖" WHERE id = 56;
UPDATE `SkillLine_vanilla` SET name_loc5 = "暗影魔法" WHERE id = 78;
UPDATE `SkillLine_vanilla` SET name_loc5 = "防禦" WHERE id = 95;
UPDATE `SkillLine_vanilla` SET name_loc5 = "語言：通用語" WHERE id = 98;
UPDATE `SkillLine_vanilla` SET name_loc5 = "矮人種族特長" WHERE id = 101;
UPDATE `SkillLine_vanilla` SET name_loc5 = "語言：獸人語" WHERE id = 109;
UPDATE `SkillLine_vanilla` SET name_loc5 = "語言：矮人語" WHERE id = 111;
UPDATE `SkillLine_vanilla` SET name_loc5 = "語言：達納蘇斯語" WHERE id = 113;
UPDATE `SkillLine_vanilla` SET name_loc5 = "語言：牛頭人語" WHERE id = 115;
UPDATE `SkillLine_vanilla` SET name_loc5 = "雙武器" WHERE id = 118;
UPDATE `SkillLine_vanilla` SET name_loc5 = "牛頭人種族特長" WHERE id = 124;
UPDATE `SkillLine_vanilla` SET name_loc5 = "獸人種族特長" WHERE id = 125;
UPDATE `SkillLine_vanilla` SET name_loc5 = "夜精靈種族特長" WHERE id = 126;
UPDATE `SkillLine_vanilla` SET name_loc5 = "急救" WHERE id = 129;
UPDATE `SkillLine_vanilla` SET name_loc5 = "野性戰鬥" WHERE id = 134;
UPDATE `SkillLine_vanilla` SET name_loc5 = "法杖" WHERE id = 136;
UPDATE `SkillLine_vanilla` SET name_loc5 = "語言：薩拉斯語" WHERE id = 137;
UPDATE `SkillLine_vanilla` SET name_loc5 = "語言：龍語" WHERE id = 138;
UPDATE `SkillLine_vanilla` SET name_loc5 = "語言：惡魔語" WHERE id = 139;
UPDATE `SkillLine_vanilla` SET name_loc5 = "語言：泰坦語" WHERE id = 140;
UPDATE `SkillLine_vanilla` SET name_loc5 = "語言：古代語" WHERE id = 141;
UPDATE `SkillLine_vanilla` SET name_loc5 = "生存技能" WHERE id = 142;
UPDATE `SkillLine_vanilla` SET name_loc5 = "騎術：馬" WHERE id = 148;
UPDATE `SkillLine_vanilla` SET name_loc5 = "騎術：狼" WHERE id = 149;
UPDATE `SkillLine_vanilla` SET name_loc5 = "騎術：豹" WHERE id = 150;
UPDATE `SkillLine_vanilla` SET name_loc5 = "騎術：羊" WHERE id = 152;
UPDATE `SkillLine_vanilla` SET name_loc5 = "游泳" WHERE id = 155;
UPDATE `SkillLine_vanilla` SET name_loc5 = "雙手錘" WHERE id = 160;
UPDATE `SkillLine_vanilla` SET name_loc5 = "徒手戰鬥" WHERE id = 162;
UPDATE `SkillLine_vanilla` SET name_loc5 = "射擊" WHERE id = 163;
UPDATE `SkillLine_vanilla` SET name_loc5 = "鍛造" WHERE id = 164;
UPDATE `SkillLine_vanilla` SET name_loc5 = "製皮" WHERE id = 165;
UPDATE `SkillLine_vanilla` SET name_loc5 = "煉金術" WHERE id = 171;
UPDATE `SkillLine_vanilla` SET name_loc5 = "雙手斧" WHERE id = 172;
UPDATE `SkillLine_vanilla` SET name_loc5 = "匕首" WHERE id = 173;
UPDATE `SkillLine_vanilla` SET name_loc5 = "投擲武器" WHERE id = 176;
UPDATE `SkillLine_vanilla` SET name_loc5 = "草藥學" WHERE id = 182;
UPDATE `SkillLine_vanilla` SET name_loc5 = "GENERIC (DND)" WHERE id = 183;
UPDATE `SkillLine_vanilla` SET name_loc5 = "懲戒" WHERE id = 184;
UPDATE `SkillLine_vanilla` SET name_loc5 = "烹飪" WHERE id = 185;
UPDATE `SkillLine_vanilla` SET name_loc5 = "採礦" WHERE id = 186;
UPDATE `SkillLine_vanilla` SET name_loc5 = "寵物 - 小鬼" WHERE id = 188;
UPDATE `SkillLine_vanilla` SET name_loc5 = "寵物 - 地獄獵犬" WHERE id = 189;
UPDATE `SkillLine_vanilla` SET name_loc5 = "裁縫" WHERE id = 197;
UPDATE `SkillLine_vanilla` SET name_loc5 = "工程學" WHERE id = 202;
UPDATE `SkillLine_vanilla` SET name_loc5 = "寵物 - 蜘蛛" WHERE id = 203;
UPDATE `SkillLine_vanilla` SET name_loc5 = "寵物 - 虛空行者" WHERE id = 204;
UPDATE `SkillLine_vanilla` SET name_loc5 = "寵物 - 魅魔" WHERE id = 205;
UPDATE `SkillLine_vanilla` SET name_loc5 = "寵物 - 地獄火" WHERE id = 206;
UPDATE `SkillLine_vanilla` SET name_loc5 = "寵物 - 末日守衛" WHERE id = 207;
UPDATE `SkillLine_vanilla` SET name_loc5 = "寵物 - 狼" WHERE id = 208;
UPDATE `SkillLine_vanilla` SET name_loc5 = "寵物 - 豹" WHERE id = 209;
UPDATE `SkillLine_vanilla` SET name_loc5 = "寵物 - 熊" WHERE id = 210;
UPDATE `SkillLine_vanilla` SET name_loc5 = "寵物 - 野豬" WHERE id = 211;
UPDATE `SkillLine_vanilla` SET name_loc5 = "寵物 - 鱷魚" WHERE id = 212;
UPDATE `SkillLine_vanilla` SET name_loc5 = "寵物 - 食腐鳥" WHERE id = 213;
UPDATE `SkillLine_vanilla` SET name_loc5 = "寵物 - 螃蟹" WHERE id = 214;
UPDATE `SkillLine_vanilla` SET name_loc5 = "寵物 - 猩猩" WHERE id = 215;
UPDATE `SkillLine_vanilla` SET name_loc5 = "寵物 - 迅猛龍" WHERE id = 217;
UPDATE `SkillLine_vanilla` SET name_loc5 = "寵物 - 陸行鳥" WHERE id = 218;
UPDATE `SkillLine_vanilla` SET name_loc5 = "不死族種族特長" WHERE id = 220;
UPDATE `SkillLine_vanilla` SET name_loc5 = "弩" WHERE id = 226;
UPDATE `SkillLine_vanilla` SET name_loc5 = "魔杖" WHERE id = 228;
UPDATE `SkillLine_vanilla` SET name_loc5 = "長柄武器" WHERE id = 229;
UPDATE `SkillLine_vanilla` SET name_loc5 = "寵物 - 蠍子" WHERE id = 236;
UPDATE `SkillLine_vanilla` SET name_loc5 = "祕法" WHERE id = 237;
UPDATE `SkillLine_vanilla` SET name_loc5 = "寵物 - 海龜" WHERE id = 251;
UPDATE `SkillLine_vanilla` SET name_loc5 = "刺殺" WHERE id = 253;
UPDATE `SkillLine_vanilla` SET name_loc5 = "狂怒" WHERE id = 256;
UPDATE `SkillLine_vanilla` SET name_loc5 = "防護" WHERE id = 257;
UPDATE `SkillLine_vanilla` SET name_loc5 = "訓練野獸" WHERE id = 261;
UPDATE `SkillLine_vanilla` SET name_loc5 = "防護" WHERE id = 267;
UPDATE `SkillLine_vanilla` SET name_loc5 = "寵物 - 天賦" WHERE id = 270;
UPDATE `SkillLine_vanilla` SET name_loc5 = "鎧甲" WHERE id = 293;
UPDATE `SkillLine_vanilla` SET name_loc5 = "語言：地精語" WHERE id = 313;
UPDATE `SkillLine_vanilla` SET name_loc5 = "語言：食人妖語" WHERE id = 315;
UPDATE `SkillLine_vanilla` SET name_loc5 = "附魔" WHERE id = 333;
UPDATE `SkillLine_vanilla` SET name_loc5 = "惡魔學識" WHERE id = 354;
UPDATE `SkillLine_vanilla` SET name_loc5 = "痛苦" WHERE id = 355;
UPDATE `SkillLine_vanilla` SET name_loc5 = "釣魚" WHERE id = 356;
UPDATE `SkillLine_vanilla` SET name_loc5 = "增強" WHERE id = 373;
UPDATE `SkillLine_vanilla` SET name_loc5 = "恢復" WHERE id = 374;
UPDATE `SkillLine_vanilla` SET name_loc5 = "元素戰鬥" WHERE id = 375;
UPDATE `SkillLine_vanilla` SET name_loc5 = "剝皮" WHERE id = 393;
UPDATE `SkillLine_vanilla` SET name_loc5 = "鎖甲" WHERE id = 413;
UPDATE `SkillLine_vanilla` SET name_loc5 = "皮甲" WHERE id = 414;
UPDATE `SkillLine_vanilla` SET name_loc5 = "布甲" WHERE id = 415;
UPDATE `SkillLine_vanilla` SET name_loc5 = "盾牌" WHERE id = 433;
UPDATE `SkillLine_vanilla` SET name_loc5 = "拳套" WHERE id = 473;
UPDATE `SkillLine_vanilla` SET name_loc5 = "騎術：迅猛龍" WHERE id = 533;
UPDATE `SkillLine_vanilla` SET name_loc5 = "騎術：機械陸行鳥" WHERE id = 553;
UPDATE `SkillLine_vanilla` SET name_loc5 = "騎術：骸骨戰馬" WHERE id = 554;
UPDATE `SkillLine_vanilla` SET name_loc5 = "恢復" WHERE id = 573;
UPDATE `SkillLine_vanilla` SET name_loc5 = "平衡" WHERE id = 574;
UPDATE `SkillLine_vanilla` SET name_loc5 = "毀滅" WHERE id = 593;
UPDATE `SkillLine_vanilla` SET name_loc5 = "神聖" WHERE id = 594;
UPDATE `SkillLine_vanilla` SET name_loc5 = "戒律" WHERE id = 613;
UPDATE `SkillLine_vanilla` SET name_loc5 = "開鎖" WHERE id = 633;
UPDATE `SkillLine_vanilla` SET name_loc5 = "寵物 - 蝙蝠" WHERE id = 653;
UPDATE `SkillLine_vanilla` SET name_loc5 = "寵物 - 土狼" WHERE id = 654;
UPDATE `SkillLine_vanilla` SET name_loc5 = "寵物 - 貓頭鷹" WHERE id = 655;
UPDATE `SkillLine_vanilla` SET name_loc5 = "寵物 - 風蛇" WHERE id = 656;
UPDATE `SkillLine_vanilla` SET name_loc5 = "語言：亡靈語" WHERE id = 673;
UPDATE `SkillLine_vanilla` SET name_loc5 = "騎術：科多獸" WHERE id = 713;
UPDATE `SkillLine_vanilla` SET name_loc5 = "種族特長 - 食人妖" WHERE id = 733;
UPDATE `SkillLine_vanilla` SET name_loc5 = "種族特長 - 地精" WHERE id = 753;
UPDATE `SkillLine_vanilla` SET name_loc5 = "種族特長 - 人類" WHERE id = 754;
UPDATE `SkillLine_vanilla` SET name_loc5 = "寵物 - 事件 - 遙控" WHERE id = 758;
UPDATE `SkillLine_vanilla` SET name_loc5 = "騎乘術" WHERE id = 762;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Escarcha" WHERE id = 6;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Fuego" WHERE id = 8;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Armas" WHERE id = 26;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Combate" WHERE id = 38;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Sutileza" WHERE id = 39;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Venenos" WHERE id = 40;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Espadas" WHERE id = 43;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Hachas" WHERE id = 44;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Arcos" WHERE id = 45;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Armas de fuego" WHERE id = 46;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Dominio de bestias" WHERE id = 50;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Supervivencia" WHERE id = 51;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mazas" WHERE id = 54;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Espadas de dos manos" WHERE id = 55;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Sagrado" WHERE id = 56;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Magia sombría" WHERE id = 78;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Defensa" WHERE id = 95;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Lengua: común" WHERE id = 98;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Racial enano" WHERE id = 101;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Lengua: orco" WHERE id = 109;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Lengua: Enánico" WHERE id = 111;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Lengua: Darnassiano" WHERE id = 113;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Lengua: Taurahe" WHERE id = 115;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Empuñadura dual" WHERE id = 118;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Racial tauren" WHERE id = 124;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Racial orco" WHERE id = 125;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Racial elfo de la noche" WHERE id = 126;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Primeros auxilios" WHERE id = 129;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Combate feral" WHERE id = 134;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Bastones" WHERE id = 136;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Lengua: thalassiano" WHERE id = 137;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Lengua: dracónico" WHERE id = 138;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Lengua: demoníaco" WHERE id = 139;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Lengua: titánico" WHERE id = 140;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Lengua: lengua antigua" WHERE id = 141;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Supervivencia" WHERE id = 142;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Montar caballos" WHERE id = 148;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Montar lobos" WHERE id = 149;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Montar tigres" WHERE id = 150;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Montar carneros" WHERE id = 152;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Nadar" WHERE id = 155;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mazas de dos manos" WHERE id = 160;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Sin armas" WHERE id = 162;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Puntería" WHERE id = 163;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Herrería" WHERE id = 164;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Marroquinería" WHERE id = 165;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Alquimia" WHERE id = 171;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Hachas de dos manos" WHERE id = 172;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Dagas" WHERE id = 173;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Armas arrojadizas" WHERE id = 176;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Botánica" WHERE id = 182;
UPDATE `SkillLine_vanilla` SET name_loc6 = "COMÚN (DND)" WHERE id = 183;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Reprensión" WHERE id = 184;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Cocina" WHERE id = 185;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Minería" WHERE id = 186;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mascota: diablillo" WHERE id = 188;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mascota: Manáfago" WHERE id = 189;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Costura" WHERE id = 197;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Ingeniería" WHERE id = 202;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mascota: araña" WHERE id = 203;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mascota: abisario" WHERE id = 204;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mascota: súcubo" WHERE id = 205;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mascota: inferno" WHERE id = 206;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mascota: guardia maldito" WHERE id = 207;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mascota: lobo" WHERE id = 208;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mascota: felino" WHERE id = 209;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mascota: oso" WHERE id = 210;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mascota: jabalí" WHERE id = 211;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mascota: crocolisco" WHERE id = 212;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mascota: carroñero" WHERE id = 213;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mascota: cangrejo" WHERE id = 214;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mascota: gorila" WHERE id = 215;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mascota: raptor" WHERE id = 217;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mascota: zancudo" WHERE id = 218;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Racial: no-muerto" WHERE id = 220;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Ballestas" WHERE id = 226;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Varitas" WHERE id = 228;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Armas de asta" WHERE id = 229;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mascota: escórpido" WHERE id = 236;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Arcano" WHERE id = 237;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mascota: tortuga" WHERE id = 251;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Asesinato" WHERE id = 253;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Furia" WHERE id = 256;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Protección" WHERE id = 257;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Entrenamiento de bestias" WHERE id = 261;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Protección" WHERE id = 267;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mascota: miscelánea" WHERE id = 270;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Armadura de placas" WHERE id = 293;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Lengua: gnomótico" WHERE id = 313;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Lengua: trol" WHERE id = 315;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Encantamiento" WHERE id = 333;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Demonología" WHERE id = 354;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Aflicción" WHERE id = 355;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Pesca" WHERE id = 356;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mejora" WHERE id = 373;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Recuperación" WHERE id = 374;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Combate elemental" WHERE id = 375;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Desollar" WHERE id = 393;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mallas" WHERE id = 413;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Cuero" WHERE id = 414;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Tela" WHERE id = 415;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Escudo" WHERE id = 433;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Armas de puño" WHERE id = 473;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Montar raptor" WHERE id = 533;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Montar mecazancudos" WHERE id = 553;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Equitación para no-muertos" WHERE id = 554;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Recuperación" WHERE id = 573;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Equilibrio" WHERE id = 574;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Destrucción" WHERE id = 593;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Sagrado" WHERE id = 594;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Disciplina" WHERE id = 613;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Ganzúa" WHERE id = 633;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mascota: murciélago" WHERE id = 653;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mascota: hiena" WHERE id = 654;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mascota: búho" WHERE id = 655;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mascota: serpiente alada" WHERE id = 656;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Lengua: viscerálico" WHERE id = 673;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Montar kodos" WHERE id = 713;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Racial: trol" WHERE id = 733;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Racial: gnomo" WHERE id = 753;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Racial: humano" WHERE id = 754;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Mascota - Evento - Control remoto" WHERE id = 758;
UPDATE `SkillLine_vanilla` SET name_loc6 = "Equitación" WHERE id = 762;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Лед" WHERE id = 6;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Огонь" WHERE id = 8;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Оружие" WHERE id = 26;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Бой" WHERE id = 38;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Скрытность" WHERE id = 39;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Яды" WHERE id = 40;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Мечи" WHERE id = 43;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Топоры" WHERE id = 44;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Луки" WHERE id = 45;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Огнестрельное оружие" WHERE id = 46;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Повелитель зверей" WHERE id = 50;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Выживание" WHERE id = 51;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Дробящее оружие" WHERE id = 54;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Двуручные мечи" WHERE id = 55;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Свет" WHERE id = 56;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Темная магия" WHERE id = 78;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Защита" WHERE id = 95;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Язык: всеобщий" WHERE id = 98;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Расовый навык дворфов" WHERE id = 101;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Язык: орочий" WHERE id = 109;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Язык: дворфийский" WHERE id = 111;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Язык: дарнасский" WHERE id = 113;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Язык: таурахэ" WHERE id = 115;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Бой двумя руками" WHERE id = 118;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Расовый навык тауренов" WHERE id = 124;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Расовый навык орков" WHERE id = 125;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Расовый навык ночных эльфов" WHERE id = 126;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Первая помощь" WHERE id = 129;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Сила зверя" WHERE id = 134;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Посохи" WHERE id = 136;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Язык: талассийский" WHERE id = 137;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Язык: драконий" WHERE id = 138;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Язык: наречие демонов" WHERE id = 139;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Язык: наречие титанов" WHERE id = 140;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Язык: древний" WHERE id = 141;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Выживание" WHERE id = 142;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Езда на лошадях" WHERE id = 148;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Езда на волках" WHERE id = 149;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Езда на тиграх" WHERE id = 150;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Езда на баранах" WHERE id = 152;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Плавание" WHERE id = 155;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Двуручное дробящее оружие" WHERE id = 160;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Рукопашный бой" WHERE id = 162;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Стрельба" WHERE id = 163;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Кузнечное дело" WHERE id = 164;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Кожевничество" WHERE id = 165;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Алхимия" WHERE id = 171;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Двуручные топоры" WHERE id = 172;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Кинжалы" WHERE id = 173;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Метательное оружие" WHERE id = 176;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Травничество" WHERE id = 182;
UPDATE `SkillLine_vanilla` SET name_loc8 = "GENERIC (DND)" WHERE id = 183;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Воздаяние" WHERE id = 184;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Кулинария" WHERE id = 185;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Горное дело" WHERE id = 186;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Питомец: бес" WHERE id = 188;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Прислужник: охотник Скверны" WHERE id = 189;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Портняжное дело" WHERE id = 197;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Инженерное дело" WHERE id = 202;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Питомец: паук" WHERE id = 203;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Прислужник: демон Бездны" WHERE id = 204;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Прислужник: суккуб" WHERE id = 205;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Прислужник: огненный голем" WHERE id = 206;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Прислужник: Стражник Ужаса" WHERE id = 207;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Питомец: волк" WHERE id = 208;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Питомец: кошка" WHERE id = 209;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Питомец: медведь" WHERE id = 210;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Питомец: кабан" WHERE id = 211;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Питомец: кроколиск" WHERE id = 212;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Питомец: падальщик" WHERE id = 213;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Питомец: краб" WHERE id = 214;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Питомец: горилла" WHERE id = 215;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Питомец: ящер" WHERE id = 217;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Питомец: долгоног" WHERE id = 218;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Расовый навык нежити" WHERE id = 220;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Арбалеты" WHERE id = 226;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Жезлы" WHERE id = 228;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Древковое оружие" WHERE id = 229;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Питомец: скорпид" WHERE id = 236;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Тайная магия" WHERE id = 237;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Питомец: черепаха" WHERE id = 251;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Ликвидация" WHERE id = 253;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Неистовство" WHERE id = 256;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Защита" WHERE id = 257;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Дрессировка" WHERE id = 261;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Защита" WHERE id = 267;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Питомец: любой" WHERE id = 270;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Латы" WHERE id = 293;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Язык: гномский" WHERE id = 313;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Язык: наречие троллей" WHERE id = 315;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Наложение чар" WHERE id = 333;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Демонология" WHERE id = 354;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Колдовство" WHERE id = 355;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Рыбная ловля" WHERE id = 356;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Совершенствование" WHERE id = 373;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Исцеление" WHERE id = 374;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Стихии" WHERE id = 375;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Снятие шкур" WHERE id = 393;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Кольчужные доспехи" WHERE id = 413;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Кожаные доспехи" WHERE id = 414;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Тканевые доспехи" WHERE id = 415;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Щит" WHERE id = 433;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Кистевое оружие" WHERE id = 473;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Езда на рапторах" WHERE id = 533;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Вождение механострауса" WHERE id = 553;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Верховая езда нежити" WHERE id = 554;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Исцеление" WHERE id = 573;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Баланс" WHERE id = 574;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Разрушение" WHERE id = 593;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Свет" WHERE id = 594;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Послушание" WHERE id = 613;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Взлом" WHERE id = 633;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Питомец: летучая мышь" WHERE id = 653;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Питомец: гиена" WHERE id = 654;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Питомец: сова" WHERE id = 655;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Питомец: крылатый змей" WHERE id = 656;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Язык: наречие нежити" WHERE id = 673;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Езда на кодо" WHERE id = 713;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Расовый навык троллей" WHERE id = 733;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Расовый навык гномов" WHERE id = 753;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Расовый: люди" WHERE id = 754;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Питомец - управление" WHERE id = 758;
UPDATE `SkillLine_vanilla` SET name_loc8 = "Верховая езда" WHERE id = 762;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Gelo" WHERE id = 6;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Fogo" WHERE id = 8;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Armas" WHERE id = 26;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Combate" WHERE id = 38;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Subterfúgio" WHERE id = 39;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Venenos" WHERE id = 40;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Espadas" WHERE id = 43;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Machados" WHERE id = 44;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Arcos" WHERE id = 45;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Armas de Fogo" WHERE id = 46;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Domínio das Feras" WHERE id = 50;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Sobrevivência" WHERE id = 51;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Maças" WHERE id = 54;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Espadas de Duas Mãos" WHERE id = 55;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Sagrado" WHERE id = 56;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Magia Sombria" WHERE id = 78;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Defesa" WHERE id = 95;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Língua: Comum" WHERE id = 98;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Racial dos Anões" WHERE id = 101;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Língua: Órquica" WHERE id = 109;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Língua: Enânica" WHERE id = 111;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Língua: Darnassiana" WHERE id = 113;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Língua: Taurahe" WHERE id = 115;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Empunhar Duas Armas" WHERE id = 118;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Racial dos Taurens" WHERE id = 124;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Racial dos Orcs" WHERE id = 125;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Racial dos Elfos Noturnos" WHERE id = 126;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Primeiros Socorros" WHERE id = 129;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Combate Feral" WHERE id = 134;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Báculos" WHERE id = 136;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Língua: Talassiana" WHERE id = 137;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Língua: Dracônica" WHERE id = 138;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Língua: Demoníaca" WHERE id = 139;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Língua: Titânica" WHERE id = 140;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Língua: Antiga" WHERE id = 141;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Sobrevivência" WHERE id = 142;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Equitação" WHERE id = 148;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Cavalgar Lobo" WHERE id = 149;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Cavalgar Tigre" WHERE id = 150;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Cavalgar Carneiro" WHERE id = 152;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Natação" WHERE id = 155;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Maças de Duas Mãos" WHERE id = 160;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Combate desarmado" WHERE id = 162;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Precisão" WHERE id = 163;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Ferraria" WHERE id = 164;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Couraria" WHERE id = 165;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Alquimia" WHERE id = 171;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Machados de Duas Mãos" WHERE id = 172;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Adagas" WHERE id = 173;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Arremesso" WHERE id = 176;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Herborismo" WHERE id = 182;
UPDATE `SkillLine_vanilla` SET name_loc10 = "GENERIC (DND)" WHERE id = 183;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Retribuição" WHERE id = 184;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Culinária" WHERE id = 185;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Mineração" WHERE id = 186;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Companheiro - Diabrete" WHERE id = 188;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Companheiro - Caçador Vil" WHERE id = 189;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Alfaiataria" WHERE id = 197;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Engenharia" WHERE id = 202;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Companheiro - Aranha" WHERE id = 203;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Companheiro - Emissário do Caos" WHERE id = 204;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Companheiro - Súcubo" WHERE id = 205;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Companheiro - Infernal" WHERE id = 206;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Companheiro - Demonarca" WHERE id = 207;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Companheiro - Lobo" WHERE id = 208;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Companheiro - Gato" WHERE id = 209;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Companheiro - Urso" WHERE id = 210;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Companheiro - Javali" WHERE id = 211;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Ajudante - Crocolisco" WHERE id = 212;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Companheiro - Ave Carniceira" WHERE id = 213;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Companheiro - Caranguejo" WHERE id = 214;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Companheiro - Gorila" WHERE id = 215;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Companheiro - Raptor" WHERE id = 217;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Companheiro - Moa" WHERE id = 218;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Racial - Morto-vivo" WHERE id = 220;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Bestas" WHERE id = 226;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Varinhas" WHERE id = 228;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Armas de Haste" WHERE id = 229;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Companheiro - Escorpídeo" WHERE id = 236;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Arcano" WHERE id = 237;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Companheiro - Tartaruga" WHERE id = 251;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Assassinato" WHERE id = 253;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Fúria" WHERE id = 256;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Proteção" WHERE id = 257;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Treinamento de Feras" WHERE id = 261;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Proteção" WHERE id = 267;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Ajudante - Genérico" WHERE id = 270;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Armadura de Placa" WHERE id = 293;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Língua: Gnômica" WHERE id = 313;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Língua: Zandáli" WHERE id = 315;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Encantamento" WHERE id = 333;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Demonologia" WHERE id = 354;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Suplício" WHERE id = 355;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Pesca" WHERE id = 356;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Aperfeiçoamento" WHERE id = 373;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Restauração" WHERE id = 374;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Combate Elemental" WHERE id = 375;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Esfolamento" WHERE id = 393;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Malha" WHERE id = 413;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Couro" WHERE id = 414;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Tecido" WHERE id = 415;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Escudo" WHERE id = 433;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Armas de punho" WHERE id = 473;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Cavalgar Raptor" WHERE id = 533;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Pilotar Mecanostruz" WHERE id = 553;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Equitação de Morto-vivo" WHERE id = 554;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Restauração" WHERE id = 573;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Equilíbrio" WHERE id = 574;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Destruição" WHERE id = 593;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Sagrado" WHERE id = 594;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Disciplina" WHERE id = 613;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Arrombamento" WHERE id = 633;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Companheiro - Morcego" WHERE id = 653;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Companheiro - Hiena" WHERE id = 654;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Ajudante - Coruja" WHERE id = 655;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Companheiro - Serpente Alada" WHERE id = 656;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Língua: Guturalês" WHERE id = 673;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Cavalgar Kodo" WHERE id = 713;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Racial - Troll" WHERE id = 733;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Racial - Gnomo" WHERE id = 753;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Racial - Humano" WHERE id = 754;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Companheiro - Evento - Controle Remoto" WHERE id = 758;
UPDATE `SkillLine_vanilla` SET name_loc10 = "Riding" WHERE id = 762;
DROP TABLE IF EXISTS `AreaTable_vanilla`;
CREATE TABLE `AreaTable_vanilla` (
`id` int(3) unsigned NOT NULL,
`zoneID` smallint(3) unsigned NOT NULL,
`name_loc0` varchar(255) NOT NULL,
`name_loc1` varchar(255) NOT NULL,
`name_loc2` varchar(255) NOT NULL,
`name_loc3` varchar(255) NOT NULL,
`name_loc4` varchar(255) NOT NULL,
`name_loc5` varchar(255) NOT NULL,
`name_loc6` varchar(255) NOT NULL,
`name_loc7` varchar(255) NOT NULL,
`name_loc8` varchar(255) NOT NULL,
`name_loc10` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED COMMENT='AreaTable';

INSERT INTO `AreaTable_vanilla` VALUES (1, 0, "Dun Morogh", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2, 40, "Longshore", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3, 0, "Badlands", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (4, 0, "Blasted Lands", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (7, 33, "Blackwater Cove", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (8, 0, "Swamp of Sorrows", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (9, 12, "Northshire Valley", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (10, 0, "Duskwood", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (11, 0, "Wetlands", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (12, 0, "Elwynn Forest", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (13, 10, "The World Tree", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (14, 0, "Durotar", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (15, 0, "Dustwallow Marsh", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (16, 0, "Azshara", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (17, 0, "The Barrens", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (18, 12, "Crystal Lake", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (19, 33, "Zul'Gurub", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (20, 40, "Moonbrook", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (21, 0, "Kul Tiras", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (22, 0, "Programmer Isle", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (23, 12, "Northshire River", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (24, 12, "Northshire Abbey", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (25, 0, "Blackrock Mountain", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (26, 40, "Lighthouse", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (28, 0, "Western Plaguelands", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (30, 0, "Nine", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (32, 10, "The Cemetary", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (33, 0, "Stranglethorn Vale", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (34, 12, "Echo Ridge Mine", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (35, 33, "Booty Bay", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (36, 0, "Alterac Mountains", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (37, 33, "Lake Nazferiti", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (38, 0, "Loch Modan", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (40, 0, "Westfall", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (41, 0, "Deadwind Pass", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (42, 10, "Darkshire", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (43, 33, "Wild Shore", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (44, 0, "Redridge Mountains", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (45, 0, "Arathi Highlands", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (46, 0, "Burning Steppes", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (47, 0, "The Hinterlands", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (49, 22, "Dead Man's Hole", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (51, 0, "Searing Gorge", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (53, 12, "Thieves Camp", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (54, 12, "Jasperlode Mine", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (55, 12, "Valley of Heroes UNUSED", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (56, 12, "Heroes' Vigil", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (57, 12, "Fargodeep Mine", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (59, 12, "Northshire Vineyards", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (60, 12, "Forest's Edge", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (61, 12, "Thunder Falls", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (62, 12, "Brackwell Pumpkin Patch", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (63, 12, "The Stonefield Farm", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (64, 12, "The Maclure Vineyards", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (65, 0, "***On Map Dungeon***", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (66, 0, "***On Map Dungeon***", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (67, 0, "***On Map Dungeon***", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (68, 44, "Lake Everstill", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (69, 44, "Lakeshire", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (70, 44, "Stonewatch", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (71, 44, "Stonewatch Falls", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (72, 4, "The Dark Portal", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (73, 4, "The Tainted Scar", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (74, 8, "Pool of Tears", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (75, 8, "Stonard", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (76, 8, "Fallow Sanctuary", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (77, 1, "Anvilmar", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (80, 12, "Stormwind Mountains", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (81, 22, "Jeff NE Quadrant Changed", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (82, 22, "Jeff NW Quadrant", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (83, 22, "Jeff SE Quadrant", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (84, 22, "Jeff SW Quadrant", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (85, 0, "Tirisfal Glades", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (86, 12, "Stone Cairn Lake", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (87, 12, "Goldshire", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (88, 12, "Eastvale Logging Camp", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (89, 12, "Mirror Lake Orchard", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (91, 12, "Tower of Azora", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (92, 12, "Mirror Lake", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (93, 10, "Vul'Gol Ogre Mound", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (94, 10, "Raven Hill", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (95, 44, "Redridge Canyons", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (96, 44, "Tower of Ilgalar", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (97, 44, "Alther's Mill", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (98, 44, "Rethban Caverns", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (99, 33, "Rebel Camp", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (100, 33, "Nesingwary's Expedition", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (101, 33, "Kurzen's Compound", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (102, 33, "Ruins of Zul'Kunda", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (103, 33, "Ruins of Zul'Mamwe", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (104, 33, "The Vile Reef", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (105, 33, "Mosh'Ogg Ogre Mound", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (106, 33, "The Stockpile", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (107, 40, "Saldean's Farm", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (108, 40, "Sentinel Hill", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (109, 40, "Furlbrow's Pumpkin Farm", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (111, 40, "Jangolode Mine", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (113, 40, "Gold Coast Quarry", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (115, 40, "Westfall Lighthouse", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (116, 8, "Misty Valley", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (117, 33, "Grom'gol Base Camp", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (118, 11, "Whelgar's Excavation Site", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (120, 12, "Westbrook Garrison", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (121, 10, "Tranquil Gardens Cemetery", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (122, 33, "Zuuldaia Ruins", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (123, 33, "Bal'lal Ruins", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (125, 33, "Kal'ai Ruins", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (126, 33, "Tkashi Ruins", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (127, 33, "Balia'mah Ruins", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (128, 33, "Ziata'jai Ruins", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (129, 33, "Mizjah Ruins", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (130, 0, "Silverpine Forest", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (131, 1, "Kharanos", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (132, 1, "Coldridge Valley", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (133, 1, "Gnomeregan", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (134, 1, "Gol'Bolar Quarry", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (135, 1, "Frostmane Hold", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (136, 1, "The Grizzled Den", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (137, 1, "Brewnall Village", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (138, 1, "Misty Pine Refuge", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (139, 0, "Eastern Plaguelands", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (141, 0, "Teldrassil", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (142, 38, "Ironband's Excavation Site", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (143, 38, "Mo'grosh Stronghold", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (144, 38, "Thelsamar", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (145, 38, "Algaz Gate", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (146, 38, "Stonewrought Dam", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (147, 38, "The Farstrider Lodge", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (148, 0, "Darkshore", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (149, 38, "Silver Stream Mine", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (150, 11, "Menethil Harbor", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (151, 0, "Designer Island", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (152, 85, "The Bulwark", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (153, 85, "Ruins of Lordaeron", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (154, 85, "Deathknell", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (155, 85, "Night Web's Hollow", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (156, 85, "Solliden Farmstead", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (157, 85, "Agamand Mills", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (158, 85, "Agamand Family Crypt", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (159, 85, "Brill", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (160, 85, "Whispering Gardens", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (161, 85, "Terrace of Repose", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (162, 85, "Brightwater Lake", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (163, 85, "Gunther's Retreat", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (164, 85, "Garren's Haunt", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (165, 85, "Balnir Farmstead", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (166, 85, "Cold Hearth Manor", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (167, 85, "Crusader Outpost", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (168, 85, "The North Coast", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (169, 85, "Whispering Shore", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (170, 0, "Lordamere Lake", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (172, 130, "Fenris Isle", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (173, 85, "Faol's Rest", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (186, 141, "Dolanaar", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (187, 141, "Darnassus UNUSED", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (188, 141, "Shadowglen", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (189, 1, "Steelgrill's Depot", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (190, 28, "Hearthglen", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (192, 28, "Northridge Lumber Camp", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (193, 28, "Ruins of Andorhal", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (195, 28, "School of Necromancy", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (196, 28, "Uther's Tomb", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (197, 28, "Sorrow Hill", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (198, 28, "The Weeping Cave", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (199, 28, "Felstone Field", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (200, 28, "Dalson's Tears", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (201, 28, "Gahrron's Withering", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (202, 28, "The Writhing Haunt", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (203, 28, "Mardenholde Keep", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (204, 130, "Pyrewood Village", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (205, 11, "Dun Modr", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (206, 0, "Westfall", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (207, 0, "The Great Sea", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (208, 0, "Unused Ironcladcove", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (209, 0, "Shadowfang Keep", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (210, 0, "***On Map Dungeon***", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (211, 1, "Iceflow Lake", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (212, 1, "Helm's Bed Lake", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (213, 130, "Deep Elem Mine", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (214, 0, "The Great Sea", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (215, 0, "Mulgore", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (219, 40, "Alexston Farmstead", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (220, 215, "Red Cloud Mesa", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (221, 215, "Camp Narache", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (222, 215, "Bloodhoof Village", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (223, 215, "Stonebull Lake", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (224, 215, "Ravaged Caravan", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (225, 215, "Red Rocks", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (226, 130, "The Skittering Dark", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (227, 130, "Valgan's Field", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (228, 130, "The Sepulcher", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (229, 130, "Olsen's Farthing", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (230, 130, "The Greymane Wall", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (231, 130, "Beren's Peril", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (232, 130, "The Dawning Isles", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (233, 130, "Ambermill", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (235, 130, "Fenris Keep", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (236, 130, "Shadowfang Keep", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (237, 130, "The Decrepit Ferry", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (238, 130, "Malden's Orchard", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (239, 130, "The Ivar Patch", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (240, 130, "The Dead Field", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (241, 10, "The Rotting Orchard", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (242, 10, "Brightwood Grove", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (243, 10, "Forlorn Rowe", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (244, 10, "The Whipple Estate", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (245, 10, "The Yorgen Farmstead", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (246, 51, "The Cauldron", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (247, 51, "Grimesilt Dig Site", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (249, 46, "Dreadmaul Rock", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (250, 46, "Ruins of Thaurissan", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (251, 46, "Flame Crest", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (252, 46, "Blackrock Stronghold", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (253, 46, "The Pillar of Ash", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (254, 46, "Blackrock Mountain", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (255, 46, "Altar of Storms", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (256, 141, "Aldrassil", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (257, 141, "Shadowthread Cave", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (258, 141, "Fel Rock", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (259, 141, "Lake Al'Ameth", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (260, 141, "Starbreeze Village", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (261, 141, "Gnarlpine Hold", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (262, 141, "Ban'ethil Barrow Den", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (263, 141, "The Cleft", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (264, 141, "The Oracle Glade", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (265, 141, "Wellspring River", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (266, 141, "Wellspring Lake", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (267, 0, "Hillsbrad Foothills", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (268, 0, "Azshara Crater", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (269, 0, "Dun Algaz", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (271, 267, "Southshore", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (272, 267, "Tarren Mill", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (275, 267, "Durnholde Keep", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (276, 0, "UNUSED Stonewrought Pass", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (277, 36, "The Foothill Caverns", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (278, 36, "Lordamere Internment Camp", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (279, 36, "Dalaran", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (280, 36, "Strahnbrad", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (281, 36, "Ruins of Alterac", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (282, 36, "Crushridge Hold", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (283, 36, "Slaughter Hollow", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (284, 36, "The Uplands", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (285, 267, "Southpoint Tower", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (286, 267, "Hillsbrad Fields", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (287, 267, "Hillsbrad", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (288, 267, "Azurelode Mine", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (289, 267, "Nethander Stead", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (290, 267, "Dun Garok", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (293, 0, "Thoradin's Wall", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (294, 267, "Eastern Strand", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (295, 267, "Western Strand", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (296, 0, "South Seas UNUSED", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (297, 33, "Jaguero Isle", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (298, 11, "Baradin Bay", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (299, 11, "Menethil Bay", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (300, 8, "Misty Reed Strand", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (301, 33, "The Savage Coast", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (302, 33, "The Crystal Shore", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (303, 33, "Shell Beach", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (305, 130, "North Tide's Run", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (306, 130, "South Tide's Run", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (307, 47, "The Overlook Cliffs", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (308, 0, "The Forbidding Sea", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (309, 11, "Ironbeard's Tomb", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (310, 33, "Crystalvein Mine", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (311, 33, "Ruins of Aboraz", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (312, 33, "Janeiro's Point", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (313, 45, "Northfold Manor", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (314, 45, "Go'Shek Farm", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (315, 45, "Dabyrie's Farmstead", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (316, 45, "Boulderfist Hall", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (317, 45, "Witherbark Village", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (318, 45, "Drywhisker Gorge", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (320, 45, "Refuge Pointe", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (321, 45, "Hammerfall", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (322, 45, "Blackwater Shipwrecks", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (323, 45, "O'Breen's Camp", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (324, 45, "Stromgarde Keep", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (325, 45, "The Tower of Arathor", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (326, 45, "The Sanctum", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (327, 45, "Faldir's Cove", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (328, 45, "The Drowned Reef", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (330, 0, "Thandol Span", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (331, 0, "Ashenvale", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (332, 0, "The Great Sea", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (333, 45, "Circle of East Binding", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (334, 45, "Circle of West Binding", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (335, 45, "Circle of Inner Binding", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (336, 45, "Circle of Outer Binding", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (337, 3, "Apocryphan's Rest", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (338, 3, "Angor Fortress", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (339, 3, "Lethlor Ravine", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (340, 3, "Kargath", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (341, 3, "Camp Kosh", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (342, 3, "Camp Boff", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (343, 3, "Camp Wurg", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (344, 3, "Camp Cagg", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (345, 3, "Agmond's End", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (346, 3, "Hammertoe's Digsite", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (347, 3, "Dustbelch Grotto", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (348, 47, "Aerie Peak", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (349, 47, "Wildhammer Keep", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (350, 47, "Quel'Danil Lodge", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (351, 47, "Skulk Rock", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (352, 47, "Zun'watha", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (353, 47, "Shadra'Alor", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (354, 47, "Jintha'Alor", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (355, 47, "The Altar of Zul", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (356, 47, "Seradane", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (357, 0, "Feralas", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (358, 215, "Brambleblade Ravine", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (359, 17, "Bael Modan", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (360, 215, "The Venture Co. Mine", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (361, 0, "Felwood", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (362, 14, "Razor Hill", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (363, 14, "Valley of Trials", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (364, 14, "The Den", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (365, 14, "Burning Blade Coven", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (366, 14, "Kolkar Crag", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (367, 14, "Sen'jin Village", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (368, 14, "Echo Isles", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (369, 14, "Thunder Ridge", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (370, 14, "Drygulch Ravine", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (371, 14, "Dustwind Cave", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (372, 14, "Tiragarde Keep", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (373, 14, "Scuttle Coast", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (374, 14, "Bladefist Bay", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (375, 14, "Deadeye Shore", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (377, 0, "Southfury River", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (378, 17, "Camp Taurajo", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (379, 17, "Far Watch Post", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (380, 17, "The Crossroads", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (381, 17, "Boulder Lode Mine", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (382, 17, "The Sludge Fen", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (383, 17, "The Dry Hills", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (384, 17, "Dreadmist Peak", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (385, 17, "Northwatch Hold", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (386, 17, "The Forgotten Pools", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (387, 17, "Lushwater Oasis", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (388, 17, "The Stagnant Oasis", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (390, 17, "Field of Giants", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (391, 17, "The Merchant Coast", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (392, 17, "Ratchet", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (393, 14, "Darkspear Strand", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (394, 0, "Darrowmere Lake UNUSED", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (395, 394, "Caer Darrow UNUSED", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (396, 215, "Winterhoof Water Well", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (397, 215, "Thunderhorn Water Well", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (398, 215, "Wildmane Water Well", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (399, 215, "Skyline Ridge", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (400, 0, "Thousand Needles", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (401, 17, "The Tidus Stair", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (403, 15, "Shady Rest Inn", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (404, 215, "Bael'dun Digsite", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (405, 0, "Desolace", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (406, 0, "Stonetalon Mountains", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (407, 14, "Orgrimmar UNUSED", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (408, 0, "Gillijim's Isle", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (409, 0, "Island of Doctor Lapidis", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (410, 14, "Razorwind Canyon", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (411, 331, "Bathran's Haunt", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (412, 331, "The Ruins of Ordil'Aran", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (413, 331, "Maestra's Post", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (414, 331, "The Zoram Strand", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (415, 331, "Astranaar", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (416, 331, "The Shrine of Aessina", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (417, 331, "Fire Scar Shrine", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (418, 331, "The Ruins of Stardust", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (419, 331, "The Howling Vale", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (420, 331, "Silverwind Refuge", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (421, 331, "Mystral Lake", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (422, 331, "Fallen Sky Lake", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (424, 331, "Iris Lake", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (425, 331, "Moonwell", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (426, 331, "Raynewood Retreat", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (427, 331, "The Shady Nook", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (428, 331, "Night Run", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (429, 331, "Xavian", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (430, 331, "Satyrnaar", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (431, 331, "Splintertree Post", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (432, 331, "The Dor'Danil Barrow Den", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (433, 331, "Falfarren River", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (434, 331, "Felfire Hill", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (435, 331, "Demon Fall Canyon", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (436, 331, "Demon Fall Ridge", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (437, 331, "Warsong Lumber Camp", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (438, 331, "Bough Shadow", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (439, 400, "The Shimmering Flats", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (440, 0, "Tanaris", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (441, 331, "Lake Falathim", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (442, 148, "Auberdine", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (443, 148, "Ruins of Mathystra", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (444, 148, "Tower of Althalaxx", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (445, 148, "Cliffspring Falls", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (446, 148, "Bashal'Aran", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (447, 148, "Ameth'Aran", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (448, 148, "Grove of the Ancients", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (449, 148, "The Master's Glaive", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (450, 148, "Remtravel's Excavation", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (452, 148, "Mist's Edge", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (453, 148, "The Long Wash", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (454, 148, "Wildbend River", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (455, 148, "Blackwood Den", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (456, 148, "Cliffspring River", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (457, 0, "The Veiled Sea", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (458, 17, "Gold Road", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (459, 85, "Scarlet Watch Post", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (460, 406, "Sun Rock Retreat", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (461, 406, "Windshear Crag", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (463, 406, "Cragpool Lake", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (464, 406, "Mirkfallon Lake", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (465, 406, "The Charred Vale", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (466, 406, "Valley of the Bloodfuries", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (467, 406, "Stonetalon Peak", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (468, 406, "The Talon Den", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (469, 406, "Greatwood Vale", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (470, 215, "Thunder Bluff UNUSED", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (471, 215, "Brave Wind Mesa", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (472, 215, "Fire Stone Mesa", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (473, 215, "Mantle Rock", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (474, 215, "Hunter Rise UNUSED", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (475, 215, "Spirit RiseUNUSED", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (476, 215, "Elder RiseUNUSED", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (477, 33, "Ruins of Jubuwal", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (478, 141, "Pools of Arlithrien", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (479, 400, "The Rustmaul Dig Site", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (480, 400, "Camp E'thok", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (481, 400, "Splithoof Crag", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (482, 400, "Highperch", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (483, 400, "The Screeching Canyon", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (484, 400, "Freewind Post", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (485, 400, "The Great Lift", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (486, 400, "Galak Hold", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (487, 400, "Roguefeather Den", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (488, 400, "The Weathered Nook", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (489, 357, "Thalanaar", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (490, 0, "Un'Goro Crater", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (491, 0, "Razorfen Kraul", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (492, 10, "Raven Hill Cemetery", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (493, 0, "Moonglade", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (495, 0, "DELETE ME", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (496, 15, "Brackenwall Village", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (497, 15, "Swamplight Manor", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (498, 15, "Bloodfen Burrow", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (499, 15, "Darkmist Cavern", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (500, 15, "Moggle Point", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (501, 15, "Beezil's Wreck", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (502, 15, "Witch Hill", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (503, 15, "Sentry Point", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (504, 15, "North Point Tower", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (505, 15, "West Point Tower", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (506, 15, "Lost Point", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (507, 15, "Bluefen", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (508, 15, "Stonemaul Ruins", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (509, 15, "The Den of Flame", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (510, 15, "The Dragonmurk", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (511, 15, "Wyrmbog", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (512, 15, "Onyxia's Lair UNUSED", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (513, 15, "Theramore Isle", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (514, 15, "Foothold Citadel", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (515, 15, "Ironclad Prison", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (516, 15, "Dustwallow Bay", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (517, 15, "Tidefury Cove", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (518, 15, "Dreadmurk Shore", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (536, 10, "Addle's Stead", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (537, 490, "Fire Plume Ridge", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (538, 490, "Lakkari Tar Pits", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (539, 490, "Terror Run", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (540, 490, "The Slithering Scar", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (541, 490, "Marshal's Refuge", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (542, 490, "Fungal Rock", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (543, 490, "Golakka Hot Springs", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (556, 38, "The Loch", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (576, 10, "Beggar's Haunt", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (596, 405, "Kodo Graveyard", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (597, 405, "Ghost Walker Post", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (598, 405, "Sar'theris Strand", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (599, 405, "Thunder Axe Fortress", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (600, 405, "Bolgan's Hole", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (602, 405, "Mannoroc Coven", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (603, 405, "Sargeron", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (604, 405, "Magram Village", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (606, 405, "Gelkis Village", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (607, 405, "Valley of Spears", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (608, 405, "Nijel's Point", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (609, 405, "Kolkar Village", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (616, 0, "Hyjal", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (618, 0, "Winterspring", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (636, 406, "Blackwolf River", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (637, 215, "Kodo Rock", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (638, 14, "Hidden Path", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (639, 14, "Spirit Rock", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (640, 14, "Shrine of the Dormant Flame", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (656, 493, "Lake Elune'ara", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (657, 8, "The Harborage", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (676, 0, "Outland", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (696, 141, "Craftsmen's Terrace UNUSED", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (697, 141, "Tradesmen's Terrace UNUSED", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (698, 141, "The Temple Gardens UNUSED", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (699, 141, "Temple of Elune UNUSED", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (700, 141, "Cenarion Enclave UNUSED", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (701, 141, "Warrior's Terrace UNUSED", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (702, 141, "Rut'theran Village", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (716, 1, "Ironband's Compound", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (717, 0, "The Stockade", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (718, 0, "Wailing Caverns", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (719, 0, "Blackfathom Deeps", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (720, 17, "Fray Island", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (721, 0, "Gnomeregan", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (722, 0, "Razorfen Downs", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (736, 141, "Ban'ethil Hollow", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (796, 0, "Scarlet Monastery", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (797, 12, "Jerod's Landing", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (798, 12, "Ridgepoint Tower", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (799, 10, "The Darkened Bank", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (800, 1, "Coldridge Pass", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (801, 1, "Chill Breeze Valley", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (802, 1, "Shimmer Ridge", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (803, 1, "Amberstill Ranch", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (804, 1, "The Tundrid Hills", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (805, 1, "South Gate Pass", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (806, 1, "South Gate Outpost", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (807, 1, "North Gate Pass", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (808, 1, "North Gate Outpost", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (809, 1, "Gates of Ironforge", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (810, 85, "Stillwater Pond", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (811, 85, "Nightmare Vale", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (812, 85, "Venomweb Vale", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (813, 28, "The Bulwark", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (814, 14, "Southfury River", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (815, 17, "Southfury River", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (816, 14, "Razormane Grounds", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (817, 14, "Skull Rock", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (818, 215, "Palemane Rock", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (819, 215, "Windfury Ridge", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (820, 215, "The Golden Plains", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (821, 215, "The Rolling Plains", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (836, 11, "Dun Algaz", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (837, 38, "Dun Algaz", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (838, 38, "North Gate Pass", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (839, 38, "South Gate Pass", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (856, 10, "Twilight Grove", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (876, 0, "GM Island", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (877, 17, "Delete ME", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (878, 16, "Southfury River", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (879, 331, "Southfury River", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (880, 45, "Thandol Span", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (881, 11, "Thandol Span", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (896, 267, "Purgation Isle", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (916, 40, "The Jansen Stead", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (917, 40, "The Dead Acre", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (918, 40, "The Molsen Farm", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (919, 40, "Stendel's Pond", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (920, 40, "The Dagger Hills", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (921, 40, "Demont's Place", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (922, 40, "The Dust Plains", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (923, 38, "Stonesplinter Valley", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (924, 38, "Valley of Kings", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (925, 38, "Algaz Station", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (926, 130, "Bucklebree Farm", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (927, 130, "The Shining Strand", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (928, 130, "North Tide's Hollow", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (936, 38, "Grizzlepaw Ridge", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (956, 0, "The Verdant Fields", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (976, 440, "Gadgetzan", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (977, 440, "Steamwheedle Port", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (978, 440, "Zul'Farrak", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (979, 440, "Sandsorrow Watch", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (980, 440, "Thistleshrub Valley", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (981, 440, "The Gaping Chasm", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (982, 440, "The Noxious Lair", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (983, 440, "Dunemaul Compound", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (984, 440, "Eastmoon Ruins", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (985, 440, "Waterspring Field", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (986, 440, "Zalashji's Den", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (987, 440, "Land's End Beach", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (988, 440, "Wavestrider Beach", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (989, 440, "Uldum", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (990, 440, "Valley of the Watchers", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (991, 440, "Gunstan's Post", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (992, 440, "Southmoon Ruins", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (996, 44, "Render's Camp", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (997, 44, "Render's Valley", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (998, 44, "Render's Rock", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (999, 44, "Stonewatch Tower", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1000, 44, "Galardell Valley", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1001, 44, "Lakeridge Highway", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1002, 44, "Three Corners", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1016, 11, "Direforge Hill", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1017, 11, "Raptor Ridge", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1018, 11, "Black Channel Marsh", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1019, 139, "The Green Belt", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1020, 11, "Mosshide Fen", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1021, 11, "Thelgen Rock", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1022, 11, "Bluegill Marsh", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1023, 11, "Saltspray Glen", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1024, 11, "Sundown Marsh", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1025, 11, "The Green Belt", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1036, 11, "Angerfang Encampment", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1037, 11, "Grim Batol", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1038, 11, "Dragonmaw Gates", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1039, 11, "The Lost Fleet", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1056, 267, "Darrow Hill", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1057, 267, "Thoradin's Wall", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1076, 406, "Webwinder Path", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1097, 10, "The Hushed Bank", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1098, 10, "Manor Mistmantle", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1099, 357, "Camp Mojache", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1100, 357, "Grimtotem Compound", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1101, 357, "The Writhing Deep", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1102, 357, "Wildwind Lake", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1103, 357, "Gordunni Outpost", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1104, 357, "Mok'Gordun", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1105, 357, "Feral Scar Vale", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1106, 357, "Frayfeather Highlands", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1107, 357, "Idlewind Lake", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1108, 357, "The Forgotten Coast", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1109, 357, "East Pillar", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1110, 357, "West Pillar", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1111, 357, "Dream Bough", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1112, 357, "Jademir Lake", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1113, 357, "Oneiros", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1114, 357, "Ruins of Ravenwind", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1115, 357, "Rage Scar Hold", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1116, 357, "Feathermoon Stronghold", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1117, 357, "Ruins of Solarsal", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1118, 357, "Lower Wilds UNUSED", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1119, 357, "The Twin Colossals", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1120, 357, "Sardor Isle", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1121, 357, "Isle of Dread", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1136, 357, "High Wilderness", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1137, 357, "Lower Wilds", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1156, 17, "Southern Barrens", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1157, 17, "Southern Gold Road", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1176, 0, "Zul'Farrak", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1196, 0, "UNUSEDAlcaz Island", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1216, 16, "Timbermaw Hold", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1217, 16, "Vanndir Encampment", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1218, 16, "TESTAzshara", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1219, 16, "Legash Encampment", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1220, 16, "Thalassian Base Camp", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1221, 16, "Ruins of Eldarath ", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1222, 16, "Hetaera's Clutch", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1223, 16, "Temple of Zin-Malor", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1224, 16, "Bear's Head", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1225, 16, "Ursolan", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1226, 16, "Temple of Arkkoran", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1227, 16, "Bay of Storms", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1228, 16, "The Shattered Strand", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1229, 16, "Tower of Eldara", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1230, 16, "Jagged Reef", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1231, 16, "Southridge Beach", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1232, 16, "Ravencrest Monument", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1233, 16, "Forlorn Ridge", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1234, 16, "Lake Mennar", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1235, 16, "Shadowsong Shrine", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1236, 16, "Haldarr Encampment", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1237, 16, "Valormok", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1256, 16, "The Ruined Reaches", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1276, 331, "The Talondeep Path", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1277, 406, "The Talondeep Path", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1296, 14, "Rocktusk Farm", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1297, 14, "Jaggedswine Farm", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1316, 17, "Razorfen Downs", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1336, 440, "Lost Rigger Cove", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1337, 0, "Uldaman", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1338, 130, "Lordamere Lake", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1339, 36, "Lordamere Lake", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1357, 36, "Gallows' Corner", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1377, 0, "Silithus", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1397, 0, "Emerald Forest", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1417, 0, "Sunken Temple", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1437, 4, "Dreadmaul Hold", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1438, 4, "Nethergarde Keep", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1439, 4, "Dreadmaul Post", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1440, 4, "Serpent's Coil", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1441, 4, "Altar of Storms", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1442, 51, "Firewatch Ridge", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1443, 51, "The Slag Pit", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1444, 51, "The Sea of Cinders", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1445, 51, "Blackrock Mountain", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1446, 51, "Thorium Point", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1457, 4, "Garrison Armory", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1477, 0, "The Temple of Atal'Hakkar", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1497, 0, "Undercity", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1517, 3, "Uldaman", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1518, 40, "Not Used Deadmines", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1519, 0, "Stormwind City", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1537, 0, "Ironforge", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1557, 400, "Splithoof Hold", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1577, 33, "The Cape of Stranglethorn", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1578, 33, "Southern Savage Coast", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1579, 0, "Unused The Deadmines 002", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1580, 1579, "Unused Ironclad Cove 003", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1581, 0, "The Deadmines", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1582, 1581, "Ironclad Cove", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1583, 0, "Blackrock Spire", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1584, 0, "Blackrock Depths", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1597, 17, "Raptor Grounds UNUSED", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1598, 17, "Grol'dom Farm UNUSED", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1599, 17, "Mor'shan Base Camp", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1600, 17, "Honor's Stand UNUSED", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1601, 17, "Blackthorn Ridge UNUSED", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1602, 17, "Bramblescar UNUSED", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1603, 17, "Agama'gor UNUSED", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1617, 1519, "Valley of Heroes", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1637, 0, "Orgrimmar", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1638, 0, "Thunder Bluff", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1639, 1638, "Elder Rise", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1640, 1638, "Spirit Rise", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1641, 1638, "Hunter Rise", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1657, 0, "Darnassus", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1658, 1657, "Cenarion Enclave", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1659, 1657, "Craftsmen's Terrace", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1660, 1657, "Warrior's Terrace", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1661, 1657, "The Temple Gardens", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1662, 1657, "Tradesmen's Terrace", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1677, 36, "Gavin's Naze", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1678, 36, "Sofera's Naze", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1679, 36, "Corrahn's Dagger", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1680, 36, "The Headland", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1681, 36, "Misty Shore", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1682, 36, "Dandred's Fold", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1683, 36, "Growless Cave", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1684, 36, "Chillwind Point", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1697, 17, "Raptor Grounds", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1698, 17, "Bramblescar", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1699, 17, "Thorn Hill", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1700, 17, "Agama'gor", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1701, 17, "Blackthorn Ridge", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1702, 17, "Honor's Stand", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1703, 17, "The Mor'shan Rampart", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1704, 17, "Grol'dom Farm", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1717, 17, "Razorfen Kraul", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1718, 17, "The Great Lift", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1737, 33, "Mistvale Valley", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1738, 33, "Nek'mani Wellspring", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1739, 33, "Bloodsail Compound", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1740, 33, "Venture Co. Base Camp", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1741, 33, "Gurubashi Arena", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1742, 33, "Spirit Den", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1757, 33, "The Crimson Veil", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1758, 33, "The Riptide", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1759, 33, "The Damsel's Luck", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1760, 33, "Venture Co. Operations Center", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1761, 361, "Deadwood Village", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1762, 361, "Felpaw Village", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1763, 361, "Jaedenar", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1764, 361, "Bloodvenom River", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1765, 361, "Bloodvenom Falls", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1766, 361, "Shatter Scar Vale", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1767, 361, "Irontree Woods", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1768, 361, "Irontree Cavern", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1769, 361, "Timbermaw Hold", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1770, 361, "Shadow Hold", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1771, 361, "Shrine of the Deceiver", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1777, 8, "Itharius's Cave", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1778, 8, "Sorrowmurk", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1779, 8, "Draenil'dur Village", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1780, 8, "Splinterspear Junction", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1797, 8, "Stagalbog", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1798, 8, "The Shifting Mire", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1817, 8, "Stagalbog Cave", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1837, 45, "Witherbark Caverns", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1857, 45, "Thoradin's Wall", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1858, 45, "Boulder'gor", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1877, 3, "Valley of Fangs", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1878, 3, "The Dustbowl", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1879, 3, "Mirage Flats", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1880, 47, "Featherbeard's Hovel", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1881, 47, "Shindigger's Camp", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1882, 47, "Plaguemist Ravine", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1883, 47, "Valorwind Lake", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1884, 47, "Agol'watha", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1885, 47, "Hiri'watha", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1886, 47, "The Creeping Ruin", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1887, 47, "Bogen's Ledge", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1897, 3, "The Maker's Terrace", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1898, 3, "Dustwind Gulch", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1917, 47, "Shaol'watha", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1937, 440, "Noonshade Ruins", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1938, 440, "Broken Pillar", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1939, 440, "Abyssal Sands", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1940, 440, "Southbreak Shore", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1941, 0, "Caverns of Time", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1942, 490, "The Marshlands", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1943, 490, "Ironstone Plateau", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1957, 51, "Blackchar Cave", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1958, 51, "Tanner Camp", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1959, 51, "Dustfire Valley", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1977, 0, "Zul'Gurub", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1978, 8, "Misty Reed Post", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1997, 361, "Bloodvenom Post ", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (1998, 361, "Talonbranch Glade ", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2017, 0, "Stratholme", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2037, 0, "UNUSEDShadowfang Keep 003", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2057, 0, "Scholomance", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2077, 148, "Twilight Vale", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2078, 148, "Twilight Shore", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2079, 15, "Alcaz Island", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2097, 400, "Darkcloud Pinnacle", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2098, 10, "Dawning Wood Catacombs", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2099, 44, "Stonewatch Keep", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2100, 0, "Maraudon", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2101, 38, "Stoutlager Inn", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2102, 1, "Thunderbrew Distillery", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2103, 11, "Menethil Keep", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2104, 11, "Deepwater Tavern", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2117, 85, "Shadow Grave", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2118, 85, "Brill Town Hall", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2119, 85, "Gallows' End Tavern", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2137, 215, "The Pools of VisionUNUSED", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2138, 17, "Dreadmist Den", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2157, 17, "Bael'dun Keep", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2158, 15, "Emberstrife's Den", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2159, 0, "Onyxia's Lair", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2160, 406, "Windshear Mine", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2161, 10, "Roland's Doom", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2177, 33, "Battle Ring", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2197, 1638, "The Pools of Vision", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2198, 405, "Shadowbreak Ravine", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2217, 405, "Broken Spear Village", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2237, 400, "Whitereach Post", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2238, 400, "Gornia", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2239, 400, "Zane's Eye Crater", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2240, 400, "Mirage Raceway", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2241, 618, "Frostsaber Rock", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2242, 618, "The Hidden Grove", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2243, 618, "Timbermaw Post", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2244, 618, "Winterfall Village", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2245, 618, "Mazthoril", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2246, 618, "Frostfire Hot Springs", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2247, 618, "Ice Thistle Hills", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2248, 618, "Dun Mandarr", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2249, 618, "Frostwhisper Gorge", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2250, 618, "Owl Wing Thicket", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2251, 618, "Lake Kel'Theril", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2252, 618, "The Ruins of Kel'Theril", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2253, 618, "Starfall Village", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2254, 618, "Ban'Thallow Barrow Den", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2255, 618, "Everlook", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2256, 618, "Darkwhisper Gorge", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2257, 0, "Deeprun Tram", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2258, 139, "The Fungal Vale", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2259, 139, "UNUSEDThe Marris Stead", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2260, 139, "The Marris Stead", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2261, 139, "The Undercroft", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2262, 139, "Darrowshire", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2263, 139, "Crown Guard Tower", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2264, 139, "Corin's Crossing", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2265, 139, "Scarlet Base Camp", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2266, 139, "Tyr's Hand", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2267, 139, "The Scarlet Basilica", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2268, 139, "Light's Hope Chapel", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2269, 139, "Browman Mill", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2270, 139, "The Noxious Glade", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2271, 139, "Eastwall Tower", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2272, 139, "Northdale", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2273, 139, "Zul'Mashar", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2274, 139, "Mazra'Alor", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2275, 139, "Northpass Tower", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2276, 139, "Quel'Lithien Lodge", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2277, 139, "Plaguewood", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2278, 139, "Scourgehold", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2279, 139, "Stratholme", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2280, 0, "UNUSED Stratholme", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2297, 28, "Darrowmere Lake", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2298, 28, "Caer Darrow", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2299, 139, "Darrowmere Lake", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2300, 440, "Caverns of Time", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2301, 331, "Thistlefur Village", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2302, 15, "The Quagmire", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2303, 400, "Windbreak Canyon", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2317, 440, "South Seas", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2318, 15, "The Great Sea", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2319, 17, "The Great Sea", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2320, 14, "The Great Sea", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2321, 16, "The Great Sea", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2322, 141, "The Veiled Sea", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2323, 357, "The Veiled Sea", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2324, 405, "The Veiled Sea", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2325, 331, "The Veiled Sea", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2326, 148, "The Veiled Sea", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2337, 14, "Razor Hill Barracks", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2338, 33, "South Seas", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2339, 33, "The Great Sea", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2357, 331, "Bloodtooth Camp", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2358, 331, "Forest Song", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2359, 331, "Greenpaw Village", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2360, 331, "Silverwing Outpost", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2361, 493, "Nighthaven", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2362, 493, "Shrine of Remulos", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2363, 493, "Stormrage Barrow Dens", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2364, 40, "The Great Sea", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2365, 11, "The Great Sea", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2366, 0, "The Black Morass", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2367, 0, "Old Hillsbrad Foothills", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2368, 2367, "Tarren Mill", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2369, 2367, "Southshore", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2370, 2367, "Durnholde Keep", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2371, 2367, "Dun Garok", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2372, 2367, "Hillsbrad Fields", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2373, 2367, "Eastern Strand", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2374, 2367, "Nethander Stead", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2375, 2367, "Darrow Hill", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2376, 2367, "Southpoint Tower", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2377, 2367, "Thoradin's Wall", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2378, 2367, "Western Strand", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2379, 2367, "Azurelode Mine", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2397, 267, "The Great Sea", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2398, 130, "The Great Sea", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2399, 85, "The Great Sea", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2400, 47, "The Forbidding Sea", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2401, 45, "The Forbidding Sea", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2402, 11, "The Forbidding Sea", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2403, 8, "The Forbidding Sea", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2404, 405, "Tethris Aran", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2405, 405, "Ethel Rethor", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2406, 405, "Ranazjar Isle", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2407, 405, "Kormek's Hut", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2408, 405, "Shadowprey Village", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2417, 46, "Blackrock Pass", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2418, 46, "Morgan's Vigil", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2419, 46, "Slither Rock", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2420, 46, "Terror Wing Path", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2421, 46, "Draco'dar", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2437, 0, "Ragefire Chasm", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2457, 331, "Nightsong Woods", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2477, 1377, "The Veiled Sea", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2478, 361, "Morlos'Aran", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2479, 361, "Emerald Sanctuary", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2480, 361, "Jadefire Glen", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2481, 361, "Ruins of Constellas", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2497, 16, "Bitter Reaches", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2517, 4, "Rise of the Defiler", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2518, 357, "Lariss Pavilion", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2519, 357, "Woodpaw Hills", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2520, 357, "Woodpaw Den", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2521, 357, "Verdantis River", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2522, 357, "Ruins of Isildien", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2537, 406, "Grimtotem Post", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2538, 406, "Camp Aparaje", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2539, 406, "Malaka'jin", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2540, 406, "Boulderslide Ravine", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2541, 406, "Sishir Canyon", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2557, 0, "Dire Maul", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2558, 41, "Deadwind Ravine", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2559, 41, "Diamondhead River", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2560, 41, "Ariden's Camp", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2561, 41, "The Vice", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2562, 41, "Karazhan", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2563, 41, "Morgan's Plot", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2577, 357, "Dire Maul", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2597, 0, "Alterac Valley", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2617, 405, "Scrabblescrew's Camp", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2618, 361, "Jadefire Run", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2619, 139, "Thondroril River", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2620, 28, "Thondroril River", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2621, 139, "Lake Mereldar", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2622, 139, "Pestilent Scar", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2623, 139, "The Infectis Scar", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2624, 139, "Blackwood Lake", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2625, 139, "Eastwall Gate", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2626, 139, "Terrorweb Tunnel", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2627, 139, "Terrordale", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2637, 331, "Kargathia Keep", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2657, 405, "Valley of Bones", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2677, 0, "Blackwing Lair", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2697, 41, "Deadman's Crossing", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2717, 0, "Molten Core", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2737, 1377, "The Scarab Wall", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2738, 1377, "Southwind Village", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2739, 1377, "Twilight Base Camp", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2740, 1377, "The Crystal Vale", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2741, 1377, "The Scarab Dais", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2742, 1377, "Hive'Ashi", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2743, 1377, "Hive'Zora", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2744, 1377, "Hive'Regal", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2757, 17, "Shrine of the Fallen Warrior", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2777, 267, "UNUSED Alterac Valley", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2797, 331, "Blackfathom Deeps", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2817, 0, "***On Map Dungeon***", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2837, 41, "The Master's Cellar", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2838, 51, "Stonewrought Pass", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2839, 36, "Alterac Valley", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2857, 440, "The Rumble Cage", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2877, 22, "Chunk Test", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2897, 331, "Zoram'gar Outpost", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2917, 0, "Hall of Legends", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2918, 0, "Champions' Hall", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2937, 41, "Grosh'gok Compound", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2938, 41, "Sleeping Gorge", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2957, 2597, "Irondeep Mine", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2958, 2597, "Stonehearth Outpost", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2959, 2597, "Dun Baldar", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2960, 2597, "Icewing Pass", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2961, 2597, "Frostwolf Village", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2962, 2597, "Tower Point", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2963, 2597, "Coldtooth Mine", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2964, 2597, "Winterax Hold", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2977, 2597, "Iceblood Garrison", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2978, 2597, "Frostwolf Keep", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (2979, 14, "Tor'kren Farm", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3017, 2597, "Frost Dagger Pass", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3037, 400, "Ironstone Camp", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3038, 400, "Weazel's Crater", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3039, 400, "Tahonda Ruins", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3057, 2597, "Field of Strife", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3058, 2597, "Icewing Cavern", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3077, 1377, "Valor's Rest", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3097, 1377, "The Swarming Pillar", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3098, 1377, "Twilight Post", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3099, 1377, "Twilight Outpost", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3100, 1377, "Ravaged Twilight Camp", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3117, 357, "Shalzaru's Lair", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3137, 16, "Talrendis Point", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3138, 16, "Rethress Sanctum", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3139, 618, "Moon Horror Den", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3140, 16, "Scalebeard's Cave", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3157, 406, "Boulderslide Cavern", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3177, 331, "Warsong Labor Camp", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3197, 28, "Chillwind Camp", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3217, 2557, "The Maul", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3237, 2557, "The Maul UNUSED", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3257, 1377, "Bones of Grakkarond", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3277, 0, "Warsong Gulch", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3297, 2597, "Frostwolf Graveyard", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3298, 2597, "Frostwolf Pass", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3299, 2597, "Dun Baldar Pass", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3300, 2597, "Iceblood Graveyard", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3301, 2597, "Snowfall Graveyard", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3302, 2597, "Stonehearth Graveyard", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3303, 2597, "Stormpike Graveyard", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3304, 2597, "Icewing Bunker", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3305, 2597, "Stonehearth Bunker", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3306, 2597, "Wildpaw Ridge", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3317, 47, "Revantusk Village", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3318, 2597, "Rock of Durotan", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3319, 331, "Silverwing Grove", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3320, 3277, "Warsong Lumber Mill", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3321, 3277, "Silverwing Hold", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3337, 2597, "Wildpaw Cavern", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3338, 2597, "The Veiled Cleft", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3357, 33, "Yojamba Isle", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3358, 0, "Arathi Basin", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3377, 1977, "The Coil", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3378, 1977, "Altar of Hir'eek", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3379, 1977, "Shadra'zaar", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3380, 1977, "Hakkari Grounds", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3381, 1977, "Naze of Shirvallah", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3382, 1977, "Temple of Bethekk", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3383, 1977, "The Bloodfire Pit", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3384, 1977, "Altar of the Blood God", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3397, 1977, "Zanza's Rise", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3398, 1977, "Edge of Madness", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3417, 3358, "Trollbane Hall", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3418, 3358, "Defiler's Den", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3419, 1977, "Pagle's Pointe", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3420, 3358, "Farm", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3421, 3358, "Blacksmith", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3422, 3358, "Lumber Mill", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3423, 3358, "Gold Mine", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3424, 3358, "Stables", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3425, 1377, "Cenarion Hold", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3426, 1377, "Staghelm Point", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3427, 1377, "Bronzebeard Encampment", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3428, 0, "Ahn'Qiraj", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3429, 0, "Ruins of Ahn'Qiraj", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3446, 1377, "Twilight's Run", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3447, 1377, "Ortell's Hideout", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3448, 3429, "Scarab Terrace", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3449, 3429, "General's Terrace", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3450, 3429, "The Reservoir", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3451, 3429, "The Hatchery", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3452, 3429, "The Comb", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3453, 3429, "Watchers' Terrace", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3454, 1377, "Ruins of Ahn'Qiraj", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3456, 0, "Naxxramas", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3459, 0, "City", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3478, 0, "Gates of Ahn'Qiraj", '', '', '', '', '', '', '', '', '');
INSERT INTO `AreaTable_vanilla` VALUES (3486, 36, "Ravenholdt Manor", '', '', '', '', '', '', '', '', '');
UPDATE `AreaTable_vanilla` SET name_loc1 = "Dun Morogh" WHERE id = 1;
UPDATE `AreaTable_vanilla` SET name_loc1 = "기나긴 해안" WHERE id = 2;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Badlands" WHERE id = 3;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Blasted Lands" WHERE id = 4;
UPDATE `AreaTable_vanilla` SET name_loc1 = "검은바다 만" WHERE id = 7;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Swamp of Sorrows" WHERE id = 8;
UPDATE `AreaTable_vanilla` SET name_loc1 = "노스샤이어 계곡" WHERE id = 9;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Duskwood" WHERE id = 10;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Wetlands" WHERE id = 11;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Elwynn Forest" WHERE id = 12;
UPDATE `AreaTable_vanilla` SET name_loc1 = "세계수" WHERE id = 13;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Durotar" WHERE id = 14;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Dustwallow Marsh" WHERE id = 15;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Azshara" WHERE id = 16;
UPDATE `AreaTable_vanilla` SET name_loc1 = "The Barrens" WHERE id = 17;
UPDATE `AreaTable_vanilla` SET name_loc1 = "수정 호수" WHERE id = 18;
UPDATE `AreaTable_vanilla` SET name_loc1 = "줄구룹" WHERE id = 19;
UPDATE `AreaTable_vanilla` SET name_loc1 = "문브룩" WHERE id = 20;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Kul Tiras" WHERE id = 21;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Programmer Isle" WHERE id = 22;
UPDATE `AreaTable_vanilla` SET name_loc1 = "노스샤이어 강" WHERE id = 23;
UPDATE `AreaTable_vanilla` SET name_loc1 = "노스샤이어 수도원" WHERE id = 24;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Blackrock Mountain" WHERE id = 25;
UPDATE `AreaTable_vanilla` SET name_loc1 = "등대" WHERE id = 26;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Western Plaguelands" WHERE id = 28;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Nine" WHERE id = 30;
UPDATE `AreaTable_vanilla` SET name_loc1 = "묘지" WHERE id = 32;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Stranglethorn Vale" WHERE id = 33;
UPDATE `AreaTable_vanilla` SET name_loc1 = "메아리 광산" WHERE id = 34;
UPDATE `AreaTable_vanilla` SET name_loc1 = "무법항" WHERE id = 35;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Alterac Mountains" WHERE id = 36;
UPDATE `AreaTable_vanilla` SET name_loc1 = "나즈페리티 호수" WHERE id = 37;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Loch Modan" WHERE id = 38;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Westfall" WHERE id = 40;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Deadwind Pass" WHERE id = 41;
UPDATE `AreaTable_vanilla` SET name_loc1 = "다크샤이어" WHERE id = 42;
UPDATE `AreaTable_vanilla` SET name_loc1 = "거친 해안" WHERE id = 43;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Redridge Mountains" WHERE id = 44;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Arathi Highlands" WHERE id = 45;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Burning Steppes" WHERE id = 46;
UPDATE `AreaTable_vanilla` SET name_loc1 = "The Hinterlands" WHERE id = 47;
UPDATE `AreaTable_vanilla` SET name_loc1 = "사자의 구멍" WHERE id = 49;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Searing Gorge" WHERE id = 51;
UPDATE `AreaTable_vanilla` SET name_loc1 = "도둑 야영지" WHERE id = 53;
UPDATE `AreaTable_vanilla` SET name_loc1 = "석영 광산" WHERE id = 54;
UPDATE `AreaTable_vanilla` SET name_loc1 = "영웅의 계곡" WHERE id = 55;
UPDATE `AreaTable_vanilla` SET name_loc1 = "수호영웅의 안식처" WHERE id = 56;
UPDATE `AreaTable_vanilla` SET name_loc1 = "개미굴 광산" WHERE id = 57;
UPDATE `AreaTable_vanilla` SET name_loc1 = "노스샤이어 포도밭" WHERE id = 59;
UPDATE `AreaTable_vanilla` SET name_loc1 = "숲 가장자리" WHERE id = 60;
UPDATE `AreaTable_vanilla` SET name_loc1 = "천둥 폭포" WHERE id = 61;
UPDATE `AreaTable_vanilla` SET name_loc1 = "브랙웰 호박밭" WHERE id = 62;
UPDATE `AreaTable_vanilla` SET name_loc1 = "스톤필드 농장" WHERE id = 63;
UPDATE `AreaTable_vanilla` SET name_loc1 = "맥클루어 포도밭" WHERE id = 64;
UPDATE `AreaTable_vanilla` SET name_loc1 = "*** 야외 던전 ***" WHERE id = 65;
UPDATE `AreaTable_vanilla` SET name_loc1 = "*** 야외 던전 ***" WHERE id = 66;
UPDATE `AreaTable_vanilla` SET name_loc1 = "*** 야외 던전 ***" WHERE id = 67;
UPDATE `AreaTable_vanilla` SET name_loc1 = "영원의 호수" WHERE id = 68;
UPDATE `AreaTable_vanilla` SET name_loc1 = "레이크샤이어" WHERE id = 69;
UPDATE `AreaTable_vanilla` SET name_loc1 = "돌망루 요새" WHERE id = 70;
UPDATE `AreaTable_vanilla` SET name_loc1 = "함락된 돌망루 요새" WHERE id = 71;
UPDATE `AreaTable_vanilla` SET name_loc1 = "어둠의 문" WHERE id = 72;
UPDATE `AreaTable_vanilla` SET name_loc1 = "타락의 흉터" WHERE id = 73;
UPDATE `AreaTable_vanilla` SET name_loc1 = "눈물의 연못" WHERE id = 74;
UPDATE `AreaTable_vanilla` SET name_loc1 = "스토나드" WHERE id = 75;
UPDATE `AreaTable_vanilla` SET name_loc1 = "드레노어 성역" WHERE id = 76;
UPDATE `AreaTable_vanilla` SET name_loc1 = "앤빌마" WHERE id = 77;
UPDATE `AreaTable_vanilla` SET name_loc1 = "스톰윈드 산맥" WHERE id = 80;
UPDATE `AreaTable_vanilla` SET name_loc1 = "제프의 북동 사분면" WHERE id = 81;
UPDATE `AreaTable_vanilla` SET name_loc1 = "제프의 북서 사분면" WHERE id = 82;
UPDATE `AreaTable_vanilla` SET name_loc1 = "제프의 남동 사분면" WHERE id = 83;
UPDATE `AreaTable_vanilla` SET name_loc1 = "제프의 남서 사분면" WHERE id = 84;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Tirisfal Glades" WHERE id = 85;
UPDATE `AreaTable_vanilla` SET name_loc1 = "돌무덤 호수" WHERE id = 86;
UPDATE `AreaTable_vanilla` SET name_loc1 = "골드샤이어" WHERE id = 87;
UPDATE `AreaTable_vanilla` SET name_loc1 = "동부 벌목지" WHERE id = 88;
UPDATE `AreaTable_vanilla` SET name_loc1 = "거울 호수 과수원" WHERE id = 89;
UPDATE `AreaTable_vanilla` SET name_loc1 = "아조라의 탑" WHERE id = 91;
UPDATE `AreaTable_vanilla` SET name_loc1 = "거울 호수" WHERE id = 92;
UPDATE `AreaTable_vanilla` SET name_loc1 = "벌골 오우거 소굴" WHERE id = 93;
UPDATE `AreaTable_vanilla` SET name_loc1 = "까마귀 언덕" WHERE id = 94;
UPDATE `AreaTable_vanilla` SET name_loc1 = "붉은마루 협곡" WHERE id = 95;
UPDATE `AreaTable_vanilla` SET name_loc1 = "일갈라의 탑" WHERE id = 96;
UPDATE `AreaTable_vanilla` SET name_loc1 = "앨더의 제재소" WHERE id = 97;
UPDATE `AreaTable_vanilla` SET name_loc1 = "레스밴 동굴" WHERE id = 98;
UPDATE `AreaTable_vanilla` SET name_loc1 = "반란군 야영지" WHERE id = 99;
UPDATE `AreaTable_vanilla` SET name_loc1 = "네싱워리 원정대" WHERE id = 100;
UPDATE `AreaTable_vanilla` SET name_loc1 = "쿠르젠 주둔지" WHERE id = 101;
UPDATE `AreaTable_vanilla` SET name_loc1 = "줄쿤다의 폐허" WHERE id = 102;
UPDATE `AreaTable_vanilla` SET name_loc1 = "줄맘웨의 폐허" WHERE id = 103;
UPDATE `AreaTable_vanilla` SET name_loc1 = "썩은내 산호초" WHERE id = 104;
UPDATE `AreaTable_vanilla` SET name_loc1 = "모쉬오그 오우거 소굴" WHERE id = 105;
UPDATE `AreaTable_vanilla` SET name_loc1 = "보급창" WHERE id = 106;
UPDATE `AreaTable_vanilla` SET name_loc1 = "살딘 농장" WHERE id = 107;
UPDATE `AreaTable_vanilla` SET name_loc1 = "감시의 언덕" WHERE id = 108;
UPDATE `AreaTable_vanilla` SET name_loc1 = "펄브로우 호박밭" WHERE id = 109;
UPDATE `AreaTable_vanilla` SET name_loc1 = "장고로드 광산" WHERE id = 111;
UPDATE `AreaTable_vanilla` SET name_loc1 = "황금해안 채석장" WHERE id = 113;
UPDATE `AreaTable_vanilla` SET name_loc1 = "서부 몰락지대 등대" WHERE id = 115;
UPDATE `AreaTable_vanilla` SET name_loc1 = "안개 골짜기" WHERE id = 116;
UPDATE `AreaTable_vanilla` SET name_loc1 = "그롬골 주둔지" WHERE id = 117;
UPDATE `AreaTable_vanilla` SET name_loc1 = "웰가르의 발굴현장" WHERE id = 118;
UPDATE `AreaTable_vanilla` SET name_loc1 = "서부 주둔지" WHERE id = 120;
UPDATE `AreaTable_vanilla` SET name_loc1 = "고요의 정원 묘지" WHERE id = 121;
UPDATE `AreaTable_vanilla` SET name_loc1 = "줄다이아 폐허" WHERE id = 122;
UPDATE `AreaTable_vanilla` SET name_loc1 = "발랄 폐허" WHERE id = 123;
UPDATE `AreaTable_vanilla` SET name_loc1 = "칼아이 폐허" WHERE id = 125;
UPDATE `AreaTable_vanilla` SET name_loc1 = "트카시 폐허" WHERE id = 126;
UPDATE `AreaTable_vanilla` SET name_loc1 = "발리아마 폐허" WHERE id = 127;
UPDATE `AreaTable_vanilla` SET name_loc1 = "지아타자이 폐허" WHERE id = 128;
UPDATE `AreaTable_vanilla` SET name_loc1 = "미즈자 폐허" WHERE id = 129;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Silverpine Forest" WHERE id = 130;
UPDATE `AreaTable_vanilla` SET name_loc1 = "카라노스" WHERE id = 131;
UPDATE `AreaTable_vanilla` SET name_loc1 = "눈마루 골짜기" WHERE id = 132;
UPDATE `AreaTable_vanilla` SET name_loc1 = "놈리건" WHERE id = 133;
UPDATE `AreaTable_vanilla` SET name_loc1 = "골볼라 채석장" WHERE id = 134;
UPDATE `AreaTable_vanilla` SET name_loc1 = "서리갈기 소굴" WHERE id = 135;
UPDATE `AreaTable_vanilla` SET name_loc1 = "은빛 동굴" WHERE id = 136;
UPDATE `AreaTable_vanilla` SET name_loc1 = "브루날 마을" WHERE id = 137;
UPDATE `AreaTable_vanilla` SET name_loc1 = "안개소나무 은거처" WHERE id = 138;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Eastern Plaguelands" WHERE id = 139;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Teldrassil" WHERE id = 141;
UPDATE `AreaTable_vanilla` SET name_loc1 = "아이언밴드의 발굴현장" WHERE id = 142;
UPDATE `AreaTable_vanilla` SET name_loc1 = "모그로쉬 소굴" WHERE id = 143;
UPDATE `AreaTable_vanilla` SET name_loc1 = "텔사마" WHERE id = 144;
UPDATE `AreaTable_vanilla` SET name_loc1 = "알가즈 관문" WHERE id = 145;
UPDATE `AreaTable_vanilla` SET name_loc1 = "돌다지 댐" WHERE id = 146;
UPDATE `AreaTable_vanilla` SET name_loc1 = "순찰자의 오두막" WHERE id = 147;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Darkshore" WHERE id = 148;
UPDATE `AreaTable_vanilla` SET name_loc1 = "은여울 광산" WHERE id = 149;
UPDATE `AreaTable_vanilla` SET name_loc1 = "메네실 항구" WHERE id = 150;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Designer Island" WHERE id = 151;
UPDATE `AreaTable_vanilla` SET name_loc1 = "보루" WHERE id = 152;
UPDATE `AreaTable_vanilla` SET name_loc1 = "로데론의 폐허" WHERE id = 153;
UPDATE `AreaTable_vanilla` SET name_loc1 = "데스넬" WHERE id = 154;
UPDATE `AreaTable_vanilla` SET name_loc1 = "검은그물 거미굴" WHERE id = 155;
UPDATE `AreaTable_vanilla` SET name_loc1 = "솔리덴 농장" WHERE id = 156;
UPDATE `AreaTable_vanilla` SET name_loc1 = "아가만드 밀농장" WHERE id = 157;
UPDATE `AreaTable_vanilla` SET name_loc1 = "아가만드가 납골당" WHERE id = 158;
UPDATE `AreaTable_vanilla` SET name_loc1 = "브릴" WHERE id = 159;
UPDATE `AreaTable_vanilla` SET name_loc1 = "속삭임의 정원" WHERE id = 160;
UPDATE `AreaTable_vanilla` SET name_loc1 = "평온의 정원" WHERE id = 161;
UPDATE `AreaTable_vanilla` SET name_loc1 = "청명 호수" WHERE id = 162;
UPDATE `AreaTable_vanilla` SET name_loc1 = "군터의 은거지" WHERE id = 163;
UPDATE `AreaTable_vanilla` SET name_loc1 = "가렌의 흉가" WHERE id = 164;
UPDATE `AreaTable_vanilla` SET name_loc1 = "발니르 농장" WHERE id = 165;
UPDATE `AreaTable_vanilla` SET name_loc1 = "버려진 장원" WHERE id = 166;
UPDATE `AreaTable_vanilla` SET name_loc1 = "붉은십자군 전초기지" WHERE id = 167;
UPDATE `AreaTable_vanilla` SET name_loc1 = "북부 해안" WHERE id = 168;
UPDATE `AreaTable_vanilla` SET name_loc1 = "속삭임의 해안" WHERE id = 169;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Lordamere Lake" WHERE id = 170;
UPDATE `AreaTable_vanilla` SET name_loc1 = "펜리스 섬" WHERE id = 172;
UPDATE `AreaTable_vanilla` SET name_loc1 = "파올의 안식처" WHERE id = 173;
UPDATE `AreaTable_vanilla` SET name_loc1 = "돌라나르" WHERE id = 186;
UPDATE `AreaTable_vanilla` SET name_loc1 = "다르나서스" WHERE id = 187;
UPDATE `AreaTable_vanilla` SET name_loc1 = "그늘 협곡" WHERE id = 188;
UPDATE `AreaTable_vanilla` SET name_loc1 = "스틸그릴의 정비소" WHERE id = 189;
UPDATE `AreaTable_vanilla` SET name_loc1 = "하스글렌" WHERE id = 190;
UPDATE `AreaTable_vanilla` SET name_loc1 = "북마루 벌목지" WHERE id = 192;
UPDATE `AreaTable_vanilla` SET name_loc1 = "안돌할 폐허" WHERE id = 193;
UPDATE `AreaTable_vanilla` SET name_loc1 = "강령술 학교" WHERE id = 195;
UPDATE `AreaTable_vanilla` SET name_loc1 = "우서 경의 무덤" WHERE id = 196;
UPDATE `AreaTable_vanilla` SET name_loc1 = "슬픔의 언덕" WHERE id = 197;
UPDATE `AreaTable_vanilla` SET name_loc1 = "진흙탕 동굴" WHERE id = 198;
UPDATE `AreaTable_vanilla` SET name_loc1 = "펠스톤 농장" WHERE id = 199;
UPDATE `AreaTable_vanilla` SET name_loc1 = "달슨의 눈물" WHERE id = 200;
UPDATE `AreaTable_vanilla` SET name_loc1 = "가론의 흉가" WHERE id = 201;
UPDATE `AreaTable_vanilla` SET name_loc1 = "고통의 흉가" WHERE id = 202;
UPDATE `AreaTable_vanilla` SET name_loc1 = "마르덴홀드 요새" WHERE id = 203;
UPDATE `AreaTable_vanilla` SET name_loc1 = "장작나무 마을" WHERE id = 204;
UPDATE `AreaTable_vanilla` SET name_loc1 = "던 모드르" WHERE id = 205;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Westfall" WHERE id = 206;
UPDATE `AreaTable_vanilla` SET name_loc1 = "The Great Sea" WHERE id = 207;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Unused Ironcladcove" WHERE id = 208;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Shadowfang Keep" WHERE id = 209;
UPDATE `AreaTable_vanilla` SET name_loc1 = "*** 야외 던전 ***" WHERE id = 210;
UPDATE `AreaTable_vanilla` SET name_loc1 = "얼음 호수" WHERE id = 211;
UPDATE `AreaTable_vanilla` SET name_loc1 = "투구바닥 호수" WHERE id = 212;
UPDATE `AreaTable_vanilla` SET name_loc1 = "심원 광산" WHERE id = 213;
UPDATE `AreaTable_vanilla` SET name_loc1 = "The Great Sea" WHERE id = 214;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Mulgore" WHERE id = 215;
UPDATE `AreaTable_vanilla` SET name_loc1 = "알렉스턴 농장" WHERE id = 219;
UPDATE `AreaTable_vanilla` SET name_loc1 = "붉은구름 고원" WHERE id = 220;
UPDATE `AreaTable_vanilla` SET name_loc1 = "나라체 야영지" WHERE id = 221;
UPDATE `AreaTable_vanilla` SET name_loc1 = "블러드후프 마을" WHERE id = 222;
UPDATE `AreaTable_vanilla` SET name_loc1 = "황소바위 호수" WHERE id = 223;
UPDATE `AreaTable_vanilla` SET name_loc1 = "습격당한 짐마차 행렬" WHERE id = 224;
UPDATE `AreaTable_vanilla` SET name_loc1 = "붉은 바위 언덕" WHERE id = 225;
UPDATE `AreaTable_vanilla` SET name_loc1 = "암흑 땅거미굴" WHERE id = 226;
UPDATE `AreaTable_vanilla` SET name_loc1 = "발간 농장" WHERE id = 227;
UPDATE `AreaTable_vanilla` SET name_loc1 = "공동묘지" WHERE id = 228;
UPDATE `AreaTable_vanilla` SET name_loc1 = "올슨 농장" WHERE id = 229;
UPDATE `AreaTable_vanilla` SET name_loc1 = "그레이메인 성벽" WHERE id = 230;
UPDATE `AreaTable_vanilla` SET name_loc1 = "베렌의 동굴" WHERE id = 231;
UPDATE `AreaTable_vanilla` SET name_loc1 = "여명의 섬" WHERE id = 232;
UPDATE `AreaTable_vanilla` SET name_loc1 = "앰버밀" WHERE id = 233;
UPDATE `AreaTable_vanilla` SET name_loc1 = "펜리스 요새" WHERE id = 235;
UPDATE `AreaTable_vanilla` SET name_loc1 = "그림자송곳니 성채" WHERE id = 236;
UPDATE `AreaTable_vanilla` SET name_loc1 = "오래된 나루터" WHERE id = 237;
UPDATE `AreaTable_vanilla` SET name_loc1 = "말덴의 과수원" WHERE id = 238;
UPDATE `AreaTable_vanilla` SET name_loc1 = "이바르 호박밭" WHERE id = 239;
UPDATE `AreaTable_vanilla` SET name_loc1 = "죽음의 농장" WHERE id = 240;
UPDATE `AreaTable_vanilla` SET name_loc1 = "오염된 과수원" WHERE id = 241;
UPDATE `AreaTable_vanilla` SET name_loc1 = "밝은숲" WHERE id = 242;
UPDATE `AreaTable_vanilla` SET name_loc1 = "버려진 흉가" WHERE id = 243;
UPDATE `AreaTable_vanilla` SET name_loc1 = "휘플가 저택" WHERE id = 244;
UPDATE `AreaTable_vanilla` SET name_loc1 = "요르겐 농장" WHERE id = 245;
UPDATE `AreaTable_vanilla` SET name_loc1 = "용광로" WHERE id = 246;
UPDATE `AreaTable_vanilla` SET name_loc1 = "검댕가루 발굴현장" WHERE id = 247;
UPDATE `AreaTable_vanilla` SET name_loc1 = "우레망치 바위굴" WHERE id = 249;
UPDATE `AreaTable_vanilla` SET name_loc1 = "타우릿산의 폐허" WHERE id = 250;
UPDATE `AreaTable_vanilla` SET name_loc1 = "화염 마루" WHERE id = 251;
UPDATE `AreaTable_vanilla` SET name_loc1 = "검은바위 요새" WHERE id = 252;
UPDATE `AreaTable_vanilla` SET name_loc1 = "잿빛 기둥" WHERE id = 253;
UPDATE `AreaTable_vanilla` SET name_loc1 = "검은바위 산" WHERE id = 254;
UPDATE `AreaTable_vanilla` SET name_loc1 = "폭풍의 제단" WHERE id = 255;
UPDATE `AreaTable_vanilla` SET name_loc1 = "알드랏실" WHERE id = 256;
UPDATE `AreaTable_vanilla` SET name_loc1 = "그늘 거미굴" WHERE id = 257;
UPDATE `AreaTable_vanilla` SET name_loc1 = "악마 바위굴" WHERE id = 258;
UPDATE `AreaTable_vanilla` SET name_loc1 = "알아메스 호수" WHERE id = 259;
UPDATE `AreaTable_vanilla` SET name_loc1 = "별바람 마을" WHERE id = 260;
UPDATE `AreaTable_vanilla` SET name_loc1 = "나무옹이 요새" WHERE id = 261;
UPDATE `AreaTable_vanilla` SET name_loc1 = "바네실 지하굴" WHERE id = 262;
UPDATE `AreaTable_vanilla` SET name_loc1 = "바위 동굴" WHERE id = 263;
UPDATE `AreaTable_vanilla` SET name_loc1 = "신탁의 숲" WHERE id = 264;
UPDATE `AreaTable_vanilla` SET name_loc1 = "생명의 강" WHERE id = 265;
UPDATE `AreaTable_vanilla` SET name_loc1 = "생명의 호수" WHERE id = 266;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Hillsbrad Foothills" WHERE id = 267;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Azshara Crater" WHERE id = 268;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Dun Algaz" WHERE id = 269;
UPDATE `AreaTable_vanilla` SET name_loc1 = "사우스쇼어" WHERE id = 271;
UPDATE `AreaTable_vanilla` SET name_loc1 = "타렌 밀농장" WHERE id = 272;
UPDATE `AreaTable_vanilla` SET name_loc1 = "던홀드 요새" WHERE id = 275;
UPDATE `AreaTable_vanilla` SET name_loc1 = "UNUSED Stonewrought Pass" WHERE id = 276;
UPDATE `AreaTable_vanilla` SET name_loc1 = "구릉지 동굴" WHERE id = 277;
UPDATE `AreaTable_vanilla` SET name_loc1 = "로다미어 포로수용소" WHERE id = 278;
UPDATE `AreaTable_vanilla` SET name_loc1 = "달라란" WHERE id = 279;
UPDATE `AreaTable_vanilla` SET name_loc1 = "스트란브래드" WHERE id = 280;
UPDATE `AreaTable_vanilla` SET name_loc1 = "알터랙 폐허" WHERE id = 281;
UPDATE `AreaTable_vanilla` SET name_loc1 = "산사태 오우거 소굴" WHERE id = 282;
UPDATE `AreaTable_vanilla` SET name_loc1 = "살육의 동굴" WHERE id = 283;
UPDATE `AreaTable_vanilla` SET name_loc1 = "고원" WHERE id = 284;
UPDATE `AreaTable_vanilla` SET name_loc1 = "남부 경비탑" WHERE id = 285;
UPDATE `AreaTable_vanilla` SET name_loc1 = "힐스브래드 농장" WHERE id = 286;
UPDATE `AreaTable_vanilla` SET name_loc1 = "힐스브래드" WHERE id = 287;
UPDATE `AreaTable_vanilla` SET name_loc1 = "청금석 광산" WHERE id = 288;
UPDATE `AreaTable_vanilla` SET name_loc1 = "네산더 농장" WHERE id = 289;
UPDATE `AreaTable_vanilla` SET name_loc1 = "던 가록" WHERE id = 290;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Thoradin's Wall" WHERE id = 293;
UPDATE `AreaTable_vanilla` SET name_loc1 = "동부 해안" WHERE id = 294;
UPDATE `AreaTable_vanilla` SET name_loc1 = "서부 해안" WHERE id = 295;
UPDATE `AreaTable_vanilla` SET name_loc1 = "South seas UNUSED" WHERE id = 296;
UPDATE `AreaTable_vanilla` SET name_loc1 = "자구에로 섬" WHERE id = 297;
UPDATE `AreaTable_vanilla` SET name_loc1 = "바라딘 만" WHERE id = 298;
UPDATE `AreaTable_vanilla` SET name_loc1 = "메네실 만" WHERE id = 299;
UPDATE `AreaTable_vanilla` SET name_loc1 = "안개갈대 해안" WHERE id = 300;
UPDATE `AreaTable_vanilla` SET name_loc1 = "폭풍 해안" WHERE id = 301;
UPDATE `AreaTable_vanilla` SET name_loc1 = "수정 해안" WHERE id = 302;
UPDATE `AreaTable_vanilla` SET name_loc1 = "조개껍질 해안" WHERE id = 303;
UPDATE `AreaTable_vanilla` SET name_loc1 = "북부 해안가" WHERE id = 305;
UPDATE `AreaTable_vanilla` SET name_loc1 = "남부 해안가" WHERE id = 306;
UPDATE `AreaTable_vanilla` SET name_loc1 = "전망대 절벽" WHERE id = 307;
UPDATE `AreaTable_vanilla` SET name_loc1 = "The Forbidding Sea" WHERE id = 308;
UPDATE `AreaTable_vanilla` SET name_loc1 = "아이언비어드의 고분" WHERE id = 309;
UPDATE `AreaTable_vanilla` SET name_loc1 = "수정 광산" WHERE id = 310;
UPDATE `AreaTable_vanilla` SET name_loc1 = "아보라즈의 폐허" WHERE id = 311;
UPDATE `AreaTable_vanilla` SET name_loc1 = "자네이로 섬" WHERE id = 312;
UPDATE `AreaTable_vanilla` SET name_loc1 = "북부습곡 장원" WHERE id = 313;
UPDATE `AreaTable_vanilla` SET name_loc1 = "고셰크 농장" WHERE id = 314;
UPDATE `AreaTable_vanilla` SET name_loc1 = "다비리 농장" WHERE id = 315;
UPDATE `AreaTable_vanilla` SET name_loc1 = "돌주먹일족 소굴" WHERE id = 316;
UPDATE `AreaTable_vanilla` SET name_loc1 = "마른나무껍질 마을" WHERE id = 317;
UPDATE `AreaTable_vanilla` SET name_loc1 = "마른수염 골짜기" WHERE id = 318;
UPDATE `AreaTable_vanilla` SET name_loc1 = "임시 주둔지" WHERE id = 320;
UPDATE `AreaTable_vanilla` SET name_loc1 = "해머폴" WHERE id = 321;
UPDATE `AreaTable_vanilla` SET name_loc1 = "검은바다 난파지" WHERE id = 322;
UPDATE `AreaTable_vanilla` SET name_loc1 = "오브린의 야영지" WHERE id = 323;
UPDATE `AreaTable_vanilla` SET name_loc1 = "스트롬가드 요새" WHERE id = 324;
UPDATE `AreaTable_vanilla` SET name_loc1 = "아라소르의 탑" WHERE id = 325;
UPDATE `AreaTable_vanilla` SET name_loc1 = "성소" WHERE id = 326;
UPDATE `AreaTable_vanilla` SET name_loc1 = "팔디르의 만" WHERE id = 327;
UPDATE `AreaTable_vanilla` SET name_loc1 = "가라앉은 산호초" WHERE id = 328;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Thandol Span" WHERE id = 330;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Ashenvale" WHERE id = 331;
UPDATE `AreaTable_vanilla` SET name_loc1 = "The Great Sea" WHERE id = 332;
UPDATE `AreaTable_vanilla` SET name_loc1 = "동쪽 봉인의 마법진" WHERE id = 333;
UPDATE `AreaTable_vanilla` SET name_loc1 = "서쪽 봉인의 마법진" WHERE id = 334;
UPDATE `AreaTable_vanilla` SET name_loc1 = "내부 봉인의 마법진" WHERE id = 335;
UPDATE `AreaTable_vanilla` SET name_loc1 = "외부 봉인의 마법진" WHERE id = 336;
UPDATE `AreaTable_vanilla` SET name_loc1 = "아포크리판의 안식처" WHERE id = 337;
UPDATE `AreaTable_vanilla` SET name_loc1 = "고통의 요새" WHERE id = 338;
UPDATE `AreaTable_vanilla` SET name_loc1 = "레슬로 협곡" WHERE id = 339;
UPDATE `AreaTable_vanilla` SET name_loc1 = "카르가스" WHERE id = 340;
UPDATE `AreaTable_vanilla` SET name_loc1 = "코쉬 야영지" WHERE id = 341;
UPDATE `AreaTable_vanilla` SET name_loc1 = "보프 야영지" WHERE id = 342;
UPDATE `AreaTable_vanilla` SET name_loc1 = "우르그 야영지" WHERE id = 343;
UPDATE `AreaTable_vanilla` SET name_loc1 = "카그 야영지" WHERE id = 344;
UPDATE `AreaTable_vanilla` SET name_loc1 = "아그몬드의 최후" WHERE id = 345;
UPDATE `AreaTable_vanilla` SET name_loc1 = "해머토의 발굴현장" WHERE id = 346;
UPDATE `AreaTable_vanilla` SET name_loc1 = "먼지목도리 소굴" WHERE id = 347;
UPDATE `AreaTable_vanilla` SET name_loc1 = "맹금의 봉우리" WHERE id = 348;
UPDATE `AreaTable_vanilla` SET name_loc1 = "와일드해머 요새" WHERE id = 349;
UPDATE `AreaTable_vanilla` SET name_loc1 = "쿠엘다닐 오두막" WHERE id = 350;
UPDATE `AreaTable_vanilla` SET name_loc1 = "굼벵이 바위굴" WHERE id = 351;
UPDATE `AreaTable_vanilla` SET name_loc1 = "준와타" WHERE id = 352;
UPDATE `AreaTable_vanilla` SET name_loc1 = "샤드라알로" WHERE id = 353;
UPDATE `AreaTable_vanilla` SET name_loc1 = "진타알로" WHERE id = 354;
UPDATE `AreaTable_vanilla` SET name_loc1 = "줄의 제단" WHERE id = 355;
UPDATE `AreaTable_vanilla` SET name_loc1 = "세라데인" WHERE id = 356;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Feralas" WHERE id = 357;
UPDATE `AreaTable_vanilla` SET name_loc1 = "칼날가시 협곡" WHERE id = 358;
UPDATE `AreaTable_vanilla` SET name_loc1 = "바엘 모단" WHERE id = 359;
UPDATE `AreaTable_vanilla` SET name_loc1 = "투자개발회사 광산" WHERE id = 360;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Felwood" WHERE id = 361;
UPDATE `AreaTable_vanilla` SET name_loc1 = "칼바위 언덕" WHERE id = 362;
UPDATE `AreaTable_vanilla` SET name_loc1 = "시험의 골짜기" WHERE id = 363;
UPDATE `AreaTable_vanilla` SET name_loc1 = "동굴 막사" WHERE id = 364;
UPDATE `AreaTable_vanilla` SET name_loc1 = "불타는 칼날 소굴" WHERE id = 365;
UPDATE `AreaTable_vanilla` SET name_loc1 = "콜카르 바윗골" WHERE id = 366;
UPDATE `AreaTable_vanilla` SET name_loc1 = "센진 마을" WHERE id = 367;
UPDATE `AreaTable_vanilla` SET name_loc1 = "메아리 섬" WHERE id = 368;
UPDATE `AreaTable_vanilla` SET name_loc1 = "천둥 골짜기" WHERE id = 369;
UPDATE `AreaTable_vanilla` SET name_loc1 = "모래바람 협곡" WHERE id = 370;
UPDATE `AreaTable_vanilla` SET name_loc1 = "먼지바람 동굴" WHERE id = 371;
UPDATE `AreaTable_vanilla` SET name_loc1 = "타이라가드 요새" WHERE id = 372;
UPDATE `AreaTable_vanilla` SET name_loc1 = "가라앉은 해안" WHERE id = 373;
UPDATE `AreaTable_vanilla` SET name_loc1 = "칼날주먹 만" WHERE id = 374;
UPDATE `AreaTable_vanilla` SET name_loc1 = "데드아이 해안" WHERE id = 375;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Southfury River" WHERE id = 377;
UPDATE `AreaTable_vanilla` SET name_loc1 = "타우라조 야영지" WHERE id = 378;
UPDATE `AreaTable_vanilla` SET name_loc1 = "전초 기지" WHERE id = 379;
UPDATE `AreaTable_vanilla` SET name_loc1 = "크로스로드" WHERE id = 380;
UPDATE `AreaTable_vanilla` SET name_loc1 = "돌무더기 광산" WHERE id = 381;
UPDATE `AreaTable_vanilla` SET name_loc1 = "진흙늪" WHERE id = 382;
UPDATE `AreaTable_vanilla` SET name_loc1 = "메마른 언덕" WHERE id = 383;
UPDATE `AreaTable_vanilla` SET name_loc1 = "공포의 안개봉우리" WHERE id = 384;
UPDATE `AreaTable_vanilla` SET name_loc1 = "북부 전초기지" WHERE id = 385;
UPDATE `AreaTable_vanilla` SET name_loc1 = "잊혀진 웅덩이" WHERE id = 386;
UPDATE `AreaTable_vanilla` SET name_loc1 = "푸른 오아시스" WHERE id = 387;
UPDATE `AreaTable_vanilla` SET name_loc1 = "죽은 오아시스" WHERE id = 388;
UPDATE `AreaTable_vanilla` SET name_loc1 = "거인의 들판" WHERE id = 390;
UPDATE `AreaTable_vanilla` SET name_loc1 = "무역 해안" WHERE id = 391;
UPDATE `AreaTable_vanilla` SET name_loc1 = "톱니항" WHERE id = 392;
UPDATE `AreaTable_vanilla` SET name_loc1 = "검은창 해안" WHERE id = 393;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Darrowmere Lake UNUSED" WHERE id = 394;
UPDATE `AreaTable_vanilla` SET name_loc1 = "카엘 다로우" WHERE id = 395;
UPDATE `AreaTable_vanilla` SET name_loc1 = "윈터후프 우물" WHERE id = 396;
UPDATE `AreaTable_vanilla` SET name_loc1 = "썬더혼 우물" WHERE id = 397;
UPDATE `AreaTable_vanilla` SET name_loc1 = "와일드메인 우물" WHERE id = 398;
UPDATE `AreaTable_vanilla` SET name_loc1 = "지평선 마루" WHERE id = 399;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Thousand Needles" WHERE id = 400;
UPDATE `AreaTable_vanilla` SET name_loc1 = "타이더스 계단" WHERE id = 401;
UPDATE `AreaTable_vanilla` SET name_loc1 = "그늘 쉼터 여관" WHERE id = 403;
UPDATE `AreaTable_vanilla` SET name_loc1 = "바엘던 발굴현장" WHERE id = 404;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Desolace" WHERE id = 405;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Stonetalon Mountains" WHERE id = 406;
UPDATE `AreaTable_vanilla` SET name_loc1 = "오그리마" WHERE id = 407;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Gillijim's Isle" WHERE id = 408;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Island of Doctor Lapidis" WHERE id = 409;
UPDATE `AreaTable_vanilla` SET name_loc1 = "칼바람 협곡" WHERE id = 410;
UPDATE `AreaTable_vanilla` SET name_loc1 = "배스랜 서식지" WHERE id = 411;
UPDATE `AreaTable_vanilla` SET name_loc1 = "오르딜아란의 폐허" WHERE id = 412;
UPDATE `AreaTable_vanilla` SET name_loc1 = "마에스트라 주둔지" WHERE id = 413;
UPDATE `AreaTable_vanilla` SET name_loc1 = "조람 해안" WHERE id = 414;
UPDATE `AreaTable_vanilla` SET name_loc1 = "아스트라나르" WHERE id = 415;
UPDATE `AreaTable_vanilla` SET name_loc1 = "아에시나의 제단" WHERE id = 416;
UPDATE `AreaTable_vanilla` SET name_loc1 = "불타버린 신전" WHERE id = 417;
UPDATE `AreaTable_vanilla` SET name_loc1 = "별가루의 폐허" WHERE id = 418;
UPDATE `AreaTable_vanilla` SET name_loc1 = "울부짖는 골짜기" WHERE id = 419;
UPDATE `AreaTable_vanilla` SET name_loc1 = "실바람 산장" WHERE id = 420;
UPDATE `AreaTable_vanilla` SET name_loc1 = "미스트랄 호수" WHERE id = 421;
UPDATE `AreaTable_vanilla` SET name_loc1 = "유성 호수" WHERE id = 422;
UPDATE `AreaTable_vanilla` SET name_loc1 = "아이리스 호수" WHERE id = 424;
UPDATE `AreaTable_vanilla` SET name_loc1 = "달샘" WHERE id = 425;
UPDATE `AreaTable_vanilla` SET name_loc1 = "라이네나무 은신처" WHERE id = 426;
UPDATE `AreaTable_vanilla` SET name_loc1 = "그늘 동굴" WHERE id = 427;
UPDATE `AreaTable_vanilla` SET name_loc1 = "어둠의 터" WHERE id = 428;
UPDATE `AreaTable_vanilla` SET name_loc1 = "사비안" WHERE id = 429;
UPDATE `AreaTable_vanilla` SET name_loc1 = "사티르나르" WHERE id = 430;
UPDATE `AreaTable_vanilla` SET name_loc1 = "토막나무 주둔지" WHERE id = 431;
UPDATE `AreaTable_vanilla` SET name_loc1 = "도르다닐 지하굴" WHERE id = 432;
UPDATE `AreaTable_vanilla` SET name_loc1 = "팔파렌 강" WHERE id = 433;
UPDATE `AreaTable_vanilla` SET name_loc1 = "지옥불 언덕" WHERE id = 434;
UPDATE `AreaTable_vanilla` SET name_loc1 = "악마벼락 협곡" WHERE id = 435;
UPDATE `AreaTable_vanilla` SET name_loc1 = "악마벼락 마루" WHERE id = 436;
UPDATE `AreaTable_vanilla` SET name_loc1 = "전쟁노래부족 벌목기지" WHERE id = 437;
UPDATE `AreaTable_vanilla` SET name_loc1 = "어둠의 나무" WHERE id = 438;
UPDATE `AreaTable_vanilla` SET name_loc1 = "소금 평원" WHERE id = 439;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Tanaris" WHERE id = 440;
UPDATE `AreaTable_vanilla` SET name_loc1 = "팔라딤 호수" WHERE id = 441;
UPDATE `AreaTable_vanilla` SET name_loc1 = "아우버다인" WHERE id = 442;
UPDATE `AreaTable_vanilla` SET name_loc1 = "마시스트라의 폐허" WHERE id = 443;
UPDATE `AreaTable_vanilla` SET name_loc1 = "알살락스의 탑" WHERE id = 444;
UPDATE `AreaTable_vanilla` SET name_loc1 = "절벽 폭포" WHERE id = 445;
UPDATE `AreaTable_vanilla` SET name_loc1 = "바샬아란" WHERE id = 446;
UPDATE `AreaTable_vanilla` SET name_loc1 = "아메스아란" WHERE id = 447;
UPDATE `AreaTable_vanilla` SET name_loc1 = "고대정령의 숲" WHERE id = 448;
UPDATE `AreaTable_vanilla` SET name_loc1 = "지배자의 무덤" WHERE id = 449;
UPDATE `AreaTable_vanilla` SET name_loc1 = "렘트레블의 발굴현장" WHERE id = 450;
UPDATE `AreaTable_vanilla` SET name_loc1 = "안개 해안" WHERE id = 452;
UPDATE `AreaTable_vanilla` SET name_loc1 = "침식지" WHERE id = 453;
UPDATE `AreaTable_vanilla` SET name_loc1 = "성난굽이 강" WHERE id = 454;
UPDATE `AreaTable_vanilla` SET name_loc1 = "검은나무일족 소굴" WHERE id = 455;
UPDATE `AreaTable_vanilla` SET name_loc1 = "폭포수 강" WHERE id = 456;
UPDATE `AreaTable_vanilla` SET name_loc1 = "The Veiled Sea" WHERE id = 457;
UPDATE `AreaTable_vanilla` SET name_loc1 = "황금길" WHERE id = 458;
UPDATE `AreaTable_vanilla` SET name_loc1 = "붉은십자군 경비초소" WHERE id = 459;
UPDATE `AreaTable_vanilla` SET name_loc1 = "해바위 야영지" WHERE id = 460;
UPDATE `AreaTable_vanilla` SET name_loc1 = "칼바람 바위산" WHERE id = 461;
UPDATE `AreaTable_vanilla` SET name_loc1 = "바위웅덩이 호수" WHERE id = 463;
UPDATE `AreaTable_vanilla` SET name_loc1 = "땅거미 호수" WHERE id = 464;
UPDATE `AreaTable_vanilla` SET name_loc1 = "잿더미 계곡" WHERE id = 465;
UPDATE `AreaTable_vanilla` SET name_loc1 = "혈폭풍일족의 골짜기" WHERE id = 466;
UPDATE `AreaTable_vanilla` SET name_loc1 = "돌발톱 봉우리" WHERE id = 467;
UPDATE `AreaTable_vanilla` SET name_loc1 = "갈퀴발톱굴" WHERE id = 468;
UPDATE `AreaTable_vanilla` SET name_loc1 = "큰소나무 계곡" WHERE id = 469;
UPDATE `AreaTable_vanilla` SET name_loc1 = "썬더 블러프" WHERE id = 470;
UPDATE `AreaTable_vanilla` SET name_loc1 = "용사의 바람절벽" WHERE id = 471;
UPDATE `AreaTable_vanilla` SET name_loc1 = "부싯돌 고원" WHERE id = 472;
UPDATE `AreaTable_vanilla` SET name_loc1 = "바람막이 바위" WHERE id = 473;
UPDATE `AreaTable_vanilla` SET name_loc1 = "수렵의 봉우리" WHERE id = 474;
UPDATE `AreaTable_vanilla` SET name_loc1 = "정기의 봉우리" WHERE id = 475;
UPDATE `AreaTable_vanilla` SET name_loc1 = "장로의 봉우리" WHERE id = 476;
UPDATE `AreaTable_vanilla` SET name_loc1 = "주부왈의 폐허" WHERE id = 477;
UPDATE `AreaTable_vanilla` SET name_loc1 = "아리스리엔 연못" WHERE id = 478;
UPDATE `AreaTable_vanilla` SET name_loc1 = "녹슨망치 발굴현장" WHERE id = 479;
UPDATE `AreaTable_vanilla` SET name_loc1 = "에톡 야영지" WHERE id = 480;
UPDATE `AreaTable_vanilla` SET name_loc1 = "갈래발굽 바윗골" WHERE id = 481;
UPDATE `AreaTable_vanilla` SET name_loc1 = "마루둥지" WHERE id = 482;
UPDATE `AreaTable_vanilla` SET name_loc1 = "회오리 협곡" WHERE id = 483;
UPDATE `AreaTable_vanilla` SET name_loc1 = "높새바람 봉우리" WHERE id = 484;
UPDATE `AreaTable_vanilla` SET name_loc1 = "구름 승강장" WHERE id = 485;
UPDATE `AreaTable_vanilla` SET name_loc1 = "갈라크 소굴" WHERE id = 486;
UPDATE `AreaTable_vanilla` SET name_loc1 = "하피 동굴" WHERE id = 487;
UPDATE `AreaTable_vanilla` SET name_loc1 = "비바람 바위굴" WHERE id = 488;
UPDATE `AreaTable_vanilla` SET name_loc1 = "탈라나르" WHERE id = 489;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Un'Goro Crater" WHERE id = 490;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Razorfen Kraul" WHERE id = 491;
UPDATE `AreaTable_vanilla` SET name_loc1 = "까마귀 언덕 묘지" WHERE id = 492;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Moonglade" WHERE id = 493;
UPDATE `AreaTable_vanilla` SET name_loc1 = "DELETE ME" WHERE id = 495;
UPDATE `AreaTable_vanilla` SET name_loc1 = "담쟁이 마을" WHERE id = 496;
UPDATE `AreaTable_vanilla` SET name_loc1 = "늪지기 오두막" WHERE id = 497;
UPDATE `AreaTable_vanilla` SET name_loc1 = "붉은늪지 동굴" WHERE id = 498;
UPDATE `AreaTable_vanilla` SET name_loc1 = "암흑안개 거미굴" WHERE id = 499;
UPDATE `AreaTable_vanilla` SET name_loc1 = "모글 야영지" WHERE id = 500;
UPDATE `AreaTable_vanilla` SET name_loc1 = "비질의 추락지" WHERE id = 501;
UPDATE `AreaTable_vanilla` SET name_loc1 = "마녀 언덕" WHERE id = 502;
UPDATE `AreaTable_vanilla` SET name_loc1 = "감시초소" WHERE id = 503;
UPDATE `AreaTable_vanilla` SET name_loc1 = "북부 경비탑" WHERE id = 504;
UPDATE `AreaTable_vanilla` SET name_loc1 = "서부 경비탑" WHERE id = 505;
UPDATE `AreaTable_vanilla` SET name_loc1 = "버려진 경비탑" WHERE id = 506;
UPDATE `AreaTable_vanilla` SET name_loc1 = "푸른늪지" WHERE id = 507;
UPDATE `AreaTable_vanilla` SET name_loc1 = "돌망치일족 폐허" WHERE id = 508;
UPDATE `AreaTable_vanilla` SET name_loc1 = "화염의 둥지" WHERE id = 509;
UPDATE `AreaTable_vanilla` SET name_loc1 = "용의 늪" WHERE id = 510;
UPDATE `AreaTable_vanilla` SET name_loc1 = "용의 둥지" WHERE id = 511;
UPDATE `AreaTable_vanilla` SET name_loc1 = "오닉시아의 둥지" WHERE id = 512;
UPDATE `AreaTable_vanilla` SET name_loc1 = "테라모어 섬" WHERE id = 513;
UPDATE `AreaTable_vanilla` SET name_loc1 = "거점 요새" WHERE id = 514;
UPDATE `AreaTable_vanilla` SET name_loc1 = "철갑 감옥" WHERE id = 515;
UPDATE `AreaTable_vanilla` SET name_loc1 = "먼지진흙 만" WHERE id = 516;
UPDATE `AreaTable_vanilla` SET name_loc1 = "성난파도 만" WHERE id = 517;
UPDATE `AreaTable_vanilla` SET name_loc1 = "몸서리 해안" WHERE id = 518;
UPDATE `AreaTable_vanilla` SET name_loc1 = "에이들의 은신처" WHERE id = 536;
UPDATE `AreaTable_vanilla` SET name_loc1 = "불기둥 마루" WHERE id = 537;
UPDATE `AreaTable_vanilla` SET name_loc1 = "락카리 잿구덩이" WHERE id = 538;
UPDATE `AreaTable_vanilla` SET name_loc1 = "공포의 터" WHERE id = 539;
UPDATE `AreaTable_vanilla` SET name_loc1 = "갈래굽이 구렁" WHERE id = 540;
UPDATE `AreaTable_vanilla` SET name_loc1 = "마샬의 야영지" WHERE id = 541;
UPDATE `AreaTable_vanilla` SET name_loc1 = "버섯 바위굴" WHERE id = 542;
UPDATE `AreaTable_vanilla` SET name_loc1 = "골락카 간헐천" WHERE id = 543;
UPDATE `AreaTable_vanilla` SET name_loc1 = "대호수" WHERE id = 556;
UPDATE `AreaTable_vanilla` SET name_loc1 = "부랑자 소굴" WHERE id = 576;
UPDATE `AreaTable_vanilla` SET name_loc1 = "코도 무덤" WHERE id = 596;
UPDATE `AreaTable_vanilla` SET name_loc1 = "침묵의 초소" WHERE id = 597;
UPDATE `AreaTable_vanilla` SET name_loc1 = "살데리스 해안" WHERE id = 598;
UPDATE `AreaTable_vanilla` SET name_loc1 = "천둥도끼 요새" WHERE id = 599;
UPDATE `AreaTable_vanilla` SET name_loc1 = "볼간의 구덩이" WHERE id = 600;
UPDATE `AreaTable_vanilla` SET name_loc1 = "만노로크 소굴" WHERE id = 602;
UPDATE `AreaTable_vanilla` SET name_loc1 = "살게론" WHERE id = 603;
UPDATE `AreaTable_vanilla` SET name_loc1 = "마그람 마을" WHERE id = 604;
UPDATE `AreaTable_vanilla` SET name_loc1 = "겔키스 마을" WHERE id = 606;
UPDATE `AreaTable_vanilla` SET name_loc1 = "뾰족바위 골짜기" WHERE id = 607;
UPDATE `AreaTable_vanilla` SET name_loc1 = "나이젤의 야영지" WHERE id = 608;
UPDATE `AreaTable_vanilla` SET name_loc1 = "콜카르 마을" WHERE id = 609;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Hyjal" WHERE id = 616;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Winterspring" WHERE id = 618;
UPDATE `AreaTable_vanilla` SET name_loc1 = "검은늑대 강" WHERE id = 636;
UPDATE `AreaTable_vanilla` SET name_loc1 = "코도 바위" WHERE id = 637;
UPDATE `AreaTable_vanilla` SET name_loc1 = "비밀의 길" WHERE id = 638;
UPDATE `AreaTable_vanilla` SET name_loc1 = "정기 바위" WHERE id = 639;
UPDATE `AreaTable_vanilla` SET name_loc1 = "희미한 불꽃의 제단" WHERE id = 640;
UPDATE `AreaTable_vanilla` SET name_loc1 = "엘룬아라 호수" WHERE id = 656;
UPDATE `AreaTable_vanilla` SET name_loc1 = "피난처" WHERE id = 657;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Outland" WHERE id = 676;
UPDATE `AreaTable_vanilla` SET name_loc1 = "장인의 정원" WHERE id = 696;
UPDATE `AreaTable_vanilla` SET name_loc1 = "상인의 정원" WHERE id = 697;
UPDATE `AreaTable_vanilla` SET name_loc1 = "신전 정원" WHERE id = 698;
UPDATE `AreaTable_vanilla` SET name_loc1 = "엘룬의 신전" WHERE id = 699;
UPDATE `AreaTable_vanilla` SET name_loc1 = "세나리온 자치령" WHERE id = 700;
UPDATE `AreaTable_vanilla` SET name_loc1 = "전사의 정원" WHERE id = 701;
UPDATE `AreaTable_vanilla` SET name_loc1 = "루테란 마을" WHERE id = 702;
UPDATE `AreaTable_vanilla` SET name_loc1 = "아이언밴드 야영지" WHERE id = 716;
UPDATE `AreaTable_vanilla` SET name_loc1 = "The Stockade" WHERE id = 717;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Wailing Caverns" WHERE id = 718;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Blackfathom Deeps" WHERE id = 719;
UPDATE `AreaTable_vanilla` SET name_loc1 = "격투의 섬" WHERE id = 720;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Gnomeregan" WHERE id = 721;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Razorfen Downs" WHERE id = 722;
UPDATE `AreaTable_vanilla` SET name_loc1 = "바네실 동굴" WHERE id = 736;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Scarlet Monastery" WHERE id = 796;
UPDATE `AreaTable_vanilla` SET name_loc1 = "제로드 선착장" WHERE id = 797;
UPDATE `AreaTable_vanilla` SET name_loc1 = "마루목 감시탑" WHERE id = 798;
UPDATE `AreaTable_vanilla` SET name_loc1 = "어스름 강둑" WHERE id = 799;
UPDATE `AreaTable_vanilla` SET name_loc1 = "눈마루 고개" WHERE id = 800;
UPDATE `AreaTable_vanilla` SET name_loc1 = "찬바람 골짜기" WHERE id = 801;
UPDATE `AreaTable_vanilla` SET name_loc1 = "쉼머 마루" WHERE id = 802;
UPDATE `AreaTable_vanilla` SET name_loc1 = "앰버스틸 목장" WHERE id = 803;
UPDATE `AreaTable_vanilla` SET name_loc1 = "툰드리드 언덕" WHERE id = 804;
UPDATE `AreaTable_vanilla` SET name_loc1 = "남부 관문 통행로" WHERE id = 805;
UPDATE `AreaTable_vanilla` SET name_loc1 = "남부 관문 전초기지" WHERE id = 806;
UPDATE `AreaTable_vanilla` SET name_loc1 = "북부 관문 통행로" WHERE id = 807;
UPDATE `AreaTable_vanilla` SET name_loc1 = "북부 관문 전초기지" WHERE id = 808;
UPDATE `AreaTable_vanilla` SET name_loc1 = "아이언포지 성문" WHERE id = 809;
UPDATE `AreaTable_vanilla` SET name_loc1 = "고요의 연못" WHERE id = 810;
UPDATE `AreaTable_vanilla` SET name_loc1 = "악몽의 골짜기" WHERE id = 811;
UPDATE `AreaTable_vanilla` SET name_loc1 = "독그물 골짜기" WHERE id = 812;
UPDATE `AreaTable_vanilla` SET name_loc1 = "보루" WHERE id = 813;
UPDATE `AreaTable_vanilla` SET name_loc1 = "분노의 강" WHERE id = 814;
UPDATE `AreaTable_vanilla` SET name_loc1 = "분노의 강" WHERE id = 815;
UPDATE `AreaTable_vanilla` SET name_loc1 = "서슬갈기일족 영토" WHERE id = 816;
UPDATE `AreaTable_vanilla` SET name_loc1 = "해골 바위굴" WHERE id = 817;
UPDATE `AreaTable_vanilla` SET name_loc1 = "회색갈기일족 바위굴" WHERE id = 818;
UPDATE `AreaTable_vanilla` SET name_loc1 = "성난바람 마루" WHERE id = 819;
UPDATE `AreaTable_vanilla` SET name_loc1 = "황금 초원" WHERE id = 820;
UPDATE `AreaTable_vanilla` SET name_loc1 = "구릉 초원" WHERE id = 821;
UPDATE `AreaTable_vanilla` SET name_loc1 = "던 알가즈" WHERE id = 836;
UPDATE `AreaTable_vanilla` SET name_loc1 = "던 알가즈" WHERE id = 837;
UPDATE `AreaTable_vanilla` SET name_loc1 = "북부 관문 통행로" WHERE id = 838;
UPDATE `AreaTable_vanilla` SET name_loc1 = "남부 관문 통행로" WHERE id = 839;
UPDATE `AreaTable_vanilla` SET name_loc1 = "황혼의 숲" WHERE id = 856;
UPDATE `AreaTable_vanilla` SET name_loc1 = "GM Island" WHERE id = 876;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Delete ME" WHERE id = 877;
UPDATE `AreaTable_vanilla` SET name_loc1 = "분노의 강" WHERE id = 878;
UPDATE `AreaTable_vanilla` SET name_loc1 = "분노의 강" WHERE id = 879;
UPDATE `AreaTable_vanilla` SET name_loc1 = "탄돌 교각" WHERE id = 880;
UPDATE `AreaTable_vanilla` SET name_loc1 = "탄돌 교각" WHERE id = 881;
UPDATE `AreaTable_vanilla` SET name_loc1 = "속죄의 섬" WHERE id = 896;
UPDATE `AreaTable_vanilla` SET name_loc1 = "얀센 농장" WHERE id = 916;
UPDATE `AreaTable_vanilla` SET name_loc1 = "메마른 논밭" WHERE id = 917;
UPDATE `AreaTable_vanilla` SET name_loc1 = "몰센 농장" WHERE id = 918;
UPDATE `AreaTable_vanilla` SET name_loc1 = "스텐들의 연못" WHERE id = 919;
UPDATE `AreaTable_vanilla` SET name_loc1 = "비수 언덕" WHERE id = 920;
UPDATE `AreaTable_vanilla` SET name_loc1 = "데몬트의 집터" WHERE id = 921;
UPDATE `AreaTable_vanilla` SET name_loc1 = "먼지 언덕" WHERE id = 922;
UPDATE `AreaTable_vanilla` SET name_loc1 = "가루바위 골짜기" WHERE id = 923;
UPDATE `AreaTable_vanilla` SET name_loc1 = "왕의 계곡" WHERE id = 924;
UPDATE `AreaTable_vanilla` SET name_loc1 = "알가즈 주둔지" WHERE id = 925;
UPDATE `AreaTable_vanilla` SET name_loc1 = "버클브리 농장" WHERE id = 926;
UPDATE `AreaTable_vanilla` SET name_loc1 = "반짝이는 호숫가" WHERE id = 927;
UPDATE `AreaTable_vanilla` SET name_loc1 = "북부 해안 골짜기" WHERE id = 928;
UPDATE `AreaTable_vanilla` SET name_loc1 = "곰발바닥 마루" WHERE id = 936;
UPDATE `AreaTable_vanilla` SET name_loc1 = "The Verdant Fields" WHERE id = 956;
UPDATE `AreaTable_vanilla` SET name_loc1 = "가젯잔" WHERE id = 976;
UPDATE `AreaTable_vanilla` SET name_loc1 = "스팀휘들 항구" WHERE id = 977;
UPDATE `AreaTable_vanilla` SET name_loc1 = "줄파락" WHERE id = 978;
UPDATE `AreaTable_vanilla` SET name_loc1 = "슬픈모래 감시탑" WHERE id = 979;
UPDATE `AreaTable_vanilla` SET name_loc1 = "덤불나무 골짜기" WHERE id = 980;
UPDATE `AreaTable_vanilla` SET name_loc1 = "모래지옥 협곡" WHERE id = 981;
UPDATE `AreaTable_vanilla` SET name_loc1 = "맹독의 둥지" WHERE id = 982;
UPDATE `AreaTable_vanilla` SET name_loc1 = "모래망치 주둔지" WHERE id = 983;
UPDATE `AreaTable_vanilla` SET name_loc1 = "동쪽 달의 폐허" WHERE id = 984;
UPDATE `AreaTable_vanilla` SET name_loc1 = "샘솟는 벌판" WHERE id = 985;
UPDATE `AreaTable_vanilla` SET name_loc1 = "잘라쉬지의 굴" WHERE id = 986;
UPDATE `AreaTable_vanilla` SET name_loc1 = "끝자락 해안" WHERE id = 987;
UPDATE `AreaTable_vanilla` SET name_loc1 = "파도타기 해안" WHERE id = 988;
UPDATE `AreaTable_vanilla` SET name_loc1 = "울둠" WHERE id = 989;
UPDATE `AreaTable_vanilla` SET name_loc1 = "감시자의 골짜기" WHERE id = 990;
UPDATE `AreaTable_vanilla` SET name_loc1 = "건스탠의 야영지" WHERE id = 991;
UPDATE `AreaTable_vanilla` SET name_loc1 = "서쪽 달의 폐허" WHERE id = 992;
UPDATE `AreaTable_vanilla` SET name_loc1 = "약탈의 야영지" WHERE id = 996;
UPDATE `AreaTable_vanilla` SET name_loc1 = "약탈의 계곡" WHERE id = 997;
UPDATE `AreaTable_vanilla` SET name_loc1 = "약탈의 바위굴" WHERE id = 998;
UPDATE `AreaTable_vanilla` SET name_loc1 = "돌망루 탑" WHERE id = 999;
UPDATE `AreaTable_vanilla` SET name_loc1 = "갈라델 골짜기" WHERE id = 1000;
UPDATE `AreaTable_vanilla` SET name_loc1 = "호수마루 오솔길" WHERE id = 1001;
UPDATE `AreaTable_vanilla` SET name_loc1 = "붉은마루 삼거리" WHERE id = 1002;
UPDATE `AreaTable_vanilla` SET name_loc1 = "불길한 언덕" WHERE id = 1016;
UPDATE `AreaTable_vanilla` SET name_loc1 = "랩터 마루" WHERE id = 1017;
UPDATE `AreaTable_vanilla` SET name_loc1 = "검은바닥 습지대" WHERE id = 1018;
UPDATE `AreaTable_vanilla` SET name_loc1 = "녹지대" WHERE id = 1019;
UPDATE `AreaTable_vanilla` SET name_loc1 = "이끼가죽 수렁" WHERE id = 1020;
UPDATE `AreaTable_vanilla` SET name_loc1 = "텔겐 바위굴" WHERE id = 1021;
UPDATE `AreaTable_vanilla` SET name_loc1 = "푸른아가미 습지대" WHERE id = 1022;
UPDATE `AreaTable_vanilla` SET name_loc1 = "소금물 습지대" WHERE id = 1023;
UPDATE `AreaTable_vanilla` SET name_loc1 = "해몰이 늪" WHERE id = 1024;
UPDATE `AreaTable_vanilla` SET name_loc1 = "녹지대" WHERE id = 1025;
UPDATE `AreaTable_vanilla` SET name_loc1 = "성난송곳니 야영지" WHERE id = 1036;
UPDATE `AreaTable_vanilla` SET name_loc1 = "그림 바톨" WHERE id = 1037;
UPDATE `AreaTable_vanilla` SET name_loc1 = "용아귀부족 관문" WHERE id = 1038;
UPDATE `AreaTable_vanilla` SET name_loc1 = "잃어버린 해안" WHERE id = 1039;
UPDATE `AreaTable_vanilla` SET name_loc1 = "다로우 언덕" WHERE id = 1056;
UPDATE `AreaTable_vanilla` SET name_loc1 = "소라딘의 성벽" WHERE id = 1057;
UPDATE `AreaTable_vanilla` SET name_loc1 = "그물누비 고개" WHERE id = 1076;
UPDATE `AreaTable_vanilla` SET name_loc1 = "고요의 강둑" WHERE id = 1097;
UPDATE `AreaTable_vanilla` SET name_loc1 = "미스트맨틀 장원" WHERE id = 1098;
UPDATE `AreaTable_vanilla` SET name_loc1 = "모자케 야영지" WHERE id = 1099;
UPDATE `AreaTable_vanilla` SET name_loc1 = "그림토템 주둔지" WHERE id = 1100;
UPDATE `AreaTable_vanilla` SET name_loc1 = "고통의 구덩이" WHERE id = 1101;
UPDATE `AreaTable_vanilla` SET name_loc1 = "갈기바람 호수" WHERE id = 1102;
UPDATE `AreaTable_vanilla` SET name_loc1 = "골두니 전초기지" WHERE id = 1103;
UPDATE `AreaTable_vanilla` SET name_loc1 = "모크골둔" WHERE id = 1104;
UPDATE `AreaTable_vanilla` SET name_loc1 = "거친흉터 골짜기" WHERE id = 1105;
UPDATE `AreaTable_vanilla` SET name_loc1 = "공작날개 고원" WHERE id = 1106;
UPDATE `AreaTable_vanilla` SET name_loc1 = "산들바람 호수" WHERE id = 1107;
UPDATE `AreaTable_vanilla` SET name_loc1 = "잊혀진 해안" WHERE id = 1108;
UPDATE `AreaTable_vanilla` SET name_loc1 = "동쪽 기둥" WHERE id = 1109;
UPDATE `AreaTable_vanilla` SET name_loc1 = "서쪽 기둥" WHERE id = 1110;
UPDATE `AreaTable_vanilla` SET name_loc1 = "꿈나무" WHERE id = 1111;
UPDATE `AreaTable_vanilla` SET name_loc1 = "비취비늘 호수" WHERE id = 1112;
UPDATE `AreaTable_vanilla` SET name_loc1 = "오네이로스" WHERE id = 1113;
UPDATE `AreaTable_vanilla` SET name_loc1 = "까마귀바람 폐허" WHERE id = 1114;
UPDATE `AreaTable_vanilla` SET name_loc1 = "무쇠설인 소굴" WHERE id = 1115;
UPDATE `AreaTable_vanilla` SET name_loc1 = "페더문 요새" WHERE id = 1116;
UPDATE `AreaTable_vanilla` SET name_loc1 = "솔라살 폐허" WHERE id = 1117;
UPDATE `AreaTable_vanilla` SET name_loc1 = "낮은벌" WHERE id = 1118;
UPDATE `AreaTable_vanilla` SET name_loc1 = "쌍둥이 바위산" WHERE id = 1119;
UPDATE `AreaTable_vanilla` SET name_loc1 = "살도르 섬" WHERE id = 1120;
UPDATE `AreaTable_vanilla` SET name_loc1 = "공포의 터" WHERE id = 1121;
UPDATE `AreaTable_vanilla` SET name_loc1 = "높은벌" WHERE id = 1136;
UPDATE `AreaTable_vanilla` SET name_loc1 = "낮은벌" WHERE id = 1137;
UPDATE `AreaTable_vanilla` SET name_loc1 = "불모의 땅 남부" WHERE id = 1156;
UPDATE `AreaTable_vanilla` SET name_loc1 = "남부 황금길" WHERE id = 1157;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Zul'Farrak" WHERE id = 1176;
UPDATE `AreaTable_vanilla` SET name_loc1 = "UNUSEDAlcaz Island" WHERE id = 1196;
UPDATE `AreaTable_vanilla` SET name_loc1 = "나무구렁 요새" WHERE id = 1216;
UPDATE `AreaTable_vanilla` SET name_loc1 = "반디르 야영지" WHERE id = 1217;
UPDATE `AreaTable_vanilla` SET name_loc1 = "아즈샤라" WHERE id = 1218;
UPDATE `AreaTable_vanilla` SET name_loc1 = "레가쉬 야영지" WHERE id = 1219;
UPDATE `AreaTable_vanilla` SET name_loc1 = "탈라시안 주둔지" WHERE id = 1220;
UPDATE `AreaTable_vanilla` SET name_loc1 = "엘다라스 폐허" WHERE id = 1221;
UPDATE `AreaTable_vanilla` SET name_loc1 = "헤타에라의 손아귀" WHERE id = 1222;
UPDATE `AreaTable_vanilla` SET name_loc1 = "진말로의 신전" WHERE id = 1223;
UPDATE `AreaTable_vanilla` SET name_loc1 = "곰마루" WHERE id = 1224;
UPDATE `AreaTable_vanilla` SET name_loc1 = "우르솔란" WHERE id = 1225;
UPDATE `AreaTable_vanilla` SET name_loc1 = "아크코란의 신전" WHERE id = 1226;
UPDATE `AreaTable_vanilla` SET name_loc1 = "폭풍의 만" WHERE id = 1227;
UPDATE `AreaTable_vanilla` SET name_loc1 = "조각난 해안" WHERE id = 1228;
UPDATE `AreaTable_vanilla` SET name_loc1 = "엘다라의 탑" WHERE id = 1229;
UPDATE `AreaTable_vanilla` SET name_loc1 = "톱니 산호초" WHERE id = 1230;
UPDATE `AreaTable_vanilla` SET name_loc1 = "남녘마루 해안" WHERE id = 1231;
UPDATE `AreaTable_vanilla` SET name_loc1 = "레이븐크레스트 기념비" WHERE id = 1232;
UPDATE `AreaTable_vanilla` SET name_loc1 = "쓸쓸한 마루" WHERE id = 1233;
UPDATE `AreaTable_vanilla` SET name_loc1 = "멘나르 호수" WHERE id = 1234;
UPDATE `AreaTable_vanilla` SET name_loc1 = "섀도송 제단" WHERE id = 1235;
UPDATE `AreaTable_vanilla` SET name_loc1 = "할다르 야영지" WHERE id = 1236;
UPDATE `AreaTable_vanilla` SET name_loc1 = "발로르모크" WHERE id = 1237;
UPDATE `AreaTable_vanilla` SET name_loc1 = "버려진 착륙장" WHERE id = 1256;
UPDATE `AreaTable_vanilla` SET name_loc1 = "돌발톱 토굴길" WHERE id = 1276;
UPDATE `AreaTable_vanilla` SET name_loc1 = "돌발톱 토굴길" WHERE id = 1277;
UPDATE `AreaTable_vanilla` SET name_loc1 = "바위어금니 농장" WHERE id = 1296;
UPDATE `AreaTable_vanilla` SET name_loc1 = "톱니멧돼지 농장" WHERE id = 1297;
UPDATE `AreaTable_vanilla` SET name_loc1 = "가시덩굴 구릉" WHERE id = 1316;
UPDATE `AreaTable_vanilla` SET name_loc1 = "해적단 소굴" WHERE id = 1336;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Uldaman" WHERE id = 1337;
UPDATE `AreaTable_vanilla` SET name_loc1 = "로다미어 호수" WHERE id = 1338;
UPDATE `AreaTable_vanilla` SET name_loc1 = "로다미어 호수" WHERE id = 1339;
UPDATE `AreaTable_vanilla` SET name_loc1 = "갤로우 삼거리" WHERE id = 1357;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Silithus" WHERE id = 1377;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Emerald Forest" WHERE id = 1397;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Sunken Temple" WHERE id = 1417;
UPDATE `AreaTable_vanilla` SET name_loc1 = "우레망치 요새" WHERE id = 1437;
UPDATE `AreaTable_vanilla` SET name_loc1 = "네더가드 요새" WHERE id = 1438;
UPDATE `AreaTable_vanilla` SET name_loc1 = "우레망치 주둔지" WHERE id = 1439;
UPDATE `AreaTable_vanilla` SET name_loc1 = "뱀의 보금자리" WHERE id = 1440;
UPDATE `AreaTable_vanilla` SET name_loc1 = "폭풍의 제단" WHERE id = 1441;
UPDATE `AreaTable_vanilla` SET name_loc1 = "불망루 마루" WHERE id = 1442;
UPDATE `AreaTable_vanilla` SET name_loc1 = "잿가루 채석장" WHERE id = 1443;
UPDATE `AreaTable_vanilla` SET name_loc1 = "잿더미 바다" WHERE id = 1444;
UPDATE `AreaTable_vanilla` SET name_loc1 = "검은바위 산" WHERE id = 1445;
UPDATE `AreaTable_vanilla` SET name_loc1 = "토륨 조합 거점" WHERE id = 1446;
UPDATE `AreaTable_vanilla` SET name_loc1 = "요새 무기고" WHERE id = 1457;
UPDATE `AreaTable_vanilla` SET name_loc1 = "The Temple of Atal'Hakkar" WHERE id = 1477;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Undercity" WHERE id = 1497;
UPDATE `AreaTable_vanilla` SET name_loc1 = "울다만" WHERE id = 1517;
UPDATE `AreaTable_vanilla` SET name_loc1 = "죽음의 폐광" WHERE id = 1518;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Stormwind City" WHERE id = 1519;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Ironforge" WHERE id = 1537;
UPDATE `AreaTable_vanilla` SET name_loc1 = "갈래발굽 소굴" WHERE id = 1557;
UPDATE `AreaTable_vanilla` SET name_loc1 = "가시덤불 봉우리" WHERE id = 1577;
UPDATE `AreaTable_vanilla` SET name_loc1 = "폭풍 해안 남부" WHERE id = 1578;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Unused The Deadmines 002" WHERE id = 1579;
UPDATE `AreaTable_vanilla` SET name_loc1 = "철갑 동굴" WHERE id = 1580;
UPDATE `AreaTable_vanilla` SET name_loc1 = "The Deadmines" WHERE id = 1581;
UPDATE `AreaTable_vanilla` SET name_loc1 = "철갑 동굴" WHERE id = 1582;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Blackrock Spire" WHERE id = 1583;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Blackrock depths" WHERE id = 1584;
UPDATE `AreaTable_vanilla` SET name_loc1 = "랩터 서식지" WHERE id = 1597;
UPDATE `AreaTable_vanilla` SET name_loc1 = "그롤돔 농장" WHERE id = 1598;
UPDATE `AreaTable_vanilla` SET name_loc1 = "몰샨 주둔지" WHERE id = 1599;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Honor's Stand UNUSED" WHERE id = 1600;
UPDATE `AreaTable_vanilla` SET name_loc1 = "검은가시 마루" WHERE id = 1601;
UPDATE `AreaTable_vanilla` SET name_loc1 = "가시덩굴 벌판" WHERE id = 1602;
UPDATE `AreaTable_vanilla` SET name_loc1 = "아가마고르" WHERE id = 1603;
UPDATE `AreaTable_vanilla` SET name_loc1 = "영웅의 계곡" WHERE id = 1617;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Orgrimmar" WHERE id = 1637;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Thunder Bluff" WHERE id = 1638;
UPDATE `AreaTable_vanilla` SET name_loc1 = "장로의 봉우리" WHERE id = 1639;
UPDATE `AreaTable_vanilla` SET name_loc1 = "정기의 봉우리" WHERE id = 1640;
UPDATE `AreaTable_vanilla` SET name_loc1 = "수렵의 봉우리" WHERE id = 1641;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Darnassus" WHERE id = 1657;
UPDATE `AreaTable_vanilla` SET name_loc1 = "세나리온 자치령" WHERE id = 1658;
UPDATE `AreaTable_vanilla` SET name_loc1 = "장인의 정원" WHERE id = 1659;
UPDATE `AreaTable_vanilla` SET name_loc1 = "전사의 정원" WHERE id = 1660;
UPDATE `AreaTable_vanilla` SET name_loc1 = "신전 정원" WHERE id = 1661;
UPDATE `AreaTable_vanilla` SET name_loc1 = "상인의 정원" WHERE id = 1662;
UPDATE `AreaTable_vanilla` SET name_loc1 = "가빈 절벽" WHERE id = 1677;
UPDATE `AreaTable_vanilla` SET name_loc1 = "소페라 절벽" WHERE id = 1678;
UPDATE `AreaTable_vanilla` SET name_loc1 = "코란의 비수" WHERE id = 1679;
UPDATE `AreaTable_vanilla` SET name_loc1 = "마루터기" WHERE id = 1680;
UPDATE `AreaTable_vanilla` SET name_loc1 = "물안개 호숫가" WHERE id = 1681;
UPDATE `AreaTable_vanilla` SET name_loc1 = "단드레드 장원" WHERE id = 1682;
UPDATE `AreaTable_vanilla` SET name_loc1 = "침묵의 동굴" WHERE id = 1683;
UPDATE `AreaTable_vanilla` SET name_loc1 = "서리바람 거점" WHERE id = 1684;
UPDATE `AreaTable_vanilla` SET name_loc1 = "랩터 서식지" WHERE id = 1697;
UPDATE `AreaTable_vanilla` SET name_loc1 = "가시덩굴 벌판" WHERE id = 1698;
UPDATE `AreaTable_vanilla` SET name_loc1 = "가시덩굴 언덕" WHERE id = 1699;
UPDATE `AreaTable_vanilla` SET name_loc1 = "아가마고르" WHERE id = 1700;
UPDATE `AreaTable_vanilla` SET name_loc1 = "검은가시 마루" WHERE id = 1701;
UPDATE `AreaTable_vanilla` SET name_loc1 = "명예의 감시탑" WHERE id = 1702;
UPDATE `AreaTable_vanilla` SET name_loc1 = "몰샨의 망루" WHERE id = 1703;
UPDATE `AreaTable_vanilla` SET name_loc1 = "그롤돔 농장" WHERE id = 1704;
UPDATE `AreaTable_vanilla` SET name_loc1 = "가시덩굴 우리" WHERE id = 1717;
UPDATE `AreaTable_vanilla` SET name_loc1 = "구름 승강장" WHERE id = 1718;
UPDATE `AreaTable_vanilla` SET name_loc1 = "안개계곡 골짜기" WHERE id = 1737;
UPDATE `AreaTable_vanilla` SET name_loc1 = "네크마니 수원지" WHERE id = 1738;
UPDATE `AreaTable_vanilla` SET name_loc1 = "붉은해적단 주둔지" WHERE id = 1739;
UPDATE `AreaTable_vanilla` SET name_loc1 = "투자개발회사 탐사기지" WHERE id = 1740;
UPDATE `AreaTable_vanilla` SET name_loc1 = "구루바시 투기장" WHERE id = 1741;
UPDATE `AreaTable_vanilla` SET name_loc1 = "정기의 동굴" WHERE id = 1742;
UPDATE `AreaTable_vanilla` SET name_loc1 = "크림슨 베일호" WHERE id = 1757;
UPDATE `AreaTable_vanilla` SET name_loc1 = "립타이드호" WHERE id = 1758;
UPDATE `AreaTable_vanilla` SET name_loc1 = "담셀의 행운호" WHERE id = 1759;
UPDATE `AreaTable_vanilla` SET name_loc1 = "투자개발회사 기계조작실" WHERE id = 1760;
UPDATE `AreaTable_vanilla` SET name_loc1 = "마른가지 마을" WHERE id = 1761;
UPDATE `AreaTable_vanilla` SET name_loc1 = "악령발 마을" WHERE id = 1762;
UPDATE `AreaTable_vanilla` SET name_loc1 = "자에데나르" WHERE id = 1763;
UPDATE `AreaTable_vanilla` SET name_loc1 = "피멍울 강" WHERE id = 1764;
UPDATE `AreaTable_vanilla` SET name_loc1 = "피멍울 폭포" WHERE id = 1765;
UPDATE `AreaTable_vanilla` SET name_loc1 = "불벼락 골짜기" WHERE id = 1766;
UPDATE `AreaTable_vanilla` SET name_loc1 = "강철나무 숲" WHERE id = 1767;
UPDATE `AreaTable_vanilla` SET name_loc1 = "강철나무 굴" WHERE id = 1768;
UPDATE `AreaTable_vanilla` SET name_loc1 = "나무구렁 요새" WHERE id = 1769;
UPDATE `AreaTable_vanilla` SET name_loc1 = "어둠의 요새" WHERE id = 1770;
UPDATE `AreaTable_vanilla` SET name_loc1 = "책략가의 사원" WHERE id = 1771;
UPDATE `AreaTable_vanilla` SET name_loc1 = "이타리우스의 동굴" WHERE id = 1777;
UPDATE `AreaTable_vanilla` SET name_loc1 = "슬픔의 그늘" WHERE id = 1778;
UPDATE `AreaTable_vanilla` SET name_loc1 = "드레닐두르 마을" WHERE id = 1779;
UPDATE `AreaTable_vanilla` SET name_loc1 = "부러진창 교차로" WHERE id = 1780;
UPDATE `AreaTable_vanilla` SET name_loc1 = "진흙늪" WHERE id = 1797;
UPDATE `AreaTable_vanilla` SET name_loc1 = "변화의 늪" WHERE id = 1798;
UPDATE `AreaTable_vanilla` SET name_loc1 = "진흙탕 동굴" WHERE id = 1817;
UPDATE `AreaTable_vanilla` SET name_loc1 = "마른나무껍질 동굴" WHERE id = 1837;
UPDATE `AreaTable_vanilla` SET name_loc1 = "소라딘의 성벽" WHERE id = 1857;
UPDATE `AreaTable_vanilla` SET name_loc1 = "돌주먹 언덕" WHERE id = 1858;
UPDATE `AreaTable_vanilla` SET name_loc1 = "송곳니 골짜기" WHERE id = 1877;
UPDATE `AreaTable_vanilla` SET name_loc1 = "먼지받이" WHERE id = 1878;
UPDATE `AreaTable_vanilla` SET name_loc1 = "신기루 벌판" WHERE id = 1879;
UPDATE `AreaTable_vanilla` SET name_loc1 = "페더비어드의 오두막" WHERE id = 1880;
UPDATE `AreaTable_vanilla` SET name_loc1 = "신디거의 야영지" WHERE id = 1881;
UPDATE `AreaTable_vanilla` SET name_loc1 = "역병안개 협곡" WHERE id = 1882;
UPDATE `AreaTable_vanilla` SET name_loc1 = "돌개바람 호수" WHERE id = 1883;
UPDATE `AreaTable_vanilla` SET name_loc1 = "아골와타" WHERE id = 1884;
UPDATE `AreaTable_vanilla` SET name_loc1 = "히리와타" WHERE id = 1885;
UPDATE `AreaTable_vanilla` SET name_loc1 = "굼벵이 폐허" WHERE id = 1886;
UPDATE `AreaTable_vanilla` SET name_loc1 = "보겐의 절벽" WHERE id = 1887;
UPDATE `AreaTable_vanilla` SET name_loc1 = "창조주의 정원" WHERE id = 1897;
UPDATE `AreaTable_vanilla` SET name_loc1 = "먼지바람 협곡" WHERE id = 1898;
UPDATE `AreaTable_vanilla` SET name_loc1 = "샤올와타" WHERE id = 1917;
UPDATE `AreaTable_vanilla` SET name_loc1 = "해그늘 폐허" WHERE id = 1937;
UPDATE `AreaTable_vanilla` SET name_loc1 = "무너진 기둥" WHERE id = 1938;
UPDATE `AreaTable_vanilla` SET name_loc1 = "끝없는 사막" WHERE id = 1939;
UPDATE `AreaTable_vanilla` SET name_loc1 = "거친파도 해안" WHERE id = 1940;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Caverns of Time" WHERE id = 1941;
UPDATE `AreaTable_vanilla` SET name_loc1 = "늪지대" WHERE id = 1942;
UPDATE `AreaTable_vanilla` SET name_loc1 = "강철바위 고원" WHERE id = 1943;
UPDATE `AreaTable_vanilla` SET name_loc1 = "검은재 동굴" WHERE id = 1957;
UPDATE `AreaTable_vanilla` SET name_loc1 = "무두장이 야영지" WHERE id = 1958;
UPDATE `AreaTable_vanilla` SET name_loc1 = "먼지불 골짜기" WHERE id = 1959;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Zul'Gurub" WHERE id = 1977;
UPDATE `AreaTable_vanilla` SET name_loc1 = "안개갈대 주둔지" WHERE id = 1978;
UPDATE `AreaTable_vanilla` SET name_loc1 = "피멍울 초소" WHERE id = 1997;
UPDATE `AreaTable_vanilla` SET name_loc1 = "갈퀴가지 숲" WHERE id = 1998;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Stratholme" WHERE id = 2017;
UPDATE `AreaTable_vanilla` SET name_loc1 = "UNUSEDShadowfang Keep 003" WHERE id = 2037;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Scholomance" WHERE id = 2057;
UPDATE `AreaTable_vanilla` SET name_loc1 = "황혼의 계곡" WHERE id = 2077;
UPDATE `AreaTable_vanilla` SET name_loc1 = "황혼의 해안" WHERE id = 2078;
UPDATE `AreaTable_vanilla` SET name_loc1 = "알카즈 섬" WHERE id = 2079;
UPDATE `AreaTable_vanilla` SET name_loc1 = "먹구름 봉우리" WHERE id = 2097;
UPDATE `AreaTable_vanilla` SET name_loc1 = "새벽숲 지하묘지" WHERE id = 2098;
UPDATE `AreaTable_vanilla` SET name_loc1 = "돌망루 요새" WHERE id = 2099;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Maraudon" WHERE id = 2100;
UPDATE `AreaTable_vanilla` SET name_loc1 = "스타우트라거 여관" WHERE id = 2101;
UPDATE `AreaTable_vanilla` SET name_loc1 = "썬더브루 양조장" WHERE id = 2102;
UPDATE `AreaTable_vanilla` SET name_loc1 = "메네실 요새" WHERE id = 2103;
UPDATE `AreaTable_vanilla` SET name_loc1 = "깊은바다 선술집" WHERE id = 2104;
UPDATE `AreaTable_vanilla` SET name_loc1 = "암흑의 무덤" WHERE id = 2117;
UPDATE `AreaTable_vanilla` SET name_loc1 = "브릴 마을회관" WHERE id = 2118;
UPDATE `AreaTable_vanilla` SET name_loc1 = "갤로우 선술집" WHERE id = 2119;
UPDATE `AreaTable_vanilla` SET name_loc1 = "예언의 웅덩이" WHERE id = 2137;
UPDATE `AreaTable_vanilla` SET name_loc1 = "공포의 안개굴" WHERE id = 2138;
UPDATE `AreaTable_vanilla` SET name_loc1 = "바엘던 요새" WHERE id = 2157;
UPDATE `AreaTable_vanilla` SET name_loc1 = "엠버스트라이프의 굴" WHERE id = 2158;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Onyxia's Lair" WHERE id = 2159;
UPDATE `AreaTable_vanilla` SET name_loc1 = "칼바람 광산" WHERE id = 2160;
UPDATE `AreaTable_vanilla` SET name_loc1 = "롤랜드 광산" WHERE id = 2161;
UPDATE `AreaTable_vanilla` SET name_loc1 = "투기장" WHERE id = 2177;
UPDATE `AreaTable_vanilla` SET name_loc1 = "예언의 웅덩이" WHERE id = 2197;
UPDATE `AreaTable_vanilla` SET name_loc1 = "동트는 협곡" WHERE id = 2198;
UPDATE `AreaTable_vanilla` SET name_loc1 = "부러진창 마을" WHERE id = 2217;
UPDATE `AreaTable_vanilla` SET name_loc1 = "백사장 야영지" WHERE id = 2237;
UPDATE `AreaTable_vanilla` SET name_loc1 = "고르니아" WHERE id = 2238;
UPDATE `AreaTable_vanilla` SET name_loc1 = "제인의 눈동자 분화구" WHERE id = 2239;
UPDATE `AreaTable_vanilla` SET name_loc1 = "신기루 경주장" WHERE id = 2240;
UPDATE `AreaTable_vanilla` SET name_loc1 = "눈호랑이 바위" WHERE id = 2241;
UPDATE `AreaTable_vanilla` SET name_loc1 = "숨겨진 숲" WHERE id = 2242;
UPDATE `AreaTable_vanilla` SET name_loc1 = "나무구렁 야영지" WHERE id = 2243;
UPDATE `AreaTable_vanilla` SET name_loc1 = "눈사태일족 마을" WHERE id = 2244;
UPDATE `AreaTable_vanilla` SET name_loc1 = "마즈소릴" WHERE id = 2245;
UPDATE `AreaTable_vanilla` SET name_loc1 = "얼음불꽃 온천" WHERE id = 2246;
UPDATE `AreaTable_vanilla` SET name_loc1 = "얼음엉겅퀴 언덕" WHERE id = 2247;
UPDATE `AreaTable_vanilla` SET name_loc1 = "던 만다르" WHERE id = 2248;
UPDATE `AreaTable_vanilla` SET name_loc1 = "서리속삭임 골짜기" WHERE id = 2249;
UPDATE `AreaTable_vanilla` SET name_loc1 = "올빼미날개 숲" WHERE id = 2250;
UPDATE `AreaTable_vanilla` SET name_loc1 = "켈테릴 호수" WHERE id = 2251;
UPDATE `AreaTable_vanilla` SET name_loc1 = "켈테릴의 폐허" WHERE id = 2252;
UPDATE `AreaTable_vanilla` SET name_loc1 = "별똥별 마을" WHERE id = 2253;
UPDATE `AreaTable_vanilla` SET name_loc1 = "반탈로우 지하굴" WHERE id = 2254;
UPDATE `AreaTable_vanilla` SET name_loc1 = "눈망루 마을" WHERE id = 2255;
UPDATE `AreaTable_vanilla` SET name_loc1 = "검은속삭임 협곡" WHERE id = 2256;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Deeprun Tram" WHERE id = 2257;
UPDATE `AreaTable_vanilla` SET name_loc1 = "곰팡이 계곡" WHERE id = 2258;
UPDATE `AreaTable_vanilla` SET name_loc1 = "마리스 농장" WHERE id = 2259;
UPDATE `AreaTable_vanilla` SET name_loc1 = "마리스 농장" WHERE id = 2260;
UPDATE `AreaTable_vanilla` SET name_loc1 = "지하 납골당" WHERE id = 2261;
UPDATE `AreaTable_vanilla` SET name_loc1 = "다로우샤이어" WHERE id = 2262;
UPDATE `AreaTable_vanilla` SET name_loc1 = "산마루 경비탑" WHERE id = 2263;
UPDATE `AreaTable_vanilla` SET name_loc1 = "코린 삼거리" WHERE id = 2264;
UPDATE `AreaTable_vanilla` SET name_loc1 = "붉은십자군 주둔지" WHERE id = 2265;
UPDATE `AreaTable_vanilla` SET name_loc1 = "티르의 손 수도원" WHERE id = 2266;
UPDATE `AreaTable_vanilla` SET name_loc1 = "붉은십자군 대성당" WHERE id = 2267;
UPDATE `AreaTable_vanilla` SET name_loc1 = "희망의 빛 예배당" WHERE id = 2268;
UPDATE `AreaTable_vanilla` SET name_loc1 = "브라우만 밀농장" WHERE id = 2269;
UPDATE `AreaTable_vanilla` SET name_loc1 = "맹독의 숲" WHERE id = 2270;
UPDATE `AreaTable_vanilla` SET name_loc1 = "동부방벽 경비탑" WHERE id = 2271;
UPDATE `AreaTable_vanilla` SET name_loc1 = "노스데일" WHERE id = 2272;
UPDATE `AreaTable_vanilla` SET name_loc1 = "줄마샤르" WHERE id = 2273;
UPDATE `AreaTable_vanilla` SET name_loc1 = "마즈라알로" WHERE id = 2274;
UPDATE `AreaTable_vanilla` SET name_loc1 = "북부관문 경비탑" WHERE id = 2275;
UPDATE `AreaTable_vanilla` SET name_loc1 = "쿠엘리시엔 오두막" WHERE id = 2276;
UPDATE `AreaTable_vanilla` SET name_loc1 = "역병의 숲" WHERE id = 2277;
UPDATE `AreaTable_vanilla` SET name_loc1 = "스컬지 요새" WHERE id = 2278;
UPDATE `AreaTable_vanilla` SET name_loc1 = "스트라솔름" WHERE id = 2279;
UPDATE `AreaTable_vanilla` SET name_loc1 = "UNUSED Stratholme" WHERE id = 2280;
UPDATE `AreaTable_vanilla` SET name_loc1 = "다로미어 호수" WHERE id = 2297;
UPDATE `AreaTable_vanilla` SET name_loc1 = "카엘 다로우" WHERE id = 2298;
UPDATE `AreaTable_vanilla` SET name_loc1 = "다로미어 호수" WHERE id = 2299;
UPDATE `AreaTable_vanilla` SET name_loc1 = "시간의 동굴" WHERE id = 2300;
UPDATE `AreaTable_vanilla` SET name_loc1 = "엉겅퀴 마을" WHERE id = 2301;
UPDATE `AreaTable_vanilla` SET name_loc1 = "먼지 수렁" WHERE id = 2302;
UPDATE `AreaTable_vanilla` SET name_loc1 = "갈기바람 협곡" WHERE id = 2303;
UPDATE `AreaTable_vanilla` SET name_loc1 = "남쪽 바다" WHERE id = 2317;
UPDATE `AreaTable_vanilla` SET name_loc1 = "대해" WHERE id = 2318;
UPDATE `AreaTable_vanilla` SET name_loc1 = "대해" WHERE id = 2319;
UPDATE `AreaTable_vanilla` SET name_loc1 = "대해" WHERE id = 2320;
UPDATE `AreaTable_vanilla` SET name_loc1 = "대해" WHERE id = 2321;
UPDATE `AreaTable_vanilla` SET name_loc1 = "장막의 바다" WHERE id = 2322;
UPDATE `AreaTable_vanilla` SET name_loc1 = "장막의 바다" WHERE id = 2323;
UPDATE `AreaTable_vanilla` SET name_loc1 = "장막의 바다" WHERE id = 2324;
UPDATE `AreaTable_vanilla` SET name_loc1 = "장막의 바다" WHERE id = 2325;
UPDATE `AreaTable_vanilla` SET name_loc1 = "장막의 바다" WHERE id = 2326;
UPDATE `AreaTable_vanilla` SET name_loc1 = "칼바람 언덕 병영" WHERE id = 2337;
UPDATE `AreaTable_vanilla` SET name_loc1 = "남쪽 바다" WHERE id = 2338;
UPDATE `AreaTable_vanilla` SET name_loc1 = "대해" WHERE id = 2339;
UPDATE `AreaTable_vanilla` SET name_loc1 = "붉은송곳니 야영지" WHERE id = 2357;
UPDATE `AreaTable_vanilla` SET name_loc1 = "숲의 노래" WHERE id = 2358;
UPDATE `AreaTable_vanilla` SET name_loc1 = "푸른발 마을" WHERE id = 2359;
UPDATE `AreaTable_vanilla` SET name_loc1 = "은빛날개 전초기지" WHERE id = 2360;
UPDATE `AreaTable_vanilla` SET name_loc1 = "나이트헤이븐" WHERE id = 2361;
UPDATE `AreaTable_vanilla` SET name_loc1 = "레물로스의 제단" WHERE id = 2362;
UPDATE `AreaTable_vanilla` SET name_loc1 = "스톰레이지 지하굴" WHERE id = 2363;
UPDATE `AreaTable_vanilla` SET name_loc1 = "대해" WHERE id = 2364;
UPDATE `AreaTable_vanilla` SET name_loc1 = "대해" WHERE id = 2365;
UPDATE `AreaTable_vanilla` SET name_loc1 = "The Black Morass" WHERE id = 2366;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Old Hillsbrad Foothills" WHERE id = 2367;
UPDATE `AreaTable_vanilla` SET name_loc1 = "타렌 밀농장" WHERE id = 2368;
UPDATE `AreaTable_vanilla` SET name_loc1 = "사우스쇼어" WHERE id = 2369;
UPDATE `AreaTable_vanilla` SET name_loc1 = "던홀드 요새" WHERE id = 2370;
UPDATE `AreaTable_vanilla` SET name_loc1 = "던 가록" WHERE id = 2371;
UPDATE `AreaTable_vanilla` SET name_loc1 = "힐스브래드 농장" WHERE id = 2372;
UPDATE `AreaTable_vanilla` SET name_loc1 = "동부 해안" WHERE id = 2373;
UPDATE `AreaTable_vanilla` SET name_loc1 = "네산더 농장" WHERE id = 2374;
UPDATE `AreaTable_vanilla` SET name_loc1 = "다로우 언덕" WHERE id = 2375;
UPDATE `AreaTable_vanilla` SET name_loc1 = "남부 경비탑" WHERE id = 2376;
UPDATE `AreaTable_vanilla` SET name_loc1 = "소라딘의 성벽" WHERE id = 2377;
UPDATE `AreaTable_vanilla` SET name_loc1 = "서부 해안" WHERE id = 2378;
UPDATE `AreaTable_vanilla` SET name_loc1 = "청금석 광산" WHERE id = 2379;
UPDATE `AreaTable_vanilla` SET name_loc1 = "대해" WHERE id = 2397;
UPDATE `AreaTable_vanilla` SET name_loc1 = "대해" WHERE id = 2398;
UPDATE `AreaTable_vanilla` SET name_loc1 = "대해" WHERE id = 2399;
UPDATE `AreaTable_vanilla` SET name_loc1 = "성난 바다" WHERE id = 2400;
UPDATE `AreaTable_vanilla` SET name_loc1 = "성난 바다" WHERE id = 2401;
UPDATE `AreaTable_vanilla` SET name_loc1 = "성난 바다" WHERE id = 2402;
UPDATE `AreaTable_vanilla` SET name_loc1 = "성난 바다" WHERE id = 2403;
UPDATE `AreaTable_vanilla` SET name_loc1 = "테드리스 아란" WHERE id = 2404;
UPDATE `AreaTable_vanilla` SET name_loc1 = "에텔 레소르" WHERE id = 2405;
UPDATE `AreaTable_vanilla` SET name_loc1 = "라나즈자르 섬" WHERE id = 2406;
UPDATE `AreaTable_vanilla` SET name_loc1 = "코르메크의 오두막" WHERE id = 2407;
UPDATE `AreaTable_vanilla` SET name_loc1 = "그늘수렵 마을" WHERE id = 2408;
UPDATE `AreaTable_vanilla` SET name_loc1 = "검은바위 고개" WHERE id = 2417;
UPDATE `AreaTable_vanilla` SET name_loc1 = "모건의 망루" WHERE id = 2418;
UPDATE `AreaTable_vanilla` SET name_loc1 = "뱀갈퀴 바위굴" WHERE id = 2419;
UPDATE `AreaTable_vanilla` SET name_loc1 = "공포의 날개 골짜기" WHERE id = 2420;
UPDATE `AreaTable_vanilla` SET name_loc1 = "드라코다르" WHERE id = 2421;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Ragefire Chasm" WHERE id = 2437;
UPDATE `AreaTable_vanilla` SET name_loc1 = "별빛노래 숲" WHERE id = 2457;
UPDATE `AreaTable_vanilla` SET name_loc1 = "장막의 바다" WHERE id = 2477;
UPDATE `AreaTable_vanilla` SET name_loc1 = "모를로스아란" WHERE id = 2478;
UPDATE `AreaTable_vanilla` SET name_loc1 = "에메랄드 성소" WHERE id = 2479;
UPDATE `AreaTable_vanilla` SET name_loc1 = "비취불꽃 숲" WHERE id = 2480;
UPDATE `AreaTable_vanilla` SET name_loc1 = "콘스텔라스 폐허" WHERE id = 2481;
UPDATE `AreaTable_vanilla` SET name_loc1 = "시련의 산마루" WHERE id = 2497;
UPDATE `AreaTable_vanilla` SET name_loc1 = "파멸자의 봉우리" WHERE id = 2517;
UPDATE `AreaTable_vanilla` SET name_loc1 = "라리스 정자" WHERE id = 2518;
UPDATE `AreaTable_vanilla` SET name_loc1 = "덩굴발 언덕" WHERE id = 2519;
UPDATE `AreaTable_vanilla` SET name_loc1 = "덩굴발일족 소굴" WHERE id = 2520;
UPDATE `AreaTable_vanilla` SET name_loc1 = "베르단티스 강" WHERE id = 2521;
UPDATE `AreaTable_vanilla` SET name_loc1 = "이실디엔 폐허" WHERE id = 2522;
UPDATE `AreaTable_vanilla` SET name_loc1 = "그림토템 초소" WHERE id = 2537;
UPDATE `AreaTable_vanilla` SET name_loc1 = "아파라제 야영지" WHERE id = 2538;
UPDATE `AreaTable_vanilla` SET name_loc1 = "말라카진" WHERE id = 2539;
UPDATE `AreaTable_vanilla` SET name_loc1 = "구릉바위 협곡" WHERE id = 2540;
UPDATE `AreaTable_vanilla` SET name_loc1 = "시쉬르 협곡" WHERE id = 2541;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Dire Maul" WHERE id = 2557;
UPDATE `AreaTable_vanilla` SET name_loc1 = "죽음의 협곡" WHERE id = 2558;
UPDATE `AreaTable_vanilla` SET name_loc1 = "다이아몬드 강" WHERE id = 2559;
UPDATE `AreaTable_vanilla` SET name_loc1 = "아리덴의 야영지" WHERE id = 2560;
UPDATE `AreaTable_vanilla` SET name_loc1 = "악의 소굴" WHERE id = 2561;
UPDATE `AreaTable_vanilla` SET name_loc1 = "카라잔" WHERE id = 2562;
UPDATE `AreaTable_vanilla` SET name_loc1 = "모건의 터" WHERE id = 2563;
UPDATE `AreaTable_vanilla` SET name_loc1 = "혈투의 전장" WHERE id = 2577;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Alterac Valley" WHERE id = 2597;
UPDATE `AreaTable_vanilla` SET name_loc1 = "스크래블스크류의 야영지" WHERE id = 2617;
UPDATE `AreaTable_vanilla` SET name_loc1 = "비취불꽃 비탈" WHERE id = 2618;
UPDATE `AreaTable_vanilla` SET name_loc1 = "톤드로릴 강" WHERE id = 2619;
UPDATE `AreaTable_vanilla` SET name_loc1 = "톤드로릴 강" WHERE id = 2620;
UPDATE `AreaTable_vanilla` SET name_loc1 = "메렐다르 호수" WHERE id = 2621;
UPDATE `AreaTable_vanilla` SET name_loc1 = "전염의 흉터" WHERE id = 2622;
UPDATE `AreaTable_vanilla` SET name_loc1 = "오염의 흉터" WHERE id = 2623;
UPDATE `AreaTable_vanilla` SET name_loc1 = "검은나무 호수" WHERE id = 2624;
UPDATE `AreaTable_vanilla` SET name_loc1 = "동부방벽 관문" WHERE id = 2625;
UPDATE `AreaTable_vanilla` SET name_loc1 = "공포의 거미굴" WHERE id = 2626;
UPDATE `AreaTable_vanilla` SET name_loc1 = "테러데일" WHERE id = 2627;
UPDATE `AreaTable_vanilla` SET name_loc1 = "카르가시아 요새" WHERE id = 2637;
UPDATE `AreaTable_vanilla` SET name_loc1 = "뼈의 골짜기" WHERE id = 2657;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Blackwing Lair" WHERE id = 2677;
UPDATE `AreaTable_vanilla` SET name_loc1 = "사자의 길" WHERE id = 2697;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Molten Core" WHERE id = 2717;
UPDATE `AreaTable_vanilla` SET name_loc1 = "스카라베 성벽" WHERE id = 2737;
UPDATE `AreaTable_vanilla` SET name_loc1 = "마파람 마을" WHERE id = 2738;
UPDATE `AreaTable_vanilla` SET name_loc1 = "황혼의 망치단 주둔지" WHERE id = 2739;
UPDATE `AreaTable_vanilla` SET name_loc1 = "수정 골짜기" WHERE id = 2740;
UPDATE `AreaTable_vanilla` SET name_loc1 = "스카라베 제단" WHERE id = 2741;
UPDATE `AreaTable_vanilla` SET name_loc1 = "하이브아쉬" WHERE id = 2742;
UPDATE `AreaTable_vanilla` SET name_loc1 = "하이브조라" WHERE id = 2743;
UPDATE `AreaTable_vanilla` SET name_loc1 = "하이브레갈" WHERE id = 2744;
UPDATE `AreaTable_vanilla` SET name_loc1 = "전사한 용사의 제단" WHERE id = 2757;
UPDATE `AreaTable_vanilla` SET name_loc1 = "알터랙 계곡" WHERE id = 2777;
UPDATE `AreaTable_vanilla` SET name_loc1 = "검은심연의 나락" WHERE id = 2797;
UPDATE `AreaTable_vanilla` SET name_loc1 = "*** 야외 던전 ***" WHERE id = 2817;
UPDATE `AreaTable_vanilla` SET name_loc1 = "지배자의 지하실" WHERE id = 2837;
UPDATE `AreaTable_vanilla` SET name_loc1 = "돌다지 고개" WHERE id = 2838;
UPDATE `AreaTable_vanilla` SET name_loc1 = "알터랙 계곡" WHERE id = 2839;
UPDATE `AreaTable_vanilla` SET name_loc1 = "싸움 우리" WHERE id = 2857;
UPDATE `AreaTable_vanilla` SET name_loc1 = "땅덩어리 시험용" WHERE id = 2877;
UPDATE `AreaTable_vanilla` SET name_loc1 = "조람가르 전초기지" WHERE id = 2897;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Hall of Legends" WHERE id = 2917;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Champions' Hall" WHERE id = 2918;
UPDATE `AreaTable_vanilla` SET name_loc1 = "그로쉬고크 주둔지" WHERE id = 2937;
UPDATE `AreaTable_vanilla` SET name_loc1 = "수면의 협곡" WHERE id = 2938;
UPDATE `AreaTable_vanilla` SET name_loc1 = "깊은무쇠 광산" WHERE id = 2957;
UPDATE `AreaTable_vanilla` SET name_loc1 = "돌심장 전초기지" WHERE id = 2958;
UPDATE `AreaTable_vanilla` SET name_loc1 = "던 발다르" WHERE id = 2959;
UPDATE `AreaTable_vanilla` SET name_loc1 = "얼음날개 고개" WHERE id = 2960;
UPDATE `AreaTable_vanilla` SET name_loc1 = "서리늑대 마을" WHERE id = 2961;
UPDATE `AreaTable_vanilla` SET name_loc1 = "거점 보초탑" WHERE id = 2962;
UPDATE `AreaTable_vanilla` SET name_loc1 = "얼음이빨 광산" WHERE id = 2963;
UPDATE `AreaTable_vanilla` SET name_loc1 = "겨울도끼 요새" WHERE id = 2964;
UPDATE `AreaTable_vanilla` SET name_loc1 = "얼음피 주둔지" WHERE id = 2977;
UPDATE `AreaTable_vanilla` SET name_loc1 = "서리늑대 요새" WHERE id = 2978;
UPDATE `AreaTable_vanilla` SET name_loc1 = "톨크렌 농장" WHERE id = 2979;
UPDATE `AreaTable_vanilla` SET name_loc1 = "서리비수 고개" WHERE id = 3017;
UPDATE `AreaTable_vanilla` SET name_loc1 = "강철바위 야영지" WHERE id = 3037;
UPDATE `AreaTable_vanilla` SET name_loc1 = "위젤의 분화구" WHERE id = 3038;
UPDATE `AreaTable_vanilla` SET name_loc1 = "타혼다 폐허" WHERE id = 3039;
UPDATE `AreaTable_vanilla` SET name_loc1 = "투쟁의 벌판" WHERE id = 3057;
UPDATE `AreaTable_vanilla` SET name_loc1 = "얼음날개 동굴" WHERE id = 3058;
UPDATE `AreaTable_vanilla` SET name_loc1 = "용사의 안식처" WHERE id = 3077;
UPDATE `AreaTable_vanilla` SET name_loc1 = "벌레무리 기둥" WHERE id = 3097;
UPDATE `AreaTable_vanilla` SET name_loc1 = "황혼의 초소" WHERE id = 3098;
UPDATE `AreaTable_vanilla` SET name_loc1 = "황혼의 전초기지" WHERE id = 3099;
UPDATE `AreaTable_vanilla` SET name_loc1 = "파괴된 황혼의 야영지" WHERE id = 3100;
UPDATE `AreaTable_vanilla` SET name_loc1 = "샬자루의 둥지" WHERE id = 3117;
UPDATE `AreaTable_vanilla` SET name_loc1 = "탈렌드리스 초소" WHERE id = 3137;
UPDATE `AreaTable_vanilla` SET name_loc1 = "레스리스 성소" WHERE id = 3138;
UPDATE `AreaTable_vanilla` SET name_loc1 = "공포의 달빛 동굴" WHERE id = 3139;
UPDATE `AreaTable_vanilla` SET name_loc1 = "비늘수염 동굴" WHERE id = 3140;
UPDATE `AreaTable_vanilla` SET name_loc1 = "구릉바위 동굴" WHERE id = 3157;
UPDATE `AreaTable_vanilla` SET name_loc1 = "전쟁노래부족 노동기지" WHERE id = 3177;
UPDATE `AreaTable_vanilla` SET name_loc1 = "서리바람 야영지" WHERE id = 3197;
UPDATE `AreaTable_vanilla` SET name_loc1 = "검투장" WHERE id = 3217;
UPDATE `AreaTable_vanilla` SET name_loc1 = "검투장" WHERE id = 3237;
UPDATE `AreaTable_vanilla` SET name_loc1 = "그락카론드의 무덤" WHERE id = 3257;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Warsong Gulch" WHERE id = 3277;
UPDATE `AreaTable_vanilla` SET name_loc1 = "서리늑대 무덤" WHERE id = 3297;
UPDATE `AreaTable_vanilla` SET name_loc1 = "서리늑대 고개" WHERE id = 3298;
UPDATE `AreaTable_vanilla` SET name_loc1 = "던 발다르 고개" WHERE id = 3299;
UPDATE `AreaTable_vanilla` SET name_loc1 = "얼음피 무덤" WHERE id = 3300;
UPDATE `AreaTable_vanilla` SET name_loc1 = "눈사태 무덤" WHERE id = 3301;
UPDATE `AreaTable_vanilla` SET name_loc1 = "돌심장 무덤" WHERE id = 3302;
UPDATE `AreaTable_vanilla` SET name_loc1 = "스톰파이크 무덤" WHERE id = 3303;
UPDATE `AreaTable_vanilla` SET name_loc1 = "얼음날개 참호" WHERE id = 3304;
UPDATE `AreaTable_vanilla` SET name_loc1 = "돌심장 참호" WHERE id = 3305;
UPDATE `AreaTable_vanilla` SET name_loc1 = "자갈발 마루" WHERE id = 3306;
UPDATE `AreaTable_vanilla` SET name_loc1 = "레반터스크 마을" WHERE id = 3317;
UPDATE `AreaTable_vanilla` SET name_loc1 = "듀로탄 바위" WHERE id = 3318;
UPDATE `AreaTable_vanilla` SET name_loc1 = "은빛날개 숲" WHERE id = 3319;
UPDATE `AreaTable_vanilla` SET name_loc1 = "전쟁노래부족 벌목기지" WHERE id = 3320;
UPDATE `AreaTable_vanilla` SET name_loc1 = "은빛날개 요새" WHERE id = 3321;
UPDATE `AreaTable_vanilla` SET name_loc1 = "자갈발 동굴" WHERE id = 3337;
UPDATE `AreaTable_vanilla` SET name_loc1 = "장막의 틈" WHERE id = 3338;
UPDATE `AreaTable_vanilla` SET name_loc1 = "요잠바 섬" WHERE id = 3357;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Arathi Basin" WHERE id = 3358;
UPDATE `AreaTable_vanilla` SET name_loc1 = "증오의 또아리" WHERE id = 3377;
UPDATE `AreaTable_vanilla` SET name_loc1 = "히리크의 제단" WHERE id = 3378;
UPDATE `AreaTable_vanilla` SET name_loc1 = "샤드라자르" WHERE id = 3379;
UPDATE `AreaTable_vanilla` SET name_loc1 = "학카리 광장" WHERE id = 3380;
UPDATE `AreaTable_vanilla` SET name_loc1 = "시르밸라의 절벽" WHERE id = 3381;
UPDATE `AreaTable_vanilla` SET name_loc1 = "베데크 신전" WHERE id = 3382;
UPDATE `AreaTable_vanilla` SET name_loc1 = "혈화의 구덩이" WHERE id = 3383;
UPDATE `AreaTable_vanilla` SET name_loc1 = "혈신의 제단" WHERE id = 3384;
UPDATE `AreaTable_vanilla` SET name_loc1 = "잔자의 언덕" WHERE id = 3397;
UPDATE `AreaTable_vanilla` SET name_loc1 = "광란의 경계" WHERE id = 3398;
UPDATE `AreaTable_vanilla` SET name_loc1 = "트롤베인 전당" WHERE id = 3417;
UPDATE `AreaTable_vanilla` SET name_loc1 = "파멸의 전당" WHERE id = 3418;
UPDATE `AreaTable_vanilla` SET name_loc1 = "페이글의 낚시터" WHERE id = 3419;
UPDATE `AreaTable_vanilla` SET name_loc1 = "농장" WHERE id = 3420;
UPDATE `AreaTable_vanilla` SET name_loc1 = "대장간" WHERE id = 3421;
UPDATE `AreaTable_vanilla` SET name_loc1 = "제재소" WHERE id = 3422;
UPDATE `AreaTable_vanilla` SET name_loc1 = "금광" WHERE id = 3423;
UPDATE `AreaTable_vanilla` SET name_loc1 = "마구간" WHERE id = 3424;
UPDATE `AreaTable_vanilla` SET name_loc1 = "세나리온 요새" WHERE id = 3425;
UPDATE `AreaTable_vanilla` SET name_loc1 = "스테그헬름 거점" WHERE id = 3426;
UPDATE `AreaTable_vanilla` SET name_loc1 = "브론즈비어드 야영지" WHERE id = 3427;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Ahn'Qiraj" WHERE id = 3428;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Ruins of Ahn'Qiraj" WHERE id = 3429;
UPDATE `AreaTable_vanilla` SET name_loc1 = "황혼의 숲" WHERE id = 3446;
UPDATE `AreaTable_vanilla` SET name_loc1 = "오르텔의 은신처" WHERE id = 3447;
UPDATE `AreaTable_vanilla` SET name_loc1 = "스카라베 정원" WHERE id = 3448;
UPDATE `AreaTable_vanilla` SET name_loc1 = "장군의 정원" WHERE id = 3449;
UPDATE `AreaTable_vanilla` SET name_loc1 = "안퀴라즈 저장실" WHERE id = 3450;
UPDATE `AreaTable_vanilla` SET name_loc1 = "안퀴라즈 부화장" WHERE id = 3451;
UPDATE `AreaTable_vanilla` SET name_loc1 = "안퀴라즈 둥지" WHERE id = 3452;
UPDATE `AreaTable_vanilla` SET name_loc1 = "감시자의 정원" WHERE id = 3453;
UPDATE `AreaTable_vanilla` SET name_loc1 = "안퀴라즈 폐허" WHERE id = 3454;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Naxxramas" WHERE id = 3456;
UPDATE `AreaTable_vanilla` SET name_loc1 = "City" WHERE id = 3459;
UPDATE `AreaTable_vanilla` SET name_loc1 = "Gates of Ahn'Qiraj" WHERE id = 3478;
UPDATE `AreaTable_vanilla` SET name_loc1 = "라벤홀트 장원" WHERE id = 3486;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Dun Morogh" WHERE id = 1;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Longrivage" WHERE id = 2;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Terres ingrates (Badlands)" WHERE id = 3;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Terres foudroyées (Blasted Lands)" WHERE id = 4;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Crique des Flots noirs" WHERE id = 7;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Marais des Chagrins (Swamp of Sorrows)" WHERE id = 8;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Vallée de Northshire" WHERE id = 9;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Bois de la Pénombre (Duskwood)" WHERE id = 10;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les Paluns (Wetlands)" WHERE id = 11;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Forêt d'Elwynn" WHERE id = 12;
UPDATE `AreaTable_vanilla` SET name_loc2 = "L'Arbre-monde" WHERE id = 13;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Durotar" WHERE id = 14;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Marécage d'Âprefange (Dustwallow Marsh)" WHERE id = 15;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Azshara" WHERE id = 16;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les Tarides (the Barrens)" WHERE id = 17;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac de Cristal" WHERE id = 18;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Zul'Gurub" WHERE id = 19;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruisselune" WHERE id = 20;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Kul Tiras" WHERE id = 21;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ile des programmeurs" WHERE id = 22;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Fleuve Northshire" WHERE id = 23;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Abbaye de Northshire" WHERE id = 24;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mont Blackrock" WHERE id = 25;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Phare" WHERE id = 26;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Maleterres de l'ouest (Western Plaguelands)" WHERE id = 28;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Neuf" WHERE id = 30;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le cimetière" WHERE id = 32;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Vallée de Strangleronce (Stranglethorn Vale)" WHERE id = 33;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mine de la crête aux échos" WHERE id = 34;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Baie-du-Butin" WHERE id = 35;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Montagnes d'Alterac" WHERE id = 36;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac Nazfériti" WHERE id = 37;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Loch Modan" WHERE id = 38;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Marche de l'Ouest (Westfall)" WHERE id = 40;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Défilé de Deuillevent (Deadwind Pass)" WHERE id = 41;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Darkshire" WHERE id = 42;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Rivage cruel" WHERE id = 43;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les Carmines (Redridge Mts)" WHERE id = 44;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Hautes-terres d'Arathi" WHERE id = 45;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Steppes ardentes" WHERE id = 46;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les Hinterlands" WHERE id = 47;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Gouffre du mort" WHERE id = 49;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Gorge des Vents brûlants (Searing Gorge)" WHERE id = 51;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp des voleurs" WHERE id = 53;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mine de Jasperlode" WHERE id = 54;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Valley of Heroes UNUSED" WHERE id = 55;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Veillée des héros" WHERE id = 56;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mine de Fargodeep" WHERE id = 57;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Vignes de Northshire" WHERE id = 59;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Lisière" WHERE id = 60;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Chutes du Tonnerre" WHERE id = 61;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Champ de potirons des Brackwell" WHERE id = 62;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La ferme des Stonefield" WHERE id = 63;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les Vignes des Maclure" WHERE id = 64;
UPDATE `AreaTable_vanilla` SET name_loc2 = "***Donjon sur carte***" WHERE id = 65;
UPDATE `AreaTable_vanilla` SET name_loc2 = "***Donjon sur carte***" WHERE id = 66;
UPDATE `AreaTable_vanilla` SET name_loc2 = "***Donjon sur carte***" WHERE id = 67;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac placide" WHERE id = 68;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lakeshire" WHERE id = 69;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Guet-de-pierre" WHERE id = 70;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Chutes de Guet-de-pierre" WHERE id = 71;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Porte des ténèbres" WHERE id = 72;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Balafre impure" WHERE id = 73;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Bassin des larmes" WHERE id = 74;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Stonard" WHERE id = 75;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Sanctuaire des friches" WHERE id = 76;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Anvilmar" WHERE id = 77;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Monts Stormwind" WHERE id = 80;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Quadrant NE de Jeff modifié" WHERE id = 81;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Quadrant de Jeff NO" WHERE id = 82;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Quadrant de Jeff SE" WHERE id = 83;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Quadrant de Jeff SO" WHERE id = 84;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Clairières de Tirisfal" WHERE id = 85;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac du Cairn" WHERE id = 86;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Goldshire" WHERE id = 87;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp de bûcherons du Val d'est" WHERE id = 88;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Verger du lac Miroir" WHERE id = 89;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tour d'Azora" WHERE id = 91;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac Miroir" WHERE id = 92;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tertre des ogres Vul'Gol" WHERE id = 93;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Colline-aux-Corbeaux" WHERE id = 94;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Canyons des Carmines" WHERE id = 95;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tour d'Ilgalar" WHERE id = 96;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Scierie d'Alther" WHERE id = 97;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cavernes de Rethban" WHERE id = 98;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp rebelle" WHERE id = 99;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Expédition de Nesingwary" WHERE id = 100;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Base de Kurzen" WHERE id = 101;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruines de Zul'Kunda" WHERE id = 102;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruines de Zul'Mamwe" WHERE id = 103;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Récif infâme" WHERE id = 104;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tertre des ogres Mosh'Ogg" WHERE id = 105;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La réserve" WHERE id = 106;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ferme des Saldean" WHERE id = 107;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Colline des sentinelles" WHERE id = 108;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ferme de potirons de Furlbrow" WHERE id = 109;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mine de Jangolode" WHERE id = 111;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Carrière de la côte de l'Or" WHERE id = 113;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Phare de l'Ouest" WHERE id = 115;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Vallée des brumes" WHERE id = 116;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Campement Grom'gol" WHERE id = 117;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Excavations de Whelgar" WHERE id = 118;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Garnison du ruisseau de l'ouest" WHERE id = 120;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cimetière des jardins paisibles" WHERE id = 121;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruines de Zuuldaia" WHERE id = 122;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruines de Bal'lal" WHERE id = 123;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruines de Kal'ai" WHERE id = 125;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruines de Tkashi" WHERE id = 126;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruines de Balia'mah" WHERE id = 127;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruines de Ziata'jai" WHERE id = 128;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruines de Mizjah" WHERE id = 129;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Forêt des Pins argentés (Silverpine Forest)" WHERE id = 130;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Kharanos" WHERE id = 131;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Vallée des Frigères" WHERE id = 132;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Gnomeregan" WHERE id = 133;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Carrière de Gol'Bolar" WHERE id = 134;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Repaire des Frostmane" WHERE id = 135;
UPDATE `AreaTable_vanilla` SET name_loc2 = "L'antre Gris" WHERE id = 136;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Brassetout" WHERE id = 137;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Refuge de Brumepins" WHERE id = 138;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Maleterres de l'est (Eastern Plaguelands)" WHERE id = 139;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Teldrassil" WHERE id = 141;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Excavations d'Ironband" WHERE id = 142;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Bastion des Mo'grosh" WHERE id = 143;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Thelsamar" WHERE id = 144;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Porte d'Algaz" WHERE id = 145;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Barrage de Formepierre" WHERE id = 146;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le pavillon des Pérégrins" WHERE id = 147;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Sombrivage (Darkshore)" WHERE id = 148;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mine du Ru d'argent" WHERE id = 149;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Port de Menethil" WHERE id = 150;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ile des concepteurs" WHERE id = 151;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Barricade" WHERE id = 152;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruines de Lordaeron" WHERE id = 153;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Glas" WHERE id = 154;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Grottes des Tisse-nuit" WHERE id = 155;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ferme des Solliden" WHERE id = 156;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Moulins d'Agamand" WHERE id = 157;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Crypte de la famille Agamand" WHERE id = 158;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Brill" WHERE id = 159;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Jardins des murmures" WHERE id = 160;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Terrasse de la quiétude" WHERE id = 161;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac Etincelant" WHERE id = 162;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Retraite de Gunther" WHERE id = 163;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Antre de Garren" WHERE id = 164;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ferme des Balnir" WHERE id = 165;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Manoir du Foyer froid" WHERE id = 166;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Avant-poste des Croisés" WHERE id = 167;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Côte nord" WHERE id = 168;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Rivage des murmures" WHERE id = 169;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac Lordamere" WHERE id = 170;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ile de Fenris" WHERE id = 172;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Repos de Faol" WHERE id = 173;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Dolanaar" WHERE id = 186;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Darnassus UNUSED" WHERE id = 187;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Sombrevallon" WHERE id = 188;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Dépôt de Steelgrill" WHERE id = 189;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Hearthglen" WHERE id = 190;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp de bûcherons de la Crête du nord" WHERE id = 192;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruines d'Andorhal" WHERE id = 193;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ecole de nécromancie" WHERE id = 195;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tombeau d'Uther" WHERE id = 196;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Colline des chagrins" WHERE id = 197;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La grotte des Pleurs" WHERE id = 198;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Champ de Felstone" WHERE id = 199;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Larmes de Dalson" WHERE id = 200;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Flétrissure de Gahrron" WHERE id = 201;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Repaire putride" WHERE id = 202;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Donjon de Mardenholde" WHERE id = 203;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Bois-du-Bûcher" WHERE id = 204;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Dun Modr" WHERE id = 205;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Marche de l'Ouest (Westfall)" WHERE id = 206;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Grande mer" WHERE id = 207;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Unused Ironcladcove" WHERE id = 208;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Donjon d'Ombrecroc" WHERE id = 209;
UPDATE `AreaTable_vanilla` SET name_loc2 = "***Donjon sur carte***" WHERE id = 210;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac glacial" WHERE id = 211;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac du Lit d'Helm" WHERE id = 212;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mine du gouffre d'Elem" WHERE id = 213;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Grande mer" WHERE id = 214;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mulgore" WHERE id = 215;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ferme des Alexston" WHERE id = 219;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mesa de Nuage rouge" WHERE id = 220;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp Narache" WHERE id = 221;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Village Bloodhoof" WHERE id = 222;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac Taureau-de-pierre" WHERE id = 223;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Caravane dévastée" WHERE id = 224;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Rochers rouges" WHERE id = 225;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Grouillement" WHERE id = 226;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Champ de Valgan" WHERE id = 227;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Sépulcre" WHERE id = 228;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ferme des Olsen" WHERE id = 229;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le mur de Greymane" WHERE id = 230;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Péril de Beren" WHERE id = 231;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les îles de l'aube" WHERE id = 232;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Moulin-de-l'Ambre" WHERE id = 233;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Donjon de Fenris" WHERE id = 235;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Donjon d'Ombrecroc" WHERE id = 236;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le bac délabré" WHERE id = 237;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Verger de Malden" WHERE id = 238;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le lopin d'Ivar" WHERE id = 239;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Champ des morts" WHERE id = 240;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le verger pourrissant" WHERE id = 241;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Bosquet de Clairbois" WHERE id = 242;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La masure lugubre" WHERE id = 243;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le domaine de Whipple" WHERE id = 244;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La ferme des Yorgen" WHERE id = 245;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Chaudron" WHERE id = 246;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Site de fouilles de Grimesilt" WHERE id = 247;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Rocher des Cognepeurs" WHERE id = 249;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruines de Thaurissan" WHERE id = 250;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Corniche des flammes" WHERE id = 251;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Bastion des Blackrock" WHERE id = 252;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Pilier de cendres" WHERE id = 253;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mont Blackrock" WHERE id = 254;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Autel des tempêtes" WHERE id = 255;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Aldrassil" WHERE id = 256;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Grotte de Sombrefil" WHERE id = 257;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Gangreroche" WHERE id = 258;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac Al'Ameth" WHERE id = 259;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Brise-stellaire" WHERE id = 260;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp des Pins-tordus" WHERE id = 261;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Refuge des saisons de Ban'ethil" WHERE id = 262;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Faille" WHERE id = 263;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Clairière de l'Oracle" WHERE id = 264;
UPDATE `AreaTable_vanilla` SET name_loc2 = "L'Aigue-vive" WHERE id = 265;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac d'Aigue-vive" WHERE id = 266;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Contreforts d'Hillsbrad" WHERE id = 267;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cratère d'Azshara" WHERE id = 268;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Dun Algaz" WHERE id = 269;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Southshore" WHERE id = 271;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Moulin-de-Tarren" WHERE id = 272;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Donjon de Durnholde" WHERE id = 275;
UPDATE `AreaTable_vanilla` SET name_loc2 = "UNUSED Passage de Formepierre" WHERE id = 276;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les cavernes des contreforts" WHERE id = 277;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp d'internement de Lordamere" WHERE id = 278;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Dalaran" WHERE id = 279;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Strahnbrad" WHERE id = 280;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruines d'Alterac" WHERE id = 281;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Bastion Cassecrête" WHERE id = 282;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Creux du massacre" WHERE id = 283;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les Hauteurs" WHERE id = 284;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tour de la Pointe du Midi" WHERE id = 285;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Champs d'Hillsbrad" WHERE id = 286;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Hillsbrad" WHERE id = 287;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mine d'Azurelode" WHERE id = 288;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ferme des Nethander" WHERE id = 289;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Dun Garok" WHERE id = 290;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mur de Thoradin" WHERE id = 293;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Rivage oriental" WHERE id = 294;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Rivage occidental" WHERE id = 295;
UPDATE `AreaTable_vanilla` SET name_loc2 = "South Seas UNUSED" WHERE id = 296;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ile aux jagueros" WHERE id = 297;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Baie de Baradin" WHERE id = 298;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Baie de Menethil" WHERE id = 299;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Grève de Brumejonc" WHERE id = 300;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Côte sauvage" WHERE id = 301;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Rivage de cristal" WHERE id = 302;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Plage aux coquillages" WHERE id = 303;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La côte nord" WHERE id = 305;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La côte sud" WHERE id = 306;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les Hauts-Surplombs" WHERE id = 307;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Mer interdite" WHERE id = 308;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tombe d'Ironbeard" WHERE id = 309;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mine aux cristaux" WHERE id = 310;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruines d'Aboraz" WHERE id = 311;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cap Janeiro" WHERE id = 312;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Manoir de Nordclos" WHERE id = 313;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ferme de Go'Shek" WHERE id = 314;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ferme des Dabyrie" WHERE id = 315;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Hall Rochepoing" WHERE id = 316;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Village Witherbark" WHERE id = 317;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Gorge des Sèches-moustaches" WHERE id = 318;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Refuge de l'Ornière" WHERE id = 320;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Trépas-d'Orgrim" WHERE id = 321;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Epaves des Flots noirs" WHERE id = 322;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp de O'Breen" WHERE id = 323;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Donjon de Stromgarde" WHERE id = 324;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Tour d'Arathor" WHERE id = 325;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Sanctuaire" WHERE id = 326;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Crique de Faldir" WHERE id = 327;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le récif englouti" WHERE id = 328;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Viaduc de Thandol" WHERE id = 330;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ashenvale" WHERE id = 331;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Grande mer" WHERE id = 332;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cercle de lien oriental" WHERE id = 333;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cercle de lien occidental" WHERE id = 334;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cercle de lien intérieur" WHERE id = 335;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cercle de lien extérieur" WHERE id = 336;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Repos d'Apocryphan" WHERE id = 337;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Forteresse d'Angor" WHERE id = 338;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ravin de Lethlor" WHERE id = 339;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Kargath" WHERE id = 340;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp Kosh" WHERE id = 341;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp Boff" WHERE id = 342;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp Wurg" WHERE id = 343;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp Cagg" WHERE id = 344;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Fin d'Agmond" WHERE id = 345;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Site de fouilles d'Hammertoe" WHERE id = 346;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Grotte de Crache-poussière" WHERE id = 347;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Nid-de-l'Aigle" WHERE id = 348;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Donjon des Wildhammer" WHERE id = 349;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Gîte de Quel'Danil" WHERE id = 350;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Rocher de l'Affût" WHERE id = 351;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Zun'watha" WHERE id = 352;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Shadra'Alor" WHERE id = 353;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Jintha'Alor" WHERE id = 354;
UPDATE `AreaTable_vanilla` SET name_loc2 = "L'Autel de Zul" WHERE id = 355;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Seradane" WHERE id = 356;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Feralas" WHERE id = 357;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ravin de Roncelame" WHERE id = 358;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Bael Modan" WHERE id = 359;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mine de la KapitalRisk" WHERE id = 360;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Gangrebois (Felwood)" WHERE id = 361;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tranchecolline" WHERE id = 362;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Vallée des épreuves" WHERE id = 363;
UPDATE `AreaTable_vanilla` SET name_loc2 = "L'Antre" WHERE id = 364;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Convent de la Lame ardente" WHERE id = 365;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Combe des Kolkar" WHERE id = 366;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Village de Sen'jin" WHERE id = 367;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Îles de l'Écho" WHERE id = 368;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Falaises du Tonnerre" WHERE id = 369;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ravin asséché" WHERE id = 370;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Caverne des Terrevent" WHERE id = 371;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Donjon de Tiragarde" WHERE id = 372;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Côte des naufrages" WHERE id = 373;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Baie de Bladefist" WHERE id = 374;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Rivage de Deadeye" WHERE id = 375;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Fleuve Furie-du-Sud" WHERE id = 377;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp Taurajo" WHERE id = 378;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Poste de garde extérieur" WHERE id = 379;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Croisée" WHERE id = 380;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mine des Pierriers" WHERE id = 381;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Videfange" WHERE id = 382;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les Collines arides" WHERE id = 383;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Pic de Brume-funeste" WHERE id = 384;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Fort du Nord" WHERE id = 385;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les Bassins oubliés" WHERE id = 386;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Oasis luxuriante" WHERE id = 387;
UPDATE `AreaTable_vanilla` SET name_loc2 = "L'oasis stagnante" WHERE id = 388;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Champ des Géants" WHERE id = 390;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Côte des marchands" WHERE id = 391;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ratchet" WHERE id = 392;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Grève des Darkspear" WHERE id = 393;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac DarrowmereUNUSED" WHERE id = 394;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Caer Darrow UNUSED" WHERE id = 395;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Puits Winterhoof" WHERE id = 396;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Puits Thunderhorn" WHERE id = 397;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Puits Wildmane" WHERE id = 398;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Crête de Skyline" WHERE id = 399;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mille pointes (Thousand Needles)" WHERE id = 400;
UPDATE `AreaTable_vanilla` SET name_loc2 = "L'Escalier des marées" WHERE id = 401;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Auberge du Repos ombragé" WHERE id = 403;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Site de fouilles de Bael'Dun" WHERE id = 404;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Désolace" WHERE id = 405;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les Serres-Rocheuses (Stonetalon Mts)" WHERE id = 406;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Orgrimmar UNUSED" WHERE id = 407;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ile de Gillijim" WHERE id = 408;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ile du docteur Lapidis" WHERE id = 409;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Canyon de Tranchevent" WHERE id = 410;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Repaire de Bathran" WHERE id = 411;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les Ruines d'Ordil'Aran" WHERE id = 412;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Poste de Maestra" WHERE id = 413;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La grève de Zoram" WHERE id = 414;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Astranaar" WHERE id = 415;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le sanctuaire d'Aessina" WHERE id = 416;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Sanctuaire de Scarfeu" WHERE id = 417;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les ruines de Chimétoile" WHERE id = 418;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Val hurlant" WHERE id = 419;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Refuge de Vent-argent" WHERE id = 420;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac Mystral" WHERE id = 421;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac Tombeciel" WHERE id = 422;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac Iris" WHERE id = 424;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Puits de lune" WHERE id = 425;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Retraite de Raynewood" WHERE id = 426;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le creux ombragé" WHERE id = 427;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Défilé de la nuit" WHERE id = 428;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Xavian" WHERE id = 429;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Satyrnaar" WHERE id = 430;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Poste de Bois-brisé" WHERE id = 431;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Refuge des saisons de Dor'danil" WHERE id = 432;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Fleuve Falfarren" WHERE id = 433;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Colline Gangrefeu" WHERE id = 434;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Canyon de la Malechute" WHERE id = 435;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Crête de la Malechute" WHERE id = 436;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp de bûcherons Warsong" WHERE id = 437;
UPDATE `AreaTable_vanilla` SET name_loc2 = "L'Ombrage" WHERE id = 438;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les Salines" WHERE id = 439;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tanaris" WHERE id = 440;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac Falathim" WHERE id = 441;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Auberdine" WHERE id = 442;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruines de Mathystra" WHERE id = 443;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tour d'Althalaxx" WHERE id = 444;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Chutes de la Bondissante" WHERE id = 445;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Bashal'Aran" WHERE id = 446;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ameth'Aran" WHERE id = 447;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Bosquet des Anciens" WHERE id = 448;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Glaive du Maître" WHERE id = 449;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Excavations de Remtravel" WHERE id = 450;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La lisière des brumes" WHERE id = 452;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Lent reflux" WHERE id = 453;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Sinueuse" WHERE id = 454;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tanière des Noirbois" WHERE id = 455;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Bondissante" WHERE id = 456;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Mer voilée" WHERE id = 457;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Route de l'or" WHERE id = 458;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Poste de garde de la Croisade" WHERE id = 459;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Retraite de Roche-Soleil" WHERE id = 460;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Combe des Cisailles" WHERE id = 461;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac de la Combe" WHERE id = 463;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac Mirkfallon" WHERE id = 464;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Val calciné" WHERE id = 465;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Vallée des Rouges-furies" WHERE id = 466;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Pic des Serres-Rocheuses" WHERE id = 467;
UPDATE `AreaTable_vanilla` SET name_loc2 = "L'antre des Serres" WHERE id = 468;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Val de Grandbois" WHERE id = 469;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Thunder Bluff UNUSED" WHERE id = 470;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mesa de Brave-vent" WHERE id = 471;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mesa de Pierrefeu" WHERE id = 472;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Roc de Mantle" WHERE id = 473;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Hunter Rise UNUSED" WHERE id = 474;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Spirit RiseUNUSED" WHERE id = 475;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Elder RiseUNUSED" WHERE id = 476;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruines de Jubuwal" WHERE id = 477;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Bassins d'Arlithrien" WHERE id = 478;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Site de fouilles de Rustmaul" WHERE id = 479;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp E'thok" WHERE id = 480;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Combe du Sabot fendu" WHERE id = 481;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Haut-perchoir" WHERE id = 482;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Canyon des hurlements" WHERE id = 483;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Poste de Librevent" WHERE id = 484;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Grande élévation" WHERE id = 485;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Repaire des Galak" WHERE id = 486;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tanière des Volplumes" WHERE id = 487;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La niche érodée" WHERE id = 488;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Thalanaar" WHERE id = 489;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cratère d'Un'Goro" WHERE id = 490;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Kraal de Tranchebauge" WHERE id = 491;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cimetière de Colline-aux-Corbeaux" WHERE id = 492;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Reflet-de-Lune (Moonglade)" WHERE id = 493;
UPDATE `AreaTable_vanilla` SET name_loc2 = "SUPPRIMEZ-MOI" WHERE id = 495;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mur-de-Fougères" WHERE id = 496;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Manoir des Flammeroles" WHERE id = 497;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Terrier des Rougefanges" WHERE id = 498;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Caverne de Sombrebrume" WHERE id = 499;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cap Moggle" WHERE id = 500;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Epave de Beezil" WHERE id = 501;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Colline des sorcières" WHERE id = 502;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Halte de la Vigie" WHERE id = 503;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tour de la halte nord" WHERE id = 504;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tour du cap ouest" WHERE id = 505;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Halte perdue" WHERE id = 506;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Marais bleu" WHERE id = 507;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruines Cognepierres" WHERE id = 508;
UPDATE `AreaTable_vanilla` SET name_loc2 = "L'Antre des flammes" WHERE id = 509;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le cloaque aux dragons" WHERE id = 510;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tourbière du Ver" WHERE id = 511;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Onyxia's Lair UNUSED" WHERE id = 512;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ile de Theramore" WHERE id = 513;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Citadelle de Theramore" WHERE id = 514;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Prison du cuirassé" WHERE id = 515;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Baie d'Âprefange" WHERE id = 516;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Crique du Mascaret" WHERE id = 517;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Rivage de Troubleffroi" WHERE id = 518;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ferme des Addle" WHERE id = 536;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Crête de la Fournaise" WHERE id = 537;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Fosses de goudron de Lakkari" WHERE id = 538;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Coteaux de la terreur" WHERE id = 539;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Balafre sinueuse" WHERE id = 540;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Refuge des Marshal" WHERE id = 541;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Rocher fongique" WHERE id = 542;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Sources de Golakka" WHERE id = 543;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Loch" WHERE id = 556;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Repaire des mendiants" WHERE id = 576;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cimetière des kodos" WHERE id = 596;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Poste de Rôdeur-fantôme" WHERE id = 597;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Grève de Sar'theris" WHERE id = 598;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Forteresse de Hache-Tonnerre" WHERE id = 599;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Trou de Bolgan" WHERE id = 600;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Convent de Mannoroc" WHERE id = 602;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Sargeron" WHERE id = 603;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Village des Magram" WHERE id = 604;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Village des Gelkis" WHERE id = 606;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Vallée des Lances" WHERE id = 607;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Combe de Nijel" WHERE id = 608;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Village des Kolkar" WHERE id = 609;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Hyjal" WHERE id = 616;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Berceau-de-l'Hiver (Winterspring)" WHERE id = 618;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Fleuve Loup-noir" WHERE id = 636;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Rocher des kodos" WHERE id = 637;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Chemin secret" WHERE id = 638;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Rocher des esprits" WHERE id = 639;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Autel de la flamme dormante" WHERE id = 640;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac Elune'ara" WHERE id = 656;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Havre boueux" WHERE id = 657;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Outreterre" WHERE id = 676;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Craftsmen's Terrace UNUSED" WHERE id = 696;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tradesmen's Terrace UNUSED" WHERE id = 697;
UPDATE `AreaTable_vanilla` SET name_loc2 = "The Temple Gardens UNUSED" WHERE id = 698;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Temple of Elune UNUSED" WHERE id = 699;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cenarion Enclave UNUSED" WHERE id = 700;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Warrior's Terrace UNUSED" WHERE id = 701;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Rut'theran" WHERE id = 702;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Base d'Ironband" WHERE id = 716;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Prison" WHERE id = 717;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cavernes des lamentations" WHERE id = 718;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Profondeurs de Brassenoire" WHERE id = 719;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ile de la Dispute" WHERE id = 720;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Gnomeregan" WHERE id = 721;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Souilles de Tranchebauge" WHERE id = 722;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Creux de Ban'ethil" WHERE id = 736;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Monastère écarlate" WHERE id = 796;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Débarcadère de Jerod" WHERE id = 797;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tour de la Crête" WHERE id = 798;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Rive sombre" WHERE id = 799;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Passe des Frigères" WHERE id = 800;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Vallée de la bise" WHERE id = 801;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Crête scintillante" WHERE id = 802;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ferme des Amberstill" WHERE id = 803;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les Collines de Tundrid" WHERE id = 804;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Passage de la porte Sud" WHERE id = 805;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Avant-poste de la porte Sud" WHERE id = 806;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Passage de la porte Nord" WHERE id = 807;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Avant-poste de la porte Nord" WHERE id = 808;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Portes d'Ironforge" WHERE id = 809;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Etang immobile" WHERE id = 810;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Vallée des cauchemars" WHERE id = 811;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Vallée de Tissevenin" WHERE id = 812;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Barricade" WHERE id = 813;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Fleuve Furie-du-Sud" WHERE id = 814;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Fleuve Furie-du-Sud" WHERE id = 815;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Terres des Tranchecrins" WHERE id = 816;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Rocher du crâne" WHERE id = 817;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Rocher des crins-pâles" WHERE id = 818;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Crête des Furies-des-vents" WHERE id = 819;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les plaines dorées" WHERE id = 820;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les plaines vallonnées" WHERE id = 821;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Dun Algaz" WHERE id = 836;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Dun Algaz" WHERE id = 837;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Passage de la porte Nord" WHERE id = 838;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Passage de la porte Sud" WHERE id = 839;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Bosquet du crépuscule" WHERE id = 856;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ile des MJ" WHERE id = 876;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Supprimez-MOI" WHERE id = 877;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Fleuve Furie-du-Sud" WHERE id = 878;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Fleuve Furie-du-Sud" WHERE id = 879;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Viaduc de Thandol" WHERE id = 880;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Viaduc de Thandol" WHERE id = 881;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ile de la purification" WHERE id = 896;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La ferme des Jansen" WHERE id = 916;
UPDATE `AreaTable_vanilla` SET name_loc2 = "L'acre mort" WHERE id = 917;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La ferme des Molsen" WHERE id = 918;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Etang de Stendel" WHERE id = 919;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les collines de la Dague" WHERE id = 920;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Maison de Demont" WHERE id = 921;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les Plaines de poussière" WHERE id = 922;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Vallée des Brisepierre" WHERE id = 923;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Vallée des rois" WHERE id = 924;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Poste d'Algaz" WHERE id = 925;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ferme des Bucklebree" WHERE id = 926;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Rivage rayonnant" WHERE id = 927;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Creux de la côte nord" WHERE id = 928;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Falaise de Vieillegriffe" WHERE id = 936;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les Champs verdoyants" WHERE id = 956;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Gadgetzan" WHERE id = 976;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Port Gentepression" WHERE id = 977;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Zul'Farrak" WHERE id = 978;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Guet de Tristesable" WHERE id = 979;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Vallée des Chardonniers" WHERE id = 980;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Gouffre béant" WHERE id = 981;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Repaire nuisible" WHERE id = 982;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Base des Cognedunes" WHERE id = 983;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruines d'Estelune" WHERE id = 984;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Champ des puisatiers" WHERE id = 985;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La tanière de Zalashji" WHERE id = 986;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Plage du Bout-du-Monde" WHERE id = 987;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Plage des Déferlantes" WHERE id = 988;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Uldum" WHERE id = 989;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Vallée des guetteurs" WHERE id = 990;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Poste de Gunstan" WHERE id = 991;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruines de Sudelune" WHERE id = 992;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp des Etripeurs" WHERE id = 996;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Vallée des Etripeurs" WHERE id = 997;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Rocher des Etripeurs" WHERE id = 998;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tour de Guet-de-pierre" WHERE id = 999;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Vallée de Galardell" WHERE id = 1000;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Grand-route de la Crête du lac" WHERE id = 1001;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Trois chemins" WHERE id = 1002;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Colline de Morneforge" WHERE id = 1016;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Crête des raptors" WHERE id = 1017;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Marais des eaux-noires" WHERE id = 1018;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Ceinture verte" WHERE id = 1019;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Marais des Poils-moussus" WHERE id = 1020;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Rocher de Thelgen" WHERE id = 1021;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Marais des Branchies-bleues" WHERE id = 1022;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Vallon des embruns" WHERE id = 1023;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Marais du couchant" WHERE id = 1024;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Ceinture verte" WHERE id = 1025;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Campement de Hargnecroc" WHERE id = 1036;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Grim Batol" WHERE id = 1037;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Portes des Dragonmaw" WHERE id = 1038;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La flotte perdue" WHERE id = 1039;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Colline de Darrow" WHERE id = 1056;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mur de Thoradin" WHERE id = 1057;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Sentier des Tisseuses" WHERE id = 1076;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Rive silencieuse" WHERE id = 1097;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Manoir Mistmantle" WHERE id = 1098;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp Mojache" WHERE id = 1099;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Base des Totem sinistre" WHERE id = 1100;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Gouffre grouillant" WHERE id = 1101;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac des rafales" WHERE id = 1102;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Avant-poste des Gordunni" WHERE id = 1103;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mok'Gordun" WHERE id = 1104;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Val des Griffes farouches" WHERE id = 1105;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Hautes-terres des Aigreplumes" WHERE id = 1106;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac Idlewind" WHERE id = 1107;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Côte oubliée" WHERE id = 1108;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Pilier Est" WHERE id = 1109;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Pilier Ouest" WHERE id = 1110;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Bosquet du rêve" WHERE id = 1111;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac Jademir" WHERE id = 1112;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Oneiros" WHERE id = 1113;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruines de Vent-du-Corbeau" WHERE id = 1114;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Repaire des Griffes féroces" WHERE id = 1115;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Bastion de Feathermoon" WHERE id = 1116;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruines de Solarsal" WHERE id = 1117;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lower Wilds UNUSED" WHERE id = 1118;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les Colosses jumeaux" WHERE id = 1119;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ile de Sardor" WHERE id = 1120;
UPDATE `AreaTable_vanilla` SET name_loc2 = "lle de l'effroi" WHERE id = 1121;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les plateaux sauvages" WHERE id = 1136;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Etendues sauvages" WHERE id = 1137;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tarides du sud" WHERE id = 1156;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Route de l'or méridionale" WHERE id = 1157;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Zul'Farrak" WHERE id = 1176;
UPDATE `AreaTable_vanilla` SET name_loc2 = "UNUSEDAlcaz Island" WHERE id = 1196;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Repaire des Grumegueules" WHERE id = 1216;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Campement de Vanndir" WHERE id = 1217;
UPDATE `AreaTable_vanilla` SET name_loc2 = "TESTAzshara" WHERE id = 1218;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Campement Legashi" WHERE id = 1219;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp de base thalassien" WHERE id = 1220;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruines d'Eldarath" WHERE id = 1221;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Frai d'Hetaera" WHERE id = 1222;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Temple de Zin-Malor" WHERE id = 1223;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tête d'ours" WHERE id = 1224;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ursolan" WHERE id = 1225;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Temple d'Arkkoran" WHERE id = 1226;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Baie des tempêtes" WHERE id = 1227;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Grève fracassée" WHERE id = 1228;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tour d'Eldara" WHERE id = 1229;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Récif déchiqueté" WHERE id = 1230;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Plage des Crêtes du sud" WHERE id = 1231;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Colosse de Ravencrest" WHERE id = 1232;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La crête lugubre" WHERE id = 1233;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac Mennar" WHERE id = 1234;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Sanctuaire de Shadowsong" WHERE id = 1235;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Campement des Haldarr" WHERE id = 1236;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Valormok" WHERE id = 1237;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les Confins dévastés" WHERE id = 1256;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Perce des Serres" WHERE id = 1276;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Perce des Serres" WHERE id = 1277;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ferme Brochepierre" WHERE id = 1296;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ferme Rêche-pourceau" WHERE id = 1297;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Souilles de Tranchebauge" WHERE id = 1316;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Crique des Gréements" WHERE id = 1336;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Uldaman" WHERE id = 1337;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac Lordamere" WHERE id = 1338;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac Lordamere" WHERE id = 1339;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Fourche du gibet" WHERE id = 1357;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Silithus" WHERE id = 1377;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Forêt d'émeraude" WHERE id = 1397;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Temple englouti" WHERE id = 1417;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Bastion Cognepeur" WHERE id = 1437;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Rempart-du-Néant" WHERE id = 1438;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Poste Cognepeur" WHERE id = 1439;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Anneaux du serpent" WHERE id = 1440;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Autel des tempêtes" WHERE id = 1441;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Crête de Guet-du-feu" WHERE id = 1442;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Fosse aux scories" WHERE id = 1443;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Mer de braises" WHERE id = 1444;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mont Blackrock" WHERE id = 1445;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Halte du Thorium" WHERE id = 1446;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Armurerie de la garnison" WHERE id = 1457;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le temple d'Atal'Hakkar" WHERE id = 1477;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Undercity" WHERE id = 1497;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Uldaman" WHERE id = 1517;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mortemines non utilisé" WHERE id = 1518;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cité de Stormwind" WHERE id = 1519;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ironforge" WHERE id = 1537;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Bastion du Sabot fendu" WHERE id = 1557;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le cap Strangleronce" WHERE id = 1577;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Côte sauvage du sud" WHERE id = 1578;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Unused The Deadmines 002" WHERE id = 1579;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Unused Ironclad Cove 003" WHERE id = 1580;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les Mortemines" WHERE id = 1581;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Crique du cuirassé" WHERE id = 1582;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Pic Blackrock" WHERE id = 1583;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Profondeurs de Blackrock" WHERE id = 1584;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Raptor Grounds UNUSED" WHERE id = 1597;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Grol'dom Farm UNUSED" WHERE id = 1598;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Campement de Mor'shan" WHERE id = 1599;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Honor's Stand UNUSED" WHERE id = 1600;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Blackthorn Ridge UNUSED" WHERE id = 1601;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ronceplaie UNUSED" WHERE id = 1602;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Agama'gor UNUSED" WHERE id = 1603;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Vallée des héros" WHERE id = 1617;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Orgrimmar" WHERE id = 1637;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Thunder Bluff" WHERE id = 1638;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cime des Anciens" WHERE id = 1639;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cime des Esprits" WHERE id = 1640;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cime des chasseurs" WHERE id = 1641;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Darnassus" WHERE id = 1657;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Enclave cénarienne" WHERE id = 1658;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Terrasse des Artisans" WHERE id = 1659;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Terrasse des Guerriers" WHERE id = 1660;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les Jardins du temple" WHERE id = 1661;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Terrasse des Marchands" WHERE id = 1662;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Promontoire de Gavin" WHERE id = 1677;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Promontoire de Sofera" WHERE id = 1678;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Dague de Corrahn" WHERE id = 1679;
UPDATE `AreaTable_vanilla` SET name_loc2 = "L'Avancée" WHERE id = 1680;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Rivage brumeux" WHERE id = 1681;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Clos de Dandred" WHERE id = 1682;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Caverne stérile" WHERE id = 1683;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Pointe du Noroît" WHERE id = 1684;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Terres des Raptors" WHERE id = 1697;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ronceplaie" WHERE id = 1698;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Colline des épines" WHERE id = 1699;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Agama'gor" WHERE id = 1700;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Crête de Noirépine" WHERE id = 1701;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le lieu de l'Honneur" WHERE id = 1702;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Rempart de Mor'shan" WHERE id = 1703;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ferme de Grol'dom" WHERE id = 1704;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Kraal de Tranchebauge" WHERE id = 1717;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Grande élévation" WHERE id = 1718;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Valbrume" WHERE id = 1737;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Fontaine des Nek'mani" WHERE id = 1738;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Base de la Voile sanglante" WHERE id = 1739;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Campement de la KapitalRisk" WHERE id = 1740;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Arène des Gurubashi" WHERE id = 1741;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Antre des esprits" WHERE id = 1742;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Voile cramoisi" WHERE id = 1757;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Courant" WHERE id = 1758;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Chance de la demoiselle" WHERE id = 1759;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Centre d'opérations de la KapitalRisk" WHERE id = 1760;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Village des Mort-bois" WHERE id = 1761;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Village de Gangrepatte" WHERE id = 1762;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Jaedenar" WHERE id = 1763;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Vénéneuse" WHERE id = 1764;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Chutes de la Vénéneuse" WHERE id = 1765;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Val Grêlé" WHERE id = 1766;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Bois d'Arbrefer" WHERE id = 1767;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Caverne d'Arbrefer" WHERE id = 1768;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Repaire des Grumegueules" WHERE id = 1769;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Fort des ombres" WHERE id = 1770;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Sanctuaire du Trompeur" WHERE id = 1771;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Caverne d'Itharius" WHERE id = 1777;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Noirchagrin" WHERE id = 1778;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Village de Draenil'dur" WHERE id = 1779;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Croisement de Lance-brisée" WHERE id = 1780;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Stagalbog" WHERE id = 1797;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Bourbier changeant" WHERE id = 1798;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Caverne de Stagalbog" WHERE id = 1817;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cavernes Witherbark" WHERE id = 1837;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mur de Thoradin" WHERE id = 1857;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Boulder'gor" WHERE id = 1858;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Vallée des crocs" WHERE id = 1877;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Vallée de la poussière" WHERE id = 1878;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Vallée des mirages" WHERE id = 1879;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Taudis de Featherbeard" WHERE id = 1880;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp de Shindigger" WHERE id = 1881;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ravin de Pestebrume" WHERE id = 1882;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac Vent-vaillant" WHERE id = 1883;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Agol'watha" WHERE id = 1884;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Hiri'watha" WHERE id = 1885;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Ruine aux rampants" WHERE id = 1886;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Escarpement de Bogen" WHERE id = 1887;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Terrasse des faiseurs" WHERE id = 1897;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Goulet de la Bourrasque" WHERE id = 1898;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Shaol'watha" WHERE id = 1917;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruines d'Ombre-du-Zénith" WHERE id = 1937;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Pilier brisé" WHERE id = 1938;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Désert Abysséen" WHERE id = 1939;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Rivage de Brisesud" WHERE id = 1940;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Grottes du temps" WHERE id = 1941;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Fondrière" WHERE id = 1942;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Plateau de Rochefer" WHERE id = 1943;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Caverne de Noircharbon" WHERE id = 1957;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp de Tanner" WHERE id = 1958;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Vallée des Escarbilles" WHERE id = 1959;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Zul'Gurub" WHERE id = 1977;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Poste de Brumejonc" WHERE id = 1978;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Poste de la Vénéneuse" WHERE id = 1997;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Clairière de Griffebranche" WHERE id = 1998;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Stratholme" WHERE id = 2017;
UPDATE `AreaTable_vanilla` SET name_loc2 = "UNUSEDShadowfang Keep 003" WHERE id = 2037;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Scholomance" WHERE id = 2057;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Vallée du crépuscule" WHERE id = 2077;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Rivage du crépuscule" WHERE id = 2078;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ile d'Alcaz" WHERE id = 2079;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cime de Noir-nuage" WHERE id = 2097;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Catacombes du Bois-de-l'Aube" WHERE id = 2098;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Donjon de Guet-de-pierre" WHERE id = 2099;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Maraudon" WHERE id = 2100;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Auberge de la Fortebière" WHERE id = 2101;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Distillerie Thunderbrew" WHERE id = 2102;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Donjon de Menethil" WHERE id = 2103;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Taverne de l'Eau-profonde" WHERE id = 2104;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tombeau des ombres" WHERE id = 2117;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Hôtel de ville de Brill" WHERE id = 2118;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Taverne des Pendus" WHERE id = 2119;
UPDATE `AreaTable_vanilla` SET name_loc2 = "The Pools of VisionUNUSED" WHERE id = 2137;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Refuge de Brume-funeste" WHERE id = 2138;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Donjon de Bael'dun" WHERE id = 2157;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tanière de Brandeguerre" WHERE id = 2158;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Repaire d'Onyxia" WHERE id = 2159;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mine des Cisailles" WHERE id = 2160;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Destin de Roland" WHERE id = 2161;
UPDATE `AreaTable_vanilla` SET name_loc2 = "L'arène" WHERE id = 2177;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les Bassins de la Vision" WHERE id = 2197;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ravin de Brèche-de-l'Ombre" WHERE id = 2198;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Village de la Lance brisée" WHERE id = 2217;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Poste de Blanc-relais" WHERE id = 2237;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Gornia" WHERE id = 2238;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cratère de l'Oeil de Zane" WHERE id = 2239;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Piste des mirages" WHERE id = 2240;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Roc des Sabres-de-Givre" WHERE id = 2241;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Bosquet caché" WHERE id = 2242;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Poste des Grumegueules" WHERE id = 2243;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Village Tombe-hiver" WHERE id = 2244;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mazthoril" WHERE id = 2245;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Sources de Givrefeu" WHERE id = 2246;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Collines des Chardons de glace" WHERE id = 2247;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Dun Mandarr" WHERE id = 2248;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Gorge du Blanc murmure" WHERE id = 2249;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Fourré de l'Aile de la chouette" WHERE id = 2250;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac Kel'Theril" WHERE id = 2251;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les ruines de Kel'Theril" WHERE id = 2252;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Pluie-d'Etoiles" WHERE id = 2253;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Refuge des saisons de Ban'Thallow" WHERE id = 2254;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Long-guet" WHERE id = 2255;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Gorge du Sombre murmure" WHERE id = 2256;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tram des profondeurs" WHERE id = 2257;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Vallée des fongus" WHERE id = 2258;
UPDATE `AreaTable_vanilla` SET name_loc2 = "UNUSEDLa ferme des Marris" WHERE id = 2259;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La ferme des Marris" WHERE id = 2260;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le caveau de Zaeldarr" WHERE id = 2261;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Darrowshire" WHERE id = 2262;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tour de garde de la couronne" WHERE id = 2263;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Croisée de Corin" WHERE id = 2264;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp de la Croisade" WHERE id = 2265;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Main de Tyr" WHERE id = 2266;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Basilique écarlate" WHERE id = 2267;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Chapelle de l'Espoir de Lumière" WHERE id = 2268;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Scierie de Browman" WHERE id = 2269;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Clairière nocive" WHERE id = 2270;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tour du Mur d'est" WHERE id = 2271;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Valnord" WHERE id = 2272;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Zul'Mashar" WHERE id = 2273;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mazra'Alor" WHERE id = 2274;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tour du Col du nord" WHERE id = 2275;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Gîte de Quel'Lithien" WHERE id = 2276;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Pestebois" WHERE id = 2277;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Fort-Fléau" WHERE id = 2278;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Stratholme" WHERE id = 2279;
UPDATE `AreaTable_vanilla` SET name_loc2 = "UNUSED Stratholme" WHERE id = 2280;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac Darrowmere" WHERE id = 2297;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Caer Darrow" WHERE id = 2298;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac Darrowmere" WHERE id = 2299;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Grottes du temps" WHERE id = 2300;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Village des Crins-de-Chardon" WHERE id = 2301;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Bourbier" WHERE id = 2302;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Canyon de Brisevent" WHERE id = 2303;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mers du sud" WHERE id = 2317;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Grande mer" WHERE id = 2318;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Grande mer" WHERE id = 2319;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Grande mer" WHERE id = 2320;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Grande mer" WHERE id = 2321;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Mer voilée" WHERE id = 2322;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Mer voilée" WHERE id = 2323;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Mer voilée" WHERE id = 2324;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Mer voilée" WHERE id = 2325;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Mer voilée" WHERE id = 2326;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Caserne de Tranchecolline" WHERE id = 2337;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mers du sud" WHERE id = 2338;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Grande mer" WHERE id = 2339;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp de Dent-rouge" WHERE id = 2357;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Chant des forêts" WHERE id = 2358;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Village des Pattes-vertes" WHERE id = 2359;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Avant-poste d'Aile-argent" WHERE id = 2360;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Havrenuit" WHERE id = 2361;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Sanctuaire de Remulos" WHERE id = 2362;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Refuge des saisons de Malfurion" WHERE id = 2363;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Grande mer" WHERE id = 2364;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Grande mer" WHERE id = 2365;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Noir Marécage" WHERE id = 2366;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Anciens contreforts d'Hillsbrad" WHERE id = 2367;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Moulin-de-Tarren" WHERE id = 2368;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Southshore" WHERE id = 2369;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Donjon de Durnholde" WHERE id = 2370;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Dun Garok" WHERE id = 2371;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Champs d'Hillsbrad" WHERE id = 2372;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Rivage oriental" WHERE id = 2373;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ferme des Nethander" WHERE id = 2374;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Colline de Darrow" WHERE id = 2375;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tour de la Pointe du Midi" WHERE id = 2376;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mur de Thoradin" WHERE id = 2377;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Rivage occidental" WHERE id = 2378;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mine d'Azurelode" WHERE id = 2379;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Grande mer" WHERE id = 2397;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Grande mer" WHERE id = 2398;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Grande mer" WHERE id = 2399;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Mer interdite" WHERE id = 2400;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Mer interdite" WHERE id = 2401;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Mer interdite" WHERE id = 2402;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Mer interdite" WHERE id = 2403;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tethris Aran" WHERE id = 2404;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ethel Rethor" WHERE id = 2405;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ile de Ranazjar" WHERE id = 2406;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Hutte de Kormek" WHERE id = 2407;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Proie-de-l'Ombre" WHERE id = 2408;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Défilé des Blackrock" WHERE id = 2417;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Veille de Morgan" WHERE id = 2418;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Roc sinueux" WHERE id = 2419;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Chemin de l'Aile de la terreur" WHERE id = 2420;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Draco'dar" WHERE id = 2421;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Gouffre de Ragefeu" WHERE id = 2437;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Bois de Chantenuit" WHERE id = 2457;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Mer voilée" WHERE id = 2477;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Morlos'Aran" WHERE id = 2478;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Sanctuaire d'émeraude" WHERE id = 2479;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Vallon des Jadefeu" WHERE id = 2480;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruines de Constellas" WHERE id = 2481;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Confins amers" WHERE id = 2497;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cime du Souilleur" WHERE id = 2517;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Pavillon de Lariss" WHERE id = 2518;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Collines des Griffebois" WHERE id = 2519;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tanière des Griffebois" WHERE id = 2520;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Verdantis" WHERE id = 2521;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruines d'Isildien" WHERE id = 2522;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Poste Totem sinistre" WHERE id = 2537;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp Aparaje" WHERE id = 2538;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Malaka'jin" WHERE id = 2539;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ravin des Eboulis" WHERE id = 2540;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Canyon de Sishir" WHERE id = 2541;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Hache-tripes" WHERE id = 2557;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ravin de Deuillevent" WHERE id = 2558;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Rivière Diamondhead" WHERE id = 2559;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp d'Ariden" WHERE id = 2560;
UPDATE `AreaTable_vanilla` SET name_loc2 = "L'Etau" WHERE id = 2561;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Karazhan" WHERE id = 2562;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le lopin de Morgan" WHERE id = 2563;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Hache-tripes" WHERE id = 2577;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Vallée d'Alterac" WHERE id = 2597;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp de Scrabblescrew" WHERE id = 2617;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Défilé des Jadefeu" WHERE id = 2618;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Thondroril" WHERE id = 2619;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Thondroril" WHERE id = 2620;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac Mereldar" WHERE id = 2621;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Balafre pestilentielle" WHERE id = 2622;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Balafre infecte" WHERE id = 2623;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Lac de Noirbois" WHERE id = 2624;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Porte du Mur d'est" WHERE id = 2625;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tunnel de Tisse-terreur" WHERE id = 2626;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Val-Terreur" WHERE id = 2627;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Donjon de Kargathia" WHERE id = 2637;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Vallée des ossements" WHERE id = 2657;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Repaire de l'Aile noire" WHERE id = 2677;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Croisée de l'homme mort" WHERE id = 2697;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cœur du Magma" WHERE id = 2717;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le Mur du scarabée" WHERE id = 2737;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Village de Sudevent" WHERE id = 2738;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Campement du crépuscule" WHERE id = 2739;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Vallée des cristaux" WHERE id = 2740;
UPDATE `AreaTable_vanilla` SET name_loc2 = "L'Estrade du scarabée" WHERE id = 2741;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruche'Ashi" WHERE id = 2742;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruche'Zora" WHERE id = 2743;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruche'Regal" WHERE id = 2744;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Autel du Guerrier mort" WHERE id = 2757;
UPDATE `AreaTable_vanilla` SET name_loc2 = "UNUSED Alterac Valley" WHERE id = 2777;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Profondeurs de Brassenoire" WHERE id = 2797;
UPDATE `AreaTable_vanilla` SET name_loc2 = "***Donjon sur la carte***" WHERE id = 2817;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La cave du maître" WHERE id = 2837;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Passage de Formepierre" WHERE id = 2838;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Vallée d'Alterac" WHERE id = 2839;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Cage des grondements" WHERE id = 2857;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Test de Chunk" WHERE id = 2877;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Avant-poste de Zoram'gar" WHERE id = 2897;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Hall des Légendes" WHERE id = 2917;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Hall des Champions" WHERE id = 2918;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Base des Grosh'gok" WHERE id = 2937;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Gorge endormie" WHERE id = 2938;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mine de Gouffrefer" WHERE id = 2957;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Avant-poste de Stonehearth" WHERE id = 2958;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Dun Baldar" WHERE id = 2959;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Défilé de l'Aile de glace" WHERE id = 2960;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Village Frostwolf" WHERE id = 2961;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Tour de la halte" WHERE id = 2962;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mine de Froide-dent" WHERE id = 2963;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Repaire des Winterax" WHERE id = 2964;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Garnison de Glace-sang" WHERE id = 2977;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Donjon Frostwolf" WHERE id = 2978;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ferme de Tor'kren" WHERE id = 2979;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Défilé de la Dague de givre" WHERE id = 3017;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp Rochefer" WHERE id = 3037;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cratère de Weazel" WHERE id = 3038;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruines de Tahonda" WHERE id = 3039;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Champ sanglant" WHERE id = 3057;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Caverne de l'Aile de glace" WHERE id = 3058;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le repos des vaillants" WHERE id = 3077;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le pilier grouillant" WHERE id = 3097;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Poste du Crépuscule" WHERE id = 3098;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Avant-poste du Crépuscule" WHERE id = 3099;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp du Crépuscule ravagé" WHERE id = 3100;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Antre de Shalzaru" WHERE id = 3117;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Halte de Talrendis" WHERE id = 3137;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Sanctuaire de Rethress" WHERE id = 3138;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Antre de l'Horreur lunaire" WHERE id = 3139;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Caverne de Barbe-d'écailles" WHERE id = 3140;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Caverne des Eboulis" WHERE id = 3157;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp de travail Warsong" WHERE id = 3177;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Camp du Noroît" WHERE id = 3197;
UPDATE `AreaTable_vanilla` SET name_loc2 = "L'Etripoir" WHERE id = 3217;
UPDATE `AreaTable_vanilla` SET name_loc2 = "L'Etripoir UNUSED" WHERE id = 3237;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Restes de Grakkarond" WHERE id = 3257;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Goulet des Warsong" WHERE id = 3277;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cimetière Frostwolf" WHERE id = 3297;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Col Frostwolf" WHERE id = 3298;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Col de Dun Baldar" WHERE id = 3299;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cimetière de Glace-sang" WHERE id = 3300;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cimetière des neiges" WHERE id = 3301;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cimetière de Stonehearth" WHERE id = 3302;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cimetière Stormpike" WHERE id = 3303;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Fortin de l'Aile de glace" WHERE id = 3304;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Fortin de Stoneheartth" WHERE id = 3305;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Crête des Follepattes" WHERE id = 3306;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Village des Revantusk" WHERE id = 3317;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Rocher de Durotan" WHERE id = 3318;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Bosquet d'Aile-argent" WHERE id = 3319;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Scierie des Warsong" WHERE id = 3320;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Fort d'Aile-argent" WHERE id = 3321;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Caverne des Follepattes" WHERE id = 3337;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La Faille voilée" WHERE id = 3338;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ile de Yojamba" WHERE id = 3357;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Bassin d'Arathi" WHERE id = 3358;
UPDATE `AreaTable_vanilla` SET name_loc2 = "L'Anneau" WHERE id = 3377;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Autel d'Hir'eek" WHERE id = 3378;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Shadra'zaar" WHERE id = 3379;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Terres hakkari" WHERE id = 3380;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Promontoire de Shirvallah" WHERE id = 3381;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Temple de Bethekk" WHERE id = 3382;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Fosse du Sang igné" WHERE id = 3383;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Autel du Dieu sanglant" WHERE id = 3384;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Cime de Zanza" WHERE id = 3397;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Frontière de la folie" WHERE id = 3398;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Salle de Trollbane" WHERE id = 3417;
UPDATE `AreaTable_vanilla` SET name_loc2 = "L'antre des Profanateurs" WHERE id = 3418;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Pointe de Pagle" WHERE id = 3419;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ferme" WHERE id = 3420;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Forge" WHERE id = 3421;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Scierie" WHERE id = 3422;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Mine d'or" WHERE id = 3423;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ecuries" WHERE id = 3424;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Fort cénarien" WHERE id = 3425;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Halte de Staghelm" WHERE id = 3426;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Campement de Bronzebeard" WHERE id = 3427;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ahn'Qiraj" WHERE id = 3428;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruines d'Ahn'Qiraj" WHERE id = 3429;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Défilé du Crépuscule" WHERE id = 3446;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La planque d'Ortell" WHERE id = 3447;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Terrasse du scarabée" WHERE id = 3448;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Terrasse du général" WHERE id = 3449;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Le réservoir" WHERE id = 3450;
UPDATE `AreaTable_vanilla` SET name_loc2 = "La chambre des œufs" WHERE id = 3451;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Les rayons" WHERE id = 3452;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Terrasse des guetteurs" WHERE id = 3453;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Ruines d'Ahn'Qiraj" WHERE id = 3454;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Naxxramas" WHERE id = 3456;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Capitales" WHERE id = 3459;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Portes d'Ahn'Qiraj" WHERE id = 3478;
UPDATE `AreaTable_vanilla` SET name_loc2 = "Manoir de Ravenholdt" WHERE id = 3486;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Dun Morogh" WHERE id = 1;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Longshore" WHERE id = 2;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ödland" WHERE id = 3;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Verwüstete Lande" WHERE id = 4;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schwarzmeerbucht" WHERE id = 7;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Sümpfe des Elends" WHERE id = 8;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Nordhaintal" WHERE id = 9;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Dämmerwald" WHERE id = 10;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Sumpfland" WHERE id = 11;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Wald von Elwynn" WHERE id = 12;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Weltbaum" WHERE id = 13;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Durotar" WHERE id = 14;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Marschen von Dustwallow" WHERE id = 15;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Azshara" WHERE id = 16;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Brachland" WHERE id = 17;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Kristallsee" WHERE id = 18;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Zul'Gurub" WHERE id = 19;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Moonbrook" WHERE id = 20;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Kul Tiras" WHERE id = 21;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Programmierer-Insel" WHERE id = 22;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Nordhain" WHERE id = 23;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Abtei von Nordhain" WHERE id = 24;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Blackrock" WHERE id = 25;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Leuchtturm" WHERE id = 26;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Westliche Pestländer" WHERE id = 28;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Nine" WHERE id = 30;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Friedhof" WHERE id = 32;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schlingendorntal" WHERE id = 33;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Echokammmine" WHERE id = 34;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Booty Bay" WHERE id = 35;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Alteracgebirge" WHERE id = 36;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Nazferitisee" WHERE id = 37;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Loch Modan" WHERE id = 38;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Westfall" WHERE id = 40;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Gebirgspass der Totenwinde" WHERE id = 41;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Dunkelhain" WHERE id = 42;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die wilden Ufer" WHERE id = 43;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Rotkammgebirge" WHERE id = 44;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Arathihochland" WHERE id = 45;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Brennende Steppe" WHERE id = 46;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Hinterland" WHERE id = 47;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Dead Man's Hole" WHERE id = 49;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Sengende Schlucht" WHERE id = 51;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Diebeslager" WHERE id = 53;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Jaspismine" WHERE id = 54;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Valley of Heroes UNUSED" WHERE id = 55;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Heldenwache" WHERE id = 56;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Tiefenschachtmine" WHERE id = 57;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Weinberge von Nordhain" WHERE id = 59;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Waldrand" WHERE id = 60;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Donnerfälle" WHERE id = 61;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Brackwells Kürbisbeet" WHERE id = 62;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Hof der Stonefields" WHERE id = 63;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Weinberge der Maclures" WHERE id = 64;
UPDATE `AreaTable_vanilla` SET name_loc3 = "***Dungeon auf Karte***" WHERE id = 65;
UPDATE `AreaTable_vanilla` SET name_loc3 = "***Dungeon auf Karte***" WHERE id = 66;
UPDATE `AreaTable_vanilla` SET name_loc3 = "***Dungeon auf Karte***" WHERE id = 67;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Immerruhsee" WHERE id = 68;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Seenhain" WHERE id = 69;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Steinwacht" WHERE id = 70;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Steinwachtfälle" WHERE id = 71;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Dunkle Portal" WHERE id = 72;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die faulende Narbe" WHERE id = 73;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Tränenteich" WHERE id = 74;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Stonard" WHERE id = 75;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Fallow Heiligtum" WHERE id = 76;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Anvilmar" WHERE id = 77;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Berge von Stormwind" WHERE id = 80;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Jeff NO-Quadrant geändert" WHERE id = 81;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Jeff NW-Quadrant" WHERE id = 82;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Jeff SO-Quadrant" WHERE id = 83;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Jeff SW-Quadrant" WHERE id = 84;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Tirisfal" WHERE id = 85;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Steinhügelsee" WHERE id = 86;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Goldhain" WHERE id = 87;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Holzfällerlager des Osttals" WHERE id = 88;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Obsthain am Spiegelsee" WHERE id = 89;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Turm von Azora" WHERE id = 91;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Spiegelsee" WHERE id = 92;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ogerhort Vul'Gol" WHERE id = 93;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Rabenflucht" WHERE id = 94;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Rotkammschlucht" WHERE id = 95;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Turm von Ilgalar" WHERE id = 96;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Althers Mühle" WHERE id = 97;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Rethbanhöhlen" WHERE id = 98;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Rebellenlager" WHERE id = 99;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Nesingwarys Expedition" WHERE id = 100;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Kurzens Truppenlager" WHERE id = 101;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ruinen von Zul'Kunda" WHERE id = 102;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ruinen von Zul'Mamwe" WHERE id = 103;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das finstere Riff" WHERE id = 104;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ogerhügel der Mosh'Ogg" WHERE id = 105;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Vorratslager" WHERE id = 106;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Saldeans Farm" WHERE id = 107;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Späherkuppe" WHERE id = 108;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Furlbrows Kürbishof" WHERE id = 109;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Jangoschacht" WHERE id = 111;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Goldküstensteinbruch" WHERE id = 113;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Leuchtturm von Westfall" WHERE id = 115;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das neblige Tal" WHERE id = 116;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Basislager von Grom'gol" WHERE id = 117;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Whelgars Ausgrabungsstätte" WHERE id = 118;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Weststromgarnison" WHERE id = 120;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Friedhof \"Stille Gärten\"" WHERE id = 121;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ruinen von Zuuldaia" WHERE id = 122;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ruinen von Bal'lal" WHERE id = 123;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ruinen von Kal'ai" WHERE id = 125;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ruinen von Tkashi" WHERE id = 126;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ruinen von Balia'mah" WHERE id = 127;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ruinen von Ziata'jai" WHERE id = 128;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ruinen von Mizjah" WHERE id = 129;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Silberwald" WHERE id = 130;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Kharanos" WHERE id = 131;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Coldridgetal" WHERE id = 132;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Gnomeregan" WHERE id = 133;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Gol'bolar Steinbruch" WHERE id = 134;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Höhle der Frostmane" WHERE id = 135;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Graufelsbau" WHERE id = 136;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Brewnall" WHERE id = 137;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Nebelfichtenzuflucht" WHERE id = 138;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Östliche Pestländer" WHERE id = 139;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Teldrassil" WHERE id = 141;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ironbands Ausgrabungsstätte" WHERE id = 142;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Festung Mo'grosh" WHERE id = 143;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Thelsamar" WHERE id = 144;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Algaz-Tor" WHERE id = 145;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Stonewroughtdamm" WHERE id = 146;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Weitschreiter-Lodge" WHERE id = 147;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Dunkelküste" WHERE id = 148;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Silberbachmine" WHERE id = 149;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Hafen von Menethil" WHERE id = 150;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Designer-Insel" WHERE id = 151;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Bollwerk" WHERE id = 152;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ruinen von Lordaeron" WHERE id = 153;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Deathknell" WHERE id = 154;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Nachtwebergrund" WHERE id = 155;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Sollidens Bauernhof" WHERE id = 156;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Agamands Mühlen" WHERE id = 157;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Gruft der Familie Agamand" WHERE id = 158;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Brill" WHERE id = 159;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Flüstergärten" WHERE id = 160;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Terrasse der Erholung" WHERE id = 161;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Blendwassersee" WHERE id = 162;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Gunthers Zufluchtsort" WHERE id = 163;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Garrens Schlupfwinkel" WHERE id = 164;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Balnirs Bauernhof" WHERE id = 165;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Coldhearth-Anwesen" WHERE id = 166;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Außenposten der Kreuzzügler" WHERE id = 167;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Nordküste" WHERE id = 168;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die stille Küste" WHERE id = 169;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Lordameresee" WHERE id = 170;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Insel Fenris" WHERE id = 172;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Faols Ruheplatz" WHERE id = 173;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Dolanaar" WHERE id = 186;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Darnassus UNUSED" WHERE id = 187;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Shadowglen" WHERE id = 188;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Steelgrills Depot" WHERE id = 189;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Hearthglen" WHERE id = 190;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Holzlager Northridge" WHERE id = 192;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Ruinen von Andorhal" WHERE id = 193;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schule der Totenbeschwörung" WHERE id = 195;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Uthers Grabmal" WHERE id = 196;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Trauerhügel" WHERE id = 197;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die weinende Höhle" WHERE id = 198;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Teufelssteinfeld" WHERE id = 199;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Dalsons Tränenfeld" WHERE id = 200;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Gahrrons Trauerfeld" WHERE id = 201;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das trostlose Feld" WHERE id = 202;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Burg Mardenholde" WHERE id = 203;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Pyrewood" WHERE id = 204;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Dun Modr" WHERE id = 205;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Westfall" WHERE id = 206;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das große Meer" WHERE id = 207;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ungenutzt - Ironcladbucht" WHERE id = 208;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Burg Shadowfang" WHERE id = 209;
UPDATE `AreaTable_vanilla` SET name_loc3 = "***Dungeon auf Karte***" WHERE id = 210;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Iceflowsee" WHERE id = 211;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Helmsbedsee" WHERE id = 212;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Tiefenfelsmine" WHERE id = 213;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das große Meer" WHERE id = 214;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Mulgore" WHERE id = 215;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Alexstons Bauernhof" WHERE id = 219;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Red Cloud Mesa" WHERE id = 220;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Camp Narache" WHERE id = 221;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Bloodhoof" WHERE id = 222;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Stonebullsee" WHERE id = 223;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Überfallene Karawane" WHERE id = 224;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Teufelsfelsen" WHERE id = 225;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Huschdunkel" WHERE id = 226;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Valgans Feld" WHERE id = 227;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Grabmal" WHERE id = 228;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Olsen's Farthing" WHERE id = 229;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Graumarnwall" WHERE id = 230;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Beren's Peril" WHERE id = 231;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Morgeninseln" WHERE id = 232;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ambermill" WHERE id = 233;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Burg Fenris" WHERE id = 235;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Burg Shadowfang" WHERE id = 236;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die verfallene Fähre" WHERE id = 237;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Maldens Obsthain" WHERE id = 238;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Ivar-Feld" WHERE id = 239;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Todesfeld" WHERE id = 240;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der verlassene Obstgarten" WHERE id = 241;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schattenhain" WHERE id = 242;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das verlassene Gut" WHERE id = 243;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Whipple-Besitz" WHERE id = 244;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Yorgens Bauernhof" WHERE id = 245;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Kessel" WHERE id = 246;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Grimesilt-Grabungsstätte" WHERE id = 247;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schreckensfels" WHERE id = 249;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Ruinen von Thaurissan" WHERE id = 250;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Flammenkamm" WHERE id = 251;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Festung der Blackrock" WHERE id = 252;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Aschensäule" WHERE id = 253;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Blackrock" WHERE id = 254;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Altar der Stürme" WHERE id = 255;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Aldrassil" WHERE id = 256;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schattenweberhöhle" WHERE id = 257;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Teufelsfels" WHERE id = 258;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Al'Amethsee" WHERE id = 259;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Starbreeze" WHERE id = 260;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Höhle der Knarzklauen" WHERE id = 261;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Grabhügel von Ban'ethil" WHERE id = 262;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Kluft" WHERE id = 263;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Lichtung des Orakels" WHERE id = 264;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Wellspring" WHERE id = 265;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Wellspringsee" WHERE id = 266;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Vorgebirge von Hillsbrad" WHERE id = 267;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Azshara-Krater" WHERE id = 268;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Dun Algaz" WHERE id = 269;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Southshore" WHERE id = 271;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Tarrens Mühle" WHERE id = 272;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Burg Durnholde" WHERE id = 275;
UPDATE `AreaTable_vanilla` SET name_loc3 = "UNUSED Stonewrought Pass" WHERE id = 276;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Vorgebirgshöhlen" WHERE id = 277;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Lordamere-Internierungslager" WHERE id = 278;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Dalaran" WHERE id = 279;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Strahnbrad" WHERE id = 280;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Ruinen von Alterac" WHERE id = 281;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Crushridgehöhle" WHERE id = 282;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schlächtergrotte" WHERE id = 283;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Oberland" WHERE id = 284;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Südwacht" WHERE id = 285;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Felder von Hillsbrad" WHERE id = 286;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Hillsbrad" WHERE id = 287;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Azurschacht" WHERE id = 288;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Nethander-Siedlung" WHERE id = 289;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Dun Garok" WHERE id = 290;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Thoradinswall" WHERE id = 293;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Oststrand" WHERE id = 294;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Weststrand" WHERE id = 295;
UPDATE `AreaTable_vanilla` SET name_loc3 = "South Seas UNUSED" WHERE id = 296;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Insel Jaguero" WHERE id = 297;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Baradinbucht" WHERE id = 298;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Bucht von Menethil" WHERE id = 299;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Nebelschilfstrand" WHERE id = 300;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die ungezähmte Küste" WHERE id = 301;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Kristallufer" WHERE id = 302;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Muschelschalenstrand" WHERE id = 303;
UPDATE `AreaTable_vanilla` SET name_loc3 = "North Tide's Run" WHERE id = 305;
UPDATE `AreaTable_vanilla` SET name_loc3 = "South Tide's Run" WHERE id = 306;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Aussichtsklippen" WHERE id = 307;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das verbotene Meer" WHERE id = 308;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ironbeards Grabmal" WHERE id = 309;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Kristalladermine" WHERE id = 310;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ruinen von Aboraz" WHERE id = 311;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Janeirospitze" WHERE id = 312;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Nordhof" WHERE id = 313;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Go'Sheks Hof" WHERE id = 314;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Bauernhof der Dabyries" WHERE id = 315;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Halle der Felsfäuste" WHERE id = 316;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Witherbark" WHERE id = 317;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schlucht der Trockenstoppel" WHERE id = 318;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Zuflucht" WHERE id = 320;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Hammerfall" WHERE id = 321;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schiffswracks der Schwarzmeerräuber" WHERE id = 322;
UPDATE `AreaTable_vanilla` SET name_loc3 = "O'Breens Lager" WHERE id = 323;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Burg Stromgarde" WHERE id = 324;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Turm von Arathor" WHERE id = 325;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Sanktum" WHERE id = 326;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Faldirbucht" WHERE id = 327;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das versunkene Riff" WHERE id = 328;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Thandol-Übergang" WHERE id = 330;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ashenvale" WHERE id = 331;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das große Meer" WHERE id = 332;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Kreis der östlichen Bindung" WHERE id = 333;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Kreis der westlichen Bindung" WHERE id = 334;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Kreis der inneren Bindung" WHERE id = 335;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Kreis der äußeren Bindung" WHERE id = 336;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Apocryphans Ruheplatz" WHERE id = 337;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Festung Angor" WHERE id = 338;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Lethlorklamm" WHERE id = 339;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Kargath" WHERE id = 340;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Camp Kosh" WHERE id = 341;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Camp Boff" WHERE id = 342;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Camp Wurg" WHERE id = 343;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Camp Cagg" WHERE id = 344;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Agmondkuppe" WHERE id = 345;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Hammertoes Grabungsstätte" WHERE id = 346;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Staubspeiergrotte" WHERE id = 347;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Aerie Peak" WHERE id = 348;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Burg Wildhammer" WHERE id = 349;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Quel'Danil-Hütte" WHERE id = 350;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Skulk Rock" WHERE id = 351;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Zun'watha" WHERE id = 352;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Shadra'Alor" WHERE id = 353;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Jintha'Alor" WHERE id = 354;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Altar von Zul" WHERE id = 355;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Seradane" WHERE id = 356;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Feralas" WHERE id = 357;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Dornrankenklamm" WHERE id = 358;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Bael Modan" WHERE id = 359;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Mine der Venture Co." WHERE id = 360;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Teufelswald" WHERE id = 361;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Klingenhügel" WHERE id = 362;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Tal der Prüfungen" WHERE id = 363;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Höhlenbau" WHERE id = 364;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Koven der Brennenden Klinge" WHERE id = 365;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Kolkarklippe" WHERE id = 366;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Sen'jin" WHERE id = 367;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Echoinseln" WHERE id = 368;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Donnergrat" WHERE id = 369;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Staubwindklamm" WHERE id = 370;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Staubwindhöhle" WHERE id = 371;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Burg Tiragarde" WHERE id = 372;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schipperküste" WHERE id = 373;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Messerbucht" WHERE id = 374;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Killrogs Küste" WHERE id = 375;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Südstrom" WHERE id = 377;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Camp Taurajo" WHERE id = 378;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Farwatch-Posten" WHERE id = 379;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Crossroads" WHERE id = 380;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Felsadermine" WHERE id = 381;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Schlickermoor" WHERE id = 382;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die trockenen Hügel" WHERE id = 383;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Glutnebelgipfel" WHERE id = 384;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Feste Northwatch" WHERE id = 385;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die vergessenen Teiche" WHERE id = 386;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die blühende Oase" WHERE id = 387;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die brackige Oase" WHERE id = 388;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Feld der Riesen" WHERE id = 390;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Händlerküste" WHERE id = 391;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ratchet" WHERE id = 392;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Strand der Darkspear" WHERE id = 393;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Darrowmere Lake UNUSED" WHERE id = 394;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Caer Darrow UNUSED" WHERE id = 395;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Wasserbrunnen von Winterhoof" WHERE id = 396;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Wasserbrunnen von Thunderhorn" WHERE id = 397;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Wasserbrunnen von Wildmane" WHERE id = 398;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Skylineridge" WHERE id = 399;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Tausend Nadeln" WHERE id = 400;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Tidusstaffel" WHERE id = 401;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Gasthaus Zur süßen Ruh" WHERE id = 403;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Grabungsstätte von Bael'dun" WHERE id = 404;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Desolace" WHERE id = 405;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Steinkrallengebirge" WHERE id = 406;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Orgrimmar UNUSED" WHERE id = 407;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Gillijims Insel" WHERE id = 408;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Insel des Doktor Lapidis" WHERE id = 409;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Klingenschlucht" WHERE id = 410;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Bathrans Schlupfwinkel" WHERE id = 411;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Ruinen von Ordil'Aran" WHERE id = 412;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Maestras Posten" WHERE id = 413;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Zoramstrand" WHERE id = 414;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Astranaar" WHERE id = 415;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Schrein von Aessina" WHERE id = 416;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schrein des sengenden Feuers" WHERE id = 417;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Sternenstaubruinen" WHERE id = 418;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das heulende Tal" WHERE id = 419;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Silberwindzuflucht" WHERE id = 420;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Mystralsee" WHERE id = 421;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Himmelssturzsee" WHERE id = 422;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Irissee" WHERE id = 424;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Mondbrunnen" WHERE id = 425;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Raynewood" WHERE id = 426;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Schattenwinkel" WHERE id = 427;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Nachtflucht" WHERE id = 428;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Xavian" WHERE id = 429;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Satyrnaar" WHERE id = 430;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Splintertreeposten" WHERE id = 431;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Dor'danil-Grabhügel" WHERE id = 432;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Falfarren" WHERE id = 433;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Felfire Hill" WHERE id = 434;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Dämonensturz" WHERE id = 435;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Dämonenstieg" WHERE id = 436;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Holzfällerlager der Warsong" WHERE id = 437;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schattengrün" WHERE id = 438;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die schimmernde Ebene" WHERE id = 439;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Tanaris" WHERE id = 440;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Falathimsee" WHERE id = 441;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Auberdine" WHERE id = 442;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Ruinen von Mathystra" WHERE id = 443;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Turm von Althalaxx" WHERE id = 444;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Cliffspring Falls" WHERE id = 445;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Bashal'Aran" WHERE id = 446;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ameth'Aran" WHERE id = 447;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Hain der Uralten" WHERE id = 448;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Meistergleve" WHERE id = 449;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Remtravels Ausgrabung" WHERE id = 450;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Nebelrand" WHERE id = 452;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der lange Strand" WHERE id = 453;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Wildschnellen" WHERE id = 454;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Bau der Schwarzfelle" WHERE id = 455;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Cliffspring" WHERE id = 456;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das verhüllte Meer" WHERE id = 457;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Goldstraße" WHERE id = 458;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Scharlachroter Wachposten" WHERE id = 459;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Sonnenfels" WHERE id = 460;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Scherwindklippe" WHERE id = 461;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Felskesselsee" WHERE id = 463;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Mirkfallonsee" WHERE id = 464;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das verbrannte Tal" WHERE id = 465;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Tal der Blutfurien" WHERE id = 466;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Steinkrallengipfel" WHERE id = 467;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Krallenbau" WHERE id = 468;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Hochwipfeltal" WHERE id = 469;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Thunder Bluff UNUSED" WHERE id = 470;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Brave Wind Mesa" WHERE id = 471;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Fire Stone Mesa" WHERE id = 472;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Mantle Rock" WHERE id = 473;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Hunter Rise UNUSED" WHERE id = 474;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Spirit RiseUNUSED" WHERE id = 475;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Elder RiseUNUSED" WHERE id = 476;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ruinen von Jubuwal" WHERE id = 477;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Teiche von Arlithrien" WHERE id = 478;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Rustmaul-Grabungsstätte" WHERE id = 479;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Camp E'thok" WHERE id = 480;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Spalthufklippe" WHERE id = 481;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Steilhang" WHERE id = 482;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der kreischende Canyon" WHERE id = 483;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Freiwindposten" WHERE id = 484;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der große Aufzug" WHERE id = 485;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Galakhöhle" WHERE id = 486;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Bau der Wildfedern" WHERE id = 487;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Wetterwinkel" WHERE id = 488;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Thalanaar" WHERE id = 489;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Un'Goro-Krater" WHERE id = 490;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Kral von Razorfen" WHERE id = 491;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Friedhof von Rabenflucht" WHERE id = 492;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Moonglade" WHERE id = 493;
UPDATE `AreaTable_vanilla` SET name_loc3 = "DELETE ME" WHERE id = 495;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Brackenwall" WHERE id = 496;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Swamplight-Anwesen" WHERE id = 497;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Blutsumpfbau" WHERE id = 498;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Graunebelhöhlen" WHERE id = 499;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Moggle-Spitze" WHERE id = 500;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Beezils Wrack" WHERE id = 501;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Hexenhügel" WHERE id = 502;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Späherwacht" WHERE id = 503;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Nordwacht" WHERE id = 504;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Westwacht" WHERE id = 505;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die verlassene Wacht" WHERE id = 506;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Blaumoor" WHERE id = 507;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Stonemaul Ruinen" WHERE id = 508;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Flammenbau" WHERE id = 509;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Drachendüster" WHERE id = 510;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Drachensumpf" WHERE id = 511;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Onyxia's Lair UNUSED" WHERE id = 512;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Insel Theramore" WHERE id = 513;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Foothold-Zitadelle" WHERE id = 514;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ironclad-Gefängnis" WHERE id = 515;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Dustwallow Bay" WHERE id = 516;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Tidefury-Bucht" WHERE id = 517;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Dreadmurk Shore" WHERE id = 518;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Addles Siedlung" WHERE id = 536;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Feuerfedergrat" WHERE id = 537;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Teergruben von Lakkari" WHERE id = 538;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Terrorflucht" WHERE id = 539;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die wuchernde Narbe" WHERE id = 540;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Marshals Zuflucht" WHERE id = 541;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Fungusfels" WHERE id = 542;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die heißen Quellen von Golakka" WHERE id = 543;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Loch" WHERE id = 556;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Bettlerschlupfwinkel" WHERE id = 576;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Kodofriedhof" WHERE id = 596;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Geistwandlerposten" WHERE id = 597;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Sar'theris-Strand" WHERE id = 598;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Festung Thunder Axe" WHERE id = 599;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Bolgans Loch" WHERE id = 600;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Mannorocs Koven" WHERE id = 602;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Sargeron" WHERE id = 603;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Magram" WHERE id = 604;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Gelkis" WHERE id = 606;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Tal der Speere" WHERE id = 607;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Nijelspitze" WHERE id = 608;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Kolkar" WHERE id = 609;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Hyjal" WHERE id = 616;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Winterspring" WHERE id = 618;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schwarzwolfschnellen" WHERE id = 636;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Kodofels" WHERE id = 637;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Verborgener Pfad" WHERE id = 638;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Geisterfelsen" WHERE id = 639;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schrein der schlafenden Flamme" WHERE id = 640;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Elune'ara See" WHERE id = 656;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der sichere Hafen" WHERE id = 657;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Scherbenwelt" WHERE id = 676;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Craftsmen's Terrace UNUSED" WHERE id = 696;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Tradesmen's Terrace UNUSED" WHERE id = 697;
UPDATE `AreaTable_vanilla` SET name_loc3 = "The Temple Gardens UNUSED" WHERE id = 698;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Temple of Elune UNUSED" WHERE id = 699;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Cenarion Enclave UNUSED" WHERE id = 700;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Warrior's Terrace UNUSED" WHERE id = 701;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Rut'theran" WHERE id = 702;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ironbands Truppenlager" WHERE id = 716;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Verlies" WHERE id = 717;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Höhlen des Wehklagens" WHERE id = 718;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Blackfathom-Tiefe" WHERE id = 719;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Prügel-Eiland" WHERE id = 720;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Gnomeregan" WHERE id = 721;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Hügel von Razorfen" WHERE id = 722;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ban'ethil Hollow" WHERE id = 736;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das scharlachrote Kloster" WHERE id = 796;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Jerods Anlegestelle" WHERE id = 797;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Kammwacht" WHERE id = 798;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das dunkle Ufer" WHERE id = 799;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Coldridgepass" WHERE id = 800;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Chillbreezetal" WHERE id = 801;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schimmergrat" WHERE id = 802;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Amberstill-Ranch" WHERE id = 803;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Tundrid-Hügel" WHERE id = 804;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Südtorpass" WHERE id = 805;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Südtoraußenposten" WHERE id = 806;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Nordtorpass" WHERE id = 807;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Nordtoraußenposten" WHERE id = 808;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Tore von Ironforge" WHERE id = 809;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Stillwassertümpel" WHERE id = 810;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Alptraumtal" WHERE id = 811;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Giftwebertal" WHERE id = 812;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Bollwerk" WHERE id = 813;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Südstrom" WHERE id = 814;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Südstrom" WHERE id = 815;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Revier der Grimmhauer" WHERE id = 816;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Knochenhöhle" WHERE id = 817;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Bleichmähnenfels" WHERE id = 818;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Windfurienkamm" WHERE id = 819;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die goldenen Ebenen" WHERE id = 820;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die wogenden Ebenen" WHERE id = 821;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Dun Algaz" WHERE id = 836;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Dun Algaz" WHERE id = 837;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Nordtorpass" WHERE id = 838;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Südtorpass" WHERE id = 839;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Zwielichtshain" WHERE id = 856;
UPDATE `AreaTable_vanilla` SET name_loc3 = "GM-Insel" WHERE id = 876;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Delete ME" WHERE id = 877;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Südstrom" WHERE id = 878;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Südstrom" WHERE id = 879;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Thandol-Übergang" WHERE id = 880;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Thandol-Übergang" WHERE id = 881;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Fegefeuer-Insel" WHERE id = 896;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Jansens Siedlung" WHERE id = 916;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Todesacker" WHERE id = 917;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Molsens Hof" WHERE id = 918;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Stendels Tümpel" WHERE id = 919;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Dolchhügel" WHERE id = 920;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Demonts Heim" WHERE id = 921;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Staubebenen" WHERE id = 922;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Splittersteintal" WHERE id = 923;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Tal der Könige" WHERE id = 924;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Station Algaz" WHERE id = 925;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Bucklebree-Hof" WHERE id = 926;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der leuchtende Strand" WHERE id = 927;
UPDATE `AreaTable_vanilla` SET name_loc3 = "North Tide's Hollow" WHERE id = 928;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Grautatzengrat" WHERE id = 936;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die saftgrünen Felder" WHERE id = 956;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Gadgetzan" WHERE id = 976;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Steamwheedle" WHERE id = 977;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Zul'Farrak" WHERE id = 978;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Sandsorrow-Wache" WHERE id = 979;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Disteltal" WHERE id = 980;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die klaffende Schlucht" WHERE id = 981;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der giftige Unterschlupf" WHERE id = 982;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Truppenlager der Dünenbrecher" WHERE id = 983;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ostmondruinen" WHERE id = 984;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Waterspring-Feld" WHERE id = 985;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Zalashjis Bau" WHERE id = 986;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Landendestrand" WHERE id = 987;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Wellenschreiterstrand" WHERE id = 988;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Uldum" WHERE id = 989;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Tal der Behüter" WHERE id = 990;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Gunstans Posten" WHERE id = 991;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Südmondruinen" WHERE id = 992;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Renders Lager" WHERE id = 996;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Renders Tal" WHERE id = 997;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Renders Fels" WHERE id = 998;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Turm der Steinwacht" WHERE id = 999;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Galardelltal" WHERE id = 1000;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Uferpfad" WHERE id = 1001;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Drei Ecken" WHERE id = 1002;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Direforge Hill" WHERE id = 1016;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Raptorgrat" WHERE id = 1017;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schwarzkanalmarschen" WHERE id = 1018;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der grüne Gürtel" WHERE id = 1019;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Moosfellmoor" WHERE id = 1020;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Thelgenfelsen" WHERE id = 1021;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Blaukiemenmarschen" WHERE id = 1022;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Salzgischtschlucht" WHERE id = 1023;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Sonnenwendmarschen" WHERE id = 1024;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der grüne Gürtel" WHERE id = 1025;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Angerfang-Lager" WHERE id = 1036;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Grim Batol" WHERE id = 1037;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Tore der Dragonmaw" WHERE id = 1038;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die verlorene Flotte" WHERE id = 1039;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Darrow Hill" WHERE id = 1056;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Thoradinswall" WHERE id = 1057;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Weberpass" WHERE id = 1076;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das stille Ufer" WHERE id = 1097;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Anwesen der Mistmantles" WHERE id = 1098;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Camp Mojache" WHERE id = 1099;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Truppenlager der Grimmtotem" WHERE id = 1100;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die verwundene Tiefe" WHERE id = 1101;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Wildwindsee" WHERE id = 1102;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Außenposten der Gordunni" WHERE id = 1103;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Mok'Gordun" WHERE id = 1104;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Wildschrammtal" WHERE id = 1105;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Fransenfederhochland" WHERE id = 1106;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Idlewindsee" WHERE id = 1107;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die vergessene Küste" WHERE id = 1108;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ostsäule" WHERE id = 1109;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Westsäule" WHERE id = 1110;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Traum-Geäst" WHERE id = 1111;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Jademirsee" WHERE id = 1112;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Oneiros" WHERE id = 1113;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ruinen von Rabenwind" WHERE id = 1114;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Wutschrammfeste" WHERE id = 1115;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Festung Feathermoon" WHERE id = 1116;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ruinen von Solarsal" WHERE id = 1117;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Lower Wilds UNUSED" WHERE id = 1118;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Zwillingskolosse" WHERE id = 1119;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Insel Sardor" WHERE id = 1120;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Insel des Schreckens" WHERE id = 1121;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die obere Wildnis" WHERE id = 1136;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die untere Wildnis" WHERE id = 1137;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Südliches Brachland" WHERE id = 1156;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Südliche Goldstraße" WHERE id = 1157;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Zul'Farrak" WHERE id = 1176;
UPDATE `AreaTable_vanilla` SET name_loc3 = "UNUSEDAlcaz Island" WHERE id = 1196;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Holzschlundfeste" WHERE id = 1216;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Vanndir-Lager" WHERE id = 1217;
UPDATE `AreaTable_vanilla` SET name_loc3 = "TESTAzshara" WHERE id = 1218;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Lager der Legashi" WHERE id = 1219;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Thalassischer Stützpunkt" WHERE id = 1220;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Ruinen von Eldarath" WHERE id = 1221;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Hetaeras Gelege" WHERE id = 1222;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Tempel von Zin-Malor" WHERE id = 1223;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Bärenkopf" WHERE id = 1224;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ursolan" WHERE id = 1225;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Tempel von Arkkoran" WHERE id = 1226;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Bucht der Stürme" WHERE id = 1227;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der zertrümmerte Strand" WHERE id = 1228;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Turm von Eldara" WHERE id = 1229;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Gezacktes Riff" WHERE id = 1230;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Southridge-Strand" WHERE id = 1231;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ravencrest-Monument" WHERE id = 1232;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der einsame Grat" WHERE id = 1233;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Mennarsee" WHERE id = 1234;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Shadowsong-Schrein" WHERE id = 1235;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Lager der Haldarr" WHERE id = 1236;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Valormok" WHERE id = 1237;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die verfallenen Gegenden" WHERE id = 1256;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Steinkrallenpfad" WHERE id = 1276;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Steinkrallenpfad" WHERE id = 1277;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Felshauerhof" WHERE id = 1296;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Scheckeneberhof" WHERE id = 1297;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Hügel von Razorfen" WHERE id = 1316;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Lost-Rigger-Bucht" WHERE id = 1336;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Uldaman" WHERE id = 1337;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Lordameresee" WHERE id = 1338;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Lordameresee" WHERE id = 1339;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Galgeneck" WHERE id = 1357;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Silithus" WHERE id = 1377;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Smaragdwald" WHERE id = 1397;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Versunkener Tempel" WHERE id = 1417;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Feste Schreckensfels" WHERE id = 1437;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Burg Nethergarde" WHERE id = 1438;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schreckensfelsposten" WHERE id = 1439;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schlangenschlinge" WHERE id = 1440;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Altar der Stürme" WHERE id = 1441;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Firewatchgrat" WHERE id = 1442;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Schlackengrube" WHERE id = 1443;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Meer der Asche" WHERE id = 1444;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Blackrock" WHERE id = 1445;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Thoriumspitze" WHERE id = 1446;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Garnison-Waffenkammer" WHERE id = 1457;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Tempel von Atal'Hakkar" WHERE id = 1477;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Undercity" WHERE id = 1497;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Uldaman" WHERE id = 1517;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Nicht benutzt - Todesminen" WHERE id = 1518;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Stormwind" WHERE id = 1519;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ironforge" WHERE id = 1537;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Spalthufhöhle" WHERE id = 1557;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Kap des Schlingendorntals" WHERE id = 1577;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Südliche ungezähmte Küste" WHERE id = 1578;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Unused The Deadmines 002" WHERE id = 1579;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Unused Ironclad Cove 003" WHERE id = 1580;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Todesminen" WHERE id = 1581;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ironcladbucht" WHERE id = 1582;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Blackrockspitze" WHERE id = 1583;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Blackrocktiefen" WHERE id = 1584;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Raptor Grounds UNUSED" WHERE id = 1597;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Grol'dom Hof UNUSED" WHERE id = 1598;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Mor'shan-Stützpunkt" WHERE id = 1599;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Honor's Stand UNUSED" WHERE id = 1600;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Blackthorn Ridge UNUSED" WHERE id = 1601;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Bramblescar UNUSED" WHERE id = 1602;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Agama'gor UNUSED" WHERE id = 1603;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Tal der Helden" WHERE id = 1617;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Orgrimmar" WHERE id = 1637;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Thunder Bluff" WHERE id = 1638;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Anhöhe der Ältesten" WHERE id = 1639;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Anhöhe der Geister" WHERE id = 1640;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Anhöhe der Jäger" WHERE id = 1641;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Darnassus" WHERE id = 1657;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Enklave des Cenarius" WHERE id = 1658;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Terrasse der Handwerker" WHERE id = 1659;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Terrasse der Krieger" WHERE id = 1660;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Tempelgärten" WHERE id = 1661;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Terrasse der Händler" WHERE id = 1662;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Gavins Landspitze" WHERE id = 1677;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Soferas Landspitze" WHERE id = 1678;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Corrahns Dolch" WHERE id = 1679;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Landzunge" WHERE id = 1680;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Nebelufer" WHERE id = 1681;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Dandreds Senke" WHERE id = 1682;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Growlesshöhle" WHERE id = 1683;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Chillwindspitze" WHERE id = 1684;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Raptorgründe" WHERE id = 1697;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Dornennarbe" WHERE id = 1698;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Dornenhügel" WHERE id = 1699;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Agama'gor" WHERE id = 1700;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schwarzdorngrat" WHERE id = 1701;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ehrenmal" WHERE id = 1702;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Mor'shan-Schutzwall" WHERE id = 1703;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Grol'doms Hof" WHERE id = 1704;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Kral von Razorfen" WHERE id = 1717;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der große Aufzug" WHERE id = 1718;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Nebeltal" WHERE id = 1737;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Nek'maniquellbrunnen" WHERE id = 1738;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Truppenlager der Blutsegelbukaniere" WHERE id = 1739;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Stützpunkt der Venture Co." WHERE id = 1740;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Arena der Gurubashi" WHERE id = 1741;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Geisterhöhlenbau" WHERE id = 1742;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die CRIMSON VEIL" WHERE id = 1757;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die RIPTIDE" WHERE id = 1758;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die DAMSEL'S LUCK" WHERE id = 1759;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Arbeitszentrale der Venture Co." WHERE id = 1760;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Lager der Totenwaldfelle" WHERE id = 1761;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Revier der Teufelspfoten" WHERE id = 1762;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Jaedenar" WHERE id = 1763;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Blutgiftbach" WHERE id = 1764;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Blutgiftfälle" WHERE id = 1765;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Narbengrund" WHERE id = 1766;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Eisenwald" WHERE id = 1767;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Eisenstammhöhle" WHERE id = 1768;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Holzschlundfeste" WHERE id = 1769;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schattenfeste" WHERE id = 1770;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schrein des Betrügers" WHERE id = 1771;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Itharius' Höhle" WHERE id = 1777;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Sorgendunkel" WHERE id = 1778;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Draenil'dur" WHERE id = 1779;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Splitterspeerkreuzung" WHERE id = 1780;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Stagalsumpf" WHERE id = 1797;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Wabersumpf" WHERE id = 1798;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Stagalsumpfhöhle" WHERE id = 1817;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Witherbarkhöhlen" WHERE id = 1837;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Thoradinswall" WHERE id = 1857;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Fels'gor" WHERE id = 1858;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Fangzahntal" WHERE id = 1877;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Staubschüssel" WHERE id = 1878;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Illusionenebene" WHERE id = 1879;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Federbarts Hütte" WHERE id = 1880;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Shindiggers Lager" WHERE id = 1881;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Seuchennebelklamm" WHERE id = 1882;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ehrenwindsee" WHERE id = 1883;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Agol'watha" WHERE id = 1884;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Hiri'watha" WHERE id = 1885;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Gruselruinen" WHERE id = 1886;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Bogens Kante" WHERE id = 1887;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Terrasse des Schöpfers" WHERE id = 1897;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Staubwindschlucht" WHERE id = 1898;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Shaol'watha" WHERE id = 1917;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Tagschattenruinen" WHERE id = 1937;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Zerbrochene Säule" WHERE id = 1938;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die ewigen Sande" WHERE id = 1939;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Südbrandung" WHERE id = 1940;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Höhlen der Zeit" WHERE id = 1941;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Marschen" WHERE id = 1942;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Eisensteinplateau" WHERE id = 1943;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Blackcharhöhle" WHERE id = 1957;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Tanners Lager" WHERE id = 1958;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Staubfeuertal" WHERE id = 1959;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Zul'Gurub" WHERE id = 1977;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Nebelschilfposten" WHERE id = 1978;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Blutgiftposten" WHERE id = 1997;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Nachtlaublichtung" WHERE id = 1998;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Stratholme" WHERE id = 2017;
UPDATE `AreaTable_vanilla` SET name_loc3 = "UNUSEDShadowfang Keep 003" WHERE id = 2037;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Scholomance" WHERE id = 2057;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Zwielichttal" WHERE id = 2077;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Zwielichtufer" WHERE id = 2078;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Insel Alcaz" WHERE id = 2079;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Düsterwolkengipfel" WHERE id = 2097;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Katakomben des Morgenwaldes" WHERE id = 2098;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Burg Steinwacht" WHERE id = 2099;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Maraudon" WHERE id = 2100;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Gasthof Zum Starkbier-Lager" WHERE id = 2101;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Brauerei Donnerbräu" WHERE id = 2102;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Burg Menethil" WHERE id = 2103;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Deepwater Taverne" WHERE id = 2104;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schattengrab" WHERE id = 2117;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Rathaus von Brill" WHERE id = 2118;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Taverne Zur Galgenschlinge" WHERE id = 2119;
UPDATE `AreaTable_vanilla` SET name_loc3 = "The Pools of VisionUNUSED" WHERE id = 2137;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Glutnebelbau" WHERE id = 2138;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Burg Bael'dun" WHERE id = 2157;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Aschenschwingens Bau" WHERE id = 2158;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Onyxias Hort" WHERE id = 2159;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Scherwindmine" WHERE id = 2160;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Rolands Verdammnis" WHERE id = 2161;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Kampfring" WHERE id = 2177;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Teiche der Visionen" WHERE id = 2197;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Shadowbreakklamm" WHERE id = 2198;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Bruchspeeringen" WHERE id = 2217;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Weißgipfelposten" WHERE id = 2237;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Gornia" WHERE id = 2238;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Zanes-Auge-Krater" WHERE id = 2239;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Illusionenrennbahn" WHERE id = 2240;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Frostsäblerfelsen" WHERE id = 2241;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der versteckte Hain" WHERE id = 2242;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Holzschlundposten" WHERE id = 2243;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Lager der Winterfelle" WHERE id = 2244;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Mazthoril" WHERE id = 2245;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Frostfeuerquellen" WHERE id = 2246;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Eisdistelberge" WHERE id = 2247;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Dun Mandarr" WHERE id = 2248;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Frostwhisperschlucht" WHERE id = 2249;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Eulenflügeldickicht" WHERE id = 2250;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Kel'Therilsee" WHERE id = 2251;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Ruinen von Kel'Theril" WHERE id = 2252;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Starfall" WHERE id = 2253;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Grabhügel von Ban'Thallow" WHERE id = 2254;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Everlook" WHERE id = 2255;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die flüsternde Schlucht" WHERE id = 2256;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Tiefenbahn" WHERE id = 2257;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Fungustal" WHERE id = 2258;
UPDATE `AreaTable_vanilla` SET name_loc3 = "UNUSEDThe Marris Stead" WHERE id = 2259;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Marris' Siedlung" WHERE id = 2260;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Tiefgewölbe" WHERE id = 2261;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Darrowshire" WHERE id = 2262;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Turm der Kronenwache" WHERE id = 2263;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Corins Kreuzung" WHERE id = 2264;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Scharlachroter Stützpunkt" WHERE id = 2265;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Tyrs Hand" WHERE id = 2266;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die scharlachrote Basilika" WHERE id = 2267;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Kapelle des hoffnungsvollen Lichts" WHERE id = 2268;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Braumanns Mühle" WHERE id = 2269;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das giftige Tal" WHERE id = 2270;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ostwallturm" WHERE id = 2271;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Nordtal" WHERE id = 2272;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Zul'Mashar" WHERE id = 2273;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Mazra'Alor" WHERE id = 2274;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Nordpassturm" WHERE id = 2275;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Quel'Lithien-Lodge" WHERE id = 2276;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Pestwald" WHERE id = 2277;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Geißelfeste" WHERE id = 2278;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Stratholme" WHERE id = 2279;
UPDATE `AreaTable_vanilla` SET name_loc3 = "UNUSED Stratholme" WHERE id = 2280;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Darrowmeresee" WHERE id = 2297;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Caer Darrow" WHERE id = 2298;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Darrowmeresee" WHERE id = 2299;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Höhlen der Zeit" WHERE id = 2300;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Lager der Distelfelle" WHERE id = 2301;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Morast" WHERE id = 2302;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schlucht der heulenden Winde" WHERE id = 2303;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die südlichen Meere" WHERE id = 2317;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das große Meer" WHERE id = 2318;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das große Meer" WHERE id = 2319;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das große Meer" WHERE id = 2320;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das große Meer" WHERE id = 2321;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das verhüllte Meer" WHERE id = 2322;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das verhüllte Meer" WHERE id = 2323;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das verhüllte Meer" WHERE id = 2324;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das verhüllte Meer" WHERE id = 2325;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das verhüllte Meer" WHERE id = 2326;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Kaserne von Klingenhügel" WHERE id = 2337;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die südlichen Meere" WHERE id = 2338;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das große Meer" WHERE id = 2339;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Blutreißers Lager" WHERE id = 2357;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Forest Song" WHERE id = 2358;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Laubtatzenlichtung" WHERE id = 2359;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Außenposten der Silverwing" WHERE id = 2360;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Nighthaven" WHERE id = 2361;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Schrein von Remulos" WHERE id = 2362;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Stormrage Grabhügel" WHERE id = 2363;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das große Meer" WHERE id = 2364;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das große Meer" WHERE id = 2365;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das schwarze Fenn" WHERE id = 2366;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die alten Vorgebirge von Hillsbrad" WHERE id = 2367;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Tarrens Mühle" WHERE id = 2368;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Southshore" WHERE id = 2369;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Burg Durnholde" WHERE id = 2370;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Dun Garok" WHERE id = 2371;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Felder von Hillsbrad" WHERE id = 2372;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Oststrand" WHERE id = 2373;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Nethander-Siedlung" WHERE id = 2374;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Darrow Hill" WHERE id = 2375;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Südwacht" WHERE id = 2376;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Thoradinswall" WHERE id = 2377;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Weststrand" WHERE id = 2378;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Azurschacht" WHERE id = 2379;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das große Meer" WHERE id = 2397;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das große Meer" WHERE id = 2398;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das große Meer" WHERE id = 2399;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das verbotene Meer" WHERE id = 2400;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das verbotene Meer" WHERE id = 2401;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das verbotene Meer" WHERE id = 2402;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das verbotene Meer" WHERE id = 2403;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Tethris Aran" WHERE id = 2404;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ethel Rethor" WHERE id = 2405;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Insel Ranazjar" WHERE id = 2406;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Kormeks Hütte" WHERE id = 2407;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Shadowprey" WHERE id = 2408;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Blackrockpass" WHERE id = 2417;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Morgans Wacht" WHERE id = 2418;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schlitterfels" WHERE id = 2419;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schreckenspfad" WHERE id = 2420;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Draco'dar" WHERE id = 2421;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ragefireabgrund" WHERE id = 2437;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Nightsongwälder" WHERE id = 2457;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das verhüllte Meer" WHERE id = 2477;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Morlos'Aran" WHERE id = 2478;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Smaragdrefugium" WHERE id = 2479;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Jadefeuertal" WHERE id = 2480;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ruinen von Constellas" WHERE id = 2481;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Bittere Landzunge" WHERE id = 2497;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Anhöhe des Entweihers" WHERE id = 2517;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Lariss' Pavillon" WHERE id = 2518;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Waldpfotenhügel" WHERE id = 2519;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Waldpfotenbau" WHERE id = 2520;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Verdantis" WHERE id = 2521;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ruinen von Isildien" WHERE id = 2522;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Posten der Grimmtotem" WHERE id = 2537;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Camp Aparaje" WHERE id = 2538;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Malaka'jin" WHERE id = 2539;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Steinschlagklamm" WHERE id = 2540;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Sishircanyon" WHERE id = 2541;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Düsterbruch" WHERE id = 2557;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schlucht der Totenwinde" WHERE id = 2558;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Diamondhead" WHERE id = 2559;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Aridens Lager" WHERE id = 2560;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Laster" WHERE id = 2561;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Karazhan" WHERE id = 2562;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Morgan's Plot" WHERE id = 2563;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Düsterbruch" WHERE id = 2577;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Alteractal" WHERE id = 2597;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Scrabblescrews Lager" WHERE id = 2617;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Jadefeuerbach" WHERE id = 2618;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Thondroril" WHERE id = 2619;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Thondroril" WHERE id = 2620;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Mereldarsee" WHERE id = 2621;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Pestilenznarbe" WHERE id = 2622;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Infektnarbe" WHERE id = 2623;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Blackwoodsee" WHERE id = 2624;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ostwalltor" WHERE id = 2625;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Terrorweb-Tunnel" WHERE id = 2626;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schreckenstal" WHERE id = 2627;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Burg Kargathia" WHERE id = 2637;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Tal der Knochen" WHERE id = 2657;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Pechschwingenhort" WHERE id = 2677;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Totmannsfurt" WHERE id = 2697;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Geschmolzener Kern" WHERE id = 2717;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Skarabäuswall" WHERE id = 2737;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Südwindposten" WHERE id = 2738;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Basislager der Twilight" WHERE id = 2739;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Kristalltal" WHERE id = 2740;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Skarabäushöhe" WHERE id = 2741;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Bau des Ashischwarms" WHERE id = 2742;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Bau des Zoraschwarms" WHERE id = 2743;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Bau des Regalschwarms" WHERE id = 2744;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schrein des gefallenen Kriegers" WHERE id = 2757;
UPDATE `AreaTable_vanilla` SET name_loc3 = "UNUSED Alterac Valley" WHERE id = 2777;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Blackfathom-Tiefe" WHERE id = 2797;
UPDATE `AreaTable_vanilla` SET name_loc3 = "***Dungeon auf Karte***" WHERE id = 2817;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Keller des Meisters" WHERE id = 2837;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Stonewroughtpass" WHERE id = 2838;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Alteractal" WHERE id = 2839;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Der Rumblekäfig" WHERE id = 2857;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Brocken-Test" WHERE id = 2877;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Zoram'gar-Außenposten" WHERE id = 2897;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Halle der Legenden" WHERE id = 2917;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Halle der Champions" WHERE id = 2918;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Grosh'gok Lager" WHERE id = 2937;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die schlummernde Schlucht" WHERE id = 2938;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Irondeep-Mine" WHERE id = 2957;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Stonehearth-Außenposten" WHERE id = 2958;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Dun Baldar" WHERE id = 2959;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Icewingpass" WHERE id = 2960;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Frostwolf" WHERE id = 2961;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Turmstellung" WHERE id = 2962;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Coldtooth-Mine" WHERE id = 2963;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Feste der Winterax" WHERE id = 2964;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Iceblood-Garnison" WHERE id = 2977;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Burg Frostwolf" WHERE id = 2978;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Tor'krens Hof" WHERE id = 2979;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Frostdagger-Pass" WHERE id = 3017;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Eisensteinlager" WHERE id = 3037;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Weazels Krater" WHERE id = 3038;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ruinen von Tahonda" WHERE id = 3039;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Feld des Kampfes" WHERE id = 3057;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Icewinghöhle" WHERE id = 3058;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Heldenwacht" WHERE id = 3077;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Schwarmsäule" WHERE id = 3097;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Twilight-Posten" WHERE id = 3098;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Twilight-Außenposten" WHERE id = 3099;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Verwüsteter Twilight-Stützpunkt" WHERE id = 3100;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Shalzarus Unterschlupf" WHERE id = 3117;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Talrendisspitze" WHERE id = 3137;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Rethress Sanktum" WHERE id = 3138;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Mondschreckensbau" WHERE id = 3139;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schuppenbarts Höhle" WHERE id = 3140;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Steinschlaghöhle" WHERE id = 3157;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Lager der Warsongarbeiter" WHERE id = 3177;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Chillwind-Lager" WHERE id = 3197;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Schlägergrube" WHERE id = 3217;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Schlägergrube" WHERE id = 3237;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Knochen von Grakkarond" WHERE id = 3257;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Warsongschlucht" WHERE id = 3277;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Friedhof der Frostwolf" WHERE id = 3297;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Frostwolfpass" WHERE id = 3298;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Pass von Dun Baldar" WHERE id = 3299;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Iceblood-Friedhof" WHERE id = 3300;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Snowfall-Friedhof" WHERE id = 3301;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Stonehearth-Friedhof" WHERE id = 3302;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Stormpike-Friedhof" WHERE id = 3303;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Icewing-Bunker" WHERE id = 3304;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Stonehearth-Bunker" WHERE id = 3305;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Wildpfotengrat" WHERE id = 3306;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Revantusk" WHERE id = 3317;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Fels von Durotan" WHERE id = 3318;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Hain der Silverwing" WHERE id = 3319;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Sägewerk der Warsong" WHERE id = 3320;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Feste Silverwing" WHERE id = 3321;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Höhle der Wildpfoten" WHERE id = 3337;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die verhüllte Kluft" WHERE id = 3338;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Insel Yojamba" WHERE id = 3357;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Arathibecken" WHERE id = 3358;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Windung" WHERE id = 3377;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Altar von Hir'eek" WHERE id = 3378;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Shadra'zaar" WHERE id = 3379;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Hakkarigründe" WHERE id = 3380;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Landspitze Shirvallahs" WHERE id = 3381;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Tempel von Bethekk" WHERE id = 3382;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Blutfeuergrube" WHERE id = 3383;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Altar des Blutgottes" WHERE id = 3384;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Zanzas Anhöhe" WHERE id = 3397;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Rand des Wahnsinns" WHERE id = 3398;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Trollbanes Halle" WHERE id = 3417;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die entweihte Feste" WHERE id = 3418;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Pagles Spitze" WHERE id = 3419;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Hof" WHERE id = 3420;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Schmiede" WHERE id = 3421;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Sägewerk" WHERE id = 3422;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Goldmine" WHERE id = 3423;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ställe" WHERE id = 3424;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Burg Cenarius" WHERE id = 3425;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Staghelms Stätte" WHERE id = 3426;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Bronzebeards Lager" WHERE id = 3427;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ahn'Qiraj" WHERE id = 3428;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ruinen von Ahn'Qiraj" WHERE id = 3429;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Kavernen der Twilight" WHERE id = 3446;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ortells Unterschlupf" WHERE id = 3447;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Skarabäusterrasse" WHERE id = 3448;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Terrasse des Generals" WHERE id = 3449;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Das Reservoir" WHERE id = 3450;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Brutstätte" WHERE id = 3451;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Die Wabenkammer" WHERE id = 3452;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Terrasse der Wächter" WHERE id = 3453;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ruinen von Ahn'Qiraj" WHERE id = 3454;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Naxxramas" WHERE id = 3456;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Hauptstädte" WHERE id = 3459;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Tore von Ahn'Qiraj" WHERE id = 3478;
UPDATE `AreaTable_vanilla` SET name_loc3 = "Ravenholdt-Anwesen" WHERE id = 3486;
UPDATE `AreaTable_vanilla` SET name_loc4 = "丹莫罗" WHERE id = 1;
UPDATE `AreaTable_vanilla` SET name_loc4 = "长滩" WHERE id = 2;
UPDATE `AreaTable_vanilla` SET name_loc4 = "荒芜之地" WHERE id = 3;
UPDATE `AreaTable_vanilla` SET name_loc4 = "诅咒之地" WHERE id = 4;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黑水湾" WHERE id = 7;
UPDATE `AreaTable_vanilla` SET name_loc4 = "悲伤沼泽" WHERE id = 8;
UPDATE `AreaTable_vanilla` SET name_loc4 = "北郡山谷" WHERE id = 9;
UPDATE `AreaTable_vanilla` SET name_loc4 = "暮色森林" WHERE id = 10;
UPDATE `AreaTable_vanilla` SET name_loc4 = "湿地" WHERE id = 11;
UPDATE `AreaTable_vanilla` SET name_loc4 = "艾尔文森林" WHERE id = 12;
UPDATE `AreaTable_vanilla` SET name_loc4 = "世界之树" WHERE id = 13;
UPDATE `AreaTable_vanilla` SET name_loc4 = "杜隆塔尔" WHERE id = 14;
UPDATE `AreaTable_vanilla` SET name_loc4 = "尘泥沼泽" WHERE id = 15;
UPDATE `AreaTable_vanilla` SET name_loc4 = "艾萨拉" WHERE id = 16;
UPDATE `AreaTable_vanilla` SET name_loc4 = "贫瘠之地" WHERE id = 17;
UPDATE `AreaTable_vanilla` SET name_loc4 = "水晶湖" WHERE id = 18;
UPDATE `AreaTable_vanilla` SET name_loc4 = "祖尔格拉布" WHERE id = 19;
UPDATE `AreaTable_vanilla` SET name_loc4 = "月溪镇" WHERE id = 20;
UPDATE `AreaTable_vanilla` SET name_loc4 = "库尔提拉斯" WHERE id = 21;
UPDATE `AreaTable_vanilla` SET name_loc4 = "Programmer Isle" WHERE id = 22;
UPDATE `AreaTable_vanilla` SET name_loc4 = "北郡河" WHERE id = 23;
UPDATE `AreaTable_vanilla` SET name_loc4 = "北郡修道院" WHERE id = 24;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黑石山" WHERE id = 25;
UPDATE `AreaTable_vanilla` SET name_loc4 = "灯塔" WHERE id = 26;
UPDATE `AreaTable_vanilla` SET name_loc4 = "西瘟疫之地" WHERE id = 28;
UPDATE `AreaTable_vanilla` SET name_loc4 = "Nine" WHERE id = 30;
UPDATE `AreaTable_vanilla` SET name_loc4 = "大墓地" WHERE id = 32;
UPDATE `AreaTable_vanilla` SET name_loc4 = "荆棘谷" WHERE id = 33;
UPDATE `AreaTable_vanilla` SET name_loc4 = "回音山矿洞" WHERE id = 34;
UPDATE `AreaTable_vanilla` SET name_loc4 = "藏宝海湾" WHERE id = 35;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奥特兰克山脉" WHERE id = 36;
UPDATE `AreaTable_vanilla` SET name_loc4 = "纳菲瑞提湖" WHERE id = 37;
UPDATE `AreaTable_vanilla` SET name_loc4 = "洛克莫丹" WHERE id = 38;
UPDATE `AreaTable_vanilla` SET name_loc4 = "西部荒野" WHERE id = 40;
UPDATE `AreaTable_vanilla` SET name_loc4 = "逆风小径" WHERE id = 41;
UPDATE `AreaTable_vanilla` SET name_loc4 = "夜色镇" WHERE id = 42;
UPDATE `AreaTable_vanilla` SET name_loc4 = "蛮荒海岸" WHERE id = 43;
UPDATE `AreaTable_vanilla` SET name_loc4 = "赤脊山" WHERE id = 44;
UPDATE `AreaTable_vanilla` SET name_loc4 = "阿拉希高地" WHERE id = 45;
UPDATE `AreaTable_vanilla` SET name_loc4 = "燃烧平原" WHERE id = 46;
UPDATE `AreaTable_vanilla` SET name_loc4 = "辛特兰" WHERE id = 47;
UPDATE `AreaTable_vanilla` SET name_loc4 = "亡者之穴" WHERE id = 49;
UPDATE `AreaTable_vanilla` SET name_loc4 = "灼热峡谷" WHERE id = 51;
UPDATE `AreaTable_vanilla` SET name_loc4 = "盗贼营地" WHERE id = 53;
UPDATE `AreaTable_vanilla` SET name_loc4 = "玉石矿洞" WHERE id = 54;
UPDATE `AreaTable_vanilla` SET name_loc4 = "英雄谷UNUSED" WHERE id = 55;
UPDATE `AreaTable_vanilla` SET name_loc4 = "英雄哨岗" WHERE id = 56;
UPDATE `AreaTable_vanilla` SET name_loc4 = "法戈第矿洞" WHERE id = 57;
UPDATE `AreaTable_vanilla` SET name_loc4 = "北郡农场" WHERE id = 59;
UPDATE `AreaTable_vanilla` SET name_loc4 = "林边空地" WHERE id = 60;
UPDATE `AreaTable_vanilla` SET name_loc4 = "雷霆瀑布" WHERE id = 61;
UPDATE `AreaTable_vanilla` SET name_loc4 = "布莱克威尔南瓜田" WHERE id = 62;
UPDATE `AreaTable_vanilla` SET name_loc4 = "斯通菲尔德农场" WHERE id = 63;
UPDATE `AreaTable_vanilla` SET name_loc4 = "马科伦农场" WHERE id = 64;
UPDATE `AreaTable_vanilla` SET name_loc4 = "***大型地下城***" WHERE id = 65;
UPDATE `AreaTable_vanilla` SET name_loc4 = "***大型地下城***" WHERE id = 66;
UPDATE `AreaTable_vanilla` SET name_loc4 = "***大型地下城***" WHERE id = 67;
UPDATE `AreaTable_vanilla` SET name_loc4 = "止水湖" WHERE id = 68;
UPDATE `AreaTable_vanilla` SET name_loc4 = "湖畔镇" WHERE id = 69;
UPDATE `AreaTable_vanilla` SET name_loc4 = "石堡" WHERE id = 70;
UPDATE `AreaTable_vanilla` SET name_loc4 = "石堡瀑布" WHERE id = 71;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黑暗之门" WHERE id = 72;
UPDATE `AreaTable_vanilla` SET name_loc4 = "腐烂之痕" WHERE id = 73;
UPDATE `AreaTable_vanilla` SET name_loc4 = "泪水之池" WHERE id = 74;
UPDATE `AreaTable_vanilla` SET name_loc4 = "斯通纳德" WHERE id = 75;
UPDATE `AreaTable_vanilla` SET name_loc4 = "农田避难所" WHERE id = 76;
UPDATE `AreaTable_vanilla` SET name_loc4 = "安威玛尔" WHERE id = 77;
UPDATE `AreaTable_vanilla` SET name_loc4 = "暴风山脉" WHERE id = 80;
UPDATE `AreaTable_vanilla` SET name_loc4 = "Jeff NE Quadrant" WHERE id = 81;
UPDATE `AreaTable_vanilla` SET name_loc4 = "Jeff NW Quadrant" WHERE id = 82;
UPDATE `AreaTable_vanilla` SET name_loc4 = "Jeff SE Quadrant" WHERE id = 83;
UPDATE `AreaTable_vanilla` SET name_loc4 = "Jeff SW Quadrant" WHERE id = 84;
UPDATE `AreaTable_vanilla` SET name_loc4 = "提瑞斯法林地" WHERE id = 85;
UPDATE `AreaTable_vanilla` SET name_loc4 = "石碑湖" WHERE id = 86;
UPDATE `AreaTable_vanilla` SET name_loc4 = "闪金镇" WHERE id = 87;
UPDATE `AreaTable_vanilla` SET name_loc4 = "东谷伐木场" WHERE id = 88;
UPDATE `AreaTable_vanilla` SET name_loc4 = "明镜湖果园" WHERE id = 89;
UPDATE `AreaTable_vanilla` SET name_loc4 = "阿祖拉之塔" WHERE id = 91;
UPDATE `AreaTable_vanilla` SET name_loc4 = "明镜湖" WHERE id = 92;
UPDATE `AreaTable_vanilla` SET name_loc4 = "沃古尔食人魔山" WHERE id = 93;
UPDATE `AreaTable_vanilla` SET name_loc4 = "乌鸦岭" WHERE id = 94;
UPDATE `AreaTable_vanilla` SET name_loc4 = "赤脊峡谷" WHERE id = 95;
UPDATE `AreaTable_vanilla` SET name_loc4 = "伊尔加拉之塔" WHERE id = 96;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奥瑟尔伐木场" WHERE id = 97;
UPDATE `AreaTable_vanilla` SET name_loc4 = "瑞斯班洞穴" WHERE id = 98;
UPDATE `AreaTable_vanilla` SET name_loc4 = "反抗军营地" WHERE id = 99;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奈辛瓦里远征队营地" WHERE id = 100;
UPDATE `AreaTable_vanilla` SET name_loc4 = "库尔森的营地" WHERE id = 101;
UPDATE `AreaTable_vanilla` SET name_loc4 = "祖昆达废墟" WHERE id = 102;
UPDATE `AreaTable_vanilla` SET name_loc4 = "祖玛维废墟" WHERE id = 103;
UPDATE `AreaTable_vanilla` SET name_loc4 = "暗礁海" WHERE id = 104;
UPDATE `AreaTable_vanilla` SET name_loc4 = "莫什奥格食人魔山" WHERE id = 105;
UPDATE `AreaTable_vanilla` SET name_loc4 = "储藏室" WHERE id = 106;
UPDATE `AreaTable_vanilla` SET name_loc4 = "萨丁农场" WHERE id = 107;
UPDATE `AreaTable_vanilla` SET name_loc4 = "哨兵岭" WHERE id = 108;
UPDATE `AreaTable_vanilla` SET name_loc4 = "法布隆南瓜农场" WHERE id = 109;
UPDATE `AreaTable_vanilla` SET name_loc4 = "詹戈洛德矿洞" WHERE id = 111;
UPDATE `AreaTable_vanilla` SET name_loc4 = "金海岸矿洞" WHERE id = 113;
UPDATE `AreaTable_vanilla` SET name_loc4 = "西部荒野灯塔" WHERE id = 115;
UPDATE `AreaTable_vanilla` SET name_loc4 = "迷雾谷" WHERE id = 116;
UPDATE `AreaTable_vanilla` SET name_loc4 = "格罗姆高营地" WHERE id = 117;
UPDATE `AreaTable_vanilla` SET name_loc4 = "维尔加挖掘场" WHERE id = 118;
UPDATE `AreaTable_vanilla` SET name_loc4 = "西泉要塞" WHERE id = 120;
UPDATE `AreaTable_vanilla` SET name_loc4 = "静谧花园墓场" WHERE id = 121;
UPDATE `AreaTable_vanilla` SET name_loc4 = "祖丹亚废墟" WHERE id = 122;
UPDATE `AreaTable_vanilla` SET name_loc4 = "巴拉尔废墟" WHERE id = 123;
UPDATE `AreaTable_vanilla` SET name_loc4 = "卡莱废墟" WHERE id = 125;
UPDATE `AreaTable_vanilla` SET name_loc4 = "伽什废墟" WHERE id = 126;
UPDATE `AreaTable_vanilla` SET name_loc4 = "巴里亚曼废墟" WHERE id = 127;
UPDATE `AreaTable_vanilla` SET name_loc4 = "赞塔加废墟" WHERE id = 128;
UPDATE `AreaTable_vanilla` SET name_loc4 = "米扎废墟" WHERE id = 129;
UPDATE `AreaTable_vanilla` SET name_loc4 = "银松森林" WHERE id = 130;
UPDATE `AreaTable_vanilla` SET name_loc4 = "卡拉诺斯" WHERE id = 131;
UPDATE `AreaTable_vanilla` SET name_loc4 = "寒脊山谷" WHERE id = 132;
UPDATE `AreaTable_vanilla` SET name_loc4 = "诺莫瑞根" WHERE id = 133;
UPDATE `AreaTable_vanilla` SET name_loc4 = "古博拉采掘场" WHERE id = 134;
UPDATE `AreaTable_vanilla` SET name_loc4 = "霜鬃巨魔要塞" WHERE id = 135;
UPDATE `AreaTable_vanilla` SET name_loc4 = "灰色洞穴" WHERE id = 136;
UPDATE `AreaTable_vanilla` SET name_loc4 = "烈酒村" WHERE id = 137;
UPDATE `AreaTable_vanilla` SET name_loc4 = "雾松避难所" WHERE id = 138;
UPDATE `AreaTable_vanilla` SET name_loc4 = "东瘟疫之地" WHERE id = 139;
UPDATE `AreaTable_vanilla` SET name_loc4 = "泰达希尔" WHERE id = 141;
UPDATE `AreaTable_vanilla` SET name_loc4 = "铁环挖掘场" WHERE id = 142;
UPDATE `AreaTable_vanilla` SET name_loc4 = "莫格罗什要塞" WHERE id = 143;
UPDATE `AreaTable_vanilla` SET name_loc4 = "塞尔萨玛" WHERE id = 144;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奥加兹大门" WHERE id = 145;
UPDATE `AreaTable_vanilla` SET name_loc4 = "巨石水坝" WHERE id = 146;
UPDATE `AreaTable_vanilla` SET name_loc4 = "旅行者营地" WHERE id = 147;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黑海岸" WHERE id = 148;
UPDATE `AreaTable_vanilla` SET name_loc4 = "银泉矿洞" WHERE id = 149;
UPDATE `AreaTable_vanilla` SET name_loc4 = "米奈希尔港" WHERE id = 150;
UPDATE `AreaTable_vanilla` SET name_loc4 = "Designer Island" WHERE id = 151;
UPDATE `AreaTable_vanilla` SET name_loc4 = "亡灵壁垒" WHERE id = 152;
UPDATE `AreaTable_vanilla` SET name_loc4 = "洛丹伦废墟" WHERE id = 153;
UPDATE `AreaTable_vanilla` SET name_loc4 = "丧钟镇" WHERE id = 154;
UPDATE `AreaTable_vanilla` SET name_loc4 = "夜行蜘蛛洞穴" WHERE id = 155;
UPDATE `AreaTable_vanilla` SET name_loc4 = "索利丹农场" WHERE id = 156;
UPDATE `AreaTable_vanilla` SET name_loc4 = "阿加曼德磨坊" WHERE id = 157;
UPDATE `AreaTable_vanilla` SET name_loc4 = "阿加曼德家族墓穴" WHERE id = 158;
UPDATE `AreaTable_vanilla` SET name_loc4 = "布瑞尔" WHERE id = 159;
UPDATE `AreaTable_vanilla` SET name_loc4 = "耳语花园" WHERE id = 160;
UPDATE `AreaTable_vanilla` SET name_loc4 = "休息区" WHERE id = 161;
UPDATE `AreaTable_vanilla` SET name_loc4 = "澈水湖" WHERE id = 162;
UPDATE `AreaTable_vanilla` SET name_loc4 = "冈瑟尔的居所" WHERE id = 163;
UPDATE `AreaTable_vanilla` SET name_loc4 = "加伦鬼屋" WHERE id = 164;
UPDATE `AreaTable_vanilla` SET name_loc4 = "巴尼尔农场" WHERE id = 165;
UPDATE `AreaTable_vanilla` SET name_loc4 = "炉灰庄园" WHERE id = 166;
UPDATE `AreaTable_vanilla` SET name_loc4 = "十字军前哨" WHERE id = 167;
UPDATE `AreaTable_vanilla` SET name_loc4 = "北部海岸" WHERE id = 168;
UPDATE `AreaTable_vanilla` SET name_loc4 = "耳语海岸" WHERE id = 169;
UPDATE `AreaTable_vanilla` SET name_loc4 = "洛丹米尔湖" WHERE id = 170;
UPDATE `AreaTable_vanilla` SET name_loc4 = "芬里斯岛" WHERE id = 172;
UPDATE `AreaTable_vanilla` SET name_loc4 = "法奥之墓" WHERE id = 173;
UPDATE `AreaTable_vanilla` SET name_loc4 = "多兰纳尔" WHERE id = 186;
UPDATE `AreaTable_vanilla` SET name_loc4 = "Darnassus UNUSED" WHERE id = 187;
UPDATE `AreaTable_vanilla` SET name_loc4 = "幽影谷" WHERE id = 188;
UPDATE `AreaTable_vanilla` SET name_loc4 = "钢架补给站" WHERE id = 189;
UPDATE `AreaTable_vanilla` SET name_loc4 = "壁炉谷" WHERE id = 190;
UPDATE `AreaTable_vanilla` SET name_loc4 = "北山伐木场" WHERE id = 192;
UPDATE `AreaTable_vanilla` SET name_loc4 = "安多哈尔废墟" WHERE id = 193;
UPDATE `AreaTable_vanilla` SET name_loc4 = "通灵术学校" WHERE id = 195;
UPDATE `AreaTable_vanilla` SET name_loc4 = "乌瑟尔之墓" WHERE id = 196;
UPDATE `AreaTable_vanilla` SET name_loc4 = "悔恨岭" WHERE id = 197;
UPDATE `AreaTable_vanilla` SET name_loc4 = "哭泣之洞" WHERE id = 198;
UPDATE `AreaTable_vanilla` SET name_loc4 = "费尔斯通农场" WHERE id = 199;
UPDATE `AreaTable_vanilla` SET name_loc4 = "达尔松之泪" WHERE id = 200;
UPDATE `AreaTable_vanilla` SET name_loc4 = "盖罗恩农场" WHERE id = 201;
UPDATE `AreaTable_vanilla` SET name_loc4 = "嚎哭鬼屋" WHERE id = 202;
UPDATE `AreaTable_vanilla` SET name_loc4 = "玛登霍尔德城堡" WHERE id = 203;
UPDATE `AreaTable_vanilla` SET name_loc4 = "焚木村" WHERE id = 204;
UPDATE `AreaTable_vanilla` SET name_loc4 = "丹莫德" WHERE id = 205;
UPDATE `AreaTable_vanilla` SET name_loc4 = "西部荒野" WHERE id = 206;
UPDATE `AreaTable_vanilla` SET name_loc4 = "无尽之海" WHERE id = 207;
UPDATE `AreaTable_vanilla` SET name_loc4 = "铁甲山谷" WHERE id = 208;
UPDATE `AreaTable_vanilla` SET name_loc4 = "影牙城堡" WHERE id = 209;
UPDATE `AreaTable_vanilla` SET name_loc4 = "***大型地下城***" WHERE id = 210;
UPDATE `AreaTable_vanilla` SET name_loc4 = "涌冰湖" WHERE id = 211;
UPDATE `AreaTable_vanilla` SET name_loc4 = "盔枕湖" WHERE id = 212;
UPDATE `AreaTable_vanilla` SET name_loc4 = "埃利姆矿洞" WHERE id = 213;
UPDATE `AreaTable_vanilla` SET name_loc4 = "无尽之海" WHERE id = 214;
UPDATE `AreaTable_vanilla` SET name_loc4 = "莫高雷" WHERE id = 215;
UPDATE `AreaTable_vanilla` SET name_loc4 = "阿历克斯顿农场" WHERE id = 219;
UPDATE `AreaTable_vanilla` SET name_loc4 = "红云台地" WHERE id = 220;
UPDATE `AreaTable_vanilla` SET name_loc4 = "纳拉其营地" WHERE id = 221;
UPDATE `AreaTable_vanilla` SET name_loc4 = "血蹄村" WHERE id = 222;
UPDATE `AreaTable_vanilla` SET name_loc4 = "石牛湖" WHERE id = 223;
UPDATE `AreaTable_vanilla` SET name_loc4 = "被破坏的货车" WHERE id = 224;
UPDATE `AreaTable_vanilla` SET name_loc4 = "赤色石" WHERE id = 225;
UPDATE `AreaTable_vanilla` SET name_loc4 = "粘丝洞" WHERE id = 226;
UPDATE `AreaTable_vanilla` SET name_loc4 = "瓦尔甘牧场" WHERE id = 227;
UPDATE `AreaTable_vanilla` SET name_loc4 = "瑟伯切尔" WHERE id = 228;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奥森农场" WHERE id = 229;
UPDATE `AreaTable_vanilla` SET name_loc4 = "格雷迈恩之墙" WHERE id = 230;
UPDATE `AreaTable_vanilla` SET name_loc4 = "博伦的巢穴" WHERE id = 231;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黎明岛" WHERE id = 232;
UPDATE `AreaTable_vanilla` SET name_loc4 = "安伯米尔" WHERE id = 233;
UPDATE `AreaTable_vanilla` SET name_loc4 = "芬里斯城堡" WHERE id = 235;
UPDATE `AreaTable_vanilla` SET name_loc4 = "影牙城堡" WHERE id = 236;
UPDATE `AreaTable_vanilla` SET name_loc4 = "破旧渡口" WHERE id = 237;
UPDATE `AreaTable_vanilla` SET name_loc4 = "玛尔丁果园" WHERE id = 238;
UPDATE `AreaTable_vanilla` SET name_loc4 = "伊瓦农场" WHERE id = 239;
UPDATE `AreaTable_vanilla` SET name_loc4 = "亡者农场" WHERE id = 240;
UPDATE `AreaTable_vanilla` SET name_loc4 = "烂果园" WHERE id = 241;
UPDATE `AreaTable_vanilla` SET name_loc4 = "阳光树林" WHERE id = 242;
UPDATE `AreaTable_vanilla` SET name_loc4 = "荒弃鬼屋" WHERE id = 243;
UPDATE `AreaTable_vanilla` SET name_loc4 = "维普尔庄园" WHERE id = 244;
UPDATE `AreaTable_vanilla` SET name_loc4 = "约根农场" WHERE id = 245;
UPDATE `AreaTable_vanilla` SET name_loc4 = "大熔炉" WHERE id = 246;
UPDATE `AreaTable_vanilla` SET name_loc4 = "煤渣挖掘场" WHERE id = 247;
UPDATE `AreaTable_vanilla` SET name_loc4 = "巨槌石" WHERE id = 249;
UPDATE `AreaTable_vanilla` SET name_loc4 = "索瑞森废墟" WHERE id = 250;
UPDATE `AreaTable_vanilla` SET name_loc4 = "烈焰峰" WHERE id = 251;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黑石要塞" WHERE id = 252;
UPDATE `AreaTable_vanilla` SET name_loc4 = "灰烬之柱" WHERE id = 253;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黑石山" WHERE id = 254;
UPDATE `AreaTable_vanilla` SET name_loc4 = "风暴祭坛" WHERE id = 255;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奥达希尔" WHERE id = 256;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黑丝洞" WHERE id = 257;
UPDATE `AreaTable_vanilla` SET name_loc4 = "地狱石" WHERE id = 258;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奥拉密斯湖" WHERE id = 259;
UPDATE `AreaTable_vanilla` SET name_loc4 = "星风村" WHERE id = 260;
UPDATE `AreaTable_vanilla` SET name_loc4 = "脊骨堡" WHERE id = 261;
UPDATE `AreaTable_vanilla` SET name_loc4 = "班奈希尔兽穴" WHERE id = 262;
UPDATE `AreaTable_vanilla` SET name_loc4 = "大断崖" WHERE id = 263;
UPDATE `AreaTable_vanilla` SET name_loc4 = "神谕林地" WHERE id = 264;
UPDATE `AreaTable_vanilla` SET name_loc4 = "涌泉河" WHERE id = 265;
UPDATE `AreaTable_vanilla` SET name_loc4 = "涌泉湖" WHERE id = 266;
UPDATE `AreaTable_vanilla` SET name_loc4 = "希尔斯布莱德丘陵" WHERE id = 267;
UPDATE `AreaTable_vanilla` SET name_loc4 = "积雪平原" WHERE id = 268;
UPDATE `AreaTable_vanilla` SET name_loc4 = "丹奥加兹" WHERE id = 269;
UPDATE `AreaTable_vanilla` SET name_loc4 = "南海镇" WHERE id = 271;
UPDATE `AreaTable_vanilla` SET name_loc4 = "塔伦米尔" WHERE id = 272;
UPDATE `AreaTable_vanilla` SET name_loc4 = "敦霍尔德城堡" WHERE id = 275;
UPDATE `AreaTable_vanilla` SET name_loc4 = "石坝小径UNUSED" WHERE id = 276;
UPDATE `AreaTable_vanilla` SET name_loc4 = "丘陵洞穴" WHERE id = 277;
UPDATE `AreaTable_vanilla` SET name_loc4 = "洛丹米尔收容所" WHERE id = 278;
UPDATE `AreaTable_vanilla` SET name_loc4 = "达拉然" WHERE id = 279;
UPDATE `AreaTable_vanilla` SET name_loc4 = "斯坦恩布莱德" WHERE id = 280;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奥特兰克废墟" WHERE id = 281;
UPDATE `AreaTable_vanilla` SET name_loc4 = "破碎岭城堡" WHERE id = 282;
UPDATE `AreaTable_vanilla` SET name_loc4 = "屠杀谷" WHERE id = 283;
UPDATE `AreaTable_vanilla` SET name_loc4 = "高地" WHERE id = 284;
UPDATE `AreaTable_vanilla` SET name_loc4 = "南点哨塔" WHERE id = 285;
UPDATE `AreaTable_vanilla` SET name_loc4 = "希尔斯布莱德农场" WHERE id = 286;
UPDATE `AreaTable_vanilla` SET name_loc4 = "希尔斯布莱德" WHERE id = 287;
UPDATE `AreaTable_vanilla` SET name_loc4 = "碧玉矿洞" WHERE id = 288;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奈杉德哨岗" WHERE id = 289;
UPDATE `AreaTable_vanilla` SET name_loc4 = "丹加洛克" WHERE id = 290;
UPDATE `AreaTable_vanilla` SET name_loc4 = "索拉丁之墙" WHERE id = 293;
UPDATE `AreaTable_vanilla` SET name_loc4 = "东部海滩" WHERE id = 294;
UPDATE `AreaTable_vanilla` SET name_loc4 = "西部海岸" WHERE id = 295;
UPDATE `AreaTable_vanilla` SET name_loc4 = "South Seas UNUSED" WHERE id = 296;
UPDATE `AreaTable_vanilla` SET name_loc4 = "哈圭罗岛" WHERE id = 297;
UPDATE `AreaTable_vanilla` SET name_loc4 = "巴拉丁海湾" WHERE id = 298;
UPDATE `AreaTable_vanilla` SET name_loc4 = "米奈希尔海湾" WHERE id = 299;
UPDATE `AreaTable_vanilla` SET name_loc4 = "芦苇海滩" WHERE id = 300;
UPDATE `AreaTable_vanilla` SET name_loc4 = "野人海岸" WHERE id = 301;
UPDATE `AreaTable_vanilla` SET name_loc4 = "水晶海岸" WHERE id = 302;
UPDATE `AreaTable_vanilla` SET name_loc4 = "贝壳海滩" WHERE id = 303;
UPDATE `AreaTable_vanilla` SET name_loc4 = "北流海岸" WHERE id = 305;
UPDATE `AreaTable_vanilla` SET name_loc4 = "南流海岸" WHERE id = 306;
UPDATE `AreaTable_vanilla` SET name_loc4 = "望海崖" WHERE id = 307;
UPDATE `AreaTable_vanilla` SET name_loc4 = "禁忌之海" WHERE id = 308;
UPDATE `AreaTable_vanilla` SET name_loc4 = "铁须之墓" WHERE id = 309;
UPDATE `AreaTable_vanilla` SET name_loc4 = "水晶矿洞" WHERE id = 310;
UPDATE `AreaTable_vanilla` SET name_loc4 = "阿博拉兹废墟" WHERE id = 311;
UPDATE `AreaTable_vanilla` SET name_loc4 = "加尼罗哨站" WHERE id = 312;
UPDATE `AreaTable_vanilla` SET name_loc4 = "诺斯弗德农场" WHERE id = 313;
UPDATE `AreaTable_vanilla` SET name_loc4 = "格沙克农场" WHERE id = 314;
UPDATE `AreaTable_vanilla` SET name_loc4 = "达比雷农场" WHERE id = 315;
UPDATE `AreaTable_vanilla` SET name_loc4 = "石拳大厅" WHERE id = 316;
UPDATE `AreaTable_vanilla` SET name_loc4 = "枯木村" WHERE id = 317;
UPDATE `AreaTable_vanilla` SET name_loc4 = "枯须峡谷" WHERE id = 318;
UPDATE `AreaTable_vanilla` SET name_loc4 = "避难谷地" WHERE id = 320;
UPDATE `AreaTable_vanilla` SET name_loc4 = "落锤镇" WHERE id = 321;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黑水湾沉船" WHERE id = 322;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奥布瑞恩营地" WHERE id = 323;
UPDATE `AreaTable_vanilla` SET name_loc4 = "激流堡" WHERE id = 324;
UPDATE `AreaTable_vanilla` SET name_loc4 = "阿拉索之塔" WHERE id = 325;
UPDATE `AreaTable_vanilla` SET name_loc4 = "密室" WHERE id = 326;
UPDATE `AreaTable_vanilla` SET name_loc4 = "法迪尔海湾" WHERE id = 327;
UPDATE `AreaTable_vanilla` SET name_loc4 = "水下暗礁" WHERE id = 328;
UPDATE `AreaTable_vanilla` SET name_loc4 = "萨多尔大桥" WHERE id = 330;
UPDATE `AreaTable_vanilla` SET name_loc4 = "灰谷" WHERE id = 331;
UPDATE `AreaTable_vanilla` SET name_loc4 = "无尽之海" WHERE id = 332;
UPDATE `AreaTable_vanilla` SET name_loc4 = "东部禁锢法阵" WHERE id = 333;
UPDATE `AreaTable_vanilla` SET name_loc4 = "西部禁锢法阵" WHERE id = 334;
UPDATE `AreaTable_vanilla` SET name_loc4 = "内禁锢法阵" WHERE id = 335;
UPDATE `AreaTable_vanilla` SET name_loc4 = "外禁锢法阵" WHERE id = 336;
UPDATE `AreaTable_vanilla` SET name_loc4 = "圣者之陵" WHERE id = 337;
UPDATE `AreaTable_vanilla` SET name_loc4 = "苦痛堡垒" WHERE id = 338;
UPDATE `AreaTable_vanilla` SET name_loc4 = "莱瑟罗峡谷" WHERE id = 339;
UPDATE `AreaTable_vanilla` SET name_loc4 = "卡加斯" WHERE id = 340;
UPDATE `AreaTable_vanilla` SET name_loc4 = "柯什营地" WHERE id = 341;
UPDATE `AreaTable_vanilla` SET name_loc4 = "博夫营地" WHERE id = 342;
UPDATE `AreaTable_vanilla` SET name_loc4 = "瓦格营地" WHERE id = 343;
UPDATE `AreaTable_vanilla` SET name_loc4 = "卡格营地" WHERE id = 344;
UPDATE `AreaTable_vanilla` SET name_loc4 = "埃格蒙德的营地" WHERE id = 345;
UPDATE `AreaTable_vanilla` SET name_loc4 = "铁趾挖掘场" WHERE id = 346;
UPDATE `AreaTable_vanilla` SET name_loc4 = "火山洞穴" WHERE id = 347;
UPDATE `AreaTable_vanilla` SET name_loc4 = "鹰巢山" WHERE id = 348;
UPDATE `AreaTable_vanilla` SET name_loc4 = "蛮锤城堡" WHERE id = 349;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奎尔丹尼小屋" WHERE id = 350;
UPDATE `AreaTable_vanilla` SET name_loc4 = "隐匿石" WHERE id = 351;
UPDATE `AreaTable_vanilla` SET name_loc4 = "祖瓦沙" WHERE id = 352;
UPDATE `AreaTable_vanilla` SET name_loc4 = "沙德拉洛" WHERE id = 353;
UPDATE `AreaTable_vanilla` SET name_loc4 = "辛萨罗" WHERE id = 354;
UPDATE `AreaTable_vanilla` SET name_loc4 = "祖尔祭坛" WHERE id = 355;
UPDATE `AreaTable_vanilla` SET name_loc4 = "瑟拉丹" WHERE id = 356;
UPDATE `AreaTable_vanilla` SET name_loc4 = "菲拉斯" WHERE id = 357;
UPDATE `AreaTable_vanilla` SET name_loc4 = "刺刃峡谷" WHERE id = 358;
UPDATE `AreaTable_vanilla` SET name_loc4 = "巴尔莫丹" WHERE id = 359;
UPDATE `AreaTable_vanilla` SET name_loc4 = "风险投资公司矿洞" WHERE id = 360;
UPDATE `AreaTable_vanilla` SET name_loc4 = "费伍德森林" WHERE id = 361;
UPDATE `AreaTable_vanilla` SET name_loc4 = "剃刀岭" WHERE id = 362;
UPDATE `AreaTable_vanilla` SET name_loc4 = "试炼谷" WHERE id = 363;
UPDATE `AreaTable_vanilla` SET name_loc4 = "大兽穴" WHERE id = 364;
UPDATE `AreaTable_vanilla` SET name_loc4 = "火刃集会所" WHERE id = 365;
UPDATE `AreaTable_vanilla` SET name_loc4 = "科卡尔峭壁" WHERE id = 366;
UPDATE `AreaTable_vanilla` SET name_loc4 = "森金村" WHERE id = 367;
UPDATE `AreaTable_vanilla` SET name_loc4 = "回音群岛" WHERE id = 368;
UPDATE `AreaTable_vanilla` SET name_loc4 = "雷霆山" WHERE id = 369;
UPDATE `AreaTable_vanilla` SET name_loc4 = "枯水谷" WHERE id = 370;
UPDATE `AreaTable_vanilla` SET name_loc4 = "尘风洞穴" WHERE id = 371;
UPDATE `AreaTable_vanilla` SET name_loc4 = "提拉加德城堡" WHERE id = 372;
UPDATE `AreaTable_vanilla` SET name_loc4 = "流亡海岸" WHERE id = 373;
UPDATE `AreaTable_vanilla` SET name_loc4 = "刃拳海湾" WHERE id = 374;
UPDATE `AreaTable_vanilla` SET name_loc4 = "死眼海岸" WHERE id = 375;
UPDATE `AreaTable_vanilla` SET name_loc4 = "怒水河" WHERE id = 377;
UPDATE `AreaTable_vanilla` SET name_loc4 = "陶拉祖营地" WHERE id = 378;
UPDATE `AreaTable_vanilla` SET name_loc4 = "前沿哨所" WHERE id = 379;
UPDATE `AreaTable_vanilla` SET name_loc4 = "十字路口" WHERE id = 380;
UPDATE `AreaTable_vanilla` SET name_loc4 = "石矿洞" WHERE id = 381;
UPDATE `AreaTable_vanilla` SET name_loc4 = "淤泥沼泽" WHERE id = 382;
UPDATE `AreaTable_vanilla` SET name_loc4 = "无水岭" WHERE id = 383;
UPDATE `AreaTable_vanilla` SET name_loc4 = "鬼雾峰" WHERE id = 384;
UPDATE `AreaTable_vanilla` SET name_loc4 = "北方城堡" WHERE id = 385;
UPDATE `AreaTable_vanilla` SET name_loc4 = "遗忘之池" WHERE id = 386;
UPDATE `AreaTable_vanilla` SET name_loc4 = "甜水绿洲" WHERE id = 387;
UPDATE `AreaTable_vanilla` SET name_loc4 = "死水绿洲" WHERE id = 388;
UPDATE `AreaTable_vanilla` SET name_loc4 = "巨人旷野" WHERE id = 390;
UPDATE `AreaTable_vanilla` SET name_loc4 = "商旅海岸" WHERE id = 391;
UPDATE `AreaTable_vanilla` SET name_loc4 = "棘齿城" WHERE id = 392;
UPDATE `AreaTable_vanilla` SET name_loc4 = "暗矛海滩" WHERE id = 393;
UPDATE `AreaTable_vanilla` SET name_loc4 = "达隆米尔湖UNUSED" WHERE id = 394;
UPDATE `AreaTable_vanilla` SET name_loc4 = "Caer Darrow UNUSED" WHERE id = 395;
UPDATE `AreaTable_vanilla` SET name_loc4 = "冰蹄水井" WHERE id = 396;
UPDATE `AreaTable_vanilla` SET name_loc4 = "雷角水井" WHERE id = 397;
UPDATE `AreaTable_vanilla` SET name_loc4 = "蛮鬃水井" WHERE id = 398;
UPDATE `AreaTable_vanilla` SET name_loc4 = "冲天岭" WHERE id = 399;
UPDATE `AreaTable_vanilla` SET name_loc4 = "千针石林" WHERE id = 400;
UPDATE `AreaTable_vanilla` SET name_loc4 = "提度斯阶梯" WHERE id = 401;
UPDATE `AreaTable_vanilla` SET name_loc4 = "树荫旅店" WHERE id = 403;
UPDATE `AreaTable_vanilla` SET name_loc4 = "巴尔丹挖掘场" WHERE id = 404;
UPDATE `AreaTable_vanilla` SET name_loc4 = "凄凉之地" WHERE id = 405;
UPDATE `AreaTable_vanilla` SET name_loc4 = "石爪山脉" WHERE id = 406;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奥格瑞玛UNUSED" WHERE id = 407;
UPDATE `AreaTable_vanilla` SET name_loc4 = "吉利吉姆之岛" WHERE id = 408;
UPDATE `AreaTable_vanilla` SET name_loc4 = "拉匹迪斯之岛" WHERE id = 409;
UPDATE `AreaTable_vanilla` SET name_loc4 = "烈风峡谷" WHERE id = 410;
UPDATE `AreaTable_vanilla` SET name_loc4 = "巴斯兰鬼屋" WHERE id = 411;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奥迪拉兰废墟" WHERE id = 412;
UPDATE `AreaTable_vanilla` SET name_loc4 = "迈斯特拉岗哨" WHERE id = 413;
UPDATE `AreaTable_vanilla` SET name_loc4 = "佐拉姆海岸" WHERE id = 414;
UPDATE `AreaTable_vanilla` SET name_loc4 = "阿斯特兰纳" WHERE id = 415;
UPDATE `AreaTable_vanilla` SET name_loc4 = "艾森娜神殿" WHERE id = 416;
UPDATE `AreaTable_vanilla` SET name_loc4 = "火痕神殿" WHERE id = 417;
UPDATE `AreaTable_vanilla` SET name_loc4 = "星尘废墟" WHERE id = 418;
UPDATE `AreaTable_vanilla` SET name_loc4 = "狼嚎谷" WHERE id = 419;
UPDATE `AreaTable_vanilla` SET name_loc4 = "银风避难所" WHERE id = 420;
UPDATE `AreaTable_vanilla` SET name_loc4 = "密斯特拉湖" WHERE id = 421;
UPDATE `AreaTable_vanilla` SET name_loc4 = "坠星湖" WHERE id = 422;
UPDATE `AreaTable_vanilla` SET name_loc4 = "伊瑞斯湖" WHERE id = 424;
UPDATE `AreaTable_vanilla` SET name_loc4 = "月亮井" WHERE id = 425;
UPDATE `AreaTable_vanilla` SET name_loc4 = "林中树居" WHERE id = 426;
UPDATE `AreaTable_vanilla` SET name_loc4 = "林荫小径" WHERE id = 427;
UPDATE `AreaTable_vanilla` SET name_loc4 = "夜道谷" WHERE id = 428;
UPDATE `AreaTable_vanilla` SET name_loc4 = "萨维亚" WHERE id = 429;
UPDATE `AreaTable_vanilla` SET name_loc4 = "萨提纳尔" WHERE id = 430;
UPDATE `AreaTable_vanilla` SET name_loc4 = "碎木岗哨" WHERE id = 431;
UPDATE `AreaTable_vanilla` SET name_loc4 = "朵丹尼尔兽穴" WHERE id = 432;
UPDATE `AreaTable_vanilla` SET name_loc4 = "弗伦河" WHERE id = 433;
UPDATE `AreaTable_vanilla` SET name_loc4 = "冥火岭" WHERE id = 434;
UPDATE `AreaTable_vanilla` SET name_loc4 = "屠魔峡谷" WHERE id = 435;
UPDATE `AreaTable_vanilla` SET name_loc4 = "屠魔山" WHERE id = 436;
UPDATE `AreaTable_vanilla` SET name_loc4 = "战歌伐木营地" WHERE id = 437;
UPDATE `AreaTable_vanilla` SET name_loc4 = "大树荫" WHERE id = 438;
UPDATE `AreaTable_vanilla` SET name_loc4 = "闪光平原" WHERE id = 439;
UPDATE `AreaTable_vanilla` SET name_loc4 = "塔纳利斯" WHERE id = 440;
UPDATE `AreaTable_vanilla` SET name_loc4 = "法拉希姆湖" WHERE id = 441;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奥伯丁" WHERE id = 442;
UPDATE `AreaTable_vanilla` SET name_loc4 = "玛塞斯特拉废墟" WHERE id = 443;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奥萨拉克斯之塔" WHERE id = 444;
UPDATE `AreaTable_vanilla` SET name_loc4 = "峭壁之泉" WHERE id = 445;
UPDATE `AreaTable_vanilla` SET name_loc4 = "巴莎兰" WHERE id = 446;
UPDATE `AreaTable_vanilla` SET name_loc4 = "亚米萨兰" WHERE id = 447;
UPDATE `AreaTable_vanilla` SET name_loc4 = "古树之林" WHERE id = 448;
UPDATE `AreaTable_vanilla` SET name_loc4 = "主宰之剑" WHERE id = 449;
UPDATE `AreaTable_vanilla` SET name_loc4 = "雷姆塔维尔挖掘场" WHERE id = 450;
UPDATE `AreaTable_vanilla` SET name_loc4 = "薄雾海" WHERE id = 452;
UPDATE `AreaTable_vanilla` SET name_loc4 = "长桥码头" WHERE id = 453;
UPDATE `AreaTable_vanilla` SET name_loc4 = "急弯河" WHERE id = 454;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黑木洞穴" WHERE id = 455;
UPDATE `AreaTable_vanilla` SET name_loc4 = "壁泉河" WHERE id = 456;
UPDATE `AreaTable_vanilla` SET name_loc4 = "迷雾之海" WHERE id = 457;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黄金之路" WHERE id = 458;
UPDATE `AreaTable_vanilla` SET name_loc4 = "血色十字军哨岗" WHERE id = 459;
UPDATE `AreaTable_vanilla` SET name_loc4 = "烈日石居" WHERE id = 460;
UPDATE `AreaTable_vanilla` SET name_loc4 = "狂风峭壁" WHERE id = 461;
UPDATE `AreaTable_vanilla` SET name_loc4 = "峭壁湖" WHERE id = 463;
UPDATE `AreaTable_vanilla` SET name_loc4 = "暗色湖" WHERE id = 464;
UPDATE `AreaTable_vanilla` SET name_loc4 = "焦炭谷" WHERE id = 465;
UPDATE `AreaTable_vanilla` SET name_loc4 = "血怒峡谷" WHERE id = 466;
UPDATE `AreaTable_vanilla` SET name_loc4 = "石爪峰" WHERE id = 467;
UPDATE `AreaTable_vanilla` SET name_loc4 = "猛禽洞穴" WHERE id = 468;
UPDATE `AreaTable_vanilla` SET name_loc4 = "巨木谷" WHERE id = 469;
UPDATE `AreaTable_vanilla` SET name_loc4 = "雷霆崖UNUSED" WHERE id = 470;
UPDATE `AreaTable_vanilla` SET name_loc4 = "强风台地" WHERE id = 471;
UPDATE `AreaTable_vanilla` SET name_loc4 = "火石台地" WHERE id = 472;
UPDATE `AreaTable_vanilla` SET name_loc4 = "披肩石" WHERE id = 473;
UPDATE `AreaTable_vanilla` SET name_loc4 = "猎人高地UNUSED" WHERE id = 474;
UPDATE `AreaTable_vanilla` SET name_loc4 = "Spirit RiseUNUSED" WHERE id = 475;
UPDATE `AreaTable_vanilla` SET name_loc4 = "长者高地UNUSED" WHERE id = 476;
UPDATE `AreaTable_vanilla` SET name_loc4 = "朱布瓦尔废墟" WHERE id = 477;
UPDATE `AreaTable_vanilla` SET name_loc4 = "阿里斯瑞恩之池" WHERE id = 478;
UPDATE `AreaTable_vanilla` SET name_loc4 = "锈锤挖掘场" WHERE id = 479;
UPDATE `AreaTable_vanilla` SET name_loc4 = "伊索克营地" WHERE id = 480;
UPDATE `AreaTable_vanilla` SET name_loc4 = "裂蹄峭壁" WHERE id = 481;
UPDATE `AreaTable_vanilla` SET name_loc4 = "风巢" WHERE id = 482;
UPDATE `AreaTable_vanilla` SET name_loc4 = "尖啸峡谷" WHERE id = 483;
UPDATE `AreaTable_vanilla` SET name_loc4 = "乱风岗" WHERE id = 484;
UPDATE `AreaTable_vanilla` SET name_loc4 = "升降梯" WHERE id = 485;
UPDATE `AreaTable_vanilla` SET name_loc4 = "加拉克城堡" WHERE id = 486;
UPDATE `AreaTable_vanilla` SET name_loc4 = "飞羽洞穴" WHERE id = 487;
UPDATE `AreaTable_vanilla` SET name_loc4 = "老屋" WHERE id = 488;
UPDATE `AreaTable_vanilla` SET name_loc4 = "萨兰纳尔" WHERE id = 489;
UPDATE `AreaTable_vanilla` SET name_loc4 = "安戈洛环形山" WHERE id = 490;
UPDATE `AreaTable_vanilla` SET name_loc4 = "剃刀沼泽" WHERE id = 491;
UPDATE `AreaTable_vanilla` SET name_loc4 = "乌鸦岭墓地" WHERE id = 492;
UPDATE `AreaTable_vanilla` SET name_loc4 = "月光林地" WHERE id = 493;
UPDATE `AreaTable_vanilla` SET name_loc4 = "DELETE ME" WHERE id = 495;
UPDATE `AreaTable_vanilla` SET name_loc4 = "蕨墙村" WHERE id = 496;
UPDATE `AreaTable_vanilla` SET name_loc4 = "水光庄园" WHERE id = 497;
UPDATE `AreaTable_vanilla` SET name_loc4 = "鲜血沼泽墓穴" WHERE id = 498;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黑雾洞穴" WHERE id = 499;
UPDATE `AreaTable_vanilla` SET name_loc4 = "摩戈尔哨塔" WHERE id = 500;
UPDATE `AreaTable_vanilla` SET name_loc4 = "比吉尔的飞艇残骸" WHERE id = 501;
UPDATE `AreaTable_vanilla` SET name_loc4 = "女巫岭" WHERE id = 502;
UPDATE `AreaTable_vanilla` SET name_loc4 = "警戒哨岗" WHERE id = 503;
UPDATE `AreaTable_vanilla` SET name_loc4 = "北点哨塔" WHERE id = 504;
UPDATE `AreaTable_vanilla` SET name_loc4 = "西点哨塔" WHERE id = 505;
UPDATE `AreaTable_vanilla` SET name_loc4 = "废弃哨塔" WHERE id = 506;
UPDATE `AreaTable_vanilla` SET name_loc4 = "蓝色沼泽" WHERE id = 507;
UPDATE `AreaTable_vanilla` SET name_loc4 = "石槌废墟" WHERE id = 508;
UPDATE `AreaTable_vanilla` SET name_loc4 = "火焰洞穴" WHERE id = 509;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黑龙谷" WHERE id = 510;
UPDATE `AreaTable_vanilla` SET name_loc4 = "巨龙沼泽" WHERE id = 511;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奥妮克希亚的巢穴" WHERE id = 512;
UPDATE `AreaTable_vanilla` SET name_loc4 = "塞拉摩岛" WHERE id = 513;
UPDATE `AreaTable_vanilla` SET name_loc4 = "塞拉摩堡垒" WHERE id = 514;
UPDATE `AreaTable_vanilla` SET name_loc4 = "铁栏监狱" WHERE id = 515;
UPDATE `AreaTable_vanilla` SET name_loc4 = "尘泥海湾" WHERE id = 516;
UPDATE `AreaTable_vanilla` SET name_loc4 = "狂潮湾" WHERE id = 517;
UPDATE `AreaTable_vanilla` SET name_loc4 = "恐惧海岸" WHERE id = 518;
UPDATE `AreaTable_vanilla` SET name_loc4 = "腐草农场" WHERE id = 536;
UPDATE `AreaTable_vanilla` SET name_loc4 = "火羽山" WHERE id = 537;
UPDATE `AreaTable_vanilla` SET name_loc4 = "拉卡利油沼" WHERE id = 538;
UPDATE `AreaTable_vanilla` SET name_loc4 = "恐惧小道" WHERE id = 539;
UPDATE `AreaTable_vanilla` SET name_loc4 = "巨痕谷" WHERE id = 540;
UPDATE `AreaTable_vanilla` SET name_loc4 = "马绍尔营地" WHERE id = 541;
UPDATE `AreaTable_vanilla` SET name_loc4 = "蘑菇石" WHERE id = 542;
UPDATE `AreaTable_vanilla` SET name_loc4 = "葛拉卡温泉" WHERE id = 543;
UPDATE `AreaTable_vanilla` SET name_loc4 = "洛克湖" WHERE id = 556;
UPDATE `AreaTable_vanilla` SET name_loc4 = "乞丐鬼屋" WHERE id = 576;
UPDATE `AreaTable_vanilla` SET name_loc4 = "科多兽坟场" WHERE id = 596;
UPDATE `AreaTable_vanilla` SET name_loc4 = "幽灵岗哨" WHERE id = 597;
UPDATE `AreaTable_vanilla` SET name_loc4 = "萨瑟里斯海岸" WHERE id = 598;
UPDATE `AreaTable_vanilla` SET name_loc4 = "雷斧堡垒" WHERE id = 599;
UPDATE `AreaTable_vanilla` SET name_loc4 = "波尔甘的洞穴" WHERE id = 600;
UPDATE `AreaTable_vanilla` SET name_loc4 = "玛诺洛克集会所" WHERE id = 602;
UPDATE `AreaTable_vanilla` SET name_loc4 = "萨格隆" WHERE id = 603;
UPDATE `AreaTable_vanilla` SET name_loc4 = "玛格拉姆村" WHERE id = 604;
UPDATE `AreaTable_vanilla` SET name_loc4 = "吉尔吉斯村" WHERE id = 606;
UPDATE `AreaTable_vanilla` SET name_loc4 = "长矛谷" WHERE id = 607;
UPDATE `AreaTable_vanilla` SET name_loc4 = "尼耶尔前哨站" WHERE id = 608;
UPDATE `AreaTable_vanilla` SET name_loc4 = "科尔卡村" WHERE id = 609;
UPDATE `AreaTable_vanilla` SET name_loc4 = "海加尔山" WHERE id = 616;
UPDATE `AreaTable_vanilla` SET name_loc4 = "冬泉谷" WHERE id = 618;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黑狼河" WHERE id = 636;
UPDATE `AreaTable_vanilla` SET name_loc4 = "科多石" WHERE id = 637;
UPDATE `AreaTable_vanilla` SET name_loc4 = "秘道" WHERE id = 638;
UPDATE `AreaTable_vanilla` SET name_loc4 = "灵魂石地" WHERE id = 639;
UPDATE `AreaTable_vanilla` SET name_loc4 = "眠炎圣殿" WHERE id = 640;
UPDATE `AreaTable_vanilla` SET name_loc4 = "月神湖" WHERE id = 656;
UPDATE `AreaTable_vanilla` SET name_loc4 = "避难营" WHERE id = 657;
UPDATE `AreaTable_vanilla` SET name_loc4 = "外域" WHERE id = 676;
UPDATE `AreaTable_vanilla` SET name_loc4 = "工匠区UNUSED" WHERE id = 696;
UPDATE `AreaTable_vanilla` SET name_loc4 = "贸易区UNUSED" WHERE id = 697;
UPDATE `AreaTable_vanilla` SET name_loc4 = "神庙花园UNUSED" WHERE id = 698;
UPDATE `AreaTable_vanilla` SET name_loc4 = "月神殿UNUSED" WHERE id = 699;
UPDATE `AreaTable_vanilla` SET name_loc4 = "Cenarion Enclave UNUSED" WHERE id = 700;
UPDATE `AreaTable_vanilla` SET name_loc4 = "Warrior's Terrace UNUSED" WHERE id = 701;
UPDATE `AreaTable_vanilla` SET name_loc4 = "鲁瑟兰村" WHERE id = 702;
UPDATE `AreaTable_vanilla` SET name_loc4 = "铁环营地" WHERE id = 716;
UPDATE `AreaTable_vanilla` SET name_loc4 = "监狱" WHERE id = 717;
UPDATE `AreaTable_vanilla` SET name_loc4 = "哀嚎洞穴" WHERE id = 718;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黑暗深渊" WHERE id = 719;
UPDATE `AreaTable_vanilla` SET name_loc4 = "勇士岛" WHERE id = 720;
UPDATE `AreaTable_vanilla` SET name_loc4 = "诺莫瑞根" WHERE id = 721;
UPDATE `AreaTable_vanilla` SET name_loc4 = "剃刀高地" WHERE id = 722;
UPDATE `AreaTable_vanilla` SET name_loc4 = "班尼希尔山谷" WHERE id = 736;
UPDATE `AreaTable_vanilla` SET name_loc4 = "血色修道院" WHERE id = 796;
UPDATE `AreaTable_vanilla` SET name_loc4 = "杰罗德码头" WHERE id = 797;
UPDATE `AreaTable_vanilla` SET name_loc4 = "山巅之塔" WHERE id = 798;
UPDATE `AreaTable_vanilla` SET name_loc4 = "暗色河滩" WHERE id = 799;
UPDATE `AreaTable_vanilla` SET name_loc4 = "寒脊山小径" WHERE id = 800;
UPDATE `AreaTable_vanilla` SET name_loc4 = "寒风峡谷" WHERE id = 801;
UPDATE `AreaTable_vanilla` SET name_loc4 = "闪光岭" WHERE id = 802;
UPDATE `AreaTable_vanilla` SET name_loc4 = "冻石农场" WHERE id = 803;
UPDATE `AreaTable_vanilla` SET name_loc4 = "冻土岭" WHERE id = 804;
UPDATE `AreaTable_vanilla` SET name_loc4 = "南门小径" WHERE id = 805;
UPDATE `AreaTable_vanilla` SET name_loc4 = "南门哨岗" WHERE id = 806;
UPDATE `AreaTable_vanilla` SET name_loc4 = "北门小径" WHERE id = 807;
UPDATE `AreaTable_vanilla` SET name_loc4 = "北门哨岗" WHERE id = 808;
UPDATE `AreaTable_vanilla` SET name_loc4 = "铁炉堡大门" WHERE id = 809;
UPDATE `AreaTable_vanilla` SET name_loc4 = "静水池" WHERE id = 810;
UPDATE `AreaTable_vanilla` SET name_loc4 = "噩梦谷" WHERE id = 811;
UPDATE `AreaTable_vanilla` SET name_loc4 = "毒蛛峡谷" WHERE id = 812;
UPDATE `AreaTable_vanilla` SET name_loc4 = "亡灵壁垒" WHERE id = 813;
UPDATE `AreaTable_vanilla` SET name_loc4 = "怒水河" WHERE id = 814;
UPDATE `AreaTable_vanilla` SET name_loc4 = "怒水河" WHERE id = 815;
UPDATE `AreaTable_vanilla` SET name_loc4 = "钢鬃营地" WHERE id = 816;
UPDATE `AreaTable_vanilla` SET name_loc4 = "骷髅石" WHERE id = 817;
UPDATE `AreaTable_vanilla` SET name_loc4 = "白鬃石" WHERE id = 818;
UPDATE `AreaTable_vanilla` SET name_loc4 = "狂风山" WHERE id = 819;
UPDATE `AreaTable_vanilla` SET name_loc4 = "金色平原" WHERE id = 820;
UPDATE `AreaTable_vanilla` SET name_loc4 = "草海平原" WHERE id = 821;
UPDATE `AreaTable_vanilla` SET name_loc4 = "丹奥加兹" WHERE id = 836;
UPDATE `AreaTable_vanilla` SET name_loc4 = "丹奥加兹" WHERE id = 837;
UPDATE `AreaTable_vanilla` SET name_loc4 = "北门小径" WHERE id = 838;
UPDATE `AreaTable_vanilla` SET name_loc4 = "南门小径" WHERE id = 839;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黎明森林" WHERE id = 856;
UPDATE `AreaTable_vanilla` SET name_loc4 = "GM Island" WHERE id = 876;
UPDATE `AreaTable_vanilla` SET name_loc4 = "Delete ME" WHERE id = 877;
UPDATE `AreaTable_vanilla` SET name_loc4 = "怒水河" WHERE id = 878;
UPDATE `AreaTable_vanilla` SET name_loc4 = "怒水河" WHERE id = 879;
UPDATE `AreaTable_vanilla` SET name_loc4 = "萨多尔大桥" WHERE id = 880;
UPDATE `AreaTable_vanilla` SET name_loc4 = "萨多尔大桥" WHERE id = 881;
UPDATE `AreaTable_vanilla` SET name_loc4 = "赎罪岛" WHERE id = 896;
UPDATE `AreaTable_vanilla` SET name_loc4 = "贾森农场" WHERE id = 916;
UPDATE `AreaTable_vanilla` SET name_loc4 = "死亡农地" WHERE id = 917;
UPDATE `AreaTable_vanilla` SET name_loc4 = "摩尔森农场" WHERE id = 918;
UPDATE `AreaTable_vanilla` SET name_loc4 = "斯特登的池塘" WHERE id = 919;
UPDATE `AreaTable_vanilla` SET name_loc4 = "匕首岭" WHERE id = 920;
UPDATE `AreaTable_vanilla` SET name_loc4 = "迪蒙特荒野" WHERE id = 921;
UPDATE `AreaTable_vanilla` SET name_loc4 = "尘埃平原" WHERE id = 922;
UPDATE `AreaTable_vanilla` SET name_loc4 = "碎石怪之谷" WHERE id = 923;
UPDATE `AreaTable_vanilla` SET name_loc4 = "国王谷" WHERE id = 924;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奥加兹岗哨" WHERE id = 925;
UPDATE `AreaTable_vanilla` SET name_loc4 = "巴克布雷农场" WHERE id = 926;
UPDATE `AreaTable_vanilla` SET name_loc4 = "闪光湖岸" WHERE id = 927;
UPDATE `AreaTable_vanilla` SET name_loc4 = "北流谷" WHERE id = 928;
UPDATE `AreaTable_vanilla` SET name_loc4 = "灰爪山" WHERE id = 936;
UPDATE `AreaTable_vanilla` SET name_loc4 = "青草平原" WHERE id = 956;
UPDATE `AreaTable_vanilla` SET name_loc4 = "加基森" WHERE id = 976;
UPDATE `AreaTable_vanilla` SET name_loc4 = "热砂港" WHERE id = 977;
UPDATE `AreaTable_vanilla` SET name_loc4 = "祖尔法拉克" WHERE id = 978;
UPDATE `AreaTable_vanilla` SET name_loc4 = "流沙岗哨" WHERE id = 979;
UPDATE `AreaTable_vanilla` SET name_loc4 = "灌木谷" WHERE id = 980;
UPDATE `AreaTable_vanilla` SET name_loc4 = "大裂口" WHERE id = 981;
UPDATE `AreaTable_vanilla` SET name_loc4 = "腐化之巢" WHERE id = 982;
UPDATE `AreaTable_vanilla` SET name_loc4 = "砂槌营地" WHERE id = 983;
UPDATE `AreaTable_vanilla` SET name_loc4 = "东月废墟" WHERE id = 984;
UPDATE `AreaTable_vanilla` SET name_loc4 = "清泉平原" WHERE id = 985;
UPDATE `AreaTable_vanilla` SET name_loc4 = "萨拉辛之穴" WHERE id = 986;
UPDATE `AreaTable_vanilla` SET name_loc4 = "天涯海滩" WHERE id = 987;
UPDATE `AreaTable_vanilla` SET name_loc4 = "破浪海滩" WHERE id = 988;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奥丹姆" WHERE id = 989;
UPDATE `AreaTable_vanilla` SET name_loc4 = "守卫之谷" WHERE id = 990;
UPDATE `AreaTable_vanilla` SET name_loc4 = "古斯坦的哨岗" WHERE id = 991;
UPDATE `AreaTable_vanilla` SET name_loc4 = "南月废墟" WHERE id = 992;
UPDATE `AreaTable_vanilla` SET name_loc4 = "撕裂者营地" WHERE id = 996;
UPDATE `AreaTable_vanilla` SET name_loc4 = "撕裂者山谷" WHERE id = 997;
UPDATE `AreaTable_vanilla` SET name_loc4 = "撕裂者之石" WHERE id = 998;
UPDATE `AreaTable_vanilla` SET name_loc4 = "石堡高塔" WHERE id = 999;
UPDATE `AreaTable_vanilla` SET name_loc4 = "加拉德尔山谷" WHERE id = 1000;
UPDATE `AreaTable_vanilla` SET name_loc4 = "湖边大道" WHERE id = 1001;
UPDATE `AreaTable_vanilla` SET name_loc4 = "三角路口" WHERE id = 1002;
UPDATE `AreaTable_vanilla` SET name_loc4 = "恶铁岭" WHERE id = 1016;
UPDATE `AreaTable_vanilla` SET name_loc4 = "恐龙岭" WHERE id = 1017;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黑水沼泽" WHERE id = 1018;
UPDATE `AreaTable_vanilla` SET name_loc4 = "绿带草地" WHERE id = 1019;
UPDATE `AreaTable_vanilla` SET name_loc4 = "藓皮沼泽" WHERE id = 1020;
UPDATE `AreaTable_vanilla` SET name_loc4 = "瑟根石" WHERE id = 1021;
UPDATE `AreaTable_vanilla` SET name_loc4 = "蓝腮沼泽" WHERE id = 1022;
UPDATE `AreaTable_vanilla` SET name_loc4 = "盐沫沼泽" WHERE id = 1023;
UPDATE `AreaTable_vanilla` SET name_loc4 = "日落沼泽" WHERE id = 1024;
UPDATE `AreaTable_vanilla` SET name_loc4 = "绿带草地" WHERE id = 1025;
UPDATE `AreaTable_vanilla` SET name_loc4 = "怒牙营地" WHERE id = 1036;
UPDATE `AreaTable_vanilla` SET name_loc4 = "格瑞姆巴托" WHERE id = 1037;
UPDATE `AreaTable_vanilla` SET name_loc4 = "龙喉大门" WHERE id = 1038;
UPDATE `AreaTable_vanilla` SET name_loc4 = "失落的舰队" WHERE id = 1039;
UPDATE `AreaTable_vanilla` SET name_loc4 = "达隆山" WHERE id = 1056;
UPDATE `AreaTable_vanilla` SET name_loc4 = "索拉丁之墙" WHERE id = 1057;
UPDATE `AreaTable_vanilla` SET name_loc4 = "蛛网小径" WHERE id = 1076;
UPDATE `AreaTable_vanilla` SET name_loc4 = "寂静河岸" WHERE id = 1097;
UPDATE `AreaTable_vanilla` SET name_loc4 = "密斯特曼托庄园" WHERE id = 1098;
UPDATE `AreaTable_vanilla` SET name_loc4 = "莫沙彻营地" WHERE id = 1099;
UPDATE `AreaTable_vanilla` SET name_loc4 = "恐怖图腾营地" WHERE id = 1100;
UPDATE `AreaTable_vanilla` SET name_loc4 = "痛苦深渊" WHERE id = 1101;
UPDATE `AreaTable_vanilla` SET name_loc4 = "狂风湖" WHERE id = 1102;
UPDATE `AreaTable_vanilla` SET name_loc4 = "戈杜尼前哨站" WHERE id = 1103;
UPDATE `AreaTable_vanilla` SET name_loc4 = "莫克高顿" WHERE id = 1104;
UPDATE `AreaTable_vanilla` SET name_loc4 = "深痕谷" WHERE id = 1105;
UPDATE `AreaTable_vanilla` SET name_loc4 = "乱羽高地" WHERE id = 1106;
UPDATE `AreaTable_vanilla` SET name_loc4 = "微风湖" WHERE id = 1107;
UPDATE `AreaTable_vanilla` SET name_loc4 = "被遗忘的海岸" WHERE id = 1108;
UPDATE `AreaTable_vanilla` SET name_loc4 = "东部石柱" WHERE id = 1109;
UPDATE `AreaTable_vanilla` SET name_loc4 = "西部石柱" WHERE id = 1110;
UPDATE `AreaTable_vanilla` SET name_loc4 = "梦境之树" WHERE id = 1111;
UPDATE `AreaTable_vanilla` SET name_loc4 = "加德米尔湖" WHERE id = 1112;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奥奈罗斯" WHERE id = 1113;
UPDATE `AreaTable_vanilla` SET name_loc4 = "鸦风废墟" WHERE id = 1114;
UPDATE `AreaTable_vanilla` SET name_loc4 = "怒痕堡" WHERE id = 1115;
UPDATE `AreaTable_vanilla` SET name_loc4 = "羽月要塞" WHERE id = 1116;
UPDATE `AreaTable_vanilla` SET name_loc4 = "索兰萨尔废墟" WHERE id = 1117;
UPDATE `AreaTable_vanilla` SET name_loc4 = "Lower Wilds UNUSED" WHERE id = 1118;
UPDATE `AreaTable_vanilla` SET name_loc4 = "双塔山" WHERE id = 1119;
UPDATE `AreaTable_vanilla` SET name_loc4 = "萨尔多岛" WHERE id = 1120;
UPDATE `AreaTable_vanilla` SET name_loc4 = "恐怖之岛" WHERE id = 1121;
UPDATE `AreaTable_vanilla` SET name_loc4 = "高原荒野" WHERE id = 1136;
UPDATE `AreaTable_vanilla` SET name_loc4 = "低地荒野" WHERE id = 1137;
UPDATE `AreaTable_vanilla` SET name_loc4 = "南贫瘠之地" WHERE id = 1156;
UPDATE `AreaTable_vanilla` SET name_loc4 = "南黄金之路" WHERE id = 1157;
UPDATE `AreaTable_vanilla` SET name_loc4 = "祖尔法拉克" WHERE id = 1176;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奥卡兹岛UNUSED" WHERE id = 1196;
UPDATE `AreaTable_vanilla` SET name_loc4 = "木喉要塞" WHERE id = 1216;
UPDATE `AreaTable_vanilla` SET name_loc4 = "范迪尔营地" WHERE id = 1217;
UPDATE `AreaTable_vanilla` SET name_loc4 = "TESTAzshara" WHERE id = 1218;
UPDATE `AreaTable_vanilla` SET name_loc4 = "雷加什营地" WHERE id = 1219;
UPDATE `AreaTable_vanilla` SET name_loc4 = "萨拉斯营地" WHERE id = 1220;
UPDATE `AreaTable_vanilla` SET name_loc4 = "埃达拉斯废墟" WHERE id = 1221;
UPDATE `AreaTable_vanilla` SET name_loc4 = "赫塔拉的巢穴" WHERE id = 1222;
UPDATE `AreaTable_vanilla` SET name_loc4 = "辛玛洛神殿" WHERE id = 1223;
UPDATE `AreaTable_vanilla` SET name_loc4 = "熊头" WHERE id = 1224;
UPDATE `AreaTable_vanilla` SET name_loc4 = "乌索兰" WHERE id = 1225;
UPDATE `AreaTable_vanilla` SET name_loc4 = "亚考兰神殿" WHERE id = 1226;
UPDATE `AreaTable_vanilla` SET name_loc4 = "风暴海湾" WHERE id = 1227;
UPDATE `AreaTable_vanilla` SET name_loc4 = "破碎海岸" WHERE id = 1228;
UPDATE `AreaTable_vanilla` SET name_loc4 = "埃达拉之塔" WHERE id = 1229;
UPDATE `AreaTable_vanilla` SET name_loc4 = "锯齿暗礁" WHERE id = 1230;
UPDATE `AreaTable_vanilla` SET name_loc4 = "南山海滩" WHERE id = 1231;
UPDATE `AreaTable_vanilla` SET name_loc4 = "拉文凯斯雕像" WHERE id = 1232;
UPDATE `AreaTable_vanilla` SET name_loc4 = "凄凉山" WHERE id = 1233;
UPDATE `AreaTable_vanilla` SET name_loc4 = "门纳尔湖" WHERE id = 1234;
UPDATE `AreaTable_vanilla` SET name_loc4 = "影歌神殿" WHERE id = 1235;
UPDATE `AreaTable_vanilla` SET name_loc4 = "哈达尔营地" WHERE id = 1236;
UPDATE `AreaTable_vanilla` SET name_loc4 = "瓦罗莫克" WHERE id = 1237;
UPDATE `AreaTable_vanilla` SET name_loc4 = "废墟海岸" WHERE id = 1256;
UPDATE `AreaTable_vanilla` SET name_loc4 = "石爪小径" WHERE id = 1276;
UPDATE `AreaTable_vanilla` SET name_loc4 = "石爪小径" WHERE id = 1277;
UPDATE `AreaTable_vanilla` SET name_loc4 = "石牙农场" WHERE id = 1296;
UPDATE `AreaTable_vanilla` SET name_loc4 = "野猪农场" WHERE id = 1297;
UPDATE `AreaTable_vanilla` SET name_loc4 = "剃刀高地" WHERE id = 1316;
UPDATE `AreaTable_vanilla` SET name_loc4 = "落帆海湾" WHERE id = 1336;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奥达曼" WHERE id = 1337;
UPDATE `AreaTable_vanilla` SET name_loc4 = "洛丹米尔湖" WHERE id = 1338;
UPDATE `AreaTable_vanilla` SET name_loc4 = "洛丹米尔湖" WHERE id = 1339;
UPDATE `AreaTable_vanilla` SET name_loc4 = "绞刑场" WHERE id = 1357;
UPDATE `AreaTable_vanilla` SET name_loc4 = "希利苏斯" WHERE id = 1377;
UPDATE `AreaTable_vanilla` SET name_loc4 = "翠叶森林" WHERE id = 1397;
UPDATE `AreaTable_vanilla` SET name_loc4 = "沉没的神庙" WHERE id = 1417;
UPDATE `AreaTable_vanilla` SET name_loc4 = "巨槌要塞" WHERE id = 1437;
UPDATE `AreaTable_vanilla` SET name_loc4 = "守望堡" WHERE id = 1438;
UPDATE `AreaTable_vanilla` SET name_loc4 = "巨槌岗哨" WHERE id = 1439;
UPDATE `AreaTable_vanilla` SET name_loc4 = "盘蛇谷" WHERE id = 1440;
UPDATE `AreaTable_vanilla` SET name_loc4 = "风暴祭坛" WHERE id = 1441;
UPDATE `AreaTable_vanilla` SET name_loc4 = "观火岭" WHERE id = 1442;
UPDATE `AreaTable_vanilla` SET name_loc4 = "熔渣之池" WHERE id = 1443;
UPDATE `AreaTable_vanilla` SET name_loc4 = "灰烬之海" WHERE id = 1444;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黑石山" WHERE id = 1445;
UPDATE `AreaTable_vanilla` SET name_loc4 = "瑟银哨塔" WHERE id = 1446;
UPDATE `AreaTable_vanilla` SET name_loc4 = "要塞军械库" WHERE id = 1457;
UPDATE `AreaTable_vanilla` SET name_loc4 = "阿塔哈卡神庙" WHERE id = 1477;
UPDATE `AreaTable_vanilla` SET name_loc4 = "幽暗城" WHERE id = 1497;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奥达曼" WHERE id = 1517;
UPDATE `AreaTable_vanilla` SET name_loc4 = "Not Used Deadmines" WHERE id = 1518;
UPDATE `AreaTable_vanilla` SET name_loc4 = "暴风城" WHERE id = 1519;
UPDATE `AreaTable_vanilla` SET name_loc4 = "铁炉堡" WHERE id = 1537;
UPDATE `AreaTable_vanilla` SET name_loc4 = "裂蹄堡" WHERE id = 1557;
UPDATE `AreaTable_vanilla` SET name_loc4 = "荆棘谷海角" WHERE id = 1577;
UPDATE `AreaTable_vanilla` SET name_loc4 = "南野人海岸" WHERE id = 1578;
UPDATE `AreaTable_vanilla` SET name_loc4 = "Unused The Deadmines 002" WHERE id = 1579;
UPDATE `AreaTable_vanilla` SET name_loc4 = "Unused Ironclad Cove 003" WHERE id = 1580;
UPDATE `AreaTable_vanilla` SET name_loc4 = "死亡矿井" WHERE id = 1581;
UPDATE `AreaTable_vanilla` SET name_loc4 = "铁甲湾" WHERE id = 1582;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黑石塔" WHERE id = 1583;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黑石深渊" WHERE id = 1584;
UPDATE `AreaTable_vanilla` SET name_loc4 = "Raptor Grounds UNUSED" WHERE id = 1597;
UPDATE `AreaTable_vanilla` SET name_loc4 = "Grol'dom Farm UNUSED" WHERE id = 1598;
UPDATE `AreaTable_vanilla` SET name_loc4 = "莫尔杉营地" WHERE id = 1599;
UPDATE `AreaTable_vanilla` SET name_loc4 = "Honor's Stand UNUSED" WHERE id = 1600;
UPDATE `AreaTable_vanilla` SET name_loc4 = "Blackthorn Ridge UNUSED" WHERE id = 1601;
UPDATE `AreaTable_vanilla` SET name_loc4 = "Bramblescar UNUSED" WHERE id = 1602;
UPDATE `AreaTable_vanilla` SET name_loc4 = "Agama'gor UNUSED" WHERE id = 1603;
UPDATE `AreaTable_vanilla` SET name_loc4 = "英雄谷" WHERE id = 1617;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奥格瑞玛" WHERE id = 1637;
UPDATE `AreaTable_vanilla` SET name_loc4 = "雷霆崖" WHERE id = 1638;
UPDATE `AreaTable_vanilla` SET name_loc4 = "长者高地" WHERE id = 1639;
UPDATE `AreaTable_vanilla` SET name_loc4 = "灵魂高地" WHERE id = 1640;
UPDATE `AreaTable_vanilla` SET name_loc4 = "猎人高地" WHERE id = 1641;
UPDATE `AreaTable_vanilla` SET name_loc4 = "达纳苏斯" WHERE id = 1657;
UPDATE `AreaTable_vanilla` SET name_loc4 = "塞纳里奥区" WHERE id = 1658;
UPDATE `AreaTable_vanilla` SET name_loc4 = "工匠区" WHERE id = 1659;
UPDATE `AreaTable_vanilla` SET name_loc4 = "战士区" WHERE id = 1660;
UPDATE `AreaTable_vanilla` SET name_loc4 = "神殿花园" WHERE id = 1661;
UPDATE `AreaTable_vanilla` SET name_loc4 = "贸易区" WHERE id = 1662;
UPDATE `AreaTable_vanilla` SET name_loc4 = "加文高地" WHERE id = 1677;
UPDATE `AreaTable_vanilla` SET name_loc4 = "索菲亚高地" WHERE id = 1678;
UPDATE `AreaTable_vanilla` SET name_loc4 = "考兰之匕" WHERE id = 1679;
UPDATE `AreaTable_vanilla` SET name_loc4 = "山头营地" WHERE id = 1680;
UPDATE `AreaTable_vanilla` SET name_loc4 = "雾气湖岸" WHERE id = 1681;
UPDATE `AreaTable_vanilla` SET name_loc4 = "达伦德农场" WHERE id = 1682;
UPDATE `AreaTable_vanilla` SET name_loc4 = "无草洞" WHERE id = 1683;
UPDATE `AreaTable_vanilla` SET name_loc4 = "冰风岗" WHERE id = 1684;
UPDATE `AreaTable_vanilla` SET name_loc4 = "迅猛龙巢穴" WHERE id = 1697;
UPDATE `AreaTable_vanilla` SET name_loc4 = "迅猛龙平原" WHERE id = 1698;
UPDATE `AreaTable_vanilla` SET name_loc4 = "荆棘岭" WHERE id = 1699;
UPDATE `AreaTable_vanilla` SET name_loc4 = "阿迦玛戈" WHERE id = 1700;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黑棘山" WHERE id = 1701;
UPDATE `AreaTable_vanilla` SET name_loc4 = "荣耀岗哨" WHERE id = 1702;
UPDATE `AreaTable_vanilla` SET name_loc4 = "摩尔沙农场" WHERE id = 1703;
UPDATE `AreaTable_vanilla` SET name_loc4 = "格罗多姆农场" WHERE id = 1704;
UPDATE `AreaTable_vanilla` SET name_loc4 = "剃刀沼泽" WHERE id = 1717;
UPDATE `AreaTable_vanilla` SET name_loc4 = "升降梯" WHERE id = 1718;
UPDATE `AreaTable_vanilla` SET name_loc4 = "薄雾谷" WHERE id = 1737;
UPDATE `AreaTable_vanilla` SET name_loc4 = "纳克迈尼圣泉" WHERE id = 1738;
UPDATE `AreaTable_vanilla` SET name_loc4 = "血帆营地" WHERE id = 1739;
UPDATE `AreaTable_vanilla` SET name_loc4 = "风险投资公司营地" WHERE id = 1740;
UPDATE `AreaTable_vanilla` SET name_loc4 = "古拉巴什竞技场" WHERE id = 1741;
UPDATE `AreaTable_vanilla` SET name_loc4 = "灵魂之穴" WHERE id = 1742;
UPDATE `AreaTable_vanilla` SET name_loc4 = "赤红之雾" WHERE id = 1757;
UPDATE `AreaTable_vanilla` SET name_loc4 = "断潮之池" WHERE id = 1758;
UPDATE `AreaTable_vanilla` SET name_loc4 = "少女的好运" WHERE id = 1759;
UPDATE `AreaTable_vanilla` SET name_loc4 = "风险投资公司工作中心" WHERE id = 1760;
UPDATE `AreaTable_vanilla` SET name_loc4 = "死木村" WHERE id = 1761;
UPDATE `AreaTable_vanilla` SET name_loc4 = "魔爪村" WHERE id = 1762;
UPDATE `AreaTable_vanilla` SET name_loc4 = "加德纳尔" WHERE id = 1763;
UPDATE `AreaTable_vanilla` SET name_loc4 = "血毒河" WHERE id = 1764;
UPDATE `AreaTable_vanilla` SET name_loc4 = "血毒瀑布" WHERE id = 1765;
UPDATE `AreaTable_vanilla` SET name_loc4 = "碎痕谷" WHERE id = 1766;
UPDATE `AreaTable_vanilla` SET name_loc4 = "铁木森林" WHERE id = 1767;
UPDATE `AreaTable_vanilla` SET name_loc4 = "铁木山洞" WHERE id = 1768;
UPDATE `AreaTable_vanilla` SET name_loc4 = "木喉要塞" WHERE id = 1769;
UPDATE `AreaTable_vanilla` SET name_loc4 = "暗影堡" WHERE id = 1770;
UPDATE `AreaTable_vanilla` SET name_loc4 = "欺诈者神祠" WHERE id = 1771;
UPDATE `AreaTable_vanilla` SET name_loc4 = "伊萨里奥斯的洞穴" WHERE id = 1777;
UPDATE `AreaTable_vanilla` SET name_loc4 = "忧伤湿地" WHERE id = 1778;
UPDATE `AreaTable_vanilla` SET name_loc4 = "德莱尼村" WHERE id = 1779;
UPDATE `AreaTable_vanilla` SET name_loc4 = "断矛路口" WHERE id = 1780;
UPDATE `AreaTable_vanilla` SET name_loc4 = "雄鹿沼泽" WHERE id = 1797;
UPDATE `AreaTable_vanilla` SET name_loc4 = "流沙泥潭" WHERE id = 1798;
UPDATE `AreaTable_vanilla` SET name_loc4 = "雄鹿沼泽洞穴" WHERE id = 1817;
UPDATE `AreaTable_vanilla` SET name_loc4 = "枯木洞穴" WHERE id = 1837;
UPDATE `AreaTable_vanilla` SET name_loc4 = "索拉丁之墙" WHERE id = 1857;
UPDATE `AreaTable_vanilla` SET name_loc4 = "博德戈尔" WHERE id = 1858;
UPDATE `AreaTable_vanilla` SET name_loc4 = "巨牙谷" WHERE id = 1877;
UPDATE `AreaTable_vanilla` SET name_loc4 = "漫尘盆地" WHERE id = 1878;
UPDATE `AreaTable_vanilla` SET name_loc4 = "雾气平原" WHERE id = 1879;
UPDATE `AreaTable_vanilla` SET name_loc4 = "羽须小屋" WHERE id = 1880;
UPDATE `AreaTable_vanilla` SET name_loc4 = "拉普索迪营地" WHERE id = 1881;
UPDATE `AreaTable_vanilla` SET name_loc4 = "毒雾峡谷" WHERE id = 1882;
UPDATE `AreaTable_vanilla` SET name_loc4 = "瓦罗温湖" WHERE id = 1883;
UPDATE `AreaTable_vanilla` SET name_loc4 = "亚戈瓦萨" WHERE id = 1884;
UPDATE `AreaTable_vanilla` SET name_loc4 = "西利瓦萨" WHERE id = 1885;
UPDATE `AreaTable_vanilla` SET name_loc4 = "爬虫废墟" WHERE id = 1886;
UPDATE `AreaTable_vanilla` SET name_loc4 = "伯根的棚屋" WHERE id = 1887;
UPDATE `AreaTable_vanilla` SET name_loc4 = "造物者遗迹" WHERE id = 1897;
UPDATE `AreaTable_vanilla` SET name_loc4 = "尘风峡谷" WHERE id = 1898;
UPDATE `AreaTable_vanilla` SET name_loc4 = "沙尔瓦萨" WHERE id = 1917;
UPDATE `AreaTable_vanilla` SET name_loc4 = "热影废墟" WHERE id = 1937;
UPDATE `AreaTable_vanilla` SET name_loc4 = "破碎石柱" WHERE id = 1938;
UPDATE `AreaTable_vanilla` SET name_loc4 = "深沙平原" WHERE id = 1939;
UPDATE `AreaTable_vanilla` SET name_loc4 = "塔纳利斯南海" WHERE id = 1940;
UPDATE `AreaTable_vanilla` SET name_loc4 = "时光之穴" WHERE id = 1941;
UPDATE `AreaTable_vanilla` SET name_loc4 = "沼泽地" WHERE id = 1942;
UPDATE `AreaTable_vanilla` SET name_loc4 = "铁石高原" WHERE id = 1943;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黑炭谷" WHERE id = 1957;
UPDATE `AreaTable_vanilla` SET name_loc4 = "制皮匠营地" WHERE id = 1958;
UPDATE `AreaTable_vanilla` SET name_loc4 = "尘火谷" WHERE id = 1959;
UPDATE `AreaTable_vanilla` SET name_loc4 = "祖尔格拉布" WHERE id = 1977;
UPDATE `AreaTable_vanilla` SET name_loc4 = "芦苇哨岗" WHERE id = 1978;
UPDATE `AreaTable_vanilla` SET name_loc4 = "血毒岗哨" WHERE id = 1997;
UPDATE `AreaTable_vanilla` SET name_loc4 = "刺枝林地" WHERE id = 1998;
UPDATE `AreaTable_vanilla` SET name_loc4 = "斯坦索姆" WHERE id = 2017;
UPDATE `AreaTable_vanilla` SET name_loc4 = "UNUSEDShadowfang Keep 003" WHERE id = 2037;
UPDATE `AreaTable_vanilla` SET name_loc4 = "通灵学院" WHERE id = 2057;
UPDATE `AreaTable_vanilla` SET name_loc4 = "暮光谷" WHERE id = 2077;
UPDATE `AreaTable_vanilla` SET name_loc4 = "暮光海岸" WHERE id = 2078;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奥卡兹岛" WHERE id = 2079;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黑云峰" WHERE id = 2097;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黎明墓穴" WHERE id = 2098;
UPDATE `AreaTable_vanilla` SET name_loc4 = "石堡要塞" WHERE id = 2099;
UPDATE `AreaTable_vanilla` SET name_loc4 = "玛拉顿" WHERE id = 2100;
UPDATE `AreaTable_vanilla` SET name_loc4 = "烈酒旅店" WHERE id = 2101;
UPDATE `AreaTable_vanilla` SET name_loc4 = "雷酒酿制厂" WHERE id = 2102;
UPDATE `AreaTable_vanilla` SET name_loc4 = "米奈希尔城堡" WHERE id = 2103;
UPDATE `AreaTable_vanilla` SET name_loc4 = "深水旅店" WHERE id = 2104;
UPDATE `AreaTable_vanilla` SET name_loc4 = "灰影墓穴" WHERE id = 2117;
UPDATE `AreaTable_vanilla` SET name_loc4 = "布瑞尔城镇大厅" WHERE id = 2118;
UPDATE `AreaTable_vanilla` SET name_loc4 = "恐惧之末旅店" WHERE id = 2119;
UPDATE `AreaTable_vanilla` SET name_loc4 = "The Pools of VisionUNUSED" WHERE id = 2137;
UPDATE `AreaTable_vanilla` SET name_loc4 = "鬼雾兽穴" WHERE id = 2138;
UPDATE `AreaTable_vanilla` SET name_loc4 = "巴尔丹城堡" WHERE id = 2157;
UPDATE `AreaTable_vanilla` SET name_loc4 = "埃博斯塔夫的巢穴" WHERE id = 2158;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奥妮克希亚的巢穴" WHERE id = 2159;
UPDATE `AreaTable_vanilla` SET name_loc4 = "狂风矿洞" WHERE id = 2160;
UPDATE `AreaTable_vanilla` SET name_loc4 = "罗兰之墓" WHERE id = 2161;
UPDATE `AreaTable_vanilla` SET name_loc4 = "大竞技场" WHERE id = 2177;
UPDATE `AreaTable_vanilla` SET name_loc4 = "预见之池" WHERE id = 2197;
UPDATE `AreaTable_vanilla` SET name_loc4 = "破影峡谷" WHERE id = 2198;
UPDATE `AreaTable_vanilla` SET name_loc4 = "断矛村" WHERE id = 2217;
UPDATE `AreaTable_vanilla` SET name_loc4 = "白沙岗哨" WHERE id = 2237;
UPDATE `AreaTable_vanilla` SET name_loc4 = "戈尼亚" WHERE id = 2238;
UPDATE `AreaTable_vanilla` SET name_loc4 = "赞恩之眼" WHERE id = 2239;
UPDATE `AreaTable_vanilla` SET name_loc4 = "沙漠赛道" WHERE id = 2240;
UPDATE `AreaTable_vanilla` SET name_loc4 = "霜刀石" WHERE id = 2241;
UPDATE `AreaTable_vanilla` SET name_loc4 = "隐秘小林" WHERE id = 2242;
UPDATE `AreaTable_vanilla` SET name_loc4 = "木喉岗哨" WHERE id = 2243;
UPDATE `AreaTable_vanilla` SET name_loc4 = "寒水村" WHERE id = 2244;
UPDATE `AreaTable_vanilla` SET name_loc4 = "麦索瑞尔" WHERE id = 2245;
UPDATE `AreaTable_vanilla` SET name_loc4 = "冰火温泉" WHERE id = 2246;
UPDATE `AreaTable_vanilla` SET name_loc4 = "冰蓟岭" WHERE id = 2247;
UPDATE `AreaTable_vanilla` SET name_loc4 = "丹曼达尔" WHERE id = 2248;
UPDATE `AreaTable_vanilla` SET name_loc4 = "霜语峡谷" WHERE id = 2249;
UPDATE `AreaTable_vanilla` SET name_loc4 = "枭翼树丛" WHERE id = 2250;
UPDATE `AreaTable_vanilla` SET name_loc4 = "凯斯利尔湖" WHERE id = 2251;
UPDATE `AreaTable_vanilla` SET name_loc4 = "凯斯利尔废墟" WHERE id = 2252;
UPDATE `AreaTable_vanilla` SET name_loc4 = "坠星村" WHERE id = 2253;
UPDATE `AreaTable_vanilla` SET name_loc4 = "班萨罗兽穴" WHERE id = 2254;
UPDATE `AreaTable_vanilla` SET name_loc4 = "永望镇" WHERE id = 2255;
UPDATE `AreaTable_vanilla` SET name_loc4 = "暗语峡谷" WHERE id = 2256;
UPDATE `AreaTable_vanilla` SET name_loc4 = "矿道地铁" WHERE id = 2257;
UPDATE `AreaTable_vanilla` SET name_loc4 = "蘑菇谷" WHERE id = 2258;
UPDATE `AreaTable_vanilla` SET name_loc4 = "UNUSEDThe Marris Stead" WHERE id = 2259;
UPDATE `AreaTable_vanilla` SET name_loc4 = "玛瑞斯农场" WHERE id = 2260;
UPDATE `AreaTable_vanilla` SET name_loc4 = "墓室" WHERE id = 2261;
UPDATE `AreaTable_vanilla` SET name_loc4 = "达隆郡" WHERE id = 2262;
UPDATE `AreaTable_vanilla` SET name_loc4 = "皇冠哨塔" WHERE id = 2263;
UPDATE `AreaTable_vanilla` SET name_loc4 = "考林路口" WHERE id = 2264;
UPDATE `AreaTable_vanilla` SET name_loc4 = "血色十字军营地" WHERE id = 2265;
UPDATE `AreaTable_vanilla` SET name_loc4 = "提尔之手" WHERE id = 2266;
UPDATE `AreaTable_vanilla` SET name_loc4 = "血色十字军教堂" WHERE id = 2267;
UPDATE `AreaTable_vanilla` SET name_loc4 = "圣光之愿礼拜堂" WHERE id = 2268;
UPDATE `AreaTable_vanilla` SET name_loc4 = "布洛米尔" WHERE id = 2269;
UPDATE `AreaTable_vanilla` SET name_loc4 = "剧毒林地" WHERE id = 2270;
UPDATE `AreaTable_vanilla` SET name_loc4 = "东墙哨塔" WHERE id = 2271;
UPDATE `AreaTable_vanilla` SET name_loc4 = "北谷" WHERE id = 2272;
UPDATE `AreaTable_vanilla` SET name_loc4 = "祖玛沙尔" WHERE id = 2273;
UPDATE `AreaTable_vanilla` SET name_loc4 = "玛兹拉罗" WHERE id = 2274;
UPDATE `AreaTable_vanilla` SET name_loc4 = "北地哨塔" WHERE id = 2275;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奎尔林斯小屋" WHERE id = 2276;
UPDATE `AreaTable_vanilla` SET name_loc4 = "病木林" WHERE id = 2277;
UPDATE `AreaTable_vanilla` SET name_loc4 = "瘟疫要塞" WHERE id = 2278;
UPDATE `AreaTable_vanilla` SET name_loc4 = "斯坦索姆" WHERE id = 2279;
UPDATE `AreaTable_vanilla` SET name_loc4 = "UNUSED Stratholme" WHERE id = 2280;
UPDATE `AreaTable_vanilla` SET name_loc4 = "达隆米尔湖" WHERE id = 2297;
UPDATE `AreaTable_vanilla` SET name_loc4 = "凯尔达隆" WHERE id = 2298;
UPDATE `AreaTable_vanilla` SET name_loc4 = "达隆米尔湖" WHERE id = 2299;
UPDATE `AreaTable_vanilla` SET name_loc4 = "时光之穴" WHERE id = 2300;
UPDATE `AreaTable_vanilla` SET name_loc4 = "蓟皮村" WHERE id = 2301;
UPDATE `AreaTable_vanilla` SET name_loc4 = "泥潭沼泽" WHERE id = 2302;
UPDATE `AreaTable_vanilla` SET name_loc4 = "风裂峡谷" WHERE id = 2303;
UPDATE `AreaTable_vanilla` SET name_loc4 = "南海" WHERE id = 2317;
UPDATE `AreaTable_vanilla` SET name_loc4 = "无尽之海" WHERE id = 2318;
UPDATE `AreaTable_vanilla` SET name_loc4 = "无尽之海" WHERE id = 2319;
UPDATE `AreaTable_vanilla` SET name_loc4 = "无尽之海" WHERE id = 2320;
UPDATE `AreaTable_vanilla` SET name_loc4 = "无尽之海" WHERE id = 2321;
UPDATE `AreaTable_vanilla` SET name_loc4 = "迷雾之海" WHERE id = 2322;
UPDATE `AreaTable_vanilla` SET name_loc4 = "迷雾之海" WHERE id = 2323;
UPDATE `AreaTable_vanilla` SET name_loc4 = "迷雾之海" WHERE id = 2324;
UPDATE `AreaTable_vanilla` SET name_loc4 = "迷雾之海" WHERE id = 2325;
UPDATE `AreaTable_vanilla` SET name_loc4 = "迷雾之海" WHERE id = 2326;
UPDATE `AreaTable_vanilla` SET name_loc4 = "剃刀岭兵营" WHERE id = 2337;
UPDATE `AreaTable_vanilla` SET name_loc4 = "南海" WHERE id = 2338;
UPDATE `AreaTable_vanilla` SET name_loc4 = "无尽之海" WHERE id = 2339;
UPDATE `AreaTable_vanilla` SET name_loc4 = "血牙营地" WHERE id = 2357;
UPDATE `AreaTable_vanilla` SET name_loc4 = "林歌神殿" WHERE id = 2358;
UPDATE `AreaTable_vanilla` SET name_loc4 = "绿爪村" WHERE id = 2359;
UPDATE `AreaTable_vanilla` SET name_loc4 = "银翼哨站" WHERE id = 2360;
UPDATE `AreaTable_vanilla` SET name_loc4 = "永夜港" WHERE id = 2361;
UPDATE `AreaTable_vanilla` SET name_loc4 = "雷姆洛斯神殿" WHERE id = 2362;
UPDATE `AreaTable_vanilla` SET name_loc4 = "怒风兽穴" WHERE id = 2363;
UPDATE `AreaTable_vanilla` SET name_loc4 = "无尽之海" WHERE id = 2364;
UPDATE `AreaTable_vanilla` SET name_loc4 = "无尽之海" WHERE id = 2365;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黑色沼泽" WHERE id = 2366;
UPDATE `AreaTable_vanilla` SET name_loc4 = "Old Hillsbrad Foothills" WHERE id = 2367;
UPDATE `AreaTable_vanilla` SET name_loc4 = "塔伦米尔" WHERE id = 2368;
UPDATE `AreaTable_vanilla` SET name_loc4 = "南海镇" WHERE id = 2369;
UPDATE `AreaTable_vanilla` SET name_loc4 = "敦霍尔德城堡" WHERE id = 2370;
UPDATE `AreaTable_vanilla` SET name_loc4 = "丹加洛克" WHERE id = 2371;
UPDATE `AreaTable_vanilla` SET name_loc4 = "希尔斯布莱德农场" WHERE id = 2372;
UPDATE `AreaTable_vanilla` SET name_loc4 = "东部海滩" WHERE id = 2373;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奈杉德哨岗" WHERE id = 2374;
UPDATE `AreaTable_vanilla` SET name_loc4 = "达隆山" WHERE id = 2375;
UPDATE `AreaTable_vanilla` SET name_loc4 = "南点哨塔" WHERE id = 2376;
UPDATE `AreaTable_vanilla` SET name_loc4 = "索拉丁之墙" WHERE id = 2377;
UPDATE `AreaTable_vanilla` SET name_loc4 = "西部海岸" WHERE id = 2378;
UPDATE `AreaTable_vanilla` SET name_loc4 = "碧玉矿洞" WHERE id = 2379;
UPDATE `AreaTable_vanilla` SET name_loc4 = "无尽之海" WHERE id = 2397;
UPDATE `AreaTable_vanilla` SET name_loc4 = "无尽之海" WHERE id = 2398;
UPDATE `AreaTable_vanilla` SET name_loc4 = "无尽之海" WHERE id = 2399;
UPDATE `AreaTable_vanilla` SET name_loc4 = "禁忌之海" WHERE id = 2400;
UPDATE `AreaTable_vanilla` SET name_loc4 = "禁忌之海" WHERE id = 2401;
UPDATE `AreaTable_vanilla` SET name_loc4 = "禁忌之海" WHERE id = 2402;
UPDATE `AreaTable_vanilla` SET name_loc4 = "禁忌之海" WHERE id = 2403;
UPDATE `AreaTable_vanilla` SET name_loc4 = "塔迪萨兰" WHERE id = 2404;
UPDATE `AreaTable_vanilla` SET name_loc4 = "艾瑟雷索" WHERE id = 2405;
UPDATE `AreaTable_vanilla` SET name_loc4 = "拉纳加尔岛" WHERE id = 2406;
UPDATE `AreaTable_vanilla` SET name_loc4 = "考米克小屋" WHERE id = 2407;
UPDATE `AreaTable_vanilla` SET name_loc4 = "葬影村" WHERE id = 2408;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黑石小径" WHERE id = 2417;
UPDATE `AreaTable_vanilla` SET name_loc4 = "摩根的岗哨" WHERE id = 2418;
UPDATE `AreaTable_vanilla` SET name_loc4 = "滑石" WHERE id = 2419;
UPDATE `AreaTable_vanilla` SET name_loc4 = "龙翼小径" WHERE id = 2420;
UPDATE `AreaTable_vanilla` SET name_loc4 = "德拉考达尔" WHERE id = 2421;
UPDATE `AreaTable_vanilla` SET name_loc4 = "怒焰裂谷" WHERE id = 2437;
UPDATE `AreaTable_vanilla` SET name_loc4 = "夜歌森林" WHERE id = 2457;
UPDATE `AreaTable_vanilla` SET name_loc4 = "迷雾之海" WHERE id = 2477;
UPDATE `AreaTable_vanilla` SET name_loc4 = "摩罗萨兰" WHERE id = 2478;
UPDATE `AreaTable_vanilla` SET name_loc4 = "翡翠圣地" WHERE id = 2479;
UPDATE `AreaTable_vanilla` SET name_loc4 = "碧火谷" WHERE id = 2480;
UPDATE `AreaTable_vanilla` SET name_loc4 = "克斯特拉斯废墟" WHERE id = 2481;
UPDATE `AreaTable_vanilla` SET name_loc4 = "痛苦海岸" WHERE id = 2497;
UPDATE `AreaTable_vanilla` SET name_loc4 = "污染者高地" WHERE id = 2517;
UPDATE `AreaTable_vanilla` SET name_loc4 = "拉瑞斯小亭" WHERE id = 2518;
UPDATE `AreaTable_vanilla` SET name_loc4 = "木爪岭" WHERE id = 2519;
UPDATE `AreaTable_vanilla` SET name_loc4 = "木爪巢穴" WHERE id = 2520;
UPDATE `AreaTable_vanilla` SET name_loc4 = "沃丹提斯河" WHERE id = 2521;
UPDATE `AreaTable_vanilla` SET name_loc4 = "伊斯迪尔废墟" WHERE id = 2522;
UPDATE `AreaTable_vanilla` SET name_loc4 = "恐怖图腾岗哨" WHERE id = 2537;
UPDATE `AreaTable_vanilla` SET name_loc4 = "阿帕拉耶营地" WHERE id = 2538;
UPDATE `AreaTable_vanilla` SET name_loc4 = "玛拉卡金" WHERE id = 2539;
UPDATE `AreaTable_vanilla` SET name_loc4 = "滚岩峡谷" WHERE id = 2540;
UPDATE `AreaTable_vanilla` SET name_loc4 = "希塞尔山谷" WHERE id = 2541;
UPDATE `AreaTable_vanilla` SET name_loc4 = "厄运之槌" WHERE id = 2557;
UPDATE `AreaTable_vanilla` SET name_loc4 = "逆风谷" WHERE id = 2558;
UPDATE `AreaTable_vanilla` SET name_loc4 = "钻石河" WHERE id = 2559;
UPDATE `AreaTable_vanilla` SET name_loc4 = "埃瑞丁营地" WHERE id = 2560;
UPDATE `AreaTable_vanilla` SET name_loc4 = "罪恶谷" WHERE id = 2561;
UPDATE `AreaTable_vanilla` SET name_loc4 = "卡拉赞" WHERE id = 2562;
UPDATE `AreaTable_vanilla` SET name_loc4 = "摩根墓场" WHERE id = 2563;
UPDATE `AreaTable_vanilla` SET name_loc4 = "厄运之槌" WHERE id = 2577;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奥特兰克山谷" WHERE id = 2597;
UPDATE `AreaTable_vanilla` SET name_loc4 = "瑟卡布斯库的营地" WHERE id = 2617;
UPDATE `AreaTable_vanilla` SET name_loc4 = "碧火小径" WHERE id = 2618;
UPDATE `AreaTable_vanilla` SET name_loc4 = "索多里尔河" WHERE id = 2619;
UPDATE `AreaTable_vanilla` SET name_loc4 = "索多里尔河" WHERE id = 2620;
UPDATE `AreaTable_vanilla` SET name_loc4 = "米雷达尔湖" WHERE id = 2621;
UPDATE `AreaTable_vanilla` SET name_loc4 = "瘟疫之痕" WHERE id = 2622;
UPDATE `AreaTable_vanilla` SET name_loc4 = "魔刃之痕" WHERE id = 2623;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黑木湖" WHERE id = 2624;
UPDATE `AreaTable_vanilla` SET name_loc4 = "东墙大门" WHERE id = 2625;
UPDATE `AreaTable_vanilla` SET name_loc4 = "恶蛛隧道" WHERE id = 2626;
UPDATE `AreaTable_vanilla` SET name_loc4 = "恐惧谷" WHERE id = 2627;
UPDATE `AreaTable_vanilla` SET name_loc4 = "卡加希亚要塞" WHERE id = 2637;
UPDATE `AreaTable_vanilla` SET name_loc4 = "白骨之谷" WHERE id = 2657;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黑翼之巢" WHERE id = 2677;
UPDATE `AreaTable_vanilla` SET name_loc4 = "死者十字" WHERE id = 2697;
UPDATE `AreaTable_vanilla` SET name_loc4 = "熔火之心" WHERE id = 2717;
UPDATE `AreaTable_vanilla` SET name_loc4 = "甲虫之墙" WHERE id = 2737;
UPDATE `AreaTable_vanilla` SET name_loc4 = "南风村" WHERE id = 2738;
UPDATE `AreaTable_vanilla` SET name_loc4 = "暮光营地" WHERE id = 2739;
UPDATE `AreaTable_vanilla` SET name_loc4 = "水晶谷" WHERE id = 2740;
UPDATE `AreaTable_vanilla` SET name_loc4 = "甲虫之台" WHERE id = 2741;
UPDATE `AreaTable_vanilla` SET name_loc4 = "亚什虫巢" WHERE id = 2742;
UPDATE `AreaTable_vanilla` SET name_loc4 = "佐拉虫巢" WHERE id = 2743;
UPDATE `AreaTable_vanilla` SET name_loc4 = "雷戈虫巢" WHERE id = 2744;
UPDATE `AreaTable_vanilla` SET name_loc4 = "战士之魂神殿" WHERE id = 2757;
UPDATE `AreaTable_vanilla` SET name_loc4 = "UNUSED Alterac Valley" WHERE id = 2777;
UPDATE `AreaTable_vanilla` SET name_loc4 = "黑暗深渊" WHERE id = 2797;
UPDATE `AreaTable_vanilla` SET name_loc4 = "***大型地下城***" WHERE id = 2817;
UPDATE `AreaTable_vanilla` SET name_loc4 = "主宰的庇护所" WHERE id = 2837;
UPDATE `AreaTable_vanilla` SET name_loc4 = "石坝小径" WHERE id = 2838;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奥特兰克山谷" WHERE id = 2839;
UPDATE `AreaTable_vanilla` SET name_loc4 = "加基森竞技场" WHERE id = 2857;
UPDATE `AreaTable_vanilla` SET name_loc4 = "Chunk Test" WHERE id = 2877;
UPDATE `AreaTable_vanilla` SET name_loc4 = "佐拉姆加前哨站" WHERE id = 2897;
UPDATE `AreaTable_vanilla` SET name_loc4 = "传说大厅" WHERE id = 2917;
UPDATE `AreaTable_vanilla` SET name_loc4 = "勇士大厅" WHERE id = 2918;
UPDATE `AreaTable_vanilla` SET name_loc4 = "格罗高克营地" WHERE id = 2937;
UPDATE `AreaTable_vanilla` SET name_loc4 = "沉睡峡谷" WHERE id = 2938;
UPDATE `AreaTable_vanilla` SET name_loc4 = "深铁矿洞" WHERE id = 2957;
UPDATE `AreaTable_vanilla` SET name_loc4 = "石炉哨站" WHERE id = 2958;
UPDATE `AreaTable_vanilla` SET name_loc4 = "丹巴达尔" WHERE id = 2959;
UPDATE `AreaTable_vanilla` SET name_loc4 = "冰翼小径" WHERE id = 2960;
UPDATE `AreaTable_vanilla` SET name_loc4 = "霜狼村" WHERE id = 2961;
UPDATE `AreaTable_vanilla` SET name_loc4 = "哨塔高地" WHERE id = 2962;
UPDATE `AreaTable_vanilla` SET name_loc4 = "冷齿矿洞" WHERE id = 2963;
UPDATE `AreaTable_vanilla` SET name_loc4 = "冰斧要塞" WHERE id = 2964;
UPDATE `AreaTable_vanilla` SET name_loc4 = "冰血要塞" WHERE id = 2977;
UPDATE `AreaTable_vanilla` SET name_loc4 = "霜狼要塞" WHERE id = 2978;
UPDATE `AreaTable_vanilla` SET name_loc4 = "托克雷农场" WHERE id = 2979;
UPDATE `AreaTable_vanilla` SET name_loc4 = "霜刀小径" WHERE id = 3017;
UPDATE `AreaTable_vanilla` SET name_loc4 = "铁石营地" WHERE id = 3037;
UPDATE `AreaTable_vanilla` SET name_loc4 = "维吉尔之坑" WHERE id = 3038;
UPDATE `AreaTable_vanilla` SET name_loc4 = "塔霍达废墟" WHERE id = 3039;
UPDATE `AreaTable_vanilla` SET name_loc4 = "征战平原" WHERE id = 3057;
UPDATE `AreaTable_vanilla` SET name_loc4 = "冰翼洞穴" WHERE id = 3058;
UPDATE `AreaTable_vanilla` SET name_loc4 = "勇士之墓" WHERE id = 3077;
UPDATE `AreaTable_vanilla` SET name_loc4 = "虫群之柱" WHERE id = 3097;
UPDATE `AreaTable_vanilla` SET name_loc4 = "暮光岗哨" WHERE id = 3098;
UPDATE `AreaTable_vanilla` SET name_loc4 = "暮光前哨站" WHERE id = 3099;
UPDATE `AreaTable_vanilla` SET name_loc4 = "暮光营地废墟" WHERE id = 3100;
UPDATE `AreaTable_vanilla` SET name_loc4 = "沙尔扎鲁的巢穴" WHERE id = 3117;
UPDATE `AreaTable_vanilla` SET name_loc4 = "塔伦迪斯营地" WHERE id = 3137;
UPDATE `AreaTable_vanilla` SET name_loc4 = "雷瑟斯圣所" WHERE id = 3138;
UPDATE `AreaTable_vanilla` SET name_loc4 = "惨月洞穴" WHERE id = 3139;
UPDATE `AreaTable_vanilla` SET name_loc4 = "鳞须海龟洞穴" WHERE id = 3140;
UPDATE `AreaTable_vanilla` SET name_loc4 = "滚岩洞穴" WHERE id = 3157;
UPDATE `AreaTable_vanilla` SET name_loc4 = "战歌劳工营地" WHERE id = 3177;
UPDATE `AreaTable_vanilla` SET name_loc4 = "寒风营地" WHERE id = 3197;
UPDATE `AreaTable_vanilla` SET name_loc4 = "巨槌竞技场" WHERE id = 3217;
UPDATE `AreaTable_vanilla` SET name_loc4 = "The Maul UNUSED" WHERE id = 3237;
UPDATE `AreaTable_vanilla` SET name_loc4 = "格拉卡隆之骨" WHERE id = 3257;
UPDATE `AreaTable_vanilla` SET name_loc4 = "战歌峡谷" WHERE id = 3277;
UPDATE `AreaTable_vanilla` SET name_loc4 = "霜狼墓地" WHERE id = 3297;
UPDATE `AreaTable_vanilla` SET name_loc4 = "霜狼小径" WHERE id = 3298;
UPDATE `AreaTable_vanilla` SET name_loc4 = "丹巴达尔小径" WHERE id = 3299;
UPDATE `AreaTable_vanilla` SET name_loc4 = "冰血墓地" WHERE id = 3300;
UPDATE `AreaTable_vanilla` SET name_loc4 = "落雪墓地" WHERE id = 3301;
UPDATE `AreaTable_vanilla` SET name_loc4 = "石炉墓地" WHERE id = 3302;
UPDATE `AreaTable_vanilla` SET name_loc4 = "雷矛墓地" WHERE id = 3303;
UPDATE `AreaTable_vanilla` SET name_loc4 = "冰翼碉堡" WHERE id = 3304;
UPDATE `AreaTable_vanilla` SET name_loc4 = "石炉碉堡" WHERE id = 3305;
UPDATE `AreaTable_vanilla` SET name_loc4 = "蛮爪岭" WHERE id = 3306;
UPDATE `AreaTable_vanilla` SET name_loc4 = "恶齿村" WHERE id = 3317;
UPDATE `AreaTable_vanilla` SET name_loc4 = "杜隆坦之石" WHERE id = 3318;
UPDATE `AreaTable_vanilla` SET name_loc4 = "银翼树林" WHERE id = 3319;
UPDATE `AreaTable_vanilla` SET name_loc4 = "战歌伐木场" WHERE id = 3320;
UPDATE `AreaTable_vanilla` SET name_loc4 = "银翼要塞" WHERE id = 3321;
UPDATE `AreaTable_vanilla` SET name_loc4 = "蛮爪洞穴" WHERE id = 3337;
UPDATE `AreaTable_vanilla` SET name_loc4 = "迷雾裂隙" WHERE id = 3338;
UPDATE `AreaTable_vanilla` SET name_loc4 = "尤亚姆巴岛" WHERE id = 3357;
UPDATE `AreaTable_vanilla` SET name_loc4 = "阿拉希盆地" WHERE id = 3358;
UPDATE `AreaTable_vanilla` SET name_loc4 = "毒蛇小径" WHERE id = 3377;
UPDATE `AreaTable_vanilla` SET name_loc4 = "希里克祭坛" WHERE id = 3378;
UPDATE `AreaTable_vanilla` SET name_loc4 = "沙德拉扎尔" WHERE id = 3379;
UPDATE `AreaTable_vanilla` SET name_loc4 = "哈卡莱猎场" WHERE id = 3380;
UPDATE `AreaTable_vanilla` SET name_loc4 = "希瓦拉尔之角" WHERE id = 3381;
UPDATE `AreaTable_vanilla` SET name_loc4 = "贝瑟克神庙" WHERE id = 3382;
UPDATE `AreaTable_vanilla` SET name_loc4 = "血火之池" WHERE id = 3383;
UPDATE `AreaTable_vanilla` SET name_loc4 = "血神祭坛" WHERE id = 3384;
UPDATE `AreaTable_vanilla` SET name_loc4 = "赞扎高地" WHERE id = 3397;
UPDATE `AreaTable_vanilla` SET name_loc4 = "疯狂之缘" WHERE id = 3398;
UPDATE `AreaTable_vanilla` SET name_loc4 = "托尔贝恩大厅" WHERE id = 3417;
UPDATE `AreaTable_vanilla` SET name_loc4 = "污染者之穴" WHERE id = 3418;
UPDATE `AreaTable_vanilla` SET name_loc4 = "帕格渔点" WHERE id = 3419;
UPDATE `AreaTable_vanilla` SET name_loc4 = "农场" WHERE id = 3420;
UPDATE `AreaTable_vanilla` SET name_loc4 = "铁匠铺" WHERE id = 3421;
UPDATE `AreaTable_vanilla` SET name_loc4 = "伐木场" WHERE id = 3422;
UPDATE `AreaTable_vanilla` SET name_loc4 = "矿洞" WHERE id = 3423;
UPDATE `AreaTable_vanilla` SET name_loc4 = "兽栏" WHERE id = 3424;
UPDATE `AreaTable_vanilla` SET name_loc4 = "塞纳里奥要塞" WHERE id = 3425;
UPDATE `AreaTable_vanilla` SET name_loc4 = "鹿盔岗哨" WHERE id = 3426;
UPDATE `AreaTable_vanilla` SET name_loc4 = "铜须营地" WHERE id = 3427;
UPDATE `AreaTable_vanilla` SET name_loc4 = "安其拉" WHERE id = 3428;
UPDATE `AreaTable_vanilla` SET name_loc4 = "安其拉废墟" WHERE id = 3429;
UPDATE `AreaTable_vanilla` SET name_loc4 = "暮光小径" WHERE id = 3446;
UPDATE `AreaTable_vanilla` SET name_loc4 = "奥泰尔藏身处" WHERE id = 3447;
UPDATE `AreaTable_vanilla` SET name_loc4 = "甲虫平台" WHERE id = 3448;
UPDATE `AreaTable_vanilla` SET name_loc4 = "将军平台" WHERE id = 3449;
UPDATE `AreaTable_vanilla` SET name_loc4 = "蓄水池" WHERE id = 3450;
UPDATE `AreaTable_vanilla` SET name_loc4 = "孵化间" WHERE id = 3451;
UPDATE `AreaTable_vanilla` SET name_loc4 = "蜂巢" WHERE id = 3452;
UPDATE `AreaTable_vanilla` SET name_loc4 = "守望平台" WHERE id = 3453;
UPDATE `AreaTable_vanilla` SET name_loc4 = "安其拉废墟" WHERE id = 3454;
UPDATE `AreaTable_vanilla` SET name_loc4 = "纳克萨玛斯" WHERE id = 3456;
UPDATE `AreaTable_vanilla` SET name_loc4 = "城市" WHERE id = 3459;
UPDATE `AreaTable_vanilla` SET name_loc4 = "安其拉之门" WHERE id = 3478;
UPDATE `AreaTable_vanilla` SET name_loc4 = "拉文霍德庄园" WHERE id = 3486;
UPDATE `AreaTable_vanilla` SET name_loc5 = "丹莫洛" WHERE id = 1;
UPDATE `AreaTable_vanilla` SET name_loc5 = "長灘" WHERE id = 2;
UPDATE `AreaTable_vanilla` SET name_loc5 = "荒蕪之地" WHERE id = 3;
UPDATE `AreaTable_vanilla` SET name_loc5 = "詛咒之地" WHERE id = 4;
UPDATE `AreaTable_vanilla` SET name_loc5 = "黑水灣" WHERE id = 7;
UPDATE `AreaTable_vanilla` SET name_loc5 = "悲傷沼澤" WHERE id = 8;
UPDATE `AreaTable_vanilla` SET name_loc5 = "北郡山谷" WHERE id = 9;
UPDATE `AreaTable_vanilla` SET name_loc5 = "暮色森林" WHERE id = 10;
UPDATE `AreaTable_vanilla` SET name_loc5 = "濕地" WHERE id = 11;
UPDATE `AreaTable_vanilla` SET name_loc5 = "艾爾文森林" WHERE id = 12;
UPDATE `AreaTable_vanilla` SET name_loc5 = "世界之樹" WHERE id = 13;
UPDATE `AreaTable_vanilla` SET name_loc5 = "杜洛塔" WHERE id = 14;
UPDATE `AreaTable_vanilla` SET name_loc5 = "塵泥沼澤" WHERE id = 15;
UPDATE `AreaTable_vanilla` SET name_loc5 = "艾薩拉" WHERE id = 16;
UPDATE `AreaTable_vanilla` SET name_loc5 = "貧瘠之地" WHERE id = 17;
UPDATE `AreaTable_vanilla` SET name_loc5 = "水晶湖" WHERE id = 18;
UPDATE `AreaTable_vanilla` SET name_loc5 = "祖爾格拉布" WHERE id = 19;
UPDATE `AreaTable_vanilla` SET name_loc5 = "月溪鎮" WHERE id = 20;
UPDATE `AreaTable_vanilla` SET name_loc5 = "庫爾提拉斯" WHERE id = 21;
UPDATE `AreaTable_vanilla` SET name_loc5 = "工程師島" WHERE id = 22;
UPDATE `AreaTable_vanilla` SET name_loc5 = "北郡河" WHERE id = 23;
UPDATE `AreaTable_vanilla` SET name_loc5 = "北郡修道院" WHERE id = 24;
UPDATE `AreaTable_vanilla` SET name_loc5 = "黑石山" WHERE id = 25;
UPDATE `AreaTable_vanilla` SET name_loc5 = "燈塔" WHERE id = 26;
UPDATE `AreaTable_vanilla` SET name_loc5 = "西瘟疫之地" WHERE id = 28;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Nine" WHERE id = 30;
UPDATE `AreaTable_vanilla` SET name_loc5 = "大墓地" WHERE id = 32;
UPDATE `AreaTable_vanilla` SET name_loc5 = "荊棘谷" WHERE id = 33;
UPDATE `AreaTable_vanilla` SET name_loc5 = "回音山礦坑" WHERE id = 34;
UPDATE `AreaTable_vanilla` SET name_loc5 = "藏寶海灣" WHERE id = 35;
UPDATE `AreaTable_vanilla` SET name_loc5 = "奧特蘭克山脈" WHERE id = 36;
UPDATE `AreaTable_vanilla` SET name_loc5 = "納菲瑞提湖" WHERE id = 37;
UPDATE `AreaTable_vanilla` SET name_loc5 = "洛克莫丹" WHERE id = 38;
UPDATE `AreaTable_vanilla` SET name_loc5 = "西部荒野" WHERE id = 40;
UPDATE `AreaTable_vanilla` SET name_loc5 = "逆風小徑" WHERE id = 41;
UPDATE `AreaTable_vanilla` SET name_loc5 = "夜色鎮" WHERE id = 42;
UPDATE `AreaTable_vanilla` SET name_loc5 = "蠻荒海岸" WHERE id = 43;
UPDATE `AreaTable_vanilla` SET name_loc5 = "赤脊山" WHERE id = 44;
UPDATE `AreaTable_vanilla` SET name_loc5 = "阿拉希高地" WHERE id = 45;
UPDATE `AreaTable_vanilla` SET name_loc5 = "燃燒平原" WHERE id = 46;
UPDATE `AreaTable_vanilla` SET name_loc5 = "辛特蘭" WHERE id = 47;
UPDATE `AreaTable_vanilla` SET name_loc5 = "亡者之穴" WHERE id = 49;
UPDATE `AreaTable_vanilla` SET name_loc5 = "灼熱峽谷" WHERE id = 51;
UPDATE `AreaTable_vanilla` SET name_loc5 = "盜賊營地" WHERE id = 53;
UPDATE `AreaTable_vanilla` SET name_loc5 = "玉石礦坑" WHERE id = 54;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Valley of Heroes UNUSED" WHERE id = 55;
UPDATE `AreaTable_vanilla` SET name_loc5 = "英雄崗哨" WHERE id = 56;
UPDATE `AreaTable_vanilla` SET name_loc5 = "法戈第礦坑" WHERE id = 57;
UPDATE `AreaTable_vanilla` SET name_loc5 = "北郡農場" WHERE id = 59;
UPDATE `AreaTable_vanilla` SET name_loc5 = "林邊空地" WHERE id = 60;
UPDATE `AreaTable_vanilla` SET name_loc5 = "雷霆瀑布" WHERE id = 61;
UPDATE `AreaTable_vanilla` SET name_loc5 = "布萊克威爾南瓜田" WHERE id = 62;
UPDATE `AreaTable_vanilla` SET name_loc5 = "斯通菲爾德農場" WHERE id = 63;
UPDATE `AreaTable_vanilla` SET name_loc5 = "馬科倫農場" WHERE id = 64;
UPDATE `AreaTable_vanilla` SET name_loc5 = "***大型地下城***" WHERE id = 65;
UPDATE `AreaTable_vanilla` SET name_loc5 = "***大型地下城***" WHERE id = 66;
UPDATE `AreaTable_vanilla` SET name_loc5 = "***大型地下城***" WHERE id = 67;
UPDATE `AreaTable_vanilla` SET name_loc5 = "止水湖" WHERE id = 68;
UPDATE `AreaTable_vanilla` SET name_loc5 = "湖畔鎮" WHERE id = 69;
UPDATE `AreaTable_vanilla` SET name_loc5 = "石堡" WHERE id = 70;
UPDATE `AreaTable_vanilla` SET name_loc5 = "石堡瀑布" WHERE id = 71;
UPDATE `AreaTable_vanilla` SET name_loc5 = "黑暗之門" WHERE id = 72;
UPDATE `AreaTable_vanilla` SET name_loc5 = "腐爛之痕" WHERE id = 73;
UPDATE `AreaTable_vanilla` SET name_loc5 = "淚水之池" WHERE id = 74;
UPDATE `AreaTable_vanilla` SET name_loc5 = "斯通納德" WHERE id = 75;
UPDATE `AreaTable_vanilla` SET name_loc5 = "農田避難所" WHERE id = 76;
UPDATE `AreaTable_vanilla` SET name_loc5 = "安威瑪" WHERE id = 77;
UPDATE `AreaTable_vanilla` SET name_loc5 = "暴風山脈" WHERE id = 80;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Jeff NE Quadrant" WHERE id = 81;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Jeff NW Quadrant" WHERE id = 82;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Jeff SE Quadrant" WHERE id = 83;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Jeff SW Quadrant" WHERE id = 84;
UPDATE `AreaTable_vanilla` SET name_loc5 = "提里斯法林地" WHERE id = 85;
UPDATE `AreaTable_vanilla` SET name_loc5 = "石碑湖" WHERE id = 86;
UPDATE `AreaTable_vanilla` SET name_loc5 = "閃金鎮" WHERE id = 87;
UPDATE `AreaTable_vanilla` SET name_loc5 = "東谷伐木場" WHERE id = 88;
UPDATE `AreaTable_vanilla` SET name_loc5 = "明鏡湖果園" WHERE id = 89;
UPDATE `AreaTable_vanilla` SET name_loc5 = "阿祖拉之塔" WHERE id = 91;
UPDATE `AreaTable_vanilla` SET name_loc5 = "明鏡湖" WHERE id = 92;
UPDATE `AreaTable_vanilla` SET name_loc5 = "沃古爾巨魔山" WHERE id = 93;
UPDATE `AreaTable_vanilla` SET name_loc5 = "烏鴉嶺" WHERE id = 94;
UPDATE `AreaTable_vanilla` SET name_loc5 = "赤脊峽谷" WHERE id = 95;
UPDATE `AreaTable_vanilla` SET name_loc5 = "伊爾加拉之塔" WHERE id = 96;
UPDATE `AreaTable_vanilla` SET name_loc5 = "奧瑟爾伐木場" WHERE id = 97;
UPDATE `AreaTable_vanilla` SET name_loc5 = "瑞斯班洞穴" WHERE id = 98;
UPDATE `AreaTable_vanilla` SET name_loc5 = "反抗軍營地" WHERE id = 99;
UPDATE `AreaTable_vanilla` SET name_loc5 = "奈辛瓦里遠征隊營地" WHERE id = 100;
UPDATE `AreaTable_vanilla` SET name_loc5 = "庫爾森的營地" WHERE id = 101;
UPDATE `AreaTable_vanilla` SET name_loc5 = "祖昆達廢墟" WHERE id = 102;
UPDATE `AreaTable_vanilla` SET name_loc5 = "祖瑪維廢墟" WHERE id = 103;
UPDATE `AreaTable_vanilla` SET name_loc5 = "暗礁海" WHERE id = 104;
UPDATE `AreaTable_vanilla` SET name_loc5 = "莫什奧格巨魔山" WHERE id = 105;
UPDATE `AreaTable_vanilla` SET name_loc5 = "儲藏室" WHERE id = 106;
UPDATE `AreaTable_vanilla` SET name_loc5 = "薩丁農場" WHERE id = 107;
UPDATE `AreaTable_vanilla` SET name_loc5 = "哨兵嶺" WHERE id = 108;
UPDATE `AreaTable_vanilla` SET name_loc5 = "法布隆南瓜農場" WHERE id = 109;
UPDATE `AreaTable_vanilla` SET name_loc5 = "詹戈洛德礦坑" WHERE id = 111;
UPDATE `AreaTable_vanilla` SET name_loc5 = "金海岸礦坑" WHERE id = 113;
UPDATE `AreaTable_vanilla` SET name_loc5 = "西部荒野燈塔" WHERE id = 115;
UPDATE `AreaTable_vanilla` SET name_loc5 = "迷霧谷" WHERE id = 116;
UPDATE `AreaTable_vanilla` SET name_loc5 = "格羅姆高營地" WHERE id = 117;
UPDATE `AreaTable_vanilla` SET name_loc5 = "維爾加挖掘場" WHERE id = 118;
UPDATE `AreaTable_vanilla` SET name_loc5 = "西泉要塞" WHERE id = 120;
UPDATE `AreaTable_vanilla` SET name_loc5 = "靜謐花園墓場" WHERE id = 121;
UPDATE `AreaTable_vanilla` SET name_loc5 = "祖丹亞廢墟" WHERE id = 122;
UPDATE `AreaTable_vanilla` SET name_loc5 = "巴拉爾廢墟" WHERE id = 123;
UPDATE `AreaTable_vanilla` SET name_loc5 = "卡萊廢墟" WHERE id = 125;
UPDATE `AreaTable_vanilla` SET name_loc5 = "伽什廢墟" WHERE id = 126;
UPDATE `AreaTable_vanilla` SET name_loc5 = "巴里亞曼廢墟" WHERE id = 127;
UPDATE `AreaTable_vanilla` SET name_loc5 = "贊塔加廢墟" WHERE id = 128;
UPDATE `AreaTable_vanilla` SET name_loc5 = "米扎廢墟" WHERE id = 129;
UPDATE `AreaTable_vanilla` SET name_loc5 = "銀松森林" WHERE id = 130;
UPDATE `AreaTable_vanilla` SET name_loc5 = "卡拉諾斯" WHERE id = 131;
UPDATE `AreaTable_vanilla` SET name_loc5 = "寒脊山谷" WHERE id = 132;
UPDATE `AreaTable_vanilla` SET name_loc5 = "諾姆瑞根" WHERE id = 133;
UPDATE `AreaTable_vanilla` SET name_loc5 = "古博拉採掘場" WHERE id = 134;
UPDATE `AreaTable_vanilla` SET name_loc5 = "霜鬃食人妖要塞" WHERE id = 135;
UPDATE `AreaTable_vanilla` SET name_loc5 = "灰色洞穴" WHERE id = 136;
UPDATE `AreaTable_vanilla` SET name_loc5 = "烈酒村" WHERE id = 137;
UPDATE `AreaTable_vanilla` SET name_loc5 = "霧松避難所" WHERE id = 138;
UPDATE `AreaTable_vanilla` SET name_loc5 = "東瘟疫之地" WHERE id = 139;
UPDATE `AreaTable_vanilla` SET name_loc5 = "泰達希爾" WHERE id = 141;
UPDATE `AreaTable_vanilla` SET name_loc5 = "鐵環挖掘場" WHERE id = 142;
UPDATE `AreaTable_vanilla` SET name_loc5 = "莫格羅什要塞" WHERE id = 143;
UPDATE `AreaTable_vanilla` SET name_loc5 = "塞爾薩瑪" WHERE id = 144;
UPDATE `AreaTable_vanilla` SET name_loc5 = "奧加茲隘口" WHERE id = 145;
UPDATE `AreaTable_vanilla` SET name_loc5 = "巨石水壩" WHERE id = 146;
UPDATE `AreaTable_vanilla` SET name_loc5 = "旅行者營地" WHERE id = 147;
UPDATE `AreaTable_vanilla` SET name_loc5 = "黑海岸" WHERE id = 148;
UPDATE `AreaTable_vanilla` SET name_loc5 = "銀泉礦坑" WHERE id = 149;
UPDATE `AreaTable_vanilla` SET name_loc5 = "米奈希爾港" WHERE id = 150;
UPDATE `AreaTable_vanilla` SET name_loc5 = "設計者之島" WHERE id = 151;
UPDATE `AreaTable_vanilla` SET name_loc5 = "亡靈壁壘" WHERE id = 152;
UPDATE `AreaTable_vanilla` SET name_loc5 = "羅德隆廢墟" WHERE id = 153;
UPDATE `AreaTable_vanilla` SET name_loc5 = "喪鐘鎮" WHERE id = 154;
UPDATE `AreaTable_vanilla` SET name_loc5 = "夜行蜘蛛洞穴" WHERE id = 155;
UPDATE `AreaTable_vanilla` SET name_loc5 = "索利丹農場" WHERE id = 156;
UPDATE `AreaTable_vanilla` SET name_loc5 = "阿加曼德磨坊" WHERE id = 157;
UPDATE `AreaTable_vanilla` SET name_loc5 = "阿加曼德家族墓穴" WHERE id = 158;
UPDATE `AreaTable_vanilla` SET name_loc5 = "布瑞爾" WHERE id = 159;
UPDATE `AreaTable_vanilla` SET name_loc5 = "耳語花園" WHERE id = 160;
UPDATE `AreaTable_vanilla` SET name_loc5 = "休息區" WHERE id = 161;
UPDATE `AreaTable_vanilla` SET name_loc5 = "澈水湖" WHERE id = 162;
UPDATE `AreaTable_vanilla` SET name_loc5 = "岡瑟爾的居所" WHERE id = 163;
UPDATE `AreaTable_vanilla` SET name_loc5 = "加倫鬼屋" WHERE id = 164;
UPDATE `AreaTable_vanilla` SET name_loc5 = "巴尼爾農場" WHERE id = 165;
UPDATE `AreaTable_vanilla` SET name_loc5 = "爐灰莊園" WHERE id = 166;
UPDATE `AreaTable_vanilla` SET name_loc5 = "十字軍前哨" WHERE id = 167;
UPDATE `AreaTable_vanilla` SET name_loc5 = "北部海岸" WHERE id = 168;
UPDATE `AreaTable_vanilla` SET name_loc5 = "耳語海岸" WHERE id = 169;
UPDATE `AreaTable_vanilla` SET name_loc5 = "洛丹米爾湖" WHERE id = 170;
UPDATE `AreaTable_vanilla` SET name_loc5 = "芬里斯島" WHERE id = 172;
UPDATE `AreaTable_vanilla` SET name_loc5 = "法奧之墓" WHERE id = 173;
UPDATE `AreaTable_vanilla` SET name_loc5 = "多蘭納爾" WHERE id = 186;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Darnassus UNUSED" WHERE id = 187;
UPDATE `AreaTable_vanilla` SET name_loc5 = "幽影谷" WHERE id = 188;
UPDATE `AreaTable_vanilla` SET name_loc5 = "鋼架補給站" WHERE id = 189;
UPDATE `AreaTable_vanilla` SET name_loc5 = "壁爐谷" WHERE id = 190;
UPDATE `AreaTable_vanilla` SET name_loc5 = "北山伐木場" WHERE id = 192;
UPDATE `AreaTable_vanilla` SET name_loc5 = "安多哈爾廢墟" WHERE id = 193;
UPDATE `AreaTable_vanilla` SET name_loc5 = "通靈術學校" WHERE id = 195;
UPDATE `AreaTable_vanilla` SET name_loc5 = "烏瑟之墓" WHERE id = 196;
UPDATE `AreaTable_vanilla` SET name_loc5 = "悔恨嶺" WHERE id = 197;
UPDATE `AreaTable_vanilla` SET name_loc5 = "哭泣之洞" WHERE id = 198;
UPDATE `AreaTable_vanilla` SET name_loc5 = "費爾斯通農場" WHERE id = 199;
UPDATE `AreaTable_vanilla` SET name_loc5 = "達爾松之淚" WHERE id = 200;
UPDATE `AreaTable_vanilla` SET name_loc5 = "蓋羅恩農場" WHERE id = 201;
UPDATE `AreaTable_vanilla` SET name_loc5 = "嚎哭鬼屋" WHERE id = 202;
UPDATE `AreaTable_vanilla` SET name_loc5 = "瑪登霍爾德城堡" WHERE id = 203;
UPDATE `AreaTable_vanilla` SET name_loc5 = "焚木村" WHERE id = 204;
UPDATE `AreaTable_vanilla` SET name_loc5 = "丹莫德" WHERE id = 205;
UPDATE `AreaTable_vanilla` SET name_loc5 = "西部荒野" WHERE id = 206;
UPDATE `AreaTable_vanilla` SET name_loc5 = "無盡之海" WHERE id = 207;
UPDATE `AreaTable_vanilla` SET name_loc5 = "鐵甲山谷" WHERE id = 208;
UPDATE `AreaTable_vanilla` SET name_loc5 = "影牙城堡" WHERE id = 209;
UPDATE `AreaTable_vanilla` SET name_loc5 = "***大型地下城***" WHERE id = 210;
UPDATE `AreaTable_vanilla` SET name_loc5 = "湧冰湖" WHERE id = 211;
UPDATE `AreaTable_vanilla` SET name_loc5 = "盔枕湖" WHERE id = 212;
UPDATE `AreaTable_vanilla` SET name_loc5 = "埃利姆礦坑" WHERE id = 213;
UPDATE `AreaTable_vanilla` SET name_loc5 = "無盡之海" WHERE id = 214;
UPDATE `AreaTable_vanilla` SET name_loc5 = "莫高雷" WHERE id = 215;
UPDATE `AreaTable_vanilla` SET name_loc5 = "艾力克斯頓農場" WHERE id = 219;
UPDATE `AreaTable_vanilla` SET name_loc5 = "紅雲台地" WHERE id = 220;
UPDATE `AreaTable_vanilla` SET name_loc5 = "納拉其營地" WHERE id = 221;
UPDATE `AreaTable_vanilla` SET name_loc5 = "血蹄村" WHERE id = 222;
UPDATE `AreaTable_vanilla` SET name_loc5 = "石牛湖" WHERE id = 223;
UPDATE `AreaTable_vanilla` SET name_loc5 = "被破壞的貨車" WHERE id = 224;
UPDATE `AreaTable_vanilla` SET name_loc5 = "赤色石" WHERE id = 225;
UPDATE `AreaTable_vanilla` SET name_loc5 = "粘絲洞" WHERE id = 226;
UPDATE `AreaTable_vanilla` SET name_loc5 = "瓦爾甘牧場" WHERE id = 227;
UPDATE `AreaTable_vanilla` SET name_loc5 = "瑟伯切爾" WHERE id = 228;
UPDATE `AreaTable_vanilla` SET name_loc5 = "奧森農場" WHERE id = 229;
UPDATE `AreaTable_vanilla` SET name_loc5 = "格雷邁恩之牆" WHERE id = 230;
UPDATE `AreaTable_vanilla` SET name_loc5 = "博倫的巢穴" WHERE id = 231;
UPDATE `AreaTable_vanilla` SET name_loc5 = "黎明島" WHERE id = 232;
UPDATE `AreaTable_vanilla` SET name_loc5 = "安伯米爾" WHERE id = 233;
UPDATE `AreaTable_vanilla` SET name_loc5 = "芬里斯城堡" WHERE id = 235;
UPDATE `AreaTable_vanilla` SET name_loc5 = "影牙城堡" WHERE id = 236;
UPDATE `AreaTable_vanilla` SET name_loc5 = "破舊渡口" WHERE id = 237;
UPDATE `AreaTable_vanilla` SET name_loc5 = "瑪爾丁果園" WHERE id = 238;
UPDATE `AreaTable_vanilla` SET name_loc5 = "伊瓦農場" WHERE id = 239;
UPDATE `AreaTable_vanilla` SET name_loc5 = "亡者農場" WHERE id = 240;
UPDATE `AreaTable_vanilla` SET name_loc5 = "爛果園" WHERE id = 241;
UPDATE `AreaTable_vanilla` SET name_loc5 = "陽光樹林" WHERE id = 242;
UPDATE `AreaTable_vanilla` SET name_loc5 = "荒棄鬼屋" WHERE id = 243;
UPDATE `AreaTable_vanilla` SET name_loc5 = "維普爾莊園" WHERE id = 244;
UPDATE `AreaTable_vanilla` SET name_loc5 = "猶根農場" WHERE id = 245;
UPDATE `AreaTable_vanilla` SET name_loc5 = "大熔爐" WHERE id = 246;
UPDATE `AreaTable_vanilla` SET name_loc5 = "煤渣挖掘場" WHERE id = 247;
UPDATE `AreaTable_vanilla` SET name_loc5 = "巨槌石" WHERE id = 249;
UPDATE `AreaTable_vanilla` SET name_loc5 = "索瑞森廢墟" WHERE id = 250;
UPDATE `AreaTable_vanilla` SET name_loc5 = "烈焰峰" WHERE id = 251;
UPDATE `AreaTable_vanilla` SET name_loc5 = "黑石要塞" WHERE id = 252;
UPDATE `AreaTable_vanilla` SET name_loc5 = "灰燼之柱" WHERE id = 253;
UPDATE `AreaTable_vanilla` SET name_loc5 = "黑石山" WHERE id = 254;
UPDATE `AreaTable_vanilla` SET name_loc5 = "暴風祭壇" WHERE id = 255;
UPDATE `AreaTable_vanilla` SET name_loc5 = "奧達希爾" WHERE id = 256;
UPDATE `AreaTable_vanilla` SET name_loc5 = "影絲洞" WHERE id = 257;
UPDATE `AreaTable_vanilla` SET name_loc5 = "地獄石" WHERE id = 258;
UPDATE `AreaTable_vanilla` SET name_loc5 = "奧拉密斯湖" WHERE id = 259;
UPDATE `AreaTable_vanilla` SET name_loc5 = "星風村" WHERE id = 260;
UPDATE `AreaTable_vanilla` SET name_loc5 = "脊骨堡" WHERE id = 261;
UPDATE `AreaTable_vanilla` SET name_loc5 = "班奈希爾獸穴" WHERE id = 262;
UPDATE `AreaTable_vanilla` SET name_loc5 = "大斷崖" WHERE id = 263;
UPDATE `AreaTable_vanilla` SET name_loc5 = "神諭林地" WHERE id = 264;
UPDATE `AreaTable_vanilla` SET name_loc5 = "湧泉河" WHERE id = 265;
UPDATE `AreaTable_vanilla` SET name_loc5 = "湧泉湖" WHERE id = 266;
UPDATE `AreaTable_vanilla` SET name_loc5 = "希爾斯布萊德丘陵" WHERE id = 267;
UPDATE `AreaTable_vanilla` SET name_loc5 = "艾薩拉盆地" WHERE id = 268;
UPDATE `AreaTable_vanilla` SET name_loc5 = "丹奧加茲" WHERE id = 269;
UPDATE `AreaTable_vanilla` SET name_loc5 = "南海鎮" WHERE id = 271;
UPDATE `AreaTable_vanilla` SET name_loc5 = "塔倫米爾" WHERE id = 272;
UPDATE `AreaTable_vanilla` SET name_loc5 = "敦霍爾德城堡" WHERE id = 275;
UPDATE `AreaTable_vanilla` SET name_loc5 = "UNUSED Stonewrought Pass" WHERE id = 276;
UPDATE `AreaTable_vanilla` SET name_loc5 = "丘陵洞穴" WHERE id = 277;
UPDATE `AreaTable_vanilla` SET name_loc5 = "洛丹米爾收容所" WHERE id = 278;
UPDATE `AreaTable_vanilla` SET name_loc5 = "達拉然" WHERE id = 279;
UPDATE `AreaTable_vanilla` SET name_loc5 = "斯坦恩布萊德" WHERE id = 280;
UPDATE `AreaTable_vanilla` SET name_loc5 = "奧特蘭克廢墟" WHERE id = 281;
UPDATE `AreaTable_vanilla` SET name_loc5 = "破碎嶺城堡" WHERE id = 282;
UPDATE `AreaTable_vanilla` SET name_loc5 = "屠殺谷" WHERE id = 283;
UPDATE `AreaTable_vanilla` SET name_loc5 = "高地" WHERE id = 284;
UPDATE `AreaTable_vanilla` SET name_loc5 = "南點哨塔" WHERE id = 285;
UPDATE `AreaTable_vanilla` SET name_loc5 = "希爾斯布萊德農場" WHERE id = 286;
UPDATE `AreaTable_vanilla` SET name_loc5 = "希爾斯布萊德" WHERE id = 287;
UPDATE `AreaTable_vanilla` SET name_loc5 = "碧玉礦坑" WHERE id = 288;
UPDATE `AreaTable_vanilla` SET name_loc5 = "奈杉德崗哨" WHERE id = 289;
UPDATE `AreaTable_vanilla` SET name_loc5 = "丹加洛克" WHERE id = 290;
UPDATE `AreaTable_vanilla` SET name_loc5 = "索拉丁之牆" WHERE id = 293;
UPDATE `AreaTable_vanilla` SET name_loc5 = "東部海灘" WHERE id = 294;
UPDATE `AreaTable_vanilla` SET name_loc5 = "西部海岸" WHERE id = 295;
UPDATE `AreaTable_vanilla` SET name_loc5 = "South Seas UNUSED" WHERE id = 296;
UPDATE `AreaTable_vanilla` SET name_loc5 = "哈圭羅島" WHERE id = 297;
UPDATE `AreaTable_vanilla` SET name_loc5 = "巴拉丁海灣" WHERE id = 298;
UPDATE `AreaTable_vanilla` SET name_loc5 = "米奈希爾海灣" WHERE id = 299;
UPDATE `AreaTable_vanilla` SET name_loc5 = "蘆葦海灘" WHERE id = 300;
UPDATE `AreaTable_vanilla` SET name_loc5 = "野人海岸" WHERE id = 301;
UPDATE `AreaTable_vanilla` SET name_loc5 = "水晶海岸" WHERE id = 302;
UPDATE `AreaTable_vanilla` SET name_loc5 = "貝殼海灘" WHERE id = 303;
UPDATE `AreaTable_vanilla` SET name_loc5 = "北流海岸" WHERE id = 305;
UPDATE `AreaTable_vanilla` SET name_loc5 = "南流海岸" WHERE id = 306;
UPDATE `AreaTable_vanilla` SET name_loc5 = "望海崖" WHERE id = 307;
UPDATE `AreaTable_vanilla` SET name_loc5 = "禁忌之海" WHERE id = 308;
UPDATE `AreaTable_vanilla` SET name_loc5 = "鐵鬚之墓" WHERE id = 309;
UPDATE `AreaTable_vanilla` SET name_loc5 = "水晶礦坑" WHERE id = 310;
UPDATE `AreaTable_vanilla` SET name_loc5 = "阿博拉茲廢墟" WHERE id = 311;
UPDATE `AreaTable_vanilla` SET name_loc5 = "加尼羅哨站" WHERE id = 312;
UPDATE `AreaTable_vanilla` SET name_loc5 = "諾斯弗德農場" WHERE id = 313;
UPDATE `AreaTable_vanilla` SET name_loc5 = "格沙克農場" WHERE id = 314;
UPDATE `AreaTable_vanilla` SET name_loc5 = "達比雷農場" WHERE id = 315;
UPDATE `AreaTable_vanilla` SET name_loc5 = "石拳大廳" WHERE id = 316;
UPDATE `AreaTable_vanilla` SET name_loc5 = "枯木村" WHERE id = 317;
UPDATE `AreaTable_vanilla` SET name_loc5 = "枯鬚峽谷" WHERE id = 318;
UPDATE `AreaTable_vanilla` SET name_loc5 = "避難谷地" WHERE id = 320;
UPDATE `AreaTable_vanilla` SET name_loc5 = "落錘鎮" WHERE id = 321;
UPDATE `AreaTable_vanilla` SET name_loc5 = "黑水灣沉船" WHERE id = 322;
UPDATE `AreaTable_vanilla` SET name_loc5 = "奧布瑞恩營地" WHERE id = 323;
UPDATE `AreaTable_vanilla` SET name_loc5 = "激流堡" WHERE id = 324;
UPDATE `AreaTable_vanilla` SET name_loc5 = "阿拉索之塔" WHERE id = 325;
UPDATE `AreaTable_vanilla` SET name_loc5 = "密室" WHERE id = 326;
UPDATE `AreaTable_vanilla` SET name_loc5 = "法迪爾海灣" WHERE id = 327;
UPDATE `AreaTable_vanilla` SET name_loc5 = "水下暗礁" WHERE id = 328;
UPDATE `AreaTable_vanilla` SET name_loc5 = "薩多爾大橋" WHERE id = 330;
UPDATE `AreaTable_vanilla` SET name_loc5 = "梣谷" WHERE id = 331;
UPDATE `AreaTable_vanilla` SET name_loc5 = "無盡之海" WHERE id = 332;
UPDATE `AreaTable_vanilla` SET name_loc5 = "東部禁錮法陣" WHERE id = 333;
UPDATE `AreaTable_vanilla` SET name_loc5 = "西部禁錮法陣" WHERE id = 334;
UPDATE `AreaTable_vanilla` SET name_loc5 = "內禁錮法陣" WHERE id = 335;
UPDATE `AreaTable_vanilla` SET name_loc5 = "外禁錮法陣" WHERE id = 336;
UPDATE `AreaTable_vanilla` SET name_loc5 = "聖者之陵" WHERE id = 337;
UPDATE `AreaTable_vanilla` SET name_loc5 = "苦痛堡壘" WHERE id = 338;
UPDATE `AreaTable_vanilla` SET name_loc5 = "萊瑟羅峽谷" WHERE id = 339;
UPDATE `AreaTable_vanilla` SET name_loc5 = "卡加斯" WHERE id = 340;
UPDATE `AreaTable_vanilla` SET name_loc5 = "柯什營地" WHERE id = 341;
UPDATE `AreaTable_vanilla` SET name_loc5 = "博夫營地" WHERE id = 342;
UPDATE `AreaTable_vanilla` SET name_loc5 = "瓦格營地" WHERE id = 343;
UPDATE `AreaTable_vanilla` SET name_loc5 = "卡格營地" WHERE id = 344;
UPDATE `AreaTable_vanilla` SET name_loc5 = "埃格蒙德的營地" WHERE id = 345;
UPDATE `AreaTable_vanilla` SET name_loc5 = "鐵趾挖掘場" WHERE id = 346;
UPDATE `AreaTable_vanilla` SET name_loc5 = "火山洞穴" WHERE id = 347;
UPDATE `AreaTable_vanilla` SET name_loc5 = "鷹巢山" WHERE id = 348;
UPDATE `AreaTable_vanilla` SET name_loc5 = "蠻錘城堡" WHERE id = 349;
UPDATE `AreaTable_vanilla` SET name_loc5 = "奎爾丹尼小屋" WHERE id = 350;
UPDATE `AreaTable_vanilla` SET name_loc5 = "隱匿石" WHERE id = 351;
UPDATE `AreaTable_vanilla` SET name_loc5 = "祖瓦沙" WHERE id = 352;
UPDATE `AreaTable_vanilla` SET name_loc5 = "沙德拉洛" WHERE id = 353;
UPDATE `AreaTable_vanilla` SET name_loc5 = "辛薩羅" WHERE id = 354;
UPDATE `AreaTable_vanilla` SET name_loc5 = "祖爾祭壇" WHERE id = 355;
UPDATE `AreaTable_vanilla` SET name_loc5 = "瑟拉丹" WHERE id = 356;
UPDATE `AreaTable_vanilla` SET name_loc5 = "菲拉斯" WHERE id = 357;
UPDATE `AreaTable_vanilla` SET name_loc5 = "刺刃峽谷" WHERE id = 358;
UPDATE `AreaTable_vanilla` SET name_loc5 = "巴爾莫丹" WHERE id = 359;
UPDATE `AreaTable_vanilla` SET name_loc5 = "風險投資公司礦坑" WHERE id = 360;
UPDATE `AreaTable_vanilla` SET name_loc5 = "費伍德森林" WHERE id = 361;
UPDATE `AreaTable_vanilla` SET name_loc5 = "剃刀嶺" WHERE id = 362;
UPDATE `AreaTable_vanilla` SET name_loc5 = "試煉谷" WHERE id = 363;
UPDATE `AreaTable_vanilla` SET name_loc5 = "大獸穴" WHERE id = 364;
UPDATE `AreaTable_vanilla` SET name_loc5 = "火刃集會所" WHERE id = 365;
UPDATE `AreaTable_vanilla` SET name_loc5 = "科卡爾峭壁" WHERE id = 366;
UPDATE `AreaTable_vanilla` SET name_loc5 = "森金村" WHERE id = 367;
UPDATE `AreaTable_vanilla` SET name_loc5 = "回音群島" WHERE id = 368;
UPDATE `AreaTable_vanilla` SET name_loc5 = "雷霆山" WHERE id = 369;
UPDATE `AreaTable_vanilla` SET name_loc5 = "枯水谷" WHERE id = 370;
UPDATE `AreaTable_vanilla` SET name_loc5 = "塵風洞穴" WHERE id = 371;
UPDATE `AreaTable_vanilla` SET name_loc5 = "提拉加德城堡" WHERE id = 372;
UPDATE `AreaTable_vanilla` SET name_loc5 = "流亡海岸" WHERE id = 373;
UPDATE `AreaTable_vanilla` SET name_loc5 = "刃拳海灣" WHERE id = 374;
UPDATE `AreaTable_vanilla` SET name_loc5 = "死眼海岸" WHERE id = 375;
UPDATE `AreaTable_vanilla` SET name_loc5 = "怒水河" WHERE id = 377;
UPDATE `AreaTable_vanilla` SET name_loc5 = "陶拉祖營地" WHERE id = 378;
UPDATE `AreaTable_vanilla` SET name_loc5 = "前沿哨所" WHERE id = 379;
UPDATE `AreaTable_vanilla` SET name_loc5 = "十字路口" WHERE id = 380;
UPDATE `AreaTable_vanilla` SET name_loc5 = "石礦坑" WHERE id = 381;
UPDATE `AreaTable_vanilla` SET name_loc5 = "淤泥沼澤" WHERE id = 382;
UPDATE `AreaTable_vanilla` SET name_loc5 = "無水嶺" WHERE id = 383;
UPDATE `AreaTable_vanilla` SET name_loc5 = "鬼霧峰" WHERE id = 384;
UPDATE `AreaTable_vanilla` SET name_loc5 = "北方城堡" WHERE id = 385;
UPDATE `AreaTable_vanilla` SET name_loc5 = "遺忘之池" WHERE id = 386;
UPDATE `AreaTable_vanilla` SET name_loc5 = "甜水綠洲" WHERE id = 387;
UPDATE `AreaTable_vanilla` SET name_loc5 = "死水綠洲" WHERE id = 388;
UPDATE `AreaTable_vanilla` SET name_loc5 = "巨人曠野" WHERE id = 390;
UPDATE `AreaTable_vanilla` SET name_loc5 = "商旅海岸" WHERE id = 391;
UPDATE `AreaTable_vanilla` SET name_loc5 = "棘齒城" WHERE id = 392;
UPDATE `AreaTable_vanilla` SET name_loc5 = "暗矛海灘" WHERE id = 393;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Darrowmere Lake UNUSED" WHERE id = 394;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Caer Darrow UNUSED" WHERE id = 395;
UPDATE `AreaTable_vanilla` SET name_loc5 = "冰蹄水井" WHERE id = 396;
UPDATE `AreaTable_vanilla` SET name_loc5 = "雷角水井" WHERE id = 397;
UPDATE `AreaTable_vanilla` SET name_loc5 = "蠻鬃水井" WHERE id = 398;
UPDATE `AreaTable_vanilla` SET name_loc5 = "沖天嶺" WHERE id = 399;
UPDATE `AreaTable_vanilla` SET name_loc5 = "千針石林" WHERE id = 400;
UPDATE `AreaTable_vanilla` SET name_loc5 = "提度斯階梯" WHERE id = 401;
UPDATE `AreaTable_vanilla` SET name_loc5 = "樹蔭旅店" WHERE id = 403;
UPDATE `AreaTable_vanilla` SET name_loc5 = "巴爾丹挖掘場" WHERE id = 404;
UPDATE `AreaTable_vanilla` SET name_loc5 = "淒涼之地" WHERE id = 405;
UPDATE `AreaTable_vanilla` SET name_loc5 = "石爪山脈" WHERE id = 406;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Orgrimmar UNUSED" WHERE id = 407;
UPDATE `AreaTable_vanilla` SET name_loc5 = "吉利吉姆之島" WHERE id = 408;
UPDATE `AreaTable_vanilla` SET name_loc5 = "拉匹迪斯之島" WHERE id = 409;
UPDATE `AreaTable_vanilla` SET name_loc5 = "烈風峽谷" WHERE id = 410;
UPDATE `AreaTable_vanilla` SET name_loc5 = "巴斯蘭鬼屋" WHERE id = 411;
UPDATE `AreaTable_vanilla` SET name_loc5 = "奧迪拉蘭廢墟" WHERE id = 412;
UPDATE `AreaTable_vanilla` SET name_loc5 = "邁斯特拉崗哨" WHERE id = 413;
UPDATE `AreaTable_vanilla` SET name_loc5 = "佐拉姆海岸" WHERE id = 414;
UPDATE `AreaTable_vanilla` SET name_loc5 = "阿斯特蘭納" WHERE id = 415;
UPDATE `AreaTable_vanilla` SET name_loc5 = "艾森娜神殿" WHERE id = 416;
UPDATE `AreaTable_vanilla` SET name_loc5 = "火痕神殿" WHERE id = 417;
UPDATE `AreaTable_vanilla` SET name_loc5 = "星塵廢墟" WHERE id = 418;
UPDATE `AreaTable_vanilla` SET name_loc5 = "狼嚎谷" WHERE id = 419;
UPDATE `AreaTable_vanilla` SET name_loc5 = "銀風避難所" WHERE id = 420;
UPDATE `AreaTable_vanilla` SET name_loc5 = "密斯特拉湖" WHERE id = 421;
UPDATE `AreaTable_vanilla` SET name_loc5 = "墜星湖" WHERE id = 422;
UPDATE `AreaTable_vanilla` SET name_loc5 = "伊瑞斯湖" WHERE id = 424;
UPDATE `AreaTable_vanilla` SET name_loc5 = "月井" WHERE id = 425;
UPDATE `AreaTable_vanilla` SET name_loc5 = "林中樹居" WHERE id = 426;
UPDATE `AreaTable_vanilla` SET name_loc5 = "林蔭小徑" WHERE id = 427;
UPDATE `AreaTable_vanilla` SET name_loc5 = "夜道谷" WHERE id = 428;
UPDATE `AreaTable_vanilla` SET name_loc5 = "薩維亞" WHERE id = 429;
UPDATE `AreaTable_vanilla` SET name_loc5 = "薩提納爾" WHERE id = 430;
UPDATE `AreaTable_vanilla` SET name_loc5 = "碎木崗哨" WHERE id = 431;
UPDATE `AreaTable_vanilla` SET name_loc5 = "朵丹尼爾獸穴" WHERE id = 432;
UPDATE `AreaTable_vanilla` SET name_loc5 = "弗倫河" WHERE id = 433;
UPDATE `AreaTable_vanilla` SET name_loc5 = "冥火嶺" WHERE id = 434;
UPDATE `AreaTable_vanilla` SET name_loc5 = "屠魔峽谷" WHERE id = 435;
UPDATE `AreaTable_vanilla` SET name_loc5 = "屠魔山" WHERE id = 436;
UPDATE `AreaTable_vanilla` SET name_loc5 = "戰歌伐木場" WHERE id = 437;
UPDATE `AreaTable_vanilla` SET name_loc5 = "大樹蔭" WHERE id = 438;
UPDATE `AreaTable_vanilla` SET name_loc5 = "閃光平原" WHERE id = 439;
UPDATE `AreaTable_vanilla` SET name_loc5 = "塔納利斯" WHERE id = 440;
UPDATE `AreaTable_vanilla` SET name_loc5 = "法拉希姆湖" WHERE id = 441;
UPDATE `AreaTable_vanilla` SET name_loc5 = "奧伯丁" WHERE id = 442;
UPDATE `AreaTable_vanilla` SET name_loc5 = "瑪塞斯特拉廢墟" WHERE id = 443;
UPDATE `AreaTable_vanilla` SET name_loc5 = "奧薩拉克斯之塔" WHERE id = 444;
UPDATE `AreaTable_vanilla` SET name_loc5 = "峭壁之泉" WHERE id = 445;
UPDATE `AreaTable_vanilla` SET name_loc5 = "巴莎蘭" WHERE id = 446;
UPDATE `AreaTable_vanilla` SET name_loc5 = "亞米薩蘭" WHERE id = 447;
UPDATE `AreaTable_vanilla` SET name_loc5 = "古樹之林" WHERE id = 448;
UPDATE `AreaTable_vanilla` SET name_loc5 = "主宰之劍" WHERE id = 449;
UPDATE `AreaTable_vanilla` SET name_loc5 = "雷姆塔維爾挖掘場" WHERE id = 450;
UPDATE `AreaTable_vanilla` SET name_loc5 = "薄霧海" WHERE id = 452;
UPDATE `AreaTable_vanilla` SET name_loc5 = "長橋碼頭" WHERE id = 453;
UPDATE `AreaTable_vanilla` SET name_loc5 = "急彎河" WHERE id = 454;
UPDATE `AreaTable_vanilla` SET name_loc5 = "黑木洞穴" WHERE id = 455;
UPDATE `AreaTable_vanilla` SET name_loc5 = "壁泉河" WHERE id = 456;
UPDATE `AreaTable_vanilla` SET name_loc5 = "迷霧之海" WHERE id = 457;
UPDATE `AreaTable_vanilla` SET name_loc5 = "黃金之路" WHERE id = 458;
UPDATE `AreaTable_vanilla` SET name_loc5 = "血色十字軍崗哨" WHERE id = 459;
UPDATE `AreaTable_vanilla` SET name_loc5 = "烈日石居" WHERE id = 460;
UPDATE `AreaTable_vanilla` SET name_loc5 = "狂風峭壁" WHERE id = 461;
UPDATE `AreaTable_vanilla` SET name_loc5 = "峭壁湖" WHERE id = 463;
UPDATE `AreaTable_vanilla` SET name_loc5 = "暗色湖" WHERE id = 464;
UPDATE `AreaTable_vanilla` SET name_loc5 = "焦炭谷" WHERE id = 465;
UPDATE `AreaTable_vanilla` SET name_loc5 = "血怒峽谷" WHERE id = 466;
UPDATE `AreaTable_vanilla` SET name_loc5 = "石爪峰" WHERE id = 467;
UPDATE `AreaTable_vanilla` SET name_loc5 = "猛禽洞穴" WHERE id = 468;
UPDATE `AreaTable_vanilla` SET name_loc5 = "巨木谷" WHERE id = 469;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Thunder Bluff UNUSED" WHERE id = 470;
UPDATE `AreaTable_vanilla` SET name_loc5 = "強風台地" WHERE id = 471;
UPDATE `AreaTable_vanilla` SET name_loc5 = "火石台地" WHERE id = 472;
UPDATE `AreaTable_vanilla` SET name_loc5 = "披肩石" WHERE id = 473;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Hunter Rise UNUSED" WHERE id = 474;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Spirit RiseUNUSED" WHERE id = 475;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Elder RiseUNUSED" WHERE id = 476;
UPDATE `AreaTable_vanilla` SET name_loc5 = "朱布瓦爾廢墟" WHERE id = 477;
UPDATE `AreaTable_vanilla` SET name_loc5 = "亞里斯瑞恩之池" WHERE id = 478;
UPDATE `AreaTable_vanilla` SET name_loc5 = "鏽錘挖掘場" WHERE id = 479;
UPDATE `AreaTable_vanilla` SET name_loc5 = "伊索克營地" WHERE id = 480;
UPDATE `AreaTable_vanilla` SET name_loc5 = "裂蹄峭壁" WHERE id = 481;
UPDATE `AreaTable_vanilla` SET name_loc5 = "風巢" WHERE id = 482;
UPDATE `AreaTable_vanilla` SET name_loc5 = "尖嘯峽谷" WHERE id = 483;
UPDATE `AreaTable_vanilla` SET name_loc5 = "亂風崗" WHERE id = 484;
UPDATE `AreaTable_vanilla` SET name_loc5 = "升降梯" WHERE id = 485;
UPDATE `AreaTable_vanilla` SET name_loc5 = "加拉克城堡" WHERE id = 486;
UPDATE `AreaTable_vanilla` SET name_loc5 = "飛羽洞穴" WHERE id = 487;
UPDATE `AreaTable_vanilla` SET name_loc5 = "老屋" WHERE id = 488;
UPDATE `AreaTable_vanilla` SET name_loc5 = "薩蘭納爾" WHERE id = 489;
UPDATE `AreaTable_vanilla` SET name_loc5 = "安戈洛環形山" WHERE id = 490;
UPDATE `AreaTable_vanilla` SET name_loc5 = "剃刀沼澤" WHERE id = 491;
UPDATE `AreaTable_vanilla` SET name_loc5 = "烏鴉嶺墓園" WHERE id = 492;
UPDATE `AreaTable_vanilla` SET name_loc5 = "月光林地" WHERE id = 493;
UPDATE `AreaTable_vanilla` SET name_loc5 = "DELETE ME" WHERE id = 495;
UPDATE `AreaTable_vanilla` SET name_loc5 = "蕨牆村" WHERE id = 496;
UPDATE `AreaTable_vanilla` SET name_loc5 = "水光莊園" WHERE id = 497;
UPDATE `AreaTable_vanilla` SET name_loc5 = "鮮血沼澤墓穴" WHERE id = 498;
UPDATE `AreaTable_vanilla` SET name_loc5 = "暗霧洞穴" WHERE id = 499;
UPDATE `AreaTable_vanilla` SET name_loc5 = "摩戈爾哨塔" WHERE id = 500;
UPDATE `AreaTable_vanilla` SET name_loc5 = "比吉爾的飛艇殘骸" WHERE id = 501;
UPDATE `AreaTable_vanilla` SET name_loc5 = "女巫嶺" WHERE id = 502;
UPDATE `AreaTable_vanilla` SET name_loc5 = "警戒崗哨" WHERE id = 503;
UPDATE `AreaTable_vanilla` SET name_loc5 = "北點哨塔" WHERE id = 504;
UPDATE `AreaTable_vanilla` SET name_loc5 = "西點哨塔" WHERE id = 505;
UPDATE `AreaTable_vanilla` SET name_loc5 = "廢棄哨塔" WHERE id = 506;
UPDATE `AreaTable_vanilla` SET name_loc5 = "藍色沼澤" WHERE id = 507;
UPDATE `AreaTable_vanilla` SET name_loc5 = "石槌廢墟" WHERE id = 508;
UPDATE `AreaTable_vanilla` SET name_loc5 = "火焰洞穴" WHERE id = 509;
UPDATE `AreaTable_vanilla` SET name_loc5 = "黑龍谷" WHERE id = 510;
UPDATE `AreaTable_vanilla` SET name_loc5 = "巨龍沼澤" WHERE id = 511;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Onyxia's Lair UNUSED" WHERE id = 512;
UPDATE `AreaTable_vanilla` SET name_loc5 = "塞拉摩島" WHERE id = 513;
UPDATE `AreaTable_vanilla` SET name_loc5 = "塞拉摩堡壘" WHERE id = 514;
UPDATE `AreaTable_vanilla` SET name_loc5 = "鐵欄監獄" WHERE id = 515;
UPDATE `AreaTable_vanilla` SET name_loc5 = "塵泥海灣" WHERE id = 516;
UPDATE `AreaTable_vanilla` SET name_loc5 = "狂潮灣" WHERE id = 517;
UPDATE `AreaTable_vanilla` SET name_loc5 = "恐懼海岸" WHERE id = 518;
UPDATE `AreaTable_vanilla` SET name_loc5 = "腐草農場" WHERE id = 536;
UPDATE `AreaTable_vanilla` SET name_loc5 = "火羽山" WHERE id = 537;
UPDATE `AreaTable_vanilla` SET name_loc5 = "拉卡利油沼" WHERE id = 538;
UPDATE `AreaTable_vanilla` SET name_loc5 = "恐懼小道" WHERE id = 539;
UPDATE `AreaTable_vanilla` SET name_loc5 = "巨痕谷" WHERE id = 540;
UPDATE `AreaTable_vanilla` SET name_loc5 = "馬紹爾營地" WHERE id = 541;
UPDATE `AreaTable_vanilla` SET name_loc5 = "蘑菇石" WHERE id = 542;
UPDATE `AreaTable_vanilla` SET name_loc5 = "葛拉卡溫泉" WHERE id = 543;
UPDATE `AreaTable_vanilla` SET name_loc5 = "洛克湖" WHERE id = 556;
UPDATE `AreaTable_vanilla` SET name_loc5 = "乞丐鬼屋" WHERE id = 576;
UPDATE `AreaTable_vanilla` SET name_loc5 = "科多獸墳場" WHERE id = 596;
UPDATE `AreaTable_vanilla` SET name_loc5 = "幽靈崗哨" WHERE id = 597;
UPDATE `AreaTable_vanilla` SET name_loc5 = "薩瑟里斯海岸" WHERE id = 598;
UPDATE `AreaTable_vanilla` SET name_loc5 = "雷斧堡壘" WHERE id = 599;
UPDATE `AreaTable_vanilla` SET name_loc5 = "波爾甘的洞穴" WHERE id = 600;
UPDATE `AreaTable_vanilla` SET name_loc5 = "瑪諾洛克集會所" WHERE id = 602;
UPDATE `AreaTable_vanilla` SET name_loc5 = "薩格隆" WHERE id = 603;
UPDATE `AreaTable_vanilla` SET name_loc5 = "瑪格拉姆村" WHERE id = 604;
UPDATE `AreaTable_vanilla` SET name_loc5 = "吉爾吉斯村" WHERE id = 606;
UPDATE `AreaTable_vanilla` SET name_loc5 = "長矛谷" WHERE id = 607;
UPDATE `AreaTable_vanilla` SET name_loc5 = "尼耶爾前哨站" WHERE id = 608;
UPDATE `AreaTable_vanilla` SET name_loc5 = "科卡爾村" WHERE id = 609;
UPDATE `AreaTable_vanilla` SET name_loc5 = "海加爾山" WHERE id = 616;
UPDATE `AreaTable_vanilla` SET name_loc5 = "冬泉谷" WHERE id = 618;
UPDATE `AreaTable_vanilla` SET name_loc5 = "黑狼河" WHERE id = 636;
UPDATE `AreaTable_vanilla` SET name_loc5 = "科多石" WHERE id = 637;
UPDATE `AreaTable_vanilla` SET name_loc5 = "秘道" WHERE id = 638;
UPDATE `AreaTable_vanilla` SET name_loc5 = "靈魂石地" WHERE id = 639;
UPDATE `AreaTable_vanilla` SET name_loc5 = "眠炎聖殿" WHERE id = 640;
UPDATE `AreaTable_vanilla` SET name_loc5 = "月神湖" WHERE id = 656;
UPDATE `AreaTable_vanilla` SET name_loc5 = "避難營" WHERE id = 657;
UPDATE `AreaTable_vanilla` SET name_loc5 = "外域" WHERE id = 676;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Craftsmen's Terrace UNUSED" WHERE id = 696;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Tradesmen's Terrace UNUSED" WHERE id = 697;
UPDATE `AreaTable_vanilla` SET name_loc5 = "The Temple Gardens UNUSED" WHERE id = 698;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Temple of Elune UNUSED" WHERE id = 699;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Cenarion Enclave UNUSED" WHERE id = 700;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Warrior's Terrace UNUSED" WHERE id = 701;
UPDATE `AreaTable_vanilla` SET name_loc5 = "魯瑟蘭村" WHERE id = 702;
UPDATE `AreaTable_vanilla` SET name_loc5 = "鐵環營地" WHERE id = 716;
UPDATE `AreaTable_vanilla` SET name_loc5 = "監獄" WHERE id = 717;
UPDATE `AreaTable_vanilla` SET name_loc5 = "哀嚎洞穴" WHERE id = 718;
UPDATE `AreaTable_vanilla` SET name_loc5 = "黑暗深淵" WHERE id = 719;
UPDATE `AreaTable_vanilla` SET name_loc5 = "勇士島" WHERE id = 720;
UPDATE `AreaTable_vanilla` SET name_loc5 = "諾姆瑞根" WHERE id = 721;
UPDATE `AreaTable_vanilla` SET name_loc5 = "剃刀高地" WHERE id = 722;
UPDATE `AreaTable_vanilla` SET name_loc5 = "班尼希爾山谷" WHERE id = 736;
UPDATE `AreaTable_vanilla` SET name_loc5 = "血色修道院" WHERE id = 796;
UPDATE `AreaTable_vanilla` SET name_loc5 = "傑羅德碼頭" WHERE id = 797;
UPDATE `AreaTable_vanilla` SET name_loc5 = "山巔之塔" WHERE id = 798;
UPDATE `AreaTable_vanilla` SET name_loc5 = "暗色河灘" WHERE id = 799;
UPDATE `AreaTable_vanilla` SET name_loc5 = "寒脊山小徑" WHERE id = 800;
UPDATE `AreaTable_vanilla` SET name_loc5 = "寒風峽谷" WHERE id = 801;
UPDATE `AreaTable_vanilla` SET name_loc5 = "閃光嶺" WHERE id = 802;
UPDATE `AreaTable_vanilla` SET name_loc5 = "凍石農場" WHERE id = 803;
UPDATE `AreaTable_vanilla` SET name_loc5 = "凍土嶺" WHERE id = 804;
UPDATE `AreaTable_vanilla` SET name_loc5 = "南門小徑" WHERE id = 805;
UPDATE `AreaTable_vanilla` SET name_loc5 = "南門崗哨" WHERE id = 806;
UPDATE `AreaTable_vanilla` SET name_loc5 = "北門小徑" WHERE id = 807;
UPDATE `AreaTable_vanilla` SET name_loc5 = "北門崗哨" WHERE id = 808;
UPDATE `AreaTable_vanilla` SET name_loc5 = "鐵爐堡大門" WHERE id = 809;
UPDATE `AreaTable_vanilla` SET name_loc5 = "靜水池" WHERE id = 810;
UPDATE `AreaTable_vanilla` SET name_loc5 = "噩夢谷" WHERE id = 811;
UPDATE `AreaTable_vanilla` SET name_loc5 = "毒蛛峽谷" WHERE id = 812;
UPDATE `AreaTable_vanilla` SET name_loc5 = "亡靈壁壘" WHERE id = 813;
UPDATE `AreaTable_vanilla` SET name_loc5 = "怒水河" WHERE id = 814;
UPDATE `AreaTable_vanilla` SET name_loc5 = "怒水河" WHERE id = 815;
UPDATE `AreaTable_vanilla` SET name_loc5 = "鋼鬃營地" WHERE id = 816;
UPDATE `AreaTable_vanilla` SET name_loc5 = "骷髏石" WHERE id = 817;
UPDATE `AreaTable_vanilla` SET name_loc5 = "白鬃石" WHERE id = 818;
UPDATE `AreaTable_vanilla` SET name_loc5 = "狂風山" WHERE id = 819;
UPDATE `AreaTable_vanilla` SET name_loc5 = "金色平原" WHERE id = 820;
UPDATE `AreaTable_vanilla` SET name_loc5 = "草海平原" WHERE id = 821;
UPDATE `AreaTable_vanilla` SET name_loc5 = "丹奧加茲" WHERE id = 836;
UPDATE `AreaTable_vanilla` SET name_loc5 = "丹奧加茲" WHERE id = 837;
UPDATE `AreaTable_vanilla` SET name_loc5 = "北門小徑" WHERE id = 838;
UPDATE `AreaTable_vanilla` SET name_loc5 = "南門小徑" WHERE id = 839;
UPDATE `AreaTable_vanilla` SET name_loc5 = "黎明森林" WHERE id = 856;
UPDATE `AreaTable_vanilla` SET name_loc5 = "GM島" WHERE id = 876;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Delete ME" WHERE id = 877;
UPDATE `AreaTable_vanilla` SET name_loc5 = "怒水河" WHERE id = 878;
UPDATE `AreaTable_vanilla` SET name_loc5 = "怒水河" WHERE id = 879;
UPDATE `AreaTable_vanilla` SET name_loc5 = "薩多爾大橋" WHERE id = 880;
UPDATE `AreaTable_vanilla` SET name_loc5 = "薩多爾大橋" WHERE id = 881;
UPDATE `AreaTable_vanilla` SET name_loc5 = "贖罪島" WHERE id = 896;
UPDATE `AreaTable_vanilla` SET name_loc5 = "傑生農場" WHERE id = 916;
UPDATE `AreaTable_vanilla` SET name_loc5 = "死亡農地" WHERE id = 917;
UPDATE `AreaTable_vanilla` SET name_loc5 = "摩爾森農場" WHERE id = 918;
UPDATE `AreaTable_vanilla` SET name_loc5 = "斯特登的池塘" WHERE id = 919;
UPDATE `AreaTable_vanilla` SET name_loc5 = "匕首嶺" WHERE id = 920;
UPDATE `AreaTable_vanilla` SET name_loc5 = "迪蒙特荒野" WHERE id = 921;
UPDATE `AreaTable_vanilla` SET name_loc5 = "塵埃平原" WHERE id = 922;
UPDATE `AreaTable_vanilla` SET name_loc5 = "碎石怪之谷" WHERE id = 923;
UPDATE `AreaTable_vanilla` SET name_loc5 = "國王谷" WHERE id = 924;
UPDATE `AreaTable_vanilla` SET name_loc5 = "奧加茲崗哨" WHERE id = 925;
UPDATE `AreaTable_vanilla` SET name_loc5 = "巴克布雷農場" WHERE id = 926;
UPDATE `AreaTable_vanilla` SET name_loc5 = "閃光湖岸" WHERE id = 927;
UPDATE `AreaTable_vanilla` SET name_loc5 = "北流谷" WHERE id = 928;
UPDATE `AreaTable_vanilla` SET name_loc5 = "灰爪山" WHERE id = 936;
UPDATE `AreaTable_vanilla` SET name_loc5 = "青草平原" WHERE id = 956;
UPDATE `AreaTable_vanilla` SET name_loc5 = "加基森" WHERE id = 976;
UPDATE `AreaTable_vanilla` SET name_loc5 = "熱砂港" WHERE id = 977;
UPDATE `AreaTable_vanilla` SET name_loc5 = "祖爾法拉克" WHERE id = 978;
UPDATE `AreaTable_vanilla` SET name_loc5 = "流沙崗哨" WHERE id = 979;
UPDATE `AreaTable_vanilla` SET name_loc5 = "灌木谷" WHERE id = 980;
UPDATE `AreaTable_vanilla` SET name_loc5 = "大裂口" WHERE id = 981;
UPDATE `AreaTable_vanilla` SET name_loc5 = "腐化之巢" WHERE id = 982;
UPDATE `AreaTable_vanilla` SET name_loc5 = "砂槌營地" WHERE id = 983;
UPDATE `AreaTable_vanilla` SET name_loc5 = "東月廢墟" WHERE id = 984;
UPDATE `AreaTable_vanilla` SET name_loc5 = "清泉平原" WHERE id = 985;
UPDATE `AreaTable_vanilla` SET name_loc5 = "薩拉辛之穴" WHERE id = 986;
UPDATE `AreaTable_vanilla` SET name_loc5 = "天涯海灘" WHERE id = 987;
UPDATE `AreaTable_vanilla` SET name_loc5 = "破浪海灘" WHERE id = 988;
UPDATE `AreaTable_vanilla` SET name_loc5 = "奧丹姆" WHERE id = 989;
UPDATE `AreaTable_vanilla` SET name_loc5 = "守衛之谷" WHERE id = 990;
UPDATE `AreaTable_vanilla` SET name_loc5 = "古斯坦的崗哨" WHERE id = 991;
UPDATE `AreaTable_vanilla` SET name_loc5 = "南月廢墟" WHERE id = 992;
UPDATE `AreaTable_vanilla` SET name_loc5 = "撕裂者營地" WHERE id = 996;
UPDATE `AreaTable_vanilla` SET name_loc5 = "撕裂者山谷" WHERE id = 997;
UPDATE `AreaTable_vanilla` SET name_loc5 = "撕裂者之石" WHERE id = 998;
UPDATE `AreaTable_vanilla` SET name_loc5 = "石堡高塔" WHERE id = 999;
UPDATE `AreaTable_vanilla` SET name_loc5 = "加拉德爾山谷" WHERE id = 1000;
UPDATE `AreaTable_vanilla` SET name_loc5 = "湖邊大道" WHERE id = 1001;
UPDATE `AreaTable_vanilla` SET name_loc5 = "三角路口" WHERE id = 1002;
UPDATE `AreaTable_vanilla` SET name_loc5 = "惡鐵嶺" WHERE id = 1016;
UPDATE `AreaTable_vanilla` SET name_loc5 = "恐龍嶺" WHERE id = 1017;
UPDATE `AreaTable_vanilla` SET name_loc5 = "黑水沼澤" WHERE id = 1018;
UPDATE `AreaTable_vanilla` SET name_loc5 = "綠帶草地" WHERE id = 1019;
UPDATE `AreaTable_vanilla` SET name_loc5 = "蘚皮沼澤" WHERE id = 1020;
UPDATE `AreaTable_vanilla` SET name_loc5 = "瑟根石" WHERE id = 1021;
UPDATE `AreaTable_vanilla` SET name_loc5 = "藍腮沼澤" WHERE id = 1022;
UPDATE `AreaTable_vanilla` SET name_loc5 = "鹽沫沼澤" WHERE id = 1023;
UPDATE `AreaTable_vanilla` SET name_loc5 = "日落沼澤" WHERE id = 1024;
UPDATE `AreaTable_vanilla` SET name_loc5 = "綠帶草地" WHERE id = 1025;
UPDATE `AreaTable_vanilla` SET name_loc5 = "怒牙營地" WHERE id = 1036;
UPDATE `AreaTable_vanilla` SET name_loc5 = "格瑞姆巴托" WHERE id = 1037;
UPDATE `AreaTable_vanilla` SET name_loc5 = "龍喉大門" WHERE id = 1038;
UPDATE `AreaTable_vanilla` SET name_loc5 = "失落的艦隊" WHERE id = 1039;
UPDATE `AreaTable_vanilla` SET name_loc5 = "達隆山" WHERE id = 1056;
UPDATE `AreaTable_vanilla` SET name_loc5 = "索拉丁之牆" WHERE id = 1057;
UPDATE `AreaTable_vanilla` SET name_loc5 = "蛛網小徑" WHERE id = 1076;
UPDATE `AreaTable_vanilla` SET name_loc5 = "寂靜河岸" WHERE id = 1097;
UPDATE `AreaTable_vanilla` SET name_loc5 = "密斯特曼托莊園" WHERE id = 1098;
UPDATE `AreaTable_vanilla` SET name_loc5 = "莫沙徹營地" WHERE id = 1099;
UPDATE `AreaTable_vanilla` SET name_loc5 = "恐怖圖騰營地" WHERE id = 1100;
UPDATE `AreaTable_vanilla` SET name_loc5 = "痛苦深淵" WHERE id = 1101;
UPDATE `AreaTable_vanilla` SET name_loc5 = "狂風湖" WHERE id = 1102;
UPDATE `AreaTable_vanilla` SET name_loc5 = "戈杜尼前哨站" WHERE id = 1103;
UPDATE `AreaTable_vanilla` SET name_loc5 = "莫克高頓" WHERE id = 1104;
UPDATE `AreaTable_vanilla` SET name_loc5 = "深痕谷" WHERE id = 1105;
UPDATE `AreaTable_vanilla` SET name_loc5 = "亂羽高地" WHERE id = 1106;
UPDATE `AreaTable_vanilla` SET name_loc5 = "微風湖" WHERE id = 1107;
UPDATE `AreaTable_vanilla` SET name_loc5 = "被遺忘的海岸" WHERE id = 1108;
UPDATE `AreaTable_vanilla` SET name_loc5 = "東部石柱" WHERE id = 1109;
UPDATE `AreaTable_vanilla` SET name_loc5 = "西部石柱" WHERE id = 1110;
UPDATE `AreaTable_vanilla` SET name_loc5 = "夢境之樹" WHERE id = 1111;
UPDATE `AreaTable_vanilla` SET name_loc5 = "加德米爾湖" WHERE id = 1112;
UPDATE `AreaTable_vanilla` SET name_loc5 = "奧奈羅斯" WHERE id = 1113;
UPDATE `AreaTable_vanilla` SET name_loc5 = "鴉風廢墟" WHERE id = 1114;
UPDATE `AreaTable_vanilla` SET name_loc5 = "怒痕堡" WHERE id = 1115;
UPDATE `AreaTable_vanilla` SET name_loc5 = "羽月要塞" WHERE id = 1116;
UPDATE `AreaTable_vanilla` SET name_loc5 = "索蘭薩爾廢墟" WHERE id = 1117;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Lower Wilds UNUSED" WHERE id = 1118;
UPDATE `AreaTable_vanilla` SET name_loc5 = "雙塔山" WHERE id = 1119;
UPDATE `AreaTable_vanilla` SET name_loc5 = "薩爾多島" WHERE id = 1120;
UPDATE `AreaTable_vanilla` SET name_loc5 = "恐怖之島" WHERE id = 1121;
UPDATE `AreaTable_vanilla` SET name_loc5 = "高原荒野" WHERE id = 1136;
UPDATE `AreaTable_vanilla` SET name_loc5 = "低地荒野" WHERE id = 1137;
UPDATE `AreaTable_vanilla` SET name_loc5 = "南貧瘠之地" WHERE id = 1156;
UPDATE `AreaTable_vanilla` SET name_loc5 = "南黃金之路" WHERE id = 1157;
UPDATE `AreaTable_vanilla` SET name_loc5 = "祖爾法拉克" WHERE id = 1176;
UPDATE `AreaTable_vanilla` SET name_loc5 = "奧卡茲島" WHERE id = 1196;
UPDATE `AreaTable_vanilla` SET name_loc5 = "木喉要塞" WHERE id = 1216;
UPDATE `AreaTable_vanilla` SET name_loc5 = "范迪爾營地" WHERE id = 1217;
UPDATE `AreaTable_vanilla` SET name_loc5 = "TESTAzshara" WHERE id = 1218;
UPDATE `AreaTable_vanilla` SET name_loc5 = "雷加什營地" WHERE id = 1219;
UPDATE `AreaTable_vanilla` SET name_loc5 = "薩拉斯營地" WHERE id = 1220;
UPDATE `AreaTable_vanilla` SET name_loc5 = "埃達拉斯廢墟" WHERE id = 1221;
UPDATE `AreaTable_vanilla` SET name_loc5 = "赫塔拉的巢穴" WHERE id = 1222;
UPDATE `AreaTable_vanilla` SET name_loc5 = "辛瑪洛神殿" WHERE id = 1223;
UPDATE `AreaTable_vanilla` SET name_loc5 = "熊頭" WHERE id = 1224;
UPDATE `AreaTable_vanilla` SET name_loc5 = "烏索蘭" WHERE id = 1225;
UPDATE `AreaTable_vanilla` SET name_loc5 = "亞考蘭神殿" WHERE id = 1226;
UPDATE `AreaTable_vanilla` SET name_loc5 = "風暴海灣" WHERE id = 1227;
UPDATE `AreaTable_vanilla` SET name_loc5 = "破碎海岸" WHERE id = 1228;
UPDATE `AreaTable_vanilla` SET name_loc5 = "艾達拉之塔" WHERE id = 1229;
UPDATE `AreaTable_vanilla` SET name_loc5 = "鋸齒暗礁" WHERE id = 1230;
UPDATE `AreaTable_vanilla` SET name_loc5 = "南山海灘" WHERE id = 1231;
UPDATE `AreaTable_vanilla` SET name_loc5 = "黑羽紀念碑" WHERE id = 1232;
UPDATE `AreaTable_vanilla` SET name_loc5 = "淒涼山" WHERE id = 1233;
UPDATE `AreaTable_vanilla` SET name_loc5 = "門納爾湖" WHERE id = 1234;
UPDATE `AreaTable_vanilla` SET name_loc5 = "影歌神殿" WHERE id = 1235;
UPDATE `AreaTable_vanilla` SET name_loc5 = "哈達爾營地" WHERE id = 1236;
UPDATE `AreaTable_vanilla` SET name_loc5 = "瓦羅莫克" WHERE id = 1237;
UPDATE `AreaTable_vanilla` SET name_loc5 = "廢墟海岸" WHERE id = 1256;
UPDATE `AreaTable_vanilla` SET name_loc5 = "石爪小徑" WHERE id = 1276;
UPDATE `AreaTable_vanilla` SET name_loc5 = "石爪小徑" WHERE id = 1277;
UPDATE `AreaTable_vanilla` SET name_loc5 = "石牙農場" WHERE id = 1296;
UPDATE `AreaTable_vanilla` SET name_loc5 = "野豬農場" WHERE id = 1297;
UPDATE `AreaTable_vanilla` SET name_loc5 = "剃刀高地" WHERE id = 1316;
UPDATE `AreaTable_vanilla` SET name_loc5 = "落帆海灣" WHERE id = 1336;
UPDATE `AreaTable_vanilla` SET name_loc5 = "奧達曼" WHERE id = 1337;
UPDATE `AreaTable_vanilla` SET name_loc5 = "洛丹米爾湖" WHERE id = 1338;
UPDATE `AreaTable_vanilla` SET name_loc5 = "洛丹米爾湖" WHERE id = 1339;
UPDATE `AreaTable_vanilla` SET name_loc5 = "絞刑場" WHERE id = 1357;
UPDATE `AreaTable_vanilla` SET name_loc5 = "希利蘇斯" WHERE id = 1377;
UPDATE `AreaTable_vanilla` SET name_loc5 = "翠葉森林" WHERE id = 1397;
UPDATE `AreaTable_vanilla` SET name_loc5 = "沉沒的神廟" WHERE id = 1417;
UPDATE `AreaTable_vanilla` SET name_loc5 = "巨槌要塞" WHERE id = 1437;
UPDATE `AreaTable_vanilla` SET name_loc5 = "守望堡" WHERE id = 1438;
UPDATE `AreaTable_vanilla` SET name_loc5 = "巨槌崗哨" WHERE id = 1439;
UPDATE `AreaTable_vanilla` SET name_loc5 = "盤蛇谷" WHERE id = 1440;
UPDATE `AreaTable_vanilla` SET name_loc5 = "暴風祭壇" WHERE id = 1441;
UPDATE `AreaTable_vanilla` SET name_loc5 = "觀火嶺" WHERE id = 1442;
UPDATE `AreaTable_vanilla` SET name_loc5 = "熔渣之池" WHERE id = 1443;
UPDATE `AreaTable_vanilla` SET name_loc5 = "灰燼之海" WHERE id = 1444;
UPDATE `AreaTable_vanilla` SET name_loc5 = "黑石山" WHERE id = 1445;
UPDATE `AreaTable_vanilla` SET name_loc5 = "瑟銀哨塔" WHERE id = 1446;
UPDATE `AreaTable_vanilla` SET name_loc5 = "要塞軍械庫" WHERE id = 1457;
UPDATE `AreaTable_vanilla` SET name_loc5 = "阿塔哈卡神廟" WHERE id = 1477;
UPDATE `AreaTable_vanilla` SET name_loc5 = "幽暗城" WHERE id = 1497;
UPDATE `AreaTable_vanilla` SET name_loc5 = "奧達曼" WHERE id = 1517;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Not Used Deadmines" WHERE id = 1518;
UPDATE `AreaTable_vanilla` SET name_loc5 = "暴風城" WHERE id = 1519;
UPDATE `AreaTable_vanilla` SET name_loc5 = "鐵爐堡" WHERE id = 1537;
UPDATE `AreaTable_vanilla` SET name_loc5 = "裂蹄堡" WHERE id = 1557;
UPDATE `AreaTable_vanilla` SET name_loc5 = "荊棘谷海角" WHERE id = 1577;
UPDATE `AreaTable_vanilla` SET name_loc5 = "南野人海岸" WHERE id = 1578;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Unused The Deadmines 002" WHERE id = 1579;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Unused Ironclad Cove 003" WHERE id = 1580;
UPDATE `AreaTable_vanilla` SET name_loc5 = "死亡礦坑" WHERE id = 1581;
UPDATE `AreaTable_vanilla` SET name_loc5 = "鐵甲灣" WHERE id = 1582;
UPDATE `AreaTable_vanilla` SET name_loc5 = "黑石塔" WHERE id = 1583;
UPDATE `AreaTable_vanilla` SET name_loc5 = "黑石深淵" WHERE id = 1584;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Raptor Grounds UNUSED" WHERE id = 1597;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Grol'dom Farm UNUSED" WHERE id = 1598;
UPDATE `AreaTable_vanilla` SET name_loc5 = "莫爾杉營地" WHERE id = 1599;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Honor's Stand UNUSED" WHERE id = 1600;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Blackthorn Ridge UNUSED" WHERE id = 1601;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Bramblescar UNUSED" WHERE id = 1602;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Agama'gor UNUSED" WHERE id = 1603;
UPDATE `AreaTable_vanilla` SET name_loc5 = "英雄谷" WHERE id = 1617;
UPDATE `AreaTable_vanilla` SET name_loc5 = "奧格瑪" WHERE id = 1637;
UPDATE `AreaTable_vanilla` SET name_loc5 = "雷霆崖" WHERE id = 1638;
UPDATE `AreaTable_vanilla` SET name_loc5 = "長者高地" WHERE id = 1639;
UPDATE `AreaTable_vanilla` SET name_loc5 = "靈魂高地" WHERE id = 1640;
UPDATE `AreaTable_vanilla` SET name_loc5 = "獵人高地" WHERE id = 1641;
UPDATE `AreaTable_vanilla` SET name_loc5 = "達納蘇斯" WHERE id = 1657;
UPDATE `AreaTable_vanilla` SET name_loc5 = "塞納里奧區" WHERE id = 1658;
UPDATE `AreaTable_vanilla` SET name_loc5 = "工匠區" WHERE id = 1659;
UPDATE `AreaTable_vanilla` SET name_loc5 = "戰士區" WHERE id = 1660;
UPDATE `AreaTable_vanilla` SET name_loc5 = "神殿花園" WHERE id = 1661;
UPDATE `AreaTable_vanilla` SET name_loc5 = "貿易區" WHERE id = 1662;
UPDATE `AreaTable_vanilla` SET name_loc5 = "加文高地" WHERE id = 1677;
UPDATE `AreaTable_vanilla` SET name_loc5 = "索菲亞高地" WHERE id = 1678;
UPDATE `AreaTable_vanilla` SET name_loc5 = "考蘭之匕" WHERE id = 1679;
UPDATE `AreaTable_vanilla` SET name_loc5 = "山頭營地" WHERE id = 1680;
UPDATE `AreaTable_vanilla` SET name_loc5 = "霧氣湖岸" WHERE id = 1681;
UPDATE `AreaTable_vanilla` SET name_loc5 = "達倫德農場" WHERE id = 1682;
UPDATE `AreaTable_vanilla` SET name_loc5 = "無草洞" WHERE id = 1683;
UPDATE `AreaTable_vanilla` SET name_loc5 = "冰風崗哨" WHERE id = 1684;
UPDATE `AreaTable_vanilla` SET name_loc5 = "迅猛龍巢穴" WHERE id = 1697;
UPDATE `AreaTable_vanilla` SET name_loc5 = "迅猛龍平原" WHERE id = 1698;
UPDATE `AreaTable_vanilla` SET name_loc5 = "荊棘嶺" WHERE id = 1699;
UPDATE `AreaTable_vanilla` SET name_loc5 = "阿迦瑪戈" WHERE id = 1700;
UPDATE `AreaTable_vanilla` SET name_loc5 = "黑棘山" WHERE id = 1701;
UPDATE `AreaTable_vanilla` SET name_loc5 = "榮耀崗哨" WHERE id = 1702;
UPDATE `AreaTable_vanilla` SET name_loc5 = "摩爾沙農場" WHERE id = 1703;
UPDATE `AreaTable_vanilla` SET name_loc5 = "格羅多姆農場" WHERE id = 1704;
UPDATE `AreaTable_vanilla` SET name_loc5 = "剃刀沼澤" WHERE id = 1717;
UPDATE `AreaTable_vanilla` SET name_loc5 = "升降梯" WHERE id = 1718;
UPDATE `AreaTable_vanilla` SET name_loc5 = "薄霧山谷" WHERE id = 1737;
UPDATE `AreaTable_vanilla` SET name_loc5 = "納克邁尼聖泉" WHERE id = 1738;
UPDATE `AreaTable_vanilla` SET name_loc5 = "血帆營地" WHERE id = 1739;
UPDATE `AreaTable_vanilla` SET name_loc5 = "風險投資公司營地" WHERE id = 1740;
UPDATE `AreaTable_vanilla` SET name_loc5 = "古拉巴什競技場" WHERE id = 1741;
UPDATE `AreaTable_vanilla` SET name_loc5 = "靈魂之穴" WHERE id = 1742;
UPDATE `AreaTable_vanilla` SET name_loc5 = "赤紅之霧" WHERE id = 1757;
UPDATE `AreaTable_vanilla` SET name_loc5 = "斷潮之池" WHERE id = 1758;
UPDATE `AreaTable_vanilla` SET name_loc5 = "少女的好運" WHERE id = 1759;
UPDATE `AreaTable_vanilla` SET name_loc5 = "風險投資公司工作中心" WHERE id = 1760;
UPDATE `AreaTable_vanilla` SET name_loc5 = "死木村" WHERE id = 1761;
UPDATE `AreaTable_vanilla` SET name_loc5 = "魔爪村" WHERE id = 1762;
UPDATE `AreaTable_vanilla` SET name_loc5 = "加德納爾" WHERE id = 1763;
UPDATE `AreaTable_vanilla` SET name_loc5 = "血毒河" WHERE id = 1764;
UPDATE `AreaTable_vanilla` SET name_loc5 = "血毒瀑布" WHERE id = 1765;
UPDATE `AreaTable_vanilla` SET name_loc5 = "碎痕谷" WHERE id = 1766;
UPDATE `AreaTable_vanilla` SET name_loc5 = "鐵木森林" WHERE id = 1767;
UPDATE `AreaTable_vanilla` SET name_loc5 = "鐵木山洞" WHERE id = 1768;
UPDATE `AreaTable_vanilla` SET name_loc5 = "木喉要塞" WHERE id = 1769;
UPDATE `AreaTable_vanilla` SET name_loc5 = "暗影堡" WHERE id = 1770;
UPDATE `AreaTable_vanilla` SET name_loc5 = "欺詐者神祠" WHERE id = 1771;
UPDATE `AreaTable_vanilla` SET name_loc5 = "伊薩里奧斯的洞穴" WHERE id = 1777;
UPDATE `AreaTable_vanilla` SET name_loc5 = "憂傷濕地" WHERE id = 1778;
UPDATE `AreaTable_vanilla` SET name_loc5 = "德萊尼村" WHERE id = 1779;
UPDATE `AreaTable_vanilla` SET name_loc5 = "斷矛路口" WHERE id = 1780;
UPDATE `AreaTable_vanilla` SET name_loc5 = "雄鹿沼澤" WHERE id = 1797;
UPDATE `AreaTable_vanilla` SET name_loc5 = "流沙泥潭" WHERE id = 1798;
UPDATE `AreaTable_vanilla` SET name_loc5 = "雄鹿沼澤洞穴" WHERE id = 1817;
UPDATE `AreaTable_vanilla` SET name_loc5 = "枯木洞穴" WHERE id = 1837;
UPDATE `AreaTable_vanilla` SET name_loc5 = "索拉丁之牆" WHERE id = 1857;
UPDATE `AreaTable_vanilla` SET name_loc5 = "博多戈爾" WHERE id = 1858;
UPDATE `AreaTable_vanilla` SET name_loc5 = "巨牙谷" WHERE id = 1877;
UPDATE `AreaTable_vanilla` SET name_loc5 = "漫塵盆地" WHERE id = 1878;
UPDATE `AreaTable_vanilla` SET name_loc5 = "霧氣平原" WHERE id = 1879;
UPDATE `AreaTable_vanilla` SET name_loc5 = "羽鬚小屋" WHERE id = 1880;
UPDATE `AreaTable_vanilla` SET name_loc5 = "拉普索迪營地" WHERE id = 1881;
UPDATE `AreaTable_vanilla` SET name_loc5 = "毒霧峽谷" WHERE id = 1882;
UPDATE `AreaTable_vanilla` SET name_loc5 = "瓦羅溫湖" WHERE id = 1883;
UPDATE `AreaTable_vanilla` SET name_loc5 = "亞戈瓦薩" WHERE id = 1884;
UPDATE `AreaTable_vanilla` SET name_loc5 = "西利瓦薩" WHERE id = 1885;
UPDATE `AreaTable_vanilla` SET name_loc5 = "爬蟲廢墟" WHERE id = 1886;
UPDATE `AreaTable_vanilla` SET name_loc5 = "伯根的棚屋" WHERE id = 1887;
UPDATE `AreaTable_vanilla` SET name_loc5 = "造物者遺跡" WHERE id = 1897;
UPDATE `AreaTable_vanilla` SET name_loc5 = "塵風峽谷" WHERE id = 1898;
UPDATE `AreaTable_vanilla` SET name_loc5 = "沙爾瓦薩" WHERE id = 1917;
UPDATE `AreaTable_vanilla` SET name_loc5 = "熱影廢墟" WHERE id = 1937;
UPDATE `AreaTable_vanilla` SET name_loc5 = "破碎石柱" WHERE id = 1938;
UPDATE `AreaTable_vanilla` SET name_loc5 = "深沙平原" WHERE id = 1939;
UPDATE `AreaTable_vanilla` SET name_loc5 = "塔納利斯南海" WHERE id = 1940;
UPDATE `AreaTable_vanilla` SET name_loc5 = "時光洞穴" WHERE id = 1941;
UPDATE `AreaTable_vanilla` SET name_loc5 = "沼澤地" WHERE id = 1942;
UPDATE `AreaTable_vanilla` SET name_loc5 = "鐵石高原" WHERE id = 1943;
UPDATE `AreaTable_vanilla` SET name_loc5 = "黑炭谷" WHERE id = 1957;
UPDATE `AreaTable_vanilla` SET name_loc5 = "製皮匠營地" WHERE id = 1958;
UPDATE `AreaTable_vanilla` SET name_loc5 = "塵火谷" WHERE id = 1959;
UPDATE `AreaTable_vanilla` SET name_loc5 = "祖爾格拉布" WHERE id = 1977;
UPDATE `AreaTable_vanilla` SET name_loc5 = "蘆葦崗哨" WHERE id = 1978;
UPDATE `AreaTable_vanilla` SET name_loc5 = "血毒崗哨" WHERE id = 1997;
UPDATE `AreaTable_vanilla` SET name_loc5 = "刺枝林地" WHERE id = 1998;
UPDATE `AreaTable_vanilla` SET name_loc5 = "斯坦索姆" WHERE id = 2017;
UPDATE `AreaTable_vanilla` SET name_loc5 = "UNUSEDShadowfang Keep 003" WHERE id = 2037;
UPDATE `AreaTable_vanilla` SET name_loc5 = "通靈學院" WHERE id = 2057;
UPDATE `AreaTable_vanilla` SET name_loc5 = "暮光谷" WHERE id = 2077;
UPDATE `AreaTable_vanilla` SET name_loc5 = "暮光海岸" WHERE id = 2078;
UPDATE `AreaTable_vanilla` SET name_loc5 = "奧卡茲島" WHERE id = 2079;
UPDATE `AreaTable_vanilla` SET name_loc5 = "黑雲峰" WHERE id = 2097;
UPDATE `AreaTable_vanilla` SET name_loc5 = "黎明墓穴" WHERE id = 2098;
UPDATE `AreaTable_vanilla` SET name_loc5 = "石堡要塞" WHERE id = 2099;
UPDATE `AreaTable_vanilla` SET name_loc5 = "瑪拉頓" WHERE id = 2100;
UPDATE `AreaTable_vanilla` SET name_loc5 = "烈酒旅店" WHERE id = 2101;
UPDATE `AreaTable_vanilla` SET name_loc5 = "雷酒釀製廠" WHERE id = 2102;
UPDATE `AreaTable_vanilla` SET name_loc5 = "米奈希爾城堡" WHERE id = 2103;
UPDATE `AreaTable_vanilla` SET name_loc5 = "深水旅店" WHERE id = 2104;
UPDATE `AreaTable_vanilla` SET name_loc5 = "灰影墓穴" WHERE id = 2117;
UPDATE `AreaTable_vanilla` SET name_loc5 = "布瑞爾城鎮大廳" WHERE id = 2118;
UPDATE `AreaTable_vanilla` SET name_loc5 = "恐懼之末旅店" WHERE id = 2119;
UPDATE `AreaTable_vanilla` SET name_loc5 = "The Pools of VisionUNUSED" WHERE id = 2137;
UPDATE `AreaTable_vanilla` SET name_loc5 = "鬼霧獸穴" WHERE id = 2138;
UPDATE `AreaTable_vanilla` SET name_loc5 = "巴爾丹城堡" WHERE id = 2157;
UPDATE `AreaTable_vanilla` SET name_loc5 = "艾博斯塔夫的巢穴" WHERE id = 2158;
UPDATE `AreaTable_vanilla` SET name_loc5 = "奧妮克希亞的巢穴" WHERE id = 2159;
UPDATE `AreaTable_vanilla` SET name_loc5 = "狂風礦坑" WHERE id = 2160;
UPDATE `AreaTable_vanilla` SET name_loc5 = "羅蘭之墓" WHERE id = 2161;
UPDATE `AreaTable_vanilla` SET name_loc5 = "大競技場" WHERE id = 2177;
UPDATE `AreaTable_vanilla` SET name_loc5 = "預見之池" WHERE id = 2197;
UPDATE `AreaTable_vanilla` SET name_loc5 = "破影峽谷" WHERE id = 2198;
UPDATE `AreaTable_vanilla` SET name_loc5 = "斷矛村" WHERE id = 2217;
UPDATE `AreaTable_vanilla` SET name_loc5 = "白沙崗哨" WHERE id = 2237;
UPDATE `AreaTable_vanilla` SET name_loc5 = "戈尼亞" WHERE id = 2238;
UPDATE `AreaTable_vanilla` SET name_loc5 = "贊恩之眼" WHERE id = 2239;
UPDATE `AreaTable_vanilla` SET name_loc5 = "沙漠賽道" WHERE id = 2240;
UPDATE `AreaTable_vanilla` SET name_loc5 = "霜刀石" WHERE id = 2241;
UPDATE `AreaTable_vanilla` SET name_loc5 = "隱秘小林" WHERE id = 2242;
UPDATE `AreaTable_vanilla` SET name_loc5 = "木喉崗哨" WHERE id = 2243;
UPDATE `AreaTable_vanilla` SET name_loc5 = "寒水村" WHERE id = 2244;
UPDATE `AreaTable_vanilla` SET name_loc5 = "麥索瑞爾" WHERE id = 2245;
UPDATE `AreaTable_vanilla` SET name_loc5 = "冰火溫泉" WHERE id = 2246;
UPDATE `AreaTable_vanilla` SET name_loc5 = "冰薊嶺" WHERE id = 2247;
UPDATE `AreaTable_vanilla` SET name_loc5 = "丹曼達爾" WHERE id = 2248;
UPDATE `AreaTable_vanilla` SET name_loc5 = "霜語峽谷" WHERE id = 2249;
UPDATE `AreaTable_vanilla` SET name_loc5 = "梟翼樹叢" WHERE id = 2250;
UPDATE `AreaTable_vanilla` SET name_loc5 = "凱斯利爾湖" WHERE id = 2251;
UPDATE `AreaTable_vanilla` SET name_loc5 = "凱斯利爾廢墟" WHERE id = 2252;
UPDATE `AreaTable_vanilla` SET name_loc5 = "墜星村" WHERE id = 2253;
UPDATE `AreaTable_vanilla` SET name_loc5 = "班薩羅獸穴" WHERE id = 2254;
UPDATE `AreaTable_vanilla` SET name_loc5 = "永望鎮" WHERE id = 2255;
UPDATE `AreaTable_vanilla` SET name_loc5 = "暗語峽谷" WHERE id = 2256;
UPDATE `AreaTable_vanilla` SET name_loc5 = "礦道地鐵" WHERE id = 2257;
UPDATE `AreaTable_vanilla` SET name_loc5 = "蘑菇谷" WHERE id = 2258;
UPDATE `AreaTable_vanilla` SET name_loc5 = "UNUSEDThe Marris Stead" WHERE id = 2259;
UPDATE `AreaTable_vanilla` SET name_loc5 = "瑪瑞斯農場" WHERE id = 2260;
UPDATE `AreaTable_vanilla` SET name_loc5 = "墓室" WHERE id = 2261;
UPDATE `AreaTable_vanilla` SET name_loc5 = "達隆郡" WHERE id = 2262;
UPDATE `AreaTable_vanilla` SET name_loc5 = "皇冠哨塔" WHERE id = 2263;
UPDATE `AreaTable_vanilla` SET name_loc5 = "考林路口" WHERE id = 2264;
UPDATE `AreaTable_vanilla` SET name_loc5 = "血色十字軍營地" WHERE id = 2265;
UPDATE `AreaTable_vanilla` SET name_loc5 = "提爾之手" WHERE id = 2266;
UPDATE `AreaTable_vanilla` SET name_loc5 = "血色十字軍教堂" WHERE id = 2267;
UPDATE `AreaTable_vanilla` SET name_loc5 = "聖光之願禮拜堂" WHERE id = 2268;
UPDATE `AreaTable_vanilla` SET name_loc5 = "布洛米爾" WHERE id = 2269;
UPDATE `AreaTable_vanilla` SET name_loc5 = "劇毒林地" WHERE id = 2270;
UPDATE `AreaTable_vanilla` SET name_loc5 = "東牆之塔" WHERE id = 2271;
UPDATE `AreaTable_vanilla` SET name_loc5 = "北谷" WHERE id = 2272;
UPDATE `AreaTable_vanilla` SET name_loc5 = "祖瑪沙爾" WHERE id = 2273;
UPDATE `AreaTable_vanilla` SET name_loc5 = "瑪茲拉羅" WHERE id = 2274;
UPDATE `AreaTable_vanilla` SET name_loc5 = "北地哨塔" WHERE id = 2275;
UPDATE `AreaTable_vanilla` SET name_loc5 = "奎爾林斯小屋" WHERE id = 2276;
UPDATE `AreaTable_vanilla` SET name_loc5 = "病木林" WHERE id = 2277;
UPDATE `AreaTable_vanilla` SET name_loc5 = "瘟疫要塞" WHERE id = 2278;
UPDATE `AreaTable_vanilla` SET name_loc5 = "斯坦索姆" WHERE id = 2279;
UPDATE `AreaTable_vanilla` SET name_loc5 = "UNUSED Stratholme" WHERE id = 2280;
UPDATE `AreaTable_vanilla` SET name_loc5 = "達隆米爾湖" WHERE id = 2297;
UPDATE `AreaTable_vanilla` SET name_loc5 = "凱爾達隆" WHERE id = 2298;
UPDATE `AreaTable_vanilla` SET name_loc5 = "達隆米爾湖" WHERE id = 2299;
UPDATE `AreaTable_vanilla` SET name_loc5 = "時光洞穴" WHERE id = 2300;
UPDATE `AreaTable_vanilla` SET name_loc5 = "薊皮村" WHERE id = 2301;
UPDATE `AreaTable_vanilla` SET name_loc5 = "泥潭沼澤" WHERE id = 2302;
UPDATE `AreaTable_vanilla` SET name_loc5 = "風裂峽谷" WHERE id = 2303;
UPDATE `AreaTable_vanilla` SET name_loc5 = "南海" WHERE id = 2317;
UPDATE `AreaTable_vanilla` SET name_loc5 = "無盡之海" WHERE id = 2318;
UPDATE `AreaTable_vanilla` SET name_loc5 = "無盡之海" WHERE id = 2319;
UPDATE `AreaTable_vanilla` SET name_loc5 = "無盡之海" WHERE id = 2320;
UPDATE `AreaTable_vanilla` SET name_loc5 = "無盡之海" WHERE id = 2321;
UPDATE `AreaTable_vanilla` SET name_loc5 = "迷霧之海" WHERE id = 2322;
UPDATE `AreaTable_vanilla` SET name_loc5 = "迷霧之海" WHERE id = 2323;
UPDATE `AreaTable_vanilla` SET name_loc5 = "迷霧之海" WHERE id = 2324;
UPDATE `AreaTable_vanilla` SET name_loc5 = "迷霧之海" WHERE id = 2325;
UPDATE `AreaTable_vanilla` SET name_loc5 = "迷霧之海" WHERE id = 2326;
UPDATE `AreaTable_vanilla` SET name_loc5 = "剃刀嶺兵營" WHERE id = 2337;
UPDATE `AreaTable_vanilla` SET name_loc5 = "南海" WHERE id = 2338;
UPDATE `AreaTable_vanilla` SET name_loc5 = "無盡之海" WHERE id = 2339;
UPDATE `AreaTable_vanilla` SET name_loc5 = "血牙營地" WHERE id = 2357;
UPDATE `AreaTable_vanilla` SET name_loc5 = "林歌神殿" WHERE id = 2358;
UPDATE `AreaTable_vanilla` SET name_loc5 = "綠爪村" WHERE id = 2359;
UPDATE `AreaTable_vanilla` SET name_loc5 = "銀翼哨站" WHERE id = 2360;
UPDATE `AreaTable_vanilla` SET name_loc5 = "永夜港" WHERE id = 2361;
UPDATE `AreaTable_vanilla` SET name_loc5 = "雷姆洛斯神殿" WHERE id = 2362;
UPDATE `AreaTable_vanilla` SET name_loc5 = "怒風獸穴" WHERE id = 2363;
UPDATE `AreaTable_vanilla` SET name_loc5 = "無盡之海" WHERE id = 2364;
UPDATE `AreaTable_vanilla` SET name_loc5 = "無盡之海" WHERE id = 2365;
UPDATE `AreaTable_vanilla` SET name_loc5 = "黑色沼澤" WHERE id = 2366;
UPDATE `AreaTable_vanilla` SET name_loc5 = "老希爾斯布萊德丘陵" WHERE id = 2367;
UPDATE `AreaTable_vanilla` SET name_loc5 = "塔倫米爾" WHERE id = 2368;
UPDATE `AreaTable_vanilla` SET name_loc5 = "南海鎮" WHERE id = 2369;
UPDATE `AreaTable_vanilla` SET name_loc5 = "敦霍爾德城堡" WHERE id = 2370;
UPDATE `AreaTable_vanilla` SET name_loc5 = "丹加洛克" WHERE id = 2371;
UPDATE `AreaTable_vanilla` SET name_loc5 = "希爾斯布萊德農場" WHERE id = 2372;
UPDATE `AreaTable_vanilla` SET name_loc5 = "東部海灘" WHERE id = 2373;
UPDATE `AreaTable_vanilla` SET name_loc5 = "奈杉德崗哨" WHERE id = 2374;
UPDATE `AreaTable_vanilla` SET name_loc5 = "達隆山" WHERE id = 2375;
UPDATE `AreaTable_vanilla` SET name_loc5 = "南點哨塔" WHERE id = 2376;
UPDATE `AreaTable_vanilla` SET name_loc5 = "索拉丁之牆" WHERE id = 2377;
UPDATE `AreaTable_vanilla` SET name_loc5 = "西部海岸" WHERE id = 2378;
UPDATE `AreaTable_vanilla` SET name_loc5 = "碧玉礦坑" WHERE id = 2379;
UPDATE `AreaTable_vanilla` SET name_loc5 = "無盡之海" WHERE id = 2397;
UPDATE `AreaTable_vanilla` SET name_loc5 = "無盡之海" WHERE id = 2398;
UPDATE `AreaTable_vanilla` SET name_loc5 = "無盡之海" WHERE id = 2399;
UPDATE `AreaTable_vanilla` SET name_loc5 = "禁忌之海" WHERE id = 2400;
UPDATE `AreaTable_vanilla` SET name_loc5 = "禁忌之海" WHERE id = 2401;
UPDATE `AreaTable_vanilla` SET name_loc5 = "禁忌之海" WHERE id = 2402;
UPDATE `AreaTable_vanilla` SET name_loc5 = "禁忌之海" WHERE id = 2403;
UPDATE `AreaTable_vanilla` SET name_loc5 = "塔迪薩蘭" WHERE id = 2404;
UPDATE `AreaTable_vanilla` SET name_loc5 = "艾瑟雷索" WHERE id = 2405;
UPDATE `AreaTable_vanilla` SET name_loc5 = "拉納加爾島" WHERE id = 2406;
UPDATE `AreaTable_vanilla` SET name_loc5 = "考米克小屋" WHERE id = 2407;
UPDATE `AreaTable_vanilla` SET name_loc5 = "葬影村" WHERE id = 2408;
UPDATE `AreaTable_vanilla` SET name_loc5 = "黑石小徑" WHERE id = 2417;
UPDATE `AreaTable_vanilla` SET name_loc5 = "摩根的崗哨" WHERE id = 2418;
UPDATE `AreaTable_vanilla` SET name_loc5 = "滑石" WHERE id = 2419;
UPDATE `AreaTable_vanilla` SET name_loc5 = "龍翼小徑" WHERE id = 2420;
UPDATE `AreaTable_vanilla` SET name_loc5 = "德拉考達爾" WHERE id = 2421;
UPDATE `AreaTable_vanilla` SET name_loc5 = "怒焰裂谷" WHERE id = 2437;
UPDATE `AreaTable_vanilla` SET name_loc5 = "夜歌森林" WHERE id = 2457;
UPDATE `AreaTable_vanilla` SET name_loc5 = "迷霧之海" WHERE id = 2477;
UPDATE `AreaTable_vanilla` SET name_loc5 = "摩羅薩蘭" WHERE id = 2478;
UPDATE `AreaTable_vanilla` SET name_loc5 = "翡翠聖地" WHERE id = 2479;
UPDATE `AreaTable_vanilla` SET name_loc5 = "碧火谷" WHERE id = 2480;
UPDATE `AreaTable_vanilla` SET name_loc5 = "克斯特拉斯廢墟" WHERE id = 2481;
UPDATE `AreaTable_vanilla` SET name_loc5 = "痛苦海岸" WHERE id = 2497;
UPDATE `AreaTable_vanilla` SET name_loc5 = "污染者高地" WHERE id = 2517;
UPDATE `AreaTable_vanilla` SET name_loc5 = "拉瑞斯小亭" WHERE id = 2518;
UPDATE `AreaTable_vanilla` SET name_loc5 = "木爪嶺" WHERE id = 2519;
UPDATE `AreaTable_vanilla` SET name_loc5 = "木爪巢穴" WHERE id = 2520;
UPDATE `AreaTable_vanilla` SET name_loc5 = "沃丹提斯河" WHERE id = 2521;
UPDATE `AreaTable_vanilla` SET name_loc5 = "伊斯迪爾廢墟" WHERE id = 2522;
UPDATE `AreaTable_vanilla` SET name_loc5 = "恐怖圖騰崗哨" WHERE id = 2537;
UPDATE `AreaTable_vanilla` SET name_loc5 = "阿帕拉耶營地" WHERE id = 2538;
UPDATE `AreaTable_vanilla` SET name_loc5 = "瑪拉卡金" WHERE id = 2539;
UPDATE `AreaTable_vanilla` SET name_loc5 = "滾岩峽谷" WHERE id = 2540;
UPDATE `AreaTable_vanilla` SET name_loc5 = "希塞爾山谷" WHERE id = 2541;
UPDATE `AreaTable_vanilla` SET name_loc5 = "厄運之槌" WHERE id = 2557;
UPDATE `AreaTable_vanilla` SET name_loc5 = "逆風谷" WHERE id = 2558;
UPDATE `AreaTable_vanilla` SET name_loc5 = "鑽石河" WHERE id = 2559;
UPDATE `AreaTable_vanilla` SET name_loc5 = "埃瑞丁營地" WHERE id = 2560;
UPDATE `AreaTable_vanilla` SET name_loc5 = "罪惡谷" WHERE id = 2561;
UPDATE `AreaTable_vanilla` SET name_loc5 = "卡拉贊" WHERE id = 2562;
UPDATE `AreaTable_vanilla` SET name_loc5 = "摩根墓場" WHERE id = 2563;
UPDATE `AreaTable_vanilla` SET name_loc5 = "厄運之槌" WHERE id = 2577;
UPDATE `AreaTable_vanilla` SET name_loc5 = "奧特蘭克山谷" WHERE id = 2597;
UPDATE `AreaTable_vanilla` SET name_loc5 = "瑟卡布斯庫的營地" WHERE id = 2617;
UPDATE `AreaTable_vanilla` SET name_loc5 = "碧火小徑" WHERE id = 2618;
UPDATE `AreaTable_vanilla` SET name_loc5 = "索多里爾河" WHERE id = 2619;
UPDATE `AreaTable_vanilla` SET name_loc5 = "索多里爾河" WHERE id = 2620;
UPDATE `AreaTable_vanilla` SET name_loc5 = "米雷達爾湖" WHERE id = 2621;
UPDATE `AreaTable_vanilla` SET name_loc5 = "瘟疫之痕" WHERE id = 2622;
UPDATE `AreaTable_vanilla` SET name_loc5 = "魔刃之痕" WHERE id = 2623;
UPDATE `AreaTable_vanilla` SET name_loc5 = "黑木湖" WHERE id = 2624;
UPDATE `AreaTable_vanilla` SET name_loc5 = "東牆大門" WHERE id = 2625;
UPDATE `AreaTable_vanilla` SET name_loc5 = "惡蛛隧道" WHERE id = 2626;
UPDATE `AreaTable_vanilla` SET name_loc5 = "恐懼谷" WHERE id = 2627;
UPDATE `AreaTable_vanilla` SET name_loc5 = "卡加希亞要塞" WHERE id = 2637;
UPDATE `AreaTable_vanilla` SET name_loc5 = "白骨之谷" WHERE id = 2657;
UPDATE `AreaTable_vanilla` SET name_loc5 = "黑翼之巢" WHERE id = 2677;
UPDATE `AreaTable_vanilla` SET name_loc5 = "死者十字" WHERE id = 2697;
UPDATE `AreaTable_vanilla` SET name_loc5 = "熔火之心" WHERE id = 2717;
UPDATE `AreaTable_vanilla` SET name_loc5 = "甲蟲之牆" WHERE id = 2737;
UPDATE `AreaTable_vanilla` SET name_loc5 = "南風村" WHERE id = 2738;
UPDATE `AreaTable_vanilla` SET name_loc5 = "暮光營地" WHERE id = 2739;
UPDATE `AreaTable_vanilla` SET name_loc5 = "水晶谷" WHERE id = 2740;
UPDATE `AreaTable_vanilla` SET name_loc5 = "甲蟲之台" WHERE id = 2741;
UPDATE `AreaTable_vanilla` SET name_loc5 = "亞什蟲巢" WHERE id = 2742;
UPDATE `AreaTable_vanilla` SET name_loc5 = "佐拉蟲巢" WHERE id = 2743;
UPDATE `AreaTable_vanilla` SET name_loc5 = "雷戈蟲巢" WHERE id = 2744;
UPDATE `AreaTable_vanilla` SET name_loc5 = "戰士之魂神殿" WHERE id = 2757;
UPDATE `AreaTable_vanilla` SET name_loc5 = "UNUSED Alterac Valley" WHERE id = 2777;
UPDATE `AreaTable_vanilla` SET name_loc5 = "黑暗深淵" WHERE id = 2797;
UPDATE `AreaTable_vanilla` SET name_loc5 = "***大型地下城***" WHERE id = 2817;
UPDATE `AreaTable_vanilla` SET name_loc5 = "主宰的庇護所" WHERE id = 2837;
UPDATE `AreaTable_vanilla` SET name_loc5 = "石壩小徑" WHERE id = 2838;
UPDATE `AreaTable_vanilla` SET name_loc5 = "奧特蘭克山谷" WHERE id = 2839;
UPDATE `AreaTable_vanilla` SET name_loc5 = "加基森競技場" WHERE id = 2857;
UPDATE `AreaTable_vanilla` SET name_loc5 = "Chunk Test" WHERE id = 2877;
UPDATE `AreaTable_vanilla` SET name_loc5 = "左拉姆加前哨站" WHERE id = 2897;
UPDATE `AreaTable_vanilla` SET name_loc5 = "傳說大廳" WHERE id = 2917;
UPDATE `AreaTable_vanilla` SET name_loc5 = "勇士大廳" WHERE id = 2918;
UPDATE `AreaTable_vanilla` SET name_loc5 = "格羅高克營地" WHERE id = 2937;
UPDATE `AreaTable_vanilla` SET name_loc5 = "沉睡峽谷" WHERE id = 2938;
UPDATE `AreaTable_vanilla` SET name_loc5 = "深鐵礦坑" WHERE id = 2957;
UPDATE `AreaTable_vanilla` SET name_loc5 = "石爐哨站" WHERE id = 2958;
UPDATE `AreaTable_vanilla` SET name_loc5 = "丹巴達爾" WHERE id = 2959;
UPDATE `AreaTable_vanilla` SET name_loc5 = "冰翼小徑" WHERE id = 2960;
UPDATE `AreaTable_vanilla` SET name_loc5 = "霜狼村" WHERE id = 2961;
UPDATE `AreaTable_vanilla` SET name_loc5 = "哨塔高地" WHERE id = 2962;
UPDATE `AreaTable_vanilla` SET name_loc5 = "冷齒礦坑" WHERE id = 2963;
UPDATE `AreaTable_vanilla` SET name_loc5 = "冰斧要塞" WHERE id = 2964;
UPDATE `AreaTable_vanilla` SET name_loc5 = "冰血要塞" WHERE id = 2977;
UPDATE `AreaTable_vanilla` SET name_loc5 = "霜狼要塞" WHERE id = 2978;
UPDATE `AreaTable_vanilla` SET name_loc5 = "托克雷農場" WHERE id = 2979;
UPDATE `AreaTable_vanilla` SET name_loc5 = "霜刀小徑" WHERE id = 3017;
UPDATE `AreaTable_vanilla` SET name_loc5 = "鐵石營地" WHERE id = 3037;
UPDATE `AreaTable_vanilla` SET name_loc5 = "維吉爾之坑" WHERE id = 3038;
UPDATE `AreaTable_vanilla` SET name_loc5 = "塔霍達廢墟" WHERE id = 3039;
UPDATE `AreaTable_vanilla` SET name_loc5 = "征戰平原" WHERE id = 3057;
UPDATE `AreaTable_vanilla` SET name_loc5 = "冰翼洞穴" WHERE id = 3058;
UPDATE `AreaTable_vanilla` SET name_loc5 = "勇士之墓" WHERE id = 3077;
UPDATE `AreaTable_vanilla` SET name_loc5 = "蟲群之柱" WHERE id = 3097;
UPDATE `AreaTable_vanilla` SET name_loc5 = "暮光崗哨" WHERE id = 3098;
UPDATE `AreaTable_vanilla` SET name_loc5 = "暮光前哨站" WHERE id = 3099;
UPDATE `AreaTable_vanilla` SET name_loc5 = "暮光營地廢墟" WHERE id = 3100;
UPDATE `AreaTable_vanilla` SET name_loc5 = "沙爾札魯的巢穴" WHERE id = 3117;
UPDATE `AreaTable_vanilla` SET name_loc5 = "塔倫迪斯營地" WHERE id = 3137;
UPDATE `AreaTable_vanilla` SET name_loc5 = "雷瑟斯聖所" WHERE id = 3138;
UPDATE `AreaTable_vanilla` SET name_loc5 = "慘月洞穴" WHERE id = 3139;
UPDATE `AreaTable_vanilla` SET name_loc5 = "鱗鬚海龜洞穴" WHERE id = 3140;
UPDATE `AreaTable_vanilla` SET name_loc5 = "滾岩洞穴" WHERE id = 3157;
UPDATE `AreaTable_vanilla` SET name_loc5 = "戰歌勞工營地" WHERE id = 3177;
UPDATE `AreaTable_vanilla` SET name_loc5 = "冰風崗" WHERE id = 3197;
UPDATE `AreaTable_vanilla` SET name_loc5 = "巨槌競技場" WHERE id = 3217;
UPDATE `AreaTable_vanilla` SET name_loc5 = "The Maul UNUSED" WHERE id = 3237;
UPDATE `AreaTable_vanilla` SET name_loc5 = "格拉卡隆之骨" WHERE id = 3257;
UPDATE `AreaTable_vanilla` SET name_loc5 = "戰歌峽谷" WHERE id = 3277;
UPDATE `AreaTable_vanilla` SET name_loc5 = "霜狼墓地" WHERE id = 3297;
UPDATE `AreaTable_vanilla` SET name_loc5 = "霜狼小徑" WHERE id = 3298;
UPDATE `AreaTable_vanilla` SET name_loc5 = "丹巴達爾小徑" WHERE id = 3299;
UPDATE `AreaTable_vanilla` SET name_loc5 = "冰血墓地" WHERE id = 3300;
UPDATE `AreaTable_vanilla` SET name_loc5 = "落雪墓地" WHERE id = 3301;
UPDATE `AreaTable_vanilla` SET name_loc5 = "石爐墓地" WHERE id = 3302;
UPDATE `AreaTable_vanilla` SET name_loc5 = "雷矛墓地" WHERE id = 3303;
UPDATE `AreaTable_vanilla` SET name_loc5 = "冰翼碉堡" WHERE id = 3304;
UPDATE `AreaTable_vanilla` SET name_loc5 = "石爐碉堡" WHERE id = 3305;
UPDATE `AreaTable_vanilla` SET name_loc5 = "蠻爪嶺" WHERE id = 3306;
UPDATE `AreaTable_vanilla` SET name_loc5 = "惡齒村" WHERE id = 3317;
UPDATE `AreaTable_vanilla` SET name_loc5 = "杜隆坦之石" WHERE id = 3318;
UPDATE `AreaTable_vanilla` SET name_loc5 = "銀翼樹林" WHERE id = 3319;
UPDATE `AreaTable_vanilla` SET name_loc5 = "戰歌伐木場" WHERE id = 3320;
UPDATE `AreaTable_vanilla` SET name_loc5 = "銀翼要塞" WHERE id = 3321;
UPDATE `AreaTable_vanilla` SET name_loc5 = "蠻爪洞穴" WHERE id = 3337;
UPDATE `AreaTable_vanilla` SET name_loc5 = "迷霧裂隙" WHERE id = 3338;
UPDATE `AreaTable_vanilla` SET name_loc5 = "尤亞姆巴島" WHERE id = 3357;
UPDATE `AreaTable_vanilla` SET name_loc5 = "阿拉希盆地" WHERE id = 3358;
UPDATE `AreaTable_vanilla` SET name_loc5 = "毒蛇小徑" WHERE id = 3377;
UPDATE `AreaTable_vanilla` SET name_loc5 = "希爾雷克祭壇" WHERE id = 3378;
UPDATE `AreaTable_vanilla` SET name_loc5 = "沙德拉札爾" WHERE id = 3379;
UPDATE `AreaTable_vanilla` SET name_loc5 = "哈卡萊獵場" WHERE id = 3380;
UPDATE `AreaTable_vanilla` SET name_loc5 = "希瓦拉爾之角" WHERE id = 3381;
UPDATE `AreaTable_vanilla` SET name_loc5 = "比塞克神廟" WHERE id = 3382;
UPDATE `AreaTable_vanilla` SET name_loc5 = "血火之池" WHERE id = 3383;
UPDATE `AreaTable_vanilla` SET name_loc5 = "血神祭壇" WHERE id = 3384;
UPDATE `AreaTable_vanilla` SET name_loc5 = "贊札高地" WHERE id = 3397;
UPDATE `AreaTable_vanilla` SET name_loc5 = "瘋狂之緣" WHERE id = 3398;
UPDATE `AreaTable_vanilla` SET name_loc5 = "托爾貝恩大廳" WHERE id = 3417;
UPDATE `AreaTable_vanilla` SET name_loc5 = "污染者之穴" WHERE id = 3418;
UPDATE `AreaTable_vanilla` SET name_loc5 = "帕格漁場" WHERE id = 3419;
UPDATE `AreaTable_vanilla` SET name_loc5 = "農場" WHERE id = 3420;
UPDATE `AreaTable_vanilla` SET name_loc5 = "鐵匠舖" WHERE id = 3421;
UPDATE `AreaTable_vanilla` SET name_loc5 = "伐木場" WHERE id = 3422;
UPDATE `AreaTable_vanilla` SET name_loc5 = "金礦" WHERE id = 3423;
UPDATE `AreaTable_vanilla` SET name_loc5 = "獸欄" WHERE id = 3424;
UPDATE `AreaTable_vanilla` SET name_loc5 = "塞納里奧城堡" WHERE id = 3425;
UPDATE `AreaTable_vanilla` SET name_loc5 = "鹿盔崗哨" WHERE id = 3426;
UPDATE `AreaTable_vanilla` SET name_loc5 = "銅鬚營地" WHERE id = 3427;
UPDATE `AreaTable_vanilla` SET name_loc5 = "安其拉" WHERE id = 3428;
UPDATE `AreaTable_vanilla` SET name_loc5 = "安其拉廢墟" WHERE id = 3429;
UPDATE `AreaTable_vanilla` SET name_loc5 = "暮光基地" WHERE id = 3446;
UPDATE `AreaTable_vanilla` SET name_loc5 = "奧泰爾的隱居處" WHERE id = 3447;
UPDATE `AreaTable_vanilla` SET name_loc5 = "甲蟲工匠區" WHERE id = 3448;
UPDATE `AreaTable_vanilla` SET name_loc5 = "將軍工匠區" WHERE id = 3449;
UPDATE `AreaTable_vanilla` SET name_loc5 = "倉庫" WHERE id = 3450;
UPDATE `AreaTable_vanilla` SET name_loc5 = "孵化室" WHERE id = 3451;
UPDATE `AreaTable_vanilla` SET name_loc5 = "狹谷" WHERE id = 3452;
UPDATE `AreaTable_vanilla` SET name_loc5 = "守衛工匠區" WHERE id = 3453;
UPDATE `AreaTable_vanilla` SET name_loc5 = "安其拉廢墟" WHERE id = 3454;
UPDATE `AreaTable_vanilla` SET name_loc5 = "納克薩瑪斯" WHERE id = 3456;
UPDATE `AreaTable_vanilla` SET name_loc5 = "城鎮" WHERE id = 3459;
UPDATE `AreaTable_vanilla` SET name_loc5 = "安其拉之門" WHERE id = 3478;
UPDATE `AreaTable_vanilla` SET name_loc5 = "拉文霍德莊園" WHERE id = 3486;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Dun Morogh" WHERE id = 1;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Playa Larga" WHERE id = 2;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Tierras Inhóspitas" WHERE id = 3;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Las Tierras Devastadas" WHERE id = 4;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cala Aguasnegras" WHERE id = 7;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Pantano de las Penas" WHERE id = 8;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Valle de Villanorte" WHERE id = 9;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bosque del Ocaso" WHERE id = 10;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Los Humedales" WHERE id = 11;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bosque de Elwynn" WHERE id = 12;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Árbol del Mundo" WHERE id = 13;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Durotar" WHERE id = 14;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Marjal Revolcafango" WHERE id = 15;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Azshara" WHERE id = 16;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Los Baldíos" WHERE id = 17;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago de Cristal" WHERE id = 18;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Zul'Gurub" WHERE id = 19;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Arroyo de la Luna" WHERE id = 20;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Kul Tiras" WHERE id = 21;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Isla del Programador" WHERE id = 22;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Río de Villanorte" WHERE id = 23;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Abadía de Villanorte" WHERE id = 24;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Montaña Roca Negra" WHERE id = 25;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Faro" WHERE id = 26;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Tierras de la Peste del Oeste" WHERE id = 28;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Nine" WHERE id = 30;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Cementerio" WHERE id = 32;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Vega de Tuercespina" WHERE id = 33;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mina del Eco" WHERE id = 34;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bahía del Botín" WHERE id = 35;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Montañas de Alterac" WHERE id = 36;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago Nazferiti" WHERE id = 37;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Loch Modan" WHERE id = 38;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Páramos de Poniente" WHERE id = 40;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Paso de la Muerte" WHERE id = 41;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Villa Oscura" WHERE id = 42;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Orilla Salvaje" WHERE id = 43;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Montañas Crestagrana" WHERE id = 44;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Tierras Altas de Arathi" WHERE id = 45;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Las Estepas Ardientes" WHERE id = 46;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Tierras del Interior" WHERE id = 47;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Agujero del Muerto" WHERE id = 49;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Garganta de Fuego" WHERE id = 51;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campamento de Ladrones" WHERE id = 53;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cantera de Jaspe" WHERE id = 54;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Valley of Heroes UNUSED" WHERE id = 55;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Vigilia de los Héroes" WHERE id = 56;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mina Abisal" WHERE id = 57;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Viñedos de Villanorte" WHERE id = 59;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Linde del bosque" WHERE id = 60;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cataratas del Trueno" WHERE id = 61;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Plantación de Calabazas de Brackwell" WHERE id = 62;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Granja Pedregosa" WHERE id = 63;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Los Viñedos de Maclure" WHERE id = 64;
UPDATE `AreaTable_vanilla` SET name_loc6 = "***On Map Dungeon***" WHERE id = 65;
UPDATE `AreaTable_vanilla` SET name_loc6 = "***On Map Dungeon***" WHERE id = 66;
UPDATE `AreaTable_vanilla` SET name_loc6 = "***On Map Dungeon***" WHERE id = 67;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago Sempiterno" WHERE id = 68;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Villa del Lago" WHERE id = 69;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Petravista" WHERE id = 70;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cascadas Petravista" WHERE id = 71;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Portal Oscuro" WHERE id = 72;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Escara Ímpia" WHERE id = 73;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Charca de Lágrimas" WHERE id = 74;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Rocal" WHERE id = 75;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Retiro Fangoso" WHERE id = 76;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Yunquemar" WHERE id = 77;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Montañas de Ventormenta" WHERE id = 80;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Jeff NE Quadrant Changed" WHERE id = 81;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Jeff NW Quadrant" WHERE id = 82;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Jeff SE Quadrant" WHERE id = 83;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Jeff SW Quadrant" WHERE id = 84;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Claros de Tirisfal" WHERE id = 85;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago del Hito" WHERE id = 86;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Villadorada" WHERE id = 87;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Aserradero de la Vega del Este" WHERE id = 88;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Vergel del Lago Espejo" WHERE id = 89;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Torre de Azora" WHERE id = 91;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago Espejo" WHERE id = 92;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Túmulo de Vul'Gol" WHERE id = 93;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cerro del Cuervo" WHERE id = 94;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cañones de Crestagrana" WHERE id = 95;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Torre de Ilgalar" WHERE id = 96;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Molino de Alther" WHERE id = 97;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cavernas de Rethban" WHERE id = 98;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Asentamiento Rebelde" WHERE id = 99;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Expedición de Nesingwary" WHERE id = 100;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Base de Kurzen" WHERE id = 101;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas de Zul'Kunda" WHERE id = 102;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas de Zul'Mamwe" WHERE id = 103;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Arrecife Mortal" WHERE id = 104;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Túmulo Ogro Mosh'Ogg" WHERE id = 105;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Las Reservas" WHERE id = 106;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Finca de Saldean" WHERE id = 107;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Colina del Centinela" WHERE id = 108;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Plantación de Calabazas de Furlbrow" WHERE id = 109;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mina de Jango" WHERE id = 111;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mina de la Costa del Oro" WHERE id = 113;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Faro de Poniente" WHERE id = 115;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Valle Brumoso" WHERE id = 116;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campamento Grom'Gol" WHERE id = 117;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Excavación de Whelgar" WHERE id = 118;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cuartel Arroyoeste" WHERE id = 120;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cementerio del Jardín Sereno" WHERE id = 121;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas Zuuldaia" WHERE id = 122;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas de Bal'lal" WHERE id = 123;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas de Kal'ai" WHERE id = 125;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas de Tkashi" WHERE id = 126;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas de Balia'mah" WHERE id = 127;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas de Ziata'jai" WHERE id = 128;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas de Mizjah" WHERE id = 129;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bosque de Argénteos" WHERE id = 130;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Kharanos" WHERE id = 131;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Valle de Crestanevada" WHERE id = 132;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Gnomeregan" WHERE id = 133;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cantera de Gol'Bolar" WHERE id = 134;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Poblado Peloescarcha" WHERE id = 135;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Cubil Pardo" WHERE id = 136;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Las Birras" WHERE id = 137;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Refugio Pinobruma" WHERE id = 138;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Tierras de la Peste del Este" WHERE id = 139;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Teldrassil" WHERE id = 141;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Excavación de Ironband" WHERE id = 142;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Fortaleza de Mo'grosh" WHERE id = 143;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Thelsamar" WHERE id = 144;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Puerta de Algaz" WHERE id = 145;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Presa de las Tres Cabezas" WHERE id = 146;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cabaña del Errante" WHERE id = 147;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Costa Oscura" WHERE id = 148;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mina de Fuenteplata" WHERE id = 149;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Puerto de Menethil" WHERE id = 150;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Isla del Diseñador" WHERE id = 151;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Baluarte" WHERE id = 152;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas de Lordaeron" WHERE id = 153;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Camposanto" WHERE id = 154;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Hoya Nocturácnidas" WHERE id = 155;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Hacienda Solliden" WHERE id = 156;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Molinos de Agamand" WHERE id = 157;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cripta de la Familia Agamand" WHERE id = 158;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Rémol" WHERE id = 159;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Jardines de los Susurros" WHERE id = 160;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bancal del Reposo" WHERE id = 161;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago Aguasclaras" WHERE id = 162;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Refugio de Gunther" WHERE id = 163;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Granja de Garren" WHERE id = 164;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Hacienda Balnir" WHERE id = 165;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mansión Fríogar" WHERE id = 166;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Avanzada de los Cruzados" WHERE id = 167;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Costa Norte" WHERE id = 168;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Costa Murmurante" WHERE id = 169;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago Lordamere" WHERE id = 170;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Isla de Fenris" WHERE id = 172;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Tumba de Faol" WHERE id = 173;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Dolanaar" WHERE id = 186;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Darnassus UNUSED" WHERE id = 187;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cañada Umbría" WHERE id = 188;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Almacén de Steelgrill" WHERE id = 189;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Vega del Amparo" WHERE id = 190;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Aserradero Crestanorte" WHERE id = 192;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas de Andorhal" WHERE id = 193;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Escuela de Necromancia" WHERE id = 195;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Tumba de Uther" WHERE id = 196;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Colina de las Penas" WHERE id = 197;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Cueva del Llanto" WHERE id = 198;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campo de Piedramácula" WHERE id = 199;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Llanto de Dalson" WHERE id = 200;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Gangrena de Gahrron" WHERE id = 201;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Tormento" WHERE id = 202;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Fuerte de Mardenholde" WHERE id = 203;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Aldea Piroleña" WHERE id = 204;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Dun Modr" WHERE id = 205;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Páramos de Poniente" WHERE id = 206;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mare Magnum" WHERE id = 207;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Unused Cala del Acorazado" WHERE id = 208;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Castillo de Colmillo Oscuro" WHERE id = 209;
UPDATE `AreaTable_vanilla` SET name_loc6 = "***On Map Dungeon***" WHERE id = 210;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago Glacial" WHERE id = 211;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago de Helm" WHERE id = 212;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mina de Elem" WHERE id = 213;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mare Magnum" WHERE id = 214;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mulgore" WHERE id = 215;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Hacienda de Alexston" WHERE id = 219;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mesa de la Nube Roja" WHERE id = 220;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campamento Narache" WHERE id = 221;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Poblado Pezuña de Sangre" WHERE id = 222;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago Toro de Piedra" WHERE id = 223;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Caravana Devastada" WHERE id = 224;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Roca Roja" WHERE id = 225;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Penumbra de las Celerácnidas" WHERE id = 226;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campo de Valgan" WHERE id = 227;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Sepulcro" WHERE id = 228;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Finca de Olsen" WHERE id = 229;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Muralla de Greymane" WHERE id = 230;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Desafío de Beren" WHERE id = 231;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Islas del Alba" WHERE id = 232;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Molino Ámbar" WHERE id = 233;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Castillo de Fenris" WHERE id = 235;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Castillo de Colmillo Oscuro" WHERE id = 236;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Viejo Embarcadero" WHERE id = 237;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Huerta de Malden" WHERE id = 238;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Los Dominios de Ivar" WHERE id = 239;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Campo Muerto" WHERE id = 240;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Vergel Pútrido" WHERE id = 241;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Arboleda del Destello" WHERE id = 242;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Loma Inhóspita" WHERE id = 243;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Raquitismo" WHERE id = 244;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Hacienda Yorgen" WHERE id = 245;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Caldera" WHERE id = 246;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Excavación de Grimesilt" WHERE id = 247;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Roca Machacamiedo" WHERE id = 249;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas de Thaurissan" WHERE id = 250;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Peñasco Llamarada" WHERE id = 251;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bastión de Roca Negra" WHERE id = 252;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Pilar de Ceniza" WHERE id = 253;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Montaña Roca Negra" WHERE id = 254;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Altar de la Tempestad" WHERE id = 255;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Aldrassil" WHERE id = 256;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Gruta Narácnida" WHERE id = 257;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Roca Mácula" WHERE id = 258;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago Al'Ameth" WHERE id = 259;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Aldea Brisa Estelar" WHERE id = 260;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Tierras de los Tuercepinos" WHERE id = 261;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Túmulo de Ben'ethil" WHERE id = 262;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Grieta" WHERE id = 263;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Claro del Oráculo" WHERE id = 264;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Río Primigenio" WHERE id = 265;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago Primigenio" WHERE id = 266;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Laderas de Trabalomas" WHERE id = 267;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cráter de Azshara" WHERE id = 268;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Dun Algaz" WHERE id = 269;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Costasur" WHERE id = 271;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Molino Tarren" WHERE id = 272;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Castillo de Durnholde" WHERE id = 275;
UPDATE `AreaTable_vanilla` SET name_loc6 = "UNUSED Stonewrought Pass" WHERE id = 276;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cuevas de la Ladera" WHERE id = 277;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campo de Reclusión de Lordamere" WHERE id = 278;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Dalaran" WHERE id = 279;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Strahnbrad" WHERE id = 280;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas de Alterac" WHERE id = 281;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Dominios de los Aplastacresta" WHERE id = 282;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cuenca de la Matanza" WHERE id = 283;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Las Tierras Altas" WHERE id = 284;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Torre Austral" WHERE id = 285;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campos de Trabalomas" WHERE id = 286;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Trabalomas" WHERE id = 287;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mina Azur" WHERE id = 288;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Granja Nethander" WHERE id = 289;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Dun Garok" WHERE id = 290;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Muralla de Thoradin" WHERE id = 293;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Playa del Este" WHERE id = 294;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Playa del Oeste" WHERE id = 295;
UPDATE `AreaTable_vanilla` SET name_loc6 = "South Seas UNUSED" WHERE id = 296;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Isla Jaguero" WHERE id = 297;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bahía de Baradin" WHERE id = 298;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bahía de Menethil" WHERE id = 299;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Playa Juncobruma" WHERE id = 300;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Costa Salvaje" WHERE id = 301;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Costa de Cristal" WHERE id = 302;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Playa del Molusco" WHERE id = 303;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cala Mareanorte" WHERE id = 305;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cala Mareasur" WHERE id = 306;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Los Acantilados Dominantes" WHERE id = 307;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mar Adusto" WHERE id = 308;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Tumba de Barbaférrea" WHERE id = 309;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mina de Cristal" WHERE id = 310;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas de Aboraz" WHERE id = 311;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cayo de Janeiro" WHERE id = 312;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mansión Redilnorte" WHERE id = 313;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Granja Go'shek" WHERE id = 314;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Granja de Dabyrie" WHERE id = 315;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Sala de Puño de Roca" WHERE id = 316;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Poblado Secacorteza" WHERE id = 317;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cañón Mostacho Seco" WHERE id = 318;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Refugio de la Zaga" WHERE id = 320;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Sentencia" WHERE id = 321;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Naufragios de Aguasnegras" WHERE id = 322;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campamento de O'Breen" WHERE id = 323;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Castillo de Stromgarde" WHERE id = 324;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Torre de Arathor" WHERE id = 325;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Sagrario" WHERE id = 326;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cala de Faldir" WHERE id = 327;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Arrecife Hundido" WHERE id = 328;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Puente Thandol" WHERE id = 330;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Vallefresno" WHERE id = 331;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mare Magnum UNUSED" WHERE id = 332;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Círculo de Vínculo Este" WHERE id = 333;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Círculo de Vínculo Oeste" WHERE id = 334;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Círculo de Vínculo Interior" WHERE id = 335;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Círculo de Vínculo Exterior" WHERE id = 336;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Descanso de Apócrifo" WHERE id = 337;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Fortaleza de Angor" WHERE id = 338;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Barranco Lethlor" WHERE id = 339;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Kargath" WHERE id = 340;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Asentamiento Kosh" WHERE id = 341;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Asentamiento Boff" WHERE id = 342;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Asentamiento Wurg" WHERE id = 343;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Asentamiento Cagg" WHERE id = 344;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Final de Agmond" WHERE id = 345;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Excavación de Hammertoe" WHERE id = 346;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Gruta Rotapolvo" WHERE id = 347;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Pico Nidal" WHERE id = 348;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Fortaleza de los Martillo Salvaje" WHERE id = 349;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Avanzada Quel'Danil" WHERE id = 350;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Roca Oculta" WHERE id = 351;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Zun'watha" WHERE id = 352;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Shadra'Alor" WHERE id = 353;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Jintha'Alor" WHERE id = 354;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Altar de Zul" WHERE id = 355;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Seradane" WHERE id = 356;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Feralas" WHERE id = 357;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Barranco Cortazarza" WHERE id = 358;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bael Modan" WHERE id = 359;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mina Riesgo y Cía" WHERE id = 360;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Frondavil" WHERE id = 361;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cerrotajo" WHERE id = 362;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Valle de los Retos" WHERE id = 363;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Cubil" WHERE id = 364;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Aquelarre del Filo Ardiente" WHERE id = 365;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Risco Kolkar" WHERE id = 366;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Poblado Sen'jin" WHERE id = 367;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Islas del Eco" WHERE id = 368;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Monte del Trueno" WHERE id = 369;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Barranco Árido" WHERE id = 370;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cueva Viento Seco" WHERE id = 371;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Fuerte de Tiragarde" WHERE id = 372;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Costa de la Huída" WHERE id = 373;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bahía de Garrafilada" WHERE id = 374;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Costa de Mortojo" WHERE id = 375;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Río Furia del Sur" WHERE id = 377;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campamento Taurajo" WHERE id = 378;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Avanzada del Puente" WHERE id = 379;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Cruce" WHERE id = 380;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mina Pedrusco" WHERE id = 381;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Fangal" WHERE id = 382;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Las Colinas Áridas" WHERE id = 383;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cima Calígine" WHERE id = 384;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Fuerte del Norte" WHERE id = 385;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Las Charcas del Olvido" WHERE id = 386;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Oasis Aguaverde" WHERE id = 387;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Oasis Estancado" WHERE id = 388;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Tierra de Gigantes" WHERE id = 390;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Costa Mercante" WHERE id = 391;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Trinquete" WHERE id = 392;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Playa de Lanza Negra" WHERE id = 393;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Darrowmere Lake UNUSED" WHERE id = 394;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Caer Darrow UNUSED" WHERE id = 395;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Pozo Pezuña Invernal" WHERE id = 396;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Pozo Tronacuerno" WHERE id = 397;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Pozo Ferocrín" WHERE id = 398;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cresta Horizonte" WHERE id = 399;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Las Mil Agujas" WHERE id = 400;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Escalón de la Marea" WHERE id = 401;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Posada Reposo Umbrío" WHERE id = 403;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Excavación Bael'Dun" WHERE id = 404;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Desolace" WHERE id = 405;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Sierra Espolón" WHERE id = 406;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Orgrimmar UNUSED" WHERE id = 407;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Isla de Gillijim" WHERE id = 408;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Isla del Doctor Lapidis" WHERE id = 409;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cañón del Ventajo" WHERE id = 410;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas de Bathran" WHERE id = 411;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Las Ruinas de Ordil'Aran" WHERE id = 412;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Atalaya de Maestra" WHERE id = 413;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Ensanada de Zoram" WHERE id = 414;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Astranaar" WHERE id = 415;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Santuario de Aessina" WHERE id = 416;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Santuario de la Escara" WHERE id = 417;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Las Ruinas del Polvo Estelar" WHERE id = 418;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Vega del Aullido" WHERE id = 419;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Refugio Brisa de Plata" WHERE id = 420;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago Mystral" WHERE id = 421;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago Cielo Estrellado" WHERE id = 422;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago Iris" WHERE id = 424;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Poza de la Luna" WHERE id = 425;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Refugio de la Algaba" WHERE id = 426;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Rincón Lóbrego" WHERE id = 427;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Senda de la Noche" WHERE id = 428;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Xavian" WHERE id = 429;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Satyrnaar" WHERE id = 430;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Puesto del Hachazo" WHERE id = 431;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Túmulo de Dor'danil" WHERE id = 432;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Río Falfarren" WHERE id = 433;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cerro Lumbrevil" WHERE id = 434;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Barranco del Demonio" WHERE id = 435;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cresta del Demonio" WHERE id = 436;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Aserradero Grito de Guerra" WHERE id = 437;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Talloumbrío" WHERE id = 438;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Desierto de Sal" WHERE id = 439;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Tanaris" WHERE id = 440;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago Falathim" WHERE id = 441;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Auberdine" WHERE id = 442;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas de Mathystra" WHERE id = 443;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Torre de Althalaxx" WHERE id = 444;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Salto de Fonrroca" WHERE id = 445;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bashal'Aran" WHERE id = 446;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ameth'Aran" WHERE id = 447;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Páramo de los Ancestros" WHERE id = 448;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Glaive del Maestro" WHERE id = 449;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Excavación de Remtravel" WHERE id = 450;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cabo de la Niebla" WHERE id = 452;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Playa del Oleaje" WHERE id = 453;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Río Culebra" WHERE id = 454;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cubil del Bosque Negro" WHERE id = 455;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Río Fonrroca" WHERE id = 456;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mar de la Bruma" WHERE id = 457;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Camino del Oro" WHERE id = 458;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Atalaya Escarlata" WHERE id = 459;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Refugio Roca del Sol" WHERE id = 460;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Risco Cortaviento" WHERE id = 461;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago del Peñasco" WHERE id = 463;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago Mirkfallon" WHERE id = 464;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Vega Carbonizada" WHERE id = 465;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Valle Furia Sangrienta" WHERE id = 466;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cima del Espolón" WHERE id = 467;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Cubil del Espolón" WHERE id = 468;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Vega del Gran Bosque" WHERE id = 469;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cima del Trueno UNUSED" WHERE id = 470;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mesa de Viento Bravo" WHERE id = 471;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mesa de La Piedra de Fuego" WHERE id = 472;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Rocamanto" WHERE id = 473;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Hunter Rise UNUSED" WHERE id = 474;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Spirit RiseUNUSED" WHERE id = 475;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Elder RiseUNUSED" WHERE id = 476;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas de Jubuwal" WHERE id = 477;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Estanques de Arlithrien" WHERE id = 478;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Excavación Pico Roto" WHERE id = 479;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campamento E'thok" WHERE id = 480;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Risco Pezuña Quebrada" WHERE id = 481;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Nido Alto" WHERE id = 482;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cañón del Chirrido" WHERE id = 483;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Poblado Viento Libre" WHERE id = 484;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Gran Elevador" WHERE id = 485;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Dominios Galak" WHERE id = 486;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Guarida Malapluma" WHERE id = 487;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Hueco Perdido" WHERE id = 488;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Thalanaar" WHERE id = 489;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cráter de Un'Goro" WHERE id = 490;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Horado Rajacieno" WHERE id = 491;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cementerio del Cerro del Cuervo" WHERE id = 492;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Claro de la Luna" WHERE id = 493;
UPDATE `AreaTable_vanilla` SET name_loc6 = "DELETE ME" WHERE id = 495;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Poblado Murohelecho" WHERE id = 496;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mansión Cienaluz" WHERE id = 497;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Madriguera de los Cienorrojo" WHERE id = 498;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cueva de la Niebla Negra" WHERE id = 499;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cabo Moggle" WHERE id = 500;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Siniestro de Beezil" WHERE id = 501;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Colina de las Brujas" WHERE id = 502;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Alto del Centinela" WHERE id = 503;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Torre de la Punta Norte" WHERE id = 504;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Torre de la Punta Oeste" WHERE id = 505;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Punta Perdida" WHERE id = 506;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ciénaga Azul" WHERE id = 507;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas Quebrantarrocas" WHERE id = 508;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cubil de la Llama" WHERE id = 509;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Pantano del Dragón" WHERE id = 510;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ciénaga de Fuego" WHERE id = 511;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Onyxia's Lair UNUSED" WHERE id = 512;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Isla Theramore" WHERE id = 513;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ciudadela Garrida" WHERE id = 514;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Prisión del Acorazado" WHERE id = 515;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bahía Revolcafango" WHERE id = 516;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cala Furiamarea" WHERE id = 517;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Playa Tenebruma" WHERE id = 518;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Granja de Addle" WHERE id = 536;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cresta del Penacho en Llamas" WHERE id = 537;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Fosas de Alquitrán Lakkari" WHERE id = 538;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Camino del Terror" WHERE id = 539;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Cicatriz del Desliz" WHERE id = 540;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Refugio de Marshal" WHERE id = 541;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Roca Fungal" WHERE id = 542;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Baños de Golakka" WHERE id = 543;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Loch Modan" WHERE id = 556;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Refugio de los Mendigos" WHERE id = 576;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cementerio de Kodos" WHERE id = 596;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campamento del Espíritu Errante" WHERE id = 597;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Playa de Sar'theris" WHERE id = 598;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Fortaleza del Hacha de Trueno" WHERE id = 599;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cuenca de Bolgan" WHERE id = 600;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Aquelarre Mannoroc" WHERE id = 602;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Sargeron" WHERE id = 603;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Poblado Magram" WHERE id = 604;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Poblado Gelkis" WHERE id = 606;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Valle de las Lanzas" WHERE id = 607;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Punta de Nijel" WHERE id = 608;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Poblado Kolkar" WHERE id = 609;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Hyjal" WHERE id = 616;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cuna del Invierno" WHERE id = 618;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Río Lobonegro" WHERE id = 636;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Roca de los Kodos" WHERE id = 637;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Sendero Oculto" WHERE id = 638;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Roca de los Espíritus" WHERE id = 639;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Santuario de la Llama Latente" WHERE id = 640;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago Elune'ara" WHERE id = 656;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Puerto" WHERE id = 657;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Terrallende" WHERE id = 676;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Craftsmen's Terrace UNUSED" WHERE id = 696;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Tradesmen's Terrace UNUSED" WHERE id = 697;
UPDATE `AreaTable_vanilla` SET name_loc6 = "The Temple Gardens UNUSED" WHERE id = 698;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Templo de Elune UNUSED" WHERE id = 699;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cenarion Enclave UNUSED" WHERE id = 700;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Warrior's Terrace UNUSED" WHERE id = 701;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Aldea Rut'theran" WHERE id = 702;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Complejo Ironband" WHERE id = 716;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Las Mazmorras" WHERE id = 717;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cuevas de los Lamentos" WHERE id = 718;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cavernas de Brazanegra" WHERE id = 719;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Isla de Batalla" WHERE id = 720;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Gnomeregan" WHERE id = 721;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Zahúrda Rojocieno" WHERE id = 722;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Hondonada Ban'ethil" WHERE id = 736;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Monasterio Escarlata" WHERE id = 796;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Embarcadero de Jerod" WHERE id = 797;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Torre de la Peña" WHERE id = 798;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Ribera Lóbrega" WHERE id = 799;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Desfiladero de Crestanevada" WHERE id = 800;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Valle Escalofrío" WHERE id = 801;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Monte Luz" WHERE id = 802;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Granja de Semperámbar" WHERE id = 803;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Las Colinas Tundra" WHERE id = 804;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Paso de la Puerta Sur" WHERE id = 805;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Avanzada de la Puerta Sur" WHERE id = 806;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Paso de la Puerta Norte" WHERE id = 807;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Avanzada de la Puerta Norte" WHERE id = 808;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Puertas de Forjaz" WHERE id = 809;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Charca Aguaserena" WHERE id = 810;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Vega Pesadilla" WHERE id = 811;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Vega Venerácnidas" WHERE id = 812;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Baluarte" WHERE id = 813;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Río Furia del Sur" WHERE id = 814;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Río Furia del Sur" WHERE id = 815;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Tierras Crines de Acero" WHERE id = 816;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Roca del Cráneo" WHERE id = 817;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Roca Crines Pálidas" WHERE id = 818;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cresta Viento Furioso" WHERE id = 819;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Las Llanuras Doradas" WHERE id = 820;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Las Llanuras Onduladas" WHERE id = 821;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Dun Algaz" WHERE id = 836;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Dun Algaz" WHERE id = 837;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Paso de la Puerta Norte" WHERE id = 838;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Paso de la Puerta Sur" WHERE id = 839;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Arboleda del Crepúsculo" WHERE id = 856;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Isla de los MJ" WHERE id = 876;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Delete ME" WHERE id = 877;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Río Furia del Sur" WHERE id = 878;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Río Furia del Sur" WHERE id = 879;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Puente Thandol" WHERE id = 880;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Puente Thandol" WHERE id = 881;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Isla del Purgatorio" WHERE id = 896;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Finca de Jansen" WHERE id = 916;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Campo Funesto" WHERE id = 917;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Granja de Molsen" WHERE id = 918;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Estanque de Stendel" WHERE id = 919;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Las Colinas Afiladas" WHERE id = 920;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Paraje de Demont" WHERE id = 921;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Los Yermos Polvorientos" WHERE id = 922;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Valle Rompecantos" WHERE id = 923;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Valle de los Reyes" WHERE id = 924;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Estación de Algaz" WHERE id = 925;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La granja de Bucklebree" WHERE id = 926;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Playa Plateada" WHERE id = 927;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Hoya Mareanorte" WHERE id = 928;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Fuerte Zarpagris" WHERE id = 936;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Los Verdegales" WHERE id = 956;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Gadgetzan" WHERE id = 976;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Puerto Bonvapor" WHERE id = 977;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Zul'Farrak" WHERE id = 978;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Vigía Penas de Arena" WHERE id = 979;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Valle Cardizal" WHERE id = 980;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Sima Abierta" WHERE id = 981;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Guarida Ponzoñosa" WHERE id = 982;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Base Machacaduna" WHERE id = 983;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas de Lunaeste" WHERE id = 984;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campo del Manantial" WHERE id = 985;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Guarida de Zalashji" WHERE id = 986;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Playa Finisterrae" WHERE id = 987;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Playa Baile de las Olas" WHERE id = 988;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Uldum" WHERE id = 989;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Valle de los Vigías" WHERE id = 990;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Puesto de Gunstan" WHERE id = 991;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas de Lunasur" WHERE id = 992;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campamento de Render" WHERE id = 996;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Valle de Render" WHERE id = 997;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Roca de Render" WHERE id = 998;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Torre de Petravista" WHERE id = 999;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Valle de Galardell" WHERE id = 1000;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Camino del Lago" WHERE id = 1001;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Tres Caminos" WHERE id = 1002;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cerro Fraguaferoz" WHERE id = 1016;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Colina del Raptor" WHERE id = 1017;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Pantano del Canal Negro" WHERE id = 1018;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Franja Verde" WHERE id = 1019;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Pantano Pellejomusgo" WHERE id = 1020;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Roca Thelgen" WHERE id = 1021;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Pantano Branquizul" WHERE id = 1022;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cañada Salobre" WHERE id = 1023;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Pantano del Ocaso" WHERE id = 1024;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Franja Verde" WHERE id = 1025;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campamento Dentellada" WHERE id = 1036;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Grim Batol" WHERE id = 1037;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Puertas Faucedraco" WHERE id = 1038;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Flota Perdida" WHERE id = 1039;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Colinas de Darrow" WHERE id = 1056;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Muralla de Thoradin" WHERE id = 1057;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Senda de las Tejedoras" WHERE id = 1076;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Ribera Silente" WHERE id = 1097;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mansión de los Mantoniebla" WHERE id = 1098;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campamento Mojache" WHERE id = 1099;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Dominios Tótem Siniestro" WHERE id = 1100;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Las Entrañas Retorcidas" WHERE id = 1101;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago Ventosalvaje" WHERE id = 1102;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Avanzada Gordunni" WHERE id = 1103;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mok'Gordun" WHERE id = 1104;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Vega Cicatriz Feral" WHERE id = 1105;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Tierras Altas de Plumavieja" WHERE id = 1106;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago Soplo" WHERE id = 1107;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Costa Olvidada" WHERE id = 1108;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Pilar Este" WHERE id = 1109;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Pilar Oeste" WHERE id = 1110;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Rama Oniria" WHERE id = 1111;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago Jademir" WHERE id = 1112;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Oneiros" WHERE id = 1113;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas de Viento Azabache" WHERE id = 1114;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Dominios de los Cicatriz de Rabia" WHERE id = 1115;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bastión Plumaluna" WHERE id = 1116;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas de Solarsal" WHERE id = 1117;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lower Wilds UNUSED" WHERE id = 1118;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Los Dos Colosos" WHERE id = 1119;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Isla de Sardor" WHERE id = 1120;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Isla del Terror" WHERE id = 1121;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Altas Tierras Salvajes" WHERE id = 1136;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bajas Tierras Salvajes" WHERE id = 1137;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Baldíos del Sur" WHERE id = 1156;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Camino del Oro Sur" WHERE id = 1157;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Zul'Farrak" WHERE id = 1176;
UPDATE `AreaTable_vanilla` SET name_loc6 = "UNUSEDAlcaz Island" WHERE id = 1196;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bastión de los Fauces de Madera" WHERE id = 1216;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campamento Vanndir" WHERE id = 1217;
UPDATE `AreaTable_vanilla` SET name_loc6 = "TESTAzshara" WHERE id = 1218;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campamento Legashi" WHERE id = 1219;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campamento base thalassiano" WHERE id = 1220;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas de Eldarath" WHERE id = 1221;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Guarida de Hetaera" WHERE id = 1222;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Templo de Zin-Malor" WHERE id = 1223;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cabeza de Oso" WHERE id = 1224;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ursolan" WHERE id = 1225;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Templo de Arkkoran" WHERE id = 1226;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bahía de la Tempestad" WHERE id = 1227;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Playa Arrasada" WHERE id = 1228;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Torre de Eldara" WHERE id = 1229;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Arrecife Dentado" WHERE id = 1230;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Playa del Arrecife Sur" WHERE id = 1231;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Monumento Cresta Cuervo" WHERE id = 1232;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Loma Desolada" WHERE id = 1233;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago Mennar" WHERE id = 1234;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Santuario de Shadowsong" WHERE id = 1235;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campamento Haldarr" WHERE id = 1236;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Valormok" WHERE id = 1237;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Las Ruinas" WHERE id = 1256;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Paso del Espolón" WHERE id = 1276;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Paso del Espolón" WHERE id = 1277;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Granja Rocamuela" WHERE id = 1296;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Pocilga" WHERE id = 1297;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Zahúrda Rojocieno" WHERE id = 1316;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cala del Aparejo Perdido" WHERE id = 1336;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Uldaman" WHERE id = 1337;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago Lordamere" WHERE id = 1338;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago Lordamere" WHERE id = 1339;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Camino de la Horca" WHERE id = 1357;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Silithus" WHERE id = 1377;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bosque Esmeralda" WHERE id = 1397;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Templo Sumergido" WHERE id = 1417;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bastión Machacamiedo" WHERE id = 1437;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Castillo de Nethergarde" WHERE id = 1438;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Puesto Machacamiedo" WHERE id = 1439;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Escama de la Serpiente" WHERE id = 1440;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Altar de la Tempestad" WHERE id = 1441;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cresta Vigía" WHERE id = 1442;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Fosa de la Escoria" WHERE id = 1443;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Mar de las Cenizas" WHERE id = 1444;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Montaña Roca Negra" WHERE id = 1445;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Puesto del Torio" WHERE id = 1446;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Arsenal del Cuartel" WHERE id = 1457;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Templo de Atal'Hakkar" WHERE id = 1477;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Entrañas" WHERE id = 1497;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Uldaman" WHERE id = 1517;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Not Used Deadmines" WHERE id = 1518;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ciudad de Ventormenta" WHERE id = 1519;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Forjaz" WHERE id = 1537;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campamento Pezuña Quebrada" WHERE id = 1557;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Cabo de Tuercespina" WHERE id = 1577;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Costa Salvaje del Sur" WHERE id = 1578;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Unused The Deadmines 003" WHERE id = 1579;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Unused Ironclad Cove 004" WHERE id = 1580;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Las Minas de la Muerte" WHERE id = 1581;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cala del Acorazado" WHERE id = 1582;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cumbre de Roca Negra" WHERE id = 1583;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Profundidades de Roca Negra" WHERE id = 1584;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Raptor Grounds UNUSED" WHERE id = 1597;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Grol'dom Farm UNUSED" WHERE id = 1598;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campamento de Mor'shan" WHERE id = 1599;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Honor's Stand UNUSED" WHERE id = 1600;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Blackthorn Ridge UNUSED" WHERE id = 1601;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bramblescar UNUSED" WHERE id = 1602;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Agama'gor UNUSED" WHERE id = 1603;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Valle de los Héroes" WHERE id = 1617;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Orgrimmar" WHERE id = 1637;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cima del Trueno" WHERE id = 1638;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Alto de los Ancestros" WHERE id = 1639;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Alto de los Espíritus" WHERE id = 1640;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Alto de los Cazadores" WHERE id = 1641;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Darnassus" WHERE id = 1657;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Enclave Cenarion" WHERE id = 1658;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bancal del Artesano" WHERE id = 1659;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bancal del Guerrero" WHERE id = 1660;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Los Jardines del Templo" WHERE id = 1661;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bancal de los Mercaderes" WHERE id = 1662;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Saliente de Gavin" WHERE id = 1677;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Saliente de Sofera" WHERE id = 1678;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Daga de Corrahn" WHERE id = 1679;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Punta" WHERE id = 1680;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Costa de la Neblina" WHERE id = 1681;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Redil de Dandred" WHERE id = 1682;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Caverna Estrecha" WHERE id = 1683;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Alto del Orvallo" WHERE id = 1684;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Tierras de los Raptores" WHERE id = 1697;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Rajazarza" WHERE id = 1698;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Colina Espinosa" WHERE id = 1699;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Agama'gor" WHERE id = 1700;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Loma Espina Negra" WHERE id = 1701;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Alto del Honor" WHERE id = 1702;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Muralla de Mor'shan" WHERE id = 1703;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Granja de Grol'dom" WHERE id = 1704;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Horado Rajacieno" WHERE id = 1717;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Gran Elevador" WHERE id = 1718;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Valle del Velo de Bruma" WHERE id = 1737;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Manantial Nek'mani" WHERE id = 1738;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Dominios Vela de Sangre" WHERE id = 1739;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Base de Ventura y Cía" WHERE id = 1740;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Arena Gurubashi" WHERE id = 1741;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cubil del Espíritu" WHERE id = 1742;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Velo Carmesí" WHERE id = 1757;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Las Mareas Vivas" WHERE id = 1758;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Damisela Afortunada" WHERE id = 1759;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Centro de Operaciones de Ventura y Cía" WHERE id = 1760;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Aldea Muertobosque" WHERE id = 1761;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Poblado Zarpavil" WHERE id = 1762;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Jaedenar" WHERE id = 1763;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Río del Veneno" WHERE id = 1764;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cascadas del Veneno" WHERE id = 1765;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cañada Gran Cicatriz" WHERE id = 1766;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bosque de Troncoferro" WHERE id = 1767;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Caverna de Troncoferro" WHERE id = 1768;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bastión de los Fauces de Madera" WHERE id = 1769;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Guarida Sombría" WHERE id = 1770;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Santuario del Impostor" WHERE id = 1771;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cueva de Itharius" WHERE id = 1777;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Tinieblas de las Penas" WHERE id = 1778;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Aldea Draenil'dur" WHERE id = 1779;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cruce Lanzarota" WHERE id = 1780;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Stagalbog" WHERE id = 1797;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lodo Traicionero" WHERE id = 1798;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cueva Stagalbog" WHERE id = 1817;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cuevas Secacorteza" WHERE id = 1837;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Muralla de Thoradin" WHERE id = 1857;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Boulder'gor" WHERE id = 1858;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Valle de los Colmillos" WHERE id = 1877;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Terraseca" WHERE id = 1878;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Esplanada del Espejismo" WHERE id = 1879;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cobertizo de Barbapluma" WHERE id = 1880;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campamento Machacacanillas" WHERE id = 1881;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Barranco Bruma Enferma" WHERE id = 1882;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago Ventobravo" WHERE id = 1883;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Agol'watha" WHERE id = 1884;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Hiri'watha" WHERE id = 1885;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Las Ruinas Abyectas" WHERE id = 1886;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Arrecife de Bogen" WHERE id = 1887;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bancal del Hacedor" WHERE id = 1897;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Barranco Viento Seco" WHERE id = 1898;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Shaol'watha" WHERE id = 1917;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas Sombrasol" WHERE id = 1937;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Pilar Partido" WHERE id = 1938;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Arenas Abisales" WHERE id = 1939;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Tierras del Sur" WHERE id = 1940;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cavernas del Tiempo" WHERE id = 1941;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Los Pantanales" WHERE id = 1942;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Meseta Roca de Hierro" WHERE id = 1943;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cueva Tizonegro" WHERE id = 1957;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Base de Peleteros" WHERE id = 1958;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Valle Polvofuego" WHERE id = 1959;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Zul'Gurub" WHERE id = 1977;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Puesto Juncobruma" WHERE id = 1978;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Puesto del Veneno" WHERE id = 1997;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Claro Ramaespolón" WHERE id = 1998;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Stratholme" WHERE id = 2017;
UPDATE `AreaTable_vanilla` SET name_loc6 = "UNUSEDShadowfang Keep 004" WHERE id = 2037;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Scholomance" WHERE id = 2057;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Vega Crepuscular" WHERE id = 2077;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Orilla Crepuscular" WHERE id = 2078;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Isla de Alcaz" WHERE id = 2079;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cumbre de la Nube Negra" WHERE id = 2097;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Catacumbas del Bosque Aurora" WHERE id = 2098;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Fuerte de Petravista" WHERE id = 2099;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Maraudon" WHERE id = 2100;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Pensión La Cebada" WHERE id = 2101;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Destilería Thunderbrew" WHERE id = 2102;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Castillo de Menethil" WHERE id = 2103;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mesón Aguahonda" WHERE id = 2104;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Sepulcro Sombrío" WHERE id = 2117;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Concejo de Rémol" WHERE id = 2118;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mesón La Horca" WHERE id = 2119;
UPDATE `AreaTable_vanilla` SET name_loc6 = "The Pools of VisionUNUSED" WHERE id = 2137;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cubil Calígine" WHERE id = 2138;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Fortaleza de Bael'dun" WHERE id = 2157;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cubil de Brasaliza" WHERE id = 2158;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Guarida de Onyxia" WHERE id = 2159;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mina Cortaviento" WHERE id = 2160;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Condena de Roland" WHERE id = 2161;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Liza" WHERE id = 2177;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Pozas de las Visiones" WHERE id = 2197;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Barranco Rompesombras" WHERE id = 2198;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Aldea Lanza Partida" WHERE id = 2217;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campamento del Tramo Blanco" WHERE id = 2237;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Gornia" WHERE id = 2238;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cráter del Ojo de Zane" WHERE id = 2239;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Circuito del Espejismo" WHERE id = 2240;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Roca Sable de Hielo" WHERE id = 2241;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Arboleda Oculta" WHERE id = 2242;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Puesto de los Fauces de Madera" WHERE id = 2243;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Poblado de los Invernales" WHERE id = 2244;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mazthoril" WHERE id = 2245;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Baños Escarchados" WHERE id = 2246;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Colinas Cardo Nevado" WHERE id = 2247;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Dun Mandarr" WHERE id = 2248;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cañón Levescarcha" WHERE id = 2249;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Matorral del Ala del Búho" WHERE id = 2250;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago Kel'Theril" WHERE id = 2251;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Las Ruinas de Kel'Theril" WHERE id = 2252;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Aldea Estrella Fugaz" WHERE id = 2253;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Túmulo de Ban'Thallow" WHERE id = 2254;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Vista Eterna" WHERE id = 2255;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Garganta Negro Rumor" WHERE id = 2256;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Tren subterráneo" WHERE id = 2257;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cuenca Fungal" WHERE id = 2258;
UPDATE `AreaTable_vanilla` SET name_loc6 = "UNUSEDThe Marris Stead" WHERE id = 2259;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Hacienda de Marris" WHERE id = 2260;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Subgranja" WHERE id = 2261;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Villa Darrow" WHERE id = 2262;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Torre de la Corona" WHERE id = 2263;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cruce de Corin" WHERE id = 2264;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Base Escarlata" WHERE id = 2265;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mano de Tyr" WHERE id = 2266;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Basílica Escarlata" WHERE id = 2267;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Capilla de la Esperanza de la Luz" WHERE id = 2268;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Molino Cejifrente" WHERE id = 2269;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Claro Ponzoñoso" WHERE id = 2270;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Torre de la Muralla del Este" WHERE id = 2271;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Vallenorte" WHERE id = 2272;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Zul'Mashar" WHERE id = 2273;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mazra'Alor" WHERE id = 2274;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Torre del Paso Norte" WHERE id = 2275;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Refugio Quel'Lithien" WHERE id = 2276;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bosque de la Peste" WHERE id = 2277;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Fuerte de la Némesis" WHERE id = 2278;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Stratholme" WHERE id = 2279;
UPDATE `AreaTable_vanilla` SET name_loc6 = "UNUSED Stratholme" WHERE id = 2280;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago Darrowmere" WHERE id = 2297;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Castel Darrow" WHERE id = 2298;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago Darrowmere" WHERE id = 2299;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cavernas del Tiempo" WHERE id = 2300;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Poblado Piel de Cardo" WHERE id = 2301;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Lodazal" WHERE id = 2302;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cañón Rompevientos" WHERE id = 2303;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mares del Sur" WHERE id = 2317;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mare Magnum" WHERE id = 2318;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mare Magnum" WHERE id = 2319;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mare Magnum" WHERE id = 2320;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mare Magnum" WHERE id = 2321;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mar de la Bruma" WHERE id = 2322;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mar de la Bruma" WHERE id = 2323;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mar de la Bruma" WHERE id = 2324;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mar de la Bruma" WHERE id = 2325;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mar de la Bruma" WHERE id = 2326;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cuartel de Cerrotajo" WHERE id = 2337;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mares del Sur" WHERE id = 2338;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mare Magnum" WHERE id = 2339;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Asentamiento Sangradientes" WHERE id = 2357;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Canción del Bosque" WHERE id = 2358;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Poblado Zarpaverde" WHERE id = 2359;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Avanzada Ala de Plata" WHERE id = 2360;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Amparo de la Noche" WHERE id = 2361;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Santuario de Remulos" WHERE id = 2362;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Túmulo de Tempestira" WHERE id = 2363;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mare Magnum" WHERE id = 2364;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mare Magnum" WHERE id = 2365;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ciénaga Negra" WHERE id = 2366;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Antiguas Laderas de Trabalomas" WHERE id = 2367;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Molino Tarren" WHERE id = 2368;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Costasur" WHERE id = 2369;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Castillo de Durnholde" WHERE id = 2370;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Dun Garok" WHERE id = 2371;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campos de Trabalomas" WHERE id = 2372;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Playa del Este" WHERE id = 2373;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Granja Nethander" WHERE id = 2374;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Colinas de Darrow" WHERE id = 2375;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Torre Austral" WHERE id = 2376;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Muralla de Thoradin" WHERE id = 2377;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Playa del Oeste" WHERE id = 2378;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mina Azur" WHERE id = 2379;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mare Magnum" WHERE id = 2397;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mare Magnum" WHERE id = 2398;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mare Magnum" WHERE id = 2399;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mar Adusto" WHERE id = 2400;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mar Adusto" WHERE id = 2401;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mar Adusto" WHERE id = 2402;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mar Adusto" WHERE id = 2403;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Tethris Aran" WHERE id = 2404;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ethel Rethor" WHERE id = 2405;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Isla Ranazjar" WHERE id = 2406;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cabaña de Kormek" WHERE id = 2407;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Aldea Cazasombras" WHERE id = 2408;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Desfiladero de Roca Negra" WHERE id = 2417;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Vigilia de Morgan" WHERE id = 2418;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Roca Desliz" WHERE id = 2419;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Senda del Ala del Terror" WHERE id = 2420;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Draco'dar" WHERE id = 2421;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Sima Ígnea" WHERE id = 2437;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bosque Arrullanoche" WHERE id = 2457;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mar de la Bruma" WHERE id = 2477;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Morlos'Aran" WHERE id = 2478;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Santuario Esmeralda" WHERE id = 2479;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cañada Fuego de Jade" WHERE id = 2480;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas de Constellas" WHERE id = 2481;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Costa Amarga" WHERE id = 2497;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Alto de los Rapiñadores" WHERE id = 2517;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Pabellón de Lariss" WHERE id = 2518;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Colinas Zarpaleña" WHERE id = 2519;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Guarida de los Zarpaleña" WHERE id = 2520;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Río Verdantis" WHERE id = 2521;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas de Isildien" WHERE id = 2522;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Poblado Tótem Siniestro" WHERE id = 2537;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campamento Aparaje" WHERE id = 2538;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Malaka'jin" WHERE id = 2539;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Barranco del Alud" WHERE id = 2540;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cañón Sishir" WHERE id = 2541;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Masacre" WHERE id = 2557;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Barranco de la Muerte" WHERE id = 2558;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Río Diamante" WHERE id = 2559;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campamento de Ariden" WHERE id = 2560;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Vicio" WHERE id = 2561;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Karazhan" WHERE id = 2562;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Terreno de Morgan" WHERE id = 2563;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Masacre" WHERE id = 2577;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Valle de Alterac" WHERE id = 2597;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campamento Mezclatornillos" WHERE id = 2617;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Camino Fuego de Jade" WHERE id = 2618;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Río Thondroril" WHERE id = 2619;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Río Thondroril" WHERE id = 2620;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago Mereldar" WHERE id = 2621;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cicatriz Pestilente" WHERE id = 2622;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Cicatriz Purulenta" WHERE id = 2623;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Lago del Bosque Negro" WHERE id = 2624;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Puerta de la Muralla del Este" WHERE id = 2625;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Túnel Terroarácnido" WHERE id = 2626;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Valle del Terror" WHERE id = 2627;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Fuerte de Kargathia" WHERE id = 2637;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Valle de los Huesos" WHERE id = 2657;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Guarida Alanegra" WHERE id = 2677;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cruce de la Muerte" WHERE id = 2697;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Núcleo de Magma" WHERE id = 2717;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Muro del Escarabajo" WHERE id = 2737;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Aldea del Viento del Sur" WHERE id = 2738;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campamento Crepúsculo" WHERE id = 2739;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Vega de Cristal" WHERE id = 2740;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Estrado del Escarabajo" WHERE id = 2741;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Colmen'Ashi" WHERE id = 2742;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Colmen'Zora" WHERE id = 2743;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Colmen'Regal" WHERE id = 2744;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Santuario del Guerrero Caído" WHERE id = 2757;
UPDATE `AreaTable_vanilla` SET name_loc6 = "UNUSED Alterac Valley" WHERE id = 2777;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cavernas de Brazanegra" WHERE id = 2797;
UPDATE `AreaTable_vanilla` SET name_loc6 = "***On Map Dungeon***" WHERE id = 2817;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Sótano del Maestro" WHERE id = 2837;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Paso de Fraguapiedra" WHERE id = 2838;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Valle de Alterac" WHERE id = 2839;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Jaula del Rugido" WHERE id = 2857;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Chunk Test" WHERE id = 2877;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Avanzada de Zoram'gar" WHERE id = 2897;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Sala de las Leyendas" WHERE id = 2917;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Sala de los Campeones" WHERE id = 2918;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Dominios Grosh'gok" WHERE id = 2937;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Desfiladero del Letargo" WHERE id = 2938;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mina Ferrohondo" WHERE id = 2957;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Avanzada Piedrahogar" WHERE id = 2958;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Dun Baldar" WHERE id = 2959;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Paso de Ala Gélida" WHERE id = 2960;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Aldea Lobo Gélido" WHERE id = 2961;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Punta de la Torre" WHERE id = 2962;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mina Dentefrío" WHERE id = 2963;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bastión Hacha Invernal?" WHERE id = 2964;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Baluarte Sangre Fría" WHERE id = 2977;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bastión Lobo Gélido" WHERE id = 2978;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Granja Tor'kren" WHERE id = 2979;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Paso de la Daga Escarcha" WHERE id = 3017;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campamento Roca de Hierro" WHERE id = 3037;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cráter de la Comadreja" WHERE id = 3038;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas de Tahonda" WHERE id = 3039;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Tierra de Disputa" WHERE id = 3057;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cueva Ala Gélida" WHERE id = 3058;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Sosiego del Valor" WHERE id = 3077;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Pilar de la Ascensión" WHERE id = 3097;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Puesto Crepúsculo" WHERE id = 3098;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Avanzada Crepúsculo" WHERE id = 3099;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campamento Crepúsculo devastado" WHERE id = 3100;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Guarida de Shalzaru" WHERE id = 3117;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Punta Talrendis" WHERE id = 3137;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Sagrario de Rethres" WHERE id = 3138;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cubil Pavor Lunar" WHERE id = 3139;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cueva Barbaescamas" WHERE id = 3140;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cueva del Alud" WHERE id = 3157;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campo de trabajos forzados Grito de Guerra" WHERE id = 3177;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campamento del Orvallo" WHERE id = 3197;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Masacre" WHERE id = 3217;
UPDATE `AreaTable_vanilla` SET name_loc6 = "The Maul UNUSED" WHERE id = 3237;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Huesos de Grakkarond" WHERE id = 3257;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Garganta Grito de Guerra" WHERE id = 3277;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cementerio Lobo Gélido" WHERE id = 3297;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Paso Lobo Gélido" WHERE id = 3298;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Paso de Dun Baldar" WHERE id = 3299;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cementerio Sangre Fría" WHERE id = 3300;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cementerio Avalancha" WHERE id = 3301;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cementerio Piedrahogar" WHERE id = 3302;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cementerio Pico Tormenta" WHERE id = 3303;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Búnker de Ala Gélida" WHERE id = 3304;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Búnker Piedrahogar" WHERE id = 3305;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Risco Zarpa Salvaje" WHERE id = 3306;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Poblado Sañadiente" WHERE id = 3317;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Roca de Durotan" WHERE id = 3318;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Claro Ala de Plata" WHERE id = 3319;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Serrería Grito de Guerra" WHERE id = 3320;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bastión Ala de Plata" WHERE id = 3321;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Caverna Zarpa Salvaje" WHERE id = 3337;
UPDATE `AreaTable_vanilla` SET name_loc6 = "La Grieta Velada" WHERE id = 3338;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Isla Yojamba" WHERE id = 3357;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Cuenca de Arathi" WHERE id = 3358;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Serpenteo" WHERE id = 3377;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Altar de Hir'eek" WHERE id = 3378;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Shadra'zaar" WHERE id = 3379;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Dominios Hakkari" WHERE id = 3380;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Saliente de Shirvallah" WHERE id = 3381;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Templo de Bethekk" WHERE id = 3382;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Foso de las Llamas de Sangre" WHERE id = 3383;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Altar del Dios de la Sangre" WHERE id = 3384;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Alto de Zanza" WHERE id = 3397;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Extremo de la Locura" WHERE id = 3398;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bastión de Trollbane" WHERE id = 3417;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Guarida de los Rapiñadores" WHERE id = 3418;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Punta de Pagle" WHERE id = 3419;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Granja" WHERE id = 3420;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Herrería" WHERE id = 3421;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Serrería" WHERE id = 3422;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mina de oro" WHERE id = 3423;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Establo" WHERE id = 3424;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Fuerte Cenarion" WHERE id = 3425;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Punta de Corzocelada" WHERE id = 3426;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Campamento Barbabronce" WHERE id = 3427;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ahn'Qiraj" WHERE id = 3428;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas de Ahn'Qiraj" WHERE id = 3429;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Paseo Crepúsculo" WHERE id = 3446;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Guarida de Ortell" WHERE id = 3447;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bancal del Escarabajo" WHERE id = 3448;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bancal del General" WHERE id = 3449;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Embalse" WHERE id = 3450;
UPDATE `AreaTable_vanilla` SET name_loc6 = "El Criadero" WHERE id = 3451;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Panal" WHERE id = 3452;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Bancal de los Oteadores" WHERE id = 3453;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ruinas de Ahn'Qiraj" WHERE id = 3454;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Naxxramas" WHERE id = 3456;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Ciudad" WHERE id = 3459;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Puertas de Ahn'Qiraj" WHERE id = 3478;
UPDATE `AreaTable_vanilla` SET name_loc6 = "Mansión Ravenholdt" WHERE id = 3486;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Дун Морог" WHERE id = 1;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Бескрайний берег" WHERE id = 2;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Бесплодные земли" WHERE id = 3;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Выжженные земли" WHERE id = 4;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Бухта Черноводья" WHERE id = 7;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Болото Печали" WHERE id = 8;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Долина Североземья" WHERE id = 9;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сумеречный лес" WHERE id = 10;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Болотина" WHERE id = 11;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Элвиннский лес" WHERE id = 12;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Древо Жизни" WHERE id = 13;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Дуротар" WHERE id = 14;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пылевые топи" WHERE id = 15;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Азшара" WHERE id = 16;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Степи" WHERE id = 17;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Озеро Хрустальное" WHERE id = 18;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Зул'Гуруб" WHERE id = 19;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Луноречье" WHERE id = 20;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Кул-Тирас" WHERE id = 21;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Остров Программиста" WHERE id = 22;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Река Североземья" WHERE id = 23;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Аббатство Североземья" WHERE id = 24;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Черная гора" WHERE id = 25;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Маяк" WHERE id = 26;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Западные Чумные земли" WHERE id = 28;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Девять" WHERE id = 30;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Кладбище" WHERE id = 32;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Тернистая долина" WHERE id = 33;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Рудник Горного Эха" WHERE id = 34;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пиратская Бухта" WHERE id = 35;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Альтеракские горы" WHERE id = 36;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Озеро Назферити" WHERE id = 37;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лок Модан" WHERE id = 38;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Западный Край" WHERE id = 40;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Перевал Мертвого Ветра" WHERE id = 41;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Темнолесье" WHERE id = 42;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пустынный берег" WHERE id = 43;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Красногорье" WHERE id = 44;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Нагорье Арати" WHERE id = 45;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пылающие степи" WHERE id = 46;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Внутренние земли" WHERE id = 47;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Нора Мертвеца" WHERE id = 49;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Тлеющее ущелье" WHERE id = 51;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Воровской лагерь" WHERE id = 53;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Яшмовая шахта" WHERE id = 54;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Аллея Героев НЕ ИСПОЛЬЗУЕТСЯ" WHERE id = 55;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Часовые Вечности" WHERE id = 56;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Рудник Подземных Глубин" WHERE id = 57;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Виноградники Североземья" WHERE id = 59;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лесная опушка" WHERE id = 60;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ревущий водопад" WHERE id = 61;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Тыквенное поле Бреквеллов" WHERE id = 62;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ферма Стоунфилдов" WHERE id = 63;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Виноградники Маклура" WHERE id = 64;
UPDATE `AreaTable_vanilla` SET name_loc8 = "***Используй меня повторно 3***" WHERE id = 65;
UPDATE `AreaTable_vanilla` SET name_loc8 = "***Используй меня повторно 6***" WHERE id = 66;
UPDATE `AreaTable_vanilla` SET name_loc8 = "***Используй меня повторно 5***" WHERE id = 67;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Озеро Безмолвия" WHERE id = 68;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Приозерье" WHERE id = 69;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Крепость Каменной Стражи" WHERE id = 70;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Водопад Каменной Стражи" WHERE id = 71;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Темный портал" WHERE id = 72;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Гниющий шрам" WHERE id = 73;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Озеро Слез" WHERE id = 74;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Каменор" WHERE id = 75;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Болотное пристанище" WHERE id = 76;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Старая Наковальня" WHERE id = 77;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Горы Штормграда" WHERE id = 80;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Джефф СВ Измененный квадрант" WHERE id = 81;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Джефф СЗ Квадрант" WHERE id = 82;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Джефф ЮВ Квадрант" WHERE id = 83;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Джефф ЮЗ Квадрант" WHERE id = 84;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Тирисфальские леса" WHERE id = 85;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Озеро Каменных Столбов" WHERE id = 86;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Златоземье" WHERE id = 87;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лесопилка Восточной долины" WHERE id = 88;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сад у Зеркального озера" WHERE id = 89;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Башня Азоры" WHERE id = 91;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Зеркальное озеро" WHERE id = 92;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лощина Вул'Гол" WHERE id = 93;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Вороний Холм" WHERE id = 94;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Каньоны Красногорья" WHERE id = 95;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Башня Илгалара" WHERE id = 96;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лесопилка Альтера" WHERE id = 97;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пещеры Ретбана" WHERE id = 98;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Повстанцев" WHERE id = 99;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Экспедиция Эрнестуэя" WHERE id = 100;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Курцена" WHERE id = 101;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Зул'Кунды" WHERE id = 102;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Зул'Мамве" WHERE id = 103;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Коварный риф" WHERE id = 104;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Холм Мош'Огг" WHERE id = 105;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Схрон" WHERE id = 106;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ферма Сальдена" WHERE id = 107;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сторожевой холм" WHERE id = 108;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Тыквенная ферма Хмуроброва" WHERE id = 109;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Рудник Янго" WHERE id = 111;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Прииск на Золотом Берегу" WHERE id = 113;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Маяк в Западном Крае" WHERE id = 115;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Туманная долина" WHERE id = 116;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Гром'гол" WHERE id = 117;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Раскопки Вельгара" WHERE id = 118;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Гарнизон у Западного ручья" WHERE id = 120;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Безмятежное кладбище" WHERE id = 121;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Зуулдая" WHERE id = 122;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Бал'лал" WHERE id = 123;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Кал'аи" WHERE id = 125;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Ткаши" WHERE id = 126;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Балиа'ма" WHERE id = 127;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Зиата'джаи" WHERE id = 128;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Мизжа" WHERE id = 129;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Серебряный бор" WHERE id = 130;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Каранос" WHERE id = 131;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Холодная долина" WHERE id = 132;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Гномреган" WHERE id = 133;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Карьер Гол'Болар" WHERE id = 134;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Форт Мерзлогривов" WHERE id = 135;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Серая берлога" WHERE id = 136;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Поселок Пивоваров" WHERE id = 137;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сторожка у заснеженной сосны" WHERE id = 138;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Восточные Чумные земли" WHERE id = 139;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Тельдрассил" WHERE id = 141;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Раскопки Сталекрута" WHERE id = 142;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Оплот Мо'грош" WHERE id = 143;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Телcамар" WHERE id = 144;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Врата Альгаза" WHERE id = 145;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Каменная Плотина" WHERE id = 146;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Приют Странников" WHERE id = 147;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Темные берега" WHERE id = 148;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Рудник у Серебряного ручейка" WHERE id = 149;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Гавань Менетилов" WHERE id = 150;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Остров Дизайнера" WHERE id = 151;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Бастион" WHERE id = 152;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Лордерона" WHERE id = 153;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Могильник" WHERE id = 154;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Паучья низина" WHERE id = 155;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Усадьба Соллиден" WHERE id = 156;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Мельницы Агамондов" WHERE id = 157;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Семейная усыпальница Агамондов" WHERE id = 158;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Брилл" WHERE id = 159;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Шепчущие сады" WHERE id = 160;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Терраса Покоя" WHERE id = 161;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Озеро Ясноводное" WHERE id = 162;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Приют Гюнтера" WHERE id = 163;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ферма Гаррена" WHERE id = 164;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Усадьба Балнира" WHERE id = 165;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Поместье \"Остывший Очаг\"" WHERE id = 166;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Застава Алого Ордена" WHERE id = 167;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Северное побережье" WHERE id = 168;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Шепчущий берег" WHERE id = 169;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Озеро Лордамер" WHERE id = 170;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Остров Фенриса" WHERE id = 172;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Могила Фаола" WHERE id = 173;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Доланаар" WHERE id = 186;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Дарнас НЕ ИСПОЛЬЗУЕТСЯ" WHERE id = 187;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Тенистая долина" WHERE id = 188;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Поселок Сталежара" WHERE id = 189;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Дольный Очаг" WHERE id = 190;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лесопилка Северного Кряжа" WHERE id = 192;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Андорала" WHERE id = 193;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Школа некромантии" WHERE id = 195;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Гробница Утера" WHERE id = 196;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Холм Печали" WHERE id = 197;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Грот Слез" WHERE id = 198;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Поле Джанис" WHERE id = 199;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Слезы Далсона" WHERE id = 200;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пустошь Гаррона" WHERE id = 201;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Удел Страданий" WHERE id = 202;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Крепость Марденхольд" WHERE id = 203;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Деревня Погребальных Костров" WHERE id = 204;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Дун Модр" WHERE id = 205;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Западный Край" WHERE id = 206;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Великое море" WHERE id = 207;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Не используется Потайная бухта" WHERE id = 208;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Крепость Темного Клыка" WHERE id = 209;
UPDATE `AreaTable_vanilla` SET name_loc8 = "***Используй меня повторно 2***" WHERE id = 210;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Заледеневшее озеро" WHERE id = 211;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Озеро Хельмово Ложе" WHERE id = 212;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Серебряный рудник" WHERE id = 213;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Великое море" WHERE id = 214;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Мулгор" WHERE id = 215;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Поместье Алекстона" WHERE id = 219;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Плато Красного Облака" WHERE id = 220;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Нараче" WHERE id = 221;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Деревня Кровавого Копыта" WHERE id = 222;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Озеро Каменного Быка" WHERE id = 223;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Разграбленный караван" WHERE id = 224;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Красные скалы" WHERE id = 225;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Струящаяся Тьма" WHERE id = 226;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Поле Валгана" WHERE id = 227;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Гробница" WHERE id = 228;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Удел Ольсена" WHERE id = 229;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Стена Седогрива" WHERE id = 230;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Погибель Берена" WHERE id = 231;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Рассветные острова" WHERE id = 232;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Янтарная мельница" WHERE id = 233;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Крепость Фенриса" WHERE id = 235;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Крепость Темного Клыка" WHERE id = 236;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Старая переправа" WHERE id = 237;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сад Мальдена" WHERE id = 238;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Делянка Ивара" WHERE id = 239;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Мертвое поле" WHERE id = 240;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Гниющий сад" WHERE id = 241;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Светлая роща" WHERE id = 242;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Покинутая усадьба" WHERE id = 243;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Имение Уиппл" WHERE id = 244;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Усадьба Йоргена" WHERE id = 245;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Котлован" WHERE id = 246;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Карьер Грязнули" WHERE id = 247;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Скала Молота Ужаса" WHERE id = 249;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Тауриссана" WHERE id = 250;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пламенеющий Стяг" WHERE id = 251;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Крепость Черной горы" WHERE id = 252;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Башня Пепла" WHERE id = 253;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Черная гора" WHERE id = 254;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Алтарь Бурь" WHERE id = 255;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Альдрассил" WHERE id = 256;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Паучье логово" WHERE id = 257;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пещера Бесов" WHERE id = 258;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Озеро Аль'Амет" WHERE id = 259;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Деревня Звездного Ветра" WHERE id = 260;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь у Кривой Сосны" WHERE id = 261;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Обитель Бен'этиль" WHERE id = 262;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Расселина" WHERE id = 263;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Поляна Оракула" WHERE id = 264;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Родниковая река" WHERE id = 265;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Родниковое озеро" WHERE id = 266;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Предгорья Хилсбрада" WHERE id = 267;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Кратер Азшары" WHERE id = 268;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Дун Альгаз" WHERE id = 269;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Южнобережье" WHERE id = 271;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Мельница Таррен" WHERE id = 272;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Крепость Дарнхольд" WHERE id = 275;
UPDATE `AreaTable_vanilla` SET name_loc8 = "НЕ ИСПОЛЬЗУЕТСЯ Подгорная тропа" WHERE id = 276;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пещеры предгорий" WHERE id = 277;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лордамерские выселки" WHERE id = 278;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Даларан" WHERE id = 279;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Странбрад" WHERE id = 280;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Альтерака" WHERE id = 281;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Логово Раздробленного Хребта" WHERE id = 282;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Кровавая низина" WHERE id = 283;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Высокогорье" WHERE id = 284;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Южная башня" WHERE id = 285;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Хилсбрадские поля" WHERE id = 286;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Хилсбрад" WHERE id = 287;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лазуритовый рудник" WHERE id = 288;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Владение Нетандера" WHERE id = 289;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Дун Гарок" WHERE id = 290;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Стена Торадина" WHERE id = 293;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Восточное побережье" WHERE id = 294;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Западное побережье" WHERE id = 295;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Южные моря НЕ ИСПОЛЬЗУЕТСЯ" WHERE id = 296;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Остров Жагуаро" WHERE id = 297;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Бухта Барадин" WHERE id = 298;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Бухта Менетилов" WHERE id = 299;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Тростниковый берег" WHERE id = 300;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Гибельный берег" WHERE id = 301;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Хрустальное взморье" WHERE id = 302;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ракушечный пляж" WHERE id = 303;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Берег Северного прилива" WHERE id = 305;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Берег Южного прилива" WHERE id = 306;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Отвесные скалы" WHERE id = 307;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Зловещее море" WHERE id = 308;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Гробница Железноборода" WHERE id = 309;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Хрустальная шахта" WHERE id = 310;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Абораза" WHERE id = 311;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Остров Жанейро" WHERE id = 312;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Северное поместье" WHERE id = 313;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ферма Го'Шека" WHERE id = 314;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Усадьба Дабири" WHERE id = 315;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Крепость Тяжелого Кулака" WHERE id = 316;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Деревня Сухокожих" WHERE id = 317;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Теснина Сухоусов" WHERE id = 318;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Опорный пункт" WHERE id = 320;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Павший Молот" WHERE id = 321;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Обломки судов Черноводья" WHERE id = 322;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь О'Брина" WHERE id = 323;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Крепость Стромгард" WHERE id = 324;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Башня Аратора" WHERE id = 325;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Святилище" WHERE id = 326;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Бухта Фальдира" WHERE id = 327;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Подводный риф" WHERE id = 328;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Мост Тандола" WHERE id = 330;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ясеневый лес" WHERE id = 331;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Великое море" WHERE id = 332;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Восточный круг Обуздания" WHERE id = 333;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Западный Круг Обуздания" WHERE id = 334;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Внутренний Круг Обуздания" WHERE id = 335;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Внешний Круг Обуздания" WHERE id = 336;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Скелет Апокрифана" WHERE id = 337;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Крепость Ангор" WHERE id = 338;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Долина Летлор" WHERE id = 339;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Каргат" WHERE id = 340;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Кош" WHERE id = 341;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Бофф" WHERE id = 342;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Вург" WHERE id = 343;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Кэгг" WHERE id = 344;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Удел Эгмонда" WHERE id = 345;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Карьер Тяжелоступа" WHERE id = 346;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Грот Гнилобрюхих" WHERE id = 347;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Заоблачный пик" WHERE id = 348;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Крепость Громового Молота" WHERE id = 349;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сторожка Кель'Данил" WHERE id = 350;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Осклизлая скала" WHERE id = 351;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Зун'вата" WHERE id = 352;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Шадра'Алор" WHERE id = 353;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Джинта'Алор" WHERE id = 354;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Алтарь Зула" WHERE id = 355;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Серадан" WHERE id = 356;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Фералас" WHERE id = 357;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ежевичная лощина" WHERE id = 358;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Бейл Модан" WHERE id = 359;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Рудник Торговой Компании" WHERE id = 360;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Оскверненный лес" WHERE id = 361;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Колючий Холм" WHERE id = 362;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Долина Испытаний" WHERE id = 363;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Логово" WHERE id = 364;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Грот Пылающего Клинка" WHERE id = 365;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Утес Колкар" WHERE id = 366;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Деревня Сен'джин" WHERE id = 367;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Острова Эха" WHERE id = 368;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Громовой хребет" WHERE id = 369;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сухая лощина" WHERE id = 370;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пещера Пыльного Ветра" WHERE id = 371;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Крепость Тирагард" WHERE id = 372;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Берег Разбитых Кораблей" WHERE id = 373;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Бухта Острорука" WHERE id = 374;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Взморье Мертвого Глаза" WHERE id = 375;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Река Строптивая" WHERE id = 377;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Таурахо" WHERE id = 378;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Дальняя застава" WHERE id = 379;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Перекресток" WHERE id = 380;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Каменный карьер" WHERE id = 381;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Нефтяное болото" WHERE id = 382;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сухие холмы" WHERE id = 383;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Вершина Багрового Тумана" WHERE id = 384;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Крепость Северной Стражи" WHERE id = 385;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Забытые пруды" WHERE id = 386;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Цветущий оазис" WHERE id = 387;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Застывший оазис" WHERE id = 388;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Поля Великанов" WHERE id = 390;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Торговое побережье" WHERE id = 391;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Кабестан" WHERE id = 392;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Побережье Черного Копья" WHERE id = 393;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Озеро Дарроумир НЕ ИСПОЛЬЗУЕТСЯ" WHERE id = 394;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Каэр Дэрроу НЕ ИСПОЛЬЗУЕТСЯ" WHERE id = 395;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Колодец Заиндевевшего Копыта" WHERE id = 396;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Колодец Громового Рога" WHERE id = 397;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Колодец Буйногривых" WHERE id = 398;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Гряда на горизонте" WHERE id = 399;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Тысяча Игл" WHERE id = 400;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лестница Прилива" WHERE id = 401;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Таверна \"Последний привал\"" WHERE id = 403;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Раскопки Бейл'дана" WHERE id = 404;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пустоши" WHERE id = 405;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Когтистые горы" WHERE id = 406;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Оргриммар НЕ ИСПОЛЬЗУЕТСЯ" WHERE id = 407;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Остров Гиллиджима" WHERE id = 408;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Остров доктора Лапидиса" WHERE id = 409;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Каньон Колючего Ветра" WHERE id = 410;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Убежище Батрана" WHERE id = 411;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Ордил'Арана" WHERE id = 412;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Застава Мейстры" WHERE id = 413;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Зорамское взморье" WHERE id = 414;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Астранаар" WHERE id = 415;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Святилище Эссины" WHERE id = 416;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Святилище Огненной Расщелины" WHERE id = 417;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Звездной Пыли" WHERE id = 418;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Воющая долина" WHERE id = 419;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Приют Серебряного Ветра" WHERE id = 420;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Озеро Мистраль" WHERE id = 421;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Зеркало Небес" WHERE id = 422;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Озеро Ирис" WHERE id = 424;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лунный колодец" WHERE id = 425;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Приют в Ночных Лесах" WHERE id = 426;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Тенистый закоулок" WHERE id = 427;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ночная поляна" WHERE id = 428;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ксавиан" WHERE id = 429;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сатирнаар" WHERE id = 430;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Застава Расщепленного Дерева" WHERE id = 431;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Обитель Дор'Данил" WHERE id = 432;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Река Фалфаррен" WHERE id = 433;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Холм Демонического Огня" WHERE id = 434;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Каньон Гибели Демона" WHERE id = 435;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Гряда Гибели Демона" WHERE id = 436;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лесозаготовки Песни Войны" WHERE id = 437;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Тенистая Крона" WHERE id = 438;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Мерцающая равнина" WHERE id = 439;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Танарис" WHERE id = 440;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Озеро Фалатим" WHERE id = 441;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Аубердин" WHERE id = 442;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Матистры" WHERE id = 443;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Башня Алталакса" WHERE id = 444;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Водопад Скалистый" WHERE id = 445;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Башал'Аран" WHERE id = 446;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Амет'Аран" WHERE id = 447;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Роща Древних" WHERE id = 448;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Меч Властителя" WHERE id = 449;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Раскопки рассеянного геолога" WHERE id = 450;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Туманный Предел" WHERE id = 452;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Длинный пролив" WHERE id = 453;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Петляющая река" WHERE id = 454;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Берлога в Чернолесье" WHERE id = 455;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Река Скалистая" WHERE id = 456;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сокрытое море" WHERE id = 457;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Золотой Путь" WHERE id = 458;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сторожевой пост Алого ордена" WHERE id = 459;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Приют у Солнечного Камня" WHERE id = 460;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Утес Ветрорезов" WHERE id = 461;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Скалистое озеро" WHERE id = 463;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Мутное озеро" WHERE id = 464;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Обугленная долина" WHERE id = 465;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Долина Кровавой Ярости" WHERE id = 466;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пик Каменного Когтя" WHERE id = 467;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Логово Когтя" WHERE id = 468;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Долина Высокого леса" WHERE id = 469;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Громовой Утес НЕ ИСПОЛЬЗУЕТСЯ" WHERE id = 470;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Плато Дерзкого Ветра" WHERE id = 471;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Плато Огненного Камня" WHERE id = 472;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Скала Мантия" WHERE id = 473;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Вершина Охотников НЕ ИСПОЛЬЗУЕТСЯ" WHERE id = 474;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Уступ Духов НЕ ИСПОЛЬЗУЕТСЯ" WHERE id = 475;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Вершина Старейшин НЕ ИСПОЛЬЗУЕТСЯ" WHERE id = 476;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Жубуваля" WHERE id = 477;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пруды Арлитриэна" WHERE id = 478;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Карьер Ржавой Кувалды" WHERE id = 479;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Э'Ток" WHERE id = 480;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Утес Треснувшего Копыта" WHERE id = 481;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Скальное гнездовье" WHERE id = 482;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Каньон Визга" WHERE id = 483;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Застава Вольного Ветра" WHERE id = 484;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Великий Подъемник" WHERE id = 485;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Форт Галак" WHERE id = 486;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Логово Легкоперых" WHERE id = 487;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Угол Семи Ветров" WHERE id = 488;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Таланаар" WHERE id = 489;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Кратер Ун'Горо" WHERE id = 490;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лабиринты Иглошкурых" WHERE id = 491;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Кладбище Вороньего Холма" WHERE id = 492;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лунная поляна" WHERE id = 493;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Удалите МЕНЯ" WHERE id = 495;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Деревня Гиблотопь" WHERE id = 496;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сторожка \"Болотный огонек\"" WHERE id = 497;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Логово Кровавой Топи" WHERE id = 498;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Мглистая пещера" WHERE id = 499;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Вершина Моггл" WHERE id = 500;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Место крушения Бизиля" WHERE id = 501;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ведьмин холм" WHERE id = 502;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сторожевой пост" WHERE id = 503;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Северная башня" WHERE id = 504;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Западная башня" WHERE id = 505;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Разрушенная башня" WHERE id = 506;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Синяя топь" WHERE id = 507;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Деревни Каменного Молота" WHERE id = 508;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Огненное логово" WHERE id = 509;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Земля Драконов" WHERE id = 510;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Драконьи топи" WHERE id = 511;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Логово Ониксии НЕ ИСПОЛЬЗУЕТСЯ" WHERE id = 512;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Остров Терамор" WHERE id = 513;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Цитадель" WHERE id = 514;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Потайная бухта" WHERE id = 515;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пылевая бухта" WHERE id = 516;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Залив Яростных Волн" WHERE id = 517;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Зловещий берег" WHERE id = 518;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Участок Эддла" WHERE id = 536;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Вулкан Огненного Венца" WHERE id = 537;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Смоляные ямы Лаккари" WHERE id = 538;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Путь Ужаса" WHERE id = 539;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Скользкий овраг" WHERE id = 540;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Укрытие Маршалла" WHERE id = 541;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пещера Лишайников" WHERE id = 542;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Горячие источники Голакка" WHERE id = 543;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Озеро Лок" WHERE id = 556;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Приют Бродяги" WHERE id = 576;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Кладбище кодо" WHERE id = 596;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Застава Скитающихся Духов" WHERE id = 597;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Побережье Сар'Терис" WHERE id = 598;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Крепость Громового Топора" WHERE id = 599;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пещера Болгана" WHERE id = 600;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Поле Маннорок" WHERE id = 602;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Саргерон" WHERE id = 603;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Деревня Маграм" WHERE id = 604;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Деревня Гелкис" WHERE id = 606;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Долина Копий" WHERE id = 607;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Высота Найджела" WHERE id = 608;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Деревня Колкар" WHERE id = 609;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Хиджал" WHERE id = 616;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Зимние Ключи" WHERE id = 618;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Волчья река" WHERE id = 636;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Дольмен Кодо" WHERE id = 637;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Потайная тропа" WHERE id = 638;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Священный Камень" WHERE id = 639;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Святилище Дремлющего Пламени" WHERE id = 640;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Озеро Элуне'ара" WHERE id = 656;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Убежище" WHERE id = 657;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Запределье" WHERE id = 676;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Терраса ремесленников НЕ ИСПОЛЬЗУЕТСЯ" WHERE id = 696;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Терраса торговцев НЕ ИСПОЛЬЗУЕТСЯ" WHERE id = 697;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Храмовые сады НЕ ИСПОЛЬЗУЕТСЯ" WHERE id = 698;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Храм Элуны НЕ ИСПОЛЬЗУЕТСЯ" WHERE id = 699;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Анклав Кенария НЕ ИСПОЛЬЗУЕТСЯ" WHERE id = 700;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Терраса Воинов НЕ ИСПОЛЬЗУЕТСЯ" WHERE id = 701;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Деревня Рут'теран" WHERE id = 702;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Мастерская Сталекрута" WHERE id = 716;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Тюрьма" WHERE id = 717;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пещеры Стенаний" WHERE id = 718;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Непроглядная Пучина" WHERE id = 719;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Остров Битв" WHERE id = 720;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Гномреган" WHERE id = 721;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Курганы Иглошкурых" WHERE id = 722;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лощина Бен'этиль" WHERE id = 736;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Монастырь Алого ордена" WHERE id = 796;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Джерода" WHERE id = 797;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Дозорная башня" WHERE id = 798;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Темный берег" WHERE id = 799;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Туннель Холодной долины" WHERE id = 800;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Долина Промозглого Ветра" WHERE id = 801;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Мерцающий хребет" WHERE id = 802;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ферма Янтарленов" WHERE id = 803;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Холмы Тандрид" WHERE id = 804;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Южные врата" WHERE id = 805;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Застава у Южных врат" WHERE id = 806;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Северные врата" WHERE id = 807;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Застава у Северных врат" WHERE id = 808;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Врата Стальгорна" WHERE id = 809;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Тихий Омут" WHERE id = 810;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Долина Кошмаров" WHERE id = 811;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Долина ядовитых пауков" WHERE id = 812;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Бастион" WHERE id = 813;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Река Строптивая" WHERE id = 814;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Река Строптивая" WHERE id = 815;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Земли Иглогривых" WHERE id = 816;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Скала Черепа" WHERE id = 817;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Утес Бледногривов" WHERE id = 818;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Гряда Неистовства Ветра" WHERE id = 819;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Золотые равнины" WHERE id = 820;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Холмистые равнины" WHERE id = 821;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Дун Альгаз" WHERE id = 836;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Дун Альгаз" WHERE id = 837;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Северные врата" WHERE id = 838;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Южные врата" WHERE id = 839;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Мглистая роща" WHERE id = 856;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Остров ГМ" WHERE id = 876;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Удалите МЕНЯ" WHERE id = 877;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Река Строптивая" WHERE id = 878;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Река Строптивая" WHERE id = 879;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Мост Тандола" WHERE id = 880;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Мост Тандола" WHERE id = 881;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Остров Очищения" WHERE id = 896;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Владение Янсена" WHERE id = 916;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Мертвая пашня" WHERE id = 917;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ферма Мольсена" WHERE id = 918;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пруд Стенделя" WHERE id = 919;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Холмы Разбойничьих Кинжалов" WHERE id = 920;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Участок Демонта" WHERE id = 921;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пыльные равнины" WHERE id = 922;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Долина Камнедробов" WHERE id = 923;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Долина Королей" WHERE id = 924;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Станция Альгаз" WHERE id = 925;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ферма Баклбри" WHERE id = 926;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сияющий берег" WHERE id = 927;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Северная приливная низина" WHERE id = 928;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Хребет Седых Лап" WHERE id = 936;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Зеленеющие поля" WHERE id = 956;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Прибамбасск" WHERE id = 976;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Порт Картеля" WHERE id = 977;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Зул'Фаррак" WHERE id = 978;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Застава Скорбных Песков" WHERE id = 979;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Долина Кактусов" WHERE id = 980;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Зияющая бездна" WHERE id = 981;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ядовитый улей" WHERE id = 982;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Поселение Песчаного Молота" WHERE id = 983;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Восточной Луны" WHERE id = 984;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Родниковое поле" WHERE id = 985;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Логово Залашьи" WHERE id = 986;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пляж на Краю Света" WHERE id = 987;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Берег Морского Бродяги" WHERE id = 988;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ульдум" WHERE id = 989;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Долина Стражей" WHERE id = 990;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Застава Ганстена" WHERE id = 991;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Южной Луны" WHERE id = 992;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Ренда" WHERE id = 996;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Долина Ренда" WHERE id = 997;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Скала Ренда" WHERE id = 998;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Башня Каменной Стражи" WHERE id = 999;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Долина Галарделл" WHERE id = 1000;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Озерный тракт" WHERE id = 1001;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Три Угла" WHERE id = 1002;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Зловещий холм" WHERE id = 1016;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Гряда Ящеров" WHERE id = 1017;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Черная трясина" WHERE id = 1018;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Зеленый Пояс" WHERE id = 1019;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Болото Мохошкуров" WHERE id = 1020;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пещера Тельгена" WHERE id = 1021;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Болота Синежабрых" WHERE id = 1022;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Долина Солевого Тумана" WHERE id = 1023;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Закатное болото" WHERE id = 1024;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Зеленый Пояс" WHERE id = 1025;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Злого Клыка" WHERE id = 1036;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Грим Батол" WHERE id = 1037;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Врата Драконьей Пасти" WHERE id = 1038;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Погибший Флот" WHERE id = 1039;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Холм Дарроу" WHERE id = 1056;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Стена Торадина" WHERE id = 1057;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Паучий тракт" WHERE id = 1076;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Затихший берег" WHERE id = 1097;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Поместье Мистмантла" WHERE id = 1098;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Мохаче" WHERE id = 1099;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Зловещего Тотема" WHERE id = 1100;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Гудящая Бездна" WHERE id = 1101;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Штормовое озеро" WHERE id = 1102;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Поселение Гордунни" WHERE id = 1103;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Мок'Гордун" WHERE id = 1104;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Долина Свирепого Утеса" WHERE id = 1105;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Высокогорье Блеклых Перьев" WHERE id = 1106;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Озеро Тихого Ветра" WHERE id = 1107;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Забытый берег" WHERE id = 1108;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Восточная колонна" WHERE id = 1109;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Западная колонна" WHERE id = 1110;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сонные Ветви" WHERE id = 1111;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Нефритовое озеро" WHERE id = 1112;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Онейрос" WHERE id = 1113;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Яростного Ветра" WHERE id = 1114;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пещера Бешеного оврага" WHERE id = 1115;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Крепость Оперенной Луны" WHERE id = 1116;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Соларсаля" WHERE id = 1117;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Низинные чащобы НЕ ИСПОЛЬЗУЕТСЯ" WHERE id = 1118;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Два Колосса" WHERE id = 1119;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Остров Сардор" WHERE id = 1120;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Остров Ужаса" WHERE id = 1121;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Высокогорные дебри" WHERE id = 1136;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Низинные чащобы" WHERE id = 1137;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Южные степи" WHERE id = 1156;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Южный Золотой Путь" WHERE id = 1157;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Зул'Фаррак" WHERE id = 1176;
UPDATE `AreaTable_vanilla` SET name_loc8 = "НЕ ИСПОЛЬЗУЕТСЯ Остров Альказ" WHERE id = 1196;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Крепость Древобрюхов" WHERE id = 1216;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Ванндир" WHERE id = 1217;
UPDATE `AreaTable_vanilla` SET name_loc8 = "ТЕСТАзшара" WHERE id = 1218;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Легаш" WHERE id = 1219;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Талассийское поселение" WHERE id = 1220;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Эльдарата" WHERE id = 1221;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Гнездо Хетайры" WHERE id = 1222;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Храм Зин-Малор" WHERE id = 1223;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Медвежий угол" WHERE id = 1224;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Урсолан" WHERE id = 1225;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Храм Арккоран" WHERE id = 1226;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Залив Бурь" WHERE id = 1227;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Разоренное побережье" WHERE id = 1228;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Башня Эльдары" WHERE id = 1229;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Острые рифы" WHERE id = 1230;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Южный пляж" WHERE id = 1231;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Памятник Гребню Ворона" WHERE id = 1232;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Одинокая вершина" WHERE id = 1233;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Озеро Меннар" WHERE id = 1234;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Святилище Песни Теней" WHERE id = 1235;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Халдарр" WHERE id = 1236;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Храбростан" WHERE id = 1237;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Опустошенный берег" WHERE id = 1256;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Туннель Когтя" WHERE id = 1276;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Туннель Когтя" WHERE id = 1277;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ферма Каменного Клыка" WHERE id = 1296;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Свиноферма" WHERE id = 1297;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Курганы Иглошкурых" WHERE id = 1316;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Бухта Сорванных Парусов" WHERE id = 1336;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ульдаман" WHERE id = 1337;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Озеро Лордамер" WHERE id = 1338;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Озеро Лордамер" WHERE id = 1339;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Перекресток Висельников" WHERE id = 1357;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Силитус" WHERE id = 1377;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Изумрудный лес" WHERE id = 1397;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Затонувший храм" WHERE id = 1417;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Форт Молота Ужаса" WHERE id = 1437;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Крепость Стражей Пустоты" WHERE id = 1438;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Стоянка Молота Ужаса" WHERE id = 1439;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Змеиные Кольца" WHERE id = 1440;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Алтарь Бурь" WHERE id = 1441;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Гряда Огненной стражи" WHERE id = 1442;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Шлаковая Яма" WHERE id = 1443;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пепельное Море" WHERE id = 1444;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Черная гора" WHERE id = 1445;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Братства Тория" WHERE id = 1446;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Мастерские Гарнизона" WHERE id = 1457;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Храм Атал'Хаккара" WHERE id = 1477;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Подгород" WHERE id = 1497;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ульдаман" WHERE id = 1517;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Не использующиеся Мертвые копи" WHERE id = 1518;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Штормград" WHERE id = 1519;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Стальгорн" WHERE id = 1537;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Оплот Треснувшего Копыта" WHERE id = 1557;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Мыс Тернистой долины" WHERE id = 1577;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Южный Гибельный берег" WHERE id = 1578;
UPDATE `AreaTable_vanilla` SET name_loc8 = "НЕ ИСПОЛЬЗУЕТСЯ Мертвые копи 002" WHERE id = 1579;
UPDATE `AreaTable_vanilla` SET name_loc8 = "НЕ ИСПОЛЬЗУЕТСЯ Потайная бухта 003" WHERE id = 1580;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Мертвые копи" WHERE id = 1581;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Потайная бухта" WHERE id = 1582;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пик Черной горы" WHERE id = 1583;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Глубины Черной горы" WHERE id = 1584;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Земли ящеров НЕ ИСПОЛЬЗУЕТСЯ" WHERE id = 1597;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ферма Гроль'дома НЕ ИСПОЛЬЗУЕТСЯ" WHERE id = 1598;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Мор'шан" WHERE id = 1599;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Застава Чести НЕ ИСПОЛЬЗУЕТСЯ" WHERE id = 1600;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Хребет Черный шип НЕ ИСПОЛЬЗУЕТСЯ" WHERE id = 1601;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ежевичный Шип НЕ ИСПОЛЬЗУЕТСЯ" WHERE id = 1602;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Агамагор НЕ ИСПОЛЬЗУЕТСЯ" WHERE id = 1603;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Аллея Героев" WHERE id = 1617;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Оргриммар" WHERE id = 1637;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Громовой Утес" WHERE id = 1638;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Вершина Старейшин" WHERE id = 1639;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Вершина Духов" WHERE id = 1640;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Вершина Охотников" WHERE id = 1641;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Дарнас" WHERE id = 1657;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Анклав Кенария" WHERE id = 1658;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Терраса Ремесленников" WHERE id = 1659;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Терраса Воинов" WHERE id = 1660;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Храмовые сады" WHERE id = 1661;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Терраса Торговцев" WHERE id = 1662;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Возвышенность Гэвина" WHERE id = 1677;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Возвышенность Соферы" WHERE id = 1678;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Уступ Коррана" WHERE id = 1679;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Высокий отрог" WHERE id = 1680;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Мглистый берег" WHERE id = 1681;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Овчарня Дандреда" WHERE id = 1682;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Промерзшая пещера" WHERE id = 1683;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Берег Промозглого Ветра" WHERE id = 1684;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Земли Ящеров" WHERE id = 1697;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ежевичный овраг" WHERE id = 1698;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Тернистый холм" WHERE id = 1699;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Агама'гор" WHERE id = 1700;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Хребет Черных Шипов" WHERE id = 1701;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Застава Чести" WHERE id = 1702;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Застава Мор'шан" WHERE id = 1703;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ферма Гроль'дома" WHERE id = 1704;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лабиринты Иглошкурых" WHERE id = 1717;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Великий Подъемник" WHERE id = 1718;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Мглистая долина" WHERE id = 1737;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Родник Нек'Мани" WHERE id = 1738;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Кровавого Паруса" WHERE id = 1739;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Главный лагерь Торговой Компании" WHERE id = 1740;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Арена Гурубаши" WHERE id = 1741;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пещера Духов" WHERE id = 1742;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Кровавая Завеса" WHERE id = 1757;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Бурун" WHERE id = 1758;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Госпожа Удача" WHERE id = 1759;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Штаб-квартира Торговой Компании" WHERE id = 1760;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Деревня Мертвого Леса" WHERE id = 1761;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Деревня Сквернолапов" WHERE id = 1762;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Джеденар" WHERE id = 1763;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Река Отравленной Крови" WHERE id = 1764;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Водопад Отравленной Крови" WHERE id = 1765;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Долина Рваных Ран" WHERE id = 1766;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Железнолесье" WHERE id = 1767;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пещера Железнолесья" WHERE id = 1768;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Крепость Древобрюхов" WHERE id = 1769;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Оплот Теней" WHERE id = 1770;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Святилище Искусителя" WHERE id = 1771;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пещера Итара" WHERE id = 1777;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Горемрак" WHERE id = 1778;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Деревня Дренил'дур" WHERE id = 1779;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Развилка Расщепленного Копья" WHERE id = 1780;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Вязкая топь" WHERE id = 1797;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ползучая трясина" WHERE id = 1798;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пещера у Вязкой топи" WHERE id = 1817;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пещеры Сухокожих" WHERE id = 1837;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Стена Торадина" WHERE id = 1857;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Камен'гор" WHERE id = 1858;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Долина Клыков" WHERE id = 1877;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Знойные Пески" WHERE id = 1878;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Маревые равнины" WHERE id = 1879;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Домик Пероборода" WHERE id = 1880;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Выпивохи" WHERE id = 1881;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Чумная лощина" WHERE id = 1882;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Озеро Доблести" WHERE id = 1883;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Агол'вата" WHERE id = 1884;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Хири'вата" WHERE id = 1885;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ползучие руины" WHERE id = 1886;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Грот Богена" WHERE id = 1887;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Терраса Творца" WHERE id = 1897;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лощина Суховея" WHERE id = 1898;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Шаол'вата" WHERE id = 1917;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Полуденной Тени" WHERE id = 1937;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Разбитая Колонна" WHERE id = 1938;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Безбрежные пески" WHERE id = 1939;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Берег за Южной грядой" WHERE id = 1940;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пещеры Времени" WHERE id = 1941;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Топи" WHERE id = 1942;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Плато Железного Камня" WHERE id = 1943;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Обугленная пещера" WHERE id = 1957;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Палатка Дубильщицы" WHERE id = 1958;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Выжженная долина" WHERE id = 1959;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Зул'Гуруб" WHERE id = 1977;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Тростниковая застава" WHERE id = 1978;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Застава Отравленной Крови" WHERE id = 1997;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Поляна Когтистых Ветвей" WHERE id = 1998;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Стратхольм" WHERE id = 2017;
UPDATE `AreaTable_vanilla` SET name_loc8 = "НЕ ИСПОЛЬЗУЕТСЯ Крепость Темного Клыка 003" WHERE id = 2037;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Некроситет" WHERE id = 2057;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сумеречная долина" WHERE id = 2077;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сумеречная излучина" WHERE id = 2078;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Остров Алькац" WHERE id = 2079;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пик Темного Облака" WHERE id = 2097;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Катакомбы Утреннего Леса" WHERE id = 2098;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Крепость Каменной Стражи" WHERE id = 2099;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Мародон" WHERE id = 2100;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Таверна \"Крепкое пойло\"" WHERE id = 2101;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Таверна \"Громоварка\"" WHERE id = 2102;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Крепость Менетил" WHERE id = 2103;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Таверна \"Большая вода\"" WHERE id = 2104;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Мрачный склеп" WHERE id = 2117;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ратуша Брилла" WHERE id = 2118;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Таверна \"Петля висельника\"" WHERE id = 2119;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пруды ВиденийНЕ ИСПОЛЬЗУЕТСЯ" WHERE id = 2137;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пещера Багрового Тумана" WHERE id = 2138;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Крепость Бейл'дан" WHERE id = 2157;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Логово Огнебора" WHERE id = 2158;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Логово Ониксии" WHERE id = 2159;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Рудник Ветрорезов" WHERE id = 2160;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Погибель Роланда" WHERE id = 2161;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ринг" WHERE id = 2177;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пруды Видений" WHERE id = 2197;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лощина Тьмы" WHERE id = 2198;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Деревня Сломанного Копья" WHERE id = 2217;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Застава Белого Плеса" WHERE id = 2237;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Горния" WHERE id = 2238;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Око Зейна" WHERE id = 2239;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Виражи на Миражах" WHERE id = 2240;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Уступ Ледопардов" WHERE id = 2241;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сокрытая роща" WHERE id = 2242;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Застава Древобрюхов" WHERE id = 2243;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Деревня Зимней Спячки" WHERE id = 2244;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Мазторил" WHERE id = 2245;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Источники Ледяного огня" WHERE id = 2246;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Холмы Ледополоха" WHERE id = 2247;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Дун Мандарр" WHERE id = 2248;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Теснина Ледяного Шепота" WHERE id = 2249;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Совиная чаща" WHERE id = 2250;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Озеро Кел'Терил" WHERE id = 2251;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Кел'Терила" WHERE id = 2252;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Деревня Звездопада" WHERE id = 2253;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Берлога Бен'Таллоу" WHERE id = 2254;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Круговзор" WHERE id = 2255;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Теснина Зловещего Шепота" WHERE id = 2256;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Подземный поезд" WHERE id = 2257;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Грибная долина" WHERE id = 2258;
UPDATE `AreaTable_vanilla` SET name_loc8 = "НЕ ИСПОЛЬЗУЕТСЯПоместье Маррисов" WHERE id = 2259;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Поместье Маррисов" WHERE id = 2260;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Крипта" WHERE id = 2261;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Дарроушир" WHERE id = 2262;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Башня королевской стражи" WHERE id = 2263;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Перекресток Корина" WHERE id = 2264;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Алого ордена" WHERE id = 2265;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Длань Тира" WHERE id = 2266;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Алая Базилика" WHERE id = 2267;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Часовня Последней Надежды" WHERE id = 2268;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лесопилка Бровача" WHERE id = 2269;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ядовитая поляна" WHERE id = 2270;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Восточная башня" WHERE id = 2271;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Северный Дол" WHERE id = 2272;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Зул'Машар" WHERE id = 2273;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Мазра'Алор" WHERE id = 2274;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Башня Северного перевала" WHERE id = 2275;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сторожка Кель'Литиен" WHERE id = 2276;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Проклятый лес" WHERE id = 2277;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Оплот Плети" WHERE id = 2278;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Стратхольм" WHERE id = 2279;
UPDATE `AreaTable_vanilla` SET name_loc8 = "НЕ ИСПОЛЬЗУЕТСЯ Стратхольм" WHERE id = 2280;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Озеро Дарроумир" WHERE id = 2297;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Каэр Дарроу" WHERE id = 2298;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Озеро Дарроумир" WHERE id = 2299;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пещеры Времени" WHERE id = 2300;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Деревня Колючего Меха" WHERE id = 2301;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Трясина" WHERE id = 2302;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Безветренный каньон" WHERE id = 2303;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Южные моря" WHERE id = 2317;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Великое море" WHERE id = 2318;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Великое море" WHERE id = 2319;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Великое море" WHERE id = 2320;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Великое море" WHERE id = 2321;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сокрытое море" WHERE id = 2322;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сокрытое море" WHERE id = 2323;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сокрытое море" WHERE id = 2324;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сокрытое море" WHERE id = 2325;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сокрытое море" WHERE id = 2326;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Казармы Колючего Холма" WHERE id = 2337;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Южные моря" WHERE id = 2338;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Великое море" WHERE id = 2339;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Кровавого Клыка" WHERE id = 2357;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лесная Песнь" WHERE id = 2358;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Деревня Зеленой Лапы" WHERE id = 2359;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Аванпост Среброкрылых" WHERE id = 2360;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ночная Гавань" WHERE id = 2361;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Святилище Ремула" WHERE id = 2362;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Кельи Малфуриона" WHERE id = 2363;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Великое море" WHERE id = 2364;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Великое море" WHERE id = 2365;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Черные топи" WHERE id = 2366;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Старые предгорья Хилсбрада" WHERE id = 2367;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Мельница Таррен" WHERE id = 2368;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Южнобережье" WHERE id = 2369;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Крепость Дарнхольд" WHERE id = 2370;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Дун Гарок" WHERE id = 2371;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Хилсбрадские поля" WHERE id = 2372;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Восточное побережье" WHERE id = 2373;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Владение Нетандера" WHERE id = 2374;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Холм Дарроу" WHERE id = 2375;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Южная башня" WHERE id = 2376;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Стена Торадина" WHERE id = 2377;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Западное побережье" WHERE id = 2378;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лазуритовый рудник" WHERE id = 2379;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Великое море" WHERE id = 2397;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Великое море" WHERE id = 2398;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Великое море" WHERE id = 2399;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Зловещее море" WHERE id = 2400;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Зловещее море" WHERE id = 2401;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Зловещее море" WHERE id = 2402;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Зловещее море" WHERE id = 2403;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Тефрис-Аран" WHERE id = 2404;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Этель-Ретор" WHERE id = 2405;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Остров Раназьяр" WHERE id = 2406;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Хижина Кормека" WHERE id = 2407;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Деревня Ночных Охотников" WHERE id = 2408;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Перевал Черной горы" WHERE id = 2417;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Дозор Моргана" WHERE id = 2418;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Скользкая скала" WHERE id = 2419;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Тропа Крылатого Ужаса" WHERE id = 2420;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Драко'дар" WHERE id = 2421;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Огненная пропасть" WHERE id = 2437;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Леса Ночной Песни" WHERE id = 2457;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сокрытое море" WHERE id = 2477;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Морлос'Аран" WHERE id = 2478;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Изумрудное святилище" WHERE id = 2479;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Долина Нефритового Пламени" WHERE id = 2480;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Констелласа" WHERE id = 2481;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Горькие плесы" WHERE id = 2497;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Утес Осквернителя" WHERE id = 2517;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Павильон Лорисс" WHERE id = 2518;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Холмы Древолапов" WHERE id = 2519;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Логово Древолапов" WHERE id = 2520;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Река Вердантис" WHERE id = 2521;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Исильдиэна" WHERE id = 2522;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Застава Зловещего Тотема" WHERE id = 2537;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Апарахе" WHERE id = 2538;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Малака'джин" WHERE id = 2539;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ущелье Камнепадов" WHERE id = 2540;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сиширский каньон" WHERE id = 2541;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Забытый Город" WHERE id = 2557;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Овраг Мертвого Ветра" WHERE id = 2558;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Река Алмазная" WHERE id = 2559;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Аридена" WHERE id = 2560;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Погань" WHERE id = 2561;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Каражан" WHERE id = 2562;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Надел Моргана" WHERE id = 2563;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Забытый Город" WHERE id = 2577;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Альтеракская долина" WHERE id = 2597;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Заржавня" WHERE id = 2617;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Холм Нефритового Пламени" WHERE id = 2618;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Река Тондрорил" WHERE id = 2619;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Река Тондрорил" WHERE id = 2620;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Озеро Мерельдар" WHERE id = 2621;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Моровой овраг" WHERE id = 2622;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Чумной овраг" WHERE id = 2623;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Озеро Чернолесья" WHERE id = 2624;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Восточные ворота" WHERE id = 2625;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Туннель Ужаса" WHERE id = 2626;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Долина Ужаса" WHERE id = 2627;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Крепость Каргатия" WHERE id = 2637;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Долина Костей" WHERE id = 2657;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Логово Крыла Тьмы" WHERE id = 2677;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Перекресток Мертвеца" WHERE id = 2697;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Огненные Недра" WHERE id = 2717;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Стена Скарабея" WHERE id = 2737;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Деревня Южного Ветра" WHERE id = 2738;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сумеречный лагерь" WHERE id = 2739;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Долина Кристаллов" WHERE id = 2740;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Помост Скарабея" WHERE id = 2741;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Улей Аши" WHERE id = 2742;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Улей Зора" WHERE id = 2743;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Улей Регал" WHERE id = 2744;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Святилище Павшего Воина" WHERE id = 2757;
UPDATE `AreaTable_vanilla` SET name_loc8 = "НЕ ИСПОЛЬЗУЕТСЯ Альтеракская долина" WHERE id = 2777;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Непроглядная Пучина" WHERE id = 2797;
UPDATE `AreaTable_vanilla` SET name_loc8 = "***Используй меня повторно 4***" WHERE id = 2817;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Хозяйский погреб" WHERE id = 2837;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Подгорная тропа" WHERE id = 2838;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Альтеракская долина" WHERE id = 2839;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Гремящая Клеть" WHERE id = 2857;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Глыба Тест" WHERE id = 2877;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Форт Зорам'гар" WHERE id = 2897;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Зал Легенд" WHERE id = 2917;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Зал Защитника" WHERE id = 2918;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Поселок Грош'гок" WHERE id = 2937;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Спящая теснина" WHERE id = 2938;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Железный рудник" WHERE id = 2957;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Форт Каменного Очага" WHERE id = 2958;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Дун Болдар" WHERE id = 2959;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Перевал Ледяного Крыла" WHERE id = 2960;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Деревня Северного Волка" WHERE id = 2961;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Смотровая башня" WHERE id = 2962;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Рудник Ледяного Зуба" WHERE id = 2963;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Форт Ледяной Секиры" WHERE id = 2964;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Гарнизон Стылой Крови" WHERE id = 2977;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Крепость Северного Волка" WHERE id = 2978;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ферма Тор'кренов" WHERE id = 2979;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Перевал Ледяного Клинка" WHERE id = 3017;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Железного Камня" WHERE id = 3037;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Кратер Криворука" WHERE id = 3038;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Тахонды" WHERE id = 3039;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Поле брани" WHERE id = 3057;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пещера Ледяного Крыла" WHERE id = 3058;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Погост Отважных" WHERE id = 3077;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Роящаяся вершина" WHERE id = 3097;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сумеречная застава" WHERE id = 3098;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сумеречный форт" WHERE id = 3099;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Разоренный Сумеречный лагерь" WHERE id = 3100;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Убежище Шалзару" WHERE id = 3117;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Застава Талрендис" WHERE id = 3137;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Святилище Ретресса" WHERE id = 3138;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Обитель Лунного Ужаса" WHERE id = 3139;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пещера Чешуеборода" WHERE id = 3140;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пещера Камнепадов" WHERE id = 3157;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Рабочий лагерь Песни Войны" WHERE id = 3177;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Промозглого Ветра" WHERE id = 3197;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ристалище" WHERE id = 3217;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Молот НЕ ИСПОЛЬЗУЕТСЯ" WHERE id = 3237;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Кости Граккаронда" WHERE id = 3257;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ущелье Песни Войны" WHERE id = 3277;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Кладбище Северного Волка" WHERE id = 3297;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Перевал Северного Волка" WHERE id = 3298;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Перевал Дун Болдар" WHERE id = 3299;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Кладбище Стылой Крови" WHERE id = 3300;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Кладбище Снегопада" WHERE id = 3301;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Кладбище Каменного Очага" WHERE id = 3302;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Кладбище Грозовой Вершины" WHERE id = 3303;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Укрытие Ледяного Крыла" WHERE id = 3304;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Укрытие Каменного Очага" WHERE id = 3305;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Гряда Дикой Лапы" WHERE id = 3306;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Деревня Сломанного Клыка" WHERE id = 3317;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Обелиск Дуротана" WHERE id = 3318;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Роща Среброкрылых" WHERE id = 3319;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лесопилка Песни Войны" WHERE id = 3320;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Крепость Среброкрылых" WHERE id = 3321;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пещера Дикой Лапы" WHERE id = 3337;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сокрытое ущелье" WHERE id = 3338;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Остров Йоджамба" WHERE id = 3357;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Низина Арати" WHERE id = 3358;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Змеиное Кольцо" WHERE id = 3377;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Алтарь Хир'ика" WHERE id = 3378;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Шадра'заар" WHERE id = 3379;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Земли Хаккари" WHERE id = 3380;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Холм Ширвалла" WHERE id = 3381;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Храм Бетекк" WHERE id = 3382;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Алтарь Кипящей Крови" WHERE id = 3383;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Алтарь Бога Крови" WHERE id = 3384;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Пирамида Занзы" WHERE id = 3397;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Грань Безумия" WHERE id = 3398;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Зал Троллебоя" WHERE id = 3417;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Логово Осквернителя" WHERE id = 3418;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Стоянка Пэгла" WHERE id = 3419;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ферма" WHERE id = 3420;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Кузница" WHERE id = 3421;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лесопилка" WHERE id = 3422;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Золотой рудник" WHERE id = 3423;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Стойла" WHERE id = 3424;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Крепость Кенария" WHERE id = 3425;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Оленьего Шлема" WHERE id = 3426;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Лагерь Бронзоборода" WHERE id = 3427;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Ан'Кираж" WHERE id = 3428;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Ан'Киража" WHERE id = 3429;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Сумеречная пещера" WHERE id = 3446;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Укрытие Ортелла" WHERE id = 3447;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Терраса Скарабея" WHERE id = 3448;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Терраса Генерала" WHERE id = 3449;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Резервуар" WHERE id = 3450;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Инкубатор" WHERE id = 3451;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Соты" WHERE id = 3452;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Терраса Стражей" WHERE id = 3453;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Руины Ан'Киража" WHERE id = 3454;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Наксрамас" WHERE id = 3456;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Город" WHERE id = 3459;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Врата Ан'Киража" WHERE id = 3478;
UPDATE `AreaTable_vanilla` SET name_loc8 = "Поместье Черного Ворона" WHERE id = 3486;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Dun Morogh" WHERE id = 1;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Praia Grande" WHERE id = 2;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ermos" WHERE id = 3;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Barreira do Inferno" WHERE id = 4;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Angra Aguanegra" WHERE id = 7;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pântano das Mágoas" WHERE id = 8;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale de Vila Norte" WHERE id = 9;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Floresta do Crepúsculo" WHERE id = 10;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pantanal" WHERE id = 11;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Floresta de Elwynn" WHERE id = 12;
UPDATE `AreaTable_vanilla` SET name_loc10 = "A Árvore do Mundo" WHERE id = 13;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Durotar" WHERE id = 14;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pântano Vadeoso" WHERE id = 15;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Azshara" WHERE id = 16;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Sertões" WHERE id = 17;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago de Cristal" WHERE id = 18;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Zul'Gurub" WHERE id = 19;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Arroio da Lua" WHERE id = 20;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Kul Tiraz" WHERE id = 21;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ilha dos Programadores" WHERE id = 22;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rio Vila Norte" WHERE id = 23;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Abadia de Vila Norte" WHERE id = 24;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Montanha Rocha Negra" WHERE id = 25;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Farol" WHERE id = 26;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Terras Pestilentas Ocidentais" WHERE id = 28;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Nove" WHERE id = 30;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Cemitério" WHERE id = 32;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Selva do Espinhaço" WHERE id = 33;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mina da Serra do Eco" WHERE id = 34;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Angra do Butim" WHERE id = 35;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Montanhas de Alterac" WHERE id = 36;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago Nazferiti" WHERE id = 37;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Loch Modan" WHERE id = 38;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cerro Oeste" WHERE id = 40;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Trilha do Vento Morto" WHERE id = 41;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vila Sombria" WHERE id = 42;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Praia Selvagem" WHERE id = 43;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Montanhas Cristarrubra" WHERE id = 44;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Planalto Arathi" WHERE id = 45;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Estepes Ardentes" WHERE id = 46;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Terras Agrestes" WHERE id = 47;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Antro do Morto" WHERE id = 49;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Garganta Abrasadora" WHERE id = 51;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Acampamento dos Ladrões" WHERE id = 53;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mina de Jaspe" WHERE id = 54;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Valley of Heroes UNUSED" WHERE id = 55;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vigia dos Heróis" WHERE id = 56;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mina Vailafundo" WHERE id = 57;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vinhedos de Vila Norte" WHERE id = 59;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Boca da Mata" WHERE id = 60;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cachoeira do Trovão" WHERE id = 61;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Plantação de Abóboras dos Braga" WHERE id = 62;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fazenda dos Campedra" WHERE id = 63;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vinhedos dos Madruga" WHERE id = 64;
UPDATE `AreaTable_vanilla` SET name_loc10 = "***On Map Dungeon***" WHERE id = 65;
UPDATE `AreaTable_vanilla` SET name_loc10 = "***On Map Dungeon***" WHERE id = 66;
UPDATE `AreaTable_vanilla` SET name_loc10 = "***On Map Dungeon***" WHERE id = 67;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago Plácido" WHERE id = 68;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vila Plácida" WHERE id = 69;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mirante de Pedra" WHERE id = 70;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cachoeira do Mirante de Pedra" WHERE id = 71;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Portal Negro" WHERE id = 72;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rasgo Infecto" WHERE id = 73;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Poço de Lágrimas" WHERE id = 74;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pedregal" WHERE id = 75;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Retiro Alqueivado" WHERE id = 76;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Sidermar" WHERE id = 77;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Montanhas de Ventobravo" WHERE id = 80;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Jeff NE Quadrant Changed" WHERE id = 81;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Jeff NW Quadrant" WHERE id = 82;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Jeff SE Quadrant" WHERE id = 83;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Jeff SW Quadrant" WHERE id = 84;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Clareiras de Tirisfal" WHERE id = 85;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago do Monumento" WHERE id = 86;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vila d'Ouro" WHERE id = 87;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Madeireira Vale do Leste" WHERE id = 88;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pomar do Lago Espelhado" WHERE id = 89;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Torre de Azora" WHERE id = 91;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago Espelhado" WHERE id = 92;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Gruta de Vul'Gol" WHERE id = 93;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Monte Corvo" WHERE id = 94;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Garganta Cristarrubra" WHERE id = 95;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Torre de Ilgalar" WHERE id = 96;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Serraria Alther" WHERE id = 97;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cavernas Retibanas" WHERE id = 98;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Acampamento dos Rebeldes" WHERE id = 99;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Expedição do Rosarães" WHERE id = 100;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Complexo do Kurzen" WHERE id = 101;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas de Zul'Kanda" WHERE id = 102;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas de Zul'Mamwe" WHERE id = 103;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Arrecife Torpe" WHERE id = 104;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Gruta de Mosh'Ogg" WHERE id = 105;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Arsenal" WHERE id = 106;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fazenda dos Saldanha" WHERE id = 107;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Morro da Sentinela" WHERE id = 108;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Plantação de Abóboras do Taturana" WHERE id = 109;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mina Veiojango" WHERE id = 111;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pedreira Costa Dourada" WHERE id = 113;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Farol de Cerro Oeste" WHERE id = 115;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale Nebuloso" WHERE id = 116;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Acampamento Grom'gol" WHERE id = 117;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Sítio de Escavação de Whelgar" WHERE id = 118;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Guarnição da Ribeira d'Oeste" WHERE id = 120;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cemitério Jardins da Paz" WHERE id = 121;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas Zuuldaia" WHERE id = 122;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas de Bal'lal" WHERE id = 123;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas de Kal'ai" WHERE id = 125;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas de Tkashi" WHERE id = 126;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas de Balia'mah" WHERE id = 127;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas Ziata'jai" WHERE id = 128;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas de Nizjah" WHERE id = 129;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Floresta de Pinhaprata" WHERE id = 130;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Kharanos" WHERE id = 131;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale Cristálgida" WHERE id = 132;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Gnomeregan" WHERE id = 133;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pedreira Gol'Bolar" WHERE id = 134;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fortaleza Jubafria" WHERE id = 135;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Covil Cinzento" WHERE id = 136;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Aldeia da Cevada" WHERE id = 137;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Refúgio Pinhal das Brumas" WHERE id = 138;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Terras Pestilentas Orientais" WHERE id = 139;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Teldrassil" WHERE id = 141;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Sítio de Escavação de Bandaferro" WHERE id = 142;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fortaleza Mo'grosh" WHERE id = 143;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Thelsamar" WHERE id = 144;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Portão de Algaz" WHERE id = 145;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Dique Lapidado" WHERE id = 146;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pavilhão dos Andarilhos" WHERE id = 147;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Costa Negra" WHERE id = 148;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mina da Prata" WHERE id = 149;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Porto de Menethil" WHERE id = 150;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ilha dos Designers" WHERE id = 151;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Baluarte" WHERE id = 152;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas de Lordaeron" WHERE id = 153;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Plangemortis" WHERE id = 154;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale Teia da Noite" WHERE id = 155;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fazenda dos Solliden" WHERE id = 156;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Moinhos dos Agamand" WHERE id = 157;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cripta da Família Agamand" WHERE id = 158;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Montalvo" WHERE id = 159;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Jardins Murmurantes" WHERE id = 160;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Terraço do Repouso" WHERE id = 161;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago Águas Claras" WHERE id = 162;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Refúgio de Tertuliano" WHERE id = 163;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Sítio dos Garren" WHERE id = 164;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fazenda dos Balnir" WHERE id = 165;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Casarão Lar Glacial" WHERE id = 166;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Guarita dos Cruzados" WHERE id = 167;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Costa Norte" WHERE id = 168;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Praia Sibilante" WHERE id = 169;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Espelho de Lordaeron" WHERE id = 170;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ilha de Fenris" WHERE id = 172;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Repouso de Faol" WHERE id = 173;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Dolanaar" WHERE id = 186;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Darnassus UNUSED" WHERE id = 187;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Umbravale" WHERE id = 188;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Garagem do Gradaço" WHERE id = 189;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Amparo" WHERE id = 190;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Madeireira Beiranorte" WHERE id = 192;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas de Andorhal" WHERE id = 193;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Escola de Necromancia" WHERE id = 195;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Tumba de Uther" WHERE id = 196;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Colina do Pesar" WHERE id = 197;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Caverna das Lágrimas" WHERE id = 198;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Campo Pedravil" WHERE id = 199;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lágrimas de Dalson" WHERE id = 200;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Aridez de Garrão" WHERE id = 201;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Antro Repelente" WHERE id = 202;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Bastilha Mardenforte" WHERE id = 203;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vilarejo Lenhardente" WHERE id = 204;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Dun Modr" WHERE id = 205;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cerro Oeste" WHERE id = 206;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Grande Oceano" WHERE id = 207;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Unused Ironcladcove" WHERE id = 208;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Bastilha da Presa Negra" WHERE id = 209;
UPDATE `AreaTable_vanilla` SET name_loc10 = "***On Map Dungeon***" WHERE id = 210;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago Nevado" WHERE id = 211;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago Helm" WHERE id = 212;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mina Elenfunda" WHERE id = 213;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Grande Oceano" WHERE id = 214;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mulgore" WHERE id = 215;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fazenda dos Aleixo" WHERE id = 219;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Chapada Nuvem Vermelha" WHERE id = 220;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Aldeia Narache" WHERE id = 221;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Aldeia Casco Sangrento" WHERE id = 222;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago da Ferradura" WHERE id = 223;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Caravana Devastada" WHERE id = 224;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rochedo Vermelho" WHERE id = 225;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Penumbra Furtiva" WHERE id = 226;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Sítio do Valgan" WHERE id = 227;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Sepulcro" WHERE id = 228;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Miséria de Olsen" WHERE id = 229;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Muralha Greymane" WHERE id = 230;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cilada de Beren" WHERE id = 231;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ilhas da Aurora" WHERE id = 232;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lenhâmbar" WHERE id = 233;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Castelo Fenris" WHERE id = 235;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Bastilha da Presa Negra" WHERE id = 236;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Campos Apodrecidos" WHERE id = 237;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Horto dos Maldonado" WHERE id = 238;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Plantação do Ivar" WHERE id = 239;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Campo Morto" WHERE id = 240;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Horto Pútrido" WHERE id = 241;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Bosque Brilhante" WHERE id = 242;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Morro dos Esquecidos" WHERE id = 243;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Propriedade dos Whipple" WHERE id = 244;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fazenda dos Figueira" WHERE id = 245;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Caldeirão" WHERE id = 246;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Escavação Pedrassuja" WHERE id = 247;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rochedo Malhorrendo" WHERE id = 249;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas de Thaurissan" WHERE id = 250;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Monte Candente" WHERE id = 251;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fortaleza Rocha Negra" WHERE id = 252;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pilar de Cinzas" WHERE id = 253;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Montanha Rocha Negra" WHERE id = 254;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Altar das Tempestades" WHERE id = 255;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Aldrassil" WHERE id = 256;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Caverna Fionumbra" WHERE id = 257;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pedra Vil" WHERE id = 258;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago Al'Ameth" WHERE id = 259;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vilarejo Brisastral" WHERE id = 260;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Acampamento Masca-pinho" WHERE id = 261;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Gruta de Ban'ethil" WHERE id = 262;
UPDATE `AreaTable_vanilla` SET name_loc10 = "A Fenda" WHERE id = 263;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Clareira do Oráculo" WHERE id = 264;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rio Olho-d'Água" WHERE id = 265;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago Olho-d'Água" WHERE id = 266;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Contraforte de Eira dos Montes" WHERE id = 267;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cratera de Azshara" WHERE id = 268;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Dun Algaz" WHERE id = 269;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Costa Sul" WHERE id = 271;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Serraria Tarren" WHERE id = 272;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Forte do Desterro" WHERE id = 275;
UPDATE `AreaTable_vanilla` SET name_loc10 = "UNUSED Stonewrought Pass" WHERE id = 276;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Caverna do Pé da Serra" WHERE id = 277;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Campo de Internação de Lordaeron" WHERE id = 278;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Dalaran" WHERE id = 279;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Strahnbrad" WHERE id = 280;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas de Alterac" WHERE id = 281;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Bastilha Esmagaterra" WHERE id = 282;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Antro do Massacre" WHERE id = 283;
UPDATE `AreaTable_vanilla` SET name_loc10 = "As Terras Altas" WHERE id = 284;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Torre do Sul" WHERE id = 285;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Campos de Eira dos Montes" WHERE id = 286;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Eira dos Montes" WHERE id = 287;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mina Veioazul" WHERE id = 288;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Sítio de Nethander" WHERE id = 289;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Dun Garok" WHERE id = 290;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Muralha de Thoradin" WHERE id = 293;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Praia Oriental" WHERE id = 294;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Praia Ocidental" WHERE id = 295;
UPDATE `AreaTable_vanilla` SET name_loc10 = "South Seas UNUSED" WHERE id = 296;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ilha Jaguara" WHERE id = 297;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Baía de Baradin" WHERE id = 298;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Baía de Menethil" WHERE id = 299;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Praia Brumalga" WHERE id = 300;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Costa Selvagem" WHERE id = 301;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Praia Cristalina" WHERE id = 302;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Praia da Concha" WHERE id = 303;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Costa da Maré do Norte" WHERE id = 305;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Costa da Maré do Sul" WHERE id = 306;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Penhascos Panorâmicos" WHERE id = 307;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Mar Proibido" WHERE id = 308;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Tumba dos Barbaférreos" WHERE id = 309;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mina Veia de Cristal" WHERE id = 310;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas de Aboraz" WHERE id = 311;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pontal de Janeiro" WHERE id = 312;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Casa Grande do Norte" WHERE id = 313;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fazenda Go'Shek" WHERE id = 314;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fazenda dos Dabyrie" WHERE id = 315;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Forte Punho de Pedra" WHERE id = 316;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Aldeia Cascasseca" WHERE id = 317;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Garganta Seca" WHERE id = 318;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ponta do Refúgio" WHERE id = 320;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruína do Martelo" WHERE id = 321;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Destroços de Aguanegra" WHERE id = 322;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Acampamento do Nabrava" WHERE id = 323;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Bastilha de Stromgarde" WHERE id = 324;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Torre de Arathor" WHERE id = 325;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Sacrário" WHERE id = 326;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Enseada de Faldir" WHERE id = 327;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Recife dos Afogados" WHERE id = 328;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ponte Thandol" WHERE id = 330;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale Gris" WHERE id = 331;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Grande Oceano" WHERE id = 332;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Círculo de União Oriental" WHERE id = 333;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Círculo de União Ocidental" WHERE id = 334;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Círculo de União Interno" WHERE id = 335;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Círculo de União Externo" WHERE id = 336;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Descanso do Apócrifo" WHERE id = 337;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fortaleza Angor" WHERE id = 338;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ravina Lethlor" WHERE id = 339;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Karrath" WHERE id = 340;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Acampamento Kosh" WHERE id = 341;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Acampamento Barf" WHERE id = 342;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Acampamento Wurg" WHERE id = 343;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Acampamento Cang" WHERE id = 344;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruína de Agmundo" WHERE id = 345;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Sítio de Escavação do Pé-de-malho" WHERE id = 346;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Gruta Arrota-pó" WHERE id = 347;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ninho da Águia" WHERE id = 348;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Bastilha Martelo Feroz" WHERE id = 349;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pavilhão Quel'Danil" WHERE id = 350;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rocha Oculta" WHERE id = 351;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Zun'watha" WHERE id = 352;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Shadra'Alor" WHERE id = 353;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Jintha'Alor" WHERE id = 354;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Altar de Zul" WHERE id = 355;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Seradane" WHERE id = 356;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Feralas" WHERE id = 357;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ravina da Lâmina Espinhenta" WHERE id = 358;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Bael Modan" WHERE id = 359;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mina da Empreendimentos S.A." WHERE id = 360;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Selva Maleva" WHERE id = 361;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Monte Navalha" WHERE id = 362;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale das Provações" WHERE id = 363;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Covil" WHERE id = 364;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Covil da Lâmina Ardente" WHERE id = 365;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Penedo de Kolkar" WHERE id = 366;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Aldeia Sen'jin" WHERE id = 367;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ilhas do Eco" WHERE id = 368;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Desfiladeiro do Trovão" WHERE id = 369;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Barranco da Ravina Seca" WHERE id = 370;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Caverna Sopravento" WHERE id = 371;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Bastilha Tiragarde" WHERE id = 372;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Praia do Bota-a-pique" WHERE id = 373;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Baía Carpunhal" WHERE id = 374;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Praia do Olho Seco" WHERE id = 375;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rio Furiaustral" WHERE id = 377;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Acampamento Taurajo" WHERE id = 378;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Posto Remoto" WHERE id = 379;
UPDATE `AreaTable_vanilla` SET name_loc10 = "A Encruzilhada" WHERE id = 380;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mina Veio do Pedregulho" WHERE id = 381;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Charco de Lodo" WHERE id = 382;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Montes Áridos" WHERE id = 383;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Morro de Brumedo" WHERE id = 384;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fortaleza da Guardanorte" WHERE id = 385;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Os Charcos Esquecidos" WHERE id = 386;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Oásis das Águas Claras" WHERE id = 387;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Oásis Estagnado" WHERE id = 388;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Campo dos Gigantes" WHERE id = 390;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Costa dos Mercadores" WHERE id = 391;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vila Catraca" WHERE id = 392;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Praia Lançanegra" WHERE id = 393;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Darrowmere Lake UNUSED" WHERE id = 394;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Caer Darrow UNUSED" WHERE id = 395;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Poço Casco Invernal" WHERE id = 396;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Poço Chifre Troante" WHERE id = 397;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Poço Juba Agreste" WHERE id = 398;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Serra do Horizonte" WHERE id = 399;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mil Agulhas" WHERE id = 400;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Escadaria de Tidus" WHERE id = 401;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Estalagem Pouso do Umbral" WHERE id = 403;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Sítio de Escavação de Bael'Dun" WHERE id = 404;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Desolação" WHERE id = 405;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cordilheira das Torres de Pedra" WHERE id = 406;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Orgrimmar UNUSED" WHERE id = 407;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ilha de Gillijim" WHERE id = 408;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ilha do Doutor Lapidis" WHERE id = 409;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Garganta do Vento Cortante" WHERE id = 410;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Refúgio de Bathran" WHERE id = 411;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas de Ordil'Aran" WHERE id = 412;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Entreposto de Maestra" WHERE id = 413;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Praia de Zoram" WHERE id = 414;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Astranaar" WHERE id = 415;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Altar de Aessina" WHERE id = 416;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Santuário Cicatriz de Fogo" WHERE id = 417;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas de Poeira Estelar" WHERE id = 418;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale Uivante" WHERE id = 419;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Refúgio Brisaprata" WHERE id = 420;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago Mistral" WHERE id = 421;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago Céu Caído" WHERE id = 422;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago Íris" WHERE id = 424;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Poço Lunar" WHERE id = 425;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Refúgio Bosque Real" WHERE id = 426;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Gruta Escura" WHERE id = 427;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Trilha da Noite" WHERE id = 428;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Xavian" WHERE id = 429;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Satyrnaar" WHERE id = 430;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Posto Machadada" WHERE id = 431;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Retiro de Dor'Danil" WHERE id = 432;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rio Felfarren" WHERE id = 433;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Monte Fogovil" WHERE id = 434;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cânion do Demônio Caído" WHERE id = 435;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Serra do Demônio Caído" WHERE id = 436;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Acampamento de Lenhadores Brado Guerreiro" WHERE id = 437;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Sombrarrama" WHERE id = 438;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Chapada Cintilante" WHERE id = 439;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Tanaris" WHERE id = 440;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago Falathim" WHERE id = 441;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Auberdine" WHERE id = 442;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas de Mathistra" WHERE id = 443;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Torre de Althalaxx" WHERE id = 444;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Quedas de Fontescarpa" WHERE id = 445;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Bashal'Aran" WHERE id = 446;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ameth'Aran" WHERE id = 447;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Bosque dos Ancientes" WHERE id = 448;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Glaive do Mestre" WHERE id = 449;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Escavação de Trilheiro" WHERE id = 450;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Beira das Névoas" WHERE id = 452;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Praia da Ressaca" WHERE id = 453;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rio Crenado" WHERE id = 454;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Antro dos Bosqueneros" WHERE id = 455;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rio Fontescarpa" WHERE id = 456;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mar Velado" WHERE id = 457;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Estrada do Ouro" WHERE id = 458;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Posto da Vigília Escarlate" WHERE id = 459;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Retiro Rocha do Sol" WHERE id = 460;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rochedo Cortavento" WHERE id = 461;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago do Rochedo" WHERE id = 463;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago Mirkfallon" WHERE id = 464;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale Carbonizado" WHERE id = 465;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale Furissangue" WHERE id = 466;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Morro das Torres de Pedra" WHERE id = 467;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Retiro do Gadanho" WHERE id = 468;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale Matagrande" WHERE id = 469;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Thunder Bluff UNUSED" WHERE id = 470;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Chapada Vento Valente" WHERE id = 471;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Chapada Rocha de Fogo" WHERE id = 472;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Manto de Rocha" WHERE id = 473;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Hunter Rise UNUSED" WHERE id = 474;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Spirit RiseUNUSED" WHERE id = 475;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Elder RiseUNUSED" WHERE id = 476;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas de Jubuwal" WHERE id = 477;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Águas de Arlithrien" WHERE id = 478;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Sítio de Escavação Velhomalho" WHERE id = 479;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Aldeia E'thok" WHERE id = 480;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rochedo do Casco Fendido" WHERE id = 481;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Alcândora" WHERE id = 482;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Garganta Uivante" WHERE id = 483;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Aldeia Vento Livre" WHERE id = 484;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Grande Elevador" WHERE id = 485;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Castelo Galath" WHERE id = 486;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Covil Plumerrante" WHERE id = 487;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Gruta Velha" WHERE id = 488;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Thalanaar" WHERE id = 489;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cratera Un'Goro" WHERE id = 490;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Urzal dos Tuscos" WHERE id = 491;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cemitério de Monte Corvo" WHERE id = 492;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Clareira da Lua" WHERE id = 493;
UPDATE `AreaTable_vanilla` SET name_loc10 = "DELETE ME" WHERE id = 495;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Aldeia Muralha Verde" WHERE id = 496;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Casarão do Pantanal Iluminado" WHERE id = 497;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Antro do Dinossangue" WHERE id = 498;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Caverna Névoa Negra" WHERE id = 499;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cabo Moggle" WHERE id = 500;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Destroços de Beezil" WHERE id = 501;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Morro das Bruxas" WHERE id = 502;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pontal de Vigília" WHERE id = 503;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Torre Norte" WHERE id = 504;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Torre Oeste" WHERE id = 505;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Posto Perdido" WHERE id = 506;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Charneca Azul" WHERE id = 507;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas Pedramalho" WHERE id = 508;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Antro das Chamas" WHERE id = 509;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Draconumbra" WHERE id = 510;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pântano da Serpe" WHERE id = 511;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Onyxia's Lair UNUSED" WHERE id = 512;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ilha Theramore" WHERE id = 513;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cidadela do Esteio" WHERE id = 514;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Prisão Encouraçado" WHERE id = 515;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Baía de Vadeoso" WHERE id = 516;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Enseada da Fúria das Marés" WHERE id = 517;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Costa Tenebrosa" WHERE id = 518;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Quinta dos Aguiar" WHERE id = 536;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pico Penacho de Fogo" WHERE id = 537;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Poços de Piche Lakkari" WHERE id = 538;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Terroral" WHERE id = 539;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fenda Coleante" WHERE id = 540;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Refúgio do Marshal" WHERE id = 541;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pedra do Limo" WHERE id = 542;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fontes Termais Golakka" WHERE id = 543;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Loch" WHERE id = 556;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Refúgio dos Mendigos" WHERE id = 576;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cemitério dos Kodos" WHERE id = 596;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Entreposto do Espírito que Anda" WHERE id = 597;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Praia de Sar'theris" WHERE id = 598;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fortaleza Machado do Trovão" WHERE id = 599;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Covil do Bolgan" WHERE id = 600;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas de Mannoroc" WHERE id = 602;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Sargeron" WHERE id = 603;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Aldeia Magram" WHERE id = 604;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Aldeia Gelkis" WHERE id = 606;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale das Lanças" WHERE id = 607;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Posto do Nijel" WHERE id = 608;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Aldeia Kolkar" WHERE id = 609;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Hyjal" WHERE id = 616;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Hibérnia" WHERE id = 618;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rio Lobonegro" WHERE id = 636;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rocha dos Kodos" WHERE id = 637;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Caminho Oculto" WHERE id = 638;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rocha dos Espíritos" WHERE id = 639;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Altar da Chama Latente" WHERE id = 640;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago Eluna'ara" WHERE id = 656;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Refúgio" WHERE id = 657;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Terralém" WHERE id = 676;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Craftsmen's Terrace UNUSED" WHERE id = 696;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Tradesmen's Terrace UNUSED" WHERE id = 697;
UPDATE `AreaTable_vanilla` SET name_loc10 = "The Temple Gardens UNUSED" WHERE id = 698;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Temple of Elune UNUSED" WHERE id = 699;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cenarion Enclave UNUSED" WHERE id = 700;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Warrior's Terrace UNUSED" WHERE id = 701;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vila de Rut'theran" WHERE id = 702;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Complexo de Bandaferro" WHERE id = 716;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Cárcere" WHERE id = 717;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Caverna Ululante" WHERE id = 718;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Profundezas Negras" WHERE id = 719;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ilha da Peleja" WHERE id = 720;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Gnomeregan" WHERE id = 721;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Urzal dos Mortos" WHERE id = 722;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ravina de Ban'ethil" WHERE id = 736;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Monastério Escarlate" WHERE id = 796;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ancoradouro de Jerod" WHERE id = 797;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Torre Serrana" WHERE id = 798;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Margem Escurecida" WHERE id = 799;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Caminho de Cristálgida" WHERE id = 800;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale Brisa Álgida" WHERE id = 801;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cordilheira Cintilante" WHERE id = 802;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rancho Ambarmanso" WHERE id = 803;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Montes Túndricos" WHERE id = 804;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Desfiladeiro do Portão Sul" WHERE id = 805;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Posto de Guarda do Portão Sul" WHERE id = 806;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Desfiladeiro do Portão Norte" WHERE id = 807;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Posto de Guarda do Portão Norte" WHERE id = 808;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Portões de Altaforja" WHERE id = 809;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lagoa das Águas Paradas" WHERE id = 810;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale do Pesadelo" WHERE id = 811;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale Veneracnídeo" WHERE id = 812;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Baluarte" WHERE id = 813;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rio Furiaustral" WHERE id = 814;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rio Furiaustral" WHERE id = 815;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Terras Crinavalha" WHERE id = 816;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rocha da Caveira" WHERE id = 817;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rochedo Jubalba" WHERE id = 818;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Serra Ventofúria" WHERE id = 819;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Planícies Douradas" WHERE id = 820;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Morros Ondulantes" WHERE id = 821;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Dun Algaz" WHERE id = 836;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Dun Algaz" WHERE id = 837;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Desfiladeiro do Portão Norte" WHERE id = 838;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Desfiladeiro do Portão Sul" WHERE id = 839;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Bosque do Crepúsculo" WHERE id = 856;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ilha dos MJs" WHERE id = 876;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Delete ME" WHERE id = 877;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rio Furiaustral" WHERE id = 878;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rio Furiaustral" WHERE id = 879;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ponte Thandol" WHERE id = 880;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ponte Thandol" WHERE id = 881;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ilha da Purgação" WHERE id = 896;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Sítio dos Jansen" WHERE id = 916;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Alqueire Morto" WHERE id = 917;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fazenda dos Peçanha" WHERE id = 918;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago Stendel" WHERE id = 919;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Os Obeliscos" WHERE id = 920;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Recanto de Demont" WHERE id = 921;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Planícies do Pó" WHERE id = 922;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale Lascapedra" WHERE id = 923;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale dos Reis" WHERE id = 924;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Estação Algaz" WHERE id = 925;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fazenda dos Bucklebree" WHERE id = 926;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Margem Brilhante" WHERE id = 927;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Atracadouro da Maré do Norte" WHERE id = 928;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Serra Garracinza" WHERE id = 936;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Campos Verdejantes" WHERE id = 956;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Geringontzan" WHERE id = 976;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Porto de Bondebico" WHERE id = 977;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Zul'Farrak" WHERE id = 978;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Posto Silitriste" WHERE id = 979;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale Moitagulhas" WHERE id = 980;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fenda Hazzali" WHERE id = 981;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Covil Nóxio" WHERE id = 982;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Complexo Dunamalho" WHERE id = 983;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas de Lunaleste" WHERE id = 984;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Campo das Minas d'Água" WHERE id = 985;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Covil de Zalashji" WHERE id = 986;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Praia do Fim do Mundo" WHERE id = 987;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Praia das Sete Ondas" WHERE id = 988;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Uldum" WHERE id = 989;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale dos Vigilantes" WHERE id = 990;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Posto de Gunstan" WHERE id = 991;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas de Lunassul" WHERE id = 992;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Acampamento dos Laceradores" WHERE id = 996;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale dos Laceradores" WHERE id = 997;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rocha dos Laceradores" WHERE id = 998;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Torre Mirante de Pedra" WHERE id = 999;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale Galardell" WHERE id = 1000;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Estrada Beira-lago" WHERE id = 1001;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Três Caminhos" WHERE id = 1002;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Monte Umbraforja" WHERE id = 1016;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Serra dos Raptores" WHERE id = 1017;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pântano do Canal Negro" WHERE id = 1018;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Zona Verde" WHERE id = 1019;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Charco Pelemusgo" WHERE id = 1020;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rocha de Thelgen" WHERE id = 1021;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pântano Peixeazul" WHERE id = 1022;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale Espuma de Sal" WHERE id = 1023;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pântano do Ocaso" WHERE id = 1024;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Zona Verde" WHERE id = 1025;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Acampamento Presirada" WHERE id = 1036;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Grim Batol" WHERE id = 1037;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Portões Presa do Dragão" WHERE id = 1038;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Frota Perdida" WHERE id = 1039;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Monte das Flechas" WHERE id = 1056;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Muralha de Thoradin" WHERE id = 1057;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Passagem Tramateia" WHERE id = 1076;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Margem Silenciada" WHERE id = 1097;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Casarão dos Brumanto" WHERE id = 1098;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Aldeia Mojache" WHERE id = 1099;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Complexo do Temível Totem" WHERE id = 1100;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Profundeza Atormentada" WHERE id = 1101;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago Vento Selvagem" WHERE id = 1102;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Assentamento Gordunni" WHERE id = 1103;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mok'Gordun" WHERE id = 1104;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale dos Abomináveis" WHERE id = 1105;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Planalto Esfiapluma" WHERE id = 1106;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago Soprocioso" WHERE id = 1107;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Costa Esquecida" WHERE id = 1108;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pilar Leste" WHERE id = 1109;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pilar Oeste" WHERE id = 1110;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ramo de Morfeu" WHERE id = 1111;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago Jademir" WHERE id = 1112;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Oneiros" WHERE id = 1113;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas dos Ventos Corvejantes" WHERE id = 1114;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Bastilha Cortifúria" WHERE id = 1115;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Domínio de Plumaluna" WHERE id = 1116;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas de Solarsal" WHERE id = 1117;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lower Wilds UNUSED" WHERE id = 1118;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Colossos Gêmeos" WHERE id = 1119;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ilha de Sardor" WHERE id = 1120;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ilha do Medo" WHERE id = 1121;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Selva Alta" WHERE id = 1136;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Baixio Selvagem" WHERE id = 1137;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Sertões Meridionais" WHERE id = 1156;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Estrada do Ouro Sul" WHERE id = 1157;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Zul'Farrak" WHERE id = 1176;
UPDATE `AreaTable_vanilla` SET name_loc10 = "UNUSEDAlcaz Island" WHERE id = 1196;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Domínio dos Presamatos" WHERE id = 1216;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Acampamento Vanndir" WHERE id = 1217;
UPDATE `AreaTable_vanilla` SET name_loc10 = "TESTAzshara" WHERE id = 1218;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Assentamento Legash" WHERE id = 1219;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Base Darnassiana" WHERE id = 1220;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas de Eldarath" WHERE id = 1221;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ninho de Hetaera" WHERE id = 1222;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Templo de Zin-Malor" WHERE id = 1223;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Campo dos Ursos" WHERE id = 1224;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ursolan" WHERE id = 1225;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Templo de Arkkoran" WHERE id = 1226;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Baía das Tempestades" WHERE id = 1227;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Areal Despedaçado" WHERE id = 1228;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Torre de Eldara" WHERE id = 1229;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Costa Rasgada" WHERE id = 1230;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Praia do Recife Sul" WHERE id = 1231;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Monumento a Cristacorvo" WHERE id = 1232;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cordilheira Esquecida" WHERE id = 1233;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago Mennar" WHERE id = 1234;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ermida Cantonegro" WHERE id = 1235;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Assentamento Haldarr" WHERE id = 1236;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Valormok" WHERE id = 1237;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Profundezas Devastadas" WHERE id = 1256;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Túnel Garracava" WHERE id = 1276;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Túnel Garracava" WHERE id = 1277;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fazenda Petradente" WHERE id = 1296;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fazenda do Beberrão" WHERE id = 1297;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Urzal dos Mortos" WHERE id = 1316;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Enseada do Armador Perdido" WHERE id = 1336;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Uldaman" WHERE id = 1337;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Espelho de Lordaeron" WHERE id = 1338;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Espelho de Lordaeron" WHERE id = 1339;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Canto da Forca" WHERE id = 1357;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Silithus" WHERE id = 1377;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Floresta Esmeralda" WHERE id = 1397;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Templo Submerso" WHERE id = 1417;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Domínio de Malhorrendo" WHERE id = 1437;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Bastilha de Etergarde" WHERE id = 1438;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Posto Malhorrendo" WHERE id = 1439;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cavernas Serpeantes" WHERE id = 1440;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Altar das Tempestades" WHERE id = 1441;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cerro da Sentinela de Fogo" WHERE id = 1442;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fosso de Lava" WHERE id = 1443;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mar de Cinzas" WHERE id = 1444;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Montanha Rocha Negra" WHERE id = 1445;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Posto de Tório" WHERE id = 1446;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Armaria da Guarnição" WHERE id = 1457;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Templo de Atal'Hakkar" WHERE id = 1477;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cidade Baixa" WHERE id = 1497;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Uldaman" WHERE id = 1517;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Not Used Deadmines" WHERE id = 1518;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ventobravo" WHERE id = 1519;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Altaforja" WHERE id = 1537;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Castelo do Casco Fendido" WHERE id = 1557;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cabo do Espinhaço" WHERE id = 1577;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Costa Selvagem Sul" WHERE id = 1578;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Unused The Deadmines 002" WHERE id = 1579;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Unused Ironclad Cove 003" WHERE id = 1580;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Minas Mortas" WHERE id = 1581;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Covil Encouraçado" WHERE id = 1582;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pico da Rocha Negra" WHERE id = 1583;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Abismo Rocha Negra" WHERE id = 1584;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Raptor Grounds UNUSED" WHERE id = 1597;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Grol'dom Farm UNUSED" WHERE id = 1598;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Campo-base Mor'shan" WHERE id = 1599;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Honor's Stand UNUSED" WHERE id = 1600;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Blackthorn Ridge UNUSED" WHERE id = 1601;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Bramblescar UNUSED" WHERE id = 1602;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Agama'gor UNUSED" WHERE id = 1603;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale dos Heróis" WHERE id = 1617;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Orgrimmar" WHERE id = 1637;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Penhasco do Trovão" WHERE id = 1638;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Platô dos Anciãos" WHERE id = 1639;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Platô dos Espíritos" WHERE id = 1640;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Platô dos Caçadores" WHERE id = 1641;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Darnassus" WHERE id = 1657;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Enclave Cenariano" WHERE id = 1658;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Terraço dos Artesãos" WHERE id = 1659;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Terraço dos Guerreiros" WHERE id = 1660;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Jardins do Templo" WHERE id = 1661;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Terraço dos Mercadores" WHERE id = 1662;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Promontório de Gavin" WHERE id = 1677;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Promontório de Sofera" WHERE id = 1678;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Adaga de Corrahn" WHERE id = 1679;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Terralta" WHERE id = 1680;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Costa da Bruma" WHERE id = 1681;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Nicho de Dandred" WHERE id = 1682;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Caverna Rugido" WHERE id = 1683;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Morro do Ventogelante" WHERE id = 1684;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Terra dos Raptores" WHERE id = 1697;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Espinheira" WHERE id = 1698;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Morro dos Espinhos" WHERE id = 1699;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Agama'gor" WHERE id = 1700;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Serra de Abrunhal" WHERE id = 1701;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Posto da Honra" WHERE id = 1702;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Paliçada Mor'shan" WHERE id = 1703;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fazenda Grol'dom" WHERE id = 1704;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Urzal dos Tuscos" WHERE id = 1717;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Grande Elevador" WHERE id = 1718;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale da Névoa" WHERE id = 1737;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Olho-d'água Nek'mani" WHERE id = 1738;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Complexo da Vela Sangrenta" WHERE id = 1739;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Base da Empreendimentos S.A." WHERE id = 1740;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Arena de Gurubashi" WHERE id = 1741;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Covil dos Espíritos" WHERE id = 1742;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Véu Carmesim" WHERE id = 1757;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Rasgamar" WHERE id = 1758;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Sorte da Donzela" WHERE id = 1759;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Centro de Operações da Empreendimentos S.A." WHERE id = 1760;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vila da Lenha Morta" WHERE id = 1761;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Aldeia Patavil" WHERE id = 1762;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Jaedenar" WHERE id = 1763;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rio Peçonha" WHERE id = 1764;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Salto da Peçonha" WHERE id = 1765;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale das Escaras Pungentes" WHERE id = 1766;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Floresta Ferrárbol" WHERE id = 1767;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Caverna Ferrárbol" WHERE id = 1768;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Domínio dos Presamatos" WHERE id = 1769;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fortaleza do Concílio das Sombras" WHERE id = 1770;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Santuário do Embusteiro" WHERE id = 1771;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Caverna de Itharius" WHERE id = 1777;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Penumbra das Mágoas" WHERE id = 1778;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vila Draenil'dur" WHERE id = 1779;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Entroncamento da Lança Lascada" WHERE id = 1780;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pantanal dos Cervos" WHERE id = 1797;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lodaçal Mutante" WHERE id = 1798;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Caverna Pantanal dos Cervos" WHERE id = 1817;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Caverna Cascasseca" WHERE id = 1837;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Muralha de Thoradin" WHERE id = 1857;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pedre'gor" WHERE id = 1858;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale das Presas" WHERE id = 1877;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Terrasseca" WHERE id = 1878;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Chapada da Ilusão" WHERE id = 1879;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Casa de Barbapena" WHERE id = 1880;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Alambique do Borracho" WHERE id = 1881;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Trilha da Névoa Pestilenta" WHERE id = 1882;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago Valovento" WHERE id = 1883;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Agol'watha" WHERE id = 1884;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Hiri'watha" WHERE id = 1885;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruína Assustadora" WHERE id = 1886;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Covil do Bogen" WHERE id = 1887;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Terraço do Criador" WHERE id = 1897;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ravina de Sopravento" WHERE id = 1898;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Shaol'watha" WHERE id = 1917;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas da Sombrassolar" WHERE id = 1937;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pilar Partido" WHERE id = 1938;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Areias Abissais" WHERE id = 1939;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Costa Quebra-sul" WHERE id = 1940;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cavernas do Tempo" WHERE id = 1941;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Os Pântanos" WHERE id = 1942;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Platô Petraferro" WHERE id = 1943;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Caverna Calcinar" WHERE id = 1957;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Acampamento Curtume" WHERE id = 1958;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale Calcinado" WHERE id = 1959;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Zul'Gurub" WHERE id = 1977;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Posto Brumalga" WHERE id = 1978;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Posto Peçonha" WHERE id = 1997;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Clareira da Galhaça" WHERE id = 1998;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Stratholme" WHERE id = 2017;
UPDATE `AreaTable_vanilla` SET name_loc10 = "UNUSEDShadowfang Keep 003" WHERE id = 2037;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Scolomântia" WHERE id = 2057;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale do Crepúsculo" WHERE id = 2077;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Costa do Crepúsculo" WHERE id = 2078;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ilha Alcaz" WHERE id = 2079;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pináculo da Nuvem Negra" WHERE id = 2097;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Catacumbas do Bosque da Aurora" WHERE id = 2098;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Bastilha Mirante de Pedra" WHERE id = 2099;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Maraudon" WHERE id = 2100;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Estalagem Pilsen" WHERE id = 2101;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Destilaria Cervaforte" WHERE id = 2102;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Bastilha Menethil" WHERE id = 2103;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Taberna Aguafunda" WHERE id = 2104;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Sepulcro Sombrio" WHERE id = 2117;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Prefeitura de Montalvo" WHERE id = 2118;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Taberna Finda Forca" WHERE id = 2119;
UPDATE `AreaTable_vanilla` SET name_loc10 = "The Pools of VisionUNUSED" WHERE id = 2137;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Covil de Brumedo" WHERE id = 2138;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Bastilha Bael'Dun" WHERE id = 2157;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Covil de Ardeluta" WHERE id = 2158;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Covil da Onyxia" WHERE id = 2159;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mina Cortavento" WHERE id = 2160;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Descanso de Rolando" WHERE id = 2161;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ringue de Batalha" WHERE id = 2177;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Poços das Visões" WHERE id = 2197;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ravina da Sombra Partida" WHERE id = 2198;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vila da Lança Partida" WHERE id = 2217;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Posto Confinalvo" WHERE id = 2237;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Górnia" WHERE id = 2238;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cratera Olho do Zane" WHERE id = 2239;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Circuito da Ilusão" WHERE id = 2240;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pedra Sabre-de-gelo" WHERE id = 2241;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Bosque Oculto" WHERE id = 2242;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Posto Presamatos" WHERE id = 2243;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Aldeia dos Invernosos" WHERE id = 2244;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mazthoril" WHERE id = 2245;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fontes Termais de Fogofrio" WHERE id = 2246;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Serra Cardo de Gelo" WHERE id = 2247;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Dun Mandarr" WHERE id = 2248;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Garganta dos Sussurros Gelados" WHERE id = 2249;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Matagal da Asa da Coruja" WHERE id = 2250;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago Kel'Theril" WHERE id = 2251;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas de Kel'Theril" WHERE id = 2252;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Aldeia Chuva Estelar" WHERE id = 2253;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Gruta de Ban'Thallow" WHERE id = 2254;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Visteterna" WHERE id = 2255;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Garganta do Sussurro Sombrio" WHERE id = 2256;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Metrô Correfundo" WHERE id = 2257;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale Fungi" WHERE id = 2258;
UPDATE `AreaTable_vanilla` SET name_loc10 = "UNUSEDThe Marris Stead" WHERE id = 2259;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Sítio dos Marris" WHERE id = 2260;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Chácara Secreta" WHERE id = 2261;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vila das Flechas" WHERE id = 2262;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Torre da Coroa" WHERE id = 2263;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cruzamento de Corin" WHERE id = 2264;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Base de Operações Escarlate" WHERE id = 2265;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Manopla de Tyr" WHERE id = 2266;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Basílica Escarlate" WHERE id = 2267;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Capela Esperança da Luz" WHERE id = 2268;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Engenho Assombrado" WHERE id = 2269;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Clareira Nociva" WHERE id = 2270;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Torre da Muralha Leste" WHERE id = 2271;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vilarejo do Norte" WHERE id = 2272;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Zul'Mashar" WHERE id = 2273;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mazra'Alor" WHERE id = 2274;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Torre do Passo Norte" WHERE id = 2275;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Abrigo Quel'Lithien" WHERE id = 2276;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Bosque Pestilento" WHERE id = 2277;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fortaleza do Flagelo" WHERE id = 2278;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Stratholme" WHERE id = 2279;
UPDATE `AreaTable_vanilla` SET name_loc10 = "UNUSED Stratholme" WHERE id = 2280;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago das Flechas" WHERE id = 2297;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Castro das Flechas" WHERE id = 2298;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago das Flechas" WHERE id = 2299;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cavernas do Tempo" WHERE id = 2300;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Aldeia dos Pelocardo" WHERE id = 2301;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Atoleiro" WHERE id = 2302;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Garganta do Quebravento" WHERE id = 2303;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mares do Sul" WHERE id = 2317;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Grande Oceano" WHERE id = 2318;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Grande Oceano" WHERE id = 2319;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Grande Oceano" WHERE id = 2320;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Grande Oceano" WHERE id = 2321;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mar Velado" WHERE id = 2322;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mar Velado" WHERE id = 2323;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mar Velado" WHERE id = 2324;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mar Velado" WHERE id = 2325;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mar Velado" WHERE id = 2326;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Guarnição do Monte Navalha" WHERE id = 2337;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mares do Sul" WHERE id = 2338;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Grande Oceano" WHERE id = 2339;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Aldeia Dente Sangrento" WHERE id = 2357;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cantilenda" WHERE id = 2358;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Aldeia Pataverde" WHERE id = 2359;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Posto Avançado Asa de Prata" WHERE id = 2360;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Refúgio Noturno" WHERE id = 2361;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Santuário de Remulos" WHERE id = 2362;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Templos de Tempesfúria" WHERE id = 2363;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Grande Oceano" WHERE id = 2364;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Grande Oceano" WHERE id = 2365;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lamaçal Negro" WHERE id = 2366;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Antigo Contraforte de Eira dos Montes" WHERE id = 2367;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Serraria Tarren" WHERE id = 2368;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Costa Sul" WHERE id = 2369;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Forte do Desterro" WHERE id = 2370;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Dun Garok" WHERE id = 2371;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Campos de Eira dos Montes" WHERE id = 2372;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Praia Oriental" WHERE id = 2373;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Sítio de Nethander" WHERE id = 2374;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Monte das Flechas" WHERE id = 2375;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Torre do Sul" WHERE id = 2376;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Muralha de Thoradin" WHERE id = 2377;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Praia Ocidental" WHERE id = 2378;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mina Veioazul" WHERE id = 2379;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Grande Oceano" WHERE id = 2397;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Grande Oceano" WHERE id = 2398;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Grande Oceano" WHERE id = 2399;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Mar Proibido" WHERE id = 2400;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Mar Proibido" WHERE id = 2401;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Mar Proibido" WHERE id = 2402;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Mar Proibido" WHERE id = 2403;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Tethris Aran" WHERE id = 2404;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ethel Rethor" WHERE id = 2405;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ilha Ranazjar" WHERE id = 2406;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Barraco do Kormek" WHERE id = 2407;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Aldeia Pescassombra" WHERE id = 2408;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Estreito Rocha Negra" WHERE id = 2417;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vigia de Morgan" WHERE id = 2418;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rocha Coleante" WHERE id = 2419;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale Asa do Terror" WHERE id = 2420;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Draco'dar" WHERE id = 2421;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cavernas Ígneas" WHERE id = 2437;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Floresta Noturcanto" WHERE id = 2457;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mar Velado" WHERE id = 2477;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Morlos'Aran" WHERE id = 2478;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Santuário Esmeralda" WHERE id = 2479;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Grota Flamejade" WHERE id = 2480;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas de Constellas" WHERE id = 2481;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Confins Amargos" WHERE id = 2497;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cerro do Profanador" WHERE id = 2517;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pavilhão Lariss" WHERE id = 2518;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Serra dos Patábua" WHERE id = 2519;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Covil dos Patábua" WHERE id = 2520;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rio Verdantis" WHERE id = 2521;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas de Isildien" WHERE id = 2522;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Aldeia do Temível Totem" WHERE id = 2537;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Aldeia Apareje" WHERE id = 2538;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Malaka'jin" WHERE id = 2539;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ravina da Avalanche" WHERE id = 2540;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Desfiladeiro Sishir" WHERE id = 2541;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Gládio Cruel" WHERE id = 2557;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Garganta do Vento Morto" WHERE id = 2558;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rio Diamante" WHERE id = 2559;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Acampamento de Ariden" WHERE id = 2560;
UPDATE `AreaTable_vanilla` SET name_loc10 = "A Garra" WHERE id = 2561;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Karazhan" WHERE id = 2562;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Terreno de Morgan" WHERE id = 2563;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Gládio Cruel" WHERE id = 2577;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale Alterac" WHERE id = 2597;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Acampamento do Rabiscafuso" WHERE id = 2617;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Aldeia Flamejade" WHERE id = 2618;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rio Thondroril" WHERE id = 2619;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rio Thondroril" WHERE id = 2620;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago Mereldar" WHERE id = 2621;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cicatriz Pestilenta" WHERE id = 2622;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fenda Infectis" WHERE id = 2623;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Lago Bosquenero" WHERE id = 2624;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Portão da Muralha Leste" WHERE id = 2625;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Túnel Terrorteia" WHERE id = 2626;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Várzea do Medo" WHERE id = 2627;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Bastilha Karrathia" WHERE id = 2637;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale dos Ossos" WHERE id = 2657;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Covil Asa Negra" WHERE id = 2677;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Encruzilhada do Defunto" WHERE id = 2697;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Núcleo Derretido" WHERE id = 2717;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Muralha do Escaravelho" WHERE id = 2737;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vila do Vento Sul" WHERE id = 2738;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Acampamento do Crepúsculo" WHERE id = 2739;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale de Cristal" WHERE id = 2740;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Palanque do Escaravelho" WHERE id = 2741;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Colme'Ashi" WHERE id = 2742;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Colme'Zora" WHERE id = 2743;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Colme'Régia" WHERE id = 2744;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Altar do Guerreiro Caído" WHERE id = 2757;
UPDATE `AreaTable_vanilla` SET name_loc10 = "UNUSED Alterac Valley" WHERE id = 2777;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Profundezas Negras" WHERE id = 2797;
UPDATE `AreaTable_vanilla` SET name_loc10 = "***On Map Dungeon***" WHERE id = 2817;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Porão do Senhorio" WHERE id = 2837;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Galeria Lapidada" WHERE id = 2838;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Vale Alterac" WHERE id = 2839;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Jaula Troante" WHERE id = 2857;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Teste de Chunk" WHERE id = 2877;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Assentamento Zoram'gar" WHERE id = 2897;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Salão dos Lendários" WHERE id = 2917;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Salão dos Campeões" WHERE id = 2918;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Complexo Grosh'gok" WHERE id = 2937;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Garganta Adormecida" WHERE id = 2938;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mina Ferrofundo" WHERE id = 2957;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Posto Avançado Larpétreo" WHERE id = 2958;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Dun Baldar" WHERE id = 2959;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Desfiladeiro Asálgida" WHERE id = 2960;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Aldeia Lobo do Gelo" WHERE id = 2961;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Torre do Pontal" WHERE id = 2962;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mina Dentefrio" WHERE id = 2963;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fortaleza Invernacha" WHERE id = 2964;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Guarnição Sanguefrio" WHERE id = 2977;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Bastilha Lobo do Gelo" WHERE id = 2978;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fazenda Tor'kren" WHERE id = 2979;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Desfiladeiro Punhal de Gelo" WHERE id = 3017;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Acampamento Petraferro" WHERE id = 3037;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cratera do Furão" WHERE id = 3038;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas de Tahonda" WHERE id = 3039;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Campo de Disputa" WHERE id = 3057;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Caverna Asálgida" WHERE id = 3058;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Repouso dos Valorosos" WHERE id = 3077;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pilar Enxameante" WHERE id = 3097;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Posto Crepúsculo" WHERE id = 3098;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Posto Avançado do Crepúsculo" WHERE id = 3099;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Acampamento Arrasado do Crepúsculo" WHERE id = 3100;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Covil de Shalzaru" WHERE id = 3117;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Campo Talrendis" WHERE id = 3137;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Sacrário de Rethress" WHERE id = 3138;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Antro Lunorror" WHERE id = 3139;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Caverna do Barbescama" WHERE id = 3140;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Caverna da Avalanche" WHERE id = 3157;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Campo de Trabalho Brado Guerreiro" WHERE id = 3177;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Acampamento Ventogelante" WHERE id = 3197;
UPDATE `AreaTable_vanilla` SET name_loc10 = "A Arena" WHERE id = 3217;
UPDATE `AreaTable_vanilla` SET name_loc10 = "The Maul UNUSED" WHERE id = 3237;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ossos de Grakkarond" WHERE id = 3257;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ravina Brado Guerreiro" WHERE id = 3277;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cemitério Lobo do Gelo" WHERE id = 3297;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Desfiladeiro Lobo do Gelo" WHERE id = 3298;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Desfiladeiro de Dun Baldar" WHERE id = 3299;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cemitério Sanguefrio" WHERE id = 3300;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cemitério Nevado" WHERE id = 3301;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cemitério Larpétreo" WHERE id = 3302;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cemitério Lançatroz" WHERE id = 3303;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Casamata Asálgida" WHERE id = 3304;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Casamata Larpétreo" WHERE id = 3305;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cordilheira Garragreste" WHERE id = 3306;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Aldeia Revatusco" WHERE id = 3317;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Rocha de Durotan" WHERE id = 3318;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Bosque Asa de Prata" WHERE id = 3319;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Serraria Brado Guerreiro" WHERE id = 3320;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Castelo Asa de Prata" WHERE id = 3321;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Caverna Garragreste" WHERE id = 3337;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fenda Oculta" WHERE id = 3338;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ilha Yojamba" WHERE id = 3357;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Bacia Arathi" WHERE id = 3358;
UPDATE `AreaTable_vanilla` SET name_loc10 = "A Espiral" WHERE id = 3377;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Altar de Hir'eek" WHERE id = 3378;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Shadra'zaar" WHERE id = 3379;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Terras Hakkari" WHERE id = 3380;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cerne de Shirvallah" WHERE id = 3381;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Templo de Bethekk" WHERE id = 3382;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fossa Rubrofogo" WHERE id = 3383;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Altar do Deus Sangrento" WHERE id = 3384;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Terraço de Zanza" WHERE id = 3397;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Beira da Loucura" WHERE id = 3398;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Salão dos Matatroll" WHERE id = 3417;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Covil do Profanador" WHERE id = 3418;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Pontal do Pagle" WHERE id = 3419;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Fazenda" WHERE id = 3420;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ferraria" WHERE id = 3421;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Serraria" WHERE id = 3422;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mina de Ouro" WHERE id = 3423;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Estábulos" WHERE id = 3424;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Forte Cenariano" WHERE id = 3425;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Posto Guenelmo" WHERE id = 3426;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Acampamento Barbabronze" WHERE id = 3427;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ahn'Qiraj" WHERE id = 3428;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas de Ahn'Qiraj" WHERE id = 3429;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Passeio do Crepúsculo" WHERE id = 3446;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Esconderijo de Ortell" WHERE id = 3447;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Terraço dos Escaravelhos" WHERE id = 3448;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Terraço do General" WHERE id = 3449;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Reservatório" WHERE id = 3450;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Incubadora" WHERE id = 3451;
UPDATE `AreaTable_vanilla` SET name_loc10 = "O Cortiço" WHERE id = 3452;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Terraço dos Vigilantes" WHERE id = 3453;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Ruínas de Ahn'Qiraj" WHERE id = 3454;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Naxxramas" WHERE id = 3456;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Cidade" WHERE id = 3459;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Portões de Ahn'Qiraj" WHERE id = 3478;
UPDATE `AreaTable_vanilla` SET name_loc10 = "Mansão de Corvoforte" WHERE id = 3486;
DROP TABLE IF EXISTS `WorldMapOverlay_turtle`;
CREATE TABLE `WorldMapOverlay_turtle` (
`areaID` smallint(3) unsigned NOT NULL,
`zoneID` smallint(3) unsigned NOT NULL,
`texture` varchar(255),
`textureWidth` smallint(3) unsigned NOT NULL,
`textureHeight` smallint(3) unsigned NOT NULL,
`offsetX` smallint(3) unsigned NOT NULL,
`offsetY` smallint(3) unsigned NOT NULL,
`hitRectTop` smallint(3) unsigned NOT NULL,
`hitRectLeft` smallint(3) unsigned NOT NULL,
`hitRectBottom` smallint(3) unsigned NOT NULL,
`hitRectRight` smallint(3) unsigned NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED COMMENT='WorldMapOverlay';

INSERT INTO `WorldMapOverlay_turtle` VALUES (9, 30, "NORTHSHIREVALLEY", 256, 256, 381, 147, 190, 425, 375, 600);
INSERT INTO `WorldMapOverlay_turtle` VALUES (18, 30, "CRYSTALLAKE", 225, 220, 422, 332, 380, 450, 475, 605);
INSERT INTO `WorldMapOverlay_turtle` VALUES (19, 37, "ZULGURUB", 245, 220, 483, 8, 50, 525, 200, 675);
INSERT INTO `WorldMapOverlay_turtle` VALUES (20, 39, "MOONBROOK", 220, 200, 317, 331, 370, 390, 505, 495);
INSERT INTO `WorldMapOverlay_turtle` VALUES (35, 37, "BOOTYBAY", 145, 128, 203, 433, 460, 220, 530, 305);
INSERT INTO `WorldMapOverlay_turtle` VALUES (37, 37, "LAKENAZFERITI", 128, 125, 331, 59, 100, 375, 150, 435);
INSERT INTO `WorldMapOverlay_turtle` VALUES (42, 34, "DARKSHIRE", 315, 280, 631, 162, 250, 710, 350, 835);
INSERT INTO `WorldMapOverlay_turtle` VALUES (43, 37, "WILDSHORE", 165, 190, 229, 422, 505, 300, 555, 350);
INSERT INTO `WorldMapOverlay_turtle` VALUES (57, 30, "FARGODEEPMINE", 256, 240, 238, 428, 510, 300, 615, 470);
INSERT INTO `WorldMapOverlay_turtle` VALUES (60, 30, "FORESTSEDGE", 256, 341, 124, 327, 445, 200, 645, 300);
INSERT INTO `WorldMapOverlay_turtle` VALUES (62, 30, "BRACKWELLPUMPKINPATCH", 256, 249, 577, 419, 495, 615, 565, 735);
INSERT INTO `WorldMapOverlay_turtle` VALUES (68, 36, "LAKEEVERSTILL", 535, 275, 133, 240, 325, 245, 465, 595);
INSERT INTO `WorldMapOverlay_turtle` VALUES (69, 36, "LAKESHIRE", 340, 195, 83, 197, 250, 165, 330, 345);
INSERT INTO `WorldMapOverlay_turtle` VALUES (70, 36, "STONEWATCH", 255, 300, 500, 215, 300, 595, 435, 730);
INSERT INTO `WorldMapOverlay_turtle` VALUES (71, 36, "STONEWATCHFALLS", 320, 210, 595, 320, 405, 655, 490, 840);
INSERT INTO `WorldMapOverlay_turtle` VALUES (72, 19, "DARKPORTAL", 265, 220, 453, 259, 325, 520, 430, 650);
INSERT INTO `WorldMapOverlay_turtle` VALUES (73, 19, "THETAINTEDSCAR", 384, 450, 212, 178, 295, 265, 540, 495);
INSERT INTO `WorldMapOverlay_turtle` VALUES (74, 38, "POOLOFTEARS", 300, 275, 565, 218, 265, 620, 440, 805);
INSERT INTO `WorldMapOverlay_turtle` VALUES (75, 38, "STONARD", 360, 315, 279, 237, 300, 370, 435, 585);
INSERT INTO `WorldMapOverlay_turtle` VALUES (76, 38, "FALLOWSANCTUARY", 365, 305, 492, 0, 60, 540, 240, 765);
INSERT INTO `WorldMapOverlay_turtle` VALUES (86, 30, "STONECAIRNLAKE", 310, 256, 587, 190, 250, 675, 415, 830);
INSERT INTO `WorldMapOverlay_turtle` VALUES (87, 30, "GOLDSHIRE", 240, 220, 250, 270, 400, 370, 465, 455);
INSERT INTO `WorldMapOverlay_turtle` VALUES (88, 30, "EASTVALELOGGINGCAMP", 256, 210, 704, 330, 400, 775, 485, 900);
INSERT INTO `WorldMapOverlay_turtle` VALUES (91, 30, "TOWEROFAZORA", 255, 250, 551, 292, 400, 610, 490, 745);
INSERT INTO `WorldMapOverlay_turtle` VALUES (93, 34, "VULGOLOGREMOUND", 255, 285, 243, 348, 435, 285, 545, 440);
INSERT INTO `WorldMapOverlay_turtle` VALUES (94, 34, "RAVENHILL", 195, 145, 102, 302, 340, 155, 410, 260);
INSERT INTO `WorldMapOverlay_turtle` VALUES (95, 36, "REDRIDGECANYONS", 365, 245, 121, 72, 125, 175, 250, 400);
INSERT INTO `WorldMapOverlay_turtle` VALUES (97, 36, "ALTHERSMILL", 235, 270, 399, 129, 220, 475, 345, 595);
INSERT INTO `WorldMapOverlay_turtle` VALUES (99, 37, "REBELCAMP", 170, 90, 284, 0, 20, 335, 55, 415);
INSERT INTO `WorldMapOverlay_turtle` VALUES (100, 37, "NESINGWARYSEXPEDITION", 140, 110, 269, 26, 60, 305, 115, 380);
INSERT INTO `WorldMapOverlay_turtle` VALUES (101, 37, "KURZENSCOMPOUND", 155, 150, 388, 0, 35, 415, 90, 495);
INSERT INTO `WorldMapOverlay_turtle` VALUES (102, 37, "RUINSOFZULKUNDA", 125, 140, 196, 3, 55, 220, 110, 300);
INSERT INTO `WorldMapOverlay_turtle` VALUES (103, 37, "RUINSOFZULMAMWE", 170, 125, 394, 212, 250, 435, 315, 500);
INSERT INTO `WorldMapOverlay_turtle` VALUES (104, 37, "THEVILEREEF", 190, 175, 152, 90, 135, 180, 235, 305);
INSERT INTO `WorldMapOverlay_turtle` VALUES (105, 37, "MOSHOGGOGREMOUND", 128, 175, 432, 94, 160, 455, 240, 535);
INSERT INTO `WorldMapOverlay_turtle` VALUES (107, 39, "SALDEANSFARM", 225, 210, 459, 105, 180, 505, 255, 605);
INSERT INTO `WorldMapOverlay_turtle` VALUES (108, 39, "SENTINELHILL", 195, 240, 442, 241, 280, 515, 385, 605);
INSERT INTO `WorldMapOverlay_turtle` VALUES (109, 39, "FURLBROWSPUMPKINFARM", 210, 215, 387, 11, 100, 465, 185, 555);
INSERT INTO `WorldMapOverlay_turtle` VALUES (111, 39, "JANGOLODEMINE", 215, 215, 307, 29, 125, 405, 200, 490);
INSERT INTO `WorldMapOverlay_turtle` VALUES (113, 39, "GOLDCOASTQUARRY", 225, 256, 220, 102, 230, 255, 325, 375);
INSERT INTO `WorldMapOverlay_turtle` VALUES (115, 39, "WESTFALLLIGHTHOUSE", 280, 190, 205, 467, 530, 260, 620, 380);
INSERT INTO `WorldMapOverlay_turtle` VALUES (116, 38, "MISTYVALLEY", 245, 305, 0, 140, 190, 50, 290, 215);
INSERT INTO `WorldMapOverlay_turtle` VALUES (117, 37, "GROMGOLBASECAMP", 110, 105, 260, 132, 160, 285, 205, 350);
INSERT INTO `WorldMapOverlay_turtle` VALUES (118, 40, "WHELGARSEXCAVATIONSITE", 195, 185, 247, 205, 295, 310, 360, 410);
INSERT INTO `WorldMapOverlay_turtle` VALUES (121, 34, "TRANQUILGARDENSCEMETARY", 220, 220, 690, 353, 430, 755, 505, 850);
INSERT INTO `WorldMapOverlay_turtle` VALUES (122, 37, "ZUULDAIARUINS", 115, 115, 156, 42, 80, 190, 120, 235);
INSERT INTO `WorldMapOverlay_turtle` VALUES (123, 37, "BALALRUINS", 90, 80, 241, 92, 115, 270, 150, 320);
INSERT INTO `WorldMapOverlay_turtle` VALUES (125, 37, "KALAIRUINS", 95, 95, 299, 88, 120, 320, 160, 370);
INSERT INTO `WorldMapOverlay_turtle` VALUES (127, 37, "BALIAMAHRUINS", 110, 140, 371, 129, 185, 390, 230, 445);
INSERT INTO `WorldMapOverlay_turtle` VALUES (128, 37, "ZIATAJAIRUINS", 128, 125, 364, 231, 235, 385, 315, 430);
INSERT INTO `WorldMapOverlay_turtle` VALUES (129, 37, "MIZJAHRUINS", 105, 110, 311, 131, 180, 350, 215, 390);
INSERT INTO `WorldMapOverlay_turtle` VALUES (131, 27, "KHARANOS", 200, 200, 386, 294, 515, 445, 390, 555);
INSERT INTO `WorldMapOverlay_turtle` VALUES (132, 27, "ANVILMAR", 240, 185, 155, 403, 445, 190, 560, 340);
INSERT INTO `WorldMapOverlay_turtle` VALUES (133, 27, "GNOMERAGON", 180, 165, 166, 184, 215, 205, 295, 280);
INSERT INTO `WorldMapOverlay_turtle` VALUES (134, 27, "GOLBOLARQUARRY", 165, 165, 608, 291, 340, 640, 430, 735);
INSERT INTO `WorldMapOverlay_turtle` VALUES (135, 27, "FROSTMANEHOLD", 125, 125, 217, 287, 315, 260, 375, 305);
INSERT INTO `WorldMapOverlay_turtle` VALUES (136, 27, "THEGRIZZLEDDEN", 200, 185, 314, 311, 350, 380, 425, 440);
INSERT INTO `WorldMapOverlay_turtle` VALUES (137, 27, "BREWNALLVILLAGE", 115, 115, 252, 249, 275, 280, 340, 330);
INSERT INTO `WorldMapOverlay_turtle` VALUES (138, 27, "MISTYPINEREFUGE", 128, 165, 502, 221, 245, 545, 325, 605);
INSERT INTO `WorldMapOverlay_turtle` VALUES (142, 35, "IRONBANDSEXCAVATIONSITE", 345, 256, 482, 321, 380, 625, 495, 765);
INSERT INTO `WorldMapOverlay_turtle` VALUES (143, 35, "MOGROSHSTRONGHOLD", 315, 235, 542, 48, 105, 620, 230, 800);
INSERT INTO `WorldMapOverlay_turtle` VALUES (144, 35, "THELSAMAR", 256, 230, 217, 203, 265, 300, 350, 400);
INSERT INTO `WorldMapOverlay_turtle` VALUES (146, 35, "STONEWROUGHTDAM", 290, 175, 339, 11, 45, 380, 125, 580);
INSERT INTO `WorldMapOverlay_turtle` VALUES (147, 35, "THEFARSTRIDERLODGE", 370, 295, 546, 199, 380, 790, 460, 875);
INSERT INTO `WorldMapOverlay_turtle` VALUES (149, 35, "SILVERSTREAMMINE", 235, 270, 229, 11, 90, 290, 200, 400);
INSERT INTO `WorldMapOverlay_turtle` VALUES (150, 40, "MENETHILHARBOR", 175, 128, 13, 314, 345, 70, 415, 135);
INSERT INTO `WorldMapOverlay_turtle` VALUES (152, 20, "BULWARK", 230, 205, 698, 362, 380, 770, 550, 905);
INSERT INTO `WorldMapOverlay_turtle` VALUES (154, 20, "DEATHKNELL", 245, 205, 227, 328, 366, 279, 488, 411);
INSERT INTO `WorldMapOverlay_turtle` VALUES (156, 20, "SOLLIDENFARMSTEAD", 256, 156, 239, 250, 290, 284, 371, 437);
INSERT INTO `WorldMapOverlay_turtle` VALUES (157, 20, "AGAMANDMILLS", 256, 210, 335, 139, 183, 384, 303, 522);
INSERT INTO `WorldMapOverlay_turtle` VALUES (159, 20, "BRILL", 128, 158, 537, 299, 320, 560, 418, 635);
INSERT INTO `WorldMapOverlay_turtle` VALUES (160, 20, "MONASTARY", 211, 189, 746, 125, 144, 766, 295, 933);
INSERT INTO `WorldMapOverlay_turtle` VALUES (162, 20, "BRIGHTWATERLAKE", 201, 288, 587, 139, 165, 633, 398, 735);
INSERT INTO `WorldMapOverlay_turtle` VALUES (164, 20, "GARRENSHAUNT", 174, 220, 497, 145, 182, 531, 328, 627);
INSERT INTO `WorldMapOverlay_turtle` VALUES (165, 20, "BALNIRFARMSTEAD", 216, 179, 630, 326, 335, 664, 489, 795);
INSERT INTO `WorldMapOverlay_turtle` VALUES (166, 20, "COLDHEARTHMANOR", 150, 128, 474, 327, 365, 502, 436, 575);
INSERT INTO `WorldMapOverlay_turtle` VALUES (167, 20, "CRUSADEROUTPOST", 173, 128, 694, 289, 292, 708, 395, 853);
INSERT INTO `WorldMapOverlay_turtle` VALUES (172, 21, "FENRISISLE", 250, 215, 593, 74, 125, 625, 260, 815);
INSERT INTO `WorldMapOverlay_turtle` VALUES (186, 41, "DOLANAAR", 190, 128, 462, 323, 340, 495, 420, 610);
INSERT INTO `WorldMapOverlay_turtle` VALUES (188, 41, "SHADOWGLEN", 225, 225, 491, 153, 205, 535, 330, 660);
INSERT INTO `WorldMapOverlay_turtle` VALUES (190, 22, "HEARTHGLEN", 340, 288, 307, 16, 55, 365, 185, 580);
INSERT INTO `WorldMapOverlay_turtle` VALUES (192, 22, "NORTHRIDGELUMBERCAMP", 220, 180, 382, 164, 195, 425, 290, 525);
INSERT INTO `WorldMapOverlay_turtle` VALUES (193, 22, "RUINSOFANDORHOL", 285, 230, 260, 355, 420, 380, 505, 495);
INSERT INTO `WorldMapOverlay_turtle` VALUES (197, 22, "SORROWHILL", 300, 206, 35