--[[

	Quest Completist - DB.lua
	Written by: Alistair Maxwell
	Last Updated: 14/11/2010

--]]

COLOUR_DEATHKNIGHT = "|cFFC41F3B"
COLOUR_DRUID = "|cFFFF7D0A"
COLOUR_HUNTER = "|cFFABD473"
COLOUR_MAGE = "|cFF69CCF0"
COLOUR_PALADIN = "|cFFF58CBA"
COLOUR_PRIEST = "|cFFFFFFFF"
COLOUR_ROGUE = "|cFFFFF569"
COLOUR_SHAMAN = "|cFF0070DE"
COLOUR_WARLOCK = "|cFF9482C9"
COLOUR_WARRIOR = "|cFFC79C6E"

qcContinents = {

	{1, "Kalimdor"},
	{2, "Eastern Kingdoms"},
	{3, "Outland"},
	{4, "Northrend"},
	{5, "Elsewhere in Azeroth"}, -- TODO: Need to check if Continent ID is correct --

}
qcDungeonCategories = {

	{10, "Classic"},
	{11, "The Burning Crusade"},
	{12, "Wrath of the Lich King"},
	{13, "Cataclysm"},
	{14, "Raids"},

}
qcMiscellaneousCategories = {

	{20, "Professions"},
	{21, "World Events"},
	{22, "Battlegrounds"},
	{23, "Specials"},

}
qcZones = {

	-- Kalimdor --
	{1, 5695, "Ahn'Qiraj: The Fallen Kingdom"},
	{1, 331, "Ashenvale"},
	{1, 16, "Azshara"},
	{1, 3524, "Azuremyst Isle"},
	{1, 3525, "Bloodmyst Isle"},
	{1, 148, "Darkshore"},
	{1, 1657, "Darnassus"},
	{1, 405, "Desolace"},
	{1, 14, "Durotar"},
	{1, 15, "Dustwallow Marsh"},
	{1, 361, "Felwood"},
	{1, 357, "Feralas"},
	{1, 493, "Moonglade"},
	{1, 616, "Mount Hyjal"},
	{1, 215, "Mulgore"},
	{1, 17, "Northern Barrens"}, -- Has taken the Zone ID from the old "The Barrens" --
	{1, 1637, "Orgrimmar"},
	{1, 1377, "Silithus"},
	{1, 4709, "Southern Barrens"},
	{1, 406, "Stonetalon Mountains"},
	{1, 440, "Tanaris"},
	{1, 141, "Teldrassil"},
	{1, 3557, "The Exodar"},
	{1, 5706, "The Steam Pools"},
	{1, 400, "Thousand Needles"},
	{1, 1638, "Thunder Bluff"},
	{1, 5034, "Uldum"},
	{1, 1216, "Timbermaw Hold"}, -- Not showing on Wowhead --
	{1, 490, "Un'Goro Crater"},
	{1, 618, "Winterspring"},

	-- Eastern Kingdoms --
	{2, 36, "Alterac Mountains"},
	{2, 45, "Arathi Highlands"},
	{2, 3, "Badlands"},
	{2, 25, "Blackrock Mountain"},
	{2, 4, "Blasted Lands"},
	{2, 46, "Burning Steppes"},
	{2, 279, "Dalaran Crater"}, -- Not Showing on Wowhead --
	{2, 41, "Deadwind Pass"},
	{2, 2257, "Deeprun Tram"},
	{2, 1, "Dun Morogh"},
	{2, 10, "Duskwood"},
	{2, 139, "Eastern Plaguelands"},
	{2, 12, "Elwynn Forest"},
	{2, 3430, "Eversong Woods"},
	{2, 3433, "Ghostlands"},
	{2, 267, "Hillsbrad Foothills"},
	{2, 1537, "Ironforge"},
	{2, 4080, "Isle of Quel'Danas"},
	{2, 38, "Loch Modan"},
	{2, 33, "Stranglethorn Vale"},
	{2, 4298, "Plaguelands: The Scarlet Enclave"},
	{2, 44, "Redridge Mountains"},
	{2, 51, "Searing Gorge"},
	{2, 3487, "Silvermoon City"},
	{2, 130, "Silverpine Forest"},
	{2, 1519, "Stormwind City"},
	{2, 8, "Swamp of Sorrows"},
	{2, 47, "The Hinterlands"},
	{2, 85, "Tirisfal Glades"},
	{2, 1497, "Undercity"},
	{2, 28, "Western Plaguelands"},
	{2, 40, "Westfall"},
	{2, 11, "Wetlands"},

	-- Outland --
	{3, 3522, "Blade's Edge Mountains"},
	{3, 3483, "Hellfire Peninsula"},
	{3, 3518, "Nagrand"},
	{3, 3523, "Netherstorm"},
	{3, 3520, "Shadowmoon Valley"},
	{3, 3703, "Shattrath City"},
	{3, 3679, "Skettis"}, -- Not showing on Wowhead --
	{3, 3519, "Terokkar Forest"},
	{3, 3521, "Zangarmarsh"},

	-- Northrend --
	{4, 3537, "Borean Tundra"},
	{4, 4024, "Coldarra"}, -- Not showing on Wowhead --
	{4, 2817, "Crystalsong Forest"},
	{4, 4395, "Dalaran"},
	{4, 65, "Dragonblight"},
	{4, 394, "Grizzly Hills"},
	{4, 495, "Howling Fjord"},
	{4, 4742, "Hrothgar's Landing"},
	{4, 210, "Icecrown"},
	{4, 3711, "Sholazar Basin"},
	{4, 67, "The Storm Peaks"},
	{4, 4197, "Wintergrasp"},
	{4, 66, "Zul'Drak"},

	-- Elsewhere in Azeroth --
	{5, 5042, "Deepholm"},
	{5, 4737, "Kezan"}, -- Not showing on Wowhead --
	{5, 4720, "The Lost Isles"},
	{5, 5416, "The Maelstrom"},
	{5, 5630, "The Maelstrom"},
	{5, 5095, "Tol Barad"},

}
qcDungeons = {

	-- Classic --
	{10, 719, "Blackfathom Deeps"},
	{10, 1584, "Blackrock Depths"},
	{10, 1583, "Blackrock Spire"},
	{10, 2557, "Dire Maul"},
	{10, 721, "Gnomeregan"},
	{10, 2100, "Maraudon"},
	{10, 2437, "Ragefire Chasm"},
	{10, 722, "Razorfen Downs"},
	{10, 491, "Razorfen Kraul"},
	{10, 796, "Scarlet Monastery"},
	{10, 2057, "Scholomance"},
	{10, 209, "Shadowfang Keep"},
	{10, 2017, "Stratholme"},
	{10, 1477, "Sunken Temple"},
	{10, 1581, "The Deadmines"},
	{10, 717, "The Stockade"},
	{10, 1337, "Uldaman"},
	{10, 718, "Wailing Caverns"},
	{10, 1176, "Zul'Farrak"},

	-- The Burning Crusade --
	{11, 3790, "Auchenai Crypts"},
	{11, 1941, "Caverns of Time"},
	{11, 3905, "Coilfang Reservoir"},
	{11, 3562, "Hellfire Ramparts"},
	{11, 4095, "Magisters' Terrace"},
	{11, 3792, "Mana-Tombs"},
	{11, 2367, "Old Hillsbrad Foothills"},
	{11, 3791, "Sethekk Halls"},
	{11, 3789, "Shadow Labyrinth"},
	{11, 3845, "Tempest Keep"},
	{11, 3846, "The Arcatraz"},
	{11, 2366, "The Black Morass"},
	{11, 3713, "The Blood Furnace"},
	{11, 3847, "The Botanica"},
	{11, 3849, "The Mechanar"},
	{11, 3714, "The Shattered Halls"},
	{11, 3717, "The Slave Pens"},
	{11, 3715, "The Steamvault"},
	{11, 3716, "The Underbog"},

	-- Wrath of the Lich King --
	{12, 4494, "Ahn'kahet: The Old Kingdom"},
	{12, 3477, "Azjol-Nerub"},
	{12, 1941, "Caverns of Time"},
	{12, 4196, "Drak'Tharon Keep"},
	{12, 4375, "Gundrak"},
	{12, 4272, "Halls of Lightning"},
	{12, 4820, "Halls of Reflection"},
	{12, 4264, "Halls of Stone"},
	{12, 4813, "Pit of Saron"},
	{12, 4100, "The Culling of Stratholme"},
	{12, 4809, "The Forge of Souls"},
	{12, 4120, "The Nexus"},
	{12, 4228, "The Oculus"},
	{12, 4415, "The Violet Hold"},
	{12, 4723, "Trial of the Champion"},
	{12, 206, "Utgarde Keep"},
	{12, 1196, "Utgarde Pinnacle"},

	-- Cataclysm --
	-- TODO: Cata dungeons here --

	-- Raids --
	{14, 3959, "Black Temple"},
	{14, 2677, "Blackwing Lair"},
	{14, 3606, "Hyjal Summit"},
	{14, 4812, "Icecrown Citadel"},
	{14, 3457, "Karazhan"},
	{14, 3836, "Magtheridon's Lair"},
	{14, 2717, "Molten Core"},
	{14, 3456, "Naxxramas"},
	{14, 2159, "Onyxia's Lair"},
	{14, 3429, "Ruins of Ahn'Qiraj"},
	{14, 4075, "Sunwell Plateau"},
	{14, 3842, "Tempest Keep"},
	{14, 3428, "Temple of Ahn'Qiraj"},
	{14, 4500, "The Eye of Eternity"},
	{14, 4493, "The Obsidian Sanctum"},
	{14, 4987, "The Ruby Sanctum"},
	{14, 4722, "Trial of the Crusader"},
	{14, 4273, "Ulduar"},
	{14, 3805, "Zul'Aman"},
	{14, 1977, "Zul'Gurub"},

}
qcProfessions = {

	{20, -181, "Alchemy"},
	{20, -377, "Archaeology"}, -- TODO: Need to check that Profession ID is correct --
	{20, -121, "Blacksmithing"},
	{20, -304, "Cooking"},
	{20, -201, "Engineering"},
	{20, -324, "First Aid"},
	{20, -101, "Fishing"},
	{20, -24, "Herbalism"},
	{20, -371, "Inscription"},
	{20, -373, "Jewelcrafting"},
	{20, -182, "Leatherworking"},
	{20, -264, "Tailoring"},

}
qcWorldEvents = {

	{21, -370, "Brewfest"},
	{21, -1002, "Children's Week"},
	{21, -364, "Darkmoon Faire"},
	{21, -1007, "Day of the Dead"},
	{21, -1003, "Hallow's End"},
	{21, -1005, "Harvest Festival"},
	{21, -1004, "Love is in the Air"},
	{21, -366, "Lunar Festival"},
	{21, -369, "Midsummer Fire Festival"},
	{21, -1006, "New Year's Eve"},
	{21, -374, "Noblegarden"},
	{21, -1008, "Pilgrim's Bounty"},
	{21, -1001, "Winter Veil"},

}
qcBattlegrounds = {

	{22, 3358, "Arathi Basin"},
	{22, 2597, "Alterac Valley"},
	{22, -25, "Battlegrounds"},
	{22, 3820, "Eye of the Storm"},
	{22, 4710, "Isle of Conquest"},
	{22, 4384, "Strand of the Ancients"},
	{22, 3277, "Warsong Gulch"},

}
qcSpecials = {

	{23, -365, "Ahn'Qiraj War"},
	{23, -23, "Cataclysm"},
	{23, -1010, "Dungeon Finder"},
	{23, -1, "Epic"},
	{23, -344, "Legendary"},
	{23, -367, "Reputation"},
	{23, -368, "Invasion"},
	{23, -241, "Tournament"},
	{23, -9999, "FLAG Quests"},

}
qcClasses = {

	{30, -372, "Death Knight", COLOUR_DEATHKNIGHT},
	{30, -263, "Druid", COLOUR_DRUID},
	{30, -261, "Hunter", COLOUR_HUNTER},
	{30, -161, "Mage", COLOUR_MAGE},
	{30, -141, "Paladin", COLOUR_PALADIN},
	{30, -262, "Priest", COLOUR_PRIEST},
	{30, -162, "Rogue", COLOUR_ROGUE},
	{30, -82, "Shaman", COLOUR_SHAMAN},
	{30, -61, "Warlock", COLOUR_WARLOCK},
	{30, -81, "Warrior", COLOUR_WARRIOR},

}
qcQuestDatabases = { -- {1: Zone ID, 2: Quest ID, 3: Quest Type (1=Normal, 2=Repeatable, 3=Daily, 4=Special), 4: Recommended Level, 5: Quest Title, 6: Side (1=Alliance, 2=Horde, 3=Both, 4=NoSideProvided), 7: ClassBased (1=Yes 2=No), 8: ClassType (In Capitals eg. WARLOCKMAGE)} --

	--[[

		EASTERN KINGDOMS - Original Version 07/11/2010;

		CHANGELOG:

		07/11/2010

		Quests flagged as repeatable:
		579, 2582, 2584, 2586, 2602, 2604, 2522, 3502, 1423, 7673, 7674, 14083, 14084, 7675, 7676,
		4973, 117, 3861.

		Quests flagged as special:
		5805, 14079, 4022, 4023, 5841.

	--]]

	{36, 505, 1, 33, "Syndicate Assassins", 1, 2, nil},
	{36, 510, 1, 34, "Foreboding Plans", 1, 2, nil},
	{36, 511, 1, 34, "Encrypted Letter", 1, 2, nil},
	{36, 514, 1, 34, "Letter to Stormpike", 1, 2, nil},
	{36, 525, 1, 34, "Further Mysteries", 1, 2, nil},
	{36, 535, 1, 34, "Valik", 2, 2, nil},
	{36, 500, 1, 36, "Crushridge Bounty", 1, 2, nil},
	{36, 512, 1, 36, "Noble Deaths", 1, 2, nil},
	{36, 522, 1, 38, "Assassin's Contract", 1, 2, nil},
	{36, 504, 1, 40, "Crushridge Warmongers", 1, 2, nil},
	{36, 523, 1, 40, "Baron's Demise", 1, 2, nil},
	{36, 537, 1, 40, "Dark Council", 1, 2, nil},
	{36, 551, 1, 40, "The Ensorcelled Parchment", 1, 2, nil},
	{36, 554, 1, 40, "Stormpike's Deciphering", 1, 2, nil},
	{36, 9826, 1, 70, "Contact from Dalaran", 3, 2, nil},
	{36, 9860, 1, 70, "The New Directive", 3, 2, nil},
	{45, 681, 1, 31, "Northfold Manor", 1, 2, nil},
	{45, 677, 1, 32, "Call to Arms", 2, 2, nil},
	{45, 671, 1, 33, "Foul Magics", 2, 2, nil},
	{45, 655, 1, 34, "Hammerfall", 2, 2, nil},
	{45, 672, 1, 34, "Raising Spirits", 2, 2, nil},
	{45, 674, 1, 34, "Raising Spirits", 2, 2, nil},
	{45, 675, 1, 34, "Raising Spirits", 2, 2, nil},
	{45, 635, 1, 35, "Crystal in the Mountains", 3, 2, nil},
	{45, 663, 1, 35, "Land Ho!", 3, 2, nil},
	{45, 691, 1, 36, "Worth Its Weight in Gold", 1, 2, nil},
	{45, 682, 1, 37, "Stromgarde Badges", 1, 2, nil},
	{45, 639, 1, 37, "Sigil of Strom", 2, 2, nil},
	{45, 701, 1, 37, "Guile of the Raptor", 2, 2, nil},
	{45, 702, 1, 37, "Guile of the Raptor", 2, 2, nil},
	{45, 847, 1, 37, "Guile of the Raptor", 2, 2, nil},
	{45, 642, 1, 37, "The Princess Trapped", 3, 2, nil},
	{45, 678, 1, 38, "Call to Arms", 2, 2, nil},
	{45, 651, 1, 38, "Stones of Binding", 3, 2, nil},
	{45, 684, 1, 39, "Wanted! Marez Cowl", 1, 2, nil},
	{45, 693, 1, 39, "Wand over Fist", 1, 2, nil},
	{45, 694, 1, 39, "Trelane's Defenses", 1, 2, nil},
	{45, 695, 1, 39, "An Apprentice's Enchantment", 1, 2, nil},
	{45, 696, 1, 39, "Attack on the Tower", 1, 2, nil},
	{45, 697, 1, 39, "Malin's Request", 1, 2, nil},
	{45, 653, 1, 40, "Myzrael's Allies", 1, 2, nil},
	{45, 685, 1, 40, "Wanted! Otto and Falconcrest", 1, 2, nil},
	{45, 640, 1, 40, "The Broken Sigil", 2, 2, nil},
	{45, 641, 1, 40, "Sigil of Thoradin", 2, 2, nil},
	{45, 673, 1, 40, "Foul Magics", 2, 2, nil},
	{45, 679, 1, 40, "Call to Arms", 2, 2, nil},
	{45, 680, 1, 40, "The Real Threat", 2, 2, nil},
	{45, 688, 1, 40, "Myzrael's Allies", 2, 2, nil},
	{45, 662, 1, 40, "Deep Sea Salvage", 3, 2, nil},
	{45, 664, 1, 40, "Drowned Sorrows", 3, 2, nil},
	{45, 665, 1, 40, "Sunken Treasure", 3, 2, nil},
	{45, 666, 1, 40, "Sunken Treasure", 3, 2, nil},
	{45, 668, 1, 40, "Sunken Treasure", 3, 2, nil},
	{45, 669, 1, 40, "Sunken Treasure", 3, 2, nil},
	{45, 670, 1, 40, "Sunken Treasure", 3, 2, nil},
	{45, 687, 1, 40, "Theldurin the Lost", 3, 2, nil},
	{45, 643, 1, 41, "Sigil of Arathor", 2, 2, nil},
	{45, 644, 1, 42, "Sigil of Trollbane", 2, 2, nil},
	{45, 645, 1, 42, "Trol'kalar", 2, 2, nil},
	{45, 646, 1, 42, "Trol'kalar", 2, 2, nil},
	{45, 652, 1, 42, "Breaking the Keystone", 3, 2, nil},
	{45, 667, 1, 44, "Death From Below", 3, 2, nil},
	{45, 656, 1, 50, "Summoning the Princess [Group]", 3, 2, nil},
	{3, 719, 1, 35, "A Dwarf and His Tools", 1, 2, nil},
	{3, 720, 1, 35, "A Sign of Hope", 1, 2, nil},
	{3, 705, 1, 37, "Pearl Diving", 3, 2, nil},
	{3, 710, 1, 37, "Study of the Elements: Rock", 3, 2, nil},
	{3, 713, 1, 37, "Coolant Heads Prevail", 3, 2, nil},
	{3, 714, 1, 37, "Gyro... What?", 3, 2, nil},
	{3, 715, 1, 37, "Liquid Stone", 3, 2, nil},
	{3, 718, 1, 38, "Mirages", 1, 2, nil},
	{3, 738, 1, 38, "Find Agmond", 1, 2, nil},
	{3, 2258, 1, 39, "Badlands Reagent Run", 2, 2, nil},
	{3, 711, 1, 39, "Study of the Elements: Rock", 3, 2, nil},
	{3, 708, 4, 40, "The Black Box [Removed]", 4, 2, nil},
	{3, 723, 1, 40, "Prospect of Faith", 1, 2, nil},
	{3, 724, 1, 40, "Prospect of Faith", 1, 2, nil},
	{3, 725, 1, 40, "Passing Word of a Threat", 1, 2, nil},
	{3, 726, 1, 40, "Passing Word of a Threat", 1, 2, nil},
	{3, 727, 1, 40, "To Ironforge for Yagyin's Digest", 1, 2, nil},
	{3, 733, 1, 40, "Scrounging", 1, 2, nil},
	{3, 728, 1, 40, "To the Undercity for Yagyin's Digest", 2, 2, nil},
	{3, 1419, 1, 40, "Coyote Thieves", 2, 2, nil},
	{3, 1420, 1, 40, "Report to Helgrum", 2, 2, nil},
	{3, 9439, 1, 40, "Unclaimed Baggage", 2, 2, nil},
	{3, 703, 1, 40, "Barbecued Buzzard Wings", 3, 2, nil},
	{3, 737, 1, 40, "Forbidden Knowledge", 3, 2, nil},
	{3, 692, 1, 41, "The Lost Fragments", 3, 2, nil},
	{3, 739, 1, 42, "Murdaloc", 1, 2, nil},
	{3, 712, 1, 42, "Study of the Elements: Rock", 3, 2, nil},
	{3, 716, 1, 42, "Stone Is Better than Cloth", 3, 2, nil},
	{3, 734, 1, 42, "This Is Going to Be Hard", 3, 2, nil},
	{3, 777, 1, 42, "This Is Going to Be Hard", 3, 2, nil},
	{3, 732, 1, 43, "Tremors of the Earth", 1, 2, nil},
	{3, 782, 1, 43, "Broken Alliances", 2, 2, nil},
	{3, 735, 1, 44, "The Star, the Hand and the Heart [Group]", 1, 2, nil},
	{3, 762, 1, 44, "An Ambassador of Evil", 1, 2, nil},
	{3, 2203, 1, 44, "Badlands Reagent Run II", 2, 2, nil},
	{3, 706, 1, 45, "Fiery Blaze Enchantments", 1, 2, nil},
	{3, 778, 1, 45, "This Is Going to Be Hard", 3, 2, nil},
	{3, 717, 1, 50, "Tremors of the Earth", 1, 2, nil},
	{3, 793, 1, 50, "Broken Alliances", 2, 2, nil},
	{3, 779, 2, 50, "Seal of the Earth", 3, 2, nil},
	{3, 3821, 1, 52, "Dreadmaul Rock", 2, 2, nil},
	{3, 4062, 1, 54, "The Rise of the Machines", 2, 2, nil},
	{25, 4262, 1, 52, "Overmaster Pyron", 1, 2, nil},
	{25, 3906, 1, 52, "Disharmony of Flame", 2, 2, nil},
	{25, 8960, 1, 60, "Bodley's Unfortunate Fate", 1, 2, nil},
	{25, 9032, 1, 60, "Bodley's Unfortunate Fate", 2, 2, nil},
	{25, 8961, 1, 60, "Three Kings of Flame", 3, 2, nil},
	{25, 8962, 1, 60, "Components of Importance [Group]", 3, 1, "TODO:CLASS"},
	{25, 8963, 1, 60, "Components of Importance [Group]", 3, 1, "TODO:CLASS"},
	{25, 8964, 1, 60, "Components of Importance [Group]", 3, 1, "TODO:CLASS"},
	{25, 8965, 1, 60, "Components of Importance [Group]", 3, 1, "TODO:CLASS"},
	{25, 8985, 1, 60, "More Components of Importance [Group]", 3, 1, "TODO:CLASS"},
	{25, 8986, 1, 60, "More Components of Importance [Group]", 3, 1, "TODO:CLASS"},
	{25, 8987, 1, 60, "More Components of Importance [Group]", 3, 1, "TODO:CLASS"},
	{25, 8988, 1, 60, "More Components of Importance [Group]", 3, 1, "TODO:CLASS"},
	{25, 8994, 1, 60, "Final Preparations", 3, 2, nil},
	{25, 8996, 1, 60, "Return to Bodley", 3, 2, nil},
	{4, 2621, 1, 50, "The Disgraced One", 2, 2, nil},
	{4, 2784, 1, 50, "Fall From Grace", 2, 2, nil},
	{4, 2581, 1, 50, "Snickerfang Jowls", 3, 2, nil},
	{4, 2582, 2, 50, "Rage of Ages", 3, 2, nil},
	{4, 2583, 1, 50, "A Boar's Vitality", 3, 2, nil},
	{4, 2584, 2, 50, "Spirit of the Boar", 3, 2, nil},
	{4, 2585, 1, 50, "The Decisive Striker", 3, 2, nil},
	{4, 2586, 2, 50, "Salt of the Scorpok", 3, 2, nil},
	{4, 2601, 1, 50, "The Basilisk's Bite", 3, 2, nil},
	{4, 2602, 2, 50, "Infallible Mind", 3, 2, nil},
	{4, 2603, 1, 50, "Vulture's Vigor", 3, 2, nil},
	{4, 2604, 2, 50, "Spiritual Domination", 3, 2, nil},
	{4, 2521, 1, 55, "To Serve Kum'isha", 3, 2, nil},
	{4, 2522, 2, 55, "Kum'isha's Endeavors", 3, 2, nil},
	{4, 3501, 1, 55, "Everything Counts In Large Amounts", 3, 2, nil},
	{4, 3502, 2, 55, "One Draenei's Junk...", 3, 2, nil},
	{4, 2783, 1, 57, "Petty Squabbles", 1, 2, nil},
	{4, 2681, 1, 57, "The Stones That Bind Us", 3, 2, nil},
	{4, 2701, 1, 57, "Heroes of Old", 3, 2, nil},
	{4, 2702, 1, 57, "Heroes of Old", 3, 2, nil},
	{4, 2801, 1, 57, "A Tale of Sorrow", 3, 2, nil},
	{4, 2721, 1, 58, "Kirith", 3, 2, nil},
	{4, 2743, 1, 60, "The Cover of Darkness", 3, 2, nil},
	{4, 2744, 1, 60, "The Demon Hunter", 3, 2, nil},
	{4, 3627, 1, 60, "Uniting the Shattered Amulet [Group]", 3, 2, nil},
	{4, 3628, 1, 60, "You Are Rakh'likh, Demon [Group]", 3, 2, nil},
	{46, 4296, 1, 50, "Tablet of the Seven", 3, 2, nil},
	{46, 3823, 1, 52, "Extinguish the Firegut", 1, 2, nil},
	{46, 4726, 1, 52, "Broodling Essence", 3, 2, nil},
	{46, 3824, 1, 53, "Gor'tesh the Brute Lord", 1, 2, nil},
	{46, 3825, 1, 53, "Ogre Head On A Stick = Party", 1, 2, nil},
	{46, 3822, 1, 53, "Krom'Grul", 2, 2, nil},
	{46, 4182, 4, 54, "Dragonkin Menace [Removed]", 1, 2, nil},
	{46, 4183, 4, 54, "The True Masters [Removed]", 1, 2, nil},
	{46, 4184, 1, 54, "The True Masters", 1, 2, nil},
	{46, 4185, 1, 54, "The True Masters", 1, 2, nil},
	{46, 4186, 4, 54, "The True Masters [Removed]", 1, 2, nil},
	{46, 4223, 4, 54, "The True Masters [Removed]", 1, 2, nil},
	{46, 4224, 4, 54, "The True Masters [Removed]", 1, 2, nil},
	{46, 4061, 1, 54, "The Rise of the Machines", 2, 2, nil},
	{46, 4022, 4, 54, "A Taste of Flame", 3, 2, nil},
	{46, 4023, 4, 54, "A Taste of Flame", 3, 2, nil},
	{46, 4808, 1, 54, "Felnok Steelspring", 3, 2, nil},
	{46, 4482, 2, 55, "Libram of Tenacity", 1, 2, nil},
	{46, 4463, 2, 55, "Libram of Rumination", 3, 2, nil},
	{46, 4481, 2, 55, "Libram of Constitution", 3, 2, nil},
	{46, 4483, 2, 55, "Libram of Resilience", 3, 2, nil},
	{46, 4484, 2, 55, "Libram of Voracity", 3, 2, nil},
	{46, 4283, 1, 56, "FIFTY! YEP!", 1, 2, nil},
	{46, 5522, 1, 60, "Leonid Barthalomew", 3, 2, nil},
	{41, 9680, 1, 70, "Digging Up the Past", 3, 2, nil},
	{2257, 6661, 1, 12, "Deeprun Rat Roundup", 1, 2, nil},
	{2257, 6662, 1, 12, "Me Brother, Nipsy", 1, 2, nil},
	{1, 25199, 1, 0, "Basic Orders", 1, 2, nil},
	{1, 25212, 1, 0, "Vent Horizon", 1, 2, nil},
	{1, 25229, 1, 0, "A Few Good Gnomes", 1, 2, nil},
	{1, 25283, 1, 0, "Prepping the Speech", 1, 2, nil},
	{1, 25285, 1, 0, "In and Out", 1, 2, nil},
	{1, 25289, 1, 0, "One Step Forward...", 1, 2, nil},
	{1, 25295, 1, 0, "Press Fire", 1, 2, nil},
	{1, 25500, 1, 0, "Words for Delivery", 1, 2, nil},
	{1, 179, 1, 1, "Dwarven Outfitters", 1, 2, nil},
	{1, 403, 2, 1, "Guarded Thunderbrew Barrel", 1, 2, nil},
	{1, 5841, 4, 1, "Welcome!", 1, 2, nil},
	{1, 7673, 2, 1, "Frost Ram Exchange", 1, 2, nil},
	{1, 7674, 2, 1, "Black Ram Exchange", 1, 2, nil},
	{1, 170, 1, 2, "A New Threat", 1, 2, nil},
	{1, 183, 1, 3, "The Boar Hunter", 1, 2, nil},
	{1, 233, 1, 3, "Coldridge Valley Mail Delivery", 1, 2, nil},
	{1, 3361, 1, 3, "A Refugee's Quandary", 1, 2, nil},
	{1, 182, 1, 4, "The Troll Cave", 1, 2, nil},
	{1, 234, 1, 4, "Coldridge Valley Mail Delivery", 1, 2, nil},
	{1, 218, 1, 5, "The Stolen Journal", 1, 2, nil},
	{1, 282, 1, 5, "Senir's Observations", 1, 2, nil},
	{1, 400, 1, 5, "Tools for Steelgrill", 1, 2, nil},
	{1, 420, 1, 5, "Senir's Observations", 1, 2, nil},
	{1, 2160, 1, 5, "Supplies to Tannok", 1, 2, nil},
	{1, 3364, 1, 5, "Scalding Mornbrew Delivery", 1, 2, nil},
	{1, 3365, 1, 5, "Bring Back the Mug", 1, 2, nil},
	{1, 310, 1, 6, "Bitter Rivals", 1, 2, nil},
	{1, 317, 1, 6, "Stocking Jetsteam", 1, 2, nil},
	{1, 5541, 1, 6, "Ammo for Rumbleshot", 1, 2, nil},
	{1, 308, 2, 7, "Distracting Jarven", 1, 2, nil},
	{1, 311, 1, 7, "Return to Marleth", 1, 2, nil},
	{1, 313, 1, 7, "The Grizzled Den", 1, 2, nil},
	{1, 318, 1, 7, "Evershine", 1, 2, nil},
	{1, 319, 1, 8, "A Favor for Evershine", 1, 2, nil},
	{1, 320, 1, 8, "Return to Bellowfiz", 1, 2, nil},
	{1, 287, 1, 9, "Frostmane Hold", 1, 2, nil},
	{1, 315, 1, 9, "The Perfect Stout", 1, 2, nil},
	{1, 432, 1, 9, "Those Blasted Troggs!", 1, 2, nil},
	{1, 291, 1, 10, "The Reports", 1, 2, nil},
	{1, 412, 1, 10, "Operation Recombobulation", 1, 2, nil},
	{1, 413, 1, 10, "Shimmer Stout", 1, 2, nil},
	{1, 414, 1, 10, "Stout to Kadrell", 1, 2, nil},
	{1, 415, 1, 10, "Rejold's New Brew", 1, 2, nil},
	{1, 419, 1, 10, "The Lost Pilot", 1, 2, nil},
	{1, 417, 1, 11, "A Pilot's Revenge", 1, 2, nil},
	{1, 433, 1, 11, "The Public Servant", 1, 2, nil},
	{1, 312, 1, 12, "Tundra MacGrann's Stolen Stash", 1, 2, nil},
	{1, 314, 1, 12, "Protecting the Herd", 1, 2, nil},
	{1, 14083, 2, 20, "Learn to Ride in Dun Morogh", 1, 2, nil},
	{1, 14084, 2, 20, "Learn to Ride in Dun Morogh", 1, 2, nil},
	{1, 466, 1, 22, "Search for Incendicite", 1, 2, nil},
	{1, 467, 1, 23, "Stonegear's Search", 1, 2, nil},
	{1, 7675, 2, 30, "Icy Blue Mechanostrider Replacement", 1, 2, nil},
	{1, 7676, 2, 30, "White Mechanostrider Replacement", 1, 2, nil},
	{1, 25286, 1, 75, "Words for Delivery", 1, 2, nil},
	{1, 25287, 1, 75, "Words for Delivery", 1, 2, nil},
	{1, 25393, 1, 75, "Operation: Gnomeregan", 1, 2, nil},
	{10, 5, 1, 20, "Jitters' Growling Gut", 1, 2, nil},
	{10, 93, 1, 20, "Dusky Crab Cakes", 1, 2, nil},
	{10, 163, 1, 20, "Raven Hill", 1, 2, nil},
	{10, 240, 1, 20, "Return to Jitters", 1, 2, nil},
	{10, 9429, 1, 20, "Travel to Darkshire", 1, 2, nil},
	{10, 226, 1, 21, "Wolves at Our Heels", 1, 2, nil},
	{10, 245, 1, 21, "Eight-Legged Menaces", 1, 2, nil},
	{10, 164, 1, 23, "Deliveries to Sven", 1, 2, nil},
	{10, 56, 1, 24, "The Night Watch", 1, 2, nil},
	{10, 148, 1, 24, "Supplies from Darkshire", 1, 2, nil},
	{10, 149, 1, 24, "Ghost Hair Thread", 1, 2, nil},
	{10, 154, 1, 24, "Return the Comb", 1, 2, nil},
	{10, 156, 1, 24, "Gather Rot Blossoms", 1, 2, nil},
	{10, 157, 1, 24, "Deliver the Thread", 1, 2, nil},
	{10, 158, 1, 24, "Zombie Juice", 1, 2, nil},
	{10, 159, 1, 24, "Juice Delivery", 1, 2, nil},
	{10, 90, 1, 25, "Seasoned Wolf Kabobs", 1, 2, nil},
	{10, 95, 1, 25, "Sven's Revenge", 1, 2, nil},
	{10, 101, 1, 25, "The Totem of Infliction", 1, 2, nil},
	{10, 165, 1, 25, "The Hermit", 1, 2, nil},
	{10, 174, 1, 25, "Look To The Stars", 1, 2, nil},
	{10, 175, 1, 25, "Look To The Stars", 1, 2, nil},
	{10, 177, 1, 25, "Look To The Stars", 1, 2, nil},
	{10, 230, 1, 25, "Sven's Camp", 1, 2, nil},
	{10, 262, 1, 25, "The Shadowy Figure", 1, 2, nil},
	{10, 265, 1, 25, "The Shadowy Search Continues", 1, 2, nil},
	{10, 266, 1, 25, "Inquire at the Inn", 1, 2, nil},
	{10, 268, 1, 25, "Return to Sven", 1, 2, nil},
	{10, 337, 1, 25, "An Old History Book", 1, 2, nil},
	{10, 453, 1, 25, "Finding the Shadowy Figure", 1, 2, nil},
	{10, 57, 1, 26, "The Night Watch", 1, 2, nil},
	{10, 133, 1, 27, "Ghoulish Effigy", 1, 2, nil},
	{10, 66, 1, 28, "The Legend of Stalvan", 1, 2, nil},
	{10, 67, 1, 28, "The Legend of Stalvan", 1, 2, nil},
	{10, 68, 1, 28, "The Legend of Stalvan", 1, 2, nil},
	{10, 69, 1, 28, "The Legend of Stalvan", 1, 2, nil},
	{10, 70, 1, 28, "The Legend of Stalvan", 1, 2, nil},
	{10, 72, 1, 28, "The Legend of Stalvan", 1, 2, nil},
	{10, 74, 1, 28, "The Legend of Stalvan", 1, 2, nil},
	{10, 75, 1, 28, "The Legend of Stalvan", 1, 2, nil},
	{10, 78, 1, 28, "The Legend of Stalvan", 1, 2, nil},
	{10, 79, 1, 28, "The Legend of Stalvan", 1, 2, nil},
	{10, 80, 1, 28, "The Legend of Stalvan", 1, 2, nil},
	{10, 97, 1, 28, "The Legend of Stalvan", 1, 2, nil},
	{10, 173, 1, 28, "Worgen in the Woods", 1, 2, nil},
	{10, 323, 1, 28, "Proving Your Worth", 1, 2, nil},
	{10, 221, 1, 29, "Worgen in the Woods", 1, 2, nil},
	{10, 269, 1, 29, "Seeking Wisdom", 1, 2, nil},
	{10, 270, 1, 29, "The Doomed Fleet", 1, 2, nil},
	{10, 321, 1, 29, "Lightforge Iron", 1, 2, nil},
	{10, 322, 1, 29, "Blessed Arm", 1, 2, nil},
	{10, 324, 1, 29, "The Lost Ingots", 1, 2, nil},
	{10, 325, 1, 29, "Armed and Ready", 1, 2, nil},
	{10, 58, 1, 30, "The Night Watch", 1, 2, nil},
	{10, 134, 1, 30, "Ogre Thieves", 1, 2, nil},
	{10, 160, 1, 30, "Note to the Mayor", 1, 2, nil},
	{10, 181, 1, 30, "Look To The Stars", 1, 2, nil},
	{10, 225, 1, 30, "The Weathered Grave", 1, 2, nil},
	{10, 227, 1, 30, "Morgan Ladimore", 1, 2, nil},
	{10, 228, 1, 30, "Mor'Ladim [Group]", 1, 2, nil},
	{10, 229, 1, 30, "The Daughter Who Lived", 1, 2, nil},
	{10, 231, 1, 30, "A Daughter's Love", 1, 2, nil},
	{10, 251, 1, 30, "Translate Abercrombie's Note", 1, 2, nil},
	{10, 252, 1, 30, "Translation to Ello", 1, 2, nil},
	{10, 253, 1, 30, "Bride of the Embalmer", 1, 2, nil},
	{10, 401, 1, 30, "Wait for Sirra to Finish", 1, 2, nil},
	{10, 222, 1, 31, "Worgen in the Woods", 1, 2, nil},
	{10, 223, 1, 31, "Worgen in the Woods", 1, 2, nil},
	{10, 55, 1, 32, "Morbent Fel", 1, 2, nil},
	{10, 98, 1, 32, "The Legend of Stalvan", 1, 2, nil},
	{10, 254, 2, 35, "Digging Through the Dirt", 1, 2, nil},
	{10, 1372, 1, 42, "Nothing But The Truth", 2, 2, nil},
	{10, 1383, 1, 42, "Nothing But The Truth", 2, 2, nil},
	{10, 1388, 1, 42, "Nothing But The Truth", 2, 2, nil},
	{10, 1391, 1, 42, "Nothing But The Truth", 2, 2, nil},
	{10, 1395, 1, 45, "Supplies for Nethergarde", 1, 2, nil},
	{139, 5903, 1, 55, "A Plague Upon Thee", 1, 2, nil},
	{139, 5901, 1, 55, "A Plague Upon Thee", 2, 2, nil},
	{139, 5142, 1, 55, "Little Pamela", 3, 2, nil},
	{139, 5149, 1, 55, "Pamela's Doll", 3, 2, nil},
	{139, 5211, 1, 55, "Defenders of Darrowshire", 3, 2, nil},
	{139, 5503, 1, 55, "Argent Dawn Commission", 3, 1, "TODO:CLASS"},
	{139, 5508, 2, 55, "Corruptor's Scourgestones", 3, 2, nil},
	{139, 5509, 2, 55, "Invader's Scourgestones", 3, 2, nil},
	{139, 5510, 2, 55, "Minion's Scourgestones", 3, 2, nil},
	{139, 5601, 1, 55, "Sister Pamela", 3, 2, nil},
	{139, 6021, 1, 55, "Zaeldarr the Outcast", 3, 2, nil},
	{139, 6164, 1, 55, "Augustus' Receipt Book", 3, 2, nil},
	{139, 5246, 1, 56, "Fragments of the Past", 1, 2, nil},
	{139, 5152, 1, 56, "Auntie Marlene", 3, 2, nil},
	{139, 5153, 1, 56, "A Strange Historian", 3, 2, nil},
	{139, 5168, 1, 56, "Heroes of Darrowshire", 3, 2, nil},
	{139, 5210, 1, 56, "Brother Carlin", 3, 2, nil},
	{139, 5241, 1, 56, "Uncle Carlin", 3, 2, nil},
	{139, 5542, 1, 56, "Demon Dogs", 3, 2, nil},
	{139, 5543, 1, 56, "Blood Tinged Skies", 3, 2, nil},
	{139, 5544, 1, 56, "Carrion Grubbage", 3, 2, nil},
	{139, 5742, 1, 56, "Redemption", 3, 2, nil},
	{139, 5247, 1, 57, "Fragments of the Past", 1, 2, nil},
	{139, 5181, 1, 57, "Villains of Darrowshire", 3, 2, nil},
	{139, 5781, 1, 57, "Of Forgotten Memories", 3, 2, nil},
	{139, 5248, 1, 58, "Tormented By the Past", 1, 2, nil},
	{139, 6022, 1, 58, "To Kill With Purpose", 2, 2, nil},
	{139, 6042, 1, 58, "Un-Life's Little Annoyances", 2, 2, nil},
	{139, 5065, 1, 58, "The Lost Tablets of Mosh'aru", 3, 2, nil},
	{139, 5845, 1, 58, "Of Lost Honor", 3, 2, nil},
	{139, 5846, 1, 58, "Of Love and Family", 3, 2, nil},
	{139, 6026, 1, 58, "That's Asking A Lot", 3, 2, nil},
	{139, 6041, 1, 58, "When Smokey Sings, I Get Violent", 3, 2, nil},
	{139, 6185, 1, 60, "The Eastern Plagues [Group]", 1, 2, nil},
	{139, 6187, 1, 60, "Order Must Be Restored", 1, 2, nil},
	{139, 8929, 1, 60, "In Search of Anthion", 1, 2, nil},
	{139, 9664, 1, 60, "Establishing New Outposts [PvP]", 1, 2, nil},
	{139, 6133, 1, 60, "The Ranger Lord's Behest", 2, 2, nil},
	{139, 6135, 1, 60, "Duskwing, Oh How I Hate Thee...", 2, 2, nil},
	{139, 6136, 1, 60, "The Corpulent One", 2, 2, nil},
	{139, 6144, 1, 60, "The Call to Command", 2, 2, nil},
	{139, 6146, 1, 60, "Nathanos' Ruse [Group]", 2, 2, nil},
	{139, 6147, 1, 60, "Return to Nathanos [Group]", 2, 2, nil},
	{139, 6148, 1, 60, "The Scarlet Oracle, Demetria [Group]", 2, 2, nil},
	{139, 8930, 1, 60, "In Search of Anthion", 2, 2, nil},
	{139, 9665, 1, 60, "Bolstering Our Defenses [PvP]", 2, 2, nil},
	{139, 14349, 1, 60, "The Call to Command", 2, 2, nil},
	{139, 14350, 1, 60, "The Crimson Courier [Group]", 2, 2, nil},
	{139, 5206, 1, 60, "Marauders of Darrowshire", 3, 2, nil},
	{139, 5264, 1, 60, "Lord Maxwell Tyrosus", 3, 2, nil},
	{139, 5265, 1, 60, "The Argent Hold", 3, 2, nil},
	{139, 5281, 1, 60, "The Restless Souls", 3, 2, nil},
	{139, 5464, 1, 60, "Menethil's Gift [Group]", 3, 2, nil},
	{139, 5513, 1, 60, "Mantles of the Dawn", 3, 2, nil},
	{139, 5517, 1, 60, "Chromatic Mantle of the Dawn", 3, 2, nil},
	{139, 5721, 1, 60, "The Battle of Darrowshire", 3, 2, nil},
	{139, 5941, 1, 60, "Return to Chromie", 3, 2, nil},
	{139, 5942, 1, 60, "Hidden Treasures", 3, 2, nil},
	{139, 6024, 1, 60, "Hameya's Plea", 3, 2, nil},
	{139, 8946, 1, 60, "Proof of Life", 3, 2, nil},
	{139, 8947, 1, 60, "Anthion's Strange Request", 3, 2, nil},
	{139, 9121, 1, 60, "The Dread Citadel - Naxxramas", 3, 2, nil},
	{139, 9122, 1, 60, "The Dread Citadel - Naxxramas", 3, 2, nil},
	{139, 9123, 1, 60, "The Dread Citadel - Naxxramas", 3, 2, nil},
	{139, 9124, 1, 60, "Cryptstalker Armor Doesn't Make Itself...", 3, 2, nil},
	{139, 9125, 2, 60, "Crypt Fiend Parts", 3, 2, nil},
	{139, 9126, 1, 60, "Bonescythe Digs", 3, 2, nil},
	{139, 9127, 2, 60, "Bone Fragments", 3, 2, nil},
	{139, 9128, 1, 60, "The Elemental Equation", 3, 2, nil},
	{139, 9129, 2, 60, "Core of Elements", 3, 2, nil},
	{139, 9131, 1, 60, "Binding the Dreadnaught", 3, 2, nil},
	{139, 9132, 2, 60, "Dark Iron Scraps", 3, 2, nil},
	{139, 9136, 1, 60, "Savage Flora", 3, 2, nil},
	{139, 9137, 2, 60, "Savage Fronds", 3, 2, nil},
	{139, 9141, 1, 60, "They Call Me \"The Rooster\" ", 3, 2, nil},
	{139, 9142, 2, 60, "Craftsman's Writ", 3, 2, nil},
	{139, 9165, 1, 60, "Writ of Safe Passage", 3, 2, nil},
	{139, 9178, 1, 60, "Craftsman's Writ - Dense Weightstone", 3, 2, nil},
	{139, 9179, 1, 60, "Craftsman's Writ - Imperial Plate Chest", 3, 2, nil},
	{139, 9181, 1, 60, "Craftsman's Writ - Volcanic Hammer", 3, 2, nil},
	{139, 9182, 1, 60, "Craftsman's Writ - Huge Thorium Battleaxe", 3, 2, nil},
	{139, 9183, 1, 60, "Craftsman's Writ - Radiant Circlet", 3, 2, nil},
	{139, 9184, 1, 60, "Craftsman's Writ - Wicked Leather Headband", 3, 2, nil},
	{139, 9185, 1, 60, "Craftsman's Writ - Rugged Armor Kit", 3, 2, nil},
	{139, 9186, 1, 60, "Craftsman's Writ - Wicked Leather Belt", 3, 2, nil},
	{139, 9187, 1, 60, "Craftsman's Writ - Runic Leather Pants", 3, 2, nil},
	{139, 9188, 1, 60, "Craftsman's Writ - Brightcloth Pants", 3, 2, nil},
	{139, 9190, 1, 60, "Craftsman's Writ - Runecloth Boots", 3, 2, nil},
	{139, 9191, 1, 60, "Craftsman's Writ - Runecloth Bag", 3, 2, nil},
	{139, 9194, 1, 60, "Craftsman's Writ - Runecloth Robe", 3, 2, nil},
	{139, 9195, 1, 60, "Craftsman's Writ - Goblin Sapper Charge", 3, 2, nil},
	{139, 9196, 1, 60, "Craftsman's Writ - Thorium Grenade", 3, 2, nil},
	{139, 9197, 1, 60, "Craftsman's Writ - Gnomish Battle Chicken", 3, 2, nil},
	{139, 9198, 1, 60, "Craftsman's Writ - Thorium Tube", 3, 2, nil},
	{139, 9200, 1, 60, "Craftsman's Writ - Major Mana Potion", 3, 2, nil},
	{139, 9201, 1, 60, "Craftsman's Writ - Greater Arcane Protection Potion", 3, 2, nil},
	{139, 9202, 1, 60, "Craftsman's Writ - Major Healing Potion", 3, 2, nil},
	{139, 9203, 1, 60, "Craftsman's Writ - Potion of Petrification", 3, 2, nil},
	{139, 9204, 1, 60, "Craftsman's Writ - Stonescale Eel", 3, 2, nil},
	{139, 9205, 1, 60, "Craftsman's Writ - Plated Armorfish", 3, 2, nil},
	{139, 9206, 1, 60, "Craftsman's Writ - Lightning Eel", 3, 2, nil},
	{139, 9211, 1, 60, "The Ice Guard", 3, 2, nil},
	{139, 9213, 1, 60, "The Shadow Guard", 3, 2, nil},
	{139, 9221, 1, 60, "Superior Armaments of Battle - Friend of the Dawn", 3, 2, nil},
	{139, 9222, 1, 60, "Epic Armaments of Battle - Friend of the Dawn", 3, 2, nil},
	{139, 9223, 1, 60, "Superior Armaments of Battle - Honored Amongst the Dawn", 3, 2, nil},
	{139, 9224, 1, 60, "Epic Armaments of Battle - Honored Amongst the Dawn", 3, 2, nil},
	{139, 9225, 1, 60, "Epic Armaments of Battle - Revered Amongst the Dawn", 3, 2, nil},
	{139, 9226, 1, 60, "Superior Armaments of Battle - Revered Amongst the Dawn", 3, 2, nil},
	{139, 9227, 1, 60, "Superior Armaments of Battle - Exalted Amongst the Dawn", 3, 2, nil},
	{139, 9228, 1, 60, "Epic Armaments of Battle - Exalted Amongst the Dawn", 3, 2, nil},
	{12, 16, 2, 1, "Give Gerard a Drink", 1, 2, nil},
	{12, 783, 1, 1, "A Threat Within", 1, 2, nil},
	{12, 5805, 4, 1, "Welcome!", 1, 2, nil},
	{12, 7677, 2, 1, "White Stallion Exchange", 1, 2, nil},
	{12, 7678, 2, 1, "Palomino Exchange", 1, 2, nil},
	{12, 7, 1, 2, "Kobold Camp Cleanup", 1, 2, nil},
	{12, 33, 1, 2, "Wolves Across the Border", 1, 2, nil},
	{12, 5261, 1, 2, "Eagan Peltskinner", 1, 2, nil},
	{12, 15, 1, 3, "Investigate Echo Ridge", 1, 2, nil},
	{12, 18, 1, 4, "Brotherhood of Thieves", 1, 2, nil},
	{12, 3903, 1, 4, "Milly Osworth", 1, 2, nil},
	{12, 3904, 1, 4, "Milly's Harvest", 1, 2, nil},
	{12, 3905, 1, 4, "Grape Manifest", 1, 2, nil},
	{12, 6, 1, 5, "Bounty on Garrick Padfoot", 1, 2, nil},
	{12, 21, 1, 5, "Skirmish at Echo Ridge", 1, 2, nil},
	{12, 54, 1, 5, "Report to Goldshire", 1, 2, nil},
	{12, 2158, 1, 5, "Rest and Relaxation", 1, 2, nil},
	{12, 84, 1, 6, "Back to Billy", 1, 2, nil},
	{12, 85, 1, 6, "Lost Necklace", 1, 2, nil},
	{12, 86, 1, 6, "Pie for Billy", 1, 2, nil},
	{12, 106, 1, 6, "Young Lovers", 1, 2, nil},
	{12, 107, 1, 6, "Note to William", 1, 2, nil},
	{12, 111, 1, 6, "Speak with Gramma", 1, 2, nil},
	{12, 47, 1, 7, "Gold Dust Exchange", 1, 2, nil},
	{12, 60, 1, 7, "Kobold Candles", 1, 2, nil},
	{12, 61, 1, 7, "Shipment to Stormwind", 1, 2, nil},
	{12, 62, 1, 7, "The Fargodeep Mine", 1, 2, nil},
	{12, 112, 1, 7, "Collecting Kelp", 1, 2, nil},
	{12, 114, 1, 7, "The Escape", 1, 2, nil},
	{12, 87, 1, 8, "Goldtooth", 1, 2, nil},
	{12, 83, 1, 9, "Red Linen Goods", 1, 2, nil},
	{12, 88, 1, 9, "Princess Must Die!", 1, 2, nil},
	{12, 5545, 1, 9, "A Bundle of Trouble", 1, 2, nil},
	{12, 11, 1, 10, "Riverpaw Gnoll Bounty", 1, 2, nil},
	{12, 35, 1, 10, "Further Concerns", 1, 2, nil},
	{12, 37, 1, 10, "Find the Lost Guards", 1, 2, nil},
	{12, 39, 1, 10, "Deliver Thomas' Report", 1, 2, nil},
	{12, 40, 1, 10, "A Fishy Peril", 1, 2, nil},
	{12, 45, 1, 10, "Discover Rolf's Fate", 1, 2, nil},
	{12, 46, 1, 10, "Bounty on Murlocs", 1, 2, nil},
	{12, 52, 1, 10, "Protect the Frontier", 1, 2, nil},
	{12, 59, 1, 10, "Cloth and Leather Armor", 1, 2, nil},
	{12, 71, 1, 10, "Report to Thomas", 1, 2, nil},
	{12, 76, 1, 10, "The Jasperlode Mine", 1, 2, nil},
	{12, 109, 1, 10, "Report to Gryan Stoutmantle", 1, 2, nil},
	{12, 123, 1, 10, "The Collector", 1, 2, nil},
	{12, 147, 1, 10, "Manhunt", 1, 2, nil},
	{12, 239, 1, 10, "Westbrook Garrison Needs Help!", 1, 2, nil},
	{12, 176, 1, 11, "Wanted: \"Hogger\" [Group]", 1, 2, nil},
	{12, 14079, 4, 20, "Learn to Ride in Elwynn Forest", 1, 2, nil},
	{3430, 8325, 1, 1, "Reclaiming Sunstrider Isle", 2, 2, nil},
	{3430, 8547, 1, 1, "Welcome!", 2, 2, nil},
	{3430, 10068, 1, 2, "Well Watcher Solanian", 2, 1, "TODO:CLASS"},
	{3430, 10069, 1, 2, "Well Watcher Solanian", 2, 1, "TODO:CLASS"},
	{3430, 10070, 1, 2, "Well Watcher Solanian", 2, 1, "TODO:CLASS"},
	{3430, 10071, 1, 2, "Well Watcher Solanian", 2, 1, "TODO:CLASS"},
	{3430, 10072, 1, 2, "Well Watcher Solanian", 2, 1, "TODO:CLASS"},
	{3430, 10073, 1, 2, "Well Watcher Solanian", 2, 1, "TODO:CLASS"},
	{3430, 8326, 1, 3, "Unfortunate Measures", 2, 2, nil},
	{3430, 8327, 1, 3, "Report to Lanthan Perilon", 2, 2, nil},
	{3430, 8346, 1, 3, "Thirst Unending", 2, 2, nil},
	{3430, 8330, 1, 4, "Solanian's Belongings", 2, 2, nil},
	{3430, 8334, 1, 4, "Aggression", 2, 2, nil},
	{3430, 8336, 1, 4, "A Fistful of Slivers", 2, 2, nil},
	{3430, 8338, 1, 4, "Tainted Arcane Sliver", 2, 2, nil},
	{3430, 8345, 1, 4, "The Shrine of Dath'Remar", 2, 2, nil},
	{3430, 8335, 1, 5, "Felendren the Banished", 2, 2, nil},
	{3430, 8347, 1, 5, "Aiding the Outrunners", 2, 2, nil},
	{3430, 8350, 1, 5, "Completing the Delivery", 2, 2, nil},
	{3430, 8463, 1, 5, "Unstable Mana Crystals", 2, 2, nil},
	{3430, 8472, 1, 5, "Major Malfunction", 2, 2, nil},
	{3430, 9119, 1, 5, "Malfunction at the West Sanctum", 2, 2, nil},
	{3430, 9704, 1, 5, "Slain by the Wretched", 2, 2, nil},
	{3430, 9705, 1, 5, "Package Recovery", 2, 2, nil},
	{3430, 8468, 1, 6, "Wanted: Thaelis the Hungerer", 2, 2, nil},
	{3430, 8475, 1, 6, "The Dead Scar", 2, 2, nil},
	{3430, 8482, 1, 6, "Incriminating Documents", 2, 2, nil},
	{3430, 8486, 1, 6, "Arcane Instability", 2, 2, nil},
	{3430, 8895, 1, 6, "Delivery to the North Sanctum", 2, 2, nil},
	{3430, 9035, 1, 6, "Roadside Ambush", 2, 2, nil},
	{3430, 9062, 1, 6, "Soaked Pages", 2, 2, nil},
	{3430, 9064, 1, 6, "Taking the Fall", 2, 2, nil},
	{3430, 9066, 1, 6, "Swift Discipline", 2, 2, nil},
	{3430, 9352, 1, 6, "Darnassian Intrusions", 2, 2, nil},
	{3430, 8480, 1, 7, "Lost Armaments", 2, 2, nil},
	{3430, 8483, 1, 7, "The Dwarven Spy", 2, 2, nil},
	{3430, 8491, 1, 7, "Pelt Collection", 2, 2, nil},
	{3430, 8884, 1, 7, "Fish Heads, Fish Heads...", 2, 2, nil},
	{3430, 8892, 1, 7, "Situation at Sunsail Anchorage", 2, 2, nil},
	{3430, 9256, 1, 7, "Fairbreeze Village", 2, 2, nil},
	{3430, 8886, 1, 8, "Grimscale Pirates!", 2, 2, nil},
	{3430, 8887, 1, 8, "Captain Kelisendra's Lost Rutters", 2, 2, nil},
	{3430, 9076, 1, 8, "Wretched Ringleader", 2, 2, nil},
	{3430, 8473, 1, 9, "A Somber Task", 2, 2, nil},
	{3430, 8487, 1, 9, "Corrupted Soil", 2, 2, nil},
	{3430, 8488, 1, 9, "Unexpected Results", 2, 2, nil},
	{3430, 8885, 1, 9, "The Ring of Mmmrrrggglll", 2, 2, nil},
	{3430, 9067, 1, 9, "The Party Never Ends", 2, 2, nil},
	{3430, 9252, 1, 9, "Defending Fairbreeze Village", 2, 2, nil},
	{3430, 9254, 1, 9, "The Wayward Apprentice", 2, 2, nil},
	{3430, 9255, 1, 9, "Research Notes", 2, 2, nil},
	{3430, 9358, 1, 9, "Ranger Sareyn", 2, 2, nil},
	{3430, 9395, 1, 9, "Saltheril's Haven", 2, 2, nil},
	{3430, 8474, 1, 10, "Old Whitebark's Pendant", 2, 2, nil},
	{3430, 8476, 1, 10, "Amani Encroachment", 2, 2, nil},
	{3430, 8477, 1, 10, "The Spearcrafter's Hammer", 2, 2, nil},
	{3430, 8490, 1, 10, "Powering our Defenses", 2, 2, nil},
	{3430, 8888, 1, 10, "The Magister's Apprentice", 2, 2, nil},
	{3430, 8889, 1, 10, "Deactivating the Spire", 2, 2, nil},
	{3430, 8890, 1, 10, "Word from the Spire", 2, 2, nil},
	{3430, 8891, 1, 10, "Abandoned Investigations", 2, 2, nil},
	{3430, 8894, 1, 10, "Cleaning up the Grounds", 2, 2, nil},
	{3430, 9253, 1, 10, "Runewarden Deryan", 2, 2, nil},
	{3430, 9258, 1, 10, "The Scorched Grove", 2, 2, nil},
	{3430, 9359, 1, 10, "Farstrider Retreat", 2, 2, nil},
	{3430, 9394, 1, 10, "Where's Wyllithen?", 2, 2, nil},
	{3430, 10166, 1, 10, "Whitebark's Memory", 2, 2, nil},
	{3430, 8479, 1, 11, "Zul'Marosh", 2, 2, nil},
	{3430, 9360, 1, 11, "Amani Invasion", 2, 2, nil},
	{3430, 9363, 1, 11, "Warning Fairbreeze Village", 2, 2, nil},
	{3430, 14081, 1, 20, "Learn to Ride in the Eversong Woods", 2, 2, nil},
	{3433, 9130, 1, 10, "Goods from Silvermoon City", 2, 2, nil},
	{3433, 9133, 1, 10, "Fly to Silvermoon City", 2, 2, nil},
	{3433, 9134, 1, 10, "Skymistress Gloaming", 2, 2, nil},
	{3433, 9135, 1, 10, "Return to Quartermaster Lymel", 2, 2, nil},
	{3433, 9138, 1, 10, "Suncrown Village", 2, 2, nil},
	{3433, 9144, 1, 10, "Missing in the Ghostlands", 2, 2, nil},
	{3433, 9147, 1, 10, "The Fallen Courier", 2, 2, nil},
	{3433, 9148, 1, 10, "Delivery to Tranquillien", 2, 2, nil},
	{3433, 9327, 1, 10, "The Forsaken", 2, 2, nil},
	{3433, 9329, 1, 10, "The Forsaken", 2, 2, nil},
	{3433, 9758, 1, 10, "Return to Arcanist Vandril", 2, 2, nil},
	{3433, 9139, 1, 11, "Goldenmist Village", 2, 2, nil},
	{3433, 9152, 1, 11, "Tomber's Supplies", 2, 2, nil},
	{3433, 9160, 1, 11, "Investigate An'daroth", 2, 2, nil},
	{3433, 9315, 1, 11, "Anok'suten [Group]", 2, 2, nil},
	{3433, 9143, 1, 12, "Dealing with Zeb'Sora", 2, 2, nil},
	{3433, 9145, 1, 12, "Help Ranger Valanna!", 2, 2, nil},
	{3433, 9146, 1, 12, "Report to Captain Helios", 2, 2, nil},
	{3433, 9150, 1, 12, "Salvaging the Past", 2, 2, nil},
	{3433, 9157, 1, 12, "Forgotten Rituals", 2, 2, nil},
	{3433, 9274, 1, 12, "Spirits of the Drowned", 2, 2, nil},
	{3433, 9149, 1, 13, "The Plagued Coast", 2, 2, nil},
	{3433, 9174, 1, 13, "Vanquishing Aquantion", 2, 2, nil},
	{3433, 9140, 1, 14, "Windrunner Village", 2, 2, nil},
	{3433, 9155, 1, 14, "Down the Dead Scar", 2, 2, nil},
	{3433, 9158, 1, 14, "Bearers of the Plague", 2, 2, nil},
	{3433, 9163, 1, 14, "Into Occupied Territory", 2, 2, nil},
	{3433, 9192, 1, 14, "Trouble at the Underlight Mines", 2, 2, nil},
	{3433, 9207, 1, 14, "Underlight Ore Samples", 2, 2, nil},
	{3433, 9159, 1, 15, "Curbing the Plague", 2, 2, nil},
	{3433, 9171, 1, 15, "Culinary Crunch", 2, 2, nil},
	{3433, 9173, 1, 15, "Retaking Windrunner Spire", 2, 2, nil},
	{3433, 9175, 1, 15, "The Lady's Necklace", 2, 2, nil},
	{3433, 9161, 1, 16, "The Traitor's Shadow", 2, 2, nil},
	{3433, 9162, 1, 16, "Hints of the Past", 2, 2, nil},
	{3433, 9166, 1, 16, "Deliver the Plans to An'telas", 2, 2, nil},
	{3433, 9169, 1, 16, "Deactivate An'owyn", 2, 2, nil},
	{3433, 9172, 1, 16, "Report to Magister Kaendris", 2, 2, nil},
	{3433, 9216, 1, 16, "Rotting Hearts", 2, 2, nil},
	{3433, 9217, 2, 16, "More Rotting Hearts", 2, 2, nil},
	{3433, 9282, 1, 16, "The Farstrider Enclave", 2, 2, nil},
	{3433, 9176, 1, 17, "The Twin Ziggurats", 2, 2, nil},
	{3433, 9193, 1, 17, "Investigate the Amani Catacombs", 2, 2, nil},
	{3433, 9199, 1, 17, "Troll Juju", 2, 2, nil},
	{3433, 9212, 1, 17, "Escape from the Catacombs", 2, 2, nil},
	{3433, 9214, 1, 18, "Shadowpine Weaponry", 2, 2, nil},
	{3433, 9218, 1, 18, "Spinal Dust", 2, 2, nil},
	{3433, 9219, 2, 18, "More Spinal Dust", 2, 2, nil},
	{3433, 9276, 1, 18, "Attack on Zeb'Tela", 2, 2, nil},
	{3433, 9281, 1, 18, "Clearing the Way", 2, 2, nil},
	{3433, 9275, 1, 19, "A Little Dash of Seasoning", 2, 2, nil},
	{3433, 9277, 1, 19, "Assault on Zeb'Nowa", 2, 2, nil},
	{3433, 9151, 1, 20, "The Sanctum of the Sun", 2, 2, nil},
	{3433, 9164, 1, 20, "Captives at Deatholme", 2, 2, nil},
	{3433, 9170, 1, 20, "Dar'Khan's Lieutenants", 2, 2, nil},
	{3433, 9215, 1, 20, "Bring Me Kel'gash's Head! [Group]", 2, 2, nil},
	{3433, 9220, 1, 20, "War on Deatholme", 2, 2, nil},
	{3433, 9877, 1, 20, "A Restorative Draught", 2, 2, nil},
	{3433, 9156, 1, 21, "Wanted: Knucklerot and Luzran [Group]", 2, 2, nil},
	{3433, 9167, 1, 21, "The Traitor's Destruction [Group]", 2, 2, nil},
	{3433, 9328, 1, 21, "Hero of the Sin'dorei", 2, 2, nil},
	{3433, 9811, 1, 21, "Friend of the Sin'dorei", 2, 2, nil},
	{267, 28617, 1, 0, "Flower Power", 1, 2, nil},
	{267, 28733, 1, 0, "Basic Botany", 1, 2, nil},
	{267, 28744, 1, 0, "Ghouls Hate My Grains", 1, 2, nil},
	{267, 28747, 1, 0, "Someone Setup the Pumpkin Bomb", 1, 2, nil},
	{267, 28748, 1, 0, "Lawn of the Dead", 1, 2, nil},
	{267, 494, 1, 20, "Time To Strike", 2, 2, nil},
	{267, 9425, 1, 20, "Report to Tarren Mill", 2, 2, nil},
	{267, 496, 1, 22, "Elixir of Suffering", 2, 2, nil},
	{267, 498, 1, 22, "The Rescue", 2, 2, nil},
	{267, 499, 1, 22, "Elixir of Suffering", 2, 2, nil},
	{267, 549, 1, 22, "WANTED: Syndicate Personnel", 2, 2, nil},
	{267, 501, 1, 24, "Elixir of Pain", 2, 2, nil},
	{267, 502, 1, 24, "Elixir of Pain", 2, 2, nil},
	{267, 527, 1, 24, "Battle of Hillsbrad", 2, 2, nil},
	{267, 528, 1, 25, "Battle of Hillsbrad", 2, 2, nil},
	{267, 546, 1, 25, "Souvenirs of Death", 2, 2, nil},
	{267, 529, 1, 26, "Battle of Hillsbrad", 2, 2, nil},
	{267, 532, 1, 26, "Battle of Hillsbrad", 2, 2, nil},
	{267, 509, 1, 28, "Elixir of Agony", 2, 2, nil},
	{267, 513, 1, 28, "Elixir of Agony", 2, 2, nil},
	{267, 539, 1, 28, "Battle of Hillsbrad", 2, 2, nil},
	{267, 567, 1, 28, "Dangerous!", 2, 2, nil},
	{267, 9435, 1, 29, "Missing Crystals", 1, 2, nil},
	{267, 536, 1, 30, "Down the Coast", 1, 2, nil},
	{267, 515, 1, 30, "Elixir of Agony", 2, 2, nil},
	{267, 517, 1, 30, "Elixir of Agony", 2, 2, nil},
	{267, 524, 1, 30, "Elixir of Agony", 2, 2, nil},
	{267, 541, 1, 30, "Battle of Hillsbrad", 2, 2, nil},
	{267, 547, 1, 30, "Humbert's Sword", 2, 2, nil},
	{267, 555, 1, 31, "Soothing Turtle Bisque", 1, 2, nil},
	{267, 559, 1, 32, "Farren's Proof", 1, 2, nil},
	{267, 560, 1, 32, "Farren's Proof", 1, 2, nil},
	{267, 561, 1, 32, "Farren's Proof", 1, 2, nil},
	{267, 562, 1, 32, "Stormwind Ho!", 1, 2, nil},
	{267, 563, 1, 32, "Reassignment", 1, 2, nil},
	{267, 556, 1, 32, "Stone Tokens", 2, 2, nil},
	{267, 676, 1, 32, "The Hammer May Fall", 2, 2, nil},
	{267, 14351, 1, 32, "Battle of Hillsbrad", 2, 2, nil},
	{267, 659, 1, 33, "Hints of a New Plague?", 1, 2, nil},
	{267, 552, 1, 33, "Helcular's Revenge", 2, 2, nil},
	{267, 553, 1, 33, "Helcular's Revenge", 2, 2, nil},
	{267, 564, 1, 34, "Costly Menace", 1, 2, nil},
	{267, 565, 1, 34, "Bartolo's Yeti Fur Cloak", 1, 2, nil},
	{267, 533, 1, 34, "Infiltration", 2, 2, nil},
	{267, 544, 1, 34, "Prison Break In", 2, 2, nil},
	{267, 557, 1, 34, "Bracers of Binding", 2, 2, nil},
	{267, 545, 1, 35, "Dalaran Patrols", 2, 2, nil},
	{267, 657, 1, 36, "Hints of a New Plague?", 1, 2, nil},
	{267, 658, 1, 36, "Hints of a New Plague?", 1, 2, nil},
	{267, 503, 1, 36, "Gol'dir", 2, 2, nil},
	{267, 506, 1, 36, "Blackmoore's Legacy", 2, 2, nil},
	{267, 660, 1, 37, "Hints of a New Plague?", 1, 2, nil},
	{267, 661, 1, 37, "Hints of a New Plague?", 1, 2, nil},
	{267, 518, 1, 39, "The Crown of Will", 2, 2, nil},
	{267, 508, 1, 40, "Taretha's Gift", 2, 2, nil},
	{267, 566, 1, 40, "WANTED: Baron Vardus", 2, 2, nil},
	{267, 519, 1, 41, "The Crown of Will", 2, 2, nil},
	{267, 507, 1, 42, "Lord Aliden Perenolde", 2, 2, nil},
	{267, 520, 1, 43, "The Crown of Will", 2, 2, nil},
	{267, 521, 1, 43, "The Crown of Will", 2, 2, nil},
	{1537, 7905, 1, 0, "The Darkmoon Faire", 1, 2, nil},
	{1537, 2039, 1, 15, "Find Bingles", 1, 2, nil},
	{1537, 2041, 1, 15, "Speak with Shoni", 1, 2, nil},
	{1537, 637, 1, 30, "Sully Balloo's Letter", 1, 2, nil},
	{1537, 683, 1, 30, "Sara Balloo's Plea", 1, 2, nil},
	{1537, 686, 1, 30, "A King's Tribute", 1, 2, nil},
	{1537, 689, 1, 31, "A King's Tribute", 1, 2, nil},
	{1537, 700, 1, 31, "A King's Tribute", 1, 2, nil},
	{1537, 1453, 1, 33, "Reclaimers' Business in Desolace", 1, 2, nil},
	{1537, 2948, 1, 35, "Gnome Improvement", 1, 2, nil},
	{1537, 707, 1, 37, "Ironband Wants You!", 1, 2, nil},
	{1537, 3201, 1, 43, "At Last!", 1, 2, nil},
	{1537, 3371, 1, 46, "Dwarven Justice", 1, 2, nil},
	{1537, 2439, 1, 47, "The Platinum Discs", 1, 2, nil},
	{1537, 2946, 1, 50, "Seeing What Happens [Group]", 1, 2, nil},
	{1537, 2963, 1, 50, "Portents of Uldum", 1, 2, nil},
	{1537, 2964, 1, 50, "A Future Task", 1, 2, nil},
	{1537, 2977, 1, 50, "Return to Ironforge", 1, 2, nil},
	{1537, 3790, 1, 50, "Assisting Arch Druid Staghelm", 1, 2, nil},
	{1537, 5090, 1, 50, "A Call to Arms: The Plaguelands!", 1, 2, nil},
	{1537, 3448, 1, 52, "Passing the Burden", 1, 2, nil},
	{1537, 3449, 1, 52, "Arcane Runes", 1, 2, nil},
	{1537, 3450, 1, 52, "An Easy Pickup", 1, 2, nil},
	{1537, 3451, 1, 52, "Signal for Pickup", 1, 2, nil},
	{1537, 3461, 1, 52, "Return to Tymor", 1, 2, nil},
	{1537, 3483, 2, 52, "Signal for Pickup", 1, 2, nil},
	{1537, 4512, 1, 52, "A Little Slime Goes a Long Way", 1, 2, nil},
	{1537, 3701, 1, 54, "The Smoldering Ruins of Thaurissan", 1, 2, nil},
	{1537, 3702, 1, 54, "The Smoldering Ruins of Thaurissan", 1, 2, nil},
	{1537, 4513, 1, 54, "A Little Slime Goes a Long Way", 1, 2, nil},
	{1537, 1019, 1, 55, "The New Frontier", 1, 2, nil},
	{1537, 8275, 1, 55, "Taking Back Silithus", 1, 2, nil},
	{1537, 7342, 2, 60, "Arrows Are For Sissies", 1, 2, nil},
	{1537, 7802, 1, 60, "A Donation of Wool", 1, 2, nil},
	{1537, 7803, 1, 60, "A Donation of Silk", 1, 2, nil},
	{1537, 7804, 1, 60, "A Donation of Mageweave", 1, 2, nil},
	{1537, 7805, 1, 60, "A Donation of Runecloth", 1, 2, nil},
	{1537, 7806, 2, 60, "Additional Runecloth", 1, 2, nil},
	{1537, 7807, 1, 60, "A Donation of Wool", 1, 2, nil},
	{1537, 7808, 1, 60, "A Donation of Silk", 1, 2, nil},
	{1537, 7809, 1, 60, "A Donation of Mageweave", 1, 2, nil},
	{1537, 7811, 1, 60, "A Donation of Runecloth", 1, 2, nil},
	{1537, 7812, 2, 60, "Additional Runecloth", 1, 2, nil},
	{1537, 8905, 1, 60, "An Earnest Proposition", 1, 1, "TODO:CLASS"},
	{1537, 8906, 1, 60, "An Earnest Proposition", 1, 1, "TODO:CLASS"},
	{1537, 8907, 1, 60, "An Earnest Proposition", 1, 1, "TODO:CLASS"},
	{1537, 8908, 1, 60, "An Earnest Proposition", 1, 1, "TODO:CLASS"},
	{1537, 8909, 1, 60, "An Earnest Proposition", 1, 1, "TODO:CLASS"},
	{1537, 8910, 1, 60, "An Earnest Proposition", 1, 1, "TODO:CLASS"},
	{1537, 8911, 1, 60, "An Earnest Proposition", 1, 1, "TODO:CLASS"},
	{1537, 8912, 1, 60, "An Earnest Proposition", 1, 1, "TODO:CLASS"},
	{1537, 8926, 1, 60, "Just Compensation", 1, 1, "TODO:CLASS"},
	{1537, 8931, 1, 60, "Just Compensation", 1, 1, "TODO:CLASS"},
	{1537, 8932, 1, 60, "Just Compensation", 1, 1, "TODO:CLASS"},
	{1537, 8933, 1, 60, "Just Compensation", 1, 1, "TODO:CLASS"},
	{1537, 8934, 1, 60, "Just Compensation", 1, 1, "TODO:CLASS"},
	{1537, 8935, 1, 60, "Just Compensation", 1, 1, "TODO:CLASS"},
	{1537, 8936, 1, 60, "Just Compensation", 1, 1, "TODO:CLASS"},
	{1537, 8937, 1, 60, "Just Compensation", 1, 1, "TODO:CLASS"},
	{1537, 8951, 1, 60, "Anthion's Parting Words", 1, 1, "TODO:CLASS"},
	{1537, 8952, 1, 60, "Anthion's Parting Words", 1, 1, "TODO:CLASS"},
	{1537, 8953, 1, 60, "Anthion's Parting Words", 1, 1, "TODO:CLASS"},
	{1537, 8954, 1, 60, "Anthion's Parting Words", 1, 1, "TODO:CLASS"},
	{1537, 8955, 1, 60, "Anthion's Parting Words", 1, 1, "TODO:CLASS"},
	{1537, 8956, 1, 60, "Anthion's Parting Words", 1, 1, "TODO:CLASS"},
	{1537, 8958, 1, 60, "Anthion's Parting Words", 1, 1, "TODO:CLASS"},
	{1537, 8959, 1, 60, "Anthion's Parting Words", 1, 1, "TODO:CLASS"},
	{1537, 8977, 1, 60, "Return to Deliana", 1, 2, nil},
	{1537, 8997, 1, 60, "Back to the Beginning", 1, 2, nil},
	{1537, 8999, 1, 60, "Saving the Best for Last", 1, 1, "TODO:CLASS"},
	{1537, 9000, 1, 60, "Saving the Best for Last", 1, 1, "TODO:CLASS"},
	{1537, 9001, 1, 60, "Saving the Best for Last", 1, 1, "TODO:CLASS"},
	{1537, 9002, 1, 60, "Saving the Best for Last", 1, 1, "TODO:CLASS"},
	{1537, 9003, 1, 60, "Saving the Best for Last", 1, 1, "TODO:CLASS"},
	{1537, 9004, 1, 60, "Saving the Best for Last", 1, 1, "TODO:CLASS"},
	{1537, 9005, 1, 60, "Saving the Best for Last", 1, 1, "TODO:CLASS"},
	{1537, 9006, 1, 60, "Saving the Best for Last", 1, 1, "TODO:CLASS"},
	{1537, 10492, 1, 60, "An Earnest Proposition", 1, 1, "TODO:CLASS"},
	{1537, 10494, 1, 60, "Just Compensation", 1, 1, "TODO:CLASS"},
	{1537, 10496, 1, 60, "Anthion's Parting Words", 1, 1, "TODO:CLASS"},
	{1537, 10498, 1, 60, "Saving the Best for Last", 1, 1, "TODO:CLASS"},
	{4080, 11481, 1, 70, "Crisis at the Sunwell", 3, 2, nil},
	{4080, 11482, 1, 70, "Duty Calls", 3, 2, nil},
	{4080, 11496, 3, 70, "The Sanctum Wards", 3, 2, nil},
	{4080, 11523, 3, 70, "Arm the Wards!", 3, 2, nil},
	{4080, 11524, 3, 70, "Erratic Behavior", 3, 2, nil},
	{4080, 11525, 3, 70, "Further Conversions", 3, 2, nil},
	{4080, 11526, 1, 70, "The Missing Magistrix", 3, 2, nil},
	{4080, 11532, 3, 70, "Distraction at the Dead Scar", 3, 2, nil},
	{4080, 11533, 3, 70, "The Air Strikes Must Continue", 3, 2, nil},
	{4080, 11535, 3, 70, "Making Ready", 3, 2, nil},
	{4080, 11536, 3, 70, "Don't Stop Now....", 3, 2, nil},
	{4080, 11537, 3, 70, "The Battle Must Go On", 3, 2, nil},
	{4080, 11538, 3, 70, "The Battle for the Sun's Reach Armory", 3, 2, nil},
	{4080, 11539, 3, 70, "Taking the Harbor", 3, 2, nil},
	{4080, 11540, 3, 70, "Crush the Dawnblade", 3, 2, nil},
	{4080, 11541, 3, 70, "Disrupt the Greengill Coast", 3, 2, nil},
	{4080, 11542, 3, 70, "Intercept the Reinforcements", 3, 2, nil},
	{4080, 11543, 3, 70, "Keeping the Enemy at Bay", 3, 2, nil},
	{4080, 11545, 3, 70, "A Charitable Donation", 3, 2, nil},
	{4080, 11546, 3, 70, "Open for Business", 3, 2, nil},
	{4080, 11547, 3, 70, "Know Your Ley Lines", 3, 2, nil},
	{4080, 11548, 3, 70, "Your Continued Support", 3, 2, nil},
	{4080, 11549, 1, 70, "A Magnanimous Benefactor", 3, 2, nil},
	{4080, 11550, 1, 70, "Enter, the Deceiver...", 3, 2, nil},
	{4080, 11554, 1, 70, "A Friend in the Frontlines", 3, 2, nil},
	{4080, 11555, 1, 70, "Honored by Your Allies", 3, 2, nil},
	{4080, 11556, 1, 70, "Revered in the Field of Battle", 3, 2, nil},
	{4080, 11557, 1, 70, "Exalted Among All Combatants", 3, 2, nil},
	{4080, 24522, 1, 80, "Journey To The Sunwell", 1, 2, nil},
	{4080, 24535, 1, 80, "Thalorien Dawnseeker", 1, 2, nil},
	{4080, 24562, 1, 80, "Journey To The Sunwell", 2, 2, nil},
	{4080, 24563, 1, 80, "Thalorien Dawnseeker", 2, 2, nil},
	{38, 6387, 1, 10, "Honor Students", 1, 2, nil},
	{38, 6388, 1, 10, "Gryth Thurden", 1, 2, nil},
	{38, 6391, 1, 10, "Ride to Ironforge", 1, 2, nil},
	{38, 6392, 1, 10, "Return to Brock", 1, 2, nil},
	{38, 416, 1, 11, "Rat Catching", 1, 2, nil},
	{38, 418, 1, 11, "Thelsamar Blood Sausages", 1, 2, nil},
	{38, 224, 1, 12, "In Defense of the King's Lands", 1, 2, nil},
	{38, 267, 1, 12, "The Trogg Threat", 1, 2, nil},
	{38, 1338, 1, 14, "Stormpike's Order", 1, 2, nil},
	{38, 237, 1, 15, "In Defense of the King's Lands", 1, 2, nil},
	{38, 263, 1, 15, "In Defense of the King's Lands", 1, 2, nil},
	{38, 273, 1, 15, "Resupplying the Excavation", 1, 2, nil},
	{38, 298, 1, 15, "Excavation Progress Report", 1, 2, nil},
	{38, 301, 1, 15, "Report to Ironforge", 1, 2, nil},
	{38, 302, 1, 15, "Powder to Ironband", 1, 2, nil},
	{38, 307, 1, 15, "Filthy Paws", 1, 2, nil},
	{38, 309, 1, 15, "Protecting the Shipment", 1, 2, nil},
	{38, 385, 1, 15, "Crocolisk Hunting", 1, 2, nil},
	{38, 454, 1, 15, "After the Ambush", 1, 2, nil},
	{38, 1339, 1, 15, "Mountaineer Stormpike's Task", 1, 2, nil},
	{38, 2038, 1, 15, "Bingles' Missing Supplies", 1, 2, nil},
	{38, 257, 1, 16, "A Hunter's Boast", 1, 2, nil},
	{38, 217, 1, 17, "In Defense of the King's Lands", 1, 2, nil},
	{38, 258, 1, 17, "A Hunter's Challenge", 1, 2, nil},
	{38, 161, 1, 18, "A Dark Threat Looms", 1, 2, nil},
	{38, 199, 1, 18, "A Dark Threat Looms", 1, 2, nil},
	{38, 250, 1, 18, "A Dark Threat Looms", 1, 2, nil},
	{38, 274, 1, 18, "A Dark Threat Looms", 1, 2, nil},
	{38, 278, 1, 18, "A Dark Threat Looms", 1, 2, nil},
	{38, 280, 1, 18, "A Dark Threat Looms", 1, 2, nil},
	{38, 297, 1, 18, "Gathering Idols", 1, 2, nil},
	{38, 436, 1, 18, "Ironband's Excavation", 1, 2, nil},
	{38, 255, 1, 19, "Mercenaries", 1, 2, nil},
	{38, 271, 1, 20, "Vyrin's Revenge", 1, 2, nil},
	{38, 283, 1, 20, "A Dark Threat Looms", 1, 2, nil},
	{38, 531, 1, 20, "Vyrin's Revenge", 1, 2, nil},
	{38, 256, 1, 22, "WANTED: Chok'sul [Group]", 1, 2, nil},
	{38, 2500, 1, 39, "Badlands Reagent Run", 1, 2, nil},
	{38, 3182, 1, 43, "Proof of Deed", 1, 2, nil},
	{38, 2501, 1, 44, "Badlands Reagent Run II", 1, 2, nil},
	{44, 120, 1, 14, "Messenger to Stormwind", 1, 2, nil},
	{44, 121, 1, 14, "Messenger to Stormwind", 1, 2, nil},
	{44, 143, 1, 14, "Messenger to Westfall", 1, 2, nil},
	{44, 144, 1, 14, "Messenger to Westfall", 1, 2, nil},
	{44, 116, 1, 15, "Dry Times", 1, 2, nil},
	{44, 129, 1, 15, "A Free Lunch", 1, 2, nil},
	{44, 130, 1, 15, "Visit the Herbalist", 1, 2, nil},
	{44, 131, 1, 15, "Delivering Daffodils", 1, 2, nil},
	{44, 3741, 1, 15, "Hilary's Necklace", 3, 2, nil},
	{44, 125, 1, 16, "The Lost Tools", 1, 2, nil},
	{44, 244, 1, 16, "Encroaching Gnolls", 1, 2, nil},
	{44, 246, 1, 17, "Assessing the Threat", 1, 2, nil},
	{44, 92, 1, 18, "Redridge Goulash", 1, 2, nil},
	{44, 118, 1, 18, "The Price of Shoes", 1, 2, nil},
	{44, 119, 1, 18, "Return to Verner", 1, 2, nil},
	{44, 122, 1, 18, "Underbelly Scales", 1, 2, nil},
	{44, 145, 1, 18, "Messenger to Darkshire", 1, 2, nil},
	{44, 146, 1, 18, "Messenger to Darkshire", 1, 2, nil},
	{44, 89, 1, 20, "The Everstill Bridge", 1, 2, nil},
	{44, 124, 1, 20, "A Baying of Gnolls", 1, 2, nil},
	{44, 150, 1, 20, "Murloc Poachers", 1, 2, nil},
	{44, 20, 1, 21, "Blackrock Menace", 1, 2, nil},
	{44, 94, 1, 21, "A Watchful Eye", 1, 2, nil},
	{44, 126, 1, 21, "Howling in the Hills", 1, 2, nil},
	{44, 127, 1, 21, "Selling Fish", 1, 2, nil},
	{44, 248, 1, 22, "Looking Further", 1, 2, nil},
	{44, 91, 1, 23, "Solomon's Law", 1, 2, nil},
	{44, 115, 1, 23, "Shadow Magic", 1, 2, nil},
	{44, 178, 1, 23, "Theocritus' Retrieval", 1, 2, nil},
	{44, 34, 1, 24, "An Unwelcome Guest", 1, 2, nil},
	{44, 19, 1, 25, "Tharil'zun [Group]", 1, 2, nil},
	{44, 128, 1, 25, "Blackrock Bounty", 1, 2, nil},
	{44, 219, 1, 25, "Missing In Action", 1, 2, nil},
	{44, 169, 1, 26, "Wanted: Gath'Ilzogg [Group]", 1, 2, nil},
	{44, 180, 1, 26, "Wanted: Lieutenant Fangore", 1, 2, nil},
	{44, 249, 1, 26, "Morganth", 1, 2, nil},
	{51, 3181, 1, 43, "The Horn of the Beast", 1, 2, nil},
	{51, 4449, 1, 45, "Caught!", 3, 2, nil},
	{51, 3367, 1, 46, "Suntara Stones", 1, 2, nil},
	{51, 3368, 1, 46, "Suntara Stones", 1, 2, nil},
	{51, 3372, 1, 46, "Release Them", 1, 2, nil},
	{51, 3566, 1, 46, "Rise, Obsidion!", 1, 2, nil},
	{51, 4450, 1, 46, "Ledger from Tanaris", 3, 2, nil},
	{51, 4451, 1, 47, "The Key to Freedom", 3, 2, nil},
	{51, 3441, 1, 48, "Divine Retribution", 3, 2, nil},
	{51, 3442, 1, 48, "The Flawless Flame", 3, 2, nil},
	{51, 3443, 1, 48, "Forging the Shaft", 3, 2, nil},
	{51, 7728, 1, 48, "STOLEN: Smithing Tuyere and Lookout's Spyglass", 3, 2, nil},
	{51, 7729, 1, 48, "JOB OPPORTUNITY: Culling the Competition", 3, 2, nil},
	{51, 7702, 1, 49, "Kill 'Em With Sleep Deprivation", 3, 2, nil},
	{51, 7723, 1, 49, "Curse These Fat Fingers", 3, 2, nil},
	{51, 7724, 1, 49, "Fiery Menace!", 3, 2, nil},
	{51, 7727, 1, 49, "Incendosaurs? Whateverosaur is More Like It", 3, 2, nil},
	{51, 3377, 1, 50, "Prayer to Elune", 1, 2, nil},
	{51, 3378, 1, 50, "Prayer to Elune", 1, 2, nil},
	{51, 3452, 1, 50, "The Flame's Casing", 3, 2, nil},
	{51, 3453, 1, 50, "The Torch of Retribution", 3, 2, nil},
	{51, 3454, 1, 50, "The Torch of Retribution", 3, 2, nil},
	{51, 3462, 1, 50, "Squire Maltrake", 3, 2, nil},
	{51, 3481, 1, 50, "Trinkets...", 3, 2, nil},
	{51, 7701, 1, 50, "WANTED: Overseer Maltorius", 3, 2, nil},
	{51, 7722, 1, 50, "What the Flux?", 3, 2, nil},
	{51, 3463, 1, 52, "Set Them Ablaze!", 3, 2, nil},
	{51, 7736, 2, 60, "Restoring Fiery Flux Supplies via Kingsblood", 3, 2, nil},
	{51, 7737, 2, 60, "Gaining Even More Acceptance", 3, 2, nil},
	{51, 8241, 2, 60, "Restoring Fiery Flux Supplies via Iron", 3, 2, nil},
	{51, 8242, 2, 60, "Restoring Fiery Flux Supplies via Heavy Leather", 3, 2, nil},
	{51, 13662, 2, 60, "Gaining Acceptance", 3, 2, nil},
	{3487, 9627, 1, 21, "Allegiance to the Horde", 2, 2, nil},
	{3487, 10374, 1, 50, "A Call to Arms: The Plaguelands!", 2, 2, nil},
	{3487, 10359, 1, 60, "A Donation of Wool", 2, 2, nil},
	{3487, 10360, 1, 60, "A Donation of Silk", 2, 2, nil},
	{3487, 10361, 1, 60, "A Donation of Mageweave", 2, 2, nil},
	{3487, 10362, 1, 60, "A Donation of Runecloth", 2, 2, nil},
	{3487, 10363, 2, 60, "Additional Runecloth", 2, 2, nil},
	{130, 421, 1, 10, "Prove Your Worth", 2, 2, nil},
	{130, 6321, 1, 10, "Supplying the Sepulcher", 2, 2, nil},
	{130, 6322, 1, 10, "Michael Garrett", 2, 2, nil},
	{130, 6323, 1, 10, "Ride to the Undercity", 2, 2, nil},
	{130, 6324, 1, 10, "Return to Podrig", 2, 2, nil},
	{130, 422, 1, 11, "Arugal's Folly", 2, 2, nil},
	{130, 429, 1, 11, "Wild Hearts", 2, 2, nil},
	{130, 430, 1, 11, "Return to Quinn", 2, 2, nil},
	{130, 435, 1, 11, "Escorting Erland", 2, 2, nil},
	{130, 449, 1, 11, "The Deathstalkers' Report", 2, 2, nil},
	{130, 425, 1, 12, "Ivar the Foul", 2, 2, nil},
	{130, 428, 1, 12, "Lost Deathstalkers", 2, 2, nil},
	{130, 447, 1, 12, "A Recipe For Death", 2, 2, nil},
	{130, 3221, 1, 12, "Speak with Renferrel", 2, 2, nil},
	{130, 423, 1, 14, "Arugal's Folly", 2, 2, nil},
	{130, 437, 1, 14, "The Dead Fields", 2, 2, nil},
	{130, 477, 1, 14, "Border Crossings", 2, 2, nil},
	{130, 478, 1, 14, "Maps and Runes", 2, 2, nil},
	{130, 481, 1, 14, "Dalar's Analysis", 2, 2, nil},
	{130, 482, 1, 14, "Dalaran's Intentions", 2, 2, nil},
	{130, 99, 1, 15, "Arugal's Folly", 2, 2, nil},
	{130, 424, 1, 15, "Arugal's Folly", 2, 2, nil},
	{130, 450, 1, 15, "A Recipe For Death", 2, 2, nil},
	{130, 452, 1, 15, "Pyrewood Ambush", 2, 2, nil},
	{130, 9189, 1, 15, "Delivery to the Sepulcher", 2, 2, nil},
	{130, 438, 1, 16, "The Decrepit Ferry", 2, 2, nil},
	{130, 439, 1, 16, "Rot Hide Clues", 2, 2, nil},
	{130, 440, 1, 16, "The Engraved Ring", 2, 2, nil},
	{130, 441, 1, 16, "Raleigh and the Undercity", 2, 2, nil},
	{130, 446, 1, 16, "Thule Ravenclaw", 2, 2, nil},
	{130, 448, 1, 16, "Report to Hadrec", 2, 2, nil},
	{130, 479, 1, 16, "Ambermill Investigations", 2, 2, nil},
	{130, 443, 1, 17, "Rot Hide Ichor", 2, 2, nil},
	{130, 444, 1, 17, "Rot Hide Origins", 2, 2, nil},
	{130, 460, 1, 17, "Resting in Pieces", 2, 2, nil},
	{130, 451, 1, 18, "A Recipe For Death", 2, 2, nil},
	{130, 461, 1, 18, "The Hidden Niche", 2, 2, nil},
	{130, 491, 1, 18, "Wand to Bethor", 2, 2, nil},
	{130, 442, 1, 20, "Assault on Fenris Isle", 2, 2, nil},
	{130, 493, 1, 20, "Journey to Hillsbrad Foothills", 2, 2, nil},
	{130, 530, 1, 20, "A Husband's Revenge", 2, 2, nil},
	{130, 516, 1, 21, "Beren's Peril", 2, 2, nil},
	{130, 480, 1, 22, "The Weaver", 2, 2, nil},
	{1519, 579, 2, 1, "Stormwind Library", 1, 2, nil},
	{1519, 332, 1, 2, "Wine Shop Advert", 1, 2, nil},
	{1519, 333, 1, 2, "Harlan Needs a Resupply", 1, 2, nil},
	{1519, 334, 1, 2, "Package for Thurman", 1, 2, nil},
	{1519, 353, 1, 15, "Stormpike's Delivery", 1, 2, nil},
	{1519, 399, 1, 15, "Humble Beginnings", 1, 2, nil},
	{1519, 1097, 1, 15, "Elmore's Task", 1, 2, nil},
	{1519, 373, 1, 22, "The Unsent Letter", 1, 2, nil},
	{1519, 389, 1, 22, "Bazil Thredd", 1, 2, nil},
	{1519, 343, 1, 24, "Speaking of Fortitude", 1, 2, nil},
	{1519, 344, 1, 24, "Brother Paxton", 1, 2, nil},
	{1519, 345, 1, 24, "Ink Supplies", 1, 2, nil},
	{1519, 346, 1, 24, "Return to Kristoff", 1, 2, nil},
	{1519, 347, 1, 24, "Rethban Ore", 1, 2, nil},
	{1519, 3765, 1, 24, "The Corruption Abroad", 1, 2, nil},
	{1519, 1241, 1, 28, "The Missing Diplomat", 1, 2, nil},
	{1519, 1242, 1, 28, "The Missing Diplomat", 1, 2, nil},
	{1519, 1243, 1, 28, "The Missing Diplomat", 1, 2, nil},
	{1519, 1274, 1, 28, "The Missing Diplomat", 1, 2, nil},
	{1519, 392, 1, 29, "The Curious Visitor", 1, 2, nil},
	{1519, 393, 1, 29, "Shadow of the Past", 1, 2, nil},
	{1519, 335, 1, 30, "A Noble Brew", 1, 2, nil},
	{1519, 336, 1, 30, "A Noble Brew", 1, 2, nil},
	{1519, 397, 1, 30, "You Have Served Us Well", 1, 1, "TODO:CLASS"},
	{1519, 1244, 1, 30, "The Missing Diplomat", 1, 2, nil},
	{1519, 1245, 1, 30, "The Missing Diplomat", 1, 2, nil},
	{1519, 350, 1, 31, "Look to an Old Friend", 1, 2, nil},
	{1519, 394, 1, 31, "The Head of the Beast", 1, 2, nil},
	{1519, 395, 1, 31, "Brotherhood's End", 1, 2, nil},
	{1519, 396, 1, 31, "An Audience with the King", 1, 2, nil},
	{1519, 434, 1, 31, "The Attack!", 1, 2, nil},
	{1519, 1246, 1, 31, "The Missing Diplomat", 1, 2, nil},
	{1519, 1247, 1, 31, "The Missing Diplomat", 1, 2, nil},
	{1519, 1447, 1, 31, "The Missing Diplomat", 1, 2, nil},
	{1519, 2745, 1, 31, "Infiltrating the Castle", 1, 2, nil},
	{1519, 2746, 1, 31, "Items of Some Consequence", 1, 2, nil},
	{1519, 690, 1, 32, "Malin's Request", 1, 2, nil},
	{1519, 1248, 1, 33, "The Missing Diplomat", 1, 2, nil},
	{1519, 1249, 1, 33, "The Missing Diplomat", 1, 2, nil},
	{1519, 1250, 1, 33, "The Missing Diplomat", 1, 2, nil},
	{1519, 1264, 1, 33, "The Missing Diplomat", 1, 2, nil},
	{1519, 1265, 1, 35, "The Missing Diplomat", 1, 2, nil},
	{1519, 1301, 1, 35, "James Hyal", 1, 2, nil},
	{1519, 1266, 1, 36, "The Missing Diplomat", 1, 2, nil},
	{1519, 538, 1, 38, "Southshore", 1, 2, nil},
	{1519, 540, 1, 38, "Preserving Knowledge", 1, 2, nil},
	{1519, 542, 1, 38, "Return to Milton", 1, 2, nil},
	{1519, 1267, 1, 38, "The Missing Diplomat", 1, 2, nil},
	{1519, 1324, 1, 38, "The Missing Diplomat", 1, 2, nil},
	{1519, 212, 1, 40, "A Meal Served Cold", 1, 2, nil},
	{1519, 543, 1, 40, "The Perenolde Tiara [Group]", 1, 2, nil},
	{1519, 1363, 1, 41, "Mazen's Behest", 1, 2, nil},
	{1519, 1364, 1, 41, "Mazen's Behest", 1, 2, nil},
	{1519, 1448, 1, 43, "In Search of The Temple [Group]", 1, 2, nil},
	{1519, 1449, 1, 43, "To The Hinterlands", 1, 2, nil},
	{1519, 1477, 1, 45, "Vital Supplies", 1, 2, nil},
	{1519, 3787, 1, 50, "Jonespyre's Request", 1, 2, nil},
	{1519, 3789, 1, 50, "Assisting Arch Druid Staghelm", 1, 2, nil},
	{1519, 5066, 1, 50, "A Call to Arms: The Plaguelands!", 1, 2, nil},
	{1519, 5048, 1, 52, "Good Natured Emma", 1, 2, nil},
	{1519, 1015, 1, 55, "The New Frontier", 1, 2, nil},
	{1519, 6182, 1, 60, "The First and the Last [Group]", 1, 2, nil},
	{1519, 6183, 1, 60, "Honor the Dead [Group]", 1, 2, nil},
	{1519, 6186, 1, 60, "The Blightcaller Cometh [Group]", 1, 2, nil},
	{1519, 6402, 4, 60, "Stormwind Rendezvous [Removed]", 1, 2, nil},
	{1519, 6403, 4, 60, "The Great Masquerade [Removed]", 1, 2, nil},
	{1519, 6501, 4, 60, "The Dragon's Eye [Removed]", 1, 2, nil},
	{1519, 7497, 1, 60, "The Journey Has Just Begun", 1, 2, nil},
	{1519, 7781, 1, 60, "The Lord of Blackrock", 1, 2, nil},
	{1519, 7782, 1, 60, "The Lord of Blackrock", 1, 2, nil},
	{1519, 7791, 1, 60, "A Donation of Wool", 1, 2, nil},
	{1519, 7793, 1, 60, "A Donation of Silk", 1, 2, nil},
	{1519, 7794, 1, 60, "A Donation of Mageweave", 1, 2, nil},
	{1519, 7795, 1, 60, "A Donation of Runecloth", 1, 2, nil},
	{1519, 7796, 2, 60, "Additional Runecloth", 1, 2, nil},
	{1519, 24428, 1, 80, "A Most Puzzling Circumstance", 1, 2, nil},
	{1519, 28825, 1, 80, "A Personal Summons", 1, 2, nil},
	{1519, 28826, 1, 80, "Eye of the Storm", 1, 2, nil},
	{33, 9259, 2, 0, "Traitor to the Bloodsail", 3, 2, nil},
	{33, 583, 1, 30, "Welcome to the Jungle", 3, 2, nil},
	{33, 185, 1, 31, "Tiger Mastery", 3, 2, nil},
	{33, 190, 1, 31, "Panther Mastery", 3, 2, nil},
	{33, 575, 1, 31, "Supply and Demand", 3, 2, nil},
	{33, 198, 1, 32, "Supplies to Private Thorsen", 1, 2, nil},
	{33, 201, 1, 32, "Investigate the Camp", 3, 2, nil},
	{33, 203, 1, 33, "The Second Rebellion", 1, 2, nil},
	{33, 215, 1, 33, "Jungle Secrets", 1, 2, nil},
	{33, 186, 1, 33, "Tiger Mastery", 3, 2, nil},
	{33, 191, 1, 33, "Panther Mastery", 3, 2, nil},
	{33, 204, 1, 34, "Bad Medicine", 1, 2, nil},
	{33, 581, 1, 34, "Hunt for Yenniku", 2, 2, nil},
	{33, 9436, 1, 34, "Bloodscalp Insight", 2, 2, nil},
	{33, 194, 1, 34, "Raptor Mastery", 3, 2, nil},
	{33, 200, 1, 35, "Bookie Herod", 1, 2, nil},
	{33, 187, 1, 35, "Tiger Mastery", 3, 2, nil},
	{33, 189, 1, 35, "Bloodscalp Ears", 3, 2, nil},
	{33, 605, 1, 35, "Singing Blue Shards", 3, 2, nil},
	{33, 568, 1, 36, "The Defense of Grom'gol", 2, 2, nil},
	{33, 9457, 1, 36, "An Unusual Patron", 2, 2, nil},
	{33, 195, 1, 36, "Raptor Mastery", 3, 2, nil},
	{33, 213, 1, 36, "Hostile Takeover", 3, 2, nil},
	{33, 577, 1, 36, "Some Assembly Required", 3, 2, nil},
	{33, 210, 1, 37, "Krazek's Cookery", 1, 2, nil},
	{33, 328, 1, 37, "The Hidden Key", 1, 2, nil},
	{33, 329, 1, 37, "The Spy Revealed!", 1, 2, nil},
	{33, 330, 1, 37, "Patrol Schedules", 1, 2, nil},
	{33, 331, 1, 37, "Report to Doren", 1, 2, nil},
	{33, 578, 1, 37, "The Stone of the Tides", 1, 2, nil},
	{33, 601, 1, 37, "Water Elementals", 1, 2, nil},
	{33, 602, 1, 37, "Magical Analysis", 1, 2, nil},
	{33, 603, 1, 37, "Ansirem's Key", 1, 2, nil},
	{33, 616, 1, 37, "The Haunted Isle", 1, 2, nil},
	{33, 622, 1, 37, "Return to Corporal Kaleb", 1, 2, nil},
	{33, 627, 1, 37, "Favor for Krazek", 1, 2, nil},
	{33, 569, 1, 37, "The Defense of Grom'gol", 2, 2, nil},
	{33, 582, 1, 37, "Headhunting", 2, 2, nil},
	{33, 596, 1, 37, "Bloody Bone Necklaces", 2, 2, nil},
	{33, 629, 1, 37, "The Vile Reef", 2, 2, nil},
	{33, 638, 1, 37, "Trollbane", 2, 2, nil},
	{33, 188, 1, 37, "Tiger Mastery", 3, 2, nil},
	{33, 207, 1, 38, "Kurzen's Mystery", 1, 2, nil},
	{33, 574, 1, 38, "Special Forces", 1, 2, nil},
	{33, 570, 1, 38, "Mok'thardin's Enchantment", 2, 2, nil},
	{33, 192, 1, 38, "Panther Mastery", 3, 2, nil},
	{33, 628, 1, 38, "Excelsior", 3, 2, nil},
	{33, 610, 1, 39, "\"Pretty Boy\" Duncan ", 1, 2, nil},
	{33, 202, 1, 40, "Colonel Kurzen", 1, 2, nil},
	{33, 205, 1, 40, "Troll Witchery", 1, 2, nil},
	{33, 611, 1, 40, "The Curse of the Tides", 1, 2, nil},
	{33, 585, 1, 40, "Speaking with Nezzliok", 2, 2, nil},
	{33, 193, 1, 40, "Panther Mastery", 3, 2, nil},
	{33, 338, 1, 40, "The Green Hills of Stranglethorn", 3, 2, nil},
	{33, 339, 1, 40, "Chapter I", 3, 2, nil},
	{33, 340, 1, 40, "Chapter II", 3, 2, nil},
	{33, 341, 1, 40, "Chapter III", 3, 2, nil},
	{33, 342, 1, 40, "Chapter IV", 3, 2, nil},
	{33, 571, 1, 41, "Mok'thardin's Enchantment", 2, 2, nil},
	{33, 572, 1, 41, "Mok'thardin's Enchantment", 2, 2, nil},
	{33, 584, 1, 41, "Bloodscalp Clan Heads", 2, 2, nil},
	{33, 196, 1, 41, "Raptor Mastery", 3, 2, nil},
	{33, 587, 1, 41, "Up to Snuff", 3, 2, nil},
	{33, 595, 1, 41, "The Bloodsail Buccaneers", 3, 2, nil},
	{33, 597, 1, 41, "The Bloodsail Buccaneers", 3, 2, nil},
	{33, 599, 1, 41, "The Bloodsail Buccaneers", 3, 2, nil},
	{33, 600, 1, 41, "Venture Company Mining", 3, 2, nil},
	{33, 606, 1, 41, "Scaring Shaky", 3, 2, nil},
	{33, 607, 1, 41, "Return to MacKinley", 3, 2, nil},
	{33, 598, 1, 42, "Split Bone Necklace", 2, 2, nil},
	{33, 209, 1, 42, "Skullsplitter Tusks", 3, 2, nil},
	{33, 576, 1, 42, "Keep An Eye Out", 3, 2, nil},
	{33, 594, 1, 42, "Message in a Bottle", 3, 2, nil},
	{33, 604, 1, 42, "The Bloodsail Buccaneers", 3, 2, nil},
	{33, 608, 1, 42, "The Bloodsail Buccaneers", 3, 2, nil},
	{33, 614, 1, 42, "The Captain's Chest [Group]", 3, 2, nil},
	{33, 619, 2, 42, "Enticing Negolash", 3, 2, nil},
	{33, 630, 1, 42, "Message in a Bottle", 3, 2, nil},
	{33, 8553, 1, 42, "The Captain's Cutlass", 3, 2, nil},
	{33, 8554, 1, 42, "Facing Negolash [Group]", 3, 2, nil},
	{33, 623, 1, 43, "Akiris by the Bundle", 1, 2, nil},
	{33, 197, 1, 43, "Raptor Mastery", 3, 2, nil},
	{33, 208, 1, 43, "Big Game Hunter [Group]", 3, 2, nil},
	{33, 617, 1, 43, "Akiris by the Bundle", 3, 2, nil},
	{33, 624, 1, 43, "Cortello's Riddle", 3, 2, nil},
	{33, 625, 1, 43, "Cortello's Riddle", 3, 2, nil},
	{33, 573, 1, 44, "Mok'thardin's Enchantment", 2, 2, nil},
	{33, 609, 1, 44, "Voodoo Dues", 3, 2, nil},
	{33, 613, 1, 44, "Cracking Maury's Foot", 3, 2, nil},
	{33, 621, 1, 44, "Zanzil's Secret", 3, 2, nil},
	{33, 1127, 1, 44, "Fool's Stout", 3, 2, nil},
	{33, 588, 1, 45, "The Fate of Yenniku", 2, 2, nil},
	{33, 589, 1, 45, "The Singing Crystals", 2, 2, nil},
	{33, 348, 1, 45, "Stranglethorn Fever", 3, 2, nil},
	{33, 206, 1, 46, "Mai'Zoth", 1, 2, nil},
	{33, 586, 1, 46, "Speaking with Gan'zulah", 2, 2, nil},
	{33, 591, 1, 46, "The Mind's Eye", 2, 2, nil},
	{33, 592, 1, 46, "Saving Yenniku", 2, 2, nil},
	{33, 593, 2, 46, "Filling the Soul Gem", 2, 2, nil},
	{33, 580, 1, 50, "Whiskey Slim's Lost Grog", 3, 2, nil},
	{33, 3721, 1, 50, "An OOX of Your Own", 3, 2, nil},
	{33, 8552, 1, 50, "The Monogrammed Sash", 3, 2, nil},
	{33, 626, 1, 51, "Cortello's Riddle", 3, 2, nil},
	{33, 9272, 1, 55, "Dressing the Part", 4, 2, nil},
	{33, 7810, 1, 55, "Arena Master [PvP]", 3, 2, nil},
	{33, 7838, 2, 55, "Arena Grandmaster", 3, 2, nil},
	{33, 3625, 1, 58, "Enchanted Azsharite Fel Weaponry", 3, 2, nil},
	{33, 3626, 1, 58, "Return to the Blasted Lands", 3, 2, nil},
	{33, 1036, 1, 60, "Avast Ye, Scallywag", 3, 2, nil},
	{33, 4621, 1, 60, "Avast Ye, Admiral!", 3, 2, nil},
	{8, 1421, 1, 35, "The Lost Caravan", 1, 2, nil},
	{8, 1418, 1, 35, "Neeka Bloodscar", 2, 2, nil},
	{8, 1389, 1, 35, "Draenethyst Crystals", 3, 2, nil},
	{8, 1116, 1, 36, "Dream Dust in the Swamp", 3, 2, nil},
	{8, 1396, 1, 37, "Encroaching Wildlife", 1, 2, nil},
	{8, 9609, 1, 37, "Help Watcher Biggs", 1, 2, nil},
	{8, 9448, 1, 38, "Mercy for the Cursed", 1, 2, nil},
	{8, 9440, 1, 38, "Little Morsels", 2, 2, nil},
	{8, 1393, 1, 38, "Galen's Escape", 3, 2, nil},
	{8, 1392, 1, 39, "Noboru the Cudgel", 3, 2, nil},
	{8, 1423, 2, 40, "The Lost Supplies", 1, 2, nil},
	{8, 698, 1, 40, "Lack of Surplus", 2, 2, nil},
	{8, 1398, 1, 42, "Driftwood", 1, 2, nil},
	{8, 1425, 1, 42, "Deliver the Shipment", 1, 2, nil},
	{8, 699, 1, 42, "Lack of Surplus", 2, 2, nil},
	{8, 9610, 1, 43, "Pool of Tears", 1, 2, nil},
	{8, 1424, 1, 43, "Pool of Tears", 2, 2, nil},
	{8, 1426, 1, 43, "Threat From the Sea", 2, 2, nil},
	{8, 1427, 1, 43, "Threat From the Sea", 2, 2, nil},
	{8, 1429, 1, 44, "The Atal'ai Exile", 2, 2, nil},
	{8, 1430, 1, 44, "Fresh Meat", 2, 2, nil},
	{8, 1422, 1, 45, "Threat From the Sea", 2, 2, nil},
	{8, 1428, 1, 45, "Continued Threat", 2, 2, nil},
	{8, 2622, 1, 50, "The Missing Orders", 2, 2, nil},
	{8, 2623, 1, 55, "The Swamp Talker", 2, 2, nil},
	{8, 3374, 1, 55, "The Essence of Eranikus", 3, 2, nil},
	{8, 3512, 1, 55, "In Eranikus' Own Words", 3, 2, nil},
	{47, 2932, 1, 42, "Grim Message", 2, 2, nil},
	{47, 1450, 1, 43, "Gryphon Master Talonaxe", 1, 2, nil},
	{47, 1451, 1, 43, "Rhapsody Shindigger", 1, 2, nil},
	{47, 1452, 1, 43, "Rhapsody's Kalimdor Kocktail", 1, 2, nil},
	{47, 1469, 1, 43, "Rhapsody's Tale", 1, 2, nil},
	{47, 2933, 1, 43, "Venom Bottles", 2, 2, nil},
	{47, 9471, 1, 44, "Preying on the Predators", 1, 2, nil},
	{47, 1444, 1, 44, "Return to Fel'Zerul", 2, 2, nil},
	{47, 2880, 1, 45, "Troll Necklace Bounty", 1, 2, nil},
	{47, 2988, 1, 45, "Witherbark Cages", 1, 2, nil},
	{47, 2934, 1, 45, "Undamaged Venom Sac", 2, 2, nil},
	{47, 2935, 1, 45, "Consult Master Gadrin", 2, 2, nil},
	{47, 9469, 1, 46, "Featherbeard's Endorsement", 1, 2, nil},
	{47, 9470, 1, 46, "A Gesture of Goodwill", 1, 2, nil},
	{47, 9475, 1, 46, "Reclaiming the Eggs", 1, 2, nil},
	{47, 9476, 1, 46, "In Pursuit of Featherbeard", 1, 2, nil},
	{47, 2990, 1, 47, "Thadius Grimshade", 1, 2, nil},
	{47, 2992, 1, 47, "The Divination", 1, 2, nil},
	{47, 2993, 1, 47, "Return to the Hinterlands", 1, 2, nil},
	{47, 3661, 1, 47, "Favored of Elune?", 1, 2, nil},
	{47, 2742, 1, 47, "Rin'ji is Trapped!", 2, 2, nil},
	{47, 2782, 1, 47, "Rin'ji's Secret", 2, 2, nil},
	{47, 8273, 1, 47, "Oran's Gratitude", 2, 2, nil},
	{47, 2877, 1, 48, "Skulk Rock Clean-up", 1, 2, nil},
	{47, 2989, 1, 48, "The Altar of Zul", 1, 2, nil},
	{47, 77, 1, 48, "A Sticky Situation", 2, 2, nil},
	{47, 7816, 1, 48, "Gammerita, Mon!", 2, 2, nil},
	{47, 7828, 1, 48, "Stalking the Stalkers", 2, 2, nil},
	{47, 7829, 1, 48, "Hunt the Savages", 2, 2, nil},
	{47, 7830, 1, 48, "Avenging the Fallen", 2, 2, nil},
	{47, 7839, 1, 48, "Vilebranch Hooligans", 2, 2, nil},
	{47, 7841, 1, 48, "Message to the Wildhammer [PvP]", 2, 2, nil},
	{47, 7842, 1, 48, "Another Message to the Wildhammer [PvP]", 2, 2, nil},
	{47, 7844, 1, 48, "Cannibalistic Cousins", 2, 2, nil},
	{47, 485, 1, 48, "Find OOX-09/HL!", 3, 2, nil},
	{47, 836, 1, 48, "Rescue OOX-09/HL!", 3, 2, nil},
	{47, 7840, 1, 49, "Lard Lost His Lunch", 2, 2, nil},
	{47, 7815, 1, 50, "Snapjaws, Mon!", 2, 2, nil},
	{47, 7843, 1, 50, "The Final Message to the Wildhammer [PvP]", 2, 2, nil},
	{47, 7849, 1, 50, "Separation Anxiety", 2, 2, nil},
	{47, 7850, 1, 50, "Dark Vessels", 2, 2, nil},
	{47, 4787, 1, 50, "The Ancient Egg", 3, 2, nil},
	{47, 2994, 1, 51, "Saving Sharpbeak", 1, 2, nil},
	{47, 7845, 1, 51, "Kidnapped Elder Torntusk!", 2, 2, nil},
	{47, 7846, 1, 51, "Recover the Key!", 2, 2, nil},
	{47, 7847, 1, 51, "Return to Primal Torntusk", 2, 2, nil},
	{47, 7861, 1, 51, "Wanted: Vile Priestess Hexx and Her Minions", 2, 2, nil},
	{47, 7862, 1, 51, "Job Opening: Guard Captain of Revantusk Village", 2, 2, nil},
	{47, 2937, 1, 55, "Summoning Shadra [Group]", 2, 2, nil},
	{47, 2938, 1, 55, "Venom to the Undercity", 2, 2, nil},
	{85, 363, 1, 1, "Rude Awakening", 2, 2, nil},
	{85, 5847, 1, 1, "Welcome!", 2, 2, nil},
	{85, 364, 1, 2, "The Mindless Ones", 2, 2, nil},
	{85, 376, 1, 2, "The Damned", 2, 2, nil},
	{85, 3901, 1, 3, "Rattling the Rattlecages", 2, 2, nil},
	{85, 3902, 1, 3, "Scavenging Deathknell", 2, 2, nil},
	{85, 380, 1, 4, "Night Web's Hollow", 2, 2, nil},
	{85, 381, 1, 4, "The Scarlet Crusade", 2, 2, nil},
	{85, 8, 1, 5, "A Rogue's Deal", 2, 2, nil},
	{85, 382, 1, 5, "The Red Messenger", 2, 2, nil},
	{85, 383, 1, 5, "Vital Intelligence", 2, 2, nil},
	{85, 590, 1, 5, "A Rogue's Deal", 2, 2, nil},
	{85, 5481, 1, 5, "Gordo's Task", 2, 2, nil},
	{85, 6395, 1, 5, "Marla's Last Wish", 2, 2, nil},
	{85, 367, 1, 6, "A New Plague", 2, 2, nil},
	{85, 404, 1, 6, "A Putrid Task", 2, 2, nil},
	{85, 5482, 1, 6, "Doom Weed", 2, 2, nil},
	{85, 361, 1, 7, "A Letter Undelivered", 2, 2, nil},
	{85, 365, 1, 7, "Fields of Grief", 2, 2, nil},
	{85, 374, 1, 7, "Proof of Demise", 2, 2, nil},
	{85, 407, 1, 7, "Fields of Grief", 2, 2, nil},
	{85, 358, 1, 8, "Graverobbers", 2, 2, nil},
	{85, 366, 1, 8, "Return the Book", 2, 2, nil},
	{85, 375, 1, 8, "The Chill of Death", 2, 2, nil},
	{85, 405, 1, 8, "The Prodigal Lich", 2, 2, nil},
	{85, 426, 1, 8, "The Mills Overrun", 2, 2, nil},
	{85, 427, 1, 8, "At War With The Scarlet Crusade", 2, 2, nil},
	{85, 359, 1, 9, "Forsaken Duties", 2, 2, nil},
	{85, 360, 1, 9, "Return to the Magistrate", 2, 2, nil},
	{85, 368, 1, 9, "A New Plague", 2, 2, nil},
	{85, 370, 1, 9, "At War With The Scarlet Crusade", 2, 2, nil},
	{85, 355, 1, 10, "Speak with Sevren", 2, 2, nil},
	{85, 362, 1, 10, "The Haunted Mills", 2, 2, nil},
	{85, 371, 1, 10, "At War With The Scarlet Crusade", 2, 2, nil},
	{85, 398, 1, 10, "Wanted: Maggot Eye", 2, 2, nil},
	{85, 410, 2, 10, "The Dormant Shade", 2, 2, nil},
	{85, 431, 2, 10, "Candles of Beckoning", 2, 2, nil},
	{85, 445, 1, 10, "Delivery to Silverpine Forest", 2, 2, nil},
	{85, 354, 1, 11, "Deaths in the Family", 2, 2, nil},
	{85, 356, 1, 11, "Rear Guard Patrol", 2, 2, nil},
	{85, 369, 1, 11, "A New Plague", 2, 2, nil},
	{85, 492, 1, 11, "A New Plague", 2, 2, nil},
	{85, 372, 1, 12, "At War With The Scarlet Crusade", 2, 2, nil},
	{85, 409, 1, 12, "Proving Allegiance", 2, 2, nil},
	{85, 411, 1, 12, "The Prodigal Lich Returns", 2, 2, nil},
	{85, 408, 1, 13, "The Family Crypt", 2, 2, nil},
	{85, 14089, 1, 20, "Learn to Ride in Tirisfal Glades", 2, 2, nil},
	{85, 5902, 1, 55, "A Plague Upon Thee", 2, 2, nil},
	{1497, 357, 1, 8, "The Lich's Identity", 2, 2, nil},
	{1497, 1358, 1, 15, "Sample for Helbrim", 2, 2, nil},
	{1497, 1359, 1, 15, "Zinge's Delivery", 2, 2, nil},
	{1497, 9180, 1, 15, "Journey to Undercity", 2, 2, nil},
	{1497, 9621, 1, 21, "Envoy to the Horde", 2, 2, nil},
	{1497, 9812, 1, 21, "Envoy to the Horde", 2, 2, nil},
	{1497, 1164, 1, 36, "To Steal From Thieves", 2, 2, nil},
	{1497, 495, 1, 39, "The Crown of Will", 2, 2, nil},
	{1497, 736, 1, 44, "The Star, the Hand and the Heart [Group]", 2, 2, nil},
	{1497, 232, 1, 45, "Errand for Apothecary Zinge", 2, 2, nil},
	{1497, 238, 1, 45, "Errand for Apothecary Zinge", 2, 2, nil},
	{1497, 864, 1, 46, "Return to Apothecary Zinge", 2, 2, nil},
	{1497, 2995, 1, 47, "Lines of Communication", 2, 2, nil},
	{1497, 3784, 1, 50, "Assisting Arch Druid Runetotem", 2, 2, nil},
	{1497, 5094, 1, 50, "A Call to Arms: The Plaguelands!", 2, 2, nil},
	{1497, 3568, 1, 52, "Seeping Corruption", 2, 2, nil},
	{1497, 3569, 1, 52, "Seeping Corruption", 2, 2, nil},
	{1497, 3570, 1, 52, "Seeping Corruption", 2, 2, nil},
	{1497, 4293, 1, 52, "A Sample of Slime...", 2, 2, nil},
	{1497, 4561, 2, 52, "Testing for Impurities - Un'Goro Crater", 2, 2, nil},
	{1497, 4661, 2, 52, "Testing for Corruption - Felwood", 2, 2, nil},
	{1497, 5049, 1, 52, "The Jeremiah Blues", 2, 2, nil},
	{1497, 1004, 1, 55, "The New Frontier", 2, 2, nil},
	{1497, 4642, 1, 55, "Melding of Influences", 2, 2, nil},
	{1497, 4294, 1, 56, "... and a Batch of Ooze", 2, 2, nil},
	{1497, 5961, 1, 56, "The Champion of the Banshee Queen", 2, 2, nil},
	{1497, 7813, 1, 60, "A Donation of Wool", 2, 2, nil},
	{1497, 7814, 1, 60, "A Donation of Silk", 2, 2, nil},
	{1497, 7817, 1, 60, "A Donation of Mageweave", 2, 2, nil},
	{1497, 7818, 1, 60, "A Donation of Runecloth", 2, 2, nil},
	{1497, 7819, 2, 60, "Additional Runecloth", 2, 2, nil},
	{1497, 13267, 1, 74, "The Battle For The Undercity", 2, 2, nil},
	{28, 5022, 1, 52, "Better Late Than Never", 1, 2, nil},
	{28, 5092, 1, 52, "Clear the Way", 1, 2, nil},
	{28, 5023, 1, 52, "Better Late Than Never", 2, 2, nil},
	{28, 5021, 1, 52, "Better Late Than Never", 3, 2, nil},
	{28, 5050, 1, 52, "Good Luck Charm", 3, 2, nil},
	{28, 5215, 1, 53, "The Scourge Cauldrons", 1, 2, nil},
	{28, 5216, 1, 53, "Target: Felstone Field", 1, 2, nil},
	{28, 5217, 1, 53, "Return to Chillwind Camp", 1, 2, nil},
	{28, 5096, 1, 53, "Scarlet Diversions", 2, 2, nil},
	{28, 5228, 1, 53, "The Scourge Cauldrons", 2, 2, nil},
	{28, 5229, 1, 53, "Target: Felstone Field", 2, 2, nil},
	{28, 5230, 1, 53, "Return to the Bulwark", 2, 2, nil},
	{28, 5218, 2, 53, "Felstone Field Cauldron", 3, 2, nil},
	{28, 4984, 1, 54, "The Wildlife Suffers Too", 3, 2, nil},
	{28, 5051, 1, 54, "Two Halves Become One", 3, 2, nil},
	{28, 5219, 1, 55, "Target: Dalson's Tears", 1, 2, nil},
	{28, 5220, 1, 55, "Return to Chillwind Camp", 1, 2, nil},
	{28, 5222, 1, 55, "Target: Writhing Haunt", 1, 2, nil},
	{28, 5223, 1, 55, "Return to Chillwind Camp", 1, 2, nil},
	{28, 5401, 1, 55, "Argent Dawn Commission", 1, 2, nil},
	{28, 5402, 2, 55, "Minion's Scourgestones", 1, 2, nil},
	{28, 5403, 2, 55, "Invader's Scourgestones", 1, 2, nil},
	{28, 5404, 2, 55, "Corruptor's Scourgestones", 1, 2, nil},
	{28, 5533, 1, 55, "Scholomance", 1, 2, nil},
	{28, 5904, 1, 55, "A Plague Upon Thee", 1, 2, nil},
	{28, 6389, 1, 55, "A Plague Upon Thee", 1, 2, nil},
	{28, 838, 1, 55, "Scholomance", 2, 2, nil},
	{28, 5231, 1, 55, "Target: Dalson's Tears", 2, 2, nil},
	{28, 5232, 1, 55, "Return to the Bulwark", 2, 2, nil},
	{28, 5233, 1, 55, "Target: Writhing Haunt", 2, 2, nil},
	{28, 5234, 1, 55, "Return to the Bulwark", 2, 2, nil},
	{28, 5405, 1, 55, "Argent Dawn Commission", 2, 2, nil},
	{28, 5406, 2, 55, "Corruptor's Scourgestones", 2, 2, nil},
	{28, 5407, 2, 55, "Invader's Scourgestones", 2, 2, nil},
	{28, 5408, 2, 55, "Minion's Scourgestones", 2, 2, nil},
	{28, 6390, 1, 55, "A Plague Upon Thee", 2, 2, nil},
	{28, 5058, 1, 55, "Mrs. Dalson's Diary", 3, 2, nil},
	{28, 5059, 2, 55, "Locked Away", 3, 2, nil},
	{28, 5060, 1, 55, "Locked Away", 3, 2, nil},
	{28, 5221, 2, 55, "Dalson's Tears Cauldron", 3, 2, nil},
	{28, 5224, 2, 55, "Writhing Haunt Cauldron", 3, 2, nil},
	{28, 4986, 1, 56, "Glyphed Oaken Branch", 1, 2, nil},
	{28, 5097, 1, 56, "All Along the Watchtowers", 1, 2, nil},
	{28, 4987, 1, 56, "Glyphed Oaken Branch", 2, 2, nil},
	{28, 5098, 1, 56, "All Along the Watchtowers", 2, 2, nil},
	{28, 4971, 1, 56, "A Matter of Time", 3, 2, nil},
	{28, 4972, 1, 56, "Counting Out Time", 3, 2, nil},
	{28, 4973, 2, 56, "Counting Out Time", 3, 2, nil},
	{28, 4985, 1, 56, "The Wildlife Suffers Too", 3, 2, nil},
	{28, 5154, 1, 56, "The Annals of Darrowshire", 3, 2, nil},
	{28, 6004, 1, 56, "Unfinished Business", 3, 2, nil},
	{28, 5537, 1, 57, "Skeletal Fragments", 1, 2, nil},
	{28, 5538, 1, 57, "Mold Rhymes With...", 1, 2, nil},
	{28, 964, 1, 57, "Skeletal Fragments", 2, 2, nil},
	{28, 5514, 1, 57, "Mold Rhymes With...", 2, 2, nil},
	{28, 6023, 1, 57, "Unfinished Business", 3, 2, nil},
	{28, 5225, 1, 58, "Target: Gahrron's Withering", 1, 2, nil},
	{28, 5226, 1, 58, "Return to Chillwind Camp", 1, 2, nil},
	{28, 5238, 1, 58, "Mission Accomplished!", 1, 2, nil},
	{28, 9446, 1, 58, "Tomb of the Lightbringer [Group]", 1, 2, nil},
	{28, 9474, 1, 58, "The Mark of the Lightbringer", 1, 2, nil},
	{28, 5235, 1, 58, "Target: Gahrron's Withering", 2, 2, nil},
	{28, 5236, 1, 58, "Return to the Bulwark", 2, 2, nil},
	{28, 5237, 1, 58, "Mission Accomplished!", 2, 2, nil},
	{28, 9443, 1, 58, "The So-Called Mark of the Lightbringer", 2, 2, nil},
	{28, 9444, 1, 58, "Defiling Uther's Tomb [PvP]", 2, 2, nil},
	{28, 5227, 2, 58, "Gahrron's Withering Cauldron", 3, 2, nil},
	{28, 6025, 1, 58, "Unfinished Business", 3, 2, nil},
	{28, 211, 1, 60, "Alas, Andorhal [Group]", 1, 2, nil},
	{28, 5344, 1, 60, "The Last Barov [Group]", 1, 2, nil},
	{28, 5505, 1, 60, "The Key to Scholomance", 1, 2, nil},
	{28, 5803, 1, 60, "Araj's Scarab [Group]", 1, 2, nil},
	{28, 6184, 1, 60, "Flint Shadowmore [Group]", 1, 2, nil},
	{28, 105, 1, 60, "Alas, Andorhal [Group]", 2, 2, nil},
	{28, 5342, 1, 60, "The Last Barov [Group]", 2, 2, nil},
	{28, 5511, 1, 60, "The Key to Scholomance", 2, 2, nil},
	{28, 5524, 1, 60, "Chromatic Mantle of the Dawn", 2, 2, nil},
	{28, 5804, 1, 60, "Araj's Scarab [Group]", 2, 2, nil},
	{28, 5162, 1, 60, "Wrath of the Blue Flight [Group]", 3, 2, nil},
	{28, 5164, 1, 60, "Catalogue of the Wayward [Group]", 3, 2, nil},
	{28, 5166, 1, 60, "Breastplate of the Chromatic Flight [Group]", 3, 2, nil},
	{28, 5167, 1, 60, "Legplates of the Chromatic Defier [Group]", 3, 2, nil},
	{28, 5461, 1, 60, "The Human, Ras Frostwhisper [Group]", 3, 2, nil},
	{28, 5462, 1, 60, "The Dying, Ras Frostwhisper [Group]", 3, 2, nil},
	{28, 5465, 1, 60, "Soulbound Keepsake [Group]", 3, 2, nil},
	{28, 5504, 1, 60, "Mantles of the Dawn", 3, 2, nil},
	{28, 5507, 1, 60, "Mantles of the Dawn", 3, 2, nil},
	{28, 5521, 1, 60, "Chromatic Mantle of the Dawn", 3, 2, nil},
	{28, 5861, 1, 60, "Find Myranda", 3, 2, nil},
	{28, 5862, 1, 60, "Scarlet Subterfuge [Group]", 3, 2, nil},
	{28, 5944, 1, 60, "In Dreams [Group]", 3, 2, nil},
	{40, 3861, 2, 1, "CLUCK!", 3, 2, nil},
	{40, 184, 1, 9, "Furlbrow's Deed", 1, 2, nil},
	{40, 36, 1, 10, "Westfall Stew", 1, 2, nil},
	{40, 6181, 1, 10, "A Swift Message", 1, 2, nil},
	{40, 6261, 1, 10, "Dungar Longdrink", 1, 2, nil},
	{40, 6281, 1, 10, "Continue to Stormwind", 1, 2, nil},
	{40, 6285, 1, 10, "Return to Lewis", 1, 2, nil},
	{40, 12, 1, 12, "The People's Militia", 1, 2, nil},
	{40, 22, 1, 12, "Goretusk Liver Pie", 1, 2, nil},
	{40, 64, 1, 12, "The Forgotten Heirloom", 1, 2, nil},
	{40, 38, 1, 13, "Westfall Stew", 1, 2, nil},
	{40, 13, 1, 14, "The People's Militia", 1, 2, nil},
	{40, 102, 1, 14, "Patrolling Westfall", 1, 2, nil},
	{40, 151, 1, 14, "Poor Old Blanchy", 1, 2, nil},
	{40, 9, 1, 15, "The Killing Fields", 1, 2, nil},
	{40, 117, 2, 15, "Thunderbrew Lager", 1, 2, nil},
	{40, 153, 1, 15, "Red Leather Bandanas", 1, 2, nil},
	{40, 103, 1, 16, "Keeper of the Flame", 3, 2, nil},
	{40, 136, 1, 16, "Captain Sanders' Hidden Treasure", 3, 2, nil},
	{40, 138, 1, 16, "Captain Sanders' Hidden Treasure", 3, 2, nil},
	{40, 139, 1, 16, "Captain Sanders' Hidden Treasure", 3, 2, nil},
	{40, 140, 1, 16, "Captain Sanders' Hidden Treasure", 3, 2, nil},
	{40, 14, 1, 17, "The People's Militia", 1, 2, nil},
	{40, 65, 1, 18, "The Defias Brotherhood", 1, 2, nil},
	{40, 132, 1, 18, "The Defias Brotherhood", 1, 2, nil},
	{40, 135, 1, 18, "The Defias Brotherhood", 1, 2, nil},
	{40, 141, 1, 18, "The Defias Brotherhood", 1, 2, nil},
	{40, 142, 1, 18, "The Defias Brotherhood", 1, 2, nil},
	{40, 155, 1, 18, "The Defias Brotherhood [Group]", 1, 2, nil},
	{40, 152, 1, 19, "The Coast Isn't Clear", 3, 2, nil},
	{40, 104, 1, 20, "The Coastal Menace", 3, 2, nil},
	{40, 48, 1, 44, "Sweet Amber", 1, 2, nil},
	{40, 49, 1, 44, "Sweet Amber", 1, 2, nil},
	{40, 50, 1, 44, "Sweet Amber", 1, 2, nil},
	{40, 51, 1, 44, "Sweet Amber", 1, 2, nil},
	{40, 53, 1, 44, "Sweet Amber", 1, 2, nil},
	{11, 1132, 4, 20, "Fiora Longears [Removed]", 1, 2, nil},
	{11, 276, 1, 21, "Tramping Paws", 1, 2, nil},
	{11, 455, 1, 21, "The Algaz Gauntlet", 1, 2, nil},
	{11, 463, 1, 21, "The Greenwarden", 1, 2, nil},
	{11, 468, 1, 21, "Report to Mountaineer Rockgar", 1, 2, nil},
	{11, 469, 1, 21, "Daily Delivery", 1, 2, nil},
	{11, 279, 1, 22, "Claws from the Deep", 1, 2, nil},
	{11, 484, 1, 22, "Young Crocolisk Skins", 1, 2, nil},
	{11, 277, 1, 23, "Fire Taboo", 1, 2, nil},
	{11, 294, 1, 24, "Ormer's Revenge", 1, 2, nil},
	{11, 305, 1, 24, "In Search of The Excavation Team", 1, 2, nil},
	{11, 306, 1, 24, "In Search of The Excavation Team", 1, 2, nil},
	{11, 470, 1, 24, "Digging Through the Ooze", 1, 2, nil},
	{11, 281, 1, 25, "Reclaiming Goods", 1, 2, nil},
	{11, 284, 1, 25, "The Search Continues", 1, 2, nil},
	{11, 285, 1, 25, "Search More Hovels", 1, 2, nil},
	{11, 286, 1, 25, "Return the Statuette", 1, 2, nil},
	{11, 472, 1, 25, "Fall of Dun Modr", 1, 2, nil},
	{11, 275, 1, 26, "Blisters on The Land", 1, 2, nil},
	{11, 464, 1, 26, "War Banners", 1, 2, nil},
	{11, 465, 1, 26, "Nek'rosh's Gambit", 1, 2, nil},
	{11, 471, 1, 26, "Apprentice's Duties", 1, 2, nil},
	{11, 473, 1, 26, "Report to Captain Stoutfist", 1, 2, nil},
	{11, 474, 1, 26, "Defeat Nek'rosh", 1, 2, nil},
	{11, 288, 1, 27, "The Third Fleet", 1, 2, nil},
	{11, 295, 1, 27, "Ormer's Revenge", 1, 2, nil},
	{11, 299, 1, 28, "Uncovering the Past", 1, 2, nil},
	{11, 289, 1, 29, "The Cursed Crew", 1, 2, nil},
	{11, 296, 1, 29, "Ormer's Revenge", 1, 2, nil},
	{11, 290, 1, 30, "Lifting the Curse", 1, 2, nil},
	{11, 292, 1, 30, "The Eye of Paleth", 1, 2, nil},
	{11, 293, 1, 30, "Cleansing the Eye", 1, 2, nil},
	{11, 303, 1, 30, "The Dark Iron War", 1, 2, nil},
	{11, 647, 1, 30, "MacKreel's Moonshine", 1, 2, nil},
	{11, 304, 1, 31, "A Grim Task", 1, 2, nil},
	{11, 631, 1, 31, "The Thandol Span", 1, 2, nil},
	{11, 632, 1, 31, "The Thandol Span", 1, 2, nil},
	{11, 633, 1, 31, "The Thandol Span", 1, 2, nil},
	{11, 634, 1, 31, "Plea To The Alliance", 1, 2, nil},
	{11, 1302, 1, 35, "James Hyal", 1, 2, nil},

	--[[

		KALIMDOR - Version 2.0

		None

	--]]

	{331, 1056, 1, 18, "Journey to Stonetalon Peak", 1, 2, nil, 2, nil},
	{331, 990, 1, 19, "Trek to Ashenvale", 1, 2, nil, 2, nil},
	{331, 991, 1, 19, "Raene's Cleansing", 1, 2, nil, 2, nil},
	{331, 1008, 1, 19, "The Zoram Strand", 1, 2, nil, 2, nil},
	{331, 6442, 1, 19, "Naga at the Zoram Strand", 2, 2, nil, 2, nil},
	{331, 6543, 1, 19, "The Warsong Reports", 2, 2, nil, 2, nil},
	{331, 6545, 2, 19, "Warsong Runner Update", 2, 2, nil, 2, nil},
	{331, 1007, 1, 20, "The Ancient Statuette", 1, 2, nil, 2, nil},
	{331, 1010, 1, 20, "Bathran's Hair", 1, 2, nil, 2, nil},
	{331, 1020, 1, 20, "Orendil's Cure", 1, 2, nil, 2, nil},
	{331, 9432, 1, 20, "Travel to Astranaar", 1, 2, nil, 1, "DRAENEI"},
	{331, 10752, 1, 20, "Onward to Ashenvale", 1, 2, nil, 2, nil},
	{331, 6383, 5, 20, "The Ashenvale Hunt", 2, 2, nil, 2, nil},
	{331, 9428, 1, 20, "Report to Splintertree Post", 2, 2, nil, 1, "BLOODELF"},
	{331, 1023, 1, 21, "Raene's Cleansing", 1, 2, nil, 2, nil},
	{331, 1024, 1, 21, "Raene's Cleansing", 1, 2, nil, 2, nil},
	{331, 1070, 1, 21, "On Guard in Stonetalon", 1, 2, nil, 2, nil},
	{331, 1085, 1, 21, "On Guard in Stonetalon", 1, 2, nil, 2, nil},
	{331, 1134, 1, 21, "Pridewings of Stonetalon", 1, 2, nil, 2, nil},
	{331, 6547, 2, 21, "Warsong Scout Update", 2, 2, nil, 2, nil},
	{331, 1033, 1, 22, "Elune's Tear", 1, 2, nil, 2, nil},
	{331, 1034, 1, 23, "The Ruins of Stardust", 1, 2, nil, 2, nil},
	{331, 6641, 1, 23, "Vorsha the Lasher [Group]", 2, 2, nil, 2, nil},
	{331, 976, 1, 24, "Supplies to Auberdine", 1, 2, nil, 2, nil},
	{331, 1016, 1, 24, "Elemental Bracers", 1, 2, nil, 2, nil},
	{331, 1025, 1, 24, "An Aggressive Defense", 1, 2, nil, 2, nil},
	{331, 23, 1, 24, "Ursangous's Paw", 2, 2, nil, 2, nil},
	{331, 216, 1, 24, "Between a Rock and a Thistlefur", 2, 2, nil, 2, nil},
	{331, 6462, 1, 24, "Troll Charm", 2, 2, nil, 2, nil},
	{331, 6482, 1, 24, "Freedom to Ruul", 2, 2, nil, 2, nil},
	{331, 6503, 1, 24, "Ashenvale Outrunners", 2, 2, nil, 2, nil},
	{331, 6544, 1, 24, "Torek's Assault", 2, 2, nil, 2, nil},
	{331, 1009, 1, 25, "Ruuzel", 1, 2, nil, 2, nil},
	{331, 1017, 1, 25, "Mage Summoner", 1, 2, nil, 2, nil},
	{331, 1054, 1, 25, "Culling the Threat", 1, 2, nil, 2, nil},
	{331, 9521, 1, 25, "Report from the Northern Front [PvP]", 1, 2, nil, 2, nil},
	{331, 9533, 1, 25, "A Helping Hand", 1, 2, nil, 2, nil},
	{331, 25, 1, 25, "Stonetalon Standstill", 2, 2, nil, 2, nil},
	{331, 6546, 2, 25, "Warsong Outrider Update", 2, 2, nil, 2, nil},
	{331, 6441, 1, 26, "Satyr Horns", 2, 2, nil, 2, nil},
	{331, 6621, 1, 26, "King of the Foulweald", 2, 2, nil, 2, nil},
	{331, 1026, 1, 27, "Raene's Cleansing", 1, 2, nil, 2, nil},
	{331, 9519, 1, 27, "The Lost Chalice", 1, 2, nil, 2, nil},
	{331, 24, 1, 27, "Shadumbra's Head", 2, 2, nil, 2, nil},
	{331, 824, 1, 27, "Je'neu of the Earthen Ring", 2, 2, nil, 2, nil},
	{331, 1918, 1, 27, "The Befouled Element", 2, 2, nil, 2, nil},
	{331, 6571, 1, 27, "Warsong Supplies", 2, 2, nil, 2, nil},
	{331, 6581, 2, 27, "Warsong Saw Blades", 2, 2, nil, 2, nil},
	{331, 1027, 1, 28, "Raene's Cleansing", 1, 2, nil, 2, nil},
	{331, 1028, 1, 28, "Raene's Cleansing", 1, 2, nil, 2, nil},
	{331, 1029, 1, 28, "Raene's Cleansing", 1, 2, nil, 2, nil},
	{331, 1030, 1, 28, "Raene's Cleansing", 1, 2, nil, 2, nil},
	{331, 1055, 1, 28, "Raene's Cleansing", 1, 2, nil, 2, nil},
	{331, 9517, 1, 28, "A Shameful Waste", 1, 2, nil, 2, nil},
	{331, 9518, 1, 28, "Agents of Destruction", 1, 2, nil, 2, nil},
	{331, 1011, 1, 29, "Forsaken Diseases", 1, 2, nil, 2, nil},
	{331, 4581, 1, 29, "Kayneth Stillwind", 1, 2, nil, 2, nil},
	{331, 1022, 1, 30, "The Howling Vale", 1, 2, nil, 2, nil},
	{331, 1035, 1, 30, "Fallen Sky Lake", 1, 2, nil, 2, nil},
	{331, 1037, 1, 30, "Velinde Starsong", 1, 2, nil, 2, nil},
	{331, 1038, 1, 30, "Velinde's Effects", 1, 2, nil, 2, nil},
	{331, 1039, 1, 30, "The Barrens Port", 1, 2, nil, 2, nil},
	{331, 1040, 1, 30, "Passage to Booty Bay", 1, 2, nil, 2, nil},
	{331, 1041, 1, 30, "The Caravan Road", 1, 2, nil, 2, nil},
	{331, 1042, 1, 30, "The Carevin Family", 1, 2, nil, 2, nil},
	{331, 1043, 1, 30, "The Scythe of Elune", 1, 2, nil, 2, nil},
	{331, 1044, 1, 30, "Answered Questions", 1, 2, nil, 2, nil},
	{331, 1045, 1, 30, "Raene's Cleansing", 1, 2, nil, 2, nil},
	{331, 1046, 1, 30, "Raene's Cleansing", 1, 2, nil, 2, nil},
	{331, 9516, 1, 30, "Destroy the Legion", 1, 2, nil, 2, nil},
	{331, 9520, 1, 30, "Diabolical Plans", 1, 2, nil, 2, nil},
	{331, 9526, 1, 30, "Reclaiming Felfire Hill", 1, 2, nil, 2, nil},
	{331, 2, 1, 30, "Sharptalon's Claw", 2, 2, nil, 2, nil},
	{331, 247, 5, 30, "The Hunt Completed", 2, 2, nil, 2, nil},
	{331, 6504, 1, 30, "The Lost Pages", 2, 2, nil, 2, nil},
	{331, 6922, 1, 30, "Baron Aquanis [Dungeon]", 2, 2, nil, 2, nil},
	{331, 9534, 1, 30, "Destroy the Legion", 2, 2, nil, 2, nil},
	{331, 9535, 1, 30, "Diabolical Plans", 2, 2, nil, 2, nil},
	{331, 1012, 1, 32, "Insane Druids", 1, 2, nil, 2, nil},
	{331, 1021, 1, 32, "Vile Satyr! Dryads in Danger!", 1, 2, nil, 2, nil},
	{331, 1031, 1, 32, "The Branch of Cenarius", 1, 2, nil, 2, nil},
	{331, 1032, 1, 32, "Satyr Slaying!", 1, 2, nil, 2, nil},
	{331, 9522, 1, 32, "Never Again!", 1, 2, nil, 2, nil},
	{331, 9536, 1, 32, "Never Again!", 2, 2, nil, 2, nil},
	{331, 7863, 5, 34, "Sentinel Basic Care Package", 1, 2, nil, 2, nil},
	{331, 7864, 5, 44, "Sentinel Standard Care Package", 1, 2, nil, 2, nil},
	{331, 7865, 5, 70, "Sentinel Advanced Care Package", 1, 2, nil, 2, nil},
	{16, 5535, 1, 47, "Spiritual Unrest", 3, 2, nil, 2, nil},
	{16, 5536, 1, 47, "A Land Filled with Hatred", 3, 2, nil, 2, nil},
	{16, 3517, 1, 52, "Stealing Knowledge", 2, 2, nil, 2, nil},
	{16, 3518, 1, 52, "Delivery to Magatha", 2, 2, nil, 2, nil},
	{16, 3541, 1, 52, "Delivery to Jes'rimon", 2, 2, nil, 2, nil},
	{16, 3542, 1, 52, "Delivery to Andron Gant", 2, 2, nil, 2, nil},
	{16, 3561, 1, 52, "Delivery to Archmage Xylem", 2, 2, nil, 2, nil},
	{16, 3562, 1, 52, "Magatha's Payment to Jediga", 2, 2, nil, 2, nil},
	{16, 3563, 1, 52, "Jes'rimon's Payment to Jediga", 2, 2, nil, 2, nil},
	{16, 3564, 1, 52, "Andron's Payment to Jediga", 2, 2, nil, 2, nil},
	{16, 3565, 1, 52, "Xylem's Payment to Jediga", 2, 2, nil, 2, nil},
	{16, 3601, 1, 53, "Kim'jael Indeed!", 3, 2, nil, 2, nil},
	{16, 5534, 1, 53, "Kim'jael's \"Missing\" Equipment", 3, 2, nil, 2, nil},
	{16, 3421, 2, 55, "Return Trip", 3, 2, nil, 2, nil},
	{16, 3503, 2, 55, "Meeting with the Master", 3, 2, nil, 2, nil},
	{16, 6804, 1, 56, "Poisoned Water", 3, 2, nil, 2, nil},
	{16, 3141, 1, 57, "Loramus", 3, 2, nil, 2, nil},
	{16, 3382, 5, 57, "A Crew Under Fire", 3, 2, nil, 2, nil},
	{16, 6805, 1, 57, "Stormers and Rumblers", 3, 2, nil, 2, nil},
	{16, 3508, 1, 58, "Breaking the Ward", 3, 2, nil, 2, nil},
	{16, 3509, 1, 58, "The Name of the Beast", 3, 2, nil, 2, nil},
	{16, 3510, 1, 58, "The Name of the Beast", 3, 2, nil, 2, nil},
	{16, 3511, 1, 58, "The Name of the Beast", 3, 2, nil, 2, nil},
	{16, 3602, 1, 58, "Azsharite [Group]", 3, 2, nil, 2, nil},
	{16, 3621, 1, 58, "The Formation of Felbane", 3, 2, nil, 2, nil},
	{16, 6821, 1, 60, "Eye of the Emberseer [Raid]", 3, 2, nil, 2, nil},
	{16, 6822, 1, 60, "The Molten Core [Raid]", 3, 2, nil, 2, nil},
	{16, 6823, 1, 60, "Agent of Hydraxis", 3, 2, nil, 2, nil},
	{16, 6824, 1, 60, "Hands of the Enemy [Raid]", 3, 2, nil, 2, nil},
	{16, 7486, 1, 60, "A Hero's Reward", 3, 2, nil, 2, nil},
	{16, 8575, 1, 60, "Azuregos's Magical Ledger", 3, 2, nil, 2, nil},
	{16, 8729, 1, 60, "The Wrath of Neptulon [Raid]", 3, 2, nil, 2, nil},
	{3524, 9278, 1, 1, "Welcome!", 1, 2, nil, 1, "DRAENEI"},
	{3524, 9279, 1, 1, "You Survived!", 1, 2, nil, 1, "DRAENEI"},
	{3524, 9280, 1, 1, "Replenishing the Healing Crystals", 1, 2, nil, 1, "DRAENEI"},
	{3524, 9369, 1, 1, "Replenishing the Healing Crystals", 1, 2, nil, 2, nil},
	{3524, 9283, 1, 2, "Rescue the Survivors!", 1, 2, nil, 1, "DRAENEI"},
	{3524, 9293, 1, 2, "What Must Be Done...", 1, 2, nil, 2, nil},
	{3524, 9371, 1, 2, "Botanist Taerix", 1, 2, nil, 2, nil},
	{3524, 9409, 1, 2, "Urgent Delivery!", 1, 2, nil, 2, nil},
	{3524, 10302, 1, 2, "Volatile Mutations", 1, 2, nil, 2, nil},
	{3524, 9294, 1, 3, "Healing the Lake", 1, 2, nil, 2, nil},
	{3524, 9799, 1, 3, "Botanical Legwork", 1, 2, nil, 2, nil},
	{3524, 9303, 1, 4, "Inoculation", 1, 2, nil, 2, nil},
	{3524, 9305, 1, 4, "Spare Parts", 1, 2, nil, 2, nil},
	{3524, 10303, 1, 4, "The Blood Elves", 1, 2, nil, 2, nil},
	{3524, 10304, 1, 4, "Vindicator Aldar", 1, 2, nil, 2, nil},
	{3524, 9309, 1, 5, "The Missing Scout", 1, 2, nil, 2, nil},
	{3524, 9311, 1, 5, "Blood Elf Spy", 1, 2, nil, 2, nil},
	{3524, 9312, 1, 5, "The Emitter", 1, 2, nil, 2, nil},
	{3524, 9313, 1, 5, "Travel to Azure Watch", 1, 2, nil, 2, nil},
	{3524, 9314, 1, 5, "Word from Azure Watch", 1, 2, nil, 2, nil},
	{3524, 9798, 1, 5, "Blood Elf Plans", 1, 2, nil, 2, nil},
	{3524, 9452, 1, 6, "Red Snapper - Very Tasty!", 1, 2, nil, 2, nil},
	{3524, 9453, 1, 6, "Find Acteon!", 1, 2, nil, 2, nil},
	{3524, 9454, 1, 6, "The Great Moongraze Hunt", 1, 2, nil, 2, nil},
	{3524, 9463, 1, 6, "Medicinal Purpose", 1, 2, nil, 1, "DRAENEI"},
	{3524, 9455, 1, 7, "Strange Findings", 1, 2, nil, 2, nil},
	{3524, 9506, 1, 7, "A Small Start", 1, 2, nil, 2, nil},
	{3524, 9512, 1, 7, "Cookie's Jumbo Gumbo", 1, 2, nil, 2, nil},
	{3524, 9616, 1, 7, "Bandits!", 1, 2, nil, 2, nil},
	{3524, 9456, 1, 8, "Nightstalker Clean Up, Isle 2...", 1, 2, nil, 2, nil},
	{3524, 9473, 1, 8, "An Alternative Alternative", 1, 2, nil, 1, "DRAENEI"},
	{3524, 9505, 1, 8, "The Prophecy of Velen", 1, 2, nil, 1, "DRAENEI"},
	{3524, 9513, 1, 8, "Reclaiming the Ruins", 1, 2, nil, 2, nil},
	{3524, 9514, 1, 8, "Rune Covered Tablet", 1, 2, nil, 2, nil},
	{3524, 9523, 1, 8, "Precious and Fragile Things Need Special Handling", 1, 2, nil, 2, nil},
	{3524, 9538, 1, 8, "Learning the Language", 1, 2, nil, 2, nil},
	{3524, 9612, 1, 8, "A Hearty Thanks!", 1, 2, nil, 1, "DRAENEI"},
	{3524, 10324, 1, 8, "The Great Moongraze Hunt", 1, 2, nil, 2, nil},
	{3524, 9530, 1, 9, "I've Got a Plant", 1, 2, nil, 2, nil},
	{3524, 9531, 1, 9, "Tree's Company", 1, 2, nil, 2, nil},
	{3524, 9537, 1, 9, "Show Gnomercy", 1, 2, nil, 2, nil},
	{3524, 9602, 1, 9, "Deliver Them From Evil...", 1, 2, nil, 2, nil},
	{3524, 9515, 1, 10, "Warlord Sriss'tiz", 1, 2, nil, 2, nil},
	{3524, 9527, 1, 10, "All That Remains", 1, 2, nil, 2, nil},
	{3524, 9528, 1, 10, "A Cry For Help [Group]", 1, 2, nil, 2, nil},
	{3524, 9539, 1, 10, "Totem of Coo", 1, 2, nil, 2, nil},
	{3524, 9540, 1, 10, "Totem of Tikti", 1, 2, nil, 2, nil},
	{3524, 9541, 1, 10, "Totem of Yor", 1, 2, nil, 2, nil},
	{3524, 9542, 1, 10, "Totem of Vark", 1, 2, nil, 2, nil},
	{3524, 9544, 1, 10, "The Prophecy of Akida", 1, 2, nil, 2, nil},
	{3524, 9559, 1, 10, "Stillpine Hold", 1, 2, nil, 2, nil},
	{3524, 9560, 1, 10, "Beasts of the Apocalypse!", 1, 2, nil, 2, nil},
	{3524, 9562, 1, 10, "Murlocs... Why Here? Why Now?", 1, 2, nil, 2, nil},
	{3524, 9565, 1, 10, "Search Stillpine Hold", 1, 2, nil, 2, nil},
	{3524, 9566, 1, 10, "Blood Crystals", 1, 2, nil, 2, nil},
	{3524, 9571, 1, 10, "The Kurken's Hide", 1, 2, nil, 2, nil},
	{3524, 10428, 1, 10, "The Missing Fisherman", 1, 2, nil, 2, nil},
	{3524, 9564, 1, 11, "Gurf's Dignity", 1, 2, nil, 2, nil},
	{3524, 9573, 1, 11, "Chieftain Oomooroo", 1, 2, nil, 2, nil},
	{3524, 9622, 1, 11, "Warn Your People", 1, 2, nil, 2, nil},
	{3524, 9623, 1, 11, "Coming of Age", 1, 2, nil, 2, nil},
	{3524, 9625, 1, 11, "Elekks Are Serious Business", 1, 2, nil, 2, nil},
	{3524, 9570, 1, 12, "The Kurken is Lurkin'", 1, 2, nil, 2, nil},
	{3524, 14082, 1, 20, "Learn to Ride at the Exodar", 1, 2, nil, 1, "DRAENEI"},
	{3525, 9603, 1, 10, "Beds, Bandages, and Beyond", 1, 2, nil, 1, "DRAENEI"},
	{3525, 9604, 1, 10, "On the Wings of a Hippogryph", 1, 2, nil, 1, "DRAENEI"},
	{3525, 9605, 1, 10, "Hippogryph Master Stephanos", 1, 2, nil, 1, "DRAENEI"},
	{3525, 9606, 1, 10, "Return to Topher Loaal", 1, 2, nil, 1, "DRAENEI"},
	{3525, 9581, 1, 11, "Learning from the Crystals", 1, 2, nil, 2, nil},
	{3525, 9634, 1, 11, "Alien Predators", 1, 2, nil, 2, nil},
	{3525, 9576, 1, 12, "Cruelfin's Necklace", 1, 2, nil, 2, nil},
	{3525, 9624, 1, 12, "A Favorite Treat", 1, 2, nil, 2, nil},
	{3525, 9663, 1, 12, "The Kessel Run", 1, 2, nil, 2, nil},
	{3525, 9629, 1, 13, "Catch and Release", 1, 2, nil, 2, nil},
	{3525, 9666, 1, 13, "Declaration of Power", 1, 2, nil, 2, nil},
	{3525, 9667, 1, 13, "Saving Princess Stillpine", 1, 2, nil, 2, nil},
	{3525, 9668, 1, 13, "Report to Exarch Admetius", 1, 2, nil, 2, nil},
	{3525, 9567, 1, 14, "Know Thine Enemy", 1, 2, nil, 2, nil},
	{3525, 9574, 1, 14, "Victims of Corruption", 1, 2, nil, 2, nil},
	{3525, 9584, 1, 14, "The Second Sample", 1, 2, nil, 2, nil},
	{3525, 9594, 1, 14, "Signs of the Legion", 1, 2, nil, 2, nil},
	{3525, 9620, 1, 14, "The Missing Survey Team", 1, 2, nil, 2, nil},
	{3525, 9628, 1, 14, "Salvaging the Data", 1, 2, nil, 2, nil},
	{3525, 9648, 1, 14, "Mac'Aree Mushroom Menagerie", 1, 2, nil, 2, nil},
	{3525, 9632, 1, 15, "Newfound Allies", 1, 2, nil, 2, nil},
	{3525, 9633, 1, 15, "The Way to Auberdine", 1, 2, nil, 2, nil},
	{3525, 9641, 1, 15, "Irradiated Crystal Shards", 1, 2, nil, 2, nil},
	{3525, 9642, 2, 15, "More Irradiated Crystal Shards", 1, 2, nil, 2, nil},
	{3525, 9643, 1, 15, "Constrictor Vines", 1, 2, nil, 2, nil},
	{3525, 9693, 1, 15, "What Argus Means to Me", 1, 2, nil, 2, nil},
	{3525, 9694, 1, 15, "Blood Watch", 1, 2, nil, 2, nil},
	{3525, 9550, 1, 16, "A Map to Where?", 1, 2, nil, 2, nil},
	{3525, 9557, 1, 16, "Deciphering the Book", 1, 2, nil, 2, nil},
	{3525, 9561, 1, 16, "Nolkai's Words", 1, 2, nil, 2, nil},
	{3525, 9580, 1, 16, "The Bear Necessities", 1, 2, nil, 2, nil},
	{3525, 9647, 1, 16, "Culling the Flutterers", 1, 2, nil, 2, nil},
	{3525, 9696, 1, 16, "Translations...", 1, 2, nil, 2, nil},
	{3525, 9698, 1, 16, "Audience with the Prophet", 1, 2, nil, 2, nil},
	{3525, 9699, 1, 16, "Truth or Fiction", 1, 2, nil, 2, nil},
	{3525, 9700, 1, 16, "I Shoot Magic Into the Darkness", 1, 2, nil, 2, nil},
	{3525, 9779, 1, 16, "Intercepting the Message", 1, 2, nil, 2, nil},
	{3525, 9548, 1, 17, "Pilfered Equipment", 1, 2, nil, 2, nil},
	{3525, 9549, 1, 17, "Artifacts of the Blacksilt", 1, 2, nil, 2, nil},
	{3525, 9646, 1, 17, "WANTED: Deathclaw", 1, 2, nil, 2, nil},
	{3525, 9703, 1, 17, "The Cryo-Core", 1, 2, nil, 2, nil},
	{3525, 10063, 1, 17, "Explorers' League, Is That Something for Gnomes?", 1, 2, nil, 2, nil},
	{3525, 10065, 1, 17, "Cutting a Path", 1, 2, nil, 2, nil},
	{3525, 9569, 1, 18, "Containing the Threat", 1, 2, nil, 2, nil},
	{3525, 9578, 1, 18, "Searching for Galaen", 1, 2, nil, 2, nil},
	{3525, 9579, 1, 18, "Galaen's Fate", 1, 2, nil, 2, nil},
	{3525, 9585, 1, 18, "The Final Sample", 1, 2, nil, 2, nil},
	{3525, 9649, 1, 18, "Ysera's Tears", 1, 2, nil, 2, nil},
	{3525, 9671, 5, 18, "Urgent Delivery", 1, 2, nil, 2, nil},
	{3525, 9672, 1, 18, "The Bloodcurse Legacy", 1, 2, nil, 2, nil},
	{3525, 9674, 1, 18, "The Bloodcursed Naga", 1, 2, nil, 2, nil},
	{3525, 9682, 1, 18, "The Hopeless Ones...", 1, 2, nil, 2, nil},
	{3525, 9687, 1, 18, "Restoring Sanctity", 1, 2, nil, 2, nil},
	{3525, 9706, 1, 18, "Galaen's Journal - The Fate of Vindicator Saruan [Group]", 1, 2, nil, 2, nil},
	{3525, 9711, 1, 18, "Matis the Cruel [Group]", 1, 2, nil, 2, nil},
	{3525, 9740, 1, 18, "The Sun Gate", 1, 2, nil, 2, nil},
	{3525, 9741, 1, 18, "Critters of the Void", 1, 2, nil, 2, nil},
	{3525, 9746, 1, 18, "Limits of Physical Exhaustion", 1, 2, nil, 2, nil},
	{3525, 9748, 1, 18, "Don't Drink the Water", 1, 2, nil, 2, nil},
	{3525, 10064, 1, 18, "Talk to the Hand", 1, 2, nil, 2, nil},
	{3525, 10066, 1, 18, "Oh, the Tangled Webs They Weave", 1, 2, nil, 2, nil},
	{3525, 9669, 1, 19, "The Missing Expedition", 1, 2, nil, 2, nil},
	{3525, 9670, 1, 19, "They're Alive! Maybe...", 1, 2, nil, 2, nil},
	{3525, 9683, 1, 19, "Ending the Bloodcurse", 1, 2, nil, 2, nil},
	{3525, 9688, 1, 19, "Into the Dream", 1, 2, nil, 2, nil},
	{3525, 10067, 1, 19, "Fouled Water Spirits", 1, 2, nil, 2, nil},
	{3525, 9753, 1, 20, "What We Know... [Group]", 1, 2, nil, 1, "DRAENEI"},
	{3525, 9756, 1, 20, "What We Don't Know... [Group]", 1, 2, nil, 1, "DRAENEI"},
	{3525, 9759, 1, 20, "Ending Their World [Group]", 1, 2, nil, 1, "DRAENEI"},
	{3525, 9760, 1, 20, "Vindicator's Rest [Group]", 1, 2, nil, 1, "DRAENEI"},
	{3525, 9761, 1, 20, "Clearing the Way [Group]", 1, 2, nil, 1, "DRAENEI"},
	{3525, 9762, 5, 20, "The Unwritten Prophecy", 1, 2, nil, 1, "DRAENEI"},
	{3525, 9689, 1, 21, "Razormaw [Group]", 1, 2, nil, 2, nil},
	{148, 961, 5, 1, "Onu is meditating", 1, 2, nil, 2, nil},
	{148, 983, 1, 10, "Buzzbox 827", 1, 2, nil, 2, nil},
	{148, 6341, 1, 10, "The Bounty of Teldrassil", 1, 2, nil, 1, "NIGHTELF"},
	{148, 6342, 1, 10, "Flight to Auberdine", 1, 2, nil, 1, "NIGHTELF"},
	{148, 6343, 1, 10, "Return to Nessa", 1, 2, nil, 1, "NIGHTELF"},
	{148, 953, 1, 12, "The Fall of Ameth'Aran", 1, 2, nil, 2, nil},
	{148, 954, 1, 12, "Bashal'Aran", 1, 2, nil, 2, nil},
	{148, 955, 1, 12, "Bashal'Aran", 1, 2, nil, 2, nil},
	{148, 958, 1, 12, "Tools of the Highborne", 1, 2, nil, 2, nil},
	{148, 1001, 1, 12, "Buzzbox 411", 1, 2, nil, 2, nil},
	{148, 956, 1, 13, "Bashal'Aran", 1, 2, nil, 2, nil},
	{148, 957, 1, 13, "Bashal'Aran", 1, 2, nil, 2, nil},
	{148, 3524, 1, 13, "Washed Ashore", 1, 2, nil, 2, nil},
	{148, 4722, 1, 13, "Beached Sea Turtle", 1, 2, nil, 2, nil},
	{148, 4723, 1, 13, "Beached Sea Creature", 1, 2, nil, 2, nil},
	{148, 984, 1, 14, "How Big a Threat?", 1, 2, nil, 2, nil},
	{148, 985, 1, 14, "How Big a Threat?", 1, 2, nil, 2, nil},
	{148, 1002, 1, 14, "Buzzbox 323", 1, 2, nil, 2, nil},
	{148, 1141, 1, 14, "The Family and the Fishing Pole", 1, 2, nil, 2, nil},
	{148, 2118, 1, 14, "Plagued Lands", 1, 2, nil, 2, nil},
	{148, 4681, 1, 14, "Washed Ashore", 1, 2, nil, 2, nil},
	{148, 4728, 1, 14, "Beached Sea Creature", 1, 2, nil, 2, nil},
	{148, 4811, 1, 14, "The Red Crystal", 1, 2, nil, 2, nil},
	{148, 4812, 1, 14, "As Water Cascades", 1, 2, nil, 2, nil},
	{148, 4813, 1, 14, "The Fragments Within", 1, 2, nil, 2, nil},
	{148, 4725, 1, 15, "Beached Sea Turtle", 1, 2, nil, 2, nil},
	{148, 4727, 1, 15, "Beached Sea Turtle", 1, 2, nil, 2, nil},
	{148, 4761, 1, 15, "Thundris Windweaver", 1, 2, nil, 2, nil},
	{148, 4762, 1, 15, "The Cliffspring River", 1, 2, nil, 2, nil},
	{148, 5713, 1, 15, "One Shot. One Kill.", 1, 2, nil, 2, nil},
	{148, 963, 1, 16, "For Love Eternal", 1, 2, nil, 2, nil},
	{148, 1003, 1, 16, "Buzzbox 525", 1, 2, nil, 2, nil},
	{148, 2138, 1, 16, "Cleansing of the Infected", 1, 2, nil, 2, nil},
	{148, 4730, 1, 16, "Beached Sea Creature", 1, 2, nil, 2, nil},
	{148, 944, 1, 17, "The Master's Glaive", 1, 2, nil, 2, nil},
	{148, 947, 1, 17, "Cave Mushrooms", 1, 2, nil, 2, nil},
	{148, 948, 1, 17, "Onu", 1, 2, nil, 2, nil},
	{148, 949, 1, 17, "The Twilight Camp", 1, 2, nil, 2, nil},
	{148, 950, 1, 17, "Return to Onu", 1, 2, nil, 2, nil},
	{148, 982, 1, 17, "Deep Ocean, Vast Sea", 1, 2, nil, 2, nil},
	{148, 1138, 1, 17, "Fruit of the Sea", 1, 2, nil, 2, nil},
	{148, 945, 1, 18, "Therylune's Escape", 1, 2, nil, 2, nil},
	{148, 965, 1, 18, "The Tower of Althalaxx", 1, 2, nil, 2, nil},
	{148, 966, 1, 18, "The Tower of Althalaxx", 1, 2, nil, 2, nil},
	{148, 967, 1, 18, "The Tower of Althalaxx", 1, 2, nil, 2, nil},
	{148, 2139, 1, 18, "Tharnariun's Hope", 1, 2, nil, 2, nil},
	{148, 4740, 1, 18, "WANTED: Murkdeep!", 1, 2, nil, 2, nil},
	{148, 4763, 1, 18, "The Blackwood Corrupted", 1, 2, nil, 2, nil},
	{148, 4731, 1, 19, "Beached Sea Turtle", 1, 2, nil, 2, nil},
	{148, 4732, 1, 19, "Beached Sea Turtle", 1, 2, nil, 2, nil},
	{148, 4733, 1, 19, "Beached Sea Creature", 1, 2, nil, 2, nil},
	{148, 729, 1, 20, "The Absent Minded Prospector", 1, 2, nil, 2, nil},
	{148, 731, 1, 20, "The Absent Minded Prospector [Group]", 1, 2, nil, 2, nil},
	{148, 741, 1, 20, "The Absent Minded Prospector", 1, 2, nil, 2, nil},
	{148, 942, 1, 20, "The Absent Minded Prospector", 1, 2, nil, 2, nil},
	{148, 951, 1, 20, "Mathystra Relics", 1, 2, nil, 2, nil},
	{148, 968, 1, 20, "The Powers Below", 1, 2, nil, 2, nil},
	{148, 986, 1, 20, "A Lost Master", 1, 2, nil, 2, nil},
	{148, 993, 1, 20, "A Lost Master", 1, 2, nil, 2, nil},
	{148, 995, 1, 20, "Escape Through Stealth", 1, 2, nil, 2, nil},
	{148, 1133, 4, 20, "Journey to Astranaar [Removed]", 1, 2, nil, 2, nil},
	{148, 2078, 1, 20, "Gyromast's Revenge", 1, 2, nil, 2, nil},
	{148, 2098, 1, 20, "Gyromast's Retrieval", 1, 2, nil, 2, nil},
	{148, 5321, 1, 20, "The Sleeper Has Awakened", 1, 2, nil, 2, nil},
	{148, 970, 1, 21, "The Tower of Althalaxx", 1, 2, nil, 2, nil},
	{148, 994, 1, 22, "Escape Through Force", 1, 2, nil, 2, nil},
	{148, 943, 1, 24, "The Absent Minded Prospector", 1, 2, nil, 2, nil},
	{148, 973, 1, 24, "The Tower of Althalaxx", 1, 2, nil, 2, nil},
	{148, 1140, 1, 28, "The Tower of Althalaxx", 1, 2, nil, 2, nil},
	{148, 1167, 1, 28, "The Tower of Althalaxx", 1, 2, nil, 2, nil},
	{148, 981, 1, 31, "The Tower of Althalaxx", 1, 2, nil, 2, nil},
	{148, 1143, 1, 31, "The Tower of Althalaxx", 1, 2, nil, 2, nil},
	{393, 25445, 1, 78, "Zalazane's Fall", 2, 2, nil, 2, nil},
	{1657, 7671, 2, 1, "Frostsaber Replacement", 4, 2, nil, 2, nil},
	{1657, 7672, 2, 1, "Nightsaber Replacement", 4, 2, nil, 2, nil},
	{1657, 2519, 1, 10, "The Temple of the Moon", 1, 2, nil, 2, nil},
	{1657, 6344, 1, 10, "Nessa Shadowsong", 1, 2, nil, 1, "NIGHTELF"},
	{1657, 952, 1, 11, "Grove of the Ancients", 1, 2, nil, 2, nil},
	{1657, 2518, 1, 12, "Tears of the Moon", 1, 2, nil, 2, nil},
	{1657, 2520, 1, 12, "Sathrah's Sacrifice", 1, 2, nil, 2, nil},
	{1657, 730, 1, 14, "Trouble In Darkshore?", 1, 2, nil, 2, nil},
	{1657, 14085, 1, 20, "Learn to Ride in Darnassus", 1, 2, nil, 1, "NIGHTELF"},
	{1657, 3763, 1, 50, "Assisting Arch Druid Staghelm", 1, 2, nil, 2, nil},
	{1657, 3764, 1, 50, "Un'Goro Soil", 1, 2, nil, 2, nil},
	{1657, 3781, 1, 50, "Morrowgrain Research", 1, 2, nil, 2, nil},
	{1657, 3785, 1, 50, "Morrowgrain Research", 1, 2, nil, 2, nil},
	{1657, 3788, 1, 50, "Jonespyre's Request", 1, 2, nil, 2, nil},
	{1657, 3791, 1, 50, "The Mystery of Morrowgrain", 1, 2, nil, 2, nil},
	{1657, 5091, 1, 50, "A Call to Arms: The Plaguelands!", 1, 2, nil, 2, nil},
	{1657, 4493, 1, 53, "March of the Silithid", 1, 2, nil, 2, nil},
	{1657, 4510, 1, 54, "Calm Before the Storm", 1, 2, nil, 2, nil},
	{1657, 1047, 1, 55, "The New Frontier", 1, 2, nil, 2, nil},
	{1657, 3792, 2, 55, "Morrowgrain to Feathermoon Stronghold", 1, 2, nil, 2, nil},
	{1657, 3803, 2, 55, "Morrowgrain to Darnassus", 1, 2, nil, 2, nil},
	{1657, 6761, 1, 55, "The New Frontier", 1, 2, nil, 2, nil},
	{1657, 6762, 1, 55, "Rabine Saturna", 1, 2, nil, 2, nil},
	{1657, 7799, 5, 60, "A Donation of Mageweave", 1, 2, nil, 2, nil},
	{1657, 7800, 5, 60, "A Donation of Runecloth", 1, 2, nil, 2, nil},
	{1657, 7801, 2, 60, "Additional Runecloth", 1, 2, nil, 2, nil},
	{1657, 10352, 5, 60, "A Donation of Wool", 1, 2, nil, 2, nil},
	{1657, 10354, 5, 60, "A Donation of Silk", 1, 2, nil, 2, nil},
	{1657, 14409, 1, 73, "A Cautious Return", 1, 2, nil, 2, nil},
	{405, 5421, 2, 25, "Fish in a Bucket", 2, 2, nil, 2, nil},
	{405, 1387, 1, 31, "Centaur Bounty", 1, 2, nil, 2, nil},
	{405, 1366, 1, 31, "Centaur Bounty", 2, 2, nil, 2, nil},
	{405, 5763, 1, 31, "Hunting in Stranglethorn", 2, 2, nil, 2, nil},
	{405, 1384, 1, 32, "Raid on the Kolkar", 1, 2, nil, 2, nil},
	{405, 1386, 1, 32, "Assault on the Kolkar", 1, 2, nil, 2, nil},
	{405, 1361, 1, 32, "Regthar Deathgate", 2, 2, nil, 2, nil},
	{405, 1362, 1, 32, "The Kolkar of Desolace", 2, 2, nil, 2, nil},
	{405, 5501, 1, 32, "Bone Collector", 3, 2, nil, 2, nil},
	{405, 1437, 1, 33, "Vahlarriel's Search", 1, 2, nil, 2, nil},
	{405, 1438, 1, 33, "Vahlarriel's Search", 1, 2, nil, 2, nil},
	{405, 1439, 1, 33, "Search for Tyranis", 1, 2, nil, 2, nil},
	{405, 1440, 1, 33, "Return to Vahlarriel", 1, 2, nil, 2, nil},
	{405, 1458, 1, 33, "Reagents for Reclaimers Inc.", 1, 2, nil, 2, nil},
	{405, 1465, 1, 33, "Vahlarriel's Search", 1, 2, nil, 2, nil},
	{405, 1367, 1, 33, "Magram Alliance", 2, 2, nil, 2, nil},
	{405, 1368, 1, 33, "Gelkis Alliance", 2, 2, nil, 2, nil},
	{405, 1480, 1, 33, "The Corrupter", 2, 2, nil, 2, nil},
	{405, 1481, 1, 33, "The Corrupter", 2, 2, nil, 2, nil},
	{405, 1484, 1, 33, "The Corrupter", 2, 2, nil, 2, nil},
	{405, 1369, 1, 33, "Broken Tears", 3, 2, nil, 2, nil},
	{405, 5741, 1, 33, "Sceptre of Light", 3, 2, nil, 2, nil},
	{405, 5561, 1, 34, "Kodo Roundup", 3, 2, nil, 2, nil},
	{405, 1382, 1, 35, "Strange Alliance", 1, 2, nil, 2, nil},
	{405, 1385, 1, 35, "Brutal Politics", 1, 2, nil, 2, nil},
	{405, 1459, 1, 35, "Reagents for Reclaimers Inc.", 1, 2, nil, 2, nil},
	{405, 1365, 1, 35, "Khan Dez'hepah", 2, 2, nil, 2, nil},
	{405, 1482, 1, 35, "The Corrupter", 2, 2, nil, 2, nil},
	{405, 6142, 1, 35, "Clam Bait", 2, 2, nil, 2, nil},
	{405, 1370, 1, 35, "Stealing Supplies", 3, 2, nil, 2, nil},
	{405, 1371, 1, 35, "Gizmo for Warug", 3, 2, nil, 2, nil},
	{405, 5821, 1, 35, "Bodyguard for Hire", 3, 2, nil, 2, nil},
	{405, 6143, 1, 36, "Other Fish to Fry", 2, 2, nil, 2, nil},
	{405, 6161, 1, 36, "Claim Rackmore's Treasure!", 3, 2, nil, 2, nil},
	{405, 5386, 1, 37, "Catch of the Day", 2, 2, nil, 2, nil},
	{405, 1373, 1, 37, "Ongeku", 3, 2, nil, 2, nil},
	{405, 1374, 1, 37, "Khan Jehn", 3, 2, nil, 2, nil},
	{405, 1375, 1, 37, "Khan Shaka", 3, 2, nil, 2, nil},
	{405, 5381, 1, 38, "Hand of Iruxos", 2, 2, nil, 2, nil},
	{405, 5581, 1, 38, "Portals of the Legion", 2, 2, nil, 2, nil},
	{405, 5943, 1, 38, "Gizelton Caravan", 3, 2, nil, 2, nil},
	{405, 6027, 1, 38, "Book of the Ancients", 3, 2, nil, 2, nil},
	{405, 261, 1, 39, "Down the Scarlet Path", 1, 2, nil, 2, nil},
	{405, 1454, 1, 39, "The Karnitol Shipwreck", 1, 2, nil, 2, nil},
	{405, 1455, 1, 39, "The Karnitol Shipwreck", 1, 2, nil, 2, nil},
	{405, 1456, 1, 39, "The Karnitol Shipwreck", 1, 2, nil, 2, nil},
	{405, 1457, 1, 39, "The Karnitol Shipwreck", 1, 2, nil, 2, nil},
	{405, 6141, 1, 39, "Brother Anton", 1, 2, nil, 2, nil},
	{405, 6132, 1, 39, "Get Me Out of Here!", 3, 2, nil, 2, nil},
	{405, 6134, 1, 39, "Ghost-o-plasm Round Up", 3, 2, nil, 2, nil},
	{405, 1052, 1, 40, "Down the Scarlet Path", 1, 2, nil, 2, nil},
	{405, 1466, 1, 40, "Reagents for Reclaimers Inc.", 1, 2, nil, 2, nil},
	{405, 1467, 1, 40, "Reagents for Reclaimers Inc.", 1, 2, nil, 2, nil},
	{405, 1488, 1, 40, "The Corrupter [Group]", 2, 2, nil, 2, nil},
	{405, 1380, 1, 42, "Khan Hratha", 3, 2, nil, 2, nil},
	{405, 1381, 1, 42, "Khan Hratha", 3, 2, nil, 2, nil},
	{405, 6568, 1, 60, "Mistress of Deception", 2, 2, nil, 2, nil},
	{14, 25444, 1, 0, "Da Perfect Spies", 2, 2, nil, 2, nil},
	{14, 25446, 1, 0, "Frogs Away!", 2, 2, nil, 2, nil},
	{14, 25461, 1, 0, "Trollin' For Volunteers", 2, 2, nil, 2, nil},
	{14, 25470, 1, 0, "Lady Of Da Tigers", 2, 2, nil, 2, nil},
	{14, 25480, 1, 0, "Dance Of De Spirits", 2, 2, nil, 2, nil},
	{14, 25495, 1, 0, "Preparin' For Battle", 2, 2, nil, 2, nil},
	{14, 4641, 1, 1, "Your Place In The World", 2, 2, nil, 2, nil},
	{14, 5843, 1, 1, "Welcome!", 2, 2, nil, 1, "TODO:RACE"},
	{14, 7664, 2, 1, "Ivory Raptor Replacement", 2, 2, nil, 2, nil},
	{14, 7665, 2, 1, "Red Raptor Replacement", 2, 2, nil, 2, nil},
	{14, 788, 1, 2, "Cutting Teeth", 2, 2, nil, 2, nil},
	{14, 789, 1, 3, "Sting of the Scorpid", 2, 2, nil, 2, nil},
	{14, 4402, 1, 3, "Galgar's Cactus Apple Surprise", 2, 2, nil, 2, nil},
	{14, 792, 1, 4, "Vile Familiars", 2, 2, nil, 2, nil},
	{14, 5441, 1, 4, "Lazy Peons", 2, 2, nil, 2, nil},
	{14, 6394, 1, 4, "Thazz'ril's Pick", 2, 2, nil, 2, nil},
	{14, 790, 1, 5, "Sarkoth", 2, 2, nil, 2, nil},
	{14, 794, 1, 5, "Burning Blade Medallion", 2, 2, nil, 2, nil},
	{14, 804, 1, 5, "Sarkoth", 2, 2, nil, 2, nil},
	{14, 805, 1, 5, "Report to Sen'jin Village", 2, 2, nil, 2, nil},
	{14, 2161, 1, 5, "A Peon's Burden", 2, 2, nil, 2, nil},
	{14, 784, 1, 7, "Vanquish the Betrayers", 2, 2, nil, 2, nil},
	{14, 791, 1, 7, "Carry Your Weight", 2, 2, nil, 2, nil},
	{14, 818, 1, 7, "A Solvent Spirit", 2, 2, nil, 2, nil},
	{14, 823, 1, 7, "Report to Orgnil", 2, 2, nil, 2, nil},
	{14, 830, 1, 7, "The Admiral's Orders", 2, 2, nil, 2, nil},
	{14, 831, 1, 7, "The Admiral's Orders", 2, 2, nil, 2, nil},
	{14, 786, 1, 8, "Thwarting Kolkar Aggression", 2, 2, nil, 2, nil},
	{14, 815, 1, 8, "Break a Few Eggs", 2, 2, nil, 2, nil},
	{14, 817, 1, 8, "Practical Prey", 2, 2, nil, 2, nil},
	{14, 825, 1, 8, "From The Wreckage....", 2, 2, nil, 2, nil},
	{14, 808, 1, 9, "Minshina's Skull", 2, 2, nil, 2, nil},
	{14, 812, 1, 9, "Need for a Cure", 2, 2, nil, 2, nil},
	{14, 813, 5, 9, "Finding the Antidote", 2, 2, nil, 2, nil},
	{14, 834, 1, 9, "Winds in the Desert", 3, 2, nil, 2, nil},
	{14, 826, 1, 10, "Zalazane", 2, 2, nil, 2, nil},
	{14, 837, 1, 10, "Encroachment", 2, 2, nil, 2, nil},
	{14, 26951, 1, 10, "Cleanup on Isle E.", 2, 2, nil, 2, nil},
	{14, 816, 1, 11, "Lost But Not Forgotten", 2, 2, nil, 2, nil},
	{14, 835, 1, 11, "Securing the Lines", 3, 2, nil, 2, nil},
	{14, 806, 1, 12, "Dark Storms", 2, 2, nil, 2, nil},
	{14, 827, 1, 12, "Skull Rock", 2, 2, nil, 2, nil},
	{14, 828, 1, 12, "Margoz", 2, 2, nil, 2, nil},
	{14, 829, 1, 12, "Neeru Fireblade", 2, 2, nil, 2, nil},
	{14, 832, 1, 12, "Burning Shadows", 2, 2, nil, 2, nil},
	{14, 840, 1, 12, "Conscript of the Horde", 2, 2, nil, 2, nil},
	{14, 842, 1, 12, "Crossroads Conscription", 2, 2, nil, 2, nil},
	{14, 809, 1, 13, "Ak'Zeloth", 2, 2, nil, 2, nil},
	{14, 924, 1, 14, "The Demon Seed", 2, 2, nil, 2, nil},
	{14, 926, 2, 14, "Flawed Power Stone", 2, 2, nil, 2, nil},
	{14, 14088, 1, 20, "Learn to Ride in Durotar", 2, 2, nil, 1, "TROLL"},
	{15, 1219, 1, 35, "The Orc Report", 1, 2, nil, 2, nil},
	{15, 1220, 1, 35, "Captain Vimes", 1, 2, nil, 2, nil},
	{15, 1252, 1, 35, "Lieutenant Paval Reethe", 1, 2, nil, 2, nil},
	{15, 1253, 1, 35, "The Black Shield", 1, 2, nil, 2, nil},
	{15, 1282, 1, 35, "They Call Him Smiling Jim", 1, 2, nil, 2, nil},
	{15, 1284, 1, 35, "Suspicious Hoofprints", 1, 2, nil, 2, nil},
	{15, 1319, 1, 35, "The Black Shield", 1, 2, nil, 2, nil},
	{15, 1320, 1, 35, "The Black Shield", 1, 2, nil, 2, nil},
	{15, 11123, 1, 35, "Inspecting the Ruins", 1, 2, nil, 2, nil},
	{15, 11126, 1, 35, "Traitors Among Us", 1, 2, nil, 2, nil},
	{15, 11128, 1, 35, "Propaganda War", 1, 2, nil, 2, nil},
	{15, 11133, 1, 35, "Discrediting the Deserters", 1, 2, nil, 2, nil},
	{15, 11191, 1, 35, "This Old Lighthouse", 1, 2, nil, 2, nil},
	{15, 11192, 1, 35, "Thresher Oil", 1, 2, nil, 2, nil},
	{15, 11193, 1, 35, "Dastardly Denizens of the Deep", 1, 2, nil, 2, nil},
	{15, 1201, 1, 35, "Theramore Spies", 2, 2, nil, 2, nil},
	{15, 1202, 1, 35, "The Theramore Docks", 2, 2, nil, 2, nil},
	{15, 1238, 1, 35, "The Lost Report", 2, 2, nil, 2, nil},
	{15, 1239, 1, 35, "The Severed Head", 2, 2, nil, 2, nil},
	{15, 1240, 1, 35, "The Troll Witchdoctor", 2, 2, nil, 2, nil},
	{15, 1251, 1, 35, "The Black Shield", 2, 2, nil, 2, nil},
	{15, 1268, 1, 35, "Suspicious Hoofprints", 2, 2, nil, 2, nil},
	{15, 1321, 1, 35, "The Black Shield", 2, 2, nil, 2, nil},
	{15, 11124, 1, 35, "Inspecting the Ruins", 2, 2, nil, 2, nil},
	{15, 1203, 1, 35, "Jarl Needs a Blade", 3, 2, nil, 2, nil},
	{15, 1206, 1, 35, "Jarl Needs Eyes", 3, 2, nil, 2, nil},
	{15, 1218, 1, 35, "Marsh Frog Legs", 3, 2, nil, 2, nil},
	{15, 11136, 1, 36, "A Disturbing Development", 1, 2, nil, 2, nil},
	{15, 11177, 1, 36, "The Hermit of Swamplight Manor", 1, 2, nil, 2, nil},
	{15, 11194, 1, 36, "Is it Real?", 1, 2, nil, 2, nil},
	{15, 11198, 1, 36, "Take Down Tethyr!", 1, 2, nil, 2, nil},
	{15, 11225, 1, 36, "The Hermit of Witch Hill", 2, 2, nil, 2, nil},
	{15, 1177, 1, 36, "Hungry!", 3, 2, nil, 2, nil},
	{15, 11180, 1, 36, "What's Haunting Witch Hill?", 3, 2, nil, 2, nil},
	{15, 11181, 1, 36, "The Witch's Bane", 3, 2, nil, 2, nil},
	{15, 11183, 1, 36, "Cleansing Witch Hill", 3, 2, nil, 2, nil},
	{15, 1222, 1, 37, "Stinky's Escape", 1, 2, nil, 2, nil},
	{15, 1271, 5, 37, "Feast at the Blue Recluse", 1, 2, nil, 2, nil},
	{15, 11134, 1, 37, "The End of the Deserters", 1, 2, nil, 2, nil},
	{15, 11137, 1, 37, "Defias in Dustwallow?", 1, 2, nil, 2, nil},
	{15, 11138, 1, 37, "Renn McGill", 1, 2, nil, 2, nil},
	{15, 11139, 1, 37, "Secondhand Diving Gear", 1, 2, nil, 2, nil},
	{15, 11140, 1, 37, "Recover the Cargo!", 1, 2, nil, 2, nil},
	{15, 11141, 1, 37, "Jaina Must Know", 1, 2, nil, 2, nil},
	{15, 11142, 1, 37, "Survey Alcaz Island", 1, 2, nil, 2, nil},
	{15, 11145, 1, 37, "Prisoners of the Grimtotems", 1, 2, nil, 2, nil},
	{15, 11146, 1, 37, "Raptor Captor", 1, 2, nil, 2, nil},
	{15, 11147, 1, 37, "Unleash the Raptors", 1, 2, nil, 2, nil},
	{15, 11209, 1, 37, "Nat's Bargain", 1, 2, nil, 2, nil},
	{15, 11210, 1, 37, "Oh, It's Real", 1, 2, nil, 2, nil},
	{15, 11212, 1, 37, "Tabetha's Farm", 1, 2, nil, 2, nil},
	{15, 11222, 4, 37, "Proof of Treachery [Removed]", 1, 2, nil, 2, nil},
	{15, 11223, 4, 37, "Return to Jaina [Removed]", 1, 2, nil, 2, nil},
	{15, 1269, 1, 37, "Lieutenant Paval Reethe", 2, 2, nil, 2, nil},
	{15, 1270, 1, 37, "Stinky's Escape", 2, 2, nil, 2, nil},
	{15, 1273, 1, 37, "Questioning Reethe", 2, 2, nil, 2, nil},
	{15, 1276, 1, 37, "The Black Shield", 2, 2, nil, 2, nil},
	{15, 1322, 1, 37, "The Black Shield", 2, 2, nil, 2, nil},
	{15, 1323, 1, 37, "The Black Shield", 2, 2, nil, 2, nil},
	{15, 9437, 1, 37, "Twilight of the Dawn Runner", 2, 2, nil, 2, nil},
	{15, 11200, 1, 37, "More than Coincidence", 2, 2, nil, 2, nil},
	{15, 11203, 1, 37, "Seek Out Tabetha", 2, 2, nil, 2, nil},
	{15, 11213, 1, 37, "Check Up on Tabetha", 2, 2, nil, 2, nil},
	{15, 1204, 1, 38, "Mudrock Soup and Bugs", 1, 2, nil, 2, nil},
	{15, 1260, 1, 38, "Morgan Stern", 1, 2, nil, 2, nil},
	{15, 1285, 1, 38, "Daelin's Men", 1, 2, nil, 2, nil},
	{15, 1286, 1, 38, "The Deserters", 1, 2, nil, 2, nil},
	{15, 1287, 1, 38, "The Deserters", 1, 2, nil, 2, nil},
	{15, 11143, 1, 38, "A Grim Connection", 1, 2, nil, 2, nil},
	{15, 11144, 1, 38, "Confirming the Suspicion", 1, 2, nil, 2, nil},
	{15, 11148, 1, 38, "Arms of the Grimtotems", 1, 2, nil, 2, nil},
	{15, 11185, 1, 38, "The Apothecary's Letter", 1, 2, nil, 2, nil},
	{15, 11186, 1, 38, "Signs of Treachery?", 2, 2, nil, 2, nil},
	{15, 11201, 1, 38, "The Grimtotem Plot", 2, 2, nil, 2, nil},
	{15, 11204, 1, 38, "Return to Krog", 2, 2, nil, 2, nil},
	{15, 11169, 1, 38, "The Grimtotem Weapon", 3, 2, nil, 2, nil},
	{15, 11149, 1, 39, "Tabetha's Assistance", 1, 2, nil, 2, nil},
	{15, 11150, 1, 39, "Raze Direhorn Post!", 1, 2, nil, 2, nil},
	{15, 11151, 1, 39, "Justice for the Hyals", 1, 2, nil, 2, nil},
	{15, 11152, 1, 39, "Peace at Last", 1, 2, nil, 2, nil},
	{15, 11214, 1, 39, "Mission to Mudsprocket", 1, 2, nil, 2, nil},
	{15, 11205, 1, 39, "Raze Direhorn Post!", 2, 2, nil, 2, nil},
	{15, 11206, 1, 39, "Justice Dispensed", 2, 2, nil, 2, nil},
	{15, 11215, 1, 39, "Help Mudsprocket", 2, 2, nil, 2, nil},
	{15, 11156, 1, 39, "Direhorn Raiders", 3, 2, nil, 2, nil},
	{15, 11158, 1, 39, "Bloodfen Feathers", 3, 2, nil, 2, nil},
	{15, 11160, 1, 39, "Banner of the Stonemaul", 3, 2, nil, 2, nil},
	{15, 11161, 1, 39, "The Essence of Enmity", 3, 2, nil, 2, nil},
	{15, 11173, 1, 39, "The Reagent Thief", 3, 2, nil, 2, nil},
	{15, 11184, 1, 39, "WANTED: Goreclaw the Ravenous", 3, 2, nil, 2, nil},
	{15, 11207, 1, 39, "Secure the Cargo!", 3, 2, nil, 2, nil},
	{15, 11208, 1, 39, "Delivery for Drazzit", 3, 2, nil, 2, nil},
	{15, 11211, 1, 39, "Help for Mudsprocket", 3, 2, nil, 2, nil},
	{15, 1258, 1, 40, "... and Bugs", 1, 2, nil, 2, nil},
	{15, 1259, 1, 40, "Lieutenant Paval Reethe", 1, 2, nil, 2, nil},
	{15, 1261, 1, 40, "Marg Speaks", 2, 2, nil, 2, nil},
	{15, 1262, 1, 40, "Report to Zor", 2, 2, nil, 2, nil},
	{15, 7541, 5, 40, "Service to the Horde", 2, 2, nil, 2, nil},
	{15, 11172, 1, 40, "The Zeppelin Crash", 3, 2, nil, 2, nil},
	{15, 11174, 1, 40, "Corrosion Prevention", 3, 2, nil, 2, nil},
	{15, 11217, 1, 40, "Catch a Dragon by the Tail", 3, 2, nil, 2, nil},
	{15, 1166, 1, 41, "Overlord Mok'Morokk's Concern", 2, 2, nil, 2, nil},
	{15, 1168, 1, 41, "Army of the Black Dragon", 2, 2, nil, 2, nil},
	{15, 1169, 1, 41, "Identifying the Brood", 2, 2, nil, 2, nil},
	{15, 1170, 1, 41, "The Brood of Onyxia", 2, 2, nil, 2, nil},
	{15, 1171, 1, 41, "The Brood of Onyxia", 2, 2, nil, 2, nil},
	{15, 1172, 1, 41, "The Brood of Onyxia", 2, 2, nil, 2, nil},
	{15, 1205, 1, 41, "Deadmire", 2, 2, nil, 2, nil},
	{15, 11159, 1, 41, "Spirits of Stonemaul Hold", 3, 2, nil, 2, nil},
	{15, 11162, 1, 41, "Challenge to the Black Flight", 3, 2, nil, 2, nil},
	{15, 1173, 1, 45, "Challenge Overlord Mok'Morokk [Group]", 2, 2, nil, 2, nil},
	{15, 6570, 1, 60, "Emberstrife [Group]", 2, 2, nil, 2, nil},
	{15, 6582, 1, 60, "The Test of Skulls, Scryer [Raid]", 2, 2, nil, 2, nil},
	{15, 6583, 1, 60, "The Test of Skulls, Somnus [Raid]", 2, 2, nil, 2, nil},
	{15, 6584, 1, 60, "The Test of Skulls, Chronalis [Raid]", 2, 2, nil, 2, nil},
	{15, 6585, 1, 60, "The Test of Skulls, Axtroz [Raid]", 2, 2, nil, 2, nil},
	{15, 6601, 1, 60, "Ascension...", 2, 2, nil, 2, nil},
	{15, 8970, 1, 60, "I See Alcaz Island In Your Future... [Group]", 3, 2, nil, 2, nil},
	{361, 8460, 1, 48, "Timbermaw Ally", 3, 2, nil, 2, nil},
	{361, 6162, 1, 51, "A Husband's Last Battle", 2, 2, nil, 2, nil},
	{361, 5155, 1, 51, "Forces of Jaedenar", 3, 2, nil, 2, nil},
	{361, 5157, 1, 52, "Collection of the Corrupt Water", 3, 2, nil, 2, nil},
	{361, 5158, 1, 52, "Seeking Spiritual Aid", 3, 2, nil, 2, nil},
	{361, 939, 1, 54, "Flute of Xavaric", 1, 2, nil, 2, nil},
	{361, 4421, 1, 54, "The Corruption of the Jadefire", 1, 2, nil, 2, nil},
	{361, 4441, 1, 54, "Felbound Ancients", 1, 2, nil, 2, nil},
	{361, 4442, 1, 54, "Purified!", 1, 2, nil, 2, nil},
	{361, 4906, 1, 54, "Further Corruption", 1, 2, nil, 2, nil},
	{361, 4505, 1, 54, "Well of Corruption", 2, 2, nil, 2, nil},
	{361, 4506, 1, 54, "Corrupted Sabers", 2, 2, nil, 2, nil},
	{361, 5156, 1, 54, "Verifying the Corruption", 3, 2, nil, 2, nil},
	{361, 5159, 1, 54, "Cleansed Water Returns to Felwood", 3, 2, nil, 2, nil},
	{361, 8470, 1, 55, "Deadwood Ritual Totem", 4, 2, nil, 2, nil},
	{361, 4101, 1, 55, "Cleansing Felwood", 1, 2, nil, 2, nil},
	{361, 4103, 2, 55, "Salve via Hunting", 1, 2, nil, 2, nil},
	{361, 4104, 2, 55, "Salve via Mining", 1, 2, nil, 2, nil},
	{361, 4105, 2, 55, "Salve via Gathering", 1, 2, nil, 2, nil},
	{361, 4106, 2, 55, "Salve via Skinning", 1, 2, nil, 2, nil},
	{361, 4107, 2, 55, "Salve via Disenchanting", 1, 2, nil, 2, nil},
	{361, 4108, 2, 55, "Salve via Hunting", 1, 2, nil, 2, nil},
	{361, 4109, 2, 55, "Salve via Mining", 1, 2, nil, 2, nil},
	{361, 4110, 2, 55, "Salve via Gathering", 1, 2, nil, 2, nil},
	{361, 4111, 2, 55, "Salve via Skinning", 1, 2, nil, 2, nil},
	{361, 4112, 2, 55, "Salve via Disenchanting", 1, 2, nil, 2, nil},
	{361, 4102, 1, 55, "Cleansing Felwood", 2, 2, nil, 2, nil},
	{361, 5882, 5, 55, "Salve via Hunting", 2, 2, nil, 2, nil},
	{361, 5883, 5, 55, "Salve via Mining", 2, 2, nil, 2, nil},
	{361, 5884, 5, 55, "Salve via Gathering", 2, 2, nil, 2, nil},
	{361, 5885, 5, 55, "Salve via Skinning", 2, 2, nil, 2, nil},
	{361, 5886, 5, 55, "Salve via Disenchanting", 2, 2, nil, 2, nil},
	{361, 5887, 5, 55, "Salve via Hunting", 2, 2, nil, 2, nil},
	{361, 5888, 5, 55, "Salve via Mining", 2, 2, nil, 2, nil},
	{361, 5889, 5, 55, "Salve via Gathering", 2, 2, nil, 2, nil},
	{361, 5890, 5, 55, "Salve via Skinning", 2, 2, nil, 2, nil},
	{361, 5891, 5, 55, "Salve via Disenchanting", 2, 2, nil, 2, nil},
	{361, 996, 2, 55, "Corrupted Windblossom", 3, 2, nil, 2, nil},
	{361, 998, 2, 55, "Corrupted Windblossom", 3, 2, nil, 2, nil},
	{361, 2523, 2, 55, "Corrupted Songflower", 3, 2, nil, 2, nil},
	{361, 3363, 2, 55, "Corrupted Songflower", 3, 2, nil, 2, nil},
	{361, 4117, 2, 55, "Corrupted Whipper Root", 3, 2, nil, 2, nil},
	{361, 4119, 2, 55, "Corrupted Night Dragon", 3, 2, nil, 2, nil},
	{361, 4443, 2, 55, "Corrupted Whipper Root", 3, 2, nil, 2, nil},
	{361, 4447, 2, 55, "Corrupted Night Dragon", 3, 2, nil, 2, nil},
	{361, 5165, 1, 55, "Dousing the Flames of Protection", 3, 2, nil, 2, nil},
	{361, 5202, 1, 55, "A Strange Red Key", 3, 2, nil, 2, nil},
	{361, 5203, 1, 55, "Rescue From Jaedenar", 3, 2, nil, 2, nil},
	{361, 8462, 1, 55, "Speak to Nafien", 3, 2, nil, 2, nil},
	{361, 8465, 1, 55, "Speak to Salfa", 3, 2, nil, 2, nil},
	{361, 8466, 2, 55, "Feathers for Grazle", 3, 2, nil, 2, nil},
	{361, 8467, 2, 55, "Feathers for Nafien", 3, 2, nil, 2, nil},
	{361, 4261, 1, 56, "Ancient Spirit", 1, 2, nil, 2, nil},
	{361, 5249, 1, 56, "To Winterspring!", 1, 2, nil, 2, nil},
	{361, 4521, 1, 56, "Wild Guardians", 2, 2, nil, 2, nil},
	{361, 8469, 2, 56, "Beads for Salfa", 3, 2, nil, 2, nil},
	{361, 5204, 1, 57, "Retribution of the Light", 3, 2, nil, 2, nil},
	{361, 5385, 1, 57, "The Remains of Trey Lightforge", 3, 2, nil, 2, nil},
	{361, 4741, 1, 58, "Wild Guardians", 2, 2, nil, 2, nil},
	{361, 5242, 1, 58, "A Final Blow", 3, 2, nil, 2, nil},
	{361, 4721, 1, 59, "Wild Guardians", 2, 2, nil, 2, nil},
	{357, 3567, 2, 25, "To the Top", 3, 2, nil, 2, nil},
	{357, 2862, 1, 42, "War on the Woodpaw", 2, 2, nil, 2, nil},
	{357, 2866, 1, 43, "The Ruins of Solarsal", 1, 2, nil, 2, nil},
	{357, 2867, 1, 43, "Return to Feathermoon Stronghold", 1, 2, nil, 2, nil},
	{357, 2869, 1, 43, "Against the Hatecrest", 1, 2, nil, 2, nil},
	{357, 3130, 1, 43, "Against the Hatecrest", 1, 2, nil, 2, nil},
	{357, 4124, 1, 43, "The Missing Courier", 1, 2, nil, 2, nil},
	{357, 4125, 1, 43, "The Missing Courier", 1, 2, nil, 2, nil},
	{357, 2863, 1, 43, "Alpha Strike", 2, 2, nil, 2, nil},
	{357, 2902, 1, 43, "Woodpaw Investigation", 2, 2, nil, 2, nil},
	{357, 2903, 1, 43, "The Battle Plans", 2, 2, nil, 2, nil},
	{357, 2975, 1, 43, "The Ogres of Feralas", 2, 2, nil, 2, nil},
	{357, 2978, 1, 43, "The Gordunni Scroll", 2, 2, nil, 2, nil},
	{357, 2987, 1, 43, "Gordunni Cobalt", 2, 2, nil, 2, nil},
	{357, 2982, 1, 44, "The High Wilderness", 1, 2, nil, 2, nil},
	{357, 4127, 1, 44, "Boat Wreckage", 1, 2, nil, 2, nil},
	{357, 4129, 1, 44, "The Knife Revealed", 1, 2, nil, 2, nil},
	{357, 4130, 1, 44, "Psychometric Reading", 1, 2, nil, 2, nil},
	{357, 4131, 1, 44, "The Woodpaw Gnolls", 1, 2, nil, 2, nil},
	{357, 4281, 1, 44, "Thalanaar Delivery", 1, 2, nil, 2, nil},
	{357, 2980, 1, 44, "The Ogres of Feralas", 2, 2, nil, 2, nil},
	{357, 2870, 1, 45, "Against Lord Shalzaru", 1, 2, nil, 2, nil},
	{357, 2871, 1, 45, "Delivering the Relic", 1, 2, nil, 2, nil},
	{357, 2973, 1, 45, "A New Cloak's Sheen", 2, 2, nil, 2, nil},
	{357, 2974, 1, 45, "A Grim Discovery", 2, 2, nil, 2, nil},
	{357, 2976, 1, 45, "A Grim Discovery", 2, 2, nil, 2, nil},
	{357, 3121, 1, 45, "A Strange Request", 2, 2, nil, 2, nil},
	{357, 3122, 1, 45, "Return to Witch Doctor Uzer'i", 2, 2, nil, 2, nil},
	{357, 3125, 1, 45, "Faerie Dragon Muisek", 2, 2, nil, 2, nil},
	{357, 7730, 1, 45, "Zukk'ash Infestation", 2, 2, nil, 2, nil},
	{357, 2766, 1, 45, "Find OOX-22/FE!", 3, 2, nil, 2, nil},
	{357, 2767, 1, 45, "Rescue OOX-22/FE!", 3, 2, nil, 2, nil},
	{357, 2821, 1, 46, "The Mark of Quality", 1, 2, nil, 2, nil},
	{357, 4135, 1, 46, "The Writhing Deep", 1, 2, nil, 2, nil},
	{357, 4265, 1, 46, "Freed from the Hive", 1, 2, nil, 2, nil},
	{357, 4266, 1, 46, "A Hero's Welcome", 1, 2, nil, 2, nil},
	{357, 4267, 1, 46, "Rise of the Silithid", 1, 2, nil, 2, nil},
	{357, 2822, 1, 46, "The Mark of Quality", 2, 2, nil, 2, nil},
	{357, 2979, 1, 46, "Dark Ceremony", 2, 2, nil, 2, nil},
	{357, 2939, 1, 47, "In Search of Knowledge", 1, 2, nil, 2, nil},
	{357, 2940, 1, 47, "Feralas: A History", 1, 2, nil, 2, nil},
	{357, 2969, 1, 47, "Freedom for All Creatures", 1, 2, nil, 2, nil},
	{357, 2970, 1, 47, "Doling Justice", 1, 2, nil, 2, nil},
	{357, 2972, 1, 47, "Doling Justice", 1, 2, nil, 2, nil},
	{357, 3841, 1, 47, "An Orphan Looking For a Home", 1, 2, nil, 2, nil},
	{357, 3842, 1, 47, "A Short Incubation", 1, 2, nil, 2, nil},
	{357, 3843, 1, 47, "The Newest Member of the Family", 1, 2, nil, 2, nil},
	{357, 4297, 1, 47, "Food for Baby", 1, 2, nil, 2, nil},
	{357, 3002, 1, 47, "The Gordunni Orb", 2, 2, nil, 2, nil},
	{357, 3123, 1, 47, "Testing the Vessel", 2, 2, nil, 2, nil},
	{357, 3124, 1, 47, "Hippogryph Muisek", 2, 2, nil, 2, nil},
	{357, 7731, 1, 47, "Stinglasher", 2, 2, nil, 2, nil},
	{357, 2941, 1, 48, "The Borrower", 1, 2, nil, 2, nil},
	{357, 2943, 1, 48, "Return to Troyas", 1, 2, nil, 2, nil},
	{357, 2944, 1, 48, "The Super Snapper FX", 1, 2, nil, 2, nil},
	{357, 4298, 1, 48, "Becoming a Parent", 1, 2, nil, 2, nil},
	{357, 7733, 1, 48, "Improved Quality", 1, 2, nil, 2, nil},
	{357, 7735, 1, 48, "Pristine Yeti Hide", 1, 2, nil, 2, nil},
	{357, 7732, 1, 48, "Zukk'ash Report", 2, 2, nil, 2, nil},
	{357, 7734, 1, 48, "Improved Quality", 2, 2, nil, 2, nil},
	{357, 7738, 1, 48, "Perfect Yeti Hide", 2, 2, nil, 2, nil},
	{357, 7003, 1, 48, "Zapped Giants", 3, 2, nil, 2, nil},
	{357, 7721, 1, 48, "Fuel for the Zapping", 3, 2, nil, 2, nil},
	{357, 2844, 1, 49, "The Giant Guardian", 1, 2, nil, 2, nil},
	{357, 2845, 1, 49, "Wandering Shay", 1, 2, nil, 2, nil},
	{357, 2879, 1, 50, "The Stave of Equinex", 1, 2, nil, 2, nil},
	{357, 2942, 1, 50, "The Morrow Stone", 1, 2, nil, 2, nil},
	{357, 3062, 1, 50, "Dark Heart", 2, 2, nil, 2, nil},
	{357, 3063, 1, 50, "Vengeance on the Northspring", 2, 2, nil, 2, nil},
	{357, 3126, 1, 50, "Treant Muisek", 2, 2, nil, 2, nil},
	{357, 3127, 1, 50, "Mountain Giant Muisek [Group]", 2, 2, nil, 2, nil},
	{357, 3128, 1, 50, "Natural Materials", 2, 2, nil, 2, nil},
	{357, 3129, 1, 50, "Weapons of Spirit", 2, 2, nil, 2, nil},
	{357, 3445, 1, 51, "The Sunken Temple", 1, 2, nil, 2, nil},
	{357, 3380, 1, 51, "The Sunken Temple [Dungeon]", 2, 2, nil, 2, nil},
	{357, 4120, 1, 52, "The Strength of Corruption", 2, 2, nil, 2, nil},
	{357, 4041, 2, 52, "The Videre Elixir", 3, 2, nil, 2, nil},
	{357, 7725, 5, 55, "Again With the Zapped Giants", 3, 2, nil, 2, nil},
	{357, 7726, 5, 55, "Refuel for the Zapping", 3, 2, nil, 2, nil},
	{357, 7494, 1, 57, "Feathermoon Stronghold [Dungeon]", 1, 2, nil, 2, nil},
	{357, 7492, 1, 57, "Camp Mojache [Dungeon]", 2, 2, nil, 2, nil},
	{493, 1124, 1, 55, "Wasteland", 3, 2, nil, 2, nil},
	{493, 1185, 5, 57, "Under the Chitin Was...", 3, 2, nil, 2, nil},
	{493, 6845, 1, 57, "Uncovering Past Secrets", 3, 2, nil, 2, nil},
	{493, 5526, 1, 60, "Shards of the Felvine [Dungeon]", 3, 2, nil, 2, nil},
	{493, 5527, 1, 60, "A Reliquary of Purity", 3, 2, nil, 2, nil},
	{493, 8735, 1, 60, "The Nightmare's Corruption [Raid]", 3, 2, nil, 2, nil},
	{493, 8736, 1, 60, "The Nightmare Manifests [Raid]", 3, 2, nil, 2, nil},
	{493, 8741, 1, 60, "The Champion Returns", 3, 2, nil, 2, nil},
	{215, 5844, 1, 1, "Welcome!", 2, 2, nil, 1, "TODO:RACE"},
	{215, 7662, 2, 1, "New Kodo - Teal", 2, 2, nil, 2, nil},
	{215, 7663, 2, 1, "New Kodo - Green", 2, 2, nil, 2, nil},
	{215, 747, 1, 2, "The Hunt Begins", 2, 2, nil, 2, nil},
	{215, 752, 1, 2, "A Humble Task", 2, 2, nil, 2, nil},
	{215, 750, 1, 3, "The Hunt Continues", 2, 2, nil, 2, nil},
	{215, 753, 1, 3, "A Humble Task", 2, 2, nil, 2, nil},
	{215, 755, 1, 3, "Rites of the Earthmother", 2, 2, nil, 2, nil},
	{215, 757, 1, 4, "Rite of Strength", 2, 2, nil, 2, nil},
	{215, 780, 1, 4, "The Battleboars", 2, 2, nil, 2, nil},
	{215, 781, 1, 4, "Attack on Camp Narache", 2, 2, nil, 2, nil},
	{215, 24857, 1, 4, "Attack on Camp Narache", 2, 2, nil, 2, nil},
	{215, 748, 1, 5, "Poison Water", 2, 2, nil, 1, "TAUREN"},
	{215, 763, 1, 5, "Rites of the Earthmother", 2, 2, nil, 2, nil},
	{215, 1656, 1, 5, "A Task Unfinished", 2, 2, nil, 2, nil},
	{215, 3376, 1, 5, "Break Sharptusk!", 2, 2, nil, 2, nil},
	{215, 745, 1, 6, "Sharing the Land", 2, 2, nil, 2, nil},
	{215, 754, 1, 6, "Winterhoof Cleansing", 2, 2, nil, 1, "TAUREN"},
	{215, 761, 1, 6, "Swoop Hunting", 2, 2, nil, 2, nil},
	{215, 767, 1, 6, "Rite of Vision", 2, 2, nil, 2, nil},
	{215, 14438, 1, 6, "Sharing the Land", 2, 2, nil, 2, nil},
	{215, 756, 1, 7, "Thunderhorn Totem", 2, 2, nil, 1, "TAUREN"},
	{215, 771, 1, 7, "Rite of Vision", 2, 2, nil, 2, nil},
	{215, 772, 1, 7, "Rite of Vision", 2, 2, nil, 2, nil},
	{215, 11129, 1, 7, "Kyle's Gone Missing!", 2, 2, nil, 2, nil},
	{215, 743, 1, 8, "Dangers of the Windfury", 2, 2, nil, 2, nil},
	{215, 746, 1, 8, "Dwarven Digging", 2, 2, nil, 2, nil},
	{215, 749, 1, 8, "The Ravaged Caravan", 2, 2, nil, 2, nil},
	{215, 751, 1, 8, "The Ravaged Caravan", 2, 2, nil, 2, nil},
	{215, 758, 1, 8, "Thunderhorn Cleansing", 2, 2, nil, 1, "TAUREN"},
	{215, 766, 1, 8, "Mazzranache", 2, 2, nil, 2, nil},
	{215, 14436, 1, 8, "Dwarven Digging", 2, 2, nil, 2, nil},
	{215, 759, 1, 10, "Wildmane Totem", 2, 2, nil, 1, "TAUREN"},
	{215, 760, 1, 10, "Wildmane Cleansing", 2, 2, nil, 1, "TAUREN"},
	{215, 764, 1, 10, "The Venture Co.", 2, 2, nil, 2, nil},
	{215, 773, 1, 10, "Rite of Wisdom", 2, 2, nil, 2, nil},
	{215, 775, 1, 10, "Journey into Thunder Bluff", 2, 2, nil, 2, nil},
	{215, 833, 1, 10, "A Sacred Burial", 2, 2, nil, 2, nil},
	{215, 861, 1, 10, "The Hunter's Way", 2, 2, nil, 2, nil},
	{215, 14439, 1, 10, "Journey into Thunder Bluff", 2, 2, nil, 2, nil},
	{215, 765, 1, 12, "Supervisor Fizsprocket", 2, 2, nil, 2, nil},
	{215, 770, 1, 12, "The Demon Scarred Cloak", 2, 2, nil, 2, nil},
	{215, 854, 1, 12, "Journey to the Crossroads", 2, 2, nil, 1, "TAUREN"},
	{215, 776, 1, 14, "Rites of the Earthmother", 2, 2, nil, 2, nil},
	{215, 14440, 1, 14, "Rites of the Earthmother", 2, 2, nil, 2, nil},
	{215, 14087, 1, 20, "Learn to Ride in Mulgore", 2, 2, nil, 1, "TAUREN"},
	{1637, 7926, 1, 0, "The Darkmoon Faire", 2, 2, nil, 2, nil},
	{1637, 7660, 2, 1, "Wolf Swapping - Arctic Wolf", 2, 2, nil, 2, nil},
	{1637, 7661, 2, 1, "Wolf Swapping - Red Wolf", 2, 2, nil, 2, nil},
	{1637, 5726, 1, 12, "Hidden Enemies", 2, 2, nil, 2, nil},
	{1637, 5727, 1, 12, "Hidden Enemies", 2, 2, nil, 2, nil},
	{1637, 5729, 1, 15, "Hidden Enemies", 2, 2, nil, 2, nil},
	{1637, 5730, 1, 16, "Hidden Enemies", 2, 2, nil, 2, nil},
	{1637, 235, 1, 20, "The Ashenvale Hunt", 2, 2, nil, 2, nil},
	{1637, 14086, 1, 20, "Learn to Ride in Orgrimmar", 2, 2, nil, 1, "ORC"},
	{1637, 9626, 1, 21, "Meeting the Warchief", 2, 2, nil, 1, "BLOODELF"},
	{1637, 9813, 1, 21, "Meeting the Warchief", 2, 2, nil, 2, nil},
	{1637, 1431, 1, 30, "Alliance Relations", 2, 2, nil, 2, nil},
	{1637, 1432, 1, 30, "Alliance Relations", 2, 2, nil, 2, nil},
	{1637, 1146, 1, 33, "The Swarm Grows", 2, 2, nil, 2, nil},
	{1637, 1433, 1, 33, "Alliance Relations", 2, 2, nil, 2, nil},
	{1637, 1434, 1, 33, "Befouled by Satyr", 2, 2, nil, 2, nil},
	{1637, 1435, 1, 33, "The Burning of Spirits", 2, 2, nil, 2, nil},
	{1637, 1436, 1, 33, "Alliance Relations", 2, 2, nil, 2, nil},
	{1637, 2950, 1, 35, "Nogg's Ring Redo", 2, 2, nil, 2, nil},
	{1637, 2981, 1, 43, "A Threat in Feralas", 2, 2, nil, 2, nil},
	{1637, 81, 1, 48, "Ripple Delivery", 2, 2, nil, 2, nil},
	{1637, 649, 1, 48, "Ripple Recovery", 2, 2, nil, 2, nil},
	{1637, 650, 1, 48, "Ripple Recovery", 2, 2, nil, 2, nil},
	{1637, 936, 1, 50, "Assisting Arch Druid Runetotem", 2, 2, nil, 2, nil},
	{1637, 5093, 1, 50, "A Call to Arms: The Plaguelands!", 2, 2, nil, 2, nil},
	{1637, 4300, 1, 52, "Bone-Bladed Weapons", 2, 2, nil, 2, nil},
	{1637, 3504, 1, 53, "Betrayed", 2, 2, nil, 2, nil},
	{1637, 3505, 1, 53, "Betrayed", 2, 2, nil, 2, nil},
	{1637, 4494, 1, 53, "March of the Silithid", 2, 2, nil, 2, nil},
	{1637, 4511, 1, 54, "Calm Before the Storm", 2, 2, nil, 2, nil},
	{1637, 1018, 1, 55, "The New Frontier", 2, 2, nil, 2, nil},
	{1637, 8276, 1, 55, "Taking Back Silithus", 2, 2, nil, 2, nil},
	{1637, 3506, 1, 56, "Betrayed", 2, 2, nil, 2, nil},
	{1637, 3507, 1, 56, "Betrayed", 2, 2, nil, 2, nil},
	{1637, 7493, 5, 60, "The Journey Has Just Begun", 4, 2, nil, 2, nil},
	{1637, 4941, 1, 60, "[DEPRECATED] Eitrigg's Wisdom", 2, 2, nil, 2, nil},
	{1637, 6566, 1, 60, "What the Wind Carries", 2, 2, nil, 2, nil},
	{1637, 6567, 1, 60, "The Champion of the Horde", 2, 2, nil, 2, nil},
	{1637, 7341, 2, 60, "A Fair Trade", 2, 2, nil, 2, nil},
	{1637, 7783, 1, 60, "The Lord of Blackrock", 2, 2, nil, 2, nil},
	{1637, 7784, 1, 60, "The Lord of Blackrock", 2, 2, nil, 2, nil},
	{1637, 7824, 5, 60, "A Donation of Runecloth", 2, 2, nil, 2, nil},
	{1637, 7826, 5, 60, "A Donation of Wool", 2, 2, nil, 2, nil},
	{1637, 7827, 5, 60, "A Donation of Silk", 2, 2, nil, 2, nil},
	{1637, 7831, 5, 60, "A Donation of Mageweave", 2, 2, nil, 2, nil},
	{1637, 7832, 2, 60, "Additional Runecloth", 2, 2, nil, 2, nil},
	{1637, 7833, 5, 60, "A Donation of Wool", 2, 2, nil, 2, nil},
	{1637, 7834, 5, 60, "A Donation of Silk", 2, 2, nil, 2, nil},
	{1637, 7835, 5, 60, "A Donation of Mageweave", 2, 2, nil, 2, nil},
	{1637, 7836, 5, 60, "A Donation of Runecloth", 2, 2, nil, 2, nil},
	{1637, 7837, 2, 60, "Additional Runecloth", 2, 2, nil, 2, nil},
	{1637, 8913, 1, 60, "An Earnest Proposition [Dungeon]", 2, 1, "DRUID", 2, nil},
	{1637, 8914, 1, 60, "An Earnest Proposition [Dungeon]", 2, 1, "HUNTER", 2, nil},
	{1637, 8915, 1, 60, "An Earnest Proposition [Dungeon]", 2, 1, "MAGE", 2, nil},
	{1637, 8916, 1, 60, "An Earnest Proposition [Dungeon]", 2, 1, "PRIEST", 2, nil},
	{1637, 8917, 1, 60, "An Earnest Proposition [Dungeon]", 2, 1, "ROGUE", 2, nil},
	{1637, 8918, 1, 60, "An Earnest Proposition [Dungeon]", 2, 1, "SHAMAN", 2, nil},
	{1637, 8919, 1, 60, "An Earnest Proposition [Dungeon]", 2, 1, "WARLOCK", 2, nil},
	{1637, 8920, 1, 60, "An Earnest Proposition [Dungeon]", 2, 1, "WARRIOR", 2, nil},
	{1637, 8927, 1, 60, "Just Compensation [Dungeon]", 2, 1, "DRUID", 2, nil},
	{1637, 8938, 1, 60, "Just Compensation [Dungeon]", 2, 1, "HUNTER", 2, nil},
	{1637, 8939, 1, 60, "Just Compensation [Dungeon]", 2, 1, "MAGE", 2, nil},
	{1637, 8940, 1, 60, "Just Compensation [Dungeon]", 2, 1, "PRIEST", 2, nil},
	{1637, 8941, 1, 60, "Just Compensation [Dungeon]", 2, 1, "ROGUE", 2, nil},
	{1637, 8942, 1, 60, "Just Compensation [Dungeon]", 2, 1, "SHAMAN", 2, nil},
	{1637, 8943, 1, 60, "Just Compensation [Dungeon]", 2, 1, "WARLOCK", 2, nil},
	{1637, 8944, 1, 60, "Just Compensation [Dungeon]", 2, 1, "WARRIOR", 2, nil},
	{1637, 8957, 1, 60, "Anthion's Parting Words [Dungeon]", 2, 1, "SHAMAN", 2, nil},
	{1637, 8978, 1, 60, "Return to Mokvar", 2, 2, nil, 2, nil},
	{1637, 8998, 1, 60, "Back to the Beginning", 2, 2, nil, 2, nil},
	{1637, 9007, 1, 60, "Saving the Best for Last [Dungeon]", 2, 1, "DRUID", 2, nil},
	{1637, 9008, 1, 60, "Saving the Best for Last [Dungeon]", 2, 1, "HUNTER", 2, nil},
	{1637, 9009, 1, 60, "Saving the Best for Last [Dungeon]", 2, 1, "PRIEST", 2, nil},
	{1637, 9010, 1, 60, "Saving the Best for Last [Dungeon]", 2, 1, "ROGUE", 2, nil},
	{1637, 9011, 1, 60, "Saving the Best for Last [Dungeon]", 2, 1, "SHAMAN", 2, nil},
	{1637, 9012, 1, 60, "Saving the Best for Last [Dungeon]", 2, 1, "WARLOCK", 2, nil},
	{1637, 9013, 1, 60, "Saving the Best for Last [Dungeon]", 2, 1, "WARRIOR", 2, nil},
	{1637, 9014, 1, 60, "Saving the Best for Last [Dungeon]", 2, 1, "MAGE", 2, nil},
	{1637, 9016, 1, 60, "Anthion's Parting Words [Dungeon]", 2, 1, "DRUID", 2, nil},
	{1637, 9017, 1, 60, "Anthion's Parting Words [Dungeon]", 2, 1, "HUNTER", 2, nil},
	{1637, 9018, 1, 60, "Anthion's Parting Words [Dungeon]", 2, 1, "MAGE", 2, nil},
	{1637, 9019, 1, 60, "Anthion's Parting Words [Dungeon]", 2, 1, "PRIEST", 2, nil},
	{1637, 9020, 1, 60, "Anthion's Parting Words [Dungeon]", 2, 1, "ROGUE", 2, nil},
	{1637, 9021, 1, 60, "Anthion's Parting Words [Dungeon]", 2, 1, "WARLOCK", 2, nil},
	{1637, 9022, 1, 60, "Anthion's Parting Words [Dungeon]", 2, 1, "WARRIOR", 2, nil},
	{1637, 10493, 1, 60, "An Earnest Proposition [Dungeon]", 2, 1, "PALADIN", 2, nil},
	{1637, 10495, 1, 60, "Just Compensation [Dungeon]", 2, 1, "PALADIN", 2, nil},
	{1637, 10497, 1, 60, "Anthion's Parting Words [Dungeon]", 2, 1, "PALADIN", 2, nil},
	{1637, 10499, 1, 60, "Saving the Best for Last [Dungeon]", 2, 1, "PALADIN", 2, nil},
	{1637, 13266, 1, 74, "A Life Without Regret", 2, 2, nil, 2, nil},
	{1637, 24429, 1, 80, "A Most Puzzling Circumstance", 2, 2, nil, 2, nil},
	{1637, 28790, 1, 80, "A Personal Summons", 2, 2, nil, 2, nil},
	{1637, 28805, 1, 80, "The Eye of the Storm", 2, 2, nil, 2, nil},
	{1377, 1125, 1, 55, "The Spirits of Southwind", 3, 2, nil, 2, nil},
	{1377, 8277, 1, 55, "Deadly Desert Venom", 3, 2, nil, 2, nil},
	{1377, 8280, 1, 55, "Securing the Supply Lines", 3, 2, nil, 2, nil},
	{1377, 1126, 1, 57, "Hive in the Tower", 3, 2, nil, 2, nil},
	{1377, 6844, 1, 57, "Umber, Archivist", 3, 2, nil, 2, nil},
	{1377, 8278, 1, 57, "Noggle's Last Hope", 3, 2, nil, 2, nil},
	{1377, 8281, 1, 57, "Stepping Up Security", 3, 2, nil, 2, nil},
	{1377, 8282, 1, 58, "Noggle's Lost Satchel", 3, 2, nil, 2, nil},
	{1377, 8284, 1, 58, "The Twilight Mystery", 3, 2, nil, 2, nil},
	{1377, 8283, 1, 59, "Wanted - Deathclasp, Terror of the Sands [Group]", 3, 2, nil, 2, nil},
	{1377, 8285, 1, 59, "The Deserter", 3, 2, nil, 2, nil},
	{1377, 8323, 1, 59, "True Believers", 3, 2, nil, 2, nil},
	{1377, 8324, 2, 59, "Still Believing", 3, 2, nil, 2, nil},
	{1377, 8364, 2, 60, "Abyssal Scepters [Raid]", 4, 2, nil, 2, nil},
	{1377, 8496, 1, 60, "Bandages for the Field", 1, 2, nil, 2, nil},
	{1377, 8497, 5, 60, "Desert Survival Kits", 1, 2, nil, 2, nil},
	{1377, 8507, 1, 60, "Field Duty", 1, 2, nil, 2, nil},
	{1377, 8508, 2, 60, "Field Duty Papers", 1, 2, nil, 2, nil},
	{1377, 8540, 5, 60, "Boots for the Guard", 1, 2, nil, 2, nil},
	{1377, 8541, 1, 60, "Grinding Stones for the Guard", 1, 2, nil, 2, nil},
	{1377, 8778, 1, 60, "The Ironforge Brigade Needs Explosives!", 1, 2, nil, 2, nil},
	{1377, 8779, 1, 60, "Scrying Materials", 1, 2, nil, 2, nil},
	{1377, 8780, 1, 60, "Armor Kits for the Field", 1, 2, nil, 2, nil},
	{1377, 8781, 1, 60, "Arms for the Field", 1, 2, nil, 2, nil},
	{1377, 8782, 1, 60, "Uniform Supplies", 1, 2, nil, 2, nil},
	{1377, 8783, 1, 60, "Extraordinary Materials", 1, 2, nil, 2, nil},
	{1377, 9415, 1, 60, "Report to Marshal Bluewall", 1, 2, nil, 2, nil},
	{1377, 9419, 1, 60, "Scouring the Desert [PvP]", 1, 2, nil, 2, nil},
	{1377, 8731, 1, 60, "Field Duty", 2, 2, nil, 2, nil},
	{1377, 8732, 2, 60, "Field Duty Papers", 2, 2, nil, 2, nil},
	{1377, 8785, 5, 60, "The Orgrimmar Legion Needs Mojo!", 2, 2, nil, 2, nil},
	{1377, 8786, 5, 60, "Arms for the Field", 2, 2, nil, 2, nil},
	{1377, 8787, 1, 60, "Armor Kits for the Field", 2, 2, nil, 2, nil},
	{1377, 8805, 1, 60, "Boots for the Guard", 2, 2, nil, 2, nil},
	{1377, 8806, 5, 60, "Grinding Stones for the Guard", 2, 2, nil, 2, nil},
	{1377, 8807, 5, 60, "Scrying Materials", 2, 2, nil, 2, nil},
	{1377, 8808, 5, 60, "Uniform Supplies", 2, 2, nil, 2, nil},
	{1377, 8809, 1, 60, "Extraordinary Materials", 2, 2, nil, 2, nil},
	{1377, 8810, 1, 60, "Bandages for the Field", 2, 2, nil, 2, nil},
	{1377, 8857, 1, 60, "Secrets of the Colossus - Ashi", 2, 2, nil, 2, nil},
	{1377, 8858, 1, 60, "Secrets of the Colossus - Regal", 2, 2, nil, 2, nil},
	{1377, 8859, 1, 60, "Secrets of the Colossus - Zora", 2, 2, nil, 2, nil},
	{1377, 9416, 1, 60, "Report to General Kirika", 2, 2, nil, 2, nil},
	{1377, 9422, 1, 60, "Scouring the Desert [PvP]", 2, 2, nil, 2, nil},
	{1377, 8279, 1, 60, "The Twilight Lexicon", 3, 2, nil, 2, nil},
	{1377, 8286, 1, 60, "What Tomorrow Brings", 3, 2, nil, 2, nil},
	{1377, 8287, 1, 60, "A Terrible Purpose", 3, 2, nil, 2, nil},
	{1377, 8301, 1, 60, "The Path of the Righteous", 3, 2, nil, 2, nil},
	{1377, 8302, 1, 60, "The Hand of the Righteous", 3, 2, nil, 2, nil},
	{1377, 8303, 1, 60, "Anachronos", 3, 2, nil, 2, nil},
	{1377, 8304, 1, 60, "Dearest Natalia", 3, 2, nil, 2, nil},
	{1377, 8305, 1, 60, "Long Forgotten Memories", 3, 2, nil, 2, nil},
	{1377, 8306, 1, 60, "Into The Maw of Madness", 3, 2, nil, 2, nil},
	{1377, 8308, 1, 60, "Brann Bronzebeard's Lost Letter", 3, 2, nil, 2, nil},
	{1377, 8309, 1, 60, "Glyph Chasing", 3, 2, nil, 2, nil},
	{1377, 8310, 1, 60, "Breaking the Code", 3, 2, nil, 2, nil},
	{1377, 8314, 1, 60, "Unraveling the Mystery", 3, 2, nil, 2, nil},
	{1377, 8315, 1, 60, "The Calling [Group]", 3, 2, nil, 2, nil},
	{1377, 8316, 5, 60, "Armaments of War [Raid]", 3, 1, "WARRIOR", 2, nil},
	{1377, 8318, 1, 60, "Secret Communication", 3, 2, nil, 2, nil},
	{1377, 8319, 2, 60, "Encrypted Twilight Texts", 3, 2, nil, 2, nil},
	{1377, 8320, 1, 60, "Twilight Geolords", 3, 2, nil, 2, nil},
	{1377, 8321, 1, 60, "Vyral the Vile", 3, 2, nil, 2, nil},
	{1377, 8331, 1, 60, "Aurel Goldleaf", 3, 2, nil, 2, nil},
	{1377, 8332, 1, 60, "Dukes of the Council", 3, 2, nil, 2, nil},
	{1377, 8333, 2, 60, "Medallion of Station", 3, 2, nil, 2, nil},
	{1377, 8341, 1, 60, "Lords of the Council [Group]", 3, 2, nil, 2, nil},
	{1377, 8342, 2, 60, "Twilight Ring of Lordship", 3, 2, nil, 2, nil},
	{1377, 8343, 1, 60, "Goldleaf's Discovery", 3, 2, nil, 2, nil},
	{1377, 8348, 1, 60, "Signet of the Dukes [Group]", 3, 2, nil, 2, nil},
	{1377, 8349, 1, 60, "Bor Wildmane", 3, 2, nil, 2, nil},
	{1377, 8351, 1, 60, "Bor Wishes to Speak [Raid]", 3, 2, nil, 2, nil},
	{1377, 8352, 1, 60, "Scepter of the Council [Raid]", 3, 2, nil, 2, nil},
	{1377, 8361, 1, 60, "Abyssal Contacts", 3, 2, nil, 2, nil},
	{1377, 8362, 2, 60, "Abyssal Crests", 3, 2, nil, 2, nil},
	{1377, 8363, 2, 60, "Abyssal Signets [Group]", 3, 2, nil, 2, nil},
	{1377, 8376, 5, 60, "Armaments of War [Raid]", 3, 1, "PALADIN", 2, nil},
	{1377, 8377, 5, 60, "Armaments of War [Raid]", 3, 1, "HUNTER", 2, nil},
	{1377, 8378, 5, 60, "Armaments of War [Raid]", 3, 1, "ROGUE", 2, nil},
	{1377, 8379, 5, 60, "Armaments of War [Raid]", 3, 1, "PRIEST", 2, nil},
	{1377, 8380, 5, 60, "Armaments of War [Raid]", 3, 1, "SHAMAN", 2, nil},
	{1377, 8381, 5, 60, "Armaments of War [Raid]", 3, 1, "TODO:CLASS", 2, nil},
	{1377, 8382, 5, 60, "Armaments of War [Raid]", 3, 1, "DRUID", 2, nil},
	{1377, 8498, 1, 60, "Twilight Battle Orders", 3, 2, nil, 2, nil},
	{1377, 8501, 1, 60, "Target: Hive'Ashi Stingers", 3, 2, nil, 2, nil},
	{1377, 8502, 1, 60, "Target: Hive'Ashi Workers", 3, 2, nil, 2, nil},
	{1377, 8519, 1, 60, "A Pawn on the Eternal Board", 3, 2, nil, 2, nil},
	{1377, 8534, 1, 60, "Hive'Zora Scout Report", 3, 2, nil, 2, nil},
	{1377, 8535, 1, 60, "Hoary Templar", 3, 2, nil, 2, nil},
	{1377, 8536, 1, 60, "Earthen Templar", 3, 2, nil, 2, nil},
	{1377, 8537, 1, 60, "Crimson Templar", 3, 2, nil, 2, nil},
	{1377, 8538, 5, 60, "The Four Dukes [Group]", 3, 2, nil, 2, nil},
	{1377, 8539, 1, 60, "Target: Hive'Zora Hive Sisters", 3, 2, nil, 2, nil},
	{1377, 8548, 5, 60, "Volunteer's Battlegear", 3, 2, nil, 2, nil},
	{1377, 8572, 5, 60, "Veteran's Battlegear", 3, 2, nil, 2, nil},
	{1377, 8573, 5, 60, "Champion's Battlegear", 3, 2, nil, 2, nil},
	{1377, 8574, 5, 60, "Stalwart's Battlegear", 3, 2, nil, 2, nil},
	{1377, 8687, 1, 60, "Target: Hive'Zora Tunnelers", 3, 2, nil, 2, nil},
	{1377, 8737, 1, 60, "Azure Templar", 3, 2, nil, 2, nil},
	{1377, 8738, 1, 60, "Hive'Regal Scout Report", 3, 2, nil, 2, nil},
	{1377, 8739, 1, 60, "Hive'Ashi Scout Report", 3, 2, nil, 2, nil},
	{1377, 8740, 1, 60, "Twilight Marauders", 3, 2, nil, 2, nil},
	{1377, 8743, 5, 60, "Bang a Gong!", 3, 2, nil, 2, nil},
	{1377, 8745, 5, 60, "Treasure of the Timeless One", 3, 2, nil, 2, nil},
	{1377, 8770, 1, 60, "Target: Hive'Ashi Defenders", 3, 2, nil, 2, nil},
	{1377, 8771, 1, 60, "Target: Hive'Ashi Sandstalkers", 3, 2, nil, 2, nil},
	{1377, 8772, 1, 60, "Target: Hive'Zora Waywatchers", 3, 2, nil, 2, nil},
	{1377, 8773, 1, 60, "Target: Hive'Zora Reavers", 3, 2, nil, 2, nil},
	{1377, 8774, 1, 60, "Target: Hive'Regal Ambushers", 3, 2, nil, 2, nil},
	{1377, 8775, 1, 60, "Target: Hive'Regal Spitfires", 3, 2, nil, 2, nil},
	{1377, 8776, 1, 60, "Target: Hive'Regal Slavemakers", 3, 2, nil, 2, nil},
	{1377, 8777, 1, 60, "Target: Hive'Regal Burrowers", 3, 2, nil, 2, nil},
	{1377, 8800, 1, 60, "Cenarion Battlegear", 3, 2, nil, 2, nil},
	{1377, 8829, 1, 60, "The Ultimate Deception", 3, 2, nil, 2, nil},
	{1377, 9023, 1, 60, "The Perfect Poison [Raid]", 3, 2, nil, 2, nil},
	{1377, 9248, 1, 60, "A Humble Offering", 3, 2, nil, 2, nil},
	{1377, 9338, 1, 60, "Allegiance to Cenarion Circle", 3, 2, nil, 2, nil},
	{406, 1061, 1, 17, "The Spirits of Stonetalon", 2, 2, nil, 2, nil},
	{406, 1063, 1, 18, "The Elder Crone", 2, 2, nil, 2, nil},
	{406, 6401, 1, 18, "Kaya's Alive", 2, 2, nil, 2, nil},
	{406, 6421, 1, 18, "Boulderslide Ravine", 2, 2, nil, 2, nil},
	{406, 6523, 1, 18, "Protect Kaya", 2, 2, nil, 2, nil},
	{406, 6548, 1, 18, "Avenge My Village", 2, 2, nil, 2, nil},
	{406, 6629, 1, 18, "Kill Grundig Darkcloud", 2, 2, nil, 2, nil},
	{406, 1062, 1, 19, "Goblin Invaders", 2, 2, nil, 2, nil},
	{406, 6461, 1, 19, "Blood Feeders", 2, 2, nil, 2, nil},
	{406, 6542, 1, 19, "Report to Kadrak", 2, 2, nil, 2, nil},
	{406, 6481, 1, 20, "Earthen Arise", 2, 2, nil, 2, nil},
	{406, 1071, 1, 21, "A Gnome's Respite", 1, 2, nil, 2, nil},
	{406, 1072, 1, 21, "An Old Colleague", 1, 2, nil, 2, nil},
	{406, 1073, 1, 21, "Ineptitude + Chemicals = Fun", 1, 2, nil, 2, nil},
	{406, 1074, 1, 21, "Ineptitude + Chemicals = Fun", 1, 2, nil, 2, nil},
	{406, 1075, 1, 21, "A Scroll from Mauren", 1, 2, nil, 2, nil},
	{406, 1076, 1, 21, "Devils in Westfall", 1, 2, nil, 2, nil},
	{406, 1077, 1, 21, "Special Delivery for Gaxim", 1, 2, nil, 2, nil},
	{406, 6284, 1, 21, "Arachnophobia", 2, 2, nil, 2, nil},
	{406, 1093, 1, 21, "Super Reaper 6000", 3, 2, nil, 2, nil},
	{406, 1094, 1, 21, "Further Instructions", 3, 2, nil, 2, nil},
	{406, 1079, 1, 22, "Covert Ops - Alpha", 1, 2, nil, 2, nil},
	{406, 1080, 1, 22, "Covert Ops - Beta", 1, 2, nil, 2, nil},
	{406, 1082, 1, 22, "Update for Sentinel Thenysil", 1, 2, nil, 2, nil},
	{406, 1091, 1, 22, "Kaela's Update", 1, 2, nil, 2, nil},
	{406, 1090, 1, 22, "Gerenzo's Orders", 3, 2, nil, 2, nil},
	{406, 1092, 1, 22, "Gerenzo's Orders", 3, 2, nil, 2, nil},
	{406, 1068, 1, 23, "Shredding Machines", 2, 2, nil, 2, nil},
	{406, 6301, 1, 23, "Cycle of Rebirth", 2, 2, nil, 2, nil},
	{406, 1087, 1, 25, "Cenarius' Legacy", 2, 2, nil, 2, nil},
	{406, 6381, 1, 25, "New Life", 2, 2, nil, 2, nil},
	{406, 6393, 1, 25, "Elemental War", 2, 2, nil, 2, nil},
	{406, 1078, 1, 26, "Retrieval for Mauren", 1, 2, nil, 2, nil},
	{406, 1083, 1, 26, "Enraged Spirits", 1, 2, nil, 2, nil},
	{406, 1058, 1, 26, "Jin'Zil's Forest Magic", 2, 2, nil, 2, nil},
	{406, 6282, 1, 26, "Harpies Threaten", 2, 2, nil, 2, nil},
	{406, 6283, 1, 26, "Bloodfury Bloodline", 2, 2, nil, 2, nil},
	{406, 1057, 1, 27, "Reclaiming the Charred Vale", 1, 2, nil, 2, nil},
	{406, 1059, 1, 27, "Reclaiming the Charred Vale", 1, 2, nil, 2, nil},
	{406, 1095, 1, 27, "Further Instructions", 3, 2, nil, 2, nil},
	{406, 1096, 1, 27, "Gerenzo Wrenchwhistle", 3, 2, nil, 2, nil},
	{406, 1081, 1, 28, "Reception from Tyrande", 1, 2, nil, 2, nil},
	{406, 1084, 1, 28, "Wounded Ancients", 1, 2, nil, 2, nil},
	{406, 5881, 1, 28, "Calling in the Reserves", 2, 2, nil, 2, nil},
	{406, 1088, 1, 29, "Ordanus", 2, 2, nil, 2, nil},
	{406, 1089, 1, 29, "The Den", 2, 2, nil, 2, nil},
	{440, 9268, 2, 0, "War at Sea", 3, 2, nil, 2, nil},
	{440, 1690, 1, 43, "Wastewander Justice", 3, 2, nil, 2, nil},
	{440, 1691, 1, 44, "More Wastewander Justice", 3, 2, nil, 2, nil},
	{440, 1707, 1, 44, "Water Pouch Bounty", 3, 2, nil, 2, nil},
	{440, 1878, 2, 44, "Water Pouch Bounty", 3, 2, nil, 2, nil},
	{440, 3520, 1, 44, "Screecher Spirits", 3, 2, nil, 2, nil},
	{440, 2872, 1, 45, "Stoley's Debt", 3, 2, nil, 2, nil},
	{440, 2873, 1, 45, "Stoley's Shipment", 3, 2, nil, 2, nil},
	{440, 2874, 1, 45, "Deliver to MacKinley", 3, 2, nil, 2, nil},
	{440, 2875, 1, 45, "WANTED: Andre Firebeard", 3, 2, nil, 2, nil},
	{440, 2876, 1, 45, "Ship Schedules", 3, 2, nil, 2, nil},
	{440, 2882, 1, 45, "Cuergo's Gold", 3, 2, nil, 2, nil},
	{440, 8365, 1, 45, "Pirate Hats Ahoy!", 3, 2, nil, 2, nil},
	{440, 8366, 1, 45, "Southsea Shakedown", 3, 2, nil, 2, nil},
	{440, 243, 1, 46, "Into the Field", 2, 2, nil, 2, nil},
	{440, 379, 1, 46, "Slake That Thirst", 2, 2, nil, 2, nil},
	{440, 654, 1, 46, "Tanaris Field Sampling", 2, 2, nil, 2, nil},
	{440, 841, 5, 46, "Another Power Source?", 2, 2, nil, 2, nil},
	{440, 992, 1, 46, "Gadgetzan Water Survey", 3, 2, nil, 2, nil},
	{440, 2781, 1, 46, "WANTED: Caliph Scorpidsting", 3, 2, nil, 2, nil},
	{440, 3022, 1, 47, "Handle With Care", 1, 2, nil, 2, nil},
	{440, 82, 1, 47, "Noxious Lair Investigation", 3, 2, nil, 2, nil},
	{440, 2741, 5, 47, "The Super Egg-O-Matic", 3, 2, nil, 2, nil},
	{440, 8893, 2, 47, "The Super Egg-O-Matic", 3, 2, nil, 2, nil},
	{440, 32, 1, 48, "Rise of the Silithid", 2, 2, nil, 2, nil},
	{440, 10, 1, 48, "The Scrimshank Redemption", 3, 2, nil, 2, nil},
	{440, 110, 1, 48, "Insect Part Analysis", 3, 2, nil, 2, nil},
	{440, 113, 1, 48, "Insect Part Analysis", 3, 2, nil, 2, nil},
	{440, 351, 1, 48, "Find OOX-17/TN!", 3, 2, nil, 2, nil},
	{440, 648, 1, 48, "Rescue OOX-17/TN!", 3, 2, nil, 2, nil},
	{440, 3161, 1, 48, "Gahz'ridian", 3, 2, nil, 2, nil},
	{440, 162, 1, 49, "Rise of the Silithid", 1, 2, nil, 2, nil},
	{440, 2605, 1, 49, "The Thirsty Goblin", 3, 2, nil, 2, nil},
	{440, 2606, 1, 49, "In Good Taste", 3, 2, nil, 2, nil},
	{440, 2641, 1, 49, "Sprinkle's Secret Ingredient", 3, 2, nil, 2, nil},
	{440, 2661, 1, 49, "Delivery for Marin", 3, 2, nil, 2, nil},
	{440, 2662, 1, 49, "Noggenfogger Elixir", 3, 2, nil, 2, nil},
	{440, 5863, 1, 49, "The Dunemaul Compound", 3, 2, nil, 2, nil},
	{440, 1560, 1, 50, "Tooga's Quest", 3, 2, nil, 2, nil},
	{440, 2954, 1, 50, "The Stone Watcher", 3, 2, nil, 2, nil},
	{440, 3362, 1, 50, "Thistleshrub Valley", 3, 2, nil, 2, nil},
	{440, 3444, 1, 51, "The Stone Circle", 3, 2, nil, 2, nil},
	{440, 4496, 1, 53, "Bungle in the Jungle", 3, 2, nil, 2, nil},
	{440, 4508, 1, 54, "Calm Before the Storm", 1, 2, nil, 2, nil},
	{440, 4509, 1, 54, "Calm Before the Storm", 2, 2, nil, 2, nil},
	{440, 4504, 1, 54, "Super Sticky", 3, 2, nil, 2, nil},
	{440, 4507, 1, 54, "Pawn Captures Queen", 3, 2, nil, 2, nil},
	{440, 5801, 1, 57, "Fire Plume Forged", 1, 2, nil, 2, nil},
	{440, 5802, 1, 57, "Fire Plume Forged", 2, 2, nil, 2, nil},
	{440, 8181, 1, 58, "Confront Yeh'kinya [Raid]", 3, 2, nil, 2, nil},
	{440, 8182, 1, 58, "The Hand of Rastakhan [Raid]", 3, 2, nil, 2, nil},
	{440, 8555, 5, 60, "The Charge of the Dragonflights", 4, 2, nil, 2, nil},
	{440, 8764, 2, 60, "The Changing of Paths - Protector No More", 4, 2, nil, 2, nil},
	{440, 8922, 1, 60, "A Supernatural Device", 1, 2, nil, 2, nil},
	{440, 8923, 1, 60, "A Supernatural Device", 2, 2, nil, 2, nil},
	{440, 2747, 2, 60, "An Extraordinary Egg", 3, 2, nil, 2, nil},
	{440, 2748, 2, 60, "A Fine Egg", 3, 2, nil, 2, nil},
	{440, 2749, 2, 60, "An Ordinary Egg", 3, 2, nil, 2, nil},
	{440, 2750, 2, 60, "A Bad Egg", 3, 2, nil, 2, nil},
	{440, 8576, 5, 60, "Translating the Ledger", 3, 2, nil, 2, nil},
	{440, 8577, 1, 60, "Stewvul, Ex-B.F.F.", 3, 2, nil, 2, nil},
	{440, 8584, 1, 60, "Never Ask Me About My Business", 3, 2, nil, 2, nil},
	{440, 8585, 1, 60, "The Isle of Dread! [Raid]", 3, 2, nil, 2, nil},
	{440, 8586, 1, 60, "Dirge's Kickin' Chimaerok Chops", 3, 2, nil, 2, nil},
	{440, 8587, 1, 60, "Return to Narain", 3, 2, nil, 2, nil},
	{440, 8597, 1, 60, "Draconic for Dummies", 3, 2, nil, 2, nil},
	{440, 8598, 1, 60, "rAnS0m", 3, 2, nil, 2, nil},
	{440, 8599, 1, 60, "Love Song for Narain", 3, 2, nil, 2, nil},
	{440, 8606, 1, 60, "Decoy! [Group]", 3, 2, nil, 2, nil},
	{440, 8620, 1, 60, "The Only Prescription [Raid]", 3, 2, nil, 2, nil},
	{440, 8728, 1, 60, "The Good News and The Bad News", 3, 2, nil, 2, nil},
	{440, 8742, 5, 60, "The Might of Kalimdor", 3, 2, nil, 2, nil},
	{440, 8747, 5, 60, "The Path of the Protector", 3, 2, nil, 2, nil},
	{440, 8748, 5, 60, "The Path of the Protector", 3, 2, nil, 2, nil},
	{440, 8749, 5, 60, "The Path of the Protector", 3, 2, nil, 2, nil},
	{440, 8750, 5, 60, "The Path of the Protector", 3, 2, nil, 2, nil},
	{440, 8751, 5, 60, "The Protector of Kalimdor", 3, 2, nil, 2, nil},
	{440, 8752, 5, 60, "The Path of the Conqueror", 3, 2, nil, 2, nil},
	{440, 8753, 5, 60, "The Path of the Conqueror", 3, 2, nil, 2, nil},
	{440, 8754, 5, 60, "The Path of the Conqueror", 3, 2, nil, 2, nil},
	{440, 8755, 5, 60, "The Path of the Conqueror", 3, 2, nil, 2, nil},
	{440, 8756, 5, 60, "The Qiraji Conqueror", 3, 2, nil, 2, nil},
	{440, 8757, 5, 60, "The Path of the Invoker", 3, 2, nil, 2, nil},
	{440, 8758, 5, 60, "The Path of the Invoker", 3, 2, nil, 2, nil},
	{440, 8759, 5, 60, "The Path of the Invoker", 3, 2, nil, 2, nil},
	{440, 8760, 5, 60, "The Path of the Invoker", 3, 2, nil, 2, nil},
	{440, 8761, 5, 60, "The Grand Invoker", 3, 2, nil, 2, nil},
	{440, 8765, 2, 60, "The Changing of Paths - Invoker No More", 3, 2, nil, 2, nil},
	{440, 8766, 2, 60, "The Changing of Paths - Conqueror No More", 3, 2, nil, 2, nil},
	{440, 8921, 1, 60, "The Ectoplasmic Distiller", 3, 2, nil, 2, nil},
	{440, 8924, 1, 60, "Hunting for Ectoplasm", 3, 2, nil, 2, nil},
	{440, 8925, 1, 60, "A Portable Power Source", 3, 2, nil, 2, nil},
	{440, 8928, 1, 60, "A Shifty Merchant [Group]", 3, 2, nil, 2, nil},
	{141, 458, 1, 1, "The Woodland Protector", 1, 2, nil, 2, nil},
	{141, 5842, 1, 1, "Welcome!", 1, 2, nil, 1, "NIGHTELF"},
	{141, 456, 1, 2, "The Balance of Nature", 1, 2, nil, 2, nil},
	{141, 457, 1, 3, "The Balance of Nature", 1, 2, nil, 2, nil},
	{141, 459, 1, 3, "The Woodland Protector", 1, 2, nil, 2, nil},
	{141, 916, 1, 4, "Webwood Venom", 1, 2, nil, 2, nil},
	{141, 3519, 1, 4, "A Friend in Need", 1, 2, nil, 2, nil},
	{141, 3521, 1, 4, "Iverron's Antidote", 1, 2, nil, 2, nil},
	{141, 3522, 1, 4, "Iverron's Antidote", 1, 2, nil, 2, nil},
	{141, 4495, 1, 4, "A Good Friend", 1, 2, nil, 2, nil},
	{141, 488, 1, 5, "Zenn's Bidding", 1, 2, nil, 2, nil},
	{141, 917, 1, 5, "Webwood Egg", 1, 2, nil, 2, nil},
	{141, 920, 1, 5, "Tenaron's Summons", 1, 2, nil, 2, nil},
	{141, 921, 1, 5, "Crown of the Earth", 1, 2, nil, 2, nil},
	{141, 928, 1, 5, "Crown of the Earth", 1, 2, nil, 2, nil},
	{141, 929, 1, 5, "Crown of the Earth", 1, 2, nil, 2, nil},
	{141, 997, 1, 5, "Denalan's Earth", 1, 2, nil, 2, nil},
	{141, 2159, 1, 5, "Dolanaar Delivery", 1, 2, nil, 2, nil},
	{141, 475, 1, 6, "A Troubling Breeze", 1, 2, nil, 2, nil},
	{141, 476, 1, 6, "Gnarlpine Corruption", 1, 2, nil, 2, nil},
	{141, 2438, 1, 6, "The Emerald Dreamcatcher", 1, 2, nil, 2, nil},
	{141, 489, 1, 7, "Seek Redemption!", 1, 2, nil, 2, nil},
	{141, 918, 1, 7, "Timberling Seeds", 1, 2, nil, 2, nil},
	{141, 919, 1, 7, "Timberling Sprouts", 1, 2, nil, 2, nil},
	{141, 922, 1, 7, "Rellian Greenspyre", 1, 2, nil, 2, nil},
	{141, 932, 1, 7, "Twisted Hatred", 1, 2, nil, 2, nil},
	{141, 487, 1, 8, "The Road to Darnassus", 1, 2, nil, 2, nil},
	{141, 2459, 1, 8, "Ferocitas the Dream Eater", 1, 2, nil, 2, nil},
	{141, 2541, 1, 8, "The Sleeping Druid", 1, 2, nil, 2, nil},
	{141, 483, 1, 9, "The Relics of Wakening", 1, 2, nil, 2, nil},
	{141, 923, 1, 9, "Tumors", 1, 2, nil, 2, nil},
	{141, 933, 1, 9, "Crown of the Earth", 1, 2, nil, 2, nil},
	{141, 2498, 1, 9, "Return to Denalan", 1, 2, nil, 2, nil},
	{141, 2499, 1, 9, "Oakenscowl", 1, 2, nil, 2, nil},
	{141, 930, 1, 10, "The Glowing Fruit", 1, 2, nil, 2, nil},
	{141, 931, 1, 10, "The Shimmering Frond", 1, 2, nil, 2, nil},
	{141, 2399, 5, 10, "The Sprouted Fronds", 1, 2, nil, 2, nil},
	{141, 2561, 1, 10, "Druid of the Claw", 1, 2, nil, 2, nil},
	{141, 935, 1, 11, "Crown of the Earth", 1, 2, nil, 2, nil},
	{141, 937, 1, 11, "The Enchanted Glade", 1, 2, nil, 2, nil},
	{141, 940, 1, 11, "Teldrassil", 1, 2, nil, 2, nil},
	{141, 7383, 1, 11, "Crown of the Earth", 1, 2, nil, 2, nil},
	{141, 486, 1, 12, "Ursal the Mauler", 1, 2, nil, 2, nil},
	{141, 927, 1, 12, "The Moss-twined Heart", 1, 2, nil, 2, nil},
	{141, 938, 1, 12, "Mist", 1, 2, nil, 2, nil},
	{141, 941, 1, 12, "Planting the Heart", 1, 2, nil, 2, nil},
	{141, 8734, 1, 60, "Tyrande and Remulos", 3, 2, nil, 2, nil},
	{17, 9267, 2, 0, "Mending Old Wounds", 3, 2, nil, 2, nil},
	{17, 860, 1, 10, "Sergra Darkthorn", 2, 2, nil, 2, nil},
	{17, 886, 1, 10, "The Barrens Oases", 2, 2, nil, 2, nil},
	{17, 6361, 1, 10, "A Bundle of Hides", 2, 2, nil, 1, "TAUREN"},
	{17, 6362, 1, 10, "Ride to Thunder Bluff", 2, 2, nil, 1, "TAUREN"},
	{17, 6363, 1, 10, "Tal the Wind Rider Master", 2, 2, nil, 1, "TAUREN"},
	{17, 6364, 1, 10, "Return to Jahan", 2, 2, nil, 1, "TAUREN"},
	{17, 6365, 1, 10, "Meats to Orgrimmar", 2, 2, nil, 1, "TODO:RACE"},
	{17, 6384, 1, 10, "Ride to Orgrimmar", 2, 2, nil, 1, "TODO:RACE"},
	{17, 6385, 1, 10, "Doras the Wind Rider Master", 2, 2, nil, 1, "TODO:RACE"},
	{17, 6386, 1, 10, "Return to the Crossroads.", 2, 2, nil, 1, "TODO:RACE"},
	{17, 1492, 1, 11, "Wharfmaster Dizzywig", 2, 2, nil, 2, nil},
	{17, 844, 1, 12, "Plainstrider Menace", 2, 2, nil, 2, nil},
	{17, 871, 1, 12, "Disrupt the Attacks", 2, 2, nil, 2, nil},
	{17, 845, 1, 13, "The Zhevra", 2, 2, nil, 2, nil},
	{17, 869, 1, 13, "Raptor Thieves", 2, 2, nil, 2, nil},
	{17, 870, 1, 13, "The Forgotten Pools", 2, 2, nil, 2, nil},
	{17, 855, 1, 14, "Centaur Bracers", 2, 2, nil, 2, nil},
	{17, 3921, 1, 14, "Wenikee Boltbucket", 2, 2, nil, 2, nil},
	{17, 5041, 1, 14, "Supplies for the Crossroads", 2, 2, nil, 2, nil},
	{17, 887, 1, 14, "Southsea Freebooters", 3, 2, nil, 2, nil},
	{17, 890, 1, 14, "The Missing Shipment", 3, 2, nil, 2, nil},
	{17, 892, 1, 14, "The Missing Shipment", 3, 2, nil, 2, nil},
	{17, 894, 1, 14, "Samophlange", 3, 2, nil, 2, nil},
	{17, 900, 1, 14, "Samophlange", 3, 2, nil, 2, nil},
	{17, 901, 1, 14, "Samophlange", 3, 2, nil, 2, nil},
	{17, 819, 1, 15, "Chen's Empty Keg", 2, 2, nil, 2, nil},
	{17, 821, 1, 15, "Chen's Empty Keg", 2, 2, nil, 2, nil},
	{17, 848, 1, 15, "Fungal Spores", 2, 2, nil, 2, nil},
	{17, 853, 1, 15, "Apothecary Zamah", 2, 2, nil, 2, nil},
	{17, 867, 1, 15, "Harpy Raiders", 2, 2, nil, 2, nil},
	{17, 872, 1, 15, "The Disruption Ends", 2, 2, nil, 2, nil},
	{17, 903, 1, 15, "Prowlers of the Barrens", 2, 2, nil, 2, nil},
	{17, 3301, 1, 15, "Mura Runetotem", 2, 2, nil, 2, nil},
	{17, 3922, 1, 15, "Nugget Slugs", 2, 2, nil, 2, nil},
	{17, 850, 1, 16, "Kolkar Leaders", 2, 2, nil, 2, nil},
	{17, 875, 1, 16, "Harpy Lieutenants", 2, 2, nil, 2, nil},
	{17, 877, 1, 16, "The Stagnant Oasis", 2, 2, nil, 2, nil},
	{17, 880, 1, 16, "Altered Beings", 2, 2, nil, 2, nil},
	{17, 881, 1, 16, "Echeyakee", 2, 2, nil, 2, nil},
	{17, 888, 1, 16, "Stolen Booty", 3, 2, nil, 2, nil},
	{17, 895, 1, 16, "WANTED: Baron Longshore", 3, 2, nil, 2, nil},
	{17, 902, 1, 16, "Samophlange", 3, 2, nil, 2, nil},
	{17, 905, 1, 17, "The Angry Scytheclaws", 2, 2, nil, 2, nil},
	{17, 851, 1, 18, "Verog the Dervish", 2, 2, nil, 2, nil},
	{17, 907, 1, 18, "Enraged Thunder Lizards", 2, 2, nil, 2, nil},
	{17, 3261, 1, 18, "Jorn Skyseer", 2, 2, nil, 2, nil},
	{17, 3281, 1, 18, "Stolen Silver", 2, 2, nil, 2, nil},
	{17, 3923, 1, 18, "Rilli Greasygob", 2, 2, nil, 2, nil},
	{17, 858, 1, 18, "Ignition", 3, 2, nil, 2, nil},
	{17, 863, 1, 18, "The Escape", 3, 2, nil, 2, nil},
	{17, 865, 1, 18, "Raptor Horns", 3, 2, nil, 2, nil},
	{17, 896, 1, 18, "Miner's Fortune", 3, 2, nil, 2, nil},
	{17, 852, 1, 19, "Hezrul Bloodmark", 2, 2, nil, 2, nil},
	{17, 882, 1, 19, "Ishamuhale", 2, 2, nil, 2, nil},
	{17, 3924, 1, 19, "Samophlange Manual", 2, 2, nil, 2, nil},
	{17, 6541, 1, 19, "Report to Kadrak", 2, 2, nil, 2, nil},
	{17, 876, 1, 20, "Serena Bloodfeather", 2, 2, nil, 2, nil},
	{17, 889, 2, 20, "Spirit of the Wind", 2, 2, nil, 2, nil},
	{17, 891, 1, 20, "The Guns of Northwatch", 2, 2, nil, 2, nil},
	{17, 898, 1, 20, "Free From the Hold", 2, 2, nil, 2, nil},
	{17, 899, 1, 20, "Consumed by Hatred", 2, 2, nil, 2, nil},
	{17, 913, 1, 20, "Cry of the Thunderhawk", 2, 2, nil, 2, nil},
	{17, 1060, 1, 20, "Letter to Jin'Zil", 2, 2, nil, 2, nil},
	{17, 4021, 1, 20, "Counterattack! [Group]", 2, 2, nil, 2, nil},
	{17, 4921, 1, 20, "Lost in Battle", 2, 2, nil, 2, nil},
	{17, 5042, 2, 20, "Agamaggan's Strength", 2, 2, nil, 2, nil},
	{17, 5043, 2, 20, "Agamaggan's Agility", 2, 2, nil, 2, nil},
	{17, 5044, 2, 20, "Wisdom of Agamaggan", 2, 2, nil, 2, nil},
	{17, 5045, 2, 20, "Rising Spirit", 2, 2, nil, 2, nil},
	{17, 5046, 2, 20, "Razorhide", 2, 2, nil, 2, nil},
	{17, 6382, 1, 20, "The Ashenvale Hunt", 2, 2, nil, 2, nil},
	{17, 1069, 1, 20, "Deepmoss Spider Eggs", 3, 2, nil, 2, nil},
	{17, 878, 1, 21, "Tribes at War", 2, 2, nil, 2, nil},
	{17, 5052, 1, 21, "Blood Shards of Agamaggan", 2, 2, nil, 2, nil},
	{17, 1483, 1, 21, "Ziz Fizziks", 3, 2, nil, 2, nil},
	{17, 868, 1, 22, "Egg Hunt", 2, 2, nil, 2, nil},
	{17, 883, 1, 22, "Lakota'mani", 2, 2, nil, 2, nil},
	{17, 843, 1, 23, "Gann's Reclamation", 2, 2, nil, 2, nil},
	{17, 822, 5, 24, "Chen's Empty Keg", 2, 2, nil, 2, nil},
	{17, 884, 1, 24, "Owatanka", 2, 2, nil, 2, nil},
	{17, 893, 1, 24, "Weapons of Choice", 2, 2, nil, 2, nil},
	{17, 897, 1, 24, "The Harvester", 2, 2, nil, 2, nil},
	{17, 3370, 1, 25, "In Nightmares", 1, 2, nil, 2, nil},
	{17, 879, 1, 25, "Betrayal from Within", 2, 2, nil, 2, nil},
	{17, 885, 1, 25, "Washte Pawne", 2, 2, nil, 2, nil},
	{17, 906, 1, 25, "Betrayal from Within", 2, 2, nil, 2, nil},
	{17, 3369, 1, 25, "In Nightmares", 2, 2, nil, 2, nil},
	{17, 3513, 1, 25, "The Runed Scroll", 2, 2, nil, 2, nil},
	{17, 846, 1, 26, "Revenge of Gann", 2, 2, nil, 2, nil},
	{17, 849, 1, 26, "Revenge of Gann", 2, 2, nil, 2, nil},
	{17, 873, 1, 27, "Isha Awak", 2, 2, nil, 2, nil},
	{17, 874, 1, 27, "Mahren Skyseer", 2, 2, nil, 2, nil},
	{17, 1153, 1, 29, "A New Ore Sample", 2, 2, nil, 2, nil},
	{17, 3514, 1, 29, "Horde Presence", 2, 2, nil, 2, nil},
	{17, 857, 1, 30, "The Tear of the Moons", 2, 2, nil, 2, nil},
	{17, 1145, 1, 33, "The Swarm Grows", 2, 2, nil, 2, nil},
	{3557, 10373, 1, 50, "A Call to Arms: The Plaguelands!", 1, 2, nil, 2, nil},
	{3557, 10520, 1, 50, "Assisting Arch Druid Staghelm", 1, 2, nil, 2, nil},
	{3557, 7792, 5, 60, "A Donation of Wool", 1, 2, nil, 2, nil},
	{3557, 7798, 5, 60, "A Donation of Silk", 1, 2, nil, 2, nil},
	{3557, 10356, 5, 60, "A Donation of Mageweave", 1, 2, nil, 2, nil},
	{3557, 10357, 5, 60, "A Donation of Runecloth", 1, 2, nil, 2, nil},
	{3557, 10358, 1, 60, "Additional Runecloth", 1, 2, nil, 2, nil},
	{400, 4542, 1, 25, "Message to Freewind Post", 2, 2, nil, 2, nil},
	{400, 4841, 1, 25, "Pacify the Centaur", 2, 2, nil, 2, nil},
	{400, 1149, 1, 26, "Test of Faith", 2, 2, nil, 2, nil},
	{400, 4821, 1, 26, "Alien Egg", 2, 2, nil, 2, nil},
	{400, 4865, 1, 26, "Serpent Wild", 2, 2, nil, 2, nil},
	{400, 1100, 1, 27, "Lonebrow's Journal", 1, 2, nil, 2, nil},
	{400, 5062, 1, 27, "Sacred Fire", 2, 2, nil, 2, nil},
	{400, 4881, 1, 28, "Assassination Plot", 2, 2, nil, 2, nil},
	{400, 4966, 1, 28, "Protect Kanati Greycloud", 2, 2, nil, 2, nil},
	{400, 5064, 1, 28, "Grimtotem Spying", 2, 2, nil, 2, nil},
	{400, 5088, 1, 28, "Arikara", 2, 2, nil, 2, nil},
	{400, 9431, 1, 28, "A Different Approach", 2, 2, nil, 2, nil},
	{400, 9433, 1, 28, "A Dip in the Moonwell", 2, 2, nil, 2, nil},
	{400, 9434, 1, 28, "Testing the Tonic", 2, 2, nil, 2, nil},
	{400, 4767, 1, 29, "Wind Rider", 2, 2, nil, 2, nil},
	{400, 4770, 1, 29, "Homeward Bound", 2, 2, nil, 2, nil},
	{400, 4904, 1, 29, "Free at Last", 2, 2, nil, 2, nil},
	{400, 5147, 1, 29, "Wanted - Arnak Grimtotem", 2, 2, nil, 2, nil},
	{400, 1179, 1, 30, "The Brassbolts Brothers", 1, 2, nil, 2, nil},
	{400, 1150, 1, 30, "Test of Endurance", 2, 2, nil, 2, nil},
	{400, 1151, 1, 30, "Test of Strength", 2, 2, nil, 2, nil},
	{400, 1152, 1, 30, "Test of Lore", 2, 2, nil, 2, nil},
	{400, 1154, 1, 30, "Test of Lore", 2, 2, nil, 2, nil},
	{400, 1159, 1, 30, "Test of Lore", 2, 2, nil, 2, nil},
	{400, 5151, 1, 30, "Hypercapacitor Gizmo [Group]", 2, 2, nil, 2, nil},
	{400, 6627, 1, 30, "Test of Lore", 2, 2, nil, 2, nil},
	{400, 6628, 1, 30, "Test of Lore", 2, 2, nil, 2, nil},
	{400, 1104, 1, 30, "Salt Flat Venom", 3, 2, nil, 2, nil},
	{400, 1105, 1, 30, "Hardened Shells", 3, 2, nil, 2, nil},
	{400, 1176, 1, 30, "Load Lightening", 3, 2, nil, 2, nil},
	{400, 1110, 1, 31, "Rocket Car Parts", 3, 2, nil, 2, nil},
	{400, 5762, 1, 31, "Hemet Nesingwary Jr.", 3, 2, nil, 2, nil},
	{400, 1175, 1, 33, "A Bump in the Road", 3, 2, nil, 2, nil},
	{400, 1147, 1, 35, "The Swarm Grows", 2, 2, nil, 2, nil},
	{400, 1148, 1, 35, "Parts of the Swarm", 2, 2, nil, 2, nil},
	{400, 1184, 1, 35, "Parts of the Swarm", 2, 2, nil, 2, nil},
	{400, 5361, 1, 35, "Family Tree", 2, 2, nil, 2, nil},
	{400, 1106, 1, 35, "Martek the Exiled", 3, 2, nil, 2, nil},
	{400, 1107, 1, 35, "Encrusted Tail Fins", 3, 2, nil, 2, nil},
	{400, 1394, 1, 36, "Final Passage", 2, 2, nil, 2, nil},
	{400, 1111, 1, 36, "Wharfmaster Dizzywig", 3, 2, nil, 2, nil},
	{400, 1112, 1, 36, "Parts for Kravel", 3, 2, nil, 2, nil},
	{400, 1114, 1, 36, "Delivery to the Gnomes", 3, 2, nil, 2, nil},
	{400, 1115, 1, 36, "The Rumormonger", 3, 2, nil, 2, nil},
	{400, 1117, 1, 36, "Rumors for Kravel", 3, 2, nil, 2, nil},
	{400, 1178, 1, 37, "Goblin Sponsorship", 3, 2, nil, 2, nil},
	{400, 1180, 1, 37, "Goblin Sponsorship", 3, 2, nil, 2, nil},
	{400, 1181, 1, 37, "Goblin Sponsorship", 3, 2, nil, 2, nil},
	{400, 1182, 1, 37, "Goblin Sponsorship", 3, 2, nil, 2, nil},
	{400, 1183, 1, 37, "Goblin Sponsorship", 3, 2, nil, 2, nil},
	{400, 1186, 1, 37, "The Eighteenth Pilot", 3, 2, nil, 2, nil},
	{400, 1137, 1, 38, "News for Fizzle", 3, 2, nil, 2, nil},
	{400, 1108, 1, 39, "Indurium", 3, 2, nil, 2, nil},
	{400, 1187, 1, 41, "Razzeric's Tweaking", 3, 2, nil, 2, nil},
	{400, 1188, 1, 41, "Safety First", 3, 2, nil, 2, nil},
	{400, 1189, 1, 41, "Safety First", 3, 2, nil, 2, nil},
	{400, 1190, 1, 41, "Keeping Pace", 3, 2, nil, 2, nil},
	{400, 1191, 5, 41, "Zamek's Distraction", 3, 2, nil, 2, nil},
	{400, 1194, 1, 41, "Rizzle's Schematics", 3, 2, nil, 2, nil},
	{400, 1192, 2, 42, "Indurium Ore", 3, 2, nil, 2, nil},
	{400, 1118, 1, 43, "Back to Booty Bay", 3, 2, nil, 2, nil},
	{400, 1119, 1, 44, "Zanzil's Mixture and a Fool's Stout", 3, 2, nil, 2, nil},
	{400, 1120, 1, 44, "Get the Gnomes Drunk", 3, 2, nil, 2, nil},
	{400, 1121, 1, 44, "Get the Goblins Drunk", 3, 2, nil, 2, nil},
	{400, 1122, 1, 44, "Report Back to Fizzlebub", 3, 2, nil, 2, nil},
	{400, 2769, 1, 46, "The Brassbolts Brothers [Dungeon]", 1, 2, nil, 2, nil},
	{1638, 768, 1, 8, "Gathering Leather", 2, 2, nil, 2, nil},
	{1638, 769, 1, 10, "Kodo Hide Bag", 2, 2, nil, 2, nil},
	{1638, 744, 1, 11, "Preparation for Ceremony", 2, 2, nil, 2, nil},
	{1638, 264, 1, 15, "Until Death Do Us Part", 2, 2, nil, 2, nil},
	{1638, 1064, 1, 18, "Forsaken Aid", 2, 2, nil, 2, nil},
	{1638, 1065, 1, 18, "Journey to Tarren Mill", 2, 2, nil, 2, nil},
	{1638, 742, 1, 20, "The Ashenvale Hunt", 2, 2, nil, 2, nil},
	{1638, 1066, 1, 23, "Blood of Innocents", 2, 2, nil, 2, nil},
	{1638, 1067, 1, 23, "Return to Thunder Bluff", 2, 2, nil, 2, nil},
	{1638, 1086, 1, 23, "The Flying Machine Airport", 2, 2, nil, 2, nil},
	{1638, 1195, 1, 25, "The Sacred Flame", 2, 2, nil, 2, nil},
	{1638, 1196, 1, 29, "The Sacred Flame", 2, 2, nil, 2, nil},
	{1638, 1197, 1, 29, "The Sacred Flame", 2, 2, nil, 2, nil},
	{1638, 1130, 1, 30, "Melor Sends Word", 2, 2, nil, 2, nil},
	{1638, 1131, 1, 30, "Steelsnap", 2, 2, nil, 2, nil},
	{1638, 1136, 1, 37, "Frostmaw", 2, 2, nil, 2, nil},
	{1638, 2440, 1, 47, "The Platinum Discs", 2, 2, nil, 2, nil},
	{1638, 2965, 1, 50, "Portents of Uldum", 2, 2, nil, 2, nil},
	{1638, 2966, 1, 50, "Seeing What Happens [Group]", 2, 2, nil, 2, nil},
	{1638, 2967, 1, 50, "Return to Thunder Bluff", 2, 2, nil, 2, nil},
	{1638, 2968, 1, 50, "A Future Task", 2, 2, nil, 2, nil},
	{1638, 3761, 1, 50, "Un'Goro Soil", 2, 2, nil, 2, nil},
	{1638, 3762, 1, 50, "Assisting Arch Druid Runetotem", 2, 2, nil, 2, nil},
	{1638, 3782, 1, 50, "Morrowgrain Research", 2, 2, nil, 2, nil},
	{1638, 3786, 1, 50, "Morrowgrain Research", 2, 2, nil, 2, nil},
	{1638, 5095, 1, 50, "A Call to Arms: The Plaguelands!", 2, 2, nil, 2, nil},
	{1638, 1000, 1, 55, "The New Frontier", 2, 2, nil, 2, nil},
	{1638, 1123, 1, 55, "Rabine Saturna", 2, 2, nil, 2, nil},
	{1638, 3804, 2, 55, "Morrowgrain to Thunder Bluff", 2, 2, nil, 2, nil},
	{1638, 7820, 5, 60, "A Donation of Wool", 2, 2, nil, 2, nil},
	{1638, 7821, 5, 60, "A Donation of Silk", 2, 2, nil, 2, nil},
	{1638, 7822, 5, 60, "A Donation of Mageweave", 2, 2, nil, 2, nil},
	{1638, 7823, 5, 60, "A Donation of Runecloth", 2, 2, nil, 2, nil},
	{1638, 7825, 2, 60, "Additional Runecloth", 2, 2, nil, 2, nil},
	{1638, 13986, 1, 73, "An Injured Colleague", 2, 2, nil, 2, nil},
	{1216, 6031, 1, 55, "Runecloth", 3, 2, nil, 2, nil},
	{1216, 8461, 1, 55, "Deadwood of the North", 3, 2, nil, 2, nil},
	{1216, 8464, 1, 58, "Winterfall Activity", 3, 2, nil, 2, nil},
	{1216, 8484, 1, 60, "The Brokering of Peace", 1, 2, nil, 2, nil},
	{1216, 8485, 1, 60, "The Brokering of Peace", 2, 2, nil, 2, nil},
	{1216, 8481, 1, 60, "The Root of All Evil [Group]", 3, 2, nil, 2, nil},
	{989, 28255, 1, 83, "Vhat's Next?", 4, 2, nil, 2, nil},
	{989, 28654, 1, 83, "The Heart of the Matter [Dungeon]", 4, 2, nil, 2, nil},
	{989, 28844, 1, 83, "Hyena Harvest", 2, 2, nil, 2, nil},
	{989, 28240, 1, 83, "Tapped Out", 3, 2, nil, 2, nil},
	{989, 28250, 3, 83, "Thieving Little Pluckers", 3, 2, nil, 2, nil},
	{989, 28267, 1, 83, "Firing Squad", 3, 2, nil, 2, nil},
	{989, 28269, 1, 83, "Meet Me In Ramkahen", 3, 2, nil, 2, nil},
	{989, 28270, 1, 83, "Riding Shotgun!", 3, 2, nil, 2, nil},
	{989, 28350, 1, 83, "Bait Master", 3, 2, nil, 2, nil},
	{989, 28351, 1, 83, "Unlimited Potential", 3, 2, nil, 2, nil},
	{989, 28352, 1, 83, "Camel Tow", 3, 2, nil, 2, nil},
	{989, 28402, 1, 83, "Schnottz So Fast", 3, 2, nil, 2, nil},
	{490, 3884, 1, 50, "Williden's Journal", 3, 2, nil, 2, nil},
	{490, 3882, 1, 51, "Roll the Bones", 3, 2, nil, 2, nil},
	{490, 4503, 1, 51, "Shizzle's Flyer", 3, 2, nil, 2, nil},
	{490, 4141, 4, 52, "Muigin and Larion [Removed]", 1, 2, nil, 2, nil},
	{490, 4142, 1, 52, "A Visit to Gregan", 1, 2, nil, 2, nil},
	{490, 4143, 1, 52, "Haze of Evil [Dungeon]", 1, 2, nil, 2, nil},
	{490, 4145, 1, 52, "Larion and Muigin", 2, 2, nil, 2, nil},
	{490, 4147, 1, 52, "Marvon's Workshop", 2, 2, nil, 2, nil},
	{490, 3844, 1, 52, "It's a Secret to Everybody", 3, 2, nil, 2, nil},
	{490, 3845, 1, 52, "It's a Secret to Everybody", 3, 2, nil, 2, nil},
	{490, 3883, 1, 52, "Alien Ecology", 3, 2, nil, 2, nil},
	{490, 3908, 1, 52, "It's a Secret to Everybody", 3, 2, nil, 2, nil},
	{490, 3909, 1, 52, "The Videre Elixir", 3, 2, nil, 2, nil},
	{490, 3912, 1, 52, "Meet at the Grave", 3, 2, nil, 2, nil},
	{490, 3913, 1, 52, "A Grave Situation", 3, 2, nil, 2, nil},
	{490, 3914, 1, 52, "Linken's Sword", 3, 2, nil, 2, nil},
	{490, 3941, 1, 52, "A Gnome's Assistance", 3, 2, nil, 2, nil},
	{490, 4144, 5, 53, "Bloodpetal Sprouts", 1, 2, nil, 2, nil},
	{490, 4148, 5, 53, "Bloodpetal Zapper [Dungeon]", 2, 2, nil, 2, nil},
	{490, 13850, 1, 53, "Toxic Tolerance", 2, 2, nil, 2, nil},
	{490, 13887, 1, 53, "Venomhide Eggs", 2, 2, nil, 2, nil},
	{490, 13889, 3, 53, "Hungry, Hungry Hatchling", 2, 2, nil, 1, "TODO:RACE"},
	{490, 13903, 3, 53, "Gorishi Grub", 2, 2, nil, 1, "TODO:RACE"},
	{490, 13904, 3, 53, "Poached, Scrambled, Or Raw?", 2, 2, nil, 1, "TODO:RACE"},
	{490, 13905, 3, 53, "Searing Roc Feathers", 2, 2, nil, 1, "TODO:RACE"},
	{490, 13906, 1, 53, "They Grow Up So Fast", 2, 2, nil, 2, nil},
	{490, 13914, 3, 53, "Searing Roc Feathers", 2, 2, nil, 1, "TODO:RACE"},
	{490, 13915, 3, 53, "Hungry, Hungry Hatchling", 2, 2, nil, 1, "TODO:RACE"},
	{490, 13916, 3, 53, "Poached, Scrambled, Or Raw?", 2, 2, nil, 1, "TODO:RACE"},
	{490, 13917, 3, 53, "Gorishi Grub", 2, 2, nil, 1, "TODO:RACE"},
	{490, 3881, 1, 53, "Expedition Salvation", 3, 2, nil, 2, nil},
	{490, 4243, 1, 53, "Chasing A-Me 01", 3, 2, nil, 2, nil},
	{490, 4244, 1, 53, "Chasing A-Me 01", 3, 2, nil, 2, nil},
	{490, 4245, 1, 53, "Chasing A-Me 01", 3, 2, nil, 2, nil},
	{490, 4284, 1, 53, "Crystals of Power", 3, 2, nil, 2, nil},
	{490, 4285, 1, 53, "The Northern Pylon", 3, 2, nil, 2, nil},
	{490, 4287, 1, 53, "The Eastern Pylon", 3, 2, nil, 2, nil},
	{490, 4288, 1, 53, "The Western Pylon", 3, 2, nil, 2, nil},
	{490, 4290, 1, 53, "The Fare of Lar'korwi", 3, 2, nil, 2, nil},
	{490, 4291, 1, 53, "The Scent of Lar'korwi", 3, 2, nil, 2, nil},
	{490, 4321, 1, 53, "Making Sense of It", 3, 2, nil, 2, nil},
	{490, 4381, 2, 53, "Crystal Restore", 3, 2, nil, 2, nil},
	{490, 4382, 2, 53, "Crystal Force", 3, 2, nil, 2, nil},
	{490, 4383, 2, 53, "Crystal Ward", 3, 2, nil, 2, nil},
	{490, 4384, 2, 53, "Crystal Yield", 3, 2, nil, 2, nil},
	{490, 4385, 2, 53, "Crystal Charge", 3, 2, nil, 2, nil},
	{490, 4386, 2, 53, "Crystal Spire", 3, 2, nil, 2, nil},
	{490, 3942, 1, 54, "Linken's Memory", 3, 2, nil, 2, nil},
	{490, 3961, 1, 54, "Linken's Adventure", 3, 2, nil, 2, nil},
	{490, 4005, 1, 54, "Aquementas", 3, 2, nil, 2, nil},
	{490, 4084, 1, 54, "Silver Heart", 3, 2, nil, 2, nil},
	{490, 974, 1, 55, "Finding the Source", 3, 2, nil, 2, nil},
	{490, 980, 1, 55, "The New Springs", 3, 2, nil, 2, nil},
	{490, 4289, 1, 55, "The Apes of Un'Goro", 3, 2, nil, 2, nil},
	{490, 4301, 1, 55, "The Mighty U'cha", 3, 2, nil, 2, nil},
	{490, 4491, 1, 55, "A Little Help From My Friends", 3, 2, nil, 2, nil},
	{490, 4492, 1, 55, "Lost!", 3, 2, nil, 2, nil},
	{490, 4501, 1, 55, "Beware of Pterrordax", 3, 2, nil, 2, nil},
	{490, 4502, 1, 55, "Volcanic Activity", 3, 2, nil, 2, nil},
	{490, 5150, 2, 55, "Dadanga is Hungry!", 3, 2, nil, 2, nil},
	{490, 3962, 1, 56, "It's Dangerous to Go Alone [Group]", 3, 2, nil, 2, nil},
	{490, 4292, 1, 56, "The Bait for Lar'korwi", 3, 2, nil, 2, nil},
	{490, 12547, 1, 78, "The Activation Rune", 3, 2, nil, 2, nil},
	{618, 9266, 2, 0, "Making Amends", 3, 2, nil, 2, nil},
	{618, 6028, 1, 52, "The Everlook Report", 1, 2, nil, 2, nil},
	{618, 6029, 1, 52, "The Everlook Report", 2, 2, nil, 2, nil},
	{618, 6030, 1, 52, "Duke Nicholas Zverenhoff", 3, 2, nil, 2, nil},
	{618, 6605, 1, 54, "A Strange One", 2, 2, nil, 2, nil},
	{618, 4809, 1, 54, "Chillwind Horns", 3, 2, nil, 2, nil},
	{618, 4810, 1, 54, "Return to Tinkee", 3, 2, nil, 2, nil},
	{618, 978, 1, 55, "Moontouched Wildkin", 1, 2, nil, 2, nil},
	{618, 8471, 1, 56, "Winterfall Ritual Totem", 4, 2, nil, 2, nil},
	{618, 5244, 1, 56, "The Ruins of Kel'Theril", 1, 2, nil, 2, nil},
	{618, 5245, 1, 56, "Troubled Spirits of Kel'Theril", 1, 2, nil, 2, nil},
	{618, 5250, 1, 56, "Starfall", 1, 2, nil, 2, nil},
	{618, 3783, 1, 56, "Are We There, Yeti?", 3, 2, nil, 2, nil},
	{618, 4842, 1, 56, "Strange Sources", 3, 2, nil, 2, nil},
	{618, 5054, 1, 56, "Ursius of the Shardtooth", 3, 2, nil, 2, nil},
	{618, 5082, 1, 56, "Threat of the Winterfall", 3, 2, nil, 2, nil},
	{618, 5083, 1, 56, "Winterfall Firewater", 3, 2, nil, 2, nil},
	{618, 5084, 1, 56, "Falling to Corruption", 3, 2, nil, 2, nil},
	{618, 5085, 1, 56, "Mystery Goo", 3, 2, nil, 2, nil},
	{618, 5086, 1, 56, "Toxic Horrors", 3, 2, nil, 2, nil},
	{618, 6603, 1, 56, "Trouble in Winterspring!", 3, 2, nil, 2, nil},
	{618, 979, 1, 57, "Find Ranshalla", 1, 2, nil, 2, nil},
	{618, 4902, 1, 57, "Wildkin of Elune", 1, 2, nil, 2, nil},
	{618, 5087, 1, 57, "Winterfall Runners", 3, 2, nil, 2, nil},
	{618, 5252, 1, 58, "Remorseful Highborne", 1, 2, nil, 2, nil},
	{618, 5253, 1, 58, "The Crystal of Zin-Malor", 1, 2, nil, 2, nil},
	{618, 977, 1, 58, "Are We There, Yeti?", 3, 2, nil, 2, nil},
	{618, 5055, 1, 58, "Brumeran of the Chillwind", 3, 2, nil, 2, nil},
	{618, 5163, 1, 58, "Are We There, Yeti?", 3, 2, nil, 2, nil},
	{618, 4861, 1, 59, "Enraged Wildkin", 1, 2, nil, 2, nil},
	{618, 4863, 1, 59, "Enraged Wildkin", 1, 2, nil, 2, nil},
	{618, 4864, 1, 59, "Enraged Wildkin", 1, 2, nil, 2, nil},
	{618, 4901, 1, 59, "Guardians of the Altar", 1, 2, nil, 2, nil},
	{618, 6604, 1, 59, "Enraged Wildkin", 1, 2, nil, 2, nil},
	{618, 4882, 1, 59, "Guarding Secrets", 2, 2, nil, 2, nil},
	{618, 4883, 1, 59, "Guarding Secrets", 2, 2, nil, 2, nil},
	{618, 5121, 1, 59, "High Chief Winterfall", 3, 2, nil, 2, nil},
	{618, 5123, 1, 59, "The Final Piece", 3, 2, nil, 2, nil},
	{618, 5128, 1, 59, "Words of the High Chief", 3, 2, nil, 2, nil},
	{618, 4970, 5, 60, "Frostsaber Provisions", 1, 2, nil, 2, nil},
	{618, 5201, 5, 60, "Winterfall Intrusion", 1, 2, nil, 2, nil},
	{618, 5981, 5, 60, "Rampaging Giants [Group]", 1, 2, nil, 2, nil},
	{618, 969, 1, 60, "Luck Be With You [Group]", 3, 2, nil, 2, nil},
	{618, 975, 1, 60, "Cache of Mau'ari", 3, 2, nil, 2, nil},
	{618, 4801, 2, 60, "Frostsaber E'ko", 3, 2, nil, 2, nil},
	{618, 4802, 2, 60, "Winterfall E'ko", 3, 2, nil, 2, nil},
	{618, 4803, 2, 60, "Shardtooth E'ko", 3, 2, nil, 2, nil},
	{618, 4804, 2, 60, "Chillwind E'ko", 3, 2, nil, 2, nil},
	{618, 4805, 2, 60, "Ice Thistle E'ko", 3, 2, nil, 2, nil},
	{618, 4806, 2, 60, "Frostmaul E'ko", 3, 2, nil, 2, nil},
	{618, 4807, 2, 60, "Wildkin E'ko", 3, 2, nil, 2, nil},
	{618, 5056, 1, 60, "Shy-Rotam", 3, 2, nil, 2, nil},
	{618, 5057, 1, 60, "Past Endeavors", 3, 2, nil, 2, nil},
	{618, 5063, 1, 60, "Cap of the Scarlet Savant", 3, 2, nil, 2, nil},
	{618, 5067, 5, 60, "Leggings of Arcana [Group]", 3, 2, nil, 2, nil},
	{618, 5068, 5, 60, "Breastplate of Bloodthirst [Group]", 3, 2, nil, 2, nil},
	{618, 5124, 1, 60, "Fiery Plate Gauntlets [Group]", 3, 2, nil, 2, nil},
	{618, 5161, 1, 60, "Wrath of the Blue Flight", 3, 2, nil, 2, nil},
	{618, 8798, 1, 60, "A Yeti of Your Own", 3, 2, nil, 2, nil},

	--[[

		OUTLAND - Version 2.0

		09/11/2010
		Quests flagged as repeatable:
	
		11006:	Reported by Aporakh.
		9727:	This quest is not treated as repeatable by Blizzard, but it is repeatable.
		10346:	This quest is not treated as repeatable by Blizzard, but it is repeatable.
		10347:	This quest is not treated as repeatable by Blizzard, but it is repeatable.

	--]]

	{3522, 10557, 1, 64, "Test Flight: The Zephyrium Capacitorium", 1, 2, nil, 2, nil},
	{3522, 10710, 1, 64, "Test Flight: The Singing Ridge", 1, 2, nil, 2, nil},
	{3522, 10711, 1, 64, "Test Flight: Razaan's Landing", 1, 2, nil, 2, nil},
	{3522, 10712, 1, 64, "Test Flight: Ruuan Weald", 1, 2, nil, 2, nil},
	{3522, 10615, 1, 64, "Ruuan Weald", 2, 2, nil, 2, nil},
	{3522, 9794, 1, 65, "No Time for Curiosity", 1, 2, nil, 2, nil},
	{3522, 10927, 1, 65, "Killing the Crawlers", 1, 2, nil, 2, nil},
	{3522, 9795, 1, 65, "The Ogre Threat", 2, 2, nil, 2, nil},
	{3522, 10618, 1, 65, "The Softest Wings", 2, 2, nil, 2, nil},
	{3522, 10928, 1, 65, "Killing the Crawlers", 2, 2, nil, 2, nil},
	{3522, 10455, 1, 66, "The Encroaching Wilderness", 1, 2, nil, 2, nil},
	{3522, 10456, 1, 66, "Marauding Wolves", 1, 2, nil, 2, nil},
	{3522, 10457, 1, 66, "Protecting Our Own", 1, 2, nil, 2, nil},
	{3522, 10502, 1, 66, "The Bloodmaul Ogres", 1, 2, nil, 2, nil},
	{3522, 10504, 1, 66, "The Bladespire Ogres", 1, 2, nil, 2, nil},
	{3522, 10506, 1, 66, "A Dire Situation", 1, 2, nil, 2, nil},
	{3522, 10510, 1, 66, "Into the Draenethyst Mine", 1, 2, nil, 2, nil},
	{3522, 10511, 1, 66, "Strange Brew", 1, 2, nil, 2, nil},
	{3522, 10512, 1, 66, "Getting the Bladespire Tanked", 1, 2, nil, 2, nil},
	{3522, 10516, 1, 66, "The Trappings of a Vindicator", 1, 2, nil, 2, nil},
	{3522, 10555, 1, 66, "Malaise", 1, 2, nil, 2, nil},
	{3522, 10556, 1, 66, "Scratches", 1, 2, nil, 2, nil},
	{3522, 10690, 1, 66, "The Den Mother", 1, 2, nil, 2, nil},
	{3522, 10486, 1, 66, "The Encroaching Wilderness", 2, 2, nil, 2, nil},
	{3522, 10487, 1, 66, "Dust from the Drakes", 2, 2, nil, 2, nil},
	{3522, 10488, 1, 66, "Protecting Our Own", 2, 2, nil, 2, nil},
	{3522, 10489, 1, 66, "Felling an Ancient Tree", 2, 2, nil, 2, nil},
	{3522, 10503, 1, 66, "The Bladespire Threat", 2, 2, nil, 2, nil},
	{3522, 10505, 1, 66, "The Bloodmaul Ogres", 2, 2, nil, 2, nil},
	{3522, 10524, 1, 66, "Thunderlord Clan Artifacts", 2, 2, nil, 2, nil},
	{3522, 10525, 1, 66, "Vision Guide", 2, 2, nil, 2, nil},
	{3522, 10542, 1, 66, "They Stole Me Hookah and Me Brews!", 2, 2, nil, 2, nil},
	{3522, 10544, 1, 66, "A Curse Upon Both of Your Clans!", 2, 2, nil, 2, nil},
	{3522, 10545, 1, 66, "Bladespire Kegger", 2, 2, nil, 2, nil},
	{3522, 10565, 1, 66, "The Stones of Vekh'nir", 2, 2, nil, 2, nil},
	{3522, 10566, 1, 66, "Trial and Error", 2, 2, nil, 2, nil},
	{3522, 10614, 1, 66, "Whispers on the Wind", 2, 2, nil, 2, nil},
	{3522, 10617, 1, 66, "Silkwing Cocoons", 2, 2, nil, 2, nil},
	{3522, 10567, 1, 66, "Creating the Pendant", 3, 2, nil, 2, nil},
	{3522, 10517, 1, 67, "Gorr'Dim, Your Time Has Come...", 1, 2, nil, 2, nil},
	{3522, 10518, 1, 67, "Planting the Banner [Group]", 1, 2, nil, 2, nil},
	{3522, 10580, 1, 67, "Where Did Those Darn Gnomes Go?", 1, 2, nil, 2, nil},
	{3522, 10581, 1, 67, "Follow the Breadcrumbs", 1, 2, nil, 2, nil},
	{3522, 10584, 1, 67, "Picking Up Some Power Converters", 1, 2, nil, 2, nil},
	{3522, 10594, 1, 67, "Gauging the Resonant Frequency", 1, 2, nil, 2, nil},
	{3522, 10608, 1, 67, "Crystal Clear", 1, 2, nil, 2, nil},
	{3522, 10609, 1, 67, "What Came First, the Drake or the Egg?", 1, 2, nil, 2, nil},
	{3522, 10620, 1, 67, "Ridgespine Menace", 1, 2, nil, 2, nil},
	{3522, 10632, 1, 67, "Cutting Your Teeth", 1, 2, nil, 2, nil},
	{3522, 10657, 1, 67, "Ride the Lightning", 1, 2, nil, 2, nil},
	{3522, 10671, 1, 67, "More than a Pound of Flesh", 1, 2, nil, 2, nil},
	{3522, 10674, 1, 67, "Trapping the Light Fantastic", 1, 2, nil, 2, nil},
	{3522, 10795, 1, 67, "A Date with Dorgok", 1, 2, nil, 2, nil},
	{3522, 10796, 1, 67, "Crush the Bloodmaul Camp!", 1, 2, nil, 2, nil},
	{3522, 10797, 1, 67, "Favor of the Gronn", 1, 2, nil, 2, nil},
	{3522, 10798, 1, 67, "Pay the Baron a Visit", 1, 2, nil, 2, nil},
	{3522, 10799, 1, 67, "Into the Churning Gulch", 1, 2, nil, 2, nil},
	{3522, 10800, 1, 67, "Goodnight, Gronn", 1, 2, nil, 2, nil},
	{3522, 10801, 1, 67, "It's a Trap!", 1, 2, nil, 2, nil},
	{3522, 10805, 1, 67, "Massacre at Gruul's Lair [Group]", 1, 2, nil, 2, nil},
	{3522, 10818, 1, 67, "Baron Sablemane Has Requested Your Presence", 1, 2, nil, 2, nil},
	{3522, 11040, 1, 67, "Parts for the Rocket-Chief", 1, 2, nil, 2, nil},
	{3522, 11043, 1, 67, "Building a Better Gryphon", 1, 2, nil, 2, nil},
	{3522, 10526, 1, 67, "The Thunderspike", 2, 2, nil, 2, nil},
	{3522, 10543, 1, 67, "Grimnok and Korgaah, I Am For You!", 2, 2, nil, 2, nil},
	{3522, 10709, 1, 67, "Reunion", 2, 2, nil, 2, nil},
	{3522, 10714, 1, 67, "On Spirit's Wings", 2, 2, nil, 2, nil},
	{3522, 10715, 1, 67, "Into the Churning Gulch", 2, 2, nil, 2, nil},
	{3522, 10718, 1, 67, "The Spirits Have Voices", 2, 2, nil, 2, nil},
	{3522, 10720, 1, 67, "The Smallest Creatures", 2, 2, nil, 2, nil},
	{3522, 10721, 1, 67, "A Boaring Time for Grulloc", 2, 2, nil, 2, nil},
	{3522, 10724, 1, 67, "Prisoner of the Bladespire [Group]", 2, 2, nil, 2, nil},
	{3522, 10749, 1, 67, "Baron Sablemane's Poison", 2, 2, nil, 2, nil},
	{3522, 10783, 1, 67, "Baron Sablemane", 2, 2, nil, 2, nil},
	{3522, 10784, 1, 67, "Crush the Bloodmaul Camp", 2, 2, nil, 2, nil},
	{3522, 10785, 1, 67, "It's a Trap!", 2, 2, nil, 2, nil},
	{3522, 10846, 1, 67, "Understanding the Mok'Nathal", 2, 2, nil, 2, nil},
	{3522, 10851, 1, 67, "The Totems of My Enemy", 2, 2, nil, 2, nil},
	{3522, 10853, 1, 67, "Spirit Calling", 2, 2, nil, 2, nil},
	{3522, 10859, 1, 67, "Gather the Orbs", 2, 2, nil, 2, nil},
	{3522, 10860, 1, 67, "Mok'Nathal Treats", 2, 2, nil, 2, nil},
	{3522, 11036, 1, 67, "Out of This World Produce!", 2, 2, nil, 2, nil},
	{3522, 11047, 1, 67, "The Apprentice's Request", 2, 2, nil, 2, nil},
	{3522, 10682, 1, 67, "A Time for Negotiation...", 3, 2, nil, 2, nil},
	{3522, 10713, 1, 67, "...and a Time for Action", 3, 2, nil, 2, nil},
	{3522, 10717, 1, 67, "Poaching from Poachers", 3, 2, nil, 2, nil},
	{3522, 10719, 1, 67, "Did You Get The Note?", 3, 2, nil, 2, nil},
	{3522, 10753, 1, 67, "Culling the Wild", 3, 2, nil, 2, nil},
	{3522, 10770, 1, 67, "Little Embers", 3, 2, nil, 2, nil},
	{3522, 10771, 1, 67, "From the Ashes", 3, 2, nil, 2, nil},
	{3522, 10893, 1, 67, "Longtail is the Lynchpin", 3, 2, nil, 2, nil},
	{3522, 10894, 1, 67, "Wyrmskull Watcher", 3, 2, nil, 2, nil},
	{3522, 10675, 1, 68, "Show Them Gnome Mercy!", 1, 2, nil, 2, nil},
	{3522, 10802, 1, 68, "Gorgrom the Dragon-Eater", 1, 2, nil, 2, nil},
	{3522, 10803, 1, 68, "Slaughter at Boulder'mok", 1, 2, nil, 2, nil},
	{3522, 10723, 1, 68, "Gorgrom the Dragon-Eater", 2, 2, nil, 2, nil},
	{3522, 10786, 1, 68, "Slaughter at Boulder'mok", 2, 2, nil, 2, nil},
	{3522, 10843, 1, 68, "Since Time Forgotten...", 2, 2, nil, 2, nil},
	{3522, 10845, 1, 68, "Slay the Brood Mother", 2, 2, nil, 2, nil},
	{3522, 10865, 1, 68, "Inform Leoroxx!", 2, 2, nil, 2, nil},
	{3522, 10867, 1, 68, "There Can Be Only One Response", 2, 2, nil, 2, nil},
	{3522, 10607, 1, 68, "Whispers of the Raven God", 3, 2, nil, 2, nil},
	{3522, 10722, 1, 68, "Meeting at the Blackwing Coven", 3, 2, nil, 2, nil},
	{3522, 10747, 1, 68, "Whelps of the Wyrmcult", 3, 2, nil, 2, nil},
	{3522, 10748, 1, 68, "Maxnar Must Die!", 3, 2, nil, 2, nil},
	{3522, 10810, 1, 68, "Damaged Mask", 3, 2, nil, 2, nil},
	{3522, 10812, 1, 68, "Mystery Mask", 3, 2, nil, 2, nil},
	{3522, 10819, 1, 68, "Felsworn Gas Mask", 3, 2, nil, 2, nil},
	{3522, 10820, 1, 68, "Deceive thy Enemy", 3, 2, nil, 2, nil},
	{3522, 10821, 1, 68, "You're Fired! [Group]", 3, 2, nil, 2, nil},
	{3522, 10825, 1, 68, "The Truth Unorbed", 3, 2, nil, 2, nil},
	{3522, 10829, 1, 68, "Treebole Must Know", 3, 2, nil, 2, nil},
	{3522, 10830, 1, 68, "Exorcising the Trees", 3, 2, nil, 2, nil},
	{3522, 10904, 1, 68, "Harvesting the Fel Ammunition", 3, 2, nil, 2, nil},
	{3522, 10910, 1, 68, "Death's Door", 3, 2, nil, 2, nil},
	{3522, 10911, 1, 68, "Fire At Will!", 3, 2, nil, 2, nil},
	{3522, 10912, 1, 68, "The Hound-Master", 3, 2, nil, 2, nil},
	{3522, 10806, 1, 70, "Showdown [Group]", 1, 2, nil, 2, nil},
	{3522, 10742, 1, 70, "Showdown [Group]", 2, 2, nil, 2, nil},
	{3522, 11022, 1, 70, "Speak with Mog'dorg", 2, 2, nil, 2, nil},
	{3522, 10974, 1, 70, "Stasis Chambers of Bash'ir [Group]", 3, 2, nil, 2, nil},
	{3522, 10975, 2, 70, "Purging the Chambers of Bash'ir [Group]", 3, 2, nil, 2, nil},
	{3522, 10976, 1, 70, "The Mark of the Nexus-King [Group]", 3, 2, nil, 2, nil},
	{3522, 10982, 5, 70, "The Eye of Haramad", 3, 2, nil, 2, nil},
	{3522, 10983, 1, 70, "Mog'dorg the Wizened", 3, 2, nil, 2, nil},
	{3522, 10989, 1, 70, "Mog'dorg the Wizened", 3, 2, nil, 2, nil},
	{3522, 10995, 1, 70, "Grulloc Has Two Skulls [Group]", 3, 2, nil, 2, nil},
	{3522, 10996, 1, 70, "Maggoc's Treasure Chest [Group]", 3, 2, nil, 2, nil},
	{3522, 10997, 1, 70, "Even Gronn Have Standards [Group]", 3, 2, nil, 2, nil},
	{3522, 10998, 1, 70, "Grim(oire) Business [Group]", 3, 2, nil, 2, nil},
	{3522, 11000, 1, 70, "Into the Soulgrinder [Group]", 3, 2, nil, 2, nil},
	{3522, 11009, 1, 70, "Ogre Heaven", 3, 2, nil, 2, nil},
	{3522, 11010, 1, 70, "Bombing Run", 3, 2, nil, 2, nil},
	{3522, 11023, 3, 70, "Bomb Them Again!", 3, 2, nil, 2, nil},
	{3522, 11025, 1, 70, "The Crystals", 3, 2, nil, 2, nil},
	{3522, 11026, 1, 70, "Banish the Demons", 3, 2, nil, 2, nil},
	{3522, 11027, 2, 70, "Yous Have Da Darkrune?", 3, 2, nil, 2, nil},
	{3522, 11030, 1, 70, "Our Boy Wants To Be A Skyguard Ranger", 3, 2, nil, 2, nil},
	{3522, 11051, 3, 70, "Banish More Demons", 3, 2, nil, 2, nil},
	{3522, 11057, 1, 70, "The Trouble Below", 3, 2, nil, 2, nil},
	{3522, 11058, 1, 70, "An Apexis Relic", 3, 2, nil, 2, nil},
	{3522, 11059, 1, 70, "Guardian of the Monument [Group]", 3, 2, nil, 2, nil},
	{3522, 11060, 2, 70, "A Crystalforged Darkrune", 3, 2, nil, 2, nil},
	{3522, 11061, 1, 70, "A Father's Duty", 3, 2, nil, 2, nil},
	{3522, 11062, 1, 70, "The Skyguard Outpost", 3, 2, nil, 2, nil},
	{3522, 11065, 1, 70, "Wrangle Some Aether Rays!", 3, 2, nil, 2, nil},
	{3522, 11066, 3, 70, "Wrangle More Aether Rays!", 3, 2, nil, 2, nil},
	{3522, 11078, 1, 70, "To Rule The Skies [Group]", 3, 2, nil, 2, nil},
	{3522, 11079, 1, 70, "A Fel Whip For Gahk [Group]", 3, 2, nil, 2, nil},
	{3522, 11080, 3, 70, "The Relic's Emanation", 3, 2, nil, 2, nil},
	{3522, 11091, 1, 70, "A Special Thank You", 3, 2, nil, 2, nil},
	{3522, 11102, 1, 70, "Bombing Run", 3, 1, "DRUID", 2, nil},
	{3522, 11119, 1, 70, "Assault on Bash'ir Landing!", 3, 2, nil, 2, nil},
	{3522, 11513, 3, 70, "Intercepting the Mana Cells", 3, 2, nil, 2, nil},
	{3522, 11514, 3, 70, "Maintaining the Sunwell Portal", 3, 2, nil, 2, nil},
	{3483, 10482, 1, 58, "Fel Orc Scavengers", 1, 2, nil, 2, nil},
	{3483, 10483, 1, 58, "Ill Omens", 1, 2, nil, 2, nil},
	{3483, 10484, 1, 58, "Cursed Talismans", 1, 2, nil, 2, nil},
	{3483, 10106, 3, 60, "Hellfire Fortifications [PvP]", 1, 2, nil, 2, nil},
	{3483, 10254, 1, 60, "Force Commander Danath", 1, 2, nil, 2, nil},
	{3483, 10340, 1, 60, "Shatter Point", 1, 2, nil, 2, nil},
	{3483, 10344, 1, 60, "Wing Commander Gryphongar", 1, 2, nil, 2, nil},
	{3483, 10485, 1, 60, "Warlord of the Bleeding Hollow", 1, 2, nil, 2, nil},
	{3483, 10895, 1, 60, "Zeth'Gor Must Burn!", 1, 2, nil, 2, nil},
	{3483, 13408, 1, 60, "Hellfire Fortifications [PvP]", 1, 2, nil, 2, nil},
	{3483, 13410, 1, 60, "Hellfire Fortifications [PvP]", 1, 1, "DEATHKNIGHT", 2, nil},
	{3483, 10110, 3, 60, "Hellfire Fortifications [PvP]", 2, 2, nil, 2, nil},
	{3483, 10242, 1, 60, "Spinebreaker Post", 2, 2, nil, 2, nil},
	{3483, 10291, 1, 60, "Report to Nazgrel", 2, 2, nil, 2, nil},
	{3483, 10449, 1, 60, "Apothecary Zelana", 2, 2, nil, 2, nil},
	{3483, 10450, 1, 60, "Bonechewer Blood", 2, 2, nil, 2, nil},
	{3483, 10538, 1, 60, "Boiling Blood", 2, 2, nil, 2, nil},
	{3483, 10809, 1, 60, "Wanted: Worg Master Kruush", 2, 2, nil, 2, nil},
	{3483, 13409, 1, 60, "Hellfire Fortifications [PvP]", 2, 2, nil, 2, nil},
	{3483, 13411, 1, 60, "Hellfire Fortifications [PvP]", 2, 1, "DEATHKNIGHT", 2, nil},
	{3483, 9355, 1, 61, "A Job for an Intelligent Man", 1, 2, nil, 2, nil},
	{3483, 10047, 1, 61, "The Path of Glory", 1, 2, nil, 2, nil},
	{3483, 10050, 1, 61, "Unyielding Souls", 1, 2, nil, 2, nil},
	{3483, 10055, 1, 61, "Waste Not, Want Not", 1, 2, nil, 2, nil},
	{3483, 10057, 1, 61, "Looking to the Leadership", 1, 2, nil, 2, nil},
	{3483, 10058, 1, 61, "An Old Gift", 1, 2, nil, 2, nil},
	{3483, 10078, 1, 61, "Laying Waste to the Unwanted", 1, 2, nil, 2, nil},
	{3483, 10079, 1, 61, "When This Mine's a-Rockin'", 1, 2, nil, 2, nil},
	{3483, 10099, 1, 61, "The Mastermind", 1, 2, nil, 2, nil},
	{3483, 10119, 1, 61, "Through the Dark Portal", 1, 2, nil, 2, nil},
	{3483, 10140, 1, 61, "Journey to Honor Hold", 1, 2, nil, 2, nil},
	{3483, 10141, 1, 61, "The Legion Reborn", 1, 2, nil, 2, nil},
	{3483, 10142, 1, 61, "The Path of Anguish", 1, 2, nil, 2, nil},
	{3483, 10143, 1, 61, "Expedition Point", 1, 2, nil, 2, nil},
	{3483, 10160, 1, 61, "Know your Enemy", 1, 2, nil, 2, nil},
	{3483, 10288, 1, 61, "Arrival in Outland", 1, 2, nil, 2, nil},
	{3483, 10382, 1, 61, "Go to the Front", 1, 2, nil, 2, nil},
	{3483, 10394, 1, 61, "Disruption - Forge Camp: Mageddon", 1, 2, nil, 2, nil},
	{3483, 10395, 1, 61, "The Dark Missive", 1, 2, nil, 2, nil},
	{3483, 10396, 1, 61, "Enemy of my Enemy...", 1, 2, nil, 2, nil},
	{3483, 10397, 1, 61, "Invasion Point: Annihilator", 1, 2, nil, 2, nil},
	{3483, 10399, 1, 61, "The Heart of Darkness", 1, 2, nil, 2, nil},
	{3483, 10443, 1, 61, "Helping the Cenarion Post", 1, 2, nil, 2, nil},
	{3483, 10903, 1, 61, "Return to Honor Hold", 1, 2, nil, 2, nil},
	{3483, 10909, 1, 61, "Fel Spirits", 1, 2, nil, 2, nil},
	{3483, 10916, 1, 61, "Digging for Prayer Beads", 1, 2, nil, 2, nil},
	{3483, 10919, 2, 61, "Fei Fei's Treat", 1, 2, nil, 2, nil},
	{3483, 10935, 1, 61, "The Exorcism of Colonel Jules", 1, 2, nil, 2, nil},
	{3483, 10936, 1, 61, "Trollbane is Looking for You", 1, 2, nil, 2, nil},
	{3483, 9345, 1, 61, "Preparing the Salve", 2, 2, nil, 2, nil},
	{3483, 9407, 1, 61, "Through the Dark Portal", 2, 2, nil, 2, nil},
	{3483, 10086, 1, 61, "I Work... For the Horde!", 2, 2, nil, 2, nil},
	{3483, 10087, 1, 61, "Burn It Up... For the Horde!", 2, 2, nil, 2, nil},
	{3483, 10103, 1, 61, "Report to Zurai", 2, 2, nil, 2, nil},
	{3483, 10120, 1, 61, "Arrival in Outland", 2, 2, nil, 2, nil},
	{3483, 10121, 1, 61, "Eradicate the Burning Legion", 2, 2, nil, 2, nil},
	{3483, 10123, 1, 61, "Felspark Ravine", 2, 2, nil, 2, nil},
	{3483, 10124, 1, 61, "Forward Base: Reaver's Fall", 2, 2, nil, 2, nil},
	{3483, 10213, 1, 61, "Investigate the Crash", 2, 2, nil, 2, nil},
	{3483, 10220, 1, 61, "Make Them Listen", 2, 2, nil, 2, nil},
	{3483, 10229, 1, 61, "Decipher the Tome", 2, 2, nil, 2, nil},
	{3483, 10230, 1, 61, "The Battle Horn", 2, 2, nil, 2, nil},
	{3483, 10250, 1, 61, "Bloody Vengeance", 2, 2, nil, 2, nil},
	{3483, 10258, 1, 61, "Honor the Fallen", 2, 2, nil, 2, nil},
	{3483, 10278, 1, 61, "The Warp Rifts", 2, 2, nil, 2, nil},
	{3483, 10289, 1, 61, "Journey to Thrallmar", 2, 2, nil, 2, nil},
	{3483, 10294, 1, 61, "Void Ridge", 2, 2, nil, 2, nil},
	{3483, 10388, 1, 61, "Return to Thrallmar", 2, 2, nil, 2, nil},
	{3483, 10389, 1, 61, "The Agony and the Darkness", 2, 2, nil, 2, nil},
	{3483, 10390, 1, 61, "Forge Camp: Mageddon", 2, 2, nil, 2, nil},
	{3483, 10391, 1, 61, "Cannons of Rage", 2, 2, nil, 2, nil},
	{3483, 10392, 1, 61, "Doorway to the Abyss", 2, 2, nil, 2, nil},
	{3483, 10393, 1, 61, "Vile Plans", 2, 2, nil, 2, nil},
	{3483, 10442, 1, 61, "Helping the Cenarion Post", 2, 2, nil, 2, nil},
	{3483, 10792, 1, 61, "Zeth'Gor Must Burn!", 2, 2, nil, 2, nil},
	{3483, 10835, 1, 61, "Apothecary Antonivich", 2, 2, nil, 2, nil},
	{3483, 10838, 1, 61, "The Demoniac Scryer [Group]", 2, 2, nil, 2, nil},
	{3483, 10864, 1, 61, "A Burden of Souls", 2, 2, nil, 2, nil},
	{3483, 10875, 1, 61, "Report to Nazgrel", 2, 2, nil, 2, nil},
	{3483, 9349, 1, 61, "Ravager Egg Roundup", 3, 2, nil, 2, nil},
	{3483, 9351, 1, 61, "Voidwalkers Gone Wild", 3, 2, nil, 2, nil},
	{3483, 9356, 1, 61, "Smooth as Butter", 3, 2, nil, 2, nil},
	{3483, 9361, 1, 61, "Helboar, the Other White Meat", 3, 2, nil, 2, nil},
	{3483, 9373, 1, 61, "Missing Missive", 3, 2, nil, 2, nil},
	{3483, 10161, 1, 61, "In Case of Emergency...", 3, 2, nil, 2, nil},
	{3483, 10236, 1, 61, "Outland Sucks!", 3, 2, nil, 2, nil},
	{3483, 10238, 1, 61, "How to Serve Goblins", 3, 2, nil, 2, nil},
	{3483, 10629, 1, 61, "Shizz Work", 3, 2, nil, 2, nil},
	{3483, 10630, 1, 61, "Beneath Thrallmar", 3, 2, nil, 2, nil},
	{3483, 9390, 1, 62, "In Search of Sedai", 1, 2, nil, 2, nil},
	{3483, 9398, 1, 62, "Deadly Predators", 1, 2, nil, 2, nil},
	{3483, 9420, 1, 62, "The Finest Down", 1, 2, nil, 2, nil},
	{3483, 9423, 1, 62, "Return to Obadei", 1, 2, nil, 2, nil},
	{3483, 9426, 1, 62, "The Pools of Aggonar", 1, 2, nil, 2, nil},
	{3483, 9427, 1, 62, "Cleansing the Waters", 1, 2, nil, 2, nil},
	{3483, 9558, 1, 62, "The Longbeards", 1, 2, nil, 2, nil},
	{3483, 9563, 1, 62, "Gaining Mirren's Trust", 1, 2, nil, 2, nil},
	{3483, 9587, 1, 62, "Dark Tidings [Dungeon]", 1, 2, nil, 2, nil},
	{3483, 10144, 1, 62, "Disrupt Their Reinforcements", 1, 2, nil, 2, nil},
	{3483, 10146, 1, 62, "Mission: The Murketh and Shaadraz Gateways", 1, 2, nil, 2, nil},
	{3483, 10163, 1, 62, "Mission: The Abyssal Shelf", 1, 2, nil, 2, nil},
	{3483, 10346, 2, 62, "Return to the Abyssal Shelf", 1, 2, nil, 2, nil},
	{3483, 10937, 1, 62, "Drill the Drillmaster [Group]", 1, 2, nil, 2, nil},
	{3483, 9340, 1, 62, "The Great Fissure", 2, 2, nil, 2, nil},
	{3483, 9366, 1, 62, "In Need of Felblood", 2, 2, nil, 2, nil},
	{3483, 9370, 1, 62, "The Cleansing Must Be Stopped", 2, 2, nil, 2, nil},
	{3483, 9374, 1, 62, "Arelion's Journal", 2, 2, nil, 2, nil},
	{3483, 9391, 1, 62, "Marking the Path", 2, 2, nil, 2, nil},
	{3483, 9396, 1, 62, "Magic of the Arakkoa", 2, 2, nil, 2, nil},
	{3483, 9397, 1, 62, "Birds of a Feather", 2, 2, nil, 2, nil},
	{3483, 9400, 1, 62, "The Assassin", 2, 2, nil, 2, nil},
	{3483, 9401, 1, 62, "A Strange Weapon", 2, 2, nil, 2, nil},
	{3483, 9405, 1, 62, "The Warchief's Mandate", 2, 2, nil, 2, nil},
	{3483, 9406, 1, 62, "The Mag'har", 2, 2, nil, 2, nil},
	{3483, 9410, 1, 62, "A Spirit Guide", 2, 2, nil, 2, nil},
	{3483, 9438, 1, 62, "Messenger to Thrall", 2, 2, nil, 2, nil},
	{3483, 9472, 1, 62, "Arelion's Mistress", 2, 2, nil, 2, nil},
	{3483, 9483, 2, 62, "Life's Finer Pleasures", 2, 2, nil, 2, nil},
	{3483, 9498, 1, 62, "Falcon Watch", 2, 2, nil, 2, nil},
	{3483, 9499, 1, 62, "Falcon Watch", 2, 2, nil, 1, "BLOODELF"},
	{3483, 9588, 1, 62, "Dark Tidings [Dungeon]", 2, 2, nil, 2, nil},
	{3483, 10129, 1, 62, "Mission: Gateways Murketh and Shaadraz", 2, 2, nil, 2, nil},
	{3483, 10162, 1, 62, "Mission: The Abyssal Shelf", 2, 2, nil, 2, nil},
	{3483, 10208, 1, 62, "Disrupt Their Reinforcements", 2, 2, nil, 2, nil},
	{3483, 10286, 1, 62, "Arelion's Secret", 2, 2, nil, 2, nil},
	{3483, 10287, 1, 62, "The Mistress Revealed", 2, 2, nil, 2, nil},
	{3483, 10347, 2, 62, "Return to the Abyssal Shelf", 2, 2, nil, 2, nil},
	{3483, 10813, 1, 62, "The Eyes of Grillok", 2, 2, nil, 2, nil},
	{3483, 10834, 1, 62, "Grillok \"Darkeye\" [Group]", 2, 2, nil, 2, nil},
	{3483, 10367, 1, 62, "A Traitor Among Us", 3, 2, nil, 2, nil},
	{3483, 10368, 1, 62, "The Dreghood Elders", 3, 2, nil, 2, nil},
	{3483, 10369, 1, 62, "Arzeth's Demise", 3, 2, nil, 2, nil},
	{3483, 10403, 1, 62, "Naladu", 3, 2, nil, 2, nil},
	{3483, 9418, 1, 63, "Avruu's Orb", 4, 2, nil, 2, nil},
	{3483, 9383, 1, 63, "An Ambitious Plan", 1, 2, nil, 2, nil},
	{3483, 9385, 1, 63, "Rampaging Ravagers", 1, 2, nil, 2, nil},
	{3483, 9399, 1, 63, "Cruel Taskmasters", 1, 2, nil, 2, nil},
	{3483, 9417, 1, 63, "The Arakkoa Threat", 1, 2, nil, 2, nil},
	{3483, 9424, 1, 63, "Makuru's Vengeance", 1, 2, nil, 2, nil},
	{3483, 9430, 1, 63, "Sha'naar Relics", 1, 2, nil, 2, nil},
	{3483, 9490, 1, 63, "The Rock Flayer Matriarch [Group]", 1, 2, nil, 2, nil},
	{3483, 9543, 1, 63, "Atonement", 1, 2, nil, 2, nil},
	{3483, 9545, 1, 63, "The Seer's Relic", 1, 2, nil, 2, nil},
	{3483, 10093, 1, 63, "The Temple of Telhamat", 1, 2, nil, 2, nil},
	{3483, 10400, 1, 63, "Overlord [Group]", 1, 2, nil, 2, nil},
	{3483, 9375, 1, 63, "The Road to Falcon Watch [Group]", 2, 2, nil, 2, nil},
	{3483, 9376, 1, 63, "A Pilgrim's Plight", 2, 2, nil, 2, nil},
	{3483, 9381, 1, 63, "Trueflight Arrows", 2, 2, nil, 2, nil},
	{3483, 9387, 1, 63, "Source of the Corruption", 2, 2, nil, 2, nil},
	{3483, 9441, 1, 63, "Envoy to the Mag'har", 2, 2, nil, 2, nil},
	{3483, 9442, 1, 63, "A Debilitating Sickness", 2, 2, nil, 2, nil},
	{3483, 9447, 1, 63, "Administering the Salve", 2, 2, nil, 2, nil},
	{3483, 9466, 1, 63, "Wanted: Blacktalon the Savage [Group]", 2, 2, nil, 2, nil},
	{3483, 10136, 1, 63, "Cruel's Intentions [Group]", 2, 2, nil, 2, nil},
	{3483, 10295, 1, 63, "From the Abyss", 2, 2, nil, 2, nil},
	{3483, 10876, 1, 63, "The Foot of the Citadel [Group]", 2, 2, nil, 2, nil},
	{3483, 9372, 1, 63, "Demonic Contamination", 3, 2, nil, 2, nil},
	{3483, 10132, 1, 63, "Colossal Menace [Group]", 3, 2, nil, 2, nil},
	{3483, 10134, 1, 63, "Crimson Crystal Clue [Group]", 3, 2, nil, 2, nil},
	{3483, 10159, 1, 63, "Keep Thornfang Hill Clear!", 3, 2, nil, 2, nil},
	{3483, 10255, 1, 63, "Testing the Antidote", 3, 2, nil, 2, nil},
	{3483, 10349, 1, 63, "The Earthbinder [Group]", 3, 2, nil, 2, nil},
	{3483, 10351, 1, 63, "Natural Remedies [Group]", 3, 2, nil, 2, nil},
	{3483, 10754, 1, 70, "Entry Into the Citadel", 1, 2, nil, 2, nil},
	{3483, 10762, 1, 70, "Grand Master Dumphry", 1, 2, nil, 2, nil},
	{3483, 10763, 1, 70, "Dumphry's Request", 1, 2, nil, 2, nil},
	{3483, 10764, 1, 70, "Hotter than Hell [Group]", 1, 2, nil, 2, nil},
	{3483, 11002, 1, 70, "The Fall of Magtheridon", 1, 2, nil, 2, nil},
	{3483, 10755, 1, 70, "Entry Into the Citadel", 2, 2, nil, 2, nil},
	{3483, 10756, 1, 70, "Grand Master Rohok", 2, 2, nil, 2, nil},
	{3483, 10757, 1, 70, "Rohok's Request", 2, 2, nil, 2, nil},
	{3483, 10758, 1, 70, "Hotter than Hell [Group]", 2, 2, nil, 2, nil},
	{3483, 11003, 1, 70, "The Fall of Magtheridon", 2, 2, nil, 2, nil},
	{3483, 11515, 3, 70, "Blood for Blood", 3, 2, nil, 2, nil},
	{3483, 11516, 3, 70, "Blast the Gateway", 3, 2, nil, 2, nil},
	{4095, 11499, 3, 70, "Wanted: The Signet Ring of Prince Kael'thas [Heroic]", 3, 2, nil, 2, nil},
	{4095, 11500, 3, 70, "Wanted: Sisters of Torment [Dungeon]", 3, 2, nil, 2, nil},
	{3518, 9917, 1, 65, "Do My Eyes Deceive Me", 1, 2, nil, 2, nil},
	{3518, 9918, 1, 65, "Not On My Watch!", 1, 2, nil, 2, nil},
	{3518, 9920, 1, 65, "Mo'mor the Breaker", 1, 2, nil, 2, nil},
	{3518, 9921, 1, 65, "The Ruins of Burning Blade", 1, 2, nil, 2, nil},
	{3518, 9923, 1, 65, "HELP!", 1, 2, nil, 2, nil},
	{3518, 10113, 1, 65, "The Nesingwary Safari", 1, 2, nil, 2, nil},
	{3518, 9891, 1, 65, "Because Kilrath is a Coward", 2, 2, nil, 2, nil},
	{3518, 9906, 1, 65, "Message in a Battle", 2, 2, nil, 2, nil},
	{3518, 9910, 1, 65, "Standards and Practices", 2, 2, nil, 2, nil},
	{3518, 10114, 1, 65, "The Nesingwary Safari", 2, 2, nil, 2, nil},
	{3518, 9800, 1, 65, "A Rare Bean", 3, 2, nil, 2, nil},
	{3518, 9804, 1, 65, "Agitated Spirits of Skysong", 3, 2, nil, 2, nil},
	{3518, 9805, 1, 65, "Blessing of Incineratus", 3, 2, nil, 2, nil},
	{3518, 9818, 1, 65, "The Underneath", 3, 2, nil, 2, nil},
	{3518, 9819, 1, 65, "The Tortured Earth", 3, 2, nil, 2, nil},
	{3518, 9854, 1, 65, "Windroc Mastery", 3, 2, nil, 2, nil},
	{3518, 9857, 1, 65, "Talbuk Mastery", 3, 2, nil, 2, nil},
	{3518, 9897, 1, 65, "I'm Saved!", 3, 2, nil, 2, nil},
	{3518, 9869, 1, 66, "The Throne of the Elements", 1, 2, nil, 2, nil},
	{3518, 9922, 1, 66, "The Twin Clefts of Nagrand", 1, 2, nil, 2, nil},
	{3518, 9924, 1, 66, "Corki's Gone Missing Again!", 1, 2, nil, 2, nil},
	{3518, 9933, 1, 66, "Message to Telaar", 1, 2, nil, 2, nil},
	{3518, 9936, 1, 66, "Wanted: Giselda the Crone", 1, 2, nil, 2, nil},
	{3518, 9940, 1, 66, "Wanted: Zorbo the Advisor", 1, 2, nil, 2, nil},
	{3518, 10108, 1, 66, "Diplomatic Measures", 1, 2, nil, 2, nil},
	{3518, 9863, 1, 66, "Vile Idolatry", 2, 2, nil, 2, nil},
	{3518, 9870, 1, 66, "The Throne of the Elements", 2, 2, nil, 2, nil},
	{3518, 9907, 1, 66, "An Audacious Advance", 2, 2, nil, 2, nil},
	{3518, 9916, 1, 66, "Bleeding Hollow Supply Crates", 2, 2, nil, 2, nil},
	{3518, 9934, 1, 66, "Message to Garadar", 2, 2, nil, 2, nil},
	{3518, 9935, 1, 66, "Wanted: Giselda the Crone", 2, 2, nil, 2, nil},
	{3518, 9939, 1, 66, "Wanted: Zorbo the Advisor", 2, 2, nil, 2, nil},
	{3518, 10107, 1, 66, "Diplomatic Measures", 2, 2, nil, 2, nil},
	{3518, 9789, 1, 66, "Clefthoof Mastery", 3, 2, nil, 2, nil},
	{3518, 9810, 1, 66, "The Spirit Polluted", 3, 2, nil, 2, nil},
	{3518, 9815, 1, 66, "Muck Diving", 3, 2, nil, 2, nil},
	{3518, 9821, 1, 66, "Eating Damnation", 3, 2, nil, 2, nil},
	{3518, 9858, 1, 66, "Talbuk Mastery", 3, 2, nil, 2, nil},
	{3518, 9859, 1, 66, "Talbuk Mastery [Group]", 3, 2, nil, 2, nil},
	{3518, 9882, 1, 66, "Stealing from Thieves", 3, 2, nil, 2, nil},
	{3518, 9883, 2, 66, "More Crystal Fragments", 3, 2, nil, 2, nil},
	{3518, 9913, 1, 66, "The Consortium Needs You!", 3, 2, nil, 2, nil},
	{3518, 9914, 1, 66, "A Head Full of Ivory", 3, 2, nil, 2, nil},
	{3518, 9915, 2, 66, "More Heads Full of Ivory", 3, 2, nil, 2, nil},
	{3518, 9925, 1, 66, "Matters of Security", 3, 2, nil, 2, nil},
	{3518, 9927, 1, 66, "Ruthless Cunning", 3, 2, nil, 2, nil},
	{3518, 9928, 1, 66, "Armaments for Deception", 3, 2, nil, 2, nil},
	{3518, 9931, 1, 66, "Returning the Favor", 3, 2, nil, 2, nil},
	{3518, 9932, 1, 66, "Body of Evidence", 3, 2, nil, 2, nil},
	{3518, 10109, 1, 66, "I Must Have Them!", 3, 2, nil, 2, nil},
	{3518, 10111, 1, 66, "Bring Me The Egg! [Group]", 3, 2, nil, 2, nil},
	{3518, 9871, 1, 67, "Murkblood Invaders", 1, 2, nil, 2, nil},
	{3518, 9873, 1, 67, "Ortor My Old Friend...", 1, 2, nil, 2, nil},
	{3518, 9874, 1, 67, "Stopping the Spread", 1, 2, nil, 2, nil},
	{3518, 9878, 1, 67, "Solving the Problem", 1, 2, nil, 2, nil},
	{3518, 9879, 1, 67, "The Totem of Kar'dash [Group]", 1, 2, nil, 2, nil},
	{3518, 9938, 1, 67, "Wanted: Durn the Hungerer [Group]", 1, 2, nil, 2, nil},
	{3518, 9954, 1, 67, "Corki's Ransom [Group]", 1, 2, nil, 2, nil},
	{3518, 9955, 1, 67, "Cho'war the Pillager [Group]", 1, 2, nil, 2, nil},
	{3518, 9956, 1, 67, "The Ravaged Caravan", 1, 2, nil, 2, nil},
	{3518, 10076, 1, 67, "Oshu'gun Crystal Powder [PvP]", 1, 2, nil, 2, nil},
	{3518, 10077, 2, 67, "Oshu'gun Crystal Powder [PvP]", 1, 2, nil, 2, nil},
	{3518, 10476, 1, 67, "Fierce Enemies", 1, 2, nil, 2, nil},
	{3518, 11042, 1, 67, "A Mystifying Vision", 1, 2, nil, 2, nil},
	{3518, 11044, 1, 67, "Visions of Destruction", 1, 2, nil, 2, nil},
	{3518, 9864, 1, 67, "The Missing War Party", 2, 2, nil, 2, nil},
	{3518, 9865, 1, 67, "Once Were Warriors", 2, 2, nil, 2, nil},
	{3518, 9866, 1, 67, "He Will Walk The Earth...", 2, 2, nil, 2, nil},
	{3518, 9867, 1, 67, "Murkblood Leaders...", 2, 2, nil, 2, nil},
	{3518, 9868, 1, 67, "The Totem of Kar'dash [Group]", 2, 2, nil, 2, nil},
	{3518, 9872, 1, 67, "Murkblood Invaders", 2, 2, nil, 2, nil},
	{3518, 9937, 1, 67, "Wanted: Durn the Hungerer [Group]", 2, 2, nil, 2, nil},
	{3518, 9944, 1, 67, "Missing Mag'hari Procession", 2, 2, nil, 2, nil},
	{3518, 9945, 1, 67, "War on the Warmaul", 2, 2, nil, 2, nil},
	{3518, 9946, 1, 67, "Cho'war the Pillager [Group]", 2, 2, nil, 2, nil},
	{3518, 9948, 1, 67, "Finding the Survivors", 2, 2, nil, 2, nil},
	{3518, 10074, 1, 67, "Oshu'gun Crystal Powder [PvP]", 2, 2, nil, 2, nil},
	{3518, 10075, 2, 67, "Oshu'gun Crystal Powder [PvP]", 2, 2, nil, 2, nil},
	{3518, 10479, 1, 67, "Proving Your Strength", 2, 2, nil, 2, nil},
	{3518, 11037, 1, 67, "A Strange Vision", 2, 2, nil, 2, nil},
	{3518, 11048, 1, 67, "Kroghan's Report", 2, 2, nil, 2, nil},
	{3518, 9849, 1, 67, "Shattering the Veil", 3, 2, nil, 2, nil},
	{3518, 9850, 1, 67, "Clefthoof Mastery", 3, 2, nil, 2, nil},
	{3518, 9851, 1, 67, "Clefthoof Mastery [Group]", 3, 2, nil, 2, nil},
	{3518, 9853, 1, 67, "Gurok the Usurper [Group]", 3, 2, nil, 2, nil},
	{3518, 9855, 1, 67, "Windroc Mastery", 3, 2, nil, 2, nil},
	{3518, 9856, 1, 67, "Windroc Mastery [Group]", 3, 2, nil, 2, nil},
	{3518, 9861, 1, 67, "The Howling Wind", 3, 2, nil, 2, nil},
	{3518, 9862, 1, 67, "Murkblood Corrupters", 3, 2, nil, 2, nil},
	{3518, 9892, 2, 67, "More Obsidian Warbeads", 3, 2, nil, 2, nil},
	{3518, 9893, 1, 67, "Obsidian Warbeads", 3, 2, nil, 2, nil},
	{3518, 9900, 1, 67, "Gava'xi", 3, 2, nil, 2, nil},
	{3518, 9962, 1, 67, "The Ring of Blood: Brokentoe [Group]", 3, 2, nil, 2, nil},
	{3518, 9967, 1, 67, "The Ring of Blood: The Blue Brothers [Group]", 3, 2, nil, 2, nil},
	{3518, 9970, 1, 67, "The Ring of Blood: Rokdar the Sundered Lord [Group]", 3, 2, nil, 2, nil},
	{3518, 9972, 1, 67, "The Ring of Blood: Skra'gath [Group]", 3, 2, nil, 2, nil},
	{3518, 9973, 1, 67, "The Ring of Blood: The Warmaul Champion [Group]", 3, 2, nil, 2, nil},
	{3518, 10251, 1, 67, "The Master's Grand Design?", 3, 2, nil, 2, nil},
	{3518, 10252, 1, 67, "Vision of the Dead [Group]", 3, 2, nil, 2, nil},
	{3518, 9982, 1, 68, "He Called Himself Altruis... [Group]", 1, 2, nil, 2, nil},
	{3518, 10477, 2, 68, "More Warbeads", 1, 2, nil, 2, nil},
	{3518, 9983, 1, 68, "He Called Himself Altruis... [Group]", 2, 2, nil, 2, nil},
	{3518, 10044, 1, 68, "A Visit With the Greatmother", 2, 2, nil, 2, nil},
	{3518, 10045, 1, 68, "Material Components", 2, 2, nil, 2, nil},
	{3518, 10081, 1, 68, "To Meet Mother Kashur", 2, 2, nil, 2, nil},
	{3518, 10082, 1, 68, "The Agitated Ancestors", 2, 2, nil, 2, nil},
	{3518, 10085, 1, 68, "A Visit With The Ancestors", 2, 2, nil, 2, nil},
	{3518, 10101, 1, 68, "When Spirits Speak", 2, 2, nil, 2, nil},
	{3518, 10102, 1, 68, "A Secret Revealed", 2, 2, nil, 2, nil},
	{3518, 10168, 1, 68, "What the Soul Sees [Group]", 2, 2, nil, 2, nil},
	{3518, 10170, 1, 68, "Return to the Greatmother", 2, 2, nil, 2, nil},
	{3518, 10171, 1, 68, "The Inconsolable Chieftain", 2, 2, nil, 2, nil},
	{3518, 10172, 1, 68, "There Is No Hope", 2, 2, nil, 2, nil},
	{3518, 10175, 1, 68, "Thrall, Son of Durotan", 2, 2, nil, 2, nil},
	{3518, 10212, 1, 68, "Hero of the Mag'har", 2, 2, nil, 2, nil},
	{3518, 10478, 2, 68, "More Warbeads!", 2, 2, nil, 2, nil},
	{3518, 9852, 1, 68, "The Ultimate Bloodsport [Group]", 3, 2, nil, 2, nil},
	{3518, 9977, 1, 68, "The Ring of Blood: The Final Challenge [Group]", 3, 2, nil, 2, nil},
	{3518, 9991, 1, 68, "Survey the Land [Group]", 3, 2, nil, 2, nil},
	{3518, 9999, 1, 68, "Buying Time [Group]", 3, 2, nil, 2, nil},
	{3518, 10001, 1, 68, "The Master Planner [Group]", 3, 2, nil, 2, nil},
	{3518, 10004, 1, 68, "Patience and Understanding [Group]", 3, 2, nil, 2, nil},
	{3518, 10011, 1, 68, "Forge Camp: Annihilated [Group]", 3, 2, nil, 2, nil},
	{3518, 11502, 3, 70, "In Defense of Halaa [PvP]", 1, 2, nil, 2, nil},
	{3518, 11880, 3, 70, "The Multiphase Survey", 1, 2, nil, 2, nil},
	{3518, 11503, 3, 70, "Enemies, Old and New [PvP]", 2, 2, nil, 2, nil},
	{3518, 9884, 5, 70, "Membership Benefits", 3, 2, nil, 2, nil},
	{3518, 9885, 5, 70, "Membership Benefits", 3, 2, nil, 2, nil},
	{3518, 9886, 5, 70, "Membership Benefits", 3, 2, nil, 2, nil},
	{3518, 9887, 5, 70, "Membership Benefits", 3, 2, nil, 2, nil},
	{3518, 10640, 1, 70, "Altruis", 3, 2, nil, 2, nil},
	{3518, 10641, 1, 70, "Against the Legion", 3, 2, nil, 2, nil},
	{3518, 10646, 1, 70, "Illidan's Pupil", 3, 2, nil, 2, nil},
	{3518, 10668, 1, 70, "Against the Illidari", 3, 2, nil, 2, nil},
	{3518, 10669, 1, 70, "Against All Odds", 3, 2, nil, 2, nil},
	{3518, 10689, 1, 70, "Altruis", 3, 2, nil, 2, nil},
	{3523, 10197, 1, 68, "A Convincing Disguise", 4, 2, nil, 2, nil},
	{3523, 10198, 1, 68, "Information Gathering", 4, 2, nil, 2, nil},
	{3523, 10241, 1, 68, "Distraction at Manaforge B'naar", 4, 2, nil, 2, nil},
	{3523, 10246, 1, 68, "Attack on Manaforge Coruu", 4, 2, nil, 2, nil},
	{3523, 10299, 1, 68, "Shutting Down Manaforge B'naar", 4, 2, nil, 2, nil},
	{3523, 10313, 1, 68, "Measuring Warp Energies", 4, 2, nil, 2, nil},
	{3523, 10173, 1, 68, "The Archmage's Staff", 3, 2, nil, 2, nil},
	{3523, 10174, 1, 68, "Curse of the Violet Tower", 3, 2, nil, 2, nil},
	{3523, 10176, 1, 68, "Ar'kelos the Guardian", 3, 2, nil, 2, nil},
	{3523, 10182, 1, 68, "Battle-Mage Dathric", 3, 2, nil, 2, nil},
	{3523, 10183, 1, 68, "Off To Area 52", 3, 2, nil, 2, nil},
	{3523, 10184, 1, 68, "Malevolent Remnants", 3, 2, nil, 2, nil},
	{3523, 10185, 1, 68, "A Fate Worse Than Death", 3, 2, nil, 2, nil},
	{3523, 10186, 1, 68, "You're Hired!", 3, 2, nil, 2, nil},
	{3523, 10189, 1, 68, "Manaforge B'naar", 3, 2, nil, 2, nil},
	{3523, 10190, 1, 68, "Recharging the Batteries", 3, 2, nil, 2, nil},
	{3523, 10191, 1, 68, "Mark V is Alive! [Group]", 3, 2, nil, 2, nil},
	{3523, 10193, 1, 68, "High Value Targets", 3, 2, nil, 2, nil},
	{3523, 10194, 1, 68, "Stealth Flight", 3, 2, nil, 2, nil},
	{3523, 10199, 1, 68, "That Little Extra Kick", 3, 2, nil, 2, nil},
	{3523, 10200, 1, 68, "Return to Thalodien", 3, 2, nil, 2, nil},
	{3523, 10204, 1, 68, "Bloodgem Crystals", 3, 2, nil, 2, nil},
	{3523, 10206, 1, 68, "Pick Your Part", 3, 2, nil, 2, nil},
	{3523, 10221, 1, 68, "Dr. Boom!", 3, 2, nil, 2, nil},
	{3523, 10224, 1, 68, "Essence for the Engines", 3, 2, nil, 2, nil},
	{3523, 10225, 1, 68, "Report to Engineering", 3, 2, nil, 2, nil},
	{3523, 10226, 1, 68, "Elemental Power Extraction", 3, 2, nil, 2, nil},
	{3523, 10243, 1, 68, "Naaru Technology", 3, 2, nil, 2, nil},
	{3523, 10245, 1, 68, "B'naar Console Transcription", 3, 2, nil, 2, nil},
	{3523, 10261, 1, 68, "Wanted: Annihilator Servo! [Group]", 3, 2, nil, 2, nil},
	{3523, 10262, 1, 68, "A Heap of Ethereals", 3, 2, nil, 2, nil},
	{3523, 10263, 1, 68, "Assisting the Consortium", 3, 2, nil, 2, nil},
	{3523, 10264, 1, 68, "Assisting the Consortium", 3, 2, nil, 2, nil},
	{3523, 10308, 2, 68, "Another Heap of Ethereals", 3, 2, nil, 2, nil},
	{3523, 10309, 1, 68, "It's a Fel Reaver, But with Heart [Group]", 3, 2, nil, 2, nil},
	{3523, 10329, 1, 68, "Shutting Down Manaforge B'naar", 3, 2, nil, 2, nil},
	{3523, 10342, 1, 68, "Securing the Shaleskin Shale", 3, 2, nil, 2, nil},
	{3523, 10417, 1, 68, "Run a Diagnostic!", 3, 2, nil, 2, nil},
	{3523, 10418, 1, 68, "Deal With the Saboteurs", 3, 2, nil, 2, nil},
	{3523, 10701, 1, 68, "Breaking Down Netherock [Group]", 3, 2, nil, 2, nil},
	{3523, 10321, 1, 69, "Shutting Down Manaforge Coruu", 4, 2, nil, 2, nil},
	{3523, 10330, 1, 69, "Shutting Down Manaforge Coruu", 4, 2, nil, 2, nil},
	{3523, 10188, 1, 69, "The Sigil of Krasus", 3, 2, nil, 2, nil},
	{3523, 10192, 1, 69, "Krasus's Compendium", 3, 2, nil, 2, nil},
	{3523, 10203, 1, 69, "Invaluable Asset Zapping", 3, 2, nil, 2, nil},
	{3523, 10205, 1, 69, "Warp-Raider Nesaad", 3, 2, nil, 2, nil},
	{3523, 10209, 1, 69, "Summoner Kanthin's Prize", 3, 2, nil, 2, nil},
	{3523, 10222, 1, 69, "The Sunfury Garrison", 3, 2, nil, 2, nil},
	{3523, 10223, 1, 69, "Down With Daellis", 3, 2, nil, 2, nil},
	{3523, 10232, 1, 69, "In A Scrap With The Legion", 3, 2, nil, 2, nil},
	{3523, 10233, 1, 69, "Torching Sunfury Hold", 3, 2, nil, 2, nil},
	{3523, 10234, 1, 69, "One Demon's Trash...", 3, 2, nil, 2, nil},
	{3523, 10235, 1, 69, "Declawing Doomclaw", 3, 2, nil, 2, nil},
	{3523, 10237, 1, 69, "Warn Area 52!", 3, 2, nil, 2, nil},
	{3523, 10239, 1, 69, "Potential Energy Source", 3, 2, nil, 2, nil},
	{3523, 10240, 1, 69, "Building a Perimeter", 3, 2, nil, 2, nil},
	{3523, 10247, 1, 69, "Doctor Vomisa, Ph.T. [Group]", 3, 2, nil, 2, nil},
	{3523, 10248, 1, 69, "You, Robot [Group]", 3, 2, nil, 2, nil},
	{3523, 10249, 1, 69, "Back to the Chief!", 3, 2, nil, 2, nil},
	{3523, 10256, 1, 69, "Finding the Keymaster [Group]", 3, 2, nil, 2, nil},
	{3523, 10265, 1, 69, "Consortium Crystal Collection", 3, 2, nil, 2, nil},
	{3523, 10266, 1, 69, "Request for Assistance", 3, 2, nil, 2, nil},
	{3523, 10267, 1, 69, "Rightful Repossession", 3, 2, nil, 2, nil},
	{3523, 10268, 1, 69, "An Audience with the Prince", 3, 2, nil, 2, nil},
	{3523, 10269, 1, 69, "Triangulation Point One", 3, 2, nil, 2, nil},
	{3523, 10293, 1, 69, "Hitting the Motherlode [Group]", 3, 2, nil, 2, nil},
	{3523, 10300, 1, 69, "Rebuilding the Staff", 3, 2, nil, 2, nil},
	{3523, 10301, 1, 69, "Unlocking the Compendium", 3, 2, nil, 2, nil},
	{3523, 10305, 1, 69, "Abjurist Belmara", 3, 2, nil, 2, nil},
	{3523, 10306, 1, 69, "Conjurer Luminrath", 3, 2, nil, 2, nil},
	{3523, 10307, 1, 69, "Cohlien Frostweaver", 3, 2, nil, 2, nil},
	{3523, 10312, 1, 69, "The Annals of Kirin'Var", 3, 2, nil, 2, nil},
	{3523, 10314, 1, 69, "A Lingering Suspicion", 3, 2, nil, 2, nil},
	{3523, 10316, 1, 69, "Searching for Evidence", 3, 2, nil, 2, nil},
	{3523, 10319, 1, 69, "Capturing the Phylactery", 3, 2, nil, 2, nil},
	{3523, 10320, 1, 69, "Destroy Naberius! [Group]", 3, 2, nil, 2, nil},
	{3523, 10331, 1, 69, "Indispensable Tools", 3, 2, nil, 2, nil},
	{3523, 10332, 1, 69, "Master Smith Rhonsus", 3, 2, nil, 2, nil},
	{3523, 10333, 1, 69, "Help Mama Wheeler", 3, 2, nil, 2, nil},
	{3523, 10334, 1, 69, "Needs More Cowbell", 3, 2, nil, 2, nil},
	{3523, 10337, 1, 69, "When the Cows Come Home [Group]", 3, 2, nil, 2, nil},
	{3523, 10343, 1, 69, "The Unending Invasion", 3, 2, nil, 2, nil},
	{3523, 10348, 1, 69, "New Opportunities", 3, 2, nil, 2, nil},
	{3523, 10423, 1, 69, "To the Stormspire", 3, 2, nil, 2, nil},
	{3523, 10424, 1, 69, "Diagnosis: Critical", 3, 2, nil, 2, nil},
	{3523, 10426, 1, 69, "Flora of the Eco-Domes", 3, 2, nil, 2, nil},
	{3523, 10427, 1, 69, "Creatures of the Eco-Domes", 3, 2, nil, 2, nil},
	{3523, 10429, 1, 69, "When Nature Goes Too Far", 3, 2, nil, 2, nil},
	{3523, 10430, 1, 69, "Testing the Prototype", 3, 2, nil, 2, nil},
	{3523, 10433, 1, 69, "Keeping Up Appearances", 3, 2, nil, 2, nil},
	{3523, 10434, 1, 69, "The Dynamic Duo", 3, 2, nil, 2, nil},
	{3523, 10435, 1, 69, "Retrieving the Goods", 3, 2, nil, 2, nil},
	{3523, 10436, 1, 69, "All Clear!", 3, 2, nil, 2, nil},
	{3523, 10440, 1, 69, "Success!", 3, 2, nil, 2, nil},
	{3523, 10652, 1, 69, "Behind Enemy Lines", 3, 2, nil, 2, nil},
	{3523, 10855, 1, 69, "Fel Reavers, No Thanks!", 3, 2, nil, 2, nil},
	{3523, 10856, 1, 69, "The Best Defense", 3, 2, nil, 2, nil},
	{3523, 10857, 1, 69, "Teleport This!", 3, 2, nil, 2, nil},
	{3523, 10924, 1, 69, "Bloody Imp-ossible!", 3, 2, nil, 2, nil},
	{3523, 10322, 1, 70, "Shutting Down Manaforge Duro", 4, 2, nil, 2, nil},
	{3523, 10323, 1, 70, "Shutting Down Manaforge Ara [Group]", 4, 2, nil, 2, nil},
	{3523, 10328, 1, 70, "Sunfury Briefings", 4, 2, nil, 2, nil},
	{3523, 10407, 1, 70, "Socrethar's Shadow [Group]", 4, 2, nil, 2, nil},
	{3523, 9631, 1, 70, "A Colleague's Aid", 3, 2, nil, 2, nil},
	{3523, 10202, 1, 70, "A Defector", 3, 2, nil, 2, nil},
	{3523, 10257, 1, 70, "Capturing the Keystone [Dungeon]", 3, 2, nil, 2, nil},
	{3523, 10270, 1, 70, "A Not-So-Modest Proposal", 3, 2, nil, 2, nil},
	{3523, 10271, 1, 70, "Getting Down to Business", 3, 2, nil, 2, nil},
	{3523, 10272, 1, 70, "A Promising Start", 3, 2, nil, 2, nil},
	{3523, 10273, 1, 70, "Troublesome Distractions", 3, 2, nil, 2, nil},
	{3523, 10274, 1, 70, "Securing the Celestial Ridge [Group]", 3, 2, nil, 2, nil},
	{3523, 10275, 1, 70, "Triangulation Point Two", 3, 2, nil, 2, nil},
	{3523, 10276, 1, 70, "Full Triangle [Group]", 3, 2, nil, 2, nil},
	{3523, 10281, 1, 70, "Formal Introductions", 3, 2, nil, 2, nil},
	{3523, 10290, 1, 70, "In Search of Farahlite [Group]", 3, 2, nil, 2, nil},
	{3523, 10310, 1, 70, "Sabotage the Warp-Gate! [Group]", 3, 2, nil, 2, nil},
	{3523, 10311, 1, 70, "Drijya Needs Your Help", 3, 2, nil, 2, nil},
	{3523, 10315, 1, 70, "Neutralizing the Nethermancers", 3, 2, nil, 2, nil},
	{3523, 10317, 1, 70, "Dealing with the Foreman", 3, 2, nil, 2, nil},
	{3523, 10318, 1, 70, "Dealing with the Overmaster", 3, 2, nil, 2, nil},
	{3523, 10335, 1, 70, "Surveying the Ruins", 3, 2, nil, 2, nil},
	{3523, 10336, 1, 70, "The Minions of Culuthas", 3, 2, nil, 2, nil},
	{3523, 10338, 1, 70, "Shutting Down Manaforge Duro", 3, 2, nil, 2, nil},
	{3523, 10339, 1, 70, "The Ethereum", 3, 2, nil, 2, nil},
	{3523, 10341, 1, 70, "Kick Them While They're Down", 3, 2, nil, 2, nil},
	{3523, 10345, 1, 70, "The Flesh Lies...", 3, 2, nil, 2, nil},
	{3523, 10353, 1, 70, "Arconus the Insatiable", 3, 2, nil, 2, nil},
	{3523, 10365, 1, 70, "Shutting Down Manaforge Ara [Group]", 3, 2, nil, 2, nil},
	{3523, 10380, 1, 70, "A Dark Pact", 3, 2, nil, 2, nil},
	{3523, 10381, 1, 70, "Aldor No More", 3, 2, nil, 2, nil},
	{3523, 10384, 1, 70, "Ethereum Data", 3, 2, nil, 2, nil},
	{3523, 10385, 1, 70, "Potential for Brain Damage = High", 3, 2, nil, 2, nil},
	{3523, 10405, 1, 70, "S-A-B-O-T-A-G-E", 3, 2, nil, 2, nil},
	{3523, 10406, 1, 70, "Delivering the Message", 3, 2, nil, 2, nil},
	{3523, 10408, 1, 70, "Nexus-King Salhadaar [Group]", 3, 2, nil, 2, nil},
	{3523, 10409, 1, 70, "Deathblow to the Legion [Group]", 3, 2, nil, 2, nil},
	{3523, 10410, 1, 70, "Ishanah's Help", 3, 2, nil, 2, nil},
	{3523, 10411, 1, 70, "Electro-Shock Goodness!", 3, 2, nil, 2, nil},
	{3523, 10413, 1, 70, "The Horrors of Pollution", 3, 2, nil, 2, nil},
	{3523, 10422, 1, 70, "Captain Tyralius", 3, 2, nil, 2, nil},
	{3523, 10425, 1, 70, "Escape from the Staging Grounds", 3, 2, nil, 2, nil},
	{3523, 10431, 1, 70, "Outside Assistance", 3, 2, nil, 2, nil},
	{3523, 10432, 1, 70, "Damning Evidence", 3, 2, nil, 2, nil},
	{3523, 10437, 1, 70, "Recipe for Destruction", 3, 2, nil, 2, nil},
	{3523, 10438, 1, 70, "On Nethery Wings", 3, 2, nil, 2, nil},
	{3523, 10439, 1, 70, "Dimensius the All-Devouring [Group]", 3, 2, nil, 2, nil},
	{3523, 10507, 1, 70, "Turning Point [Group]", 3, 2, nil, 2, nil},
	{3523, 10508, 1, 70, "A Gift for Voren'thal [Group]", 3, 2, nil, 2, nil},
	{3523, 10850, 2, 70, "Nether Gas In a Fel Fire Engine", 3, 2, nil, 2, nil},
	{3523, 10969, 1, 70, "Seek Out Ameer", 3, 2, nil, 2, nil},
	{3523, 10970, 1, 70, "A Mission of Mercy", 3, 2, nil, 2, nil},
	{3523, 10971, 1, 70, "Ethereum Secrets", 3, 2, nil, 2, nil},
	{3523, 10972, 5, 70, "Ethereum Prisoner I.D. Catalogue", 3, 2, nil, 2, nil},
	{3523, 10973, 1, 70, "A Thousand Worlds", 3, 2, nil, 2, nil},
	{3523, 11877, 3, 70, "Sunfury Attack Plans", 3, 2, nil, 2, nil},
	{3520, 10562, 1, 69, "Besieged!", 1, 2, nil, 2, nil},
	{3520, 10563, 1, 69, "To Legion Hold", 1, 2, nil, 2, nil},
	{3520, 10564, 1, 69, "Blast the Infernals!", 1, 2, nil, 2, nil},
	{3520, 10569, 1, 69, "The Sketh'lon Wreckage", 1, 2, nil, 2, nil},
	{3520, 10572, 1, 69, "Setting Up the Bomb", 1, 2, nil, 2, nil},
	{3520, 10573, 1, 69, "The Deathforge", 1, 2, nil, 2, nil},
	{3520, 10582, 1, 69, "Minions of the Shadow Council", 1, 2, nil, 2, nil},
	{3520, 10583, 1, 69, "The Fate of Flanis", 1, 2, nil, 2, nil},
	{3520, 10585, 1, 69, "The Summoning Chamber", 1, 2, nil, 2, nil},
	{3520, 10586, 1, 69, "Bring Down the Warbringer!", 1, 2, nil, 2, nil},
	{3520, 10589, 1, 69, "Gaining Access", 1, 2, nil, 2, nil},
	{3520, 10606, 1, 69, "The Art of Fel Reaver Maintenance", 1, 2, nil, 2, nil},
	{3520, 10612, 1, 69, "The Fel and the Furious", 1, 2, nil, 2, nil},
	{3520, 10621, 1, 69, "Illidari-Bane Shard", 1, 2, nil, 2, nil},
	{3520, 10626, 1, 69, "Capture the Weapons [Group]", 1, 2, nil, 2, nil},
	{3520, 10642, 1, 69, "A Ghost in the Machine", 1, 2, nil, 2, nil},
	{3520, 10643, 1, 69, "Harbingers of Shadowmoon", 1, 2, nil, 2, nil},
	{3520, 10661, 1, 69, "Spleendid!", 1, 2, nil, 2, nil},
	{3520, 10662, 1, 69, "The Hermit Smith", 1, 2, nil, 2, nil},
	{3520, 10677, 1, 69, "The Second Course...", 1, 2, nil, 2, nil},
	{3520, 10703, 1, 69, "Put On Yer Kneepads...", 1, 2, nil, 2, nil},
	{3520, 10759, 1, 69, "Find the Deserter", 1, 2, nil, 2, nil},
	{3520, 10766, 1, 69, "Invasion Point: Cataclysm", 1, 2, nil, 2, nil},
	{3520, 10595, 1, 69, "Besieged!", 2, 2, nil, 2, nil},
	{3520, 10596, 1, 69, "To Legion Hold", 2, 2, nil, 2, nil},
	{3520, 10597, 1, 69, "Setting Up the Bomb", 2, 2, nil, 2, nil},
	{3520, 10598, 1, 69, "Blast the Infernals!", 2, 2, nil, 2, nil},
	{3520, 10599, 1, 69, "The Deathforge", 2, 2, nil, 2, nil},
	{3520, 10600, 1, 69, "Minions of the Shadow Council", 2, 2, nil, 2, nil},
	{3520, 10601, 1, 69, "The Fate of Kagrosh", 2, 2, nil, 2, nil},
	{3520, 10602, 1, 69, "The Summoning Chamber", 2, 2, nil, 2, nil},
	{3520, 10603, 1, 69, "Bring Down the Warbringer!", 2, 2, nil, 2, nil},
	{3520, 10604, 1, 69, "Gaining Access", 2, 2, nil, 2, nil},
	{3520, 10611, 1, 69, "The Art of Fel Reaver Maintenance", 2, 2, nil, 2, nil},
	{3520, 10613, 1, 69, "The Fel and the Furious", 2, 2, nil, 2, nil},
	{3520, 10623, 1, 69, "Illidari-Bane Shard", 2, 2, nil, 2, nil},
	{3520, 10624, 1, 69, "A Haunted History", 2, 2, nil, 2, nil},
	{3520, 10625, 1, 69, "Spectrecles", 2, 2, nil, 2, nil},
	{3520, 10627, 1, 69, "Capture the Weapons [Group]", 2, 2, nil, 2, nil},
	{3520, 10660, 1, 69, "What Strange Creatures...", 2, 2, nil, 2, nil},
	{3520, 10663, 1, 69, "The Hermit Smith", 2, 2, nil, 2, nil},
	{3520, 10672, 1, 69, "Frankly, It Makes No Sense...", 2, 2, nil, 2, nil},
	{3520, 10702, 1, 69, "A Grunt's Work...", 2, 2, nil, 2, nil},
	{3520, 10760, 1, 69, "The Sketh'lon Wreckage", 2, 2, nil, 2, nil},
	{3520, 10761, 1, 69, "Find the Deserter", 2, 2, nil, 2, nil},
	{3520, 10767, 1, 69, "Invasion Point: Cataclysm", 2, 2, nil, 2, nil},
	{3520, 10664, 1, 69, "Additional Materials", 3, 2, nil, 2, nil},
	{3520, 10665, 1, 69, "Fresh from the Mechanar [Dungeon]", 3, 2, nil, 2, nil},
	{3520, 10666, 1, 69, "The Lexicon Demonica [Dungeon]", 3, 2, nil, 2, nil},
	{3520, 10777, 1, 69, "Asghar's Totem", 3, 2, nil, 2, nil},
	{3520, 10778, 1, 69, "The Rod of Lianthe", 3, 2, nil, 2, nil},
	{3520, 10780, 1, 69, "Sketh'lon Feathers", 3, 2, nil, 2, nil},
	{3520, 10782, 1, 69, "Imbuing the Headpiece", 3, 2, nil, 2, nil},
	{3520, 10808, 1, 69, "Thwart the Dark Conclave", 3, 2, nil, 2, nil},
	{3520, 13429, 1, 70, "A Distraction for Akama", 4, 2, nil, 2, nil},
	{3520, 10644, 1, 70, "Teron Gorefiend - Lore and Legend", 1, 2, nil, 2, nil},
	{3520, 10645, 1, 70, "Teron Gorefiend, I am...", 1, 2, nil, 2, nil},
	{3520, 10648, 1, 70, "Wanted: Uvuros, Scourge of Shadowmoon [Group]", 1, 2, nil, 2, nil},
	{3520, 10678, 1, 70, "The Main Course!", 1, 2, nil, 2, nil},
	{3520, 10680, 1, 70, "The Hand of Gul'dan", 1, 2, nil, 2, nil},
	{3520, 10744, 1, 70, "News of Victory", 1, 2, nil, 2, nil},
	{3520, 10772, 1, 70, "The Path of Conquest [Group]", 1, 2, nil, 2, nil},
	{3520, 10773, 1, 70, "Breaching the Path [Group]", 1, 2, nil, 2, nil},
	{3520, 10774, 1, 70, "Blood Elf + Giant = ??? [Group]", 1, 2, nil, 2, nil},
	{3520, 10775, 1, 70, "Tabards of the Illidari [Group]", 1, 2, nil, 2, nil},
	{3520, 10776, 1, 70, "Dissension Amongst the Ranks... [Group]", 1, 2, nil, 2, nil},
	{3520, 11497, 1, 70, "Learning to Fly", 1, 2, nil, 2, nil},
	{3520, 10633, 1, 70, "Teron Gorefiend - Lore and Legend", 2, 2, nil, 2, nil},
	{3520, 10639, 1, 70, "Teron Gorefiend, I am...", 2, 2, nil, 2, nil},
	{3520, 10647, 1, 70, "Wanted: Uvuros, Scourge of Shadowmoon [Group]", 2, 2, nil, 2, nil},
	{3520, 10673, 1, 70, "Felspine the Greater", 2, 2, nil, 2, nil},
	{3520, 10681, 1, 70, "The Hand of Gul'dan", 2, 2, nil, 2, nil},
	{3520, 10683, 1, 70, "Tablets of Baa'ri", 2, 2, nil, 2, nil},
	{3520, 10684, 1, 70, "Oronu the Elder", 2, 2, nil, 2, nil},
	{3520, 10685, 1, 70, "The Ashtongue Corruptors", 2, 2, nil, 2, nil},
	{3520, 10686, 1, 70, "The Warden's Cage", 2, 2, nil, 2, nil},
	{3520, 10745, 1, 70, "News of Victory", 2, 2, nil, 2, nil},
	{3520, 10750, 1, 70, "The Path of Conquest [Group]", 2, 2, nil, 2, nil},
	{3520, 10751, 1, 70, "Breaching the Path [Group]", 2, 2, nil, 2, nil},
	{3520, 10765, 1, 70, "When Worlds Collide... [Group]", 2, 2, nil, 2, nil},
	{3520, 10768, 1, 70, "Tabards of the Illidari [Group]", 2, 2, nil, 2, nil},
	{3520, 10769, 1, 70, "Dissension Amongst the Ranks... [Group]", 2, 2, nil, 2, nil},
	{3520, 10824, 1, 70, "Sunfury Signets", 2, 2, nil, 2, nil},
	{3520, 11019, 5, 70, "Your Friend On The Inside", 2, 2, nil, 2, nil},
	{3520, 11020, 3, 70, "A Slow Death", 2, 2, nil, 2, nil},
	{3520, 11035, 3, 70, "The Not-So-Friendly Skies...", 2, 2, nil, 2, nil},
	{3520, 11049, 1, 70, "The Great Netherwing Egg Hunt", 2, 2, nil, 2, nil},
	{3520, 11050, 2, 70, "Accepting All Eggs", 2, 2, nil, 2, nil},
	{3520, 11083, 1, 70, "Crazed and Confused", 2, 2, nil, 2, nil},
	{3520, 11094, 1, 70, "Kill Them All!", 2, 2, nil, 2, nil},
	{3520, 11095, 1, 70, "Commander Hobb", 2, 2, nil, 2, nil},
	{3520, 11097, 3, 70, "The Deadliest Trap Ever Laid [Group]", 2, 2, nil, 2, nil},
	{3520, 11498, 1, 70, "Learning to Fly", 2, 2, nil, 2, nil},
	{3520, 10451, 1, 70, "Escape from Coilskar Cistern [Group]", 3, 2, nil, 2, nil},
	{3520, 10458, 1, 70, "Enraged Spirits of Fire and Earth", 3, 2, nil, 2, nil},
	{3520, 10480, 1, 70, "Enraged Spirits of Water", 3, 2, nil, 2, nil},
	{3520, 10481, 1, 70, "Enraged Spirits of Air", 3, 2, nil, 2, nil},
	{3520, 10513, 1, 70, "Oronok Torn-heart", 3, 2, nil, 2, nil},
	{3520, 10514, 1, 70, "I Was A Lot Of Things...", 3, 2, nil, 2, nil},
	{3520, 10515, 1, 70, "A Lesson Learned", 3, 2, nil, 2, nil},
	{3520, 10519, 1, 70, "The Cipher of Damnation - Truth and History", 3, 2, nil, 2, nil},
	{3520, 10521, 1, 70, "Grom'tor, Son of Oronok", 3, 2, nil, 2, nil},
	{3520, 10522, 1, 70, "The Cipher of Damnation - Grom'tor's Charge", 3, 2, nil, 2, nil},
	{3520, 10523, 1, 70, "The Cipher of Damnation - The First Fragment Recovered", 3, 2, nil, 2, nil},
	{3520, 10527, 1, 70, "Ar'tor, Son of Oronok", 3, 2, nil, 2, nil},
	{3520, 10528, 1, 70, "Demonic Crystal Prisons", 3, 2, nil, 2, nil},
	{3520, 10537, 1, 70, "Lohn'goron, Bow of the Torn-heart", 3, 2, nil, 2, nil},
	{3520, 10540, 1, 70, "The Cipher of Damnation - Ar'tor's Charge", 3, 2, nil, 2, nil},
	{3520, 10541, 1, 70, "The Cipher of Damnation - The Second Fragment Recovered", 3, 2, nil, 2, nil},
	{3520, 10546, 1, 70, "Borak, Son of Oronok", 3, 2, nil, 2, nil},
	{3520, 10547, 1, 70, "Of Thistleheads and Eggs...", 3, 2, nil, 2, nil},
	{3520, 10550, 1, 70, "The Bundle of Bloodthistle", 3, 2, nil, 2, nil},
	{3520, 10568, 1, 70, "Tablets of Baa'ri", 3, 2, nil, 2, nil},
	{3520, 10570, 1, 70, "To Catch A Thistlehead", 3, 2, nil, 2, nil},
	{3520, 10571, 1, 70, "Oronu the Elder", 3, 2, nil, 2, nil},
	{3520, 10574, 1, 70, "The Ashtongue Corruptors", 3, 2, nil, 2, nil},
	{3520, 10575, 1, 70, "The Warden's Cage", 3, 2, nil, 2, nil},
	{3520, 10576, 1, 70, "The Shadowmoon Shuffle", 3, 2, nil, 2, nil},
	{3520, 10577, 1, 70, "What Illidan Wants, Illidan Gets...", 3, 2, nil, 2, nil},
	{3520, 10578, 1, 70, "The Cipher of Damnation - Borak's Charge [Group]", 3, 2, nil, 2, nil},
	{3520, 10579, 1, 70, "The Cipher of Damnation - The Third Fragment Recovered", 3, 2, nil, 2, nil},
	{3520, 10587, 1, 70, "Karabor Training Grounds", 3, 2, nil, 2, nil},
	{3520, 10588, 1, 70, "The Cipher of Damnation [Group]", 3, 2, nil, 2, nil},
	{3520, 10619, 1, 70, "The Ashtongue Tribe", 3, 2, nil, 2, nil},
	{3520, 10622, 1, 70, "Proof of Allegiance", 3, 2, nil, 2, nil},
	{3520, 10628, 1, 70, "Akama", 3, 2, nil, 2, nil},
	{3520, 10634, 1, 70, "Divination: Gorefiend's Armor [Group]", 3, 2, nil, 2, nil},
	{3520, 10635, 1, 70, "Divination: Gorefiend's Cloak", 3, 2, nil, 2, nil},
	{3520, 10636, 1, 70, "Divination: Gorefiend's Truncheon [Group]", 3, 2, nil, 2, nil},
	{3520, 10637, 1, 70, "A Necessary Distraction", 3, 2, nil, 2, nil},
	{3520, 10650, 1, 70, "Return to the Aldor", 3, 2, nil, 2, nil},
	{3520, 10651, 1, 70, "Varedis Must Be Stopped [Group]", 3, 2, nil, 2, nil},
	{3520, 10667, 1, 70, "Underworld Loam [Dungeon]", 3, 2, nil, 2, nil},
	{3520, 10670, 1, 70, "Tear of the Earthmother [Dungeon]", 3, 2, nil, 2, nil},
	{3520, 10676, 1, 70, "Bane of the Illidari", 3, 2, nil, 2, nil},
	{3520, 10679, 1, 70, "Quenching the Blade", 3, 2, nil, 2, nil},
	{3520, 10687, 1, 70, "Karabor Training Grounds", 3, 2, nil, 2, nil},
	{3520, 10688, 1, 70, "A Necessary Distraction", 3, 2, nil, 2, nil},
	{3520, 10691, 1, 70, "Return to the Scryers", 3, 2, nil, 2, nil},
	{3520, 10692, 1, 70, "Varedis Must Be Stopped [Group]", 3, 2, nil, 2, nil},
	{3520, 10706, 1, 70, "A Mysterious Portent", 3, 2, nil, 2, nil},
	{3520, 10707, 1, 70, "The Ata'mal Terrace [Group]", 3, 2, nil, 2, nil},
	{3520, 10708, 1, 70, "Akama's Promise", 3, 2, nil, 2, nil},
	{3520, 10781, 1, 70, "Battle of the Crimson Watch [Group]", 3, 2, nil, 2, nil},
	{3520, 10793, 1, 70, "The Journal of Val'zareq: Portends of War [Group]", 3, 2, nil, 2, nil},
	{3520, 10804, 1, 70, "Kindness", 3, 2, nil, 2, nil},
	{3520, 10807, 1, 70, "The Ashtongue Broken", 3, 2, nil, 2, nil},
	{3520, 10811, 1, 70, "Seek Out Neltharaku", 3, 2, nil, 2, nil},
	{3520, 10814, 1, 70, "Neltharaku's Tale", 3, 2, nil, 2, nil},
	{3520, 10816, 1, 70, "Reclaiming Holy Grounds", 3, 2, nil, 2, nil},
	{3520, 10817, 1, 70, "The Great Retribution", 3, 2, nil, 2, nil},
	{3520, 10822, 2, 70, "Single Sunfury Signet", 3, 2, nil, 2, nil},
	{3520, 10823, 2, 70, "More Sunfury Signets", 3, 2, nil, 2, nil},
	{3520, 10826, 1, 70, "Marks of Sargeras", 3, 2, nil, 2, nil},
	{3520, 10827, 2, 70, "More Marks of Sargeras", 3, 2, nil, 2, nil},
	{3520, 10828, 2, 70, "Single Mark of Sargeras", 3, 1, "SHAMAN", 1, "ORC"},
	{3520, 10836, 1, 70, "Infiltrating Dragonmaw Fortress", 3, 2, nil, 2, nil},
	{3520, 10837, 1, 70, "To Netherwing Ledge!", 3, 2, nil, 2, nil},
	{3520, 10854, 1, 70, "The Force of Neltharaku", 3, 2, nil, 2, nil},
	{3520, 10858, 1, 70, "Karynaku [Group]", 3, 2, nil, 2, nil},
	{3520, 10866, 1, 70, "Zuluhed the Whacked [Group]", 3, 2, nil, 2, nil},
	{3520, 10870, 1, 70, "Ally of the Netherwing", 3, 2, nil, 2, nil},
	{3520, 10944, 1, 70, "The Secret Compromised", 3, 2, nil, 2, nil},
	{3520, 10949, 1, 70, "Entry Into the Black Temple", 3, 2, nil, 2, nil},
	{3520, 10985, 1, 70, "A Distraction for Akama", 3, 2, nil, 2, nil},
	{3520, 11012, 5, 70, "Blood Oath of the Netherwing", 3, 2, nil, 2, nil},
	{3520, 11013, 1, 70, "In Service of the Illidari", 3, 2, nil, 2, nil},
	{3520, 11014, 1, 70, "Enter the Taskmaster", 3, 2, nil, 2, nil},
	{3520, 11015, 3, 70, "Netherwing Crystals", 3, 2, nil, 2, nil},
	{3520, 11016, 3, 70, "Nethermine Flayer Hide", 3, 2, nil, 2, nil},
	{3520, 11017, 3, 70, "Netherdust Pollen", 3, 2, nil, 2, nil},
	{3520, 11018, 3, 70, "Nethercite Ore", 3, 2, nil, 2, nil},
	{3520, 11041, 1, 70, "A Job Unfinished... [Group]", 3, 2, nil, 2, nil},
	{3520, 11053, 1, 70, "Rise, Overseer!", 3, 2, nil, 2, nil},
	{3520, 11054, 1, 70, "Overseeing and You: Making the Right Choices", 3, 2, nil, 2, nil},
	{3520, 11055, 3, 70, "The Booterang: A Cure For The Common Worthless Peon", 3, 2, nil, 2, nil},
	{3520, 11063, 5, 70, "Earning Your Wings...", 3, 2, nil, 2, nil},
	{3520, 11064, 1, 70, "Dragonmaw Race: The Ballad of Oldie McOld", 3, 2, nil, 2, nil},
	{3520, 11067, 1, 70, "Dragonmaw Race: Trope the Filth-Belcher", 3, 2, nil, 2, nil},
	{3520, 11068, 1, 70, "Dragonmaw Race: Corlok the Vet", 3, 2, nil, 2, nil},
	{3520, 11069, 1, 70, "Dragonmaw Race: Wing Commander Ichman", 3, 2, nil, 2, nil},
	{3520, 11070, 1, 70, "Dragonmaw Race: Wing Commander Mulverick", 3, 2, nil, 2, nil},
	{3520, 11071, 1, 70, "Dragonmaw Race: Captain Skyshatter", 3, 2, nil, 2, nil},
	{3520, 11075, 1, 70, "The Netherwing Mines", 3, 2, nil, 2, nil},
	{3520, 11076, 3, 70, "Picking Up The Pieces...", 3, 2, nil, 2, nil},
	{3520, 11077, 3, 70, "Dragons are the Least of Our Problems", 3, 2, nil, 2, nil},
	{3520, 11081, 1, 70, "The Great Murkblood Revolt", 3, 2, nil, 2, nil},
	{3520, 11082, 1, 70, "Seeker of Truth", 3, 2, nil, 2, nil},
	{3520, 11084, 1, 70, "Stand Tall, Captain!", 3, 2, nil, 2, nil},
	{3520, 11086, 3, 70, "Disrupting the Twilight Portal", 3, 2, nil, 2, nil},
	{3520, 11089, 1, 70, "The Soul Cannon of Reth'hedron", 3, 2, nil, 2, nil},
	{3520, 11090, 1, 70, "Subdue the Subduer", 3, 2, nil, 2, nil},
	{3520, 11092, 1, 70, "Hail, Commander!", 3, 2, nil, 2, nil},
	{3520, 11099, 1, 70, "Kill Them All!", 3, 2, nil, 2, nil},
	{3520, 11100, 1, 70, "Commander Arcus", 3, 2, nil, 2, nil},
	{3520, 11101, 3, 70, "The Deadliest Trap Ever Laid [Group]", 3, 2, nil, 2, nil},
	{3520, 11107, 1, 70, "Bow to the Highlord", 3, 2, nil, 2, nil},
	{3520, 11108, 1, 70, "Lord Illidan Stormrage", 3, 2, nil, 2, nil},
	{3520, 11544, 3, 70, "Ata'mal Armaments", 3, 2, nil, 2, nil},
	{3703, 9979, 1, 63, "Wind Trader Lathrai", 3, 2, nil, 2, nil},
	{3703, 10017, 5, 64, "Strained Supplies", 3, 2, nil, 2, nil},
	{3703, 10019, 2, 64, "More Venom Sacs", 3, 2, nil, 2, nil},
	{3703, 10020, 1, 64, "A Cure for Zahlia [Group]", 3, 2, nil, 2, nil},
	{3703, 10021, 1, 64, "Restoring the Light", 3, 2, nil, 2, nil},
	{3703, 10024, 5, 65, "Voren'thal's Visions", 3, 2, nil, 2, nil},
	{3703, 10025, 2, 65, "More Basilisk Eyes", 3, 2, nil, 2, nil},
	{3703, 10169, 4, 65, "Losing Gracefully [Removed]", 3, 2, nil, 2, nil},
	{3703, 10211, 1, 65, "City of Light", 3, 2, nil, 2, nil},
	{3703, 10325, 1, 65, "Marks of Kil'jaeden", 3, 2, nil, 2, nil},
	{3703, 10326, 2, 65, "More Marks of Kil'jaeden", 3, 2, nil, 2, nil},
	{3703, 10327, 2, 65, "Single Mark of Kil'jaeden", 3, 2, nil, 2, nil},
	{3703, 10412, 1, 65, "Firewing Signets", 3, 2, nil, 2, nil},
	{3703, 10551, 5, 65, "Allegiance to the Aldor", 3, 2, nil, 2, nil},
	{3703, 10552, 5, 65, "Allegiance to the Scryers", 3, 2, nil, 2, nil},
	{3703, 10553, 1, 65, "Voren'thal the Seer", 3, 2, nil, 2, nil},
	{3703, 10554, 1, 65, "Ishanah", 3, 2, nil, 2, nil},
	{3703, 11045, 1, 67, "Zorus the Judicator", 1, 2, nil, 2, nil},
	{3703, 11046, 1, 67, "Chief Apothecary Hildagard", 2, 2, nil, 2, nil},
	{3703, 10231, 1, 67, "What Book? I Don't See Any Book. [Group]", 3, 2, nil, 2, nil},
	{3703, 11038, 1, 67, "Assist Exarch Orelis", 3, 2, nil, 2, nil},
	{3703, 11039, 1, 67, "Report to Spymaster Thalodien", 3, 2, nil, 2, nil},
	{3703, 11451, 1, 70, "Alicia's Poem", 1, 2, nil, 2, nil},
	{3703, 9829, 1, 70, "Khadgar", 3, 2, nil, 2, nil},
	{3703, 9832, 1, 70, "The Second and Third Fragments [Dungeon]", 3, 2, nil, 2, nil},
	{3703, 9837, 1, 70, "Return to Khadgar", 3, 2, nil, 2, nil},
	{3703, 10280, 1, 70, "Special Delivery to Shattrath City", 3, 2, nil, 2, nil},
	{3703, 10414, 2, 70, "Single Firewing Signet", 3, 2, nil, 2, nil},
	{3703, 10415, 2, 70, "More Firewing Signets", 3, 2, nil, 2, nil},
	{3703, 10416, 5, 70, "Synthesis of Power", 3, 2, nil, 2, nil},
	{3703, 10419, 2, 70, "Arcane Tomes", 3, 2, nil, 2, nil},
	{3703, 10420, 5, 70, "A Cleansing Light", 3, 2, nil, 2, nil},
	{3703, 10421, 2, 70, "Fel Armaments", 3, 2, nil, 2, nil},
	{3703, 10509, 1, 70, "Bound for Glory", 3, 2, nil, 2, nil},
	{3703, 10653, 1, 70, "Marks of Sargeras", 3, 2, nil, 2, nil},
	{3703, 10654, 2, 70, "More Marks of Sargeras", 3, 2, nil, 2, nil},
	{3703, 10655, 2, 70, "Single Mark of Sargeras", 3, 2, nil, 2, nil},
	{3703, 10656, 1, 70, "Sunfury Signets", 3, 2, nil, 2, nil},
	{3703, 10658, 2, 70, "More Sunfury Signets", 3, 2, nil, 2, nil},
	{3703, 10659, 2, 70, "Single Sunfury Signet", 3, 2, nil, 2, nil},
	{3703, 10883, 1, 70, "The Tempest Key", 3, 2, nil, 2, nil},
	{3703, 10884, 1, 70, "Trial of the Naaru: Mercy [Heroic]", 3, 2, nil, 2, nil},
	{3703, 10885, 1, 70, "Trial of the Naaru: Strength [Heroic]", 3, 2, nil, 2, nil},
	{3703, 10886, 1, 70, "Trial of the Naaru: Tenacity [Heroic]", 3, 2, nil, 2, nil},
	{3703, 10948, 1, 70, "The Hostage Soul", 3, 2, nil, 2, nil},
	{3703, 10984, 1, 70, "Speak with the Ogre", 3, 2, nil, 2, nil},
	{3703, 11024, 1, 70, "An Ally in Lower City", 3, 2, nil, 2, nil},
	{3703, 11096, 1, 70, "Threat from Above", 3, 2, nil, 2, nil},
	{3703, 11109, 5, 70, "Jorus the Cobalt Netherwing Drake", 3, 2, nil, 2, nil},
	{3703, 11110, 5, 70, "Malfas the Purple Netherwing Drake", 3, 2, nil, 2, nil},
	{3703, 11111, 5, 70, "Onyxien the Onyx Netherwing Drake", 3, 2, nil, 2, nil},
	{3703, 11112, 5, 70, "Suraku the Azure Netherwing Drake", 3, 2, nil, 2, nil},
	{3703, 11113, 5, 70, "Voranaku the Violet Netherwing Drake", 3, 2, nil, 2, nil},
	{3703, 11114, 5, 70, "Zoya the Veridian Netherwing Drake", 3, 2, nil, 2, nil},
	{3703, 11517, 1, 70, "Report to Nasuun", 3, 2, nil, 2, nil},
	{3703, 11534, 1, 70, "Report to Nasuun", 3, 2, nil, 2, nil},
	{3703, 11875, 3, 70, "Gaining the Advantage", 3, 2, nil, 2, nil},
	{3679, 11004, 1, 70, "World of Shadows", 3, 2, nil, 2, nil},
	{3679, 11005, 1, 70, "Secrets of the Talonpriests", 3, 2, nil, 2, nil},
	{3679, 11006, 2, 70, "More Shadow Dust", 3, 2, nil, 2, nil},
	{3679, 11008, 3, 70, "Fires Over Skettis", 3, 2, nil, 2, nil},
	{3679, 11021, 1, 70, "Ishaal's Almanac", 3, 2, nil, 2, nil},
	{3679, 11028, 1, 70, "Countdown to Doom", 3, 2, nil, 2, nil},
	{3679, 11029, 1, 70, "A Shabby Disguise", 3, 2, nil, 2, nil},
	{3679, 11056, 1, 70, "Hazzik's Bargain", 3, 2, nil, 2, nil},
	{3679, 11072, 1, 70, "Adversarial Blood [Group]", 3, 2, nil, 2, nil},
	{3679, 11073, 1, 70, "Terokk's Downfall [Group]", 3, 2, nil, 2, nil},
	{3679, 11085, 3, 70, "Escape from Skettis", 3, 2, nil, 2, nil},
	{3679, 11093, 1, 70, "Hungry Nether Rays", 3, 2, nil, 2, nil},
	{3679, 11098, 1, 70, "To Skettis!", 3, 2, nil, 2, nil},
	{3679, 11885, 1, 70, "Adversarial Blood [Group]", 3, 2, nil, 2, nil},
	{3519, 11505, 3, 0, "Spirits of Auchindoun [PvP]", 1, 2, nil, 2, nil},
	{3519, 11506, 3, 0, "Spirits of Auchindoun [PvP]", 2, 2, nil, 2, nil},
	{3519, 10869, 1, 62, "Thin the Flock", 1, 2, nil, 2, nil},
	{3519, 10868, 1, 62, "Arakkoa War Path", 2, 2, nil, 2, nil},
	{3519, 10847, 1, 62, "The Eyes of Skettis", 3, 2, nil, 2, nil},
	{3519, 9961, 1, 63, "What's Wrong at Cenarion Thicket?", 1, 2, nil, 2, nil},
	{3519, 9992, 1, 63, "Olemba Seeds", 1, 2, nil, 2, nil},
	{3519, 9998, 1, 63, "Unruly Neighbors", 1, 2, nil, 2, nil},
	{3519, 10005, 1, 63, "Letting Earthbinder Tavgren Know", 1, 2, nil, 2, nil},
	{3519, 10028, 1, 63, "Vessels of Power", 1, 2, nil, 2, nil},
	{3519, 10863, 1, 63, "Secrets of the Arakkoa", 1, 2, nil, 2, nil},
	{3519, 9960, 1, 63, "What's Wrong at Cenarion Thicket?", 2, 2, nil, 2, nil},
	{3519, 9993, 1, 63, "Olemba Seed Oil", 2, 2, nil, 2, nil},
	{3519, 10000, 1, 63, "An Unwelcome Presence", 2, 2, nil, 2, nil},
	{3519, 10006, 1, 63, "Letting Earthbinder Tavgren Know", 2, 2, nil, 2, nil},
	{3519, 10862, 1, 63, "Surrender to the Horde", 2, 2, nil, 2, nil},
	{3519, 9957, 1, 63, "What's Wrong at Cenarion Thicket?", 3, 2, nil, 2, nil},
	{3519, 9968, 1, 63, "Strange Energy", 3, 2, nil, 2, nil},
	{3519, 9971, 1, 63, "Clues in the Thicket", 3, 2, nil, 2, nil},
	{3519, 9978, 1, 63, "By Any Means Necessary", 3, 2, nil, 2, nil},
	{3519, 10849, 1, 63, "Seek Out Kirrik", 3, 2, nil, 2, nil},
	{3519, 10878, 1, 63, "Before Darkness Falls", 3, 2, nil, 2, nil},
	{3519, 10908, 1, 63, "Speak with Rilak the Redeemed", 3, 2, nil, 2, nil},
	{3519, 9986, 1, 64, "Stymying the Arakkoa", 1, 2, nil, 2, nil},
	{3519, 9994, 1, 64, "What Are These Things?", 1, 2, nil, 2, nil},
	{3519, 9996, 1, 64, "Attack on Firewing Point", 1, 2, nil, 2, nil},
	{3519, 10002, 1, 64, "The Firewing Liaison", 1, 2, nil, 2, nil},
	{3519, 10007, 1, 64, "Thinning the Ranks", 1, 2, nil, 2, nil},
	{3519, 10012, 1, 64, "Fel Orc Plans", 1, 2, nil, 2, nil},
	{3519, 10016, 1, 64, "Timber Worg Tails", 1, 2, nil, 2, nil},
	{3519, 10022, 1, 64, "The Elusive Ironjaw", 1, 2, nil, 2, nil},
	{3519, 10026, 1, 64, "Magical Disturbances", 1, 2, nil, 2, nil},
	{3519, 10038, 1, 64, "Speak with Private Weeks", 1, 2, nil, 2, nil},
	{3519, 10051, 1, 64, "Escape from Firewing Point! [Group]", 1, 2, nil, 2, nil},
	{3519, 10444, 1, 64, "Report to the Allerian Post", 1, 2, nil, 2, nil},
	{3519, 9987, 1, 64, "Stymying the Arakkoa", 2, 2, nil, 2, nil},
	{3519, 9995, 1, 64, "What Are These Things?", 2, 2, nil, 2, nil},
	{3519, 9997, 1, 64, "Attack on Firewing Point", 2, 2, nil, 2, nil},
	{3519, 10003, 1, 64, "The Firewing Liaison", 2, 2, nil, 2, nil},
	{3519, 10008, 1, 64, "What Happens in Terokkar Stays in Terokkar", 2, 2, nil, 2, nil},
	{3519, 10013, 1, 64, "An Unseen Hand", 2, 2, nil, 2, nil},
	{3519, 10018, 1, 64, "Vestments of the Wolf Spirit", 2, 2, nil, 2, nil},
	{3519, 10023, 1, 64, "Patriarch Ironjaw", 2, 2, nil, 2, nil},
	{3519, 10027, 1, 64, "Magical Disturbances", 2, 2, nil, 2, nil},
	{3519, 10039, 1, 64, "Speak with Scout Neftis", 2, 2, nil, 2, nil},
	{3519, 10052, 1, 64, "Escape from Firewing Point! [Group]", 2, 2, nil, 2, nil},
	{3519, 10448, 1, 64, "Report to Stonebreaker Camp", 2, 2, nil, 2, nil},
	{3519, 10791, 1, 64, "Welcoming the Wolf Spirit", 2, 2, nil, 2, nil},
	{3519, 9951, 1, 64, "It's Watching You!", 3, 2, nil, 2, nil},
	{3519, 9990, 1, 64, "Investigate Tuurem", 3, 2, nil, 2, nil},
	{3519, 10037, 1, 64, "Rather Be Fishin'", 3, 2, nil, 2, nil},
	{3519, 10112, 1, 64, "A Personal Favor", 3, 2, nil, 2, nil},
	{3519, 10839, 1, 64, "Veil Skith: Darkstone of Terokk", 3, 2, nil, 2, nil},
	{3519, 10848, 1, 64, "Veil Rhaze: Unliving Evil", 3, 2, nil, 2, nil},
	{3519, 10852, 1, 64, "Missing Friends", 3, 2, nil, 2, nil},
	{3519, 10861, 1, 64, "Veil Lithic: Preemptive Strike", 3, 2, nil, 2, nil},
	{3519, 10880, 1, 64, "Cabal Orders", 3, 2, nil, 2, nil},
	{3519, 10881, 1, 64, "The Shadow Tomb", 3, 2, nil, 2, nil},
	{3519, 10887, 1, 64, "Escaping the Tomb", 3, 2, nil, 2, nil},
	{3519, 10033, 1, 65, "Wanted: Bonelashers Dead!", 1, 2, nil, 2, nil},
	{3519, 10035, 1, 65, "Torgos! [Group]", 1, 2, nil, 2, nil},
	{3519, 10040, 1, 65, "Who Are They?", 1, 2, nil, 2, nil},
	{3519, 10042, 1, 65, "Kill the Shadow Council!", 1, 2, nil, 2, nil},
	{3519, 10446, 1, 65, "The Final Code", 1, 2, nil, 2, nil},
	{3519, 9888, 1, 65, "The Impotent Leader", 2, 2, nil, 2, nil},
	{3519, 9889, 1, 65, "Don't Kill the Fat One", 2, 2, nil, 2, nil},
	{3519, 9890, 1, 65, "Success!", 2, 2, nil, 2, nil},
	{3519, 10034, 1, 65, "Wanted: Bonelashers Dead!", 2, 2, nil, 2, nil},
	{3519, 10036, 1, 65, "Torgos! [Group]", 2, 2, nil, 2, nil},
	{3519, 10041, 1, 65, "Who Are They?", 2, 2, nil, 2, nil},
	{3519, 10043, 1, 65, "Kill the Shadow Council!", 2, 2, nil, 2, nil},
	{3519, 10201, 1, 65, "And Now, the Moment of Truth", 2, 2, nil, 2, nil},
	{3519, 10447, 1, 65, "The Final Code", 2, 2, nil, 2, nil},
	{3519, 10920, 1, 65, "For the Fallen", 2, 2, nil, 2, nil},
	{3519, 10921, 1, 65, "Terokkarantula [Group]", 2, 2, nil, 2, nil},
	{3519, 10926, 1, 65, "Return to Sha'tari Base Camp", 2, 2, nil, 2, nil},
	{3519, 10030, 1, 65, "Recover the Bones", 3, 2, nil, 2, nil},
	{3519, 10031, 1, 65, "Helping the Lost Find Their Way", 3, 2, nil, 2, nil},
	{3519, 10210, 1, 65, "A'dal", 3, 2, nil, 2, nil},
	{3519, 10840, 1, 65, "The Tomb of Lights", 3, 2, nil, 2, nil},
	{3519, 10842, 1, 65, "Vengeful Souls", 3, 2, nil, 2, nil},
	{3519, 10873, 1, 65, "Taken in the Night", 3, 2, nil, 2, nil},
	{3519, 10874, 1, 65, "Veil Shalas: Signal Fires", 3, 2, nil, 2, nil},
	{3519, 10879, 1, 65, "The Skettis Offensive [Group]", 3, 2, nil, 2, nil},
	{3519, 10889, 1, 65, "Return to Shattrath", 3, 2, nil, 2, nil},
	{3519, 10896, 1, 65, "The Infested Protectors", 3, 2, nil, 2, nil},
	{3519, 10898, 1, 65, "Skywing [Group]", 3, 2, nil, 2, nil},
	{3519, 10913, 1, 65, "An Improper Burial", 3, 2, nil, 2, nil},
	{3519, 10914, 1, 65, "A Hero Is Needed", 3, 2, nil, 2, nil},
	{3519, 10915, 1, 65, "The Fallen Exarch", 3, 2, nil, 2, nil},
	{3519, 10917, 1, 65, "The Outcast's Plight", 3, 2, nil, 2, nil},
	{3519, 10918, 2, 65, "More Feathers", 3, 2, nil, 2, nil},
	{3519, 10922, 1, 65, "Digging Through Bones [Group]", 3, 2, nil, 2, nil},
	{3519, 10923, 1, 65, "Evil Draws Near [Group]", 3, 2, nil, 2, nil},
	{3519, 10929, 1, 65, "Fumping [Group]", 3, 2, nil, 2, nil},
	{3519, 10930, 1, 65, "The Big Bone Worm [Group]", 3, 2, nil, 2, nil},
	{3519, 10877, 1, 66, "The Dread Relic", 3, 2, nil, 2, nil},
	{3519, 10227, 1, 67, "I See Dead Draenei", 3, 2, nil, 2, nil},
	{3519, 10228, 1, 67, "Ezekiel", 3, 2, nil, 2, nil},
	{3519, 10009, 1, 68, "Crackin' Some Skulls [Group]", 3, 2, nil, 2, nil},
	{3519, 10010, 1, 68, "It's Just That Easy? [Group]", 3, 2, nil, 2, nil},
	{3519, 10180, 1, 69, "Can't Stay Away", 3, 2, nil, 2, nil},
	{3519, 11074, 5, 70, "Tokens of the Descendants", 3, 2, nil, 2, nil},
	{3519, 11520, 3, 70, "Discovering Your Roots", 3, 2, nil, 2, nil},
	{3519, 11521, 3, 70, "Rediscovering Your Roots", 3, 2, nil, 2, nil},
	{3521, 9773, 5, 61, "No More Mushrooms!", 2, 2, nil, 2, nil},
	{3521, 9777, 1, 62, "Fulgor Spores", 1, 2, nil, 2, nil},
	{3521, 9780, 1, 62, "Umbrafen Eel Filets", 1, 2, nil, 2, nil},
	{3521, 9781, 1, 62, "Too Many Mouths to Feed", 1, 2, nil, 2, nil},
	{3521, 9782, 1, 62, "The Dead Mire", 1, 2, nil, 2, nil},
	{3521, 9783, 1, 62, "An Unnatural Drought", 1, 2, nil, 2, nil},
	{3521, 9786, 1, 62, "The Boha'mu Ruins", 1, 2, nil, 2, nil},
	{3521, 9787, 1, 62, "Idols of the Feralfen", 1, 2, nil, 2, nil},
	{3521, 9790, 1, 62, "Diaphanous Wings", 1, 2, nil, 2, nil},
	{3521, 9791, 1, 62, "Menacing Marshfangs", 1, 2, nil, 2, nil},
	{3521, 9793, 1, 62, "The Fate of Tuurem", 1, 2, nil, 2, nil},
	{3521, 9801, 1, 62, "Gathering the Reagents", 1, 2, nil, 2, nil},
	{3521, 9803, 1, 62, "Messenger to the Feralfen", 1, 2, nil, 2, nil},
	{3521, 9827, 1, 62, "Withered Basidium", 1, 2, nil, 2, nil},
	{3521, 9896, 1, 62, "Blacksting's Bane", 1, 2, nil, 2, nil},
	{3521, 9901, 1, 62, "Unfinished Business", 1, 2, nil, 2, nil},
	{3521, 10104, 1, 62, "Concerns About Tuurem", 1, 2, nil, 2, nil},
	{3521, 10355, 1, 62, "Withered Flesh", 1, 2, nil, 2, nil},
	{3521, 9769, 1, 62, "There's No Explanation for Fashion", 2, 2, nil, 2, nil},
	{3521, 9770, 1, 62, "Menacing Marshfangs", 2, 2, nil, 2, nil},
	{3521, 9771, 1, 62, "Searching for Scout Jyoba", 2, 2, nil, 2, nil},
	{3521, 9772, 1, 62, "Jyoba's Report", 2, 2, nil, 2, nil},
	{3521, 9774, 1, 62, "Thick Hydra Scales", 2, 2, nil, 2, nil},
	{3521, 9775, 1, 62, "Report to Shadow Hunter Denjai", 2, 2, nil, 2, nil},
	{3521, 9796, 1, 62, "News from Zangarmarsh", 2, 2, nil, 2, nil},
	{3521, 9828, 1, 62, "Withered Basidium", 2, 2, nil, 2, nil},
	{3521, 9846, 1, 62, "Spirits of the Feralfen", 2, 2, nil, 2, nil},
	{3521, 9898, 1, 62, "Nothin' Says Lovin' Like a Big Stinger", 2, 2, nil, 2, nil},
	{3521, 9899, 1, 62, "A Job Undone", 2, 2, nil, 2, nil},
	{3521, 10105, 1, 62, "News for Rakoria", 2, 2, nil, 2, nil},
	{3521, 9747, 1, 62, "The Umbrafen Tribe", 3, 2, nil, 2, nil},
	{3521, 9788, 1, 62, "A Damp, Dark Place", 3, 2, nil, 2, nil},
	{3521, 9894, 1, 62, "Safeguarding the Watchers [Group]", 3, 2, nil, 2, nil},
	{3521, 9895, 1, 62, "The Dying Balance [Group]", 3, 2, nil, 2, nil},
	{3521, 9912, 1, 62, "The Cenarion Expedition", 3, 2, nil, 2, nil},
	{3521, 10096, 1, 62, "Saving the Sporeloks", 3, 2, nil, 2, nil},
	{3521, 9697, 1, 63, "Watcher Leesa'oh", 3, 2, nil, 2, nil},
	{3521, 9701, 1, 63, "Observing the Sporelings", 3, 2, nil, 2, nil},
	{3521, 9708, 1, 63, "Familiar Fungi", 3, 2, nil, 2, nil},
	{3521, 9716, 1, 63, "Disturbance at Umbrafen Lake", 3, 2, nil, 2, nil},
	{3521, 9718, 1, 63, "As the Crow Flies", 3, 2, nil, 2, nil},
	{3521, 9731, 1, 63, "Drain Schematics", 3, 2, nil, 2, nil},
	{3521, 9732, 1, 63, "Return to the Marsh", 3, 2, nil, 2, nil},
	{3521, 9739, 1, 63, "The Sporelings' Plight", 3, 2, nil, 2, nil},
	{3521, 9742, 2, 63, "More Spore Sacs", 3, 2, nil, 2, nil},
	{3521, 9752, 1, 63, "Escape from Umbrafen", 3, 2, nil, 2, nil},
	{3521, 9802, 5, 63, "Plants of Zangarmarsh", 3, 2, nil, 2, nil},
	{3521, 9817, 1, 63, "Leader of the Bloodscale [Group]", 3, 2, nil, 2, nil},
	{3521, 9875, 5, 63, "Uncatalogued Species", 3, 2, nil, 2, nil},
	{3521, 9776, 1, 64, "The Orebor Harborage", 1, 2, nil, 2, nil},
	{3521, 9792, 1, 64, "A Message to Telaar", 1, 2, nil, 2, nil},
	{3521, 9830, 1, 64, "Stinger Venom", 1, 2, nil, 2, nil},
	{3521, 9833, 1, 64, "Lines of Communication", 1, 2, nil, 2, nil},
	{3521, 9834, 1, 64, "Natural Armor", 1, 2, nil, 2, nil},
	{3521, 9835, 1, 64, "Ango'rosh Encroachment", 1, 2, nil, 2, nil},
	{3521, 9839, 1, 64, "Overlord Gorefist", 1, 2, nil, 2, nil},
	{3521, 9848, 1, 64, "Secrets of the Daggerfen", 1, 2, nil, 2, nil},
	{3521, 9902, 1, 64, "The Terror of Marshlight Lake", 1, 2, nil, 2, nil},
	{3521, 9905, 1, 64, "Maktu's Revenge", 1, 2, nil, 2, nil},
	{3521, 10115, 1, 64, "Daggerfen Deviance", 1, 2, nil, 2, nil},
	{3521, 10116, 1, 64, "Wanted: Chieftain Mummaki [Group]", 1, 2, nil, 2, nil},
	{3521, 9797, 1, 64, "Reinforcements for Garadar", 2, 2, nil, 2, nil},
	{3521, 9814, 1, 64, "Burstcap Mushrooms, Mon!", 2, 2, nil, 2, nil},
	{3521, 9816, 1, 64, "Have You Ever Seen One of These?", 2, 2, nil, 2, nil},
	{3521, 9820, 1, 64, "WANTED: Boss Grog'ak", 2, 2, nil, 2, nil},
	{3521, 9822, 1, 64, "Impending Attack", 2, 2, nil, 2, nil},
	{3521, 9823, 1, 64, "Us or Them", 2, 2, nil, 2, nil},
	{3521, 9841, 1, 64, "Stinging the Stingers", 2, 2, nil, 2, nil},
	{3521, 9842, 1, 64, "The Sharpest Blades", 2, 2, nil, 2, nil},
	{3521, 9845, 1, 64, "Angling to Beat the Competition", 2, 2, nil, 2, nil},
	{3521, 9847, 1, 64, "A Spirit Ally?", 2, 2, nil, 2, nil},
	{3521, 9903, 1, 64, "The Biggest of Them All", 2, 2, nil, 2, nil},
	{3521, 9904, 1, 64, "Pursuing Terrorclaw", 2, 2, nil, 2, nil},
	{3521, 10117, 1, 64, "Wanted: Chieftain Mummaki [Group]", 2, 2, nil, 2, nil},
	{3521, 10118, 1, 64, "Message to the Daggerfen", 2, 2, nil, 2, nil},
	{3521, 9702, 1, 64, "A Question of Gluttony", 3, 2, nil, 2, nil},
	{3521, 9709, 1, 64, "Stealing Back the Mushrooms", 3, 2, nil, 2, nil},
	{3521, 9720, 1, 64, "Balance Must Be Preserved", 3, 2, nil, 2, nil},
	{3521, 9724, 1, 64, "Warning the Cenarion Circle", 3, 2, nil, 2, nil},
	{3521, 9726, 1, 64, "Now That We're Friends...", 3, 2, nil, 2, nil},
	{3521, 9727, 2, 64, "Now That We're Still Friends...", 3, 2, nil, 2, nil},
	{3521, 9728, 1, 64, "A Warm Welcome", 3, 2, nil, 2, nil},
	{3521, 9730, 1, 64, "Leader of the Darkcrest [Group]", 3, 2, nil, 2, nil},
	{3521, 9743, 1, 64, "Natural Enemies", 3, 2, nil, 2, nil},
	{3521, 9744, 2, 64, "More Tendrils!", 3, 2, nil, 2, nil},
	{3521, 9778, 1, 64, "Warden Hamoot", 3, 2, nil, 2, nil},
	{3521, 9784, 2, 64, "Identify Plant Parts", 3, 2, nil, 2, nil},
	{3521, 9785, 1, 64, "Blessings of the Ancients", 3, 2, nil, 2, nil},
	{3521, 9806, 1, 64, "Fertile Spores", 3, 2, nil, 2, nil},
	{3521, 9807, 2, 64, "More Fertile Spores", 3, 2, nil, 2, nil},
	{3521, 9808, 1, 64, "Glowcap Mushrooms", 3, 2, nil, 2, nil},
	{3521, 9809, 2, 64, "More Glowcaps", 3, 2, nil, 2, nil},
	{3521, 9911, 1, 64, "The Count of the Marshes", 3, 2, nil, 2, nil},
	{3521, 9919, 1, 64, "Sporeggar", 3, 2, nil, 2, nil},
	{3521, 9729, 1, 65, "Fhwoor Smash! [Group]", 3, 2, nil, 2, nil},

	--[[

		NORTHREND - Original Version 07/11/2010;

		CHANGELOG:

		##/##/####
		None

	--]]

	{3537, 11575, 1, 71, "Nick of Time", 1, 2, nil},
	{3537, 11599, 1, 71, "Thassarian, My Brother", 1, 2, nil},
	{3537, 11600, 1, 71, "The Late William Allerton", 1, 2, nil},
	{3537, 11601, 1, 71, "Lost and Found", 1, 2, nil},
	{3537, 11603, 1, 71, "In Wine, Truth", 1, 2, nil},
	{3537, 11604, 1, 71, "A Deserter", 1, 2, nil},
	{3537, 11645, 1, 71, "Dirty, Stinkin' Snobolds!", 1, 2, nil},
	{3537, 11650, 1, 71, "Just a Few More Things...", 1, 2, nil},
	{3537, 11653, 1, 71, "Hah... You're Not So Big Now!", 1, 2, nil},
	{3537, 11658, 1, 71, "Plan B", 1, 2, nil},
	{3537, 11672, 1, 71, "Enlistment Day", 1, 2, nil},
	{3537, 11692, 1, 71, "Check in With Bixie", 1, 2, nil},
	{3537, 11693, 1, 71, "Oh Great... Plagued Magnataur!", 1, 2, nil},
	{3537, 11694, 1, 71, "There's Something Going On In Those Caves", 1, 2, nil},
	{3537, 11697, 1, 71, "Rats, Tinky Went into the Necropolis!", 1, 2, nil},
	{3537, 11698, 1, 71, "Might As Well Wipe Out the Scourge", 1, 2, nil},
	{3537, 11700, 1, 71, "Let Bixie Know", 1, 2, nil},
	{3537, 11701, 1, 71, "Back to the Airstrip", 1, 2, nil},
	{3537, 11704, 1, 71, "King Mrgl-Mrgl", 1, 2, nil},
	{3537, 11707, 1, 71, "Distress Call", 1, 2, nil},
	{3537, 11708, 1, 71, "The Mechagnomes", 1, 2, nil},
	{3537, 11710, 1, 71, "What's the Matter with the Transmatter?", 1, 2, nil},
	{3537, 11712, 1, 71, "Re-Cursive", 1, 2, nil},
	{3537, 11713, 1, 71, "Scouting the Sinkholes", 1, 2, nil},
	{3537, 11715, 1, 71, "Fueling the Project", 1, 2, nil},
	{3537, 11718, 1, 71, "A Bot in Mammoth's Clothing", 1, 2, nil},
	{3537, 11723, 1, 71, "Deploy the Shake-n-Quake!", 1, 2, nil},
	{3537, 11725, 1, 71, "Finding Pilot Tailspin", 1, 2, nil},
	{3537, 11726, 1, 71, "A Little Bit of Spice", 1, 2, nil},
	{3537, 11727, 1, 71, "A Time for Heroes", 1, 2, nil},
	{3537, 11728, 1, 71, "Lupus Pupus", 1, 2, nil},
	{3537, 11729, 1, 71, "The Ultrasonic Screwdriver", 1, 2, nil},
	{3537, 11730, 1, 71, "Master and Servant", 1, 2, nil},
	{3537, 11788, 1, 71, "Lefty Loosey, Righty Tighty", 1, 2, nil},
	{3537, 11789, 1, 71, "A Soldier in Need", 1, 2, nil},
	{3537, 11790, 1, 71, "Cultists Among Us", 1, 2, nil},
	{3537, 11791, 1, 71, "Notify Arlos", 1, 2, nil},
	{3537, 11792, 1, 71, "Enemies of the Light", 1, 2, nil},
	{3537, 11793, 1, 71, "Further Investigation", 1, 2, nil},
	{3537, 11794, 1, 71, "The Hunt is On", 1, 2, nil},
	{3537, 11795, 1, 71, "Emergency Protocol: Section 8.2, Paragraph C", 1, 2, nil},
	{3537, 11796, 1, 71, "Emergency Protocol: Section 8.2, Paragraph D", 1, 2, nil},
	{3537, 11797, 1, 71, "The Siege", 1, 2, nil},
	{3537, 11873, 1, 71, "Give Fizzcrank the News", 1, 2, nil},
	{3537, 11889, 1, 71, "Death From Above", 1, 2, nil},
	{3537, 11897, 1, 71, "Plug the Sinkholes", 1, 2, nil},
	{3537, 11901, 1, 71, "Military? What Military?", 1, 2, nil},
	{3537, 11902, 1, 71, "Pernicious Evidence", 1, 2, nil},
	{3537, 11903, 1, 71, "It's Time for Action", 1, 2, nil},
	{3537, 11904, 1, 71, "Fruits of Our Labor", 1, 2, nil},
	{3537, 11908, 1, 71, "Reference Material", 1, 2, nil},
	{3537, 11913, 1, 71, "Take No Chances", 1, 2, nil},
	{3537, 11920, 1, 71, "Cultists Among Us", 1, 2, nil},
	{3537, 11927, 1, 71, "Word on the Street", 1, 2, nil},
	{3537, 11928, 1, 71, "Farshire", 1, 2, nil},
	{3537, 11932, 1, 71, "Cowards and Fools", 1, 2, nil},
	{3537, 11956, 1, 71, "Finding the Phylactery", 1, 2, nil},
	{3537, 11962, 1, 71, "One Last Delivery", 1, 2, nil},
	{3537, 11963, 1, 71, "Weapons for Farshire", 1, 2, nil},
	{3537, 11965, 1, 71, "Call to Arms!", 1, 2, nil},
	{3537, 12035, 1, 71, "Repurposed Technology", 1, 2, nil},
	{3537, 12141, 1, 71, "A Diplomatic Mission", 1, 2, nil},
	{3537, 11574, 1, 71, "Too Close For Comfort", 2, 2, nil},
	{3537, 11585, 1, 71, "Hellscream's Vigil", 2, 2, nil},
	{3537, 11586, 1, 71, "Hellscream's Vigil", 2, 2, nil},
	{3537, 11591, 1, 71, "Report to Steeljaw's Caravan", 2, 2, nil},
	{3537, 11593, 1, 71, "The Honored Dead", 2, 2, nil},
	{3537, 11594, 1, 71, "Put Them to Rest", 2, 2, nil},
	{3537, 11595, 1, 71, "The Defense of Warsong Hold", 2, 2, nil},
	{3537, 11596, 1, 71, "The Defense of Warsong Hold", 2, 2, nil},
	{3537, 11597, 1, 71, "The Defense of Warsong Hold", 2, 2, nil},
	{3537, 11598, 1, 71, "Taking Back Mightstone Quarry", 2, 2, nil},
	{3537, 11602, 1, 71, "Cutting Off the Source", 2, 2, nil},
	{3537, 11606, 1, 71, "Patience is a Virtue that We Don't Need", 2, 2, nil},
	{3537, 11608, 1, 71, "Bury Those Cockroaches!", 2, 2, nil},
	{3537, 11611, 1, 71, "Taken by the Scourge", 2, 2, nil},
	{3537, 11614, 1, 71, "Untold Truths", 2, 2, nil},
	{3537, 11615, 1, 71, "Nerub'ar Secrets", 2, 2, nil},
	{3537, 11616, 1, 71, "Message to Hellscream", 2, 2, nil},
	{3537, 11618, 1, 71, "Reinforcements Incoming...", 2, 2, nil},
	{3537, 11624, 1, 71, "The Sky Will Know", 2, 2, nil},
	{3537, 11629, 1, 71, "Return to the Spirit Talker", 2, 2, nil},
	{3537, 11631, 1, 71, "Vision of Air", 2, 2, nil},
	{3537, 11632, 1, 71, "What the Cold Wind Brings...", 2, 2, nil},
	{3537, 11634, 1, 71, "Wind Master To'bor", 2, 2, nil},
	{3537, 11635, 1, 71, "Farseer Grimwalker's Spirit", 2, 2, nil},
	{3537, 11636, 1, 71, "Magic Carpet Ride", 2, 2, nil},
	{3537, 11638, 1, 71, "Return My Remains", 2, 2, nil},
	{3537, 11639, 1, 71, "Revenge Upon Magmoth", 2, 2, nil},
	{3537, 11642, 1, 71, "Tank Ain't Gonna Fix Itself", 2, 2, nil},
	{3537, 11643, 1, 71, "Mobu's Pneumatic Tank Transjigamarig", 2, 2, nil},
	{3537, 11644, 1, 71, "Super Strong Metal Plates!", 2, 2, nil},
	{3537, 11649, 1, 71, "Motes of the Enraged", 2, 2, nil},
	{3537, 11651, 1, 71, "Tanks a lot...", 2, 2, nil},
	{3537, 11652, 1, 71, "The Plains of Nasam", 2, 2, nil},
	{3537, 11655, 1, 71, "Into the Mist", 2, 2, nil},
	{3537, 11656, 1, 71, "Burn in Effigy", 2, 2, nil},
	{3537, 11660, 1, 71, "Horn of the Ancient Mariner", 2, 2, nil},
	{3537, 11661, 1, 71, "Orabus the Helmsman", 2, 2, nil},
	{3537, 11662, 1, 71, "Seek Out Karuk!", 2, 2, nil},
	{3537, 11664, 1, 71, "Escaping the Mist", 2, 2, nil},
	{3537, 11674, 1, 71, "Sage Highmesa is Missing", 2, 2, nil},
	{3537, 11675, 1, 71, "A Proper Death", 2, 2, nil},
	{3537, 11676, 1, 71, "Merciful Freedom", 2, 2, nil},
	{3537, 11677, 1, 71, "Stop the Plague", 2, 2, nil},
	{3537, 11678, 1, 71, "Find Bristlehorn", 2, 2, nil},
	{3537, 11683, 1, 71, "Fallen Necropolis", 2, 2, nil},
	{3537, 11684, 1, 71, "Scouting the Sinkholes", 2, 2, nil},
	{3537, 11685, 1, 71, "The Heart of the Elements", 2, 2, nil},
	{3537, 11686, 1, 71, "The Warsong Farms", 2, 2, nil},
	{3537, 11688, 1, 71, "Damned Filthy Swine", 2, 2, nil},
	{3537, 11689, 1, 71, "Return with the Bad News", 2, 2, nil},
	{3537, 11690, 1, 71, "Bring 'Em Back Alive", 2, 2, nil},
	{3537, 11695, 1, 71, "The Horn of Elemental Fury", 2, 2, nil},
	{3537, 11702, 1, 71, "King Mrgl-Mrgl", 2, 2, nil},
	{3537, 11703, 1, 71, "Get to Getry", 2, 2, nil},
	{3537, 11705, 1, 71, "Foolish Endeavors", 2, 2, nil},
	{3537, 11706, 1, 71, "The Collapse", 2, 2, nil},
	{3537, 11709, 1, 71, "Nork Bloodfrenzy's Charge", 2, 2, nil},
	{3537, 11711, 1, 71, "Coward Delivery... Under 30 Minutes or it's Free", 2, 2, nil},
	{3537, 11714, 1, 71, "Vermin Extermination", 2, 2, nil},
	{3537, 11716, 1, 71, "The Wondrous Bloodspore", 2, 2, nil},
	{3537, 11717, 1, 71, "Pollen from the Source", 2, 2, nil},
	{3537, 11719, 1, 71, "A Suitable Test Subject", 2, 2, nil},
	{3537, 11720, 1, 71, "The Invasion of Gammoth", 2, 2, nil},
	{3537, 11721, 1, 71, "Gammothra the Tormentor", 2, 2, nil},
	{3537, 11722, 1, 71, "Trophies of Gammoth", 2, 2, nil},
	{3537, 11724, 1, 71, "Massive Moth Omelet?", 2, 2, nil},
	{3537, 11881, 1, 71, "Load'er Up!", 2, 2, nil},
	{3537, 11887, 1, 71, "Emergency Supplies", 2, 2, nil},
	{3537, 11888, 1, 71, "Ride to Taunka'le Village", 2, 2, nil},
	{3537, 11890, 1, 71, "What Are They Up To?", 2, 2, nil},
	{3537, 11893, 1, 71, "The Power of the Elements", 2, 2, nil},
	{3537, 11894, 1, 71, "Patching Up", 2, 2, nil},
	{3537, 11895, 1, 71, "Master the Storm", 2, 2, nil},
	{3537, 11896, 1, 71, "Weakness to Lightning", 2, 2, nil},
	{3537, 11898, 1, 71, "Breaking Through [Group]", 2, 2, nil},
	{3537, 11899, 1, 71, "Souls of the Decursed", 2, 2, nil},
	{3537, 11906, 1, 71, "Cleaning Up the Pools", 2, 2, nil},
	{3537, 11907, 1, 71, "The Sub-Chieftains", 2, 2, nil},
	{3537, 11916, 1, 71, "Hellscream's Champion", 2, 2, nil},
	{3537, 12486, 1, 71, "To Bor'gorok Outpost, Quickly!", 2, 2, nil},
	{3537, 11559, 1, 71, "Winterfin Commerce", 3, 2, nil},
	{3537, 11560, 1, 71, "Oh Noes, the Tadpoles!", 3, 2, nil},
	{3537, 11561, 1, 71, "Them!", 3, 2, nil},
	{3537, 11562, 1, 71, "I'm Being Blackmailed By My Cleaner", 3, 2, nil},
	{3537, 11563, 1, 71, "Grmmurggll Mrllggrl Glrggl!!!", 3, 2, nil},
	{3537, 11564, 1, 71, "Succulent Orca Stew", 3, 2, nil},
	{3537, 11565, 1, 71, "The Spare Suit", 3, 2, nil},
	{3537, 11569, 1, 71, "Keymaster Urmgrgl", 3, 2, nil},
	{3537, 11570, 1, 71, "Escape from the Winterfin Caverns", 3, 2, nil},
	{3537, 11571, 1, 71, "Learning to Communicate", 3, 2, nil},
	{3537, 11576, 1, 71, "Monitoring the Rift: Cleftcliff Anomaly", 3, 2, nil},
	{3537, 11582, 1, 71, "Monitoring the Rift: Sundered Chasm", 3, 2, nil},
	{3537, 11587, 1, 71, "Prison Break", 3, 2, nil},
	{3537, 11590, 1, 71, "Abduction", 3, 2, nil},
	{3537, 11613, 1, 71, "Karuk's Oath", 3, 2, nil},
	{3537, 11619, 1, 71, "Gamel the Cruel", 3, 2, nil},
	{3537, 11620, 1, 71, "A Father's Words", 3, 2, nil},
	{3537, 11625, 1, 71, "The Trident of Naz'jan", 3, 2, nil},
	{3537, 11626, 1, 71, "The Emissary", 3, 2, nil},
	{3537, 11646, 1, 71, "The Borean Inquisition", 3, 2, nil},
	{3537, 11648, 1, 71, "The Art of Persuasion", 3, 2, nil},
	{3537, 11663, 1, 71, "Sharing Intelligence", 3, 2, nil},
	{3537, 11671, 1, 71, "A Race Against Time", 3, 2, nil},
	{3537, 11679, 1, 71, "Reforging the Key", 3, 2, nil},
	{3537, 11680, 1, 71, "Taking Wing", 3, 2, nil},
	{3537, 11681, 1, 71, "Rescuing Evanor", 3, 2, nil},
	{3537, 11682, 1, 71, "Dragonspeak", 3, 2, nil},
	{3537, 11733, 1, 71, "Traversing the Rift", 3, 2, nil},
	{3537, 11900, 1, 71, "Reading the Meters", 3, 2, nil},
	{3537, 11910, 1, 71, "Secrets of the Ancients", 3, 2, nil},
	{3537, 11912, 1, 71, "Nuts for Berries", 3, 2, nil},
	{3537, 11914, 1, 71, "Keep the Secret Safe", 3, 2, nil},
	{3537, 11918, 1, 71, "Basic Training", 3, 2, nil},
	{3537, 11919, 1, 71, "Drake Hunt", 3, 2, nil},
	{3537, 11931, 1, 71, "Cracking the Code", 3, 2, nil},
	{3537, 11936, 1, 71, "Hatching a Plan", 3, 2, nil},
	{3537, 11940, 3, 71, "Drake Hunt", 3, 2, nil},
	{3537, 11941, 1, 71, "Puzzling...", 3, 2, nil},
	{3537, 11943, 1, 71, "The Cell", 3, 2, nil},
	{3537, 11946, 1, 71, "Keristrasza", 3, 2, nil},
	{3537, 11951, 1, 71, "Bait and Switch", 3, 2, nil},
	{3537, 11957, 1, 71, "Saragosa's End", 3, 2, nil},
	{3537, 11967, 1, 71, "Mustering the Reds", 3, 2, nil},
	{3537, 11968, 1, 71, "The Tides Turn", 3, 2, nil},
	{3537, 11969, 1, 71, "Springing the Trap", 3, 2, nil},
	{3537, 12471, 1, 71, "Cruelty of the Kvaldir", 3, 2, nil},
	{3537, 12728, 1, 71, "Monitoring the Rift: Winterfin Cavern", 3, 2, nil},
	{3537, 11670, 1, 72, "It Was The Orcs, Honest!", 1, 2, nil},
	{3537, 11673, 1, 72, "Get Me Outa Here!", 1, 2, nil},
	{3537, 11699, 1, 72, "I'm Stuck in this Damned Cage... But Not For Long!", 1, 2, nil},
	{3537, 11798, 1, 72, "The Gearmaster", 1, 2, nil},
	{3537, 11938, 1, 72, "Buying Some Time", 1, 2, nil},
	{3537, 11942, 1, 72, "Words of Power", 1, 2, nil},
	{3537, 11944, 1, 72, "Surrounded!", 1, 2, nil},
	{3537, 12019, 1, 72, "Last Rites [Group]", 1, 2, nil},
	{3537, 12086, 1, 72, "The Son of Karkut", 1, 2, nil},
	{3537, 12088, 1, 72, "Thassarian, the Death Knight", 1, 2, nil},
	{3537, 11592, 1, 72, "We Strike!", 2, 2, nil},
	{3537, 11627, 1, 72, "Boiling Point", 2, 2, nil},
	{3537, 11628, 1, 72, "Shrouds of the Scourge", 2, 2, nil},
	{3537, 11630, 1, 72, "The Bad Earth", 2, 2, nil},
	{3537, 11633, 1, 72, "Blending In", 2, 2, nil},
	{3537, 11637, 1, 72, "Kaganishu", 2, 2, nil},
	{3537, 11640, 1, 72, "Words of Power", 2, 2, nil},
	{3537, 11641, 1, 72, "A Courageous Strike", 2, 2, nil},
	{3537, 11647, 1, 72, "Neutralizing the Cauldrons", 2, 2, nil},
	{3537, 11654, 1, 72, "The Spire of Blood", 2, 2, nil},
	{3537, 11659, 1, 72, "Shatter the Orbs!", 2, 2, nil},
	{3537, 11687, 1, 72, "The Doctor and the Lich-Lord", 2, 2, nil},
	{3537, 11909, 1, 72, "Defeat the Gearmaster", 2, 2, nil},
	{3537, 11929, 1, 72, "The Fall of Taunka'le Village", 2, 2, nil},
	{3537, 11930, 1, 72, "Across Transborea", 2, 2, nil},
	{3537, 11566, 1, 72, "Surrender... Not!", 3, 2, nil},
	{3537, 11605, 1, 72, "The Honored Ancestors", 3, 2, nil},
	{3537, 11607, 1, 72, "The Lost Spirits", 3, 2, nil},
	{3537, 11609, 1, 72, "Picking Up the Pieces", 3, 2, nil},
	{3537, 11610, 1, 72, "Leading the Ancestors Home", 3, 2, nil},
	{3537, 11612, 1, 72, "Reclaiming the Quarry", 3, 2, nil},
	{3537, 11617, 1, 72, "Hampering Their Escape", 3, 2, nil},
	{3537, 11623, 1, 72, "A Visit to the Curator", 3, 2, nil},
	{3537, 11864, 1, 72, "A Mission Statement", 3, 2, nil},
	{3537, 11865, 1, 72, "Unfit for Death", 3, 2, nil},
	{3537, 11866, 1, 72, "Ears of Our Enemies", 3, 2, nil},
	{3537, 11867, 1, 72, "Can't Get Ear-nough...", 3, 2, nil},
	{3537, 11868, 1, 72, "The Culler Cometh [Group]", 3, 2, nil},
	{3537, 11869, 1, 72, "Happy as a Clam", 3, 2, nil},
	{3537, 11870, 1, 72, "The Abandoned Reach", 3, 2, nil},
	{3537, 11871, 1, 72, "Not On Our Watch", 3, 2, nil},
	{3537, 11872, 1, 72, "The Nefarious Clam Master...", 3, 2, nil},
	{3537, 11876, 1, 72, "Help Those That Cannot Help Themselves", 3, 2, nil},
	{3537, 11878, 1, 72, "Khu'nok Will Know", 3, 2, nil},
	{3537, 11879, 1, 72, "Kaw the Mammoth Destroyer", 3, 2, nil},
	{3537, 11884, 1, 72, "Ned, Lord of Rhinos... [Group]", 3, 2, nil},
	{3537, 11892, 1, 72, "The Assassination of Harold Lane [Group]", 3, 2, nil},
	{3537, 11945, 3, 72, "Preparing for the Worst", 3, 2, nil},
	{3537, 11949, 1, 72, "Not Without a Fight!", 3, 2, nil},
	{3537, 11950, 1, 72, "Muahit's Wisdom", 3, 2, nil},
	{3537, 11961, 1, 72, "Spirits Watch Over Us", 3, 2, nil},
	{3537, 13257, 1, 74, "Herald of War", 2, 2, nil},
	{3537, 13412, 1, 80, "Corastrasza", 3, 2, nil},
	{3537, 13413, 1, 80, "Aces High!", 3, 2, nil},
	{4024, 13414, 3, 80, "Aces High!", 3, 2, nil},
	{4395, 12794, 1, 74, "The Magical Kingdom of Dalaran", 1, 2, nil},
	{4395, 12791, 1, 74, "The Magical Kingdom of Dalaran", 2, 2, nil},
	{4395, 12790, 1, 74, "Learning to Leave and Return: the Magical Way", 3, 2, nil},
	{4395, 12796, 1, 74, "The Magical Kingdom of Dalaran", 3, 2, nil},
	{4395, 14457, 1, 80, "The Sunreaver Plan", 1, 2, nil},
	{4395, 24557, 1, 80, "The Silver Covenant's Scheme", 2, 2, nil},
	{65, 11995, 1, 72, "Your Presence is Required at Stars' Rest", 1, 2, nil},
	{65, 12000, 1, 72, "Rifle the Bodies", 1, 2, nil},
	{65, 12055, 1, 72, "A Strange Device", 1, 2, nil},
	{65, 12060, 1, 72, "Projections and Plans", 1, 2, nil},
	{65, 12065, 1, 72, "The Focus on the Beach", 1, 2, nil},
	{65, 12067, 1, 72, "A Letter for Home", 1, 2, nil},
	{65, 12083, 1, 72, "Atop the Woodlands", 1, 2, nil},
	{65, 12092, 1, 72, "Strengthen the Ancients", 1, 2, nil},
	{65, 12098, 1, 72, "Search Indu'le Village", 1, 2, nil},
	{65, 12107, 1, 72, "The End of the Line", 1, 2, nil},
	{65, 12119, 1, 72, "Gaining an Audience", 1, 2, nil},
	{65, 12157, 1, 72, "The Lost Courier", 1, 2, nil},
	{65, 12166, 1, 72, "The Liquid Fire of Elune", 1, 2, nil},
	{65, 12167, 1, 72, "Kill the Cultists", 1, 2, nil},
	{65, 12168, 1, 72, "The Favor of Zangus", 1, 2, nil},
	{65, 12169, 1, 72, "The High Cultist", 1, 2, nil},
	{65, 12171, 1, 72, "Of Traitors and Treason", 1, 2, nil},
	{65, 12174, 1, 72, "High Commander Halford Wyrmbane", 1, 2, nil},
	{65, 12235, 1, 72, "Naxxramas and the Fall of Wintergarde", 1, 2, nil},
	{65, 12237, 1, 72, "Flight of the Wintergarde Defender", 1, 2, nil},
	{65, 12251, 1, 72, "Return to the High Commander", 1, 2, nil},
	{65, 12253, 1, 72, "Rescue from Town Square", 1, 2, nil},
	{65, 12258, 1, 72, "The Fate of the Dead", 1, 2, nil},
	{65, 12269, 1, 72, "Not In Our Mine", 1, 2, nil},
	{65, 12272, 1, 72, "The Bleeding Ore", 1, 2, nil},
	{65, 12275, 1, 72, "The Demo-gnome", 1, 2, nil},
	{65, 12276, 1, 72, "The Search for Slinkin", 1, 2, nil},
	{65, 12277, 1, 72, "Leave Nothing to Chance", 1, 2, nil},
	{65, 12281, 1, 72, "Understanding the Scourge War Machine", 1, 2, nil},
	{65, 12282, 1, 72, "Imprints on the Past", 1, 2, nil},
	{65, 12287, 1, 72, "Orik Trueheart and the Forgotten Shore", 1, 2, nil},
	{65, 12290, 1, 72, "The Murkweed Elixir", 1, 2, nil},
	{65, 12291, 1, 72, "The Forgotten Tale", 1, 2, nil},
	{65, 12297, 1, 72, "Of Traitors and Treason", 1, 2, nil},
	{65, 12298, 1, 72, "High Commander Halford Wyrmbane", 1, 2, nil},
	{65, 12301, 1, 72, "The Truth Shall Set Us Free", 1, 2, nil},
	{65, 12305, 1, 72, "Parting Thoughts", 1, 2, nil},
	{65, 12309, 1, 72, "Find Durkon!", 1, 2, nil},
	{65, 12311, 1, 72, "The Noble's Crypt", 1, 2, nil},
	{65, 12439, 1, 72, "A Disturbance In The West", 1, 2, nil},
	{65, 12440, 1, 72, "To Stars' Rest!", 1, 2, nil},
	{65, 12766, 1, 72, "Speak with your Ambassador", 1, 2, nil},
	{65, 11977, 1, 72, "A Tauren Among Taunka", 2, 2, nil},
	{65, 11978, 1, 72, "Into the Fold", 2, 2, nil},
	{65, 11979, 1, 72, "The Taunka and the Tauren", 2, 2, nil},
	{65, 11980, 1, 72, "Pride of the Horde", 2, 2, nil},
	{65, 11983, 1, 72, "Blood Oath of the Horde", 2, 2, nil},
	{65, 11996, 1, 72, "Your Presence is Required at Agmar's Hammer", 2, 2, nil},
	{65, 11999, 1, 72, "Rifle the Bodies", 2, 2, nil},
	{65, 12008, 1, 72, "Agmar's Hammer", 2, 2, nil},
	{65, 12033, 1, 72, "Message from the West", 2, 2, nil},
	{65, 12034, 1, 72, "Victory Nears...", 2, 2, nil},
	{65, 12036, 1, 72, "From the Depths of Azjol-Nerub", 2, 2, nil},
	{65, 12039, 1, 72, "Black Blood of Yogg-Saron", 2, 2, nil},
	{65, 12040, 1, 72, "An Enemy in Arthas", 2, 2, nil},
	{65, 12041, 1, 72, "The Lost Empire", 2, 2, nil},
	{65, 12048, 1, 72, "Scourge Armaments", 2, 2, nil},
	{65, 12053, 1, 72, "The Might of the Horde", 2, 2, nil},
	{65, 12056, 1, 72, "Marked for Death: High Cultist Zangus", 2, 2, nil},
	{65, 12057, 1, 72, "The Flesh-Bound Tome", 2, 2, nil},
	{65, 12059, 1, 72, "A Strange Device", 2, 2, nil},
	{65, 12061, 1, 72, "Projections and Plans", 2, 2, nil},
	{65, 12063, 1, 72, "Strength of Icemist", 2, 2, nil},
	{65, 12064, 1, 72, "Chains of the Anub'ar", 2, 2, nil},
	{65, 12066, 1, 72, "The Focus on the Beach", 2, 2, nil},
	{65, 12071, 1, 72, "Attack by Air! ", 2, 2, nil},
	{65, 12072, 1, 72, "Blightbeasts be Damned!", 2, 2, nil},
	{65, 12084, 1, 72, "Atop the Woodlands", 2, 2, nil},
	{65, 12085, 1, 72, "A Letter for Home", 2, 2, nil},
	{65, 12096, 1, 72, "Strengthen the Ancients", 2, 2, nil},
	{65, 12100, 1, 72, "Containing the Rot", 2, 2, nil},
	{65, 12101, 1, 72, "The Good Doctor...", 2, 2, nil},
	{65, 12106, 1, 72, "Search Indu'le Village", 2, 2, nil},
	{65, 12110, 1, 72, "The End of the Line", 2, 2, nil},
	{65, 12115, 1, 72, "Koltira and the Language of Death", 2, 2, nil},
	{65, 12122, 1, 72, "Gaining an Audience", 2, 2, nil},
	{65, 12182, 1, 72, "To Venomspite!", 2, 2, nil},
	{65, 12188, 1, 72, "The Forsaken Blight and You: How Not to Die", 2, 2, nil},
	{65, 12189, 1, 72, "Imbeciles Abound!", 2, 2, nil},
	{65, 12200, 1, 72, "Emerald Dragon Tears", 2, 2, nil},
	{65, 12205, 1, 72, "Wanted: The Scarlet Onslaught", 2, 2, nil},
	{65, 12206, 1, 72, "Blighted Last Rites", 2, 2, nil},
	{65, 12209, 1, 72, "Materiel Plunder", 2, 2, nil},
	{65, 12211, 1, 72, "Let Them Not Rise!", 2, 2, nil},
	{65, 12214, 1, 72, "Fresh Remounts", 2, 2, nil},
	{65, 12218, 1, 72, "Spread the Good Word", 2, 2, nil},
	{65, 12221, 1, 72, "The Forsaken Blight", 2, 2, nil},
	{65, 12230, 1, 72, "Stealing from the Siegesmiths", 2, 2, nil},
	{65, 12232, 1, 72, "Bombard the Ballistae", 2, 2, nil},
	{65, 12234, 1, 72, "Need to Know", 2, 2, nil},
	{65, 12239, 1, 72, "The Spy in New Hearthglen", 2, 2, nil},
	{65, 12240, 1, 72, "A Means to an End", 2, 2, nil},
	{65, 12243, 1, 72, "Fire Upon the Waters", 2, 2, nil},
	{65, 12245, 1, 72, "No Mercy for the Captured", 2, 2, nil},
	{65, 12252, 1, 72, "Torture the Torturer", 2, 2, nil},
	{65, 12254, 1, 72, "Without a Prayer", 2, 2, nil},
	{65, 12260, 1, 72, "The Perfect Dissemblance", 2, 2, nil},
	{65, 12271, 1, 72, "The Rod of Compulsion", 2, 2, nil},
	{65, 12283, 1, 72, "The Truth Will Out", 2, 2, nil},
	{65, 12303, 1, 72, "Funding the War Effort", 2, 2, nil},
	{65, 12304, 1, 72, "Beachfront Property", 2, 2, nil},
	{65, 12767, 1, 72, "Speak with your Ambassador", 2, 2, nil},
	{65, 11958, 1, 72, "Let Nothing Go To Waste", 3, 2, nil},
	{65, 11960, 3, 72, "Planning for the Future", 3, 2, nil},
	{65, 12006, 1, 72, "Avenge this Atrocity!", 3, 2, nil},
	{65, 12009, 1, 72, "Tua'kea's Crab Traps", 3, 2, nil},
	{65, 12011, 1, 72, "Signs of Big Watery Trouble", 3, 2, nil},
	{65, 12016, 1, 72, "The Bait", 3, 2, nil},
	{65, 12028, 1, 72, "Spiritual Insight", 3, 2, nil},
	{65, 12030, 1, 72, "Elder Mana'loa", 3, 2, nil},
	{65, 12031, 1, 72, "Freedom for the Lingering", 3, 2, nil},
	{65, 12032, 1, 72, "Conversing With the Depths", 3, 2, nil},
	{65, 12117, 1, 72, "Travel to Moa'ki Harbor", 3, 2, nil},
	{65, 12118, 1, 72, "Travel to Moa'ki Harbor", 3, 2, nil},
	{65, 12004, 1, 73, "Prevent the Accord", 1, 2, nil},
	{65, 12142, 1, 73, "Pest Control", 1, 2, nil},
	{65, 12143, 1, 73, "Canyon Chase", 1, 2, nil},
	{65, 12146, 1, 73, "Disturbing Implications", 1, 2, nil},
	{65, 12312, 1, 73, "Secrets of the Scourge", 1, 2, nil},
	{65, 12319, 1, 73, "Mystery of the Tome", 1, 2, nil},
	{65, 12320, 1, 73, "Understanding the Language of Death", 1, 2, nil},
	{65, 12321, 1, 73, "A Righteous Sermon", 1, 2, nil},
	{65, 12325, 1, 73, "Into Hostile Territory", 1, 2, nil},
	{65, 12326, 1, 73, "Steamtank Surprise", 1, 2, nil},
	{65, 12455, 1, 73, "Scattered To The Wind", 1, 2, nil},
	{65, 12457, 1, 73, "The Chain Gun And You", 1, 2, nil},
	{65, 12462, 1, 73, "Breaking Off A Piece", 1, 2, nil},
	{65, 12463, 1, 73, "Plunderbeard Must Be Found!", 1, 2, nil},
	{65, 12464, 1, 73, "My Old Enemy [Group]", 1, 2, nil},
	{65, 12465, 1, 73, "Plunderbeard's Journal", 1, 2, nil},
	{65, 12466, 1, 73, "Chasing Icestorm: The 7th Legion Front", 1, 2, nil},
	{65, 12467, 1, 73, "Chasing Icestorm: Thel'zan's Phylactery", 1, 2, nil},
	{65, 12472, 1, 73, "Finality", 1, 2, nil},
	{65, 12473, 1, 73, "An End And A Beginning", 1, 2, nil},
	{65, 12474, 1, 73, "To Fordragon Hold!", 1, 2, nil},
	{65, 12475, 1, 73, "What Secrets Men Hide", 1, 2, nil},
	{65, 12476, 1, 73, "The Return of the Crusade?", 1, 2, nil},
	{65, 12477, 1, 73, "The Path of Redemption", 1, 2, nil},
	{65, 12478, 1, 73, "Frostmourne Cavern", 1, 2, nil},
	{65, 12005, 1, 73, "Prevent the Accord", 2, 2, nil},
	{65, 12069, 1, 73, "Return of the High Chief", 2, 2, nil},
	{65, 12102, 1, 73, "In Search of the Ruby Lilac", 2, 2, nil},
	{65, 12104, 1, 73, "Return to Soar", 2, 2, nil},
	{65, 12111, 1, 73, "Where the Wild Things Roam", 2, 2, nil},
	{65, 12125, 1, 73, "In Service of Blood", 2, 2, nil},
	{65, 12126, 1, 73, "In Service of the Unholy", 2, 2, nil},
	{65, 12127, 1, 73, "In Service of Frost", 2, 2, nil},
	{65, 12132, 1, 73, "The Power to Destroy", 2, 2, nil},
	{65, 12136, 1, 73, "The Translated Tome", 2, 2, nil},
	{65, 12140, 1, 73, "All Hail Roanauk!", 2, 2, nil},
	{65, 12144, 1, 73, "Pest Control", 2, 2, nil},
	{65, 12145, 1, 73, "Canyon Chase", 2, 2, nil},
	{65, 12147, 1, 73, "Disturbing Implications", 2, 2, nil},
	{65, 12224, 1, 73, "The Kor'kron Vanguard!", 2, 2, nil},
	{65, 12273, 1, 73, "The Denouncement", 2, 2, nil},
	{65, 12274, 1, 73, "A Fall From Grace", 2, 2, nil},
	{65, 12285, 1, 73, "Do Unto Others [Group]", 2, 2, nil},
	{65, 11959, 1, 73, "Slay Loguhn", 3, 2, nil},
	{65, 12013, 1, 73, "End Arcanimus", 3, 2, nil},
	{65, 12017, 1, 73, "Meat on the Hook", 3, 2, nil},
	{65, 12148, 1, 73, "One of a Kind [Group]", 3, 2, nil},
	{65, 12149, 1, 73, "Mighty Magnataur [Group]", 3, 2, nil},
	{65, 12416, 1, 74, "Heated Battle", 1, 2, nil},
	{65, 12417, 1, 74, "Return to the Earth", 1, 2, nil},
	{65, 12438, 1, 74, "Wanted: Kreug Oathbreaker [Group]", 1, 2, nil},
	{65, 12441, 1, 74, "Wanted: High Shaman Bloodpaw [Group]", 1, 2, nil},
	{65, 12442, 1, 74, "Wanted: Onslaught Commander Iustus [Group]", 1, 2, nil},
	{65, 12460, 1, 74, "Report to the Ruby Dragonshrine", 1, 2, nil},
	{65, 12495, 1, 74, "Audience With The Dragon Queen", 1, 2, nil},
	{65, 12499, 1, 74, "Return To Angrathar", 1, 2, nil},
	{65, 13347, 1, 74, "Reborn From The Ashes", 1, 2, nil},
	{65, 13369, 1, 74, "Fate, Up Against Your Will", 1, 2, nil},
	{65, 13370, 1, 74, "A Royal Coup", 1, 2, nil},
	{65, 13371, 1, 74, "The Killing Time", 1, 2, nil},
	{65, 13377, 1, 74, "The Battle For The Undercity", 1, 2, nil},
	{65, 12089, 1, 74, "Wanted: Magister Keldonus [Group]", 2, 2, nil},
	{65, 12090, 1, 74, "Wanted: Gigantaur [Group]", 2, 2, nil},
	{65, 12091, 1, 74, "Wanted: Dreadtalon [Group]", 2, 2, nil},
	{65, 12448, 1, 74, "Heated Battle", 2, 2, nil},
	{65, 12449, 1, 74, "Return to the Earth", 2, 2, nil},
	{65, 12461, 1, 74, "Report to the Ruby Dragonshrine", 2, 2, nil},
	{65, 12488, 1, 74, "The High Executor Needs You", 2, 2, nil},
	{65, 12496, 1, 74, "Audience With The Dragon Queen", 2, 2, nil},
	{65, 12500, 1, 74, "Return To Angrathar", 2, 2, nil},
	{65, 13242, 1, 74, "Darkness Stirs", 2, 2, nil},
	{65, 12043, 1, 74, "Nozzlerust Defense", 3, 2, nil},
	{65, 12044, 1, 74, "Stocking Up", 3, 2, nil},
	{65, 12045, 1, 74, "Shaved Ice", 3, 2, nil},
	{65, 12046, 1, 74, "Soft Packaging", 3, 2, nil},
	{65, 12047, 1, 74, "Something That Doesn't Melt", 3, 2, nil},
	{65, 12049, 1, 74, "Hard to Swallow", 3, 2, nil},
	{65, 12050, 1, 74, "Lumber Hack", 3, 2, nil},
	{65, 12052, 1, 74, "Harp on This!", 3, 2, nil},
	{65, 12075, 1, 74, "Slim Pickings", 3, 2, nil},
	{65, 12076, 1, 74, "Messy Business", 3, 2, nil},
	{65, 12077, 1, 74, "Apply This Twice A Day", 3, 2, nil},
	{65, 12078, 1, 74, "Worm Wrangler", 3, 2, nil},
	{65, 12079, 1, 74, "Stomping Grounds", 3, 2, nil},
	{65, 12080, 1, 74, "Really Big Worm [Group]", 3, 2, nil},
	{65, 12112, 1, 74, "Stiff Negotiations", 3, 2, nil},
	{65, 12150, 1, 74, "Reclusive Runemaster [Group]", 3, 2, nil},
	{65, 12151, 1, 74, "Wanton Warlord [Group]", 3, 2, nil},
	{65, 12261, 1, 74, "No Place to Run", 3, 2, nil},
	{65, 12262, 1, 74, "No One to Save You", 3, 2, nil},
	{65, 12263, 1, 74, "The Best of Intentions", 3, 2, nil},
	{65, 12264, 1, 74, "Culling the Damned", 3, 2, nil},
	{65, 12265, 1, 74, "Defiling the Defilers", 3, 2, nil},
	{65, 12266, 1, 74, "Tales of Destruction", 3, 2, nil},
	{65, 12372, 3, 74, "Defending Wyrmrest Temple", 3, 2, nil},
	{65, 12435, 1, 74, "Report to Lord Afrasastrasz", 3, 2, nil},
	{65, 12447, 1, 74, "The Obsidian Dragonshrine", 3, 2, nil},
	{65, 12454, 1, 74, "Cycle of Life", 3, 2, nil},
	{65, 12456, 1, 74, "The Plume of Alystros [Group]", 3, 2, nil},
	{65, 12458, 1, 74, "Seeds of the Lashers", 3, 2, nil},
	{65, 12459, 1, 74, "That Which Creates Can Also Destroy", 3, 2, nil},
	{65, 12469, 1, 74, "Return to Sender", 3, 2, nil},
	{65, 12497, 1, 74, "Galakrond and the Scourge", 3, 2, nil},
	{65, 12498, 1, 74, "On Ruby Wings", 3, 2, nil},
	{65, 12542, 1, 74, "The Call Of The Crusade", 3, 2, nil},
	{65, 12545, 1, 74, "The Cleansing Of Jintha'kalar", 3, 2, nil},
	{65, 12123, 1, 75, "Informing the Queen", 1, 2, nil},
	{65, 12418, 1, 75, "Through Fields of Flame", 1, 2, nil},
	{65, 12768, 1, 75, "The Steward of Wyrmrest Temple", 1, 2, nil},
	{65, 12095, 1, 75, "To Dragon's Fall [Group]", 2, 2, nil},
	{65, 12097, 1, 75, "Sarathstra, Scourge of the North [Group]", 2, 2, nil},
	{65, 12124, 1, 75, "Informing the Queen", 2, 2, nil},
	{65, 12450, 1, 75, "Through Fields of Flame", 2, 2, nil},
	{65, 12769, 1, 75, "The Steward of Wyrmrest Temple", 2, 2, nil},
	{65, 12267, 1, 75, "Neltharion's Flame", 3, 2, nil},
	{65, 12419, 1, 75, "The Fate of the Ruby Dragonshrine", 3, 2, nil},
	{65, 12470, 1, 75, "Mystery of the Infinite", 3, 2, nil},
	{65, 13078, 1, 80, "Dahlia's Tears", 3, 2, nil},
	{65, 13343, 1, 80, "Mystery of the Infinite, Redux", 3, 2, nil},
	{65, 13372, 1, 80, "The Key to the Focusing Iris", 3, 2, nil},
	{65, 13375, 1, 80, "The Heroic Key to the Focusing Iris", 3, 2, nil},
	{394, 12038, 3, 72, "Seared Scourge", 3, 2, nil},
	{394, 12210, 1, 73, "Troll Season!", 1, 2, nil},
	{394, 12225, 1, 73, "Mmm... Amberseeds!", 1, 2, nil},
	{394, 12226, 1, 73, "Just Passing Through", 1, 2, nil},
	{394, 12227, 1, 73, "Doing Your Duty", 1, 2, nil},
	{394, 12511, 1, 73, "The Hills Have Us", 1, 2, nil},
	{394, 11989, 1, 73, "Truce?", 3, 2, nil},
	{394, 12027, 1, 74, "Mr. Floppy's Perilous Adventure", 1, 2, nil},
	{394, 12105, 1, 74, "Descent into Darkness", 1, 2, nil},
	{394, 12109, 1, 74, "Report to Gryan Stoutmantle... Again", 1, 2, nil},
	{394, 12212, 1, 74, "Replenishing the Storehouse", 1, 2, nil},
	{394, 12215, 1, 74, "Them or Us!", 1, 2, nil},
	{394, 12216, 1, 74, "Take Their Rear!", 1, 2, nil},
	{394, 12217, 1, 74, "Eagle Eyes", 1, 2, nil},
	{394, 12219, 1, 74, "The Failed World Tree", 1, 2, nil},
	{394, 12220, 1, 74, "A Dark Influence", 1, 2, nil},
	{394, 12222, 1, 74, "Secrets of the Flamebinders", 1, 2, nil},
	{394, 12223, 1, 74, "Thinning the Ranks", 1, 2, nil},
	{394, 12244, 3, 74, "Shredder Repair", 1, 2, nil},
	{394, 12246, 1, 74, "A Possible Link", 1, 2, nil},
	{394, 12255, 1, 74, "The Thane of Voldrune", 1, 2, nil},
	{394, 12268, 3, 74, "Pieces Parts", 1, 2, nil},
	{394, 12289, 3, 74, "Kick 'Em While They're Down", 1, 2, nil},
	{394, 12292, 1, 74, "Local Support", 1, 2, nil},
	{394, 12293, 1, 74, "Close the Deal", 1, 2, nil},
	{394, 12294, 1, 74, "A Tentative Pact", 1, 2, nil},
	{394, 12295, 1, 74, "An Exercise in Diplomacy", 1, 2, nil},
	{394, 12296, 3, 74, "Life or Death", 1, 2, nil},
	{394, 12299, 1, 74, "Northern Hospitality", 1, 2, nil},
	{394, 12300, 1, 74, "Test of Mettle", 1, 2, nil},
	{394, 12302, 1, 74, "Words of Warning", 1, 2, nil},
	{394, 12307, 1, 74, "Wolfsbane Root", 1, 2, nil},
	{394, 12308, 1, 74, "Escape from Silverbrook", 1, 2, nil},
	{394, 12310, 1, 74, "A Swift Response", 1, 2, nil},
	{394, 12314, 3, 74, "Down With Captain Zorna! [Group]", 1, 2, nil},
	{394, 12316, 3, 74, "Keep Them at Bay!", 1, 2, nil},
	{394, 12323, 3, 74, "Smoke 'Em Out", 1, 2, nil},
	{394, 12437, 3, 74, "Riding the Red Rocket", 1, 2, nil},
	{394, 12443, 1, 74, "Seeking Solvent", 1, 2, nil},
	{394, 12444, 3, 74, "Blackriver Skirmish [PvP]", 1, 2, nil},
	{394, 12446, 2, 74, "Always Seeking Solvent", 1, 2, nil},
	{394, 12170, 3, 74, "Blackriver Brawl", 2, 2, nil},
	{394, 12175, 1, 74, "Gray Worg Hides", 2, 2, nil},
	{394, 12176, 1, 74, "A Minor Substitution", 2, 2, nil},
	{394, 12177, 1, 74, "Jun'ik's Coverup", 2, 2, nil},
	{394, 12178, 1, 74, "Delivery to Krenna", 2, 2, nil},
	{394, 12207, 1, 74, "Vordrassil's Fall", 2, 2, nil},
	{394, 12208, 1, 74, "Good Troll Hunting", 2, 2, nil},
	{394, 12213, 1, 74, "The Darkness Beneath", 2, 2, nil},
	{394, 12229, 1, 74, "A Possible Link", 2, 2, nil},
	{394, 12242, 1, 74, "Vordrassil's Seeds", 2, 2, nil},
	{394, 12256, 1, 74, "The Flamebinders' Secrets", 2, 2, nil},
	{394, 12257, 1, 74, "A Show of Strength", 2, 2, nil},
	{394, 12259, 1, 74, "The Thane of Voldrune", 2, 2, nil},
	{394, 12270, 3, 74, "Shred the Alliance", 2, 2, nil},
	{394, 12280, 3, 74, "Making Repairs", 2, 2, nil},
	{394, 12284, 3, 74, "Keep 'Em on Their Heels", 2, 2, nil},
	{394, 12288, 3, 74, "Overwhelmed!", 2, 2, nil},
	{394, 12315, 3, 74, "Crush Captain Brightwater! [Group]", 2, 2, nil},
	{394, 12317, 3, 74, "Keep Them at Bay", 2, 2, nil},
	{394, 12324, 3, 74, "Smoke 'Em Out", 2, 2, nil},
	{394, 12413, 1, 74, "Attack on Silverbrook", 2, 2, nil},
	{394, 12422, 1, 74, "Tactical Clemency", 2, 2, nil},
	{394, 12423, 1, 74, "Mikhail's Journal", 2, 2, nil},
	{394, 12424, 1, 74, "Gorgonna", 2, 2, nil},
	{394, 12427, 1, 74, "The Conquest Pit: Bear Wrestling! [Group]", 2, 2, nil},
	{394, 12428, 1, 74, "The Conquest Pit: Mad Furbolg Fighting [Group]", 2, 2, nil},
	{394, 12429, 1, 74, "The Conquest Pit: Blood and Metal [Group]", 2, 2, nil},
	{394, 12432, 3, 74, "Riding the Red Rocket", 2, 2, nil},
	{394, 12433, 1, 74, "Seeking Solvent", 2, 2, nil},
	{394, 12434, 2, 74, "Always Seeking Solvent", 2, 2, nil},
	{394, 12436, 1, 74, "Supplemental Income", 2, 2, nil},
	{394, 12451, 1, 74, "Onward to Camp Oneqwah", 2, 2, nil},
	{394, 12453, 1, 74, "Eyes Above", 2, 2, nil},
	{394, 12468, 1, 74, "The Conqueror's Task", 2, 2, nil},
	{394, 12487, 1, 74, "To Conquest Hold, But Be Careful!", 2, 2, nil},
	{394, 11984, 1, 74, "Filling the Cages", 3, 2, nil},
	{394, 11990, 1, 74, "Vial of Visions", 3, 2, nil},
	{394, 11991, 1, 74, "Subject to Interpretation", 3, 2, nil},
	{394, 12007, 1, 74, "Sacrifices Must be Made", 3, 2, nil},
	{394, 12029, 1, 74, "Seared Scourge", 3, 2, nil},
	{394, 12042, 1, 74, "Heart of the Ancients", 3, 2, nil},
	{394, 12190, 1, 74, "Say Hello to My Little Friend", 3, 2, nil},
	{394, 12484, 1, 74, "Scourgekabob", 3, 2, nil},
	{394, 12802, 1, 74, "My Heart is in Your Hands", 3, 2, nil},
	{394, 11986, 1, 75, "The Damaged Journal", 1, 2, nil},
	{394, 11988, 1, 75, "The Runic Keystone", 1, 2, nil},
	{394, 11993, 1, 75, "The Runic Prophecies", 1, 2, nil},
	{394, 11998, 1, 75, "Softening the Blow", 1, 2, nil},
	{394, 12002, 1, 75, "Brothers in Battle", 1, 2, nil},
	{394, 12003, 1, 75, "Uncovering the Tunnels", 1, 2, nil},
	{394, 12010, 1, 75, "The Fate of Orlond", 1, 2, nil},
	{394, 12014, 1, 75, "Steady as a Rock?", 1, 2, nil},
	{394, 12128, 1, 75, "Check Up on Raegar", 1, 2, nil},
	{394, 12129, 1, 75, "The Perfect Plan", 1, 2, nil},
	{394, 12130, 1, 75, "Why Fabricate When You Can Appropriate?", 1, 2, nil},
	{394, 12131, 1, 75, "We Have the Power", 1, 2, nil},
	{394, 12138, 1, 75, "... Or Maybe We Don't", 1, 2, nil},
	{394, 12153, 1, 75, "The Iron Thane and His Anvil", 1, 2, nil},
	{394, 12154, 1, 75, "Blackout", 1, 2, nil},
	{394, 12158, 1, 75, "Hollowstone Mine", 1, 2, nil},
	{394, 12159, 1, 75, "Souls at Unrest", 1, 2, nil},
	{394, 12160, 1, 75, "A Name from the Past", 1, 2, nil},
	{394, 12161, 1, 75, "Ruuna the Blind", 1, 2, nil},
	{394, 12180, 1, 75, "The Captive Prospectors", 1, 2, nil},
	{394, 12183, 1, 75, "Looking the Part", 1, 2, nil},
	{394, 12184, 1, 75, "Cultivating an Image", 1, 2, nil},
	{394, 12185, 1, 75, "Put on Your Best Face for Loken", 1, 2, nil},
	{394, 12247, 1, 75, "Children of Ursoc", 1, 2, nil},
	{394, 12248, 1, 75, "Vordrassil's Sapling", 1, 2, nil},
	{394, 12249, 1, 75, "Ursoc, the Bear God [Group]", 1, 2, nil},
	{394, 12250, 1, 75, "Vordrassil's Seeds", 1, 2, nil},
	{394, 12414, 1, 75, "Mounting Up", 1, 2, nil},
	{394, 12770, 1, 75, "Reallocating Resources", 1, 2, nil},
	{394, 12026, 1, 75, "The Damaged Journal", 2, 2, nil},
	{394, 12054, 1, 75, "Deciphering the Journal", 2, 2, nil},
	{394, 12058, 1, 75, "The Runic Prophecies", 2, 2, nil},
	{394, 12073, 1, 75, "Pounding the Iron", 2, 2, nil},
	{394, 12074, 1, 75, "An Expedient Ally", 2, 2, nil},
	{394, 12165, 1, 75, "An Intriguing Plan", 2, 2, nil},
	{394, 12195, 1, 75, "The Unexpected 'Guest'", 2, 2, nil},
	{394, 12196, 1, 75, "From the Ground Up", 2, 2, nil},
	{394, 12197, 1, 75, "We Have the Power", 2, 2, nil},
	{394, 12198, 1, 75, "... Or Maybe We Don't", 2, 2, nil},
	{394, 12199, 1, 75, "Bringing Down the Iron Thane", 2, 2, nil},
	{394, 12201, 1, 75, "The Overseer's Shadow", 2, 2, nil},
	{394, 12202, 1, 75, "Cultivating an Image", 2, 2, nil},
	{394, 12203, 1, 75, "Loken's Orders", 2, 2, nil},
	{394, 12204, 1, 75, "In the Name of Loken", 2, 2, nil},
	{394, 12231, 1, 75, "The Bear God's Offspring", 2, 2, nil},
	{394, 12236, 1, 75, "Ursoc, the Bear God [Group]", 2, 2, nil},
	{394, 12241, 1, 75, "Destroy the Sapling", 2, 2, nil},
	{394, 12412, 1, 75, "My Enemy's Friend", 2, 2, nil},
	{394, 12415, 1, 75, "The Horse Hollerer", 2, 2, nil},
	{394, 12425, 1, 75, "Ruuna the Blind", 2, 2, nil},
	{394, 12430, 1, 75, "The Conquest Pit: Death Is Likely [Group]", 2, 2, nil},
	{394, 12431, 1, 75, "The Conquest Pit: Final Showdown [Group]", 2, 2, nil},
	{394, 12763, 1, 75, "Shifting Priorities", 2, 2, nil},
	{394, 11981, 1, 75, "Find Kurun!", 3, 2, nil},
	{394, 11982, 1, 75, "Raining Down Destruction", 3, 2, nil},
	{394, 11985, 1, 75, "Into the Breach", 3, 2, nil},
	{394, 12068, 1, 75, "Voices From the Dust", 3, 2, nil},
	{394, 12070, 1, 75, "Rallying the Troops", 3, 2, nil},
	{394, 12081, 1, 75, "Gavrock", 3, 2, nil},
	{394, 12082, 1, 75, "Dun-da-Dun-tah!", 3, 2, nil},
	{394, 12093, 1, 75, "Runes of Compulsion", 3, 2, nil},
	{394, 12094, 1, 75, "Latent Power", 3, 2, nil},
	{394, 12099, 1, 75, "Free at Last", 3, 2, nil},
	{394, 12113, 1, 75, "Nice to Meat You", 3, 2, nil},
	{394, 12114, 1, 75, "Therapy", 3, 2, nil},
	{394, 12116, 1, 75, "It Takes Guts....", 3, 2, nil},
	{394, 12120, 1, 75, "Drak'aguul's Mallet", 3, 2, nil},
	{394, 12121, 1, 75, "See You on the Other Side", 3, 2, nil},
	{394, 12134, 1, 75, "Sasha's Hunt", 3, 2, nil},
	{394, 12137, 1, 75, "Chill Out, Mon", 3, 2, nil},
	{394, 12152, 1, 75, "Jin'arrak's End", 3, 2, nil},
	{394, 12164, 1, 75, "Hour of the Worg [Group]", 3, 2, nil},
	{394, 12279, 1, 75, "A Bear of an Appetite", 3, 2, nil},
	{394, 12327, 1, 75, "Out of Body Experience", 3, 2, nil},
	{394, 12328, 1, 75, "Ruuna's Request", 3, 2, nil},
	{394, 12329, 1, 75, "Fate and Coincidence", 3, 2, nil},
	{394, 12330, 1, 75, "Anatoly Will Talk", 3, 2, nil},
	{394, 12411, 1, 75, "A Sister's Pledge", 3, 2, nil},
	{394, 12483, 1, 75, "Shimmercap Stew", 3, 2, nil},
	{495, 11472, 3, 0, "The Way to His Heart...", 3, 2, nil},
	{495, 11228, 1, 70, "Hell Has Frozen Over...", 1, 2, nil},
	{495, 11243, 1, 70, "If Valgarde Falls...", 1, 2, nil},
	{495, 11244, 1, 70, "Rescuing the Rescuers", 1, 2, nil},
	{495, 11255, 1, 70, "Prisoners of Wyrmskull", 1, 2, nil},
	{495, 11273, 1, 70, "The Human League", 1, 2, nil},
	{495, 11274, 1, 70, "Zedd's Probably Dead", 1, 2, nil},
	{495, 11276, 1, 70, "And Then There Were Two...", 1, 2, nil},
	{495, 11290, 1, 70, "Dragonflayer Battle Plans", 1, 2, nil},
	{495, 11291, 1, 70, "To Westguard Keep!", 1, 2, nil},
	{495, 11292, 1, 70, "Preying Upon the Weak", 1, 2, nil},
	{495, 11302, 1, 70, "The Enigmatic Frost Nymphs", 1, 2, nil},
	{495, 11329, 1, 70, "I'll Try Anything!", 1, 2, nil},
	{495, 11406, 1, 70, "Everything Must Be Ready", 1, 2, nil},
	{495, 11418, 1, 70, "We Call Him Steelfeather", 1, 2, nil},
	{495, 11477, 1, 70, "Out of My Element?", 1, 2, nil},
	{495, 11323, 1, 71, "In Worg's Clothing", 4, 2, nil},
	{495, 11324, 1, 71, "Alpha Worg", 4, 2, nil},
	{495, 11153, 3, 71, "Break the Blockade", 1, 2, nil},
	{495, 11154, 1, 71, "Scare the Guano Out of Them!", 1, 2, nil},
	{495, 11155, 1, 71, "Shoveltusk Soup Again?", 1, 2, nil},
	{495, 11157, 1, 71, "The Clutches of Evil", 1, 2, nil},
	{495, 11175, 1, 71, "My Daughter", 1, 2, nil},
	{495, 11176, 1, 71, "See to the Operations", 1, 2, nil},
	{495, 11187, 1, 71, "Mage-Lieutenant Malister", 1, 2, nil},
	{495, 11188, 1, 71, "Two Wrongs...", 1, 2, nil},
	{495, 11190, 1, 71, "One Size Does Not Fit All", 1, 2, nil},
	{495, 11199, 1, 71, "Report to Scout Knowles", 1, 2, nil},
	{495, 11202, 1, 71, "Mission: Eternal Flame", 1, 2, nil},
	{495, 11218, 1, 71, "Danger! Explosives!", 1, 2, nil},
	{495, 11224, 1, 71, "Send Them Packing", 1, 2, nil},
	{495, 11231, 1, 71, "Of Keys and Cages", 1, 2, nil},
	{495, 11235, 1, 71, "Dealing With Gjalerbron", 1, 2, nil},
	{495, 11239, 1, 71, "In Service to the Light", 1, 2, nil},
	{495, 11240, 1, 71, "Leader of the Deranged", 1, 2, nil},
	{495, 11245, 1, 71, "Towers of Certain Doom", 1, 2, nil},
	{495, 11246, 1, 71, "Gruesome, But Necessary", 1, 2, nil},
	{495, 11247, 1, 71, "Burn Skorn, Burn!", 1, 2, nil},
	{495, 11248, 1, 71, "Operation: Skornful Wrath", 1, 2, nil},
	{495, 11251, 1, 71, "Fresh Legs", 1, 2, nil},
	{495, 11269, 1, 71, "Down to the Wire", 1, 2, nil},
	{495, 11277, 1, 71, "The Depths of Depravity", 1, 2, nil},
	{495, 11278, 1, 71, "Return to Valgarde", 1, 2, nil},
	{495, 11284, 1, 71, "The Yeti Next Door", 1, 2, nil},
	{495, 11288, 1, 71, "The Shining Light", 1, 2, nil},
	{495, 11289, 1, 71, "Guided by Honor", 1, 2, nil},
	{495, 11299, 1, 71, "The Ring of Judgement", 1, 2, nil},
	{495, 11300, 1, 71, "Stunning Defeat at the Ring", 1, 2, nil},
	{495, 11322, 1, 71, "The Cleansing", 1, 2, nil},
	{495, 11325, 1, 71, "In Worg's Clothing", 1, 2, nil},
	{495, 11326, 1, 71, "Alpha Worg", 1, 2, nil},
	{495, 11327, 1, 71, "Mission: Package Retrieval", 1, 2, nil},
	{495, 11328, 1, 71, "Mission: Forsaken Intel", 1, 2, nil},
	{495, 11330, 1, 71, "Absholutely... Thish Will Work!", 1, 2, nil},
	{495, 11331, 1, 71, "You Tell Him ...Hic!", 1, 2, nil},
	{495, 11332, 1, 71, "Mission: Plague This!", 1, 2, nil},
	{495, 11333, 1, 71, "Into the World of Spirits", 1, 2, nil},
	{495, 11343, 1, 71, "The Echo of Ymiron", 1, 2, nil},
	{495, 11344, 1, 71, "Anguish of Nifflevar", 1, 2, nil},
	{495, 11346, 1, 71, "The Book of Runes", 1, 2, nil},
	{495, 11348, 1, 71, "The Rune of Command", 1, 2, nil},
	{495, 11349, 1, 71, "Mastering the Runes", 1, 2, nil},
	{495, 11390, 1, 71, "I've Got a Flying Machine!", 1, 2, nil},
	{495, 11391, 3, 71, "Steel Gate Patrol", 1, 2, nil},
	{495, 11393, 1, 71, "Where is Explorer Jaren?", 1, 2, nil},
	{495, 11394, 1, 71, "And You Thought Murlocs Smelled Bad!", 1, 2, nil},
	{495, 11395, 1, 71, "It's a Scourge Device", 1, 2, nil},
	{495, 11396, 1, 71, "Bring Down Those Shields", 1, 2, nil},
	{495, 11410, 1, 71, "The One That Got Away", 1, 2, nil},
	{495, 11414, 1, 71, "Brother Betrayers", 1, 2, nil},
	{495, 11416, 1, 71, "Eyes of the Eagle", 1, 2, nil},
	{495, 11420, 1, 71, "The Path to Payback", 1, 2, nil},
	{495, 11421, 1, 71, "It Goes to 11...", 1, 2, nil},
	{495, 11426, 1, 71, "Locating the Mechanism", 1, 2, nil},
	{495, 11427, 1, 71, "Meet Lieutenant Icehammer...", 1, 2, nil},
	{495, 11429, 1, 71, "Drop It then Rock It!", 1, 2, nil},
	{495, 11430, 1, 71, "Harpoon Master Yavus", 1, 2, nil},
	{495, 11432, 1, 71, "Sleeping Giants", 1, 2, nil},
	{495, 11436, 1, 71, "Let's Go Surfing Now", 1, 2, nil},
	{495, 11443, 1, 71, "Daggercap Divin'", 1, 2, nil},
	{495, 11448, 1, 71, "The Explorers' League Outpost", 1, 2, nil},
	{495, 11460, 1, 71, "Trust is Earned", 1, 2, nil},
	{495, 11465, 1, 71, "The Ransacked Caravan", 1, 2, nil},
	{495, 11468, 1, 71, "Falcon Versus Hawk", 1, 2, nil},
	{495, 11470, 1, 71, "There Exists No Honor Among Birds", 1, 2, nil},
	{495, 11474, 1, 71, "Problems on the High Bluff", 1, 2, nil},
	{495, 11475, 1, 71, "Tools to Get the Job Done", 1, 2, nil},
	{495, 11478, 1, 71, "Outpost Over Yonder...", 1, 2, nil},
	{495, 11483, 1, 71, "We Can Rebuild It", 1, 2, nil},
	{495, 11484, 1, 71, "We Have the Technology", 1, 2, nil},
	{495, 11485, 1, 71, "Iron Rune Constructs and You: Rocket Jumping", 1, 2, nil},
	{495, 11489, 1, 71, "Iron Rune Constructs and You: Collecting Data", 1, 2, nil},
	{495, 11491, 1, 71, "Iron Rune Constructs and You: The Bluff", 1, 2, nil},
	{495, 11494, 1, 71, "Lightning Infused Relics", 1, 2, nil},
	{495, 11495, 1, 71, "The Delicate Sound of Thunder", 1, 2, nil},
	{495, 11501, 1, 71, "News From the East", 1, 2, nil},
	{495, 11573, 1, 71, "Orfus of Kamagua", 1, 2, nil},
	{495, 11167, 1, 71, "The New Plague", 2, 2, nil},
	{495, 11168, 1, 71, "Spiking the Mix", 2, 2, nil},
	{495, 11170, 1, 71, "Test at Sea", 2, 2, nil},
	{495, 11221, 1, 71, "Reports from the Field", 2, 2, nil},
	{495, 11227, 1, 71, "Let Them Eat Crow", 2, 2, nil},
	{495, 11229, 1, 71, "The Windrunner Fleet", 2, 2, nil},
	{495, 11230, 1, 71, "Ambushed!", 2, 2, nil},
	{495, 11232, 1, 71, "Guide Our Sights", 2, 2, nil},
	{495, 11233, 1, 71, "Landing the Killing Blow", 2, 2, nil},
	{495, 11234, 1, 71, "Report to Anselm", 2, 2, nil},
	{495, 11241, 1, 71, "Trail of Fire", 2, 2, nil},
	{495, 11253, 1, 71, "Sniff Out the Enemy", 2, 2, nil},
	{495, 11254, 1, 71, "The Dragonskin Map", 2, 2, nil},
	{495, 11256, 1, 71, "Skorn Must Fall!", 2, 2, nil},
	{495, 11257, 1, 71, "Gruesome, But Necessary", 2, 2, nil},
	{495, 11258, 1, 71, "Burn Skorn, Burn!", 2, 2, nil},
	{495, 11259, 1, 71, "Towers of Certain Doom", 2, 2, nil},
	{495, 11263, 1, 71, "Dealing With Gjalerbron", 2, 2, nil},
	{495, 11265, 1, 71, "Of Keys and Cages", 2, 2, nil},
	{495, 11268, 1, 71, "The Walking Dead", 2, 2, nil},
	{495, 11270, 1, 71, "War is Hell", 2, 2, nil},
	{495, 11271, 1, 71, "Hasty Preparations", 2, 2, nil},
	{495, 11275, 1, 71, "Making the Horn", 2, 2, nil},
	{495, 11279, 1, 71, "Green Eggs and Whelps", 2, 2, nil},
	{495, 11280, 1, 71, "Draconis Gastritis", 2, 2, nil},
	{495, 11281, 1, 71, "Mimicking Nature's Call", 2, 2, nil},
	{495, 11282, 1, 71, "A Lesson in Fear", 2, 2, nil},
	{495, 11283, 1, 71, "Baleheim Bodycount", 2, 2, nil},
	{495, 11285, 1, 71, "Baleheim Must Burn!", 2, 2, nil},
	{495, 11286, 1, 71, "The Artifacts of Steel Gate", 2, 2, nil},
	{495, 11287, 1, 71, "Find Sage Mistwalker", 2, 2, nil},
	{495, 11295, 1, 71, "The Offensive Begins", 2, 2, nil},
	{495, 11297, 1, 71, "Keeping Watch on the Interlopers", 2, 2, nil},
	{495, 11298, 1, 71, "What's in That Brew?", 2, 2, nil},
	{495, 11301, 1, 71, "Brains! Brains! Brains!", 2, 2, nil},
	{495, 11303, 1, 71, "The Ambush", 2, 2, nil},
	{495, 11304, 1, 71, "New Agamand", 2, 2, nil},
	{495, 11305, 1, 71, "A Tailor-Made Formula", 2, 2, nil},
	{495, 11306, 1, 71, "Apply Heat and Stir", 2, 2, nil},
	{495, 11307, 1, 71, "Field Test", 2, 2, nil},
	{495, 11308, 1, 71, "Time for Cleanup", 2, 2, nil},
	{495, 11309, 1, 71, "Parts for the Job", 2, 2, nil},
	{495, 11310, 1, 71, "Warning: Some Assembly Required", 2, 2, nil},
	{495, 11311, 1, 71, "Suppressing the Elements", 2, 2, nil},
	{495, 11312, 1, 71, "The Frozen Glade", 2, 2, nil},
	{495, 11317, 1, 71, "The Cleansing", 2, 2, nil},
	{495, 11350, 1, 71, "The Book of Runes", 2, 2, nil},
	{495, 11351, 1, 71, "Mastering the Runes", 2, 2, nil},
	{495, 11352, 1, 71, "The Rune of Command", 2, 2, nil},
	{495, 11397, 1, 71, "And You Thought Murlocs Smelled Bad!", 2, 2, nil},
	{495, 11398, 1, 71, "It's a Scourge Device", 2, 2, nil},
	{495, 11399, 1, 71, "Bring Down Those Shields", 2, 2, nil},
	{495, 11415, 1, 71, "Brother Betrayers", 2, 2, nil},
	{495, 11417, 1, 71, "Eyes of the Eagle", 2, 2, nil},
	{495, 11423, 1, 71, "The Enemy's Legacy", 2, 2, nil},
	{495, 11424, 1, 71, "Shield Hill", 2, 2, nil},
	{495, 11433, 1, 71, "Sleeping Giants", 2, 2, nil},
	{495, 11434, 1, 71, "Forgotten Treasure", 2, 2, nil},
	{495, 11455, 1, 71, "The Fragrance of Money", 2, 2, nil},
	{495, 11459, 1, 71, "Zeh'gehn Sez", 2, 2, nil},
	{495, 11464, 1, 71, "Gambling Debt", 2, 2, nil},
	{495, 11466, 1, 71, "Jack Likes His Drink", 2, 2, nil},
	{495, 11467, 1, 71, "Dead Man's Debt", 2, 2, nil},
	{495, 11473, 1, 71, "A Traitor Among Us", 2, 2, nil},
	{495, 11476, 1, 71, "A Carver and a Croaker", 2, 2, nil},
	{495, 11479, 1, 71, "\"Crowleg\" Dan", 2, 2, nil},
	{495, 11480, 1, 71, "Meet Number Two", 2, 2, nil},
	{495, 11509, 1, 71, "Street \"Cred\" ", 2, 2, nil},
	{495, 11510, 1, 71, "\"Scoodles\" ", 2, 2, nil},
	{495, 11511, 1, 71, "The Staff of Storm's Fury", 2, 2, nil},
	{495, 11512, 1, 71, "The Frozen Heart of Isuldof", 2, 2, nil},
	{495, 11519, 1, 71, "The Lost Shield of the Aesirites", 2, 2, nil},
	{495, 11567, 1, 71, "The Ancient Armor of the Kvaldir", 2, 2, nil},
	{495, 12481, 1, 71, "Adding Injury to Insult", 2, 2, nil},
	{495, 12482, 1, 71, "Against Nifflevar", 2, 2, nil},
	{495, 12566, 1, 71, "Help for Camp Winterhoof", 2, 2, nil},
	{495, 11182, 1, 71, "Root Causes", 3, 2, nil},
	{495, 11313, 1, 71, "Spirits of the Ice", 3, 2, nil},
	{495, 11314, 1, 71, "The Fallen Sisters", 3, 2, nil},
	{495, 11315, 1, 71, "Wild Vines", 3, 2, nil},
	{495, 11316, 1, 71, "Spawn of the Twisted Glade", 3, 2, nil},
	{495, 11319, 1, 71, "Seeds of the Blacksouled Keepers", 3, 2, nil},
	{495, 11422, 1, 71, "Trident of the Son", 3, 2, nil},
	{495, 11428, 1, 71, "Keeper Witherleaf", 3, 2, nil},
	{495, 11456, 1, 71, "Feeding the Survivors", 3, 2, nil},
	{495, 11457, 1, 71, "Arming Kamagua", 3, 2, nil},
	{495, 11458, 1, 71, "Avenge Iskaal", 3, 2, nil},
	{495, 11469, 1, 71, "Swabbin' Soap", 3, 2, nil},
	{495, 11471, 1, 71, "The Jig is Up [Group]", 3, 2, nil},
	{495, 11504, 1, 71, "The Dead Rise!", 3, 2, nil},
	{495, 11507, 1, 71, "Elder Atuik and Kamagua", 3, 2, nil},
	{495, 11508, 1, 71, "Grezzix Spindlesnap", 3, 2, nil},
	{495, 11527, 1, 71, "Mutiny on the Mercy", 3, 2, nil},
	{495, 11529, 1, 71, "Sorlof's Booty", 3, 2, nil},
	{495, 11530, 1, 71, "The Shield of the Aesirites", 3, 2, nil},
	{495, 11568, 1, 71, "A Return to Resting", 3, 2, nil},
	{495, 11572, 1, 71, "Return to Atuik", 3, 2, nil},
	{495, 11236, 1, 72, "Necro Overlord Mezhen", 1, 2, nil},
	{495, 11237, 1, 72, "Gjalerbron Attack Plans", 1, 2, nil},
	{495, 11238, 1, 72, "The Frost Wyrm and its Master [Group]", 1, 2, nil},
	{495, 11249, 1, 72, "Stop the Ascension!", 1, 2, nil},
	{495, 11250, 1, 72, "All Hail the Conqueror of Skorn!", 1, 2, nil},
	{495, 11355, 1, 72, "March of the Giants [Group]", 1, 2, nil},
	{495, 11358, 1, 72, "The Lodestone [Group]", 1, 2, nil},
	{495, 11359, 1, 72, "Demolishing Megalith [Group]", 1, 2, nil},
	{495, 11260, 1, 72, "Stop the Ascension!", 2, 2, nil},
	{495, 11261, 1, 72, "The Conqueror of Skorn!", 2, 2, nil},
	{495, 11264, 1, 72, "Necro Overlord Mezhen", 2, 2, nil},
	{495, 11266, 1, 72, "Gjalerbron Attack Plans", 2, 2, nil},
	{495, 11267, 1, 72, "The Frost Wyrm and its Master [Group]", 2, 2, nil},
	{495, 11296, 1, 72, "Rivenwood Captives", 2, 2, nil},
	{495, 11365, 1, 72, "March of the Giants [Group]", 2, 2, nil},
	{495, 11366, 1, 72, "The Lodestone [Group]", 2, 2, nil},
	{495, 11367, 1, 72, "Demolishing Megalith [Group]", 2, 2, nil},
	{495, 11453, 1, 72, "The Slumbering King", 2, 2, nil},
	{495, 12181, 1, 72, "Give it a Name", 2, 2, nil},
	{210, 25238, 1, 0, "Strength Ring Flag", 4, 2, nil},
	{210, 13226, 1, 78, "Judgment Day Comes!", 1, 2, nil},
	{210, 13227, 1, 78, "Judgment Day Comes!", 2, 2, nil},
	{210, 13008, 1, 78, "Scourge Tactics", 3, 2, nil},
	{210, 13036, 1, 78, "Honor Above All Else", 3, 2, nil},
	{210, 13039, 1, 78, "Defending The Vanguard", 3, 2, nil},
	{210, 13040, 1, 78, "Curing The Incurable", 3, 2, nil},
	{210, 13044, 1, 78, "If There Are Survivors...", 3, 2, nil},
	{210, 13045, 1, 78, "Into The Wild Green Yonder", 3, 2, nil},
	{210, 13070, 1, 78, "A Cold Front Approaches", 3, 2, nil},
	{210, 13086, 1, 78, "The Last Line Of Defense", 3, 2, nil},
	{210, 13104, 1, 78, "Once More Unto The Breach, Hero", 3, 2, nil},
	{210, 13105, 1, 78, "Once More Unto The Breach, Hero", 3, 1, "TODO:CLASS"},
	{210, 13110, 1, 78, "The Restless Dead", 3, 2, nil},
	{210, 13118, 1, 78, "The Purging Of Scourgeholme", 3, 2, nil},
	{210, 13122, 1, 78, "The Scourgestone", 3, 2, nil},
	{210, 13225, 1, 79, "The Skybreaker", 1, 2, nil},
	{210, 13224, 1, 79, "Orgrim's Hammer", 2, 2, nil},
	{210, 13125, 1, 79, "The Air Stands Still", 3, 2, nil},
	{210, 13130, 1, 79, "The Stone That Started A Revolution", 3, 2, nil},
	{210, 13135, 1, 79, "It Could Kill Us All", 3, 2, nil},
	{210, 13139, 1, 79, "Into The Frozen Heart Of Northrend", 3, 2, nil},
	{210, 13141, 1, 79, "The Battle For Crusaders' Pinnacle", 3, 2, nil},
	{210, 13157, 1, 79, "The Crusaders' Pinnacle", 3, 2, nil},
	{210, 13175, 1, 80, "Regaining Control", 4, 2, nil},
	{210, 13176, 1, 80, "Preparing the Delivery", 4, 2, nil},
	{210, 13184, 1, 80, "Outliving Usefulness", 4, 2, nil},
	{210, 13302, 3, 80, "Slaves to Saronite", 4, 2, nil},
	{210, 12887, 1, 80, "It's All Fun and Games", 1, 2, nil},
	{210, 12896, 1, 80, "If He Cannot Be Turned", 1, 2, nil},
	{210, 12898, 1, 80, "The Shadow Vault", 1, 2, nil},
	{210, 13221, 1, 80, "I'm Not Dead Yet!", 1, 2, nil},
	{210, 13231, 1, 80, "The Broken Front", 1, 2, nil},
	{210, 13232, 1, 80, "Finish Me!", 1, 2, nil},
	{210, 13233, 3, 80, "No Mercy! [PvP]", 1, 2, nil},
	{210, 13280, 3, 80, "King of the Mountain [PvP]", 1, 2, nil},
	{210, 13284, 3, 80, "Assault by Ground", 1, 2, nil},
	{210, 13286, 1, 80, "...All the Help We Can Get.", 1, 2, nil},
	{210, 13287, 1, 80, "Poke and Prod", 1, 2, nil},
	{210, 13288, 1, 80, "That's Abominable!", 1, 2, nil},
	{210, 13289, 3, 80, "That's Abominable!", 1, 2, nil},
	{210, 13290, 1, 80, "Your Attention, Please", 1, 2, nil},
	{210, 13291, 1, 80, "Borrowed Technology", 1, 2, nil},
	{210, 13292, 3, 80, "The Solution Solution", 1, 2, nil},
	{210, 13294, 1, 80, "Against the Giants [Group]", 1, 2, nil},
	{210, 13295, 1, 80, "Basic Chemistry [Group]", 1, 2, nil},
	{210, 13296, 1, 80, "Get to Ymirheim!", 1, 2, nil},
	{210, 13297, 3, 80, "Neutralizing the Plague [Group]", 1, 2, nil},
	{210, 13298, 1, 80, "Coprous the Defiled [Group]", 1, 2, nil},
	{210, 13300, 3, 80, "Slaves to Saronite", 1, 2, nil},
	{210, 13309, 3, 80, "Assault by Air", 1, 2, nil},
	{210, 13314, 1, 80, "Get the Message", 1, 2, nil},
	{210, 13315, 1, 80, "Sneak Preview", 1, 2, nil},
	{210, 13318, 1, 80, "Drag and Drop", 1, 2, nil},
	{210, 13319, 1, 80, "Chain of Command", 1, 2, nil},
	{210, 13320, 1, 80, "Cannot Reproduce", 1, 2, nil},
	{210, 13321, 1, 80, "Retest Now", 1, 2, nil},
	{210, 13322, 3, 80, "Retest Now", 1, 2, nil},
	{210, 13323, 3, 80, "Drag and Drop", 1, 2, nil},
	{210, 13332, 1, 80, "Raise the Barricades", 1, 2, nil},
	{210, 13333, 3, 80, "Capture More Dispatches", 1, 2, nil},
	{210, 13334, 1, 80, "Bloodspattered Banners", 1, 2, nil},
	{210, 13335, 1, 80, "Before the Gate of Horror [Group]", 1, 2, nil},
	{210, 13336, 3, 80, "Blood of the Chosen", 1, 2, nil},
	{210, 13337, 1, 80, "The Ironwall Rampart [Group]", 1, 2, nil},
	{210, 13338, 1, 80, "The Guardians of Corp'rethar [Group]", 1, 2, nil},
	{210, 13339, 1, 80, "Shatter the Shards [Group]", 1, 2, nil},
	{210, 13341, 1, 80, "Joining the Assault", 1, 2, nil},
	{210, 13342, 1, 80, "Not a Bug", 1, 2, nil},
	{210, 13344, 3, 80, "Not a Bug", 1, 2, nil},
	{210, 13345, 1, 80, "Need More Info [Group]", 1, 2, nil},
	{210, 13346, 1, 80, "No Rest For The Wicked [Group]", 1, 2, nil},
	{210, 13350, 3, 80, "No Rest For The Wicked [Group]", 1, 2, nil},
	{210, 13380, 1, 80, "Leading the Charge", 1, 2, nil},
	{210, 13381, 1, 80, "Watts My Target", 1, 2, nil},
	{210, 13382, 3, 80, "Putting the Hertz: The Valley of Lost Hope", 1, 2, nil},
	{210, 13383, 1, 80, "Killohertz", 1, 2, nil},
	{210, 13386, 1, 80, "Exploiting an Opening", 1, 2, nil},
	{210, 13387, 1, 80, "Securing the Perimeter", 1, 2, nil},
	{210, 13388, 1, 80, "Set it Off!", 1, 2, nil},
	{210, 13389, 1, 80, "A Short Fuse", 1, 2, nil},
	{210, 13390, 1, 80, "A Voice in the Dark", 1, 2, nil},
	{210, 13391, 1, 80, "Time to Hide", 1, 2, nil},
	{210, 13392, 1, 80, "Return to the Surface", 1, 2, nil},
	{210, 13393, 1, 80, "Field Repairs", 1, 2, nil},
	{210, 13394, 1, 80, "Do Your Worst", 1, 2, nil},
	{210, 13395, 1, 80, "Army of the Damned", 1, 2, nil},
	{210, 13396, 1, 80, "Futility", 1, 2, nil},
	{210, 13397, 1, 80, "Sindragosa's Fall", 1, 2, nil},
	{210, 13398, 1, 80, "Where Dragons Fell", 1, 2, nil},
	{210, 13399, 1, 80, "Time for Answers", 1, 2, nil},
	{210, 13400, 1, 80, "The Hunter and the Prince", 1, 2, nil},
	{210, 13401, 1, 80, "Knowledge is a Terrible Burden", 1, 2, nil},
	{210, 13402, 1, 80, "Tirion's Help", 1, 2, nil},
	{210, 13403, 1, 80, "Tirion's Gambit", 1, 2, nil},
	{210, 13404, 3, 80, "Static Shock Troops: the Bombardment", 1, 2, nil},
	{210, 13418, 1, 80, "Preparations for War", 1, 2, nil},
	{210, 13482, 1, 80, "Let's Get Out of Here", 1, 2, nil},
	{210, 14443, 1, 80, "The Battered Hilt", 1, 2, nil},
	{210, 14444, 1, 80, "What The Dragons Know", 1, 2, nil},
	{210, 20438, 1, 80, "A Suitable Disguise", 1, 2, nil},
	{210, 20439, 1, 80, "A Meeting With The Magister", 1, 2, nil},
	{210, 24454, 1, 80, "Return To Caladis Brightspear", 1, 2, nil},
	{210, 24476, 1, 80, "Tempering The Blade", 1, 2, nil},
	{210, 24795, 1, 80, "A Victory For The Silver Covenant", 1, 1, "TODO:CLASS"},
	{210, 24796, 1, 80, "A Victory For The Silver Covenant", 1, 2, nil},
	{210, 12892, 1, 80, "It's All Fun and Games", 2, 2, nil},
	{210, 12897, 1, 80, "If He Cannot Be Turned", 2, 2, nil},
	{210, 12899, 1, 80, "The Shadow Vault", 2, 2, nil},
	{210, 13228, 1, 80, "The Broken Front", 2, 2, nil},
	{210, 13229, 1, 80, "I'm Not Dead Yet!", 2, 2, nil},
	{210, 13230, 1, 80, "Avenge Me!", 2, 2, nil},
	{210, 13234, 3, 80, "Make Them Pay! [PvP]", 2, 2, nil},
	{210, 13236, 1, 80, "Army of the Damned", 2, 2, nil},
	{210, 13237, 1, 80, "Poke and Prod", 2, 2, nil},
	{210, 13238, 1, 80, "Good For Something?", 2, 2, nil},
	{210, 13239, 1, 80, "Volatility", 2, 2, nil},
	{210, 13258, 1, 80, "Opportunity", 2, 2, nil},
	{210, 13259, 1, 80, "Establishing Superiority", 2, 2, nil},
	{210, 13260, 1, 80, "Takes One to Know One", 2, 2, nil},
	{210, 13261, 3, 80, "Volatility", 2, 2, nil},
	{210, 13262, 1, 80, "Blow it Up!", 2, 2, nil},
	{210, 13263, 1, 80, "A Short Fuse", 2, 2, nil},
	{210, 13264, 1, 80, "That's Abominable!", 2, 2, nil},
	{210, 13271, 1, 80, "A Voice in the Dark", 2, 2, nil},
	{210, 13275, 1, 80, "Time to Hide", 2, 2, nil},
	{210, 13276, 3, 80, "That's Abominable!", 2, 2, nil},
	{210, 13277, 1, 80, "Against the Giants [Group]", 2, 2, nil},
	{210, 13278, 1, 80, "Coprous the Defiled [Group]", 2, 2, nil},
	{210, 13279, 1, 80, "Basic Chemistry [Group]", 2, 2, nil},
	{210, 13281, 3, 80, "Neutralizing the Plague [Group]", 2, 2, nil},
	{210, 13282, 1, 80, "Return to the Surface", 2, 2, nil},
	{210, 13283, 3, 80, "King of the Mountain [PvP]", 2, 2, nil},
	{210, 13293, 1, 80, "Get to Ymirheim!", 2, 2, nil},
	{210, 13301, 3, 80, "Assault by Ground", 2, 2, nil},
	{210, 13304, 1, 80, "Field Repairs", 2, 2, nil},
	{210, 13305, 1, 80, "Do Your Worst", 2, 2, nil},
	{210, 13306, 1, 80, "Raise the Barricades", 2, 2, nil},
	{210, 13307, 1, 80, "Bloodspattered Banners", 2, 2, nil},
	{210, 13310, 3, 80, "Assault by Air", 2, 2, nil},
	{210, 13312, 1, 80, "The Ironwall Rampart [Group]", 2, 2, nil},
	{210, 13313, 1, 80, "Blinding the Eyes in the Sky", 2, 2, nil},
	{210, 13316, 1, 80, "The Guardians of Corp'rethar [Group]", 2, 2, nil},
	{210, 13328, 1, 80, "Shatter the Shards [Group]", 2, 2, nil},
	{210, 13329, 1, 80, "Before the Gate of Horror [Group]", 2, 2, nil},
	{210, 13330, 3, 80, "Blood of the Chosen", 2, 2, nil},
	{210, 13331, 3, 80, "Keeping the Alliance Blind", 2, 2, nil},
	{210, 13340, 1, 80, "Joining the Assault", 2, 2, nil},
	{210, 13348, 1, 80, "Futility", 2, 2, nil},
	{210, 13349, 1, 80, "Cradle of the Frostbrood", 2, 2, nil},
	{210, 13351, 1, 80, "Sneak Preview", 2, 2, nil},
	{210, 13352, 1, 80, "Drag and Drop", 2, 2, nil},
	{210, 13353, 3, 80, "Drag and Drop", 2, 2, nil},
	{210, 13354, 1, 80, "Chain of Command", 2, 2, nil},
	{210, 13355, 1, 80, "Cannot Reproduce", 2, 2, nil},
	{210, 13356, 1, 80, "Retest Now", 2, 2, nil},
	{210, 13357, 3, 80, "Retest Now", 2, 2, nil},
	{210, 13358, 1, 80, "Not a Bug", 2, 2, nil},
	{210, 13359, 1, 80, "Where Dragons Fell", 2, 2, nil},
	{210, 13360, 1, 80, "Time for Answers", 2, 2, nil},
	{210, 13361, 1, 80, "The Hunter and the Prince", 2, 2, nil},
	{210, 13362, 1, 80, "Knowledge is a Terrible Burden", 2, 2, nil},
	{210, 13363, 1, 80, "Argent Aid", 2, 2, nil},
	{210, 13364, 1, 80, "Tirion's Gambit", 2, 2, nil},
	{210, 13365, 3, 80, "Not a Bug", 2, 2, nil},
	{210, 13366, 1, 80, "Need More Info [Group]", 2, 2, nil},
	{210, 13367, 1, 80, "No Rest For The Wicked [Group]", 2, 2, nil},
	{210, 13368, 3, 80, "No Rest For The Wicked [Group]", 2, 2, nil},
	{210, 13373, 1, 80, "Fringe Science Benefits", 2, 2, nil},
	{210, 13374, 1, 80, "Amped for Revolt!", 2, 2, nil},
	{210, 13376, 3, 80, "Total Ohmage: The Valley of Lost Hope!", 2, 2, nil},
	{210, 13379, 1, 80, "Green Technology", 2, 2, nil},
	{210, 13406, 3, 80, "Riding the Wavelength: The Bombardment", 2, 2, nil},
	{210, 13419, 1, 80, "Preparations for War", 2, 2, nil},
	{210, 13481, 1, 80, "Let's Get Out of Here!", 2, 2, nil},
	{210, 24451, 1, 80, "An Audience With The Arcanist", 2, 2, nil},
	{210, 24554, 1, 80, "The Battered Hilt", 2, 2, nil},
	{210, 24555, 1, 80, "What The Dragons Know", 2, 2, nil},
	{210, 24556, 1, 80, "A Suitable Disguise", 2, 2, nil},
	{210, 24558, 1, 80, "Return To Myralion Sunblaze", 2, 2, nil},
	{210, 24560, 1, 80, "Tempering The Blade", 2, 2, nil},
	{210, 24798, 1, 80, "A Victory For The Sunreavers", 2, 1, "TODO:CLASS"},
	{210, 24799, 1, 80, "A Victory For The Sunreavers", 2, 1, "TODO:CLASS"},
	{210, 24800, 1, 80, "A Victory For The Sunreavers", 2, 2, nil},
	{210, 24801, 1, 80, "A Victory For The Sunreavers", 2, 2, nil},
	{210, 12806, 1, 80, "To the Rise with all Due Haste!", 3, 2, nil},
	{210, 12807, 1, 80, "The Story Thus Far...", 3, 2, nil},
	{210, 12810, 1, 80, "Blood in the Water", 3, 2, nil},
	{210, 12813, 3, 80, "From Their Corpses, Rise!", 3, 2, nil},
	{210, 12814, 1, 80, "You'll Need a Gryphon", 3, 2, nil},
	{210, 12815, 3, 80, "No Fly Zone", 3, 2, nil},
	{210, 12838, 3, 80, "Intelligence Gathering", 3, 2, nil},
	{210, 12839, 1, 80, "The Grand (Admiral's) Plan", 3, 2, nil},
	{210, 12840, 1, 80, "In Strict Confidence", 3, 2, nil},
	{210, 12847, 1, 80, "Second Chances [Group]", 3, 2, nil},
	{210, 12852, 1, 80, "The Admiral Revealed [Group]", 3, 2, nil},
	{210, 12891, 1, 80, "I Have an Idea, But First...", 3, 2, nil},
	{210, 12893, 1, 80, "Free Your Mind", 3, 2, nil},
	{210, 12938, 1, 80, "The Duke", 3, 2, nil},
	{210, 12939, 1, 80, "Honor Challenge", 3, 2, nil},
	{210, 12943, 1, 80, "Shadow Vault Decree", 3, 2, nil},
	{210, 12949, 1, 80, "Get the Key", 3, 2, nil},
	{210, 12951, 1, 80, "Let the Baron Know", 3, 2, nil},
	{210, 12955, 1, 80, "Eliminate the Competition", 3, 2, nil},
	{210, 12982, 1, 80, "Ebon Blade Prisoners", 3, 2, nil},
	{210, 12992, 1, 80, "Crush Dem Vrykuls!", 3, 2, nil},
	{210, 12995, 3, 80, "Leave Our Mark", 3, 2, nil},
	{210, 12999, 1, 80, "The Bone Witch", 3, 2, nil},
	{210, 13042, 1, 80, "Deep in the Bowels of The Underhalls", 3, 2, nil},
	{210, 13043, 1, 80, "The Sum is Greater than the Parts", 3, 2, nil},
	{210, 13059, 1, 80, "Revenge for the Vargul", 3, 2, nil},
	{210, 13068, 1, 80, "A Tale of Valor", 3, 2, nil},
	{210, 13069, 3, 80, "Shoot 'Em Up", 3, 2, nil},
	{210, 13071, 3, 80, "Vile Like Fire!", 3, 2, nil},
	{210, 13072, 1, 80, "A Hero Remains", 3, 2, nil},
	{210, 13073, 1, 80, "The Keeper's Favor", 3, 2, nil},
	{210, 13074, 1, 80, "Hope Within the Emerald Nightmare", 3, 2, nil},
	{210, 13075, 1, 80, "The Boon of Remulos", 3, 2, nil},
	{210, 13076, 1, 80, "Time Yet Remains", 3, 2, nil},
	{210, 13077, 1, 80, "The Touch of an Aspect", 3, 2, nil},
	{210, 13079, 1, 80, "The Boon of Alexstrasza", 3, 2, nil},
	{210, 13080, 1, 80, "Hope Yet Remains", 3, 2, nil},
	{210, 13081, 1, 80, "The Will of the Naaru", 3, 2, nil},
	{210, 13082, 1, 80, "The Boon of A'dal", 3, 2, nil},
	{210, 13083, 1, 80, "Light Within the Darkness", 3, 2, nil},
	{210, 13084, 1, 80, "Vandalizing Jotunheim", 3, 2, nil},
	{210, 13085, 1, 80, "Vaelen Has Returned", 3, 2, nil},
	{210, 13091, 1, 80, "The Art of Being a Water Terror", 3, 2, nil},
	{210, 13092, 1, 80, "Reading the Bones", 3, 2, nil},
	{210, 13093, 2, 80, "Reading the Bones", 3, 2, nil},
	{210, 13106, 1, 80, "Blackwatch", 3, 2, nil},
	{210, 13117, 1, 80, "Where Are They Coming From?", 3, 2, nil},
	{210, 13119, 1, 80, "Destroying the Altars", 3, 2, nil},
	{210, 13120, 1, 80, "Death's Gaze", 3, 2, nil},
	{210, 13121, 1, 80, "Through the Eye", 3, 2, nil},
	{210, 13133, 1, 80, "Find the Ancient Hero", 3, 2, nil},
	{210, 13134, 1, 80, "Spill Their Blood", 3, 2, nil},
	{210, 13136, 1, 80, "Jagged Shards", 3, 2, nil},
	{210, 13137, 1, 80, "Not-So-Honorable Combat [Group]", 3, 2, nil},
	{210, 13138, 1, 80, "I'm Smelting... Smelting!", 3, 2, nil},
	{210, 13140, 1, 80, "The Runesmiths of Malykriss", 3, 2, nil},
	{210, 13142, 1, 80, "Banshee's Revenge [Group]", 3, 2, nil},
	{210, 13143, 1, 80, "New Recruit", 3, 2, nil},
	{210, 13144, 1, 80, "Killing Two Scourge With One Skeleton", 3, 2, nil},
	{210, 13145, 1, 80, "The Vile Hold", 3, 2, nil},
	{210, 13146, 1, 80, "Generosity Abounds", 3, 2, nil},
	{210, 13147, 1, 80, "Matchmaker", 3, 2, nil},
	{210, 13152, 1, 80, "A Visit to the Doctor", 3, 2, nil},
	{210, 13155, 1, 80, "Vereth the Cunning", 3, 2, nil},
	{210, 13160, 1, 80, "Stunning View", 3, 2, nil},
	{210, 13161, 1, 80, "The Rider of the Unholy [Group]", 3, 2, nil},
	{210, 13162, 1, 80, "The Rider of Frost [Group]", 3, 2, nil},
	{210, 13163, 1, 80, "The Rider of Blood [Group]", 3, 2, nil},
	{210, 13164, 1, 80, "The Fate of Bloodbane [Group]", 3, 2, nil},
	{210, 13168, 1, 80, "Parting Gifts", 3, 2, nil},
	{210, 13169, 1, 80, "An Undead's Best Friend", 3, 2, nil},
	{210, 13170, 1, 80, "Honor is for the Weak", 3, 2, nil},
	{210, 13171, 1, 80, "From Whence They Came", 3, 2, nil},
	{210, 13172, 1, 80, "Seeds of Chaos", 3, 2, nil},
	{210, 13174, 1, 80, "Amidst the Confusion", 3, 2, nil},
	{210, 13211, 1, 80, "By Fire Be Purged", 3, 2, nil},
	{210, 13212, 1, 80, "He's Gone to Pieces", 3, 2, nil},
	{210, 13213, 1, 80, "Battle at Valhalas", 3, 2, nil},
	{210, 13214, 1, 80, "Battle at Valhalas: Fallen Heroes [Group]", 3, 2, nil},
	{210, 13215, 1, 80, "Battle at Valhalas: Khit'rix the Dark Master [Group]", 3, 2, nil},
	{210, 13216, 1, 80, "Battle at Valhalas: The Return of Sigrid Iceborn [Group]", 3, 2, nil},
	{210, 13217, 1, 80, "Battle at Valhalas: Carnage! [Group]", 3, 2, nil},
	{210, 13218, 1, 80, "Battle at Valhalas: Thane Deathblow [Group]", 3, 2, nil},
	{210, 13219, 1, 80, "Battle at Valhalas: Final Challenge [Group]", 3, 2, nil},
	{210, 13220, 1, 80, "Putting Olakin Back Together Again", 3, 2, nil},
	{210, 13235, 1, 80, "The Flesh Giant Champion", 3, 2, nil},
	{210, 13308, 1, 80, "Mind Tricks [Group]", 3, 2, nil},
	{3711, 12489, 1, 76, "Welcome to Sholazar Basin", 3, 2, nil},
	{3711, 12520, 1, 76, "Rhino Mastery: The Test", 3, 2, nil},
	{3711, 12521, 1, 76, "Where in the World is Hemet Nesingwary?", 3, 2, nil},
	{3711, 12522, 1, 76, "Need an Engine, Take an Engine", 3, 2, nil},
	{3711, 12523, 1, 76, "Have a Part, Give a Part", 3, 2, nil},
	{3711, 12524, 1, 76, "Venture Co. Misadventure", 3, 2, nil},
	{3711, 12525, 1, 76, "Wipe That Grin Off His Face", 3, 2, nil},
	{3711, 12526, 1, 76, "Rhino Mastery: The Chase", 3, 2, nil},
	{3711, 12543, 1, 76, "An Offering for Soo-rahm", 3, 2, nil},
	{3711, 12544, 1, 76, "The Bones of Nozronn", 3, 2, nil},
	{3711, 12549, 1, 76, "Dreadsaber Mastery: Becoming a Predator", 3, 2, nil},
	{3711, 12550, 1, 76, "Dreadsaber Mastery: Stalking the Prey", 3, 2, nil},
	{3711, 12551, 1, 76, "Crocolisk Mastery: The Trial", 3, 2, nil},
	{3711, 12556, 1, 76, "Rhino Mastery: The Kill", 3, 2, nil},
	{3711, 12558, 1, 76, "Dreadsaber Mastery: Ready to Pounce", 3, 2, nil},
	{3711, 12560, 1, 76, "Crocolisk Mastery: The Plan", 3, 2, nil},
	{3711, 12569, 1, 76, "Crocolisk Mastery: The Ambush", 3, 2, nil},
	{3711, 12589, 1, 76, "Kick, What Kick?", 3, 2, nil},
	{3711, 12592, 1, 76, "The Great Hunter's Challenge", 3, 2, nil},
	{3711, 12624, 1, 76, "It Could Be Anywhere!", 3, 2, nil},
	{3711, 12634, 1, 76, "Some Make Lemonade, Some Make Liquor", 3, 2, nil},
	{3711, 12644, 1, 76, "Still At It", 3, 2, nil},
	{3711, 12645, 1, 76, "The Taste Test", 3, 2, nil},
	{3711, 12654, 1, 76, "The Part-time Hunter", 3, 2, nil},
	{3711, 12688, 1, 76, "Engineering a Disaster", 3, 2, nil},
	{3711, 12804, 1, 76, "A Steak Fit for a Hunter", 3, 2, nil},
	{3711, 12570, 1, 77, "Fortunate Misunderstandings", 1, 2, nil},
	{3711, 12571, 1, 77, "Make the Bad Snake Go Away", 1, 2, nil},
	{3711, 12572, 1, 77, "Gods like Shiny Things", 1, 2, nil},
	{3711, 12573, 1, 77, "Making Peace", 1, 2, nil},
	{3711, 12574, 1, 77, "Back So Soon?", 1, 2, nil},
	{3711, 12577, 1, 77, "Home Time!", 1, 2, nil},
	{3711, 12578, 1, 77, "The Angry Gorloc", 1, 2, nil},
	{3711, 12689, 3, 77, "Hand of the Oracles", 1, 2, nil},
	{3711, 12695, 1, 77, "Return of the Friendly Dryskin", 1, 2, nil},
	{3711, 12704, 3, 77, "Appeasing the Great Rain Stone", 1, 2, nil},
	{3711, 12528, 1, 77, "Playing Along", 3, 2, nil},
	{3711, 12529, 1, 77, "The Ape Hunter's Slave", 3, 2, nil},
	{3711, 12530, 1, 77, "Tormenting the Softknuckles", 3, 2, nil},
	{3711, 12531, 1, 77, "The Underground Menace", 3, 2, nil},
	{3711, 12532, 1, 77, "Flown the Coop!", 3, 2, nil},
	{3711, 12533, 1, 77, "The Wasp Hunter's Apprentice", 3, 2, nil},
	{3711, 12534, 1, 77, "The Sapphire Queen", 3, 2, nil},
	{3711, 12535, 1, 77, "Mischief in the Making", 3, 2, nil},
	{3711, 12536, 1, 77, "A Rough Ride", 3, 2, nil},
	{3711, 12537, 1, 77, "Lightning Definitely Strikes Twice", 3, 2, nil},
	{3711, 12538, 1, 77, "The Mist Isn't Listening", 3, 2, nil},
	{3711, 12539, 1, 77, "Hoofing It", 3, 2, nil},
	{3711, 12540, 1, 77, "Just Following Orders", 3, 2, nil},
	{3711, 12559, 1, 77, "Powering the Waygate - The Maker's Perch", 3, 2, nil},
	{3711, 12561, 1, 77, "An Issue of Trust", 3, 2, nil},
	{3711, 12575, 1, 77, "The Lost Mistwhisper Treasure", 3, 2, nil},
	{3711, 12576, 1, 77, "Forced Hand", 3, 2, nil},
	{3711, 12579, 1, 77, "Lifeblood of the Mosswalker Shrine", 3, 2, nil},
	{3711, 12580, 1, 77, "The Mosswalker Savior", 3, 2, nil},
	{3711, 12581, 1, 77, "A Hero's Burden [Group]", 3, 2, nil},
	{3711, 12582, 3, 77, "Frenzyheart Champion", 3, 2, nil},
	{3711, 12595, 1, 77, "In Search of Bigger Game", 3, 2, nil},
	{3711, 12603, 1, 77, "Sharpening Your Talons", 3, 2, nil},
	{3711, 12605, 1, 77, "Securing the Bait", 3, 2, nil},
	{3711, 12607, 1, 77, "A Mammoth Undertaking", 3, 2, nil},
	{3711, 12611, 1, 77, "Returned Sevenfold", 3, 2, nil},
	{3711, 12612, 1, 77, "The Fallen Pillar", 3, 2, nil},
	{3711, 12613, 1, 77, "Powering the Waygate - The Maker's Overlook", 3, 2, nil},
	{3711, 12614, 1, 77, "Post-partum Aggression", 3, 2, nil},
	{3711, 12617, 1, 77, "Exterminate the Intruders", 3, 2, nil},
	{3711, 12620, 1, 77, "The Lifewarden's Wrath", 3, 2, nil},
	{3711, 12621, 1, 77, "Freya's Pact", 3, 2, nil},
	{3711, 12651, 1, 77, "Lakeside Landing", 3, 2, nil},
	{3711, 12658, 1, 77, "My Pet Roc", 3, 2, nil},
	{3711, 12660, 1, 77, "Weapons of Destruction", 3, 2, nil},
	{3711, 12671, 1, 77, "Reconnaissance Flight", 3, 2, nil},
	{3711, 12681, 1, 77, "Reagent Agent", 3, 2, nil},
	{3711, 12683, 1, 77, "Burning to Help", 3, 2, nil},
	{3711, 12692, 1, 77, "Return of the Lich Hunter", 3, 2, nil},
	{3711, 12696, 1, 77, "Aerial Surveillance", 3, 2, nil},
	{3711, 12699, 1, 77, "An Embarassing Incident", 3, 2, nil},
	{3711, 12702, 3, 77, "Chicken Party!", 3, 2, nil},
	{3711, 12805, 1, 77, "Salvaging Life's Strength", 3, 2, nil},
	{3711, 12703, 3, 78, "Kartak's Rampage", 1, 2, nil},
	{3711, 12759, 3, 78, "Tools of War", 1, 2, nil},
	{3711, 12760, 3, 78, "Secret Strength of the Frenzyheart", 1, 2, nil},
	{3711, 12546, 1, 78, "Reclamation", 3, 2, nil},
	{3711, 12548, 1, 78, "The Etymidian", 3, 2, nil},
	{3711, 12608, 1, 78, "Cultist Incursion", 3, 2, nil},
	{3711, 12691, 1, 78, "A Timeworn Coffer", 3, 2, nil},
	{3711, 12705, 3, 78, "Will of the Titans", 3, 2, nil},
	{3711, 12761, 3, 78, "Mastery of the Crystals", 3, 2, nil},
	{3711, 12762, 3, 78, "Power of the Great Ones", 3, 2, nil},
	{3711, 12797, 1, 78, "Back Through the Waygate", 3, 2, nil},
	{3711, 12803, 1, 78, "Force of Nature", 3, 2, nil},
	{3711, 12726, 3, 80, "Song of Wind and Water", 1, 2, nil},
	{3711, 12735, 3, 80, "A Cleansing Song", 1, 2, nil},
	{3711, 12736, 3, 80, "Song of Reflection", 1, 2, nil},
	{3711, 12737, 3, 80, "Song of Fecundity", 1, 2, nil},
	{3711, 12732, 3, 80, "The Heartblood's Strength", 3, 2, nil},
	{3711, 12734, 3, 80, "Rejek: First Blood", 3, 2, nil},
	{3711, 12741, 3, 80, "Strength of the Tempest", 3, 2, nil},
	{3711, 12758, 3, 80, "A Hero's Headgear", 3, 2, nil},
	{67, 13420, 1, 77, "Everfrost", 3, 2, nil},
	{67, 13421, 2, 77, "Remember Everfrost!", 3, 2, nil},
	{67, 12862, 1, 78, "When All Else Fails", 1, 2, nil},
	{67, 12863, 1, 78, "Offering Thanks", 1, 2, nil},
	{67, 12864, 1, 78, "Missing Scouts", 1, 2, nil},
	{67, 12865, 1, 78, "Loyal Companions", 1, 2, nil},
	{67, 12866, 1, 78, "Stemming the Aggressors", 1, 2, nil},
	{67, 12867, 1, 78, "Baby Stealers", 1, 2, nil},
	{67, 12868, 1, 78, "Sirana Iceshriek [Group]", 1, 2, nil},
	{67, 12869, 3, 78, "Pushed Too Far", 1, 2, nil},
	{67, 12870, 1, 78, "Ancient Relics", 1, 2, nil},
	{67, 12882, 1, 78, "Ancient Relics", 2, 2, nil},
	{67, 13060, 1, 78, "When All Else Fails", 2, 2, nil},
	{67, 12818, 1, 78, "Clean Up", 3, 2, nil},
	{67, 12819, 1, 78, "Just Around the Corner", 3, 2, nil},
	{67, 12820, 1, 78, "A Delicate Touch", 3, 2, nil},
	{67, 12821, 1, 78, "Opening the Backdoor", 3, 2, nil},
	{67, 12822, 1, 78, "Know No Fear", 3, 2, nil},
	{67, 12823, 1, 78, "A Flawless Plan", 3, 2, nil},
	{67, 12824, 1, 78, "Demolitionist Extraordinaire", 3, 2, nil},
	{67, 12826, 1, 78, "Slightly Unstable", 3, 2, nil},
	{67, 12827, 1, 78, "Reclaimed Rations", 3, 2, nil},
	{67, 12828, 1, 78, "Ample Inspiration", 3, 2, nil},
	{67, 12829, 1, 78, "Moving In", 3, 2, nil},
	{67, 12830, 1, 78, "Ore Repossession", 3, 2, nil},
	{67, 12831, 1, 78, "Only Partly Forgotten", 3, 2, nil},
	{67, 12832, 1, 78, "Bitter Departure", 3, 2, nil},
	{67, 12833, 3, 78, "Overstock", 3, 2, nil},
	{67, 12836, 1, 78, "Expression of Gratitude", 3, 2, nil},
	{67, 12846, 1, 78, "Leave No Goblin Behind", 3, 2, nil},
	{67, 12853, 1, 78, "Luxurious Getaway!", 3, 2, nil},
	{67, 12890, 1, 79, "If Size Mattered...", 4, 2, nil},
	{67, 12905, 1, 79, "Mildred the Cruel", 2, 2, nil},
	{67, 12906, 1, 79, "Discipline", 2, 2, nil},
	{67, 12907, 1, 79, "Examples to be Made", 2, 2, nil},
	{67, 12908, 1, 79, "A Certain Prisoner", 2, 2, nil},
	{67, 13000, 1, 79, "Emergency Measures", 2, 2, nil},
	{67, 13061, 1, 79, "Prepare for Glory", 2, 2, nil},
	{67, 13422, 3, 79, "Maintaining Discipline", 2, 2, nil},
	{67, 12841, 1, 79, "The Crone's Bargain", 3, 2, nil},
	{67, 12843, 1, 79, "They Took Our Men!", 3, 2, nil},
	{67, 12844, 1, 79, "Equipment Recovery", 3, 2, nil},
	{67, 12921, 1, 79, "A Change of Scenery", 3, 2, nil},
	{67, 12881, 1, 80, "The Brothers Bronzebeard", 4, 2, nil},
	{67, 12854, 1, 80, "On Brann's Trail", 1, 2, nil},
	{67, 12855, 1, 80, "Sniffing Out the Perpetrator", 1, 2, nil},
	{67, 12858, 1, 80, "Pieces to the Puzzle", 1, 2, nil},
	{67, 12860, 1, 80, "Data Mining", 1, 2, nil},
	{67, 12871, 1, 80, "Aid from the Explorers' League", 1, 2, nil},
	{67, 12872, 1, 80, "Norgannon's Shell", 1, 2, nil},
	{67, 12873, 1, 80, "The Frostborn King", 1, 2, nil},
	{67, 12874, 1, 80, "Fervor of the Frostborn", 1, 2, nil},
	{67, 12875, 1, 80, "An Experienced Guide", 1, 2, nil},
	{67, 12876, 1, 80, "Unwelcome Guests", 1, 2, nil},
	{67, 12877, 1, 80, "The Lonesome Watcher", 1, 2, nil},
	{67, 12878, 1, 80, "The Hidden Relic", 1, 2, nil},
	{67, 12879, 1, 80, "Fury of the Frostborn King", 1, 2, nil},
	{67, 12880, 1, 80, "The Master Explorer", 1, 2, nil},
	{67, 12885, 1, 80, "The Exiles of Ulduar", 1, 2, nil},
	{67, 12973, 1, 80, "The Brothers Bronzebeard", 1, 2, nil},
	{67, 12986, 1, 80, "Fate of the Titans", 1, 2, nil},
	{67, 13415, 1, 80, "The Library Console", 1, 2, nil},
	{67, 12851, 1, 80, "Going Bearback", 2, 2, nil},
	{67, 12856, 1, 80, "Cold Hearted", 2, 2, nil},
	{67, 12886, 1, 80, "The Drakkensryd", 2, 2, nil},
	{67, 12895, 1, 80, "The Missing Bronzebeard", 2, 2, nil},
	{67, 12900, 1, 80, "Making a Harness", 2, 2, nil},
	{67, 12909, 1, 80, "The Nose Knows", 2, 2, nil},
	{67, 12910, 1, 80, "Sniffing Out the Perpetrator", 2, 2, nil},
	{67, 12913, 1, 80, "Speak Orcish, Man!", 2, 2, nil},
	{67, 12917, 1, 80, "Speaking with the Wind's Voice", 2, 2, nil},
	{67, 12920, 1, 80, "Catching up with Brann", 2, 2, nil},
	{67, 12925, 1, 80, "Aberrations", 2, 2, nil},
	{67, 12926, 1, 80, "Pieces of the Puzzle", 2, 2, nil},
	{67, 12927, 1, 80, "Data Mining", 2, 2, nil},
	{67, 12928, 1, 80, "Norgannon's Shell", 2, 2, nil},
	{67, 12929, 1, 80, "The Earthen of Ulduar", 2, 2, nil},
	{67, 12942, 1, 80, "Off With Their Black Wings", 2, 2, nil},
	{67, 12953, 1, 80, "Valkyrion Must Burn", 2, 2, nil},
	{67, 12968, 1, 80, "Yulda's Folly", 2, 2, nil},
	{67, 12972, 1, 80, "You'll Need a Bear", 2, 2, nil},
	{67, 12983, 1, 80, "The Last of Her Kind", 2, 2, nil},
	{67, 12989, 1, 80, "The Slithering Darkness", 2, 2, nil},
	{67, 12996, 1, 80, "The Warm-Up ", 2, 2, nil},
	{67, 12997, 1, 80, "Into the Pit", 2, 2, nil},
	{67, 13034, 1, 80, "The Witness and the Hero", 2, 2, nil},
	{67, 13037, 1, 80, "Memories of Stormhoof", 2, 2, nil},
	{67, 13038, 1, 80, "Distortions in Time", 2, 2, nil},
	{67, 13048, 1, 80, "Where Time Went Wrong", 2, 2, nil},
	{67, 13049, 1, 80, "The Hero's Arms", 2, 2, nil},
	{67, 13054, 1, 80, "The Missing Tracker", 2, 2, nil},
	{67, 13055, 1, 80, "Cave Medicine", 2, 2, nil},
	{67, 13056, 1, 80, "There's Always Time for Revenge", 2, 2, nil},
	{67, 13058, 1, 80, "Changing the Wind's Course", 2, 2, nil},
	{67, 13062, 1, 80, "Lok'lira's Parting Gift", 2, 2, nil},
	{67, 13063, 1, 80, "Deemed Worthy", 2, 2, nil},
	{67, 13273, 1, 80, "Going After the Core", 2, 2, nil},
	{67, 13274, 1, 80, "The Core's Keeper", 2, 2, nil},
	{67, 13285, 1, 80, "Forging the Keystone", 2, 2, nil},
	{67, 13416, 1, 80, "The Library Console", 2, 2, nil},
	{67, 13423, 3, 80, "Defending Your Title", 2, 2, nil},
	{67, 13424, 3, 80, "Back to the Pit", 2, 2, nil},
	{67, 13425, 3, 80, "The Aberrations Must Die", 2, 2, nil},
	{67, 13426, 1, 80, "Xarantaur, the Witness", 2, 2, nil},
	{67, 12888, 1, 80, "SCRAP-E", 3, 2, nil},
	{67, 12889, 1, 80, "The Prototype Console", 3, 2, nil},
	{67, 12915, 1, 80, "Mending Fences", 3, 2, nil},
	{67, 12922, 1, 80, "The Refiner's Fire", 3, 2, nil},
	{67, 12924, 1, 80, "Forging an Alliance", 3, 2, nil},
	{67, 12930, 1, 80, "Rare Earth", 3, 2, nil},
	{67, 12931, 1, 80, "Fighting Back", 3, 2, nil},
	{67, 12937, 1, 80, "Relief for the Fallen", 3, 2, nil},
	{67, 12956, 1, 80, "A Spark of Hope", 3, 2, nil},
	{67, 12957, 1, 80, "Slaves of the Stormforged", 3, 2, nil},
	{67, 12964, 1, 80, "The Dark Ore", 3, 2, nil},
	{67, 12965, 1, 80, "The Gifts of Loken", 3, 2, nil},
	{67, 12966, 1, 80, "You Can't Miss Him", 3, 2, nil},
	{67, 12967, 1, 80, "Battling the Elements", 3, 2, nil},
	{67, 12969, 1, 80, "Is That Your Goblin?", 3, 2, nil},
	{67, 12970, 1, 80, "The Hyldsmeet", 3, 2, nil},
	{67, 12971, 1, 80, "Taking on All Challengers", 3, 2, nil},
	{67, 12975, 1, 80, "In Memoriam", 3, 2, nil},
	{67, 12976, 1, 80, "A Monument to the Fallen", 3, 2, nil},
	{67, 12977, 3, 80, "Blowing Hodir's Horn", 3, 2, nil},
	{67, 12978, 1, 80, "Facing the Storm", 3, 2, nil},
	{67, 12979, 1, 80, "Armor of Darkness", 3, 2, nil},
	{67, 12980, 1, 80, "The Armor's Secrets", 3, 2, nil},
	{67, 12981, 3, 80, "Hot and Cold", 3, 2, nil},
	{67, 12984, 1, 80, "Valduran the Stormborn", 3, 2, nil},
	{67, 12985, 1, 80, "Forging a Head", 3, 2, nil},
	{67, 12987, 1, 80, "Mounting Hodir's Helm", 3, 2, nil},
	{67, 12988, 1, 80, "Destroy the Forges!", 3, 2, nil},
	{67, 12991, 1, 80, "Hit Them Where it Hurts", 3, 2, nil},
	{67, 12993, 1, 80, "A Colossal Threat", 3, 2, nil},
	{67, 12994, 3, 80, "Spy Hunter", 3, 2, nil},
	{67, 12998, 1, 80, "The Heart of the Storm", 3, 2, nil},
	{67, 13001, 1, 80, "Raising Hodir's Spear", 3, 2, nil},
	{67, 13003, 3, 80, "Thrusting Hodir's Spear", 3, 2, nil},
	{67, 13005, 1, 80, "The Earthen Oath", 3, 2, nil},
	{67, 13006, 3, 80, "Polishing the Helm", 3, 2, nil},
	{67, 13007, 1, 80, "The Iron Colossus", 3, 2, nil},
	{67, 13009, 1, 80, "A New Beginning", 3, 2, nil},
	{67, 13010, 1, 80, "Krolmir, Hammer of Storms", 3, 2, nil},
	{67, 13011, 1, 80, "Jormuttar is Soo Fat...", 3, 2, nil},
	{67, 13035, 1, 80, "Loken's Lackeys", 3, 2, nil},
	{67, 13046, 3, 80, "Feeding Arngrim", 3, 2, nil},
	{67, 13047, 1, 80, "The Reckoning", 3, 2, nil},
	{67, 13050, 1, 80, "Veranus", 3, 2, nil},
	{67, 13051, 1, 80, "Territorial Trespass", 3, 2, nil},
	{67, 13057, 1, 80, "The Terrace of the Makers", 3, 2, nil},
	{67, 13064, 1, 80, "Sibling Rivalry", 3, 2, nil},
	{67, 13559, 2, 80, "Hodir's Tribute", 3, 2, nil},
	{67, 13843, 1, 80, "The Scrapbot Construction Kit", 3, 2, nil},
	{4197, 13153, 1, 80, "Warding the Warriors [PvP]", 1, 2, nil},
	{4197, 13154, 1, 80, "Bones and Arrows [PvP]", 1, 2, nil},
	{4197, 13156, 1, 80, "A Rare Herb [PvP]", 1, 2, nil},
	{4197, 13177, 1, 80, "No Mercy for the Merciless [PvP]", 1, 2, nil},
	{4197, 13179, 1, 80, "No Mercy for the Merciless [PvP]", 1, 2, nil},
	{4197, 13181, 1, 80, "Victory in Wintergrasp [PvP]", 1, 2, nil},
	{4197, 13186, 1, 80, "Stop the Siege [PvP]", 1, 2, nil},
	{4197, 13195, 1, 80, "A Rare Herb [PvP]", 1, 2, nil},
	{4197, 13196, 1, 80, "Bones and Arrows [PvP]", 1, 2, nil},
	{4197, 13197, 1, 80, "Fueling the Demolishers [PvP]", 1, 2, nil},
	{4197, 13198, 1, 80, "Warding the Warriors [PvP]", 1, 2, nil},
	{4197, 13222, 1, 80, "Defend the Siege [PvP]", 1, 2, nil},
	{4197, 13538, 1, 80, "Southern Sabotage [PvP]", 1, 2, nil},
	{4197, 13178, 1, 80, "Slay them all! [PvP]", 2, 2, nil},
	{4197, 13180, 1, 80, "Slay them all! [PvP]", 2, 2, nil},
	{4197, 13183, 1, 80, "Victory in Wintergrasp [PvP]", 2, 2, nil},
	{4197, 13185, 1, 80, "Stop the Siege [PvP]", 2, 2, nil},
	{4197, 13191, 1, 80, "Fueling the Demolishers [PvP]", 2, 2, nil},
	{4197, 13192, 1, 80, "Warding the Walls [PvP]", 2, 2, nil},
	{4197, 13193, 1, 80, "Bones and Arrows [PvP]", 2, 2, nil},
	{4197, 13194, 1, 80, "Healing with Roses [PvP]", 2, 2, nil},
	{4197, 13199, 1, 80, "Bones and Arrows [PvP]", 2, 2, nil},
	{4197, 13200, 1, 80, "Fueling the Demolishers [PvP]", 2, 2, nil},
	{4197, 13201, 1, 80, "Healing with Roses [PvP]", 2, 2, nil},
	{4197, 13202, 1, 80, "Jinxing the Walls [PvP]", 2, 2, nil},
	{4197, 13223, 1, 80, "Defend the Siege [PvP]", 2, 2, nil},
	{4197, 13539, 1, 80, "Toppling the Towers [PvP]", 2, 2, nil},
	{66, 12629, 1, 75, "You Can Run, But You Can't Hide", 3, 2, nil},
	{66, 12630, 1, 75, "Kickin' Nass and Takin' Manes", 3, 2, nil},
	{66, 12631, 1, 75, "An Invitation, of Sorts...", 3, 2, nil},
	{66, 12633, 1, 75, "Darkness Calling", 3, 2, nil},
	{66, 12637, 1, 75, "Near Miss", 3, 2, nil},
	{66, 12638, 1, 75, "Close Call", 3, 2, nil},
	{66, 12643, 1, 75, "Silver Lining", 3, 2, nil},
	{66, 12648, 1, 75, "Dressing Down", 3, 2, nil},
	{66, 12649, 1, 75, "Suit Up!", 3, 2, nil},
	{66, 12652, 1, 75, "Feedin' Da Goolz", 3, 2, nil},
	{66, 12661, 1, 75, "Infiltrating Voltarus", 3, 2, nil},
	{66, 12663, 1, 75, "Reunited", 3, 2, nil},
	{66, 12664, 1, 75, "Dark Horizon", 3, 2, nil},
	{66, 12669, 1, 75, "So Far, So Bad", 3, 2, nil},
	{66, 12673, 1, 75, "It Rolls Downhill", 3, 2, nil},
	{66, 12676, 1, 75, "Sabotage", 3, 2, nil},
	{66, 12677, 1, 75, "Hazardous Materials", 3, 2, nil},
	{66, 12686, 1, 75, "Zero Tolerance", 3, 2, nil},
	{66, 12690, 1, 75, "Fuel for the Fire", 3, 2, nil},
	{66, 12710, 1, 75, "Disclosure", 3, 2, nil},
	{66, 12789, 1, 75, "Into the Breach!", 3, 2, nil},
	{66, 12792, 1, 75, "First Things First", 3, 2, nil},
	{66, 12793, 1, 75, "Smoke on the Horizon", 3, 2, nil},
	{66, 12795, 1, 75, "Taking a Stand", 3, 2, nil},
	{66, 12799, 1, 75, "Siphoning the Spirits", 3, 2, nil},
	{66, 12857, 1, 75, "Wanted: Ragemane's Flipper [Group]", 3, 2, nil},
	{66, 12859, 1, 75, "This Just In: Fire Still Hot!", 3, 2, nil},
	{66, 12861, 1, 75, "Trolls Is Gone Crazy!", 3, 2, nil},
	{66, 12883, 1, 75, "Orders From Drakuru", 3, 2, nil},
	{66, 12884, 1, 75, "The Ebon Watch", 3, 2, nil},
	{66, 12894, 1, 75, "Crusader Forward Camp", 3, 2, nil},
	{66, 12902, 1, 75, "In Search Of Answers", 3, 2, nil},
	{66, 12502, 3, 76, "Troll Patrol: High Standards", 3, 2, nil},
	{66, 12503, 1, 76, "Defend the Stand", 3, 2, nil},
	{66, 12504, 1, 76, "Argent Crusade, We Are Leaving!", 3, 2, nil},
	{66, 12505, 1, 76, "New Orders for Sergeant Stackhammer", 3, 2, nil},
	{66, 12506, 1, 76, "Trouble at the Altar of Sseratus", 3, 2, nil},
	{66, 12507, 1, 76, "Strange Mojo", 3, 2, nil},
	{66, 12508, 1, 76, "Mopping Up", 3, 2, nil},
	{66, 12509, 3, 76, "Troll Patrol: Intestinal Fortitude", 3, 2, nil},
	{66, 12510, 1, 76, "Precious Elemental Fluids", 3, 2, nil},
	{66, 12512, 1, 76, "Leave No One Behind", 3, 2, nil},
	{66, 12514, 1, 76, "Mushroom Mixer", 3, 2, nil},
	{66, 12516, 1, 76, "Too Much of a Good Thing", 3, 2, nil},
	{66, 12519, 3, 76, "Troll Patrol: Whatdya Want, a Medal?", 3, 2, nil},
	{66, 12527, 1, 76, "Gluttonous Lurkers", 3, 2, nil},
	{66, 12541, 3, 76, "Troll Patrol: The Alchemist's Apprentice", 3, 2, nil},
	{66, 12552, 1, 76, "Death to the Necromagi", 3, 2, nil},
	{66, 12553, 1, 76, "Skimmer Spinnerets", 3, 2, nil},
	{66, 12554, 1, 76, "Malas the Corrupter [Group]", 3, 2, nil},
	{66, 12555, 1, 76, "A Tangled Skein", 3, 2, nil},
	{66, 12557, 1, 76, "Lab Work", 3, 2, nil},
	{66, 12562, 1, 76, "The Drakkari Do Not Need Water Elementals!", 3, 2, nil},
	{66, 12564, 3, 76, "Troll Patrol: Something for the Pain", 3, 2, nil},
	{66, 12565, 1, 76, "The Blessing of Zim'Abwa", 3, 2, nil},
	{66, 12567, 2, 76, "Blessing of Zim'Abwa", 3, 2, nil},
	{66, 12568, 3, 76, "Troll Patrol: Done to Death", 3, 2, nil},
	{66, 12583, 1, 76, "Crashed Sprayer", 3, 2, nil},
	{66, 12584, 1, 76, "Pure Evil", 3, 2, nil},
	{66, 12585, 3, 76, "Troll Patrol: Creature Comforts", 3, 2, nil},
	{66, 12587, 3, 76, "Troll Patrol", 3, 2, nil},
	{66, 12588, 3, 76, "Troll Patrol: Can You Dig It?", 3, 2, nil},
	{66, 12591, 3, 76, "Troll Patrol: Throwing Down", 3, 2, nil},
	{66, 12594, 3, 76, "Troll Patrol: Couldn't Care Less", 3, 2, nil},
	{66, 12596, 1, 76, "Pa'Troll", 3, 2, nil},
	{66, 12597, 1, 76, "Something for the Pain", 3, 2, nil},
	{66, 12598, 1, 76, "Throwing Down", 3, 2, nil},
	{66, 12599, 1, 76, "Creature Comforts", 3, 2, nil},
	{66, 12604, 3, 76, "Congratulations!", 3, 2, nil},
	{66, 12606, 1, 76, "Cocooned!", 3, 2, nil},
	{66, 12609, 1, 76, "Stocking the Shelves", 3, 2, nil},
	{66, 12610, 1, 76, "Clipping Their Wings", 3, 2, nil},
	{66, 12713, 1, 76, "Betrayal", 3, 2, nil},
	{66, 12740, 1, 76, "Parachutes for the Argent Crusade", 3, 2, nil},
	{66, 12901, 1, 76, "Making Something Out Of Nothing", 3, 2, nil},
	{66, 12903, 1, 76, "That's What Friends Are For...", 3, 2, nil},
	{66, 12904, 1, 76, "Light Won't Grant Me Vengeance", 3, 2, nil},
	{66, 12912, 1, 76, "A Great Storm Approaches", 3, 2, nil},
	{66, 12914, 1, 76, "Gymer's Salvation", 3, 2, nil},
	{66, 12916, 1, 76, "Our Only Hope", 3, 2, nil},
	{66, 12919, 1, 76, "The Storm King's Vengeance", 3, 2, nil},
	{66, 12615, 1, 77, "The Blessing of Zim'Torga", 3, 2, nil},
	{66, 12618, 2, 77, "Blessing of Zim'Torga", 3, 2, nil},
	{66, 12622, 1, 77, "The Leaders at Jin'Alai", 3, 2, nil},
	{66, 12623, 1, 77, "To the Witch Doctor", 3, 2, nil},
	{66, 12627, 1, 77, "Breaking Through Jin'Alai", 3, 2, nil},
	{66, 12628, 1, 77, "To Speak With Har'koa", 3, 2, nil},
	{66, 12632, 1, 77, "But First My Offspring", 3, 2, nil},
	{66, 12635, 1, 77, "Relics of the Snow Leopard Goddess", 3, 2, nil},
	{66, 12639, 1, 77, "The Frozen Earth", 3, 2, nil},
	{66, 12640, 1, 77, "Sealing the Rifts", 3, 2, nil},
	{66, 12642, 1, 77, "Spirit of Rhunok", 3, 2, nil},
	{66, 12646, 1, 77, "My Prophet, My Enemy", 3, 2, nil},
	{66, 12647, 1, 77, "An End to the Suffering", 3, 2, nil},
	{66, 12650, 1, 77, "Plundering Their Own", 3, 2, nil},
	{66, 12653, 1, 77, "Back to Har'koa", 3, 2, nil},
	{66, 12655, 1, 77, "The Blessing of Zim'Rhuk", 3, 2, nil},
	{66, 12656, 2, 77, "Blessing of Zim'Rhuk", 3, 2, nil},
	{66, 12659, 1, 77, "Scalps!", 3, 2, nil},
	{66, 12662, 1, 77, "Bringing Down Heb'Jin", 3, 2, nil},
	{66, 12665, 1, 77, "I Sense a Disturbance", 3, 2, nil},
	{66, 12666, 1, 77, "Preparations for the Underworld", 3, 2, nil},
	{66, 12667, 1, 77, "Seek the Wind Serpent Goddess", 3, 2, nil},
	{66, 12668, 1, 77, "Foundation for Revenge", 3, 2, nil},
	{66, 12672, 1, 77, "Setting the Stage", 3, 2, nil},
	{66, 12674, 1, 77, "Hell Hath a Fury", 3, 2, nil},
	{66, 12675, 1, 77, "One Last Thing", 3, 2, nil},
	{66, 12684, 1, 77, "Blood of a Dead God", 3, 2, nil},
	{66, 12685, 1, 77, "You Reap What You Sow", 3, 2, nil},
	{66, 12707, 1, 77, "Wooly Justice", 3, 2, nil},
	{66, 12708, 1, 77, "Enchanted Tiki Warriors", 3, 2, nil},
	{66, 12709, 1, 77, "Hexed Caches", 3, 2, nil},
	{66, 12712, 1, 77, "The Key of Warlord Zol'Maz", 3, 2, nil},
	{66, 12721, 1, 77, "Rampage", 3, 2, nil},
	{66, 12729, 1, 77, "The Gods Have Spoken [Group]", 3, 2, nil},
	{66, 12932, 1, 77, "The Amphitheater of Anguish: Yggdras! [Group]", 3, 2, nil},
	{66, 12933, 1, 77, "The Amphitheater of Anguish: Magnataur! [Group]", 3, 2, nil},
	{66, 12934, 1, 77, "The Amphitheater of Anguish: From Beyond! [Group]", 3, 2, nil},
	{66, 12935, 1, 77, "The Amphitheater of Anguish: Tuskarrmageddon! [Group]", 3, 2, nil},
	{66, 12936, 1, 77, "The Amphitheater of Anguish: Korrak the Bloodrager! [Group]", 3, 2, nil},
	{66, 12974, 1, 77, "The Champion's Call! [Group]", 3, 2, nil},
	{66, 13549, 1, 77, "Tails Up", 3, 2, nil},
	{66, 13556, 1, 77, "Eggs for Dubra'Jin", 3, 2, nil},
	{66, 12730, 1, 78, "Convocation at Zol'Heb [Group]", 3, 2, nil},
	{66, 12948, 1, 78, "The Champion of Anguish [Group]", 3, 2, nil},
	{66, 13097, 1, 78, "Unfinished Business", 3, 2, nil},
	{66, 13099, 1, 78, "Just Checkin'", 3, 2, nil},

	--[[

		DUNGEONS - Original Version 07/11/2010;

		CHANGELOG:

		07/11/2010

		Quests flagged as repeatable:
		7483, 7484, 7485, 5582, 3375.

	--]]

	{4494, 13187, 1, 76, "The Faceless Ones", 3, 2, nil},
	{4494, 13204, 1, 76, "Funky Fungi", 3, 2, nil},
	{4494, 13190, 3, 80, "All Things in Good Time", 3, 2, nil},
	{4494, 13255, 4, 80, "Proof of Demise: Herald Volazj [Removed]", 3, 2, nil},

	{3790, 10164, 1, 67, "Everything Will Be Alright", 3, 2, nil},
	{3790, 10253, 1, 67, "Levixus the Soul Caller [Group]", 3, 2, nil},
	{3790, 10167, 1, 68, "Auchindoun...", 2, 2, nil},
	{3790, 11374, 3, 70, "Wanted: The Exarch's Soul Gem", 3, 2, nil},

	{4277, 13167, 1, 74, "Death to the Traitor King", 3, 2, nil},
	{4277, 13182, 1, 74, "Don't Forget the Eggs!", 3, 2, nil},
	{4277, 13254, 4, 80, "Proof of Demise: Anub'arak [Removed]", 3, 2, nil},

	{719, 6562, 1, 22, "Trouble in the Deeps", 2, 2, nil},
	{719, 6563, 1, 22, "The Essence of Aku'Mai", 2, 2, nil},
	{719, 6564, 1, 22, "Allegiance to the Old Gods", 2, 2, nil},
	{719, 971, 1, 23, "Knowledge in the Deeps", 1, 2, nil},
	{719, 1198, 1, 24, "In Search of Thaelrid", 1, 2, nil},
	{719, 1275, 1, 24, "Researching the Corruption", 1, 2, nil},
	{719, 1199, 1, 25, "Twilight Falls", 1, 2, nil},
	{719, 6565, 1, 26, "Allegiance to the Old Gods", 2, 2, nil},
	{719, 1200, 1, 27, "Blackfathom Villainy", 1, 2, nil},
	{719, 6561, 1, 27, "Blackfathom Villainy", 2, 2, nil},
	{719, 6921, 1, 27, "Amongst the Ruins", 2, 2, nil},

	{1584, 4295, 2, 1, "Rocknot's Ale", 3, 2, nil},
	{1584, 3981, 1, 52, "Commander Gor'shak", 2, 2, nil},
	{1584, 4081, 1, 52, "KILL ON SIGHT: Dark Iron Dwarves", 2, 2, nil},
	{1584, 3801, 1, 52, "Dark Iron Legacy", 3, 2, nil},
	{1584, 3802, 1, 52, "Dark Iron Legacy", 3, 2, nil},
	{1584, 4136, 1, 53, "Ribbly Screwspigot", 3, 2, nil},
	{1584, 4324, 1, 53, "Yuka Screwspigot", 3, 2, nil},
	{1584, 4241, 1, 54, "Marshal Windsor", 1, 2, nil},
	{1584, 4242, 4, 54, "Abandoned Hope [Removed]", 1, 2, nil},
	{1584, 3982, 1, 54, "What Is Going On?", 2, 2, nil},
	{1584, 4001, 1, 54, "What Is Going On?", 2, 2, nil},
	{1584, 4002, 1, 54, "The Eastern Kingdoms", 2, 2, nil},
	{1584, 4082, 1, 54, "KILL ON SIGHT: High Ranking Dark Iron Officials", 2, 2, nil},
	{1584, 7201, 1, 54, "The Last Element", 2, 2, nil},
	{1584, 4201, 1, 54, "The Love Potion", 3, 2, nil},
	{1584, 4126, 1, 55, "Hurley Blackbreath", 1, 2, nil},
	{1584, 4128, 1, 55, "Ragnar Thunderbrew", 1, 2, nil},
	{1584, 4133, 1, 55, "Vivian Lagrave", 2, 2, nil},
	{1584, 4134, 1, 55, "Lost Thunderbrew Recipe", 2, 2, nil},
	{1584, 4083, 1, 55, "The Spectral Chalice", 3, 2, nil},
	{1584, 4123, 1, 55, "The Heart of the Mountain", 3, 2, nil},
	{1584, 4263, 1, 56, "Incendius!", 1, 2, nil},
	{1584, 4286, 1, 56, "The Good Stuff", 1, 2, nil},
	{1584, 3907, 1, 56, "Disharmony of Fire", 2, 2, nil},
	{1584, 4264, 4, 58, "A Crumpled Up Note [Removed]", 1, 2, nil},
	{1584, 4282, 4, 58, "A Shred of Hope [Removed]", 1, 2, nil},
	{1584, 4322, 4, 58, "Jail Break! [Removed]", 1, 2, nil},
	{1584, 4063, 1, 58, "The Rise of the Machines", 2, 2, nil},
	{1584, 4121, 1, 58, "Precarious Predicament", 2, 2, nil},
	{1584, 4122, 1, 58, "Grark Lorkrub", 2, 2, nil},
	{1584, 4132, 1, 58, "Operation: Death to Angerforge", 2, 2, nil},
	{1584, 4024, 1, 58, "A Taste of Flame", 3, 2, nil},
	{1584, 4341, 1, 59, "Kharan Mighthammer", 1, 2, nil},
	{1584, 4342, 1, 59, "Kharan's Tale", 1, 2, nil},
	{1584, 4361, 1, 59, "The Bearer of Bad News", 1, 2, nil},
	{1584, 4362, 1, 59, "The Fate of the Kingdom", 1, 2, nil},
	{1584, 4363, 1, 59, "The Princess's Surprise", 1, 2, nil},
	{1584, 4003, 1, 59, "The Royal Rescue", 2, 2, nil},
	{1584, 4004, 1, 60, "The Princess Saved?", 2, 2, nil},
	{1584, 7604, 1, 60, "A Binding Contract", 3, 2, nil},
	{1584, 9015, 1, 60, "The Challenge", 3, 2, nil},

	{1583, 4788, 1, 58, "The Final Tablets", 3, 2, nil},
	{1583, 4701, 1, 59, "Put Her Down", 1, 2, nil},
	{1583, 5001, 1, 59, "Bijou's Belongings", 1, 2, nil},
	{1583, 5002, 1, 59, "Message to Maxwell", 1, 2, nil},
	{1583, 4724, 1, 59, "The Pack Mistress", 2, 2, nil},
	{1583, 4981, 1, 59, "Operative Bijou", 2, 2, nil},
	{1583, 4982, 1, 59, "Bijou's Belongings", 2, 2, nil},
	{1583, 4983, 1, 59, "Bijou's Reconnaissance Report", 2, 2, nil},
	{1583, 4729, 1, 59, "Kibler's Exotic Pets", 3, 2, nil},
	{1583, 4862, 1, 59, "En-Ay-Es-Tee-Why", 3, 2, nil},
	{1583, 4764, 1, 60, "Doomrigger's Clasp", 1, 2, nil},
	{1583, 4765, 1, 60, "Delivery to Ridgewell", 1, 2, nil},
	{1583, 4766, 1, 60, "Mayara Brightwing", 1, 2, nil},
	{1583, 5081, 1, 60, "Maxwell's Mission", 1, 2, nil},
	{1583, 5089, 1, 60, "General Drakkisath's Command", 1, 2, nil},
	{1583, 5102, 1, 60, "General Drakkisath's Demise", 1, 2, nil},
	{1583, 6502, 4, 60, "Drakefire Amulet [Removed]", 1, 2, nil},
	{1583, 4768, 1, 60, "The Darkstone Tablet", 2, 2, nil},
	{1583, 4769, 1, 60, "Vivian Lagrave and the Darkstone Tablet", 2, 2, nil},
	{1583, 4903, 1, 60, "[DEPRECATED] Warlord's Command", 2, 2, nil},
	{1583, 4974, 1, 60, "[DEPRECATED] For The Horde!", 2, 2, nil},
	{1583, 6569, 1, 60, "Oculus Illusions", 2, 2, nil},
	{1583, 6602, 1, 60, "Blood of the Black Dragon Champion", 2, 2, nil},
	{1583, 4734, 1, 60, "Egg Freezing", 3, 2, nil},
	{1583, 4735, 1, 60, "Egg Collection", 3, 2, nil},
	{1583, 4742, 1, 60, "Seal of Ascension", 3, 2, nil},
	{1583, 4743, 1, 60, "Seal of Ascension", 3, 2, nil},
	{1583, 4866, 1, 60, "Mother's Milk", 3, 2, nil},
	{1583, 4867, 1, 60, "Urok Doomhowl", 3, 2, nil},
	{1583, 4907, 1, 60, "Tinkee Steamboil", 3, 2, nil},
	{1583, 5047, 1, 60, "Finkle Einhorn, At Your Service!", 3, 2, nil},
	{1583, 5127, 1, 60, "The Demon Forge", 3, 2, nil},
	{1583, 5160, 1, 60, "The Matron Protectorate", 3, 2, nil},
	{1583, 7761, 1, 60, "Blackhand's Command", 3, 2, nil},
	{1583, 8966, 1, 60, "The Left Piece of Lord Valthalak's Amulet", 3, 1, "WARRIOR MAGE"},
	{1583, 8989, 1, 60, "The Right Piece of Lord Valthalak's Amulet", 3, 1, "PALADIN SHAMAN DRUID"},
	{1583, 8995, 1, 60, "Mea Culpa, Lord Valthalak", 3, 2, nil},

	{1941, 10279, 1, 66, "To The Master's Lair", 3, 2, nil},
	{1941, 10277, 1, 68, "The Caverns of Time", 3, 2, nil},
	{1941, 12513, 1, 68, "Nice Hat...", 3, 2, nil},
	{1941, 11103, 2, 70, "Sage No More", 3, 2, nil},
	{1941, 11104, 2, 70, "Restorer No More", 3, 2, nil},
	{1941, 11105, 2, 70, "Champion No More", 3, 2, nil},
	{1941, 11106, 2, 70, "Defender No More", 3, 2, nil},
	{1941, 13432, 1, 70, "The Vials of Eternity", 3, 2, nil},

	{3905, 9738, 1, 65, "Lost in Action", 3, 2, nil},
	{3905, 9876, 1, 65, "Failed Incursion", 3, 2, nil},
	{3905, 9765, 1, 70, "Preparing for War", 3, 2, nil},
	{3905, 9766, 2, 70, "Coilfang Armaments", 3, 2, nil},

	{2557, 7488, 1, 57, "Lethtendris's Web", 1, 2, nil},
	{2557, 7489, 1, 57, "Lethtendris's Web", 2, 2, nil},
	{2557, 7441, 1, 58, "Pusillin and the Elder Azj'Tordin", 3, 2, nil},
	{2557, 5528, 1, 60, "The Gordok Taste Test", 4, 2, nil},
	{2557, 7482, 1, 60, "Elven Legends", 1, 2, nil},
	{2557, 7481, 1, 60, "Elven Legends", 2, 2, nil},
	{2557, 1193, 2, 60, "A Broken Trap", 3, 2, nil},
	{2557, 5518, 1, 60, "The Gordok Ogre Suit", 3, 2, nil},
	{2557, 5525, 1, 60, "Free Knot!", 3, 2, nil},
	{2557, 7429, 2, 60, "Free Knot!", 3, 1, "DRUID"},
	{2557, 7461, 1, 60, "The Madness Within", 3, 2, nil},
	{2557, 7483, 2, 60, "Libram of Rapidity", 3, 2, nil},
	{2557, 7484, 2, 60, "Libram of Focus", 3, 2, nil},
	{2557, 7485, 2, 60, "Libram of Protection", 3, 2, nil},
	{2557, 7498, 1, 60, "Garona: A Study on Stealth and Treachery", 3, 1, "ROGUE"},
	{2557, 7499, 1, 60, "Codex of Defense", 3, 1, "WARRIOR"},
	{2557, 7500, 1, 60, "The Arcanist's Cookbook", 3, 1, "MAGE"},
	{2557, 7501, 1, 60, "The Light and How To Swing It", 3, 1, "PALADIN"},
	{2557, 7502, 1, 60, "Harnessing Shadows", 3, 1, "WARLOCK"},
	{2557, 7503, 1, 60, "The Greatest Race of Hunters", 3, 1, "HUNTER"},
	{2557, 7504, 1, 60, "Holy Bologna: What the Light Won't Tell You", 3, 1, "PRIEST"},
	{2557, 7505, 1, 60, "Frost Shock and You", 3, 1, "SHAMAN"},
	{2557, 7506, 1, 60, "The Emerald Dream...", 3, 1, "DRUID"},
	{2557, 7507, 1, 60, "Foror's Compendium", 3, 2, nil},
	{2557, 7508, 1, 60, "The Forging of Quel'Serrar", 3, 2, nil},
	{2557, 7703, 1, 60, "Unfinished Gordok Business", 3, 2, nil},
	{2557, 7877, 1, 60, "The Treasure of the Shen'dralar", 3, 2, nil},
	{2557, 8948, 1, 60, "Anthion's Old Friend", 3, 2, nil},
	{2557, 8949, 1, 60, "Falrin's Vendetta", 3, 2, nil},
	{2557, 8950, 1, 60, "The Instigator's Enchantment", 3, 2, nil},
	{2557, 8967, 1, 60, "The Left Piece of Lord Valthalak's Amulet", 3, 1, "WARLOCK DRUID"},
	{2557, 8990, 1, 60, "The Right Piece of Lord Valthalak's Amulet", 3, 1, "WARRIOR ROGUE"},

	{4196, 12037, 1, 74, "Search and Rescue", 3, 2, nil},
	{4196, 13129, 1, 74, "Head Games", 3, 2, nil},
	{4196, 12238, 1, 75, "Cleansing Drak'Tharon", 3, 2, nil},
	{4196, 13249, 4, 80, "Proof of Demise: The Prophet Tharon'ja [Removed]", 3, 2, nil},

	{721, 2922, 1, 26, "Save Techbot's Brain!", 1, 2, nil},
	{721, 2923, 1, 26, "Tinkmaster Overspark", 1, 2, nil},
	{721, 2926, 1, 27, "Gnogaine", 1, 2, nil},
	{721, 2927, 1, 27, "The Day After", 1, 2, nil},
	{721, 2931, 1, 28, "Castpipe's Task", 1, 2, nil},
	{721, 2924, 1, 30, "Essential Artificials", 1, 2, nil},
	{721, 2925, 1, 30, "Klockmort's Essentials", 1, 2, nil},
	{721, 2928, 1, 30, "Gyrodrillmatic Excavationators", 1, 2, nil},
	{721, 2930, 1, 30, "Data Rescue", 1, 2, nil},
	{721, 2962, 1, 30, "The Only Cure is More Green Glow", 1, 2, nil},
	{721, 4606, 1, 30, "The Sparklematic 5200!", 2, 2, nil},
	{721, 2904, 1, 30, "A Fine Mess", 3, 2, nil},
	{721, 2951, 1, 30, "The Sparklematic 5200!", 3, 2, nil},
	{721, 2952, 1, 30, "The Sparklematic 5200!", 3, 2, nil},
	{721, 2953, 2, 30, "More Sparklematic Action", 3, 2, nil},
	{721, 4601, 1, 30, "The Sparklematic 5200!", 3, 2, nil},
	{721, 4602, 1, 30, "The Sparklematic 5200!", 3, 2, nil},
	{721, 4603, 2, 30, "More Sparklematic Action", 3, 2, nil},
	{721, 4604, 2, 30, "More Sparklematic Action", 3, 2, nil},
	{721, 4605, 1, 30, "The Sparklematic 5200!", 3, 2, nil},
	{721, 2947, 1, 34, "Return of the Ring", 1, 2, nil},
	{721, 2949, 1, 34, "Return of the Ring", 2, 2, nil},
	{721, 2945, 1, 34, "Grime-Encrusted Ring", 3, 2, nil},
	{721, 2929, 1, 35, "The Grand Betrayal", 1, 2, nil},
	{721, 2841, 1, 35, "Rig Wars", 2, 2, nil},
	{721, 2842, 1, 35, "Chief Engineer Scooty", 2, 2, nil},
	{721, 2843, 1, 35, "Gnomer-gooooone!", 2, 2, nil},

	{4416, 13096, 1, 78, "Gal'darah Must Pay", 3, 2, nil},
	{4416, 13098, 1, 78, "For Posterity", 3, 2, nil},
	{4416, 13111, 1, 78, "One of a Kind", 3, 2, nil},
	{4416, 13250, 4, 80, "Proof of Demise: Gal'darah [Removed]", 3, 2, nil},

	{4272, 13108, 1, 80, "Whatever it Takes!", 3, 2, nil},
	{4272, 13109, 1, 80, "Diametrically Opposed", 3, 2, nil},
	{4272, 13253, 4, 80, "Proof of Demise: Loken [Removed]", 3, 2, nil},

	{4820, 24480, 1, 80, "The Halls Of Reflection", 1, 2, nil},
	{4820, 24500, 1, 80, "Wrath of the Lich King", 1, 2, nil},
	{4820, 24711, 1, 80, "Frostmourne", 1, 2, nil},
	{4820, 24561, 1, 80, "The Halls Of Reflection", 2, 2, nil},
	{4820, 24713, 1, 80, "Frostmourne", 2, 2, nil},
	{4820, 24802, 1, 80, "Wrath of the Lich King", 2, 2, nil},

	{4264, 13207, 1, 78, "Halls of Stone", 3, 2, nil},
	{4264, 13252, 4, 80, "Proof of Demise: Sjonnir The Ironshaper [Removed]", 3, 2, nil},

	{3562, 9575, 1, 62, "Weaken the Ramparts", 1, 2, nil},
	{3562, 9572, 1, 62, "Weaken the Ramparts", 2, 2, nil},
	{3562, 11354, 3, 70, "Wanted: Nazan's Riding Crop", 3, 2, nil},

	{4131, 11488, 1, 70, "Magisters' Terrace", 3, 2, nil},
	{4131, 11490, 1, 70, "The Scryer's Scryer", 3, 2, nil},
	{4131, 11492, 1, 70, "Hard to Kill", 3, 2, nil},

	{3792, 10165, 1, 66, "Undercutting the Competition", 3, 2, nil},
	{3792, 10216, 1, 66, "Safety Is Job One", 3, 2, nil},
	{3792, 10218, 1, 66, "Someone Else's Hard Work Pays Off", 3, 2, nil},
	{3792, 10977, 1, 70, "Stasis Chambers of the Mana-Tombs", 3, 2, nil},
	{3792, 10981, 2, 70, "Nexus-Prince Shaffar's Personal Chamber", 3, 2, nil},
	{3792, 11373, 3, 70, "Wanted: Shaffar's Wondrous Pendant", 3, 2, nil},

	{2100, 7070, 1, 42, "Shadowshard Fragments", 1, 2, nil},
	{2100, 7068, 1, 42, "Shadowshard Fragments", 2, 2, nil},
	{2100, 7041, 1, 47, "Vyletongue Corruption", 1, 2, nil},
	{2100, 7029, 1, 47, "Vyletongue Corruption", 2, 2, nil},
	{2100, 7028, 1, 47, "Twisted Evils", 3, 2, nil},
	{2100, 7067, 1, 48, "The Pariah's Instructions", 3, 2, nil},
	{2100, 7044, 1, 49, "Legends of Maraudon", 3, 2, nil},
	{2100, 7046, 1, 49, "The Scepter of Celebras", 3, 2, nil},
	{2100, 7065, 1, 51, "Corruption of Earth and Seed", 1, 2, nil},
	{2100, 7064, 1, 51, "Corruption of Earth and Seed", 2, 2, nil},
	{2100, 7066, 1, 51, "Seed of Life", 3, 2, nil},

	{2367, 10282, 1, 68, "Old Hillsbrad", 3, 2, nil},
	{2367, 10283, 1, 68, "Taretha's Diversion", 3, 2, nil},
	{2367, 10284, 1, 68, "Escape from Durnholde", 3, 2, nil},
	{2367, 10285, 1, 68, "Return to Andormu", 3, 2, nil},
	{2367, 11378, 3, 70, "Wanted: The Epoch Hunter's Head", 3, 2, nil},

	{4813, 24461, 1, 80, "Reforging The Sword", 1, 2, nil},
	{4813, 24498, 1, 80, "The Path to the Citadel", 1, 2, nil},
	{4813, 24683, 1, 80, "The Pit of Saron", 1, 2, nil},
	{4813, 24710, 1, 80, "Deliverance from the Pit", 1, 2, nil},
	{4813, 24507, 1, 80, "The Path to the Citadel", 2, 2, nil},
	{4813, 24559, 1, 80, "Reforging The Sword", 2, 2, nil},
	{4813, 24682, 1, 80, "The Pit of Saron", 2, 2, nil},
	{4813, 24712, 1, 80, "Deliverance from the Pit", 2, 2, nil},

	{2437, 5723, 1, 15, "Testing an Enemy's Strength", 2, 2, nil},
	{2437, 5722, 1, 16, "Searching for the Lost Satchel", 2, 2, nil},
	{2437, 5724, 1, 16, "Returning the Lost Satchel", 2, 2, nil},
	{2437, 5728, 1, 16, "Hidden Enemies", 2, 2, nil},
	{2437, 5761, 1, 16, "Slaying the Beast", 2, 2, nil},
	{2437, 14356, 1, 16, "The Power to Destroy...", 2, 2, nil},

	{722, 6626, 1, 35, "A Host of Evil", 3, 2, nil},
	{722, 14352, 1, 36, "An Unholy Alliance", 2, 2, nil},
	{722, 14353, 1, 36, "An Unholy Alliance", 2, 2, nil},
	{722, 3636, 1, 37, "Bring the Light", 1, 2, nil},
	{722, 3341, 1, 37, "Bring the End", 2, 2, nil},
	{722, 3523, 1, 37, "Scourge of the Downs", 3, 2, nil},
	{722, 3525, 1, 37, "Extinguishing the Idol", 3, 2, nil},

	{491, 1109, 1, 26, "Going, Going, Guano!", 2, 2, nil},
	{491, 1221, 1, 26, "Blueleaf Tubers", 3, 2, nil},
	{491, 1101, 1, 27, "The Crone of the Kraul", 1, 2, nil},
	{491, 1102, 1, 27, "A Vengeful Fate", 2, 2, nil},
	{491, 1142, 1, 30, "Mortality Wanes", 1, 2, nil},
	{491, 1144, 1, 30, "Willix the Importer", 3, 2, nil},

	{796, 1051, 1, 33, "Vorrel's Revenge [Group]", 2, 2, nil},
	{796, 1113, 1, 33, "Hearts of Zeal", 2, 2, nil},
	{796, 1160, 1, 36, "Test of Lore", 2, 2, nil},
	{796, 1050, 1, 38, "Mythology of the Titans", 1, 2, nil},
	{796, 1049, 1, 38, "Compendium of the Fallen", 2, 2, nil},
	{796, 1053, 1, 40, "In the Name of the Light", 1, 2, nil},
	{796, 14355, 1, 42, "Into The Scarlet Monastery", 2, 2, nil},

	{2057, 5529, 1, 58, "Plagued Hatchlings", 3, 2, nil},
	{2057, 5582, 2, 58, "Healthy Dragon Scale", 3, 2, nil},
	{2057, 5343, 1, 60, "Barov Family Fortune", 1, 2, nil},
	{2057, 5341, 1, 60, "Barov Family Fortune", 2, 2, nil},
	{2057, 4771, 1, 60, "Dawn's Gambit", 3, 2, nil},
	{2057, 5382, 1, 60, "Doctor Theolen Krastinov, the Butcher", 3, 2, nil},
	{2057, 5384, 1, 60, "Kirtonos the Herald", 3, 2, nil},
	{2057, 5466, 1, 60, "The Lich, Ras Frostwhisper", 3, 2, nil},
	{2057, 5515, 1, 60, "Krastinov's Bag of Horrors", 3, 2, nil},
	{2057, 5531, 1, 60, "Betina Bigglezink", 3, 2, nil},
	{2057, 8969, 1, 60, "The Left Piece of Lord Valthalak's Amulet", 3, 1, "PALADIN PRIEST SHAMAN"},
	{2057, 8992, 1, 60, "The Right Piece of Lord Valthalak's Amulet", 3, 2, nil},

	{3791, 10097, 1, 69, "Brother Against Brother", 3, 2, nil},
	{3791, 10098, 1, 69, "Terokk's Legacy", 3, 2, nil},
	{3791, 11372, 3, 70, "Wanted: The Headfeathers of Ikiss", 3, 2, nil},

	{3789, 9831, 1, 70, "Entry Into Karazhan", 3, 2, nil},
	{3789, 10091, 1, 70, "The Soul Devices", 3, 2, nil},
	{3789, 10094, 1, 70, "The Codex of Blood", 3, 2, nil},
	{3789, 10095, 1, 70, "Into the Heart of the Labyrinth", 3, 2, nil},
	{3789, 10177, 1, 70, "Trouble at Auchindoun", 3, 2, nil},
	{3789, 10178, 1, 70, "Find Spy To'gun", 3, 2, nil},
	{3789, 10649, 1, 70, "The Book of Fel Names", 3, 2, nil},
	{3789, 11375, 3, 70, "Wanted: Murmur's Whisper", 3, 2, nil},
	{3789, 11376, 3, 70, "Wanted: Malicious Instructors", 3, 2, nil},

	{209, 1098, 1, 25, "Deathstalkers in Shadowfang", 2, 2, nil},
	{209, 1013, 1, 26, "The Book of Ur", 2, 2, nil},
	{209, 1014, 1, 27, "Arugal Must Die", 2, 2, nil},

	{2017, 6163, 1, 60, "Ramstein", 2, 2, nil},
	{2017, 5122, 2, 60, "The Medallion of Faith", 3, 2, nil},
	{2017, 5125, 1, 60, "Aurius' Reckoning", 3, 2, nil},
	{2017, 5212, 1, 60, "The Flesh Does Not Lie", 3, 2, nil},
	{2017, 5213, 1, 60, "The Active Agent", 3, 2, nil},
	{2017, 5214, 1, 60, "The Great Fras Siabi", 3, 2, nil},
	{2017, 5243, 1, 60, "Houses of the Holy", 3, 2, nil},
	{2017, 5251, 1, 60, "The Archivist", 3, 2, nil},
	{2017, 5262, 1, 60, "The Truth Comes Crashing Down", 3, 2, nil},
	{2017, 5263, 1, 60, "Above and Beyond", 3, 2, nil},
	{2017, 5282, 1, 60, "The Restless Souls", 3, 2, nil},
	{2017, 5463, 1, 60, "Menethil's Gift", 3, 2, nil},
	{2017, 5848, 1, 60, "Of Love and Family", 3, 2, nil},
	{2017, 8945, 1, 60, "Dead Man's Plea", 3, 2, nil},
	{2017, 8968, 1, 60, "The Left Piece of Lord Valthalak's Amulet", 3, 1, "HUNTER ROGUE"},
	{2017, 8991, 1, 60, "The Right Piece of Lord Valthalak's Amulet", 3, 1, "PRIEST MAGE"},

	{1477, 1475, 1, 50, "Into The Temple of Atal'Hakkar", 1, 2, nil},
	{1477, 1445, 1, 50, "The Temple of Atal'Hakkar", 2, 2, nil},
	{1477, 3446, 1, 51, "Into the Depths", 3, 2, nil},
	{1477, 3447, 1, 51, "Secret of the Circle", 3, 2, nil},
	{1477, 4146, 1, 52, "Zapper Fuel", 2, 2, nil},
	{1477, 1446, 1, 53, "Jammal'an the Prophet", 3, 2, nil},
	{1477, 3528, 1, 53, "The God Hakkar", 3, 2, nil},
	{1477, 3373, 1, 55, "The Essence of Eranikus", 3, 2, nil},
	{1477, 8733, 1, 60, "Eranikus, Tyrant of the Dream", 3, 2, nil},

	{3848, 10705, 1, 70, "Seer Udalo", 3, 2, nil},
	{3848, 10882, 1, 70, "Harbinger of Doom", 3, 2, nil},
	{3848, 11388, 3, 70, "Wanted: The Scroll of Skyriss", 3, 2, nil},
	{3848, 11389, 3, 70, "Wanted: Arcatraz Sentinels", 3, 2, nil},

	{2366, 9836, 1, 70, "The Master's Touch", 3, 2, nil},
	{2366, 10296, 1, 70, "The Black Morass", 3, 2, nil},
	{2366, 10297, 1, 70, "The Opening of the Dark Portal", 3, 2, nil},
	{2366, 10298, 1, 70, "Hero of the Brood", 3, 2, nil},
	{2366, 11382, 3, 70, "Wanted: Aeonus's Hourglass", 3, 2, nil},
	{2366, 11383, 3, 70, "Wanted: Rift Lords", 3, 2, nil},

	{3713, 9589, 1, 63, "The Blood is Life", 1, 2, nil},
	{3713, 9607, 1, 63, "Heart of Rage", 1, 2, nil},
	{3713, 9590, 1, 63, "The Blood is Life", 2, 2, nil},
	{3713, 9608, 1, 63, "Heart of Rage", 2, 2, nil},
	{3713, 11362, 3, 70, "Wanted: Keli'dan's Feathered Stave", 3, 2, nil},

	{3847, 11384, 3, 70, "Wanted: A Warp Splinter Clipping", 3, 2, nil},
	{3847, 11385, 3, 70, "Wanted: Sunseeker Channelers", 3, 2, nil},

	{4100, 13149, 1, 80, "Dispelling Illusions", 3, 2, nil},
	{4100, 13151, 1, 80, "A Royal Escort", 3, 2, nil},
	{4100, 13251, 4, 80, "Proof of Demise: Mal'Ganis [Removed]", 3, 2, nil},

	{1581, 214, 1, 17, "Red Silk Bandanas", 1, 2, nil},
	{1581, 168, 1, 18, "Collecting Memories", 1, 2, nil},
	{1581, 167, 1, 20, "Oh Brother. . .", 1, 2, nil},
	{1581, 2040, 1, 20, "Underground Assault", 1, 2, nil},
	{1581, 166, 1, 22, "The Defias Brotherhood", 1, 2, nil},

	{3845, 10704, 1, 70, "How to Break Into the Arcatraz", 3, 2, nil},

	{4809, 24499, 1, 80, "Echoes of Tortured Souls", 1, 2, nil},
	{4809, 24510, 1, 80, "Inside the Frozen Citadel", 1, 2, nil},
	{4809, 24506, 1, 80, "Inside the Frozen Citadel", 2, 2, nil},
	{4809, 24511, 1, 80, "Echoes of Tortured Souls", 2, 2, nil},

	{3849, 11386, 3, 70, "Wanted: Pathaleon's Projector", 3, 2, nil},
	{3849, 11387, 3, 70, "Wanted: Tempest-Forge Destroyers", 3, 2, nil},

	{4120, 13094, 1, 71, "Have They No Shame?", 1, 2, nil},
	{4120, 13095, 1, 71, "Have They No Shame?", 2, 2, nil},
	{4120, 11905, 1, 71, "Postponing the Inevitable", 3, 2, nil},
	{4120, 11911, 1, 71, "Quickening", 3, 2, nil},
	{4120, 11973, 1, 71, "Prisoner of War", 3, 2, nil},
	{4120, 13246, 4, 80, "Proof of Demise: Keristrasza [Removed]", 3, 2, nil},

	{4228, 13124, 1, 80, "The Struggle Persists", 3, 2, nil},
	{4228, 13126, 1, 80, "A Unified Front", 3, 2, nil},
	{4228, 13127, 1, 80, "Mage-Lord Urom", 3, 2, nil},
	{4228, 13128, 1, 80, "A Wing and a Prayer", 3, 2, nil},
	{4228, 13247, 4, 80, "Proof of Demise: Ley-Guardian Eregos [Removed]", 3, 2, nil},

	{3714, 9492, 1, 70, "Turning the Tide", 1, 2, nil},
	{3714, 9493, 1, 70, "Pride of the Fel Horde", 1, 2, nil},
	{3714, 9494, 1, 70, "Fel Embers", 1, 2, nil},
	{3714, 9524, 1, 70, "Imprisoned in the Citadel", 1, 2, nil},
	{3714, 9495, 1, 70, "The Will of the Warchief", 2, 2, nil},
	{3714, 9496, 1, 70, "Pride of the Fel Horde", 2, 2, nil},
	{3714, 9525, 1, 70, "Imprisoned in the Citadel", 2, 2, nil},
	{3714, 11363, 3, 70, "Wanted: Bladefist's Seal", 3, 2, nil},
	{3714, 11364, 3, 70, "Wanted: Shattered Hand Centurions", 3, 2, nil},

	{3717, 10900, 1, 70, "The Mark of Vashj", 3, 2, nil},
	{3717, 11368, 3, 70, "Wanted: The Heart of Quagmirran", 3, 2, nil},
	{3717, 13431, 1, 70, "The Cudgel of Kar'desh", 3, 2, nil},

	{3715, 9763, 1, 70, "The Warlord's Hideout", 3, 2, nil},
	{3715, 9764, 1, 70, "Orders from Lady Vashj", 3, 2, nil},
	{3715, 11370, 3, 70, "Wanted: The Warlord's Treatise", 3, 2, nil},
	{3715, 11371, 3, 70, "Wanted: Coilfang Myrmidons", 3, 2, nil},

	{717, 386, 1, 25, "What Comes Around...", 1, 2, nil},
	{717, 377, 1, 26, "Crime and Punishment", 1, 2, nil},
	{717, 387, 1, 26, "Quell The Uprising", 1, 2, nil},
	{717, 388, 1, 26, "The Color of Blood", 1, 2, nil},
	{717, 378, 1, 27, "The Fury Runs Deep", 1, 2, nil},
	{717, 391, 1, 29, "The Stockade Riots", 1, 2, nil},

	{3716, 9714, 2, 65, "Bring Me Another Shrubbery!", 3, 2, nil},
	{3716, 9715, 1, 65, "Bring Me A Shrubbery!", 3, 2, nil},
	{3716, 9717, 1, 65, "Oh, It's On!", 3, 2, nil},
	{3716, 9719, 1, 65, "Stalk the Stalker", 3, 2, nil},
	{3716, 11369, 3, 70, "Wanted: A Black Stalker Egg", 3, 2, nil},

	{4415, 13158, 1, 77, "Discretion is Key", 3, 2, nil},
	{4415, 13159, 1, 77, "Containment", 3, 2, nil},
	{4415, 13256, 4, 80, "Proof of Demise: Cyanigosa [Removed]", 3, 2, nil},

	{4723, 14199, 4, 80, "Proof of Demise: The Black Knight [Removed]", 3, 2, nil},

	{1337, 721, 1, 35, "A Sign of Hope", 1, 2, nil},
	{1337, 2418, 1, 36, "Power Stones", 3, 2, nil},
	{1337, 704, 1, 38, "Agmond's Fate", 1, 2, nil},
	{1337, 722, 1, 40, "Amulet of Secrets", 1, 2, nil},
	{1337, 2240, 1, 40, "The Hidden Chamber", 1, 2, nil},
	{1337, 2398, 1, 40, "The Lost Dwarves", 1, 2, nil},
	{1337, 709, 1, 40, "Solution to Doom", 3, 2, nil},
	{1337, 2198, 1, 41, "The Shattered Necklace", 1, 2, nil},
	{1337, 2199, 1, 41, "Lore for a Price", 1, 2, nil},
	{1337, 2283, 1, 41, "Necklace Recovery", 2, 2, nil},
	{1337, 2284, 1, 41, "Necklace Recovery, Take 2", 2, 2, nil},
	{1337, 17, 1, 42, "Uldaman Reagent Run", 1, 2, nil},
	{1337, 2200, 1, 42, "Back to Uldaman", 1, 2, nil},
	{1337, 3375, 2, 42, "Replacement Phial", 1, 2, nil},
	{1337, 2202, 1, 42, "Uldaman Reagent Run", 2, 2, nil},
	{1337, 2318, 1, 42, "Translating the Journal", 2, 2, nil},
	{1337, 2338, 1, 42, "Translating the Journal", 2, 2, nil},
	{1337, 1360, 1, 43, "Reclaimed Treasures", 1, 2, nil},
	{1337, 2201, 1, 43, "Find the Gems", 1, 2, nil},
	{1337, 2342, 1, 43, "Reclaimed Treasures", 2, 2, nil},
	{1337, 2204, 1, 44, "Restoring the Necklace", 1, 2, nil},
	{1337, 2361, 1, 44, "Restoring the Necklace", 1, 2, nil},
	{1337, 2339, 1, 44, "Find the Gems and Power Source", 2, 2, nil},
	{1337, 2340, 1, 44, "Deliver the Gems", 2, 2, nil},
	{1337, 2341, 1, 44, "Necklace Recovery, Take 3", 2, 2, nil},
	{1337, 1139, 1, 45, "The Lost Tablets of Will", 1, 2, nil},
	{1337, 2279, 1, 47, "The Platinum Discs", 1, 2, nil},
	{1337, 2280, 1, 47, "The Platinum Discs", 2, 2, nil},
	{1337, 2278, 1, 47, "The Platinum Discs", 3, 2, nil},

	{206, 11252, 1, 71, "Into Utgarde!", 1, 2, nil},
	{206, 13205, 1, 71, "Disarmament", 1, 2, nil},
	{206, 11262, 1, 71, "Ingvar Must Die!", 2, 2, nil},
	{206, 11272, 1, 71, "A Score to Settle", 2, 2, nil},
	{206, 13206, 1, 71, "Disarmament", 2, 2, nil},
	{206, 13245, 4, 80, "Proof of Demise: Ingvar the Plunderer [Removed]", 3, 2, nil},

	{1196, 13131, 1, 80, "Junk in My Trunk", 3, 2, nil},
	{1196, 13132, 1, 80, "Vengeance Be Mine!", 3, 2, nil},
	{1196, 13248, 4, 80, "Proof of Demise: King Ymiron [Removed]", 3, 2, nil},

	{718, 1489, 1, 16, "Hamuul Runetotem", 2, 2, nil},
	{718, 1490, 1, 16, "Nara Wildmane", 2, 2, nil},
	{718, 1486, 1, 17, "Deviate Hides", 3, 2, nil},
	{718, 962, 1, 18, "Serpentbloom", 2, 2, nil},
	{718, 959, 1, 18, "Trouble at the Docks", 3, 2, nil},
	{718, 1491, 1, 18, "Smart Drinks", 3, 2, nil},
	{718, 1487, 1, 21, "Deviate Eradication", 3, 2, nil},
	{718, 914, 1, 22, "Leaders of the Fang", 2, 2, nil},
	{718, 6981, 1, 26, "The Glowing Shard", 3, 2, nil},

	{1176, 2936, 1, 45, "The Spider God", 2, 2, nil},
	{1176, 2864, 1, 45, "Tran'rek", 3, 2, nil},
	{1176, 2865, 1, 45, "Scarab Shells", 3, 2, nil},
	{1176, 3042, 1, 45, "Troll Temper", 3, 2, nil},
	{1176, 2846, 1, 46, "Tiara of the Deep", 3, 2, nil},
	{1176, 2861, 1, 46, "Tabetha's Task", 3, 2, nil},
	{1176, 2991, 1, 47, "Nekrum's Medallion", 1, 2, nil},
	{1176, 2768, 1, 47, "Divino-matic Rod", 3, 2, nil},
	{1176, 3527, 1, 47, "The Prophecy of Mosh'aru", 3, 2, nil},
	{1176, 2770, 1, 50, "Gahz'rilla", 3, 2, nil},

	--[[

		PROFESSIONS - Original Version 07/11/2010;

		CHANGELOG:

		07/11/2010

		Quests flagged as repeatable:
		14151.

		Quests flagged as special:
		11934.

	--]]

	{-181, 14151, 2, 0, "Cardinal Ruby", 3, 2, nil},
	{-181, 1581, 1, 8, "Elixirs for the Bladeleafs", 1, 2, nil},
	{-181, 10897, 1, 70, "Master of Potions", 3, 2, nil},
	{-181, 10899, 1, 70, "Master of Transmutation", 3, 2, nil},
	{-181, 10902, 1, 70, "Master of Elixirs", 3, 2, nil},
	{-181, 10905, 1, 70, "Master of Potions", 3, 2, nil},
	{-181, 10906, 1, 70, "Master of Elixirs", 3, 2, nil},
	{-181, 10907, 1, 70, "Master of Transmutation", 3, 2, nil},

	{-121, 1578, 1, 12, "Supplying the Front", 1, 2, nil},
	{-121, 1618, 1, 16, "Gearing Redridge", 1, 2, nil},
	{-121, 2751, 1, 32, "Barbaric Battlements", 2, 2, nil},
	{-121, 2752, 1, 32, "On Iron Pauldrons", 2, 2, nil},
	{-121, 2753, 1, 36, "Trampled Under Foot", 2, 2, nil},
	{-121, 2754, 1, 36, "Horns of Frenzy", 2, 2, nil},
	{-121, 2755, 1, 36, "Joys of Omosh", 2, 2, nil},
	{-121, 2758, 1, 40, "The Origins of Smithing", 1, 2, nil},
	{-121, 2759, 1, 40, "In Search of Galvan", 1, 2, nil},
	{-121, 5283, 1, 40, "The Art of the Armorsmith", 1, 2, nil},
	{-121, 5284, 1, 40, "The Way of the Weaponsmith", 1, 2, nil},
	{-121, 2756, 1, 40, "The Old Ways", 2, 2, nil},
	{-121, 2757, 1, 40, "Booty Bay or Bust!", 2, 2, nil},
	{-121, 5301, 1, 40, "The Art of the Armorsmith", 2, 2, nil},
	{-121, 5302, 1, 40, "The Way of the Weaponsmith", 2, 2, nil},
	{-121, 2760, 1, 40, "The Mithril Order", 3, 2, nil},
	{-121, 2761, 1, 45, "Smelt On, Smelt Off", 3, 2, nil},
	{-121, 2762, 1, 45, "The Great Silver Deceiver", 3, 2, nil},
	{-121, 2763, 1, 45, "The Art of the Imbue", 3, 2, nil},
	{-121, 2764, 1, 45, "Galvan's Finest Pupil", 3, 2, nil},
	{-121, 2765, 1, 45, "Expert Blacksmith!", 3, 2, nil},
	{-121, 2771, 1, 45, "A Good Head On Your Shoulders", 3, 2, nil},
	{-121, 2772, 1, 45, "The World At Your Feet", 3, 2, nil},
	{-121, 2773, 1, 45, "The Mithril Kid", 3, 2, nil},
	{-121, 10891, 1, 50, "Imperial Plate Armor", 1, 2, nil},
	{-121, 10892, 1, 50, "Imperial Plate Armor", 2, 2, nil},
	{-121, 3321, 1, 50, "Did You Lose This?", 3, 2, nil},
	{-121, 5103, 1, 60, "Hot Fiery Death", 3, 2, nil},
	{-121, 5126, 1, 60, "Lorax's Tale", 3, 2, nil},
	{-121, 5305, 1, 60, "Sweet Serenity", 3, 2, nil},
	{-121, 5306, 1, 60, "Snakestone of the Shadow Huntress", 3, 2, nil},
	{-121, 5307, 1, 60, "Corruption", 3, 2, nil},
	{-121, 7649, 1, 60, "Enchanted Thorium Platemail: Volume I", 3, 2, nil},
	{-121, 7650, 1, 60, "Enchanted Thorium Platemail: Volume II", 3, 2, nil},
	{-121, 7651, 1, 60, "Enchanted Thorium Platemail: Volume III", 3, 2, nil},
	{-121, 7652, 1, 60, "A Blue Light Bargain", 3, 2, nil},
	{-121, 7653, 1, 60, "Imperial Plate Belt", 3, 2, nil},
	{-121, 7654, 1, 60, "Imperial Plate Boots", 3, 2, nil},
	{-121, 7655, 1, 60, "Imperial Plate Bracer", 3, 2, nil},
	{-121, 7656, 1, 60, "Imperial Plate Chest", 3, 2, nil},
	{-121, 7657, 1, 60, "Imperial Plate Helm", 3, 2, nil},
	{-121, 7658, 1, 60, "Imperial Plate Leggings", 3, 2, nil},
	{-121, 7659, 1, 60, "Imperial Plate Shoulders", 3, 2, nil},

	{-304, 13087, 1, 0, "Northern Cooking", 1, 2, nil},
	{-304, 13088, 1, 0, "Northern Cooking", 1, 2, nil},
	{-304, 13100, 3, 0, "Infused Mushroom Meatloaf", 1, 2, nil},
	{-304, 13101, 3, 0, "Convention at the Legerdemain", 1, 2, nil},
	{-304, 13102, 3, 0, "Sewer Stew", 1, 2, nil},
	{-304, 13103, 3, 0, "Cheese for Glowergold", 1, 2, nil},
	{-304, 13107, 3, 0, "Mustard Dogs!", 1, 2, nil},
	{-304, 13089, 1, 0, "Northern Cooking", 2, 2, nil},
	{-304, 13090, 1, 0, "Northern Cooking", 2, 2, nil},
	{-304, 13112, 3, 0, "Infused Mushroom Meatloaf", 2, 2, nil},
	{-304, 13113, 3, 0, "Convention at the Legerdemain", 2, 2, nil},
	{-304, 13114, 3, 0, "Sewer Stew", 2, 2, nil},
	{-304, 13115, 3, 0, "Cheese for Glowergold", 2, 2, nil},
	{-304, 13116, 3, 0, "Mustard Dogs!", 2, 2, nil},
	{-304, 13825, 1, 0, "Clamlette Surprise", 3, 2, nil},
	{-304, 384, 1, 7, "Beer Basted Boar Ribs", 1, 2, nil},
	{-304, 4161, 1, 7, "Recipe of the Kaldorei", 1, 2, nil},
	{-304, 2178, 1, 12, "Easy Strider Living", 1, 2, nil},
	{-304, 862, 1, 23, "Dig Rat Stew", 2, 2, nil},
	{-304, 7321, 1, 31, "Soothing Turtle Bisque", 2, 2, nil},
	{-304, 6612, 1, 45, "I Know A Guy...", 1, 2, nil},
	{-304, 6611, 1, 45, "To Gadgetzan You Go!", 2, 2, nil},
	{-304, 6610, 1, 45, "Clamlette Surprise", 3, 2, nil},
	{-304, 8307, 1, 57, "Desert Recipe", 3, 2, nil},
	{-304, 8313, 1, 57, "Sharing the Knowledge", 3, 2, nil},
	{-304, 8317, 1, 57, "Kitchen Assistance", 3, 2, nil},
	{-304, 11377, 3, 70, "Revenge is Tasty", 3, 2, nil},
	{-304, 11379, 3, 70, "Super Hot Stew", 3, 2, nil},
	{-304, 11380, 3, 70, "Manalicious", 3, 2, nil},
	{-304, 11381, 3, 70, "Soup for the Soul", 3, 2, nil},
	{-304, 13571, 1, 80, "Fletcher's Lost and Found", 3, 2, nil},

	{-201, 3629, 1, 0, "Goblin Engineering", 1, 2, nil},
	{-201, 3630, 1, 0, "Gnome Engineering", 1, 2, nil},
	{-201, 3632, 1, 0, "Gnome Engineering", 1, 2, nil},
	{-201, 3634, 1, 0, "Gnome Engineering", 1, 2, nil},
	{-201, 3641, 1, 0, "Show Your Work", 1, 2, nil},
	{-201, 4181, 1, 0, "Goblin Engineering", 1, 2, nil},
	{-201, 3526, 1, 0, "Goblin Engineering", 2, 2, nil},
	{-201, 3635, 1, 0, "Gnome Engineering", 2, 2, nil},
	{-201, 3637, 1, 0, "Gnome Engineering", 2, 2, nil},
	{-201, 3633, 1, 0, "Goblin Engineering", 3, 2, nil},
	{-201, 3639, 1, 0, "Show Your Work", 3, 2, nil},
	{-201, 3643, 1, 0, "Show Your Work", 3, 2, nil},
	{-201, 1559, 1, 37, "Flash Bomb Recipe", 3, 2, nil},
	{-201, 3640, 1, 47, "The Pledge of Secrecy", 1, 2, nil},
	{-201, 3647, 2, 47, "Membership Card Renewal", 1, 2, nil},
	{-201, 3638, 1, 47, "The Pledge of Secrecy", 3, 2, nil},
	{-201, 3642, 1, 47, "The Pledge of Secrecy", 3, 2, nil},
	{-201, 3644, 2, 47, "Membership Card Renewal", 3, 2, nil},
	{-201, 3645, 2, 47, "Membership Card Renewal", 3, 2, nil},
	{-201, 3646, 1, 47, "Membership Card Renewal", 3, 2, nil},
	{-201, 9636, 1, 60, "The Zapthrottle Mote Extractor!", 1, 2, nil},
	{-201, 9635, 1, 60, "The Zapthrottle Mote Extractor!", 2, 2, nil},

	{-324, 6624, 1, 0, "Triage", 1, 2, nil},
	{-324, 6622, 1, 0, "Triage", 2, 2, nil},
	{-324, 6625, 1, 45, "Alliance Trauma", 1, 2, nil},
	{-324, 6623, 1, 45, "Horde Trauma", 2, 2, nil},

	{-101, 24803, 2, 0, "Kalu'ak Fishing Derby", 4, 2, nil},
	{-101, 8229, 2, 0, "Could I get a Fishing Flier?", 1, 2, nil},
	{-101, 24806, 2, 0, "Better Luck Next Time", 1, 2, nil},
	{-101, 8228, 2, 0, "Could I get a Fishing Flier?", 2, 2, nil},
	{-101, 8193, 2, 0, "Master Angler", 3, 2, nil},
	{-101, 8194, 2, 0, "Apprentice Angler", 3, 2, nil},
	{-101, 8221, 2, 0, "Rare Fish - Keefer's Angelfish", 3, 2, nil},
	{-101, 8224, 2, 0, "Rare Fish - Dezian Queenfish", 3, 2, nil},
	{-101, 8225, 2, 0, "Rare Fish - Brownell's Blue Striped Racer", 3, 2, nil},
	{-101, 13826, 1, 0, "Nat Pagle, Angler Extreme", 3, 2, nil},
	{-101, 13830, 3, 0, "The Ghostfish", 3, 2, nil},
	{-101, 13832, 3, 0, "Jewel Of The Sewers", 3, 2, nil},
	{-101, 13833, 3, 0, "Blood Is Thicker", 3, 2, nil},
	{-101, 13834, 3, 0, "Dangerously Delicious", 3, 2, nil},
	{-101, 13836, 3, 0, "Disarmed!", 3, 2, nil},
	{-101, 1579, 1, 12, "Gaffer Jacks", 1, 2, nil},
	{-101, 1580, 1, 12, "Electropellers", 1, 2, nil},
	{-101, 6609, 1, 45, "I Got Nothin' Left!", 1, 2, nil},
	{-101, 6608, 1, 45, "You Too Good.", 2, 2, nil},
	{-101, 6607, 1, 45, "Nat Pagle, Angler Extreme", 3, 2, nil},
	{-101, 11531, 1, 70, "Strange Engine Part", 1, 2, nil},
	{-101, 11665, 3, 70, "Crocolisks in the City", 3, 2, nil},
	{-101, 11666, 3, 70, "Bait Bandits", 3, 2, nil},
	{-101, 11667, 3, 70, "The One That Got Away", 3, 2, nil},
	{-101, 11668, 3, 70, "Shrimpin' Ain't Easy", 3, 2, nil},
	{-101, 11669, 3, 70, "Felblood Fillet", 3, 2, nil},
	{-101, 13827, 1, 77, "Treasure!", 4, 2, nil},
	{-101, 13845, 1, 80, "Sealed Vial of Poison", 3, 2, nil},
	{-101, 14203, 1, 80, "Waterlogged Recipe", 3, 2, nil},

	{-24, 866, 1, 16, "Root Samples", 2, 2, nil},

	{-371, 11934, 4, 15, "Unlocking Your Potential [Placeholder]", 4, 2, nil},
	{-371, 12517, 1, 15, "Rogues Deck", 3, 2, nil},
	{-371, 12798, 1, 25, "Swords Deck", 3, 2, nil},
	{-371, 12518, 1, 35, "Mages Deck", 3, 2, nil},
	{-371, 13311, 1, 45, "Demons Deck", 3, 2, nil},

	{-373, 12918, 1, 0, "Gem Perfection", 1, 2, nil},
	{-373, 13004, 1, 0, "Gem Perfection", 1, 2, nil},
	{-373, 12952, 1, 0, "Gem Perfection", 2, 2, nil},
	{-373, 13002, 1, 0, "Gem Perfection", 2, 2, nil},
	{-373, 12958, 3, 0, "Shipment: Blood Jade Amulet ", 3, 2, nil},
	{-373, 12959, 3, 0, "Shipment: Glowing Ivory Figurine", 3, 2, nil},
	{-373, 12960, 3, 0, "Shipment: Wicked Sun Brooch", 3, 2, nil},
	{-373, 12961, 3, 0, "Shipment: Intricate Bone Figurine", 3, 2, nil},
	{-373, 12962, 3, 0, "Shipment: Bright Armor Relic", 3, 2, nil},
	{-373, 12963, 3, 0, "Shipment: Shifting Sun Curio ", 3, 2, nil},
	{-373, 13041, 1, 0, "Finish the Shipment", 3, 2, nil},
	{-373, 13148, 1, 0, "Necklace Repair", 3, 2, nil},
	{-373, 14160, 1, 0, "Writ of Merit", 3, 2, nil},

	{-182, 1582, 1, 18, "Moonglow Vest", 1, 2, nil},
	{-182, 2847, 1, 45, "Wild Leather Armor", 1, 2, nil},
	{-182, 2848, 1, 45, "Wild Leather Shoulders", 1, 2, nil},
	{-182, 2849, 1, 45, "Wild Leather Vest", 1, 2, nil},
	{-182, 2850, 1, 45, "Wild Leather Helmet", 1, 2, nil},
	{-182, 2851, 1, 45, "Wild Leather Boots", 1, 2, nil},
	{-182, 2852, 1, 45, "Wild Leather Leggings", 1, 2, nil},
	{-182, 2853, 1, 45, "Master of the Wild Leather", 1, 2, nil},
	{-182, 2854, 1, 45, "Wild Leather Armor", 2, 2, nil},
	{-182, 2855, 1, 45, "Wild Leather Shoulders", 2, 2, nil},
	{-182, 2856, 1, 45, "Wild Leather Vest", 2, 2, nil},
	{-182, 2857, 1, 45, "Wild Leather Helmet", 2, 2, nil},
	{-182, 2858, 1, 45, "Wild Leather Boots", 2, 2, nil},
	{-182, 2859, 1, 45, "Wild Leather Leggings", 2, 2, nil},
	{-182, 2860, 1, 45, "Master of the Wild Leather", 2, 2, nil},
	{-182, 5141, 1, 55, "Dragonscale Leatherworking", 1, 2, nil},
	{-182, 5143, 1, 55, "Tribal Leatherworking", 1, 2, nil},
	{-182, 5144, 1, 55, "Elemental Leatherworking", 1, 2, nil},
	{-182, 5145, 1, 55, "Dragonscale Leatherworking", 2, 1, "HUNTER ROGUE SHAMAN"},
	{-182, 5146, 1, 55, "Elemental Leatherworking", 2, 2, nil},
	{-182, 5148, 1, 55, "Tribal Leatherworking", 2, 1, "HUNTER MAGE DRUID"},

	{-264, 13268, 1, 0, "Cloth Scavenging", 4, 2, nil},
	{-264, 13265, 1, 0, "Cloth Scavenging", 1, 2, nil},
	{-264, 13269, 1, 0, "Cloth Scavenging", 2, 2, nil},
	{-264, 13270, 1, 0, "Cloth Scavenging", 2, 2, nil},
	{-264, 13272, 1, 0, "Cloth Scavenging", 2, 2, nil},
	{-264, 3379, 1, 50, "Shadoweaver", 3, 2, nil},
	{-264, 3385, 1, 50, "The Undermarket", 3, 2, nil},
	{-264, 3402, 1, 50, "The Undermarket", 3, 2, nil},
	{-264, 6032, 1, 55, "Sacred Cloth", 2, 2, nil},
	{-264, 10831, 1, 70, "Becoming a Mooncloth Tailor", 3, 2, nil},
	{-264, 10832, 1, 70, "Becoming a Spellfire Tailor", 3, 2, nil},
	{-264, 10833, 1, 70, "Becoming a Shadoweave Tailor", 3, 2, nil},

	--[[

		WORLD EVENTS - Original Version 07/11/2010;

		CHANGELOG:

		##/##/####
		None

	--]]

	{-370, 11117, 1, 0, "Catch the Wild Wolpertinger!", 1, 2, nil},
	{-370, 11118, 1, 0, "Pink Elekks On Parade", 1, 2, nil},
	{-370, 11122, 1, 0, "There and Back Again", 1, 2, nil},
	{-370, 11293, 3, 0, "Bark for the Barleybrews!", 1, 2, nil},
	{-370, 11294, 3, 0, "Bark for the Thunderbrews!", 1, 2, nil},
	{-370, 11318, 1, 0, "Now This is Ram Racing... Almost.", 1, 2, nil},
	{-370, 11321, 1, 0, "Did Someone Say \"Souvenir?\" ", 1, 2, nil},
	{-370, 11400, 4, 0, "Brewfest Riding Rams [Removed]", 1, 2, nil},
	{-370, 11441, 1, 0, "Brewfest!", 1, 2, nil},
	{-370, 11486, 4, 0, "The Best of Brews [Removed]", 1, 2, nil},
	{-370, 12020, 3, 0, "This One Time, When I Was Drunk...", 1, 2, nil},
	{-370, 12022, 1, 0, "Chug and Chuck!", 1, 2, nil},
	{-370, 12193, 1, 0, "Say, There Wouldn't Happen to be a Souvenir This Year, Would There?", 1, 2, nil},
	{-370, 12420, 1, 0, "Brew of the Month Club", 1, 2, nil},
	{-370, 12491, 1, 0, "Direbrew's Dire Brew", 1, 2, nil},
	{-370, 13932, 1, 0, "Another Year, Another Souvenir.", 1, 2, nil},
	{-370, 11120, 1, 0, "Pink Elekks On Parade", 2, 2, nil},
	{-370, 11407, 3, 0, "Bark for Drohn's Distillery!", 2, 2, nil},
	{-370, 11408, 3, 0, "Bark for T'chali's Voodoo Brewery!", 2, 2, nil},
	{-370, 11409, 1, 0, "Now This is Ram Racing... Almost.", 2, 2, nil},
	{-370, 11412, 1, 0, "There and Back Again", 2, 2, nil},
	{-370, 11413, 1, 0, "Did Someone Say \"Souvenir?\" ", 2, 2, nil},
	{-370, 11419, 4, 0, "Brewfest Riding Rams [Removed]", 2, 2, nil},
	{-370, 11431, 1, 0, "Catch the Wild Wolpertinger!", 2, 2, nil},
	{-370, 11446, 1, 0, "Brewfest!", 2, 2, nil},
	{-370, 11487, 4, 0, "The Best of Brews [Removed]", 2, 2, nil},
	{-370, 12191, 1, 0, "Chug and Chuck!", 2, 2, nil},
	{-370, 12192, 3, 0, "This One Time, When I Was Drunk...", 2, 2, nil},
	{-370, 12194, 1, 0, "Say, There Wouldn't Happen to be a Souvenir This Year, Would There?", 2, 2, nil},
	{-370, 12306, 1, 0, "Brew of the Month Club", 2, 2, nil},
	{-370, 12421, 1, 0, "Brew of the Month Club", 2, 2, nil},
	{-370, 12492, 1, 0, "Direbrew's Dire Brew", 2, 2, nil},
	{-370, 13931, 1, 0, "Another Year, Another Souvenir.", 2, 2, nil},
	{-370, 12318, 4, 0, "Save Brewfest! [Removed]", 3, 2, nil},
	{-370, 11454, 4, 52, "Seek the Saboteurs [Removed]", 3, 2, nil},
	{-370, 12062, 4, 80, "Insult Coren Direbrew [Removed]", 3, 2, nil},

	{-1002, 14441, 1, 0, "Garrosh's Autograph", 4, 2, nil},
	{-1002, 171, 1, 0, "A Warden of the Alliance", 1, 2, nil},
	{-1002, 558, 1, 0, "Jaina's Autograph", 1, 2, nil},
	{-1002, 1468, 1, 0, "Children's Week", 1, 2, nil},
	{-1002, 1479, 1, 0, "The Bough of the Eternals", 1, 2, nil},
	{-1002, 1558, 1, 0, "The Stonewrought Dam", 1, 2, nil},
	{-1002, 1687, 1, 0, "Spooky Lighthouse", 1, 2, nil},
	{-1002, 4822, 1, 0, "You Scream, I Scream...", 1, 2, nil},
	{-1002, 10943, 1, 0, "Children's Week", 1, 2, nil},
	{-1002, 10950, 1, 0, "Auchindoun and the Ring of Observance", 1, 2, nil},
	{-1002, 10952, 1, 0, "A Trip to the Dark Portal", 1, 2, nil},
	{-1002, 10954, 1, 0, "Jheel is at Aeris Landing!", 1, 2, nil},
	{-1002, 10956, 1, 0, "The Seat of the Naaru", 1, 2, nil},
	{-1002, 10962, 1, 0, "Time to Visit the Caverns", 1, 2, nil},
	{-1002, 10966, 1, 0, "Back to the Orphanage", 1, 2, nil},
	{-1002, 10968, 1, 0, "Call on the Farseer", 1, 2, nil},
	{-1002, 172, 1, 0, "Children's Week", 2, 2, nil},
	{-1002, 910, 1, 0, "Down at the Docks", 2, 2, nil},
	{-1002, 911, 1, 0, "Gateway to the Frontier", 2, 2, nil},
	{-1002, 915, 1, 0, "You Scream, I Scream...", 2, 2, nil},
	{-1002, 925, 1, 0, "Cairne's Hoofprint", 2, 2, nil},
	{-1002, 1800, 1, 0, "Lordaeron Throne Room", 2, 2, nil},
	{-1002, 5502, 1, 0, "A Warden of the Horde", 2, 2, nil},
	{-1002, 10942, 1, 0, "Children's Week", 2, 2, nil},
	{-1002, 10945, 1, 0, "Hch'uu and the Mushroom People", 2, 2, nil},
	{-1002, 10951, 1, 0, "A Trip to the Dark Portal", 2, 2, nil},
	{-1002, 10953, 1, 0, "Visit the Throne of the Elements", 2, 2, nil},
	{-1002, 10960, 4, 0, "When I Grow Up... [Removed]", 2, 2, nil},
	{-1002, 10963, 1, 0, "Time to Visit the Caverns", 2, 2, nil},
	{-1002, 10967, 1, 0, "Back to the Orphanage", 2, 2, nil},
	{-1002, 11975, 1, 0, "Now, When I Grow Up...", 2, 2, nil},
	{-1002, 13926, 1, 0, "Little Orphan Roo Of The Oracles", 3, 2, nil},
	{-1002, 13927, 1, 0, "Little Orphan Kekek Of The Wolvar", 3, 2, nil},
	{-1002, 13929, 1, 0, "The Biggest Tree Ever!", 3, 2, nil},
	{-1002, 13930, 1, 0, "Home Of The Bear-Men", 3, 2, nil},
	{-1002, 13933, 1, 0, "The Bronze Dragonshrine", 3, 2, nil},
	{-1002, 13934, 1, 0, "The Bronze Dragonshrine", 3, 2, nil},
	{-1002, 13937, 1, 0, "A Trip To The Wonderworks", 3, 2, nil},
	{-1002, 13938, 1, 0, "A Visit To The Wonderworks", 3, 2, nil},
	{-1002, 13950, 1, 0, "Playmates!", 3, 2, nil},
	{-1002, 13951, 1, 0, "Playmates!", 3, 2, nil},
	{-1002, 13954, 1, 0, "The Dragon Queen", 3, 2, nil},
	{-1002, 13955, 1, 0, "The Dragon Queen", 3, 2, nil},
	{-1002, 13956, 1, 0, "Meeting a Great One", 3, 2, nil},
	{-1002, 13957, 1, 0, "The Mighty Hemet Nesingwary", 3, 2, nil},
	{-1002, 13959, 1, 0, "Back To The Orphanage", 3, 2, nil},
	{-1002, 13960, 1, 0, "Back To The Orphanage", 3, 2, nil},

	{-364, 7981, 1, 0, "1200 Tickets - Amulet of the Darkmoon", 1, 2, nil},
	{-364, 7881, 1, 0, "Carnival Boots", 3, 2, nil},
	{-364, 7882, 1, 0, "Carnival Jerkins", 3, 2, nil},
	{-364, 7883, 1, 0, "The World's Largest Gnome!", 3, 2, nil},
	{-364, 7884, 1, 0, "Crocolisk Boy and the Bearded Murloc", 3, 2, nil},
	{-364, 7885, 1, 0, "Armor Kits", 3, 2, nil},
	{-364, 7889, 1, 0, "Coarse Weightstone", 3, 2, nil},
	{-364, 7890, 1, 0, "Heavy Grinding Stone", 3, 2, nil},
	{-364, 7891, 1, 0, "Green Iron Bracers", 3, 2, nil},
	{-364, 7892, 1, 0, "Big Black Mace", 3, 2, nil},
	{-364, 7893, 1, 0, "Rituals of Strength", 3, 2, nil},
	{-364, 7894, 1, 0, "Copper Modulator", 3, 2, nil},
	{-364, 7895, 1, 0, "Whirring Bronze Gizmo", 3, 2, nil},
	{-364, 7896, 1, 0, "Green Fireworks", 3, 2, nil},
	{-364, 7897, 1, 0, "Mechanical Repair Kits", 3, 2, nil},
	{-364, 7898, 1, 0, "Thorium Widget", 3, 2, nil},
	{-364, 7899, 1, 0, "Small Furry Paws", 3, 2, nil},
	{-364, 7900, 1, 0, "Torn Bear Pelts", 3, 2, nil},
	{-364, 7901, 1, 0, "Soft Bushy Tails", 3, 2, nil},
	{-364, 7902, 1, 0, "Vibrant Plumes", 3, 2, nil},
	{-364, 7903, 1, 0, "Evil Bat Eyes", 3, 2, nil},
	{-364, 7907, 1, 0, "Darkmoon Beast Deck", 3, 2, nil},
	{-364, 7927, 1, 0, "Darkmoon Portals Deck", 3, 2, nil},
	{-364, 7928, 1, 0, "Darkmoon Warlords Deck", 3, 2, nil},
	{-364, 7929, 1, 0, "Darkmoon Elementals Deck", 3, 2, nil},
	{-364, 7930, 1, 0, "5 Tickets - Darkmoon Flower", 3, 2, nil},
	{-364, 7931, 1, 0, "5 Tickets - Minor Darkmoon Prize", 3, 2, nil},
	{-364, 7932, 1, 0, "12 Tickets - Lesser Darkmoon Prize", 3, 2, nil},
	{-364, 7933, 1, 0, "40 Tickets - Greater Darkmoon Prize", 3, 2, nil},
	{-364, 7934, 1, 0, "50 Tickets - Darkmoon Storage Box", 3, 2, nil},
	{-364, 7935, 1, 0, "10 Tickets - Last Month's Mutton", 3, 2, nil},
	{-364, 7936, 1, 0, "50 Tickets - Last Year's Mutton", 3, 2, nil},
	{-364, 7937, 1, 0, "Your Fortune Awaits You...", 3, 2, nil},
	{-364, 7938, 1, 0, "Your Fortune Awaits You...", 3, 2, nil},
	{-364, 7939, 1, 0, "More Dense Grinding Stones", 3, 2, nil},
	{-364, 7940, 1, 0, "1200 Tickets - Orb of the Darkmoon", 3, 2, nil},
	{-364, 7941, 1, 0, "More Armor Kits", 3, 2, nil},
	{-364, 7942, 1, 0, "More Thorium Widgets", 3, 2, nil},
	{-364, 7943, 1, 0, "More Bat Eyes", 3, 2, nil},
	{-364, 7944, 1, 0, "Your Fortune Awaits You...", 3, 2, nil},
	{-364, 7945, 1, 0, "Your Fortune Awaits You...", 3, 2, nil},
	{-364, 7946, 1, 0, "Spawn of Jubjub", 3, 2, nil},
	{-364, 8222, 1, 0, "Glowing Scorpid Blood", 3, 2, nil},
	{-364, 8223, 1, 0, "More Glowing Scorpid Blood", 3, 2, nil},
	{-364, 9249, 1, 0, "40 Tickets - Schematic: Steam Tonk Controller", 3, 2, nil},
	{-364, 10938, 1, 70, "Darkmoon Blessings Deck", 3, 2, nil},
	{-364, 10939, 1, 70, "Darkmoon Storms Deck", 3, 2, nil},
	{-364, 10940, 1, 70, "Darkmoon Furies Deck", 3, 2, nil},
	{-364, 10941, 1, 70, "Darkmoon Lunacy Deck", 3, 2, nil},
	{-364, 13324, 1, 80, "Darkmoon Prisms Deck", 3, 2, nil},
	{-364, 13325, 1, 80, "Darkmoon Chaos Deck", 3, 2, nil},
	{-364, 13326, 1, 80, "Darkmoon Nobles Deck", 3, 2, nil},
	{-364, 13327, 1, 80, "Darkmoon Undeath Deck", 3, 2, nil},

	{-1007, 13952, 1, 0, "The Grateful Dead", 1, 2, nil},
	{-1007, 14167, 1, 0, "The Grateful Dead", 1, 2, nil},
	{-1007, 14168, 1, 0, "The Grateful Dead", 1, 2, nil},
	{-1007, 14169, 1, 0, "The Grateful Dead", 1, 2, nil},
	{-1007, 14170, 1, 0, "The Grateful Dead", 1, 2, nil},
	{-1007, 14171, 1, 0, "The Grateful Dead", 2, 2, nil},
	{-1007, 14174, 1, 0, "The Grateful Dead", 2, 2, nil},
	{-1007, 14175, 1, 0, "The Grateful Dead", 2, 2, nil},
	{-1007, 14176, 1, 0, "The Grateful Dead", 2, 2, nil},
	{-1007, 14177, 1, 0, "The Grateful Dead", 2, 2, nil},
	{-1007, 14166, 1, 0, "The Grateful Dead", 3, 2, nil},
	{-1007, 14172, 1, 0, "The Grateful Dead", 3, 2, nil},
	{-1007, 14173, 1, 0, "The Grateful Dead", 3, 2, nil},

	{-1003, 12405, 1, 0, "Candy Bucket", 4, 2, nil},
	{-1003, 12410, 1, 0, "Candy Bucket", 4, 2, nil},
	{-1003, 1658, 1, 0, "Crashing the Wickerman Festival [PvP]", 1, 2, nil},
	{-1003, 8311, 1, 0, "Hallow's End Treats for Jesper!", 1, 2, nil},
	{-1003, 8353, 1, 0, "Chicken Clucking for a Mint", 1, 2, nil},
	{-1003, 8355, 1, 0, "Incoming Gumdrop", 1, 2, nil},
	{-1003, 8356, 1, 0, "Flexing for Nougat", 1, 2, nil},
	{-1003, 8357, 1, 0, "Dancing for Marzipan", 1, 2, nil},
	{-1003, 8373, 1, 0, "The Power of Pine [PvP]", 1, 2, nil},
	{-1003, 11131, 3, 0, "Stop the Fires!", 1, 2, nil},
	{-1003, 11242, 1, 0, "Free at Last!", 1, 2, nil},
	{-1003, 11356, 1, 0, "Costumed Orphan Matron", 1, 2, nil},
	{-1003, 11360, 1, 0, "Fire Brigade Practice", 1, 2, nil},
	{-1003, 11404, 3, 0, "Call the Headless Horseman", 1, 2, nil},
	{-1003, 11439, 1, 0, "Fire Brigade Practice", 1, 2, nil},
	{-1003, 11440, 1, 0, "Fire Brigade Practice", 1, 2, nil},
	{-1003, 12133, 3, 0, "Smash the Pumpkin", 1, 2, nil},
	{-1003, 12135, 3, 0, "\"Let the Fires Come!\" ", 1, 2, nil},
	{-1003, 12286, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12331, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12332, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12333, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12334, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12335, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12336, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12337, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12338, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12339, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12340, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12341, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12342, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12343, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12344, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12345, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12346, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12347, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12348, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12349, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12350, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12351, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12352, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12353, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12354, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12355, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12356, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12357, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12358, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12359, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12360, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12944, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 12945, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 13433, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 13434, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 13435, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 13436, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 13437, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 13438, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 13439, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 13448, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 13473, 1, 0, "Candy Bucket", 1, 2, nil},
	{-1003, 1657, 1, 0, "Stinking Up Southshore [PvP]", 2, 2, nil},
	{-1003, 8312, 1, 0, "Hallow's End Treats for Spoops!", 2, 2, nil},
	{-1003, 8322, 1, 0, "Rotten Eggs [PvP]", 2, 2, nil},
	{-1003, 8354, 1, 0, "Chicken Clucking for a Mint", 2, 2, nil},
	{-1003, 8358, 1, 0, "Incoming Gumdrop", 2, 2, nil},
	{-1003, 8359, 1, 0, "Flexing for Nougat", 2, 2, nil},
	{-1003, 8360, 1, 0, "Dancing for Marzipan", 2, 2, nil},
	{-1003, 8409, 1, 0, "Ruined Kegs [PvP]", 2, 2, nil},
	{-1003, 11219, 3, 0, "Stop the Fires!", 2, 2, nil},
	{-1003, 11357, 1, 0, "Masked Orphan Matron", 2, 2, nil},
	{-1003, 11361, 1, 0, "Fire Training", 2, 2, nil},
	{-1003, 11403, 1, 0, "Free at Last!", 2, 2, nil},
	{-1003, 11405, 3, 0, "Call the Headless Horseman", 2, 2, nil},
	{-1003, 11449, 1, 0, "Fire Training", 2, 2, nil},
	{-1003, 11450, 1, 0, "Fire Training", 2, 2, nil},
	{-1003, 12139, 3, 0, "\"Let the Fires Come!\" ", 2, 2, nil},
	{-1003, 12155, 3, 0, "Smash the Pumpkin", 2, 2, nil},
	{-1003, 12361, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12362, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12363, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12364, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12365, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12366, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12367, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12368, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12369, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12370, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12371, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12373, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12374, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12375, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12376, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12377, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12378, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12379, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12380, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12381, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12382, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12383, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12384, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12385, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12386, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12387, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12388, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12389, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12390, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12391, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12392, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12393, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12394, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12395, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12946, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 12947, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 13464, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 13465, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 13466, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 13467, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 13468, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 13469, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 13470, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 13471, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 13474, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 13501, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 13548, 1, 0, "Candy Bucket", 2, 2, nil},
	{-1003, 11401, 3, 0, "Call the Headless Horseman", 3, 2, nil},
	{-1003, 12396, 1, 0, "Candy Bucket", 3, 2, nil},
	{-1003, 12397, 1, 0, "Candy Bucket", 3, 2, nil},
	{-1003, 12398, 1, 0, "Candy Bucket", 3, 2, nil},
	{-1003, 12399, 1, 0, "Candy Bucket", 3, 2, nil},
	{-1003, 12400, 1, 0, "Candy Bucket", 3, 2, nil},
	{-1003, 12401, 1, 0, "Candy Bucket", 3, 2, nil},
	{-1003, 12402, 1, 0, "Candy Bucket", 3, 2, nil},
	{-1003, 12403, 1, 0, "Candy Bucket", 3, 2, nil},
	{-1003, 12404, 1, 0, "Candy Bucket", 3, 2, nil},
	{-1003, 12406, 1, 0, "Candy Bucket", 3, 2, nil},
	{-1003, 12407, 1, 0, "Candy Bucket", 3, 2, nil},
	{-1003, 12408, 1, 0, "Candy Bucket", 3, 2, nil},
	{-1003, 12409, 1, 0, "Candy Bucket", 3, 2, nil},
	{-1003, 12940, 1, 0, "Candy Bucket", 3, 2, nil},
	{-1003, 12941, 1, 0, "Candy Bucket", 3, 2, nil},
	{-1003, 12950, 1, 0, "Candy Bucket", 3, 2, nil},
	{-1003, 13452, 1, 0, "Candy Bucket", 3, 2, nil},
	{-1003, 13456, 1, 0, "Candy Bucket", 3, 2, nil},
	{-1003, 13459, 1, 0, "Candy Bucket", 3, 2, nil},
	{-1003, 13460, 1, 0, "Candy Bucket", 3, 2, nil},
	{-1003, 13461, 1, 0, "Candy Bucket", 3, 2, nil},
	{-1003, 13462, 1, 0, "Candy Bucket", 3, 2, nil},
	{-1003, 13463, 1, 0, "Candy Bucket", 3, 2, nil},
	{-1003, 13472, 1, 0, "Candy Bucket", 3, 2, nil},
	{-1003, 11135, 1, 80, "The Headless Horseman", 1, 2, nil},
	{-1003, 11220, 1, 80, "The Headless Horseman", 2, 2, nil},
	{-1003, 11392, 1, 80, "Call the Headless Horseman", 3, 2, nil},

	{-1005, 8149, 1, 0, "Honoring a Hero", 1, 2, nil},
	{-1005, 8150, 1, 0, "Honoring a Hero", 2, 2, nil},

	{-1004, 24597, 3, 0, "A Gift for the King of Stormwind", 1, 2, nil},
	{-1004, 24609, 3, 0, "A Gift for the Lord of Ironforge", 1, 2, nil},
	{-1004, 24610, 3, 0, "A Gift for the High Priestess of Elune", 1, 2, nil},
	{-1004, 24611, 3, 0, "A Gift for the Prophet", 1, 2, nil},
	{-1004, 24655, 1, 0, "Something Stinks", 1, 2, nil},
	{-1004, 24656, 1, 0, "Pilfering Perfume", 1, 2, nil},
	{-1004, 24657, 1, 0, "A Friendly Chat...", 1, 2, nil},
	{-1004, 24658, 3, 0, "Crushing the Crown", 1, 2, nil},
	{-1004, 24659, 3, 0, "Crushing the Crown", 1, 2, nil},
	{-1004, 24660, 3, 0, "Crushing the Crown", 1, 2, nil},
	{-1004, 24662, 3, 0, "Crushing the Crown", 1, 2, nil},
	{-1004, 24663, 3, 0, "Crushing the Crown", 1, 2, nil},
	{-1004, 24664, 3, 0, "Crushing the Crown", 1, 2, nil},
	{-1004, 24665, 3, 0, "Crushing the Crown", 1, 2, nil},
	{-1004, 24666, 3, 0, "Crushing the Crown", 1, 2, nil},
	{-1004, 24792, 1, 0, "Man on the Inside", 1, 2, nil},
	{-1004, 24804, 1, 0, "Uncommon Scents", 1, 2, nil},
	{-1004, 24848, 1, 0, "Fireworks At The Gilded Rose", 1, 2, nil},
	{-1004, 24849, 1, 0, "Hot On The Trail", 1, 2, nil},
	{-1004, 24536, 1, 0, "Something Stinks", 2, 2, nil},
	{-1004, 24541, 1, 0, "Pilfering Perfume", 2, 2, nil},
	{-1004, 24576, 1, 0, "A Friendly Chat...", 2, 2, nil},
	{-1004, 24612, 3, 0, "A Gift for the Warchief", 2, 2, nil},
	{-1004, 24613, 3, 0, "A Gift for the Banshee Queen", 2, 2, nil},
	{-1004, 24614, 3, 0, "A Gift for the High Chieftain", 2, 2, nil},
	{-1004, 24615, 3, 0, "A Gift for the Regent Lord of Quel'Thalas", 2, 2, nil},
	{-1004, 24638, 3, 0, "Crushing the Crown", 2, 2, nil},
	{-1004, 24645, 3, 0, "Crushing the Crown", 2, 2, nil},
	{-1004, 24647, 3, 0, "Crushing the Crown", 2, 2, nil},
	{-1004, 24648, 3, 0, "Crushing the Crown", 2, 2, nil},
	{-1004, 24649, 3, 0, "Crushing the Crown", 2, 2, nil},
	{-1004, 24650, 3, 0, "Crushing the Crown", 2, 2, nil},
	{-1004, 24651, 3, 0, "Crushing the Crown", 2, 2, nil},
	{-1004, 24652, 3, 0, "Crushing the Crown", 2, 2, nil},
	{-1004, 24793, 1, 0, "Man on the Inside", 2, 2, nil},
	{-1004, 24805, 1, 0, "Uncommon Scents", 2, 2, nil},
	{-1004, 24850, 1, 0, "Snivel's Sweetheart", 2, 2, nil},
	{-1004, 24851, 1, 0, "Hot On The Trail", 2, 2, nil},
	{-1004, 24629, 3, 0, "A Perfect Puff of Perfume", 3, 2, nil},
	{-1004, 24635, 3, 0, "A Cloudlet of Classy Cologne", 3, 2, nil},
	{-1004, 24636, 3, 0, "Bonbon Blitz", 3, 2, nil},
	{-1004, 14483, 1, 80, "Something is in the Air (and it Ain't Love)", 4, 2, nil},
	{-1004, 24745, 1, 80, "Something is in the Air (and it Ain't Love)", 4, 2, nil},
	{-1004, 14488, 3, 80, "You've Been Served", 3, 2, nil},

	{-366, 13012, 1, 0, "Sardis the Elder", 4, 2, nil},
	{-366, 13013, 1, 0, "Beldak the Elder", 4, 2, nil},
	{-366, 13014, 1, 0, "Morthie the Elder", 4, 2, nil},
	{-366, 13015, 1, 0, "Fargal the Elder", 4, 2, nil},
	{-366, 13016, 1, 0, "Northal the Elder", 4, 2, nil},
	{-366, 13017, 1, 0, "Jarten the Elder", 4, 2, nil},
	{-366, 13018, 1, 0, "Sandrene the Elder", 4, 2, nil},
	{-366, 13019, 1, 0, "Thoim the Elder", 4, 2, nil},
	{-366, 13020, 1, 0, "Stonebeard the Elder", 4, 2, nil},
	{-366, 13021, 1, 0, "Igasho the Elder", 4, 2, nil},
	{-366, 13022, 1, 0, "Nurgen the Elder", 4, 2, nil},
	{-366, 13023, 1, 0, "Kilias the Elder", 4, 2, nil},
	{-366, 13024, 1, 0, "Wanikaya the Elder", 4, 2, nil},
	{-366, 13025, 1, 0, "Lunaro the Elder", 4, 2, nil},
	{-366, 13026, 1, 0, "Bluewolf the Elder", 4, 2, nil},
	{-366, 13027, 1, 0, "Tauros the Elder", 4, 2, nil},
	{-366, 13028, 1, 0, "Graymane the Elder", 4, 2, nil},
	{-366, 13029, 1, 0, "Pamuya the Elder", 4, 2, nil},
	{-366, 13030, 1, 0, "Whurain the Elder", 4, 2, nil},
	{-366, 13031, 1, 0, "Skywarden the Elder", 4, 2, nil},
	{-366, 13032, 1, 0, "Muraco the Elder", 4, 2, nil},
	{-366, 13033, 1, 0, "Arp the Elder", 4, 2, nil},
	{-366, 13065, 1, 0, "Ohanzee the Elder", 4, 2, nil},
	{-366, 13066, 1, 0, "Yurauk the Elder", 4, 2, nil},
	{-366, 13067, 1, 0, "Chogan'gada the Elder", 4, 2, nil},
	{-366, 8646, 1, 0, "Hammershout the Elder", 1, 2, nil},
	{-366, 8649, 1, 0, "Stormbrow the Elder", 1, 2, nil},
	{-366, 8653, 1, 0, "Goldwell the Elder", 1, 2, nil},
	{-366, 8675, 1, 0, "Skychaser the Elder", 1, 2, nil},
	{-366, 8718, 1, 0, "Bladeswift the Elder", 1, 2, nil},
	{-366, 8866, 1, 0, "Bronzebeard the Elder", 1, 2, nil},
	{-366, 8870, 1, 0, "The Lunar Festival", 1, 2, nil},
	{-366, 8871, 1, 0, "The Lunar Festival", 1, 2, nil},
	{-366, 8872, 1, 0, "The Lunar Festival", 1, 2, nil},
	{-366, 8648, 1, 0, "Darkcore the Elder", 2, 2, nil},
	{-366, 8677, 1, 0, "Darkhorn the Elder", 2, 2, nil},
	{-366, 8678, 1, 0, "Wheathoof the Elder", 2, 2, nil},
	{-366, 8682, 1, 0, "Skyseer the Elder", 2, 2, nil},
	{-366, 8686, 1, 0, "High Mountain the Elder", 2, 2, nil},
	{-366, 8873, 1, 0, "The Lunar Festival", 2, 2, nil},
	{-366, 8874, 1, 0, "The Lunar Festival", 2, 2, nil},
	{-366, 8875, 1, 0, "The Lunar Festival", 2, 2, nil},
	{-366, 8619, 1, 0, "Morndeep the Elder", 3, 2, nil},
	{-366, 8635, 1, 0, "Splitrock the Elder", 3, 2, nil},
	{-366, 8636, 1, 0, "Rumblerock the Elder", 3, 2, nil},
	{-366, 8642, 1, 0, "Silvervein the Elder", 3, 2, nil},
	{-366, 8643, 1, 0, "Highpeak the Elder", 3, 2, nil},
	{-366, 8644, 1, 0, "Stonefort the Elder", 3, 2, nil},
	{-366, 8645, 1, 0, "Obsidian the Elder", 3, 2, nil},
	{-366, 8647, 1, 0, "Bellowrage the Elder", 3, 2, nil},
	{-366, 8650, 1, 0, "Snowcrown the Elder", 3, 2, nil},
	{-366, 8651, 1, 0, "Ironband the Elder", 3, 2, nil},
	{-366, 8652, 1, 0, "Graveborn the Elder", 3, 2, nil},
	{-366, 8654, 1, 0, "Primestone the Elder", 3, 2, nil},
	{-366, 8670, 1, 0, "Runetotem the Elder", 3, 2, nil},
	{-366, 8671, 1, 0, "Ragetotem the Elder", 3, 2, nil},
	{-366, 8672, 1, 0, "Stonespire the Elder", 3, 2, nil},
	{-366, 8673, 1, 0, "Bloodhoof the Elder", 3, 2, nil},
	{-366, 8674, 1, 0, "Winterhoof the Elder", 3, 2, nil},
	{-366, 8676, 1, 0, "Wildmane the Elder", 3, 2, nil},
	{-366, 8679, 1, 0, "Grimtotem the Elder", 3, 2, nil},
	{-366, 8680, 1, 0, "Windtotem the Elder", 3, 2, nil},
	{-366, 8681, 1, 0, "Thunderhorn the Elder", 3, 2, nil},
	{-366, 8683, 1, 0, "Dawnstrider the Elder", 3, 2, nil},
	{-366, 8684, 1, 0, "Dreamseer the Elder", 3, 2, nil},
	{-366, 8685, 1, 0, "Mistwalker the Elder", 3, 2, nil},
	{-366, 8688, 1, 0, "Windrun the Elder", 3, 2, nil},
	{-366, 8713, 1, 0, "Starsong the Elder", 3, 2, nil},
	{-366, 8714, 1, 0, "Moonstrike the Elder", 3, 2, nil},
	{-366, 8715, 1, 0, "Bladeleaf the Elder", 3, 2, nil},
	{-366, 8716, 1, 0, "Starglade the Elder", 3, 2, nil},
	{-366, 8717, 1, 0, "Moonwarden the Elder", 3, 2, nil},
	{-366, 8719, 1, 0, "Bladesing the Elder", 3, 2, nil},
	{-366, 8720, 1, 0, "Skygleam the Elder", 3, 2, nil},
	{-366, 8721, 1, 0, "Starweave the Elder", 3, 2, nil},
	{-366, 8722, 1, 0, "Meadowrun the Elder", 3, 2, nil},
	{-366, 8723, 1, 0, "Nightwind the Elder", 3, 2, nil},
	{-366, 8724, 1, 0, "Morningdew the Elder", 3, 2, nil},
	{-366, 8725, 1, 0, "Riversong the Elder", 3, 2, nil},
	{-366, 8726, 1, 0, "Brightspear the Elder", 3, 2, nil},
	{-366, 8727, 1, 0, "Farwhisper the Elder", 3, 2, nil},
	{-366, 8867, 1, 0, "Lunar Fireworks", 3, 2, nil},
	{-366, 8868, 1, 0, "Elune's Blessing", 3, 2, nil},
	{-366, 8883, 1, 0, "Valadar Starsong", 3, 2, nil},

	{-369, 11580, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11583, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11584, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11734, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11735, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11736, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11737, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11738, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11739, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11740, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11741, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11742, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11743, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11744, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11746, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11747, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11748, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11750, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11751, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11752, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11753, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11754, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11756, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11757, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11758, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11759, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11760, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11761, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11762, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11763, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11764, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11765, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11767, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11768, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11769, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11770, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11771, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11772, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11773, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11774, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11775, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11776, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11777, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11778, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11779, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11780, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11781, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11782, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11783, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11784, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11785, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11787, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11799, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11800, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11801, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11802, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11803, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 11804, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11805, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11806, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11808, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11809, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11810, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11811, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11812, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11813, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11814, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11815, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11816, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11817, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11818, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11819, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11820, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11822, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11823, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11824, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11825, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11826, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11827, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11828, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11829, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11830, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11831, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11832, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11833, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11834, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11835, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11837, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11839, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11840, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11841, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11842, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11844, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11845, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11846, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11847, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11848, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11849, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11850, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11851, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11852, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11853, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11854, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11855, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11857, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11858, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11859, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11860, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11861, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11862, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 11863, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 13440, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 13441, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 13442, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 13443, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 13444, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 13445, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 13446, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 13447, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 13449, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 13450, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 13451, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 13453, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 13454, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 13455, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 13457, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 13458, 1, 0, "Desecrate this Fire!", 4, 2, nil},
	{-369, 13485, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 13486, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 13487, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 13488, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 13489, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 13490, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 13491, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 13492, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 13493, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 13494, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 13495, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 13496, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 13497, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 13498, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 13499, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 13500, 1, 0, "Honor the Flame", 4, 2, nil},
	{-369, 9324, 1, 0, "Stealing Orgrimmar's Flame", 1, 2, nil},
	{-369, 9325, 1, 0, "Stealing Thunder Bluff's Flame", 1, 2, nil},
	{-369, 9326, 1, 0, "Stealing the Undercity's Flame", 1, 2, nil},
	{-369, 9365, 1, 0, "A Thief's Reward", 1, 2, nil},
	{-369, 11657, 1, 0, "Torch Catching", 1, 2, nil},
	{-369, 11731, 1, 0, "Torch Tossing", 1, 2, nil},
	{-369, 11732, 1, 0, "Desecrate this Fire!", 1, 2, nil},
	{-369, 11755, 1, 0, "Desecrate this Fire!", 1, 2, nil},
	{-369, 11766, 1, 0, "Desecrate this Fire!", 1, 2, nil},
	{-369, 11786, 1, 0, "Desecrate this Fire!", 1, 2, nil},
	{-369, 11807, 1, 0, "Honor the Flame", 1, 2, nil},
	{-369, 11882, 1, 0, "Playing with Fire", 1, 2, nil},
	{-369, 11921, 3, 0, "More Torch Tossing", 1, 2, nil},
	{-369, 11924, 3, 0, "More Torch Catching", 1, 2, nil},
	{-369, 11935, 1, 0, "Stealing Silvermoon's Flame", 1, 2, nil},
	{-369, 11964, 1, 0, "Incense for the Summer Scorchlings", 1, 2, nil},
	{-369, 11970, 1, 0, "The Master of Summer Lore", 1, 2, nil},
	{-369, 9330, 1, 0, "Stealing Stormwind's Flame", 2, 2, nil},
	{-369, 9331, 1, 0, "Stealing Ironforge's Flame", 2, 2, nil},
	{-369, 9332, 1, 0, "Stealing Darnassus's Flame", 2, 2, nil},
	{-369, 9339, 1, 0, "A Thief's Reward", 2, 2, nil},
	{-369, 11581, 1, 0, "Desecrate this Fire!", 2, 2, nil},
	{-369, 11745, 1, 0, "Desecrate this Fire!", 2, 2, nil},
	{-369, 11749, 1, 0, "Desecrate this Fire!", 2, 2, nil},
	{-369, 11821, 1, 0, "Honor the Flame", 2, 2, nil},
	{-369, 11836, 1, 0, "Honor the Flame", 2, 2, nil},
	{-369, 11838, 1, 0, "Honor the Flame", 2, 2, nil},
	{-369, 11843, 1, 0, "Honor the Flame", 2, 2, nil},
	{-369, 11856, 1, 0, "Honor the Flame", 2, 2, nil},
	{-369, 11915, 1, 0, "Playing with Fire", 2, 2, nil},
	{-369, 11922, 1, 0, "Torch Tossing", 2, 2, nil},
	{-369, 11923, 1, 0, "Torch Catching", 2, 2, nil},
	{-369, 11925, 3, 0, "More Torch Catching", 2, 2, nil},
	{-369, 11926, 3, 0, "More Torch Tossing", 2, 2, nil},
	{-369, 11933, 1, 0, "Stealing the Exodar's Flame", 2, 2, nil},
	{-369, 11966, 1, 0, "Incense for the Festival Scorchlings", 2, 2, nil},
	{-369, 11971, 1, 0, "The Spinner of Summer Tales", 2, 2, nil},
	{-369, 11886, 1, 0, "Unusual Activity", 3, 2, nil},
	{-369, 11891, 1, 0, "An Innocent Disguise", 3, 2, nil},
	{-369, 11972, 1, 0, "Shards of Ahune", 3, 2, nil},
	{-369, 12012, 1, 0, "Inform the Elder", 3, 2, nil},
	{-369, 11917, 3, 22, "Striking Back", 3, 2, nil},
	{-369, 11947, 3, 32, "Striking Back", 3, 2, nil},
	{-369, 11948, 3, 43, "Striking Back", 3, 2, nil},
	{-369, 11952, 3, 51, "Striking Back", 3, 2, nil},
	{-369, 11953, 3, 60, "Striking Back", 3, 2, nil},
	{-369, 11954, 3, 67, "Striking Back", 3, 2, nil},
	{-369, 11691, 3, 80, "Summon Ahune", 3, 2, nil},
	{-369, 11696, 1, 80, "Ahune is Here!", 3, 2, nil},
	{-369, 11955, 1, 80, "Ahune, the Frost Lord", 3, 2, nil},

	{-1006, 8860, 1, 0, "New Year Celebrations!", 1, 2, nil},
	{-1006, 8861, 1, 0, "New Year Celebrations!", 2, 2, nil},

	{-1008, 14022, 1, 0, "Pilgrim's Bounty", 1, 2, nil},
	{-1008, 14023, 1, 0, "Spice Bread Stuffing", 1, 2, nil},
	{-1008, 14024, 1, 0, "Pumpkin Pie", 1, 2, nil},
	{-1008, 14028, 1, 0, "Cranberry Chutney", 1, 2, nil},
	{-1008, 14030, 1, 0, "They're Ravenous In Darnassus", 1, 2, nil},
	{-1008, 14033, 1, 0, "Candied Sweet Potatoes", 1, 2, nil},
	{-1008, 14035, 1, 0, "Slow-roasted Turkey", 1, 2, nil},
	{-1008, 14048, 3, 0, "Can't Get Enough Turkey", 1, 2, nil},
	{-1008, 14051, 3, 0, "Don't Forget The Stuffing!", 1, 2, nil},
	{-1008, 14053, 3, 0, "We're Out of Cranberry Chutney Again?", 1, 2, nil},
	{-1008, 14054, 3, 0, "Easy As Pie", 1, 2, nil},
	{-1008, 14055, 3, 0, "She Says Potato", 1, 2, nil},
	{-1008, 14064, 1, 0, "Sharing a Bountiful Feast", 1, 2, nil},
	{-1008, 14036, 1, 0, "Pilgrim's Bounty", 2, 2, nil},
	{-1008, 14037, 1, 0, "Spice Bread Stuffing", 2, 2, nil},
	{-1008, 14040, 1, 0, "Pumpkin Pie", 2, 2, nil},
	{-1008, 14041, 1, 0, "Cranberry Chutney", 2, 2, nil},
	{-1008, 14043, 1, 0, "Candied Sweet Potatoes", 2, 2, nil},
	{-1008, 14044, 1, 0, "Undersupplied in the Undercity", 2, 2, nil},
	{-1008, 14047, 1, 0, "Slow-roasted Turkey", 2, 2, nil},
	{-1008, 14058, 3, 0, "She Says Potato", 2, 2, nil},
	{-1008, 14059, 3, 0, "We're Out of Cranberry Chutney Again?", 2, 2, nil},
	{-1008, 14060, 3, 0, "Easy As Pie", 2, 2, nil},
	{-1008, 14061, 3, 0, "Can't Get Enough Turkey", 2, 2, nil},
	{-1008, 14062, 3, 0, "Don't Forget The Stuffing!", 2, 2, nil},
	{-1008, 14065, 1, 0, "Sharing a Bountiful Feast", 2, 2, nil},

	{-374, 13480, 3, 0, "The Great Egg Hunt", 1, 2, nil},
	{-374, 13484, 1, 0, "Spring Collectors", 1, 2, nil},
	{-374, 13502, 1, 0, "A Tisket, a Tasket, a Noblegarden Basket", 1, 2, nil},
	{-374, 13479, 3, 0, "The Great Egg Hunt", 2, 2, nil},
	{-374, 13483, 1, 0, "Spring Gatherers", 2, 2, nil},
	{-374, 13503, 1, 0, "A Tisket, a Tasket, a Noblegarden Basket", 2, 2, nil},

	{-1001, 8767, 1, 0, "A Gently Shaken Gift", 4, 2, nil},
	{-1001, 8788, 1, 0, "A Gently Shaken Gift", 4, 2, nil},
	{-1001, 11528, 1, 0, "A Winter Veil Gift", 4, 2, nil},
	{-1001, 13203, 1, 0, "A Winter Veil Gift", 4, 2, nil},
	{-1001, 13966, 1, 0, "A Winter Veil Gift", 4, 2, nil},
	{-1001, 7022, 1, 0, "Greatfather Winter is Here!", 1, 2, nil},
	{-1001, 7023, 1, 0, "Greatfather Winter is Here!", 1, 2, nil},
	{-1001, 7025, 1, 0, "Treats for Greatfather Winter", 1, 2, nil},
	{-1001, 7042, 1, 0, "Stolen Winter Veil Treats", 1, 2, nil},
	{-1001, 7043, 1, 0, "You're a Mean One... [Group]", 1, 2, nil},
	{-1001, 7045, 1, 0, "A Smokywood Pastures' Thank You!", 1, 2, nil},
	{-1001, 7062, 1, 0, "The Reason for the Season", 1, 2, nil},
	{-1001, 7063, 1, 0, "The Feast of Winter Veil", 1, 2, nil},
	{-1001, 8762, 1, 0, "Metzen the Reindeer", 1, 2, nil},
	{-1001, 8763, 1, 0, "The Hero of the Day", 1, 2, nil},
	{-1001, 8827, 1, 0, "Winter's Presents", 1, 2, nil},
	{-1001, 6961, 1, 0, "Great-father Winter is Here!", 2, 2, nil},
	{-1001, 6962, 1, 0, "Treats for Great-father Winter", 2, 2, nil},
	{-1001, 6963, 1, 0, "Stolen Winter Veil Treats", 2, 2, nil},
	{-1001, 6964, 1, 0, "The Reason for the Season", 2, 2, nil},
	{-1001, 6983, 1, 0, "You're a Mean One... [Group]", 2, 2, nil},
	{-1001, 6984, 1, 0, "A Smokywood Pastures' Thank You!", 2, 2, nil},
	{-1001, 7021, 1, 0, "Great-father Winter is Here!", 2, 2, nil},
	{-1001, 7024, 1, 0, "Great-father Winter is Here!", 2, 2, nil},
	{-1001, 7061, 1, 0, "The Feast of Winter Veil", 2, 2, nil},
	{-1001, 8746, 1, 0, "Metzen the Reindeer", 2, 2, nil},
	{-1001, 8799, 1, 0, "The Hero of the Day", 2, 2, nil},
	{-1001, 8828, 1, 0, "Winter's Presents", 2, 2, nil},
	{-1001, 8744, 1, 0, "A Carefully Wrapped Present", 3, 2, nil},
	{-1001, 8768, 1, 0, "A Gaily Wrapped Present", 3, 2, nil},
	{-1001, 8769, 1, 0, "A Ticking Present", 3, 2, nil},
	{-1001, 8803, 1, 0, "A Festive Gift", 3, 2, nil},

	--[[

		BATTLEGROUNDS - Original Version 07/11/2010;

		CHANGELOG:

		##/##/####
		None

	--]]

	{2597, 5892, 1, 0, "Irondeep Supplies", 1, 2, nil},
	{2597, 6781, 2, 0, "More Armor Scraps [PvP]", 1, 2, nil},
	{2597, 6881, 2, 0, "Ivus the Forest Lord [PvP]", 1, 2, nil},
	{2597, 6941, 2, 0, "Call of Air - Vipore's Fleet [PvP]", 1, 2, nil},
	{2597, 6942, 2, 0, "Call of Air - Slidore's Fleet [PvP]", 1, 2, nil},
	{2597, 6943, 2, 0, "Call of Air - Ichman's Fleet [PvP]", 1, 2, nil},
	{2597, 6982, 1, 0, "Coldtooth Supplies", 1, 2, nil},
	{2597, 7026, 2, 0, "Ram Riding Harnesses [PvP]", 1, 2, nil},
	{2597, 7027, 1, 0, "Empty Stables", 1, 2, nil},
	{2597, 7081, 1, 0, "Alterac Valley Graveyards", 1, 2, nil},
	{2597, 7102, 1, 0, "Towers and Bunkers", 1, 2, nil},
	{2597, 7121, 1, 0, "The Quartermaster", 1, 2, nil},
	{2597, 7122, 1, 0, "Capture a Mine", 1, 2, nil},
	{2597, 7141, 1, 0, "The Battle of Alterac", 1, 2, nil},
	{2597, 7162, 1, 0, "Proving Grounds", 1, 2, nil},
	{2597, 7168, 1, 0, "Rise and Be Recognized", 1, 2, nil},
	{2597, 7169, 1, 0, "Honored Amongst the Guard", 1, 2, nil},
	{2597, 7170, 1, 0, "Earned Reverence", 1, 2, nil},
	{2597, 7171, 1, 0, "Legendary Heroes", 1, 2, nil},
	{2597, 7172, 1, 0, "The Eye of Command", 1, 2, nil},
	{2597, 7223, 1, 0, "Armor Scraps", 1, 2, nil},
	{2597, 7261, 1, 0, "The Sovereign Imperative", 1, 2, nil},
	{2597, 7386, 2, 0, "Crystal Cluster [PvP]", 1, 2, nil},
	{2597, 8271, 1, 0, "Hero of the Stormpike [PvP]", 1, 2, nil},
	{2597, 11336, 3, 0, "Call to Arms: Alterac Valley [PvP]", 1, 2, nil},
	{2597, 13427, 3, 0, "Call to Arms: Alterac Valley [PvP]", 1, 2, nil},
	{2597, 24427, 3, 0, "Call to Arms: Alterac Valley [PvP]", 1, 2, nil},
	{2597, 5893, 1, 0, "Coldtooth Supplies", 2, 2, nil},
	{2597, 6741, 2, 0, "More Booty!", 2, 2, nil},
	{2597, 6801, 2, 0, "Lokholar the Ice Lord [PvP]", 2, 2, nil},
	{2597, 6825, 2, 0, "Call of Air - Guse's Fleet [PvP]", 2, 2, nil},
	{2597, 6826, 2, 0, "Call of Air - Jeztor's Fleet [PvP]", 2, 2, nil},
	{2597, 6827, 2, 0, "Call of Air - Mulverick's Fleet [PvP]", 2, 2, nil},
	{2597, 6985, 1, 0, "Irondeep Supplies [PvP]", 2, 2, nil},
	{2597, 7001, 1, 0, "Empty Stables", 2, 2, nil},
	{2597, 7002, 2, 0, "Ram Hide Harnesses [PvP]", 2, 2, nil},
	{2597, 7082, 1, 0, "The Graveyards of Alterac", 2, 2, nil},
	{2597, 7101, 1, 0, "Towers and Bunkers", 2, 2, nil},
	{2597, 7123, 1, 0, "Speak with our Quartermaster", 2, 2, nil},
	{2597, 7124, 1, 0, "Capture a Mine", 2, 2, nil},
	{2597, 7142, 1, 0, "The Battle for Alterac", 2, 2, nil},
	{2597, 7161, 1, 0, "Proving Grounds", 2, 2, nil},
	{2597, 7163, 1, 0, "Rise and Be Recognized", 2, 2, nil},
	{2597, 7164, 1, 0, "Honored Amongst the Clan", 2, 2, nil},
	{2597, 7165, 1, 0, "Earned Reverence", 2, 2, nil},
	{2597, 7166, 1, 0, "Legendary Heroes", 2, 2, nil},
	{2597, 7167, 1, 0, "The Eye of Command", 2, 2, nil},
	{2597, 7224, 1, 0, "Enemy Booty", 2, 2, nil},
	{2597, 7241, 1, 0, "In Defense of Frostwolf", 2, 2, nil},
	{2597, 7385, 2, 0, "A Gallon of Blood [PvP]", 2, 2, nil},
	{2597, 8272, 1, 0, "Hero of the Frostwolf [PvP]", 2, 2, nil},
	{2597, 11340, 3, 0, "Call to Arms: Alterac Valley [PvP]", 2, 2, nil},
	{2597, 13428, 3, 0, "Call to Arms: Alterac Valley [PvP]", 2, 2, nil},
	{2597, 24426, 3, 0, "Call to Arms: Alterac Valley [PvP]", 2, 2, nil},
	{2597, 8369, 1, 60, "Invaders of Alterac Valley [PvP]", 2, 2, nil},

	{3358, 11335, 3, 0, "Call to Arms: Arathi Basin [PvP]", 1, 2, nil},
	{3358, 14178, 3, 0, "Call to Arms: Arathi Basin [PvP]", 1, 2, nil},
	{3358, 24220, 3, 0, "Call to Arms: Arathi Basin [PvP]", 1, 2, nil},
	{3358, 24223, 3, 0, "Call to Arms: Arathi Basin [PvP]", 1, 2, nil},
	{3358, 11339, 3, 0, "Call to Arms: Arathi Basin [PvP]", 2, 2, nil},
	{3358, 14181, 3, 0, "Call to Arms: Arathi Basin [PvP]", 2, 2, nil},
	{3358, 24221, 3, 0, "Call to Arms: Arathi Basin [PvP]", 2, 2, nil},
	{3358, 24226, 3, 0, "Call to Arms: Arathi Basin [PvP]", 2, 2, nil},
	{3358, 8260, 1, 34, "Arathor Basic Care Package", 1, 2, nil},
	{3358, 8263, 1, 34, "Defiler's Basic Care Package", 2, 2, nil},
	{3358, 8261, 1, 44, "Arathor Standard Care Package", 1, 2, nil},
	{3358, 8264, 1, 44, "Defiler's Standard Care Package", 2, 2, nil},
	{3358, 8105, 1, 55, "The Battle for Arathi Basin! [PvP]", 1, 2, nil},
	{3358, 8120, 1, 55, "The Battle for Arathi Basin! [PvP]", 2, 2, nil},
	{3358, 8114, 1, 60, "Control Four Bases [PvP]", 1, 2, nil},
	{3358, 8115, 1, 60, "Control Five Bases [PvP]", 1, 2, nil},
	{3358, 8121, 1, 60, "Take Four Bases [PvP]", 2, 2, nil},
	{3358, 8122, 1, 60, "Take Five Bases [PvP]", 2, 2, nil},
	{3358, 8262, 1, 70, "Arathor Advanced Care Package", 1, 2, nil},
	{3358, 8265, 1, 70, "Defiler's Advanced Care Package", 2, 2, nil},

	{-25, 8371, 1, 0, "Concerted Efforts", 1, 2, nil},
	{-25, 13478, 1, 0, "Concerted Efforts", 1, 2, nil},
	{-25, 8367, 1, 0, "For Great Honor", 2, 2, nil},
	{-25, 13476, 1, 0, "For Great Honor", 2, 2, nil},

	{3820, 11337, 3, 0, "Call to Arms: Eye of the Storm [PvP]", 1, 2, nil},
	{3820, 14179, 3, 0, "Call to Arms: Eye of the Storm [PvP]", 1, 2, nil},
	{3820, 11341, 3, 0, "Call to Arms: Eye of the Storm [PvP]", 2, 2, nil},
	{3820, 14182, 3, 0, "Call to Arms: Eye of the Storm [PvP]", 2, 2, nil},

	{4710, 14163, 3, 0, "Call to Arms: Isle of Conquest [PvP]", 1, 2, nil},
	{4710, 14164, 3, 0, "Call to Arms: Isle of Conquest [PvP]", 2, 2, nil},

	{4384, 13405, 3, 0, "Call to Arms: Strand of the Ancients [PvP]", 1, 2, nil},
	{4384, 13407, 3, 0, "Call to Arms: Strand of the Ancients [PvP]", 2, 2, nil},

	{3277, 11338, 3, 0, "Call to Arms: Warsong Gulch [PvP]", 1, 2, nil},
	{3277, 14180, 3, 0, "Call to Arms: Warsong Gulch [PvP]", 1, 2, nil},
	{3277, 24218, 3, 0, "Call to Arms: Warsong Gulch [PvP]", 1, 2, nil},
	{3277, 24219, 3, 0, "Call to Arms: Warsong Gulch [PvP]", 1, 2, nil},
	{3277, 24224, 3, 0, "Call to Arms: Warsong Gulch [PvP]", 1, 2, nil},
	{3277, 11342, 3, 0, "Call to Arms: Warsong Gulch [PvP]", 2, 2, nil},
	{3277, 14183, 3, 0, "Call to Arms: Warsong Gulch [PvP]", 2, 2, nil},
	{3277, 24216, 3, 0, "Call to Arms: Warsong Gulch [PvP]", 2, 2, nil},
	{3277, 24217, 3, 0, "Call to Arms: Warsong Gulch [PvP]", 2, 2, nil},
	{3277, 24225, 3, 0, "Call to Arms: Warsong Gulch [PvP]", 2, 2, nil},
	{3277, 8368, 4, 19, "Battle of Warsong Gulch [Removed]", 2, 2, nil},
	{3277, 7866, 1, 34, "Outrider Basic Care Package", 2, 2, nil},
	{3277, 7867, 1, 44, "Outrider Standard Care Package", 2, 2, nil},
	{3277, 8401, 4, 49, "Fight for Warsong Gulch [Removed]", 1, 2, nil},
	{3277, 7868, 1, 70, "Outrider Advanced Care Package", 2, 2, nil},

	--[[

		CLASS QUESTS - Original Version 07/11/2010;

		CHANGELOG:

		08/11/2010

		Quests flagged as special:
		12781.

	--]]

	{-372, 12781, 4, 1, "Welcome!", 3, 1, "DEATHKNIGHT"},
	{-372, 12742, 1, 55, "A Special Surprise", 1, 1, "DEATHKNIGHT"},
	{-372, 12743, 1, 55, "A Special Surprise", 1, 1, "DEATHKNIGHT"},
	{-372, 12744, 1, 55, "A Special Surprise", 1, 1, "DEATHKNIGHT"},
	{-372, 12745, 1, 55, "A Special Surprise", 1, 1, "DEATHKNIGHT"},
	{-372, 13188, 1, 55, "Where Kings Walk", 1, 1, "DEATHKNIGHT"},
	{-372, 12739, 1, 55, "A Special Surprise", 2, 1, "DEATHKNIGHT"},
	{-372, 12747, 1, 55, "A Special Surprise", 2, 1, "DEATHKNIGHT"},
	{-372, 12748, 1, 55, "A Special Surprise", 2, 1, "DEATHKNIGHT"},
	{-372, 12749, 1, 55, "A Special Surprise", 2, 1, "DEATHKNIGHT"},
	{-372, 12750, 1, 55, "A Special Surprise", 2, 1, "DEATHKNIGHT"},
	{-372, 13189, 1, 55, "Warchief's Blessing", 2, 1, "DEATHKNIGHT"},
	{-372, 12593, 1, 55, "In Service Of The Lich King", 3, 1, "DEATHKNIGHT"},
	{-372, 12619, 1, 55, "The Emblazoned Runeblade", 3, 1, "DEATHKNIGHT"},
	{-372, 12636, 1, 55, "The Eye Of Acherus", 3, 1, "DEATHKNIGHT"},
	{-372, 12641, 1, 55, "Death Comes From On High", 3, 1, "DEATHKNIGHT"},
	{-372, 12657, 1, 55, "The Might Of The Scourge", 3, 1, "DEATHKNIGHT"},
	{-372, 12670, 1, 55, "The Scarlet Harvest", 3, 1, "DEATHKNIGHT"},
	{-372, 12678, 1, 55, "If Chaos Drives, Let Suffering Hold The Reins", 3, 1, "DEATHKNIGHT"},
	{-372, 12679, 1, 55, "Tonight We Dine In Havenshire", 3, 1, "DEATHKNIGHT"},
	{-372, 12680, 1, 55, "Grand Theft Palomino", 3, 1, "DEATHKNIGHT"},
	{-372, 12687, 1, 55, "Into the Realm of Shadows", 3, 1, "DEATHKNIGHT"},
	{-372, 12697, 1, 55, "Gothik the Harvester", 3, 1, "DEATHKNIGHT"},
	{-372, 12698, 1, 55, "The Gift That Keeps On Giving", 3, 1, "DEATHKNIGHT"},
	{-372, 12700, 1, 55, "An Attack Of Opportunity", 3, 1, "DEATHKNIGHT"},
	{-372, 12701, 1, 55, "Massacre At Light's Point", 3, 1, "DEATHKNIGHT"},
	{-372, 12706, 1, 55, "Victory At Death's Breach!", 3, 1, "DEATHKNIGHT"},
	{-372, 12711, 1, 55, "Abandoned Mail", 3, 1, "DEATHKNIGHT"},
	{-372, 12714, 1, 55, "The Will Of The Lich King", 3, 1, "DEATHKNIGHT"},
	{-372, 12715, 1, 55, "The Crypt of Remembrance", 3, 1, "DEATHKNIGHT"},
	{-372, 12716, 1, 55, "The Plaguebringer's Request", 3, 1, "DEATHKNIGHT"},
	{-372, 12717, 1, 55, "Noth's Special Brew", 3, 1, "DEATHKNIGHT"},
	{-372, 12718, 2, 55, "More Skulls For Brew", 3, 1, "DEATHKNIGHT"},
	{-372, 12719, 1, 55, "Nowhere To Run And Nowhere To Hide", 3, 1, "DEATHKNIGHT"},
	{-372, 12720, 1, 55, "How To Win Friends And Influence Enemies", 3, 1, "DEATHKNIGHT"},
	{-372, 12722, 1, 55, "Lambs To The Slaughter", 3, 1, "DEATHKNIGHT"},
	{-372, 12723, 1, 55, "Behind Scarlet Lines", 3, 1, "DEATHKNIGHT"},
	{-372, 12724, 1, 55, "The Path Of The Righteous Crusader", 3, 1, "DEATHKNIGHT"},
	{-372, 12725, 1, 55, "Brothers In Death", 3, 1, "DEATHKNIGHT"},
	{-372, 12727, 1, 55, "Bloody Breakout", 3, 1, "DEATHKNIGHT"},
	{-372, 12733, 1, 55, "Death's Challenge", 3, 1, "DEATHKNIGHT"},
	{-372, 12738, 1, 55, "A Cry For Vengeance!", 3, 1, "DEATHKNIGHT"},
	{-372, 12746, 1, 55, "A Special Surprise", 3, 1, "DEATHKNIGHT"},
	{-372, 12751, 1, 55, "A Sort Of Homecoming", 3, 1, "DEATHKNIGHT"},
	{-372, 12754, 1, 55, "Ambush At The Overlook", 3, 1, "DEATHKNIGHT"},
	{-372, 12755, 1, 55, "A Meeting With Fate", 3, 1, "DEATHKNIGHT"},
	{-372, 12756, 1, 55, "The Scarlet Onslaught Emerges", 3, 1, "DEATHKNIGHT"},
	{-372, 12757, 1, 55, "Scarlet Armies Approach...", 3, 1, "DEATHKNIGHT"},
	{-372, 12778, 1, 55, "The Scarlet Apocalypse", 3, 1, "DEATHKNIGHT"},
	{-372, 12779, 1, 55, "An End To All Things...", 3, 1, "DEATHKNIGHT"},
	{-372, 12800, 1, 55, "The Lich King's Command", 3, 1, "DEATHKNIGHT"},
	{-372, 12801, 1, 55, "The Light of Dawn", 3, 1, "DEATHKNIGHT"},
	{-372, 12842, 1, 55, "Runeforging: Preparation For Battle", 3, 1, "DEATHKNIGHT"},
	{-372, 12848, 1, 55, "The Endless Hunger", 3, 1, "DEATHKNIGHT"},
	{-372, 12849, 1, 55, "The Power Of Blood, Frost And Unholy", 3, 1, "DEATHKNIGHT"},
	{-372, 12850, 1, 55, "Report To Scourge Commander Thalanor", 3, 1, "DEATHKNIGHT"},
	{-372, 13165, 1, 55, "Taking Back Acherus", 3, 1, "DEATHKNIGHT"},
	{-372, 13166, 1, 55, "The Battle For The Ebon Hold", 3, 1, "DEATHKNIGHT"},

	{-263, 27, 1, 0, "A Lesson to Learn", 1, 2, nil},
	{-263, 29, 1, 0, "Trial of the Lake", 1, 1, "DRUID"},
	{-263, 272, 1, 0, "Trial of the Sea Lion", 1, 1, "DRUID"},
	{-263, 5061, 1, 0, "Aquatic Form", 1, 1, "DRUID"},
	{-263, 5921, 1, 0, "Moonglade", 1, 1, "DRUID"},
	{-263, 5923, 1, 0, "Heeding the Call", 1, 1, "DRUID"},
	{-263, 5924, 1, 0, "Heeding the Call", 1, 1, "DRUID"},
	{-263, 5925, 1, 0, "Heeding the Call", 1, 1, "DRUID"},
	{-263, 5929, 1, 0, "Great Bear Spirit", 1, 1, "DRUID"},
	{-263, 5931, 1, 0, "Back to Darnassus", 1, 1, "DRUID"},
	{-263, 6001, 1, 0, "Body and Heart", 1, 1, "DRUID"},
	{-263, 6121, 1, 0, "Lessons Anew", 1, 1, "DRUID"},
	{-263, 6122, 1, 0, "The Principal Source", 1, 1, "DRUID"},
	{-263, 6123, 1, 0, "Gathering the Cure", 1, 1, "DRUID"},
	{-263, 6124, 1, 0, "Curing the Sick", 1, 1, "DRUID"},
	{-263, 6125, 1, 0, "Power over Poison", 1, 1, "DRUID"},
	{-263, 26, 1, 0, "A Lesson to Learn", 2, 2, nil},
	{-263, 28, 1, 0, "Trial of the Lake", 2, 1, "DRUID"},
	{-263, 30, 1, 0, "Trial of the Sea Lion", 2, 1, "DRUID"},
	{-263, 31, 1, 0, "Aquatic Form", 2, 1, "DRUID"},
	{-263, 5922, 1, 0, "Moonglade", 2, 1, "DRUID"},
	{-263, 5926, 1, 0, "Heeding the Call", 2, 1, "DRUID"},
	{-263, 5927, 1, 0, "Heeding the Call", 2, 1, "DRUID"},
	{-263, 5928, 1, 0, "Heeding the Call", 2, 1, "DRUID"},
	{-263, 5930, 1, 0, "Great Bear Spirit", 2, 1, "DRUID"},
	{-263, 5932, 1, 0, "Back to Thunder Bluff", 2, 1, "DRUID"},
	{-263, 6002, 1, 0, "Body and Heart", 2, 1, "DRUID"},
	{-263, 6126, 1, 0, "Lessons Anew", 2, 1, "DRUID"},
	{-263, 6127, 1, 0, "The Principal Source", 2, 1, "DRUID"},
	{-263, 6128, 1, 0, "Gathering the Cure", 2, 1, "DRUID"},
	{-263, 6129, 1, 0, "Curing the Sick", 2, 1, "DRUID"},
	{-263, 6130, 1, 0, "Power over Poison", 2, 1, "DRUID"},
	{-263, 10955, 1, 0, "Morthis Whisperwing", 3, 1, "DRUID"},
	{-263, 10961, 1, 0, "The Ward of Wakening", 3, 1, "DRUID"},
	{-263, 10964, 1, 0, "Waking the Sleeper", 3, 1, "DRUID"},
	{-263, 10965, 1, 0, "No Mere Dream", 3, 1, "DRUID"},
	{-263, 10978, 1, 0, "Return to Morthis Whisperwing", 3, 1, "DRUID"},
	{-263, 10979, 1, 0, "To the Evergrove", 3, 1, "DRUID"},
	{-263, 10980, 1, 0, "The Book of the Raven", 3, 1, "DRUID"},
	{-263, 10986, 1, 0, "Eyes in the Sky", 3, 1, "DRUID"},
	{-263, 10987, 1, 0, "To Catch A Sparrowhawk", 3, 1, "DRUID"},
	{-263, 10988, 1, 0, "The Raven Stones", 3, 1, "DRUID"},
	{-263, 10990, 1, 0, "The Eagle's Essence", 3, 1, "DRUID"},
	{-263, 10991, 1, 0, "The Falcon's Essence", 3, 1, "DRUID"},
	{-263, 10992, 1, 0, "The Hawk's Essence", 3, 1, "DRUID"},
	{-263, 10993, 1, 0, "Return to Cenarion Refuge", 3, 1, "DRUID"},
	{-263, 10994, 1, 0, "Chasing the Moonstone", 3, 1, "DRUID"},
	{-263, 11001, 1, 0, "Vanquish the Raven God", 3, 1, "DRUID"},
	{-263, 3120, 1, 1, "Verdant Sigil", 1, 1, "DRUID"},
	{-263, 3094, 1, 1, "Verdant Note", 2, 1, "DRUID"},
	{-263, 9051, 1, 52, "Toxic Test [Group]", 3, 1, "DRUID"},
	{-263, 9052, 1, 52, "Bloodpetal Poison", 3, 1, "DRUID"},
	{-263, 9053, 1, 52, "A Better Ingredient", 3, 1, "DRUID"},
	{-263, 9063, 1, 52, "Torwa Pathfinder", 3, 1, "DRUID"},
	{-263, 11011, 1, 70, "Eternal Vigilance", 3, 1, "DRUID"},

	{-261, 6063, 1, 0, "Taming the Beast", 1, 1, "HUNTER"},
	{-261, 6064, 1, 0, "Taming the Beast", 1, 1, "HUNTER"},
	{-261, 6071, 1, 0, "The Hunter's Path", 1, 1, "HUNTER"},
	{-261, 6072, 1, 0, "The Hunter's Path", 1, 1, "HUNTER"},
	{-261, 6073, 1, 0, "The Hunter's Path", 1, 1, "HUNTER"},
	{-261, 6074, 1, 0, "The Hunter's Path", 1, 1, "HUNTER"},
	{-261, 6075, 1, 0, "The Hunter's Path", 1, 1, "HUNTER"},
	{-261, 6076, 1, 0, "The Hunter's Path", 1, 1, "HUNTER"},
	{-261, 6084, 1, 0, "Taming the Beast", 1, 1, "HUNTER"},
	{-261, 6085, 1, 0, "Taming the Beast", 1, 1, "HUNTER"},
	{-261, 6086, 1, 0, "Training the Beast", 1, 1, "HUNTER"},
	{-261, 6101, 1, 0, "Taming the Beast", 1, 1, "HUNTER"},
	{-261, 6102, 1, 0, "Taming the Beast", 1, 1, "HUNTER"},
	{-261, 6103, 1, 0, "Training the Beast", 1, 1, "HUNTER"},
	{-261, 9591, 1, 0, "Taming the Beast", 1, 1, "HUNTER"},
	{-261, 9592, 1, 0, "Taming the Beast", 1, 1, "HUNTER"},
	{-261, 9593, 1, 0, "Taming the Beast", 1, 1, "HUNTER"},
	{-261, 9675, 1, 0, "Beast Training", 1, 1, "HUNTER"},
	{-261, 9757, 1, 0, "Seek Huntress Kella Nightbow", 1, 1, "HUNTER"},
	{-261, 6061, 1, 0, "Taming the Beast", 2, 1, "HUNTER"},
	{-261, 6062, 1, 0, "Taming the Beast", 2, 1, "HUNTER"},
	{-261, 6065, 1, 0, "The Hunter's Path", 2, 1, "HUNTER"},
	{-261, 6066, 1, 0, "The Hunter's Path", 2, 1, "HUNTER"},
	{-261, 6067, 1, 0, "The Hunter's Path", 2, 1, "HUNTER"},
	{-261, 6068, 1, 0, "The Hunter's Path", 2, 1, "HUNTER"},
	{-261, 6069, 1, 0, "The Hunter's Path", 2, 1, "HUNTER"},
	{-261, 6070, 1, 0, "The Hunter's Path", 2, 1, "HUNTER"},
	{-261, 6081, 1, 0, "Training the Beast", 2, 1, "HUNTER"},
	{-261, 6082, 1, 0, "Taming the Beast", 2, 1, "HUNTER"},
	{-261, 6083, 1, 0, "Taming the Beast", 2, 1, "HUNTER"},
	{-261, 6087, 1, 0, "Taming the Beast", 2, 1, "HUNTER"},
	{-261, 6088, 1, 0, "Taming the Beast", 2, 1, "HUNTER"},
	{-261, 6089, 1, 0, "Training the Beast", 2, 1, "HUNTER"},
	{-261, 9484, 1, 0, "Taming the Beast", 2, 1, "HUNTER"},
	{-261, 9485, 1, 0, "Taming the Beast", 2, 1, "HUNTER"},
	{-261, 9486, 1, 0, "Taming the Beast", 2, 1, "HUNTER"},
	{-261, 9617, 1, 0, "Seek the Farstriders", 2, 1, "HUNTER"},
	{-261, 9673, 1, 0, "Beast Training", 2, 1, "HUNTER"},
	{-261, 10530, 1, 0, "The Hunter's Path", 2, 1, "HUNTER"},
	{-261, 3108, 1, 1, "Etched Rune", 1, 1, "HUNTER"},
	{-261, 3117, 1, 1, "Etched Sigil", 1, 1, "HUNTER"},
	{-261, 3082, 1, 1, "Etched Tablet", 2, 1, "HUNTER"},
	{-261, 3087, 1, 1, "Etched Parchment", 2, 1, "HUNTER"},
	{-261, 3092, 1, 1, "Etched Note", 2, 1, "HUNTER"},
	{-261, 9393, 1, 1, "Hunter Training", 2, 1, "HUNTER"},
	{-261, 9288, 1, 2, "Hunter Training", 1, 1, "HUNTER"},
	{-261, 8151, 1, 52, "The Hunter's Charm", 3, 1, "HUNTER"},
	{-261, 8153, 1, 52, "Courser Antlers", 3, 1, "HUNTER"},
	{-261, 8231, 1, 52, "Wavethrashing", 3, 1, "HUNTER"},
	{-261, 8232, 1, 52, "The Green Drake", 3, 1, "HUNTER"},
	{-261, 7632, 1, 60, "The Ancient Leaf", 3, 1, "HUNTER"},
	{-261, 7633, 1, 60, "An Introduction", 3, 1, "HUNTER"},
	{-261, 7634, 1, 60, "Ancient Sinew Wrapped Lamina", 3, 1, "HUNTER"},
	{-261, 7635, 1, 60, "A Proper String", 3, 1, "HUNTER"},
	{-261, 7636, 1, 60, "Stave of the Ancients", 3, 1, "HUNTER"},

	{-161, 7463, 1, 0, "Arcane Refreshment", 3, 1, "MAGE"},
	{-161, 9364, 1, 0, "Fragmented Magic", 3, 1, "MAGE"},
	{-161, 3104, 1, 1, "Glyphic Letter", 1, 1, "MAGE"},
	{-161, 3114, 1, 1, "Glyphic Memorandum", 1, 1, "MAGE"},
	{-161, 3086, 1, 1, "Glyphic Tablet", 2, 1, "MAGE"},
	{-161, 3098, 1, 1, "Glyphic Scroll", 2, 1, "MAGE"},
	{-161, 8328, 1, 1, "Mage Training", 2, 1, "MAGE"},
	{-161, 9290, 1, 2, "Mage Training", 1, 1, "MAGE"},
	{-161, 1860, 1, 10, "Speak with Jennea", 1, 1, "MAGE"},
	{-161, 1861, 1, 10, "Mirror Lake", 1, 1, "MAGE"},
	{-161, 1879, 1, 10, "Speak with Bink", 1, 1, "MAGE"},
	{-161, 1880, 1, 10, "Mage-tastic Gizmonitor", 1, 1, "MAGE"},
	{-161, 1881, 1, 10, "Speak with Anastasia", 2, 1, "MAGE"},
	{-161, 1882, 1, 10, "The Balnir Farmstead", 2, 1, "MAGE"},
	{-161, 1883, 1, 10, "Speak with Un'thuwa", 2, 1, "MAGE"},
	{-161, 1884, 1, 10, "Ju-Ju Heaps", 2, 1, "MAGE"},
	{-161, 9402, 1, 10, "Fetch!", 2, 1, "MAGE"},
	{-161, 9403, 1, 10, "The Purest Water", 2, 1, "MAGE"},
	{-161, 9404, 1, 10, "Recently Living", 2, 1, "MAGE"},
	{-161, 9595, 1, 11, "Control", 1, 1, "MAGE"},
	{-161, 1919, 1, 15, "Report to Jennea", 1, 1, "MAGE"},
	{-161, 1921, 1, 15, "Gathering Materials", 1, 1, "MAGE"},
	{-161, 1941, 1, 15, "Manaweave Robe", 1, 1, "MAGE"},
	{-161, 1959, 1, 15, "Report to Anastasia", 2, 1, "MAGE"},
	{-161, 1961, 1, 15, "Gathering Materials", 2, 1, "MAGE"},
	{-161, 1962, 1, 15, "Spellfire Robes", 2, 1, "MAGE"},
	{-161, 1920, 1, 16, "Investigate the Blue Recluse", 1, 1, "MAGE"},
	{-161, 1960, 1, 16, "Investigate the Alchemist Shop", 2, 1, "MAGE"},
	{-161, 9487, 1, 16, "Arcane Reavers", 2, 1, "MAGE"},
	{-161, 9488, 1, 16, "A Simple Robe", 2, 1, "MAGE"},
	{-161, 1939, 1, 26, "High Sorcerer Andromath", 1, 1, "MAGE"},
	{-161, 1940, 1, 26, "Pristine Spider Silk", 1, 1, "MAGE"},
	{-161, 1942, 1, 26, "Astral Knot Garment", 1, 1, "MAGE"},
	{-161, 1943, 1, 26, "Speak with Deino", 2, 1, "MAGE"},
	{-161, 1944, 1, 26, "Waters of Xavian", 2, 1, "MAGE"},
	{-161, 1945, 1, 26, "Laughing Sisters", 2, 1, "MAGE"},
	{-161, 1946, 1, 26, "Nether-lace Garment", 2, 1, "MAGE"},
	{-161, 1938, 1, 28, "Ur's Treatise on Shadow Magic", 1, 1, "MAGE"},
	{-161, 1950, 1, 30, "Get the Scoop", 3, 1, "MAGE"},
	{-161, 1947, 1, 38, "Journey to the Marsh", 3, 1, "MAGE"},
	{-161, 1949, 1, 38, "Hidden Secrets", 3, 1, "MAGE"},
	{-161, 1948, 1, 40, "Items of Power", 3, 1, "MAGE"},
	{-161, 1951, 1, 40, "Rituals of Power", 3, 1, "MAGE"},
	{-161, 1952, 1, 40, "Mage's Wand", 3, 1, "MAGE"},
	{-161, 1953, 1, 40, "Return to the Marsh", 3, 1, "MAGE"},
	{-161, 1954, 1, 40, "The Infernal Orb", 3, 1, "MAGE"},
	{-161, 1955, 1, 40, "The Exorcism [Group]", 3, 1, "MAGE"},
	{-161, 1956, 1, 40, "Power in Uldaman", 3, 1, "MAGE"},
	{-161, 1957, 1, 40, "Mana Surges", 3, 1, "MAGE"},
	{-161, 1958, 1, 40, "Celestial Power", 3, 1, "MAGE"},
	{-161, 8250, 1, 52, "Magecraft", 3, 1, "MAGE"},
	{-161, 8251, 1, 52, "Magic Dust", 3, 1, "MAGE"},
	{-161, 8252, 1, 52, "The Siren's Coral", 3, 1, "MAGE"},
	{-161, 8253, 1, 52, "Destroy Morphaz", 3, 1, "MAGE"},
	{-161, 9362, 1, 60, "Warlord Krellian", 3, 1, "MAGE"},
	{-161, 12172, 1, 73, "Attunement to Dalaran", 1, 1, "MAGE"},
	{-161, 12173, 1, 73, "Attunement to Dalaran", 2, 1, "MAGE"},

	{-141, 7666, 2, 0, "Again Into the Great Ossuary", 4, 1, "PALADIN"},
	{-141, 1642, 1, 0, "The Tome of Divinity", 1, 1, "PALADIN"},
	{-141, 1643, 1, 0, "The Tome of Divinity", 1, 1, "PALADIN"},
	{-141, 1644, 1, 0, "The Tome of Divinity", 1, 1, "PALADIN"},
	{-141, 1646, 1, 0, "The Tome of Divinity", 1, 1, "PALADIN"},
	{-141, 1647, 1, 0, "The Tome of Divinity", 1, 1, "PALADIN"},
	{-141, 1648, 1, 0, "The Tome of Divinity", 1, 1, "PALADIN"},
	{-141, 1649, 1, 0, "The Tome of Valor", 1, 1, "PALADIN"},
	{-141, 1650, 1, 0, "The Tome of Valor", 1, 1, "PALADIN"},
	{-141, 1651, 1, 0, "The Tome of Valor", 1, 1, "PALADIN"},
	{-141, 1652, 1, 0, "The Tome of Valor", 1, 1, "PALADIN"},
	{-141, 1653, 1, 0, "The Test of Righteousness", 1, 1, "PALADIN"},
	{-141, 1778, 1, 0, "The Tome of Divinity", 1, 1, "PALADIN"},
	{-141, 1779, 1, 0, "The Tome of Divinity", 1, 1, "PALADIN"},
	{-141, 1780, 1, 0, "The Tome of Divinity", 1, 1, "PALADIN"},
	{-141, 1781, 1, 0, "The Tome of Divinity", 1, 1, "PALADIN"},
	{-141, 1783, 1, 0, "The Tome of Divinity", 1, 1, "PALADIN"},
	{-141, 1784, 1, 0, "The Tome of Divinity", 1, 1, "PALADIN"},
	{-141, 1785, 1, 0, "The Tome of Divinity", 1, 1, "PALADIN"},
	{-141, 1786, 1, 0, "The Tome of Divinity", 1, 1, "PALADIN"},
	{-141, 1787, 1, 0, "The Tome of Divinity", 1, 1, "PALADIN"},
	{-141, 1788, 1, 0, "The Tome of Divinity", 1, 1, "PALADIN"},
	{-141, 1789, 2, 0, "The Symbol of Life", 1, 1, "PALADIN"},
	{-141, 1790, 2, 0, "The Symbol of Life", 1, 1, "PALADIN"},
	{-141, 1793, 2, 0, "The Tome of Valor", 1, 1, "PALADIN"},
	{-141, 2997, 1, 0, "Tome of Divinity", 1, 1, "PALADIN"},
	{-141, 2998, 1, 0, "Tome of Divinity", 1, 1, "PALADIN"},
	{-141, 2999, 1, 0, "Tome of Divinity", 1, 1, "PALADIN"},
	{-141, 3000, 1, 0, "Tome of Divinity", 1, 1, "PALADIN"},
	{-141, 3681, 1, 0, "Tome of Divinity", 1, 1, "PALADIN"},
	{-141, 7637, 1, 0, "Emphasis on Sacrifice", 1, 1, "PALADIN"},
	{-141, 7638, 1, 0, "Lord Grayson Shadowbreaker", 1, 1, "PALADIN"},
	{-141, 7639, 1, 0, "To Show Due Judgment", 1, 1, "PALADIN"},
	{-141, 7640, 1, 0, "Exorcising Terrordale", 1, 1, "PALADIN"},
	{-141, 7641, 1, 0, "The Work of Grimand Elmore", 1, 1, "PALADIN"},
	{-141, 7642, 1, 0, "Collection of Goods", 1, 1, "PALADIN"},
	{-141, 7643, 1, 0, "Ancient Equine Spirit", 1, 1, "PALADIN"},
	{-141, 7644, 1, 0, "Blessed Arcanite Barding", 1, 1, "PALADIN"},
	{-141, 7645, 1, 0, "Manna-Enriched Horse Feed", 1, 1, "PALADIN"},
	{-141, 7646, 1, 0, "The Divination Scryer", 1, 1, "PALADIN"},
	{-141, 7647, 1, 0, "Judgment and Redemption", 1, 1, "PALADIN"},
	{-141, 7648, 1, 0, "Grimand's Finest Work", 1, 1, "PALADIN"},
	{-141, 7670, 1, 0, "Lord Grayson Shadowbreaker", 1, 1, "PALADIN"},
	{-141, 9598, 1, 0, "Redemption", 1, 1, "PALADIN"},
	{-141, 9600, 1, 0, "Redemption", 1, 1, "PALADIN"},
	{-141, 10366, 1, 0, "Jol", 1, 1, "PALADIN"},
	{-141, 9677, 1, 0, "Summons from Knight-Lord Bloodvalor", 2, 1, "PALADIN"},
	{-141, 9678, 1, 0, "The First Trial", 2, 1, "PALADIN"},
	{-141, 9681, 1, 0, "A Study in Power", 2, 1, "PALADIN"},
	{-141, 9684, 1, 0, "Claiming the Light", 2, 1, "PALADIN"},
	{-141, 9685, 1, 0, "Redeeming the Dead", 2, 1, "PALADIN"},
	{-141, 9686, 1, 0, "The Second Trial", 2, 1, "PALADIN"},
	{-141, 9690, 1, 0, "The Second Trial", 2, 1, "PALADIN"},
	{-141, 9691, 1, 0, "Return to Silvermoon", 2, 1, "PALADIN"},
	{-141, 9721, 1, 0, "A Summons from Lord Solanar", 2, 1, "PALADIN"},
	{-141, 9722, 1, 0, "The Master's Path", 2, 1, "PALADIN"},
	{-141, 9723, 1, 0, "A Gesture of Commitment", 2, 1, "PALADIN"},
	{-141, 9725, 1, 0, "A Demonstration of Loyalty", 2, 1, "PALADIN"},
	{-141, 9735, 1, 0, "True Masters of the Light", 2, 1, "PALADIN"},
	{-141, 9736, 1, 0, "True Masters of the Light", 2, 1, "PALADIN"},
	{-141, 9737, 1, 0, "True Masters of the Light", 2, 1, "PALADIN"},
	{-141, 3101, 1, 1, "Consecrated Letter", 1, 1, "PALADIN"},
	{-141, 3107, 1, 1, "Consecrated Rune", 1, 1, "PALADIN"},
	{-141, 9676, 1, 1, "Paladin Training", 2, 1, "PALADIN"},
	{-141, 9287, 1, 2, "Paladin Training", 1, 1, "PALADIN"},
	{-141, 1442, 1, 22, "Seeking the Kor Gem", 1, 1, "PALADIN"},
	{-141, 1654, 1, 22, "The Test of Righteousness", 1, 1, "PALADIN"},
	{-141, 1655, 1, 22, "Bailor's Ore Shipment", 1, 1, "PALADIN"},
	{-141, 1806, 1, 22, "The Test of Righteousness", 1, 1, "PALADIN"},
	{-141, 9692, 1, 23, "The Path of the Adept", 2, 1, "PALADIN"},
	{-141, 9707, 1, 23, "Forging the Weapon", 2, 1, "PALADIN"},
	{-141, 9710, 1, 23, "The Blood-Tempered Ranseur", 2, 1, "PALADIN"},
	{-141, 8414, 1, 52, "Dispelling Evil", 1, 1, "PALADIN"},
	{-141, 8415, 1, 52, "Chillwind Camp", 1, 1, "PALADIN"},
	{-141, 8416, 1, 52, "Inert Scourgestones", 1, 1, "PALADIN"},
	{-141, 8418, 1, 52, "Forging the Mightstone", 1, 1, "PALADIN"},
	{-141, 9601, 1, 52, "To The Bulwark", 2, 1, "PALADIN"},
	{-141, 10590, 1, 52, "Prove Your Hatred", 2, 1, "PALADIN"},
	{-141, 10592, 1, 52, "Wisdom of the Banshee Queen", 2, 1, "PALADIN"},
	{-141, 10593, 1, 52, "Ancient Evil", 2, 1, "PALADIN"},

	{-262, 3103, 1, 1, "Hallowed Letter", 1, 1, "PRIEST"},
	{-262, 3110, 1, 1, "Hallowed Rune", 1, 1, "PRIEST"},
	{-262, 3119, 1, 1, "Hallowed Sigil", 1, 1, "PRIEST"},
	{-262, 3085, 1, 1, "Hallowed Tablet", 2, 1, "PRIEST"},
	{-262, 3097, 1, 1, "Hallowed Scroll", 2, 1, "PRIEST"},
	{-262, 8564, 1, 1, "Priest Training", 2, 1, "PRIEST"},
	{-262, 9291, 1, 2, "Priest Training", 1, 1, "PRIEST"},
	{-262, 5621, 1, 4, "Garments of the Moon", 1, 1, "PRIEST"},
	{-262, 5622, 1, 4, "In Favor of Elune", 1, 1, "PRIEST"},
	{-262, 5623, 1, 4, "In Favor of the Light", 1, 1, "PRIEST"},
	{-262, 5624, 1, 4, "Garments of the Light", 1, 1, "PRIEST"},
	{-262, 5625, 1, 4, "Garments of the Light", 1, 1, "PRIEST"},
	{-262, 5626, 1, 4, "In Favor of the Light", 1, 1, "PRIEST"},
	{-262, 5648, 1, 4, "Garments of Spirituality", 2, 1, "PRIEST"},
	{-262, 5649, 1, 4, "In Favor of Spirituality", 2, 1, "PRIEST"},
	{-262, 5650, 1, 4, "Garments of Darkness", 2, 1, "PRIEST"},
	{-262, 5651, 1, 4, "In Favor of Darkness", 2, 1, "PRIEST"},
	{-262, 9586, 1, 5, "Help Tavara", 1, 1, "PRIEST"},
	{-262, 9489, 1, 5, "Cleansing the Scar", 2, 1, "PRIEST"},
	{-262, 8254, 1, 52, "Cenarion Aid", 3, 1, "PRIEST"},
	{-262, 8255, 1, 52, "Of Coursers We Know", 3, 1, "PRIEST"},
	{-262, 8256, 1, 52, "The Ichor of Undeath", 3, 1, "PRIEST"},
	{-262, 8257, 1, 52, "Blood of Morphaz", 3, 1, "PRIEST"},
	{-262, 7621, 1, 60, "A Warning", 3, 1, "PRIEST"},
	{-262, 7622, 1, 60, "The Balance of Light and Shadow", 3, 1, "PRIEST"},

	{-162, 2359, 1, 0, "Klaven's Tower", 1, 1, "ROGUE"},
	{-162, 2360, 1, 0, "Mathias and the Defias", 1, 1, "ROGUE"},
	{-162, 2458, 1, 0, "Deep Cover", 2, 1, "ROGUE"},
	{-162, 2460, 1, 0, "The Shattered Salute", 2, 1, "ROGUE"},
	{-162, 2478, 1, 0, "Mission: Possible But Not Probable", 2, 1, "ROGUE"},
	{-162, 2479, 1, 0, "Hinott's Assistance", 2, 1, "ROGUE"},
	{-162, 2480, 1, 0, "Hinott's Assistance", 2, 1, "ROGUE"},
	{-162, 3102, 1, 1, "Encrypted Letter", 1, 1, "ROGUE"},
	{-162, 3109, 1, 1, "Encrypted Rune", 1, 1, "ROGUE"},
	{-162, 3113, 1, 1, "Encrypted Memorandum", 1, 1, "ROGUE"},
	{-162, 3118, 1, 1, "Encrypted Sigil", 1, 1, "ROGUE"},
	{-162, 3083, 1, 1, "Encrypted Tablet", 2, 1, "ROGUE"},
	{-162, 3088, 1, 1, "Encrypted Parchment", 2, 1, "ROGUE"},
	{-162, 3096, 1, 1, "Encrypted Scroll", 2, 1, "ROGUE"},
	{-162, 9392, 1, 1, "Rogue Training", 2, 1, "ROGUE"},
	{-162, 2205, 1, 10, "Seek out SI: 7", 1, 1, "ROGUE"},
	{-162, 2206, 1, 10, "Snatch and Grab", 1, 1, "ROGUE"},
	{-162, 2218, 1, 10, "Road to Salvation", 1, 1, "ROGUE"},
	{-162, 2238, 1, 10, "Simple Subterfugin'", 1, 1, "ROGUE"},
	{-162, 2239, 1, 10, "Onin's Report", 1, 1, "ROGUE"},
	{-162, 2241, 1, 10, "The Apple Falls", 1, 1, "ROGUE"},
	{-162, 2242, 1, 10, "Destiny Calls", 1, 1, "ROGUE"},
	{-162, 1859, 1, 10, "Therzok", 2, 1, "ROGUE"},
	{-162, 1885, 1, 10, "Mennet Carkad", 2, 1, "ROGUE"},
	{-162, 9532, 1, 10, "Find Keltus Darkleaf", 2, 1, "ROGUE"},
	{-162, 9618, 1, 10, "Return the Reports", 2, 1, "ROGUE"},
	{-162, 9460, 1, 12, "Combining Forces", 2, 1, "ROGUE"},
	{-162, 1858, 1, 13, "The Shattered Hand", 2, 1, "ROGUE"},
	{-162, 1886, 4, 13, "The Deathstalkers [Removed]", 2, 1, "ROGUE"},
	{-162, 1898, 4, 13, "The Deathstalkers [Removed]", 2, 1, "ROGUE"},
	{-162, 1899, 4, 13, "The Deathstalkers [Removed]", 2, 1, "ROGUE"},
	{-162, 1963, 1, 13, "The Shattered Hand", 2, 1, "ROGUE"},
	{-162, 14418, 1, 13, "The Deathstalkers", 2, 1, "ROGUE"},
	{-162, 14419, 1, 13, "The Deathstalkers", 2, 1, "ROGUE"},
	{-162, 14420, 1, 13, "The Deathstalkers", 2, 1, "ROGUE"},
	{-162, 14421, 1, 13, "The Deathstalkers", 2, 1, "ROGUE"},
	{-162, 2259, 1, 16, "Erion Shadewhisper", 1, 1, "ROGUE"},
	{-162, 2260, 1, 16, "Erion's Behest", 1, 1, "ROGUE"},
	{-162, 2281, 1, 16, "Redridge Rendezvous", 1, 1, "ROGUE"},
	{-162, 2298, 1, 16, "Kingly Shakedown", 1, 1, "ROGUE"},
	{-162, 2299, 1, 16, "To Hulfdan!", 1, 1, "ROGUE"},
	{-162, 2300, 1, 16, "SI:7", 1, 1, "ROGUE"},
	{-162, 1998, 1, 16, "Fenwick Thatros", 2, 1, "ROGUE"},
	{-162, 2378, 1, 16, "Find the Shattered Hand", 2, 1, "ROGUE"},
	{-162, 2379, 1, 16, "Zando'zan", 2, 1, "ROGUE"},
	{-162, 2380, 1, 16, "To Orgrimmar!", 2, 1, "ROGUE"},
	{-162, 2382, 1, 16, "Wrenix of Ratchet", 2, 1, "ROGUE"},
	{-162, 10372, 1, 16, "A Discreet Inquiry", 2, 1, "ROGUE"},
	{-162, 2381, 1, 18, "Plundering the Plunderers", 2, 1, "ROGUE"},
	{-162, 9491, 1, 18, "Greed", 2, 1, "ROGUE"},
	{-162, 10548, 1, 18, "The Sad Truth", 2, 1, "ROGUE"},
	{-162, 2282, 1, 20, "Alther's Mill", 1, 1, "ROGUE"},
	{-162, 2607, 1, 20, "The Touch of Zanzil", 1, 1, "ROGUE"},
	{-162, 2608, 1, 20, "The Touch of Zanzil", 1, 1, "ROGUE"},
	{-162, 2609, 1, 20, "The Touch of Zanzil", 1, 1, "ROGUE"},
	{-162, 1999, 1, 20, "Tools of the Trade", 2, 1, "ROGUE"},
	{-162, 2358, 1, 22, "Horns of Nez'ra", 1, 1, "ROGUE"},
	{-162, 10794, 1, 24, "Rogues of the Shattered Hand", 2, 1, "ROGUE"},
	{-162, 6681, 1, 24, "The Manor, Ravenholdt", 3, 1, "ROGUE"},
	{-162, 8233, 1, 52, "A Simple Request", 3, 1, "ROGUE"},
	{-162, 8234, 1, 52, "Sealed Azure Bag", 3, 1, "ROGUE"},
	{-162, 8235, 1, 52, "Encoded Fragments", 3, 1, "ROGUE"},
	{-162, 8236, 1, 52, "The Azure Key", 3, 1, "ROGUE"},
	{-162, 6701, 2, 60, "Syndicate Emblems", 3, 1, "ROGUE"},
	{-162, 8249, 2, 60, "Junkboxes Needed", 3, 2, nil},

	{-82, 9449, 1, 0, "Call of Earth", 1, 1, "SHAMAN"},
	{-82, 9450, 1, 0, "Call of Earth", 1, 1, "SHAMAN"},
	{-82, 9451, 1, 0, "Call of Earth", 1, 1, "SHAMAN"},
	{-82, 9461, 1, 0, "Call of Fire", 1, 1, "SHAMAN"},
	{-82, 9462, 1, 0, "Call of Fire", 1, 1, "SHAMAN"},
	{-82, 9464, 1, 0, "Call of Fire", 1, 1, "SHAMAN"},
	{-82, 9465, 1, 0, "Call of Fire", 1, 1, "SHAMAN"},
	{-82, 9467, 1, 0, "Call of Fire", 1, 1, "SHAMAN"},
	{-82, 9468, 1, 0, "Call of Fire", 1, 1, "SHAMAN"},
	{-82, 9500, 1, 0, "Call of Water", 1, 1, "SHAMAN"},
	{-82, 9501, 1, 0, "Call of Water", 1, 1, "SHAMAN"},
	{-82, 9502, 1, 0, "Call of Water", 1, 1, "SHAMAN"},
	{-82, 9503, 1, 0, "Call of Water", 1, 1, "SHAMAN"},
	{-82, 9504, 1, 0, "Call of Water", 1, 1, "SHAMAN"},
	{-82, 9508, 1, 0, "Call of Water", 1, 1, "SHAMAN"},
	{-82, 9509, 1, 0, "Call of Water", 1, 1, "SHAMAN"},
	{-82, 9547, 1, 0, "Call of Air", 1, 1, "SHAMAN"},
	{-82, 9551, 1, 0, "Call of Air", 1, 1, "SHAMAN"},
	{-82, 9552, 1, 0, "Call of Air", 1, 1, "SHAMAN"},
	{-82, 9553, 1, 0, "Call of Air", 1, 1, "SHAMAN"},
	{-82, 9554, 1, 0, "Call of Air", 1, 1, "SHAMAN"},
	{-82, 9555, 1, 0, "Call of Fire", 1, 1, "SHAMAN"},
	{-82, 10490, 1, 0, "Call of Water", 1, 1, "SHAMAN"},
	{-82, 10491, 1, 0, "Call of Air", 1, 1, "SHAMAN"},
	{-82, 63, 1, 0, "Call of Water", 2, 1, "SHAMAN"},
	{-82, 96, 1, 0, "Call of Water", 2, 1, "SHAMAN"},
	{-82, 100, 1, 0, "Call of Water", 2, 1, "SHAMAN"},
	{-82, 220, 1, 0, "Call of Water", 2, 1, "SHAMAN"},
	{-82, 972, 2, 0, "Water Sapta", 2, 1, "SHAMAN"},
	{-82, 1103, 1, 0, "Call of Water", 2, 1, "SHAMAN"},
	{-82, 1464, 1, 0, "Fire Sapta", 2, 1, "SHAMAN"},
	{-82, 1522, 1, 0, "Call of Fire", 2, 1, "SHAMAN"},
	{-82, 1523, 1, 0, "Call of Fire", 2, 1, "SHAMAN"},
	{-82, 1524, 1, 0, "Call of Fire", 2, 1, "SHAMAN"},
	{-82, 1525, 1, 0, "Call of Fire", 2, 1, "SHAMAN"},
	{-82, 1526, 1, 0, "Call of Fire", 2, 1, "SHAMAN"},
	{-82, 1527, 1, 0, "Call of Fire", 2, 1, "SHAMAN"},
	{-82, 1528, 1, 0, "Call of Water", 2, 1, "SHAMAN"},
	{-82, 1529, 1, 0, "Call of Water", 2, 1, "SHAMAN"},
	{-82, 1530, 1, 0, "Call of Water", 2, 1, "SHAMAN"},
	{-82, 1531, 1, 0, "Call of Air", 2, 1, "SHAMAN"},
	{-82, 1532, 1, 0, "Call of Air", 2, 1, "SHAMAN"},
	{-82, 1534, 1, 0, "Call of Water", 2, 1, "SHAMAN"},
	{-82, 1535, 1, 0, "Call of Water", 2, 1, "SHAMAN"},
	{-82, 1536, 1, 0, "Call of Water", 2, 1, "SHAMAN"},
	{-82, 2983, 1, 0, "Call of Fire", 2, 1, "SHAMAN"},
	{-82, 2984, 1, 0, "Call of Fire", 2, 1, "SHAMAN"},
	{-82, 2985, 1, 0, "Call of Water", 2, 1, "SHAMAN"},
	{-82, 2986, 1, 0, "Call of Water", 2, 1, "SHAMAN"},
	{-82, 3084, 1, 1, "Rune-Inscribed Tablet", 2, 1, "SHAMAN"},
	{-82, 3089, 1, 1, "Rune-Inscribed Parchment", 2, 1, "SHAMAN"},
	{-82, 3093, 1, 1, "Rune-Inscribed Note", 2, 1, "SHAMAN"},
	{-82, 9421, 1, 2, "Shaman Training", 1, 1, "SHAMAN"},
	{-82, 1462, 1, 4, "Earth Sapta", 4, 1, "SHAMAN"},
	{-82, 1463, 1, 4, "Earth Sapta", 4, 1, "SHAMAN"},
	{-82, 1516, 1, 4, "Call of Earth", 2, 1, "SHAMAN"},
	{-82, 1517, 1, 4, "Call of Earth", 2, 1, "SHAMAN"},
	{-82, 1518, 1, 4, "Call of Earth", 2, 1, "SHAMAN"},
	{-82, 1519, 1, 4, "Call of Earth", 2, 1, "SHAMAN"},
	{-82, 1520, 1, 4, "Call of Earth", 2, 1, "SHAMAN"},
	{-82, 1521, 1, 4, "Call of Earth", 2, 1, "SHAMAN"},
	{-82, 14111, 1, 30, "Relic of the Earthen Ring", 1, 1, "SHAMAN"},
	{-82, 14100, 1, 30, "Relic of the Earthen Ring", 2, 1, "SHAMAN"},
	{-82, 8410, 1, 52, "Elemental Mastery", 3, 1, "SHAMAN"},
	{-82, 8412, 1, 52, "Spirit Totem", 3, 1, "SHAMAN"},
	{-82, 8413, 1, 52, "Da Voodoo", 3, 1, "SHAMAN"},
	{-82, 7669, 2, 60, "Again Into the Great Ossuary", 4, 1, "SHAMAN"},
	{-82, 7667, 1, 60, "Material Assistance", 2, 1, "SHAMAN"},
	{-82, 8258, 1, 60, "The Darkreaver Menace", 2, 1, "SHAMAN"},

	{-61, 1598, 1, 0, "The Stolen Tome", 1, 1, "WARLOCK"},
	{-61, 1599, 1, 0, "Beginnings", 1, 1, "WARLOCK"},
	{-61, 1685, 1, 0, "Gakin's Summons", 1, 1, "WARLOCK"},
	{-61, 1688, 1, 0, "Surena Caledon", 1, 1, "WARLOCK"},
	{-61, 1689, 1, 0, "The Binding", 1, 1, "WARLOCK"},
	{-61, 1715, 1, 0, "The Slaughtered Lamb", 1, 1, "WARLOCK"},
	{-61, 1716, 1, 0, "Devourer of Souls", 1, 1, "WARLOCK"},
	{-61, 1717, 1, 0, "Gakin's Summons", 1, 1, "WARLOCK"},
	{-61, 1738, 1, 0, "Heartswood", 1, 1, "WARLOCK"},
	{-61, 1739, 1, 0, "The Binding", 1, 1, "WARLOCK"},
	{-61, 1758, 1, 0, "Tome of the Cabal", 1, 1, "WARLOCK"},
	{-61, 1798, 1, 0, "Seeking Strahad", 1, 1, "WARLOCK"},
	{-61, 1802, 1, 0, "Tome of the Cabal", 1, 1, "WARLOCK"},
	{-61, 1804, 1, 0, "Tome of the Cabal", 1, 1, "WARLOCK"},
	{-61, 7623, 1, 0, "Lord Banehollow", 1, 1, "WARLOCK"},
	{-61, 7624, 1, 0, "Ulathek the Traitor", 1, 1, "WARLOCK"},
	{-61, 7625, 1, 0, "Xorothian Stardust", 1, 1, "WARLOCK"},
	{-61, 1470, 1, 0, "Piercing the Veil", 2, 1, "WARLOCK"},
	{-61, 1471, 1, 0, "The Binding", 2, 1, "WARLOCK"},
	{-61, 1472, 1, 0, "Devourer of Souls", 2, 1, "WARLOCK"},
	{-61, 1473, 1, 0, "Creature of the Void", 2, 1, "WARLOCK"},
	{-61, 1474, 1, 0, "The Binding", 2, 1, "WARLOCK"},
	{-61, 1476, 1, 0, "Hearts of the Pure", 2, 1, "WARLOCK"},
	{-61, 1478, 1, 0, "Halgar's Summons", 2, 1, "WARLOCK"},
	{-61, 1485, 1, 0, "Vile Familiars", 2, 1, "WARLOCK"},
	{-61, 1499, 1, 0, "Vile Familiars", 2, 1, "WARLOCK"},
	{-61, 1501, 1, 0, "Creature of the Void", 2, 1, "WARLOCK"},
	{-61, 1504, 1, 0, "The Binding", 2, 1, "WARLOCK"},
	{-61, 1506, 1, 0, "Gan'rul's Summons", 2, 1, "WARLOCK"},
	{-61, 1507, 1, 0, "Devourer of Souls", 2, 1, "WARLOCK"},
	{-61, 1508, 1, 0, "Blind Cazul", 2, 1, "WARLOCK"},
	{-61, 1509, 1, 0, "News of Dogran", 2, 1, "WARLOCK"},
	{-61, 1510, 1, 0, "News of Dogran", 2, 1, "WARLOCK"},
	{-61, 1511, 1, 0, "Ken'zigla's Draught", 2, 1, "WARLOCK"},
	{-61, 1512, 1, 0, "Love's Gift", 2, 1, "WARLOCK"},
	{-61, 1513, 1, 0, "The Binding", 2, 1, "WARLOCK"},
	{-61, 1515, 1, 0, "Dogran's Captivity", 2, 1, "WARLOCK"},
	{-61, 1801, 1, 0, "Tome of the Cabal", 2, 1, "WARLOCK"},
	{-61, 1803, 1, 0, "Tome of the Cabal", 2, 1, "WARLOCK"},
	{-61, 1805, 1, 0, "Tome of the Cabal", 2, 1, "WARLOCK"},
	{-61, 2996, 1, 0, "Seeking Strahad", 2, 1, "WARLOCK"},
	{-61, 3001, 1, 0, "Seeking Strahad", 2, 1, "WARLOCK"},
	{-61, 8344, 1, 0, "Windows to the Source", 2, 1, "WARLOCK"},
	{-61, 9529, 1, 0, "The Stone", 2, 1, "WARLOCK"},
	{-61, 9619, 1, 0, "The Rune of Summoning", 2, 1, "WARLOCK"},
	{-61, 10605, 1, 0, "Carendin Summons", 2, 1, "WARLOCK"},
	{-61, 10788, 1, 0, "Return to Talionia", 2, 1, "WARLOCK"},
	{-61, 10789, 1, 0, "Return to Carendin Halgar", 2, 1, "WARLOCK"},
	{-61, 10790, 1, 0, "Return to Gan'rul Bloodeye", 2, 1, "WARLOCK"},
	{-61, 1795, 1, 0, "The Binding", 3, 1, "WARLOCK"},
	{-61, 7562, 1, 0, "Mor'zul Bloodbringer", 3, 1, "WARLOCK"},
	{-61, 7563, 1, 0, "Rage of Blood", 3, 1, "WARLOCK"},
	{-61, 7564, 1, 0, "Wildeyes", 3, 1, "WARLOCK"},
	{-61, 7581, 1, 0, "The Prison's Bindings", 3, 1, "WARLOCK"},
	{-61, 7582, 1, 0, "The Prison's Casing", 3, 1, "WARLOCK"},
	{-61, 7583, 1, 0, "Suppression", 3, 1, "WARLOCK"},
	{-61, 7601, 1, 0, "What Niby Commands", 3, 1, "WARLOCK"},
	{-61, 7602, 1, 0, "Flawless Fel Essence", 3, 1, "WARLOCK"},
	{-61, 7603, 1, 0, "Kroshius' Infernal Core", 3, 1, "WARLOCK"},
	{-61, 7626, 1, 0, "Bell of Dethmoora", 3, 1, "WARLOCK"},
	{-61, 7627, 1, 0, "Wheel of the Black March", 3, 1, "WARLOCK"},
	{-61, 7628, 1, 0, "Doomsday Candle", 3, 1, "WARLOCK"},
	{-61, 7629, 1, 0, "Imp Delivery", 3, 1, "WARLOCK"},
	{-61, 7630, 1, 0, "Arcanite", 3, 1, "WARLOCK"},
	{-61, 7631, 1, 0, "Dreadsteed of Xoroth", 3, 1, "WARLOCK"},
	{-61, 3105, 1, 1, "Tainted Letter", 1, 1, "WARLOCK"},
	{-61, 3115, 1, 1, "Tainted Memorandum", 1, 1, "WARLOCK"},
	{-61, 3090, 1, 1, "Tainted Parchment", 2, 1, "WARLOCK"},
	{-61, 3099, 1, 1, "Tainted Scroll", 2, 1, "WARLOCK"},
	{-61, 8563, 1, 1, "Warlock Training", 2, 1, "WARLOCK"},
	{-61, 1740, 1, 25, "The Orb of Soran'ruk", 3, 1, "WARLOCK"},
	{-61, 4736, 1, 31, "In Search of Menara Voidrender", 1, 1, "WARLOCK"},
	{-61, 4737, 1, 31, "In Search of Menara Voidrender", 2, 1, "WARLOCK"},
	{-61, 4739, 1, 31, "In Search of Menara Voidrender", 2, 1, "WARLOCK"},
	{-61, 1796, 1, 31, "Components for the Enchanted Gold Bloodrobe", 3, 1, "WARLOCK"},
	{-61, 4738, 1, 31, "In Search of Menara Voidrender", 3, 1, "WARLOCK"},
	{-61, 4781, 1, 34, "Components for the Enchanted Gold Bloodrobe", 3, 1, "WARLOCK"},
	{-61, 4782, 1, 34, "Components for the Enchanted Gold Bloodrobe", 3, 1, "WARLOCK"},
	{-61, 4965, 1, 35, "Knowledge of the Orb of Orahil", 1, 1, "WARLOCK"},
	{-61, 4967, 1, 35, "Knowledge of the Orb of Orahil", 2, 1, "WARLOCK"},
	{-61, 4969, 1, 35, "Knowledge of the Orb of Orahil", 2, 1, "WARLOCK"},
	{-61, 4968, 1, 35, "Knowledge of the Orb of Orahil", 3, 1, "WARLOCK"},
	{-61, 4783, 1, 37, "Components for the Enchanted Gold Bloodrobe", 3, 1, "WARLOCK"},
	{-61, 4784, 1, 37, "Components for the Enchanted Gold Bloodrobe", 3, 1, "WARLOCK"},
	{-61, 4785, 2, 37, "Fine Gold Thread", 3, 1, "WARLOCK"},
	{-61, 4786, 1, 38, "The Completed Robe", 3, 1, "WARLOCK"},
	{-61, 1799, 1, 40, "Fragments of the Orb of Orahil", 3, 1, "WARLOCK"},
	{-61, 4961, 1, 40, "Cleansing of the Orb of Orahil [Group]", 3, 1, "WARLOCK"},
	{-61, 4962, 1, 40, "Shard of a Felhound", 3, 1, "WARLOCK"},
	{-61, 4963, 1, 40, "Shard of an Infernal", 3, 1, "WARLOCK"},
	{-61, 4964, 1, 40, "The Completed Orb of Dar'Orahil", 3, 1, "WARLOCK"},
	{-61, 4975, 1, 40, "The Completed Orb of Noh'Orahil", 3, 1, "WARLOCK"},
	{-61, 4976, 1, 40, "Returning the Cleansed Orb", 3, 1, "WARLOCK"},
	{-61, 8419, 1, 52, "An Imp's Request", 3, 1, "WARLOCK"},
	{-61, 8420, 1, 52, "Hot and Itchy", 3, 1, "WARLOCK"},
	{-61, 8421, 1, 52, "The Wrong Stuff", 3, 1, "WARLOCK"},
	{-61, 8422, 1, 52, "Trolls of a Feather", 3, 1, "WARLOCK"},

	{-81, 1638, 1, 0, "A Warrior's Training", 1, 1, "WARRIOR"},
	{-81, 1639, 1, 0, "Bartleby the Drunk", 1, 1, "WARRIOR"},
	{-81, 1640, 1, 0, "Beat Bartleby", 1, 1, "WARRIOR"},
	{-81, 1665, 1, 0, "Bartleby's Mug", 1, 1, "WARRIOR"},
	{-81, 1678, 1, 0, "Vejrek", 1, 1, "WARRIOR"},
	{-81, 1679, 1, 0, "Muren Stormpike", 1, 1, "WARRIOR"},
	{-81, 1683, 1, 0, "Vorlus Vilehoof", 1, 1, "WARRIOR"},
	{-81, 1684, 1, 0, "Elanaria", 1, 1, "WARRIOR"},
	{-81, 1498, 1, 0, "Path of Defense", 2, 1, "WARRIOR"},
	{-81, 1505, 1, 0, "Veteran Uzzek", 2, 1, "WARRIOR"},
	{-81, 1818, 1, 0, "Speak with Dillinger", 2, 1, "WARRIOR"},
	{-81, 1819, 1, 0, "Ulag the Cleaver", 2, 1, "WARRIOR"},
	{-81, 1718, 1, 0, "The Islander", 3, 1, "WARRIOR"},
	{-81, 1719, 1, 0, "The Affray", 3, 1, "WARRIOR"},
	{-81, 3100, 1, 1, "Simple Letter", 1, 1, "WARRIOR"},
	{-81, 3106, 1, 1, "Simple Rune", 1, 1, "WARRIOR"},
	{-81, 3112, 1, 1, "Simple Memorandum", 1, 1, "WARRIOR"},
	{-81, 3116, 1, 1, "Simple Sigil", 1, 1, "WARRIOR"},
	{-81, 2383, 1, 1, "Simple Parchment", 2, 1, "WARRIOR"},
	{-81, 3065, 1, 1, "Simple Tablet", 2, 1, "WARRIOR"},
	{-81, 3091, 1, 1, "Simple Note", 2, 1, "WARRIOR"},
	{-81, 3095, 1, 1, "Simple Scroll", 2, 1, "WARRIOR"},
	{-81, 9289, 1, 2, "Warrior Training", 1, 1, "WARRIOR"},
	{-81, 1666, 1, 10, "Marshal Haggard", 1, 1, "WARRIOR"},
	{-81, 1667, 1, 10, "Dead-tooth Jack", 1, 1, "WARRIOR"},
	{-81, 1682, 1, 10, "Grey Iron Weapons", 1, 1, "WARRIOR"},
	{-81, 1686, 1, 10, "The Shade of Elura", 1, 1, "WARRIOR"},
	{-81, 1692, 1, 10, "Smith Mathiel", 1, 1, "WARRIOR"},
	{-81, 1693, 1, 10, "Weapons of Elunite", 1, 1, "WARRIOR"},
	{-81, 9582, 1, 10, "Strength of One", 1, 1, "WARRIOR"},
	{-81, 10350, 1, 10, "Behomat", 1, 1, "WARRIOR"},
	{-81, 1502, 1, 10, "Thun'grim Firegaze", 2, 1, "WARRIOR"},
	{-81, 1503, 1, 10, "Forged Steel", 2, 1, "WARRIOR"},
	{-81, 1820, 1, 10, "Speak with Coleman", 2, 1, "WARRIOR"},
	{-81, 1680, 1, 11, "Tormus Deepforge", 1, 1, "WARRIOR"},
	{-81, 1681, 1, 11, "Ironband's Compound", 1, 1, "WARRIOR"},
	{-81, 1821, 1, 11, "Agamand Heirlooms", 2, 1, "WARRIOR"},
	{-81, 1822, 1, 11, "Heirloom Weapon", 2, 1, "WARRIOR"},
	{-81, 1698, 1, 20, "Yorus Barleybrew", 1, 1, "WARRIOR"},
	{-81, 10371, 1, 20, "Yorus Barleybrew", 1, 1, "WARRIOR"},
	{-81, 1823, 1, 20, "Speak with Ruga", 2, 1, "WARRIOR"},
	{-81, 1824, 1, 20, "Trial at the Field of Giants", 2, 1, "WARRIOR"},
	{-81, 1825, 1, 20, "Speak with Thun'grim", 2, 1, "WARRIOR"},
	{-81, 1699, 1, 22, "The Rethban Gauntlet", 1, 1, "WARRIOR"},
	{-81, 1702, 1, 22, "The Shieldsmith", 1, 1, "WARRIOR"},
	{-81, 1700, 1, 28, "Grimand Elmore", 1, 1, "WARRIOR"},
	{-81, 1701, 1, 28, "Fire Hardened Mail [Group]", 1, 1, "WARRIOR"},
	{-81, 1703, 1, 28, "Mathiel", 1, 1, "WARRIOR"},
	{-81, 1704, 1, 28, "Klockmort Spannerspan", 1, 1, "WARRIOR"},
	{-81, 1705, 1, 28, "Burning Blood", 1, 1, "WARRIOR"},
	{-81, 1782, 1, 28, "Furen's Armor", 1, 1, "WARRIOR"},
	{-81, 1708, 1, 29, "Iron Coral", 1, 1, "WARRIOR"},
	{-81, 1706, 1, 30, "Grimand's Armor", 1, 1, "WARRIOR"},
	{-81, 1709, 1, 30, "Klockmort's Creation", 1, 1, "WARRIOR"},
	{-81, 1710, 1, 30, "Sunscorched Shells", 1, 1, "WARRIOR"},
	{-81, 1711, 1, 30, "Mathiel's Armor", 1, 1, "WARRIOR"},
	{-81, 1838, 1, 30, "Brutal Armor", 2, 1, "WARRIOR"},
	{-81, 1839, 1, 30, "Ula'elek and the Brutal Gauntlets", 2, 1, "WARRIOR"},
	{-81, 1840, 1, 30, "Orm Stonehoof and the Brutal Helm", 2, 1, "WARRIOR"},
	{-81, 1841, 1, 30, "Velora Nitely and the Brutal Legguards", 2, 1, "WARRIOR"},
	{-81, 1842, 1, 30, "Satyr Hooves", 2, 1, "WARRIOR"},
	{-81, 1843, 1, 30, "Brutal Gauntlets", 2, 1, "WARRIOR"},
	{-81, 1844, 1, 30, "Chimaeric Horn", 2, 1, "WARRIOR"},
	{-81, 1845, 1, 30, "Brutal Helm", 2, 1, "WARRIOR"},
	{-81, 1846, 1, 30, "Dragonmaw Shinbones", 2, 1, "WARRIOR"},
	{-81, 1847, 1, 30, "Brutal Legguards", 2, 1, "WARRIOR"},
	{-81, 1848, 1, 30, "Brutal Hauberk", 2, 1, "WARRIOR"},
	{-81, 1791, 1, 30, "The Windwatcher", 3, 1, "WARRIOR"},
	{-81, 1714, 2, 37, "Essence of the Exile", 3, 1, "WARRIOR"},
	{-81, 1712, 1, 40, "Cyclonian", 3, 1, "WARRIOR"},
	{-81, 1713, 1, 40, "The Summoning [Group]", 3, 1, "WARRIOR"},
	{-81, 1792, 1, 40, "Whirlwind Weapon", 3, 1, "WARRIOR"},
	{-81, 8417, 1, 52, "A Troubled Spirit", 3, 1, "WARRIOR"},
	{-81, 8423, 1, 52, "Warrior Kinship", 3, 1, "WARRIOR"},
	{-81, 8424, 1, 52, "War on the Shadowsworn", 3, 1, "WARRIOR"},
	{-81, 8425, 1, 52, "Voodoo Feathers", 3, 1, "WARRIOR"},

	--[[

		SPECIALS - Original Version 07/11/2010; TODO:TOURNAMENT NEEDS REWORKED

		CHANGELOG:

		##/##/####
		None

	--]]

	{-365, 8846, 4, 19, "Five Signets for War Supplies [Removed]", 4, 2, nil},
	{-365, 8851, 4, 19, "Five Signets for War Supplies [Removed]", 4, 2, nil},
	{-365, 8847, 4, 29, "Ten Signets for War Supplies [Removed]", 4, 2, nil},
	{-365, 8852, 4, 29, "Ten Signets for War Supplies [Removed]", 4, 2, nil},
	{-365, 8848, 4, 39, "Fifteen Signets for War Supplies [Removed]", 4, 2, nil},
	{-365, 8853, 4, 39, "Fifteen Signets for War Supplies [Removed]", 4, 2, nil},
	{-365, 8849, 4, 49, "Twenty Signets for War Supplies [Removed]", 4, 2, nil},
	{-365, 8854, 4, 49, "Twenty Signets for War Supplies [Removed]", 4, 2, nil},
	{-365, 8500, 4, 60, "The Alliance Needs More Thorium Bars! [Removed]", 4, 2, nil},
	{-365, 8504, 4, 60, "The Alliance Needs More Stranglekelp! [Removed]", 4, 2, nil},
	{-365, 8506, 4, 60, "The Alliance Needs More Purple Lotus! [Removed]", 4, 2, nil},
	{-365, 8510, 4, 60, "The Alliance Needs More Arthas' Tears! [Removed]", 4, 2, nil},
	{-365, 8525, 4, 60, "The Alliance Needs More Rainbow Fin Albacore! [Removed]", 4, 2, nil},
	{-365, 8527, 4, 60, "The Alliance Needs More Roast Raptor! [Removed]", 4, 2, nil},
	{-365, 8581, 4, 60, "The Horde Needs More Firebloom! [Removed]", 4, 2, nil},
	{-365, 8583, 4, 60, "The Horde Needs More Purple Lotus! [Removed]", 4, 2, nil},
	{-365, 8612, 4, 60, "The Horde Needs More Lean Wolf Steaks! [Removed]", 4, 2, nil},
	{-365, 8615, 4, 60, "The Horde Needs Baked Salmon! [Removed]", 4, 2, nil},
	{-365, 8616, 4, 60, "The Horde Needs More Baked Salmon! [Removed]", 4, 2, nil},
	{-365, 8850, 4, 60, "Thirty Signets for War Supplies [Removed]", 4, 2, nil},
	{-365, 8855, 4, 60, "Thirty Signets for War Supplies [Removed]", 4, 2, nil},
	{-365, 8492, 4, 60, "The Alliance Needs Copper Bars! [Removed]", 1, 2, nil},
	{-365, 8493, 4, 60, "The Alliance Needs More Copper Bars! [Removed]", 1, 2, nil},
	{-365, 8494, 4, 60, "The Alliance Needs Iron Bars! [Removed]", 1, 2, nil},
	{-365, 8495, 4, 60, "The Alliance Needs More Iron Bars! [Removed]", 1, 2, nil},
	{-365, 8499, 4, 60, "The Alliance Needs Thorium Bars! [Removed]", 1, 2, nil},
	{-365, 8503, 4, 60, "The Alliance Needs Stranglekelp! [Removed]", 1, 2, nil},
	{-365, 8505, 4, 60, "The Alliance Needs Purple Lotus! [Removed]", 1, 2, nil},
	{-365, 8509, 4, 60, "The Alliance Needs Arthas' Tears! [Removed]", 1, 2, nil},
	{-365, 8511, 4, 60, "The Alliance Needs Light Leather! [Removed]", 1, 2, nil},
	{-365, 8512, 4, 60, "The Alliance Needs More Light Leather! [Removed]", 1, 2, nil},
	{-365, 8513, 4, 60, "The Alliance Needs Medium Leather! [Removed]", 1, 2, nil},
	{-365, 8514, 4, 60, "The Alliance Needs More Medium Leather! [Removed]", 1, 2, nil},
	{-365, 8515, 4, 60, "The Alliance Needs Thick Leather! [Removed]", 1, 2, nil},
	{-365, 8516, 4, 60, "The Alliance Needs More Thick Leather! [Removed]", 1, 2, nil},
	{-365, 8517, 4, 60, "The Alliance Needs Linen Bandages! [Removed]", 1, 2, nil},
	{-365, 8518, 4, 60, "The Alliance Needs More Linen Bandages! [Removed]", 1, 2, nil},
	{-365, 8520, 4, 60, "The Alliance Needs Silk Bandages! [Removed]", 1, 2, nil},
	{-365, 8521, 4, 60, "The Alliance Needs More Silk Bandages! [Removed]", 1, 2, nil},
	{-365, 8522, 4, 60, "The Alliance Needs Runecloth Bandages! [Removed]", 1, 2, nil},
	{-365, 8523, 4, 60, "The Alliance Needs More Runecloth Bandages! [Removed]", 1, 2, nil},
	{-365, 8524, 4, 60, "The Alliance Needs Rainbow Fin Albacore! [Removed]", 1, 2, nil},
	{-365, 8526, 4, 60, "The Alliance Needs Roast Raptor! [Removed]", 1, 2, nil},
	{-365, 8528, 4, 60, "The Alliance Needs Spotted Yellowtail! [Removed]", 1, 2, nil},
	{-365, 8529, 4, 60, "The Alliance Needs More Spotted Yellowtail! [Removed]", 1, 2, nil},
	{-365, 8795, 4, 60, "The Alliance Needs Your Help! [Removed]", 1, 2, nil},
	{-365, 8796, 4, 60, "The Alliance Needs Your Help! [Removed]", 1, 2, nil},
	{-365, 8797, 4, 60, "The Alliance Needs Your Help! [Removed]", 1, 2, nil},
	{-365, 10501, 4, 60, "The Alliance Needs Your Help! [Removed]", 1, 2, nil},
	{-365, 8532, 4, 60, "The Horde Needs Copper Bars! [Removed]", 2, 2, nil},
	{-365, 8533, 4, 60, "The Horde Needs More Copper Bars! [Removed]", 2, 2, nil},
	{-365, 8542, 4, 60, "The Horde Needs Tin Bars! [Removed]", 2, 2, nil},
	{-365, 8543, 4, 60, "The Horde Needs More Tin Bars! [Removed]", 2, 2, nil},
	{-365, 8545, 4, 60, "The Horde Needs Mithril Bars! [Removed]", 2, 2, nil},
	{-365, 8546, 4, 60, "The Horde Needs More Mithril Bars! [Removed]", 2, 2, nil},
	{-365, 8549, 4, 60, "The Horde Needs Peacebloom! [Removed]", 2, 2, nil},
	{-365, 8550, 4, 60, "The Horde Needs More Peacebloom! [Removed]", 2, 2, nil},
	{-365, 8580, 4, 60, "The Horde Needs Firebloom! [Removed]", 2, 2, nil},
	{-365, 8582, 4, 60, "The Horde Needs Purple Lotus! [Removed]", 2, 2, nil},
	{-365, 8588, 4, 60, "The Horde Needs Heavy Leather! [Removed]", 2, 2, nil},
	{-365, 8589, 4, 60, "The Horde Needs More Heavy Leather! [Removed]", 2, 2, nil},
	{-365, 8590, 4, 60, "The Horde Needs Thick Leather! [Removed]", 2, 2, nil},
	{-365, 8591, 4, 60, "The Horde Needs More Thick Leather! [Removed]", 2, 2, nil},
	{-365, 8600, 4, 60, "The Horde Needs Rugged Leather! [Removed]", 2, 2, nil},
	{-365, 8601, 4, 60, "The Horde Needs More Rugged Leather! [Removed]", 2, 2, nil},
	{-365, 8604, 4, 60, "The Horde Needs Wool Bandages! [Removed]", 2, 2, nil},
	{-365, 8605, 4, 60, "The Horde Needs More Wool Bandages! [Removed]", 2, 2, nil},
	{-365, 8607, 4, 60, "The Horde Needs Mageweave Bandages! [Removed]", 2, 2, nil},
	{-365, 8608, 4, 60, "The Horde Needs More Mageweave Bandages! [Removed]", 2, 2, nil},
	{-365, 8609, 4, 60, "The Horde Needs Runecloth Bandages! [Removed]", 2, 2, nil},
	{-365, 8610, 4, 60, "The Horde Needs More Runecloth Bandages! [Removed]", 2, 2, nil},
	{-365, 8611, 4, 60, "The Horde Needs Lean Wolf Steaks! [Removed]", 2, 2, nil},
	{-365, 8613, 4, 60, "The Horde Needs Spotted Yellowtail! [Removed]", 2, 2, nil},
	{-365, 8614, 4, 60, "The Horde Needs More Spotted Yellowtail! [Removed]", 2, 2, nil},
	{-365, 8792, 4, 60, "The Horde Needs Your Help! [Removed]", 2, 2, nil},
	{-365, 8793, 4, 60, "The Horde Needs Your Help! [Removed]", 2, 2, nil},
	{-365, 8794, 4, 60, "The Horde Needs Your Help! [Removed]", 2, 2, nil},
	{-365, 10500, 4, 60, "The Horde Needs Your Help! [Removed]", 2, 2, nil},

	{-23, 25092, 1, 0, "Subduing the Elements", 4, 2, nil},
	{-23, 25181, 1, 0, "Tablets of Fire", 4, 2, nil},
	{-23, 25563, 3, 0, "Hammering It Out", 4, 2, nil},
	{-23, 25567, 3, 0, "Hammering It Out", 4, 2, nil},
	{-23, 25570, 3, 0, "Hammering It Out", 4, 2, nil},
	{-23, 25604, 3, 0, "Hammering It Out", 4, 2, nil},
	{-23, 25781, 3, 0, "Hammering It Out", 4, 2, nil},
	{-23, 25784, 3, 0, "Hammering It Out", 4, 2, nil},
	{-23, 25789, 3, 0, "Hammering It Out", 4, 2, nil},
	{-23, 27473, 1, 0, "What's Shaking in Ironforge}", 4, 2, nil},
	{-23, 27546, 1, 0, "Speak with Captain Anton}", 4, 2, nil},
	{-23, 27566, 1, 0, "A Gathering in Outland", 4, 2, nil},
	{-23, 27741, 1, 0, "Show Me Your Papers", 4, 2, nil},
	{-23, 27780, 1, 0, "I Said the Words...", 4, 2, nil},
	{-23, 27800, 1, 0, "Back Under Cover", 4, 2, nil},
	{-23, 27802, 1, 0, "Arrest the Infiltrators", 4, 2, nil},
	{-23, 25055, 1, 0, "Subduing the Elements", 1, 2, nil},
	{-23, 25180, 1, 0, "Tablets of the Earth", 1, 2, nil},
	{-23, 25253, 1, 0, "Prophecies Of Doom", 1, 2, nil},
	{-23, 25282, 1, 0, "Signs Of The Times", 1, 2, nil},
	{-23, 25290, 1, 0, "Infiltrating the Cult", 1, 2, nil},
	{-23, 25414, 1, 0, "The Missing", 1, 2, nil},
	{-23, 25415, 1, 0, "Spreading The Word", 1, 2, nil},
	{-23, 25416, 1, 0, "The Master's Plan", 1, 2, nil},
	{-23, 25417, 1, 0, "The Doomsday Plan", 1, 2, nil},
	{-23, 25418, 1, 0, "Thwarting Twilight's Hammer", 1, 2, nil},
	{-23, 25425, 1, 0, "Warn King Wrynn", 1, 2, nil},
	{-23, 25572, 3, 0, "Hammering It Out", 1, 2, nil},
	{-23, 27307, 1, 0, "The Elements Cry Out", 1, 2, nil},
	{-23, 27540, 1, 0, "The Wildhammer", 1, 2, nil},
	{-23, 27749, 1, 0, "Arrest the Infiltrators", 1, 2, nil},
	{-23, 27767, 1, 0, "Back Under Cover", 1, 2, nil},
	{-23, 25228, 1, 0, "Prophecies Of Doom", 2, 2, nil},
	{-23, 25254, 1, 0, "Signs Of The Times", 2, 2, nil},
	{-23, 25288, 1, 0, "Infiltrating The Cult", 2, 2, nil},
	{-23, 25293, 1, 0, "The Missing", 2, 2, nil},
	{-23, 25343, 1, 0, "The Master's Plan", 2, 2, nil},
	{-23, 25347, 1, 0, "The Doomsday Plan", 2, 2, nil},
	{-23, 25348, 1, 0, "Thwarting Twilight's Hammer", 2, 2, nil},
	{-23, 25351, 1, 0, "Alert Our Leaders", 2, 2, nil},
	{-23, 25380, 1, 0, "Spreading The Word", 2, 2, nil},
	{-23, 25571, 3, 0, "A Natural Occurrence", 2, 2, nil},
	{-23, 25787, 3, 0, "Hammering It Out", 2, 2, nil},
	{-23, 27308, 1, 0, "The Elements Cry Out", 2, 2, nil},
	{-23, 27570, 1, 0, "The Situation So Far", 2, 2, nil},
	{-23, 27572, 1, 0, "A Gathering in Outland", 2, 2, nil},
	{-23, 27799, 1, 0, "I Said the Words...", 2, 2, nil},
	{-23, 27801, 1, 0, "Show Me Your Papers", 2, 2, nil},
	{-23, 26990, 1, 80, "Water They Up To?", 4, 2, nil},
	{-23, 27122, 1, 80, "Fired Up and Not So Good To Go.", 4, 2, nil},
	{-23, 27137, 1, 80, "Earth Girls Aren't So Easy", 4, 2, nil},
	{-23, 27209, 1, 80, "This Blows", 4, 2, nil},
	{-23, 26054, 1, 80, "Water They Up To?", 1, 2, nil},
	{-23, 27207, 1, 80, "This Blows", 1, 2, nil},
	{-23, 27127, 1, 80, "Fired Up and Not So Good To Go.", 2, 2, nil},
	{-23, 27138, 1, 80, "Earth Girls Aren't So Easy", 2, 2, nil},

	{-1010, 24881, 2, 15, "Classic Random 5-15 (1st)", 4, 2, nil},
	{-1010, 24889, 2, 15, "Classic Random 5-15 (Nth)", 4, 2, nil},
	{-1010, 24882, 2, 25, "Classic Random 15-25 (1st)", 4, 2, nil},
	{-1010, 24890, 2, 25, "Classic Random 15-25 (Nth)", 4, 2, nil},
	{-1010, 24883, 2, 34, "Classic Random 24-34 (1st)", 4, 2, nil},
	{-1010, 24891, 2, 34, "Classic Random 24-34 (Nth)", 4, 2, nil},
	{-1010, 24884, 2, 45, "Classic Random 35-45 (1st)", 4, 2, nil},
	{-1010, 24892, 2, 45, "Classic Random 35-45 (Nth)", 4, 2, nil},
	{-1010, 24885, 2, 55, "Classic Random 46-55 (1st)", 4, 2, nil},
	{-1010, 24893, 2, 55, "Classic Random 46-55 (Nth)", 4, 2, nil},
	{-1010, 24886, 2, 60, "Classic Random 56-60 (1st)", 4, 2, nil},
	{-1010, 24894, 2, 60, "Classic Random 56-60 (Nth)", 4, 2, nil},
	{-1010, 24887, 2, 64, "Classic Random 60-64 (1st)", 4, 2, nil},
	{-1010, 24895, 2, 64, "Classic Random 60-64 (Nth)", 4, 2, nil},
	{-1010, 24888, 2, 70, "Classic Random 65-70 (1st)", 4, 2, nil},
	{-1010, 24896, 2, 70, "Classic Random 65-70 (Nth)", 4, 2, nil},
	{-1010, 24922, 2, 70, "Classic Random Heroic (1st)", 4, 2, nil},
	{-1010, 24923, 2, 70, "Burning Crusade Random Heroic (Nth)", 4, 2, nil},
	{-1010, 24788, 2, 80, "Daily Heroic Random (1st)", 4, 2, nil},
	{-1010, 24789, 2, 80, "Daily Heroic Random (Nth)", 4, 2, nil},
	{-1010, 24790, 2, 80, "Daily Normal Random (1st)", 4, 2, nil},
	{-1010, 24791, 2, 80, "Daily Normal Random (Nth)", 4, 2, nil},
	{-1010, 25482, 1, 80, "World Event Dungeon - Headless Horseman", 4, 2, nil},
	{-1010, 25483, 1, 80, "World Event Dungeon - Coren Direbrew", 4, 2, nil},
	{-1010, 25484, 1, 80, "World Event Dungeon - Ahune", 4, 2, nil},
	{-1010, 25485, 1, 80, "World Event Dungeon - Hummel", 4, 2, nil},

	{-1, 8446, 1, 60, "Shrouded in Nightmare", 3, 2, nil},
	{-1, 8447, 1, 60, "Waking Legends", 3, 2, nil},

	{-344, 7785, 1, 60, "Examine the Vessel", 3, 2, nil},
	{-344, 7786, 1, 60, "Thunderaan the Windseeker", 3, 2, nil},
	{-344, 7787, 1, 60, "Rise, Thunderfury!", 3, 2, nil},
	{-344, 9250, 1, 60, "Frame of Atiesh", 3, 2, nil},
	{-344, 9251, 1, 60, "Atiesh, the Befouled Greatstaff", 3, 2, nil},
	{-344, 9257, 1, 60, "Atiesh, Greatstaff of the Guardian", 3, 1, "PRIEST"},
	{-344, 9269, 1, 60, "Atiesh, Greatstaff of the Guardian", 3, 1, "DRUID"},
	{-344, 9270, 1, 60, "Atiesh, Greatstaff of the Guardian", 3, 1, "MAGE"},
	{-344, 9271, 1, 60, "Atiesh, Greatstaff of the Guardian", 3, 1, "WARLOCK"},

	{-367, 8811, 4, 60, "One Commendation Signet [Removed]", 4, 2, nil},
	{-367, 8812, 4, 60, "One Commendation Signet [Removed]", 4, 2, nil},
	{-367, 8813, 4, 60, "One Commendation Signet [Removed]", 4, 2, nil},
	{-367, 8814, 4, 60, "One Commendation Signet [Removed]", 4, 2, nil},
	{-367, 8815, 4, 60, "One Commendation Signet [Removed]", 4, 2, nil},
	{-367, 8816, 4, 60, "One Commendation Signet [Removed]", 4, 2, nil},
	{-367, 8817, 4, 60, "One Commendation Signet [Removed]", 4, 2, nil},
	{-367, 8818, 4, 60, "One Commendation Signet [Removed]", 4, 2, nil},
	{-367, 8819, 4, 60, "Ten Commendation Signets [Removed]", 4, 2, nil},
	{-367, 8820, 4, 60, "Ten Commendation Signets [Removed]", 4, 2, nil},
	{-367, 8821, 4, 60, "Ten Commendation Signets [Removed]", 4, 2, nil},
	{-367, 8822, 4, 60, "Ten Commendation Signets [Removed]", 4, 2, nil},
	{-367, 8823, 4, 60, "Ten Commendation Signets [Removed]", 4, 2, nil},
	{-367, 8824, 4, 60, "Ten Commendation Signets [Removed]", 4, 2, nil},
	{-367, 8825, 4, 60, "Ten Commendation Signets [Removed]", 4, 2, nil},
	{-367, 8826, 4, 60, "Ten Commendation Signets [Removed]", 4, 2, nil},
	{-367, 8830, 4, 60, "One Commendation Signet [Removed]", 4, 2, nil},
	{-367, 8831, 4, 60, "Ten Commendation Signets [Removed]", 4, 2, nil},
	{-367, 8832, 4, 60, "One Commendation Signet [Removed]", 4, 2, nil},
	{-367, 8833, 4, 60, "Ten Commendation Signets [Removed]", 4, 2, nil},
	{-367, 8834, 4, 60, "One Commendation Signet [Removed]", 4, 2, nil},
	{-367, 8835, 4, 60, "Ten Commendation Signets [Removed]", 4, 2, nil},
	{-367, 8836, 4, 60, "One Commendation Signet [Removed]", 4, 2, nil},
	{-367, 8837, 4, 60, "Ten Commendation Signets [Removed]", 4, 2, nil},
	{-367, 8838, 4, 60, "One Commendation Signet [Removed]", 4, 2, nil},
	{-367, 8839, 4, 60, "Ten Commendation Signets [Removed]", 4, 2, nil},
	{-367, 8840, 4, 60, "One Commendation Signet [Removed]", 4, 2, nil},
	{-367, 8841, 4, 60, "Ten Commendation Signets [Removed]", 4, 2, nil},
	{-367, 8842, 4, 60, "One Commendation Signet [Removed]", 4, 2, nil},
	{-367, 8843, 4, 60, "Ten Commendation Signets [Removed]", 4, 2, nil},
	{-367, 8844, 4, 60, "One Commendation Signet [Removed]", 4, 2, nil},
	{-367, 8845, 4, 60, "Ten Commendation Signets [Removed]", 4, 2, nil},
	{-367, 10693, 4, 60, "One Commendation Signet [Removed]", 4, 2, nil},
	{-367, 10694, 4, 60, "Ten Commendation Signets [Removed]", 4, 2, nil},
	{-367, 10695, 4, 60, "One Commendation Signet [Removed]", 4, 2, nil},
	{-367, 10696, 4, 60, "Ten Commendation Signets [Removed]", 4, 2, nil},
	{-367, 10697, 4, 60, "One Commendation Signet [Removed]", 4, 2, nil},
	{-367, 10698, 4, 60, "Ten Commendation Signets [Removed]", 4, 2, nil},
	{-367, 10699, 4, 60, "One Commendation Signet [Removed]", 4, 2, nil},
	{-367, 10700, 4, 60, "Ten Commendation Signets [Removed]", 4, 2, nil},

	{-368, 9094, 4, 0, "Argent Dawn Gloves [Removed]", 4, 2, nil},
	{-368, 9317, 4, 0, "Consecrated Sharpening Stones [Removed]", 4, 2, nil},
	{-368, 9318, 4, 0, "Blessed Wizard Oil [Removed]", 4, 2, nil},
	{-368, 9320, 4, 0, "Super Mana Potion [Removed]", 4, 2, nil},
	{-368, 9321, 4, 0, "Super Healing Potion [Removed]", 4, 2, nil},
	{-368, 9333, 4, 0, "Argent Dawn Gloves [Removed]", 4, 2, nil},
	{-368, 9334, 4, 0, "Blessed Wizard Oil [Removed]", 4, 2, nil},
	{-368, 9335, 4, 0, "Consecrated Sharpening Stones [Removed]", 4, 2, nil},
	{-368, 9336, 4, 0, "Super Healing Potion [Removed]", 4, 2, nil},
	{-368, 9337, 4, 0, "Super Mana Potion [Removed]", 4, 2, nil},
	{-368, 9341, 4, 0, "Tabard of the Argent Dawn [Removed]", 4, 2, nil},
	{-368, 9343, 4, 0, "Tabard of the Argent Dawn [Removed]", 4, 2, nil},
	{-368, 9292, 4, 0, "Cracked Necrotic Crystal [Removed]", 1, 2, nil},
	{-368, 12753, 4, 0, "A Desperate Alliance [Removed]", 1, 2, nil},
	{-368, 12771, 4, 0, "Ironforge [Removed]", 1, 2, nil},
	{-368, 12772, 4, 0, "A Desperate Alliance [Removed]", 1, 2, nil},
	{-368, 12773, 4, 0, "Darnassus [Removed]", 1, 2, nil},
	{-368, 12774, 4, 0, "Stormwind [Removed]", 1, 2, nil},
	{-368, 12775, 4, 0, "A Desperate Alliance [Removed]", 1, 2, nil},
	{-368, 12776, 4, 0, "The Exodar [Removed]", 1, 2, nil},
	{-368, 12777, 4, 0, "A Desperate Alliance [Removed]", 1, 2, nil},
	{-368, 12808, 4, 0, "A Desperate Alliance [Removed]", 1, 2, nil},
	{-368, 12809, 4, 0, "Ironforge [Removed]", 1, 2, nil},
	{-368, 9310, 4, 0, "Faint Necrotic Crystal [Removed]", 2, 2, nil},
	{-368, 12752, 4, 0, "Desperate Research [Removed]", 2, 2, nil},
	{-368, 12782, 4, 0, "Desperate Research [Removed]", 2, 2, nil},
	{-368, 12783, 4, 0, "Desperate Research [Removed]", 2, 2, nil},
	{-368, 12784, 4, 0, "Desperate Research [Removed]", 2, 2, nil},
	{-368, 12785, 4, 0, "Orgrimmar [Removed]", 2, 2, nil},
	{-368, 12786, 4, 0, "Thunder Bluff [Removed]", 2, 2, nil},
	{-368, 12787, 4, 0, "The Undercity [Removed]", 2, 2, nil},
	{-368, 12788, 4, 0, "Silvermoon [Removed]", 2, 2, nil},
	{-368, 12811, 4, 0, "Desperate Research [Removed]", 2, 2, nil},
	{-368, 12812, 4, 0, "Orgrimmar [Removed]", 2, 2, nil},
	{-368, 9085, 4, 0, "Shadows of Doom [Removed]", 3, 2, nil},
	{-368, 9153, 4, 0, "Under the Shadow [Removed]", 3, 2, nil},
	{-368, 9154, 4, 0, "Light's Hope Chapel [Removed]", 3, 2, nil},
	{-368, 9247, 4, 0, "The Keeper's Call [Removed]", 3, 2, nil},
	{-368, 9295, 4, 0, "Letter from the Front [Removed]", 3, 2, nil},
	{-368, 9299, 4, 0, "Note from the Front [Removed]", 3, 2, nil},
	{-368, 9300, 4, 0, "Page from the Front [Removed]", 3, 2, nil},
	{-368, 9301, 4, 0, "Envelope from the Front [Removed]", 3, 2, nil},
	{-368, 9302, 4, 0, "Missive from the Front [Removed]", 3, 2, nil},
	{-368, 9304, 4, 0, "Document from the Front [Removed]", 3, 2, nil},
	{-368, 9260, 4, 6, "Investigate the Scourge of Stormwind [Removed]", 1, 2, nil},
	{-368, 9265, 4, 8, "Investigate the Scourge of the Undercity [Removed]", 2, 2, nil},
	{-368, 9261, 4, 10, "Investigate the Scourge of Ironforge [Removed]", 1, 2, nil},
	{-368, 9262, 4, 10, "Investigate the Scourge of Darnassus [Removed]", 1, 2, nil},
	{-368, 12817, 4, 10, "Investigate the Scourge of Exodar [Removed]", 1, 2, nil},
	{-368, 9263, 4, 10, "Investigate the Scourge of Orgrimmar [Removed]", 2, 2, nil},
	{-368, 9264, 4, 10, "Investigate the Scourge of Thunder Bluff [Removed]", 2, 2, nil},
	{-368, 12816, 4, 10, "Investigate the Scourge of Silvermoon [Removed]", 2, 2, nil},

	-- TODO: NEEDS REWORKED
	{-241, 14200, 2, 70, "Kickoff Mail Marker", 4, 2, nil},
	{-241, 14096, 3, 80, "You've Really Done It This Time, Kul", 4, 2, nil},
	{-241, 13592, 3, 80, "A Valiant's Field Training", 1, 2, nil},
	{-241, 13593, 1, 80, "Valiant Of Stormwind", 1, 2, nil},
	{-241, 13600, 3, 80, "A Worthy Weapon", 1, 2, nil},
	{-241, 13603, 3, 80, "A Blade Fit For A Champion", 1, 2, nil},
	{-241, 13616, 3, 80, "The Edge Of Winter", 1, 2, nil},
	{-241, 13625, 3, 80, "Learning The Reins", 1, 2, nil},
	{-241, 13633, 1, 80, "The Black Knight of Westfall?", 1, 2, nil},
	{-241, 13665, 3, 80, "The Grand Melee", 1, 2, nil},
	{-241, 13666, 3, 80, "A Blade Fit For A Champion", 1, 2, nil},
	{-241, 13667, 1, 80, "The Argent Tournament", 1, 2, nil},
	{-241, 13669, 3, 80, "A Worthy Weapon", 1, 2, nil},
	{-241, 13670, 3, 80, "The Edge Of Winter", 1, 2, nil},
	{-241, 13671, 3, 80, "Training In The Field", 1, 2, nil},
	{-241, 13672, 1, 80, "Up To The Challenge", 1, 2, nil},
	{-241, 13679, 1, 80, "The Aspirant's Challenge", 1, 2, nil},
	{-241, 13682, 3, 80, "Threat From Above [Group]", 1, 2, nil},
	{-241, 13684, 1, 80, "A Valiant Of Stormwind", 1, 2, nil},
	{-241, 13685, 1, 80, "A Valiant Of Ironforge", 1, 2, nil},
	{-241, 13688, 1, 80, "A Valiant Of Gnomeregan", 1, 2, nil},
	{-241, 13689, 1, 80, "A Valiant Of Darnassus", 1, 2, nil},
	{-241, 13690, 1, 80, "A Valiant Of The Exodar", 1, 2, nil},
	{-241, 13699, 1, 80, "The Valiant's Challenge", 1, 2, nil},
	{-241, 13702, 1, 80, "A Champion Rises", 1, 2, nil},
	{-241, 13703, 1, 80, "Valiant Of Ironforge", 1, 2, nil},
	{-241, 13704, 1, 80, "Valiant Of Gnomeregan", 1, 2, nil},
	{-241, 13705, 1, 80, "Valiant Of The Exodar", 1, 2, nil},
	{-241, 13706, 1, 80, "Valiant Of Darnassus", 1, 2, nil},
	{-241, 13713, 1, 80, "The Valiant's Challenge", 1, 2, nil},
	{-241, 13714, 1, 80, "The Valiant's Charge", 1, 2, nil},
	{-241, 13715, 1, 80, "The Valiant's Charge", 1, 2, nil},
	{-241, 13716, 1, 80, "The Valiant's Charge", 1, 2, nil},
	{-241, 13717, 1, 80, "The Valiant's Charge", 1, 2, nil},
	{-241, 13718, 1, 80, "The Valiant's Charge", 1, 2, nil},
	{-241, 13723, 1, 80, "The Valiant's Challenge", 1, 2, nil},
	{-241, 13724, 1, 80, "The Valiant's Challenge", 1, 2, nil},
	{-241, 13725, 1, 80, "The Valiant's Challenge", 1, 2, nil},
	{-241, 13732, 1, 80, "A Champion Rises", 1, 2, nil},
	{-241, 13733, 1, 80, "A Champion Rises", 1, 2, nil},
	{-241, 13734, 1, 80, "A Champion Rises", 1, 2, nil},
	{-241, 13735, 1, 80, "A Champion Rises", 1, 2, nil},
	{-241, 13741, 3, 80, "A Blade Fit For A Champion", 1, 2, nil},
	{-241, 13742, 3, 80, "A Worthy Weapon", 1, 2, nil},
	{-241, 13743, 3, 80, "The Edge Of Winter", 1, 2, nil},
	{-241, 13744, 3, 80, "A Valiant's Field Training", 1, 2, nil},
	{-241, 13745, 3, 80, "The Grand Melee", 1, 2, nil},
	{-241, 13746, 3, 80, "A Blade Fit For A Champion", 1, 2, nil},
	{-241, 13747, 3, 80, "A Worthy Weapon", 1, 2, nil},
	{-241, 13748, 3, 80, "The Edge Of Winter", 1, 2, nil},
	{-241, 13749, 3, 80, "A Valiant's Field Training", 1, 2, nil},
	{-241, 13750, 3, 80, "The Grand Melee", 1, 2, nil},
	{-241, 13752, 3, 80, "A Blade Fit For A Champion", 1, 2, nil},
	{-241, 13753, 3, 80, "A Worthy Weapon", 1, 2, nil},
	{-241, 13754, 3, 80, "The Edge Of Winter", 1, 2, nil},
	{-241, 13755, 3, 80, "A Valiant's Field Training", 1, 2, nil},
	{-241, 13756, 3, 80, "The Grand Melee", 1, 2, nil},
	{-241, 13757, 3, 80, "A Blade Fit For A Champion", 1, 2, nil},
	{-241, 13758, 3, 80, "A Worthy Weapon", 1, 2, nil},
	{-241, 13759, 3, 80, "The Edge Of Winter", 1, 2, nil},
	{-241, 13760, 3, 80, "A Valiant's Field Training", 1, 2, nil},
	{-241, 13761, 3, 80, "The Grand Melee", 1, 2, nil},
	{-241, 13788, 3, 80, "Threat From Above [Group]", 1, 1, "TODO:CLASS"},
	{-241, 13789, 3, 80, "Taking Battle To The Enemy", 1, 2, nil},
	{-241, 13790, 3, 80, "Among the Champions", 1, 2, nil},
	{-241, 13791, 3, 80, "Taking Battle To The Enemy", 1, 1, "TODO:CLASS"},
	{-241, 13793, 3, 80, "Among the Champions", 1, 1, "TODO:CLASS"},
	{-241, 13828, 1, 80, "Mastery Of Melee", 1, 2, nil},
	{-241, 13835, 1, 80, "Mastery Of The Shield-Breaker", 1, 2, nil},
	{-241, 13837, 1, 80, "Mastery Of The Charge", 1, 2, nil},
	{-241, 13847, 3, 80, "At The Enemy's Gates", 1, 2, nil},
	{-241, 13851, 3, 80, "At The Enemy's Gates", 1, 2, nil},
	{-241, 13852, 3, 80, "At The Enemy's Gates", 1, 2, nil},
	{-241, 13854, 3, 80, "At The Enemy's Gates", 1, 2, nil},
	{-241, 13855, 3, 80, "At The Enemy's Gates", 1, 2, nil},
	{-241, 13861, 3, 80, "Battle Before The Citadel", 1, 2, nil},
	{-241, 13864, 3, 80, "Battle Before The Citadel", 1, 1, "TODO:CLASS"},
	{-241, 14074, 3, 80, "A Leg Up", 1, 2, nil},
	{-241, 14076, 3, 80, "Breakfast Of Champions", 1, 2, nil},
	{-241, 14077, 3, 80, "The Light's Mercy", 1, 2, nil},
	{-241, 14080, 3, 80, "Stop The Aggressors", 1, 2, nil},
	{-241, 14090, 3, 80, "Gormok Wants His Snobolds", 1, 2, nil},
	{-241, 14112, 3, 80, "What Do You Feed a Yeti, Anyway?", 1, 2, nil},
	{-241, 14152, 3, 80, "Rescue at Sea", 1, 2, nil},
	{-241, 13634, 1, 80, "The Black Knight of Silverpine?", 2, 2, nil},
	{-241, 13668, 1, 80, "The Argent Tournament", 2, 2, nil},
	{-241, 13673, 3, 80, "A Blade Fit For A Champion", 2, 2, nil},
	{-241, 13674, 3, 80, "A Worthy Weapon", 2, 2, nil},
	{-241, 13675, 3, 80, "The Edge Of Winter", 2, 2, nil},
	{-241, 13676, 3, 80, "Training In The Field", 2, 2, nil},
	{-241, 13677, 3, 80, "Learning The Reins", 2, 2, nil},
	{-241, 13678, 1, 80, "Up To The Challenge", 2, 2, nil},
	{-241, 13680, 1, 80, "The Aspirant's Challenge", 2, 2, nil},
	{-241, 13691, 1, 80, "A Valiant Of Orgrimmar", 2, 2, nil},
	{-241, 13693, 1, 80, "A Valiant Of Sen'jin", 2, 2, nil},
	{-241, 13694, 1, 80, "A Valiant Of Thunder Bluff", 2, 2, nil},
	{-241, 13695, 1, 80, "A Valiant Of Undercity", 2, 2, nil},
	{-241, 13696, 1, 80, "A Valiant Of Silvermoon", 2, 2, nil},
	{-241, 13697, 1, 80, "The Valiant's Charge", 2, 2, nil},
	{-241, 13707, 1, 80, "Valiant Of Orgrimmar", 2, 2, nil},
	{-241, 13708, 1, 80, "Valiant Of Sen'jin", 2, 2, nil},
	{-241, 13709, 1, 80, "Valiant Of Thunder Bluff", 2, 2, nil},
	{-241, 13710, 1, 80, "Valiant Of Undercity", 2, 2, nil},
	{-241, 13711, 1, 80, "Valiant Of Silvermoon", 2, 2, nil},
	{-241, 13719, 1, 80, "The Valiant's Charge", 2, 2, nil},
	{-241, 13720, 1, 80, "The Valiant's Charge", 2, 2, nil},
	{-241, 13721, 1, 80, "The Valiant's Charge", 2, 2, nil},
	{-241, 13722, 1, 80, "The Valiant's Charge", 2, 2, nil},
	{-241, 13726, 1, 80, "The Valiant's Challenge", 2, 2, nil},
	{-241, 13727, 1, 80, "The Valiant's Challenge", 2, 2, nil},
	{-241, 13728, 1, 80, "The Valiant's Challenge", 2, 2, nil},
	{-241, 13729, 1, 80, "The Valiant's Challenge", 2, 2, nil},
	{-241, 13731, 1, 80, "The Valiant's Challenge", 2, 2, nil},
	{-241, 13736, 1, 80, "A Champion Rises", 2, 2, nil},
	{-241, 13737, 1, 80, "A Champion Rises", 2, 2, nil},
	{-241, 13738, 1, 80, "A Champion Rises", 2, 2, nil},
	{-241, 13739, 1, 80, "A Champion Rises", 2, 2, nil},
	{-241, 13740, 1, 80, "A Champion Rises", 2, 2, nil},
	{-241, 13762, 3, 80, "A Blade Fit For A Champion", 2, 2, nil},
	{-241, 13763, 3, 80, "A Worthy Weapon", 2, 2, nil},
	{-241, 13764, 3, 80, "The Edge Of Winter", 2, 2, nil},
	{-241, 13765, 3, 80, "A Valiant's Field Training", 2, 2, nil},
	{-241, 13767, 3, 80, "The Grand Melee", 2, 2, nil},
	{-241, 13768, 3, 80, "A Blade Fit For A Champion", 2, 2, nil},
	{-241, 13769, 3, 80, "A Worthy Weapon", 2, 2, nil},
	{-241, 13770, 3, 80, "The Edge Of Winter", 2, 2, nil},
	{-241, 13771, 3, 80, "A Valiant's Field Training", 2, 2, nil},
	{-241, 13772, 3, 80, "The Grand Melee", 2, 2, nil},
	{-241, 13773, 3, 80, "A Blade Fit For A Champion", 2, 2, nil},
	{-241, 13774, 3, 80, "A Worthy Weapon", 2, 2, nil},
	{-241, 13775, 3, 80, "The Edge Of Winter", 2, 2, nil},
	{-241, 13776, 3, 80, "A Valiant's Field Training", 2, 2, nil},
	{-241, 13777, 3, 80, "The Grand Melee", 2, 2, nil},
	{-241, 13778, 3, 80, "A Blade Fit For A Champion", 2, 2, nil},
	{-241, 13779, 3, 80, "A Worthy Weapon", 2, 2, nil},
	{-241, 13780, 3, 80, "The Edge Of Winter", 2, 2, nil},
	{-241, 13781, 3, 80, "A Valiant's Field Training", 2, 2, nil},
	{-241, 13782, 3, 80, "The Grand Melee", 2, 2, nil},
	{-241, 13783, 3, 80, "A Blade Fit For A Champion", 2, 2, nil},
	{-241, 13784, 3, 80, "A Worthy Weapon", 2, 2, nil},
	{-241, 13785, 3, 80, "The Edge Of Winter", 2, 2, nil},
	{-241, 13786, 3, 80, "A Valiant's Field Training", 2, 2, nil},
	{-241, 13787, 3, 80, "The Grand Melee", 2, 2, nil},
	{-241, 13809, 3, 80, "Threat From Above [Group]", 2, 2, nil},
	{-241, 13810, 3, 80, "Taking Battle To The Enemy", 2, 2, nil},
	{-241, 13811, 3, 80, "Among the Champions", 2, 2, nil},
	{-241, 13812, 3, 80, "Threat From Above [Group]", 2, 1, "TODO:CLASS"},
	{-241, 13813, 3, 80, "Taking Battle To The Enemy", 2, 1, "TODO:CLASS"},
	{-241, 13814, 3, 80, "Among the Champions", 2, 1, "TODO:CLASS"},
	{-241, 13829, 1, 80, "Mastery Of Melee", 2, 2, nil},
	{-241, 13838, 1, 80, "Mastery Of The Shield-Breaker", 2, 2, nil},
	{-241, 13839, 1, 80, "Mastery Of The Charge", 2, 2, nil},
	{-241, 13856, 3, 80, "At The Enemy's Gates", 2, 2, nil},
	{-241, 13857, 3, 80, "At The Enemy's Gates", 2, 2, nil},
	{-241, 13858, 3, 80, "At The Enemy's Gates", 2, 2, nil},
	{-241, 13859, 3, 80, "At The Enemy's Gates", 2, 2, nil},
	{-241, 13860, 3, 80, "At The Enemy's Gates", 2, 2, nil},
	{-241, 13862, 3, 80, "Battle Before The Citadel", 2, 2, nil},
	{-241, 13863, 3, 80, "Battle Before The Citadel", 2, 1, "TODO:CLASS"},
	{-241, 14092, 3, 80, "Breakfast Of Champions", 2, 2, nil},
	{-241, 14136, 3, 80, "Rescue at Sea", 2, 2, nil},
	{-241, 14140, 3, 80, "Stop The Aggressors", 2, 2, nil},
	{-241, 14141, 3, 80, "Gormok Wants His Snobolds", 2, 2, nil},
	{-241, 14142, 3, 80, "You've Really Done It This Time, Kul", 2, 2, nil},
	{-241, 14143, 3, 80, "A Leg Up", 2, 2, nil},
	{-241, 14144, 3, 80, "The Light's Mercy", 2, 2, nil},
	{-241, 14145, 3, 80, "What Do You Feed a Yeti, Anyway?", 2, 2, nil},
	{-241, 13627, 3, 80, "Jack Me Some Lumber", 3, 2, nil},
	{-241, 13641, 1, 80, "The Seer's Crystal", 3, 2, nil},
	{-241, 13643, 1, 80, "The Stories Dead Men Tell", 3, 2, nil},
	{-241, 13654, 1, 80, "0", 4, 2, nil},

	{-9999, 9031, 4, 0, "<TXT>Anthion's Parting Words", 4, 2, nil},
	{-9999, 8551, 4, 0, "The Captain's Chest", 4, 2, nil},
	{-9999, 10214, 4, 0, "When This Mine's a-Rockin'", 4, 2, nil},
	{-9999, 9734, 4, 0, "Return to the Marsh", 4, 2, nil},
	{-9999, 9030, 4, 0, "Anthion's Parting Words", 4, 2, nil},
	{-9999, 10149, 4, 0, "Mission: End All, Be All", 4, 2, nil},
	{-9999, 9733, 4, 0, "Warning the Cenarion Circle", 4, 2, nil},
	{-9999, 13700, 4, 0, "Alliance Champion Marker", 4, 2, nil},
	{-9999, 12452, 4, 0, "zzOLD The Fate of the Ruby Dragonshrine", 4, 2, nil},
	{-9999, 13123, 4, 0, "WotLK Collector's Edition: - DEM - E - FLAG", 4, 2, nil},
	{-9999, 7496, 4, 0, "Celebrating Good Times", 4, 2, nil},
	{-9999, 11937, 4, 0, "FLAG - all torch return quests are complete", 4, 2, nil},
	{-9999, 11578, 4, 0, "The \"Chow\" Quest (123)aa COPY", 4, 2, nil},
	{-9999, 6842, 4, 0, "<UNUSED>", 4, 2, nil},
	{-9999, 9378, 4, 0, "DND FLAG The Dread Citadel - Naxxramas", 4, 2, nil},
	{-9999, 10815, 4, 0, "The Journal of Val'zareq: Portends of War", 4, 2, nil},
	{-9999, 10207, 4, 0, "Forward Base: Reaver's Fall REUSE", 4, 2, nil},
	{-9999, 11518, 4, 0, "Sunwell Daily Portal Flag", 4, 2, nil},
	{-9999, 3381, 4, 0, "A Meeting with the Master", 4, 2, nil},
	{-9999, 9749, 4, 0, "They're Alive! Maybe...", 4, 2, nil},
	{-9999, 11579, 4, 0, "The \"Chow\" Quest (123)aa COPY", 4, 2, nil},
	{-9999, 12694, 4, 0, "Oracle Faction Choice Tracker", 4, 2, nil},
	{-9999, 13053, 4, 0, "Looking for Survivors", 4, 2, nil},
	{-9999, 10401, 4, 0, "Mission: End All, Be All", 4, 2, nil},
	{-9999, 10746, 4, 0, "DEPRECATED Karazhan: LAB - E - Exalted Ring - Caster", 4, 2, nil},
	{-9999, 13686, 4, 0, "Alliance Tournament Eligibility Marker", 4, 2, nil},
	{-9999, 7069, 4, 0, "<UNUSED>", 4, 2, nil},
	{-9999, 13687, 4, 0, "Horde Tournament Eligibility Marker", 4, 2, nil},
	{-9999, 11320, 4, 0, "[NYI] Now this is Ram Racing... Almost.", 4, 2, nil},
	{-9999, 24811, 4, 0, "Caster Ring Flag", 4, 2, nil},
	{-9999, 11447, 4, 0, "Welcome to Brewfest!", 4, 2, nil},
	{-9999, 14032, 4, 0, "Kobold Camp Cleanup [Programming Test]", 4, 2, nil},
	{-9999, 13052, 4, 0, "Aerial Surveillance", 4, 2, nil},
	{-9999, 10454, 4, 0, "FLAG - OFF THE RAILS", 4, 2, nil},
	{-9999, 9750, 4, 0, "UNUSED Urgent Delivery", 4, 2, nil},
	{-9999, 13524, 4, 0, "Escape from Silverbrook", 4, 2, nil},
	{-9999, 3366, 4, 0, "The Glowing Shard", 4, 2, nil},
	{-9999, 10387, 4, 0, "The Fel Reaver Slayer", 4, 2, nil},
	{-9999, 11442, 4, 0, "Welcome to Brewfest!", 4, 2, nil},
	{-9999, 10386, 4, 0, "The Fel Reaver Slayer", 4, 2, nil},
	{-9999, 10737, 4, 0, "The Master's Touch", 4, 2, nil},
	{-9999, 13807, 4, 0, "FLAG: Tournament Invitation", 4, 2, nil},
	{-9999, 12845, 4, 0, "Dalaran Teleport Crystal Flag", 4, 2, nil},
	{-9999, 10925, 4, 0, "Evil Draws Near", 4, 2, nil},
	{-9999, 10125, 4, 0, "Mission: Disrupt Communications", 4, 2, nil},
	{-9999, 11115, 4, 0, "The Mark of Vashj (FLAG ONLY)", 4, 2, nil},
	{-9999, 11976, 4, 0, "Ice Shards", 4, 2, nil},
	{-9999, 7908, 4, 0, "Arena Master", 4, 2, nil},
	{-9999, 7364, 4, 0, "Gnomeregan Bounty", 4, 2, nil},
	{-9999, 934, 4, 0, "Crown of the Earth", 4, 2, nil},
	{-9999, 620, 4, 0, "The Monogrammed Sash", 4, 2, nil},
	{-9999, 618, 4, 0, "Facing Negolash", 4, 2, nil},
	{-9999, 615, 4, 0, "The Captain's Cutlass", 4, 2, nil},
	{-9999, 1, 4, 0, "Kanrethad's Quest", 4, 2, nil},
	{-9999, 13417, 4, 0, "The Brothers Bronzebeard", 4, 2, nil},
	{-9999, 4487, 4, 0, "Summon Felsteed", 4, 2, nil},
	{-9999, 7495, 4, 0, "Victory for the Alliance", 4, 2, nil},
	{-9999, 4488, 4, 0, "Summon Felsteed", 4, 2, nil},
	{-9999, 4489, 4, 0, "Summon Felsteed", 4, 2, nil},
	{-9999, 4490, 4, 0, "Summon Felsteed", 4, 2, nil},
	--{-9999, , 4, 0, "", 4, 2, nil},

	--[[

		RAIDS - Original Version 08/11/2010;

		CHANGELOG:

		08/11/2010

		Quests flagged as special:
		24797.

	--]]

	{3959, 10957, 1, 70, "Redemption of the Ashtongue", 3, 2, nil},
	{3959, 10958, 1, 70, "Seek Out the Ashtongue", 3, 2, nil},
	{3959, 10959, 1, 70, "The Fall of the Betrayer", 3, 2, nil},

	{2677, 8730, 1, 60, "Nefarius's Corruption", 1, 2, nil},
	{2677, 8288, 1, 60, "Only One May Rise", 3, 2, nil},

	{3606, 10460, 1, 70, "Defender's Pledge", 3, 2, nil},
	{3606, 10461, 1, 70, "Restorer's Pledge", 3, 2, nil},
	{3606, 10462, 1, 70, "Champion's Pledge", 3, 2, nil},
	{3606, 10463, 1, 70, "Sage's Pledge", 3, 2, nil},
	{3606, 10464, 1, 70, "Sage's Vow", 3, 2, nil},
	{3606, 10465, 1, 70, "Restorer's Vow", 3, 2, nil},
	{3606, 10466, 1, 70, "Champion's Vow", 3, 2, nil},
	{3606, 10467, 1, 70, "Defender's Vow", 3, 2, nil},
	{3606, 10468, 1, 70, "Sage's Oath", 3, 2, nil},
	{3606, 10469, 1, 70, "Restorer's Oath", 3, 2, nil},
	{3606, 10470, 1, 70, "Champion's Oath", 3, 2, nil},
	{3606, 10471, 1, 70, "Defender's Oath", 3, 2, nil},
	{3606, 10472, 1, 70, "Sage's Covenant", 3, 2, nil},
	{3606, 10473, 1, 70, "Restorer's Covenant", 3, 2, nil},
	{3606, 10474, 1, 70, "Champion's Covenant", 3, 2, nil},
	{3606, 10475, 1, 70, "Defender's Covenant", 3, 2, nil},
	{3606, 10947, 1, 70, "An Artifact From the Past", 3, 2, nil},

	{4812, 24547, 1, 80, "A Feast of Souls", 4, 1, "WARRIOR PALADIN DEATHKNIGHT"},
	{4812, 24548, 1, 80, "The Splintered Throne", 4, 1, "WARRIOR PALADIN DEATHKNIGHT"},
	{4812, 24748, 1, 80, "The Lich King's Last Stand", 4, 1, "WARRIOR PALADIN DEATHKNIGHT"},
	{4812, 24749, 1, 80, "Unholy Infusion", 4, 1, "WARRIOR PALADIN DEATHKNIGHT"},
	{4812, 24756, 1, 80, "Blood Infusion", 4, 1, "WARRIOR PALADIN DEATHKNIGHT"},
	{4812, 24757, 1, 80, "Frost Infusion", 4, 1, "WARRIOR PALADIN DEATHKNIGHT"},
	{4812, 24871, 1, 80, "Securing the Ramparts", 1, 2, nil},
	{4812, 24876, 1, 80, "Securing the Ramparts", 1, 2, nil},
	{4812, 24870, 1, 80, "Securing the Ramparts", 2, 2, nil},
	{4812, 24877, 1, 80, "Securing the Ramparts", 2, 2, nil},
	{4812, 24545, 1, 80, "The Sacred and the Corrupt", 3, 1, "WARRIOR PALADIN DEATHKNIGHT"},
	{4812, 24549, 1, 80, "Shadowmourne...", 3, 2, nil},
	{4812, 24590, 1, 80, "Lord Marrowgar Must Die!", 3, 2, nil},
	{4812, 24743, 1, 80, "Shadow's Edge", 3, 1, "WARRIOR PALADIN DEATHKNIGHT"},
	{4812, 24815, 1, 80, "Choose Your Path", 3, 2, nil},
	{4812, 24819, 2, 80, "A Change of Heart", 3, 2, nil},
	{4812, 24820, 2, 80, "A Change of Heart", 3, 2, nil},
	{4812, 24821, 2, 80, "A Change of Heart", 3, 2, nil},
	{4812, 24822, 2, 80, "A Change of Heart", 3, 2, nil},
	{4812, 24823, 1, 80, "Path of Destruction", 3, 2, nil},
	{4812, 24825, 1, 80, "Path of Wisdom", 3, 2, nil},
	{4812, 24826, 1, 80, "Path of Vengeance", 3, 2, nil},
	{4812, 24827, 1, 80, "Path of Courage", 3, 2, nil},
	{4812, 24828, 1, 80, "Path of Destruction", 3, 2, nil},
	{4812, 24829, 1, 80, "Path of Destruction", 3, 2, nil},
	{4812, 24830, 1, 80, "Path of Wisdom", 3, 2, nil},
	{4812, 24831, 1, 80, "Path of Wisdom", 3, 2, nil},
	{4812, 24832, 1, 80, "Path of Vengeance", 3, 2, nil},
	{4812, 24833, 1, 80, "Path of Vengeance", 3, 2, nil},
	{4812, 24834, 1, 80, "Path of Courage", 3, 2, nil},
	{4812, 24835, 1, 80, "Path of Courage", 3, 2, nil},
	{4812, 24836, 2, 80, "A Change of Heart", 3, 2, nil},
	{4812, 24837, 2, 80, "A Change of Heart", 3, 2, nil},
	{4812, 24838, 2, 80, "A Change of Heart", 3, 2, nil},
	{4812, 24839, 2, 80, "A Change of Heart", 3, 2, nil},
	{4812, 24840, 2, 80, "A Change of Heart", 3, 2, nil},
	{4812, 24841, 2, 80, "A Change of Heart", 3, 2, nil},
	{4812, 24842, 2, 80, "A Change of Heart", 3, 2, nil},
	{4812, 24843, 2, 80, "A Change of Heart", 3, 2, nil},
	{4812, 24844, 2, 80, "A Change of Heart", 3, 2, nil},
	{4812, 24845, 2, 80, "A Change of Heart", 3, 2, nil},
	{4812, 24846, 2, 80, "A Change of Heart", 3, 2, nil},
	{4812, 24847, 2, 80, "A Change of Heart", 3, 2, nil},
	{4812, 24869, 1, 80, "Deprogramming", 3, 2, nil},
	{4812, 24872, 1, 80, "Respite for a Tormented Soul", 3, 2, nil},
	{4812, 24873, 1, 80, "Residue Rendezvous", 3, 2, nil},
	{4812, 24874, 1, 80, "Blood Quickening", 3, 2, nil},
	{4812, 24875, 1, 80, "Deprogramming", 3, 2, nil},
	{4812, 24878, 1, 80, "Residue Rendezvous", 3, 2, nil},
	{4812, 24879, 1, 80, "Blood Quickening", 3, 2, nil},
	{4812, 24880, 1, 80, "Respite for a Tormented Soul", 3, 2, nil},
	{4812, 24912, 1, 80, "Empowerment", 3, 1, "WARRIOR PALADIN DEATHKNIGHT"},
	{4812, 24914, 1, 80, "Personal Property", 3, 1, "WARRIOR PALADIN DEATHKNIGHT"},
	{4812, 24915, 1, 80, "Mograine's Reunion", 3, 1, "WARRIOR PALADIN DEATHKNIGHT"},
	{4812, 24916, 1, 80, "Jaina's Locket", 3, 1, "WARRIOR PALADIN DEATHKNIGHT"},
	{4812, 24917, 1, 80, "Muradin's Lament", 3, 1, "WARRIOR PALADIN DEATHKNIGHT"},
	{4812, 24918, 1, 80, "Sylvanas' Vengeance", 3, 1, "WARRIOR PALADIN DEATHKNIGHT"},
	{4812, 24919, 1, 80, "The Lightbringer's Redemption", 3, 1, "WARRIOR PALADIN DEATHKNIGHT"},
	{4812, 25239, 1, 80, "Path of Might", 3, 1, "WARRIOR PALADIN DEATHKNIGHT"},
	{4812, 25240, 1, 80, "Path of Might", 3, 2, nil},
	{4812, 25242, 1, 80, "Path of Might", 3, 2, nil},
	{4812, 25246, 2, 80, "A Change of Heart", 3, 2, nil},
	{4812, 25247, 2, 80, "A Change of Heart", 3, 2, nil},
	{4812, 25248, 2, 80, "A Change of Heart", 3, 2, nil},
	{4812, 25249, 2, 80, "A Change of Heart", 3, 2, nil},

	{3457, 9630, 1, 70, "Medivh's Journal", 3, 2, nil},
	{3457, 9637, 1, 70, "Kalynna's Request", 3, 2, nil},
	{3457, 9638, 1, 70, "In Good Hands", 3, 2, nil},
	{3457, 9639, 1, 70, "Kamsis", 3, 2, nil},
	{3457, 9640, 1, 70, "The Shade of Aran", 3, 2, nil},
	{3457, 9644, 1, 70, "Nightbane", 3, 2, nil},
	{3457, 9645, 1, 70, "The Master's Terrace", 3, 2, nil},
	{3457, 9824, 1, 70, "Arcane Disturbances", 3, 2, nil},
	{3457, 9825, 1, 70, "Restless Activity", 3, 2, nil},
	{3457, 9838, 1, 70, "The Violet Eye", 3, 2, nil},
	{3457, 9840, 1, 70, "Assessing the Situation", 3, 2, nil},
	{3457, 9843, 1, 70, "Keanna's Log", 3, 2, nil},
	{3457, 9844, 1, 70, "A Demonic Presence", 3, 2, nil},
	{3457, 10725, 1, 70, "Eminence Among the Violet Eye", 3, 2, nil},
	{3457, 10726, 1, 70, "Eminence Among the Violet Eye", 3, 2, nil},
	{3457, 10727, 1, 70, "Eminence Among the Violet Eye", 3, 2, nil},
	{3457, 10728, 1, 70, "Eminence Among the Violet Eye", 3, 2, nil},
	{3457, 10729, 1, 70, "Path of the Violet Mage", 3, 2, nil},
	{3457, 10730, 1, 70, "Path of the Violet Restorer", 3, 2, nil},
	{3457, 10731, 1, 70, "Path of the Violet Assassin", 3, 2, nil},
	{3457, 10732, 1, 70, "Path of the Violet Protector", 3, 2, nil},
	{3457, 10733, 1, 70, "Down the Violet Path", 3, 2, nil},
	{3457, 10734, 1, 70, "Down the Violet Path", 3, 2, nil},
	{3457, 10735, 1, 70, "Down the Violet Path", 3, 2, nil},
	{3457, 10736, 1, 70, "Down the Violet Path", 3, 2, nil},
	{3457, 10738, 1, 70, "Distinguished Service", 3, 2, nil},
	{3457, 10739, 1, 70, "Distinguished Service", 3, 2, nil},
	{3457, 10740, 1, 70, "Distinguished Service", 3, 2, nil},
	{3457, 10741, 1, 70, "Distinguished Service", 3, 2, nil},
	{3457, 11031, 2, 70, "Archmage No More", 3, 2, nil},
	{3457, 11032, 2, 70, "Protector No More", 3, 2, nil},
	{3457, 11033, 2, 70, "Assassin No More", 3, 2, nil},
	{3457, 11034, 2, 70, "Restorer No More", 3, 2, nil},
	{3457, 11216, 1, 70, "Archmage Alturus", 3, 2, nil},
	{3457, 12616, 1, 70, "Chamber of Secrets", 3, 2, nil},

	{3836, 10888, 1, 70, "Trial of the Naaru: Magtheridon", 3, 2, nil},
	{3836, 13430, 1, 70, "Trial of the Naaru: Magtheridon", 3, 2, nil},

	{2717, 6642, 2, 60, "Favor Amongst the Brotherhood, Dark Iron Ore", 3, 2, nil},
	{2717, 6643, 2, 60, "Favor Amongst the Brotherhood, Fiery Core", 3, 2, nil},
	{2717, 6644, 2, 60, "Favor Amongst the Brotherhood, Lava Core", 3, 2, nil},
	{2717, 6645, 2, 60, "Favor Amongst the Brotherhood, Core Leather", 3, 2, nil},
	{2717, 6646, 2, 60, "Favor Amongst the Brotherhood, Blood of the Mountain", 3, 2, nil},
	{2717, 7848, 1, 60, "Attunement to the Core", 3, 2, nil},
	{2717, 8578, 1, 60, "Scrying Goggles? No Problem!", 3, 2, nil},

	{3456, 9071, 4, 60, "Earthshatter Spaulders [Removed]", 4, 2, nil},
	{3456, 9086, 4, 60, "Dreamwalker Tunic [Removed]", 4, 2, nil},
	{3456, 9087, 4, 60, "Dreamwalker Legguards [Removed]", 4, 2, nil},
	{3456, 9088, 4, 60, "Dreamwalker Headpiece [Removed]", 4, 2, nil},
	{3456, 9089, 4, 60, "Dreamwalker Spaulders [Removed]", 4, 2, nil},
	{3456, 9110, 4, 60, "Plagueheart Bindings [Removed]", 4, 2, nil},
	{3456, 9038, 4, 60, "Dreadnaught Pauldrons [Removed]", 1, 2, nil},
	{3456, 9039, 4, 60, "Dreadnaught Sabatons [Removed]", 1, 2, nil},
	{3456, 9040, 4, 60, "Dreadnaught Gauntlets [Removed]", 1, 2, nil},
	{3456, 9041, 4, 60, "Dreadnaught Waistguard [Removed]", 1, 2, nil},
	{3456, 9042, 4, 60, "Dreadnaught Bracers [Removed]", 1, 2, nil},
	{3456, 9047, 4, 60, "Redemption Boots [Removed]", 1, 2, nil},
	{3456, 9083, 4, 60, "Bonescythe Waistguard [Removed]", 1, 2, nil},
	{3456, 9084, 4, 60, "Bonescythe Bracers [Removed]", 1, 2, nil},
	{3456, 9090, 4, 60, "Dreamwalker Boots [Removed]", 1, 2, nil},
	{3456, 9093, 4, 60, "Dreamwalker Wristguards [Removed]", 1, 2, nil},
	{3456, 9120, 4, 60, "The Fall of Kel'Thuzad [Removed]", 1, 2, nil},
	{3456, 9056, 4, 60, "Cryptstalker Headpiece [Removed]", 2, 2, nil},
	{3456, 9058, 4, 60, "Cryptstalker Boots [Removed]", 2, 2, nil},
	{3456, 9061, 4, 60, "Cryptstalker Wristguards [Removed]", 2, 2, nil},
	{3456, 9105, 4, 60, "Plagueheart Circlet [Removed]", 2, 2, nil},
	{3456, 9033, 1, 60, "Echoes of War", 3, 2, nil},
	{3456, 9034, 4, 60, "Dreadnaught Breastplate [Removed]", 3, 2, nil},
	{3456, 9036, 4, 60, "Dreadnaught Legplates [Removed]", 3, 2, nil},
	{3456, 9037, 4, 60, "Dreadnaught Helmet [Removed]", 3, 2, nil},
	{3456, 9043, 4, 60, "Redemption Tunic [Removed]", 3, 2, nil},
	{3456, 9044, 4, 60, "Redemption Legguards [Removed]", 3, 2, nil},
	{3456, 9045, 4, 60, "Redemption Headpiece [Removed]", 3, 2, nil},
	{3456, 9046, 4, 60, "Redemption Spaulders [Removed]", 3, 2, nil},
	{3456, 9048, 4, 60, "Redemption Handguards [Removed]", 3, 2, nil},
	{3456, 9049, 4, 60, "Redemption Girdle [Removed]", 3, 2, nil},
	{3456, 9050, 4, 60, "Redemption Wristguards [Removed]", 3, 2, nil},
	{3456, 9054, 4, 60, "Cryptstalker Tunic [Removed]", 3, 2, nil},
	{3456, 9055, 4, 60, "Cryptstalker Legguards [Removed]", 3, 2, nil},
	{3456, 9057, 4, 60, "Cryptstalker Spaulders [Removed]", 3, 2, nil},
	{3456, 9059, 4, 60, "Cryptstalker Handguards [Removed]", 3, 2, nil},
	{3456, 9060, 4, 60, "Cryptstalker Girdle [Removed]", 3, 2, nil},
	{3456, 9068, 4, 60, "Earthshatter Tunic [Removed]", 3, 2, nil},
	{3456, 9069, 4, 60, "Earthshatter Legguards [Removed]", 3, 2, nil},
	{3456, 9070, 4, 60, "Earthshatter Headpiece [Removed]", 3, 2, nil},
	{3456, 9072, 4, 60, "Earthshatter Boots [Removed]", 3, 2, nil},
	{3456, 9073, 4, 60, "Earthshatter Handguards [Removed]", 3, 2, nil},
	{3456, 9074, 4, 60, "Earthshatter Girdle [Removed]", 3, 2, nil},
	{3456, 9075, 4, 60, "Earthshatter Wristguards [Removed]", 3, 2, nil},
	{3456, 9077, 4, 60, "Bonescythe Breastplate [Removed]", 3, 2, nil},
	{3456, 9078, 4, 60, "Bonescythe Legplates [Removed]", 3, 2, nil},
	{3456, 9079, 4, 60, "Bonescythe Helmet [Removed]", 3, 2, nil},
	{3456, 9080, 4, 60, "Bonescythe Pauldrons [Removed]", 3, 2, nil},
	{3456, 9081, 4, 60, "Bonescythe Sabatons [Removed]", 3, 2, nil},
	{3456, 9082, 4, 60, "Bonescythe Gauntlets [Removed]", 3, 2, nil},
	{3456, 9091, 4, 60, "Dreamwalker Handguards [Removed]", 3, 2, nil},
	{3456, 9092, 4, 60, "Dreamwalker Girdle [Removed]", 3, 2, nil},
	{3456, 9095, 4, 60, "Frostfire Robe [Removed]", 3, 2, nil},
	{3456, 9096, 4, 60, "Frostfire Leggings [Removed]", 3, 2, nil},
	{3456, 9097, 4, 60, "Frostfire Circlet [Removed]", 3, 2, nil},
	{3456, 9098, 4, 60, "Frostfire Shoulderpads [Removed]", 3, 2, nil},
	{3456, 9099, 4, 60, "Frostfire Sandals [Removed]", 3, 2, nil},
	{3456, 9100, 4, 60, "Frostfire Gloves [Removed]", 3, 2, nil},
	{3456, 9101, 4, 60, "Frostfire Belt [Removed]", 3, 2, nil},
	{3456, 9102, 4, 60, "Frostfire Bindings [Removed]", 3, 2, nil},
	{3456, 9103, 4, 60, "Plagueheart Robe [Removed]", 3, 2, nil},
	{3456, 9104, 4, 60, "Plagueheart Leggings [Removed]", 3, 2, nil},
	{3456, 9106, 4, 60, "Plagueheart Shoulderpads [Removed]", 3, 2, nil},
	{3456, 9107, 4, 60, "Plagueheart Sandals [Removed]", 3, 2, nil},
	{3456, 9108, 4, 60, "Plagueheart Gloves [Removed]", 3, 2, nil},
	{3456, 9109, 4, 60, "Plagueheart Belt [Removed]", 3, 2, nil},
	{3456, 9111, 4, 60, "Robe of Faith [Removed]", 3, 2, nil},
	{3456, 9112, 4, 60, "Leggings of Faith [Removed]", 3, 2, nil},
	{3456, 9113, 4, 60, "Circlet of Faith [Removed]", 3, 2, nil},
	{3456, 9114, 4, 60, "Shoulderpads of Faith [Removed]", 3, 2, nil},
	{3456, 9115, 4, 60, "Sandals of Faith [Removed]", 3, 2, nil},
	{3456, 9116, 4, 60, "Gloves of Faith [Removed]", 3, 2, nil},
	{3456, 9117, 4, 60, "Belt of Faith [Removed]", 3, 2, nil},
	{3456, 9118, 4, 60, "Bindings of Faith [Removed]", 3, 2, nil},
	{3456, 9229, 1, 60, "The Fate of Ramaladni", 3, 2, nil},
	{3456, 9230, 1, 60, "Ramaladni's Icy Grasp", 3, 2, nil},
	{3456, 9232, 4, 60, "The Only Song I Know... [Removed]", 3, 2, nil},
	{3456, 9233, 4, 60, "Omarion's Handbook [Removed]", 3, 2, nil},
	{3456, 9234, 1, 60, "Icebane Gauntlets", 3, 1, "WARRIOR PALADIN"},
	{3456, 9235, 1, 60, "Icebane Bracers", 3, 1, "WARRIOR PALADIN"},
	{3456, 9236, 1, 60, "Icebane Breastplate", 3, 1, "WARRIOR PALADIN"},
	{3456, 9237, 1, 60, "Glacial Cloak", 3, 2, nil},
	{3456, 9238, 1, 60, "Glacial Wrists", 3, 1, "PRIEST MAGE WARLOCK"},
	{3456, 9239, 1, 60, "Glacial Gloves", 3, 1, "PRIEST MAGE WARLOCK"},
	{3456, 9240, 1, 60, "Glacial Vest", 3, 1, "PRIEST MAGE WARLOCK"},
	{3456, 9241, 1, 60, "Polar Bracers", 3, 1, "ROGUE DRUID"},
	{3456, 9242, 1, 60, "Polar Gloves", 3, 1, "ROGUE DRUID"},
	{3456, 9243, 1, 60, "Polar Tunic", 3, 1, "ROGUE DRUID"},
	{3456, 9244, 1, 60, "Icy Scale Bracers", 3, 1, "HUNTER SHAMAN"},
	{3456, 9245, 1, 60, "Icy Scale Gauntlets", 3, 1, "HUNTER SHAMAN"},
	{3456, 9246, 1, 60, "Icy Scale Breastplate", 3, 1, "HUNTER SHAMAN"},
	{3456, 24580, 1, 80, "Anub'Rekhan Must Die!", 3, 2, nil},
	{3456, 24581, 1, 80, "Noth the Plaguebringer Must Die!", 3, 2, nil},
	{3456, 24582, 1, 80, "Instructor Razuvious Must Die!", 3, 2, nil},
	{3456, 24583, 1, 80, "Patchwerk Must Die!", 3, 2, nil},

	{2159, 7509, 1, 60, "The Forging of Quel'Serrar", 3, 1, "WARRIOR PALADIN"},

	{3429, 8556, 1, 60, "Signet of Unyielding Strength", 3, 1, "WARRIOR"},
	{3429, 8557, 1, 60, "Drape of Unyielding Strength", 3, 1, "WARRIOR"},
	{3429, 8558, 1, 60, "Sickle of Unyielding Strength", 3, 1, "WARRIOR"},
	{3429, 8689, 1, 60, "Shroud of Infinite Wisdom", 3, 1, "PRIEST"},
	{3429, 8690, 1, 60, "Cloak of the Gathering Storm", 3, 1, "SHAMAN"},
	{3429, 8691, 1, 60, "Drape of Vaulted Secrets", 3, 1, "MAGE"},
	{3429, 8692, 1, 60, "Cloak of Unending Life", 3, 1, "DRUID"},
	{3429, 8693, 1, 60, "Cloak of Veiled Shadows", 3, 1, "ROGUE"},
	{3429, 8694, 1, 60, "Shroud of Unspoken Names", 3, 1, "WARLOCK"},
	{3429, 8695, 1, 60, "Cape of Eternal Justice", 3, 1, "PALADIN"},
	{3429, 8696, 1, 60, "Cloak of the Unseen Path", 3, 1, "HUNTER"},
	{3429, 8697, 1, 60, "Ring of Infinite Wisdom", 3, 1, "PRIEST"},
	{3429, 8698, 1, 60, "Ring of the Gathering Storm", 3, 1, "SHAMAN"},
	{3429, 8699, 1, 60, "Band of Vaulted Secrets", 3, 1, "MAGE"},
	{3429, 8700, 1, 60, "Band of Unending Life", 3, 1, "DRUID"},
	{3429, 8701, 1, 60, "Band of Veiled Shadows", 3, 1, "ROGUE"},
	{3429, 8702, 1, 60, "Ring of Unspoken Names", 3, 1, "WARLOCK"},
	{3429, 8703, 1, 60, "Ring of Eternal Justice", 3, 1, "PALADIN"},
	{3429, 8704, 1, 60, "Signet of the Unseen Path", 3, 1, "HUNTER"},
	{3429, 8705, 1, 60, "Gavel of Infinite Wisdom", 3, 1, "PRIEST"},
	{3429, 8706, 1, 60, "Hammer of the Gathering Storm", 3, 1, "SHAMAN"},
	{3429, 8707, 1, 60, "Blade of Vaulted Secrets", 3, 1, "MAGE"},
	{3429, 8708, 1, 60, "Mace of Unending Life", 3, 1, "DRUID"},
	{3429, 8709, 1, 60, "Dagger of Veiled Shadows", 3, 1, "ROGUE"},
	{3429, 8710, 1, 60, "Kris of Unspoken Names", 3, 1, "WARLOCK"},
	{3429, 8711, 1, 60, "Blade of Eternal Justice", 3, 1, "PALADIN"},
	{3429, 8712, 1, 60, "Scythe of the Unseen Path", 3, 1, "HUNTER"},
	{3429, 8791, 1, 60, "The Fall of Ossirian", 3, 2, nil},

	{4075, 24797, 4, 80, "REUSE", 4, 2, nil},
	{4075, 24553, 1, 80, "The Purification of Quel'Delar", 1, 2, nil},
	{4075, 24595, 1, 80, "The Purification of Quel'Delar", 1, 1, "PRIEST SHAMAN DRUID"},
	{4075, 24564, 1, 80, "The Purification of Quel'Delar", 2, 2, nil},
	{4075, 24594, 1, 80, "The Purification of Quel'Delar", 2, 2, nil},
	{4075, 24596, 1, 80, "The Purification of Quel'Delar", 2, 1, "PRIEST"},
	{4075, 24598, 1, 80, "The Purification of Quel'Delar", 2, 1, "PRIEST SHAMAN DRUID"},

	{3842, 10946, 1, 70, "Ruse of the Ashtongue", 3, 2, nil},
	{3842, 11007, 1, 70, "Kael'thas and the Verdant Sphere", 3, 2, nil},

	{3428, 8544, 1, 60, "Conqueror's Spaulders", 3, 1, "WARRIOR"},
	{3428, 8559, 1, 60, "Conqueror's Greaves", 3, 1, "WARRIOR"},
	{3428, 8560, 1, 60, "Conqueror's Legguards", 3, 1, "WARRIOR"},
	{3428, 8561, 1, 60, "Conqueror's Crown", 3, 1, "WARRIOR"},
	{3428, 8562, 1, 60, "Conqueror's Breastplate", 3, 1, "WARRIOR"},
	{3428, 8579, 1, 60, "Mortal Champions", 3, 2, nil},
	{3428, 8592, 1, 60, "Tiara of the Oracle", 3, 1, "PRIEST"},
	{3428, 8593, 1, 60, "Trousers of the Oracle", 3, 1, "PRIEST"},
	{3428, 8594, 1, 60, "Mantle of the Oracle", 3, 1, "PRIEST"},
	{3428, 8595, 2, 60, "Mortal Champions", 3, 2, nil},
	{3428, 8596, 1, 60, "Footwraps of the Oracle", 3, 1, "PRIEST"},
	{3428, 8602, 1, 60, "Stormcaller's Pauldrons", 3, 1, "SHAMAN"},
	{3428, 8603, 1, 60, "Vestments of the Oracle", 3, 1, "PRIEST"},
	{3428, 8621, 1, 60, "Stormcaller's Footguards", 3, 1, "SHAMAN"},
	{3428, 8622, 1, 60, "Stormcaller's Hauberk", 3, 1, "SHAMAN"},
	{3428, 8623, 1, 60, "Stormcaller's Diadem", 3, 1, "SHAMAN"},
	{3428, 8624, 1, 60, "Stormcaller's Leggings", 3, 1, "SHAMAN"},
	{3428, 8625, 1, 60, "Enigma Shoulderpads", 3, 1, "MAGE"},
	{3428, 8626, 1, 60, "Striker's Footguards", 3, 1, "HUNTER"},
	{3428, 8627, 1, 60, "Avenger's Breastplate", 3, 1, "PALADIN"},
	{3428, 8628, 1, 60, "Avenger's Crown", 3, 1, "PALADIN"},
	{3428, 8629, 1, 60, "Avenger's Legguards", 3, 1, "PALADIN"},
	{3428, 8630, 1, 60, "Avenger's Pauldrons", 3, 1, "PALADIN"},
	{3428, 8631, 1, 60, "Enigma Leggings", 3, 1, "MAGE"},
	{3428, 8632, 1, 60, "Enigma Circlet", 3, 1, "MAGE"},
	{3428, 8633, 1, 60, "Enigma Robes", 3, 1, "MAGE"},
	{3428, 8634, 1, 60, "Enigma Boots", 3, 1, "MAGE"},
	{3428, 8637, 1, 60, "Deathdealer's Boots", 3, 1, "ROGUE"},
	{3428, 8638, 1, 60, "Deathdealer's Vest", 3, 1, "ROGUE"},
	{3428, 8639, 1, 60, "Deathdealer's Helm", 3, 1, "ROGUE"},
	{3428, 8640, 1, 60, "Deathdealer's Leggings", 3, 1, "ROGUE"},
	{3428, 8641, 1, 60, "Deathdealer's Spaulders", 3, 1, "ROGUE"},
	{3428, 8655, 1, 60, "Avenger's Greaves", 3, 1, "PALADIN"},
	{3428, 8656, 1, 60, "Striker's Hauberk", 3, 1, "HUNTER"},
	{3428, 8657, 1, 60, "Striker's Diadem", 3, 1, "HUNTER"},
	{3428, 8658, 1, 60, "Striker's Leggings", 3, 1, "HUNTER"},
	{3428, 8659, 1, 60, "Striker's Pauldrons", 3, 1, "HUNTER"},
	{3428, 8660, 1, 60, "Doomcaller's Footwraps", 3, 1, "WARLOCK"},
	{3428, 8661, 1, 60, "Doomcaller's Robes", 3, 1, "WARLOCK"},
	{3428, 8662, 1, 60, "Doomcaller's Circlet", 3, 1, "WARLOCK"},
	{3428, 8663, 1, 60, "Doomcaller's Trousers", 3, 1, "WARLOCK"},
	{3428, 8664, 1, 60, "Doomcaller's Mantle", 3, 1, "WARLOCK"},
	{3428, 8665, 1, 60, "Genesis Boots", 3, 1, "DRUID"},
	{3428, 8666, 1, 60, "Genesis Vest", 3, 1, "DRUID"},
	{3428, 8667, 1, 60, "Genesis Helm", 3, 1, "DRUID"},
	{3428, 8668, 1, 60, "Genesis Trousers", 3, 1, "DRUID"},
	{3428, 8669, 1, 60, "Genesis Shoulderpads", 3, 1, "DRUID"},
	{3428, 8784, 1, 60, "Secrets of the Qiraji", 3, 2, nil},
	{3428, 8789, 1, 60, "Imperial Qiraji Armaments", 3, 2, nil},
	{3428, 8790, 1, 60, "Imperial Qiraji Regalia", 3, 2, nil},
	{3428, 8801, 1, 60, "C'Thun's Legacy", 3, 2, nil},
	{3428, 8802, 1, 60, "The Savior of Kalimdor", 3, 2, nil},

	{4500, 13384, 1, 80, "Judgment at the Eye of Eternity", 3, 2, nil},
	{4500, 13385, 1, 80, "Heroic Judgment at the Eye of Eternity", 3, 2, nil},
	{4500, 24584, 1, 80, "Malygos Must Die!", 3, 2, nil},

	{4493, 24579, 1, 80, "Sartharion Must Die!", 3, 2, nil},

	{4987, 26012, 1, 82, "Trouble at Wyrmrest", 3, 2, nil},
	{4987, 26013, 1, 82, "Assault on the Sanctum", 3, 2, nil},
	{4987, 26034, 1, 82, "The Twilight Destroyer", 3, 2, nil},

	{4722, 24589, 1, 80, "Lord Jaraxxus Must Die!", 3, 2, nil},

	{4273, 13604, 1, 80, "Archivum Data Disc", 3, 2, nil},
	{4273, 13606, 1, 80, "Freya's Sigil", 3, 2, nil},
	{4273, 13607, 1, 80, "The Celestial Planetarium", 3, 2, nil},
	{4273, 13609, 1, 80, "Hodir's Sigil", 3, 2, nil},
	{4273, 13610, 1, 80, "Thorim's Sigil", 3, 2, nil},
	{4273, 13611, 1, 80, "Mimiron's Sigil", 3, 2, nil},
	{4273, 13614, 1, 80, "Algalon", 3, 2, nil},
	{4273, 13622, 1, 80, "Ancient History", 3, 2, nil},
	{4273, 13629, 1, 80, "Val'anyr, Hammer of Ancient Kings", 3, 2, nil},
	{4273, 13631, 1, 80, "All Is Well That Ends Well", 3, 2, nil},
	{4273, 13816, 1, 80, "Heroic: The Celestial Planetarium", 3, 2, nil},
	{4273, 13817, 1, 80, "Heroic: Archivum Data Disc", 3, 2, nil},
	{4273, 13818, 1, 80, "Heroic: Algalon", 3, 2, nil},
	{4273, 13819, 1, 80, "Heroic: All Is Well That Ends Well", 3, 2, nil},
	{4273, 13821, 1, 80, "Heroic: Freya's Sigil", 3, 2, nil},
	{4273, 13822, 1, 80, "Heroic: Hodir's Sigil", 3, 2, nil},
	{4273, 13823, 1, 80, "Heroic: Thorim's Sigil", 3, 2, nil},
	{4273, 13824, 1, 80, "Heroic: Mimiron's Sigil", 3, 2, nil},
	{4273, 24585, 1, 80, "Flame Leviathan Must Die!", 3, 2, nil},
	{4273, 24586, 1, 80, "Razorscale Must Die!", 3, 2, nil},
	{4273, 24587, 1, 80, "Ignis the Furnace Master Must Die!", 3, 2, nil},
	{4273, 24588, 1, 80, "XT-002 Deconstructor Must Die!", 3, 2, nil},

	{3805, 11130, 1, 70, "Oooh, Shinies!", 3, 2, nil},
	{3805, 11132, 1, 70, "Promises, Promises...", 3, 2, nil},
	{3805, 11163, 1, 70, "Undercover Sister", 3, 2, nil},
	{3805, 11164, 1, 70, "Tuskin' Raiders", 3, 2, nil},
	{3805, 11165, 1, 70, "A Troll Among Trolls", 3, 2, nil},
	{3805, 11166, 1, 70, "X Marks... Your Doom!", 3, 2, nil},
	{3805, 11171, 1, 70, "Hex Lord? Hah!", 3, 2, nil},
	{3805, 11178, 1, 70, "Blood of the Warlord", 3, 2, nil},
	{3805, 11195, 1, 70, "Playin' With Dolls", 3, 2, nil},

	{1977, 8148, 1, 60, "Maelstrom's Wrath", 1, 1, "HUNTER"},
	{1977, 8041, 1, 60, "Strength of Mount Mugamba", 3, 1, "WARRIOR"},
	{1977, 8042, 1, 60, "Strength of Mount Mugamba", 3, 1, "WARRIOR"},
	{1977, 8043, 1, 60, "Strength of Mount Mugamba", 3, 1, "WARRIOR"},
	{1977, 8044, 1, 60, "The Rage of Mugamba", 3, 1, "WARRIOR"},
	{1977, 8045, 1, 60, "The Heathen's Brand", 3, 1, "PALADIN"},
	{1977, 8046, 1, 60, "The Heathen's Brand", 3, 1, "PALADIN"},
	{1977, 8047, 1, 60, "The Heathen's Brand", 3, 1, "PALADIN"},
	{1977, 8048, 1, 60, "The Hero's Brand", 3, 1, "PALADIN"},
	{1977, 8049, 1, 60, "The Eye of Zuldazar", 3, 1, "PRIEST"},
	{1977, 8050, 1, 60, "The Eye of Zuldazar", 3, 1, "PRIEST"},
	{1977, 8051, 1, 60, "The Eye of Zuldazar", 3, 1, "PRIEST"},
	{1977, 8052, 1, 60, "The All-Seeing Eye of Zuldazar", 3, 1, "PRIEST"},
	{1977, 8053, 1, 60, "Paragons of Power: The Freethinker's Armguards", 3, 1, "PALADIN"},
	{1977, 8054, 1, 60, "Paragons of Power: The Freethinker's Belt", 3, 1, "PALADIN"},
	{1977, 8055, 1, 60, "Paragons of Power: The Freethinker's Breastplate", 3, 1, "PALADIN"},
	{1977, 8056, 1, 60, "Paragons of Power: The Augur's Bracers", 3, 1, "PRIEST SHAMAN"},
	{1977, 8057, 1, 60, "Paragons of Power: The Haruspex's Bracers", 3, 1, "DRUID"},
	{1977, 8058, 1, 60, "Paragons of Power: The Vindicator's Armguards", 3, 1, "WARRIOR"},
	{1977, 8059, 1, 60, "Paragons of Power: The Demoniac's Wraps", 3, 1, "WARLOCK"},
	{1977, 8060, 1, 60, "Paragons of Power: The Illusionist's Wraps", 3, 1, "MAGE"},
	{1977, 8061, 1, 60, "Paragons of Power: The Confessor's Wraps", 3, 1, "PRIEST"},
	{1977, 8062, 1, 60, "Paragons of Power: The Predator's Bracers", 3, 1, "HUNTER"},
	{1977, 8063, 1, 60, "Paragons of Power: The Madcap's Bracers", 3, 1, "ROGUE"},
	{1977, 8064, 1, 60, "Paragons of Power: The Haruspex's Belt", 3, 1, "DRUID"},
	{1977, 8065, 1, 60, "Paragons of Power: The Haruspex's Tunic", 3, 1, "DRUID"},
	{1977, 8066, 1, 60, "Paragons of Power: The Predator's Belt", 3, 1, "HUNTER"},
	{1977, 8067, 1, 60, "Paragons of Power: The Predator's Mantle", 3, 1, "HUNTER"},
	{1977, 8068, 1, 60, "Paragons of Power: The Illusionist's Mantle", 3, 1, "MAGE"},
	{1977, 8069, 1, 60, "Paragons of Power: The Illusionist's Robes", 3, 1, "MAGE"},
	{1977, 8070, 1, 60, "Paragons of Power: The Confessor's Bindings", 3, 1, "PRIEST"},
	{1977, 8071, 1, 60, "Paragons of Power: The Confessor's Mantle", 3, 1, "PRIEST"},
	{1977, 8072, 1, 60, "Paragons of Power: The Madcap's Mantle", 3, 1, "ROGUE"},
	{1977, 8073, 1, 60, "Paragons of Power: The Madcap's Tunic", 3, 1, "ROGUE"},
	{1977, 8074, 1, 60, "Paragons of Power: The Augur's Belt", 3, 1, "PRIEST SHAMAN"},
	{1977, 8075, 1, 60, "Paragons of Power: The Augur's Hauberk", 3, 1, "PRIEST SHAMAN"},
	{1977, 8076, 1, 60, "Paragons of Power: The Demoniac's Mantle", 3, 1, "WARLOCK"},
	{1977, 8077, 1, 60, "Paragons of Power: The Demoniac's Robes", 3, 1, "WARLOCK"},
	{1977, 8078, 1, 60, "Paragons of Power: The Vindicator's Belt", 3, 1, "WARRIOR"},
	{1977, 8079, 1, 60, "Paragons of Power: The Vindicator's Breastplate", 3, 1, "WARRIOR"},
	{1977, 8101, 1, 60, "The Pebble of Kajaro", 3, 1, "MAGE"},
	{1977, 8102, 1, 60, "The Pebble of Kajaro", 3, 1, "MAGE"},
	{1977, 8103, 1, 60, "The Pebble of Kajaro", 3, 1, "MAGE"},
	{1977, 8104, 1, 60, "The Jewel of Kajaro", 3, 1, "MAGE"},
	{1977, 8106, 1, 60, "Kezan's Taint", 3, 1, "WARLOCK"},
	{1977, 8107, 1, 60, "Kezan's Taint", 3, 1, "WARLOCK"},
	{1977, 8108, 1, 60, "Kezan's Taint", 3, 1, "WARLOCK"},
	{1977, 8109, 1, 60, "Kezan's Unstoppable Taint", 3, 1, "WARLOCK"},
	{1977, 8110, 1, 60, "Enchanted South Seas Kelp", 3, 1, "DRUID"},
	{1977, 8111, 1, 60, "Enchanted South Seas Kelp", 3, 1, "DRUID"},
	{1977, 8112, 1, 60, "Enchanted South Seas Kelp", 3, 1, "DRUID"},
	{1977, 8113, 1, 60, "Pristine Enchanted South Seas Kelp", 3, 1, "DRUID"},
	{1977, 8116, 1, 60, "Vision of Voodress", 3, 1, "SHAMAN"},
	{1977, 8117, 1, 60, "Vision of Voodress", 3, 1, "SHAMAN"},
	{1977, 8118, 1, 60, "Vision of Voodress", 3, 1, "SHAMAN"},
	{1977, 8119, 1, 60, "The Unmarred Vision of Voodress", 3, 1, "SHAMAN"},
	{1977, 8141, 1, 60, "Zandalarian Shadow Talisman", 3, 1, "ROGUE"},
	{1977, 8142, 1, 60, "Zandalarian Shadow Talisman", 3, 1, "ROGUE"},
	{1977, 8143, 1, 60, "Zandalarian Shadow Talisman", 3, 1, "ROGUE"},
	{1977, 8144, 1, 60, "Zandalarian Shadow Mastery Talisman", 3, 1, "ROGUE"},
	{1977, 8145, 1, 60, "The Maelstrom's Tendril", 3, 1, "HUNTER"},
	{1977, 8146, 1, 60, "The Maelstrom's Tendril", 3, 1, "HUNTER"},
	{1977, 8147, 1, 60, "The Maelstrom's Tendril", 3, 1, "HUNTER"},
	{1977, 8183, 1, 60, "The Heart of Hakkar", 3, 2, nil},
	{1977, 8184, 2, 60, "Presence of Might", 3, 1, "WARRIOR"},
	{1977, 8185, 2, 60, "Syncretist's Sigil", 3, 1, "PALADIN"},
	{1977, 8186, 2, 60, "Death's Embrace", 3, 1, "ROGUE"},
	{1977, 8187, 2, 60, "Falcon's Call", 3, 1, "HUNTER"},
	{1977, 8188, 2, 60, "Vodouisant's Vigilant Embrace", 3, 1, "SHAMAN"},
	{1977, 8189, 2, 60, "Presence of Sight", 3, 1, "MAGE"},
	{1977, 8190, 2, 60, "Hoodoo Hex", 3, 1, "WARLOCK"},
	{1977, 8191, 2, 60, "Prophetic Aura", 3, 1, "PRIEST"},
	{1977, 8192, 2, 60, "Animist's Caress", 3, 1, "DRUID"},
	{1977, 8195, 2, 60, "Zulian, Razzashi, and Hakkari Coins", 3, 2, nil},
	{1977, 8196, 2, 60, "Essence Mangoes", 3, 2, nil},
	{1977, 8201, 1, 60, "A Collection of Heads", 3, 2, nil},
	{1977, 8227, 1, 60, "Nat's Measuring Tape", 3, 2, nil},
	{1977, 8238, 2, 60, "Gurubashi, Vilebranch, and Witherbark Coins", 3, 2, nil},
	{1977, 8239, 2, 60, "Sandfury, Skullsplitter, and Bloodscalp Coins", 3, 2, nil},
	{1977, 8240, 1, 60, "A Bijou for Zanza", 3, 2, nil},
	{1977, 8243, 2, 60, "Zanza's Potent Potables", 3, 2, nil},
	{1977, 8246, 2, 60, "Signets of the Zandalar", 3, 2, nil},
	{1977, 9208, 1, 60, "The Savage Guard - Arcanum of Protection", 3, 2, nil},
	{1977, 9209, 1, 60, "The Savage Guard - Arcanum of Rapidity", 3, 2, nil},
	{1977, 9210, 1, 60, "The Savage Guard - Arcanum of Focus", 3, 2, nil},

}